/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class VirtuosoDate
extends Date {
    int timezone = 0;
    boolean with_timezone = false;

    public VirtuosoDate(long date) {
        super(date);
    }

    public VirtuosoDate(long date, int tz) {
        super(date);
        this.timezone = tz;
        this.with_timezone = true;
    }

    public VirtuosoDate(long date, int tz, boolean with_tz) {
        super(date);
        this.timezone = tz;
        this.with_timezone = with_tz;
    }

    public boolean withTimezone() {
        return this.with_timezone;
    }

    public int getTimezone() {
        return this.timezone;
    }

    @Override
    public VirtuosoDate clone() {
        return new VirtuosoDate(this.getTime(), this.timezone, this.with_timezone);
    }

    public String toXSD_String() {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String timeZoneString = null;
        if (this.with_timezone) {
            StringBuffer s = new StringBuffer();
            s.append(this.timezone > 0 ? (char)'+' : '-');
            int tz = Math.abs(this.timezone);
            int tzh = tz / 60;
            int tzm = tz % 60;
            if (tzh < 10) {
                s.append('0');
            }
            s.append(tzh);
            s.append(':');
            if (tzm < 10) {
                s.append('0');
            }
            s.append(tzm);
            timeZoneString = s.toString();
            formatter.setTimeZone(TimeZone.getTimeZone("GMT" + timeZoneString));
        }
        sb.append(formatter.format(this));
        return sb.toString();
    }
}

