/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import virtuoso.jdbc4.ConnectionWrapper;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoConnectionPoolDataSource;
import virtuoso.jdbc4.VirtuosoException;

public class VirtuosoPooledConnection
implements PooledConnection,
Cloneable {
    private LinkedList<ConnectionEventListener> listeners = null;
    private ConnectionWrapper connWrapper = null;
    private VirtuosoConnection conn;
    private boolean sendEvent = true;
    protected String connURL;
    protected int hashConnURL;
    protected long tmClosed;

    protected VirtuosoPooledConnection(VirtuosoConnection _conn, String _connURL) {
        this.conn = _conn;
        this.conn.pooled_connection = this;
        this.connURL = _connURL;
        this.hashConnURL = this.connURL.hashCode();
        this.tmClosed = System.currentTimeMillis();
    }

    protected VirtuosoPooledConnection(VirtuosoConnection _conn, String _connURL, VirtuosoConnectionPoolDataSource listener) {
        this(_conn, _connURL);
        this.init(listener);
    }

    protected void init(VirtuosoConnectionPoolDataSource listener) {
        this.listeners = new LinkedList();
        this.addConnectionEventListener(listener);
        this.conn.pooled_connection = this;
    }

    public synchronized void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listeners.clear();
    }

    protected synchronized Object clone() {
        try {
            VirtuosoPooledConnection v = (VirtuosoPooledConnection)super.clone();
            v.listeners = null;
            v.connWrapper = null;
            v.conn = this.conn;
            v.sendEvent = true;
            v.connURL = this.connURL;
            v.hashConnURL = this.hashConnURL;
            v.tmClosed = this.tmClosed;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected VirtuosoPooledConnection reuse() {
        this.connWrapper.reset();
        VirtuosoPooledConnection pconn = (VirtuosoPooledConnection)this.clone();
        this.listeners.clear();
        this.connWrapper = null;
        this.conn.pooled_connection = null;
        this.conn.xa_connection = null;
        this.conn = null;
        this.connURL = null;
        pconn.tmClosed = System.currentTimeMillis();
        pconn.conn.pooled_connection = pconn;
        pconn.conn.clearFutures();
        return pconn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionEventListener(ConnectionEventListener parm) {
        LinkedList<ConnectionEventListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(parm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionEventListener(ConnectionEventListener parm) {
        LinkedList<ConnectionEventListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(parm);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        SQLException ex = null;
        if (this.connWrapper != null) {
            try {
                this.connWrapper.closeAll();
            }
            catch (SQLException e) {
                ex = e;
            }
            this.connWrapper = null;
        }
        if (this.conn != null) {
            if (!this.conn.isClosed()) {
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    ex = e;
                }
            }
            this.conn.pooled_connection = null;
            this.conn.xa_connection = null;
        }
        this.conn = null;
        this.sendErrorEvent(new VirtuosoException("Physical Connection is closed", 0));
        if (ex != null) {
            throw ex;
        }
    }

    @Deprecated
    public void closeAll() throws SQLException {
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.conn == null) {
            VirtuosoException ex = new VirtuosoException("Physical Connection is closed", 0);
            this.sendErrorEvent(ex);
            throw ex;
        }
        if (this.connWrapper != null) {
            this.sendEvent = false;
            this.connWrapper.reset();
            this.connWrapper.close();
            this.sendEvent = true;
        }
        this.connWrapper = new ConnectionWrapper(this.conn, this);
        return this.connWrapper;
    }

    public VirtuosoConnection getVirtuosoConnection() throws SQLException {
        if (this.conn == null) {
            VirtuosoException ex = new VirtuosoException("Connection is closed", 0);
            this.sendErrorEvent(ex);
            throw ex;
        }
        return this.conn;
    }

    public boolean isConnectionLost(int timeout_sec) {
        if (this.conn == null) {
            return true;
        }
        return this.conn.isClosed() || this.conn.isConnectionLost(timeout_sec);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
    }

    protected boolean isClosed() {
        return this.conn == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCloseEvent() {
        LinkedList tmpList;
        if (!this.sendEvent) {
            return;
        }
        if (this.listeners == null) {
            return;
        }
        ConnectionEvent ev = new ConnectionEvent(this);
        LinkedList<ConnectionEventListener> linkedList = this.listeners;
        synchronized (linkedList) {
            tmpList = (LinkedList)this.listeners.clone();
        }
        Iterator i = tmpList.iterator();
        while (i.hasNext()) {
            ((ConnectionEventListener)i.next()).connectionClosed(ev);
        }
        tmpList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendErrorEvent(SQLException ex) {
        LinkedList tmpList;
        if (this.listeners == null) {
            return;
        }
        ConnectionEvent ev = new ConnectionEvent(this, ex);
        LinkedList<ConnectionEventListener> linkedList = this.listeners;
        synchronized (linkedList) {
            tmpList = (LinkedList)this.listeners.clone();
        }
        Iterator i = tmpList.iterator();
        while (i.hasNext()) {
            ((ConnectionEventListener)i.next()).connectionErrorOccurred(ev);
        }
        tmpList.clear();
    }
}

