/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import javax.transaction.xa.XAException;
import virtuoso.jdbc4.VirtuosoFuture;
import virtuoso.jdbc4.VirtuosoXid;

class XATransaction {
    static final int ACTIVE = 1;
    static final int IDLE = 2;
    static final int PREPARED = 3;
    static final int COMMITTED = 4;
    static final int ROLLEDBACK = 5;
    static final int ROLLBACKONLY = 6;
    private VirtuosoXid xid;
    private int status;

    XATransaction(VirtuosoXid xid, int status) {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("new VirtuosoXATransaction (xid=" + xid.hashCode() + ", status=" + status + ") :" + this.hashCode());
        }
        this.xid = xid;
        this.status = status;
    }

    VirtuosoXid getXid() {
        return this.xid;
    }

    int getStatus() {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXATransaction.getStatus () ret=" + this.status + " :" + this.hashCode() + ")");
        }
        return this.status;
    }

    void setStatus(int status) {
        this.status = status;
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXATransaction.setStatus (status=" + status + ") :" + this.hashCode() + ")");
        }
    }

    void changeStatus(int nstatus) throws XAException {
        this.changeStatus(nstatus, false);
    }

    void changeStatus(int nstatus, boolean onePhase) throws XAException {
        this.checkNewStatus(nstatus, onePhase);
        this.status = nstatus;
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXATransaction.changeStatus (nstatus=" + nstatus + ") :" + this.hashCode() + ")");
        }
    }

    void checkNewStatus(int nstatus) throws XAException {
        this.checkNewStatus(nstatus, false);
    }

    void checkNewStatus(int nstatus, boolean onePhase) throws XAException {
        if (this.status == 1 && nstatus != 2 && nstatus != 1 && nstatus != 6) {
            throw this.createException(nstatus);
        }
        if (!(this.status != 2 || nstatus == 3 || nstatus == 5 || nstatus == 4 && onePhase)) {
            throw this.createException(nstatus);
        }
        if (this.status == 3 && nstatus != 4 && nstatus != 5) {
            throw this.createException(nstatus);
        }
        if (this.status == 6 && nstatus != 5 && nstatus != 3) {
            throw this.createException(nstatus);
        }
        if (this.status == 4 || this.status == 5) {
            throw this.createException(nstatus);
        }
    }

    private String getName(int _status) {
        switch (_status) {
            case 1: {
                return "ACTIVE";
            }
            case 2: {
                return "IDLE";
            }
            case 3: {
                return "PREPARED";
            }
            case 4: {
                return "COMMITED";
            }
            case 5: {
                return "ROLLEDBACK";
            }
            case 6: {
                return "ROLLBACKONLY";
            }
        }
        return "UNKNOWN";
    }

    private XAException createException(int nstatus) {
        XAException ex = new XAException("Can't change transaction state from " + this.getName(this.status) + " to " + this.getName(nstatus));
        ex.errorCode = -7;
        return ex;
    }
}

