/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import virtuoso.jdbc4.VirtuosoExplicitString;

public class VirtuosoXid
implements Xid {
    private int formatId;
    private byte[] globalId;
    private byte[] branchId;
    private static final byte[] encodeTable;
    private static final byte[] decodeTable;

    public VirtuosoXid(Xid xid) throws XAException {
        this(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    public VirtuosoXid(int formatId, byte[] globalId, byte[] branchId) throws XAException {
        this.formatId = formatId;
        this.globalId = this.copyId(globalId);
        this.branchId = this.copyId(branchId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Xid) {
            Xid xid = (Xid)obj;
            if (this.formatId != xid.getFormatId()) {
                return false;
            }
            if (!this.equalIds(this.globalId, xid.getGlobalTransactionId())) {
                return false;
            }
            return this.equalIds(this.branchId, xid.getBranchQualifier());
        }
        return false;
    }

    public int hashCode() {
        return this.formatId + this.hashId(this.globalId) + this.hashId(this.branchId);
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalId == null ? null : (byte[])this.globalId.clone();
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchId == null ? null : (byte[])this.branchId.clone();
    }

    VirtuosoExplicitString encode() {
        byte[] bytes = new byte[280];
        VirtuosoXid.encode(this.formatId, bytes, 0);
        VirtuosoXid.encode(this.globalId.length, bytes, 8);
        VirtuosoXid.encode(this.branchId.length, bytes, 16);
        VirtuosoXid.encode(this.globalId, bytes, 24);
        VirtuosoXid.encode(this.branchId, bytes, 24 + this.globalId.length * 2);
        for (int i = 24 + (this.globalId.length + this.branchId.length) * 2; i < 280; ++i) {
            bytes[i] = 48;
        }
        return new VirtuosoExplicitString(bytes, 182);
    }

    static VirtuosoXid decode(String data) throws XAException {
        int fId = VirtuosoXid.decode(data, 0);
        int gIdLength = VirtuosoXid.decode(data, 8);
        if (gIdLength > 64) {
            throw new XAException(-3);
        }
        int bIdLength = VirtuosoXid.decode(data, 16);
        if (bIdLength > 64) {
            throw new XAException(-3);
        }
        byte[] gId = VirtuosoXid.decode(data, 24, gIdLength);
        byte[] bId = VirtuosoXid.decode(data, 24 + gIdLength * 2, bIdLength);
        return new VirtuosoXid(fId, gId, bId);
    }

    private byte[] copyId(byte[] id) throws XAException {
        if (id == null) {
            return null;
        }
        if (id.length > 64) {
            throw new XAException(-4);
        }
        return (byte[])id.clone();
    }

    private boolean equalIds(byte[] a, byte[] b) {
        if (a == b || a == null && b.length == 0 || b == null && a.length == 0) {
            return true;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private int hashId(byte[] a) {
        int hash = 0;
        if (a != null) {
            for (int i = 0; i < a.length; ++i) {
                hash = hash * 17 + a[i];
            }
        }
        return hash;
    }

    private static void encode(int n, byte[] bytes, int offset) {
        byte[] data = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        VirtuosoXid.encode(data, bytes, offset);
    }

    private static void encode(byte[] data, byte[] bytes, int offset) {
        for (int i = 0; i < data.length; ++i) {
            byte b = data[i];
            bytes[offset++] = encodeTable[b >> 4 & 0xF];
            bytes[offset++] = encodeTable[b & 0xF];
        }
    }

    private static int decode(String data, int offset) {
        byte[] bytes = VirtuosoXid.decode(data, offset, 4);
        int n = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
        return n;
    }

    private static byte[] decode(String data, int offset, int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(decodeTable[data.charAt(offset)] << 4 | decodeTable[data.charAt(offset + 1)]);
            offset += 2;
        }
        return bytes;
    }

    public String toString() {
        int i;
        StringBuffer s = new StringBuffer("formatId:" + this.formatId);
        s.append("globalId length:" + this.globalId.length);
        s.append(":");
        for (i = 0; i < this.globalId.length; ++i) {
            s.append(" " + this.globalId[i]);
        }
        s.append(" branchId length:" + this.branchId.length);
        s.append(":");
        for (i = 0; i < this.branchId.length; ++i) {
            s.append(" " + this.branchId[i]);
        }
        s.append("\n");
        s.append("encoded:" + this.encode().toString());
        return s.toString();
    }

    private void print() {
        System.out.println("formatId: " + this.formatId);
        this.print("globalId", this.globalId);
        this.print("branchId", this.branchId);
    }

    private void print(String name, byte[] bytes) {
        System.out.println(name + " length: " + bytes.length);
        System.out.print(name + ":");
        for (int i = 0; i < bytes.length; ++i) {
            System.out.print(" " + bytes[i]);
        }
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        byte[] gid = new byte[64];
        byte[] bid = new byte[64];
        for (int i = 0; i < 64; ++i) {
            gid[i] = (byte)(256.0 * Math.random());
            bid[i] = (byte)(256.0 * Math.random());
        }
        VirtuosoXid xid = new VirtuosoXid(0, gid, bid);
        System.out.println("encode str=" + xid.encode());
        VirtuosoXid xid2 = VirtuosoXid.decode(xid.encode().toString());
        if (xid.equals(xid2)) {
            System.out.println("passed");
        } else {
            System.out.println("failed");
        }
        xid.print();
        xid2.print();
    }

    static {
        int i;
        encodeTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        decodeTable = new byte[256];
        for (i = 0; i < 256; ++i) {
            VirtuosoXid.decodeTable[i] = -1;
        }
        for (i = 0; i < encodeTable.length; ++i) {
            VirtuosoXid.decodeTable[VirtuosoXid.encodeTable[i]] = (byte)i;
        }
    }
}

