/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIteratorBase;
import org.apache.jena.sparql.engine.main.QueryEngineMain;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Utils;
import virtuoso.jena.driver.VirtDataset;
import virtuoso.jena.driver.VirtGraph;

public class VirtuosoQueryEngine
extends QueryEngineMain {
    protected Query eQuery = null;
    static QueryEngineFactory factory = new VirtQueryEngineFactory();

    public VirtuosoQueryEngine(Query query, DatasetGraph dataset, Binding initial, Context context) {
        super(query, dataset, initial, context);
        this.eQuery = query;
    }

    public VirtuosoQueryEngine(Query query, DatasetGraph dataset) {
        this(query, dataset, null, null);
    }

    public QueryIterator eval(Op op, DatasetGraph dsg, Binding initial, Context context) {
        VirtTransform transform = new VirtTransform();
        op = Transformer.transform((Transform)transform, (Op)op);
        VirtGraph vg = (VirtGraph)dsg.getDefaultGraph();
        String query = this.fixQuery(this.eQuery.toString(), initial, vg);
        try {
            Statement stmt = vg.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            return new VQueryIterator(vg, stmt, rs);
        }
        catch (Exception e) {
            throw new JenaException("Can not create QueryIterator.:" + e);
        }
    }

    private String substBindings(String query, Binding args) {
        if (args == null) {
            return query;
        }
        VirtGraph vg = (VirtGraph)this.dataset.getDefaultGraph();
        StringBuilder buf = new StringBuilder();
        String delim = " ,)(;.";
        int i = 0;
        int qlen = query.length();
        block0: while (i < qlen) {
            char ch;
            if ((ch = query.charAt(i++)) == '\\') {
                buf.append(ch);
                if (i >= qlen) continue;
                buf.append(query.charAt(i++));
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                char end = ch;
                buf.append(ch);
                while (i < qlen) {
                    ch = query.charAt(i++);
                    buf.append(ch);
                    if (ch != end) continue;
                    continue block0;
                }
                continue;
            }
            if (ch == '?') {
                String varName;
                Node val;
                int j;
                String varData = null;
                for (j = i; j < qlen && delim.indexOf(query.charAt(j)) < 0; ++j) {
                }
                if (j != i && (val = args.get(Var.alloc((String)(varName = query.substring(i, j))))) != null) {
                    varData = vg.Node2Str(val);
                    i = j;
                }
                if (varData != null) {
                    buf.append(varData);
                    continue;
                }
                buf.append(ch);
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    private String fixQuery(String query, Binding args, VirtGraph vg) {
        StringBuilder sb = new StringBuilder("sparql\n ");
        vg.appendSparqlPrefixes(sb);
        if (!vg.getReadFromAllGraphs()) {
            sb.append(" define input:default-graph-uri <" + vg.getGraphName() + "> \n");
        }
        sb.append(this.substBindings(query, args));
        return sb.toString();
    }

    protected Op modifyOp(Op op) {
        op = super.modifyOp(op);
        return op;
    }

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory((QueryEngineFactory)factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory((QueryEngineFactory)factory);
    }

    protected class VQueryIterator
    extends QueryIteratorBase {
        ResultSetMetaData rsmd;
        ResultSet rs;
        Statement stmt;
        VirtGraph vg;
        boolean v_finished = false;
        boolean v_prefetched = false;
        BindingMap v_row;
        String virt_graph = null;

        protected VQueryIterator(VirtGraph _g, Statement _stmt, ResultSet _rs) {
            this.stmt = _stmt;
            this.rs = _rs;
            this.vg = _g;
            this.virt_graph = this.vg.getGraphName();
            try {
                this.rsmd = this.rs.getMetaData();
            }
            catch (Exception e) {
                throw new JenaException("VQueryIterator is FAILED.:" + e);
            }
        }

        public void output(IndentedWriter out, SerializationContext sCxt) {
            out.print(Utils.className((Object)((Object)this)));
        }

        protected boolean hasNextBinding() {
            if (!this.v_finished && !this.v_prefetched) {
                this.moveForward();
            }
            return !this.v_finished;
        }

        protected Binding moveToNextBinding() {
            if (!this.v_finished && !this.v_prefetched) {
                this.moveForward();
            }
            this.v_prefetched = false;
            if (this.v_finished) {
                return null;
            }
            return this.v_row;
        }

        protected void closeIterator() {
            if (!this.v_finished) {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                        this.rs = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                        this.stmt = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.v_finished = true;
        }

        protected void moveForward() throws JenaException {
            try {
                if (!this.v_finished && this.rs.next()) {
                    this.extractRow();
                    this.v_prefetched = true;
                } else {
                    this.closeIterator();
                }
            }
            catch (Exception e) {
                throw new JenaException("Convert results are FAILED.:" + e);
            }
        }

        protected void extractRow() throws Exception {
            this.v_row = BindingFactory.create();
            try {
                for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                    Node n = VirtGraph.Object2Node(this.rs.getObject(i));
                    if (n == null) continue;
                    this.v_row.add(Var.alloc((String)this.rsmd.getColumnLabel(i)), n);
                }
                if (this.virt_graph != null && !this.virt_graph.equals("virt:DEFAULT")) {
                    this.v_row.add(Var.alloc((String)"graph"), NodeFactory.createURI((String)this.virt_graph));
                }
            }
            catch (Exception e) {
                throw new JenaException("extractRow is FAILED.:" + e);
            }
        }

        protected void finalize() throws Throwable {
            if (!this.v_finished) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void requestCancel() {
            if (this.stmt != null) {
                try {
                    this.stmt.cancel();
                }
                catch (Exception e) {
                    throw new JenaException("requestCancel is FAILED.:" + e);
                }
            }
        }
    }

    private static class VirtQueryEngineFactory
    implements QueryEngineFactory {
        private VirtQueryEngineFactory() {
        }

        public boolean accept(Query query, DatasetGraph dataset, Context context) {
            if (dataset instanceof VirtDataset.VirtDataSetGraph) {
                return true;
            }
            return dataset.getDefaultGraph() instanceof VirtGraph;
        }

        public Plan create(Query query, DatasetGraph dataset, Binding initial, Context context) {
            if (!(dataset instanceof VirtDataset.VirtDataSetGraph) && !(dataset.getDefaultGraph() instanceof VirtGraph)) {
                throw new ARQInternalErrorException("VirtQueryEngineFactory: only factory VirtuosoDatasetGraph is supported");
            }
            VirtuosoQueryEngine engine = new VirtuosoQueryEngine(query, dataset, initial, context);
            return engine.getPlan();
        }

        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return false;
        }

        public Plan create(Op op, DatasetGraph dataset, Binding inputBinding, Context context) {
            throw new ARQInternalErrorException("VirtQueryEngineFactory: factory calleddirectly with an algebra expression");
        }
    }

    private class VirtTransform
    extends TransformCopy {
        private VirtTransform() {
        }

        public Op transform(OpBGP opBGP) {
            return opBGP;
        }
    }
}

