/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

#include "import_gate_virtuoso.h"

/* graphql.sql */

static const char *other0 = 
"DB.DBA.XML_SET_NS_DECL (\'gql\', \'http://www.openlinksw.com/schemas/graphql#\', 2)\n";
static const char *other1 = 
"DB.DBA.XML_SET_NS_DECL (\'gqi\', \'http://www.openlinksw.com/schemas/graphql/intro#\', 2)\n";
static const char *proc0 = 
"#line 12 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_GET_FRAGMENTS (inout tree any)\n"
"{\n"
"declare frag_dict, elm any;\n"
"declare i int;\n"
"\n"
"if (isvector (tree) and tree[0] = 199)\n"
"tree := tree[1];\n"
"\n"
"frag_dict := dict_new (length (tree));\n"
"for (i := 0; i < length(tree); i := i + 1)\n"
"{\n"
"elm := tree[i];\n"
"if (gql_frag (elm))\n"
"{\n"
"dict_put (frag_dict, elm[1], vector (elm[2], elm[3], elm[4]));\n"
"tree[i] := null;\n"
"}\n"
"}\n"
"return frag_dict;\n"
"}\n"
"--src graphql.sql:10\n"
;

static const char *proc1 = 
"#line 35 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_DIRECTIVES_MERGE (inout dirs01 any, inout dirs02 any, in elem varchar)\n"
"{\n"
"declare dirs03 any;\n"
"declare i int;\n"
"dirs01 := aref_set_0 (dirs01, 1);\n"
"dirs03 := aref_set_0 (dirs02, 1);\n"
"for (i := 0; i < length (dirs03); i := i + 2)\n"
"{\n"
"declare directive_name varchar;\n"
"directive_name := dirs03[i];\n"
"if (get_keyword (directive_name, dirs01) is not null)\n"
"signal (\'GQLF1\', sprintf (\'Cannot override directive `%s` on `%s`\', directive_name, elem));\n"
"}\n"
"return vector_concat (dirs01, dirs03);\n"
"}\n"
"--src graphql.sql:33\n"
;

static const char *proc2 = 
"#line 53 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_EXPAND_REFS (in tree any, inout variables any, inout frag_dict any, out frag_exists int, inout known_directives any)\n"
"{\n"
"declare elm, new_tree any;\n"
"declare i, j int;\n"
"\n"
"if (not isvector (tree))\n"
"return tree;\n"
"\n"
"if (frag_dict is null)\n"
"frag_dict := GQL_GET_FRAGMENTS (tree);\n"
"\n"
"vectorbld_init (new_tree);\n"
"\n"
"for (i := 0; i < length(tree); i := i + 1)\n"
"{\n"
"declare exp any;\n"
"elm := tree[i];\n"
"\n"
"\n"
"\n"
"if (not isvector (elm))\n"
"{\n"
"vectorbld_acc (new_tree, elm);\n"
"goto skip;\n"
"}\n"
"\n"
"if (gql_field (elm) and 0 = GQL_DIRECTIVES_CHECK (elm[6], variables, known_directives))\n"
"goto skip;\n"
"if (gql_frag_ref (elm) and 0 = GQL_DIRECTIVES_CHECK (elm[2], variables, known_directives))\n"
"goto skip;\n"
"if (gql_inline_frag (elm) and 0 = GQL_DIRECTIVES_CHECK (elm[2], variables, known_directives))\n"
"goto skip;\n"
"\n"
"if (gql_frag_ref (elm))\n"
"{\n"
"declare fname, ftype varchar;\n"
"declare exps, directives, directives0 any;\n"
"fname := elm[1];\n"
"directives0 := elm[2];\n"
"exps := dict_get (frag_dict, fname);\n"
"if (not isvector (exps))\n"
"signal (\'GQLF0\', sprintf (\'No fragment `%s` defined\', fname));\n"
"ftype := exps[0];\n"
"exp := exps[1];\n"
"directives := exps[2];\n"
"if (isvector (directives0) and isvector (directives))\n"
"signal (\'GQLF2\', sprintf (\'Cannot override directives on `%s`\', fname));\n"
"if (not isvector (directives))\n"
"directives := directives0;\n"
"foreach (any frag in exp) do\n"
"{\n"
"if (gql_field (frag))\n"
"{\n"
"frag [5] := ftype;\n"
"if (isvector (frag [6]) and isvector (directives))\n"
"{\n"
"declare dirs01, dirs02 any;\n"
"dirs01 := aref_set_0 (frag, 6);\n"
"dirs02 := GQL_DIRECTIVES_MERGE (dirs01, directives, frag[1]);\n"
"aset (directives, 1, dirs02);\n"
"}\n"
"frag [6] := directives;\n"
"}\n"
"vectorbld_acc (new_tree, frag);\n"
"}\n"
"frag_exists := 1;\n"
"}\n"
"else if (gql_inline_frag (elm))\n"
"{\n"
"declare ftype varchar;\n"
"declare exps, directives any;\n"
"exps := elm[3];\n"
"ftype := elm[1];\n"
"directives := elm[2];\n"
"foreach (any frag in exps) do\n"
"{\n"
"frag [5] := ftype;\n"
"if (isvector (frag [6]) and isvector (directives))\n"
"signal (\'GQLF3\', sprintf (\'Cannot override directives on `%s`\', frag[1]));\n"
"frag [6] := directives;\n"
"vectorbld_acc (new_tree, frag);\n"
"}\n"
"frag_exists := 1;\n"
"}\n"
"else\n"
"{\n"
"exp := GQL_EXPAND_REFS (elm, variables, frag_dict, frag_exists, known_directives);\n"
"if (exp is not null)\n"
"{\n"
"vectorbld_acc (new_tree, exp);\n"
"}\n"
"}\n"
"skip:;\n"
"}\n"
"vectorbld_final (new_tree);\n"
"return new_tree;\n"
"}\n"
"--src graphql.sql:51\n"
;

static const char *proc3 = 
"#line 153 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_APPLY_VARS_DEFAULTS (inout variables any, inout defs any)\n"
"{\n"
"declare i int;\n"
"if (not gql_vars_defs (defs))\n"
"return;\n"
"defs := defs[1];\n"
"if (not isvector (variables))\n"
"variables := vector ();\n"
"for (i := 0; i < length (defs); i := i + 2)\n"
"{\n"
"declare var_name varchar;\n"
"declare pos int;\n"
"declare def_value any;\n"
"var_name := defs[i][1];\n"
"def_value := defs[i+1][2];\n"
"if (get_keyword (var_name, variables) is null)\n"
"variables := vector_concat (variables, vector (var_name, def_value));\n"
"}\n"
"}\n"
"--src graphql.sql:151\n"
;

static const char *proc4 = 
"#line 175 \"[executable]/graphql.sql\"\n"
"create procedure GQL_QUERY_PRAGMAS (inout dirs any, inout known_directives any)\n"
"{\n"
"declare pragmas, locations varchar;\n"
"declare i int;\n"
"pragmas := \'\';\n"
"if (not isvector (dirs) or not gql_directives (dirs))\n"
"return \'\';\n"
"dirs := aref_set_0 (dirs, 1);\n"
"for (i := 0; i < length (dirs); i := i + 2)\n"
"{\n"
"declare dir_name varchar;\n"
"declare opts any;\n"
"dir_name := dirs[i];\n"
"opts := dirs[i + 1];\n"
"if (isvector (opts))\n"
"opts := opts[1];\n"
"else\n"
"opts := vector ();\n"
"locations := get_keyword (dir_name, known_directives);\n"
"if (locations is null or\n"
"(strstr (locations, \'QUERY\') is null and\n"
"strstr (locations, \'MUTATION\') is null and\n"
"strstr (locations, \'SUBSCRIPTION\') is null))\n"
"{\n"
"signal (\'GQTPQ\', sprintf (\'Unsupported directive `%s`\', dir_name));\n"
"}\n"
"if (dir_name = \'inferenceOption\')\n"
"{\n"
"declare sas, ifps varchar;\n"
"sas := get_keyword (\'sameAs\', opts);\n"
"ifps := get_keyword (\'ifp\', opts);\n"
"if (sas is not null)\n"
"pragmas := concat (pragmas, sprintf (\'define input:same-as \"%s\"\\r\\n\', sas));\n"
"if (ifps is not null)\n"
"pragmas := concat (pragmas, sprintf (\'define input:ifp \"%s\"\\r\\n\', ifps));\n"
"}\n"
"else if (dir_name = \'dataGraph\')\n"
"{\n"
"declare graph_uri varchar;\n"
"graph_uri := get_keyword (\'uri\', opts);\n"
"if (graph_uri is not null)\n"
"pragmas := concat (pragmas, sprintf (\'define input:using-graph-uri \"%s\"\\r\\n\', graph_uri));\n"
"}\n"
"}\n"
"return pragmas;\n"
"}\n"
"--src graphql.sql:173\n"
;

static const char *proc5 = 
"#line 223 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_PARSE_REQUEST (in str any, inout variables any, inout g_iid any, inout tree any,\n"
"inout triples any, inout patterns any, inout vals any, inout clauses any, inout updates any, inout upd_params any,\n"
"inout dict any, in operation_name varchar, inout events any, inout pragmas any)\n"
"{\n"
"#pragma prefix gql: <http://www.openlinksw.com/schemas/graphql#>\n"
"declare elm, elem_lst, frag_dict, parent, vars_defs, dirs, known_directives any;\n"
"declare i, j, frag_exists, nth int;\n"
"declare defs, qry, operation varchar;\n"
"declare qry_idx, for_update int;\n"
"\n"
"tree := graphql_parse (str);\n"
"\n"
"if (gql_top (tree))\n"
"tree := tree[1];\n"
"else\n"
"signal (\'GQLRQ\', \'Unexpected GraphQL document\');\n"
"\n"
"qry_idx := 0;\n"
"for_update := 0;\n"
"\n"
"for (i := 0; i < length (tree); i := i + 1)\n"
"{\n"
"if (operation_name is not null and tree[i][1] = operation_name)\n"
"qry_idx := i;\n"
"if (gql_token (tree[i][0]) in (\'query\', \'mutation\', \'subscription\'))\n"
"{\n"
"vars_defs := tree[i][3];\n"
"GQL_APPLY_VARS_DEFAULTS (variables, vars_defs);\n"
"}\n"
"}\n"
"\n"
"\n"
"known_directives := (SELECT VECTOR_AGG (\"dname\", \"locs\") FROM (SPARQL SELECT str(?dname) as ?dname GROUP_CONCAT(?loc, \",\") as ?locs\n"
"{\n"
"GRAPH <urn:graphql:schema> { gql:Map gql:dataGraph ?g }\n"
"GRAPH ?g { gqi:__schema gqi:directives [ gqi:name ?dname ; gqi:locations ?loc ] FILTER (str(?dname) not in (\"skip\", \"include\"))\n"
"}} group by (?dname) ) dt );\n"
"frag_dict := null;\n"
"frag_exists := 1;\n"
"nth := 0;\n"
"while (frag_exists)\n"
"{\n"
"frag_exists := 0;\n"
"tree := GQL_EXPAND_REFS (tree, variables, frag_dict, frag_exists, known_directives);\n"
"nth := nth + 1;\n"
"if (nth > atoi (registry_get (\'graphql-max-depth\', \'15\')))\n"
"signal (\'GQLDX\', \'Maximum nesting level reached or infinite loop in fragments, optimise your query.\');\n"
"}\n"
"\n"
"\n"
"\n"
"operation := gql_token (tree[qry_idx][0]);\n"
"\n"
"\n"
"if (operation in (\'query\', \'mutation\', \'subscription\'))\n"
"{\n"
"dirs := tree[qry_idx][4];\n"
"tree := tree[qry_idx][2];\n"
"}\n"
"else\n"
"{\n"
"signal (\'GQLNO\', sprintf (\'The `%s` operation is not supported.\', operation));\n"
"}\n"
"\n"
"pragmas := GQL_QUERY_PRAGMAS (dirs, known_directives);\n"
"\n"
"triples := string_output ();\n"
"patterns := string_output ();\n"
"vals := string_output ();\n"
"clauses := string_output ();\n"
"updates := string_output ();\n"
"vectorbld_init (upd_params);\n"
"vectorbld_init (events);\n"
"parent := null;\n"
"for (i := 0; i < length(tree); i := i + 1)\n"
"{\n"
"elm := tree[i];\n"
"\n"
"if (i = 0 and gql_field (elm))\n"
"{\n"
"declare top_field_name varchar;\n"
"top_field_name := elm[1];\n"
"if (top_field_name in (\'__schema\',\'__type\'))\n"
"{\n"
"connection_set (\'__intro\', (case top_field_name when \'__schema\' then 1 when \'__type\' then 2 else 0 end));\n"
"g_iid := GQL_SCH_IID();\n"
"}\n"
"else\n"
"{\n"
"declare g_iid_sch, field_iid iri_id_8;\n"
"field_iid := GQL_IID (top_field_name);\n"
"g_iid_sch := null;\n"
"for select * from (sparql define input:storage \"\" define output:valmode \"LONG\"\n"
"select ?g where { graph ?g { gql:Map gql:schemaObjects ?:field_iid .  filter (?g != <urn:graphql:schema>)}}) dt do\n"
"{\n"
"if (atoi (registry_get (\'graphql-map-check\', \'1\')) > 0 and g_iid_sch is not null)\n"
"signal (\'GQLSX\', sprintf (concat (\'The field `gql:%s` is defined in more than one mapping schema graph, must drop overlapping one(s).\',\n"
"\' Conflicting graphs are `%s` and `%s`.\',\n"
"\' You can disable this check by registry setting `graphql-map-check` set to `0`, however may get wrong results or errors\'),\n"
"top_field_name, g_iid_sch, \"g\"));\n"
"g_iid_sch := \"g\";\n"
"}\n"
"g_iid := coalesce (g_iid_sch, g_iid);\n"
"}\n"
"}\n"
"if (operation = \'mutation\')\n"
"{\n"
"for_update := 1;\n"
"GQL_UPDATE (g_iid, elm, variables, parent, updates, upd_params, dict, events);\n"
"}\n"
"if (i > 0)\n"
"http  (\'\\n UNION \\n\', patterns);\n"
"http (\'{\', patterns);\n"
"GQL_CONSTRUCT (g_iid, elm, variables, parent, triples, patterns, vals, clauses, dict, for_update);\n"
"http (vals, patterns);\n"
"string_output_flush (vals);\n"
"http (\'}\', patterns);\n"
"}\n"
"vectorbld_final (upd_params);\n"
"vectorbld_final (events);\n"
"return 1;\n"
"}\n"
"--src graphql.sql:221\n"
;

static const char *proc6 = 
"#line 348 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_EXEC_UPDATES (in qry_ses varchar, inout upd_params any, inout events any)\n"
"{\n"
"declare qrs, params any;\n"
"declare state, message varchar;\n"
"declare maxrows, nth int;\n"
"\n"
"set_user_id (connection_get (\'SPARQLUserId\', \'GRAPHQL\'), 1);\n"
"qrs := string_output_string (qry_ses);\n"
"qrs := sql_split_text (qrs);\n"
"nth := 0;\n"
"foreach (varchar qry in qrs) do\n"
"{\n"
"maxrows := 0;\n"
"params := upd_params[nth];\n"
"state := \'00000\';\n"
"exec (qry, state, message, params, vector (\'max_rows\', maxrows, \'use_cache\', 1));\n"
"if (state <> \'00000\')\n"
"{\n"
"signal (state, message);\n"
"return NULL;\n"
"}\n"
"nth := nth + 1;\n"
"}\n"
"commit work;\n"
"if (events and length (events) > 0 and __proc_exists (\'DB.DBA.GQL_REGISTER_EVENTS\'))\n"
"{\n"
"aq_request (async_queue (1, 4), \'DB.DBA.GQL_REGISTER_EVENTS\', events);\n"
"}\n"
"}\n"
"--src graphql.sql:346\n"
;

static const char *proc7 = 
"#line 381 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_EXEC (in tree any, in qry varchar, inout meta any, inout rset any, in timeout int)\n"
"{\n"
"declare ses, params any;\n"
"declare state, message, elm varchar;\n"
"declare maxrows, nesting, is_array int;\n"
"declare max_timeout int;\n"
"declare anytime_status integer;\n"
"\n"
"maxrows := atoi (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'ResultSetMaxRows\'), \'-1\'));\n"
"anytime_status := atoi (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'HTTPAnytimeStatus\'), \'206\'));\n"
"\n"
"if (connection_get (\'__intro\'))\n"
"{\n"
"maxrows := -1;\n"
"timeout := 0;\n"
"}\n"
"params := vector ();\n"
"state := \'00000\';\n"
"\n"
"max_timeout := atoi (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'MaxQueryExecutionTime\'), \'0\')) * 1000;\n"
"if (max_timeout < 1000) max_timeout := 0;\n"
"if (timeout < 1000) timeout := 0;\n"
"if (max_timeout >= 1000 and (timeout > max_timeout))\n"
"{\n"
"timeout := max_timeout;\n"
"}\n"
"if (max_timeout and (timeout >= 1000))\n"
"{\n"
"set RESULT_TIMEOUT = timeout;\n"
"}\n"
"else if (max_timeout >= 1000)\n"
"{\n"
"set RESULT_TIMEOUT = max_timeout;\n"
"}\n"
"\n"
"qry := \'SPARQL \' || qry;\n"
"exec (qry, state, message, params, vector (\'max_rows\', maxrows, \'use_cache\', 1), meta, rset);\n"
"set RESULT_TIMEOUT = 0;\n"
"if (not isvector (rset))\n"
"rset := vector();\n"
"\n"
"if (0 = http_request_header () and state <> \'00000\')\n"
"{\n"
"signal (state, message);\n"
"return NULL;\n"
"}\n"
"if (state = \'S1TAT\' and timeout >= 1000)\n"
"{\n"
"http_status_set (anytime_status);\n"
"http_header (concat (http_header_get(),\n"
"sprintf (\'Accept-Ranges: none\\r\\nX-SPARQL-Anytime: timeout=%d; max_timeout=%d\\r\\n\', timeout, max_timeout)));\n"
"}\n"
"else if (length (rset) = maxrows)\n"
"{\n"
"http_status_set (anytime_status);\n"
"http_header (concat (http_header_get(), sprintf (\'Accept-Ranges: none\\r\\nX-SPARQL-MaxRows: %d\\r\\n\', maxrows)));\n"
"}\n"
"else if (state <> \'00000\')\n"
"{\n"
"signal (state, message);\n"
"return NULL;\n"
"}\n"
"}\n"
"--src graphql.sql:379\n"
;

static const char *proc8 = 
"#line 447 \"[executable]/graphql.sql\"\n"
"create function GQL_IID (in var varchar) returns iri_id_8\n"
"{\n"
"return iri_to_id (concat (\'http://www.openlinksw.com/schemas/graphql#\', var));\n"
"}\n"
"--src graphql.sql:445\n"
;

static const char *proc9 = 
"#line 453 \"[executable]/graphql.sql\"\n"
"create function GQL_SCH_IID () returns iri_id_8\n"
"{\n"
"return iri_to_id (\'urn:graphql:schema\');\n"
"}\n"
"--src graphql.sql:451\n"
;

static const char *proc10 = 
"#line 459 \"[executable]/graphql.sql\"\n"
"create procedure GQL_VAL_PRINT (in val any, in xsd_type varchar := null)\n"
"{\n"
"declare ret varchar;\n"
"if (xsd_type in (GQL_XSD_IRI (\'date\'), GQL_XSD_IRI (\'dateTime\'), GQL_XSD_IRI (\'time\')))\n"
"{\n"
"declare parsed varchar;\n"
"parsed := __xqf_str_parse_to_rdf_box (val, xsd_type, 1);\n"
"if (parsed is null)\n"
"{\n"
"declare ses any;\n"
"if (xsd_type = GQL_XSD_IRI (\'dateTime\'))\n"
"parsed := cast (val as datetime);\n"
"else if (xsd_type = GQL_XSD_IRI (\'date\'))\n"
"parsed := cast (val as date);\n"
"else if (xsd_type = GQL_XSD_IRI (\'time\'))\n"
"parsed := cast (val as time);\n"
"else\n"
"signal (\'22023\', \'Invalid date/time value\');\n"
"ses := string_output ();\n"
"__rdf_long_to_ttl (parsed, ses);\n"
"val := string_output_string (ses);\n"
"}\n"
"ret := sprintf (\'%s^^<%s>\',  DB.DBA.SYS_SQL_VAL_PRINT (val), xsd_type);\n"
"}\n"
"else\n"
"ret := DB.DBA.SYS_SQL_VAL_PRINT (val);\n"
"return ret;\n"
"}\n"
"--src graphql.sql:457\n"
;

static const char *proc11 = 
"#line 489 \"[executable]/graphql.sql\"\n"
"create procedure GQL_SQL_ARRAY_STR (in var any, in xsd_type varchar)\n"
"{\n"
"declare i int;\n"
"declare res varchar;\n"
"res := \'(\';\n"
"for (i := 0; i < length (var); i := i + 1)\n"
"{\n"
"if (i > 0)\n"
"res := concat (res, \',\');\n"
"res := concat (res, GQL_VAL_PRINT (var[i], xsd_type));\n"
"}\n"
"res := concat (res, \')\');\n"
"return res;\n"
"}\n"
"--src graphql.sql:487\n"
;

static const char *proc12 = 
"#line 505 \"[executable]/graphql.sql\"\n"
"create function GQL_FUNCTION_EXP (in exp varchar, out neg char)\n"
"{\n"
"declare op, arg_value any;\n"
"if (not gql_expression (exp))\n"
"return NULL;\n"
"arg_value := exp[1][0];\n"
"op := arg_value[1];\n"
"op := lower (op);\n"
"neg := \'\';\n"
"if (subseq (op, 0, 4) = \'not_\')\n"
"{\n"
"op := subseq (op, 4);\n"
"neg := \'!\';\n"
"}\n"
"if (op in (\'strstr\', \'regex\', \'contains\'))\n"
"return upper (op);\n"
"return NULL;\n"
"}\n"
"--src graphql.sql:503\n"
;

static const char *proc13 = 
"#line 525 \"[executable]/graphql.sql\"\n"
"create function GQL_OP (in tok varchar, out neg char)\n"
"{\n"
"tok := lower (tok);\n"
"neg := \'\';\n"
"if (subseq (tok, 0, 4) = \'not_\')\n"
"{\n"
"neg := \'!\';\n"
"tok := subseq (tok, 4);\n"
"}\n"
"if (tok = \'gt\') return \'>\';\n"
"if (tok = \'gte\') return \'>=\';\n"
"if (tok = \'lt\') return \'<\';\n"
"if (tok = \'lte\') return \'<=\';\n"
"if (tok = \'neq\') return \'!=\';\n"
"if (tok = \'like\') return \'LIKE\';\n"
"if (tok = \'in\') return \'IN\';\n"
"signal (\'GQLTO\', sprintf (\'Unrecognised expression operator %s\', tok));\n"
"}\n"
"--src graphql.sql:523\n"
;

static const char *proc14 = 
"#line 545 \"[executable]/graphql.sql\"\n"
"create procedure GQL_DEBUG (in line int, in text varchar)\n"
"{\n"
"if (registry_get (\'graphql-debug\') = \'1\')\n"
"dbg_obj_print (\'line:\', line, \' \',replace (text, \'\\n\', \'\'));\n"
"}\n"
"--src graphql.sql:543\n"
;

static const char *proc15 = 
"#line 552 \"[executable]/graphql.sql\"\n"
"create function\n"
"GQL_DIRECTIVES_CHECK (in directives_list any, inout variables any, inout known_directives any) returns int\n"
"{\n"
"declare inx int;\n"
"declare directive_name, directive, cond any;\n"
"declare locations varchar;\n"
"if (not gql_directives (directives_list))\n"
"return 1;\n"
"directives_list := directives_list[1];\n"
"for (inx := 0; inx < length (directives_list); inx := inx + 2)\n"
"{\n"
"directive_name := directives_list[inx];\n"
"directive := directives_list[inx+1];\n"
"locations := get_keyword (directive_name, known_directives);\n"
"if (locations is not null)\n"
"return 1;\n"
"if (directive_name not in (\'skip\', \'include\'))\n"
"signal (\'GQLDN\', sprintf (\'Directive `%s` is not supported\', directive_name));\n"
"if (not gql_args (directive) or length (directive[1]) <> 2 or directive[1][0] <> \'if\')\n"
"signal (\'GQLDA\', sprintf (\'Directive `%s` must specify `if`\', directive_name));\n"
"cond := coalesce (GQL_VALUE (variables, directive[1][1], \'RAW\'), 0);\n"
"if (directive_name = \'skip\' and cond)\n"
"return 0;\n"
"if (directive_name = \'include\' and not cond)\n"
"return 0;\n"
"}\n"
"return 1;\n"
"}\n"
"--src graphql.sql:550\n"
;

static const char *proc16 = 
"#line 582 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_DIECTIVES_APPLY (in var_name varchar, in directives any, inout variables any,\n"
"inout tp varchar, inout sql_table_option varchar, inout filter_exp varchar, inout graph_exp varchar)\n"
"{\n"
"declare list any;\n"
"declare i int;\n"
"sql_table_option := \'\';\n"
"filter_exp := \'\';\n"
"graph_exp := \'\';\n"
"if (not gql_directives (directives))\n"
"return;\n"
"list := directives[1];\n"
"for (i := 0; i < length (list); i := i + 2)\n"
"{\n"
"declare dir_name varchar;\n"
"declare args any;\n"
"dir_name := list[i];\n"
"args := list[i+1][1];\n"
"if (dir_name = \'notNull\')\n"
"{\n"
"tp := concat (rtrim (tp, \'-\'), \'-\');\n"
"}\n"
"else if (dir_name = \'sqlOption\')\n"
"{\n"
"declare hash_option, index_option varchar;\n"
"hash_option := get_keyword (\'option\', args, null);\n"
"index_option := get_keyword (\'index\', args, null);\n"
"if (hash_option is not null)\n"
"sql_table_option := sprintf (\'%s,\', hash_option);\n"
"if (index_option is not null)\n"
"sql_table_option := concat (sql_table_option, sprintf (\'index %s\', index_option));\n"
"sql_table_option := trim (sql_table_option,\',\');\n"
"if (length (sql_table_option))\n"
"sql_table_option := concat (\'option (table_option \"\', sql_table_option,\'\")\');\n"
"}\n"
"else if (dir_name = \'filter\')\n"
"{\n"
"declare func_exp varchar;\n"
"func_exp := get_keyword (\'expression\', args, null);\n"
"if (func_exp is null)\n"
"signal (\'GQLD0\', \'`filter` directive must specify `expression` argument\');\n"
"var_name := concat (\'?\', var_name);\n"
"func_exp := replace (func_exp, \'\\x24\', var_name);\n"
"filter_exp := concat (filter_exp, sprintf (\' FILTER (%s)\', func_exp));\n"
"}\n"
"else if (dir_name = \'dataGraph\')\n"
"{\n"
"declare uri varchar;\n"
"uri := get_keyword (\'uri\', args, null);\n"
"if (uri is null)\n"
"signal (\'GQLD1\', \'`dataGraph` directive must specify `uri` argument\');\n"
"graph_exp := sprintf (\' GRAPH %s { \', GQL_VALUE (variables, uri, \'IRI\'));\n"
"}\n"
"}\n"
"}\n"
"--src graphql.sql:580\n"
;

static const char *proc17 = 
"#line 639 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_CONSTRUCT (in g_iid any, in tree any, in variables any, in parent any,\n"
"inout triples any, inout patterns any, inout vals any, inout clauses any, inout dict any, in for_update int := 0)\n"
"{\n"
"#pragma prefix gql: <http://www.openlinksw.com/schemas/graphql#>\n"
"declare i, j int;\n"
"declare elm, args, directives any;\n"
"declare var_name, var_name_only varchar;\n"
"declare sql_table_option, filter_exp, graph_exp varchar;\n"
"\n"
"if (not isvector (tree))\n"
"return;\n"
"if (gql_field (tree))\n"
"{\n"
"declare cls, cls_type, prop, tp, parent_name, parent_prop, parent_cls, prefix, field_type, local_filter varchar;\n"
"declare id_prop, alias varchar;\n"
"declare has_filter int;\n"
"args := tree[2];\n"
"directives := tree[6];\n"
"sql_table_option := filter_exp := graph_exp := \'\';\n"
"\n"
"parent_name := parent_cls := parent_prop := cls := cls_type := null; id_prop := null;\n"
"has_filter := 0;\n"
"alias := tree[4];\n"
"if (isvector (parent))\n"
"{\n"
"parent_cls := parent[0];\n"
"parent_name := parent[1];\n"
"parent_prop := parent[2];\n"
"prefix := parent_name || \'·\';\n"
"}\n"
"else\n"
"prefix := (case when isstring (alias) then concat (alias, \'·\') else \'\' end);\n"
"\n"
"field_type := tree[5];\n"
"var_name_only := var_name := tree[1];\n"
"var_name := concat (prefix, var_name);\n"
"local_filter := \'\';\n"
"tree := tree[3];\n"
"if ((isvector (tree) or parent_name is null) and var_name <> \'__typename\')\n"
"{\n"
"declare gcls_iid iri_id_8;\n"
"declare pos int;\n"
"gcls_iid := GQL_IID (var_name_only);\n"
"GQL_DEBUG (pldbg_last_line (),sprintf (concat (\'sparql select * where { graph <%s> \',\n"
"\' { gql:Map gql:schemaObjects <%s> . <%s> gql:rdfClass ?class ; gql:type ?class_type . }}\'),\n"
"id_to_iri (g_iid), id_to_iri(gcls_iid), id_to_iri(gcls_iid)));\n"
"\n"
"for select \"class\", \"class_type\" from (sparql select ?class ?class_type where\n"
"{ graph ?:g_iid { gql:Map gql:schemaObjects ?:gcls_iid .\n"
"?:gcls_iid gql:rdfClass ?class ; gql:type ?class_type . }}) dt0 do\n"
"{\n"
"cls := \"class\";\n"
"cls_type := \"class_type\";\n"
"}\n"
"\n"
"\n"
"if (cls is null and parent_name is not null)\n"
"{\n"
"declare object_prop varchar;\n"
"object_prop := null;\n"
"GQL_DEBUG ( pldbg_last_line (), sprintf (concat (\'sparql select ?class ?class_type where { graph <%s> { \',\n"
"\' [] a owl:ObjectProperty ; gql:field <%s> ; rdfs:range ?class ; gql:type ?class_type . }} \'),\n"
"id_to_iri (g_iid), id_to_iri(gcls_iid)));\n"
"\n"
"for select \"obj_prop\", \"class\", \"class_type\" from (sparql select ?obj_prop ?class ?class_type where { graph ?:g_iid {\n"
"?obj_prop a owl:ObjectProperty ; gql:field ?:gcls_iid ; rdfs:range ?class ; gql:type ?class_type . }}) dt1 do\n"
"{\n"
"if (cls is not null and cls <> \"class\")\n"
"signal (\'GQLSX\', concat (sprintf (\'Conflict: the field `gql:%s` is mapped to property `<%s>` of mapping classes `<%s>` and `<%s>`.\',\n"
"var_name_only, object_prop, cls, \"class\"),\n"
"\' Only one mapping class must be specified in rdfs:range or make property a top-level field.\'));\n"
"if (object_prop is not null and object_prop <> \"obj_prop\")\n"
"signal (\'GQLSX\', sprintf (\'Conflict: the field `gql:%s` is mapped to properties `<%s>` and `<%s>`.\',\n"
"var_name_only, object_prop, \"obj_prop\"));\n"
"object_prop := \"obj_prop\";\n"
"cls := \"class\";\n"
"cls_type := \"class_type\";\n"
"}\n"
"}\n"
"if (cls is null)\n"
"{\n"
"signal (\'GQL0X\', sprintf (\'Can not find class for field \"%s\"\', var_name_only));\n"
"}\n"
"cls_type := iri_split (cls_type, null, 0, 1);\n"
"\n"
"if (not gqt_is_list(cls_type) and not gqt_is_obj(cls_type) and not cls_type = \'Function\')\n"
"signal (\'GQLTP\', sprintf (\'The field `%s` is not Object or Array.\', var_name_only));\n"
"\n"
"if (atoi (registry_get (\'graphql-top-object\', \'0\')) > 0 and\n"
"var_name <> \'__schema\' and not (gqt_is_list (cls_type)) and parent_cls is null and not isvector (args))\n"
"signal (\'GQLAR\', sprintf (\'The field `%s` is an Object and no parent field or arguments.\', var_name_only));\n"
"\n"
"GQL_DIECTIVES_APPLY (var_name, directives, variables, cls_type, sql_table_option, filter_exp, graph_exp);\n"
"dict_put (dict, var_name, cls_type);\n"
"parent := vector (iri_to_id (cls), var_name, null);\n"
"if (parent_cls is null and var_name <> \'__type\')\n"
"http (sprintf (\'%s ?%s a <%s> %s. %s\\n\', graph_exp, var_name, cls, sql_table_option, filter_exp), patterns);\n"
"else if (parent_cls is null and var_name = \'__type\')\n"
"http (sprintf (\' ?%s a [] . \\n\', var_name), patterns);\n"
"\n"
"if (parent_name is null)\n"
"http (sprintf (\' :data :%s ?%s . \\n\', var_name, var_name), triples);\n"
"}\n"
"if (gql_args (args))\n"
"{\n"
"declare arg_name, arg_value, expression, neg, iri_given any;\n"
"declare arg_iid, fld_iid iri_id_8;\n"
"\n"
"iri_given := 0;\n"
"fld_iid := GQL_IID (var_name_only);\n"
"args := args[1];\n"
"for (j := 0; j < length(args); j := j + 2)\n"
"{\n"
"arg_name := args[j];\n"
"arg_value := args[j + 1];\n"
"if (gql_var (arg_value))\n"
"arg_value := get_keyword (arg_value[1], variables, NULL);\n"
"arg_iid := GQL_IID (arg_name);\n"
"if (arg_name = \'first\')\n"
"http (sprintf (\' LIMIT %s \\n\', DB.DBA.SYS_SQL_VAL_PRINT (arg_value)), clauses);\n"
"else if (arg_name = \'offset\')\n"
"http (sprintf (\' OFFSET %s \\n\', DB.DBA.SYS_SQL_VAL_PRINT (arg_value)), clauses);\n"
"else if (arg_name = \'contains\')\n"
"{\n"
"declare ftx varchar;\n"
"ftx := DB.DBA.FTI_MAKE_SEARCH_STRING (arg_value);\n"
"if (ftx is null)\n"
"signal (\'GQLFX\', sprintf (\'Can not search \"%s\" with an empty pattern\', var_name));\n"
"http (sprintf (\' ?%s ?%s·search ?%s . \\n\', var_name, arg_name, arg_name), patterns);\n"
"http (sprintf (\' FILTER (bif:contains (?%s, \\\'%s\\\')) \\n\',  arg_name, ftx), vals);\n"
"}\n"
"else if (arg_name = \'iri\')\n"
"{\n"
"http (sprintf (\' FILTER (?%s = <%s>) \\n\',  var_name, arg_value), vals);\n"
"if (for_update and id_prop is not null)\n"
"signal (\'GQLSX\', \'`ID` and `iri` arguments conflict for update operation\');\n"
"iri_given := 1;\n"
"}\n"
"else if (arg_name = \'lang\')\n"
"local_filter := concat (local_filter, sprintf (\' FILTER (lang(?%s) = \\\'%s\\\') \\n\',  var_name, arg_value));\n"
"else\n"
"{\n"
"declare xsd_type varchar;\n"
"if (g_iid = GQL_SCH_IID())\n"
"{\n"
"\n"
"if (arg_name = \'includeDeprecated\' and arg_value)\n"
"goto skip_filter;\n"
"if (arg_name = \'includeDeprecated\')\n"
"{\n"
"arg_name := \'isDeprecated\';\n"
"arg_iid := GQL_IID (arg_name);\n"
"}\n"
"}\n"
"prop := null;\n"
"\n"
"GQL_DEBUG (pldbg_last_line (),sprintf (concat (\'sparql select * where { graph <%s> \',\n"
"\' { <%s> rdfs:subClassOf* ?domain .\n"
"?prop0 rdfs:domain ?domain ; gql:type ?tp0 ; gql:field <%s> . \',\n"
"\'  optional {  [] rdfs:domain ?domain  ; rdfs:range ?range ; gql:field <%s> . \',\n"
"\'  ?prop1 rdfs:domain ?range ; gql:field <%s> . } }}\'),\n"
"id_to_iri (g_iid), id_to_iri (cls), id_to_iri(arg_iid), id_to_iri(fld_iid), id_to_iri(arg_iid) ));\n"
"\n"
"for select \"prop0\", \"prop1\", \"tp0\", \"range0\" from (sparql select ?prop0 ?prop1 ?tp0 ?range0\n"
"where { graph ?:g_iid {\n"
"?:cls rdfs:subClassOf* ?domain .\n"
"?prop0 rdfs:domain ?domain ; gql:type ?tp0 ; rdfs:range ?range0 ; gql:field ?:arg_iid .\n"
"optional {  [] rdfs:domain ?domain  ; rdfs:range ?range ; gql:field ?:fld_iid .\n"
"?prop1 rdfs:domain ?range ; gql:field ?:arg_iid .\n"
"}\n"
"}}) dt0 do\n"
"{\n"
"prop := coalesce (\"prop1\", \"prop0\");\n"
"tp := iri_split (\"tp0\", null, 0, 1);\n"
"xsd_type := \"range0\";\n"
"}\n"
"if (prop is null)\n"
"signal (\'GQL1X\', sprintf (\'Can not find property for argument \"%s\"\', arg_name));\n"
"\n"
"if (tp = \'ID\')\n"
"id_prop := prop;\n"
"\n"
"if (for_update and tp <> \'ID\')\n"
"goto skip_filter;\n"
"\n"
"if (for_update and iri_given)\n"
"signal (\'GQLSX\', \'`ID` and `iri` arguments conflict for update operation\');\n"
"\n"
"arg_name := concat (prefix, var_name_only, \'·\', arg_name);\n"
"expression := GQL_FUNCTION_EXP (arg_value, neg);\n"
"http (sprintf (\' ?%s <%s> ?%s . \\n\', var_name, prop, arg_name), patterns);\n"
"if (arg_value is null)\n"
"http (sprintf (\'FILTER (?%s = rdf:nil) \\n\',  arg_name), vals);\n"
"else if (expression is not null)\n"
"{\n"
"arg_value := arg_value[1][0][2];\n"
"if (gql_var (arg_value))\n"
"arg_value := get_keyword (arg_value[1], variables, NULL);\n"
"http (sprintf (\'FILTER (%s %s (?%s, %s)) \\n\', neg, expression, arg_name, GQL_VAL_PRINT (arg_value, xsd_type)), vals);\n"
"}\n"
"else if (gql_expression (arg_value))\n"
"{\n"
"declare op varchar;\n"
"arg_value := arg_value[1][0];\n"
"op := GQL_OP (arg_value[1], neg);\n"
"arg_value := arg_value[2];\n"
"if (gql_var (arg_value))\n"
"arg_value := get_keyword (arg_value[1], variables, NULL);\n"
"http (sprintf (\'FILTER (%s ?%s %s %s ) \\n\', neg, arg_name, op, GQL_VAL_PRINT (arg_value, xsd_type)), vals);\n"
"}\n"
"else if (gql_obj (arg_value))\n"
"{\n"
"signal (\'GQLV0\', \'Inlined objects not supported in args list\');\n"
"}\n"
"else if (isvector (arg_value) and length (arg_value) > 1 and __tag (arg_value[0]) = 255 and arg_value[1] = \'structure\')\n"
"{\n"
"signal (\'GQLV1\', \'JSON objects not supported as values\');\n"
"}\n"
"else if (isvector (arg_value))\n"
"{\n"
"declare vlist varchar;\n"
"vlist := GQL_SQL_ARRAY_STR (arg_value, xsd_type);\n"
"http (sprintf (\' FILTER (?%s IN %s) \\n\',  arg_name, vlist), vals);\n"
"}\n"
"else if (tp = \'IRI\' or gqt_is_obj (tp) or gqt_is_list (tp))\n"
"http (sprintf (\' FILTER (?%s = <%s>) \\n\',  arg_name, arg_value), vals);\n"
"else\n"
"http (sprintf (\' FILTER (?%s = %s) \\n\',  arg_name, GQL_VAL_PRINT (arg_value, xsd_type)), vals);\n"
"has_filter := 1;\n"
"skip_filter:;\n"
"}\n"
"}\n"
"}\n"
"\n"
"if (parent_cls is not null)\n"
"{\n"
"declare parent_type varchar;\n"
"declare fld_iid iri_id_8;\n"
"fld_iid := GQL_IID (var_name_only);\n"
"if (not isvector (parent))\n"
"signal (\'GQL2X\', \'Internal error, unexpected child\');\n"
"\n"
"parent_type := dict_get (dict, parent_name);\n"
"prop := tp := null;\n"
"if (parent_prop is not null and (gqt_is_obj (parent_type) or gqt_is_list (parent_type)))\n"
"{\n"
"GQL_DEBUG (pldbg_last_line (),sprintf ( concat (\'sparql select * where { graph <%s> \',\n"
"\' { ?range rdfs:subClassOf* ?domain . <%s> rdfs:range  ?range . ?prop0 rdfs:domain ?domain ; gql:field <%s> ; gql:type ?tp0 . }}\'),\n"
"id_to_iri (g_iid), id_to_iri(parent_prop), id_to_iri(fld_iid)));\n"
"\n"
"for select \"prop0\", \"tp0\" from (sparql select ?prop0 ?tp0 where { graph ?:g_iid\n"
"{\n"
"?range rdfs:subClassOf* ?domain .\n"
"?:parent_prop rdfs:range  ?range .\n"
"?prop0 rdfs:domain ?domain ;\n"
"gql:field ?:fld_iid ;\n"
"gql:type ?tp0 .\n"
"}}) dt0 do\n"
"{\n"
"prop := \"prop0\";\n"
"tp := \"tp0\";\n"
"}\n"
"}\n"
"else\n"
"{\n"
"GQL_DEBUG (pldbg_last_line (),sprintf (concat (\'sparql select * where { graph <%s> \',\n"
"\' { <%s> rdfs:subClassOf* ?domain . ?prop0 rdfs:domain ?domain ; gql:field <%s> ; gql:type ?tp0 . }}\'),\n"
"id_to_iri (g_iid), id_to_iri(parent_cls), id_to_iri(fld_iid)));\n"
"\n"
"for select \"prop0\", \"tp0\"  from (sparql select ?prop0 ?tp0 where { graph ?:g_iid\n"
"{\n"
"?:parent_cls rdfs:subClassOf* ?domain .\n"
"?prop0 rdfs:domain ?domain ;\n"
"gql:field ?:fld_iid ;\n"
"gql:type ?tp0 .\n"
"}}) dt0 do\n"
"{\n"
"prop := \"prop0\";\n"
"tp := \"tp0\";\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"if (prop is null and var_name_only not in (\'__typename\', \'iri\'))\n"
"{\n"
"signal (\'GQL3X\', sprintf (\'Can not find property mapping for the property `gql:%s` associated with field %s\', var_name_only, var_name));\n"
"}\n"
"\n"
"if (var_name_only not in (\'__typename\', \'iri\'))\n"
"{\n"
"tp := iri_split (tp, null, 0,1);\n"
"GQL_DIECTIVES_APPLY (var_name, directives, variables, tp, sql_table_option, filter_exp, graph_exp);\n"
"dict_put (dict, var_name, tp);\n"
"parent [2] := prop;\n"
"http (sprintf (\' ?%s :%s ?%s . \\n\', parent_name, var_name, var_name), triples);\n"
"if (not has_filter)\n"
"http (sprintf (\' OPTIONAL {%s\', graph_exp), patterns);\n"
"else\n"
"http (sprintf (\' {%s\\t\', graph_exp), patterns);\n"
"\n"
"if (connection_get (\'__intro\') = 1)\n"
"http (sprintf (\'  ?%s <%s> ?%s option (table_option \"hash\") . \\n\', parent_name, prop, var_name), patterns);\n"
"else\n"
"http (sprintf (\'  ?%s <%s> ?%s %s. %s\\n\', parent_name, prop, var_name, sql_table_option, filter_exp), patterns);\n"
"\n"
"\n"
"if (atoi (registry_get (\'graphql-enable-non-object-fitering\', \'0\'))\n"
"and not(connection_get (\'__intro\')) and (gqt_is_obj (tp) or gqt_is_list (tp)))\n"
"http (sprintf (\' FILTER (isIRI (?%s)) . \\n\', var_name), patterns);\n"
"}\n"
"else if (var_name_only = \'__typename\')\n"
"{\n"
"declare sdl_name, parent_name_only varchar;\n"
"declare dot int;\n"
"\n"
"sdl_name := null;\n"
"dot := strrchr (parent_name, \'·\');\n"
"if (dot is not null)\n"
"parent_name_only := subseq (parent_name, dot + 2);\n"
"else\n"
"parent_name_only := parent_name;\n"
"\n"
"for select \"tname\" from (SPARQL SELECT  str(?tname) as ?tname\n"
"FROM <urn:graphql:intro>\n"
"WHERE\n"
"{ gqi:Query  gqi:fields  ?fld .\n"
"?fld      gqi:name    ?name .\n"
"?fld (gqi:type/gqi:ofType)|gqi:type ?tp .\n"
"?tp  gqi:name  ?tname .\n"
"FILTER ( ( ?name = ?:parent_name_only ) && ( ?tname != rdf:nil ) )\n"
"}) dt do\n"
"{\n"
"sdl_name := \"tname\";\n"
"}\n"
"\n"
"if (sdl_name is not null)\n"
"http (sprintf (\' ?%s :%s \"%s\" . \\n\', parent_name, var_name, sdl_name), triples);\n"
"else\n"
"http (sprintf (\' ?%s :%s `bif:iri_split(?%s,0,0,1)` . \\n\', parent_name, var_name, var_name), triples);\n"
"\n"
"http (sprintf (\' { ?%s rdf:type ?%s . \\n\', parent_name, var_name), patterns);\n"
"}\n"
"else\n"
"{\n"
"\n"
"http (sprintf (\' ?%s :%s ?%s . \\n\', parent_name, var_name, parent_name), triples);\n"
"\n"
"if (var_name_only = \'iri\' and strchr (parent_name, \'·\') is not null)\n"
"http (sprintf (\' FILTER (isIRI (?%s)) . \\n\', parent_name), patterns);\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"if (isvector (tree))\n"
"GQL_CONSTRUCT (g_iid, tree, variables, parent, triples, patterns, vals, clauses, dict, for_update);\n"
"\n"
"\n"
"if (parent_cls is not null and var_name_only <> \'iri\')\n"
"{\n"
"http (local_filter, patterns);\n"
"http (\' }\\n\', patterns);\n"
"}\n"
"if (length (graph_exp) > 0)\n"
"http (\' }\\n\', patterns);\n"
"\n"
"if (parent_cls is null and var_name = \'__typename\')\n"
"{\n"
"http (sprintf (\' :data :%s \"Query\" . \\n\', var_name), triples);\n"
"}\n"
"}\n"
"else if (length (tree) and isvector (tree[0]))\n"
"{\n"
"for (i := 0; i < length(tree); i := i + 1)\n"
"{\n"
"elm := tree[i];\n"
"GQL_CONSTRUCT (g_iid, elm, variables, parent, triples, patterns, vals, clauses, dict, for_update);\n"
"}\n"
"}\n"
"return;\n"
"}\n"
"--src graphql.sql:637\n"
;

static const char *proc18 = 
"#line 1024 \"[executable]/graphql.sql\"\n"
"create procedure GQL_FIELD_CAST (in g_iid iri_id_8, inout variables any,\n"
"inout fld_name any, inout val any, inout dt varchar, inout iid any, inout acc any)\n"
"{\n"
"declare fld_iid, prop, range, tp, pattern any;\n"
"if (fld_name = \'iri\')\n"
"{\n"
"if (iid is not null)\n"
"signal (\'GQTI4\', sprintf (\'IRI input for `%s` conflicts with `%s`\', fld_name, iid));\n"
"if (gql_var (val))\n"
"val := get_keyword (val[1], variables, null);\n"
"if (not isstring (val))\n"
"signal (\'GQTI1\', sprintf (\'IRI input for `%s` cannot be `%s`\', fld_name, dv_type_title (__tag (val))));\n"
"__box_flags_set (val, 1);\n"
"iid := val;\n"
"vectorbld_acc (acc, vector (val, rdf_ns_type_iri(), dt));\n"
"return;\n"
"}\n"
"fld_iid := GQL_IID (fld_name);\n"
"prop := null;\n"
"pattern := null;\n"
"for select * from (sparql select ?prop0 ?range0 ?tp0 ?pattern0\n"
"where { graph ?:g_iid {\n"
"?prop0 rdfs:domain ?domain ;\n"
"rdfs:range ?range0 ;\n"
"gql:type ?tp0 ;\n"
"gql:field ?:fld_iid .\n"
"optional { ?domain gql:iriPattern ?pattern0 . }\n"
"filter (?domain = iri(?:dt))\n"
"}}) dt do\n"
"{\n"
"if (prop is not null)\n"
"signal (\'GQLSX\', sprintf (\'RDF property conflict for mapping to field gql:%s\', fld_name));\n"
"prop := \"prop0\";\n"
"range := \"range0\";\n"
"tp := iri_split (\"tp0\", null, 0, 1);\n"
"pattern := \"pattern0\";\n"
"}\n"
"if (prop is null)\n"
"signal (\'GQTC2\', sprintf (\'Can not find property mapping for the property for field `%s`\', fld_name));\n"
"if (tp = \'ID\')\n"
"{\n"
"if (iid is not null)\n"
"signal (\'GQTI5\', sprintf (\'ID input for `%s` conflicts with `%s`\', fld_name, iid));\n"
"if (pattern is null)\n"
"signal (\'GQTI2\', sprintf (\'Missing pattern for `%s` input.\', fld_name));\n"
"if (gql_var (val))\n"
"val := get_keyword (val[1], variables, null);\n"
"if (not isstring (val)  and not isnumeric (val))\n"
"signal (\'GQTI3\', sprintf (\'IRI input for `%s` cannot be `%s`\', fld_name, dv_type_title (__tag (val))));\n"
"iid := sprintf (pattern, val);\n"
"__box_flags_set (iid, 1);\n"
"vectorbld_acc (acc, vector (iid, rdf_ns_type_iri(), dt));\n"
"}\n"
"val := GQL_ARG_INSERT_CAST (g_iid, variables, val, tp, range);\n"
"vectorbld_acc (acc, vector (null, prop, val));\n"
"}\n"
"--src graphql.sql:1022\n"
;

static const char *proc19 = 
"#line 1082 \"[executable]/graphql.sql\"\n"
"create procedure GQL_OBJ_CAST (in g_iid iri_id_8, inout variables any, in arg any, inout dt varchar)\n"
"{\n"
"declare list, res, iid any;\n"
"declare inx int;\n"
"\n"
"if (not gql_obj (arg))\n"
"return null;\n"
"\n"
"list := aref_set_0 (arg, 1);\n"
"iid := null;\n"
"vectorbld_init (res);\n"
"for (inx := 0; inx < length (list); inx := inx + 1)\n"
"{\n"
"declare fld, fld_name, val any;\n"
"\n"
"fld := aref_set_0 (list, inx);\n"
"fld_name := aref_set_0 (fld, 1);\n"
"val := aref_set_0 (fld, 2);\n"
"GQL_FIELD_CAST (g_iid, variables, fld_name, val, dt, iid, res);\n"
"}\n"
"if (isnull (iid))\n"
"vectorbld_acc (res, vector (null, rdf_ns_type_iri(), dt));\n"
"vectorbld_final (res);\n"
"\n"
"for (inx := 0; not isnull(iid) and inx < length (res); inx := inx + 1)\n"
"{\n"
"declare triple any;\n"
"triple := aref_set_0 (res, inx);\n"
"aset (triple, 0, iid);\n"
"aset_zap_arg (res, inx, triple);\n"
"}\n"
"return res;\n"
"}\n"
"--src graphql.sql:1080\n"
;

static const char *proc20 = 
"#line 1117 \"[executable]/graphql.sql\"\n"
"create procedure GQL_JSON_OBJ_CAST (in g_iid iri_id_8, inout variables any, in arg any, inout dt varchar)\n"
"{\n"
"declare res, iid any;\n"
"declare inx int;\n"
"\n"
"if (not (isvector (arg) and length (arg) > 1 and __tag (arg[0]) = 255 and arg[1] = \'structure\'))\n"
"return null;\n"
"\n"
"vectorbld_init (res);\n"
"iid := null;\n"
"for (inx := 2; inx < length (arg); inx := inx + 2)\n"
"{\n"
"declare fld_name, val any;\n"
"\n"
"fld_name := aref_set_0 (arg, inx);\n"
"val := aref_set_0 (arg, inx + 1);\n"
"GQL_FIELD_CAST (g_iid, variables, fld_name, val, dt, iid, res);\n"
"}\n"
"if (isnull (iid))\n"
"vectorbld_acc (res, vector (null, rdf_ns_type_iri(), dt));\n"
"vectorbld_final (res);\n"
"for (inx := 0; not isnull(iid) and inx < length (res); inx := inx + 1)\n"
"{\n"
"declare triple any;\n"
"triple := aref_set_0 (res, inx);\n"
"aset (triple, 0, iid);\n"
"aset_zap_arg (res, inx, triple);\n"
"}\n"
"return res;\n"
"}\n"
"--src graphql.sql:1115\n"
;

static const char *proc21 = 
"#line 1149 \"[executable]/graphql.sql\"\n"
"create procedure GQL_ARG_INSERT_CAST (in g_iid iri_id_8, in variables any, in arg_value any, in gqt varchar, inout dt varchar)\n"
"{\n"
"declare parsed any;\n"
"declare tid int;\n"
"\n"
"if (gql_var (arg_value))\n"
"arg_value := get_keyword (arg_value[1], variables, NULL);\n"
"\n"
"if (arg_value is null)\n"
"return GQL_RDF_NIL();\n"
"\n"
"if (gql_obj (arg_value))\n"
"{\n"
"return GQL_OBJ_CAST (g_iid, variables, arg_value, dt);\n"
"}\n"
"\n"
"if (isvector (arg_value) and length (arg_value) > 1 and __tag (arg_value[0]) = 255 and arg_value[1] = \'structure\')\n"
"{\n"
"return GQL_JSON_OBJ_CAST (g_iid, variables, arg_value, dt);\n"
"}\n"
"\n"
"if (isvector (arg_value))\n"
"signal (\'GQTC1\', \'Inlined arrays not supported as input value\');\n"
"\n"
"if (gqt_is_obj (gqt) or gqt_is_list (gqt) or dt = GQL_XSD_IRI (\'anyURI\') or gqt = \'IRI\')\n"
"return __box_flags_tweak (arg_value, 1);\n"
"\n"
"if (dt = GQL_XSD_IRI (\'string\') and isstring (arg_value))\n"
"return arg_value;\n"
"\n"
"if (isnumeric (arg_value) and GQL_XSD_IRI(\'boolean\') <> dt)\n"
"return arg_value;\n"
"\n"
"parsed := __xqf_str_parse_to_rdf_box (arg_value, dt, isstring (arg_value));\n"
"if (parsed is not null)\n"
"{\n"
"tid := rdf_cache_id (\'t\', dt);\n"
"if (tid and __tag (parsed) = __tag of rdf_box)\n"
"rdf_box_set_type (parsed, tid);\n"
"return parsed;\n"
"}\n"
"return arg_value;\n"
"}\n"
"--src graphql.sql:1147\n"
;

static const char *proc22 = 
"#line 1194 \"[executable]/graphql.sql\"\n"
"create procedure GQL_VALUE (in variables any, in arg_value any, in tp varchar, in cast_dt varchar := null)\n"
"{\n"
"if (gql_var (arg_value))\n"
"arg_value := get_keyword (arg_value[1], variables, NULL);\n"
"if (tp = \'RAW\')\n"
"{\n"
"if (arg_value is null)\n"
"return null;\n"
"\n"
"if (isvector (arg_value))\n"
"signal (\'GQTI6\', sprintf (\'Can not cast JSON object to RDF type `%s`\', coalesce (cast_dt, \'string\')));\n"
"if (cast_dt is null or not isstring (arg_value) or cast_dt = GQL_XSD_IRI(\'string\') or cast_dt = GQL_XSD_IRI(\'anyURI\'))\n"
"return arg_value;\n"
"\n"
"return DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_STRINGS (arg_value, cast_dt, null);\n"
"}\n"
"if (arg_value is null)\n"
"return \'rdf:nil\';\n"
"if (gql_expression (arg_value) or isvector (arg_value))\n"
"signal (\'GQLVX\', \'Argument value type for mutation is not supported.\');\n"
"if (tp = \'IRI\')\n"
"return sprintf (\'<%s>\', arg_value);\n"
"return DB.DBA.SYS_SQL_VAL_PRINT (arg_value);\n"
"}\n"
"--src graphql.sql:1192\n"
;

static const char *proc23 = 
"#line 1220 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_UPDATE (in g_iid any, in tree any, in variables any, in parent any, inout triples any, inout upd_params any, inout dict any, inout events any)\n"
"{\n"
"#pragma prefix gql: <http://www.openlinksw.com/schemas/graphql#>\n"
"declare i, j int;\n"
"declare elm, args any;\n"
"declare var_name, var_name_only varchar;\n"
"declare gcls_iid iri_id_8;\n"
"\n"
"if (not isvector (tree))\n"
"return;\n"
"if (gql_field (tree))\n"
"{\n"
"declare cls, cls_type, prop, tp, parent_name, parent_prop, parent_cls, prefix varchar;\n"
"declare field_type, iri_format, data_graph, sparql_operation, update_qry varchar;\n"
"\n"
"parent_name := parent_cls := parent_prop := cls := cls_type := null; iri_format := null; update_qry := null;\n"
"if (isvector (parent))\n"
"{\n"
"parent_cls := parent[0]; parent_name := parent[1]; parent_prop := parent[2]; prefix := parent_name || \'·\';\n"
"}\n"
"else\n"
"{\n"
"prefix := \'\';\n"
"}\n"
"\n"
"field_type := tree[5];\n"
"var_name_only := var_name := tree[1];\n"
"var_name := concat (prefix, var_name);\n"
"args := tree[2];\n"
"tree := tree[3];\n"
"if (isvector (tree))\n"
"{\n"
"gcls_iid := GQL_IID (var_name_only);\n"
"GQL_DEBUG (pldbg_last_line (),sprintf (concat (\'sparql select * where { graph <%s> \',\n"
"\' { gql:Map gql:schemaObjects <%s> . <%s> gql:rdfClass ?class ; gql:type ?class_type . }}\'),\n"
"id_to_iri (g_iid), id_to_iri(gcls_iid), id_to_iri(gcls_iid)));\n"
"\n"
"cls := null;\n"
"for select \"class\", \"class_type\", \"iri_pattern\", \"data_graph0\", \"sparql_op0\", \"qry0\" from (sparql select * where\n"
"{ graph ?:g_iid { gql:Map gql:schemaObjects ?gcls .\n"
"?gcls gql:rdfClass ?class ; gql:type ?class_type ; gql:mutationType ?sparql_op0 .\n"
"optional { ?gcls gql:sparqlQuery ?qry0 }\n"
"optional { ?class gql:iriPattern ?iri_pattern }\n"
"gql:Map gql:dataGraph ?data_graph0 .\n"
"filter (?gcls = iri(?:gcls_iid)) }}) dt0 do\n"
"{\n"
"if (cls is not null)\n"
"signal (\'GQGPF\', \'Not supposed to have more than one row here\');\n"
"cls := \"class\";\n"
"cls_type := \"class_type\";\n"
"iri_format := \"iri_pattern\";\n"
"data_graph := \"data_graph0\";\n"
"sparql_operation := \"sparql_op0\";\n"
"update_qry := \"qry0\";\n"
"}\n"
"if (parent is not null and cls is null)\n"
"return;\n"
"if (cls is null)\n"
"signal (\'GQL0U\', sprintf (\'Can not find class for field \"%s\"\', var_name_only));\n"
"cls_type := iri_split (cls_type, null, 0, 1);\n"
"if (cls_type = \'Function\' and update_qry is null)\n"
"signal (\'GQL3U\', sprintf (\'SPARQL query for field \"%s\" is not specified\', var_name_only));\n"
"if (cls_type <> \'Function\' and (not gql_args (args) or not length (args)))\n"
"signal (\'GQL6U\', sprintf (\'Implicit mutation `%s` requires arguments\', var_name_only));\n"
"dict_put (dict, var_name, cls_type);\n"
"parent := vector (iri_to_id (cls), var_name, null);\n"
"}\n"
"if (gql_args (args))\n"
"{\n"
"declare pos int;\n"
"declare arg_name, arg_value, id_prop, id_field, id_iri, triples_vec, params any;\n"
"declare arg_iid, fld_iid iri_id_8;\n"
"vectorbld_init (params);\n"
"vectorbld_init (triples_vec);\n"
"fld_iid := GQL_IID (var_name_only);\n"
"id_prop := id_field := null;\n"
"for select \"prop0\", \"field0\" from (sparql select ?prop0 ?field0\n"
"where { graph ?:g_iid { ?prop0 rdfs:domain `iri(?:cls)` ; gql:type gql:ID ; gql:field ?field0 . }}) dt0 do\n"
"{\n"
"if (id_prop is not null)\n"
"signal (\'GQL4U\', sprintf (\'Duplicate ID property `%s` for field \"%s\"\', \"prop0\", var_name_only));\n"
"id_prop := \"prop0\";\n"
"id_field := iri_split (\"field0\", null, 0, 1);\n"
"}\n"
"if (id_prop is null)\n"
"signal (\'GQL5U\', sprintf (\'Can not find ID property for field \"%s\"\', var_name_only));\n"
"args := args[1];\n"
"if (not (pos := position (id_field, args)))\n"
"signal (\'GQL7U\', sprintf (\'The ID argument for field \"%s\" not given\', var_name_only));\n"
"\n"
"if (iri_format is null and id_field <> \'iri\')\n"
"signal (\'GQL2U\', sprintf (\'IRI format to create instances of class `%s` with values of argument `%s` is not specified.\',\n"
"cls, id_field));\n"
"\n"
"if (id_field = \'iri\')\n"
"id_iri := GQL_VALUE (variables, args[pos], \'RAW\');\n"
"else\n"
"id_iri := sprintf (iri_format, GQL_VALUE (variables, args[pos], \'RAW\'));\n"
"__box_flags_set (id_iri, 1);\n"
"for select \"event\"\n"
"from (sparql define input:storage \"\" define output:valmode \"LONG\" select ?event\n"
"where { graph ?:g_iid { gql:Map gql:schemaObjects ?gql_object .\n"
"?gql_object gql:event ?event .\n"
"filter (?gql_object = ?:gcls_iid)\n"
"}}) dt1 do\n"
"{\n"
"vectorbld_acc (events, vector (vector (\"event\", iri_to_id (id_iri))));\n"
"}\n"
"if (cls_type <> \'Function\')\n"
"{\n"
"vectorbld_acc (triples_vec, vector (id_iri, rdf_ns_type_iri(), __box_flags_tweak (cls, 1), id_field, GQL_XSD_IRI (\'anyURI\'), \'ID\'));\n"
"}\n"
"for (j := 0; j < length(args); j := j + 2)\n"
"{\n"
"declare arg_dt varchar;\n"
"declare cast_value any;\n"
"arg_name := args[j];\n"
"arg_value := args[j + 1];\n"
"if (gql_var (arg_value))\n"
"arg_value := get_keyword (arg_value[1], variables, NULL);\n"
"arg_iid := GQL_IID (arg_name);\n"
"prop := null;\n"
"\n"
"GQL_DEBUG (pldbg_last_line (),sprintf (concat (\'sparql select * where { graph <%s> \',\n"
"\' { ?prop0 rdfs:domain <%s> ; gql:type ?tp0 ; gql:field <%s> . \',\n"
"\'  optional {  [] rdfs:domain <%s>  ; rdfs:range ?range ; gql:field <%s> . \',\n"
"\'  ?prop1 rdfs:domain ?range ; gql:field <%s> . } }}\'),\n"
"id_to_iri (g_iid), id_to_iri (cls), id_to_iri(arg_iid), id_to_iri (cls), id_to_iri(fld_iid), id_to_iri(arg_iid) ));\n"
"\n"
"for select \"prop0\", \"prop1\", \"tp0\", \"rangeType0\", \"rangeType1\"\n"
"from (sparql select ?prop0 ?prop1 ?tp0 ?rangeType0 ?rangeType1\n"
"where { graph ?:g_iid {\n"
"?prop0 rdfs:domain `iri(?:cls)` ; gql:type ?tp0 ; gql:field ?:arg_iid ; rdfs:range ?rangeType0 .\n"
"optional {  [] rdfs:domain `iri(?:cls)`  ; rdfs:range ?range ; gql:field ?:fld_iid .\n"
"?prop1 rdfs:domain ?range ; gql:field ?:arg_iid ; rdfs:range ?rangeType1 .\n"
"}\n"
"}}) dt0 do\n"
"{\n"
"arg_dt := coalesce (\"rangeType1\", \"rangeType0\");\n"
"prop := coalesce (\"prop1\", \"prop0\");\n"
"tp := iri_split (\"tp0\", null, 0, 1);\n"
"}\n"
"if (prop is null)\n"
"signal (\'GQL1U\', sprintf (\'Can not find property for argument \"%s\"\', arg_name));\n"
"if (arg_dt is null)\n"
"signal (\'GQL8U\', sprintf (\'Property `%s` for argument `%s` must have a rdfs:range\', prop, arg_name));\n"
"if (cls_type = \'Function\')\n"
"{\n"
"cast_value := GQL_VALUE (variables, arg_value, \'RAW\', arg_dt);\n"
"vectorbld_concat_acc (params, vector (concat (\':\', arg_name), cast_value));\n"
"}\n"
"else if (arg_name <> \'iri\')\n"
"{\n"
"arg_name := concat (prefix, var_name_only, \'·\', arg_name);\n"
"cast_value := GQL_ARG_INSERT_CAST (g_iid, variables, arg_value, tp, arg_dt);\n"
"__box_flags_set (prop, 1);\n"
"vectorbld_acc (triples_vec, vector (id_iri, prop, cast_value, arg_name, arg_dt, tp));\n"
"}\n"
"}\n"
"if (cls_type = \'Function\')\n"
"{\n"
"declare meta any;\n"
"vectorbld_concat_acc (params, vector (\':ID\', id_iri));\n"
"if (__tag (update_qry) = __tag of rdf_box)\n"
"update_qry := rdf_box_data (update_qry);\n"
"update_qry := concat (\'SPARQL \', update_qry);\n"
"exec_metadata (update_qry, null, null, null, meta);\n"
"foreach (varchar parm in meta) do\n"
"{\n"
"if (1 > position (parm, params))\n"
"vectorbld_concat_acc (params, vector (parm, null));\n"
"}\n"
"http (update_qry, triples);\n"
"http (\';\', triples);\n"
"}\n"
"else\n"
"{\n"
"vectorbld_final (triples_vec);\n"
"GQL_BUILD_SPARUL (data_graph, sparql_operation, triples_vec, triples);\n"
"if (sparql_operation = \'UPDATE\')\n"
"{\n"
"vectorbld_acc (upd_params, vector ());\n"
"}\n"
"}\n"
"vectorbld_final (params);\n"
"vectorbld_acc (upd_params, params);\n"
"}\n"
"if (isvector (tree))\n"
"GQL_UPDATE (g_iid, tree, variables, parent, triples, upd_params, dict, events);\n"
"}\n"
"else if (length (tree) and isvector (tree[0]))\n"
"{\n"
"for (i := 0; i < length(tree); i := i + 1)\n"
"{\n"
"elm := tree[i];\n"
"GQL_UPDATE (g_iid, elm, variables, parent, triples, upd_params, dict, events);\n"
"}\n"
"}\n"
"return;\n"
"}\n"
"--src graphql.sql:1218\n"
;

static const char *proc24 = 
"#line 1423 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_PRINT_TRIPLE_OR_PATTERN (inout env any, inout ses any, inout triple any, in what int)\n"
"{\n"
"if (what = 0)\n"
"{\n"
"declare obj any;\n"
"obj := aref_set_0 (triple, 2);\n"
"if (isvector (obj))\n"
"{\n"
"declare bn_iid iri_id_8;\n"
"if (not length (obj))\n"
"signal (\'GQTO4\', \'Empty objects are not allowed for insert/update\');\n"
"bn_iid := obj[0][0];\n"
"if (bn_iid is null)\n"
"bn_iid := iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\'));\n"
"foreach (any ntrip in obj) do\n"
"{\n"
"if (bn_iid is not null)\n"
"aset (ntrip, 0, bn_iid);\n"
"GQL_PRINT_TRIPLE_OR_PATTERN (env, ses, ntrip, 0);\n"
"}\n"
"http_nt_triple (env, triple[0], triple[1], bn_iid, ses);\n"
"}\n"
"else\n"
"http_nt_triple (env, triple[0], triple[1], obj, ses);\n"
"return;\n"
"}\n"
"else if (what = 1)\n"
"{\n"
"declare gqt, dt varchar;\n"
"dt := triple[4];\n"
"gqt := triple[5];\n"
"if (__box_flags (triple[2]) = 1 and gqt = \'ID\')\n"
"http_nt_triple (env, triple[0], triple[1], triple[2], ses);\n"
"else\n"
"http (sprintf (\' <%s> <%s> ?%s . \\n\', triple[0], triple[1], triple[3]), ses);\n"
"return;\n"
"}\n"
"signal (\'GQLFA\', sprintf (\'Unexpected call to `%s` with mode `%U`\', current_proc_name (), what));\n"
"}\n"
"--src graphql.sql:1421\n"
;

static const char *proc25 = 
"#line 1465 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_BUILD_SPARUL (inout data_graph varchar, in sparql_operation varchar, inout triples_vec any, inout ses any)\n"
"{\n"
"declare env any;\n"
"env := vector (0,0,0);\n"
"if (upper (sparql_operation) = \'UPDATE\')\n"
"{\n"
"http (sprintf (\'SPARQL WITH  <%s> \\nDELETE { \\n\', data_graph), ses);\n"
"foreach (any triple in triples_vec) do\n"
"{\n"
"if (triple[5] <> \'ID\')\n"
"GQL_PRINT_TRIPLE_OR_PATTERN (env, ses, triple, 1);\n"
"}\n"
"http (\'} \\n\', ses);\n"
"http (\' WHERE { \\n\', ses);\n"
"foreach (any triple in triples_vec) do\n"
"{\n"
"GQL_PRINT_TRIPLE_OR_PATTERN (env, ses, triple, 1);\n"
"}\n"
"http (\'};\\n\', ses);\n"
"sparql_operation := \'INSERT\';\n"
"}\n"
"\n"
"http (sprintf (\'SPARQL WITH  <%s> \\n%s { \\n\', data_graph, sparql_operation), ses);\n"
"foreach (any triple in triples_vec) do\n"
"{\n"
"GQL_PRINT_TRIPLE_OR_PATTERN (env, ses, triple, 0);\n"
"}\n"
"if (upper (sparql_operation) = \'DELETE\' and length (triples_vec) = 1 and triples_vec[0][1] = rdf_ns_type_iri())\n"
"{\n"
"declare triple0 any;\n"
"triple0 := triples_vec[0];\n"
"http (sprintf (\' <%s> ?pred ?obj . \\n\', triple0[0]), ses);\n"
"http (\'} \\n WHERE { \\n\', ses);\n"
"http (sprintf (\' <%s> a <%s> ; \\n ?pred ?obj . \\n\', triple0[0], triple0[2]), ses);\n"
"}\n"
"http (\'};\\n\', ses);\n"
"}\n"
"--src graphql.sql:1463\n"
;

static const char *proc26 = 
"#line 1505 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_ERROR (in ses any, in code varchar, in message varchar, in details varchar, in is_http int := 1)\n"
"{\n"
"declare error, error_text varchar;\n"
"declare lines any;\n"
"declare line_no int;\n"
"error := regexp_match (\'GQL01: GRAPHQL parser failed:.* at line ([0-9]+)\', message);\n"
"error_text := regexp_match (\'[^\\\\n\\\\r]*\', message);\n"
"lines := sprintf_inverse (error, \'%s line %d\', 0);\n"
"if (isvector (lines))\n"
"line_no := lines[1];\n"
"if (is_http)\n"
"http (\'{ \"errors\":\', ses);\n"
"http (\'[{\', ses);\n"
"http (\'\"message\":\"\', ses); http_escape (case when error is not null then error else error_text end, 14, ses, 1, 1); http (\'\",\', ses);\n"
"if (line_no > 0)\n"
"http (sprintf (\'\"locations\":[{\"line\":%d}],\', line_no), ses);\n"
"http (sprintf (\'\"extensions\":{\"code\":\"%s\",\"timestamp\":\"%s\"\', code, date_rfc1123(curdatetime())), ses);\n"
"if (details is not null)\n"
"{\n"
"http (sprintf (\', \"details\":\"%s\"\', details), ses);\n"
"}\n"
"if (sys_stat (\'callstack_on_exception\'))\n"
"{\n"
"http (\', \"callstack\":\"\', ses);\n"
"http_escape (message, 14, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"http (\'}}]\', ses);\n"
"if (is_http)\n"
"http (\'}\', ses);\n"
"}\n"
"--src graphql.sql:1503\n"
;

static const char *proc27 = 
"#line 1540 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_TRANSFORM (in str varchar, in g_iid varchar,\n"
"inout tree any, inout triples any, inout patterns any, inout vals any, inout clauses any, inout dict any, inout pragmas any)\n"
"{\n"
"#pragma prefix gql: <http://www.openlinksw.com/schemas/graphql#>\n"
"declare qry, inference_name, data_graph any;\n"
"qry := string_output ();\n"
"if (length (triples) < 1)\n"
"signal (\'GQLEX\', \'The query not generates any statements\');\n"
"\n"
"inference_name := (sparql select ?inference_name where { graph ?:g_iid { gql:Map gql:inferenceName ?inference_name }});\n"
"if (inference_name is not null)\n"
"http (sprintf (\'define input:inference \"%s\" \', inference_name), qry);\n"
"\n"
"data_graph := (sparql select ?data_graph where { graph ?:g_iid { gql:Map gql:dataGraph ?data_graph }});\n"
"if (data_graph is not null)\n"
"http (sprintf (\'define input:default-graph-uri \"%s\" \\n\', data_graph), qry);\n"
"http (pragmas, qry);\n"
"http (\'define output:format \"_UDBC_\" \\n\', qry);\n"
"http (\'PREFIX : <#> \\n\', qry);\n"
"http (\'CONSTRUCT { \\n\', qry);\n"
"http (triples, qry);\n"
"http (\'} \\n\', qry);\n"
"http (sprintf (\'WHERE { \\n\'), qry);\n"
"http (patterns, qry);\n"
"http (vals, qry);\n"
"http (\'}\', qry);\n"
"http (\'\\n\', qry);\n"
"http (clauses, qry);\n"
"return string_output_string (qry);\n"
"}\n"
"--src graphql.sql:1538\n"
;

static const char *proc28 = 
"#line 1573 \"[executable]/graphql.sql\"\n"
"create function GQL_RDF_NIL() returns IRI_ID_8\n"
"{\n"
"return iri_to_id (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#nil\');\n"
"}\n"
"--src graphql.sql:1571\n"
;

static const char *proc29 = 
"#line 1586 \"[executable]/graphql.sql\"\n"
"create procedure GQL_PREPARE_JSON_TREE (inout tree any, inout dict any, inout rset any)\n"
"{\n"
"declare row_no, len, inx int;\n"
"declare vect any;\n"
"\n"
"if (not isvector(rset))\n"
"signal (\'GQLX9\', \'No results returned, report statement\');\n"
"\n"
"len := length (rset);\n"
"vectorbld_init (vect);\n"
"for (row_no := 0; row_no < len; row_no := row_no + 1)\n"
"{\n"
"declare s, p, o varchar;\n"
"declare sp, spo, rw any;\n"
"declare pos int;\n"
"rw := aref_set_0 (rset, row_no);\n"
"s := aref_set_0 (rw, 0);\n"
"s := iri_to_id (s);\n"
"p := aref_set_0 (rw, 1);\n"
"o := aref_set_0 (rw, 2);\n"
"if (1 = __box_flags (o))\n"
"o := iri_to_id (o);\n"
"if (o = GQL_RDF_NIL())\n"
"o := null;\n"
"sp := composite (s, iri_to_id (p));\n"
"if (0 = (pos := position (sp, vect)))\n"
"{\n"
"vectorbld_init (spo);\n"
"vectorbld_concat_acc (spo, vector (o));\n"
"vectorbld_concat_acc (vect, vector (sp, spo));\n"
"}\n"
"else\n"
"{\n"
"spo := aref_set_0 (vect, pos);\n"
"vectorbld_concat_acc (spo, vector (o));\n"
"aset_zap_arg (vect, pos, spo);\n"
"}\n"
"}\n"
"vectorbld_final (vect);\n"
"len := length (vect);\n"
"for (inx := 0; inx < len; inx := inx + 2)\n"
"{\n"
"declare spo any;\n"
"spo := aref_set_0 (vect, inx+1);\n"
"vectorbld_final (spo);\n"
"aset_zap_arg (vect, inx+1, spo);\n"
"}\n"
"return vect;\n"
"}\n"
"--src graphql.sql:1584\n"
;

static const char *proc30 = 
"#line 1637 \"[executable]/graphql.sql\"\n"
"create function GQL_PRINT_JSON_VAL (inout val any, inout ses any)\n"
"{\n"
"http (\'\"\', ses);\n"
"if (__tag of rdf_box = __tag (val))\n"
"{\n"
"__rdf_box_make_complete (val);\n"
"val := rdf_box_data (val);\n"
"}\n"
"if (isiri_id (val))\n"
"val := id_to_iri (val);\n"
"if (__tag of datetime = __tag (val))\n"
"__rdf_long_to_ttl (val, ses);\n"
"else\n"
"http_escape (val, 14, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"--src graphql.sql:1635\n"
;

static const char *proc31 = 
"#line 1655 \"[executable]/graphql.sql\"\n"
"create procedure GQL_SERIALIZE_TREE_INT (inout ses any, inout jt any, in tree any, inout dict any, in parent any, in pval any)\n"
"{\n"
"declare i, rc int;\n"
"declare elm, args any;\n"
"declare var_name, var_name_only varchar;\n"
"\n"
"rc := 1;\n"
"if (not isvector (tree))\n"
"{\n"
"signal (\'GQLE0\', \'Serialize called with scalar\');\n"
"return rc;\n"
"}\n"
"if (gql_field (tree))\n"
"{\n"
"declare is_array int;\n"
"declare cls, prop, tp, parent_name, parent_cls, prefix, value, alias varchar;\n"
"declare sp, spo any;\n"
"\n"
"parent_cls := cls := null;\n"
"is_array := 0;\n"
"alias := tree[4];\n"
"\n"
"if (parent is not null)\n"
"{\n"
"parent_name := parent;\n"
"prefix := parent_name || \'·\';\n"
"}\n"
"else\n"
"prefix := (case when isstring (alias) then concat (\'#\', alias, \'·\') else \'#\' end);\n"
"\n"
"var_name_only := var_name := tree[1];\n"
"if (isstring (alias))\n"
"var_name_only := alias;\n"
"tree := tree[3];\n"
"var_name := prefix || var_name;\n"
"if (isvector (tree))\n"
"{\n"
"tp := dict_get (dict, subseq (var_name, 1));\n"
"if (gqt_is_list (tp))\n"
"is_array := 1;\n"
"sp := composite (pval, iri_to_id (var_name));\n"
"spo := get_keyword (sp, jt);\n"
"parent := var_name;\n"
"}\n"
"else\n"
"{\n"
"declare val any;\n"
"sp := composite (pval, iri_to_id (var_name));\n"
"tp := dict_get (dict, subseq (var_name, 1));\n"
"spo := get_keyword (sp, jt);\n"
"\n"
"if (spo is null and gqt_not_null(tp))\n"
"{\n"
"rc := 0;\n"
"goto skip_non_null_scalar;\n"
"}\n"
"\n"
"if (spo is null)\n"
"http (sprintf (\'\"%s\":%s\', var_name_only, (case when tp = \'Boolean\' then \'false\' else \'null\' end)), ses);\n"
"else if (isvector (spo) and gqt_is_list (tp))\n"
"{\n"
"http (sprintf (\'\"%s\":\', var_name_only), ses);\n"
"http (\'[\', ses);\n"
"for (i := 0; i < length(spo); i := i + 1)\n"
"{\n"
"val := spo[i];\n"
"if (i > 0)\n"
"http (\',\', ses);\n"
"GQL_PRINT_JSON_VAL (val, ses);\n"
"}\n"
"http (\']\', ses);\n"
"}\n"
"else\n"
"{\n"
"declare dt any;\n"
"val := spo[0];\n"
"\n"
"if (val is null and gqt_not_null(tp))\n"
"{\n"
"rc := 0;\n"
"goto skip_non_null_scalar;\n"
"}\n"
"\n"
"if (__tag of rdf_box = __tag (val))\n"
"dt := rdf_cache_id_to_name (\'t\', rdf_box_type (val));\n"
"if (dt <> 0 and dt = \'http://www.w3.org/2001/XMLSchema#boolean\')\n"
"http (sprintf (\'\"%s\":%s\', var_name_only, (case val when 0 then \'false\' else \'true\' end)), ses);\n"
"else if (val is null)\n"
"http (sprintf (\'\"%s\":null\', var_name_only), ses);\n"
"else if (isfinitenumeric (val))\n"
"http (sprintf (\'\"%s\":%s\', var_name_only, DB.DBA.SYS_SQL_VAL_PRINT (val)), ses);\n"
"else\n"
"{\n"
"http (sprintf (\'\"%s\":\', var_name_only), ses);\n"
"GQL_PRINT_JSON_VAL (val, ses);\n"
"}\n"
"}\n"
"skip_non_null_scalar:;\n"
"}\n"
"\n"
"if (isvector (tree))\n"
"{\n"
"declare is_null_obj int;\n"
"is_null_obj := (case when ((length (spo) = 1 and isnull(spo[0]) or spo is null)) then 1 else 0 end);\n"
"\n"
"if (is_null_obj and gqt_not_null (tp))\n"
"{\n"
"rc := 0;\n"
"goto skip_non_null_obj;\n"
"}\n"
"\n"
"http (sprintf (\'\"%s\":\', var_name_only), ses);\n"
"if (is_null_obj)\n"
"{\n"
"if (is_array)\n"
"http (\'[]\', ses);\n"
"else\n"
"http (\'null\', ses);\n"
"}\n"
"else\n"
"{\n"
"if (is_array) http (\'[\', ses);\n"
"if (not is_array and length (spo) > 1)\n"
"signal (\'GQLSZ\', sprintf (\'An array of values is returned for `%s` defined as `%s`\', var_name, tp));\n"
"for (i := 0; i < length(spo); i := i + 1)\n"
"{\n"
"if (i > 0)\n"
"http (\',\', ses);\n"
"http (\'{\', ses);\n"
"GQL_SERIALIZE_TREE_INT (ses, jt, tree, dict, parent, spo[i]);\n"
"http (\'}\', ses);\n"
"}\n"
"if (is_array) http (\']\', ses);\n"
"}\n"
"skip_non_null_obj:;\n"
"}\n"
"}\n"
"else if (length (tree) and isvector (tree[0]))\n"
"{\n"
"declare printc int;\n"
"for (i := 0; i < length(tree); i := i + 1)\n"
"{\n"
"elm := tree[i];\n"
"if (printc and i > 0)\n"
"http (\',\', ses);\n"
"printc := GQL_SERIALIZE_TREE_INT (ses, jt, elm, dict, parent, pval);\n"
"}\n"
"}\n"
"return rc;\n"
"}\n"
"--src graphql.sql:1653\n"
;

static const char *proc32 = 
"#line 1807 \"[executable]/graphql.sql\"\n"
"create procedure GQL_JSON_SERIALIZE_TREE (inout jt any, inout tree any, inout dict any)\n"
"{\n"
"declare ses any;\n"
"declare parent varchar;\n"
"\n"
"parent := null;\n"
"ses := string_output ();\n"
"http (\'{\"data\":{\',ses);\n"
"GQL_SERIALIZE_TREE_INT (ses, jt, tree, dict, parent, iri_to_id (\'#data\'));\n"
"http (\'}}\',ses);\n"
"return ses;\n"
"}\n"
"--src graphql.sql:1805\n"
;

static const char *tbl0 = 
"create table DB.DBA.GQL_CACHE (GC_ID varchar primary key, GC_TS timestamp, GC_QUERY long varchar, GC_VARS any, GC_RESULT long varchar) if not exists\n";

static const char *proc33 = 
"#line 1824 \"[executable]/graphql.sql\"\n"
"create procedure GQL_CACHE_CHECK (inout g_iid iri_id_8, inout qry varchar, inout variables any, in id varchar)\n"
"{\n"
"declare ses any;\n"
"if (g_iid <> GQL_SCH_IID ())\n"
"return NULL;\n"
"if (id is null)\n"
"id := bin2hex (xenc_digest (concat (qry, serialize (variables)), \'sha256\'));\n"
"for select GC_RESULT from DB.DBA.GQL_CACHE where GC_ID = id do\n"
"{\n"
"ses := string_output ();\n"
"http (GC_RESULT, ses);\n"
"return ses;\n"
"}\n"
"return NULL;\n"
"}\n"
"--src graphql.sql:1822\n"
;

static const char *proc34 = 
"#line 1841 \"[executable]/graphql.sql\"\n"
"create procedure GQL_CACHE_STORE (inout g_iid iri_id_8, inout qry varchar, inout ses any, inout variables any, in id varchar)\n"
"{\n"
"if (g_iid <> GQL_SCH_IID ())\n"
"return;\n"
"if (id is null)\n"
"id := bin2hex (xenc_digest (concat (qry, serialize (variables)), \'sha256\'));\n"
"insert into DB.DBA.GQL_CACHE (GC_ID, GC_QUERY, GC_RESULT, GC_VARS) values (id, qry, ses, variables);\n"
"commit work;\n"
"}\n"
"--src graphql.sql:1839\n"
;

static const char *proc35 = 
"#line 1852 \"[executable]/graphql.sql\"\n"
"create procedure GQL_CACHE_ENABLE (in enable int)\n"
"{\n"
"if (enable)\n"
"{\n"
"registry_set (\'graphql-use-cache\',\'1\');\n"
"}\n"
"else\n"
"{\n"
"registry_set (\'graphql-use-cache\',\'0\');\n"
"delete from DB.DBA.GQL_CACHE;\n"
"commit work;\n"
"}\n"
"}\n"
"--src graphql.sql:1850\n"
;

static const char *proc36 = 
"#line 1867 \"[executable]/graphql.sql\"\n"
"create procedure GQL_DATA_GRAPH_SIGNATURE (in g_iid iri_id_8, in digest varchar := \'sha1\')\n"
"{\n"
"declare ses, graph_iid any;\n"
"ses := string_output ();\n"
"graph_iid := (sparql define input:storage \"\" define output:valmode \"LONG\" select ?g where { graph ?:g_iid { gql:Map gql:dataGraph ?g }});\n"
"\n"
"for select concat (__ro2sq (S), __ro2sq (P), __ro2sq(O)) as sig from DB.DBA.RDF_QUAD table option (index G) where G = graph_iid order by S,P,O do\n"
"{\n"
"http (sig, ses);\n"
"}\n"
"return xenc_digest (string_output_string (ses), digest);\n"
"}\n"
"--src graphql.sql:1865\n"
;

static const char *proc37 = 
"#line 1881 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_DISPATCH (in str varchar, in variables any, in g_iri varchar, in transform_only int := 0,\n"
"in use_cache int := 0, in timeout int := 0, in operation_name varchar := null)\n"
"{\n"
"declare qry, ses, tree, triples, patterns, vals, clauses, updates, events, pragmas, g_iid any;\n"
"declare meta, rset, dict, upd_params any;\n"
"declare json_tree any;\n"
"declare etag varchar;\n"
"\n"
"connection_set (\'__intro\', 0);\n"
"etag := null;\n"
"g_iid := iri_to_id (g_iri);\n"
"dict := dict_new (31);\n"
"pragmas := \'\';\n"
"GQL_PARSE_REQUEST (str, variables, g_iid, tree, triples, patterns, vals, clauses, updates, upd_params, dict, operation_name, events, pragmas);\n"
"qry := GQL_TRANSFORM (str, g_iid, tree, triples, patterns, vals, clauses, dict, pragmas);\n"
"if (transform_only = 2)\n"
"return updates;\n"
"if (transform_only)\n"
"return qry;\n"
"if (use_cache and g_iid = GQL_SCH_IID () and is_http_ctx ())\n"
"{\n"
"declare intro_sha1, client_etag varchar;\n"
"\n"
"intro_sha1 := GQL_DATA_GRAPH_SIGNATURE (g_iid);\n"
"etag := encode_base64url (xenc_digest (concat (str, serialize (variables), intro_sha1),\'sha1\'));\n"
"client_etag := trim (http_request_header (http_request_header (), \'If-None-Match\', null, \'\'), \'\"\');\n"
"http_header (concat (http_header_get (), sprintf (\'ETag: \"%s\"\\r\\n\', etag)));\n"
"if (client_etag = etag)\n"
"{\n"
"http_status_set (304);\n"
"return \'\';\n"
"}\n"
"}\n"
"if (use_cache)\n"
"{\n"
"ses := GQL_CACHE_CHECK (g_iid, str, variables, etag);\n"
"if (ses is not null)\n"
"return ses;\n"
"}\n"
"GQL_EXEC_UPDATES (updates, upd_params, events);\n"
"GQL_EXEC (tree, qry, meta, rset, timeout);\n"
"json_tree := GQL_PREPARE_JSON_TREE (tree, dict, rset);\n"
"ses := GQL_JSON_SERIALIZE_TREE (json_tree, tree, dict);\n"
"if (use_cache)\n"
"{\n"
"GQL_CACHE_STORE (g_iid, str, ses, variables, etag);\n"
"}\n"
"return ses;\n"
"}\n"
"--src graphql.sql:1879\n"
;

static const char *proc38 = 
"#line 1933 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GRAPHQL.GRAPHQL.auth (in path any, in params any, in lines any) __SOAP_HTTP \'application/json\'\n"
"{\n"
"return \'{\"error\":\"Unauthorized\"}\';\n"
"}\n"
"--src graphql.sql:1931\n"
;

static const char *proc39 = 
"#line 1940 \"[executable]/graphql.sql\"\n"
"create procedure GQL_IS_WSOCK_REQUEST (in lines any)\n"
"{\n"
"if (\'upgrade\' = lower (http_request_header (lines, \'Connection\', null, null)) and\n"
"\'websocket\' = http_request_header (lines, \'Upgrade\', null, null) and\n"
"not isnull (__proc_exists (\'WSOCK.DBA.websockets\')))\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src graphql.sql:1938\n"
;

static const char *proc40 = 
"#line 1950 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GRAPHQL.GRAPHQL.query (in query varchar := NULL, in variables varchar := null, in timeout int := 0, in debug int := 0) __SOAP_HTTP \'application/json\'\n"
"{\n"
"declare content_type, g_iri varchar;\n"
"declare lines any;\n"
"declare error_details, operation_name varchar;\n"
"\n"
"lines := http_request_header ();\n"
"if (GQL_IS_WSOCK_REQUEST (lines))\n"
"return WSOCK.DBA.\"websockets\" ();\n"
"declare exit handler for sqlstate \'*\' {\n"
"rollback work;\n"
"error_details := null;\n"
"if (__SQL_MESSAGE like \'%:SECURITY:%\' or __SQL_MESSAGE like \'RPERM:%\')\n"
"{\n"
"if (not (is_https_ctx()))\n"
"error_details := \'The connection is unsecure, please consider using HTTPS.\';\n"
"http_status_set (401);\n"
"}\n"
"else\n"
"{\n"
"if (__SQL_STATE = \'GQLSX\')\n"
"http_status_set (409);\n"
"else\n"
"http_status_set (400);\n"
"}\n"
"GQL_ERROR (null, __SQL_STATE, __SQL_MESSAGE, error_details);\n"
"return \'\';\n"
"};\n"
"if (http_request_get (\'REQUEST_METHOD\') = \'OPTIONS\')\n"
"{\n"
"http_status_set (200);\n"
"return \'\';\n"
"}\n"
"content_type := http_request_header (lines, \'Content-Type\', null, \'application/octet-stream\');\n"
"debug := coalesce (atoi (http_request_header (lines, \'X-Debug\', null, null)), debug);\n"
"operation_name := null;\n"
"if (query is null)\n"
"{\n"
"declare jt any;\n"
"query := string_output_string (http_body_read ());\n"
"if (not length (query))\n"
"signal (\'GQLIN\', \'POST body is missing\');\n"
"if (content_type <> \'application/json\')\n"
"{\n"
"http_status_set (400);\n"
"return \'Content-Type is not specified or query is not supplied\';\n"
"}\n"
"jt := json_parse (query);\n"
"query := get_keyword (\'query\', jt, NULL);\n"
"if (variables is null)\n"
"variables := get_keyword (\'variables\', jt, NULL);\n"
"operation_name := get_keyword (\'operationName\', jt, NULL);\n"
"}\n"
"if (not length (query))\n"
"signal (\'GQLIQ\', \'Query is missing.\');\n"
"set_qualifier (\'DB\');\n"
"\n"
"g_iri := registry_get (\'graphql-default-schema-uri\', \'urn:graphql:default\');\n"
"if (atoi(registry_get (\'graphql-debug-enable\', \'0\')) = 0)\n"
"debug := 0;\n"
"if (debug)\n"
"http_header (\'Content-Type: text/plain\\r\\n\');\n"
"http (GQL_DISPATCH (query, variables, g_iri, debug, atoi (registry_get (\'graphql-use-cache\', \'0\')), timeout, operation_name));\n"
"return \'\';\n"
"}\n"
"--src graphql.sql:1948\n"
;

static const char *proc41 = 
"#line 2018 \"[executable]/graphql.sql\"\n"
"create procedure DB.DBA.HP_AUTH_GRAPHQL_USER (in realm varchar)\n"
"{\n"
"declare val_serviceId, val_sid, val_realm, val_uname, val_webidGraph varchar;\n"
"declare val_isRealUser integer;\n"
"declare val_cert any;\n"
"val_realm := null;\n"
"if (VAD_CHECK_VERSION (\'VAL\') is not null)\n"
"{\n"
"val_webidGraph := concat (\'urn:gql:auth:\', uuid());\n"
"VAL.DBA.get_authentication_details_for_connection (\n"
"sid=>val_sid,\n"
"serviceId=>val_serviceId,\n"
"uname=>val_uname,\n"
"isRealUser=>val_isRealUser,\n"
"realm=>val_realm,\n"
"cert=>val_cert,\n"
"webidGraph=>val_webidGraph);\n"
"sparql clear graph ?:val_webidGraph;\n"
"if (not VAL.DBA.is_admin_user (val_uname) and sys_stat (\'enable_g_in_sec\') = 1)\n"
"{\n"
"connection_set (\'SPARQLUserId\', \'VAL_SPARQL_ADMIN_G_CTX\');\n"
"VAL.DBA.set_graph_context_query (serviceId=>val_serviceId, realm=>val_realm, certificate=>val_cert);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.HTTP_AUTH_CHECK_USER (realm, 1, 0);\n"
"}\n"
"return 1;\n"
"}\n"
"--src graphql.sql:2016\n"
;

static const char *proc42 = 
"#line 2050 \"[executable]/graphql.sql\"\n"
"create procedure GQL_INIT_USER ()\n"
"{\n"
"if (user_to_uid (\'GRAPHQL\') > 0)\n"
"{\n"
"\n"
"EXEC_STMT (\'GRANT EXECUTE ON GRAPHQL.GRAPHQL.\"query\" TO GRAPHQL\', 0);\n"
"return;\n"
"}\n"
"USER_CREATE (\'GRAPHQL\', sha1_digest (uuid ()), vector (\'DISABLED\', 1, \'LOGIN_QUALIFIER\', \'GRAPHQL\'));\n"
"EXEC_STMT (\'GRANT EXECUTE ON GRAPHQL.GRAPHQL.\"query\" TO GRAPHQL\', 0);\n"
"EXEC_STMT (\'GRANT SPARQL_SELECT to GRAPHQL\', 0);\n"
"}\n"
"--src graphql.sql:2048\n"
;

static const char *other2 = 
"GQL_INIT_USER()\n";
static const char *other3 = 
"DB.DBA.ADD_DEFAULT_VHOST (\n"
"lpath=>\'/graphql\',\n"
"ppath=>\'/SOAP/Http/query\',\n"
"soap_user=>\'GRAPHQL\',\n"
"auth_fn=>\'DB.DBA.HP_AUTH_GRAPHQL_USER\',\n"
"realm=>\'GraphQL\',\n"
"opts=>vector (\'cors\',\'*\',\'cors_allow_headers\', \'*\',\n"
"\'websocket_service_call\', \'DB.DBA.GQL_SUBSCRIBE\', \'websocket_service_connect\', \'DB.DBA.GQL_WS_CONNECT\'),\n"
"overwrite=>1\n"
")\n";
static const char *other4 = 
"DB.DBA.VHOST_REMOVE (lpath=>\'/graphql\')\n";
static const char *other5 = 
"DB.DBA.VHOST_DEFINE (lpath=>\'/graphql\', ppath=>\'/SOAP/Http/query\', soap_user=>\'GRAPHQL\',\n"
"auth_fn=>\'DB.DBA.HP_AUTH_GRAPHQL_USER\', realm=>\'GraphQL\', sec=>\'basic\',\n"
"opts=>vector (\'cors\',\'*\',\'cors_allow_headers\', \'*\',\n"
"\'websocket_service_call\', \'DB.DBA.GQL_SUBSCRIBE\', \'websocket_service_connect\', \'DB.DBA.GQL_WS_CONNECT\')\n"
")\n";
static const char *other6 = 
"DB.DBA.VHOST_REMOVE (vhost=>\'*sslini*\', lhost=>\'*sslini*\', lpath=>\'/graphql\')\n";
static const char *other7 = 
"DB.DBA.VHOST_DEFINE (vhost=>\'*sslini*\', lhost=>\'*sslini*\', lpath=>\'/graphql\', ppath=>\'/SOAP/Http/query\', soap_user=>\'GRAPHQL\',\n"
"auth_fn=>\'DB.DBA.HP_AUTH_GRAPHQL_USER\', realm=>\'GraphQL\', sec=>\'basic\',\n"
"opts=>vector (\'cors\',\'*\',\'cors_allow_headers\', \'*\')\n"
")\n";
static const char *proc43 = 
"#line 2098 \"[executable]/graphql.sql\"\n"
"create function GQL_XSD_IRI (in n varchar)\n"
"{\n"
"return concat (\'http://www.w3.org/2001/XMLSchema#\', n);\n"
"}\n"
"--src graphql.sql:2096\n"
;

static const char *proc44 = 
"#line 2104 \"[executable]/graphql.sql\"\n"
"create function GQL_OWL_IRI (in n varchar)\n"
"{\n"
"return concat (\'http://www.w3.org/2002/07/owl#\', n);\n"
"}\n"
"--src graphql.sql:2102\n"
;

static const char *proc45 = 
"#line 2110 \"[executable]/graphql.sql\"\n"
"create procedure GQL_GET_NS (inout ns_dict any, inout ns_uri any, inout ns_last int, inout ses any)\n"
"{\n"
"declare ns varchar;\n"
"ns := dict_get (ns_dict, ns_uri);\n"
"if (ns is null)\n"
"{\n"
"ns := sprintf (\'ns%d\', ns_last);\n"
"dict_put (ns_dict, ns_uri, ns);\n"
"http (sprintf (\'@prefix %s: <%s> .\\n\', ns, ns_uri), ses);\n"
"ns_last := ns_last + 1;\n"
"}\n"
"return ns;\n"
"}\n"
"--src graphql.sql:2108\n"
;

static const char *proc46 = 
"#line 2125 \"[executable]/graphql.sql\"\n"
"create procedure GQL_CREATE_TYPE_SCHEMA (in g_iri varchar)\n"
"{\n"
"declare ses, out_ses, ns_dict, class_dict, owl_classes, objects, query_dict, query_fields, typed_fields, skip, fields any;\n"
"declare ns_last int;\n"
"ns_dict := dict_new (11);\n"
"class_dict := dict_new (11);\n"
"query_dict := dict_new (11);\n"
"skip := dict_new (11);\n"
"ses := string_output ();\n"
"out_ses := string_output ();\n"
"http (\'@prefix : <http://www.openlinksw.com/schemas/graphql/intro#> . \\n\', out_ses);\n"
"http (\'@prefix gql: <http://www.openlinksw.com/schemas/graphql#> . \\n\', out_ses);\n"
"http (\'@prefix xsd: <http://www.w3.org/2001/XMLSchema#> . \\n\', out_ses);\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> . \\n\', out_ses);\n"
"http (\' \\n\', ses);\n"
"objects := dict_new (11);\n"
"fields := dict_new (11);\n"
"ns_last := 0;\n"
"for select * from (sparql define input:storage \"\"\n"
"select distinct ?gqlObject ?owlClass ?gType ?typeName where { graph `iri(?:g_iri)` {\n"
"?gqlObject gql:type ?gType ; gql:rdfClass ?owlClass .\n"
"OPTIONAL { ?owlClass gql:typeName ?typeName }\n"
"filter (?gType in (gql:Object, gql:Array)) .\n"
"}}) dt0 do\n"
"{\n"
"declare gql_object_name, owl_class_name, gql_type_name, parent_class_name, kind, ns_uri, ns, fns varchar;\n"
"declare any_field int;\n"
"gql_object_name := iri_split (\"gqlObject\", 0, 0, 1);\n"
"owl_class_name := iri_split (\"owlClass\", 0, 0, 1);\n"
"dict_put (class_dict, iri_to_id (\"owlClass\"), 1);\n"
"ns_uri := iri_split (\"owlClass\", 0);\n"
"ns := GQL_GET_NS (ns_dict, ns_uri, ns_last, out_ses);\n"
"gql_type_name := iri_split (\"gType\", 0, 0, 1);\n"
"\n"
"if (gqt_is_obj (gql_type_name))\n"
"kind := \'OBJECT\';\n"
"else if (gqt_is_list (gql_type_name))\n"
"kind := \'LIST\';\n"
"else\n"
"signal (\'GQTG0\', \'GraphQL mapping type for RDF/OWL Class must be Object or Array\');\n"
"\n"
"http (sprintf (\'%s:%s rdf:type gql:%s ;\\n\', ns, gql_object_name, gql_type_name) , ses);\n"
"http (sprintf (\'    :name \"%s\" ;\\n\', coalesce (\"typeName\", gql_object_name)), ses);\n"
"http (sprintf (\'        :kind \"OBJECT\" ;\\n\'), ses);\n"
"http (sprintf (\'        :fields %s:iri ;\\n\', ns), ses);\n"
"http (sprintf (\'        :args %s:iri ;\\n\', ns), ses);\n"
"if (kind = \'LIST\')\n"
"{\n"
"declare parent_class_iri, parent_type_name varchar;\n"
"\n"
"for select * from (sparql define input:storage \"\"\n"
"select ?parentClass where { graph `iri(?:g_iri)`\n"
"{ ?parentClass gql:type gql:Object ;\n"
"gql:rdfClass `iri(?:owlClass)` .\n"
"}}) dt do\n"
"{\n"
"parent_class_iri := \"parentClass\";\n"
"}\n"
"\n"
"parent_class_name := iri_split (parent_class_iri, 0, 0, 1);\n"
"parent_class_name := concat (ns, \':\', parent_class_name);\n"
"http (sprintf (\'    :type [ :kind \"LIST\"; :ofType %s ] ; \\n\', parent_class_name), ses);\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'    :type [ :kind \"OBJECT\" ; :name \"%s\" ; :ofType rdf:nil ] ; \\n\', coalesce (\"typeName\", gql_object_name)), ses);\n"
"}\n"
"dict_put (objects, concat (ns, \':\', gql_object_name), 1);\n"
"dict_put (query_dict, gql_object_name, vector (gql_type_name, concat (ns,\':\', gql_object_name)));\n"
"\n"
"declare fields_list, args_list varchar;\n"
"fields_list := args_list := sprintf (\'%s:iri\', ns);\n"
"for select * from (sparql define input:storage \"\"\n"
"select ?prop ?rangeType ?pGqlType ?field where { graph `iri(?:g_iri)` {\n"
"?prop rdfs:domain ?:owlClass ;\n"
"gql:field ?field  ;\n"
"rdfs:range ?rangeType ;\n"
"gql:type ?pGqlType . }}) dt0 do\n"
"{\n"
"declare field_name, gql_type, range_class, range_ns_uri varchar;\n"
"field_name := iri_split (\"field\", 0, 0, 1);\n"
"gql_type := iri_split (\"pGqlType\", 0, 0, 1);\n"
"range_class := \"rangeType\";\n"
"range_ns_uri := iri_split (range_class, 0);\n"
"ns_uri := iri_split (\"prop\", 0);\n"
"fns := GQL_GET_NS (ns_dict, ns_uri, ns_last, out_ses);\n"
"if (gqt_is_scalar (gql_type) or gql_type = \'ID\')\n"
"{\n"
"args_list := concat (args_list, sprintf (\', %s:%s\', fns, field_name));\n"
"}\n"
"else\n"
"{\n"
"if (not (sparql ask where { graph `iri(?:g_iri)` { gql:Map gql:schemaObjects ?cls . ?cls gql:rdfClass `iri(?:range_class)` . }})\n"
"and range_ns_uri <> GQL_XSD_IRI(\'\'))\n"
"{\n"
"sql_warning (\'01V01\', \'GQLW0\', sprintf (\'Ref. property %s to undefined class %s.\', \"prop\", \"rangeType\"));\n"
"dict_put (skip, \"prop\", 1);\n"
"goto skip_fld;\n"
"}\n"
"}\n"
"fields_list := concat (fields_list, sprintf (\', %s:%s\', fns, field_name));\n"
"skip_fld:;\n"
"}\n"
"\n"
"if (length (args_list))\n"
"http (sprintf (\'    :args %s ; \\n\', args_list), ses);\n"
"if (length (fields_list))\n"
"http (sprintf (\'    :fields %s ; \\n\', fields_list), ses);\n"
"\n"
"declare description_text varchar;\n"
"description_text := (sparql define input:storage \"\"\n"
"select ?description where { graph `iri(?:g_iri)` { `iri(?:owlClass)` rdfs:comment ?description }});\n"
"if (description_text is not null)\n"
"{\n"
"http (\'    :description \', ses);\n"
"GQL_PRINT_JSON_VAL (description_text, ses);\n"
"http(\';\\n\', ses);\n"
"}\n"
"http (sprintf (\'    :isDeprecated false . \\n\\n\'), ses);\n"
"http (sprintf (\'\\n\'), ses);\n"
"}\n"
"\n"
"owl_classes := dict_list_keys (class_dict, 1);\n"
"foreach (iri_id_8 owlClass in owl_classes) do\n"
"{\n"
"declare field_name, ns_uri, ns, type_def, gql_type, field_q_name varchar;\n"
"http (sprintf (\'\\n\\n\'), ses);\n"
"\n"
"ns_uri := iri_split (id_to_iri (owlClass), 0);\n"
"ns := dict_get (ns_dict, ns_uri);\n"
"ns := GQL_GET_NS (ns_dict, ns_uri, ns_last, out_ses);\n"
"http (sprintf (\'%s:iri rdf:type gql:Scalar ;\\n\', ns), ses);\n"
"http (sprintf (\'      :name \"iri\" ;\\n\'), ses);\n"
"http (sprintf (\'      :type  :IRI ;\\n\'), ses);\n"
"http (sprintf (\'    :isDeprecated false . \\n\\n\'), ses);\n"
"for select * from (sparql define input:storage \"\"\n"
"select distinct ?prop ?ptype ?rangeType ?gqlObject ?field ?pGqlType ?typeName where { graph `iri(?:g_iri)` {\n"
"?prop rdf:type ?ptype ;\n"
"rdfs:domain ?:owlClass ;\n"
"gql:field ?field  ;\n"
"rdfs:range ?rangeType ;\n"
"gql:type ?pGqlType .\n"
"OPTIONAL { ?gqlObject gql:rdfClass ?rangeType .  }\n"
"OPTIONAL { ?rangeType gql:typeName ?typeName . }\n"
"FILTER (?ptype in (owl:DatatypeProperty, owl:ObjectProperty))\n"
"}}) dt0 do\n"
"{\n"
"if (dict_get (skip, \"prop\"))\n"
"goto skip_prop;\n"
"field_name := iri_split (\"field\", 0, 0, 1);\n"
"gql_type := iri_split (\"pGqlType\", 0, 0, 1);\n"
"ns_uri := iri_split (\"prop\", 0);\n"
"ns := dict_get (ns_dict, ns_uri);\n"
"ns := GQL_GET_NS (ns_dict, ns_uri, ns_last, out_ses);\n"
"field_q_name := concat (ns,\':\',field_name);\n"
"if (dict_get (fields, field_q_name))\n"
"goto skip_prop;\n"
"dict_put (fields, field_q_name, 1);\n"
"if (\"ptype\" = GQL_OWL_IRI (\'DatatypeProperty\'))\n"
"{\n"
"if (\"rangeType\" = GQL_XSD_IRI (\'string\'))\n"
"type_def := \':String\';\n"
"if (\"rangeType\" = GQL_XSD_IRI (\'anyURI\'))\n"
"type_def := \':IRI\';\n"
"else if (\"rangeType\" = GQL_XSD_IRI (\'int\') or \"rangeType\" = GQL_XSD_IRI (\'long\'))\n"
"type_def := \':Int\';\n"
"else if (\n"
"\"rangeType\" = GQL_XSD_IRI (\'float\') or\n"
"\"rangeType\" = GQL_XSD_IRI (\'numeric\') or\n"
"\"rangeType\" = GQL_XSD_IRI (\'double\'))\n"
"type_def := \':Float\';\n"
"else if (\"rangeType\" = GQL_XSD_IRI (\'boolean\'))\n"
"type_def := \':Boolean\';\n"
"else if (\"rangeType\" in (GQL_XSD_IRI (\'date\'), GQL_XSD_IRI (\'dateTime\'), GQL_XSD_IRI (\'time\')))\n"
"type_def := \':DateTime\';\n"
"else\n"
"type_def := \':String\';\n"
"\n"
"if (gql_type = \'ID\')\n"
"type_def := sprintf (\'[ :kind \"NON_NULL\" ; :ofType %s ]\', type_def);\n"
"\n"
"http (sprintf (\'%s rdf:type gql:Scalar ;\\n\', field_q_name), ses);\n"
"\n"
"if (gqt_is_list (gql_type))\n"
"http (sprintf (\'    :type [ :kind \"LIST\" ; :ofType %s ] ;\\n\', type_def), ses);\n"
"else\n"
"http (sprintf (\'      :type %s ;\\n\', type_def), ses);\n"
"\n"
"http (sprintf (\'    :name \"%s\" ;\\n\', field_name), ses);\n"
"http (sprintf (\'    :isDeprecated false . \\n\'), ses);\n"
"}\n"
"else if (\"ptype\" = GQL_OWL_IRI (\'ObjectProperty\'))\n"
"{\n"
"declare gql_type_name, gns varchar;\n"
"if (gql_type not in (\'Object\', \'Array\'))\n"
"signal (\'GQTG1\', \'ObjectProperty must be of type Object or Array.\');\n"
"if (\"gqlObject\" is null)\n"
"signal (\'GQTG3\', \'Mapping between object property range class and gql Type is missing.\');\n"
"\n"
"gql_type_name := iri_split (\"gqlObject\", 0, 0, 1);\n"
"ns_uri := iri_split (\"rangeType\", 0);\n"
"gns := GQL_GET_NS (ns_dict, ns_uri, ns_last, out_ses);\n"
"\n"
"http (sprintf (\'%s rdf:type gql:%s ;\\n\', field_q_name, gql_type), ses);\n"
"http (sprintf (\'      :name \"%s\" ;\\n\', field_name), ses);\n"
"http (sprintf (\'      :kind \"OBJECT\" ;\\n\'), ses);\n"
"if (gqt_is_obj (gql_type))\n"
"http (sprintf (\'    :type %s:%s .\\n\', gns, gql_type_name), ses);\n"
"else\n"
"http (sprintf (\'    :type [ :kind \"LIST\" ; :ofType %s:%s ] .\\n\\n\', gns, gql_type_name), ses);\n"
"}\n"
"else\n"
"signal (\'GQTG2\', \'fields must be mapped to ObjectProperty or DatatypeProperty\');\n"
"skip_prop:;\n"
"}\n"
"}\n"
"typed_fields := dict_list_keys (objects, 1);\n"
"if (length (typed_fields))\n"
"{\n"
"declare any_field int;\n"
"http (\':__schema :types \', ses);\n"
"any_field := 0;\n"
"foreach (varchar fld in typed_fields) do\n"
"{\n"
"any_field := any_field + 1;\n"
"if (any_field > 1)\n"
"http (\',\', ses);\n"
"http (sprintf (\' %s\', fld), ses);\n"
"}\n"
"http (\'.\\n\', ses);\n"
"}\n"
"\n"
"declare any_query_field int;\n"
"any_query_field := 0;\n"
"for select * from (sparql define input:storage \"\"\n"
"select distinct ?gqlObject ?owlClass ?gType  where { graph `iri(?:g_iri)` {\n"
"gql:Map gql:queryObjects ?gqlObject .\n"
"?gqlObject gql:type ?gType ; gql:rdfClass ?owlClass .\n"
"filter (?gType in (gql:Object, gql:Array)) .\n"
"}}) dt0 do\n"
"{\n"
"declare gql_object_name, owl_class_name, gql_type_name, parent_class_name, kind, ns_uri, ns, fns varchar;\n"
"gql_object_name := iri_split (\"gqlObject\", 0, 0, 1);\n"
"owl_class_name := iri_split (\"owlClass\", 0, 0, 1);\n"
"gql_type_name := iri_split (\"gType\", 0, 0, 1);\n"
"ns_uri := iri_split (\"owlClass\", 0);\n"
"ns := GQL_GET_NS (ns_dict, ns_uri, ns_last, out_ses);\n"
"\n"
"if (gqt_is_list (gql_type_name))\n"
"http (sprintf (\':Query :fields [ :name \"%s\" ; :type [ :kind \"LIST\" ; :ofType %s:%s ] ] .\\n\', gql_object_name, ns, gql_object_name), ses);\n"
"else\n"
"http (sprintf (\':Query :fields [ :name \"%s\" ; :type %s:%s ] .\\n\', gql_object_name, ns, gql_object_name), ses);\n"
"any_query_field := any_query_field + 1;\n"
"}\n"
"\n"
"query_fields := dict_to_vector (query_dict, 1);\n"
"if (not any_query_field)\n"
"{\n"
"declare inx int;\n"
"declare fld_name, fld_type, fld_kind, type_ref varchar;\n"
"for (inx := 0; inx < length (query_fields); inx := inx + 2)\n"
"{\n"
"type_ref := query_fields[inx+1];\n"
"fld_kind := type_ref[0];\n"
"fld_type := type_ref[1];\n"
"fld_name := query_fields[inx];\n"
"if (gqt_is_list (fld_kind))\n"
"http (sprintf (\':Query :fields [ :name \"%s\" ; :type [ :kind \"LIST\" ; :ofType %s ] ] .\\n\', fld_name, fld_type), ses);\n"
"else\n"
"http (sprintf (\':Query :fields [ :name \"%s\" ; :type %s ] .\\n\', fld_name, fld_type), ses);\n"
"}\n"
"}\n"
"\n"
"http (ses, out_ses);\n"
"return out_ses;\n"
"}\n"
"--src graphql.sql:2123\n"
;

static const char *other8 = 
"DB.DBA.RDF_GRAPH_GROUP_CREATE (\'urn:graphql:intro:group\', 1)\n";
static const char *proc47 = 
"#line 2406 \"[executable]/graphql.sql\"\n"
"create procedure GQL_INTRO_LIST ()\n"
"{\n"
"declare graph varchar;\n"
"result_names (graph);\n"
"for select id_to_iri (RGGM_MEMBER_IID) as member  from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = iri_to_id (\'urn:graphql:intro:group\') do\n"
"{\n"
"result (member);\n"
"}\n"
"}\n"
"--src graphql.sql:2404\n"
;

static const char *proc48 = 
"#line 2417 \"[executable]/graphql.sql\"\n"
"create procedure GQL_INTRO_UPDATE (in g_iri varchar, in tgt_iri varchar := \'urn:graphql:intro\')\n"
"{\n"
"GQL_INTRO_DEL (g_iri, tgt_iri);\n"
"GQL_INTRO_ADD (g_iri, tgt_iri);\n"
"}\n"
"--src graphql.sql:2415\n"
;

static const char *proc49 = 
"#line 2424 \"[executable]/graphql.sql\"\n"
"create procedure GQL_INTRO_LOAD (in src_iri varchar, in target_iri varchar, in force int := 0)\n"
"{\n"
"declare str varchar;\n"
"str := DB.DBA.XML_URI_GET (src_iri, \'\');\n"
"if (force)\n"
"{\n"
"GQL_INTRO_DEL (target_iri);\n"
"sparql clear graph ?:target_iri;\n"
"}\n"
"else if (exists (select 1 from DB.DBA.RDF_QUAD table option (index G) where G = iri_to_id (target_iri)))\n"
"signal (\'GQLIE\', \'The target graph is not empty, drop it first or use force=>1 to delete\');\n"
"DB.DBA.TTLP (str, \'\', target_iri);\n"
"GQL_INTRO_ADD (target_iri, \'urn:graphql:intro\');\n"
"}\n"
"--src graphql.sql:2422\n"
;

static const char *proc50 = 
"#line 2440 \"[executable]/graphql.sql\"\n"
"create procedure GQL_INTRO_ADD (in g_iri varchar, in tgt_iri varchar := \'urn:graphql:intro\')\n"
"{\n"
"declare g_iids, tgt_iid any;\n"
"declare env, ses, status, any_error any;\n"
"\n"
"if (current_proc_name (1) is null)\n"
"result_names (status);\n"
"any_error := 0;\n"
"for select * from (sparql select ?typeName\n"
"where { graph `iri(?:tgt_iri)` { gqi:__schema gqi:types ?type0 . ?type0 gqi:name ?typeName0 }\n"
"graph `iri(?:g_iri)`   { gqi:__schema gqi:types ?type . ?type gqi:name ?typeName }\n"
"filter (?typeName0 = ?typeName) }) dt do\n"
"{\n"
"result (sprintf (\'Type `%s` already defined, must fix conflicting definition.\', typeName));\n"
"any_error := 1;\n"
"}\n"
"if (any_error)\n"
"{\n"
"result (\'Introspection graph cannot be updated\');\n"
"return;\n"
"}\n"
"\n"
"env := vector (0, 0, 0);\n"
"ses := string_output ();\n"
"\n"
"DB.DBA.RDF_GRAPH_GROUP_INS (\'urn:graphql:intro:group\', g_iri);\n"
"\n"
"g_iids := (select VECTOR_AGG (RGGM_MEMBER_IID)  from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = iri_to_id (\'urn:graphql:intro:group\'));\n"
"\n"
"foreach (iri_id_8 g_iid in g_iids) do\n"
"{\n"
"for (select * from ( sparql define input:storage \"\" select ?s ?p ?o { graph ?:g_iid { ?s ?p ?o } } ) as sub option (loop)) do\n"
"{\n"
"http_nt_triple (env, \"s\", \"p\", \"o\", ses);\n"
"}\n"
"}\n"
"\n"
"tgt_iid := iri_to_id (tgt_iri);\n"
"delete from DB.DBA.RDF_QUAD where G = tgt_iid;\n"
"delete from DB.DBA.RDF_QUAD table option (index RDF_QUAD_GS, index_only) where G = tgt_iid option (index_only, index RDF_QUAD_GS);\n"
"TTLP (ses, \'\', tgt_iri);\n"
"commit work;\n"
"result (sprintf (\'Introspection data from `%s` is added.\', g_iri));\n"
"}\n"
"--src graphql.sql:2438\n"
;

static const char *proc51 = 
"#line 2486 \"[executable]/graphql.sql\"\n"
"create procedure GQL_INTRO_DEL (in g_iri varchar, in tgt_iri varchar := \'urn:graphql:intro\')\n"
"{\n"
"declare g_iids, tgt_iid any;\n"
"declare env, ses any;\n"
"\n"
"env := vector (0, 0, 0);\n"
"ses := string_output ();\n"
"\n"
"DB.DBA.RDF_GRAPH_GROUP_DEL (\'urn:graphql:intro:group\', g_iri);\n"
"\n"
"g_iids := (select VECTOR_AGG (RGGM_MEMBER_IID)  from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = iri_to_id (\'urn:graphql:intro:group\'));\n"
"\n"
"foreach (iri_id_8 g_iid in g_iids) do\n"
"{\n"
"for (select * from ( sparql define input:storage \"\" select ?s ?p ?o { graph ?:g_iid { ?s ?p ?o } } ) as sub option (loop)) do\n"
"{\n"
"http_nt_triple (env, \"s\", \"p\", \"o\", ses);\n"
"}\n"
"}\n"
"\n"
"tgt_iid := iri_to_id (tgt_iri);\n"
"delete from DB.DBA.RDF_QUAD where G = tgt_iid;\n"
"delete from DB.DBA.RDF_QUAD table option (index RDF_QUAD_GS, index_only) where G = tgt_iid option (index_only, index RDF_QUAD_GS);\n"
"TTLP (ses, \'\', tgt_iri);\n"
"commit work;\n"
"}\n"
"--src graphql.sql:2484\n"
;

static const char *proc52 = 
"#line 2514 \"[executable]/graphql.sql\"\n"
"create procedure GQL_INIT_TYPE_SCHEMA (in force_clean int := 0)\n"
"{\n"
"declare version, latest_version varchar;\n"
"declare report varchar;\n"
"result_names (report);\n"
"\n"
"latest_version := \'0.9.3\';\n"
"if (force_clean = 2)\n"
"{\n"
"declare g_iids any;\n"
"g_iids := (select VECTOR_AGG (RGGM_MEMBER_IID)  from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = iri_to_id (\'urn:graphql:intro:group\'));\n"
"foreach (any g_iid in g_iids) do\n"
"{\n"
"DB.DBA.RDF_GRAPH_GROUP_DEL (\'urn:graphql:intro:group\', id_to_iri (g_iid));\n"
"}\n"
"}\n"
"version := coalesce ((sparql select str(?version) from <urn:graphql:schema> { ?s a owl:Ontology ; virtrdf:version ?version }), \'0\');\n"
"if (lt (version, latest_version) or force_clean)\n"
"{\n"
"sparql clear graph <urn:graphql:schema>;\n"
"DB.DBA.TTLP (DB.DBA.XML_URI_GET (\'http://www.openlinksw.com/graphql/graphql-intro-schema.ttl\', \'\'), \'\', \'urn:graphql:schema\');\n"
"result (sprintf (\'Loaded GraphQL Type Schema, version %s\', latest_version));\n"
"}\n"
"else\n"
"{\n"
"result (sprintf (\'GraphQL Type Schema, version %s already loaded\', version));\n"
"}\n"
"version := coalesce ((sparql select str(?version) from <urn:graphql:intro> { ?s a void:Dataset ; virtrdf:version ?version }), \'0\');\n"
"if (lt (version, latest_version) or force_clean)\n"
"{\n"
"GQL_INTRO_DEL (\'urn:graphql:intro:core\');\n"
"sparql clear graph <urn:graphql:intro:core>;\n"
"DB.DBA.TTLP (DB.DBA.XML_URI_GET (\'http://www.openlinksw.com/graphql/graphql-intro.ttl\', \'\'), \'\', \'urn:graphql:intro:core\');\n"
"GQL_INTRO_ADD (\'urn:graphql:intro:core\');\n"
"result (sprintf (\'Loaded GraphQL Core Types Dataset, version %s\', latest_version));\n"
"}\n"
"else\n"
"{\n"
"result (sprintf (\'GraphQL Core Types Dataset, version %s already loaded\', version));\n"
"}\n"
"commit work;\n"
"}\n"
"--src graphql.sql:2512\n"
;

static const char *proc53 = 
"#line 2558 \"[executable]/graphql.sql\"\n"
"create procedure GQL_GENERATE_INTRO (in type_schema_doc varchar)\n"
"{\n"
"declare tree any;\n"
"declare i, len int;\n"
"declare ses, types, dict any;\n"
"\n"
"tree := graphql_parse (type_schema_doc);\n"
"if (not isvector (tree) and tree[0] <> 512)\n"
"signal (\'GOWL0\', \'Not a GQL schema\');\n"
"\n"
"\n"
"tree := tree[1];\n"
"dict := dict_new (11);\n"
"types := GQL_READ_TYPES (tree, dict);\n"
"len := length (tree);\n"
"ses := string_output ();\n"
"http (\'@prefix : <http://www.openlinksw.com/schemas/graphql/intro#> . \\n\', ses);\n"
"http (\'@prefix gql: <http://www.openlinksw.com/schemas/graphql#> . \\n\', ses);\n"
"http (\'@prefix xsd: <http://www.w3.org/2001/XMLSchema#> . \\n\', ses);\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> . \\n\', ses);\n"
"http (\' \\n\', ses);\n"
"\n"
"for (i := 0; i < len; i := i + 1)\n"
"{\n"
"GQL_TRAVERSE_NODE (aref (tree, i), ses, 0, types, dict);\n"
"}\n"
"return ses;\n"
"}\n"
"--src graphql.sql:2556\n"
;

static const char *proc54 = 
"#line 2588 \"[executable]/graphql.sql\"\n"
"create procedure GQL_PRINT_FIELD (inout ses any, in field_def any, inout types any)\n"
"{\n"
"declare type_def, name varchar;\n"
"declare description, args, op any;\n"
"op := aref (field_def, 0);\n"
"name := aref (field_def, 1);\n"
"if (op = 1007)\n"
"{\n"
"args := 0;\n"
"type_def := aref (field_def, 2);\n"
"description := aref (field_def, 5);\n"
"}\n"
"else if (op = 1006)\n"
"{\n"
"args := aref (field_def, 2);\n"
"description := aref (field_def, 5);\n"
"type_def := aref (field_def, 3);\n"
"}\n"
"else\n"
"signal (\'22023\', \'Invalid field type\');\n"
"http (sprintf (\'\\t [ :name \"%s\" \', name), ses);\n"
"if (description)\n"
"{\n"
"http (\'; :description \', ses);\n"
"http_nt_object (description, ses);\n"
"}\n"
"http (\'; :type \', ses);\n"
"GQL_PRINT_TYPE (ses, type_def, op, types);\n"
"if (isvector (args) and length (args))\n"
"{\n"
"declare i int;\n"
"declare arg, arg_name, arg_type any;\n"
"http (\';\\n\', ses);\n"
"for (i := 0; i < length (args); i := i + 1)\n"
"{\n"
"arg := args[i];\n"
"arg_name := arg[1];\n"
"arg_type := arg[2];\n"
"if (i > 0)\n"
"http (\';\\n\', ses);\n"
"http (\'\\t\\t :args [ \', ses);\n"
"http (sprintf (\' :name \"%s\" ; :type \', arg_name), ses);\n"
"GQL_PRINT_TYPE (ses, arg_type, op, types);\n"
"http (\' ]\', ses);\n"
"}\n"
"}\n"
"http (\' ]\', ses);\n"
"return;\n"
"}\n"
"--src graphql.sql:2586\n"
;

static const char *proc55 = 
"#line 2639 \"[executable]/graphql.sql\"\n"
"create procedure GQL_PRINT_TYPE (inout ses any, in type_def any, in kind int, inout types any)\n"
"{\n"
"declare not_null, list, type_name any;\n"
"list := (case type_def[0] when 212 then 1 else 0 end);\n"
"not_null := aref (type_def, 2);\n"
"if (not_null)\n"
"{\n"
"http (sprintf (\' [ :kind \"NON_NULL\"; :ofType \'), ses);\n"
"type_def[2] := 0;\n"
"GQL_PRINT_TYPE (ses, type_def, kind, types);\n"
"http (\' ]\', ses);\n"
"return;\n"
"}\n"
"if (list)\n"
"{\n"
"http (sprintf (\' [ :kind \"LIST\"; :ofType \'), ses);\n"
"type_def := aref (type_def, 1);\n"
"GQL_PRINT_TYPE (ses, type_def, kind, types);\n"
"http (\' ]\', ses);\n"
"return;\n"
"}\n"
"type_name := aref (type_def, 1);\n"
"if (dict_get (types, type_name) is null)\n"
"signal (\'22023\', sprintf (\'Undefined type %s.\', type_name));\n"
"http (sprintf (\':%s\' , type_name), ses);\n"
"return;\n"
"}\n"
"--src graphql.sql:2637\n"
;

static const char *proc56 = 
"#line 2668 \"[executable]/graphql.sql\"\n"
"create procedure GQL_READ_TYPES (in tree any, inout dict any, in schema_iri varchar := \'urn:graphql:intro\')\n"
"{\n"
"declare i, len int;\n"
"declare schema_iid iri_id_8;\n"
"declare types any;\n"
"\n"
"schema_iid := iri_to_id (schema_iri);\n"
"types := dict_new (31);\n"
"for select \"name\", \"kind\" from (sparql select str(?name) as ?name  str(?kind) as ?kind\n"
"{ graph ?:schema_iid { gqi:__schema gqi:types [ gqi:name ?name ; gqi:kind ?kind ] }}) dt do\n"
"{\n"
"if (subseq (\"name\", 0, 2) <> \'__\')\n"
"dict_put (types, \"name\", \"kind\");\n"
"}\n"
"len := length (tree);\n"
"for (i := 0; i < len; i := i + 1)\n"
"{\n"
"declare elm any;\n"
"declare op int;\n"
"elm := aref (tree, i);\n"
"op := aref (elm, 0);\n"
"if (op = 1001)\n"
"dict_put (types, elm[2], \'SCALAR\');\n"
"else if (op = 1002)\n"
"dict_put (types, elm[2], \'OBJECT\');\n"
"else if (op = 1012)\n"
"dict_put (types, elm[2], \'INPUT_OBJECT\');\n"
"else if (op = 1009)\n"
"dict_put (types, elm[2], \'ENUM\');\n"
"else if (op = 1011)\n"
"{\n"
"declare name, fields any;\n"
"name := aref (elm, 2);\n"
"fields := aref (elm, 5);\n"
"dict_put (dict, name, fields);\n"
"}\n"
"}\n"
"return types;\n"
"}\n"
"--src graphql.sql:2666\n"
;

static const char *proc57 = 
"#line 2709 \"[executable]/graphql.sql\"\n"
"create procedure GQL_TRAVERSE_NODE (in tree any, inout ses any, in lev int, inout types any, inout dict any)\n"
"{\n"
"declare op int;\n"
"declare name, skip varchar;\n"
"declare description any;\n"
"declare dirs, ifaces, fields any;\n"
"\n"
"http (\'\\n###\\n\\n\', ses);\n"
"op := aref (tree, 0);\n"
"if (op = 1000)\n"
"{\n"
"signal (\'42000\', \'Can not re-define root schema.\');\n"
"}\n"
"else if (op = 1001)\n"
"{\n"
"description := aref (tree, 1);\n"
"name := aref (tree, 2);\n"
"dirs := aref (tree, 3);\n"
"http (sprintf (\':__schema :types :%s . \\n\', name), ses);\n"
"\n"
"http (sprintf (\':%s rdf:type gql:Object ;\\n\', name), ses);\n"
"http (sprintf (\'    :enumValues rdf:nil ;\\n\'), ses);\n"
"http (sprintf (\'    :fields rdf:nil ;\\n\'), ses);\n"
"http (sprintf (\'    :interfaces rdf:nil ;\\n\'), ses);\n"
"http (sprintf (\'    :kind \"SCALAR\" ;\\n\'), ses);\n"
"http (sprintf (\'    :possibleTypes rdf:nil ;\\n\'), ses);\n"
"if (description)\n"
"{\n"
"http (\'    :description \', ses);\n"
"http_nt_object (description, ses);\n"
"http (\';\\n\', ses);\n"
"}\n"
"http (sprintf (\'    :name \"%s\" .\\n\', name), ses);\n"
"}\n"
"else if (op = 1002)\n"
"{\n"
"declare inx int;\n"
"description := aref (tree, 1);\n"
"name := aref (tree, 2);\n"
"if (name[0] = 95)\n"
"signal (\'42000\', \'(re)Definition of system types prohibited.\');\n"
"\n"
"\n"
"ifaces := aref (tree, 3);\n"
"dirs := aref (tree, 4);\n"
"fields := aref (tree, 5);\n"
"\n"
"if (name in (\'Query\', \'Mutation\'))\n"
"{\n"
"if (not fields or not length (fields))\n"
"goto no;\n"
"http (sprintf (\':%s \', name), ses);\n"
"goto fields_def;\n"
"}\n"
"\n"
"http (sprintf (\':__schema :types :%s . \\n\', name), ses);\n"
"\n"
"http (sprintf (\':%s a gql:Object ;\\n\', name), ses);\n"
"http (sprintf (\'  :name \"%s\" ;\\n\', name), ses);\n"
"if (description)\n"
"{\n"
"http (\'    :description \', ses);\n"
"http_nt_object (description, ses);\n"
"http (\';\\n\', ses);\n"
"}\n"
"http (sprintf (\'  :kind \"OBJECT\" ;\\n\'), ses);\n"
"fields_def:\n"
"for (inx := 0; ifaces <> 0 and inx < length (ifaces); inx := inx + 1)\n"
"{\n"
"declare iname, ifields, elm any;\n"
"elm := aref (ifaces, inx);\n"
"iname := elm[1][1];\n"
"ifields := dict_get (dict, iname);\n"
"\n"
"}\n"
"http (\'  :fields \\n\', ses);\n"
"for (inx := 0; inx < length (fields); inx := inx + 1)\n"
"{\n"
"declare fld any;\n"
"fld := fields[inx];\n"
"if (inx > 0) http (\', \\n\', ses);\n"
"GQL_PRINT_FIELD (ses, fld, types);\n"
"}\n"
"if (not inx) http (\'rdf:nil\', ses);\n"
"http (\';\\n\', ses);\n"
"http (sprintf (\'  :isDeprecated false .\\n\'), ses);\n"
"\n"
"}\n"
"else if (op = 1012)\n"
"{\n"
"declare inx int;\n"
"description := aref (tree, 1);\n"
"name := aref (tree, 2);\n"
"\n"
"dirs := aref (tree, 3);\n"
"fields := aref (tree, 4);\n"
"\n"
"http (sprintf (\':__schema :types :%s . \\n\', name), ses);\n"
"\n"
"http (sprintf (\':%s a gql:Object ;\\n\', name), ses);\n"
"http (sprintf (\'  :name \"%s\" ;\\n\', name), ses);\n"
"if (description)\n"
"{\n"
"http (\'    :description \', ses);\n"
"http_nt_object (description, ses);\n"
"http (\';\\n\', ses);\n"
"}\n"
"http (sprintf (\'  :kind \"INPUT_OBJECT\" ;\\n\'), ses);\n"
"http (\'  :inputFields \\n\', ses);\n"
"for (inx := 0; inx < length (fields); inx := inx + 1)\n"
"{\n"
"declare fld any;\n"
"fld := fields[inx];\n"
"if (inx > 0) http (\', \\n\', ses);\n"
"GQL_PRINT_FIELD (ses, fld, types);\n"
"}\n"
"if (not inx)\n"
"signal (\'22023\', sprintf (\'Input `%s` must define fields.\', name));\n"
"http (\'.\\n\', ses);\n"
"}\n"
"else if (op = 1011)\n"
"{\n"
" ;\n"
"}\n"
"else if (op = 1009)\n"
"{\n"
"declare inx int;\n"
"declare vals any;\n"
"\n"
"description := aref (tree, 1);\n"
"name := aref (tree, 2);\n"
"dirs := aref (tree, 3);\n"
"vals := aref (tree, 4);\n"
"http (sprintf (\':__schema :types :%s . \\n\', name), ses);\n"
"\n"
"http (sprintf (\':%s a gql:Object ;\\n\', name), ses);\n"
"http (sprintf (\'  :name \"%s\" ;\\n\', name), ses);\n"
"if (description)\n"
"{\n"
"http (\'    :description \', ses);\n"
"http_nt_object (description, ses);\n"
"http (\';\\n\', ses);\n"
"}\n"
"http (sprintf (\'  :kind \"ENUM\" ;\\n\'), ses);\n"
"http (\'  :enumValues \\n\', ses);\n"
"for (inx := 0; inx < length (vals); inx := inx + 1)\n"
"{\n"
"declare val, enum_name any;\n"
"val := vals[inx];\n"
"enum_name := aref (val, 2);\n"
"description := aref (val, 1);\n"
"if (inx > 0) http (\', \\n\', ses);\n"
"http (sprintf (\'    [ :name \"%s\" ;\', enum_name), ses);\n"
"if (description)\n"
"{\n"
"http (\' :description \', ses);\n"
"http_nt_object (description, ses);\n"
"http (\';\', ses);\n"
"}\n"
"http (sprintf (\' :isDeprecated false ]\'), ses);\n"
"}\n"
"if (not inx)\n"
"signal (\'22023\', sprintf (\'ENUM `%s` must define values.\', name));\n"
"http (\'.\\n\', ses);\n"
"}\n"
"else if (op = 1004)\n"
"{\n"
"declare args, locations any;\n"
"declare repeatable int;\n"
"description := aref (tree, 1);\n"
"name := aref (tree, 2);\n"
"args := aref (tree, 3);\n"
"repeatable := aref (tree, 4);\n"
"locations := aref (tree, 5);\n"
"http (sprintf (\':__schema :directives :%s . \\n\', name), ses);\n"
"http (sprintf (\':%s rdf:type gql:Object ;\\n\', name), ses);\n"
"if (description)\n"
"{\n"
"http (\'    :description \', ses);\n"
"http_nt_object (description, ses);\n"
"http (\';\\n\', ses);\n"
"}\n"
"if (isvector (locations) and length (locations))\n"
"{\n"
"declare i int;\n"
"declare loc any;\n"
"http (\'    :locations \', ses);\n"
"for (i := 0; i < length (locations); i := i + 1)\n"
"{\n"
"loc := aref (locations, i);\n"
"if (i > 0)\n"
"http (\',\', ses);\n"
"http (sprintf (\'\"%s\"\', loc), ses);\n"
"}\n"
"http (\';\\n\', ses);\n"
"}\n"
"if (repeatable)\n"
"http (\'    :isRepeatable \"true\"^^xsd:boolean ;\\n\', ses);\n"
"if (isvector (args) and length (args))\n"
"{\n"
"declare i int;\n"
"declare arg, arg_name, arg_type any;\n"
"for (i := 0; i < length (args); i := i + 1)\n"
"{\n"
"arg := args[i];\n"
"arg_name := arg[1];\n"
"arg_type := arg[2];\n"
"if (i > 0)\n"
"http (\';\\n\', ses);\n"
"http (\'    :args [ \', ses);\n"
"http (sprintf (\' :name \"%s\" ; :type \', arg_name), ses);\n"
"GQL_PRINT_TYPE (ses, arg_type, op, types);\n"
"http (\' ]\', ses);\n"
"}\n"
"http (\';\\n\', ses);\n"
"}\n"
"http (sprintf (\'    :name \"%s\" .\\n\', name), ses);\n"
"}\n"
"else\n"
"{\n"
"signal (\'GQTNO\', sprintf (\'Not supported type ID: %d\', op));\n"
"}\n"
"no:\n"
"return;\n"
"}\n"
"--src graphql.sql:2707\n"
;

static const char *tbl1 = 
"create table GRAPHQL.DBA.GQL_WS_SESSION (\n"
"GW_SID BIGINT primary key,\n"
"GW_STATE int,\n"
"GW_VARS ANY,\n"
"GW_IP varchar,\n"
"GW_TS datetime) if not exists\n";

static const char *tbl2 = 
"create table GRAPHQL.DBA.GQL_SUBSCRIPTION (\n"
"GS_ID varchar primary key,\n"
"GS_SID BIGINT,\n"
"GS_SUB_IID iri_id_8,\n"
"GS_OP_NAME varchar,\n"
"GS_QUERY long varchar,\n"
"GS_VARIABLES any,\n"
"GS_REGISTERED datetime,\n"
"GS_LAST_UPDATE datetime,\n"
"GS_STATE int,\n"
"GS_LAST_ERROR varchar) if not exists\n";

static const char *other9 = 
"create unique index GQL_SUBSCRIPTION_ID on GRAPHQL.DBA.GQL_SUBSCRIPTION (GS_SID, GS_ID) if not exists\n";

static const char *proc58 = 
"#line 2961 \"[executable]/graphql.sql\"\n"
"create procedure DB.DBA.GQL_REGISTER_EVENTS (in events any)\n"
"{\n"
"declare arg_iri varchar;\n"
"declare sub_iid iri_id_8;\n"
"foreach (any evt in events) do\n"
"{\n"
"sub_iid := evt[0];\n"
"arg_iri := id_to_iri (evt[1]);\n"
"DB.DBA.GQL_SUB_PUSH (sub_iid, vector (\'iri\', arg_iri));\n"
"}\n"
"}\n"
"--src graphql.sql:2959\n"
;

static const char *proc59 = 
"#line 2974 \"[executable]/graphql.sql\"\n"
"create procedure DB.DBA.GQL_SUB_PUSH (in sub_iid iri_id_8, in vars any)\n"
"{\n"
"declare response, payload varchar;\n"
"declare sids any;\n"
"response := null;\n"
"sids := vector ();\n"
"for select GS_QUERY, GS_ID, GS_SID, GS_VARIABLES, GS_OP_NAME from GRAPHQL.DBA.GQL_SUBSCRIPTION where GS_SUB_IID = sub_iid and GS_STATE = 1 do\n"
"{\n"
"if (not http_client_session_cached (GS_SID))\n"
"{\n"
"sids := vector_concat (sids, vector (GS_SID));\n"
"goto next;\n"
"}\n"
"if (isvector (GS_VARIABLES) and length (GS_VARIABLES) > 2)\n"
"vars := GS_VARIABLES;\n"
"GQL_RESTORE_SESSION (GS_SID);\n"
"set_user_id (connection_get (\'SPARQLUserId\', \'GRAPHQL\'), 1);\n"
"if (response is null)\n"
"response := GQL_DISPATCH (GS_QUERY, vars, \'urn:zero\', 0, operation_name=>GS_OP_NAME);\n"
"declare exit handler for sqlstate \'*\' {\n"
"sids := vector_concat (sids, vector (GS_SID));\n"
"goto next;\n"
"};\n"
"payload := string_output ();\n"
"http (sprintf (\'{\"id\":\"%s\",\"type\":\"next\",\"payload\":\', GS_ID), payload);\n"
"http (response, payload);\n"
"http (\'}\', payload);\n"
"payload := string_output_string (payload);\n"
"WSOCK.DBA.WEBSOCKET_WRITE_MESSAGE (GS_SID, payload);\n"
"next:;\n"
"}\n"
"foreach (int sid in sids) do\n"
"{\n"
"GQL_SESSION_TERMINATE (sid, 1);\n"
"}\n"
"commit work;\n"
"}\n"
"--src graphql.sql:2972\n"
;

static const char *proc60 = 
"#line 3013 \"[executable]/graphql.sql\"\n"
"create procedure DB.DBA.GQL_WS_CONNECT (in sid int)\n"
"{\n"
"insert into GRAPHQL.DBA.GQL_WS_SESSION (GW_SID, GW_STATE, GW_VARS, GW_IP, GW_TS)\n"
"values (sid, 0, connection_vars(), http_client_ip (), curutcdatetime());\n"
"commit work;\n"
"}\n"
"--src graphql.sql:3011\n"
;

static const char *proc61 = 
"#line 3021 \"[executable]/graphql.sql\"\n"
"create procedure GQL_RESTORE_SESSION (in sid int)\n"
"{\n"
"for select GW_VARS from GRAPHQL.DBA.GQL_WS_SESSION where GW_SID = sid do\n"
"{\n"
"connection_vars_set (GW_VARS);\n"
"}\n"
"}\n"
"--src graphql.sql:3019\n"
;

static const char *proc62 = 
"#line 3030 \"[executable]/graphql.sql\"\n"
"create procedure GQL_CHECK_SES_ALIVE ()\n"
"{\n"
"declare ping varchar;\n"
"declare sids any;\n"
"\n"
"sids := vector ();\n"
"for select GW_SID from GRAPHQL.DBA.GQL_WS_SESSION do {\n"
"if (not http_client_session_cached (GW_SID))\n"
"{\n"
"sids := vector_concat (sids, vector (GW_SID));\n"
"goto next;\n"
"}\n"
"ping := \'{\"type\":\"ping\"}\';\n"
"declare exit handler for sqlstate \'*\' {\n"
"sids := vector_concat (sids, vector (GW_SID));\n"
"goto next;\n"
"};\n"
"WSOCK.DBA.WEBSOCKET_WRITE_MESSAGE (GW_SID, ping);\n"
"next:;\n"
"}\n"
"foreach (int sid in sids) do\n"
"{\n"
"GQL_SESSION_TERMINATE (sid, 1);\n"
"}\n"
"commit work;\n"
"}\n"
"--src graphql.sql:3028\n"
;

static const char *proc63 = 
"#line 3058 \"[executable]/graphql.sql\"\n"
"create procedure GQL_SESSION_TERMINATE (in sid int, in on_error int := 0)\n"
"{\n"
"if (not on_error)\n"
"{\n"
"for select GS_ID from GRAPHQL.DBA.GQL_SUBSCRIPTION where GS_SID = sid do\n"
"{\n"
"WSOCK.DBA.WEBSOCKET_WRITE_MESSAGE (sid, sprintf (\'{\"id\":\"%s\",\"type\":\"complete\"}\', GS_ID));\n"
"}\n"
"}\n"
"delete from GRAPHQL.DBA.GQL_SUBSCRIPTION where GS_SID = sid;\n"
"delete from GRAPHQL.DBA.GQL_WS_SESSION where GW_SID = sid;\n"
"commit work;\n"
"}\n"
"--src graphql.sql:3056\n"
;

static const char *proc64 = 
"#line 3074 \"[executable]/graphql.sql\"\n"
"create procedure DB.DBA.GQL_SUBSCRIBE (in request varchar, in sid any)\n"
"{\n"
"declare jt, query, variables, tree, ses, operation, operation_name, root_fld, payload any;\n"
"declare sub_iid iri_id_8;\n"
"declare req_type varchar;\n"
"declare id varchar;\n"
"\n"
"\n"
"declare exit handler for sqlstate \'*\' {\n"
"rollback work;\n"
"GQL_SESSION_TERMINATE (sid, 1);\n"
"commit work;\n"
"ses := string_output ();\n"
"http (sprintf (\'{\"id\":\"%s\",\"type\":\"error\",\"payload\":\', id), ses);\n"
"GQL_ERROR (ses, __SQL_STATE, __SQL_MESSAGE, null, 0);\n"
"http (\'}\', ses);\n"
"WSOCK.DBA.WEBSOCKET_WRITE_MESSAGE (sid, string_output_string (ses));\n"
"return 0;\n"
"};\n"
"\n"
"jt := json_parse (request);\n"
"\n"
"req_type := get_keyword (\'type\', jt);\n"
"id := get_keyword (\'id\', jt);\n"
"if (req_type = \'connection_init\')\n"
"{\n"
"if (not exists (select 1 from GRAPHQL.DBA.GQL_WS_SESSION where GW_SID = sid and GW_STATE = 0 for update))\n"
"{\n"
"WSOCK.DBA.WEBSOCKET_CLOSE_MESSAGE (sid, 4500, \'Internal Server Error\');\n"
"return 0;\n"
"}\n"
"update GRAPHQL.DBA.GQL_WS_SESSION set GW_STATE = 1 where GW_SID = sid and GW_STATE = 0;\n"
"if (not row_count())\n"
"{\n"
"WSOCK.DBA.WEBSOCKET_CLOSE_MESSAGE (sid, 4429, \'Too many initialisation requests\');\n"
"return 0;\n"
"}\n"
"commit work;\n"
"return \'{\"type\":\"connection_ack\"}\';\n"
"}\n"
"else if (req_type = \'ping\')\n"
"{\n"
"if (not exists (select 1 from GRAPHQL.DBA.GQL_WS_SESSION where GW_SID = sid and GW_STATE = 1))\n"
"{\n"
"WSOCK.DBA.WEBSOCKET_CLOSE_MESSAGE (sid, 4401, \'Unauthorized\');\n"
"return 0;\n"
"}\n"
"return \'{\"type\":\"pong\"}\';\n"
"}\n"
"else if (req_type = \'pong\')\n"
"{\n"
"if (not exists (select 1 from GRAPHQL.DBA.GQL_WS_SESSION where GW_SID = sid and GW_STATE = 1))\n"
"{\n"
"WSOCK.DBA.WEBSOCKET_CLOSE_MESSAGE (sid, 4401, \'Unauthorized\');\n"
"return 0;\n"
"}\n"
"return null;\n"
"}\n"
"else if (req_type = \'complete\')\n"
"{\n"
"delete from GRAPHQL.DBA.GQL_SUBSCRIPTION where GS_ID = id;\n"
"commit work;\n"
"return 0;\n"
"}\n"
"else if (req_type is null or req_type <> \'subscribe\')\n"
"{\n"
"GQL_SESSION_TERMINATE (sid, 1);\n"
"WSOCK.DBA.WEBSOCKET_CLOSE_MESSAGE (sid, 4400, \'Invalid request\');\n"
"return 0;\n"
"}\n"
"if (not exists (select 1 from GRAPHQL.DBA.GQL_WS_SESSION where GW_SID = sid and GW_STATE = 1))\n"
"{\n"
"GQL_SESSION_TERMINATE (sid, 1);\n"
"WSOCK.DBA.WEBSOCKET_CLOSE_MESSAGE (sid, 4401, \'Unauthorized\');\n"
"return 0;\n"
"}\n"
"\n"
"for select GS_SID from GRAPHQL.DBA.GQL_SUBSCRIPTION where GS_ID = id do\n"
"{\n"
"if (http_client_session_cached (GS_SID))\n"
"{\n"
"GQL_SESSION_TERMINATE (sid, 1);\n"
"WSOCK.DBA.WEBSOCKET_CLOSE_MESSAGE (sid, 4409, \'Subscriber Already Exists\');\n"
"return 0;\n"
"}\n"
"}\n"
"payload := get_keyword (\'payload\', jt, vector ());\n"
"query := get_keyword (\'query\', payload);\n"
"variables := get_keyword (\'variables\', payload, vector());\n"
"operation := get_keyword (\'operationName\', payload, null);\n"
"tree := graphql_parse (query);\n"
"if (gql_top (tree))\n"
"tree := tree[1];\n"
"else\n"
"signal (\'GQLRW\', \'Unexpected GraphQL document\');\n"
"\n"
"if (gql_token (tree[0][0]) <> \'subscription\')\n"
"signal (\'GQLSU\', \'Only subscriptions are allowed\');\n"
"\n"
"GQL_RESTORE_SESSION (sid);\n"
"set_user_id (connection_get (\'SPARQLUserId\', \'GRAPHQL\'), 1);\n"
"operation_name := tree[0][1];\n"
"tree := tree[0][2];\n"
"root_fld := tree[0][1];\n"
"sub_iid := GQL_IID (root_fld);\n"
"insert replacing GRAPHQL.DBA.GQL_SUBSCRIPTION (GS_SID, GS_ID, GS_OP_NAME, GS_VARIABLES, GS_SUB_IID, GS_QUERY, GS_REGISTERED, GS_STATE)\n"
"values (sid, id, operation, variables, sub_iid, query, curdatetime(), 1);\n"
"commit work;\n"
"return null;\n"
"}\n"
"--src graphql.sql:3072\n"
;

static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name, const int report)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  if (report && proc != NULL)
     log_debug ("built-in procedure \"%s\" overruled by the RDBMS", proc_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


#define EXEC_AND_LOG_TIME(fname, sno) \
  ddl_exec_init_stmt ("do this always", sno, #fname, #sno); 

void
sqls_define_graphql (void)
{
  /* graphql.sql */

  EXEC_AND_LOG_TIME(graphql.sql, other0);
  EXEC_AND_LOG_TIME(graphql.sql, other1);
  DEFINE_PROC ("GQL_GET_FRAGMENTS", proc0);
  DEFINE_PROC ("GQL_DIRECTIVES_MERGE", proc1);
  DEFINE_PROC ("GQL_EXPAND_REFS", proc2);
  DEFINE_PROC ("GQL_APPLY_VARS_DEFAULTS", proc3);
  DEFINE_PROC ("GQL_QUERY_PRAGMAS", proc4);
  DEFINE_PROC ("GQL_PARSE_REQUEST", proc5);
  DEFINE_PROC ("GQL_EXEC_UPDATES", proc6);
  DEFINE_PROC ("GQL_EXEC", proc7);
  DEFINE_PROC ("GQL_IID", proc8);
  DEFINE_PROC ("GQL_SCH_IID", proc9);
  DEFINE_PROC ("GQL_VAL_PRINT", proc10);
  DEFINE_PROC ("GQL_SQL_ARRAY_STR", proc11);
  DEFINE_PROC ("GQL_FUNCTION_EXP", proc12);
  DEFINE_PROC ("GQL_OP", proc13);
  DEFINE_PROC ("GQL_DEBUG", proc14);
  DEFINE_PROC ("GQL_DIRECTIVES_CHECK", proc15);
  DEFINE_PROC ("GQL_DIECTIVES_APPLY", proc16);
  DEFINE_PROC ("GQL_CONSTRUCT", proc17);
  DEFINE_PROC ("GQL_FIELD_CAST", proc18);
  DEFINE_PROC ("GQL_OBJ_CAST", proc19);
  DEFINE_PROC ("GQL_JSON_OBJ_CAST", proc20);
  DEFINE_PROC ("GQL_ARG_INSERT_CAST", proc21);
  DEFINE_PROC ("GQL_VALUE", proc22);
  DEFINE_PROC ("GQL_UPDATE", proc23);
  DEFINE_PROC ("GQL_PRINT_TRIPLE_OR_PATTERN", proc24);
  DEFINE_PROC ("GQL_BUILD_SPARUL", proc25);
  DEFINE_PROC ("GQL_ERROR", proc26);
  DEFINE_PROC ("GQL_TRANSFORM", proc27);
  DEFINE_PROC ("GQL_RDF_NIL", proc28);
  DEFINE_PROC ("GQL_PREPARE_JSON_TREE", proc29);
  DEFINE_PROC ("GQL_PRINT_JSON_VAL", proc30);
  DEFINE_PROC ("GQL_SERIALIZE_TREE_INT", proc31);
  DEFINE_PROC ("GQL_JSON_SERIALIZE_TREE", proc32);
  ddl_ensure_table ("DB.DBA.GQL_CACHE", tbl0);
  DEFINE_PROC ("GQL_CACHE_CHECK", proc33);
  DEFINE_PROC ("GQL_CACHE_STORE", proc34);
  DEFINE_PROC ("GQL_CACHE_ENABLE", proc35);
  DEFINE_PROC ("GQL_DATA_GRAPH_SIGNATURE", proc36);
  DEFINE_PROC ("GQL_DISPATCH", proc37);
  DEFINE_PROC ("GRAPHQL.GRAPHQL.auth", proc38);
  DEFINE_PROC ("GQL_IS_WSOCK_REQUEST", proc39);
  DEFINE_PROC ("GRAPHQL.GRAPHQL.query", proc40);
  DEFINE_PROC ("DB.DBA.HP_AUTH_GRAPHQL_USER", proc41);
  DEFINE_PROC ("GQL_INIT_USER", proc42);
  EXEC_AND_LOG_TIME(graphql.sql, other2);
  EXEC_AND_LOG_TIME(graphql.sql, other3);
  EXEC_AND_LOG_TIME(graphql.sql, other4);
  EXEC_AND_LOG_TIME(graphql.sql, other5);
  EXEC_AND_LOG_TIME(graphql.sql, other6);
  EXEC_AND_LOG_TIME(graphql.sql, other7);
  DEFINE_PROC ("GQL_XSD_IRI", proc43);
  DEFINE_PROC ("GQL_OWL_IRI", proc44);
  DEFINE_PROC ("GQL_GET_NS", proc45);
  DEFINE_PROC ("GQL_CREATE_TYPE_SCHEMA", proc46);
  EXEC_AND_LOG_TIME(graphql.sql, other8);
  DEFINE_PROC ("GQL_INTRO_LIST", proc47);
  DEFINE_PROC ("GQL_INTRO_UPDATE", proc48);
  DEFINE_PROC ("GQL_INTRO_LOAD", proc49);
  DEFINE_PROC ("GQL_INTRO_ADD", proc50);
  DEFINE_PROC ("GQL_INTRO_DEL", proc51);
  DEFINE_PROC ("GQL_INIT_TYPE_SCHEMA", proc52);
  DEFINE_PROC ("GQL_GENERATE_INTRO", proc53);
  DEFINE_PROC ("GQL_PRINT_FIELD", proc54);
  DEFINE_PROC ("GQL_PRINT_TYPE", proc55);
  DEFINE_PROC ("GQL_READ_TYPES", proc56);
  DEFINE_PROC ("GQL_TRAVERSE_NODE", proc57);
  ddl_ensure_table ("GRAPHQL.DBA.GQL_WS_SESSION", tbl1);
  ddl_ensure_table ("GRAPHQL.DBA.GQL_SUBSCRIPTION", tbl2);
  ddl_ensure_table ("do this always", other9);
  DEFINE_PROC ("DB.DBA.GQL_REGISTER_EVENTS", proc58);
  DEFINE_PROC ("DB.DBA.GQL_SUB_PUSH", proc59);
  DEFINE_PROC ("DB.DBA.GQL_WS_CONNECT", proc60);
  DEFINE_PROC ("GQL_RESTORE_SESSION", proc61);
  DEFINE_PROC ("GQL_CHECK_SES_ALIVE", proc62);
  DEFINE_PROC ("GQL_SESSION_TERMINATE", proc63);
  DEFINE_PROC ("DB.DBA.GQL_SUBSCRIBE", proc64);
}


void
sqls_arfw_define_graphql (void)
{
}
