default: all

#
# This is the makefile for the CDK command line widgets. To get this
# to complile, you need to set the include path and library path of
# of curses and CDK. If your curses version is a variant of ncurses
# you might be able to display color. If your curses has the function
# wbkgd defined then set the compile option CAN_SET_WINDOW_COLOR.
# Other than that, this should compile cleanly and nicely.
#

ROOTDIR	= $(HOME)/local
INSTDIR	= $(ROOTDIR)/bin
INCDIR	= -I/usr/include/ncurses -I$(ROOTDIR)/include -I../include
LIBDIR	= -L$(ROOTDIR)/lib -L/usr/lib -L..
LIBS	= -lcdk -lncurses -lm
#LIBS	= -lcdk -lcurses -lm
CFLAGS	= -g -Wall -DCAN_SET_WINDOW_COLOR
#CFLAGS	= -g -Wall
CC	= gcc
PURIFY  =

#
# No need to edit anything below this line.
#
BINS	= cdkdialog cdkfselect cdkviewer cdklabel\
		cdkscroll cdkradio cdkselection\
		cdkcalendar cdkentry cdktemplate\
		cdkmentry cdkscale cdkslider\
		cdkitemlist cdkmatrix cdkalphalist
all: $(BINS)

cdkdialog: cdkdialog.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

cdkfselect: cdkfselect.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

cdkviewer: cdkviewer.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

cdkscroll: cdkscroll.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

cdkradio: cdkradio.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

cdklabel: cdklabel.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

cdkselection: cdkselection.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

cdkcalendar: cdkcalendar.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

cdkentry: cdkentry.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

cdkmentry: cdkmentry.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

cdktemplate: cdktemplate.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

cdkscale: cdkscale.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

cdkslider: cdkslider.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

cdkitemlist: cdkitemlist.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

cdkmatrix: cdkmatrix.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

cdkalphalist: cdkalphalist.c
	$(PURIFY) $(CC) $(CFLAGS) $(INCDIR) $? -o $@ $(LIBDIR) $(LIBS)

install:
	@(for i in $(BINS); do \
	   echo "Copying $$i to $(INSTDIR)/$${i}"; \
	   rm -f $(INSTDIR)/$${i}; \
	   cp $$i $(INSTDIR)/$${i}; \
	   strip ${INSTDIR}/$${i}; \
	done)
	cp utils/* /export/local/bin

clean:
	$(RM) core *.o $(BINS)
