#include "cdk.h"

#ifdef XCURSES
char *XCursesProgramName="cdkdialog";
#endif

/*
 * Define file local variables.
 */
char *FPUsage = "-m Message String | -f filename [-B Buttons] [-O Output file] [-X X Position] [-Y Y Position] [-N] [-S]";

/*
 * 
 */
int main (int argc, char **argv)
{
   /* Declare variables. */
   CDKSCREEN *cdkScreen		= (CDKSCREEN *)NULL;
   CDKDIALOG *widget		= (CDKDIALOG *)NULL;
   WINDOW *cursesWindow		= (WINDOW *)NULL;
   char *CDK_WIDGET_COLOR	= (char *)NULL;
   char *message		= (char *)NULL;
   char *buttons		= (char *)NULL;
   char *button			= (char *)NULL;
   char *filename		= (char *)NULL;
   char *outputFile		= (char *)NULL;
   char *temp			= (char *)NULL;
   chtype *holder		= (chtype *)NULL;
   int answer			= 0;
   int xpos			= CENTER;
   int ypos			= CENTER;
   int ret			= 0;
   int messageLines		= -1;
   int buttonCount		= 0;
   boolean boxWidget		= TRUE;
   boolean shadowWidget		= FALSE;
   FILE *fp			= stderr;
   char *messageList[MAX_DIALOG_ROWS];
   char *buttonList[30];
   int x, j1, j2;

   /* Parse up the command line. */
   while (1)
   {
      /* If there aren't any more options, then break. */
      if ((ret = getopt (argc, argv, "m:B:f:O:X:Y:NS")) == -1)
      {
         break;
      }

      /* Determine which command line option we just received. */
      switch (ret)
      {
         case 'm':
              message = copyChar (optarg);
              break;

         case 'f':
              filename = copyChar (optarg);
              break;

         case 'B':
              buttons = copyChar (optarg);
              break;

         case 'O':
              outputFile = copyChar (optarg);
              break;

         case 'X':
              if (strcmp (optarg, "TOP") == 0)
              {
                 xpos = TOP;
              }
              else if (strcmp (optarg, "BOTTOM") == 0)
              {
                 xpos = BOTTOM;
              }
              else if (strcmp (optarg, "LEFT") == 0)
              {
                 xpos = LEFT;
              }
              else if (strcmp (optarg, "RIGHT") == 0)
              {
                 xpos = RIGHT;
              }
              else if (strcmp (optarg, "CENTER") == 0)
              {
                 xpos = CENTER;
              }
              else
              {
                 xpos = atoi (optarg);
              }
              break;

         case 'Y':
              if (strcmp (optarg, "TOP") == 0)
              {
                 ypos = TOP;
              }
              else if (strcmp (optarg, "BOTTOM") == 0)
              {
                 ypos = BOTTOM;
              }
              else if (strcmp (optarg, "LEFT") == 0)
              {
                 ypos = LEFT;
              }
              else if (strcmp (optarg, "RIGHT") == 0)
              {
                 ypos = RIGHT;
              }
              else if (strcmp (optarg, "CENTER") == 0)
              {
                 ypos = CENTER;
              }
              else
              {
                 ypos = atoi (optarg);
              }
              break;

         case 'N':
              boxWidget = FALSE;
              break;

         case 'S':
              shadowWidget = TRUE;
              break;

         default:
              break;
      }
   }

   /* If the user asked for an output file, try to open it. */
   if (outputFile != (char *)NULL)
   {
      if ((fp = fopen (outputFile, "w")) == NULL)
      {
         fprintf (stderr, "%s: Can not open output file %s\n", argv[0], outputFile);
         exit (-1);
      }
   }

   /* Make sure we have a message to display. */
   if (message == (char *)NULL)
   {
      /* No message, maybe they provided a file to read. */
      if (filename != (char *)NULL)
      {
         /* Read the file in. */
         messageLines = readFile (filename, messageList, MAX_DIALOG_ROWS);
         freeChar (filename);

         /* Check if there was an error. */
         if (messageLines == -1)
         {
            fprintf (stderr, "Error: Could not open the file %s\n", filename);
            exit (-1);
         }
      }
      else
      {
         /* No message, no file, it's an error. */
         fprintf (stderr, "Usage: %s %s\n", argv[0], FPUsage);
         exit (-1);
      }
   }
   else
   {
      /* Split the message up. */
      messageLines = splitString (message, messageList, '\n');
      freeChar (message);
   }

   /* Set up the buttons for the dialog box. */
   if (buttons == (char *)NULL)
   {
      buttonList[0]	= copyChar ("OK");
      buttonList[1]	= copyChar ("Cancel");
      buttonCount	= 2;
   }
   else
   {
      /* Split the button list up. */
      buttonCount = splitString (buttons, buttonList, '\n');
      freeChar (buttons);
   }

   /* Set up CDK. */ 
   cursesWindow = initscr();
   cdkScreen = initCDKScreen (cursesWindow);

   /* Start color. */
   initCDKColor();

   /* Check if the user wants to set the background of the main screen. */
   if ((temp = getenv ("CDK_SCREEN_COLOR")) != NULL)
   {
      holder = char2Chtype (temp, &j1, &j2);
      wbkgd (cdkScreen->window, holder[0]);
      wrefresh (cdkScreen->window);
      freeChtype (holder);
   }

   /* Get the widget color background color. */
   if ((CDK_WIDGET_COLOR = getenv ("CDK_WIDGET_COLOR")) == NULL)
   {
      CDK_WIDGET_COLOR = (char *)NULL;
   }

   /* Create the dialog box. */
   widget = newCDKDialog (cdkScreen, xpos, ypos,
				messageList, messageLines,
				buttonList, buttonCount,
				A_REVERSE, 
				boxWidget, boxWidget, shadowWidget);

   /* Check to make sure we created the dialog box. */
   if (widget == NULL)
   {
      /* Clean up used memory. */
      for (x=0; x < messageLines; x++)
      {
         freeChar (messageList[x]);
      }
      for (x=0; x < buttonCount; x++)
      {
         freeChar (buttonList[x]);
      }

      /* Shut down curses and CDK. */
      destroyCDKScreen (cdkScreen);
      delwin (cursesWindow);
      endCDK();

      /* Spit out the message. */
      fprintf (stderr, "Error: Could not create the dialog box. Is the window too small?\n");

      /* Exit with an error. */
      exit (-1);
   }

   /* Check if the user wants to set the background of the widget. */
   setCDKDialogBackgroundColor (widget, CDK_WIDGET_COLOR);

   /* Activate the dialog box. */
   answer = activateCDKDialog (widget, NULL);

   /* End CDK. */
   destroyCDKDialog (widget);
   destroyCDKScreen (cdkScreen);
   delwin (cursesWindow);
   endCDK();

   /* Print the name of the button selected. */
   if (answer >= 0)
   {
      button = copyChar (buttonList[answer]);
      fprintf (fp, "%s\n", button);
      freeChar (button);
   }

   /* Clean up. */
   for (x=0; x < messageLines; x++)
   {
      freeChar (messageList[x]);
   }
   for (x=0; x < buttonCount; x++)
   {
      freeChar (buttonList[x]);
   }

   /* Exit with the button number picked. */
   exit (answer);
}
