//--DVRShader.cpp -----------------------------------------------------------
//   
//                   Copyright (C) 2006
//     University Corporation for Atmospheric Research
//                   All Rights Reserved
//
//----------------------------------------------------------------------------
//
// GLSL shader code. 
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Standard fragment shader
//----------------------------------------------------------------------------
static char fragment_shader_default[] =
  "uniform sampler1D colormap;\n"
  "uniform sampler3D volumeTexture;\n"
  "//------------------------------------------------------------------\n"
  "// Fragment shader main\n"
  "//------------------------------------------------------------------\n"
  "void main(void)\n"
  "{\n"
  "vec4 intensity = vec4 (texture3D(volumeTexture, gl_TexCoord[0].xyz));\n"
  "vec4 color     = vec4 (texture1D(colormap, intensity.x));\n"
  "gl_FragColor = color;\n"
  "}\n";

//----------------------------------------------------------------------------
// Standard vertex shader for the lighting model 
//----------------------------------------------------------------------------
static char vertex_shader_lighting[] =
  "//-----------------------------------------------------------------------\n"
  "// Vertex shader main\n"
  "//-----------------------------------------------------------------------\n"
  "#version 110\n"
  "varying vec3 ecPosition;\n" 
  "void main(void)\n"
  "{\n"
  "  gl_TexCoord[0] = gl_MultiTexCoord0;\n"
  "  gl_Position    = ftransform();\n"
  "  ecPosition     = vec3(gl_ModelViewMatrix * gl_Vertex);\n"
  "}\n";

//----------------------------------------------------------------------------
// Standard fragment shader w/ lighting model (on-the-fly gradient calculation)
//----------------------------------------------------------------------------
static char fragment_shader_lighting[] =
  "uniform sampler1D colormap;\n"
  "uniform sampler3D volumeTexture;\n"
  "uniform vec3 dimensions;\n"
  "uniform vec3 lightDirection;\n"
  "uniform float kd;\n"
  "uniform float ka;\n"
  "uniform float ks;\n"
  "uniform float expS;\n"
  "varying vec3 ecPosition;\n"
  ""
  "vec3 alphaGradient();\n"
  "vec3 Gradient();\n"
  ""
  "//-----------------------------------------------------------------------\n"
  "// Fragment shader main\n"
  "//-----------------------------------------------------------------------\n"
  "void main(void)\n"
  "{\n"
  "  vec4 intensity = vec4 (texture3D(volumeTexture, gl_TexCoord[0].xyz));\n"
  "  vec4 color     = vec4 (texture1D(colormap, intensity.x));\n"
  "  vec3 lightColor = vec3 (1.0, 1.0, 1.0);\n"
  "  \n"
  "  "
  "  vec3 gradient = normalize(gl_NormalMatrix * Gradient());\n"
  "  "
  "  vec3 lightVec      = normalize(lightDirection);\n"
  "  vec3 halfv      = reflect(-lightVec, gradient);\n"
  "  vec3 viewVec      = normalize(-ecPosition);\n"
  "  "
//  "  float diffuse  = max(dot(lightVec, gradient),0.0);\n"
  "  float diffuse  = abs(dot(lightVec, gradient));\n"
  " "
  "  float specular = 0.0;\n"
  "  if (diffuse > 0.0) {\n"
 // "    specular = pow(max(dot(halfv, normalize(viewVec)),0.0), expS);\n"
  "    specular = pow(abs(dot(halfv, normalize(viewVec))), expS);\n"
  "  }\n"
  "  "
  "  diffuse = kd * diffuse;\n"
  "  specular = ks * specular;\n"
  "  "
  "  gl_FragColor.w = color.w;\n"
  "  gl_FragColor.xyz = color.xyz * (ka + diffuse) + vec3(specular * lightColor);\n"
  "}\n"
  "" 
  "//-----------------------------------------------------------------------\n"
  "// Compute the gradient using the alpha channel\n"
  "//-----------------------------------------------------------------------\n"
  "vec3 alphaGradient()\n"
  "{\n"
  "  vec3 gradient;\n"
  "  "
  "  float dx = 0.5/(dimensions.x);\n"
  "  float dy = 0.5/(dimensions.y);\n"
  "  float dz = 0.5/(dimensions.z);\n"
  "  "
  "  vec3 a0;\n"
  "  vec3 a1;\n"
  "  "
  "  a0.x = texture1D(colormap,\n" 
  "                   texture3D(volumeTexture,\n" 
  "                             gl_TexCoord[0].xyz + vec3(dx,0,0)).x).a;\n"
  "  a1.x = texture1D(colormap,\n" 
  "                   texture3D(volumeTexture,\n" 
  "                             gl_TexCoord[0].xyz + vec3(-dx,0,0)).x).a;\n"
  "  "
  "  a0.y = texture1D(colormap,\n" 
  "                   texture3D(volumeTexture,\n" 
  "                             gl_TexCoord[0].xyz + vec3(0,dy,0)).x).a;\n"
  "  a1.y = texture1D(colormap,\n" 
  "                   texture3D(volumeTexture," 
  "                             gl_TexCoord[0].xyz + vec3(0,-dy,0)).x).a;\n"
  "  "
  "  a0.z = texture1D(colormap,\n" 
  "                   texture3D(volumeTexture,\n" 
  "                             gl_TexCoord[0].xyz + vec3(0,0,dz)).x).a;\n"
  "  a1.z = texture1D(colormap,\n" 
  "                   texture3D(volumeTexture,\n" 
  "                             gl_TexCoord[0].xyz + vec3(0,0,-dz)).x).a;\n"
  "  "
  "  gradient = (a1-a0)/2.0;\n"
  "  "
  "  return gradient;\n"
  "}\n"
  "//-----------------------------------------------------------------------\n"
  "// Compute the gradient using the data\n"
  "//-----------------------------------------------------------------------\n"
  "vec3 Gradient()\n"
  "{\n"
  "  vec3 gradient;\n"
  "  "
  "  float dx = 0.5/(dimensions.x);\n"
  "  float dy = 0.5/(dimensions.y);\n"
  "  float dz = 0.5/(dimensions.z);\n"
  "  "
  "  vec3 a0;\n"
  "  vec3 a1;\n"
  "  "
  "  a0.x = texture3D(volumeTexture,\n" 
  "                             gl_TexCoord[0].xyz + vec3(dx,0,0)).x;\n"
  "  a1.x = texture3D(volumeTexture,\n" 
  "                             gl_TexCoord[0].xyz + vec3(-dx,0,0)).x;\n"
  "  "
  "  a0.y = texture3D(volumeTexture,\n" 
  "                             gl_TexCoord[0].xyz + vec3(0,dy,0)).x;\n"
  "  a1.y = texture3D(volumeTexture," 
  "                             gl_TexCoord[0].xyz + vec3(0,-dy,0)).x;\n"
  "  "
  "  a0.z = texture3D(volumeTexture,\n" 
  "                             gl_TexCoord[0].xyz + vec3(0,0,dz)).x;\n"
  "  a1.z = texture3D(volumeTexture,\n" 
  "                             gl_TexCoord[0].xyz + vec3(0,0,-dz)).x;\n"
  "  "
  "  gradient = (a1-a0)/2.0;\n"
  "  "
  "  return gradient;\n"
  "}\n";

//----------------------------------------------------------------------------
// Pre-integrated vertex shader
//----------------------------------------------------------------------------
static char vertex_shader_preintegrated[] =
  "#version 110\n"
  " "
  "uniform float delta;\n"
  "uniform vec4  vdir;\n"
  "uniform vec4  vpos;\n"
  " "
  "//-----------------------------------------------------------------------\n"
  "// Vertex shader main\n"
  "//-----------------------------------------------------------------------\n"
  "void main(void)\n"
  "{\n"
  "  gl_TexCoord[0] = gl_MultiTexCoord0;\n"
  "  gl_Position    = ftransform();\n"
  " "
  "  vec4 sf        =  gl_Vertex;\n"
  "  "
  "  vec4 eye2vert  = normalize(sf - vpos);\n"
  "  vec4 sb        = sf - eye2vert * (delta / dot(normalize(vdir), eye2vert));\n"
  "  "
  "  // Finally, convert sb into texture coordinates\n"
  "  gl_TexCoord[1] = gl_TextureMatrix[0] * sb; \n"
  "}\n";

//----------------------------------------------------------------------------
// Pre-integrated fragment shader
//----------------------------------------------------------------------------
static char fragment_shader_preintegrated[] =
  "uniform sampler2D colormap;\n"
  "uniform sampler3D volumeTexture;\n"
  "//------------------------------------------------------------------\n"
  "// Fragment shader main\n"
  "//------------------------------------------------------------------\n"
  "void main(void)\n"
  "{\n"
  "  vec2 intensity;\n"
  "  intensity.x = texture3D(volumeTexture, gl_TexCoord[0].xyz).x;\n"
  "  intensity.y = texture3D(volumeTexture, gl_TexCoord[1].xyz).x;\n"
  "  vec4 color     = vec4 (texture2D(colormap, intensity));\n"
  "  gl_FragColor = color;\n"
  "}\n";

//----------------------------------------------------------------------------
// Pre-integrated vertex shader w/ lighting
//----------------------------------------------------------------------------
static char vertex_shader_preintegrated_lighting[] =
  "#version 110\n"
  " "
  "uniform float delta;\n"
  "uniform vec4  vdir;\n"
  "uniform vec4  vpos;\n"
  " "
  "varying vec3 ecPosition;\n" 
  " "
  "//-----------------------------------------------------------------------\n"
  "// Vertex shader main\n"
  "//-----------------------------------------------------------------------\n"
  "void main(void)\n"
  "{\n"
  "  gl_TexCoord[0] = gl_MultiTexCoord0;\n"
  "  gl_Position    = ftransform();\n"
  "  ecPosition     = vec3(gl_ModelViewMatrix * gl_Vertex);\n"
  " "
  "  vec4 sf        = gl_Vertex;\n"
  "  "
  "  vec4 eye2vert  = normalize(sf - vpos);\n"
  "  vec4 sb        = sf - eye2vert * (delta / dot(normalize(vdir), eye2vert));\n"
  "  // Finally, convert sb into texture coordinates\n"
  "  gl_TexCoord[1] = gl_TextureMatrix[0] * sb; \n"
  "  "
  "}\n";

//----------------------------------------------------------------------------
// Pre-integrated fragment shader w/ lighting model 
// (on-the-fly gradient calculation)
//----------------------------------------------------------------------------
static char fragment_shader_preintegrated_lighting[] =
  "uniform sampler2D colormap;\n"
  "uniform sampler3D volumeTexture;\n"
  "uniform vec3 dimensions;\n"
  "uniform vec3 lightDirection;\n"
  "uniform float kd;\n"
  "uniform float ka;\n"
  "uniform float ks;\n"
  "uniform float expS;\n"
  "varying vec3 ecPosition;\n"
  ""
  "vec3 alphaGradient();\n"
  "vec3 Gradient();\n"
  ""
  "//-----------------------------------------------------------------------\n"
  "// Fragment shader main\n"
  "//-----------------------------------------------------------------------\n"
  "void main(void)\n"
  "{\n"
  "  vec2 intensity;\n"
  "  intensity.x = texture3D(volumeTexture, gl_TexCoord[0].xyz).x;\n"
  "  intensity.y = texture3D(volumeTexture, gl_TexCoord[1].xyz).x;\n"
  "  vec4 color = vec4 (texture2D(colormap, intensity));\n"
  "  vec3 lightColor = vec3 (1.0, 1.0, 1.0);\n"
  "  "
  "  vec3 gradient = normalize(gl_NormalMatrix * Gradient());\n"
  "  "
  "  vec3 lightVec      = normalize(lightDirection);\n"
  "  vec3 halfv      = reflect(-lightVec, gradient);\n"
  "  vec3 viewVec      = normalize(-ecPosition);\n"
  "  "
//  "  float diffuse  = max(dot(lightVec, gradient),0.0);\n"
  "  float diffuse  = abs(dot(lightVec, gradient));\n"
  " "
  "  float specular = 0.0;\n"
  "  if (diffuse > 0.0) {\n"
//  "    specular = pow(max(dot(halfv, normalize(viewVec)),0.0), expS);\n"
  "    specular = pow(abs(dot(halfv, normalize(viewVec))), expS);\n"
  "  }\n"
  "  "
  "  diffuse = kd * diffuse;\n"
  "  specular = ks * specular;\n"
  "  "
  "  gl_FragColor.w = color.w;\n"
  "  gl_FragColor.xyz = color.xyz * (ka + diffuse) + vec3(specular * lightColor);\n"
  "}\n"
  "" 
  "//-----------------------------------------------------------------------\n"
  "// Compute the gradient using the alpha channel\n"
  "//-----------------------------------------------------------------------\n"
  "vec3 alphaGradient()"
  "{"
  " vec3 gradient;"
  " "
  " float dx = 0.5/(dimensions.x);"
  " float dy = 0.5/(dimensions.y);"
  " float dz = 0.5/(dimensions.z);"
  " "
  " float v  = texture3D(volumeTexture, gl_TexCoord[0].xyz + vec3(dx,0,0)).x;"
  " float x0 = texture2D(colormap, vec2(v,v)).a;"
  " "
  " v        = texture3D(volumeTexture, gl_TexCoord[0].xyz + vec3(-dx,0,0)).x;"
  " float x1 = texture2D(colormap, vec2(v,v)).a;"
  " "
  " v        = texture3D(volumeTexture, gl_TexCoord[0].xyz + vec3(0,dy,0)).x;"
  " float y0 = texture2D(colormap, vec2(v,v)).a;"
  " "
  " v        = texture3D(volumeTexture, gl_TexCoord[0].xyz + vec3(0,-dy,0)).x;"
  " float y1 = texture2D(colormap, vec2(v,v)).a;"
  " "
  " v        = texture3D(volumeTexture, gl_TexCoord[0].xyz + vec3(0,0,dz)).x;"
  " float z0 = texture2D(colormap, vec2(v,v)).a;"
  " "
  " v        = texture3D(volumeTexture, gl_TexCoord[0].xyz + vec3(0,0,-dz)).x;"
  " float z1 = texture2D(colormap, vec2(v,v)).a;"
  " "
  " gradient.x = (x1-x0)/2.0;"
  " gradient.y = (y1-y0)/2.0;"
  " gradient.z = (z1-z0)/2.0;"
  " "
  " return gradient;"
  "}\n"
  "//-----------------------------------------------------------------------\n"
  "// Compute the gradient using the data\n"
  "//-----------------------------------------------------------------------\n"
  "vec3 Gradient()\n"
  "{\n"
  "  vec3 gradient;\n"
  "  "
  "  float dx = 0.5/(dimensions.x);\n"
  "  float dy = 0.5/(dimensions.y);\n"
  "  float dz = 0.5/(dimensions.z);\n"
  "  "
  "  vec3 a0;\n"
  "  vec3 a1;\n"
  "  "
  "  a0.x = texture3D(volumeTexture,\n" 
  "                             gl_TexCoord[0].xyz + vec3(dx,0,0)).x;\n"
  "  a1.x = texture3D(volumeTexture,\n" 
  "                             gl_TexCoord[0].xyz + vec3(-dx,0,0)).x;\n"
  "  "
  "  a0.y = texture3D(volumeTexture,\n" 
  "                             gl_TexCoord[0].xyz + vec3(0,dy,0)).x;\n"
  "  a1.y = texture3D(volumeTexture," 
  "                             gl_TexCoord[0].xyz + vec3(0,-dy,0)).x;\n"
  "  "
  "  a0.z = texture3D(volumeTexture,\n" 
  "                             gl_TexCoord[0].xyz + vec3(0,0,dz)).x;\n"
  "  a1.z = texture3D(volumeTexture,\n" 
  "                             gl_TexCoord[0].xyz + vec3(0,0,-dz)).x;\n"
  "  "
  "  gradient = (a1-a0)/2.0;\n"
  "  "
  "  return gradient;\n"
  "}\n";
