//
//      $Id$
//
//************************************************************************
//								*
//		     Copyright (C)  2005			*
//     University Corporation for Atmospheric Research		*
//		     All Rights Reserved			*
//								*
//************************************************************************/
//
//	File:		
//
//	Author:		John Clyne
//			National Center for Atmospheric Research
//			PO 3000, Boulder, Colorado
//
//	Date:		Wed Feb 16 16:42:51 MST 2005
//
//	Description:	
//
#include <cstdarg>
#include <cstdio>
#include <cassert>
#include <idl_export.h>
#include "IDLCommon.h"


namespace {

const vector<long> longNullVec(1,0);
const vector<double> doubleNullVec(1,0.0);
const vector<string> stringNullVec(1,"");



void vdfSetGridType(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    
    IDL_ENSURE_SCALAR(argv[1]);

    
    
    
    char    *value = IDL_VarGetString(argv[1]);

    
    
	int n = 1;
    vector <string> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = (string) value;
	}

    metadata->SetGridType(
		valuevec[0]
	);

	myBaseErrChk();

	
}



IDL_VPTR vdfGetGridType(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const string  value = metadata->GetGridType();
    const string  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	result = IDL_StrToSTRING((char *) valueptr->c_str());

	n = 0;
    for(int i=0; i<n; i++) {
		
    }

	return(result);

}


void vdfSetCoordSystemType(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    
    IDL_ENSURE_SCALAR(argv[1]);

    
    
    
    char    *value = IDL_VarGetString(argv[1]);

    
    
	int n = 1;
    vector <string> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = (string) value;
	}

    metadata->SetCoordSystemType(
		valuevec[0]
	);

	myBaseErrChk();

	
}



IDL_VPTR vdfGetCoordSystemType(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const string  value = metadata->GetCoordSystemType();
    const string  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	result = IDL_StrToSTRING((char *) valueptr->c_str());

	n = 0;
    for(int i=0; i<n; i++) {
		
    }

	return(result);

}


void vdfSetExtents(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    
    IDL_ENSURE_ARRAY(argv[1]);

    
    
    
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[1],IDL_TYP_DOUBLE); double *valptr = (double *) valvar->value.arr->data;

    
    
	int n = valvar->value.arr->n_elts;
    vector <double> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = valptr[i];
	}

    metadata->SetExtents(
		valuevec
	);

	myBaseErrChk();

	if (valvar != argv[1]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetExtents(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<double>  value = metadata->GetExtents();
    const vector<double>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	double *result_ptr = (double *) IDL_MakeTempVector( IDL_TYP_DOUBLE, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		result_ptr[i] = (double) (*valueptr)[i];
    }

	return(result);

}


void vdfSetNumTimeSteps(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    
    IDL_ENSURE_SCALAR(argv[1]);

    
    
    
    IDL_LONG value = IDL_LongScalar(argv[1]);

    
    
	int n = 1;
    vector <long> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = (long) value;
	}

    metadata->SetNumTimeSteps(
		valuevec[0]
	);

	myBaseErrChk();

	
}



IDL_VPTR vdfGetNumTimeSteps(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const long  value = metadata->GetNumTimeSteps();
    const long  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	result = IDL_GettmpLong((IDL_LONG) *valueptr);

	n = 0;
    for(int i=0; i<n; i++) {
		
    }

	return(result);

}


void vdfSetVariableNames(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    
    IDL_ENSURE_ARRAY(argv[1]);

    
    
    
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[1],IDL_TYP_STRING); IDL_STRING *valptr = (IDL_STRING *) valvar->value.arr->data;

    
    
	int n = valvar->value.arr->n_elts;
    vector <string> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = IDL_STRING_STR(&valptr[i]);
	}

    metadata->SetVariableNames(
		valuevec
	);

	myBaseErrChk();

	if (valvar != argv[1]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetVariableNames(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<string>  value = metadata->GetVariableNames();
    const vector<string>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_STRING *result_ptr = (IDL_STRING *) IDL_MakeTempVector( IDL_TYP_STRING, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		IDL_StrStore(&result_ptr[i], (char *) (*valueptr)[i].c_str());
    }

	return(result);

}


void vdfSetVariables3D(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    
    IDL_ENSURE_ARRAY(argv[1]);

    
    
    
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[1],IDL_TYP_STRING); IDL_STRING *valptr = (IDL_STRING *) valvar->value.arr->data;

    
    
	int n = valvar->value.arr->n_elts;
    vector <string> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = IDL_STRING_STR(&valptr[i]);
	}

    metadata->SetVariables3D(
		valuevec
	);

	myBaseErrChk();

	if (valvar != argv[1]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetVariables3D(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<string>  value = metadata->GetVariables3D();
    const vector<string>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_STRING *result_ptr = (IDL_STRING *) IDL_MakeTempVector( IDL_TYP_STRING, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		IDL_StrStore(&result_ptr[i], (char *) (*valueptr)[i].c_str());
    }

	return(result);

}


void vdfSetVariables2DXY(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    
    IDL_ENSURE_ARRAY(argv[1]);

    
    
    
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[1],IDL_TYP_STRING); IDL_STRING *valptr = (IDL_STRING *) valvar->value.arr->data;

    
    
	int n = valvar->value.arr->n_elts;
    vector <string> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = IDL_STRING_STR(&valptr[i]);
	}

    metadata->SetVariables2DXY(
		valuevec
	);

	myBaseErrChk();

	if (valvar != argv[1]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetVariables2DXY(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<string>  value = metadata->GetVariables2DXY();
    const vector<string>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_STRING *result_ptr = (IDL_STRING *) IDL_MakeTempVector( IDL_TYP_STRING, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		IDL_StrStore(&result_ptr[i], (char *) (*valueptr)[i].c_str());
    }

	return(result);

}


void vdfSetVariables2DXZ(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    
    IDL_ENSURE_ARRAY(argv[1]);

    
    
    
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[1],IDL_TYP_STRING); IDL_STRING *valptr = (IDL_STRING *) valvar->value.arr->data;

    
    
	int n = valvar->value.arr->n_elts;
    vector <string> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = IDL_STRING_STR(&valptr[i]);
	}

    metadata->SetVariables2DXZ(
		valuevec
	);

	myBaseErrChk();

	if (valvar != argv[1]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetVariables2DXZ(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<string>  value = metadata->GetVariables2DXZ();
    const vector<string>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_STRING *result_ptr = (IDL_STRING *) IDL_MakeTempVector( IDL_TYP_STRING, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		IDL_StrStore(&result_ptr[i], (char *) (*valueptr)[i].c_str());
    }

	return(result);

}


void vdfSetVariables2DYZ(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    
    IDL_ENSURE_ARRAY(argv[1]);

    
    
    
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[1],IDL_TYP_STRING); IDL_STRING *valptr = (IDL_STRING *) valvar->value.arr->data;

    
    
	int n = valvar->value.arr->n_elts;
    vector <string> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = IDL_STRING_STR(&valptr[i]);
	}

    metadata->SetVariables2DYZ(
		valuevec
	);

	myBaseErrChk();

	if (valvar != argv[1]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetVariables2DYZ(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<string>  value = metadata->GetVariables2DYZ();
    const vector<string>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_STRING *result_ptr = (IDL_STRING *) IDL_MakeTempVector( IDL_TYP_STRING, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		IDL_StrStore(&result_ptr[i], (char *) (*valueptr)[i].c_str());
    }

	return(result);

}


void vdfSetComment(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    
    IDL_ENSURE_SCALAR(argv[1]);

    
    
    
    char    *value = IDL_VarGetString(argv[1]);

    
    
	int n = 1;
    vector <string> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = (string) value;
	}

    metadata->SetComment(
		valuevec[0]
	);

	myBaseErrChk();

	
}



IDL_VPTR vdfGetComment(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const string  value = metadata->GetComment();
    const string  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	result = IDL_StrToSTRING((char *) valueptr->c_str());

	n = 0;
    for(int i=0; i<n; i++) {
		
    }

	return(result);

}


void vdfSetMapProjection(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    
    IDL_ENSURE_SCALAR(argv[1]);

    
    
    
    char    *value = IDL_VarGetString(argv[1]);

    
    
	int n = 1;
    vector <string> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = (string) value;
	}

    metadata->SetMapProjection(
		valuevec[0]
	);

	myBaseErrChk();

	
}



IDL_VPTR vdfGetMapProjection(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const string  value = metadata->GetMapProjection();
    const string  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	result = IDL_StrToSTRING((char *) valueptr->c_str());

	n = 0;
    for(int i=0; i<n; i++) {
		
    }

	return(result);

}


void vdfSetPeriodicBoundary(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    
    IDL_ENSURE_ARRAY(argv[1]);

    
    
    
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[1],IDL_TYP_LONG); IDL_LONG *valptr = (IDL_LONG *) valvar->value.arr->data;

    
    
	int n = valvar->value.arr->n_elts;
    vector <long> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = valptr[i];
	}

    metadata->SetPeriodicBoundary(
		valuevec
	);

	myBaseErrChk();

	if (valvar != argv[1]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetPeriodicBoundary(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<long>  value = metadata->GetPeriodicBoundary();
    const vector<long>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_LONG *result_ptr = (IDL_LONG *) IDL_MakeTempVector( IDL_TYP_LONG, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		result_ptr[i] = (IDL_LONG) (*valueptr)[i];
    }

	return(result);

}


void vdfSetTSExtents(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    
    IDL_ENSURE_ARRAY(argv[2]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[2],IDL_TYP_DOUBLE); double *valptr = (double *) valvar->value.arr->data;

    
    
	int n = valvar->value.arr->n_elts;
    vector <double> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = valptr[i];
	}

    metadata->SetTSExtents(
		ts, valuevec
	);

	myBaseErrChk();

	if (valvar != argv[2]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetTSExtents(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    

    
    

	int n;

    const vector<double>  value = metadata->GetTSExtents(ts);
    const vector<double>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	double *result_ptr = (double *) IDL_MakeTempVector( IDL_TYP_DOUBLE, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		result_ptr[i] = (double) (*valueptr)[i];
    }

	return(result);

}


void vdfSetTSUserTime(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    
    IDL_ENSURE_ARRAY(argv[2]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[2],IDL_TYP_DOUBLE); double *valptr = (double *) valvar->value.arr->data;

    
    
	int n = valvar->value.arr->n_elts;
    vector <double> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = valptr[i];
	}

    metadata->SetTSUserTime(
		ts, valuevec
	);

	myBaseErrChk();

	if (valvar != argv[2]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetTSUserTime(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    

    
    

	int n;

    const double  value = metadata->GetTSUserTime(ts);
    const double  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	result = IDL_Gettmp(); result->type = IDL_TYP_DOUBLE; result->value.d = *valueptr;

	n = 0;
    for(int i=0; i<n; i++) {
		
    }

	return(result);

}


void vdfSetTSXCoords(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    
    IDL_ENSURE_ARRAY(argv[2]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[2],IDL_TYP_DOUBLE); double *valptr = (double *) valvar->value.arr->data;

    
    
	int n = valvar->value.arr->n_elts;
    vector <double> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = valptr[i];
	}

    metadata->SetTSXCoords(
		ts, valuevec
	);

	myBaseErrChk();

	if (valvar != argv[2]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetTSXCoords(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    

    
    

	int n;

    const vector<double>  value = metadata->GetTSXCoords(ts);
    const vector<double>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	double *result_ptr = (double *) IDL_MakeTempVector( IDL_TYP_DOUBLE, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		result_ptr[i] = (double) (*valueptr)[i];
    }

	return(result);

}


void vdfSetTSYCoords(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    
    IDL_ENSURE_ARRAY(argv[2]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[2],IDL_TYP_DOUBLE); double *valptr = (double *) valvar->value.arr->data;

    
    
	int n = valvar->value.arr->n_elts;
    vector <double> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = valptr[i];
	}

    metadata->SetTSYCoords(
		ts, valuevec
	);

	myBaseErrChk();

	if (valvar != argv[2]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetTSYCoords(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    

    
    

	int n;

    const vector<double>  value = metadata->GetTSYCoords(ts);
    const vector<double>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	double *result_ptr = (double *) IDL_MakeTempVector( IDL_TYP_DOUBLE, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		result_ptr[i] = (double) (*valueptr)[i];
    }

	return(result);

}


void vdfSetTSZCoords(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    
    IDL_ENSURE_ARRAY(argv[2]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[2],IDL_TYP_DOUBLE); double *valptr = (double *) valvar->value.arr->data;

    
    
	int n = valvar->value.arr->n_elts;
    vector <double> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = valptr[i];
	}

    metadata->SetTSZCoords(
		ts, valuevec
	);

	myBaseErrChk();

	if (valvar != argv[2]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetTSZCoords(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    

    
    

	int n;

    const vector<double>  value = metadata->GetTSZCoords(ts);
    const vector<double>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	double *result_ptr = (double *) IDL_MakeTempVector( IDL_TYP_DOUBLE, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		result_ptr[i] = (double) (*valueptr)[i];
    }

	return(result);

}


void vdfSetTSComment(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    
    IDL_ENSURE_SCALAR(argv[2]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    
    char    *value = IDL_VarGetString(argv[2]);

    
    
	int n = 1;
    vector <string> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = (string) value;
	}

    metadata->SetTSComment(
		ts, valuevec[0]
	);

	myBaseErrChk();

	
}



IDL_VPTR vdfGetTSComment(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    

    
    

	int n;

    const string  value = metadata->GetTSComment(ts);
    const string  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	result = IDL_StrToSTRING((char *) valueptr->c_str());

	n = 0;
    for(int i=0; i<n; i++) {
		
    }

	return(result);

}


void vdfSetVComment(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    IDL_ENSURE_SCALAR(argv[2]);
    
    IDL_ENSURE_SCALAR(argv[3]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    char *var = IDL_VarGetString(argv[2]);
    
    char    *value = IDL_VarGetString(argv[3]);

    string varvec = var;
    
	int n = 1;
    vector <string> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = (string) value;
	}

    metadata->SetVComment(
		ts, var, valuevec[0]
	);

	myBaseErrChk();

	
}



IDL_VPTR vdfGetVComment(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    IDL_ENSURE_SCALAR(argv[2]);
    

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    char *var = IDL_VarGetString(argv[2]);
    

    string varvec = var;
    

	int n;

    const string  value = metadata->GetVComment(ts, var);
    const string  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	result = IDL_StrToSTRING((char *) valueptr->c_str());

	n = 0;
    for(int i=0; i<n; i++) {
		
    }

	return(result);

}


void vdfSetVDataRange(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    IDL_ENSURE_SCALAR(argv[2]);
    
    IDL_ENSURE_ARRAY(argv[3]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    char *var = IDL_VarGetString(argv[2]);
    
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[3],IDL_TYP_DOUBLE); double *valptr = (double *) valvar->value.arr->data;

    string varvec = var;
    
	int n = valvar->value.arr->n_elts;
    vector <double> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = valptr[i];
	}

    metadata->SetVDataRange(
		ts, var, valuevec
	);

	myBaseErrChk();

	if (valvar != argv[3]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetVDataRange(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    IDL_ENSURE_SCALAR(argv[2]);
    

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    char *var = IDL_VarGetString(argv[2]);
    

    string varvec = var;
    

	int n;

    const vector<double>  value = metadata->GetVDataRange(ts, var);
    const vector<double>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	double *result_ptr = (double *) IDL_MakeTempVector( IDL_TYP_DOUBLE, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		result_ptr[i] = (double) (*valueptr)[i];
    }

	return(result);

}


void vdfSetUserDataLong(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    IDL_ENSURE_SCALAR(argv[1]);
    IDL_ENSURE_ARRAY(argv[2]);

    
    
    char *tag = IDL_VarGetString(argv[1]);
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[2],IDL_TYP_LONG); IDL_LONG *valptr = (IDL_LONG *) valvar->value.arr->data;

    
    string tagvec = tag;
	int n = valvar->value.arr->n_elts;
    vector <long> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = valptr[i];
	}

    metadata->SetUserDataLong(
		tag, valuevec
	);

	myBaseErrChk();

	if (valvar != argv[2]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetUserDataLong(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    IDL_ENSURE_SCALAR(argv[1]);

    
    
    char *tag = IDL_VarGetString(argv[1]);

    
    string tagvec = tag;

	int n;

    const vector<long>  value = metadata->GetUserDataLong(tag);
    const vector<long>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_LONG *result_ptr = (IDL_LONG *) IDL_MakeTempVector( IDL_TYP_LONG, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		result_ptr[i] = (IDL_LONG) (*valueptr)[i];
    }

	return(result);

}


IDL_VPTR vdfGetUserDataLongTags(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<string>  value = metadata->GetUserDataLongTags();
    const vector<string>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_STRING *result_ptr = (IDL_STRING *) IDL_MakeTempVector( IDL_TYP_STRING, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		IDL_StrStore(&result_ptr[i], (char *) (*valueptr)[i].c_str());
    }

	return(result);

}


void vdfSetUserDataDouble(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    IDL_ENSURE_SCALAR(argv[1]);
    IDL_ENSURE_ARRAY(argv[2]);

    
    
    char *tag = IDL_VarGetString(argv[1]);
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[2],IDL_TYP_DOUBLE); double *valptr = (double *) valvar->value.arr->data;

    
    string tagvec = tag;
	int n = valvar->value.arr->n_elts;
    vector <double> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = valptr[i];
	}

    metadata->SetUserDataDouble(
		tag, valuevec
	);

	myBaseErrChk();

	if (valvar != argv[2]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetUserDataDouble(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    IDL_ENSURE_SCALAR(argv[1]);

    
    
    char *tag = IDL_VarGetString(argv[1]);

    
    string tagvec = tag;

	int n;

    const vector<double>  value = metadata->GetUserDataDouble(tag);
    const vector<double>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	double *result_ptr = (double *) IDL_MakeTempVector( IDL_TYP_DOUBLE, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		result_ptr[i] = (double) (*valueptr)[i];
    }

	return(result);

}


IDL_VPTR vdfGetUserDataDoubleTags(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<string>  value = metadata->GetUserDataDoubleTags();
    const vector<string>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_STRING *result_ptr = (IDL_STRING *) IDL_MakeTempVector( IDL_TYP_STRING, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		IDL_StrStore(&result_ptr[i], (char *) (*valueptr)[i].c_str());
    }

	return(result);

}


void vdfSetUserDataString(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    IDL_ENSURE_SCALAR(argv[1]);
    IDL_ENSURE_SCALAR(argv[2]);

    
    
    char *tag = IDL_VarGetString(argv[1]);
    char    *value = IDL_VarGetString(argv[2]);

    
    string tagvec = tag;
	int n = 1;
    vector <string> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = (string) value;
	}

    metadata->SetUserDataString(
		tag, valuevec[0]
	);

	myBaseErrChk();

	
}



IDL_VPTR vdfGetUserDataString(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    IDL_ENSURE_SCALAR(argv[1]);

    
    
    char *tag = IDL_VarGetString(argv[1]);

    
    string tagvec = tag;

	int n;

    const string  value = metadata->GetUserDataString(tag);
    const string  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	result = IDL_StrToSTRING((char *) valueptr->c_str());

	n = 0;
    for(int i=0; i<n; i++) {
		
    }

	return(result);

}


IDL_VPTR vdfGetUserDataStringTags(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<string>  value = metadata->GetUserDataStringTags();
    const vector<string>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_STRING *result_ptr = (IDL_STRING *) IDL_MakeTempVector( IDL_TYP_STRING, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		IDL_StrStore(&result_ptr[i], (char *) (*valueptr)[i].c_str());
    }

	return(result);

}


void vdfSetTSUserDataLong(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    IDL_ENSURE_SCALAR(argv[2]);
    IDL_ENSURE_ARRAY(argv[3]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    char *tag = IDL_VarGetString(argv[2]);
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[3],IDL_TYP_LONG); IDL_LONG *valptr = (IDL_LONG *) valvar->value.arr->data;

    
    string tagvec = tag;
	int n = valvar->value.arr->n_elts;
    vector <long> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = valptr[i];
	}

    metadata->SetTSUserDataLong(
		ts, tag, valuevec
	);

	myBaseErrChk();

	if (valvar != argv[3]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetTSUserDataLong(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    IDL_ENSURE_SCALAR(argv[2]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    char *tag = IDL_VarGetString(argv[2]);

    
    string tagvec = tag;

	int n;

    const vector<long>  value = metadata->GetTSUserDataLong(ts, tag);
    const vector<long>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_LONG *result_ptr = (IDL_LONG *) IDL_MakeTempVector( IDL_TYP_LONG, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		result_ptr[i] = (IDL_LONG) (*valueptr)[i];
    }

	return(result);

}


IDL_VPTR vdfGetTSUserDataLongTags(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<string>  value = metadata->GetTSUserDataLongTags();
    const vector<string>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_STRING *result_ptr = (IDL_STRING *) IDL_MakeTempVector( IDL_TYP_STRING, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		IDL_StrStore(&result_ptr[i], (char *) (*valueptr)[i].c_str());
    }

	return(result);

}


void vdfSetTSUserDataDouble(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    IDL_ENSURE_SCALAR(argv[2]);
    IDL_ENSURE_ARRAY(argv[3]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    char *tag = IDL_VarGetString(argv[2]);
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[3],IDL_TYP_DOUBLE); double *valptr = (double *) valvar->value.arr->data;

    
    string tagvec = tag;
	int n = valvar->value.arr->n_elts;
    vector <double> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = valptr[i];
	}

    metadata->SetTSUserDataDouble(
		ts, tag, valuevec
	);

	myBaseErrChk();

	if (valvar != argv[3]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetTSUserDataDouble(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    IDL_ENSURE_SCALAR(argv[2]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    char *tag = IDL_VarGetString(argv[2]);

    
    string tagvec = tag;

	int n;

    const vector<double>  value = metadata->GetTSUserDataDouble(ts, tag);
    const vector<double>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	double *result_ptr = (double *) IDL_MakeTempVector( IDL_TYP_DOUBLE, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		result_ptr[i] = (double) (*valueptr)[i];
    }

	return(result);

}


IDL_VPTR vdfGetTSUserDataDoubleTags(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<string>  value = metadata->GetTSUserDataDoubleTags();
    const vector<string>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_STRING *result_ptr = (IDL_STRING *) IDL_MakeTempVector( IDL_TYP_STRING, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		IDL_StrStore(&result_ptr[i], (char *) (*valueptr)[i].c_str());
    }

	return(result);

}


void vdfSetTSUserDataString(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    IDL_ENSURE_SCALAR(argv[2]);
    IDL_ENSURE_SCALAR(argv[3]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    char *tag = IDL_VarGetString(argv[2]);
    char    *value = IDL_VarGetString(argv[3]);

    
    string tagvec = tag;
	int n = 1;
    vector <string> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = (string) value;
	}

    metadata->SetTSUserDataString(
		ts, tag, valuevec[0]
	);

	myBaseErrChk();

	
}



IDL_VPTR vdfGetTSUserDataString(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    
    IDL_ENSURE_SCALAR(argv[2]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    
    char *tag = IDL_VarGetString(argv[2]);

    
    string tagvec = tag;

	int n;

    const string  value = metadata->GetTSUserDataString(ts, tag);
    const string  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	result = IDL_StrToSTRING((char *) valueptr->c_str());

	n = 0;
    for(int i=0; i<n; i++) {
		
    }

	return(result);

}


IDL_VPTR vdfGetTSUserDataStringTags(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<string>  value = metadata->GetTSUserDataStringTags();
    const vector<string>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_STRING *result_ptr = (IDL_STRING *) IDL_MakeTempVector( IDL_TYP_STRING, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		IDL_StrStore(&result_ptr[i], (char *) (*valueptr)[i].c_str());
    }

	return(result);

}


void vdfSetVUserDataLong(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    IDL_ENSURE_SCALAR(argv[2]);
    IDL_ENSURE_SCALAR(argv[3]);
    IDL_ENSURE_ARRAY(argv[4]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    char *var = IDL_VarGetString(argv[2]);
    char *tag = IDL_VarGetString(argv[3]);
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[4],IDL_TYP_LONG); IDL_LONG *valptr = (IDL_LONG *) valvar->value.arr->data;

    string varvec = var;
    string tagvec = tag;
	int n = valvar->value.arr->n_elts;
    vector <long> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = valptr[i];
	}

    metadata->SetVUserDataLong(
		ts, var, tag, valuevec
	);

	myBaseErrChk();

	if (valvar != argv[4]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetVUserDataLong(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    IDL_ENSURE_SCALAR(argv[2]);
    IDL_ENSURE_SCALAR(argv[3]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    char *var = IDL_VarGetString(argv[2]);
    char *tag = IDL_VarGetString(argv[3]);

    string varvec = var;
    string tagvec = tag;

	int n;

    const vector<long>  value = metadata->GetVUserDataLong(ts, var, tag);
    const vector<long>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_LONG *result_ptr = (IDL_LONG *) IDL_MakeTempVector( IDL_TYP_LONG, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		result_ptr[i] = (IDL_LONG) (*valueptr)[i];
    }

	return(result);

}


IDL_VPTR vdfGetVUserDataLongTags(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<string>  value = metadata->GetVUserDataLongTags();
    const vector<string>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_STRING *result_ptr = (IDL_STRING *) IDL_MakeTempVector( IDL_TYP_STRING, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		IDL_StrStore(&result_ptr[i], (char *) (*valueptr)[i].c_str());
    }

	return(result);

}


void vdfSetVUserDataDouble(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    IDL_ENSURE_SCALAR(argv[2]);
    IDL_ENSURE_SCALAR(argv[3]);
    IDL_ENSURE_ARRAY(argv[4]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    char *var = IDL_VarGetString(argv[2]);
    char *tag = IDL_VarGetString(argv[3]);
    IDL_VPTR valvar = IDL_BasicTypeConversion(1, &argv[4],IDL_TYP_DOUBLE); double *valptr = (double *) valvar->value.arr->data;

    string varvec = var;
    string tagvec = tag;
	int n = valvar->value.arr->n_elts;
    vector <double> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = valptr[i];
	}

    metadata->SetVUserDataDouble(
		ts, var, tag, valuevec
	);

	myBaseErrChk();

	if (valvar != argv[4]) IDL_Deltmp(valvar);
}



IDL_VPTR vdfGetVUserDataDouble(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    IDL_ENSURE_SCALAR(argv[2]);
    IDL_ENSURE_SCALAR(argv[3]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    char *var = IDL_VarGetString(argv[2]);
    char *tag = IDL_VarGetString(argv[3]);

    string varvec = var;
    string tagvec = tag;

	int n;

    const vector<double>  value = metadata->GetVUserDataDouble(ts, var, tag);
    const vector<double>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	double *result_ptr = (double *) IDL_MakeTempVector( IDL_TYP_DOUBLE, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		result_ptr[i] = (double) (*valueptr)[i];
    }

	return(result);

}


IDL_VPTR vdfGetVUserDataDoubleTags(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<string>  value = metadata->GetVUserDataDoubleTags();
    const vector<string>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_STRING *result_ptr = (IDL_STRING *) IDL_MakeTempVector( IDL_TYP_STRING, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		IDL_StrStore(&result_ptr[i], (char *) (*valueptr)[i].c_str());
    }

	return(result);

}


void vdfSetVUserDataString(int argc, IDL_VPTR *argv)
{
    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    IDL_ENSURE_SCALAR(argv[2]);
    IDL_ENSURE_SCALAR(argv[3]);
    IDL_ENSURE_SCALAR(argv[4]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    char *var = IDL_VarGetString(argv[2]);
    char *tag = IDL_VarGetString(argv[3]);
    char    *value = IDL_VarGetString(argv[4]);

    string varvec = var;
    string tagvec = tag;
	int n = 1;
    vector <string> valuevec(n);

	for(int i = 0; i<n; i++) {
		valuevec[i] = (string) value;
	}

    metadata->SetVUserDataString(
		ts, var, tag, valuevec[0]
	);

	myBaseErrChk();

	
}



IDL_VPTR vdfGetVUserDataString(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    IDL_ENSURE_SCALAR(argv[1]);
    IDL_ENSURE_SCALAR(argv[2]);
    IDL_ENSURE_SCALAR(argv[3]);

    size_t ts = (size_t) IDL_LongScalar(argv[1]);
    char *var = IDL_VarGetString(argv[2]);
    char *tag = IDL_VarGetString(argv[3]);

    string varvec = var;
    string tagvec = tag;

	int n;

    const string  value = metadata->GetVUserDataString(ts, var, tag);
    const string  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	result = IDL_StrToSTRING((char *) valueptr->c_str());

	n = 0;
    for(int i=0; i<n; i++) {
		
    }

	return(result);

}


IDL_VPTR vdfGetVUserDataStringTags(int argc, IDL_VPTR *argv)
{

    MetadataVDC    *metadata = varGetMetadata(argv[0]);
    
    
    

    
    
    

    
    

	int n;

    const vector<string>  value = metadata->GetVUserDataStringTags();
    const vector<string>  *valueptr = &value;
    if (int rc = MetadataVDC::GetErrCode()) {
		if (rc != XmlNode::ERR_TNP) {
			myBaseErrChk();
        }
        else {
			IDL_Message(
				IDL_M_NAMED_GENERIC, IDL_MSG_INFO, 
				"Requested element not present in metafile"
			);
			valueptr = NULL;
        }
    }
    IDL_VPTR result;

	if (valueptr && valueptr->size() < 1) valueptr = NULL;

	if (! valueptr) {
		result = IDL_Gettmp();
		result->type = IDL_TYP_UNDEF;
		return(result);
	}

	IDL_STRING *result_ptr = (IDL_STRING *) IDL_MakeTempVector( IDL_TYP_STRING, valueptr->size(), IDL_ARR_INI_NOP, &result);

	n = valueptr->size();
    for(int i=0; i<n; i++) {
		IDL_StrStore(&result_ptr[i], (char *) (*valueptr)[i].c_str());
    }

	return(result);

}



};

int IDL_LoadMeta(void)
{
	//
	//These tables contain information on the functions and procedures
	//that make up the TESTMODULE DLM. The information contained in these
	//tables must be identical to that contained in testmodule.dlm.
	//
	static IDL_SYSFUN_DEF2 func_addr[] = {
		
		{ (IDL_SYSRTN_GENERIC) vdfGetGridType,
		(char *) "VDF_GETGRIDTYPE", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetCoordSystemType,
		(char *) "VDF_GETCOORDTYPE", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetExtents,
		(char *) "VDF_GETEXTENTS", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetNumTimeSteps,
		(char *) "VDF_GETNUMTIMESTEPS", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetVariableNames,
		(char *) "VDF_GETVARNAMES", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetVariables3D,
		(char *) "VDF_GETVARIABLES3D", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetVariables2DXY,
		(char *) "VDF_GETVARIABLES2DXY", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetVariables2DXZ,
		(char *) "VDF_GETVARIABLES2DXZ", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetVariables2DYZ,
		(char *) "VDF_GETVARIABLES2DYZ", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetComment,
		(char *) "VDF_GETCOMMENT", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetMapProjection,
		(char *) "VDF_GETMAPPROJECTION", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetPeriodicBoundary,
		(char *) "VDF_GETPERIODIC", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetTSExtents,
		(char *) "VDF_GETTEXTENTS", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetTSUserTime,
		(char *) "VDF_GETTUSERTIME", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetTSXCoords,
		(char *) "VDF_GETTXCOORDS", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetTSYCoords,
		(char *) "VDF_GETTYCOORDS", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetTSZCoords,
		(char *) "VDF_GETTZCOORDS", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetTSComment,
		(char *) "VDF_GETTCOMMENT", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetVComment,
		(char *) "VDF_GETVCOMMENT", 3, 3, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetVDataRange,
		(char *) "VDF_GETVDRANGE", 3, 3, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetUserDataLong,
		(char *) "VDF_GETLONG", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetUserDataLongTags,
		(char *) "VDF_GETLONGTAGS", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetUserDataDouble,
		(char *) "VDF_GETDBL", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetUserDataDoubleTags,
		(char *) "VDF_GETDBLTAGS", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetUserDataString,
		(char *) "VDF_GETSTR", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetUserDataStringTags,
		(char *) "VDF_GETSTRTAGS", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetTSUserDataLong,
		(char *) "VDF_GETTLONG", 3, 3, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetTSUserDataLongTags,
		(char *) "VDF_GETTLONGTAGS", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetTSUserDataDouble,
		(char *) "VDF_GETTDBL", 3, 3, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetTSUserDataDoubleTags,
		(char *) "VDF_GETTDBLTAGS", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetTSUserDataString,
		(char *) "VDF_GETTSTR", 3, 3, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetTSUserDataStringTags,
		(char *) "VDF_GETTSTRTAGS", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetVUserDataLong,
		(char *) "VDF_GETVLONG", 4, 4, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetVUserDataLongTags,
		(char *) "VDF_GETVLONGTAGS", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetVUserDataDouble,
		(char *) "VDF_GETVDBL", 4, 4, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetVUserDataDoubleTags,
		(char *) "VDF_GETVDBLTAGS", 1, 1, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetVUserDataString,
		(char *) "VDF_GETVSTR", 4, 4, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfGetVUserDataStringTags,
		(char *) "VDF_GETVSTRTAGS", 1, 1, 0, 0
		}
	};

	static IDL_SYSFUN_DEF2 proc_addr[] = {
		
		{ (IDL_SYSRTN_GENERIC) vdfSetGridType,
		(char *) "VDF_SETGRIDTYPE", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetCoordSystemType,
		(char *) "VDF_SETCOORDTYPE", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetExtents,
		(char *) "VDF_SETEXTENTS", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetNumTimeSteps,
		(char *) "VDF_SETNUMTIMESTEPS", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetVariableNames,
		(char *) "VDF_SETVARNAMES", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetVariables3D,
		(char *) "VDF_SETVARIABLES3D", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetVariables2DXY,
		(char *) "VDF_SETVARIABLES2DXY", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetVariables2DXZ,
		(char *) "VDF_SETVARIABLES2DXZ", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetVariables2DYZ,
		(char *) "VDF_SETVARIABLES2DYZ", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetComment,
		(char *) "VDF_SETCOMMENT", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetMapProjection,
		(char *) "VDF_SETMAPPROJECTION", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetPeriodicBoundary,
		(char *) "VDF_SETPERIODIC", 2, 2, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetTSExtents,
		(char *) "VDF_SETTEXTENTS", 3, 3, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetTSUserTime,
		(char *) "VDF_SETTUSERTIME", 3, 3, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetTSXCoords,
		(char *) "VDF_SETTXCOORDS", 3, 3, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetTSYCoords,
		(char *) "VDF_SETTYCOORDS", 3, 3, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetTSZCoords,
		(char *) "VDF_SETTZCOORDS", 3, 3, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetTSComment,
		(char *) "VDF_SETTCOMMENT", 3, 3, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetVComment,
		(char *) "VDF_SETVCOMMENT", 4, 4, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetVDataRange,
		(char *) "VDF_SETVDRANGE", 4, 4, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetUserDataLong,
		(char *) "VDF_SETLONG", 3, 3, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetUserDataDouble,
		(char *) "VDF_SETDBL", 3, 3, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetUserDataString,
		(char *) "VDF_SETSTR", 3, 3, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetTSUserDataLong,
		(char *) "VDF_SETTLONG", 4, 4, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetTSUserDataDouble,
		(char *) "VDF_SETTDBL", 4, 4, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetTSUserDataString,
		(char *) "VDF_SETTSTR", 4, 4, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetVUserDataLong,
		(char *) "VDF_SETVLONG", 5, 5, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetVUserDataDouble,
		(char *) "VDF_SETVDBL", 5, 5, 0, 0
		}
		,
		{ (IDL_SYSRTN_GENERIC) vdfSetVUserDataString,
		(char *) "VDF_SETVSTR", 5, 5, 0, 0
		}
	};

	return IDL_SysRtnAdd(func_addr, TRUE, IDL_CARRAY_ELTS(func_addr)) && 
		IDL_SysRtnAdd(proc_addr, FALSE, IDL_CARRAY_ELTS(proc_addr));

}

