/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _is_sealed;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_immutable;
	gboolean* _is_singleton;
	ValaList* base_types;
	ValaHashMap* implicit_implementations;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};

static gint ValaClass_private_offset;
static gpointer vala_class_parent_class = NULL;

static gboolean* _bool_dup (gboolean* self);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static guint _vala_symbol_hash_func_ghash_func (gconstpointer key);
static gboolean _vala_symbol_equal_func_gequal_func (gconstpointer a,
                                              gconstpointer b);
static void vala_class_set_default_construction_method (ValaClass* self,
                                                 ValaCreationMethod* value);
static void vala_class_set_constructor (ValaClass* self,
                                 ValaConstructor* value);
static void vala_class_set_class_constructor (ValaClass* self,
                                       ValaConstructor* value);
static void vala_class_set_static_constructor (ValaClass* self,
                                        ValaConstructor* value);
static void vala_class_set_destructor (ValaClass* self,
                                ValaDestructor* value);
static void vala_class_set_static_destructor (ValaClass* self,
                                       ValaDestructor* value);
static void vala_class_set_class_destructor (ValaClass* self,
                                      ValaDestructor* value);
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_class_finalize (ValaCodeNode * obj);
static GType vala_class_get_type_once (void);

static inline gpointer
vala_class_get_instance_private (ValaClass* self)
{
	return G_STRUCT_MEMBER_P (self, ValaClass_private_offset);
}

ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}

gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_class_get_is_sealed (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_sealed;
	return result;
}

void
vala_class_set_is_sealed (ValaClass* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_sealed = value;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_compact (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_compact;
	result = *_tmp11_;
	return result;
}

void
vala_class_set_is_compact (ValaClass* self,
                           gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_compact);
	self->priv->_is_compact = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Compact", value, NULL);
}

gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_immutable (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_immutable;
	result = *_tmp11_;
	return result;
}

void
vala_class_set_is_immutable (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}

gboolean
vala_class_get_is_singleton (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_singleton;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SingleInstance");
		_tmp2_ = _tmp1_ != NULL;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (self->priv->_is_singleton);
		self->priv->_is_singleton = _tmp3_;
	}
	_tmp4_ = self->priv->_is_singleton;
	result = *_tmp4_;
	return result;
}

void
vala_class_set_is_singleton (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_singleton);
	self->priv->_is_singleton = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "SingleInstance", value, NULL);
}

gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}

void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}

gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}

static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}

static guint
_vala_symbol_hash_func_ghash_func (gconstpointer key)
{
	guint result;
	result = vala_symbol_hash_func ((ValaSymbol*) key);
	return result;
}

static gboolean
_vala_symbol_equal_func_gequal_func (gconstpointer a,
                                     gconstpointer b)
{
	gboolean result;
	result = vala_symbol_equal_func ((ValaSymbol*) a, (ValaSymbol*) b);
	return result;
}

ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}

ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	result = _tmp0_ != NULL;
	return result;
}

/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}

/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}

/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp23_ = FALSE;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != VALA_MEMBER_BINDING_STATIC) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameter* _tmp14_;
		ValaScope* _tmp15_;
		ValaScope* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_parameter_new ("this", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_method_set_this_parameter (m, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_method_get_this_parameter (m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_method_get_this_parameter (m);
		_tmp22_ = _tmp21_;
		vala_scope_add (_tmp16_, _tmp20_, (ValaSymbol*) _tmp22_);
	}
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp25_ = _tmp24_;
	if (!VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp26_ = vala_method_get_postconditions (m);
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp23_ = _tmp28_ > 0;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaDataType* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaLocalVariable* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		_tmp29_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp30_ = _tmp29_;
		if (_tmp30_ != NULL) {
			ValaScope* _tmp31_;
			ValaScope* _tmp32_;
			ValaLocalVariable* _tmp33_;
			ValaLocalVariable* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp31_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
			_tmp36_ = _tmp35_;
			vala_scope_remove (_tmp32_, _tmp36_);
		}
		_tmp37_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_data_type_copy (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_local_variable_new (_tmp40_, "result", NULL, _tmp42_);
		_tmp44_ = _tmp43_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp44_);
		_vala_code_node_unref0 (_tmp44_);
		_vala_code_node_unref0 (_tmp40_);
		_tmp45_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp46_ = _tmp45_;
		vala_local_variable_set_is_result (_tmp46_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		ValaCreationMethod* cm = NULL;
		gboolean _tmp49_ = FALSE;
		ValaCreationMethod* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_;
		_tmp47_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp48_ = _tmp47_;
		if (_tmp48_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		cm = G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
		_tmp50_ = cm;
		_tmp51_ = vala_creation_method_get_class_name (_tmp50_);
		_tmp52_ = _tmp51_;
		if (_tmp52_ != NULL) {
			ValaCreationMethod* _tmp53_;
			const gchar* _tmp54_;
			const gchar* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			_tmp53_ = cm;
			_tmp54_ = vala_creation_method_get_class_name (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp57_ = _tmp56_;
			_tmp49_ = g_strcmp0 (_tmp55_, _tmp57_) != 0;
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			ValaSourceReference* _tmp58_;
			ValaSourceReference* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			ValaCreationMethod* _tmp62_;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = cm;
			_tmp63_ = vala_creation_method_get_class_name (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp61_, _tmp64_);
			_tmp66_ = _tmp65_;
			vala_report_error (_tmp59_, _tmp66_);
			_g_free0 (_tmp66_);
			_g_free0 (_tmp61_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
		_tmp68_ = self->priv->_is_abstract;
		if (_tmp68_) {
			ValaCreationMethod* _tmp69_;
			ValaSymbolAccessibility _tmp70_;
			ValaSymbolAccessibility _tmp71_;
			_tmp69_ = cm;
			_tmp70_ = vala_symbol_get_access ((ValaSymbol*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp67_ = _tmp71_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		} else {
			_tmp67_ = FALSE;
		}
		if (_tmp67_) {
			gboolean _tmp72_;
			gboolean _tmp73_;
			_tmp72_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp73_ = _tmp72_;
			if (_tmp73_) {
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp75_ = _tmp74_;
				vala_report_warning (_tmp75_, "Creation method of abstract class cannot be public.");
			} else {
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp77_ = _tmp76_;
				vala_report_error (_tmp77_, "Creation method of abstract class cannot be public.");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				return;
			}
		}
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValaHashMap*
vala_class_get_implicit_implementations (ValaClass* self)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	ValaHashMap* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->implicit_implementations;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaField* _tmp14_;
	ValaField* _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_property_get_binding (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaParameter* _tmp4_;
		ValaParameter* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaParameter* _tmp8_;
		ValaParameter* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ValaParameter* _tmp12_;
		ValaParameter* _tmp13_;
		_tmp2_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_parameter_new ("this", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		vala_property_set_this_parameter (prop, _tmp5_);
		_vala_code_node_unref0 (_tmp5_);
		_vala_code_node_unref0 (_tmp3_);
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_property_get_this_parameter (prop);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_name ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_property_get_this_parameter (prop);
		_tmp13_ = _tmp12_;
		vala_scope_add (_tmp7_, _tmp11_, (ValaSymbol*) _tmp13_);
	}
	_tmp14_ = vala_property_get_field (prop);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaField* _tmp16_;
		ValaField* _tmp17_;
		_tmp16_ = vala_property_get_field (prop);
		_tmp17_ = _tmp16_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp17_);
	}
}

static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaConstructor* _tmp2_;
			ValaConstructor* _tmp3_;
			_tmp2_ = vala_class_get_constructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a constructor");
			}
			vala_class_set_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaConstructor* _tmp6_;
			ValaConstructor* _tmp7_;
			_tmp6_ = vala_class_get_class_constructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaConstructor* _tmp10_;
			ValaConstructor* _tmp11_;
			_tmp10_ = vala_class_get_static_constructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_constructor_get_binding (c);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaParameter* _tmp26_;
		ValaParameter* _tmp27_;
		ValaScope* _tmp28_;
		ValaScope* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		ValaParameter* _tmp34_;
		ValaParameter* _tmp35_;
		_tmp16_ = vala_constructor_get_this_parameter (c);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) c);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_constructor_get_this_parameter (c);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) c, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_parameter_new ("this", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		vala_constructor_set_this_parameter (c, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp28_ = vala_symbol_get_scope ((ValaSymbol*) c);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_constructor_get_this_parameter (c);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_constructor_get_this_parameter (c);
		_tmp35_ = _tmp34_;
		vala_scope_add (_tmp29_, _tmp33_, (ValaSymbol*) _tmp35_);
	}
}

static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaDestructor* _tmp2_;
			ValaDestructor* _tmp3_;
			_tmp2_ = vala_class_get_destructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a destructor");
			}
			vala_class_set_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaDestructor* _tmp6_;
			ValaDestructor* _tmp7_;
			_tmp6_ = vala_class_get_class_destructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaDestructor* _tmp10_;
			ValaDestructor* _tmp11_;
			_tmp10_ = vala_class_get_static_destructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_destructor_get_binding (d);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaParameter* _tmp26_;
		ValaParameter* _tmp27_;
		ValaScope* _tmp28_;
		ValaScope* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		ValaParameter* _tmp34_;
		ValaParameter* _tmp35_;
		_tmp16_ = vala_destructor_get_this_parameter (d);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) d);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_destructor_get_this_parameter (d);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) d, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_parameter_new ("this", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		vala_destructor_set_this_parameter (d, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp28_ = vala_symbol_get_scope ((ValaSymbol*) d);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_destructor_get_this_parameter (d);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_destructor_get_this_parameter (d);
		_tmp35_ = _tmp34_;
		vala_scope_add (_tmp29_, _tmp33_, (ValaSymbol*) _tmp35_);
	}
}

static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp10_;
	ValaConstructor* _tmp11_;
	ValaConstructor* _tmp14_;
	ValaConstructor* _tmp15_;
	ValaConstructor* _tmp18_;
	ValaConstructor* _tmp19_;
	ValaDestructor* _tmp22_;
	ValaDestructor* _tmp23_;
	ValaDestructor* _tmp26_;
	ValaDestructor* _tmp27_;
	ValaDestructor* _tmp30_;
	ValaDestructor* _tmp31_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* type = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaDataType* _tmp9_;
			_type_index = _type_index + 1;
			_tmp5_ = _type_index;
			_tmp6_ = _type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _type_list;
			_tmp8_ = vala_list_get (_tmp7_, _type_index);
			type = (ValaDataType*) _tmp8_;
			_tmp9_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
	_tmp10_ = vala_class_get_constructor (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ValaConstructor* _tmp12_;
		ValaConstructor* _tmp13_;
		_tmp12_ = vala_class_get_constructor (self);
		_tmp13_ = _tmp12_;
		vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
	}
	_tmp14_ = vala_class_get_class_constructor (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaConstructor* _tmp16_;
		ValaConstructor* _tmp17_;
		_tmp16_ = vala_class_get_class_constructor (self);
		_tmp17_ = _tmp16_;
		vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
	}
	_tmp18_ = vala_class_get_static_constructor (self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		ValaConstructor* _tmp20_;
		ValaConstructor* _tmp21_;
		_tmp20_ = vala_class_get_static_constructor (self);
		_tmp21_ = _tmp20_;
		vala_code_node_accept ((ValaCodeNode*) _tmp21_, visitor);
	}
	_tmp22_ = vala_class_get_destructor (self);
	_tmp23_ = _tmp22_;
	if (_tmp23_ != NULL) {
		ValaDestructor* _tmp24_;
		ValaDestructor* _tmp25_;
		_tmp24_ = vala_class_get_destructor (self);
		_tmp25_ = _tmp24_;
		vala_code_node_accept ((ValaCodeNode*) _tmp25_, visitor);
	}
	_tmp26_ = vala_class_get_static_destructor (self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != NULL) {
		ValaDestructor* _tmp28_;
		ValaDestructor* _tmp29_;
		_tmp28_ = vala_class_get_static_destructor (self);
		_tmp29_ = _tmp28_;
		vala_code_node_accept ((ValaCodeNode*) _tmp29_, visitor);
	}
	_tmp30_ = vala_class_get_class_destructor (self);
	_tmp31_ = _tmp30_;
	if (_tmp31_ != NULL) {
		ValaDestructor* _tmp32_;
		ValaDestructor* _tmp33_;
		_tmp32_ = vala_class_get_class_destructor (self);
		_tmp33_ = _tmp32_;
		vala_code_node_accept ((ValaCodeNode*) _tmp33_, visitor);
	}
}

static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}

gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			ValaDataType* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			_base_type_index = _base_type_index + 1;
			_tmp5_ = _base_type_index;
			_tmp6_ = _base_type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _base_type_list;
			_tmp8_ = vala_list_get (_tmp7_, _base_type_index);
			base_type = (ValaDataType*) _tmp8_;
			_tmp11_ = base_type;
			_tmp12_ = vala_data_type_get_type_symbol (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				ValaDataType* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				_tmp14_ = base_type;
				_tmp15_ = vala_data_type_get_type_symbol (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp10_ = _tmp16_ != G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				ValaDataType* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				ValaTypeSymbol* _tmp19_;
				_tmp17_ = base_type;
				_tmp18_ = vala_data_type_get_type_symbol (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp9_ = vala_typesymbol_is_subtype_of (_tmp19_, t);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->base_types;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->base_types;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->base_types;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prereq_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prereq_list = _tmp1_;
		_tmp2_ = _prereq_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prereq_size = _tmp4_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			_prereq_index = _prereq_index + 1;
			_tmp5_ = _prereq_index;
			_tmp6_ = _prereq_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _prereq_list;
			_tmp8_ = vala_list_get (_tmp7_, _prereq_index);
			prereq = (ValaDataType*) _tmp8_;
			_tmp9_ = prereq;
			_tmp10_ = vala_data_type_get_type_symbol (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = _vala_code_node_ref0 (_tmp11_);
			type = _tmp12_;
			_tmp13_ = type;
			if (_tmp13_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp14_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp14_);
			_tmp15_ = type;
			if (VALA_IS_INTERFACE (_tmp15_)) {
				ValaTypeSymbol* _tmp16_;
				_tmp16_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}

gboolean
vala_class_is_a (ValaClass* self,
                 ValaObjectTypeSymbol* t)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_base_type_index = _base_type_index + 1;
			_tmp5_ = _base_type_index;
			_tmp6_ = _base_type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _base_type_list;
			_tmp8_ = vala_list_get (_tmp7_, _base_type_index);
			base_type = (ValaDataType*) _tmp8_;
			_tmp9_ = base_type;
			_tmp10_ = vala_data_type_get_type_symbol (_tmp9_);
			_tmp11_ = _tmp10_;
			if (VALA_IS_CLASS (_tmp11_)) {
				ValaDataType* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				_tmp12_ = base_type;
				_tmp13_ = vala_data_type_get_type_symbol (_tmp12_);
				_tmp14_ = _tmp13_;
				if (vala_class_is_a (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				_tmp15_ = base_type;
				_tmp16_ = vala_data_type_get_type_symbol (_tmp15_);
				_tmp17_ = _tmp16_;
				if (_tmp17_ == G_TYPE_CHECK_INSTANCE_CAST (t, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

gboolean
vala_class_implements (ValaClass* self,
                       ValaInterface* i)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_base_type_index = _base_type_index + 1;
			_tmp5_ = _base_type_index;
			_tmp6_ = _base_type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _base_type_list;
			_tmp8_ = vala_list_get (_tmp7_, _base_type_index);
			base_type = (ValaDataType*) _tmp8_;
			_tmp9_ = base_type;
			_tmp10_ = vala_data_type_get_type_symbol (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ == G_TYPE_CHECK_INSTANCE_CAST (i, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	gboolean _tmp92_ = FALSE;
	ValaClass* _tmp93_;
	gboolean _tmp106_ = FALSE;
	gboolean _tmp107_;
	gboolean _tmp108_;
	gboolean _tmp118_ = FALSE;
	gboolean _tmp119_;
	gboolean _tmp120_;
	gboolean _tmp132_ = FALSE;
	ValaClass* _tmp133_;
	gboolean _tmp145_;
	ValaConstructor* _tmp254_;
	ValaConstructor* _tmp255_;
	ValaConstructor* _tmp258_;
	ValaConstructor* _tmp259_;
	ValaConstructor* _tmp262_;
	ValaConstructor* _tmp263_;
	ValaDestructor* _tmp266_;
	ValaDestructor* _tmp267_;
	ValaDestructor* _tmp270_;
	ValaDestructor* _tmp271_;
	ValaDestructor* _tmp274_;
	ValaDestructor* _tmp275_;
	gboolean _tmp318_;
	gboolean _tmp319_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp364_;
	ValaArrayList* _tmp365_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp382_;
	ValaArrayList* _tmp383_;
	ValaList* _tmp398_;
	gint _tmp399_;
	gint _tmp400_;
	ValaSourceFileType _tmp425_;
	ValaSourceFileType _tmp426_;
	ValaSemanticAnalyzer* _tmp659_;
	ValaSemanticAnalyzer* _tmp660_;
	ValaSourceFile* _tmp661_;
	ValaSemanticAnalyzer* _tmp662_;
	ValaSemanticAnalyzer* _tmp663_;
	ValaSymbol* _tmp664_;
	gboolean _tmp665_;
	gboolean _tmp666_;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	if (!VALA_CODE_NODE_CLASS (vala_class_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), context)) {
		result = FALSE;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		ValaList* _tmp25_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_tmp25_ = _vala_iterable_ref0 (_tmp24_);
		_base_type_reference_list = _tmp25_;
		_tmp26_ = _base_type_reference_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_base_type_reference_size = _tmp28_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp31_;
			gpointer _tmp32_;
			ValaDataType* _tmp33_;
			ValaDataType* _tmp34_;
			ValaSemanticAnalyzer* _tmp44_;
			ValaSemanticAnalyzer* _tmp45_;
			ValaDataType* _tmp46_;
			gint n_type_args = 0;
			ValaDataType* _tmp56_;
			ValaList* _tmp57_;
			gint _tmp58_;
			gint _tmp59_;
			gint n_type_params = 0;
			ValaDataType* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			ValaList* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			_base_type_reference_index = _base_type_reference_index + 1;
			_tmp29_ = _base_type_reference_index;
			_tmp30_ = _base_type_reference_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _base_type_reference_list;
			_tmp32_ = vala_list_get (_tmp31_, _base_type_reference_index);
			base_type_reference = (ValaDataType*) _tmp32_;
			_tmp33_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp33_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp34_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp34_)) {
				ValaSourceReference* _tmp35_;
				ValaSourceReference* _tmp36_;
				ValaDataType* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp36_ = _tmp35_;
				_tmp37_ = base_type_reference;
				_tmp38_ = vala_code_node_to_string ((ValaCodeNode*) _tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_strdup_printf ("base type `%s' of class `%s' is not an object type", _tmp39_, _tmp41_);
				_tmp43_ = _tmp42_;
				vala_report_error (_tmp36_, _tmp43_);
				_g_free0 (_tmp43_);
				_g_free0 (_tmp41_);
				_g_free0 (_tmp39_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp44_ = vala_code_context_get_analyzer (context);
			_tmp45_ = _tmp44_;
			_tmp46_ = base_type_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp45_, (ValaSymbol*) self, _tmp46_)) {
				ValaSourceReference* _tmp47_;
				ValaSourceReference* _tmp48_;
				ValaDataType* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp47_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp48_ = _tmp47_;
				_tmp49_ = base_type_reference;
				_tmp50_ = vala_code_node_to_string ((ValaCodeNode*) _tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp53_ = _tmp52_;
				_tmp54_ = g_strdup_printf ("base type `%s' is less accessible than class `%s'", _tmp51_, _tmp53_);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp48_, _tmp55_);
				_g_free0 (_tmp55_);
				_g_free0 (_tmp53_);
				_g_free0 (_tmp51_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp56_ = base_type_reference;
			_tmp57_ = vala_data_type_get_type_arguments (_tmp56_);
			_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
			_tmp59_ = _tmp58_;
			n_type_args = _tmp59_;
			_tmp60_ = base_type_reference;
			_tmp61_ = vala_data_type_get_type_symbol (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
			_tmp65_ = _tmp64_;
			n_type_params = _tmp65_;
			if (n_type_args < n_type_params) {
				ValaDataType* _tmp66_;
				ValaSourceReference* _tmp67_;
				ValaSourceReference* _tmp68_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp66_ = base_type_reference;
				_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp66_);
				_tmp68_ = _tmp67_;
				vala_report_error (_tmp68_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				if (n_type_args > n_type_params) {
					ValaDataType* _tmp69_;
					ValaSourceReference* _tmp70_;
					ValaSourceReference* _tmp71_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp69_ = base_type_reference;
					_tmp70_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp69_);
					_tmp71_ = _tmp70_;
					vala_report_error (_tmp71_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp72_;
		ValaList* _tmp73_;
		gint _type_size = 0;
		ValaList* _tmp74_;
		gint _tmp75_;
		gint _tmp76_;
		gint _type_index = 0;
		_tmp72_ = self->priv->base_types;
		_tmp73_ = _vala_iterable_ref0 (_tmp72_);
		_type_list = _tmp73_;
		_tmp74_ = _type_list;
		_tmp75_ = vala_collection_get_size ((ValaCollection*) _tmp74_);
		_tmp76_ = _tmp75_;
		_type_size = _tmp76_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp77_;
			gint _tmp78_;
			ValaDataType* type = NULL;
			ValaList* _tmp79_;
			gpointer _tmp80_;
			ValaDataType* _tmp81_;
			_type_index = _type_index + 1;
			_tmp77_ = _type_index;
			_tmp78_ = _type_size;
			if (!(_tmp77_ < _tmp78_)) {
				break;
			}
			_tmp79_ = _type_list;
			_tmp80_ = vala_list_get (_tmp79_, _type_index);
			type = (ValaDataType*) _tmp80_;
			_tmp81_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp81_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp82_;
		ValaList* _tmp83_;
		gint _p_size = 0;
		ValaList* _tmp84_;
		gint _tmp85_;
		gint _tmp86_;
		gint _p_index = 0;
		_tmp82_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_tmp83_ = _vala_iterable_ref0 (_tmp82_);
		_p_list = _tmp83_;
		_tmp84_ = _p_list;
		_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
		_tmp86_ = _tmp85_;
		_p_size = _tmp86_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp87_;
			gint _tmp88_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp89_;
			gpointer _tmp90_;
			ValaTypeParameter* _tmp91_;
			_p_index = _p_index + 1;
			_tmp87_ = _p_index;
			_tmp88_ = _p_size;
			if (!(_tmp87_ < _tmp88_)) {
				break;
			}
			_tmp89_ = _p_list;
			_tmp90_ = vala_list_get (_tmp89_, _p_index);
			p = (ValaTypeParameter*) _tmp90_;
			_tmp91_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp91_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp93_ = self->priv->_base_class;
	if (_tmp93_ != NULL) {
		ValaClass* _tmp94_;
		gboolean _tmp95_;
		gboolean _tmp96_;
		_tmp94_ = self->priv->_base_class;
		_tmp95_ = vala_class_get_is_singleton (_tmp94_);
		_tmp96_ = _tmp95_;
		_tmp92_ = _tmp96_;
	} else {
		_tmp92_ = FALSE;
	}
	if (_tmp92_) {
		ValaSourceReference* _tmp97_;
		ValaSourceReference* _tmp98_;
		gchar* _tmp99_;
		gchar* _tmp100_;
		ValaClass* _tmp101_;
		gchar* _tmp102_;
		gchar* _tmp103_;
		gchar* _tmp104_;
		gchar* _tmp105_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp100_ = _tmp99_;
		_tmp101_ = self->priv->_base_class;
		_tmp102_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp101_);
		_tmp103_ = _tmp102_;
		_tmp104_ = g_strdup_printf ("`%s' cannot inherit from SingleInstance class `%s'", _tmp100_, _tmp103_);
		_tmp105_ = _tmp104_;
		vala_report_error (_tmp98_, _tmp105_);
		_g_free0 (_tmp105_);
		_g_free0 (_tmp103_);
		_g_free0 (_tmp100_);
	}
	_tmp107_ = vala_class_get_is_singleton (self);
	_tmp108_ = _tmp107_;
	if (_tmp108_) {
		ValaSemanticAnalyzer* _tmp109_;
		ValaSemanticAnalyzer* _tmp110_;
		ValaClass* _tmp111_;
		_tmp109_ = vala_code_context_get_analyzer (context);
		_tmp110_ = _tmp109_;
		_tmp111_ = _tmp110_->object_type;
		_tmp106_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp111_);
	} else {
		_tmp106_ = FALSE;
	}
	if (_tmp106_) {
		ValaSourceReference* _tmp112_;
		ValaSourceReference* _tmp113_;
		gchar* _tmp114_;
		gchar* _tmp115_;
		gchar* _tmp116_;
		gchar* _tmp117_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp112_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp115_ = _tmp114_;
		_tmp116_ = g_strdup_printf ("SingleInstance class `%s' requires inheritance from `GLib.Object'", _tmp115_);
		_tmp117_ = _tmp116_;
		vala_report_error (_tmp113_, _tmp117_);
		_g_free0 (_tmp117_);
		_g_free0 (_tmp115_);
	}
	_tmp119_ = vala_class_get_is_singleton (self);
	_tmp120_ = _tmp119_;
	if (_tmp120_) {
		ValaConstructor* _tmp121_;
		ValaConstructor* _tmp122_;
		_tmp121_ = vala_class_get_constructor (self);
		_tmp122_ = _tmp121_;
		_tmp118_ = _tmp122_ == NULL;
	} else {
		_tmp118_ = FALSE;
	}
	if (_tmp118_) {
		ValaConstructor* c = NULL;
		ValaSourceReference* _tmp123_;
		ValaSourceReference* _tmp124_;
		ValaConstructor* _tmp125_;
		ValaConstructor* _tmp126_;
		ValaSourceReference* _tmp127_;
		ValaSourceReference* _tmp128_;
		ValaBlock* _tmp129_;
		ValaBlock* _tmp130_;
		ValaConstructor* _tmp131_;
		_tmp123_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp124_ = _tmp123_;
		_tmp125_ = vala_constructor_new (_tmp124_);
		c = _tmp125_;
		_tmp126_ = c;
		_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_block_new (_tmp128_);
		_tmp130_ = _tmp129_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp126_, _tmp130_);
		_vala_code_node_unref0 (_tmp130_);
		_tmp131_ = c;
		vala_symbol_add_constructor ((ValaSymbol*) self, _tmp131_);
		_vala_code_node_unref0 (c);
	}
	_tmp133_ = self->priv->_base_class;
	if (_tmp133_ != NULL) {
		ValaClass* _tmp134_;
		gboolean _tmp135_;
		_tmp134_ = self->priv->_base_class;
		_tmp135_ = _tmp134_->priv->_is_sealed;
		_tmp132_ = _tmp135_;
	} else {
		_tmp132_ = FALSE;
	}
	if (_tmp132_) {
		ValaSourceReference* _tmp136_;
		ValaSourceReference* _tmp137_;
		gchar* _tmp138_;
		gchar* _tmp139_;
		ValaClass* _tmp140_;
		gchar* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		gchar* _tmp144_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp137_ = _tmp136_;
		_tmp138_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp139_ = _tmp138_;
		_tmp140_ = self->priv->_base_class;
		_tmp141_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp140_);
		_tmp142_ = _tmp141_;
		_tmp143_ = g_strdup_printf ("`%s' cannot inherit from sealed class `%s'", _tmp139_, _tmp142_);
		_tmp144_ = _tmp143_;
		vala_report_error (_tmp137_, _tmp144_);
		_g_free0 (_tmp144_);
		_g_free0 (_tmp142_);
		_g_free0 (_tmp139_);
	}
	_tmp145_ = self->priv->_is_sealed;
	if (_tmp145_) {
		gboolean _tmp146_;
		gboolean _tmp147_;
		gboolean _tmp154_;
		gboolean _tmp161_;
		gboolean _tmp162_;
		_tmp146_ = vala_class_get_is_compact (self);
		_tmp147_ = _tmp146_;
		if (_tmp147_) {
			ValaSourceReference* _tmp148_;
			ValaSourceReference* _tmp149_;
			gchar* _tmp150_;
			gchar* _tmp151_;
			gchar* _tmp152_;
			gchar* _tmp153_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp149_ = _tmp148_;
			_tmp150_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp151_ = _tmp150_;
			_tmp152_ = g_strdup_printf ("Sealed class `%s' cannot be compact", _tmp151_);
			_tmp153_ = _tmp152_;
			vala_report_error (_tmp149_, _tmp153_);
			_g_free0 (_tmp153_);
			_g_free0 (_tmp151_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp154_ = self->priv->_is_abstract;
		if (_tmp154_) {
			ValaSourceReference* _tmp155_;
			ValaSourceReference* _tmp156_;
			gchar* _tmp157_;
			gchar* _tmp158_;
			gchar* _tmp159_;
			gchar* _tmp160_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp156_ = _tmp155_;
			_tmp157_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp158_ = _tmp157_;
			_tmp159_ = g_strdup_printf ("Sealed class `%s' cannot be abstract", _tmp158_);
			_tmp160_ = _tmp159_;
			vala_report_error (_tmp156_, _tmp160_);
			_g_free0 (_tmp160_);
			_g_free0 (_tmp158_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp161_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp162_ = _tmp161_;
		if (!_tmp162_) {
			ValaSourceReference* _tmp163_;
			ValaSourceReference* _tmp164_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp163_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp164_ = _tmp163_;
			vala_report_error (_tmp164_, "Sealed classes are not fully supported yet");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp165_;
		ValaList* _tmp166_;
		gint _en_size = 0;
		ValaList* _tmp167_;
		gint _tmp168_;
		gint _tmp169_;
		gint _en_index = 0;
		_tmp165_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_tmp166_ = _vala_iterable_ref0 (_tmp165_);
		_en_list = _tmp166_;
		_tmp167_ = _en_list;
		_tmp168_ = vala_collection_get_size ((ValaCollection*) _tmp167_);
		_tmp169_ = _tmp168_;
		_en_size = _tmp169_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp170_;
			gint _tmp171_;
			ValaEnum* en = NULL;
			ValaList* _tmp172_;
			gpointer _tmp173_;
			ValaEnum* _tmp174_;
			_en_index = _en_index + 1;
			_tmp170_ = _en_index;
			_tmp171_ = _en_size;
			if (!(_tmp170_ < _tmp171_)) {
				break;
			}
			_tmp172_ = _en_list;
			_tmp173_ = vala_list_get (_tmp172_, _en_index);
			en = (ValaEnum*) _tmp173_;
			_tmp174_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp174_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp175_;
		ValaList* _tmp176_;
		gint _f_size = 0;
		ValaList* _tmp177_;
		gint _tmp178_;
		gint _tmp179_;
		gint _f_index = 0;
		_tmp175_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_tmp176_ = _vala_iterable_ref0 (_tmp175_);
		_f_list = _tmp176_;
		_tmp177_ = _f_list;
		_tmp178_ = vala_collection_get_size ((ValaCollection*) _tmp177_);
		_tmp179_ = _tmp178_;
		_f_size = _tmp179_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp180_;
			gint _tmp181_;
			ValaField* f = NULL;
			ValaList* _tmp182_;
			gpointer _tmp183_;
			gboolean _tmp184_ = FALSE;
			gboolean _tmp185_;
			gboolean _tmp186_;
			ValaField* _tmp204_;
			_f_index = _f_index + 1;
			_tmp180_ = _f_index;
			_tmp181_ = _f_size;
			if (!(_tmp180_ < _tmp181_)) {
				break;
			}
			_tmp182_ = _f_list;
			_tmp183_ = vala_list_get (_tmp182_, _f_index);
			f = (ValaField*) _tmp183_;
			_tmp185_ = vala_class_get_is_compact (self);
			_tmp186_ = _tmp185_;
			if (_tmp186_) {
				ValaField* _tmp187_;
				ValaMemberBinding _tmp188_;
				ValaMemberBinding _tmp189_;
				_tmp187_ = f;
				_tmp188_ = vala_field_get_binding (_tmp187_);
				_tmp189_ = _tmp188_;
				_tmp184_ = _tmp189_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp184_ = FALSE;
			}
			if (_tmp184_) {
				gboolean _tmp190_ = FALSE;
				gboolean _tmp191_;
				gboolean _tmp192_;
				ValaField* _tmp198_;
				ValaMemberBinding _tmp199_;
				ValaMemberBinding _tmp200_;
				_tmp191_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp192_ = _tmp191_;
				if (!_tmp192_) {
					ValaField* _tmp193_;
					ValaSymbolAccessibility _tmp194_;
					ValaSymbolAccessibility _tmp195_;
					_tmp193_ = f;
					_tmp194_ = vala_symbol_get_access ((ValaSymbol*) _tmp193_);
					_tmp195_ = _tmp194_;
					_tmp190_ = _tmp195_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp190_ = FALSE;
				}
				if (_tmp190_) {
					ValaSourceReference* _tmp196_;
					ValaSourceReference* _tmp197_;
					_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp197_ = _tmp196_;
					vala_report_error (_tmp197_, "private fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp198_ = f;
				_tmp199_ = vala_field_get_binding (_tmp198_);
				_tmp200_ = _tmp199_;
				if (_tmp200_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp201_;
					ValaSourceReference* _tmp202_;
					ValaSourceReference* _tmp203_;
					_tmp201_ = f;
					_tmp202_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp201_);
					_tmp203_ = _tmp202_;
					vala_report_error (_tmp203_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp204_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp204_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp205_;
		ValaList* _tmp206_;
		gint _c_size = 0;
		ValaList* _tmp207_;
		gint _tmp208_;
		gint _tmp209_;
		gint _c_index = 0;
		_tmp205_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_tmp206_ = _vala_iterable_ref0 (_tmp205_);
		_c_list = _tmp206_;
		_tmp207_ = _c_list;
		_tmp208_ = vala_collection_get_size ((ValaCollection*) _tmp207_);
		_tmp209_ = _tmp208_;
		_c_size = _tmp209_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp210_;
			gint _tmp211_;
			ValaConstant* c = NULL;
			ValaList* _tmp212_;
			gpointer _tmp213_;
			ValaConstant* _tmp214_;
			_c_index = _c_index + 1;
			_tmp210_ = _c_index;
			_tmp211_ = _c_size;
			if (!(_tmp210_ < _tmp211_)) {
				break;
			}
			_tmp212_ = _c_list;
			_tmp213_ = vala_list_get (_tmp212_, _c_index);
			c = (ValaConstant*) _tmp213_;
			_tmp214_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp214_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp215_;
		ValaList* _tmp216_;
		gint _m_size = 0;
		ValaList* _tmp217_;
		gint _tmp218_;
		gint _tmp219_;
		gint _m_index = 0;
		_tmp215_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_tmp216_ = _vala_iterable_ref0 (_tmp215_);
		_m_list = _tmp216_;
		_tmp217_ = _m_list;
		_tmp218_ = vala_collection_get_size ((ValaCollection*) _tmp217_);
		_tmp219_ = _tmp218_;
		_m_size = _tmp219_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp220_;
			gint _tmp221_;
			ValaMethod* m = NULL;
			ValaList* _tmp222_;
			gpointer _tmp223_;
			ValaMethod* _tmp224_;
			_m_index = _m_index + 1;
			_tmp220_ = _m_index;
			_tmp221_ = _m_size;
			if (!(_tmp220_ < _tmp221_)) {
				break;
			}
			_tmp222_ = _m_list;
			_tmp223_ = vala_list_get (_tmp222_, _m_index);
			m = (ValaMethod*) _tmp223_;
			_tmp224_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp224_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp225_;
		ValaList* _tmp226_;
		gint _prop_size = 0;
		ValaList* _tmp227_;
		gint _tmp228_;
		gint _tmp229_;
		gint _prop_index = 0;
		_tmp225_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_tmp226_ = _vala_iterable_ref0 (_tmp225_);
		_prop_list = _tmp226_;
		_tmp227_ = _prop_list;
		_tmp228_ = vala_collection_get_size ((ValaCollection*) _tmp227_);
		_tmp229_ = _tmp228_;
		_prop_size = _tmp229_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp230_;
			gint _tmp231_;
			ValaProperty* prop = NULL;
			ValaList* _tmp232_;
			gpointer _tmp233_;
			gboolean _tmp234_ = FALSE;
			ValaProperty* _tmp235_;
			ValaAttribute* _tmp236_;
			ValaProperty* _tmp243_;
			_prop_index = _prop_index + 1;
			_tmp230_ = _prop_index;
			_tmp231_ = _prop_size;
			if (!(_tmp230_ < _tmp231_)) {
				break;
			}
			_tmp232_ = _prop_list;
			_tmp233_ = vala_list_get (_tmp232_, _prop_index);
			prop = (ValaProperty*) _tmp233_;
			_tmp235_ = prop;
			_tmp236_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp235_, "NoAccessorMethod");
			if (_tmp236_ != NULL) {
				ValaSemanticAnalyzer* _tmp237_;
				ValaSemanticAnalyzer* _tmp238_;
				ValaClass* _tmp239_;
				_tmp237_ = vala_code_context_get_analyzer (context);
				_tmp238_ = _tmp237_;
				_tmp239_ = _tmp238_->object_type;
				_tmp234_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp239_);
			} else {
				_tmp234_ = FALSE;
			}
			if (_tmp234_) {
				ValaProperty* _tmp240_;
				ValaSourceReference* _tmp241_;
				ValaSourceReference* _tmp242_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp240_ = prop;
				_tmp241_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp240_);
				_tmp242_ = _tmp241_;
				vala_report_error (_tmp242_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp243_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp243_, context);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp244_;
		ValaList* _tmp245_;
		gint _sig_size = 0;
		ValaList* _tmp246_;
		gint _tmp247_;
		gint _tmp248_;
		gint _sig_index = 0;
		_tmp244_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_tmp245_ = _vala_iterable_ref0 (_tmp244_);
		_sig_list = _tmp245_;
		_tmp246_ = _sig_list;
		_tmp247_ = vala_collection_get_size ((ValaCollection*) _tmp246_);
		_tmp248_ = _tmp247_;
		_sig_size = _tmp248_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp249_;
			gint _tmp250_;
			ValaSignal* sig = NULL;
			ValaList* _tmp251_;
			gpointer _tmp252_;
			ValaSignal* _tmp253_;
			_sig_index = _sig_index + 1;
			_tmp249_ = _sig_index;
			_tmp250_ = _sig_size;
			if (!(_tmp249_ < _tmp250_)) {
				break;
			}
			_tmp251_ = _sig_list;
			_tmp252_ = vala_list_get (_tmp251_, _sig_index);
			sig = (ValaSignal*) _tmp252_;
			_tmp253_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp253_, context);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp254_ = vala_class_get_constructor (self);
	_tmp255_ = _tmp254_;
	if (_tmp255_ != NULL) {
		ValaConstructor* _tmp256_;
		ValaConstructor* _tmp257_;
		_tmp256_ = vala_class_get_constructor (self);
		_tmp257_ = _tmp256_;
		vala_code_node_check ((ValaCodeNode*) _tmp257_, context);
	}
	_tmp258_ = vala_class_get_class_constructor (self);
	_tmp259_ = _tmp258_;
	if (_tmp259_ != NULL) {
		ValaConstructor* _tmp260_;
		ValaConstructor* _tmp261_;
		_tmp260_ = vala_class_get_class_constructor (self);
		_tmp261_ = _tmp260_;
		vala_code_node_check ((ValaCodeNode*) _tmp261_, context);
	}
	_tmp262_ = vala_class_get_static_constructor (self);
	_tmp263_ = _tmp262_;
	if (_tmp263_ != NULL) {
		ValaConstructor* _tmp264_;
		ValaConstructor* _tmp265_;
		_tmp264_ = vala_class_get_static_constructor (self);
		_tmp265_ = _tmp264_;
		vala_code_node_check ((ValaCodeNode*) _tmp265_, context);
	}
	_tmp266_ = vala_class_get_destructor (self);
	_tmp267_ = _tmp266_;
	if (_tmp267_ != NULL) {
		ValaDestructor* _tmp268_;
		ValaDestructor* _tmp269_;
		_tmp268_ = vala_class_get_destructor (self);
		_tmp269_ = _tmp268_;
		vala_code_node_check ((ValaCodeNode*) _tmp269_, context);
	}
	_tmp270_ = vala_class_get_static_destructor (self);
	_tmp271_ = _tmp270_;
	if (_tmp271_ != NULL) {
		ValaDestructor* _tmp272_;
		ValaDestructor* _tmp273_;
		_tmp272_ = vala_class_get_static_destructor (self);
		_tmp273_ = _tmp272_;
		vala_code_node_check ((ValaCodeNode*) _tmp273_, context);
	}
	_tmp274_ = vala_class_get_class_destructor (self);
	_tmp275_ = _tmp274_;
	if (_tmp275_ != NULL) {
		ValaDestructor* _tmp276_;
		ValaDestructor* _tmp277_;
		_tmp276_ = vala_class_get_class_destructor (self);
		_tmp277_ = _tmp276_;
		vala_code_node_check ((ValaCodeNode*) _tmp277_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp278_;
		ValaList* _tmp279_;
		gint _cl_size = 0;
		ValaList* _tmp280_;
		gint _tmp281_;
		gint _tmp282_;
		gint _cl_index = 0;
		_tmp278_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_tmp279_ = _vala_iterable_ref0 (_tmp278_);
		_cl_list = _tmp279_;
		_tmp280_ = _cl_list;
		_tmp281_ = vala_collection_get_size ((ValaCollection*) _tmp280_);
		_tmp282_ = _tmp281_;
		_cl_size = _tmp282_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp283_;
			gint _tmp284_;
			ValaClass* cl = NULL;
			ValaList* _tmp285_;
			gpointer _tmp286_;
			ValaClass* _tmp287_;
			_cl_index = _cl_index + 1;
			_tmp283_ = _cl_index;
			_tmp284_ = _cl_size;
			if (!(_tmp283_ < _tmp284_)) {
				break;
			}
			_tmp285_ = _cl_list;
			_tmp286_ = vala_list_get (_tmp285_, _cl_index);
			cl = (ValaClass*) _tmp286_;
			_tmp287_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp287_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp288_;
		ValaList* _tmp289_;
		gint _iface_size = 0;
		ValaList* _tmp290_;
		gint _tmp291_;
		gint _tmp292_;
		gint _iface_index = 0;
		_tmp288_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_tmp289_ = _vala_iterable_ref0 (_tmp288_);
		_iface_list = _tmp289_;
		_tmp290_ = _iface_list;
		_tmp291_ = vala_collection_get_size ((ValaCollection*) _tmp290_);
		_tmp292_ = _tmp291_;
		_iface_size = _tmp292_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp293_;
			gint _tmp294_;
			ValaInterface* iface = NULL;
			ValaList* _tmp295_;
			gpointer _tmp296_;
			ValaInterface* _tmp297_;
			_iface_index = _iface_index + 1;
			_tmp293_ = _iface_index;
			_tmp294_ = _iface_size;
			if (!(_tmp293_ < _tmp294_)) {
				break;
			}
			_tmp295_ = _iface_list;
			_tmp296_ = vala_list_get (_tmp295_, _iface_index);
			iface = (ValaInterface*) _tmp296_;
			_tmp297_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp297_, context);
			_vala_code_node_unref0 (iface);
		}
		_vala_iterable_unref0 (_iface_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp298_;
		ValaList* _tmp299_;
		gint _st_size = 0;
		ValaList* _tmp300_;
		gint _tmp301_;
		gint _tmp302_;
		gint _st_index = 0;
		_tmp298_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_tmp299_ = _vala_iterable_ref0 (_tmp298_);
		_st_list = _tmp299_;
		_tmp300_ = _st_list;
		_tmp301_ = vala_collection_get_size ((ValaCollection*) _tmp300_);
		_tmp302_ = _tmp301_;
		_st_size = _tmp302_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp303_;
			gint _tmp304_;
			ValaStruct* st = NULL;
			ValaList* _tmp305_;
			gpointer _tmp306_;
			ValaStruct* _tmp307_;
			_st_index = _st_index + 1;
			_tmp303_ = _st_index;
			_tmp304_ = _st_size;
			if (!(_tmp303_ < _tmp304_)) {
				break;
			}
			_tmp305_ = _st_list;
			_tmp306_ = vala_list_get (_tmp305_, _st_index);
			st = (ValaStruct*) _tmp306_;
			_tmp307_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp307_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp308_;
		ValaList* _tmp309_;
		gint _d_size = 0;
		ValaList* _tmp310_;
		gint _tmp311_;
		gint _tmp312_;
		gint _d_index = 0;
		_tmp308_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_tmp309_ = _vala_iterable_ref0 (_tmp308_);
		_d_list = _tmp309_;
		_tmp310_ = _d_list;
		_tmp311_ = vala_collection_get_size ((ValaCollection*) _tmp310_);
		_tmp312_ = _tmp311_;
		_d_size = _tmp312_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp313_;
			gint _tmp314_;
			ValaDelegate* d = NULL;
			ValaList* _tmp315_;
			gpointer _tmp316_;
			ValaDelegate* _tmp317_;
			_d_index = _d_index + 1;
			_tmp313_ = _d_index;
			_tmp314_ = _d_size;
			if (!(_tmp313_ < _tmp314_)) {
				break;
			}
			_tmp315_ = _d_list;
			_tmp316_ = vala_list_get (_tmp315_, _d_index);
			d = (ValaDelegate*) _tmp316_;
			_tmp317_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp317_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp318_ = vala_class_get_is_compact (self);
	_tmp319_ = _tmp318_;
	if (_tmp319_) {
		gboolean _tmp338_ = FALSE;
		gboolean _tmp339_ = FALSE;
		gboolean _tmp340_ = FALSE;
		gboolean _tmp341_;
		gboolean _tmp342_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp320_;
			ValaList* _tmp321_;
			gint _base_type_size = 0;
			ValaList* _tmp322_;
			gint _tmp323_;
			gint _tmp324_;
			gint _base_type_index = 0;
			_tmp320_ = vala_class_get_base_types (self);
			_tmp321_ = _vala_iterable_ref0 (_tmp320_);
			_base_type_list = _tmp321_;
			_tmp322_ = _base_type_list;
			_tmp323_ = vala_collection_get_size ((ValaCollection*) _tmp322_);
			_tmp324_ = _tmp323_;
			_base_type_size = _tmp324_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp325_;
				gint _tmp326_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp327_;
				gpointer _tmp328_;
				ValaDataType* _tmp329_;
				ValaTypeSymbol* _tmp330_;
				ValaTypeSymbol* _tmp331_;
				_base_type_index = _base_type_index + 1;
				_tmp325_ = _base_type_index;
				_tmp326_ = _base_type_size;
				if (!(_tmp325_ < _tmp326_)) {
					break;
				}
				_tmp327_ = _base_type_list;
				_tmp328_ = vala_list_get (_tmp327_, _base_type_index);
				base_type = (ValaDataType*) _tmp328_;
				_tmp329_ = base_type;
				_tmp330_ = vala_data_type_get_type_symbol (_tmp329_);
				_tmp331_ = _tmp330_;
				if (VALA_IS_INTERFACE (_tmp331_)) {
					ValaSourceReference* _tmp332_;
					ValaSourceReference* _tmp333_;
					gchar* _tmp334_;
					gchar* _tmp335_;
					gchar* _tmp336_;
					gchar* _tmp337_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp332_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp333_ = _tmp332_;
					_tmp334_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp335_ = _tmp334_;
					_tmp336_ = g_strdup_printf ("compact classes `%s' may not implement interfaces", _tmp335_);
					_tmp337_ = _tmp336_;
					vala_report_error (_tmp333_, _tmp337_);
					_g_free0 (_tmp337_);
					_g_free0 (_tmp335_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp341_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp342_ = _tmp341_;
		if (!_tmp342_) {
			gboolean _tmp343_;
			gboolean _tmp344_;
			_tmp343_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp344_ = _tmp343_;
			_tmp340_ = !_tmp344_;
		} else {
			_tmp340_ = FALSE;
		}
		if (_tmp340_) {
			ValaClass* _tmp345_;
			_tmp345_ = self->priv->_base_class;
			_tmp339_ = _tmp345_ != NULL;
		} else {
			_tmp339_ = FALSE;
		}
		if (_tmp339_) {
			ValaClass* _tmp346_;
			ValaSemanticAnalyzer* _tmp347_;
			ValaSemanticAnalyzer* _tmp348_;
			ValaClass* _tmp349_;
			_tmp346_ = self->priv->_base_class;
			_tmp347_ = vala_code_context_get_analyzer (context);
			_tmp348_ = _tmp347_;
			_tmp349_ = _tmp348_->gsource_type;
			_tmp338_ = _tmp346_ != _tmp349_;
		} else {
			_tmp338_ = FALSE;
		}
		if (_tmp338_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp350_;
				ValaList* _tmp351_;
				gint _f_size = 0;
				ValaList* _tmp352_;
				gint _tmp353_;
				gint _tmp354_;
				gint _f_index = 0;
				_tmp350_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_tmp351_ = _vala_iterable_ref0 (_tmp350_);
				_f_list = _tmp351_;
				_tmp352_ = _f_list;
				_tmp353_ = vala_collection_get_size ((ValaCollection*) _tmp352_);
				_tmp354_ = _tmp353_;
				_f_size = _tmp354_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp355_;
					gint _tmp356_;
					ValaField* f = NULL;
					ValaList* _tmp357_;
					gpointer _tmp358_;
					ValaField* _tmp359_;
					ValaMemberBinding _tmp360_;
					ValaMemberBinding _tmp361_;
					_f_index = _f_index + 1;
					_tmp355_ = _f_index;
					_tmp356_ = _f_size;
					if (!(_tmp355_ < _tmp356_)) {
						break;
					}
					_tmp357_ = _f_list;
					_tmp358_ = vala_list_get (_tmp357_, _f_index);
					f = (ValaField*) _tmp358_;
					_tmp359_ = f;
					_tmp360_ = vala_field_get_binding (_tmp359_);
					_tmp361_ = _tmp360_;
					if (_tmp361_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp362_;
						ValaSourceReference* _tmp363_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp362_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp363_ = _tmp362_;
						vala_report_error (_tmp363_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp364_ = g_direct_equal;
	_tmp365_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp364_);
	prerequisites = (ValaList*) _tmp365_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp366_;
		ValaList* _tmp367_;
		gint _base_type_size = 0;
		ValaList* _tmp368_;
		gint _tmp369_;
		gint _tmp370_;
		gint _base_type_index = 0;
		_tmp366_ = vala_class_get_base_types (self);
		_tmp367_ = _vala_iterable_ref0 (_tmp366_);
		_base_type_list = _tmp367_;
		_tmp368_ = _base_type_list;
		_tmp369_ = vala_collection_get_size ((ValaCollection*) _tmp368_);
		_tmp370_ = _tmp369_;
		_base_type_size = _tmp370_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp371_;
			gint _tmp372_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp373_;
			gpointer _tmp374_;
			ValaDataType* _tmp375_;
			ValaTypeSymbol* _tmp376_;
			ValaTypeSymbol* _tmp377_;
			_base_type_index = _base_type_index + 1;
			_tmp371_ = _base_type_index;
			_tmp372_ = _base_type_size;
			if (!(_tmp371_ < _tmp372_)) {
				break;
			}
			_tmp373_ = _base_type_list;
			_tmp374_ = vala_list_get (_tmp373_, _base_type_index);
			base_type = (ValaDataType*) _tmp374_;
			_tmp375_ = base_type;
			_tmp376_ = vala_data_type_get_type_symbol (_tmp375_);
			_tmp377_ = _tmp376_;
			if (VALA_IS_INTERFACE (_tmp377_)) {
				ValaDataType* _tmp378_;
				ValaTypeSymbol* _tmp379_;
				ValaTypeSymbol* _tmp380_;
				ValaList* _tmp381_;
				_tmp378_ = base_type;
				_tmp379_ = vala_data_type_get_type_symbol (_tmp378_);
				_tmp380_ = _tmp379_;
				_tmp381_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp380_, VALA_TYPE_INTERFACE, ValaInterface), _tmp381_);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp382_ = g_str_equal;
	_tmp383_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp382_);
	missing_prereqs = (ValaList*) _tmp383_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp384_;
		ValaList* _tmp385_;
		gint _prereq_size = 0;
		ValaList* _tmp386_;
		gint _tmp387_;
		gint _tmp388_;
		gint _prereq_index = 0;
		_tmp384_ = prerequisites;
		_tmp385_ = _vala_iterable_ref0 (_tmp384_);
		_prereq_list = _tmp385_;
		_tmp386_ = _prereq_list;
		_tmp387_ = vala_collection_get_size ((ValaCollection*) _tmp386_);
		_tmp388_ = _tmp387_;
		_prereq_size = _tmp388_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp389_;
			gint _tmp390_;
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp391_;
			gpointer _tmp392_;
			ValaTypeSymbol* _tmp393_;
			_prereq_index = _prereq_index + 1;
			_tmp389_ = _prereq_index;
			_tmp390_ = _prereq_size;
			if (!(_tmp389_ < _tmp390_)) {
				break;
			}
			_tmp391_ = _prereq_list;
			_tmp392_ = vala_list_get (_tmp391_, _prereq_index);
			prereq = (ValaTypeSymbol*) _tmp392_;
			_tmp393_ = prereq;
			if (!vala_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp393_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))) {
				ValaList* _tmp394_;
				ValaTypeSymbol* _tmp395_;
				gchar* _tmp396_;
				gchar* _tmp397_;
				_tmp394_ = missing_prereqs;
				_tmp395_ = prereq;
				_tmp396_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp395_);
				_tmp397_ = _tmp396_;
				vala_list_insert (_tmp394_, 0, _tmp397_);
				_g_free0 (_tmp397_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp398_ = missing_prereqs;
	_tmp399_ = vala_collection_get_size ((ValaCollection*) _tmp398_);
	_tmp400_ = _tmp399_;
	if (_tmp400_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp401_;
		gchar* _tmp402_;
		gchar* _tmp403_;
		gchar* _tmp404_;
		gboolean first = FALSE;
		const gchar* _tmp420_;
		gchar* _tmp421_;
		ValaSourceReference* _tmp422_;
		ValaSourceReference* _tmp423_;
		const gchar* _tmp424_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp401_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp402_ = _tmp401_;
		_tmp403_ = g_strdup_printf ("%s: some prerequisites (", _tmp402_);
		_tmp404_ = _tmp403_;
		_g_free0 (_tmp402_);
		error_string = _tmp404_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp405_;
			ValaList* _tmp406_;
			gint _s_size = 0;
			ValaList* _tmp407_;
			gint _tmp408_;
			gint _tmp409_;
			gint _s_index = 0;
			_tmp405_ = missing_prereqs;
			_tmp406_ = _vala_iterable_ref0 (_tmp405_);
			_s_list = _tmp406_;
			_tmp407_ = _s_list;
			_tmp408_ = vala_collection_get_size ((ValaCollection*) _tmp407_);
			_tmp409_ = _tmp408_;
			_s_size = _tmp409_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp410_;
				gint _tmp411_;
				gchar* s = NULL;
				ValaList* _tmp412_;
				gpointer _tmp413_;
				_s_index = _s_index + 1;
				_tmp410_ = _s_index;
				_tmp411_ = _s_size;
				if (!(_tmp410_ < _tmp411_)) {
					break;
				}
				_tmp412_ = _s_list;
				_tmp413_ = vala_list_get (_tmp412_, _s_index);
				s = (gchar*) _tmp413_;
				if (first) {
					const gchar* _tmp414_;
					const gchar* _tmp415_;
					gchar* _tmp416_;
					_tmp414_ = error_string;
					_tmp415_ = s;
					_tmp416_ = g_strdup_printf ("%s`%s'", _tmp414_, _tmp415_);
					_g_free0 (error_string);
					error_string = _tmp416_;
					first = FALSE;
				} else {
					const gchar* _tmp417_;
					const gchar* _tmp418_;
					gchar* _tmp419_;
					_tmp417_ = error_string;
					_tmp418_ = s;
					_tmp419_ = g_strdup_printf ("%s, `%s'", _tmp417_, _tmp418_);
					_g_free0 (error_string);
					error_string = _tmp419_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp420_ = error_string;
		_tmp421_ = g_strconcat (_tmp420_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp421_;
		_tmp422_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp423_ = _tmp422_;
		_tmp424_ = error_string;
		vala_report_error (_tmp423_, _tmp424_);
		_g_free0 (error_string);
	}
	_tmp425_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp426_ = _tmp425_;
	if (_tmp426_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp587_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp427_;
			ValaList* _tmp428_;
			gint _base_type_size = 0;
			ValaList* _tmp429_;
			gint _tmp430_;
			gint _tmp431_;
			gint _base_type_index = 0;
			_tmp427_ = vala_class_get_base_types (self);
			_tmp428_ = _vala_iterable_ref0 (_tmp427_);
			_base_type_list = _tmp428_;
			_tmp429_ = _base_type_list;
			_tmp430_ = vala_collection_get_size ((ValaCollection*) _tmp429_);
			_tmp431_ = _tmp430_;
			_base_type_size = _tmp431_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp432_;
				gint _tmp433_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp434_;
				gpointer _tmp435_;
				ValaDataType* _tmp436_;
				ValaTypeSymbol* _tmp437_;
				ValaTypeSymbol* _tmp438_;
				_base_type_index = _base_type_index + 1;
				_tmp432_ = _base_type_index;
				_tmp433_ = _base_type_size;
				if (!(_tmp432_ < _tmp433_)) {
					break;
				}
				_tmp434_ = _base_type_list;
				_tmp435_ = vala_list_get (_tmp434_, _base_type_index);
				base_type = (ValaDataType*) _tmp435_;
				_tmp436_ = base_type;
				_tmp437_ = vala_data_type_get_type_symbol (_tmp436_);
				_tmp438_ = _tmp437_;
				if (VALA_IS_INTERFACE (_tmp438_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp439_;
					ValaTypeSymbol* _tmp440_;
					ValaTypeSymbol* _tmp441_;
					gboolean _tmp442_ = FALSE;
					ValaClass* _tmp443_;
					_tmp439_ = base_type;
					_tmp440_ = vala_data_type_get_type_symbol (_tmp439_);
					_tmp441_ = _tmp440_;
					iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp441_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp443_ = self->priv->_base_class;
					if (_tmp443_ != NULL) {
						ValaClass* _tmp444_;
						ValaInterface* _tmp445_;
						_tmp444_ = self->priv->_base_class;
						_tmp445_ = iface;
						_tmp442_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp444_, (ValaTypeSymbol*) _tmp445_);
					} else {
						_tmp442_ = FALSE;
					}
					if (_tmp442_) {
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp446_;
						ValaList* _tmp447_;
						ValaList* _tmp448_;
						gint _m_size = 0;
						ValaList* _tmp449_;
						gint _tmp450_;
						gint _tmp451_;
						gint _m_index = 0;
						_tmp446_ = iface;
						_tmp447_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp446_);
						_tmp448_ = _vala_iterable_ref0 (_tmp447_);
						_m_list = _tmp448_;
						_tmp449_ = _m_list;
						_tmp450_ = vala_collection_get_size ((ValaCollection*) _tmp449_);
						_tmp451_ = _tmp450_;
						_m_size = _tmp451_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp452_;
							gint _tmp453_;
							ValaMethod* m = NULL;
							ValaList* _tmp454_;
							gpointer _tmp455_;
							ValaMethod* _tmp456_;
							gboolean _tmp457_;
							gboolean _tmp458_;
							_m_index = _m_index + 1;
							_tmp452_ = _m_index;
							_tmp453_ = _m_size;
							if (!(_tmp452_ < _tmp453_)) {
								break;
							}
							_tmp454_ = _m_list;
							_tmp455_ = vala_list_get (_tmp454_, _m_index);
							m = (ValaMethod*) _tmp455_;
							_tmp456_ = m;
							_tmp457_ = vala_method_get_is_abstract (_tmp456_);
							_tmp458_ = _tmp457_;
							if (_tmp458_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								implemented = FALSE;
								base_class = self;
								while (TRUE) {
									gboolean _tmp459_ = FALSE;
									ValaClass* _tmp460_;
									ValaClass* _tmp514_;
									ValaClass* _tmp515_;
									_tmp460_ = base_class;
									if (_tmp460_ != NULL) {
										_tmp459_ = !implemented;
									} else {
										_tmp459_ = FALSE;
									}
									if (!_tmp459_) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp461_;
										ValaList* _tmp462_;
										ValaList* _tmp463_;
										gint _impl_size = 0;
										ValaList* _tmp464_;
										gint _tmp465_;
										gint _tmp466_;
										gint _impl_index = 0;
										_tmp461_ = base_class;
										_tmp462_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp461_);
										_tmp463_ = _vala_iterable_ref0 (_tmp462_);
										_impl_list = _tmp463_;
										_tmp464_ = _impl_list;
										_tmp465_ = vala_collection_get_size ((ValaCollection*) _tmp464_);
										_tmp466_ = _tmp465_;
										_impl_size = _tmp466_;
										_impl_index = -1;
										while (TRUE) {
											gint _tmp467_;
											gint _tmp468_;
											ValaMethod* impl = NULL;
											ValaList* _tmp469_;
											gpointer _tmp470_;
											gboolean _tmp471_ = FALSE;
											ValaMethod* _tmp472_;
											ValaMethod* _tmp473_;
											ValaMethod* _tmp474_;
											ValaMethod* _tmp475_;
											_impl_index = _impl_index + 1;
											_tmp467_ = _impl_index;
											_tmp468_ = _impl_size;
											if (!(_tmp467_ < _tmp468_)) {
												break;
											}
											_tmp469_ = _impl_list;
											_tmp470_ = vala_list_get (_tmp469_, _impl_index);
											impl = (ValaMethod*) _tmp470_;
											_tmp472_ = impl;
											_tmp473_ = vala_method_get_base_interface_method (_tmp472_);
											_tmp474_ = _tmp473_;
											_tmp475_ = m;
											if (_tmp474_ == _tmp475_) {
												_tmp471_ = TRUE;
											} else {
												gboolean _tmp476_ = FALSE;
												gboolean _tmp477_ = FALSE;
												gboolean _tmp478_ = FALSE;
												gboolean _tmp479_ = FALSE;
												ValaClass* _tmp480_;
												_tmp480_ = base_class;
												if (_tmp480_ != self) {
													ValaMethod* _tmp481_;
													ValaMethod* _tmp482_;
													ValaMethod* _tmp483_;
													_tmp481_ = impl;
													_tmp482_ = vala_method_get_base_interface_method (_tmp481_);
													_tmp483_ = _tmp482_;
													_tmp479_ = _tmp483_ == NULL;
												} else {
													_tmp479_ = FALSE;
												}
												if (_tmp479_) {
													ValaMethod* _tmp484_;
													const gchar* _tmp485_;
													const gchar* _tmp486_;
													ValaMethod* _tmp487_;
													const gchar* _tmp488_;
													const gchar* _tmp489_;
													_tmp484_ = impl;
													_tmp485_ = vala_symbol_get_name ((ValaSymbol*) _tmp484_);
													_tmp486_ = _tmp485_;
													_tmp487_ = m;
													_tmp488_ = vala_symbol_get_name ((ValaSymbol*) _tmp487_);
													_tmp489_ = _tmp488_;
													_tmp478_ = g_strcmp0 (_tmp486_, _tmp489_) == 0;
												} else {
													_tmp478_ = FALSE;
												}
												if (_tmp478_) {
													gboolean _tmp490_ = FALSE;
													ValaMethod* _tmp491_;
													ValaDataType* _tmp492_;
													ValaDataType* _tmp493_;
													_tmp491_ = impl;
													_tmp492_ = vala_method_get_base_interface_type (_tmp491_);
													_tmp493_ = _tmp492_;
													if (_tmp493_ == NULL) {
														_tmp490_ = TRUE;
													} else {
														ValaMethod* _tmp494_;
														ValaDataType* _tmp495_;
														ValaDataType* _tmp496_;
														ValaTypeSymbol* _tmp497_;
														ValaTypeSymbol* _tmp498_;
														ValaInterface* _tmp499_;
														_tmp494_ = impl;
														_tmp495_ = vala_method_get_base_interface_type (_tmp494_);
														_tmp496_ = _tmp495_;
														_tmp497_ = vala_data_type_get_type_symbol (_tmp496_);
														_tmp498_ = _tmp497_;
														_tmp499_ = iface;
														_tmp490_ = _tmp498_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp499_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
													}
													_tmp477_ = _tmp490_;
												} else {
													_tmp477_ = FALSE;
												}
												if (_tmp477_) {
													ValaMethod* _tmp500_;
													ValaMethod* _tmp501_;
													_tmp500_ = impl;
													_tmp501_ = m;
													_tmp476_ = vala_method_compatible_no_error (_tmp500_, _tmp501_);
												} else {
													_tmp476_ = FALSE;
												}
												_tmp471_ = _tmp476_;
											}
											if (_tmp471_) {
												ValaMethod* _tmp502_;
												ValaVersionAttribute* _tmp503_;
												ValaVersionAttribute* _tmp504_;
												ValaSourceReference* _tmp505_;
												ValaSourceReference* _tmp506_;
												ValaMethod* _tmp507_;
												ValaMethod* _tmp508_;
												ValaMethod* _tmp509_;
												ValaMethod* _tmp510_;
												_tmp502_ = impl;
												_tmp503_ = vala_symbol_get_version ((ValaSymbol*) _tmp502_);
												_tmp504_ = _tmp503_;
												_tmp505_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp506_ = _tmp505_;
												vala_version_attribute_check (_tmp504_, context, _tmp506_);
												_tmp507_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp507_, TRUE);
												implemented = TRUE;
												_tmp508_ = impl;
												_tmp509_ = vala_method_get_base_interface_method (_tmp508_);
												_tmp510_ = _tmp509_;
												if (_tmp510_ == NULL) {
													ValaHashMap* _tmp511_;
													ValaMethod* _tmp512_;
													ValaMethod* _tmp513_;
													_tmp511_ = self->priv->implicit_implementations;
													_tmp512_ = m;
													_tmp513_ = impl;
													vala_map_set ((ValaMap*) _tmp511_, _tmp512_, _tmp513_);
												}
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
										_vala_iterable_unref0 (_impl_list);
									}
									_tmp514_ = base_class;
									_tmp515_ = _tmp514_->priv->_base_class;
									base_class = _tmp515_;
								}
								if (!implemented) {
									ValaSourceReference* _tmp516_;
									ValaSourceReference* _tmp517_;
									gchar* _tmp518_;
									gchar* _tmp519_;
									ValaMethod* _tmp520_;
									gchar* _tmp521_;
									gchar* _tmp522_;
									gchar* _tmp523_;
									gchar* _tmp524_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp516_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp517_ = _tmp516_;
									_tmp518_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp519_ = _tmp518_;
									_tmp520_ = m;
									_tmp521_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp520_);
									_tmp522_ = _tmp521_;
									_tmp523_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp519_, _tmp522_);
									_tmp524_ = _tmp523_;
									vala_report_error (_tmp517_, _tmp524_);
									_g_free0 (_tmp524_);
									_g_free0 (_tmp522_);
									_g_free0 (_tmp519_);
								}
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp525_;
						ValaList* _tmp526_;
						ValaList* _tmp527_;
						gint _prop_size = 0;
						ValaList* _tmp528_;
						gint _tmp529_;
						gint _tmp530_;
						gint _prop_index = 0;
						_tmp525_ = iface;
						_tmp526_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp525_);
						_tmp527_ = _vala_iterable_ref0 (_tmp526_);
						_prop_list = _tmp527_;
						_tmp528_ = _prop_list;
						_tmp529_ = vala_collection_get_size ((ValaCollection*) _tmp528_);
						_tmp530_ = _tmp529_;
						_prop_size = _tmp530_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp531_;
							gint _tmp532_;
							ValaProperty* prop = NULL;
							ValaList* _tmp533_;
							gpointer _tmp534_;
							ValaProperty* _tmp535_;
							gboolean _tmp536_;
							gboolean _tmp537_;
							_prop_index = _prop_index + 1;
							_tmp531_ = _prop_index;
							_tmp532_ = _prop_size;
							if (!(_tmp531_ < _tmp532_)) {
								break;
							}
							_tmp533_ = _prop_list;
							_tmp534_ = vala_list_get (_tmp533_, _prop_index);
							prop = (ValaProperty*) _tmp534_;
							_tmp535_ = prop;
							_tmp536_ = vala_property_get_is_abstract (_tmp535_);
							_tmp537_ = _tmp536_;
							if (_tmp537_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaSymbol* _tmp550_;
								sym = NULL;
								base_class = self;
								while (TRUE) {
									gboolean _tmp538_ = FALSE;
									ValaClass* _tmp539_;
									ValaClass* _tmp541_;
									ValaScope* _tmp542_;
									ValaScope* _tmp543_;
									ValaProperty* _tmp544_;
									const gchar* _tmp545_;
									const gchar* _tmp546_;
									ValaSymbol* _tmp547_;
									ValaClass* _tmp548_;
									ValaClass* _tmp549_;
									_tmp539_ = base_class;
									if (_tmp539_ != NULL) {
										ValaSymbol* _tmp540_;
										_tmp540_ = sym;
										_tmp538_ = !VALA_IS_PROPERTY (_tmp540_);
									} else {
										_tmp538_ = FALSE;
									}
									if (!_tmp538_) {
										break;
									}
									_tmp541_ = base_class;
									_tmp542_ = vala_symbol_get_scope ((ValaSymbol*) _tmp541_);
									_tmp543_ = _tmp542_;
									_tmp544_ = prop;
									_tmp545_ = vala_symbol_get_name ((ValaSymbol*) _tmp544_);
									_tmp546_ = _tmp545_;
									_tmp547_ = vala_scope_lookup (_tmp543_, _tmp546_);
									_vala_code_node_unref0 (sym);
									sym = _tmp547_;
									_tmp548_ = base_class;
									_tmp549_ = _tmp548_->priv->_base_class;
									base_class = _tmp549_;
								}
								_tmp550_ = sym;
								if (VALA_IS_PROPERTY (_tmp550_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp551_;
									ValaProperty* _tmp552_;
									gchar* invalid_match = NULL;
									gboolean _tmp553_ = FALSE;
									ValaProperty* _tmp554_;
									gboolean _tmp555_;
									gboolean _tmp556_;
									ValaSymbol* _tmp572_;
									ValaVersionAttribute* _tmp573_;
									ValaVersionAttribute* _tmp574_;
									ValaSourceReference* _tmp575_;
									ValaSourceReference* _tmp576_;
									ValaSymbol* _tmp577_;
									_tmp551_ = sym;
									_tmp552_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp551_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp552_;
									invalid_match = NULL;
									_tmp554_ = base_prop;
									_tmp555_ = vala_symbol_get_hides ((ValaSymbol*) _tmp554_);
									_tmp556_ = _tmp555_;
									if (!_tmp556_) {
										ValaProperty* _tmp557_;
										ValaProperty* _tmp558_;
										gchar* _tmp559_ = NULL;
										gboolean _tmp560_;
										_tmp557_ = base_prop;
										_tmp558_ = prop;
										_tmp560_ = vala_property_compatible (_tmp557_, _tmp558_, &_tmp559_);
										_g_free0 (invalid_match);
										invalid_match = _tmp559_;
										_tmp553_ = !_tmp560_;
									} else {
										_tmp553_ = FALSE;
									}
									if (_tmp553_) {
										ValaSourceReference* _tmp561_;
										ValaSourceReference* _tmp562_;
										ValaProperty* _tmp563_;
										gchar* _tmp564_;
										gchar* _tmp565_;
										ValaProperty* _tmp566_;
										gchar* _tmp567_;
										gchar* _tmp568_;
										const gchar* _tmp569_;
										gchar* _tmp570_;
										gchar* _tmp571_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp561_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp562_ = _tmp561_;
										_tmp563_ = prop;
										_tmp564_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp563_);
										_tmp565_ = _tmp564_;
										_tmp566_ = base_prop;
										_tmp567_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp566_);
										_tmp568_ = _tmp567_;
										_tmp569_ = invalid_match;
										_tmp570_ = g_strdup_printf ("Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp565_, _tmp568_, _tmp569_);
										_tmp571_ = _tmp570_;
										vala_report_error (_tmp562_, _tmp571_);
										_g_free0 (_tmp571_);
										_g_free0 (_tmp568_);
										_g_free0 (_tmp565_);
									}
									_tmp572_ = sym;
									_tmp573_ = vala_symbol_get_version (_tmp572_);
									_tmp574_ = _tmp573_;
									_tmp575_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp576_ = _tmp575_;
									vala_version_attribute_check (_tmp574_, context, _tmp576_);
									_tmp577_ = sym;
									vala_symbol_set_used (_tmp577_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp578_;
									ValaSourceReference* _tmp579_;
									gchar* _tmp580_;
									gchar* _tmp581_;
									ValaProperty* _tmp582_;
									gchar* _tmp583_;
									gchar* _tmp584_;
									gchar* _tmp585_;
									gchar* _tmp586_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp578_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp579_ = _tmp578_;
									_tmp580_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp581_ = _tmp580_;
									_tmp582_ = prop;
									_tmp583_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp582_);
									_tmp584_ = _tmp583_;
									_tmp585_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp581_, _tmp584_);
									_tmp586_ = _tmp585_;
									vala_report_error (_tmp579_, _tmp586_);
									_g_free0 (_tmp586_);
									_g_free0 (_tmp584_);
									_g_free0 (_tmp581_);
								}
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp587_ = self->priv->_is_abstract;
		if (!_tmp587_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp588_;
			_tmp588_ = self->priv->_base_class;
			base_class = _tmp588_;
			while (TRUE) {
				gboolean _tmp589_ = FALSE;
				ValaClass* _tmp590_;
				ValaClass* _tmp657_;
				ValaClass* _tmp658_;
				_tmp590_ = base_class;
				if (_tmp590_ != NULL) {
					ValaClass* _tmp591_;
					gboolean _tmp592_;
					_tmp591_ = base_class;
					_tmp592_ = _tmp591_->priv->_is_abstract;
					_tmp589_ = _tmp592_;
				} else {
					_tmp589_ = FALSE;
				}
				if (!_tmp589_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp593_;
					ValaList* _tmp594_;
					ValaList* _tmp595_;
					gint _base_method_size = 0;
					ValaList* _tmp596_;
					gint _tmp597_;
					gint _tmp598_;
					gint _base_method_index = 0;
					_tmp593_ = base_class;
					_tmp594_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp593_);
					_tmp595_ = _vala_iterable_ref0 (_tmp594_);
					_base_method_list = _tmp595_;
					_tmp596_ = _base_method_list;
					_tmp597_ = vala_collection_get_size ((ValaCollection*) _tmp596_);
					_tmp598_ = _tmp597_;
					_base_method_size = _tmp598_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp599_;
						gint _tmp600_;
						ValaMethod* base_method = NULL;
						ValaList* _tmp601_;
						gpointer _tmp602_;
						ValaMethod* _tmp603_;
						gboolean _tmp604_;
						gboolean _tmp605_;
						_base_method_index = _base_method_index + 1;
						_tmp599_ = _base_method_index;
						_tmp600_ = _base_method_size;
						if (!(_tmp599_ < _tmp600_)) {
							break;
						}
						_tmp601_ = _base_method_list;
						_tmp602_ = vala_list_get (_tmp601_, _base_method_index);
						base_method = (ValaMethod*) _tmp602_;
						_tmp603_ = base_method;
						_tmp604_ = vala_method_get_is_abstract (_tmp603_);
						_tmp605_ = _tmp604_;
						if (_tmp605_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp606_;
							const gchar* _tmp607_;
							const gchar* _tmp608_;
							ValaSymbol* _tmp609_;
							ValaMethod* _tmp610_;
							gboolean _tmp611_ = FALSE;
							ValaMethod* _tmp612_;
							_tmp606_ = base_method;
							_tmp607_ = vala_symbol_get_name ((ValaSymbol*) _tmp606_);
							_tmp608_ = _tmp607_;
							_tmp609_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp608_);
							_tmp610_ = VALA_IS_METHOD (_tmp609_) ? ((ValaMethod*) _tmp609_) : NULL;
							if (_tmp610_ == NULL) {
								_vala_code_node_unref0 (_tmp609_);
							}
							override_method = _tmp610_;
							_tmp612_ = override_method;
							if (_tmp612_ == NULL) {
								_tmp611_ = TRUE;
							} else {
								ValaMethod* _tmp613_;
								gboolean _tmp614_;
								gboolean _tmp615_;
								_tmp613_ = override_method;
								_tmp614_ = vala_method_get_overrides (_tmp613_);
								_tmp615_ = _tmp614_;
								_tmp611_ = !_tmp615_;
							}
							if (_tmp611_) {
								ValaSourceReference* _tmp616_;
								ValaSourceReference* _tmp617_;
								gchar* _tmp618_;
								gchar* _tmp619_;
								ValaMethod* _tmp620_;
								gchar* _tmp621_;
								gchar* _tmp622_;
								gchar* _tmp623_;
								gchar* _tmp624_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp616_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp617_ = _tmp616_;
								_tmp618_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp619_ = _tmp618_;
								_tmp620_ = base_method;
								_tmp621_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp620_);
								_tmp622_ = _tmp621_;
								_tmp623_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp619_, _tmp622_);
								_tmp624_ = _tmp623_;
								vala_report_error (_tmp617_, _tmp624_);
								_g_free0 (_tmp624_);
								_g_free0 (_tmp622_);
								_g_free0 (_tmp619_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp625_;
					ValaList* _tmp626_;
					ValaList* _tmp627_;
					gint _base_property_size = 0;
					ValaList* _tmp628_;
					gint _tmp629_;
					gint _tmp630_;
					gint _base_property_index = 0;
					_tmp625_ = base_class;
					_tmp626_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp625_);
					_tmp627_ = _vala_iterable_ref0 (_tmp626_);
					_base_property_list = _tmp627_;
					_tmp628_ = _base_property_list;
					_tmp629_ = vala_collection_get_size ((ValaCollection*) _tmp628_);
					_tmp630_ = _tmp629_;
					_base_property_size = _tmp630_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp631_;
						gint _tmp632_;
						ValaProperty* base_property = NULL;
						ValaList* _tmp633_;
						gpointer _tmp634_;
						ValaProperty* _tmp635_;
						gboolean _tmp636_;
						gboolean _tmp637_;
						_base_property_index = _base_property_index + 1;
						_tmp631_ = _base_property_index;
						_tmp632_ = _base_property_size;
						if (!(_tmp631_ < _tmp632_)) {
							break;
						}
						_tmp633_ = _base_property_list;
						_tmp634_ = vala_list_get (_tmp633_, _base_property_index);
						base_property = (ValaProperty*) _tmp634_;
						_tmp635_ = base_property;
						_tmp636_ = vala_property_get_is_abstract (_tmp635_);
						_tmp637_ = _tmp636_;
						if (_tmp637_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp638_;
							const gchar* _tmp639_;
							const gchar* _tmp640_;
							ValaSymbol* _tmp641_;
							ValaProperty* _tmp642_;
							gboolean _tmp643_ = FALSE;
							ValaProperty* _tmp644_;
							_tmp638_ = base_property;
							_tmp639_ = vala_symbol_get_name ((ValaSymbol*) _tmp638_);
							_tmp640_ = _tmp639_;
							_tmp641_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp640_);
							_tmp642_ = VALA_IS_PROPERTY (_tmp641_) ? ((ValaProperty*) _tmp641_) : NULL;
							if (_tmp642_ == NULL) {
								_vala_code_node_unref0 (_tmp641_);
							}
							override_property = _tmp642_;
							_tmp644_ = override_property;
							if (_tmp644_ == NULL) {
								_tmp643_ = TRUE;
							} else {
								ValaProperty* _tmp645_;
								gboolean _tmp646_;
								gboolean _tmp647_;
								_tmp645_ = override_property;
								_tmp646_ = vala_property_get_overrides (_tmp645_);
								_tmp647_ = _tmp646_;
								_tmp643_ = !_tmp647_;
							}
							if (_tmp643_) {
								ValaSourceReference* _tmp648_;
								ValaSourceReference* _tmp649_;
								gchar* _tmp650_;
								gchar* _tmp651_;
								ValaProperty* _tmp652_;
								gchar* _tmp653_;
								gchar* _tmp654_;
								gchar* _tmp655_;
								gchar* _tmp656_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp648_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp649_ = _tmp648_;
								_tmp650_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp651_ = _tmp650_;
								_tmp652_ = base_property;
								_tmp653_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp652_);
								_tmp654_ = _tmp653_;
								_tmp655_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp651_, _tmp654_);
								_tmp656_ = _tmp655_;
								vala_report_error (_tmp649_, _tmp656_);
								_g_free0 (_tmp656_);
								_g_free0 (_tmp654_);
								_g_free0 (_tmp651_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp657_ = base_class;
				_tmp658_ = _tmp657_->priv->_base_class;
				base_class = _tmp658_;
			}
		}
	}
	_tmp659_ = vala_code_context_get_analyzer (context);
	_tmp660_ = _tmp659_;
	_tmp661_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp660_, _tmp661_);
	_tmp662_ = vala_code_context_get_analyzer (context);
	_tmp663_ = _tmp662_;
	_tmp664_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp663_, _tmp664_);
	_tmp665_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp666_ = _tmp665_;
	result = !_tmp666_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_class_class_init (ValaClassClass * klass,
                       gpointer klass_data)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_adjust_private_offset (klass, &ValaClass_private_offset);
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}

static void
vala_class_instance_init (ValaClass * self,
                          gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	self->priv = vala_class_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _vala_symbol_hash_func_ghash_func, _vala_symbol_equal_func_gequal_func, _tmp2_);
	self->priv->implicit_implementations = _tmp3_;
}

static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_immutable);
	_g_free0 (self->priv->_is_singleton);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_map_unref0 (self->priv->implicit_implementations);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}

/**
 * Represents a class declaration in the source code.
 */
static GType
vala_class_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
	GType vala_class_type_id;
	vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
	ValaClass_private_offset = g_type_add_instance_private (vala_class_type_id, sizeof (ValaClassPrivate));
	return vala_class_type_id;
}

GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		GType vala_class_type_id;
		vala_class_type_id = vala_class_get_type_once ();
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}

