/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};


static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                                      ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                          ValaCallable* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gsize _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		const gchar* res = NULL;
		gsize _tmp27_;
		void* _tmp28_;
		void* ptr = NULL;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		void* _tmp31_;
		const gchar* _tmp44_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = len;
		_tmp24_ = strlen ((const gchar*) separator);
		_tmp25_ = _tmp24_;
		_tmp26_ = i;
		len = _tmp23_ + (_tmp25_ * (_tmp26_ - 1));
		_tmp27_ = len;
		_tmp28_ = g_malloc (_tmp27_);
		res = _tmp28_;
		_tmp29_ = res;
		_tmp30_ = str_array[0];
		_tmp31_ = g_stpcpy ((void*) _tmp29_, (const gchar*) _tmp30_);
		ptr = _tmp31_;
		{
			gboolean _tmp32_ = FALSE;
			i = 1;
			_tmp32_ = TRUE;
			while (TRUE) {
				gint _tmp34_;
				void* _tmp35_;
				void* _tmp36_;
				const gchar* _tmp37_ = NULL;
				gint _tmp38_;
				const gchar* _tmp39_;
				void* _tmp42_;
				void* _tmp43_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = i;
				if (!(_tmp34_ < str_array_length1)) {
					break;
				}
				_tmp35_ = ptr;
				_tmp36_ = g_stpcpy (_tmp35_, (const gchar*) separator);
				ptr = _tmp36_;
				_tmp38_ = i;
				_tmp39_ = str_array[_tmp38_];
				if (_tmp39_ != NULL) {
					gint _tmp40_;
					const gchar* _tmp41_;
					_tmp40_ = i;
					_tmp41_ = str_array[_tmp40_];
					_tmp37_ = (const gchar*) _tmp41_;
				} else {
					_tmp37_ = "";
				}
				_tmp42_ = ptr;
				_tmp43_ = g_stpcpy (_tmp42_, _tmp37_);
				ptr = _tmp43_;
			}
		}
		_tmp44_ = res;
		res = NULL;
		result = (gchar*) _tmp44_;
		return result;
	} else {
		gchar* _tmp45_;
		_tmp45_ = g_strdup ("");
		result = _tmp45_;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp164_;
	GEqualFunc _tmp165_;
	GEqualFunc _tmp166_;
	ValaHashMap* _tmp167_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp168_;
	ValaHashMap* _tmp169_;
	gboolean _tmp170_ = FALSE;
	ValaMethod* _tmp171_;
	gboolean _tmp317_ = FALSE;
	ValaMethod* _tmp318_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp496_;
	ValaCCodeExpression* _tmp497_;
	ValaMethod* _tmp498_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp522_ = FALSE;
	ValaMethod* _tmp523_;
	gboolean _tmp679_ = FALSE;
	ValaMethod* _tmp680_;
	ValaMethod* _tmp732_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp933_;
	ValaIterator* _tmp934_;
	ValaIterator* _tmp1290_;
	gboolean _tmp1300_ = FALSE;
	gboolean _tmp1301_ = FALSE;
	ValaMethod* _tmp1302_;
	gboolean _tmp1427_ = FALSE;
	ValaDelegate* _tmp1428_;
	gboolean _tmp1525_ = FALSE;
	ValaMethod* _tmp1526_;
	gboolean _tmp1542_;
	gboolean _tmp1543_;
	gboolean _tmp1558_;
	ValaDataType* _tmp1583_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1607_;
	ValaDataType* _tmp1608_;
	ValaDataType* _tmp1609_;
	gboolean _tmp1610_;
	gboolean _tmp1611_ = FALSE;
	ValaDataType* _tmp1612_;
	ValaCCodeFunctionCall* _tmp1641_;
	ValaCCodeFunctionCall* _tmp1642_;
	ValaCCodeExpression* out_param_ref = NULL;
	gboolean _tmp1643_;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1658_;
	ValaCCodeFunctionCall* _tmp1659_;
	ValaCCodeFunctionCall* _tmp1683_;
	gboolean _tmp1707_;
	gboolean _tmp1708_;
	gboolean _tmp1734_;
	gboolean _tmp1735_;
	gboolean _tmp1765_;
	gboolean _tmp1771_ = FALSE;
	gboolean _tmp1772_ = FALSE;
	ValaMethod* _tmp1773_;
	gboolean _tmp1811_ = FALSE;
	gboolean _tmp1812_ = FALSE;
	ValaMethod* _tmp1813_;
	ValaMethod* _tmp1832_;
	gboolean _tmp1949_ = FALSE;
	ValaCodeNode* _tmp1950_;
	ValaCodeNode* _tmp1951_;
	ValaList* _tmp2034_;
	ValaIterator* _tmp2035_;
	gboolean _tmp2120_ = FALSE;
	gboolean _tmp2121_ = FALSE;
	ValaMethod* _tmp2122_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_tostring_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_ = FALSE;
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			ValaCodeContext* _tmp60_;
			ValaCodeContext* _tmp61_;
			ValaProfile _tmp62_;
			ValaProfile _tmp63_;
			_tmp60_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_code_context_get_profile (_tmp61_);
			_tmp63_ = _tmp62_;
			if (_tmp63_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp64_;
				ValaExpression* _tmp65_;
				ValaExpression* _tmp66_;
				_tmp64_ = ma;
				_tmp65_ = vala_member_access_get_inner (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp59_ = _tmp66_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp67_;
				ValaExpression* _tmp68_;
				ValaExpression* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				_tmp67_ = ma;
				_tmp68_ = vala_member_access_get_inner (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_expression_get_value_type (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp58_ = _tmp71_ != NULL;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp72_;
				ValaExpression* _tmp73_;
				ValaExpression* _tmp74_;
				ValaDataType* _tmp75_;
				ValaDataType* _tmp76_;
				ValaTypeSymbol* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaDataType* _tmp79_;
				ValaTypeSymbol* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				_tmp72_ = ma;
				_tmp73_ = vala_member_access_get_inner (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_expression_get_value_type (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = vala_data_type_get_data_type (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp80_ = vala_data_type_get_data_type (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp57_ = _tmp78_ == _tmp81_;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaMemberAccess* _tmp82_;
				const gchar* _tmp83_;
				const gchar* _tmp84_;
				_tmp82_ = ma;
				_tmp83_ = vala_member_access_get_member_name (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp56_ = g_strcmp0 (_tmp84_, "printf") == 0;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				ValaCCodeFunctionCall* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				ValaCCodeIdentifier* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				_tmp85_ = ccall;
				_tmp86_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_ccode_identifier_new (_tmp87_);
				_tmp89_ = _tmp88_;
				vala_ccode_function_call_set_call (_tmp85_, (ValaCCodeExpression*) _tmp89_);
				_vala_ccode_node_unref0 (_tmp89_);
				_g_free0 (_tmp87_);
			} else {
				gboolean _tmp90_;
				gboolean _tmp91_;
				_tmp90_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp91_ = _tmp90_;
				if (_tmp91_) {
					ValaCCodeFunctionCall* _tmp92_;
					ValaMethod* _tmp93_;
					gchar* _tmp94_;
					gchar* _tmp95_;
					ValaCCodeIdentifier* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					_tmp92_ = ccall;
					_tmp93_ = m;
					_tmp94_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp95_ = _tmp94_;
					_tmp96_ = vala_ccode_identifier_new (_tmp95_);
					_tmp97_ = _tmp96_;
					vala_ccode_function_call_set_call (_tmp92_, (ValaCCodeExpression*) _tmp97_);
					_vala_ccode_node_unref0 (_tmp97_);
					_g_free0 (_tmp95_);
				}
			}
		}
	} else {
		ValaDataType* _tmp98_;
		_tmp98_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp99_;
			ValaSignalType* _tmp100_;
			gboolean _tmp101_ = FALSE;
			gboolean _tmp102_ = FALSE;
			ValaMemberAccess* _tmp103_;
			_tmp99_ = itype;
			_tmp100_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp100_;
			_tmp103_ = ma;
			if (_tmp103_ != NULL) {
				ValaMemberAccess* _tmp104_;
				ValaExpression* _tmp105_;
				ValaExpression* _tmp106_;
				_tmp104_ = ma;
				_tmp105_ = vala_member_access_get_inner (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp102_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp107_;
				ValaSignal* _tmp108_;
				ValaSignal* _tmp109_;
				gboolean _tmp110_;
				gboolean _tmp111_;
				_tmp107_ = sig_type;
				_tmp108_ = vala_signal_type_get_signal_symbol (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = vala_signal_get_is_virtual (_tmp109_);
				_tmp111_ = _tmp110_;
				_tmp101_ = _tmp111_;
			} else {
				_tmp101_ = FALSE;
			}
			if (_tmp101_) {
				ValaSignalType* _tmp112_;
				ValaSignal* _tmp113_;
				ValaSignal* _tmp114_;
				ValaMethod* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				_tmp112_ = sig_type;
				_tmp113_ = vala_signal_type_get_signal_symbol (_tmp112_);
				_tmp114_ = _tmp113_;
				_tmp115_ = vala_signal_get_default_handler (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp117_ = _vala_code_node_ref0 (_tmp116_);
				_vala_code_node_unref0 (m);
				m = _tmp117_;
			} else {
				ValaExpression* _tmp118_;
				ValaExpression* _tmp119_;
				ValaCCodeExpression* _tmp120_;
				_tmp118_ = vala_method_call_get_call (expr);
				_tmp119_ = _tmp118_;
				_tmp120_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp119_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp121_;
			_tmp121_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp121_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp122_;
				ValaObjectTypeSymbol* _tmp123_;
				ValaObjectTypeSymbol* _tmp124_;
				ValaClass* _tmp125_;
				ValaClass* _tmp126_;
				ValaCreationMethod* _tmp127_;
				ValaCreationMethod* _tmp128_;
				ValaMethod* _tmp129_;
				ValaMethod* _tmp130_;
				ValaCCodeFile* _tmp131_;
				gchar* real_name = NULL;
				ValaMethod* _tmp132_;
				gchar* _tmp133_;
				gboolean _tmp134_;
				gboolean _tmp135_;
				const gchar* _tmp138_;
				ValaCCodeIdentifier* _tmp139_;
				ValaCCodeIdentifier* _tmp140_;
				ValaCCodeFunctionCall* _tmp141_;
				_tmp122_ = itype;
				_tmp123_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp124_ = _tmp123_;
				_tmp125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp125_;
				_tmp126_ = cl;
				_tmp127_ = vala_class_get_default_construction_method (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = _vala_code_node_ref0 ((ValaMethod*) _tmp128_);
				_vala_code_node_unref0 (m);
				m = _tmp129_;
				_tmp130_ = m;
				_tmp131_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp130_, _tmp131_);
				_tmp132_ = m;
				_tmp133_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp132_);
				real_name = _tmp133_;
				_tmp134_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp135_ = _tmp134_;
				if (_tmp135_) {
					ValaMethod* _tmp136_;
					gchar* _tmp137_;
					_tmp136_ = m;
					_tmp137_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp137_;
				}
				_tmp138_ = real_name;
				_tmp139_ = vala_ccode_identifier_new (_tmp138_);
				_tmp140_ = _tmp139_;
				_tmp141_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp140_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp141_;
				_vala_ccode_node_unref0 (_tmp140_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp142_;
				_tmp142_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp142_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp143_;
					ValaTypeSymbol* _tmp144_;
					ValaTypeSymbol* _tmp145_;
					ValaStruct* _tmp146_;
					ValaStruct* _tmp147_;
					ValaMethod* _tmp148_;
					ValaMethod* _tmp149_;
					ValaMethod* _tmp150_;
					ValaMethod* _tmp151_;
					ValaCCodeFile* _tmp152_;
					ValaMethod* _tmp153_;
					gchar* _tmp154_;
					gchar* _tmp155_;
					ValaCCodeIdentifier* _tmp156_;
					ValaCCodeIdentifier* _tmp157_;
					ValaCCodeFunctionCall* _tmp158_;
					_tmp143_ = itype;
					_tmp144_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp145_ = _tmp144_;
					_tmp146_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp146_;
					_tmp147_ = st;
					_tmp148_ = vala_struct_get_default_construction_method (_tmp147_);
					_tmp149_ = _tmp148_;
					_tmp150_ = _vala_code_node_ref0 (_tmp149_);
					_vala_code_node_unref0 (m);
					m = _tmp150_;
					_tmp151_ = m;
					_tmp152_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp151_, _tmp152_);
					_tmp153_ = m;
					_tmp154_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp153_);
					_tmp155_ = _tmp154_;
					_tmp156_ = vala_ccode_identifier_new (_tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp157_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp158_;
					_vala_ccode_node_unref0 (_tmp157_);
					_g_free0 (_tmp155_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp159_;
					_tmp159_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp160_;
						ValaDelegate* _tmp161_;
						ValaDelegate* _tmp162_;
						ValaDelegate* _tmp163_;
						_tmp160_ = itype;
						_tmp161_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp162_ = _tmp161_;
						_tmp163_ = _vala_code_node_ref0 (_tmp162_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp163_;
					}
				}
			}
		}
	}
	_tmp164_ = g_direct_hash;
	_tmp165_ = g_direct_equal;
	_tmp166_ = g_direct_equal;
	_tmp167_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp164_, _tmp165_, _tmp166_);
	in_arg_map = _tmp167_;
	_tmp168_ = in_arg_map;
	_tmp169_ = _vala_map_ref0 (_tmp168_);
	out_arg_map = _tmp169_;
	_tmp171_ = m;
	if (_tmp171_ != NULL) {
		ValaMethod* _tmp172_;
		gboolean _tmp173_;
		gboolean _tmp174_;
		_tmp172_ = m;
		_tmp173_ = vala_method_get_coroutine (_tmp172_);
		_tmp174_ = _tmp173_;
		_tmp170_ = _tmp174_;
	} else {
		_tmp170_ = FALSE;
	}
	if (_tmp170_) {
		ValaMethod* _tmp175_;
		gchar* _tmp176_;
		gchar* _tmp177_;
		ValaCCodeIdentifier* _tmp178_;
		ValaCCodeIdentifier* _tmp179_;
		ValaCCodeFunctionCall* _tmp180_;
		ValaMethod* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		ValaCCodeIdentifier* _tmp184_;
		ValaCCodeIdentifier* _tmp185_;
		ValaCCodeFunctionCall* _tmp186_;
		ValaMemberAccess* _tmp187_;
		ValaExpression* _tmp188_;
		ValaExpression* _tmp189_;
		gboolean _tmp267_ = FALSE;
		ValaMemberAccess* _tmp268_;
		const gchar* _tmp269_;
		const gchar* _tmp270_;
		_tmp175_ = m;
		_tmp176_ = vala_get_ccode_name ((ValaCodeNode*) _tmp175_);
		_tmp177_ = _tmp176_;
		_tmp178_ = vala_ccode_identifier_new (_tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp179_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp180_;
		_vala_ccode_node_unref0 (_tmp179_);
		_g_free0 (_tmp177_);
		_tmp181_ = m;
		_tmp182_ = vala_get_ccode_finish_name (_tmp181_);
		_tmp183_ = _tmp182_;
		_tmp184_ = vala_ccode_identifier_new (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp185_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp186_;
		_vala_ccode_node_unref0 (_tmp185_);
		_g_free0 (_tmp183_);
		_tmp187_ = ma;
		_tmp188_ = vala_member_access_get_inner (_tmp187_);
		_tmp189_ = _tmp188_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp189_, VALA_TYPE_BASE_ACCESS)) {
			ValaMethod* _tmp190_;
			ValaMethod* _tmp191_;
			ValaMethod* _tmp192_;
			_tmp190_ = m;
			_tmp191_ = vala_method_get_base_method (_tmp190_);
			_tmp192_ = _tmp191_;
			if (_tmp192_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp193_;
				ValaMethod* _tmp194_;
				ValaMethod* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaClass* _tmp198_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaClass* _tmp199_;
				gchar* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				gchar* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeIdentifier* _tmp205_;
				ValaCCodeFunctionCall* _tmp206_;
				ValaCCodeFunctionCall* _tmp207_;
				ValaCCodeFunctionCall* _tmp208_;
				ValaClass* _tmp209_;
				ValaClass* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				gchar* _tmp213_;
				gchar* _tmp214_;
				ValaCCodeIdentifier* _tmp215_;
				ValaCCodeIdentifier* _tmp216_;
				ValaCCodeFunctionCall* _tmp217_;
				ValaCCodeFunctionCall* _tmp218_;
				ValaMethod* _tmp219_;
				gchar* _tmp220_;
				gchar* _tmp221_;
				ValaCCodeMemberAccess* _tmp222_;
				ValaCCodeMemberAccess* _tmp223_;
				ValaCCodeFunctionCall* _tmp224_;
				ValaCCodeFunctionCall* _tmp225_;
				ValaMethod* _tmp226_;
				gchar* _tmp227_;
				gchar* _tmp228_;
				ValaCCodeMemberAccess* _tmp229_;
				ValaCCodeMemberAccess* _tmp230_;
				_tmp193_ = m;
				_tmp194_ = vala_method_get_base_method (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp197_, VALA_TYPE_CLASS, ValaClass));
				base_class = _tmp198_;
				_tmp199_ = base_class;
				_tmp200_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp199_, NULL);
				_tmp201_ = _tmp200_;
				_tmp202_ = g_strdup_printf ("%s_CLASS", _tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_ccode_identifier_new (_tmp203_);
				_tmp205_ = _tmp204_;
				_tmp206_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp205_);
				_tmp207_ = _tmp206_;
				_vala_ccode_node_unref0 (_tmp205_);
				_g_free0 (_tmp203_);
				_g_free0 (_tmp201_);
				vcast = _tmp207_;
				_tmp208_ = vcast;
				_tmp209_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp210_ = _tmp209_;
				_tmp211_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp210_, NULL);
				_tmp212_ = _tmp211_;
				_tmp213_ = g_strdup_printf ("%s_parent_class", _tmp212_);
				_tmp214_ = _tmp213_;
				_tmp215_ = vala_ccode_identifier_new (_tmp214_);
				_tmp216_ = _tmp215_;
				vala_ccode_function_call_add_argument (_tmp208_, (ValaCCodeExpression*) _tmp216_);
				_vala_ccode_node_unref0 (_tmp216_);
				_g_free0 (_tmp214_);
				_g_free0 (_tmp212_);
				_tmp217_ = async_call;
				_tmp218_ = vcast;
				_tmp219_ = m;
				_tmp220_ = vala_get_ccode_vfunc_name (_tmp219_);
				_tmp221_ = _tmp220_;
				_tmp222_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp218_, _tmp221_);
				_tmp223_ = _tmp222_;
				vala_ccode_function_call_set_call (_tmp217_, (ValaCCodeExpression*) _tmp223_);
				_vala_ccode_node_unref0 (_tmp223_);
				_g_free0 (_tmp221_);
				_tmp224_ = finish_call;
				_tmp225_ = vcast;
				_tmp226_ = m;
				_tmp227_ = vala_get_ccode_finish_vfunc_name (_tmp226_);
				_tmp228_ = _tmp227_;
				_tmp229_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp225_, _tmp228_);
				_tmp230_ = _tmp229_;
				vala_ccode_function_call_set_call (_tmp224_, (ValaCCodeExpression*) _tmp230_);
				_vala_ccode_node_unref0 (_tmp230_);
				_g_free0 (_tmp228_);
				_vala_ccode_node_unref0 (vcast);
				_vala_code_node_unref0 (base_class);
			} else {
				ValaMethod* _tmp231_;
				ValaMethod* _tmp232_;
				ValaMethod* _tmp233_;
				_tmp231_ = m;
				_tmp232_ = vala_method_get_base_interface_method (_tmp231_);
				_tmp233_ = _tmp232_;
				if (_tmp233_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp234_;
					ValaMethod* _tmp235_;
					ValaMethod* _tmp236_;
					ValaSymbol* _tmp237_;
					ValaSymbol* _tmp238_;
					ValaInterface* _tmp239_;
					gchar* parent_iface_var = NULL;
					ValaClass* _tmp240_;
					ValaClass* _tmp241_;
					gchar* _tmp242_;
					gchar* _tmp243_;
					ValaInterface* _tmp244_;
					gchar* _tmp245_;
					gchar* _tmp246_;
					gchar* _tmp247_;
					gchar* _tmp248_;
					ValaCCodeFunctionCall* _tmp249_;
					const gchar* _tmp250_;
					ValaCCodeIdentifier* _tmp251_;
					ValaCCodeIdentifier* _tmp252_;
					ValaMethod* _tmp253_;
					gchar* _tmp254_;
					gchar* _tmp255_;
					ValaCCodeMemberAccess* _tmp256_;
					ValaCCodeMemberAccess* _tmp257_;
					ValaCCodeFunctionCall* _tmp258_;
					const gchar* _tmp259_;
					ValaCCodeIdentifier* _tmp260_;
					ValaCCodeIdentifier* _tmp261_;
					ValaMethod* _tmp262_;
					gchar* _tmp263_;
					gchar* _tmp264_;
					ValaCCodeMemberAccess* _tmp265_;
					ValaCCodeMemberAccess* _tmp266_;
					_tmp234_ = m;
					_tmp235_ = vala_method_get_base_interface_method (_tmp234_);
					_tmp236_ = _tmp235_;
					_tmp237_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp236_);
					_tmp238_ = _tmp237_;
					_tmp239_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp238_, VALA_TYPE_INTERFACE, ValaInterface));
					base_iface = _tmp239_;
					_tmp240_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp241_ = _tmp240_;
					_tmp242_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp241_, NULL);
					_tmp243_ = _tmp242_;
					_tmp244_ = base_iface;
					_tmp245_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp244_, NULL);
					_tmp246_ = _tmp245_;
					_tmp247_ = g_strdup_printf ("%s_%s_parent_iface", _tmp243_, _tmp246_);
					_tmp248_ = _tmp247_;
					_g_free0 (_tmp246_);
					_g_free0 (_tmp243_);
					parent_iface_var = _tmp248_;
					_tmp249_ = async_call;
					_tmp250_ = parent_iface_var;
					_tmp251_ = vala_ccode_identifier_new (_tmp250_);
					_tmp252_ = _tmp251_;
					_tmp253_ = m;
					_tmp254_ = vala_get_ccode_vfunc_name (_tmp253_);
					_tmp255_ = _tmp254_;
					_tmp256_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp252_, _tmp255_);
					_tmp257_ = _tmp256_;
					vala_ccode_function_call_set_call (_tmp249_, (ValaCCodeExpression*) _tmp257_);
					_vala_ccode_node_unref0 (_tmp257_);
					_g_free0 (_tmp255_);
					_vala_ccode_node_unref0 (_tmp252_);
					_tmp258_ = finish_call;
					_tmp259_ = parent_iface_var;
					_tmp260_ = vala_ccode_identifier_new (_tmp259_);
					_tmp261_ = _tmp260_;
					_tmp262_ = m;
					_tmp263_ = vala_get_ccode_finish_vfunc_name (_tmp262_);
					_tmp264_ = _tmp263_;
					_tmp265_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp261_, _tmp264_);
					_tmp266_ = _tmp265_;
					vala_ccode_function_call_set_call (_tmp258_, (ValaCCodeExpression*) _tmp266_);
					_vala_ccode_node_unref0 (_tmp266_);
					_g_free0 (_tmp264_);
					_vala_ccode_node_unref0 (_tmp261_);
					_g_free0 (parent_iface_var);
					_vala_code_node_unref0 (base_iface);
				}
			}
		}
		_tmp268_ = ma;
		_tmp269_ = vala_member_access_get_member_name (_tmp268_);
		_tmp270_ = _tmp269_;
		if (g_strcmp0 (_tmp270_, "begin") == 0) {
			ValaMemberAccess* _tmp271_;
			ValaExpression* _tmp272_;
			ValaExpression* _tmp273_;
			ValaSymbol* _tmp274_;
			ValaSymbol* _tmp275_;
			ValaMemberAccess* _tmp276_;
			ValaSymbol* _tmp277_;
			ValaSymbol* _tmp278_;
			_tmp271_ = ma;
			_tmp272_ = vala_member_access_get_inner (_tmp271_);
			_tmp273_ = _tmp272_;
			_tmp274_ = vala_expression_get_symbol_reference (_tmp273_);
			_tmp275_ = _tmp274_;
			_tmp276_ = ma;
			_tmp277_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp276_);
			_tmp278_ = _tmp277_;
			_tmp267_ = _tmp275_ == _tmp278_;
		} else {
			_tmp267_ = FALSE;
		}
		if (_tmp267_) {
			ValaCCodeFunctionCall* _tmp279_;
			ValaCCodeFunctionCall* _tmp280_;
			ValaMethod* _tmp281_;
			ValaList* _tmp282_;
			_tmp279_ = async_call;
			_tmp280_ = _vala_ccode_node_ref0 (_tmp279_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp280_;
			_tmp281_ = m;
			_tmp282_ = vala_method_get_async_begin_parameters (_tmp281_);
			_vala_iterable_unref0 (params);
			params = _tmp282_;
		} else {
			gboolean _tmp283_ = FALSE;
			ValaMemberAccess* _tmp284_;
			const gchar* _tmp285_;
			const gchar* _tmp286_;
			_tmp284_ = ma;
			_tmp285_ = vala_member_access_get_member_name (_tmp284_);
			_tmp286_ = _tmp285_;
			if (g_strcmp0 (_tmp286_, "end") == 0) {
				ValaMemberAccess* _tmp287_;
				ValaExpression* _tmp288_;
				ValaExpression* _tmp289_;
				ValaSymbol* _tmp290_;
				ValaSymbol* _tmp291_;
				ValaMemberAccess* _tmp292_;
				ValaSymbol* _tmp293_;
				ValaSymbol* _tmp294_;
				_tmp287_ = ma;
				_tmp288_ = vala_member_access_get_inner (_tmp287_);
				_tmp289_ = _tmp288_;
				_tmp290_ = vala_expression_get_symbol_reference (_tmp289_);
				_tmp291_ = _tmp290_;
				_tmp292_ = ma;
				_tmp293_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp292_);
				_tmp294_ = _tmp293_;
				_tmp283_ = _tmp291_ == _tmp294_;
			} else {
				_tmp283_ = FALSE;
			}
			if (_tmp283_) {
				ValaCCodeFunctionCall* _tmp295_;
				ValaCCodeFunctionCall* _tmp296_;
				ValaMethod* _tmp297_;
				ValaList* _tmp298_;
				_tmp295_ = finish_call;
				_tmp296_ = _vala_ccode_node_ref0 (_tmp295_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp296_;
				_tmp297_ = m;
				_tmp298_ = vala_method_get_async_end_parameters (_tmp297_);
				_vala_iterable_unref0 (params);
				params = _tmp298_;
			} else {
				gboolean _tmp299_;
				gboolean _tmp300_;
				_tmp299_ = vala_method_call_get_is_yield_expression (expr);
				_tmp300_ = _tmp299_;
				if (!_tmp300_) {
					ValaCCodeFunctionCall* _tmp301_;
					ValaCCodeFunctionCall* _tmp302_;
					ValaMethod* _tmp303_;
					ValaList* _tmp304_;
					_tmp301_ = async_call;
					_tmp302_ = _vala_ccode_node_ref0 (_tmp301_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp302_;
					_tmp303_ = m;
					_tmp304_ = vala_method_get_async_begin_parameters (_tmp303_);
					_vala_iterable_unref0 (params);
					params = _tmp304_;
				} else {
					ValaCCodeFunctionCall* _tmp305_;
					ValaCCodeFunctionCall* _tmp306_;
					GHashFunc _tmp307_;
					GEqualFunc _tmp308_;
					GEqualFunc _tmp309_;
					ValaHashMap* _tmp310_;
					ValaHashMap* _tmp311_;
					ValaMethod* _tmp312_;
					ValaCCodeIdentifier* _tmp313_;
					ValaCCodeIdentifier* _tmp314_;
					ValaCCodeMemberAccess* _tmp315_;
					ValaCCodeMemberAccess* _tmp316_;
					_tmp305_ = finish_call;
					_tmp306_ = _vala_ccode_node_ref0 (_tmp305_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp306_;
					_tmp307_ = g_direct_hash;
					_tmp308_ = g_direct_equal;
					_tmp309_ = g_direct_equal;
					_tmp310_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp307_, _tmp308_, _tmp309_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp310_;
					_tmp311_ = out_arg_map;
					_tmp312_ = m;
					_tmp313_ = vala_ccode_identifier_new ("_data_");
					_tmp314_ = _tmp313_;
					_tmp315_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp314_, "_res_");
					_tmp316_ = _tmp315_;
					vala_map_set ((ValaMap*) _tmp311_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp312_), FALSE)), (ValaCCodeExpression*) _tmp316_);
					_vala_ccode_node_unref0 (_tmp316_);
					_vala_ccode_node_unref0 (_tmp314_);
				}
			}
		}
	}
	_tmp318_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp318_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp319_;
		ValaSymbol* _tmp320_;
		ValaSymbol* _tmp321_;
		_tmp319_ = m;
		_tmp320_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp319_);
		_tmp321_ = _tmp320_;
		_tmp317_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp321_, VALA_TYPE_CLASS);
	} else {
		_tmp317_ = FALSE;
	}
	if (_tmp317_) {
		ValaCodeContext* _tmp322_;
		ValaCodeContext* _tmp323_;
		ValaProfile _tmp324_;
		ValaProfile _tmp325_;
		ValaClass* _tmp337_;
		ValaClass* _tmp338_;
		gboolean _tmp339_;
		gboolean _tmp340_;
		_tmp322_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp323_ = _tmp322_;
		_tmp324_ = vala_code_context_get_profile (_tmp323_);
		_tmp325_ = _tmp324_;
		if (_tmp325_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp326_;
			ValaSymbol* _tmp327_;
			ValaSymbol* _tmp328_;
			gboolean _tmp329_;
			gboolean _tmp330_;
			_tmp326_ = m;
			_tmp327_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp326_);
			_tmp328_ = _tmp327_;
			_tmp329_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp328_, VALA_TYPE_CLASS, ValaClass));
			_tmp330_ = _tmp329_;
			if (!_tmp330_) {
				ValaCCodeFunctionCall* _tmp331_;
				ValaCCodeExpression* _tmp332_;
				ValaCCodeExpression* _tmp333_;
				_tmp331_ = ccall;
				_tmp332_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp333_ = _tmp332_;
				vala_ccode_function_call_add_argument (_tmp331_, _tmp333_);
				_vala_ccode_node_unref0 (_tmp333_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp334_;
			ValaCCodeExpression* _tmp335_;
			ValaCCodeExpression* _tmp336_;
			_tmp334_ = ccall;
			_tmp335_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp336_ = _tmp335_;
			vala_ccode_function_call_add_argument (_tmp334_, _tmp336_);
			_vala_ccode_node_unref0 (_tmp336_);
		}
		_tmp337_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp338_ = _tmp337_;
		_tmp339_ = vala_class_get_is_compact (_tmp338_);
		_tmp340_ = _tmp339_;
		if (!_tmp340_) {
			ValaClass* _tmp341_;
			ValaClass* _tmp342_;
			ValaMethod* _tmp343_;
			ValaSymbol* _tmp344_;
			ValaSymbol* _tmp345_;
			_tmp341_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp342_ = _tmp341_;
			_tmp343_ = m;
			_tmp344_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp343_);
			_tmp345_ = _tmp344_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp342_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp345_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp346_;
					ValaClass* _tmp347_;
					ValaList* _tmp348_;
					gint _base_type_size = 0;
					ValaList* _tmp349_;
					gint _tmp350_;
					gint _tmp351_;
					gint _base_type_index = 0;
					_tmp346_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp347_ = _tmp346_;
					_tmp348_ = vala_class_get_base_types (_tmp347_);
					_base_type_list = _tmp348_;
					_tmp349_ = _base_type_list;
					_tmp350_ = vala_collection_get_size ((ValaCollection*) _tmp349_);
					_tmp351_ = _tmp350_;
					_base_type_size = _tmp351_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp352_;
						gint _tmp353_;
						gint _tmp354_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp355_;
						gint _tmp356_;
						gpointer _tmp357_;
						ValaDataType* _tmp358_;
						ValaTypeSymbol* _tmp359_;
						ValaTypeSymbol* _tmp360_;
						_tmp352_ = _base_type_index;
						_base_type_index = _tmp352_ + 1;
						_tmp353_ = _base_type_index;
						_tmp354_ = _base_type_size;
						if (!(_tmp353_ < _tmp354_)) {
							break;
						}
						_tmp355_ = _base_type_list;
						_tmp356_ = _base_type_index;
						_tmp357_ = vala_list_get (_tmp355_, _tmp356_);
						base_type = (ValaDataType*) _tmp357_;
						_tmp358_ = base_type;
						_tmp359_ = vala_data_type_get_data_type (_tmp358_);
						_tmp360_ = _tmp359_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp360_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp361_;
							gchar* _tmp362_;
							gchar* _tmp363_;
							gboolean _tmp364_;
							ValaHashMap* _tmp369_;
							ValaDataType* _tmp370_;
							ValaList* _tmp371_;
							ValaList* _tmp372_;
							ValaList* _tmp373_;
							type_parameters = NULL;
							_tmp361_ = m;
							_tmp362_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp361_);
							_tmp363_ = _tmp362_;
							_tmp364_ = g_strcmp0 (_tmp363_, "g_object_new") == 0;
							_g_free0 (_tmp363_);
							if (_tmp364_) {
								ValaDataType* _tmp365_;
								ValaTypeSymbol* _tmp366_;
								ValaTypeSymbol* _tmp367_;
								ValaList* _tmp368_;
								_tmp365_ = base_type;
								_tmp366_ = vala_data_type_get_data_type (_tmp365_);
								_tmp367_ = _tmp366_;
								_tmp368_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp367_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp368_;
							}
							_tmp369_ = in_arg_map;
							_tmp370_ = base_type;
							_tmp371_ = vala_data_type_get_type_arguments (_tmp370_);
							_tmp372_ = _tmp371_;
							_tmp373_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp369_, _tmp372_, (ValaCodeNode*) expr, TRUE, _tmp373_);
							_vala_iterable_unref0 (_tmp372_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp374_;
				ValaSymbol* _tmp375_;
				ValaSymbol* _tmp376_;
				ValaClass* _tmp377_;
				type_param_index = 0;
				_tmp374_ = m;
				_tmp375_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp374_);
				_tmp376_ = _tmp375_;
				_tmp377_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp376_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp377_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp378_;
					ValaList* _tmp379_;
					gint _type_param_size = 0;
					ValaList* _tmp380_;
					gint _tmp381_;
					gint _tmp382_;
					gint _type_param_index = 0;
					_tmp378_ = cl;
					_tmp379_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp378_);
					_type_param_list = _tmp379_;
					_tmp380_ = _type_param_list;
					_tmp381_ = vala_collection_get_size ((ValaCollection*) _tmp380_);
					_tmp382_ = _tmp381_;
					_type_param_size = _tmp382_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp383_;
						gint _tmp384_;
						gint _tmp385_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp386_;
						gint _tmp387_;
						gpointer _tmp388_;
						ValaHashMap* _tmp389_;
						gint _tmp390_;
						ValaTypeParameter* _tmp391_;
						const gchar* _tmp392_;
						const gchar* _tmp393_;
						gchar* _tmp394_;
						gchar* _tmp395_;
						gchar* _tmp396_;
						gchar* _tmp397_;
						ValaCCodeIdentifier* _tmp398_;
						ValaCCodeIdentifier* _tmp399_;
						ValaHashMap* _tmp400_;
						gint _tmp401_;
						ValaTypeParameter* _tmp402_;
						const gchar* _tmp403_;
						const gchar* _tmp404_;
						gchar* _tmp405_;
						gchar* _tmp406_;
						gchar* _tmp407_;
						gchar* _tmp408_;
						ValaCCodeIdentifier* _tmp409_;
						ValaCCodeIdentifier* _tmp410_;
						ValaHashMap* _tmp411_;
						gint _tmp412_;
						ValaTypeParameter* _tmp413_;
						const gchar* _tmp414_;
						const gchar* _tmp415_;
						gchar* _tmp416_;
						gchar* _tmp417_;
						gchar* _tmp418_;
						gchar* _tmp419_;
						ValaCCodeIdentifier* _tmp420_;
						ValaCCodeIdentifier* _tmp421_;
						gint _tmp422_;
						_tmp383_ = _type_param_index;
						_type_param_index = _tmp383_ + 1;
						_tmp384_ = _type_param_index;
						_tmp385_ = _type_param_size;
						if (!(_tmp384_ < _tmp385_)) {
							break;
						}
						_tmp386_ = _type_param_list;
						_tmp387_ = _type_param_index;
						_tmp388_ = vala_list_get (_tmp386_, _tmp387_);
						type_param = (ValaTypeParameter*) _tmp388_;
						_tmp389_ = in_arg_map;
						_tmp390_ = type_param_index;
						_tmp391_ = type_param;
						_tmp392_ = vala_symbol_get_name ((ValaSymbol*) _tmp391_);
						_tmp393_ = _tmp392_;
						_tmp394_ = g_utf8_strdown (_tmp393_, (gssize) -1);
						_tmp395_ = _tmp394_;
						_tmp396_ = g_strdup_printf ("%s_type", _tmp395_);
						_tmp397_ = _tmp396_;
						_tmp398_ = vala_ccode_identifier_new (_tmp397_);
						_tmp399_ = _tmp398_;
						vala_map_set ((ValaMap*) _tmp389_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp390_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp399_);
						_vala_ccode_node_unref0 (_tmp399_);
						_g_free0 (_tmp397_);
						_g_free0 (_tmp395_);
						_tmp400_ = in_arg_map;
						_tmp401_ = type_param_index;
						_tmp402_ = type_param;
						_tmp403_ = vala_symbol_get_name ((ValaSymbol*) _tmp402_);
						_tmp404_ = _tmp403_;
						_tmp405_ = g_utf8_strdown (_tmp404_, (gssize) -1);
						_tmp406_ = _tmp405_;
						_tmp407_ = g_strdup_printf ("%s_dup_func", _tmp406_);
						_tmp408_ = _tmp407_;
						_tmp409_ = vala_ccode_identifier_new (_tmp408_);
						_tmp410_ = _tmp409_;
						vala_map_set ((ValaMap*) _tmp400_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp401_) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp410_);
						_vala_ccode_node_unref0 (_tmp410_);
						_g_free0 (_tmp408_);
						_g_free0 (_tmp406_);
						_tmp411_ = in_arg_map;
						_tmp412_ = type_param_index;
						_tmp413_ = type_param;
						_tmp414_ = vala_symbol_get_name ((ValaSymbol*) _tmp413_);
						_tmp415_ = _tmp414_;
						_tmp416_ = g_utf8_strdown (_tmp415_, (gssize) -1);
						_tmp417_ = _tmp416_;
						_tmp418_ = g_strdup_printf ("%s_destroy_func", _tmp417_);
						_tmp419_ = _tmp418_;
						_tmp420_ = vala_ccode_identifier_new (_tmp419_);
						_tmp421_ = _tmp420_;
						vala_map_set ((ValaMap*) _tmp411_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp412_) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp421_);
						_vala_ccode_node_unref0 (_tmp421_);
						_g_free0 (_tmp419_);
						_g_free0 (_tmp417_);
						_tmp422_ = type_param_index;
						type_param_index = _tmp422_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp423_;
			ValaClass* _tmp424_;
			ValaClass* _tmp425_;
			ValaClass* _tmp426_;
			ValaClass* _tmp427_;
			_tmp423_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp424_ = _tmp423_;
			_tmp425_ = vala_class_get_base_class (_tmp424_);
			_tmp426_ = _tmp425_;
			_tmp427_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp426_ == _tmp427_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp428_;
				ValaClass* _tmp429_;
				gchar* _tmp430_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp431_;
				ValaCCodeDeclaration* _tmp432_;
				ValaCCodeDeclaration* _tmp433_;
				const gchar* _tmp434_;
				const gchar* _tmp435_;
				const gchar* _tmp436_;
				const gchar* _tmp437_;
				gchar* _tmp438_;
				gchar* _tmp439_;
				ValaCCodeConstant* _tmp440_;
				ValaCCodeConstant* _tmp441_;
				ValaCCodeVariableDeclarator* _tmp442_;
				ValaCCodeVariableDeclarator* _tmp443_;
				ValaCCodeFunction* _tmp444_;
				ValaCCodeFunction* _tmp445_;
				ValaCCodeDeclaration* _tmp446_;
				ValaCCodeFunctionCall* _tmp447_;
				ValaCCodeIdentifier* _tmp448_;
				ValaCCodeIdentifier* _tmp449_;
				ValaCCodeUnaryExpression* _tmp450_;
				ValaCCodeUnaryExpression* _tmp451_;
				ValaCCodeCastExpression* _tmp452_;
				ValaCCodeCastExpression* _tmp453_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp454_;
				ValaCCodeIdentifier* _tmp455_;
				ValaCCodeFunctionCall* _tmp456_;
				ValaCCodeFunctionCall* _tmp457_;
				ValaCCodeFunctionCall* _tmp458_;
				ValaClass* _tmp459_;
				ValaClass* _tmp460_;
				gchar* _tmp461_;
				gchar* _tmp462_;
				ValaCCodeIdentifier* _tmp463_;
				ValaCCodeIdentifier* _tmp464_;
				ValaCCodeFunctionCall* _tmp465_;
				ValaCCodeFunctionCall* _tmp466_;
				_tmp428_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp429_ = _tmp428_;
				_tmp430_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp429_, NULL);
				class_prefix = _tmp430_;
				_tmp431_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp431_;
				_tmp432_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp432_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp433_ = funcs;
				_tmp434_ = class_prefix;
				_tmp435_ = class_prefix;
				_tmp436_ = class_prefix;
				_tmp437_ = class_prefix;
				_tmp438_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp434_, _tmp435_, _tmp436_, _tmp437_);
				_tmp439_ = _tmp438_;
				_tmp440_ = vala_ccode_constant_new (_tmp439_);
				_tmp441_ = _tmp440_;
				_tmp442_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp441_, NULL);
				_tmp443_ = _tmp442_;
				vala_ccode_declaration_add_declarator (_tmp433_, (ValaCCodeDeclarator*) _tmp443_);
				_vala_ccode_node_unref0 (_tmp443_);
				_vala_ccode_node_unref0 (_tmp441_);
				_g_free0 (_tmp439_);
				_tmp444_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp445_ = _tmp444_;
				_tmp446_ = funcs;
				vala_ccode_function_add_statement (_tmp445_, (ValaCCodeNode*) _tmp446_);
				_tmp447_ = ccall;
				_tmp448_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp449_ = _tmp448_;
				_tmp450_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp449_);
				_tmp451_ = _tmp450_;
				_tmp452_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp451_, "GSourceFuncs *");
				_tmp453_ = _tmp452_;
				vala_ccode_function_call_add_argument (_tmp447_, (ValaCCodeExpression*) _tmp453_);
				_vala_ccode_node_unref0 (_tmp453_);
				_vala_ccode_node_unref0 (_tmp451_);
				_vala_ccode_node_unref0 (_tmp449_);
				_tmp454_ = vala_ccode_identifier_new ("sizeof");
				_tmp455_ = _tmp454_;
				_tmp456_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp455_);
				_tmp457_ = _tmp456_;
				_vala_ccode_node_unref0 (_tmp455_);
				csizeof = _tmp457_;
				_tmp458_ = csizeof;
				_tmp459_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp460_ = _tmp459_;
				_tmp461_ = vala_get_ccode_name ((ValaCodeNode*) _tmp460_);
				_tmp462_ = _tmp461_;
				_tmp463_ = vala_ccode_identifier_new (_tmp462_);
				_tmp464_ = _tmp463_;
				vala_ccode_function_call_add_argument (_tmp458_, (ValaCCodeExpression*) _tmp464_);
				_vala_ccode_node_unref0 (_tmp464_);
				_g_free0 (_tmp462_);
				_tmp465_ = ccall;
				_tmp466_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp465_, (ValaCCodeExpression*) _tmp466_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp467_ = FALSE;
		ValaMethod* _tmp468_;
		_tmp468_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp468_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp469_;
			ValaSymbol* _tmp470_;
			ValaSymbol* _tmp471_;
			_tmp469_ = m;
			_tmp470_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp469_);
			_tmp471_ = _tmp470_;
			_tmp467_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp471_, VALA_TYPE_STRUCT);
		} else {
			_tmp467_ = FALSE;
		}
		if (_tmp467_) {
			ValaCCodeFunctionCall* _tmp472_;
			ValaCCodeExpression* _tmp473_;
			ValaCCodeExpression* _tmp474_;
			_tmp472_ = ccall;
			_tmp473_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp474_ = _tmp473_;
			vala_ccode_function_call_add_argument (_tmp472_, _tmp474_);
			_vala_ccode_node_unref0 (_tmp474_);
		} else {
			gboolean _tmp475_ = FALSE;
			gboolean _tmp476_ = FALSE;
			gboolean _tmp477_ = FALSE;
			gboolean _tmp478_ = FALSE;
			ValaMethod* _tmp479_;
			_tmp479_ = m;
			if (_tmp479_ != NULL) {
				ValaMethod* _tmp480_;
				ValaList* _tmp481_;
				ValaList* _tmp482_;
				gint _tmp483_;
				gint _tmp484_;
				_tmp480_ = m;
				_tmp481_ = vala_method_get_type_parameters (_tmp480_);
				_tmp482_ = _tmp481_;
				_tmp483_ = vala_collection_get_size ((ValaCollection*) _tmp482_);
				_tmp484_ = _tmp483_;
				_tmp478_ = _tmp484_ > 0;
				_vala_iterable_unref0 (_tmp482_);
			} else {
				_tmp478_ = FALSE;
			}
			if (_tmp478_) {
				ValaMethod* _tmp485_;
				_tmp485_ = m;
				_tmp477_ = !vala_get_ccode_has_generic_type_parameter (_tmp485_);
			} else {
				_tmp477_ = FALSE;
			}
			if (_tmp477_) {
				ValaMethod* _tmp486_;
				_tmp486_ = m;
				_tmp476_ = !vala_get_ccode_simple_generics (_tmp486_);
			} else {
				_tmp476_ = FALSE;
			}
			if (_tmp476_) {
				gboolean _tmp487_ = FALSE;
				ValaCCodeFunctionCall* _tmp488_;
				ValaCCodeFunctionCall* _tmp489_;
				_tmp488_ = ccall;
				_tmp489_ = finish_call;
				if (_tmp488_ != _tmp489_) {
					_tmp487_ = TRUE;
				} else {
					gboolean _tmp490_;
					gboolean _tmp491_;
					_tmp490_ = vala_method_call_get_is_yield_expression (expr);
					_tmp491_ = _tmp490_;
					_tmp487_ = _tmp491_;
				}
				_tmp475_ = _tmp487_;
			} else {
				_tmp475_ = FALSE;
			}
			if (_tmp475_) {
				ValaHashMap* _tmp492_;
				ValaMemberAccess* _tmp493_;
				ValaList* _tmp494_;
				ValaList* _tmp495_;
				_tmp492_ = in_arg_map;
				_tmp493_ = ma;
				_tmp494_ = vala_member_access_get_type_arguments (_tmp493_);
				_tmp495_ = _tmp494_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp492_, _tmp495_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp495_);
			}
		}
	}
	_tmp496_ = ccall;
	_tmp497_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp496_);
	ccall_expr = _tmp497_;
	_tmp498_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp498_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp499_;
		ValaExpression* _tmp500_;
		ValaExpression* _tmp501_;
		ValaDataType* _tmp502_;
		ValaDataType* _tmp503_;
		ValaArrayType* _tmp504_;
		ValaHashMap* _tmp505_;
		ValaArrayType* _tmp506_;
		ValaDataType* _tmp507_;
		ValaDataType* _tmp508_;
		gchar* _tmp509_;
		gchar* _tmp510_;
		ValaCCodeIdentifier* _tmp511_;
		ValaCCodeIdentifier* _tmp512_;
		_tmp499_ = ma;
		_tmp500_ = vala_member_access_get_inner (_tmp499_);
		_tmp501_ = _tmp500_;
		_tmp502_ = vala_expression_get_value_type (_tmp501_);
		_tmp503_ = _tmp502_;
		_tmp504_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp503_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp504_;
		_tmp505_ = in_arg_map;
		_tmp506_ = array_type;
		_tmp507_ = vala_array_type_get_element_type (_tmp506_);
		_tmp508_ = _tmp507_;
		_tmp509_ = vala_get_ccode_name ((ValaCodeNode*) _tmp508_);
		_tmp510_ = _tmp509_;
		_tmp511_ = vala_ccode_identifier_new (_tmp510_);
		_tmp512_ = _tmp511_;
		vala_map_set ((ValaMap*) _tmp505_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp512_);
		_vala_ccode_node_unref0 (_tmp512_);
		_g_free0 (_tmp510_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp513_;
		_tmp513_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp513_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp514_;
			_tmp514_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp514_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp515_;
				ValaExpression* _tmp516_;
				ValaExpression* _tmp517_;
				ValaTargetValue* _tmp518_;
				ValaTargetValue* _tmp519_;
				ValaTargetValue* _tmp520_;
				ValaTargetValue* _tmp521_;
				_tmp515_ = ma;
				_tmp516_ = vala_member_access_get_inner (_tmp515_);
				_tmp517_ = _tmp516_;
				_tmp518_ = vala_expression_get_target_value (_tmp517_);
				_tmp519_ = _tmp518_;
				_tmp520_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp519_, (ValaCodeNode*) expr);
				_tmp521_ = _tmp520_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp521_);
				_vala_target_value_unref0 (_tmp521_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp523_ = m;
	if (_tmp523_ != NULL) {
		ValaMethod* _tmp524_;
		gboolean _tmp525_;
		gboolean _tmp526_;
		_tmp524_ = m;
		_tmp525_ = vala_method_get_is_async_callback (_tmp524_);
		_tmp526_ = _tmp525_;
		_tmp522_ = _tmp526_;
	} else {
		_tmp522_ = FALSE;
	}
	if (_tmp522_) {
		ValaMethod* _tmp527_;
		ValaMethod* _tmp528_;
		gboolean _tmp529_;
		gboolean _tmp530_;
		ValaHashMap* _tmp544_;
		ValaMethod* _tmp545_;
		ValaCCodeExpression* _tmp546_;
		ValaHashMap* _tmp547_;
		ValaMethod* _tmp548_;
		ValaCCodeExpression* _tmp549_;
		_tmp527_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp528_ = _tmp527_;
		_tmp529_ = vala_method_get_closure (_tmp528_);
		_tmp530_ = _tmp529_;
		if (_tmp530_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp531_;
			ValaSymbol* _tmp532_;
			ValaSymbol* _tmp533_;
			ValaBlock* _tmp534_;
			ValaBlock* _tmp535_;
			ValaBlock* _tmp536_;
			ValaBlock* _tmp537_;
			gchar* _tmp538_;
			gchar* _tmp539_;
			ValaCCodeExpression* _tmp540_;
			ValaCCodeExpression* _tmp541_;
			ValaCCodeMemberAccess* _tmp542_;
			_tmp531_ = m;
			_tmp532_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp531_);
			_tmp533_ = _tmp532_;
			_tmp534_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp533_, VALA_TYPE_METHOD, ValaMethod));
			_tmp535_ = _tmp534_;
			_tmp536_ = _vala_code_node_ref0 (_tmp535_);
			block = _tmp536_;
			_tmp537_ = block;
			_tmp538_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp537_));
			_tmp539_ = _tmp538_;
			_tmp540_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp539_);
			_tmp541_ = _tmp540_;
			_tmp542_ = vala_ccode_member_access_new_pointer (_tmp541_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp542_;
			_vala_ccode_node_unref0 (_tmp541_);
			_g_free0 (_tmp539_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp543_;
			_tmp543_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp543_;
		}
		_tmp544_ = in_arg_map;
		_tmp545_ = m;
		_tmp546_ = instance;
		vala_map_set ((ValaMap*) _tmp544_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp545_), FALSE)), _tmp546_);
		_tmp547_ = out_arg_map;
		_tmp548_ = m;
		_tmp549_ = instance;
		vala_map_set ((ValaMap*) _tmp547_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp548_), FALSE)), _tmp549_);
	} else {
		gboolean _tmp550_ = FALSE;
		gboolean _tmp551_ = FALSE;
		ValaMethod* _tmp552_;
		_tmp552_ = m;
		if (_tmp552_ != NULL) {
			ValaMethod* _tmp553_;
			ValaMemberBinding _tmp554_;
			ValaMemberBinding _tmp555_;
			_tmp553_ = m;
			_tmp554_ = vala_method_get_binding (_tmp553_);
			_tmp555_ = _tmp554_;
			_tmp551_ = _tmp555_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp551_ = FALSE;
		}
		if (_tmp551_) {
			ValaMethod* _tmp556_;
			_tmp556_ = m;
			_tmp550_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp556_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp550_ = FALSE;
		}
		if (_tmp550_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp557_;
			ValaExpression* _tmp558_;
			ValaExpression* _tmp559_;
			ValaTargetValue* _tmp560_;
			ValaTargetValue* _tmp561_;
			ValaTargetValue* _tmp562_;
			gboolean _tmp563_ = FALSE;
			gboolean _tmp564_ = FALSE;
			ValaMemberAccess* _tmp565_;
			const gchar* _tmp566_;
			const gchar* _tmp567_;
			ValaTargetValue* _tmp589_;
			ValaCCodeExpression* _tmp590_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp591_;
			ValaSymbol* _tmp592_;
			ValaSymbol* _tmp593_;
			ValaStruct* _tmp594_;
			gboolean _tmp595_ = FALSE;
			ValaStruct* _tmp596_;
			gboolean _tmp605_;
			gboolean _tmp606_;
			_tmp557_ = ma;
			_tmp558_ = vala_member_access_get_inner (_tmp557_);
			_tmp559_ = _tmp558_;
			_tmp560_ = vala_expression_get_target_value (_tmp559_);
			_tmp561_ = _tmp560_;
			_tmp562_ = _vala_target_value_ref0 (_tmp561_);
			instance_value = _tmp562_;
			_tmp565_ = ma;
			_tmp566_ = vala_member_access_get_member_name (_tmp565_);
			_tmp567_ = _tmp566_;
			if (g_strcmp0 (_tmp567_, "begin") == 0) {
				_tmp564_ = TRUE;
			} else {
				ValaMemberAccess* _tmp568_;
				const gchar* _tmp569_;
				const gchar* _tmp570_;
				_tmp568_ = ma;
				_tmp569_ = vala_member_access_get_member_name (_tmp568_);
				_tmp570_ = _tmp569_;
				_tmp564_ = g_strcmp0 (_tmp570_, "end") == 0;
			}
			if (_tmp564_) {
				ValaMemberAccess* _tmp571_;
				ValaExpression* _tmp572_;
				ValaExpression* _tmp573_;
				ValaSymbol* _tmp574_;
				ValaSymbol* _tmp575_;
				ValaMemberAccess* _tmp576_;
				ValaSymbol* _tmp577_;
				ValaSymbol* _tmp578_;
				_tmp571_ = ma;
				_tmp572_ = vala_member_access_get_inner (_tmp571_);
				_tmp573_ = _tmp572_;
				_tmp574_ = vala_expression_get_symbol_reference (_tmp573_);
				_tmp575_ = _tmp574_;
				_tmp576_ = ma;
				_tmp577_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp576_);
				_tmp578_ = _tmp577_;
				_tmp563_ = _tmp575_ == _tmp578_;
			} else {
				_tmp563_ = FALSE;
			}
			if (_tmp563_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp579_;
				ValaExpression* _tmp580_;
				ValaExpression* _tmp581_;
				ValaMemberAccess* _tmp582_;
				ValaMemberAccess* _tmp583_;
				ValaExpression* _tmp584_;
				ValaExpression* _tmp585_;
				ValaTargetValue* _tmp586_;
				ValaTargetValue* _tmp587_;
				ValaTargetValue* _tmp588_;
				_tmp579_ = ma;
				_tmp580_ = vala_member_access_get_inner (_tmp579_);
				_tmp581_ = _tmp580_;
				_tmp582_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp581_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp582_;
				_tmp583_ = inner_ma;
				_tmp584_ = vala_member_access_get_inner (_tmp583_);
				_tmp585_ = _tmp584_;
				_tmp586_ = vala_expression_get_target_value (_tmp585_);
				_tmp587_ = _tmp586_;
				_tmp588_ = _vala_target_value_ref0 (_tmp587_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp588_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp589_ = instance_value;
			_tmp590_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp589_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp590_;
			_tmp591_ = m;
			_tmp592_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp591_);
			_tmp593_ = _tmp592_;
			_tmp594_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp593_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp593_) : NULL);
			st = _tmp594_;
			_tmp596_ = st;
			if (_tmp596_ != NULL) {
				ValaStruct* _tmp597_;
				_tmp597_ = st;
				_tmp595_ = !vala_struct_is_simple_type (_tmp597_);
			} else {
				_tmp595_ = FALSE;
			}
			if (_tmp595_) {
				ValaTargetValue* _tmp598_;
				ValaTargetValue* _tmp601_;
				ValaCCodeExpression* _tmp602_;
				ValaCCodeExpression* _tmp603_;
				ValaCCodeUnaryExpression* _tmp604_;
				_tmp598_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp598_)) {
					ValaTargetValue* _tmp599_;
					ValaTargetValue* _tmp600_;
					_tmp599_ = instance_value;
					_tmp600_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp599_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp600_;
				}
				_tmp601_ = instance_value;
				_tmp602_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp601_);
				_tmp603_ = _tmp602_;
				_tmp604_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp603_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp604_;
				_vala_ccode_node_unref0 (_tmp603_);
			}
			_tmp605_ = vala_method_call_get_is_yield_expression (expr);
			_tmp606_ = _tmp605_;
			if (_tmp606_) {
				ValaHashMap* _tmp607_;
				ValaMethod* _tmp608_;
				ValaCCodeExpression* _tmp609_;
				ValaMethod* _tmp610_;
				_tmp607_ = in_arg_map;
				_tmp608_ = m;
				_tmp609_ = instance;
				vala_map_set ((ValaMap*) _tmp607_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp608_), FALSE)), _tmp609_);
				_tmp610_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp610_)) {
					ValaHashMap* _tmp611_;
					ValaMethod* _tmp612_;
					ValaCCodeExpression* _tmp613_;
					_tmp611_ = out_arg_map;
					_tmp612_ = m;
					_tmp613_ = instance;
					vala_map_set ((ValaMap*) _tmp611_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp612_), FALSE)), _tmp613_);
				}
			} else {
				gboolean _tmp614_ = FALSE;
				ValaMemberAccess* _tmp615_;
				const gchar* _tmp616_;
				const gchar* _tmp617_;
				_tmp615_ = ma;
				_tmp616_ = vala_member_access_get_member_name (_tmp615_);
				_tmp617_ = _tmp616_;
				if (g_strcmp0 (_tmp617_, "end") != 0) {
					_tmp614_ = TRUE;
				} else {
					ValaMethod* _tmp618_;
					_tmp618_ = m;
					_tmp614_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp618_);
				}
				if (_tmp614_) {
					ValaHashMap* _tmp619_;
					ValaMethod* _tmp620_;
					ValaCCodeExpression* _tmp621_;
					ValaHashMap* _tmp622_;
					ValaMethod* _tmp623_;
					ValaCCodeExpression* _tmp624_;
					_tmp619_ = out_arg_map;
					_tmp620_ = m;
					_tmp621_ = instance;
					vala_map_set ((ValaMap*) _tmp619_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp620_), FALSE)), _tmp621_);
					_tmp622_ = in_arg_map;
					_tmp623_ = m;
					_tmp624_ = instance;
					vala_map_set ((ValaMap*) _tmp622_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp623_), FALSE)), _tmp624_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp625_ = FALSE;
			ValaMethod* _tmp626_;
			_tmp626_ = m;
			if (_tmp626_ != NULL) {
				ValaMethod* _tmp627_;
				ValaMemberBinding _tmp628_;
				ValaMemberBinding _tmp629_;
				_tmp627_ = m;
				_tmp628_ = vala_method_get_binding (_tmp627_);
				_tmp629_ = _tmp628_;
				_tmp625_ = _tmp629_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp625_ = FALSE;
			}
			if (_tmp625_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp630_;
				ValaSymbol* _tmp631_;
				ValaSymbol* _tmp632_;
				ValaClass* _tmp633_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp634_;
				gchar* _tmp635_;
				gchar* _tmp636_;
				gchar* _tmp637_;
				gchar* _tmp638_;
				ValaCCodeIdentifier* _tmp639_;
				ValaCCodeIdentifier* _tmp640_;
				ValaCCodeFunctionCall* _tmp641_;
				ValaCCodeFunctionCall* _tmp642_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp643_;
				ValaExpression* _tmp644_;
				ValaExpression* _tmp645_;
				ValaCCodeFunctionCall* _tmp671_;
				ValaCCodeExpression* _tmp672_;
				ValaHashMap* _tmp673_;
				ValaMethod* _tmp674_;
				ValaCCodeFunctionCall* _tmp675_;
				ValaHashMap* _tmp676_;
				ValaMethod* _tmp677_;
				ValaCCodeFunctionCall* _tmp678_;
				_tmp630_ = m;
				_tmp631_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp630_);
				_tmp632_ = _tmp631_;
				_tmp633_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp632_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp633_;
				_tmp634_ = cl;
				_tmp635_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp634_, NULL);
				_tmp636_ = _tmp635_;
				_tmp637_ = g_strconcat (_tmp636_, "_CLASS", NULL);
				_tmp638_ = _tmp637_;
				_tmp639_ = vala_ccode_identifier_new (_tmp638_);
				_tmp640_ = _tmp639_;
				_tmp641_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp640_);
				_tmp642_ = _tmp641_;
				_vala_ccode_node_unref0 (_tmp640_);
				_g_free0 (_tmp638_);
				_g_free0 (_tmp636_);
				cast = _tmp642_;
				_tmp643_ = ma;
				_tmp644_ = vala_member_access_get_inner (_tmp643_);
				_tmp645_ = _tmp644_;
				if (_tmp645_ == NULL) {
					ValaDataType* _tmp646_;
					ValaDataType* _tmp647_;
					gboolean _tmp648_;
					_tmp646_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp647_ = _tmp646_;
					_tmp648_ = _tmp647_ == NULL;
					_vala_code_node_unref0 (_tmp647_);
					if (_tmp648_) {
						ValaCCodeIdentifier* _tmp649_;
						_tmp649_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp649_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp650_;
						ValaCCodeIdentifier* _tmp651_;
						ValaCCodeFunctionCall* _tmp652_;
						ValaCCodeFunctionCall* _tmp653_;
						ValaCCodeFunctionCall* _tmp654_;
						ValaCCodeExpression* _tmp655_;
						ValaCCodeExpression* _tmp656_;
						ValaCCodeFunctionCall* _tmp657_;
						ValaCCodeExpression* _tmp658_;
						_tmp650_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp651_ = _tmp650_;
						_tmp652_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp651_);
						_tmp653_ = _tmp652_;
						_vala_ccode_node_unref0 (_tmp651_);
						k = _tmp653_;
						_tmp654_ = k;
						_tmp655_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp656_ = _tmp655_;
						vala_ccode_function_call_add_argument (_tmp654_, _tmp656_);
						_vala_ccode_node_unref0 (_tmp656_);
						_tmp657_ = k;
						_tmp658_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp657_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp658_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp659_;
					ValaCCodeIdentifier* _tmp660_;
					ValaCCodeFunctionCall* _tmp661_;
					ValaCCodeFunctionCall* _tmp662_;
					ValaCCodeFunctionCall* _tmp663_;
					ValaMemberAccess* _tmp664_;
					ValaExpression* _tmp665_;
					ValaExpression* _tmp666_;
					ValaCCodeExpression* _tmp667_;
					ValaCCodeExpression* _tmp668_;
					ValaCCodeFunctionCall* _tmp669_;
					ValaCCodeExpression* _tmp670_;
					_tmp659_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp660_ = _tmp659_;
					_tmp661_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp660_);
					_tmp662_ = _tmp661_;
					_vala_ccode_node_unref0 (_tmp660_);
					k = _tmp662_;
					_tmp663_ = k;
					_tmp664_ = ma;
					_tmp665_ = vala_member_access_get_inner (_tmp664_);
					_tmp666_ = _tmp665_;
					_tmp667_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp666_);
					_tmp668_ = _tmp667_;
					vala_ccode_function_call_add_argument (_tmp663_, _tmp668_);
					_vala_ccode_node_unref0 (_tmp668_);
					_tmp669_ = k;
					_tmp670_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp669_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp670_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp671_ = cast;
				_tmp672_ = klass;
				vala_ccode_function_call_add_argument (_tmp671_, _tmp672_);
				_tmp673_ = in_arg_map;
				_tmp674_ = m;
				_tmp675_ = cast;
				vala_map_set ((ValaMap*) _tmp673_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp674_), FALSE)), (ValaCCodeExpression*) _tmp675_);
				_tmp676_ = out_arg_map;
				_tmp677_ = m;
				_tmp678_ = cast;
				vala_map_set ((ValaMap*) _tmp676_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp677_), FALSE)), (ValaCCodeExpression*) _tmp678_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp680_ = m;
	if (_tmp680_ != NULL) {
		ValaMethod* _tmp681_;
		_tmp681_ = m;
		_tmp679_ = vala_get_ccode_has_generic_type_parameter (_tmp681_);
	} else {
		_tmp679_ = FALSE;
	}
	if (_tmp679_) {
		ValaMethod* _tmp682_;
		ValaList* _tmp683_;
		ValaList* _tmp684_;
		gint _tmp685_;
		gint _tmp686_;
		gboolean _tmp687_;
		_tmp682_ = m;
		_tmp683_ = vala_method_get_type_parameters (_tmp682_);
		_tmp684_ = _tmp683_;
		_tmp685_ = vala_collection_get_size ((ValaCollection*) _tmp684_);
		_tmp686_ = _tmp685_;
		_tmp687_ = _tmp686_ > 0;
		_vala_iterable_unref0 (_tmp684_);
		if (_tmp687_) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp688_;
				ValaList* _tmp689_;
				gint _type_arg_size = 0;
				ValaList* _tmp690_;
				gint _tmp691_;
				gint _tmp692_;
				gint _type_arg_index = 0;
				_tmp688_ = ma;
				_tmp689_ = vala_member_access_get_type_arguments (_tmp688_);
				_type_arg_list = _tmp689_;
				_tmp690_ = _type_arg_list;
				_tmp691_ = vala_collection_get_size ((ValaCollection*) _tmp690_);
				_tmp692_ = _tmp691_;
				_type_arg_size = _tmp692_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp693_;
					gint _tmp694_;
					gint _tmp695_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp696_;
					gint _tmp697_;
					gpointer _tmp698_;
					ValaHashMap* _tmp699_;
					ValaMethod* _tmp700_;
					gint _tmp701_;
					ValaDataType* _tmp702_;
					gchar* _tmp703_;
					gchar* _tmp704_;
					ValaCCodeIdentifier* _tmp705_;
					ValaCCodeIdentifier* _tmp706_;
					gint _tmp707_;
					_tmp693_ = _type_arg_index;
					_type_arg_index = _tmp693_ + 1;
					_tmp694_ = _type_arg_index;
					_tmp695_ = _type_arg_size;
					if (!(_tmp694_ < _tmp695_)) {
						break;
					}
					_tmp696_ = _type_arg_list;
					_tmp697_ = _type_arg_index;
					_tmp698_ = vala_list_get (_tmp696_, _tmp697_);
					type_arg = (ValaDataType*) _tmp698_;
					_tmp699_ = in_arg_map;
					_tmp700_ = m;
					_tmp701_ = type_param_index;
					_tmp702_ = type_arg;
					_tmp703_ = vala_get_ccode_name ((ValaCodeNode*) _tmp702_);
					_tmp704_ = _tmp703_;
					_tmp705_ = vala_ccode_identifier_new (_tmp704_);
					_tmp706_ = _tmp705_;
					vala_map_set ((ValaMap*) _tmp699_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp700_) + (0.01 * _tmp701_), FALSE)), (ValaCCodeExpression*) _tmp706_);
					_vala_ccode_node_unref0 (_tmp706_);
					_g_free0 (_tmp704_);
					_tmp707_ = type_param_index;
					type_param_index = _tmp707_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp708_;
				ValaExpression* _tmp709_;
				ValaExpression* _tmp710_;
				ValaDataType* _tmp711_;
				ValaDataType* _tmp712_;
				ValaList* _tmp713_;
				gint _type_arg_size = 0;
				ValaList* _tmp714_;
				gint _tmp715_;
				gint _tmp716_;
				gint _type_arg_index = 0;
				_tmp708_ = ma;
				_tmp709_ = vala_member_access_get_inner (_tmp708_);
				_tmp710_ = _tmp709_;
				_tmp711_ = vala_expression_get_value_type (_tmp710_);
				_tmp712_ = _tmp711_;
				_tmp713_ = vala_data_type_get_type_arguments (_tmp712_);
				_type_arg_list = _tmp713_;
				_tmp714_ = _type_arg_list;
				_tmp715_ = vala_collection_get_size ((ValaCollection*) _tmp714_);
				_tmp716_ = _tmp715_;
				_type_arg_size = _tmp716_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp717_;
					gint _tmp718_;
					gint _tmp719_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp720_;
					gint _tmp721_;
					gpointer _tmp722_;
					ValaHashMap* _tmp723_;
					ValaMethod* _tmp724_;
					gint _tmp725_;
					ValaDataType* _tmp726_;
					gchar* _tmp727_;
					gchar* _tmp728_;
					ValaCCodeIdentifier* _tmp729_;
					ValaCCodeIdentifier* _tmp730_;
					gint _tmp731_;
					_tmp717_ = _type_arg_index;
					_type_arg_index = _tmp717_ + 1;
					_tmp718_ = _type_arg_index;
					_tmp719_ = _type_arg_size;
					if (!(_tmp718_ < _tmp719_)) {
						break;
					}
					_tmp720_ = _type_arg_list;
					_tmp721_ = _type_arg_index;
					_tmp722_ = vala_list_get (_tmp720_, _tmp721_);
					type_arg = (ValaDataType*) _tmp722_;
					_tmp723_ = in_arg_map;
					_tmp724_ = m;
					_tmp725_ = type_param_index;
					_tmp726_ = type_arg;
					_tmp727_ = vala_get_ccode_name ((ValaCodeNode*) _tmp726_);
					_tmp728_ = _tmp727_;
					_tmp729_ = vala_ccode_identifier_new (_tmp728_);
					_tmp730_ = _tmp729_;
					vala_map_set ((ValaMap*) _tmp723_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp724_) + (0.01 * _tmp725_), FALSE)), (ValaCCodeExpression*) _tmp730_);
					_vala_ccode_node_unref0 (_tmp730_);
					_g_free0 (_tmp728_);
					_tmp731_ = type_param_index;
					type_param_index = _tmp731_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp732_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp732_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp733_;
		ValaExpression* _tmp734_;
		ValaExpression* _tmp735_;
		ValaDataType* _tmp736_;
		ValaDataType* _tmp737_;
		ValaArrayType* _tmp738_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp739_;
		ValaCCodeIdentifier* _tmp740_;
		ValaCCodeFunctionCall* _tmp741_;
		ValaCCodeFunctionCall* _tmp742_;
		ValaCCodeFunctionCall* _tmp743_;
		ValaArrayType* _tmp744_;
		ValaDataType* _tmp745_;
		ValaDataType* _tmp746_;
		gchar* _tmp747_;
		gchar* _tmp748_;
		ValaCCodeIdentifier* _tmp749_;
		ValaCCodeIdentifier* _tmp750_;
		ValaHashMap* _tmp751_;
		ValaCCodeFunctionCall* _tmp752_;
		_tmp733_ = ma;
		_tmp734_ = vala_member_access_get_inner (_tmp733_);
		_tmp735_ = _tmp734_;
		_tmp736_ = vala_expression_get_value_type (_tmp735_);
		_tmp737_ = _tmp736_;
		_tmp738_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp737_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp738_;
		_tmp739_ = vala_ccode_identifier_new ("sizeof");
		_tmp740_ = _tmp739_;
		_tmp741_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp740_);
		_tmp742_ = _tmp741_;
		_vala_ccode_node_unref0 (_tmp740_);
		csizeof = _tmp742_;
		_tmp743_ = csizeof;
		_tmp744_ = array_type;
		_tmp745_ = vala_array_type_get_element_type (_tmp744_);
		_tmp746_ = _tmp745_;
		_tmp747_ = vala_get_ccode_name ((ValaCodeNode*) _tmp746_);
		_tmp748_ = _tmp747_;
		_tmp749_ = vala_ccode_identifier_new (_tmp748_);
		_tmp750_ = _tmp749_;
		vala_ccode_function_call_add_argument (_tmp743_, (ValaCCodeExpression*) _tmp750_);
		_vala_ccode_node_unref0 (_tmp750_);
		_g_free0 (_tmp748_);
		_tmp751_ = in_arg_map;
		_tmp752_ = csizeof;
		vala_map_set ((ValaMap*) _tmp751_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp752_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp753_;
		_tmp753_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp753_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaMethod* _tmp754_;
			gint param_nr = 0;
			ValaMethod* _tmp825_;
			_tmp754_ = m;
			vala_method_clear_parameters (_tmp754_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp755_;
				gint _arg_size = 0;
				ValaList* _tmp756_;
				gint _tmp757_;
				gint _tmp758_;
				gint _arg_index = 0;
				_tmp755_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp755_;
				_tmp756_ = _arg_list;
				_tmp757_ = vala_collection_get_size ((ValaCollection*) _tmp756_);
				_tmp758_ = _tmp757_;
				_arg_size = _tmp758_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp759_;
					gint _tmp760_;
					gint _tmp761_;
					ValaExpression* arg = NULL;
					ValaList* _tmp762_;
					gint _tmp763_;
					gpointer _tmp764_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp765_;
					ValaUnaryExpression* _tmp766_;
					gboolean _tmp767_ = FALSE;
					ValaUnaryExpression* _tmp768_;
					gint _tmp812_;
					_tmp759_ = _arg_index;
					_arg_index = _tmp759_ + 1;
					_tmp760_ = _arg_index;
					_tmp761_ = _arg_size;
					if (!(_tmp760_ < _tmp761_)) {
						break;
					}
					_tmp762_ = _arg_list;
					_tmp763_ = _arg_index;
					_tmp764_ = vala_list_get (_tmp762_, _tmp763_);
					arg = (ValaExpression*) _tmp764_;
					_tmp765_ = arg;
					_tmp766_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp765_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp765_) : NULL);
					unary = _tmp766_;
					_tmp768_ = unary;
					if (_tmp768_ != NULL) {
						ValaUnaryExpression* _tmp769_;
						ValaUnaryOperator _tmp770_;
						ValaUnaryOperator _tmp771_;
						_tmp769_ = unary;
						_tmp770_ = vala_unary_expression_get_operator (_tmp769_);
						_tmp771_ = _tmp770_;
						_tmp767_ = _tmp771_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp767_ = FALSE;
					}
					if (_tmp767_) {
						ValaParameter* param = NULL;
						gint _tmp772_;
						gchar* _tmp773_;
						gchar* _tmp774_;
						ValaUnaryExpression* _tmp775_;
						ValaExpression* _tmp776_;
						ValaExpression* _tmp777_;
						ValaDataType* _tmp778_;
						ValaDataType* _tmp779_;
						ValaParameter* _tmp780_;
						ValaParameter* _tmp781_;
						ValaParameter* _tmp782_;
						ValaMethod* _tmp783_;
						ValaParameter* _tmp784_;
						_tmp772_ = param_nr;
						_tmp773_ = g_strdup_printf ("param%d", _tmp772_);
						_tmp774_ = _tmp773_;
						_tmp775_ = unary;
						_tmp776_ = vala_unary_expression_get_inner (_tmp775_);
						_tmp777_ = _tmp776_;
						_tmp778_ = vala_expression_get_value_type (_tmp777_);
						_tmp779_ = _tmp778_;
						_tmp780_ = vala_parameter_new (_tmp774_, _tmp779_, NULL);
						_tmp781_ = _tmp780_;
						_g_free0 (_tmp774_);
						param = _tmp781_;
						_tmp782_ = param;
						vala_parameter_set_direction (_tmp782_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp783_ = m;
						_tmp784_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp783_, _tmp784_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp785_ = FALSE;
						ValaUnaryExpression* _tmp786_;
						_tmp786_ = unary;
						if (_tmp786_ != NULL) {
							ValaUnaryExpression* _tmp787_;
							ValaUnaryOperator _tmp788_;
							ValaUnaryOperator _tmp789_;
							_tmp787_ = unary;
							_tmp788_ = vala_unary_expression_get_operator (_tmp787_);
							_tmp789_ = _tmp788_;
							_tmp785_ = _tmp789_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp785_ = FALSE;
						}
						if (_tmp785_) {
							ValaParameter* param = NULL;
							gint _tmp790_;
							gchar* _tmp791_;
							gchar* _tmp792_;
							ValaUnaryExpression* _tmp793_;
							ValaExpression* _tmp794_;
							ValaExpression* _tmp795_;
							ValaDataType* _tmp796_;
							ValaDataType* _tmp797_;
							ValaParameter* _tmp798_;
							ValaParameter* _tmp799_;
							ValaParameter* _tmp800_;
							ValaMethod* _tmp801_;
							ValaParameter* _tmp802_;
							_tmp790_ = param_nr;
							_tmp791_ = g_strdup_printf ("param%d", _tmp790_);
							_tmp792_ = _tmp791_;
							_tmp793_ = unary;
							_tmp794_ = vala_unary_expression_get_inner (_tmp793_);
							_tmp795_ = _tmp794_;
							_tmp796_ = vala_expression_get_value_type (_tmp795_);
							_tmp797_ = _tmp796_;
							_tmp798_ = vala_parameter_new (_tmp792_, _tmp797_, NULL);
							_tmp799_ = _tmp798_;
							_g_free0 (_tmp792_);
							param = _tmp799_;
							_tmp800_ = param;
							vala_parameter_set_direction (_tmp800_, VALA_PARAMETER_DIRECTION_REF);
							_tmp801_ = m;
							_tmp802_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp801_, _tmp802_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp803_;
							gint _tmp804_;
							gchar* _tmp805_;
							gchar* _tmp806_;
							ValaExpression* _tmp807_;
							ValaDataType* _tmp808_;
							ValaDataType* _tmp809_;
							ValaParameter* _tmp810_;
							ValaParameter* _tmp811_;
							_tmp803_ = m;
							_tmp804_ = param_nr;
							_tmp805_ = g_strdup_printf ("param%d", _tmp804_);
							_tmp806_ = _tmp805_;
							_tmp807_ = arg;
							_tmp808_ = vala_expression_get_value_type (_tmp807_);
							_tmp809_ = _tmp808_;
							_tmp810_ = vala_parameter_new (_tmp806_, _tmp809_, NULL);
							_tmp811_ = _tmp810_;
							vala_callable_add_parameter ((ValaCallable*) _tmp803_, _tmp811_);
							_vala_code_node_unref0 (_tmp811_);
							_g_free0 (_tmp806_);
						}
					}
					_tmp812_ = param_nr;
					param_nr = _tmp812_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp813_;
				ValaList* _tmp814_;
				gint _param_size = 0;
				ValaList* _tmp815_;
				gint _tmp816_;
				gint _tmp817_;
				gint _param_index = 0;
				_tmp813_ = m;
				_tmp814_ = vala_callable_get_parameters ((ValaCallable*) _tmp813_);
				_param_list = _tmp814_;
				_tmp815_ = _param_list;
				_tmp816_ = vala_collection_get_size ((ValaCollection*) _tmp815_);
				_tmp817_ = _tmp816_;
				_param_size = _tmp817_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp818_;
					gint _tmp819_;
					gint _tmp820_;
					ValaParameter* param = NULL;
					ValaList* _tmp821_;
					gint _tmp822_;
					gpointer _tmp823_;
					ValaParameter* _tmp824_;
					_tmp818_ = _param_index;
					_param_index = _tmp818_ + 1;
					_tmp819_ = _param_index;
					_tmp820_ = _param_size;
					if (!(_tmp819_ < _tmp820_)) {
						break;
					}
					_tmp821_ = _param_list;
					_tmp822_ = _param_index;
					_tmp823_ = vala_list_get (_tmp821_, _tmp822_);
					param = (ValaParameter*) _tmp823_;
					_tmp824_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp824_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp825_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp825_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
		} else {
			gboolean _tmp826_ = FALSE;
			gboolean _tmp827_ = FALSE;
			ValaMethod* _tmp828_;
			_tmp828_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp828_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp829_;
				ValaCodeContext* _tmp830_;
				ValaProfile _tmp831_;
				ValaProfile _tmp832_;
				_tmp829_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp830_ = _tmp829_;
				_tmp831_ = vala_code_context_get_profile (_tmp830_);
				_tmp832_ = _tmp831_;
				_tmp827_ = _tmp832_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp827_ = FALSE;
			}
			if (_tmp827_) {
				ValaMethod* _tmp833_;
				ValaSymbol* _tmp834_;
				ValaSymbol* _tmp835_;
				_tmp833_ = m;
				_tmp834_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp833_);
				_tmp835_ = _tmp834_;
				_tmp826_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp835_, VALA_TYPE_CLASS);
			} else {
				_tmp826_ = FALSE;
			}
			if (_tmp826_) {
				ValaCCodeFunction* _tmp836_;
				ValaCCodeFunction* _tmp837_;
				ValaCCodeExpression* _tmp838_;
				ValaCCodeExpression* _tmp839_;
				ValaCCodeFunctionCall* _tmp840_;
				ValaClass* _tmp841_;
				ValaClass* _tmp842_;
				gchar* _tmp843_;
				gchar* _tmp844_;
				gchar* _tmp845_;
				gchar* _tmp846_;
				ValaCCodeCastExpression* _tmp847_;
				ValaCCodeCastExpression* _tmp848_;
				ValaMethod* _tmp849_;
				ValaMethod* _tmp850_;
				ValaBlock* _tmp851_;
				ValaBlock* _tmp852_;
				gboolean _tmp853_;
				gboolean _tmp854_;
				gboolean _tmp881_ = FALSE;
				ValaClass* _tmp882_;
				ValaClass* _tmp883_;
				gboolean _tmp884_;
				gboolean _tmp885_;
				_tmp836_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp837_ = _tmp836_;
				_tmp838_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp839_ = _tmp838_;
				_tmp840_ = ccall;
				_tmp841_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp842_ = _tmp841_;
				_tmp843_ = vala_get_ccode_name ((ValaCodeNode*) _tmp842_);
				_tmp844_ = _tmp843_;
				_tmp845_ = g_strconcat (_tmp844_, "*", NULL);
				_tmp846_ = _tmp845_;
				_tmp847_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp840_, _tmp846_);
				_tmp848_ = _tmp847_;
				vala_ccode_function_add_assignment (_tmp837_, _tmp839_, (ValaCCodeExpression*) _tmp848_);
				_vala_ccode_node_unref0 (_tmp848_);
				_g_free0 (_tmp846_);
				_g_free0 (_tmp844_);
				_vala_ccode_node_unref0 (_tmp839_);
				_tmp849_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp850_ = _tmp849_;
				_tmp851_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp850_);
				_tmp852_ = _tmp851_;
				_tmp853_ = vala_block_get_captured (_tmp852_);
				_tmp854_ = _tmp853_;
				if (_tmp854_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp855_;
					ValaClass* _tmp856_;
					ValaObjectType* _tmp857_;
					ValaObjectType* _tmp858_;
					ValaSourceReference* _tmp859_;
					ValaSourceReference* _tmp860_;
					ValaCCodeExpression* _tmp861_;
					ValaCCodeExpression* _tmp862_;
					ValaCCodeFunctionCall* _tmp863_;
					ValaCCodeFunctionCall* _tmp864_;
					ValaCCodeFunctionCall* _tmp865_;
					ValaCCodeExpression* _tmp866_;
					ValaCCodeExpression* _tmp867_;
					ValaCCodeFunction* _tmp868_;
					ValaCCodeFunction* _tmp869_;
					ValaMethod* _tmp870_;
					ValaMethod* _tmp871_;
					ValaBlock* _tmp872_;
					ValaBlock* _tmp873_;
					gchar* _tmp874_;
					gchar* _tmp875_;
					ValaCCodeExpression* _tmp876_;
					ValaCCodeExpression* _tmp877_;
					ValaCCodeMemberAccess* _tmp878_;
					ValaCCodeMemberAccess* _tmp879_;
					ValaCCodeFunctionCall* _tmp880_;
					_tmp855_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp856_ = _tmp855_;
					_tmp857_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp856_);
					_tmp858_ = _tmp857_;
					_tmp859_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp860_ = _tmp859_;
					_tmp861_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp858_, _tmp860_, FALSE);
					_tmp862_ = _tmp861_;
					_tmp863_ = vala_ccode_function_call_new (_tmp862_);
					_tmp864_ = _tmp863_;
					_vala_ccode_node_unref0 (_tmp862_);
					_vala_code_node_unref0 (_tmp858_);
					ref_call = _tmp864_;
					_tmp865_ = ref_call;
					_tmp866_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp867_ = _tmp866_;
					vala_ccode_function_call_add_argument (_tmp865_, _tmp867_);
					_vala_ccode_node_unref0 (_tmp867_);
					_tmp868_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp869_ = _tmp868_;
					_tmp870_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp871_ = _tmp870_;
					_tmp872_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp871_);
					_tmp873_ = _tmp872_;
					_tmp874_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp873_));
					_tmp875_ = _tmp874_;
					_tmp876_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp875_);
					_tmp877_ = _tmp876_;
					_tmp878_ = vala_ccode_member_access_new_pointer (_tmp877_, "self");
					_tmp879_ = _tmp878_;
					_tmp880_ = ref_call;
					vala_ccode_function_add_assignment (_tmp869_, (ValaCCodeExpression*) _tmp879_, (ValaCCodeExpression*) _tmp880_);
					_vala_ccode_node_unref0 (_tmp879_);
					_vala_ccode_node_unref0 (_tmp877_);
					_g_free0 (_tmp875_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp882_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp883_ = _tmp882_;
				_tmp884_ = vala_class_get_is_compact (_tmp883_);
				_tmp885_ = _tmp884_;
				if (!_tmp885_) {
					ValaClass* _tmp886_;
					ValaClass* _tmp887_;
					ValaList* _tmp888_;
					ValaList* _tmp889_;
					gint _tmp890_;
					gint _tmp891_;
					_tmp886_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp887_ = _tmp886_;
					_tmp888_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp887_);
					_tmp889_ = _tmp888_;
					_tmp890_ = vala_collection_get_size ((ValaCollection*) _tmp889_);
					_tmp891_ = _tmp890_;
					_tmp881_ = _tmp891_ > 0;
					_vala_iterable_unref0 (_tmp889_);
				} else {
					_tmp881_ = FALSE;
				}
				if (_tmp881_) {
					gchar** suffices = NULL;
					gchar* _tmp892_;
					gchar* _tmp893_;
					gchar* _tmp894_;
					gchar** _tmp895_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp892_ = g_strdup ("type");
					_tmp893_ = g_strdup ("dup_func");
					_tmp894_ = g_strdup ("destroy_func");
					_tmp895_ = g_new0 (gchar*, 3 + 1);
					_tmp895_[0] = _tmp892_;
					_tmp895_[1] = _tmp893_;
					_tmp895_[2] = _tmp894_;
					suffices = _tmp895_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp896_;
						ValaClass* _tmp897_;
						ValaList* _tmp898_;
						gint _type_param_size = 0;
						ValaList* _tmp899_;
						gint _tmp900_;
						gint _tmp901_;
						gint _type_param_index = 0;
						_tmp896_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp897_ = _tmp896_;
						_tmp898_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp897_);
						_type_param_list = _tmp898_;
						_tmp899_ = _type_param_list;
						_tmp900_ = vala_collection_get_size ((ValaCollection*) _tmp899_);
						_tmp901_ = _tmp900_;
						_type_param_size = _tmp901_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp902_;
							gint _tmp903_;
							gint _tmp904_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp905_;
							gint _tmp906_;
							gpointer _tmp907_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp908_;
							ValaCCodeIdentifier* _tmp909_;
							ValaCCodeMemberAccess* _tmp910_;
							ValaCCodeMemberAccess* _tmp911_;
							gchar** _tmp912_;
							gint _tmp912__length1;
							_tmp902_ = _type_param_index;
							_type_param_index = _tmp902_ + 1;
							_tmp903_ = _type_param_index;
							_tmp904_ = _type_param_size;
							if (!(_tmp903_ < _tmp904_)) {
								break;
							}
							_tmp905_ = _type_param_list;
							_tmp906_ = _type_param_index;
							_tmp907_ = vala_list_get (_tmp905_, _tmp906_);
							type_param = (ValaTypeParameter*) _tmp907_;
							_tmp908_ = vala_ccode_identifier_new ("self");
							_tmp909_ = _tmp908_;
							_tmp910_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp909_, "priv");
							_tmp911_ = _tmp910_;
							_vala_ccode_node_unref0 (_tmp909_);
							priv_access = _tmp911_;
							_tmp912_ = suffices;
							_tmp912__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp912_;
								suffix_collection_length1 = _tmp912__length1;
								for (suffix_it = 0; suffix_it < _tmp912__length1; suffix_it = suffix_it + 1) {
									gchar* _tmp913_;
									gchar* suffix = NULL;
									_tmp913_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp913_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp914_;
										const gchar* _tmp915_;
										const gchar* _tmp916_;
										gchar* _tmp917_;
										gchar* _tmp918_;
										const gchar* _tmp919_;
										gchar* _tmp920_;
										gchar* _tmp921_;
										ValaCCodeIdentifier* _tmp922_;
										ValaCCodeIdentifier* _tmp923_;
										ValaCCodeFunction* _tmp924_;
										ValaCCodeFunction* _tmp925_;
										ValaCCodeMemberAccess* _tmp926_;
										ValaCCodeIdentifier* _tmp927_;
										const gchar* _tmp928_;
										const gchar* _tmp929_;
										ValaCCodeMemberAccess* _tmp930_;
										ValaCCodeMemberAccess* _tmp931_;
										ValaCCodeIdentifier* _tmp932_;
										_tmp914_ = type_param;
										_tmp915_ = vala_symbol_get_name ((ValaSymbol*) _tmp914_);
										_tmp916_ = _tmp915_;
										_tmp917_ = g_utf8_strdown (_tmp916_, (gssize) -1);
										_tmp918_ = _tmp917_;
										_tmp919_ = suffix;
										_tmp920_ = g_strdup_printf ("%s_%s", _tmp918_, _tmp919_);
										_tmp921_ = _tmp920_;
										_tmp922_ = vala_ccode_identifier_new (_tmp921_);
										_tmp923_ = _tmp922_;
										_g_free0 (_tmp921_);
										_g_free0 (_tmp918_);
										param_name = _tmp923_;
										_tmp924_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp925_ = _tmp924_;
										_tmp926_ = priv_access;
										_tmp927_ = param_name;
										_tmp928_ = vala_ccode_identifier_get_name (_tmp927_);
										_tmp929_ = _tmp928_;
										_tmp930_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp926_, _tmp929_);
										_tmp931_ = _tmp930_;
										_tmp932_ = param_name;
										vala_ccode_function_add_assignment (_tmp925_, (ValaCCodeExpression*) _tmp931_, (ValaCCodeExpression*) _tmp932_);
										_vala_ccode_node_unref0 (_tmp931_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp933_ = params;
	_tmp934_ = vala_iterable_iterator ((ValaIterable*) _tmp933_);
	params_it = _tmp934_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp935_;
		gint _arg_size = 0;
		ValaList* _tmp936_;
		gint _tmp937_;
		gint _tmp938_;
		gint _arg_index = 0;
		_tmp935_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp935_;
		_tmp936_ = _arg_list;
		_tmp937_ = vala_collection_get_size ((ValaCollection*) _tmp936_);
		_tmp938_ = _tmp937_;
		_arg_size = _tmp938_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp939_;
			gint _tmp940_;
			gint _tmp941_;
			ValaExpression* arg = NULL;
			ValaList* _tmp942_;
			gint _tmp943_;
			gpointer _tmp944_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp945_;
			ValaCCodeExpression* _tmp946_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp947_;
			ValaHashMap* _tmp948_;
			ValaIterator* _tmp949_;
			ValaHashMap* _tmp1265_;
			gint _tmp1266_;
			ValaCCodeExpression* _tmp1267_;
			gboolean _tmp1268_ = FALSE;
			ValaExpression* _tmp1269_;
			gint _tmp1289_;
			_tmp939_ = _arg_index;
			_arg_index = _tmp939_ + 1;
			_tmp940_ = _arg_index;
			_tmp941_ = _arg_size;
			if (!(_tmp940_ < _tmp941_)) {
				break;
			}
			_tmp942_ = _arg_list;
			_tmp943_ = _arg_index;
			_tmp944_ = vala_list_get (_tmp942_, _tmp943_);
			arg = (ValaExpression*) _tmp944_;
			_tmp945_ = arg;
			_tmp946_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp945_);
			cexpr = _tmp946_;
			_tmp947_ = in_arg_map;
			_tmp948_ = _vala_map_ref0 (_tmp947_);
			carg_map = _tmp948_;
			_tmp949_ = params_it;
			if (vala_iterator_next (_tmp949_)) {
				ValaParameter* param = NULL;
				ValaIterator* _tmp950_;
				gpointer _tmp951_;
				gboolean _tmp952_ = FALSE;
				ValaParameter* _tmp953_;
				gboolean _tmp954_;
				gboolean _tmp955_;
				gboolean _tmp959_;
				ValaParameter* _tmp1258_;
				gboolean _tmp1259_;
				_tmp950_ = params_it;
				_tmp951_ = vala_iterator_get (_tmp950_);
				param = (ValaParameter*) _tmp951_;
				_tmp953_ = param;
				_tmp954_ = vala_parameter_get_params_array (_tmp953_);
				_tmp955_ = _tmp954_;
				if (_tmp955_) {
					_tmp952_ = TRUE;
				} else {
					ValaParameter* _tmp956_;
					gboolean _tmp957_;
					gboolean _tmp958_;
					_tmp956_ = param;
					_tmp957_ = vala_parameter_get_ellipsis (_tmp956_);
					_tmp958_ = _tmp957_;
					_tmp952_ = _tmp958_;
				}
				ellipsis = _tmp952_;
				_tmp959_ = ellipsis;
				if (!_tmp959_) {
					ValaParameter* _tmp960_;
					ValaParameterDirection _tmp961_;
					ValaParameterDirection _tmp962_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp965_;
					ValaUnaryExpression* _tmp966_;
					gboolean _tmp967_ = FALSE;
					ValaUnaryExpression* _tmp968_;
					ValaParameter* _tmp1246_;
					gchar* _tmp1247_;
					gchar* _tmp1248_;
					gboolean _tmp1249_;
					_tmp960_ = param;
					_tmp961_ = vala_parameter_get_direction (_tmp960_);
					_tmp962_ = _tmp961_;
					if (_tmp962_ == VALA_PARAMETER_DIRECTION_OUT) {
						ValaHashMap* _tmp963_;
						ValaHashMap* _tmp964_;
						_tmp963_ = out_arg_map;
						_tmp964_ = _vala_map_ref0 (_tmp963_);
						_vala_map_unref0 (carg_map);
						carg_map = _tmp964_;
					}
					_tmp965_ = arg;
					_tmp966_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp965_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp965_) : NULL);
					unary = _tmp966_;
					_tmp968_ = unary;
					if (_tmp968_ == NULL) {
						_tmp967_ = TRUE;
					} else {
						ValaUnaryExpression* _tmp969_;
						ValaUnaryOperator _tmp970_;
						ValaUnaryOperator _tmp971_;
						_tmp969_ = unary;
						_tmp970_ = vala_unary_expression_get_operator (_tmp969_);
						_tmp971_ = _tmp970_;
						_tmp967_ = _tmp971_ != VALA_UNARY_OPERATOR_OUT;
					}
					if (_tmp967_) {
						gboolean _tmp972_ = FALSE;
						gboolean _tmp973_ = FALSE;
						ValaParameter* _tmp974_;
						ValaParameter* _tmp1116_;
						ValaExpression* _tmp1117_;
						ValaCCodeExpression* _tmp1118_;
						ValaCCodeExpression* _tmp1119_;
						_tmp974_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp974_)) {
							ValaParameter* _tmp975_;
							ValaDataType* _tmp976_;
							ValaDataType* _tmp977_;
							_tmp975_ = param;
							_tmp976_ = vala_variable_get_variable_type ((ValaVariable*) _tmp975_);
							_tmp977_ = _tmp976_;
							_tmp973_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp977_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp973_ = FALSE;
						}
						if (_tmp973_) {
							ValaParameter* _tmp978_;
							ValaDataType* _tmp979_;
							ValaDataType* _tmp980_;
							gboolean _tmp981_;
							gboolean _tmp982_;
							_tmp978_ = param;
							_tmp979_ = vala_variable_get_variable_type ((ValaVariable*) _tmp978_);
							_tmp980_ = _tmp979_;
							_tmp981_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp980_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp982_ = _tmp981_;
							_tmp972_ = !_tmp982_;
						} else {
							_tmp972_ = FALSE;
						}
						if (_tmp972_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp983_;
							ValaDataType* _tmp984_;
							ValaDataType* _tmp985_;
							ValaArrayType* _tmp986_;
							_tmp983_ = param;
							_tmp984_ = vala_variable_get_variable_type ((ValaVariable*) _tmp983_);
							_tmp985_ = _tmp984_;
							_tmp986_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp985_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp986_;
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp987_ = FALSE;
									_tmp987_ = TRUE;
									while (TRUE) {
										gint _tmp989_;
										ValaArrayType* _tmp990_;
										gint _tmp991_;
										gint _tmp992_;
										ValaCCodeExpression* array_length_expr = NULL;
										ValaParameter* _tmp993_;
										gchar* _tmp994_;
										gchar* _tmp995_;
										gboolean _tmp996_;
										ValaHashMap* _tmp1015_;
										ValaParameter* _tmp1016_;
										gint _tmp1017_;
										ValaCCodeExpression* _tmp1018_;
										if (!_tmp987_) {
											gint _tmp988_;
											_tmp988_ = dim;
											dim = _tmp988_ + 1;
										}
										_tmp987_ = FALSE;
										_tmp989_ = dim;
										_tmp990_ = array_type;
										_tmp991_ = vala_array_type_get_rank (_tmp990_);
										_tmp992_ = _tmp991_;
										if (!(_tmp989_ <= _tmp992_)) {
											break;
										}
										array_length_expr = NULL;
										_tmp993_ = param;
										_tmp994_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp993_);
										_tmp995_ = _tmp994_;
										_tmp996_ = _tmp995_ != NULL;
										_g_free0 (_tmp995_);
										if (_tmp996_) {
											gchar* length_ctype = NULL;
											ValaParameter* _tmp997_;
											gchar* _tmp998_;
											gboolean _tmp999_ = FALSE;
											ValaUnaryExpression* _tmp1000_;
											ValaExpression* _tmp1006_;
											gint _tmp1007_;
											ValaCCodeExpression* _tmp1008_;
											ValaCCodeExpression* _tmp1009_;
											const gchar* _tmp1010_;
											ValaCCodeCastExpression* _tmp1011_;
											_tmp997_ = param;
											_tmp998_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp997_);
											length_ctype = _tmp998_;
											_tmp1000_ = unary;
											if (_tmp1000_ != NULL) {
												ValaUnaryExpression* _tmp1001_;
												ValaUnaryOperator _tmp1002_;
												ValaUnaryOperator _tmp1003_;
												_tmp1001_ = unary;
												_tmp1002_ = vala_unary_expression_get_operator (_tmp1001_);
												_tmp1003_ = _tmp1002_;
												_tmp999_ = _tmp1003_ == VALA_UNARY_OPERATOR_REF;
											} else {
												_tmp999_ = FALSE;
											}
											if (_tmp999_) {
												const gchar* _tmp1004_;
												gchar* _tmp1005_;
												_tmp1004_ = length_ctype;
												_tmp1005_ = g_strdup_printf ("%s*", _tmp1004_);
												_g_free0 (length_ctype);
												length_ctype = _tmp1005_;
											}
											_tmp1006_ = arg;
											_tmp1007_ = dim;
											_tmp1008_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1006_, _tmp1007_);
											_tmp1009_ = _tmp1008_;
											_tmp1010_ = length_ctype;
											_tmp1011_ = vala_ccode_cast_expression_new (_tmp1009_, _tmp1010_);
											_vala_ccode_node_unref0 (array_length_expr);
											array_length_expr = (ValaCCodeExpression*) _tmp1011_;
											_vala_ccode_node_unref0 (_tmp1009_);
											_g_free0 (length_ctype);
										} else {
											ValaExpression* _tmp1012_;
											gint _tmp1013_;
											ValaCCodeExpression* _tmp1014_;
											_tmp1012_ = arg;
											_tmp1013_ = dim;
											_tmp1014_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1012_, _tmp1013_);
											_vala_ccode_node_unref0 (array_length_expr);
											array_length_expr = _tmp1014_;
										}
										_tmp1015_ = carg_map;
										_tmp1016_ = param;
										_tmp1017_ = dim;
										_tmp1018_ = array_length_expr;
										vala_map_set ((ValaMap*) _tmp1015_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1016_) + (0.01 * _tmp1017_), FALSE)), _tmp1018_);
										_vala_ccode_node_unref0 (array_length_expr);
									}
								}
							}
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp1019_;
							ValaDataType* _tmp1020_;
							ValaDataType* _tmp1021_;
							_tmp1019_ = param;
							_tmp1020_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1019_);
							_tmp1021_ = _tmp1020_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1021_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp1022_;
								ValaDataType* _tmp1023_;
								ValaDataType* _tmp1024_;
								ValaDelegateType* _tmp1025_;
								ValaDelegateType* _tmp1026_;
								ValaDelegate* _tmp1027_;
								ValaDelegate* _tmp1028_;
								gboolean _tmp1029_;
								gboolean _tmp1030_;
								_tmp1022_ = param;
								_tmp1023_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1022_);
								_tmp1024_ = _tmp1023_;
								_tmp1025_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1024_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp1025_;
								_tmp1026_ = deleg_type;
								_tmp1027_ = vala_delegate_type_get_delegate_symbol (_tmp1026_);
								_tmp1028_ = _tmp1027_;
								_tmp1029_ = vala_delegate_get_has_target (_tmp1028_);
								_tmp1030_ = _tmp1029_;
								if (_tmp1030_) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaCCodeExpression* delegate_target = NULL;
									ValaExpression* _tmp1031_;
									ValaCCodeExpression* _tmp1032_ = NULL;
									ValaCCodeExpression* _tmp1033_;
									ValaCCodeExpression* _tmp1034_;
									ValaParameter* _tmp1035_;
									gchar* _tmp1036_;
									gchar* _tmp1037_;
									gboolean _tmp1038_;
									_tmp1031_ = arg;
									_tmp1033_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1031_, &_tmp1032_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp1032_;
									delegate_target = _tmp1033_;
									_tmp1034_ = delegate_target;
									_vala_assert (_tmp1034_ != NULL, "delegate_target != null");
									_tmp1035_ = param;
									_tmp1036_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1035_);
									_tmp1037_ = _tmp1036_;
									_tmp1038_ = g_strcmp0 (_tmp1037_, "GClosure*") == 0;
									_g_free0 (_tmp1037_);
									if (_tmp1038_) {
										ValaCCodeFunctionCall* closure_new = NULL;
										ValaCCodeIdentifier* _tmp1039_;
										ValaCCodeIdentifier* _tmp1040_;
										ValaCCodeFunctionCall* _tmp1041_;
										ValaCCodeFunctionCall* _tmp1042_;
										ValaCCodeFunctionCall* _tmp1043_;
										ValaCCodeExpression* _tmp1044_;
										ValaCCodeCastExpression* _tmp1045_;
										ValaCCodeCastExpression* _tmp1046_;
										ValaCCodeFunctionCall* _tmp1047_;
										ValaCCodeExpression* _tmp1048_;
										ValaCCodeFunctionCall* _tmp1049_;
										ValaCCodeExpression* _tmp1050_;
										ValaCCodeCastExpression* _tmp1051_;
										ValaCCodeCastExpression* _tmp1052_;
										ValaCCodeExpression* _tmp1053_;
										ValaCCodeIdentifier* _tmp1054_;
										ValaCCodeIdentifier* _tmp1055_;
										ValaCCodeBinaryExpression* _tmp1056_;
										ValaCCodeBinaryExpression* _tmp1057_;
										ValaCCodeIdentifier* _tmp1058_;
										ValaCCodeIdentifier* _tmp1059_;
										ValaCCodeFunctionCall* _tmp1060_;
										ValaCCodeConditionalExpression* _tmp1061_;
										_tmp1039_ = vala_ccode_identifier_new ("g_cclosure_new");
										_tmp1040_ = _tmp1039_;
										_tmp1041_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1040_);
										_tmp1042_ = _tmp1041_;
										_vala_ccode_node_unref0 (_tmp1040_);
										closure_new = _tmp1042_;
										_tmp1043_ = closure_new;
										_tmp1044_ = cexpr;
										_tmp1045_ = vala_ccode_cast_expression_new (_tmp1044_, "GCallback");
										_tmp1046_ = _tmp1045_;
										vala_ccode_function_call_add_argument (_tmp1043_, (ValaCCodeExpression*) _tmp1046_);
										_vala_ccode_node_unref0 (_tmp1046_);
										_tmp1047_ = closure_new;
										_tmp1048_ = delegate_target;
										vala_ccode_function_call_add_argument (_tmp1047_, _tmp1048_);
										_tmp1049_ = closure_new;
										_tmp1050_ = delegate_target_destroy_notify;
										_tmp1051_ = vala_ccode_cast_expression_new (_tmp1050_, "GClosureNotify");
										_tmp1052_ = _tmp1051_;
										vala_ccode_function_call_add_argument (_tmp1049_, (ValaCCodeExpression*) _tmp1052_);
										_vala_ccode_node_unref0 (_tmp1052_);
										_tmp1053_ = cexpr;
										_tmp1054_ = vala_ccode_identifier_new ("NULL");
										_tmp1055_ = _tmp1054_;
										_tmp1056_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1053_, (ValaCCodeExpression*) _tmp1055_);
										_tmp1057_ = _tmp1056_;
										_tmp1058_ = vala_ccode_identifier_new ("NULL");
										_tmp1059_ = _tmp1058_;
										_tmp1060_ = closure_new;
										_tmp1061_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1057_, (ValaCCodeExpression*) _tmp1059_, (ValaCCodeExpression*) _tmp1060_);
										_vala_ccode_node_unref0 (cexpr);
										cexpr = (ValaCCodeExpression*) _tmp1061_;
										_vala_ccode_node_unref0 (_tmp1059_);
										_vala_ccode_node_unref0 (_tmp1057_);
										_vala_ccode_node_unref0 (_tmp1055_);
										_vala_ccode_node_unref0 (closure_new);
									} else {
										ValaHashMap* _tmp1062_;
										ValaParameter* _tmp1063_;
										ValaCCodeExpression* _tmp1064_;
										ValaDelegateType* _tmp1065_;
										_tmp1062_ = carg_map;
										_tmp1063_ = param;
										_tmp1064_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp1062_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1063_), FALSE)), _tmp1064_);
										_tmp1065_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1065_)) {
											ValaCCodeExpression* _tmp1066_;
											ValaHashMap* _tmp1067_;
											ValaParameter* _tmp1068_;
											ValaCCodeExpression* _tmp1069_;
											_tmp1066_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1066_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1067_ = carg_map;
											_tmp1068_ = param;
											_tmp1069_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1067_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1068_) + 0.01, FALSE)), _tmp1069_);
										}
									}
									_vala_ccode_node_unref0 (delegate_target);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								}
								_vala_code_node_unref0 (deleg_type);
							} else {
								ValaParameter* _tmp1070_;
								ValaDataType* _tmp1071_;
								ValaDataType* _tmp1072_;
								_tmp1070_ = param;
								_tmp1071_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1070_);
								_tmp1072_ = _tmp1071_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1072_, VALA_TYPE_METHOD_TYPE)) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaHashMap* _tmp1073_;
									ValaParameter* _tmp1074_;
									ValaExpression* _tmp1075_;
									ValaCCodeExpression* _tmp1076_ = NULL;
									ValaCCodeExpression* _tmp1077_;
									ValaCCodeExpression* _tmp1078_;
									_tmp1073_ = carg_map;
									_tmp1074_ = param;
									_tmp1075_ = arg;
									_tmp1077_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1075_, &_tmp1076_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp1076_;
									_tmp1078_ = _tmp1077_;
									vala_map_set ((ValaMap*) _tmp1073_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1074_), FALSE)), _tmp1078_);
									_vala_ccode_node_unref0 (_tmp1078_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								} else {
									ValaParameter* _tmp1079_;
									ValaDataType* _tmp1080_;
									ValaDataType* _tmp1081_;
									_tmp1079_ = param;
									_tmp1080_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1079_);
									_tmp1081_ = _tmp1080_;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1081_, VALA_TYPE_GENERIC_TYPE)) {
										gboolean _tmp1082_ = FALSE;
										ValaMethod* _tmp1083_;
										_tmp1083_ = m;
										if (_tmp1083_ != NULL) {
											ValaMethod* _tmp1084_;
											_tmp1084_ = m;
											_tmp1082_ = vala_get_ccode_simple_generics (_tmp1084_);
										} else {
											_tmp1082_ = FALSE;
										}
										if (_tmp1082_) {
											ValaGenericType* generic_type = NULL;
											ValaParameter* _tmp1085_;
											ValaDataType* _tmp1086_;
											ValaDataType* _tmp1087_;
											ValaGenericType* _tmp1088_;
											gint type_param_index = 0;
											ValaMethod* _tmp1089_;
											ValaGenericType* _tmp1090_;
											ValaTypeParameter* _tmp1091_;
											ValaTypeParameter* _tmp1092_;
											const gchar* _tmp1093_;
											const gchar* _tmp1094_;
											ValaDataType* type_arg = NULL;
											ValaMemberAccess* _tmp1095_;
											ValaList* _tmp1096_;
											ValaList* _tmp1097_;
											gint _tmp1098_;
											gpointer _tmp1099_;
											ValaDataType* _tmp1100_;
											ValaParameter* _tmp1101_;
											ValaDataType* _tmp1102_;
											ValaDataType* _tmp1103_;
											gboolean _tmp1104_;
											gboolean _tmp1105_;
											_tmp1085_ = param;
											_tmp1086_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1085_);
											_tmp1087_ = _tmp1086_;
											_tmp1088_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1087_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
											generic_type = _tmp1088_;
											_tmp1089_ = m;
											_tmp1090_ = generic_type;
											_tmp1091_ = vala_generic_type_get_type_parameter (_tmp1090_);
											_tmp1092_ = _tmp1091_;
											_tmp1093_ = vala_symbol_get_name ((ValaSymbol*) _tmp1092_);
											_tmp1094_ = _tmp1093_;
											type_param_index = vala_method_get_type_parameter_index (_tmp1089_, _tmp1094_);
											_tmp1095_ = ma;
											_tmp1096_ = vala_member_access_get_type_arguments (_tmp1095_);
											_tmp1097_ = _tmp1096_;
											_tmp1098_ = type_param_index;
											_tmp1099_ = vala_list_get (_tmp1097_, _tmp1098_);
											_tmp1100_ = (ValaDataType*) _tmp1099_;
											_vala_iterable_unref0 (_tmp1097_);
											type_arg = _tmp1100_;
											_tmp1101_ = param;
											_tmp1102_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1101_);
											_tmp1103_ = _tmp1102_;
											_tmp1104_ = vala_data_type_get_value_owned (_tmp1103_);
											_tmp1105_ = _tmp1104_;
											if (_tmp1105_) {
												ValaDataType* _tmp1106_;
												_tmp1106_ = type_arg;
												if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1106_)) {
													ValaHashMap* _tmp1107_;
													ValaParameter* _tmp1108_;
													ValaDataType* _tmp1109_;
													ValaCCodeExpression* _tmp1110_;
													ValaCCodeExpression* _tmp1111_;
													_tmp1107_ = carg_map;
													_tmp1108_ = param;
													_tmp1109_ = type_arg;
													_tmp1110_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1109_, FALSE);
													_tmp1111_ = _tmp1110_;
													vala_map_set ((ValaMap*) _tmp1107_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1108_), FALSE)), _tmp1111_);
													_vala_ccode_node_unref0 (_tmp1111_);
												} else {
													ValaHashMap* _tmp1112_;
													ValaParameter* _tmp1113_;
													ValaCCodeConstant* _tmp1114_;
													ValaCCodeConstant* _tmp1115_;
													_tmp1112_ = carg_map;
													_tmp1113_ = param;
													_tmp1114_ = vala_ccode_constant_new ("NULL");
													_tmp1115_ = _tmp1114_;
													vala_map_set ((ValaMap*) _tmp1112_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1113_), FALSE)), (ValaCCodeExpression*) _tmp1115_);
													_vala_ccode_node_unref0 (_tmp1115_);
												}
											}
											_vala_code_node_unref0 (type_arg);
											_vala_code_node_unref0 (generic_type);
										}
									}
								}
							}
						}
						_tmp1116_ = param;
						_tmp1117_ = arg;
						_tmp1118_ = cexpr;
						_tmp1119_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1116_, _tmp1117_, _tmp1118_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = _tmp1119_;
					} else {
						ValaExpression* _tmp1120_;
						ValaLocalVariable* temp_var = NULL;
						ValaParameter* _tmp1121_;
						ValaDataType* _tmp1122_;
						ValaDataType* _tmp1123_;
						ValaParameter* _tmp1124_;
						ValaDataType* _tmp1125_;
						ValaDataType* _tmp1126_;
						gboolean _tmp1127_;
						gboolean _tmp1128_;
						ValaLocalVariable* _tmp1129_;
						ValaLocalVariable* _tmp1130_;
						ValaExpression* _tmp1131_;
						ValaLocalVariable* _tmp1132_;
						const gchar* _tmp1133_;
						const gchar* _tmp1134_;
						ValaCCodeExpression* _tmp1135_;
						ValaCCodeExpression* _tmp1136_;
						ValaExpression* _tmp1137_;
						ValaTargetValue* _tmp1138_;
						ValaTargetValue* _tmp1139_;
						ValaExpression* _tmp1140_;
						ValaDataType* _tmp1141_;
						ValaDataType* _tmp1142_;
						ValaExpression* _tmp1143_;
						ValaCCodeExpression* _tmp1144_;
						ValaCCodeExpression* _tmp1145_;
						ValaCCodeUnaryExpression* _tmp1146_;
						gboolean _tmp1147_ = FALSE;
						gboolean _tmp1148_ = FALSE;
						ValaParameter* _tmp1149_;
						_tmp1120_ = arg;
						vala_expression_set_target_value (_tmp1120_, NULL);
						_tmp1121_ = param;
						_tmp1122_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1121_);
						_tmp1123_ = _tmp1122_;
						_tmp1124_ = param;
						_tmp1125_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1124_);
						_tmp1126_ = _tmp1125_;
						_tmp1127_ = vala_data_type_get_value_owned (_tmp1126_);
						_tmp1128_ = _tmp1127_;
						_tmp1129_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1123_, _tmp1128_, NULL, TRUE);
						temp_var = _tmp1129_;
						_tmp1130_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1130_, FALSE);
						_tmp1131_ = arg;
						_tmp1132_ = temp_var;
						_tmp1133_ = vala_symbol_get_name ((ValaSymbol*) _tmp1132_);
						_tmp1134_ = _tmp1133_;
						_tmp1135_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1134_);
						_tmp1136_ = _tmp1135_;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1131_, _tmp1136_);
						_vala_ccode_node_unref0 (_tmp1136_);
						_tmp1137_ = arg;
						_tmp1138_ = vala_expression_get_target_value (_tmp1137_);
						_tmp1139_ = _tmp1138_;
						_tmp1140_ = arg;
						_tmp1141_ = vala_expression_get_target_type (_tmp1140_);
						_tmp1142_ = _tmp1141_;
						vala_target_value_set_value_type (_tmp1139_, _tmp1142_);
						_tmp1143_ = arg;
						_tmp1144_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1143_);
						_tmp1145_ = _tmp1144_;
						_tmp1146_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1145_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1146_;
						_vala_ccode_node_unref0 (_tmp1145_);
						_tmp1149_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1149_)) {
							ValaParameter* _tmp1150_;
							ValaDataType* _tmp1151_;
							ValaDataType* _tmp1152_;
							_tmp1150_ = param;
							_tmp1151_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1150_);
							_tmp1152_ = _tmp1151_;
							_tmp1148_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1152_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp1148_ = FALSE;
						}
						if (_tmp1148_) {
							ValaParameter* _tmp1153_;
							ValaDataType* _tmp1154_;
							ValaDataType* _tmp1155_;
							gboolean _tmp1156_;
							gboolean _tmp1157_;
							_tmp1153_ = param;
							_tmp1154_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1153_);
							_tmp1155_ = _tmp1154_;
							_tmp1156_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1155_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp1157_ = _tmp1156_;
							_tmp1147_ = !_tmp1157_;
						} else {
							_tmp1147_ = FALSE;
						}
						if (_tmp1147_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp1158_;
							ValaDataType* _tmp1159_;
							ValaDataType* _tmp1160_;
							ValaArrayType* _tmp1161_;
							ValaDataType* array_length_type = NULL;
							ValaDataType* _tmp1162_;
							ValaDataType* _tmp1163_;
							ValaParameter* _tmp1164_;
							gchar* _tmp1165_;
							gchar* _tmp1166_;
							gboolean _tmp1167_;
							_tmp1158_ = param;
							_tmp1159_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1158_);
							_tmp1160_ = _tmp1159_;
							_tmp1161_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1160_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp1161_;
							_tmp1162_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1163_ = _vala_code_node_ref0 (_tmp1162_);
							array_length_type = _tmp1163_;
							_tmp1164_ = param;
							_tmp1165_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1164_);
							_tmp1166_ = _tmp1165_;
							_tmp1167_ = _tmp1166_ != NULL;
							_g_free0 (_tmp1166_);
							if (_tmp1167_) {
								ValaParameter* _tmp1168_;
								gchar* _tmp1169_;
								gchar* _tmp1170_;
								ValaCType* _tmp1171_;
								_tmp1168_ = param;
								_tmp1169_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1168_);
								_tmp1170_ = _tmp1169_;
								_tmp1171_ = vala_ctype_new (_tmp1170_);
								_vala_code_node_unref0 (array_length_type);
								array_length_type = (ValaDataType*) _tmp1171_;
								_g_free0 (_tmp1170_);
							}
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp1172_ = FALSE;
									_tmp1172_ = TRUE;
									while (TRUE) {
										gint _tmp1174_;
										ValaArrayType* _tmp1175_;
										gint _tmp1176_;
										gint _tmp1177_;
										ValaLocalVariable* temp_array_length = NULL;
										ValaDataType* _tmp1178_;
										ValaLocalVariable* _tmp1179_;
										ValaLocalVariable* _tmp1180_;
										ValaExpression* _tmp1181_;
										ValaLocalVariable* _tmp1182_;
										const gchar* _tmp1183_;
										const gchar* _tmp1184_;
										ValaCCodeExpression* _tmp1185_;
										ValaCCodeExpression* _tmp1186_;
										ValaHashMap* _tmp1187_;
										ValaParameter* _tmp1188_;
										gint _tmp1189_;
										ValaExpression* _tmp1190_;
										ValaList* _tmp1191_;
										ValaList* _tmp1192_;
										gint _tmp1193_;
										gpointer _tmp1194_;
										ValaCCodeExpression* _tmp1195_;
										ValaCCodeUnaryExpression* _tmp1196_;
										ValaCCodeUnaryExpression* _tmp1197_;
										if (!_tmp1172_) {
											gint _tmp1173_;
											_tmp1173_ = dim;
											dim = _tmp1173_ + 1;
										}
										_tmp1172_ = FALSE;
										_tmp1174_ = dim;
										_tmp1175_ = array_type;
										_tmp1176_ = vala_array_type_get_rank (_tmp1175_);
										_tmp1177_ = _tmp1176_;
										if (!(_tmp1174_ <= _tmp1177_)) {
											break;
										}
										_tmp1178_ = array_length_type;
										_tmp1179_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1178_, TRUE, NULL, FALSE);
										temp_array_length = _tmp1179_;
										_tmp1180_ = temp_array_length;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1180_, FALSE);
										_tmp1181_ = arg;
										_tmp1182_ = temp_array_length;
										_tmp1183_ = vala_symbol_get_name ((ValaSymbol*) _tmp1182_);
										_tmp1184_ = _tmp1183_;
										_tmp1185_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1184_);
										_tmp1186_ = _tmp1185_;
										vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1181_, _tmp1186_);
										_vala_ccode_node_unref0 (_tmp1186_);
										_tmp1187_ = carg_map;
										_tmp1188_ = param;
										_tmp1189_ = dim;
										_tmp1190_ = arg;
										_tmp1191_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1190_);
										_tmp1192_ = _tmp1191_;
										_tmp1193_ = dim;
										_tmp1194_ = vala_list_get (_tmp1192_, _tmp1193_ - 1);
										_tmp1195_ = (ValaCCodeExpression*) _tmp1194_;
										_tmp1196_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1195_);
										_tmp1197_ = _tmp1196_;
										vala_map_set ((ValaMap*) _tmp1187_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1188_) + (0.01 * _tmp1189_), FALSE)), (ValaCCodeExpression*) _tmp1197_);
										_vala_ccode_node_unref0 (_tmp1197_);
										_vala_ccode_node_unref0 (_tmp1195_);
										_vala_iterable_unref0 (_tmp1192_);
										_vala_code_node_unref0 (temp_array_length);
									}
								}
							}
							_vala_code_node_unref0 (array_length_type);
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp1198_;
							ValaDataType* _tmp1199_;
							ValaDataType* _tmp1200_;
							_tmp1198_ = param;
							_tmp1199_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1198_);
							_tmp1200_ = _tmp1199_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1200_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp1201_;
								ValaDataType* _tmp1202_;
								ValaDataType* _tmp1203_;
								ValaDelegateType* _tmp1204_;
								ValaDelegateType* _tmp1205_;
								ValaDelegate* _tmp1206_;
								ValaDelegate* _tmp1207_;
								gboolean _tmp1208_;
								gboolean _tmp1209_;
								_tmp1201_ = param;
								_tmp1202_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1201_);
								_tmp1203_ = _tmp1202_;
								_tmp1204_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1203_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp1204_;
								_tmp1205_ = deleg_type;
								_tmp1206_ = vala_delegate_type_get_delegate_symbol (_tmp1205_);
								_tmp1207_ = _tmp1206_;
								_tmp1208_ = vala_delegate_get_has_target (_tmp1207_);
								_tmp1209_ = _tmp1208_;
								if (_tmp1209_) {
									ValaVoidType* _tmp1210_;
									ValaVoidType* _tmp1211_;
									ValaPointerType* _tmp1212_;
									ValaPointerType* _tmp1213_;
									ValaLocalVariable* _tmp1214_;
									ValaLocalVariable* _tmp1215_;
									ValaExpression* _tmp1216_;
									ValaLocalVariable* _tmp1217_;
									const gchar* _tmp1218_;
									const gchar* _tmp1219_;
									ValaCCodeExpression* _tmp1220_;
									ValaCCodeExpression* _tmp1221_;
									ValaHashMap* _tmp1222_;
									ValaParameter* _tmp1223_;
									ValaExpression* _tmp1224_;
									ValaCCodeExpression* _tmp1225_;
									ValaCCodeExpression* _tmp1226_;
									ValaCCodeUnaryExpression* _tmp1227_;
									ValaCCodeUnaryExpression* _tmp1228_;
									ValaDelegateType* _tmp1229_;
									_tmp1210_ = vala_void_type_new (NULL);
									_tmp1211_ = _tmp1210_;
									_tmp1212_ = vala_pointer_type_new ((ValaDataType*) _tmp1211_, NULL);
									_tmp1213_ = _tmp1212_;
									_tmp1214_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1213_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1214_;
									_vala_code_node_unref0 (_tmp1213_);
									_vala_code_node_unref0 (_tmp1211_);
									_tmp1215_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1215_, FALSE);
									_tmp1216_ = arg;
									_tmp1217_ = temp_var;
									_tmp1218_ = vala_symbol_get_name ((ValaSymbol*) _tmp1217_);
									_tmp1219_ = _tmp1218_;
									_tmp1220_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1219_);
									_tmp1221_ = _tmp1220_;
									vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1216_, _tmp1221_);
									_vala_ccode_node_unref0 (_tmp1221_);
									_tmp1222_ = carg_map;
									_tmp1223_ = param;
									_tmp1224_ = arg;
									_tmp1225_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1224_);
									_tmp1226_ = _tmp1225_;
									_tmp1227_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1226_);
									_tmp1228_ = _tmp1227_;
									vala_map_set ((ValaMap*) _tmp1222_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1223_), FALSE)), (ValaCCodeExpression*) _tmp1228_);
									_vala_ccode_node_unref0 (_tmp1228_);
									_vala_ccode_node_unref0 (_tmp1226_);
									_tmp1229_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1229_)) {
										ValaDataType* _tmp1230_;
										ValaLocalVariable* _tmp1231_;
										ValaLocalVariable* _tmp1232_;
										ValaExpression* _tmp1233_;
										ValaLocalVariable* _tmp1234_;
										const gchar* _tmp1235_;
										const gchar* _tmp1236_;
										ValaCCodeExpression* _tmp1237_;
										ValaCCodeExpression* _tmp1238_;
										ValaHashMap* _tmp1239_;
										ValaParameter* _tmp1240_;
										ValaExpression* _tmp1241_;
										ValaCCodeExpression* _tmp1242_;
										ValaCCodeExpression* _tmp1243_;
										ValaCCodeUnaryExpression* _tmp1244_;
										ValaCCodeUnaryExpression* _tmp1245_;
										_tmp1230_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
										_tmp1231_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1230_, TRUE, NULL, TRUE);
										_vala_code_node_unref0 (temp_var);
										temp_var = _tmp1231_;
										_tmp1232_ = temp_var;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1232_, FALSE);
										_tmp1233_ = arg;
										_tmp1234_ = temp_var;
										_tmp1235_ = vala_symbol_get_name ((ValaSymbol*) _tmp1234_);
										_tmp1236_ = _tmp1235_;
										_tmp1237_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1236_);
										_tmp1238_ = _tmp1237_;
										vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1233_, _tmp1238_);
										_vala_ccode_node_unref0 (_tmp1238_);
										_tmp1239_ = carg_map;
										_tmp1240_ = param;
										_tmp1241_ = arg;
										_tmp1242_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1241_);
										_tmp1243_ = _tmp1242_;
										_tmp1244_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1243_);
										_tmp1245_ = _tmp1244_;
										vala_map_set ((ValaMap*) _tmp1239_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1240_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1245_);
										_vala_ccode_node_unref0 (_tmp1245_);
										_vala_ccode_node_unref0 (_tmp1243_);
									}
								}
								_vala_code_node_unref0 (deleg_type);
							}
						}
						_vala_code_node_unref0 (temp_var);
					}
					_tmp1246_ = param;
					_tmp1247_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1246_);
					_tmp1248_ = _tmp1247_;
					_tmp1249_ = _tmp1248_ != NULL;
					_g_free0 (_tmp1248_);
					if (_tmp1249_) {
						ValaCCodeExpression* _tmp1250_;
						ValaParameter* _tmp1251_;
						gchar* _tmp1252_;
						gchar* _tmp1253_;
						ValaCCodeCastExpression* _tmp1254_;
						_tmp1250_ = cexpr;
						_tmp1251_ = param;
						_tmp1252_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1251_);
						_tmp1253_ = _tmp1252_;
						_tmp1254_ = vala_ccode_cast_expression_new (_tmp1250_, _tmp1253_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1254_;
						_g_free0 (_tmp1253_);
					}
					_vala_code_node_unref0 (unary);
				} else {
					ValaExpression* _tmp1255_;
					ValaCCodeExpression* _tmp1256_;
					ValaCCodeExpression* _tmp1257_;
					_tmp1255_ = arg;
					_tmp1256_ = cexpr;
					_tmp1257_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1255_, _tmp1256_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1257_;
				}
				_tmp1258_ = param;
				_tmp1259_ = ellipsis;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_pos (_tmp1258_), _tmp1259_);
				_vala_code_node_unref0 (param);
			} else {
				ValaExpression* _tmp1260_;
				ValaCCodeExpression* _tmp1261_;
				ValaCCodeExpression* _tmp1262_;
				gint _tmp1263_;
				gboolean _tmp1264_;
				_tmp1260_ = arg;
				_tmp1261_ = cexpr;
				_tmp1262_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1260_, _tmp1261_);
				_vala_ccode_node_unref0 (cexpr);
				cexpr = _tmp1262_;
				_tmp1263_ = i;
				_tmp1264_ = ellipsis;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) _tmp1263_, _tmp1264_);
			}
			_tmp1265_ = carg_map;
			_tmp1266_ = arg_pos;
			_tmp1267_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1265_, (gpointer) ((gintptr) _tmp1266_), _tmp1267_);
			_tmp1269_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1269_, VALA_TYPE_NAMED_ARGUMENT)) {
				gboolean _tmp1270_;
				_tmp1270_ = ellipsis;
				_tmp1268_ = _tmp1270_;
			} else {
				_tmp1268_ = FALSE;
			}
			if (_tmp1268_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1271_;
				ValaNamedArgument* _tmp1272_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1273_;
				const gchar* _tmp1274_;
				const gchar* _tmp1275_;
				gchar** _tmp1276_;
				gchar** _tmp1277_;
				gchar** _tmp1278_;
				gint _tmp1278__length1;
				gchar* _tmp1279_;
				gchar* _tmp1280_;
				ValaHashMap* _tmp1281_;
				gint _tmp1282_;
				gboolean _tmp1283_;
				const gchar* _tmp1284_;
				gchar* _tmp1285_;
				gchar* _tmp1286_;
				ValaCCodeConstant* _tmp1287_;
				ValaCCodeConstant* _tmp1288_;
				_tmp1271_ = arg;
				_tmp1272_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1271_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1272_;
				_tmp1273_ = named_arg;
				_tmp1274_ = vala_named_argument_get_name (_tmp1273_);
				_tmp1275_ = _tmp1274_;
				_tmp1277_ = _tmp1276_ = g_strsplit (_tmp1275_, "_", 0);
				_tmp1278_ = _tmp1277_;
				_tmp1278__length1 = _vala_array_length (_tmp1276_);
				_tmp1279_ = _vala_g_strjoinv ("-", _tmp1278_, _vala_array_length (_tmp1276_));
				_tmp1280_ = _tmp1279_;
				_tmp1278_ = (_vala_array_free (_tmp1278_, _tmp1278__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1280_;
				_tmp1281_ = carg_map;
				_tmp1282_ = i;
				_tmp1283_ = ellipsis;
				_tmp1284_ = name;
				_tmp1285_ = g_strdup_printf ("\"%s\"", _tmp1284_);
				_tmp1286_ = _tmp1285_;
				_tmp1287_ = vala_ccode_constant_new (_tmp1286_);
				_tmp1288_ = _tmp1287_;
				vala_map_set ((ValaMap*) _tmp1281_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1282_ - 0.1, _tmp1283_)), (ValaCCodeExpression*) _tmp1288_);
				_vala_ccode_node_unref0 (_tmp1288_);
				_g_free0 (_tmp1286_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1289_ = i;
			i = _tmp1289_ + 1;
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1290_ = params_it;
	if (vala_iterator_next (_tmp1290_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1291_;
		gpointer _tmp1292_;
		gboolean _tmp1293_ = FALSE;
		ValaParameter* _tmp1294_;
		gboolean _tmp1295_;
		gboolean _tmp1296_;
		_tmp1291_ = params_it;
		_tmp1292_ = vala_iterator_get (_tmp1291_);
		param = (ValaParameter*) _tmp1292_;
		_tmp1294_ = param;
		_tmp1295_ = vala_parameter_get_params_array (_tmp1294_);
		_tmp1296_ = _tmp1295_;
		if (_tmp1296_) {
			_tmp1293_ = TRUE;
		} else {
			ValaParameter* _tmp1297_;
			gboolean _tmp1298_;
			gboolean _tmp1299_;
			_tmp1297_ = param;
			_tmp1298_ = vala_parameter_get_ellipsis (_tmp1297_);
			_tmp1299_ = _tmp1298_;
			_tmp1293_ = _tmp1299_;
		}
		_vala_assert (_tmp1293_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1302_ = m;
	if (_tmp1302_ != NULL) {
		ValaMethod* _tmp1303_;
		ValaDataType* _tmp1304_;
		ValaDataType* _tmp1305_;
		_tmp1303_ = m;
		_tmp1304_ = vala_callable_get_return_type ((ValaCallable*) _tmp1303_);
		_tmp1305_ = _tmp1304_;
		_tmp1301_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1305_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1301_ = FALSE;
	}
	if (_tmp1301_) {
		ValaCCodeFunctionCall* _tmp1306_;
		ValaCCodeFunctionCall* _tmp1307_;
		_tmp1306_ = async_call;
		_tmp1307_ = ccall;
		_tmp1300_ = _tmp1306_ != _tmp1307_;
	} else {
		_tmp1300_ = FALSE;
	}
	if (_tmp1300_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1308_;
		ValaDataType* _tmp1309_;
		ValaDataType* _tmp1310_;
		ValaArrayType* _tmp1311_;
		_tmp1308_ = m;
		_tmp1309_ = vala_callable_get_return_type ((ValaCallable*) _tmp1308_);
		_tmp1310_ = _tmp1309_;
		_tmp1311_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1310_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1311_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1312_ = FALSE;
				_tmp1312_ = TRUE;
				while (TRUE) {
					gint _tmp1314_;
					ValaArrayType* _tmp1315_;
					gint _tmp1316_;
					gint _tmp1317_;
					ValaMethod* _tmp1318_;
					if (!_tmp1312_) {
						gint _tmp1313_;
						_tmp1313_ = dim;
						dim = _tmp1313_ + 1;
					}
					_tmp1312_ = FALSE;
					_tmp1314_ = dim;
					_tmp1315_ = array_type;
					_tmp1316_ = vala_array_type_get_rank (_tmp1315_);
					_tmp1317_ = _tmp1316_;
					if (!(_tmp1314_ <= _tmp1317_)) {
						break;
					}
					_tmp1318_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1318_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1319_;
						ValaDataType* _tmp1320_;
						ValaDataType* _tmp1321_;
						ValaLocalVariable* _tmp1322_;
						ValaLocalVariable* _tmp1323_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1324_;
						const gchar* _tmp1325_;
						const gchar* _tmp1326_;
						ValaCCodeExpression* _tmp1327_;
						ValaLocalVariable* _tmp1328_;
						ValaCCodeExpression* _tmp1329_;
						ValaCCodeExpression* _tmp1330_;
						ValaCCodeAssignment* _tmp1331_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1332_;
						ValaCCodeIdentifier* _tmp1333_;
						ValaCCodeFunctionCall* _tmp1334_;
						ValaCCodeFunctionCall* _tmp1335_;
						ValaCCodeFunctionCall* _tmp1336_;
						ValaCCodeExpression* _tmp1337_;
						ValaCCodeFunctionCall* _tmp1338_;
						_tmp1319_ = itype;
						_tmp1320_ = vala_data_type_get_return_type (_tmp1319_);
						_tmp1321_ = _tmp1320_;
						_tmp1322_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1321_, TRUE, NULL, FALSE);
						_tmp1323_ = _tmp1322_;
						_vala_code_node_unref0 (_tmp1321_);
						temp_var = _tmp1323_;
						_tmp1324_ = temp_var;
						_tmp1325_ = vala_symbol_get_name ((ValaSymbol*) _tmp1324_);
						_tmp1326_ = _tmp1325_;
						_tmp1327_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1326_);
						temp_ref = _tmp1327_;
						_tmp1328_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1328_, FALSE);
						_tmp1329_ = temp_ref;
						_tmp1330_ = ccall_expr;
						_tmp1331_ = vala_ccode_assignment_new (_tmp1329_, _tmp1330_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1331_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1332_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1333_ = _tmp1332_;
						_tmp1334_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1333_);
						_tmp1335_ = _tmp1334_;
						_vala_ccode_node_unref0 (_tmp1333_);
						len_call = _tmp1335_;
						_tmp1336_ = len_call;
						_tmp1337_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1336_, _tmp1337_);
						_tmp1338_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1338_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1339_;
						_tmp1339_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1339_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaMethod* _tmp1340_;
							gchar* _tmp1341_;
							gchar* _tmp1342_;
							gboolean _tmp1343_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1352_;
							const gchar* _tmp1353_;
							const gchar* _tmp1354_;
							ValaCCodeExpression* _tmp1355_;
							ValaLocalVariable* _tmp1356_;
							ValaHashMap* _tmp1357_;
							ValaMethod* _tmp1358_;
							gint _tmp1359_;
							ValaCCodeExpression* _tmp1360_;
							ValaCCodeUnaryExpression* _tmp1361_;
							ValaCCodeUnaryExpression* _tmp1362_;
							ValaCCodeExpression* _tmp1363_;
							_tmp1340_ = m;
							_tmp1341_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1340_);
							_tmp1342_ = _tmp1341_;
							_tmp1343_ = _tmp1342_ == NULL;
							_g_free0 (_tmp1342_);
							if (_tmp1343_) {
								ValaDataType* _tmp1344_;
								ValaLocalVariable* _tmp1345_;
								_tmp1344_ = ((ValaCCodeBaseModule*) self)->int_type;
								_tmp1345_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1344_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1345_;
							} else {
								ValaMethod* _tmp1346_;
								gchar* _tmp1347_;
								gchar* _tmp1348_;
								ValaCType* _tmp1349_;
								ValaCType* _tmp1350_;
								ValaLocalVariable* _tmp1351_;
								_tmp1346_ = m;
								_tmp1347_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1346_);
								_tmp1348_ = _tmp1347_;
								_tmp1349_ = vala_ctype_new (_tmp1348_);
								_tmp1350_ = _tmp1349_;
								_tmp1351_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1350_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1351_;
								_vala_code_node_unref0 (_tmp1350_);
								_g_free0 (_tmp1348_);
							}
							_tmp1352_ = temp_var;
							_tmp1353_ = vala_symbol_get_name ((ValaSymbol*) _tmp1352_);
							_tmp1354_ = _tmp1353_;
							_tmp1355_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1354_);
							temp_ref = _tmp1355_;
							_tmp1356_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1356_, FALSE);
							_tmp1357_ = out_arg_map;
							_tmp1358_ = m;
							_tmp1359_ = dim;
							_tmp1360_ = temp_ref;
							_tmp1361_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1360_);
							_tmp1362_ = _tmp1361_;
							vala_map_set ((ValaMap*) _tmp1357_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1358_) + (0.01 * _tmp1359_), FALSE)), (ValaCCodeExpression*) _tmp1362_);
							_vala_ccode_node_unref0 (_tmp1362_);
							_tmp1363_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1363_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaMethod* _tmp1364_;
							gchar* _tmp1365_;
							gchar* _tmp1366_;
							gboolean _tmp1367_;
							_tmp1364_ = m;
							_tmp1365_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1364_);
							_tmp1366_ = _tmp1365_;
							_tmp1367_ = _tmp1366_ != NULL;
							_g_free0 (_tmp1366_);
							if (_tmp1367_) {
								ValaMethod* _tmp1368_;
								gchar* _tmp1369_;
								gchar* _tmp1370_;
								ValaCCodeConstant* _tmp1371_;
								ValaCCodeConstant* _tmp1372_;
								_tmp1368_ = m;
								_tmp1369_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1368_);
								_tmp1370_ = _tmp1369_;
								_tmp1371_ = vala_ccode_constant_new (_tmp1370_);
								_tmp1372_ = _tmp1371_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1372_);
								_vala_ccode_node_unref0 (_tmp1372_);
								_g_free0 (_tmp1370_);
							} else {
								ValaCCodeConstant* _tmp1373_;
								ValaCCodeConstant* _tmp1374_;
								_tmp1373_ = vala_ccode_constant_new ("-1");
								_tmp1374_ = _tmp1373_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1374_);
								_vala_ccode_node_unref0 (_tmp1374_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1375_ = FALSE;
		gboolean _tmp1376_ = FALSE;
		ValaMethod* _tmp1377_;
		_tmp1377_ = m;
		if (_tmp1377_ != NULL) {
			ValaMethod* _tmp1378_;
			ValaDataType* _tmp1379_;
			ValaDataType* _tmp1380_;
			_tmp1378_ = m;
			_tmp1379_ = vala_callable_get_return_type ((ValaCallable*) _tmp1378_);
			_tmp1380_ = _tmp1379_;
			_tmp1376_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1380_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1376_ = FALSE;
		}
		if (_tmp1376_) {
			ValaCCodeFunctionCall* _tmp1381_;
			ValaCCodeFunctionCall* _tmp1382_;
			_tmp1381_ = async_call;
			_tmp1382_ = ccall;
			_tmp1375_ = _tmp1381_ != _tmp1382_;
		} else {
			_tmp1375_ = FALSE;
		}
		if (_tmp1375_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1383_;
			ValaDataType* _tmp1384_;
			ValaDataType* _tmp1385_;
			ValaDelegateType* _tmp1386_;
			ValaDelegateType* _tmp1387_;
			ValaDelegate* _tmp1388_;
			ValaDelegate* _tmp1389_;
			gboolean _tmp1390_;
			gboolean _tmp1391_;
			_tmp1383_ = m;
			_tmp1384_ = vala_callable_get_return_type ((ValaCallable*) _tmp1383_);
			_tmp1385_ = _tmp1384_;
			_tmp1386_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1385_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1386_;
			_tmp1387_ = deleg_type;
			_tmp1388_ = vala_delegate_type_get_delegate_symbol (_tmp1387_);
			_tmp1389_ = _tmp1388_;
			_tmp1390_ = vala_delegate_get_has_target (_tmp1389_);
			_tmp1391_ = _tmp1390_;
			if (_tmp1391_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1392_;
				ValaVoidType* _tmp1393_;
				ValaPointerType* _tmp1394_;
				ValaPointerType* _tmp1395_;
				ValaLocalVariable* _tmp1396_;
				ValaLocalVariable* _tmp1397_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1398_;
				const gchar* _tmp1399_;
				const gchar* _tmp1400_;
				ValaCCodeExpression* _tmp1401_;
				ValaLocalVariable* _tmp1402_;
				ValaHashMap* _tmp1403_;
				ValaMethod* _tmp1404_;
				ValaCCodeExpression* _tmp1405_;
				ValaCCodeUnaryExpression* _tmp1406_;
				ValaCCodeUnaryExpression* _tmp1407_;
				ValaCCodeExpression* _tmp1408_;
				ValaDelegateType* _tmp1409_;
				_tmp1392_ = vala_void_type_new (NULL);
				_tmp1393_ = _tmp1392_;
				_tmp1394_ = vala_pointer_type_new ((ValaDataType*) _tmp1393_, NULL);
				_tmp1395_ = _tmp1394_;
				_tmp1396_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1395_, TRUE, NULL, TRUE);
				_tmp1397_ = _tmp1396_;
				_vala_code_node_unref0 (_tmp1395_);
				_vala_code_node_unref0 (_tmp1393_);
				temp_var = _tmp1397_;
				_tmp1398_ = temp_var;
				_tmp1399_ = vala_symbol_get_name ((ValaSymbol*) _tmp1398_);
				_tmp1400_ = _tmp1399_;
				_tmp1401_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1400_);
				temp_ref = _tmp1401_;
				_tmp1402_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1402_, FALSE);
				_tmp1403_ = out_arg_map;
				_tmp1404_ = m;
				_tmp1405_ = temp_ref;
				_tmp1406_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1405_);
				_tmp1407_ = _tmp1406_;
				vala_map_set ((ValaMap*) _tmp1403_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1404_), FALSE)), (ValaCCodeExpression*) _tmp1407_);
				_vala_ccode_node_unref0 (_tmp1407_);
				_tmp1408_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1408_);
				_tmp1409_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1409_)) {
					ValaDataType* _tmp1410_;
					ValaLocalVariable* _tmp1411_;
					ValaLocalVariable* _tmp1412_;
					const gchar* _tmp1413_;
					const gchar* _tmp1414_;
					ValaCCodeExpression* _tmp1415_;
					ValaLocalVariable* _tmp1416_;
					ValaHashMap* _tmp1417_;
					ValaMethod* _tmp1418_;
					ValaCCodeExpression* _tmp1419_;
					ValaCCodeUnaryExpression* _tmp1420_;
					ValaCCodeUnaryExpression* _tmp1421_;
					ValaCCodeExpression* _tmp1422_;
					_tmp1410_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1411_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1410_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1411_;
					_tmp1412_ = temp_var;
					_tmp1413_ = vala_symbol_get_name ((ValaSymbol*) _tmp1412_);
					_tmp1414_ = _tmp1413_;
					_tmp1415_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1414_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1415_;
					_tmp1416_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1416_, FALSE);
					_tmp1417_ = out_arg_map;
					_tmp1418_ = m;
					_tmp1419_ = temp_ref;
					_tmp1420_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1419_);
					_tmp1421_ = _tmp1420_;
					vala_map_set ((ValaMap*) _tmp1417_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1418_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1421_);
					_vala_ccode_node_unref0 (_tmp1421_);
					_tmp1422_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1422_);
				} else {
					ValaCCodeConstant* _tmp1423_;
					ValaCCodeConstant* _tmp1424_;
					_tmp1423_ = vala_ccode_constant_new ("NULL");
					_tmp1424_ = _tmp1423_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1424_);
					_vala_ccode_node_unref0 (_tmp1424_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1425_;
				ValaCCodeConstant* _tmp1426_;
				_tmp1425_ = vala_ccode_constant_new ("NULL");
				_tmp1426_ = _tmp1425_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1426_);
				_vala_ccode_node_unref0 (_tmp1426_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1428_ = deleg;
	if (_tmp1428_ != NULL) {
		ValaDelegate* _tmp1429_;
		ValaDataType* _tmp1430_;
		ValaDataType* _tmp1431_;
		_tmp1429_ = deleg;
		_tmp1430_ = vala_callable_get_return_type ((ValaCallable*) _tmp1429_);
		_tmp1431_ = _tmp1430_;
		_tmp1427_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1431_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1427_ = FALSE;
	}
	if (_tmp1427_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1432_;
		ValaDataType* _tmp1433_;
		ValaDataType* _tmp1434_;
		ValaArrayType* _tmp1435_;
		_tmp1432_ = deleg;
		_tmp1433_ = vala_callable_get_return_type ((ValaCallable*) _tmp1432_);
		_tmp1434_ = _tmp1433_;
		_tmp1435_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1434_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1435_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1436_ = FALSE;
				_tmp1436_ = TRUE;
				while (TRUE) {
					gint _tmp1438_;
					ValaArrayType* _tmp1439_;
					gint _tmp1440_;
					gint _tmp1441_;
					ValaDelegate* _tmp1442_;
					if (!_tmp1436_) {
						gint _tmp1437_;
						_tmp1437_ = dim;
						dim = _tmp1437_ + 1;
					}
					_tmp1436_ = FALSE;
					_tmp1438_ = dim;
					_tmp1439_ = array_type;
					_tmp1440_ = vala_array_type_get_rank (_tmp1439_);
					_tmp1441_ = _tmp1440_;
					if (!(_tmp1438_ <= _tmp1441_)) {
						break;
					}
					_tmp1442_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1442_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1443_;
						ValaDataType* _tmp1444_;
						ValaDataType* _tmp1445_;
						ValaLocalVariable* _tmp1446_;
						ValaLocalVariable* _tmp1447_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1448_;
						const gchar* _tmp1449_;
						const gchar* _tmp1450_;
						ValaCCodeExpression* _tmp1451_;
						ValaLocalVariable* _tmp1452_;
						ValaCCodeExpression* _tmp1453_;
						ValaCCodeExpression* _tmp1454_;
						ValaCCodeAssignment* _tmp1455_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1456_;
						ValaCCodeIdentifier* _tmp1457_;
						ValaCCodeFunctionCall* _tmp1458_;
						ValaCCodeFunctionCall* _tmp1459_;
						ValaCCodeFunctionCall* _tmp1460_;
						ValaCCodeExpression* _tmp1461_;
						ValaCCodeFunctionCall* _tmp1462_;
						_tmp1443_ = itype;
						_tmp1444_ = vala_data_type_get_return_type (_tmp1443_);
						_tmp1445_ = _tmp1444_;
						_tmp1446_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1445_, TRUE, NULL, FALSE);
						_tmp1447_ = _tmp1446_;
						_vala_code_node_unref0 (_tmp1445_);
						temp_var = _tmp1447_;
						_tmp1448_ = temp_var;
						_tmp1449_ = vala_symbol_get_name ((ValaSymbol*) _tmp1448_);
						_tmp1450_ = _tmp1449_;
						_tmp1451_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1450_);
						temp_ref = _tmp1451_;
						_tmp1452_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1452_, FALSE);
						_tmp1453_ = temp_ref;
						_tmp1454_ = ccall_expr;
						_tmp1455_ = vala_ccode_assignment_new (_tmp1453_, _tmp1454_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1455_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1456_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1457_ = _tmp1456_;
						_tmp1458_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1457_);
						_tmp1459_ = _tmp1458_;
						_vala_ccode_node_unref0 (_tmp1457_);
						len_call = _tmp1459_;
						_tmp1460_ = len_call;
						_tmp1461_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1460_, _tmp1461_);
						_tmp1462_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1462_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1463_;
						_tmp1463_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1463_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaDataType* _tmp1464_;
							ValaLocalVariable* _tmp1465_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1466_;
							const gchar* _tmp1467_;
							const gchar* _tmp1468_;
							ValaCCodeExpression* _tmp1469_;
							ValaLocalVariable* _tmp1470_;
							ValaHashMap* _tmp1471_;
							ValaDelegate* _tmp1472_;
							gint _tmp1473_;
							ValaCCodeExpression* _tmp1474_;
							ValaCCodeUnaryExpression* _tmp1475_;
							ValaCCodeUnaryExpression* _tmp1476_;
							ValaCCodeExpression* _tmp1477_;
							_tmp1464_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1465_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1464_, TRUE, NULL, TRUE);
							temp_var = _tmp1465_;
							_tmp1466_ = temp_var;
							_tmp1467_ = vala_symbol_get_name ((ValaSymbol*) _tmp1466_);
							_tmp1468_ = _tmp1467_;
							_tmp1469_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1468_);
							temp_ref = _tmp1469_;
							_tmp1470_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1470_, FALSE);
							_tmp1471_ = out_arg_map;
							_tmp1472_ = deleg;
							_tmp1473_ = dim;
							_tmp1474_ = temp_ref;
							_tmp1475_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1474_);
							_tmp1476_ = _tmp1475_;
							vala_map_set ((ValaMap*) _tmp1471_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1472_) + (0.01 * _tmp1473_), FALSE)), (ValaCCodeExpression*) _tmp1476_);
							_vala_ccode_node_unref0 (_tmp1476_);
							_tmp1477_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1477_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1478_;
							ValaCCodeConstant* _tmp1479_;
							_tmp1478_ = vala_ccode_constant_new ("-1");
							_tmp1479_ = _tmp1478_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1479_);
							_vala_ccode_node_unref0 (_tmp1479_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1480_ = FALSE;
		ValaDelegate* _tmp1481_;
		_tmp1481_ = deleg;
		if (_tmp1481_ != NULL) {
			ValaDelegate* _tmp1482_;
			ValaDataType* _tmp1483_;
			ValaDataType* _tmp1484_;
			_tmp1482_ = deleg;
			_tmp1483_ = vala_callable_get_return_type ((ValaCallable*) _tmp1482_);
			_tmp1484_ = _tmp1483_;
			_tmp1480_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1484_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1480_ = FALSE;
		}
		if (_tmp1480_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1485_;
			ValaDataType* _tmp1486_;
			ValaDataType* _tmp1487_;
			ValaDelegateType* _tmp1488_;
			ValaDelegateType* _tmp1489_;
			ValaDelegate* _tmp1490_;
			ValaDelegate* _tmp1491_;
			gboolean _tmp1492_;
			gboolean _tmp1493_;
			_tmp1485_ = deleg;
			_tmp1486_ = vala_callable_get_return_type ((ValaCallable*) _tmp1485_);
			_tmp1487_ = _tmp1486_;
			_tmp1488_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1487_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1488_;
			_tmp1489_ = deleg_type;
			_tmp1490_ = vala_delegate_type_get_delegate_symbol (_tmp1489_);
			_tmp1491_ = _tmp1490_;
			_tmp1492_ = vala_delegate_get_has_target (_tmp1491_);
			_tmp1493_ = _tmp1492_;
			if (_tmp1493_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1494_;
				ValaVoidType* _tmp1495_;
				ValaPointerType* _tmp1496_;
				ValaPointerType* _tmp1497_;
				ValaLocalVariable* _tmp1498_;
				ValaLocalVariable* _tmp1499_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1500_;
				const gchar* _tmp1501_;
				const gchar* _tmp1502_;
				ValaCCodeExpression* _tmp1503_;
				ValaLocalVariable* _tmp1504_;
				ValaHashMap* _tmp1505_;
				ValaDelegate* _tmp1506_;
				ValaCCodeExpression* _tmp1507_;
				ValaCCodeUnaryExpression* _tmp1508_;
				ValaCCodeUnaryExpression* _tmp1509_;
				ValaCCodeExpression* _tmp1510_;
				ValaDelegateType* _tmp1511_;
				_tmp1494_ = vala_void_type_new (NULL);
				_tmp1495_ = _tmp1494_;
				_tmp1496_ = vala_pointer_type_new ((ValaDataType*) _tmp1495_, NULL);
				_tmp1497_ = _tmp1496_;
				_tmp1498_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1497_, TRUE, NULL, TRUE);
				_tmp1499_ = _tmp1498_;
				_vala_code_node_unref0 (_tmp1497_);
				_vala_code_node_unref0 (_tmp1495_);
				temp_var = _tmp1499_;
				_tmp1500_ = temp_var;
				_tmp1501_ = vala_symbol_get_name ((ValaSymbol*) _tmp1500_);
				_tmp1502_ = _tmp1501_;
				_tmp1503_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1502_);
				temp_ref = _tmp1503_;
				_tmp1504_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1504_, FALSE);
				_tmp1505_ = out_arg_map;
				_tmp1506_ = deleg;
				_tmp1507_ = temp_ref;
				_tmp1508_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1507_);
				_tmp1509_ = _tmp1508_;
				vala_map_set ((ValaMap*) _tmp1505_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1506_), FALSE)), (ValaCCodeExpression*) _tmp1509_);
				_vala_ccode_node_unref0 (_tmp1509_);
				_tmp1510_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1510_);
				_tmp1511_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1511_)) {
					ValaDataType* _tmp1512_;
					ValaLocalVariable* _tmp1513_;
					ValaLocalVariable* _tmp1514_;
					const gchar* _tmp1515_;
					const gchar* _tmp1516_;
					ValaCCodeExpression* _tmp1517_;
					ValaLocalVariable* _tmp1518_;
					ValaHashMap* _tmp1519_;
					ValaDelegate* _tmp1520_;
					ValaCCodeExpression* _tmp1521_;
					ValaCCodeUnaryExpression* _tmp1522_;
					ValaCCodeUnaryExpression* _tmp1523_;
					ValaCCodeExpression* _tmp1524_;
					_tmp1512_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1513_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1512_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1513_;
					_tmp1514_ = temp_var;
					_tmp1515_ = vala_symbol_get_name ((ValaSymbol*) _tmp1514_);
					_tmp1516_ = _tmp1515_;
					_tmp1517_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1516_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1517_;
					_tmp1518_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1518_, FALSE);
					_tmp1519_ = out_arg_map;
					_tmp1520_ = deleg;
					_tmp1521_ = temp_ref;
					_tmp1522_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1521_);
					_tmp1523_ = _tmp1522_;
					vala_map_set ((ValaMap*) _tmp1519_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1520_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1523_);
					_vala_ccode_node_unref0 (_tmp1523_);
					_tmp1524_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1524_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1526_ = m;
	if (_tmp1526_ != NULL) {
		ValaMethod* _tmp1527_;
		gboolean _tmp1528_;
		gboolean _tmp1529_;
		_tmp1527_ = m;
		_tmp1528_ = vala_method_get_coroutine (_tmp1527_);
		_tmp1529_ = _tmp1528_;
		_tmp1525_ = _tmp1529_;
	} else {
		_tmp1525_ = FALSE;
	}
	if (_tmp1525_) {
		gboolean _tmp1530_;
		gboolean _tmp1531_;
		_tmp1530_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1531_ = _tmp1530_;
		if (_tmp1531_) {
			ValaHashMap* _tmp1532_;
			ValaMethod* _tmp1533_;
			ValaMethod* _tmp1534_;
			gchar* _tmp1535_;
			gchar* _tmp1536_;
			ValaCCodeIdentifier* _tmp1537_;
			ValaCCodeIdentifier* _tmp1538_;
			ValaHashMap* _tmp1539_;
			ValaCCodeIdentifier* _tmp1540_;
			ValaCCodeIdentifier* _tmp1541_;
			_tmp1532_ = in_arg_map;
			_tmp1533_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1534_ = _tmp1533_;
			_tmp1535_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1534_);
			_tmp1536_ = _tmp1535_;
			_tmp1537_ = vala_ccode_identifier_new (_tmp1536_);
			_tmp1538_ = _tmp1537_;
			vala_map_set ((ValaMap*) _tmp1532_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1538_);
			_vala_ccode_node_unref0 (_tmp1538_);
			_g_free0 (_tmp1536_);
			_tmp1539_ = in_arg_map;
			_tmp1540_ = vala_ccode_identifier_new ("_data_");
			_tmp1541_ = _tmp1540_;
			vala_map_set ((ValaMap*) _tmp1539_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1541_);
			_vala_ccode_node_unref0 (_tmp1541_);
		}
	}
	_tmp1542_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1543_ = _tmp1542_;
	if (_tmp1543_) {
		ValaHashMap* _tmp1544_;
		ValaCCodeExpression* _tmp1545_;
		ValaCCodeExpression* _tmp1546_;
		ValaCCodeUnaryExpression* _tmp1547_;
		ValaCCodeUnaryExpression* _tmp1548_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1544_ = out_arg_map;
		_tmp1545_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
		_tmp1546_ = _tmp1545_;
		_tmp1547_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1546_);
		_tmp1548_ = _tmp1547_;
		vala_map_set ((ValaMap*) _tmp1544_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1548_);
		_vala_ccode_node_unref0 (_tmp1548_);
		_vala_ccode_node_unref0 (_tmp1546_);
	} else {
		gboolean _tmp1549_ = FALSE;
		gboolean _tmp1550_ = FALSE;
		ValaMethod* _tmp1551_;
		_tmp1551_ = m;
		if (_tmp1551_ != NULL) {
			ValaMethod* _tmp1552_;
			_tmp1552_ = m;
			_tmp1550_ = vala_method_has_error_type_parameter (_tmp1552_);
		} else {
			_tmp1550_ = FALSE;
		}
		if (_tmp1550_) {
			ValaCCodeFunctionCall* _tmp1553_;
			ValaCCodeFunctionCall* _tmp1554_;
			_tmp1553_ = async_call;
			_tmp1554_ = ccall;
			_tmp1549_ = _tmp1553_ != _tmp1554_;
		} else {
			_tmp1549_ = FALSE;
		}
		if (_tmp1549_) {
			ValaHashMap* _tmp1555_;
			ValaCCodeConstant* _tmp1556_;
			ValaCCodeConstant* _tmp1557_;
			_tmp1555_ = out_arg_map;
			_tmp1556_ = vala_ccode_constant_new ("NULL");
			_tmp1557_ = _tmp1556_;
			vala_map_set ((ValaMap*) _tmp1555_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1557_);
			_vala_ccode_node_unref0 (_tmp1557_);
		}
	}
	_tmp1558_ = ellipsis;
	if (_tmp1558_) {
		ValaMethod* _tmp1559_;
		_tmp1559_ = m;
		if (_tmp1559_ == NULL) {
			ValaHashMap* _tmp1560_;
			ValaCCodeConstant* _tmp1561_;
			ValaCCodeConstant* _tmp1562_;
			_tmp1560_ = in_arg_map;
			_tmp1561_ = vala_ccode_constant_new ("NULL");
			_tmp1562_ = _tmp1561_;
			vala_map_set ((ValaMap*) _tmp1560_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1562_);
			_vala_ccode_node_unref0 (_tmp1562_);
		} else {
			gboolean _tmp1563_ = FALSE;
			gboolean _tmp1564_ = FALSE;
			gboolean _tmp1565_ = FALSE;
			ValaMethod* _tmp1566_;
			gboolean _tmp1567_;
			gboolean _tmp1568_;
			_tmp1566_ = m;
			_tmp1567_ = vala_method_get_printf_format (_tmp1566_);
			_tmp1568_ = _tmp1567_;
			if (!_tmp1568_) {
				ValaMethod* _tmp1569_;
				gboolean _tmp1570_;
				gboolean _tmp1571_;
				_tmp1569_ = m;
				_tmp1570_ = vala_method_get_scanf_format (_tmp1569_);
				_tmp1571_ = _tmp1570_;
				_tmp1565_ = !_tmp1571_;
			} else {
				_tmp1565_ = FALSE;
			}
			if (_tmp1565_) {
				ValaMethod* _tmp1572_;
				gchar* _tmp1573_;
				gchar* _tmp1574_;
				_tmp1572_ = m;
				_tmp1573_ = vala_get_ccode_sentinel (_tmp1572_);
				_tmp1574_ = _tmp1573_;
				_tmp1564_ = g_strcmp0 (_tmp1574_, "") != 0;
				_g_free0 (_tmp1574_);
			} else {
				_tmp1564_ = FALSE;
			}
			if (_tmp1564_) {
				gboolean _tmp1575_;
				gboolean _tmp1576_;
				_tmp1575_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1576_ = _tmp1575_;
				_tmp1563_ = !_tmp1576_;
			} else {
				_tmp1563_ = FALSE;
			}
			if (_tmp1563_) {
				ValaHashMap* _tmp1577_;
				ValaMethod* _tmp1578_;
				gchar* _tmp1579_;
				gchar* _tmp1580_;
				ValaCCodeConstant* _tmp1581_;
				ValaCCodeConstant* _tmp1582_;
				_tmp1577_ = in_arg_map;
				_tmp1578_ = m;
				_tmp1579_ = vala_get_ccode_sentinel (_tmp1578_);
				_tmp1580_ = _tmp1579_;
				_tmp1581_ = vala_ccode_constant_new (_tmp1580_);
				_tmp1582_ = _tmp1581_;
				vala_map_set ((ValaMap*) _tmp1577_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1582_);
				_vala_ccode_node_unref0 (_tmp1582_);
				_g_free0 (_tmp1580_);
			}
		}
	}
	_tmp1583_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1583_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1584_;
		ValaDelegateType* _tmp1585_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1586_;
		ValaDelegate* _tmp1587_;
		ValaDelegate* _tmp1588_;
		ValaDelegate* _tmp1589_;
		ValaDelegate* _tmp1590_;
		gboolean _tmp1591_;
		gboolean _tmp1592_;
		_tmp1584_ = itype;
		_tmp1585_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1584_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1585_;
		_tmp1586_ = deleg_type;
		_tmp1587_ = vala_delegate_type_get_delegate_symbol (_tmp1586_);
		_tmp1588_ = _tmp1587_;
		_tmp1589_ = _vala_code_node_ref0 (_tmp1588_);
		d = _tmp1589_;
		_tmp1590_ = d;
		_tmp1591_ = vala_delegate_get_has_target (_tmp1590_);
		_tmp1592_ = _tmp1591_;
		if (_tmp1592_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1593_;
			ValaDelegate* _tmp1594_;
			ValaExpression* _tmp1595_;
			ValaExpression* _tmp1596_;
			ValaCCodeExpression* _tmp1597_ = NULL;
			ValaCCodeExpression* _tmp1598_;
			ValaCCodeExpression* _tmp1599_;
			ValaHashMap* _tmp1600_;
			ValaDelegate* _tmp1601_;
			ValaExpression* _tmp1602_;
			ValaExpression* _tmp1603_;
			ValaCCodeExpression* _tmp1604_ = NULL;
			ValaCCodeExpression* _tmp1605_;
			ValaCCodeExpression* _tmp1606_;
			_tmp1593_ = in_arg_map;
			_tmp1594_ = d;
			_tmp1595_ = vala_method_call_get_call (expr);
			_tmp1596_ = _tmp1595_;
			_tmp1598_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1596_, &_tmp1597_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1597_;
			_tmp1599_ = _tmp1598_;
			vala_map_set ((ValaMap*) _tmp1593_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1594_), FALSE)), _tmp1599_);
			_vala_ccode_node_unref0 (_tmp1599_);
			_tmp1600_ = out_arg_map;
			_tmp1601_ = d;
			_tmp1602_ = vala_method_call_get_call (expr);
			_tmp1603_ = _tmp1602_;
			_tmp1605_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1603_, &_tmp1604_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1604_;
			_tmp1606_ = _tmp1605_;
			vala_map_set ((ValaMap*) _tmp1600_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1601_), FALSE)), _tmp1606_);
			_vala_ccode_node_unref0 (_tmp1606_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1607_ = itype;
	_tmp1608_ = vala_data_type_get_return_type (_tmp1607_);
	_tmp1609_ = _tmp1608_;
	_tmp1610_ = vala_data_type_is_real_non_null_struct_type (_tmp1609_);
	_vala_code_node_unref0 (_tmp1609_);
	return_result_via_out_param = _tmp1610_;
	_tmp1612_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1612_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1613_;
		ValaDataType* _tmp1614_;
		ValaDataType* _tmp1615_;
		_tmp1613_ = itype;
		_tmp1614_ = vala_data_type_get_return_type (_tmp1613_);
		_tmp1615_ = _tmp1614_;
		_tmp1611_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1615_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1615_);
	} else {
		_tmp1611_ = FALSE;
	}
	if (_tmp1611_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1616_;
		ValaSignal* _tmp1617_;
		ValaSignal* _tmp1618_;
		ValaSignal* _tmp1619_;
		gboolean _tmp1620_ = FALSE;
		gboolean _tmp1621_ = FALSE;
		ValaMemberAccess* _tmp1622_;
		_tmp1616_ = itype;
		_tmp1617_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1616_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1618_ = _tmp1617_;
		_tmp1619_ = _vala_code_node_ref0 (_tmp1618_);
		sig = _tmp1619_;
		_tmp1622_ = ma;
		if (_tmp1622_ != NULL) {
			ValaMemberAccess* _tmp1623_;
			ValaExpression* _tmp1624_;
			ValaExpression* _tmp1625_;
			_tmp1623_ = ma;
			_tmp1624_ = vala_member_access_get_inner (_tmp1623_);
			_tmp1625_ = _tmp1624_;
			_tmp1621_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1625_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1621_ = FALSE;
		}
		if (_tmp1621_) {
			ValaSignal* _tmp1626_;
			gboolean _tmp1627_;
			gboolean _tmp1628_;
			_tmp1626_ = sig;
			_tmp1627_ = vala_signal_get_is_virtual (_tmp1626_);
			_tmp1628_ = _tmp1627_;
			_tmp1620_ = _tmp1628_;
		} else {
			_tmp1620_ = FALSE;
		}
		if (_tmp1620_) {
		} else {
			gboolean _tmp1629_ = FALSE;
			ValaSignal* _tmp1630_;
			_tmp1630_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1630_)) {
				_tmp1629_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1631_;
				ValaSourceReference* _tmp1632_;
				ValaSourceReference* _tmp1633_;
				ValaSourceFile* _tmp1634_;
				ValaSourceFile* _tmp1635_;
				ValaSignal* _tmp1636_;
				ValaSourceReference* _tmp1637_;
				ValaSourceReference* _tmp1638_;
				ValaSourceFile* _tmp1639_;
				ValaSourceFile* _tmp1640_;
				_tmp1631_ = ma;
				_tmp1632_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1631_);
				_tmp1633_ = _tmp1632_;
				_tmp1634_ = vala_source_reference_get_file (_tmp1633_);
				_tmp1635_ = _tmp1634_;
				_tmp1636_ = sig;
				_tmp1637_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1636_);
				_tmp1638_ = _tmp1637_;
				_tmp1639_ = vala_source_reference_get_file (_tmp1638_);
				_tmp1640_ = _tmp1639_;
				_tmp1629_ = _tmp1635_ == _tmp1640_;
			}
			if (_tmp1629_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1641_ = async_call;
	_tmp1642_ = ccall;
	if (_tmp1641_ == _tmp1642_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	_tmp1643_ = return_result_via_out_param;
	if (_tmp1643_) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1644_;
		ValaDataType* _tmp1645_;
		ValaDataType* _tmp1646_;
		ValaLocalVariable* _tmp1647_;
		ValaLocalVariable* _tmp1648_;
		ValaLocalVariable* _tmp1649_;
		const gchar* _tmp1650_;
		const gchar* _tmp1651_;
		ValaCCodeExpression* _tmp1652_;
		ValaLocalVariable* _tmp1653_;
		ValaHashMap* _tmp1654_;
		ValaCCodeExpression* _tmp1655_;
		ValaCCodeUnaryExpression* _tmp1656_;
		ValaCCodeUnaryExpression* _tmp1657_;
		_tmp1644_ = itype;
		_tmp1645_ = vala_data_type_get_return_type (_tmp1644_);
		_tmp1646_ = _tmp1645_;
		_tmp1647_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1646_, TRUE, NULL, TRUE);
		_tmp1648_ = _tmp1647_;
		_vala_code_node_unref0 (_tmp1646_);
		out_param_var = _tmp1648_;
		_tmp1649_ = out_param_var;
		_tmp1650_ = vala_symbol_get_name ((ValaSymbol*) _tmp1649_);
		_tmp1651_ = _tmp1650_;
		_tmp1652_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1651_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1652_;
		_tmp1653_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1653_, FALSE);
		_tmp1654_ = out_arg_map;
		_tmp1655_ = out_param_ref;
		_tmp1656_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1655_);
		_tmp1657_ = _tmp1656_;
		vala_map_set ((ValaMap*) _tmp1654_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1657_);
		_vala_ccode_node_unref0 (_tmp1657_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1658_ = async_call;
	_tmp1659_ = ccall;
	if (_tmp1658_ != _tmp1659_) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1676_;
			ValaCCodeFunctionCall* _tmp1677_;
			ValaHashMap* _tmp1678_;
			gint _tmp1679_;
			gpointer _tmp1680_;
			ValaCCodeExpression* _tmp1681_;
			gint _tmp1682_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1660_;
				ValaSet* _tmp1661_;
				ValaSet* _tmp1662_;
				ValaIterator* _tmp1663_;
				ValaIterator* _tmp1664_;
				_tmp1660_ = out_arg_map;
				_tmp1661_ = vala_map_get_keys ((ValaMap*) _tmp1660_);
				_tmp1662_ = _tmp1661_;
				_tmp1663_ = vala_iterable_iterator ((ValaIterable*) _tmp1662_);
				_tmp1664_ = _tmp1663_;
				_vala_iterable_unref0 (_tmp1662_);
				_pos_it = _tmp1664_;
				while (TRUE) {
					ValaIterator* _tmp1665_;
					gint pos = 0;
					ValaIterator* _tmp1666_;
					gpointer _tmp1667_;
					gboolean _tmp1668_ = FALSE;
					gint _tmp1669_;
					gint _tmp1670_;
					_tmp1665_ = _pos_it;
					if (!vala_iterator_next (_tmp1665_)) {
						break;
					}
					_tmp1666_ = _pos_it;
					_tmp1667_ = vala_iterator_get (_tmp1666_);
					pos = (gint) ((gintptr) _tmp1667_);
					_tmp1669_ = pos;
					_tmp1670_ = last_pos;
					if (_tmp1669_ > _tmp1670_) {
						gboolean _tmp1671_ = FALSE;
						gint _tmp1672_;
						_tmp1672_ = min_pos;
						if (_tmp1672_ == -1) {
							_tmp1671_ = TRUE;
						} else {
							gint _tmp1673_;
							gint _tmp1674_;
							_tmp1673_ = pos;
							_tmp1674_ = min_pos;
							_tmp1671_ = _tmp1673_ < _tmp1674_;
						}
						_tmp1668_ = _tmp1671_;
					} else {
						_tmp1668_ = FALSE;
					}
					if (_tmp1668_) {
						gint _tmp1675_;
						_tmp1675_ = pos;
						min_pos = _tmp1675_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1676_ = min_pos;
			if (_tmp1676_ == -1) {
				break;
			}
			_tmp1677_ = ccall;
			_tmp1678_ = out_arg_map;
			_tmp1679_ = min_pos;
			_tmp1680_ = vala_map_get ((ValaMap*) _tmp1678_, (gpointer) ((gintptr) _tmp1679_));
			_tmp1681_ = (ValaCCodeExpression*) _tmp1680_;
			vala_ccode_function_call_add_argument (_tmp1677_, _tmp1681_);
			_vala_ccode_node_unref0 (_tmp1681_);
			_tmp1682_ = min_pos;
			last_pos = _tmp1682_;
		}
	}
	_tmp1683_ = async_call;
	if (_tmp1683_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1700_;
			ValaCCodeFunctionCall* _tmp1701_;
			ValaHashMap* _tmp1702_;
			gint _tmp1703_;
			gpointer _tmp1704_;
			ValaCCodeExpression* _tmp1705_;
			gint _tmp1706_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1684_;
				ValaSet* _tmp1685_;
				ValaSet* _tmp1686_;
				ValaIterator* _tmp1687_;
				ValaIterator* _tmp1688_;
				_tmp1684_ = in_arg_map;
				_tmp1685_ = vala_map_get_keys ((ValaMap*) _tmp1684_);
				_tmp1686_ = _tmp1685_;
				_tmp1687_ = vala_iterable_iterator ((ValaIterable*) _tmp1686_);
				_tmp1688_ = _tmp1687_;
				_vala_iterable_unref0 (_tmp1686_);
				_pos_it = _tmp1688_;
				while (TRUE) {
					ValaIterator* _tmp1689_;
					gint pos = 0;
					ValaIterator* _tmp1690_;
					gpointer _tmp1691_;
					gboolean _tmp1692_ = FALSE;
					gint _tmp1693_;
					gint _tmp1694_;
					_tmp1689_ = _pos_it;
					if (!vala_iterator_next (_tmp1689_)) {
						break;
					}
					_tmp1690_ = _pos_it;
					_tmp1691_ = vala_iterator_get (_tmp1690_);
					pos = (gint) ((gintptr) _tmp1691_);
					_tmp1693_ = pos;
					_tmp1694_ = last_pos;
					if (_tmp1693_ > _tmp1694_) {
						gboolean _tmp1695_ = FALSE;
						gint _tmp1696_;
						_tmp1696_ = min_pos;
						if (_tmp1696_ == -1) {
							_tmp1695_ = TRUE;
						} else {
							gint _tmp1697_;
							gint _tmp1698_;
							_tmp1697_ = pos;
							_tmp1698_ = min_pos;
							_tmp1695_ = _tmp1697_ < _tmp1698_;
						}
						_tmp1692_ = _tmp1695_;
					} else {
						_tmp1692_ = FALSE;
					}
					if (_tmp1692_) {
						gint _tmp1699_;
						_tmp1699_ = pos;
						min_pos = _tmp1699_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1700_ = min_pos;
			if (_tmp1700_ == -1) {
				break;
			}
			_tmp1701_ = async_call;
			_tmp1702_ = in_arg_map;
			_tmp1703_ = min_pos;
			_tmp1704_ = vala_map_get ((ValaMap*) _tmp1702_, (gpointer) ((gintptr) _tmp1703_));
			_tmp1705_ = (ValaCCodeExpression*) _tmp1704_;
			vala_ccode_function_call_add_argument (_tmp1701_, _tmp1705_);
			_vala_ccode_node_unref0 (_tmp1705_);
			_tmp1706_ = min_pos;
			last_pos = _tmp1706_;
		}
	}
	_tmp1707_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1708_ = _tmp1707_;
	if (_tmp1708_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1709_;
		gint _tmp1710_;
		ValaCCodeFunction* _tmp1711_;
		ValaCCodeFunction* _tmp1712_;
		ValaCCodeIdentifier* _tmp1713_;
		ValaCCodeIdentifier* _tmp1714_;
		ValaCCodeMemberAccess* _tmp1715_;
		ValaCCodeMemberAccess* _tmp1716_;
		gint _tmp1717_;
		gchar* _tmp1718_;
		gchar* _tmp1719_;
		ValaCCodeConstant* _tmp1720_;
		ValaCCodeConstant* _tmp1721_;
		ValaCCodeFunction* _tmp1722_;
		ValaCCodeFunction* _tmp1723_;
		ValaCCodeFunctionCall* _tmp1724_;
		ValaCCodeFunction* _tmp1725_;
		ValaCCodeFunction* _tmp1726_;
		ValaCCodeConstant* _tmp1727_;
		ValaCCodeConstant* _tmp1728_;
		ValaCCodeFunction* _tmp1729_;
		ValaCCodeFunction* _tmp1730_;
		gint _tmp1731_;
		gchar* _tmp1732_;
		gchar* _tmp1733_;
		_tmp1709_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1710_ = _tmp1709_->next_coroutine_state;
		_tmp1709_->next_coroutine_state = _tmp1710_ + 1;
		state = _tmp1710_;
		_tmp1711_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1712_ = _tmp1711_;
		_tmp1713_ = vala_ccode_identifier_new ("_data_");
		_tmp1714_ = _tmp1713_;
		_tmp1715_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1714_, "_state_");
		_tmp1716_ = _tmp1715_;
		_tmp1717_ = state;
		_tmp1718_ = g_strdup_printf ("%i", _tmp1717_);
		_tmp1719_ = _tmp1718_;
		_tmp1720_ = vala_ccode_constant_new (_tmp1719_);
		_tmp1721_ = _tmp1720_;
		vala_ccode_function_add_assignment (_tmp1712_, (ValaCCodeExpression*) _tmp1716_, (ValaCCodeExpression*) _tmp1721_);
		_vala_ccode_node_unref0 (_tmp1721_);
		_g_free0 (_tmp1719_);
		_vala_ccode_node_unref0 (_tmp1716_);
		_vala_ccode_node_unref0 (_tmp1714_);
		_tmp1722_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1723_ = _tmp1722_;
		_tmp1724_ = async_call;
		vala_ccode_function_add_expression (_tmp1723_, (ValaCCodeExpression*) _tmp1724_);
		_tmp1725_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1726_ = _tmp1725_;
		_tmp1727_ = vala_ccode_constant_new ("FALSE");
		_tmp1728_ = _tmp1727_;
		vala_ccode_function_add_return (_tmp1726_, (ValaCCodeExpression*) _tmp1728_);
		_vala_ccode_node_unref0 (_tmp1728_);
		_tmp1729_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1730_ = _tmp1729_;
		_tmp1731_ = state;
		_tmp1732_ = g_strdup_printf ("_state_%d", _tmp1731_);
		_tmp1733_ = _tmp1732_;
		vala_ccode_function_add_label (_tmp1730_, _tmp1733_);
		_g_free0 (_tmp1733_);
	}
	_tmp1734_ = vala_method_call_get_is_assert (expr);
	_tmp1735_ = _tmp1734_;
	if (_tmp1735_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1736_;
		ValaSourceReference* _tmp1737_;
		ValaSourceLocation _tmp1738_ = {0};
		ValaSourceLocation _tmp1739_;
		gchar* _tmp1740_;
		ValaSourceReference* _tmp1741_;
		ValaSourceReference* _tmp1742_;
		ValaSourceLocation _tmp1743_ = {0};
		ValaSourceLocation _tmp1744_;
		gchar* _tmp1745_;
		ValaSourceReference* _tmp1746_;
		ValaSourceReference* _tmp1747_;
		ValaSourceLocation _tmp1748_ = {0};
		ValaSourceLocation _tmp1749_;
		gchar* _tmp1750_;
		gchar* _tmp1751_;
		ValaCCodeFunctionCall* _tmp1752_;
		ValaCCodeIdentifier* _tmp1753_;
		ValaCCodeIdentifier* _tmp1754_;
		ValaCCodeFunctionCall* _tmp1755_;
		const gchar* _tmp1756_;
		gchar* _tmp1757_;
		gchar* _tmp1758_;
		gchar* _tmp1759_;
		gchar* _tmp1760_;
		gchar* _tmp1761_;
		gchar* _tmp1762_;
		ValaCCodeConstant* _tmp1763_;
		ValaCCodeConstant* _tmp1764_;
		_tmp1736_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1737_ = _tmp1736_;
		vala_source_reference_get_begin (_tmp1737_, &_tmp1738_);
		_tmp1739_ = _tmp1738_;
		_tmp1740_ = _tmp1739_.pos;
		_tmp1741_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1742_ = _tmp1741_;
		vala_source_reference_get_end (_tmp1742_, &_tmp1743_);
		_tmp1744_ = _tmp1743_;
		_tmp1745_ = _tmp1744_.pos;
		_tmp1746_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1747_ = _tmp1746_;
		vala_source_reference_get_begin (_tmp1747_, &_tmp1748_);
		_tmp1749_ = _tmp1748_;
		_tmp1750_ = _tmp1749_.pos;
		_tmp1751_ = string_substring ((const gchar*) _tmp1740_, (glong) 0, (glong) ((gint) (_tmp1745_ - _tmp1750_)));
		message = _tmp1751_;
		_tmp1752_ = ccall;
		_tmp1753_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1754_ = _tmp1753_;
		vala_ccode_function_call_set_call (_tmp1752_, (ValaCCodeExpression*) _tmp1754_);
		_vala_ccode_node_unref0 (_tmp1754_);
		_tmp1755_ = ccall;
		_tmp1756_ = message;
		_tmp1757_ = string_replace (_tmp1756_, "\n", " ");
		_tmp1758_ = _tmp1757_;
		_tmp1759_ = g_strescape (_tmp1758_, "");
		_tmp1760_ = _tmp1759_;
		_tmp1761_ = g_strdup_printf ("\"%s\"", _tmp1760_);
		_tmp1762_ = _tmp1761_;
		_tmp1763_ = vala_ccode_constant_new (_tmp1762_);
		_tmp1764_ = _tmp1763_;
		vala_ccode_function_call_add_argument (_tmp1755_, (ValaCCodeExpression*) _tmp1764_);
		_vala_ccode_node_unref0 (_tmp1764_);
		_g_free0 (_tmp1762_);
		_g_free0 (_tmp1760_);
		_g_free0 (_tmp1758_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	_tmp1765_ = return_result_via_out_param;
	if (_tmp1765_) {
		ValaCCodeFunction* _tmp1766_;
		ValaCCodeFunction* _tmp1767_;
		ValaCCodeExpression* _tmp1768_;
		ValaCCodeExpression* _tmp1769_;
		ValaCCodeExpression* _tmp1770_;
		_tmp1766_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1767_ = _tmp1766_;
		_tmp1768_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1767_, _tmp1768_);
		_tmp1769_ = out_param_ref;
		_tmp1770_ = _vala_ccode_node_ref0 (_tmp1769_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1770_;
	}
	_tmp1773_ = m;
	if (_tmp1773_ != NULL) {
		ValaMethod* _tmp1774_;
		ValaMemberBinding _tmp1775_;
		ValaMemberBinding _tmp1776_;
		_tmp1774_ = m;
		_tmp1775_ = vala_method_get_binding (_tmp1774_);
		_tmp1776_ = _tmp1775_;
		_tmp1772_ = _tmp1776_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1772_ = FALSE;
	}
	if (_tmp1772_) {
		ValaMethod* _tmp1777_;
		gboolean _tmp1778_;
		gboolean _tmp1779_;
		_tmp1777_ = m;
		_tmp1778_ = vala_method_get_returns_modified_pointer (_tmp1777_);
		_tmp1779_ = _tmp1778_;
		_tmp1771_ = _tmp1779_;
	} else {
		_tmp1771_ = FALSE;
	}
	if (_tmp1771_) {
		gboolean _tmp1780_ = FALSE;
		gboolean _tmp1781_ = FALSE;
		ValaMemberAccess* _tmp1782_;
		_tmp1782_ = ma;
		if (_tmp1782_ != NULL) {
			ValaMemberAccess* _tmp1783_;
			ValaExpression* _tmp1784_;
			ValaExpression* _tmp1785_;
			ValaSymbol* _tmp1786_;
			ValaSymbol* _tmp1787_;
			_tmp1783_ = ma;
			_tmp1784_ = vala_member_access_get_inner (_tmp1783_);
			_tmp1785_ = _tmp1784_;
			_tmp1786_ = vala_expression_get_symbol_reference (_tmp1785_);
			_tmp1787_ = _tmp1786_;
			_tmp1781_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1787_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1781_ = FALSE;
		}
		if (_tmp1781_) {
			ValaMemberAccess* _tmp1788_;
			ValaExpression* _tmp1789_;
			ValaExpression* _tmp1790_;
			_tmp1788_ = ma;
			_tmp1789_ = vala_member_access_get_inner (_tmp1788_);
			_tmp1790_ = _tmp1789_;
			_tmp1780_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1790_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1780_ = FALSE;
		}
		if (_tmp1780_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1791_;
			ValaExpression* _tmp1792_;
			ValaExpression* _tmp1793_;
			ValaSymbol* _tmp1794_;
			ValaSymbol* _tmp1795_;
			ValaProperty* _tmp1796_;
			ValaProperty* _tmp1797_;
			ValaMemberAccess* _tmp1798_;
			ValaExpression* _tmp1799_;
			ValaExpression* _tmp1800_;
			ValaExpression* _tmp1801_;
			ValaExpression* _tmp1802_;
			ValaDataType* _tmp1803_;
			ValaDataType* _tmp1804_;
			ValaCCodeExpression* _tmp1805_;
			ValaGLibValue* _tmp1806_;
			ValaGLibValue* _tmp1807_;
			_tmp1791_ = ma;
			_tmp1792_ = vala_member_access_get_inner (_tmp1791_);
			_tmp1793_ = _tmp1792_;
			_tmp1794_ = vala_expression_get_symbol_reference (_tmp1793_);
			_tmp1795_ = _tmp1794_;
			_tmp1796_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1795_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1796_;
			_tmp1797_ = prop;
			_tmp1798_ = ma;
			_tmp1799_ = vala_member_access_get_inner (_tmp1798_);
			_tmp1800_ = _tmp1799_;
			_tmp1801_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1800_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1802_ = _tmp1801_;
			_tmp1803_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1804_ = _tmp1803_;
			_tmp1805_ = ccall_expr;
			_tmp1806_ = vala_glib_value_new (_tmp1804_, _tmp1805_, FALSE);
			_tmp1807_ = _tmp1806_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1797_, _tmp1802_, (ValaTargetValue*) _tmp1807_);
			_vala_target_value_unref0 (_tmp1807_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1808_;
			ValaCCodeExpression* _tmp1809_;
			ValaCCodeAssignment* _tmp1810_;
			_tmp1808_ = instance;
			_tmp1809_ = ccall_expr;
			_tmp1810_ = vala_ccode_assignment_new (_tmp1808_, _tmp1809_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1810_;
		}
	}
	_tmp1813_ = m;
	if (_tmp1813_ != NULL) {
		ValaMethod* _tmp1814_;
		gchar* _tmp1815_;
		gchar* _tmp1816_;
		_tmp1814_ = m;
		_tmp1815_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1814_);
		_tmp1816_ = _tmp1815_;
		_tmp1812_ = _tmp1816_ != NULL;
		_g_free0 (_tmp1816_);
	} else {
		_tmp1812_ = FALSE;
	}
	if (_tmp1812_) {
		ValaMethod* _tmp1817_;
		gchar* _tmp1818_;
		gchar* _tmp1819_;
		ValaMethod* _tmp1820_;
		ValaDataType* _tmp1821_;
		ValaDataType* _tmp1822_;
		gchar* _tmp1823_;
		gchar* _tmp1824_;
		_tmp1817_ = m;
		_tmp1818_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1817_);
		_tmp1819_ = _tmp1818_;
		_tmp1820_ = m;
		_tmp1821_ = vala_callable_get_return_type ((ValaCallable*) _tmp1820_);
		_tmp1822_ = _tmp1821_;
		_tmp1823_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1822_);
		_tmp1824_ = _tmp1823_;
		_tmp1811_ = g_strcmp0 (_tmp1819_, _tmp1824_) != 0;
		_g_free0 (_tmp1824_);
		_g_free0 (_tmp1819_);
	} else {
		_tmp1811_ = FALSE;
	}
	if (_tmp1811_) {
		ValaCCodeExpression* _tmp1825_;
		ValaMethod* _tmp1826_;
		ValaDataType* _tmp1827_;
		ValaDataType* _tmp1828_;
		gchar* _tmp1829_;
		gchar* _tmp1830_;
		ValaCCodeCastExpression* _tmp1831_;
		_tmp1825_ = ccall_expr;
		_tmp1826_ = m;
		_tmp1827_ = vala_callable_get_return_type ((ValaCallable*) _tmp1826_);
		_tmp1828_ = _tmp1827_;
		_tmp1829_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1828_);
		_tmp1830_ = _tmp1829_;
		_tmp1831_ = vala_ccode_cast_expression_new (_tmp1825_, _tmp1830_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1831_;
		_g_free0 (_tmp1830_);
	}
	_tmp1832_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1832_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1833_;
		ValaList* _tmp1834_;
		ValaIterator* _tmp1835_;
		ValaIterator* _tmp1836_;
		ValaIterator* _tmp1837_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1838_;
		gpointer _tmp1839_;
		ValaExpression* _tmp1840_;
		ValaCCodeExpression* _tmp1841_;
		ValaCCodeExpression* _tmp1842_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1843_;
		ValaLocalVariable* _tmp1844_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1845_;
		const gchar* _tmp1846_;
		const gchar* _tmp1847_;
		ValaCCodeExpression* _tmp1848_;
		ValaLocalVariable* _tmp1849_;
		ValaCCodeFile* _tmp1850_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1851_;
		ValaExpression* _tmp1852_;
		ValaExpression* _tmp1853_;
		ValaCCodeExpression* _tmp1854_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1855_;
		ValaExpression* _tmp1856_;
		ValaExpression* _tmp1857_;
		ValaCCodeExpression* _tmp1858_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1859_;
		ValaExpression* _tmp1860_;
		ValaExpression* _tmp1861_;
		ValaDataType* _tmp1862_;
		ValaDataType* _tmp1863_;
		ValaArrayType* _tmp1864_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1865_;
		ValaDataType* _tmp1866_;
		ValaDataType* _tmp1867_;
		gchar* _tmp1868_;
		gchar* _tmp1869_;
		gchar* _tmp1870_;
		gchar* _tmp1871_;
		ValaCCodeIdentifier* _tmp1872_;
		ValaCCodeIdentifier* _tmp1873_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1874_;
		ValaCCodeExpression* _tmp1875_;
		ValaCCodeBinaryExpression* _tmp1876_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1877_;
		ValaCCodeExpression* _tmp1878_;
		ValaCCodeBinaryExpression* _tmp1879_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1880_;
		ValaCCodeIdentifier* _tmp1881_;
		ValaCCodeFunctionCall* _tmp1882_;
		ValaCCodeFunctionCall* _tmp1883_;
		ValaCCodeFunctionCall* _tmp1884_;
		ValaCCodeExpression* _tmp1885_;
		ValaCCodeExpression* _tmp1886_;
		ValaCCodeBinaryExpression* _tmp1887_;
		ValaCCodeBinaryExpression* _tmp1888_;
		ValaCCodeFunctionCall* _tmp1889_;
		ValaCCodeConstant* _tmp1890_;
		ValaCCodeConstant* _tmp1891_;
		ValaCCodeFunctionCall* _tmp1892_;
		ValaCCodeIdentifier* _tmp1893_;
		ValaCCodeBinaryExpression* _tmp1894_;
		ValaCCodeBinaryExpression* _tmp1895_;
		ValaCCodeBinaryExpression* _tmp1896_;
		ValaCCodeFunction* _tmp1897_;
		ValaCCodeFunction* _tmp1898_;
		ValaCCodeExpression* _tmp1899_;
		ValaCCodeExpression* _tmp1900_;
		ValaCCodeFunction* _tmp1901_;
		ValaCCodeFunction* _tmp1902_;
		ValaCCodeExpression* _tmp1903_;
		ValaCCodeFunction* _tmp1904_;
		ValaCCodeFunction* _tmp1905_;
		ValaCCodeBinaryExpression* _tmp1906_;
		ValaCCodeFunctionCall* _tmp1907_;
		ValaCCodeConstant* _tmp1908_;
		ValaCCodeConstant* _tmp1909_;
		ValaCCodeConditionalExpression* _tmp1910_;
		ValaCCodeConditionalExpression* _tmp1911_;
		ValaCCodeFunction* _tmp1912_;
		ValaCCodeFunction* _tmp1913_;
		ValaMemberAccess* _tmp1914_;
		ValaExpression* _tmp1915_;
		ValaExpression* _tmp1916_;
		ValaCCodeExpression* _tmp1917_;
		ValaCCodeExpression* _tmp1918_;
		ValaCCodeExpression* _tmp1919_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1920_;
		ValaExpression* _tmp1921_;
		ValaExpression* _tmp1922_;
		ValaSymbol* _tmp1923_;
		ValaSymbol* _tmp1924_;
		ValaSymbol* _tmp1925_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1926_;
		ValaLocalVariable* _tmp1927_;
		gboolean _tmp1928_ = FALSE;
		gboolean _tmp1929_ = FALSE;
		ValaSymbol* _tmp1930_;
		_tmp1833_ = vala_method_call_get_argument_list (expr);
		_tmp1834_ = _tmp1833_;
		_tmp1835_ = vala_iterable_iterator ((ValaIterable*) _tmp1834_);
		_tmp1836_ = _tmp1835_;
		_vala_iterable_unref0 (_tmp1834_);
		arg_it = _tmp1836_;
		_tmp1837_ = arg_it;
		vala_iterator_next (_tmp1837_);
		_tmp1838_ = arg_it;
		_tmp1839_ = vala_iterator_get (_tmp1838_);
		_tmp1840_ = (ValaExpression*) _tmp1839_;
		_tmp1841_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1840_);
		_tmp1842_ = _tmp1841_;
		_vala_code_node_unref0 (_tmp1840_);
		new_size = _tmp1842_;
		_tmp1843_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1844_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1843_, TRUE, NULL, FALSE);
		temp_decl = _tmp1844_;
		_tmp1845_ = temp_decl;
		_tmp1846_ = vala_symbol_get_name ((ValaSymbol*) _tmp1845_);
		_tmp1847_ = _tmp1846_;
		_tmp1848_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1847_);
		temp_ref = _tmp1848_;
		_tmp1849_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1849_, FALSE);
		_tmp1850_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1850_, "string.h", FALSE);
		_tmp1851_ = ma;
		_tmp1852_ = vala_member_access_get_inner (_tmp1851_);
		_tmp1853_ = _tmp1852_;
		_tmp1854_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1853_, 1);
		clen = _tmp1854_;
		_tmp1855_ = ma;
		_tmp1856_ = vala_member_access_get_inner (_tmp1855_);
		_tmp1857_ = _tmp1856_;
		_tmp1858_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1857_);
		celems = _tmp1858_;
		_tmp1859_ = ma;
		_tmp1860_ = vala_member_access_get_inner (_tmp1859_);
		_tmp1861_ = _tmp1860_;
		_tmp1862_ = vala_expression_get_value_type (_tmp1861_);
		_tmp1863_ = _tmp1862_;
		_tmp1864_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1863_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1864_;
		_tmp1865_ = array_type;
		_tmp1866_ = vala_array_type_get_element_type (_tmp1865_);
		_tmp1867_ = _tmp1866_;
		_tmp1868_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1867_);
		_tmp1869_ = _tmp1868_;
		_tmp1870_ = g_strdup_printf ("sizeof (%s)", _tmp1869_);
		_tmp1871_ = _tmp1870_;
		_tmp1872_ = vala_ccode_identifier_new (_tmp1871_);
		_tmp1873_ = _tmp1872_;
		_g_free0 (_tmp1871_);
		_g_free0 (_tmp1869_);
		csizeof = _tmp1873_;
		_tmp1874_ = temp_ref;
		_tmp1875_ = clen;
		_tmp1876_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1874_, _tmp1875_);
		cdelta = _tmp1876_;
		_tmp1877_ = temp_ref;
		_tmp1878_ = clen;
		_tmp1879_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1877_, _tmp1878_);
		ccheck = _tmp1879_;
		_tmp1880_ = vala_ccode_identifier_new ("memset");
		_tmp1881_ = _tmp1880_;
		_tmp1882_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1881_);
		_tmp1883_ = _tmp1882_;
		_vala_ccode_node_unref0 (_tmp1881_);
		czero = _tmp1883_;
		_tmp1884_ = czero;
		_tmp1885_ = celems;
		_tmp1886_ = clen;
		_tmp1887_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1885_, _tmp1886_);
		_tmp1888_ = _tmp1887_;
		vala_ccode_function_call_add_argument (_tmp1884_, (ValaCCodeExpression*) _tmp1888_);
		_vala_ccode_node_unref0 (_tmp1888_);
		_tmp1889_ = czero;
		_tmp1890_ = vala_ccode_constant_new ("0");
		_tmp1891_ = _tmp1890_;
		vala_ccode_function_call_add_argument (_tmp1889_, (ValaCCodeExpression*) _tmp1891_);
		_vala_ccode_node_unref0 (_tmp1891_);
		_tmp1892_ = czero;
		_tmp1893_ = csizeof;
		_tmp1894_ = cdelta;
		_tmp1895_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1893_, (ValaCCodeExpression*) _tmp1894_);
		_tmp1896_ = _tmp1895_;
		vala_ccode_function_call_add_argument (_tmp1892_, (ValaCCodeExpression*) _tmp1896_);
		_vala_ccode_node_unref0 (_tmp1896_);
		_tmp1897_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1898_ = _tmp1897_;
		_tmp1899_ = temp_ref;
		_tmp1900_ = new_size;
		vala_ccode_function_add_assignment (_tmp1898_, _tmp1899_, _tmp1900_);
		_tmp1901_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1902_ = _tmp1901_;
		_tmp1903_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1902_, _tmp1903_);
		_tmp1904_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1905_ = _tmp1904_;
		_tmp1906_ = ccheck;
		_tmp1907_ = czero;
		_tmp1908_ = vala_ccode_constant_new ("NULL");
		_tmp1909_ = _tmp1908_;
		_tmp1910_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1906_, (ValaCCodeExpression*) _tmp1907_, (ValaCCodeExpression*) _tmp1909_);
		_tmp1911_ = _tmp1910_;
		vala_ccode_function_add_expression (_tmp1905_, (ValaCCodeExpression*) _tmp1911_);
		_vala_ccode_node_unref0 (_tmp1911_);
		_vala_ccode_node_unref0 (_tmp1909_);
		_tmp1912_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1913_ = _tmp1912_;
		_tmp1914_ = ma;
		_tmp1915_ = vala_member_access_get_inner (_tmp1914_);
		_tmp1916_ = _tmp1915_;
		_tmp1917_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1916_, 1);
		_tmp1918_ = _tmp1917_;
		_tmp1919_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1913_, _tmp1918_, _tmp1919_);
		_vala_ccode_node_unref0 (_tmp1918_);
		_tmp1920_ = ma;
		_tmp1921_ = vala_member_access_get_inner (_tmp1920_);
		_tmp1922_ = _tmp1921_;
		_tmp1923_ = vala_expression_get_symbol_reference (_tmp1922_);
		_tmp1924_ = _tmp1923_;
		_tmp1925_ = _vala_code_node_ref0 (_tmp1924_);
		array_var = _tmp1925_;
		_tmp1926_ = array_var;
		_tmp1927_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1926_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1926_) : NULL);
		array_local = _tmp1927_;
		_tmp1930_ = array_var;
		if (_tmp1930_ != NULL) {
			ValaSymbol* _tmp1931_;
			_tmp1931_ = array_var;
			_tmp1929_ = vala_symbol_is_internal_symbol (_tmp1931_);
		} else {
			_tmp1929_ = FALSE;
		}
		if (_tmp1929_) {
			gboolean _tmp1932_ = FALSE;
			gboolean _tmp1933_ = FALSE;
			ValaSymbol* _tmp1934_;
			_tmp1934_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1934_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1935_;
				gboolean _tmp1936_;
				gboolean _tmp1937_;
				_tmp1935_ = array_local;
				_tmp1936_ = vala_local_variable_get_captured (_tmp1935_);
				_tmp1937_ = _tmp1936_;
				_tmp1933_ = !_tmp1937_;
			} else {
				_tmp1933_ = FALSE;
			}
			if (_tmp1933_) {
				_tmp1932_ = TRUE;
			} else {
				ValaSymbol* _tmp1938_;
				_tmp1938_ = array_var;
				_tmp1932_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1938_, VALA_TYPE_FIELD);
			}
			_tmp1928_ = _tmp1932_;
		} else {
			_tmp1928_ = FALSE;
		}
		if (_tmp1928_) {
			ValaCCodeFunction* _tmp1939_;
			ValaCCodeFunction* _tmp1940_;
			ValaMemberAccess* _tmp1941_;
			ValaExpression* _tmp1942_;
			ValaExpression* _tmp1943_;
			ValaTargetValue* _tmp1944_;
			ValaTargetValue* _tmp1945_;
			ValaCCodeExpression* _tmp1946_;
			ValaCCodeExpression* _tmp1947_;
			ValaCCodeExpression* _tmp1948_;
			_tmp1939_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1940_ = _tmp1939_;
			_tmp1941_ = ma;
			_tmp1942_ = vala_member_access_get_inner (_tmp1941_);
			_tmp1943_ = _tmp1942_;
			_tmp1944_ = vala_expression_get_target_value (_tmp1943_);
			_tmp1945_ = _tmp1944_;
			_tmp1946_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1945_);
			_tmp1947_ = _tmp1946_;
			_tmp1948_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1940_, _tmp1947_, _tmp1948_);
			_vala_ccode_node_unref0 (_tmp1947_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1950_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1951_ = _tmp1950_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1951_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1952_;
		ValaDataType* _tmp1953_;
		_tmp1952_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1953_ = _tmp1952_;
		_tmp1949_ = !vala_data_type_is_disposable (_tmp1953_);
	} else {
		_tmp1949_ = FALSE;
	}
	if (_tmp1949_) {
		gboolean _tmp1954_ = FALSE;
		ValaCCodeExpression* _tmp1955_;
		_tmp1955_ = ccall_expr;
		if (_tmp1955_ != NULL) {
			gboolean _tmp1956_;
			_tmp1956_ = return_result_via_out_param;
			_tmp1954_ = !_tmp1956_;
		} else {
			_tmp1954_ = FALSE;
		}
		if (_tmp1954_) {
			ValaCCodeFunction* _tmp1957_;
			ValaCCodeFunction* _tmp1958_;
			ValaCCodeExpression* _tmp1959_;
			_tmp1957_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1958_ = _tmp1957_;
			_tmp1959_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1958_, _tmp1959_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1960_;
		ValaDataType* _tmp1961_;
		gboolean _tmp1962_ = FALSE;
		ValaDataType* _tmp1963_;
		ValaDataType* _tmp1964_;
		gboolean _tmp1991_ = FALSE;
		ValaMethod* _tmp1992_;
		_tmp1960_ = itype;
		_tmp1961_ = vala_data_type_get_return_type (_tmp1960_);
		result_type = _tmp1961_;
		_tmp1963_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1964_ = _tmp1963_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1964_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1965_;
			ValaDataType* _tmp1966_;
			_tmp1965_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1966_ = _tmp1965_;
			_tmp1962_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1966_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1962_ = FALSE;
		}
		if (_tmp1962_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1967_;
			ValaDataType* _tmp1968_;
			ValaTypeParameter* _tmp1969_;
			ValaTypeParameter* _tmp1970_;
			ValaTypeParameter* _tmp1971_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1972_;
			ValaSymbol* _tmp1973_;
			ValaSymbol* _tmp1974_;
			ValaSymbol* _tmp1975_;
			ValaSymbol* _tmp1976_;
			ValaStruct* _tmp1977_;
			gboolean _tmp1978_ = FALSE;
			ValaTypeParameter* _tmp1979_;
			ValaSymbol* _tmp1980_;
			ValaSymbol* _tmp1981_;
			ValaTypeSymbol* _tmp1982_;
			_tmp1967_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1968_ = _tmp1967_;
			_tmp1969_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1968_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1970_ = _tmp1969_;
			_tmp1971_ = _vala_code_node_ref0 (_tmp1970_);
			type_parameter = _tmp1971_;
			_tmp1972_ = type_parameter;
			_tmp1973_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1972_);
			_tmp1974_ = _tmp1973_;
			_tmp1975_ = vala_symbol_get_parent_symbol (_tmp1974_);
			_tmp1976_ = _tmp1975_;
			_tmp1977_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1976_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1976_) : NULL);
			st = _tmp1977_;
			_tmp1979_ = type_parameter;
			_tmp1980_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1979_);
			_tmp1981_ = _tmp1980_;
			_tmp1982_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1981_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1982_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1978_ = TRUE;
			} else {
				gboolean _tmp1983_ = FALSE;
				ValaStruct* _tmp1984_;
				_tmp1984_ = st;
				if (_tmp1984_ != NULL) {
					ValaStruct* _tmp1985_;
					gchar* _tmp1986_;
					gchar* _tmp1987_;
					_tmp1985_ = st;
					_tmp1986_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1985_);
					_tmp1987_ = _tmp1986_;
					_tmp1983_ = g_strcmp0 (_tmp1987_, "va_list") == 0;
					_g_free0 (_tmp1987_);
				} else {
					_tmp1983_ = FALSE;
				}
				_tmp1978_ = _tmp1983_;
			}
			if (_tmp1978_) {
				ValaDataType* _tmp1988_;
				ValaDataType* _tmp1989_;
				ValaDataType* _tmp1990_;
				_tmp1988_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1989_ = _tmp1988_;
				_tmp1990_ = _vala_code_node_ref0 (_tmp1989_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1990_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1992_ = m;
		if (_tmp1992_ != NULL) {
			ValaMethod* _tmp1993_;
			_tmp1993_ = m;
			_tmp1991_ = vala_method_get_format_arg_index (_tmp1993_) >= 0;
		} else {
			_tmp1991_ = FALSE;
		}
		if (_tmp1991_) {
			ValaCCodeExpression* _tmp1994_;
			_tmp1994_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1994_);
		} else {
			gboolean _tmp1995_ = FALSE;
			ValaMethod* _tmp1996_;
			_tmp1996_ = m;
			if (_tmp1996_ != NULL) {
				ValaMethod* _tmp1997_;
				_tmp1997_ = m;
				_tmp1995_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1997_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1995_ = FALSE;
			}
			if (_tmp1995_) {
				ValaCCodeExpression* _tmp1998_;
				_tmp1998_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1998_);
			} else {
				gboolean _tmp1999_ = FALSE;
				gboolean _tmp2000_ = FALSE;
				gboolean _tmp2001_;
				_tmp2001_ = return_result_via_out_param;
				if (!_tmp2001_) {
					gboolean _tmp2002_ = FALSE;
					gboolean _tmp2003_ = FALSE;
					ValaMethod* _tmp2004_;
					_tmp2004_ = m;
					if (_tmp2004_ != NULL) {
						ValaMethod* _tmp2005_;
						_tmp2005_ = m;
						_tmp2003_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp2005_);
					} else {
						_tmp2003_ = FALSE;
					}
					if (_tmp2003_) {
						_tmp2002_ = TRUE;
					} else {
						gboolean _tmp2006_ = FALSE;
						ValaDelegate* _tmp2007_;
						_tmp2007_ = deleg;
						if (_tmp2007_ != NULL) {
							ValaDelegate* _tmp2008_;
							_tmp2008_ = deleg;
							_tmp2006_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp2008_);
						} else {
							_tmp2006_ = FALSE;
						}
						_tmp2002_ = _tmp2006_;
					}
					_tmp2000_ = _tmp2002_;
				} else {
					_tmp2000_ = FALSE;
				}
				if (_tmp2000_) {
					gboolean _tmp2009_ = FALSE;
					ValaDataType* _tmp2010_;
					_tmp2010_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2010_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2011_;
						_tmp2011_ = result_type;
						_tmp2009_ = !vala_data_type_is_disposable (_tmp2011_);
					} else {
						_tmp2009_ = FALSE;
					}
					_tmp1999_ = _tmp2009_;
				} else {
					_tmp1999_ = FALSE;
				}
				if (_tmp1999_) {
					ValaCCodeExpression* _tmp2012_;
					_tmp2012_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2012_);
				} else {
					gboolean _tmp2013_;
					_tmp2013_ = return_result_via_out_param;
					if (!_tmp2013_) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2014_;
						ValaDataType* _tmp2015_;
						gboolean _tmp2016_;
						gboolean _tmp2017_;
						ValaLocalVariable* _tmp2018_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2019_;
						const gchar* _tmp2020_;
						const gchar* _tmp2021_;
						ValaCCodeExpression* _tmp2022_;
						ValaLocalVariable* _tmp2023_;
						ValaCCodeFunction* _tmp2024_;
						ValaCCodeFunction* _tmp2025_;
						ValaCCodeExpression* _tmp2026_;
						ValaCCodeExpression* _tmp2027_;
						ValaCCodeExpression* _tmp2028_;
						ValaTargetValue* _tmp2029_;
						ValaTargetValue* _tmp2030_;
						_tmp2014_ = result_type;
						_tmp2015_ = result_type;
						_tmp2016_ = vala_data_type_get_value_owned (_tmp2015_);
						_tmp2017_ = _tmp2016_;
						_tmp2018_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2014_, _tmp2017_, NULL, FALSE);
						temp_var = _tmp2018_;
						_tmp2019_ = temp_var;
						_tmp2020_ = vala_symbol_get_name ((ValaSymbol*) _tmp2019_);
						_tmp2021_ = _tmp2020_;
						_tmp2022_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2021_);
						temp_ref = _tmp2022_;
						_tmp2023_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2023_, FALSE);
						_tmp2024_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2025_ = _tmp2024_;
						_tmp2026_ = temp_ref;
						_tmp2027_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2025_, _tmp2026_, _tmp2027_);
						_tmp2028_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2028_);
						_tmp2029_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2030_ = _tmp2029_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2030_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2031_;
						ValaTargetValue* _tmp2032_;
						ValaTargetValue* _tmp2033_;
						_tmp2031_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2031_);
						_tmp2032_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2033_ = _tmp2032_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2033_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2034_ = params;
	_tmp2035_ = vala_iterable_iterator ((ValaIterable*) _tmp2034_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2035_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2036_;
		gint _arg_size = 0;
		ValaList* _tmp2037_;
		gint _tmp2038_;
		gint _tmp2039_;
		gint _arg_index = 0;
		_tmp2036_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp2036_;
		_tmp2037_ = _arg_list;
		_tmp2038_ = vala_collection_get_size ((ValaCollection*) _tmp2037_);
		_tmp2039_ = _tmp2038_;
		_arg_size = _tmp2039_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2040_;
			gint _tmp2041_;
			gint _tmp2042_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2043_;
			gint _tmp2044_;
			gpointer _tmp2045_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2046_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2056_;
			ValaUnaryExpression* _tmp2057_;
			gboolean _tmp2058_ = FALSE;
			ValaUnaryExpression* _tmp2059_;
			ValaUnaryExpression* _tmp2063_;
			ValaExpression* _tmp2064_;
			ValaExpression* _tmp2065_;
			ValaDataType* _tmp2066_;
			ValaDataType* _tmp2067_;
			ValaUnaryExpression* _tmp2077_;
			ValaExpression* _tmp2078_;
			ValaExpression* _tmp2079_;
			ValaTargetValue* _tmp2080_;
			ValaTargetValue* _tmp2081_;
			ValaUnaryExpression* _tmp2082_;
			ValaTargetValue* _tmp2083_;
			ValaTargetValue* _tmp2084_;
			ValaUnaryExpression* _tmp2085_;
			ValaExpression* _tmp2086_;
			ValaExpression* _tmp2087_;
			ValaDataType* _tmp2088_;
			ValaDataType* _tmp2089_;
			ValaExpression* _tmp2090_;
			ValaTargetValue* _tmp2091_;
			ValaTargetValue* _tmp2092_;
			ValaSourceReference* _tmp2093_;
			ValaSourceReference* _tmp2094_;
			gboolean _tmp2095_ = FALSE;
			ValaParameter* _tmp2096_;
			_tmp2040_ = _arg_index;
			_arg_index = _tmp2040_ + 1;
			_tmp2041_ = _arg_index;
			_tmp2042_ = _arg_size;
			if (!(_tmp2041_ < _tmp2042_)) {
				break;
			}
			_tmp2043_ = _arg_list;
			_tmp2044_ = _arg_index;
			_tmp2045_ = vala_list_get (_tmp2043_, _tmp2044_);
			arg = (ValaExpression*) _tmp2045_;
			param = NULL;
			_tmp2046_ = params_it;
			if (vala_iterator_next (_tmp2046_)) {
				ValaIterator* _tmp2047_;
				gpointer _tmp2048_;
				gboolean _tmp2049_ = FALSE;
				ValaParameter* _tmp2050_;
				gboolean _tmp2051_;
				gboolean _tmp2052_;
				_tmp2047_ = params_it;
				_tmp2048_ = vala_iterator_get (_tmp2047_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2048_;
				_tmp2050_ = param;
				_tmp2051_ = vala_parameter_get_params_array (_tmp2050_);
				_tmp2052_ = _tmp2051_;
				if (_tmp2052_) {
					_tmp2049_ = TRUE;
				} else {
					ValaParameter* _tmp2053_;
					gboolean _tmp2054_;
					gboolean _tmp2055_;
					_tmp2053_ = param;
					_tmp2054_ = vala_parameter_get_ellipsis (_tmp2053_);
					_tmp2055_ = _tmp2054_;
					_tmp2049_ = _tmp2055_;
				}
				if (_tmp2049_) {
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (arg);
					break;
				}
			}
			_tmp2056_ = arg;
			_tmp2057_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2056_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2056_) : NULL);
			unary = _tmp2057_;
			_tmp2059_ = unary;
			if (_tmp2059_ == NULL) {
				_tmp2058_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2060_;
				ValaUnaryOperator _tmp2061_;
				ValaUnaryOperator _tmp2062_;
				_tmp2060_ = unary;
				_tmp2061_ = vala_unary_expression_get_operator (_tmp2060_);
				_tmp2062_ = _tmp2061_;
				_tmp2058_ = _tmp2062_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2058_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2063_ = unary;
			_tmp2064_ = vala_unary_expression_get_inner (_tmp2063_);
			_tmp2065_ = _tmp2064_;
			_tmp2066_ = vala_expression_get_value_type (_tmp2065_);
			_tmp2067_ = _tmp2066_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp2067_)) {
				ValaCCodeFunction* _tmp2068_;
				ValaCCodeFunction* _tmp2069_;
				ValaUnaryExpression* _tmp2070_;
				ValaExpression* _tmp2071_;
				ValaExpression* _tmp2072_;
				ValaTargetValue* _tmp2073_;
				ValaTargetValue* _tmp2074_;
				ValaCCodeExpression* _tmp2075_;
				ValaCCodeExpression* _tmp2076_;
				_tmp2068_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2069_ = _tmp2068_;
				_tmp2070_ = unary;
				_tmp2071_ = vala_unary_expression_get_inner (_tmp2070_);
				_tmp2072_ = _tmp2071_;
				_tmp2073_ = vala_expression_get_target_value (_tmp2072_);
				_tmp2074_ = _tmp2073_;
				_tmp2075_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2074_, FALSE);
				_tmp2076_ = _tmp2075_;
				vala_ccode_function_add_expression (_tmp2069_, _tmp2076_);
				_vala_ccode_node_unref0 (_tmp2076_);
			}
			_tmp2077_ = unary;
			_tmp2078_ = vala_unary_expression_get_inner (_tmp2077_);
			_tmp2079_ = _tmp2078_;
			_tmp2080_ = vala_expression_get_target_value (_tmp2079_);
			_tmp2081_ = _tmp2080_;
			_tmp2082_ = unary;
			_tmp2083_ = vala_expression_get_target_value ((ValaExpression*) _tmp2082_);
			_tmp2084_ = _tmp2083_;
			_tmp2085_ = unary;
			_tmp2086_ = vala_unary_expression_get_inner (_tmp2085_);
			_tmp2087_ = _tmp2086_;
			_tmp2088_ = vala_expression_get_value_type (_tmp2087_);
			_tmp2089_ = _tmp2088_;
			_tmp2090_ = arg;
			_tmp2091_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2084_, _tmp2089_, (ValaCodeNode*) _tmp2090_);
			_tmp2092_ = _tmp2091_;
			_tmp2093_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2094_ = _tmp2093_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2081_, _tmp2092_, _tmp2094_);
			_vala_target_value_unref0 (_tmp2092_);
			_tmp2096_ = param;
			if (_tmp2096_ != NULL) {
				ValaParameter* _tmp2097_;
				_tmp2097_ = param;
				_tmp2095_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2097_);
			} else {
				_tmp2095_ = FALSE;
			}
			if (_tmp2095_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2098_;
				ValaCCodeIdentifier* _tmp2099_;
				ValaCCodeFunctionCall* _tmp2100_;
				ValaCCodeFunctionCall* _tmp2101_;
				ValaCCodeFunctionCall* _tmp2102_;
				ValaUnaryExpression* _tmp2103_;
				ValaExpression* _tmp2104_;
				ValaExpression* _tmp2105_;
				ValaTargetValue* _tmp2106_;
				ValaTargetValue* _tmp2107_;
				ValaCCodeExpression* _tmp2108_;
				ValaCCodeExpression* _tmp2109_;
				ValaCCodeFunction* _tmp2110_;
				ValaCCodeFunction* _tmp2111_;
				ValaUnaryExpression* _tmp2112_;
				ValaExpression* _tmp2113_;
				ValaExpression* _tmp2114_;
				ValaTargetValue* _tmp2115_;
				ValaTargetValue* _tmp2116_;
				ValaCCodeExpression* _tmp2117_;
				ValaCCodeExpression* _tmp2118_;
				ValaCCodeFunctionCall* _tmp2119_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2098_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2099_ = _tmp2098_;
				_tmp2100_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2099_);
				_tmp2101_ = _tmp2100_;
				_vala_ccode_node_unref0 (_tmp2099_);
				len_call = _tmp2101_;
				_tmp2102_ = len_call;
				_tmp2103_ = unary;
				_tmp2104_ = vala_unary_expression_get_inner (_tmp2103_);
				_tmp2105_ = _tmp2104_;
				_tmp2106_ = vala_expression_get_target_value (_tmp2105_);
				_tmp2107_ = _tmp2106_;
				_tmp2108_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2107_);
				_tmp2109_ = _tmp2108_;
				vala_ccode_function_call_add_argument (_tmp2102_, _tmp2109_);
				_vala_ccode_node_unref0 (_tmp2109_);
				_tmp2110_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2111_ = _tmp2110_;
				_tmp2112_ = unary;
				_tmp2113_ = vala_unary_expression_get_inner (_tmp2112_);
				_tmp2114_ = _tmp2113_;
				_tmp2115_ = vala_expression_get_target_value (_tmp2114_);
				_tmp2116_ = _tmp2115_;
				_tmp2117_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2116_, 1);
				_tmp2118_ = _tmp2117_;
				_tmp2119_ = len_call;
				vala_ccode_function_add_assignment (_tmp2111_, _tmp2118_, (ValaCCodeExpression*) _tmp2119_);
				_vala_ccode_node_unref0 (_tmp2118_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2122_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2122_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2123_;
		ValaSymbol* _tmp2124_;
		ValaSymbol* _tmp2125_;
		_tmp2123_ = m;
		_tmp2124_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2123_);
		_tmp2125_ = _tmp2124_;
		_tmp2121_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2125_, VALA_TYPE_CLASS);
	} else {
		_tmp2121_ = FALSE;
	}
	if (_tmp2121_) {
		gboolean _tmp2126_ = FALSE;
		gboolean _tmp2127_ = FALSE;
		ValaClass* _tmp2128_;
		ValaClass* _tmp2129_;
		gboolean _tmp2130_;
		gboolean _tmp2131_;
		_tmp2128_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2129_ = _tmp2128_;
		_tmp2130_ = vala_class_get_is_compact (_tmp2129_);
		_tmp2131_ = _tmp2130_;
		if (_tmp2131_) {
			ValaClass* _tmp2132_;
			ValaClass* _tmp2133_;
			ValaClass* _tmp2134_;
			ValaClass* _tmp2135_;
			_tmp2132_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2133_ = _tmp2132_;
			_tmp2134_ = vala_class_get_base_class (_tmp2133_);
			_tmp2135_ = _tmp2134_;
			_tmp2127_ = _tmp2135_ != NULL;
		} else {
			_tmp2127_ = FALSE;
		}
		if (_tmp2127_) {
			_tmp2126_ = TRUE;
		} else {
			ValaClass* _tmp2136_;
			ValaClass* _tmp2137_;
			ValaClass* _tmp2138_;
			ValaClass* _tmp2139_;
			ValaClass* _tmp2140_;
			_tmp2136_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2137_ = _tmp2136_;
			_tmp2138_ = vala_class_get_base_class (_tmp2137_);
			_tmp2139_ = _tmp2138_;
			_tmp2140_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2126_ = _tmp2139_ == _tmp2140_;
		}
		_tmp2120_ = _tmp2126_;
	} else {
		_tmp2120_ = FALSE;
	}
	if (_tmp2120_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2141_;
		ValaClass* _tmp2142_;
		gchar* _tmp2143_;
		gchar* _tmp2144_;
		gchar* _tmp2145_;
		gchar* _tmp2146_;
		ValaCCodeIdentifier* _tmp2147_;
		ValaCCodeIdentifier* _tmp2148_;
		ValaCCodeFunctionCall* _tmp2149_;
		ValaCCodeFunctionCall* _tmp2150_;
		ValaCCodeFunctionCall* _tmp2151_;
		ValaCCodeExpression* _tmp2152_;
		ValaCCodeExpression* _tmp2153_;
		ValaCCodeFunction* _tmp2154_;
		ValaCCodeFunction* _tmp2155_;
		ValaCCodeFunctionCall* _tmp2156_;
		_tmp2141_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2142_ = _tmp2141_;
		_tmp2143_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2142_, NULL);
		_tmp2144_ = _tmp2143_;
		_tmp2145_ = g_strdup_printf ("%s_instance_init", _tmp2144_);
		_tmp2146_ = _tmp2145_;
		_tmp2147_ = vala_ccode_identifier_new (_tmp2146_);
		_tmp2148_ = _tmp2147_;
		_tmp2149_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2148_);
		_tmp2150_ = _tmp2149_;
		_vala_ccode_node_unref0 (_tmp2148_);
		_g_free0 (_tmp2146_);
		_g_free0 (_tmp2144_);
		cinitcall = _tmp2150_;
		_tmp2151_ = cinitcall;
		_tmp2152_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2153_ = _tmp2152_;
		vala_ccode_function_call_add_argument (_tmp2151_, _tmp2153_);
		_vala_ccode_node_unref0 (_tmp2153_);
		_tmp2154_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2155_ = _tmp2154_;
		_tmp2156_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2155_, (ValaCCodeExpression*) _tmp2156_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}


static gchar*
vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                               ValaEnum* en)
{
	gchar* result = NULL;
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeConstant* _tmp53_;
	ValaCCodeFile* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	ValaCCodeFile* _tmp56_;
	ValaCCodeFunction* _tmp57_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaCCodeFunction* _tmp31_;
			ValaEnumValue* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeIdentifier* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaCCodeFunction* _tmp38_;
			ValaEnumValue* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			ValaCCodeConstant* _tmp47_;
			_tmp24_ = _enum_value_index;
			_enum_value_index = _tmp24_ + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = _enum_value_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			enum_value = (ValaEnumValue*) _tmp29_;
			_tmp30_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = enum_value;
			_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_identifier_new (_tmp34_);
			_tmp36_ = _tmp35_;
			vala_ccode_function_add_case (_tmp31_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
			_g_free0 (_tmp34_);
			_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = enum_value;
			_tmp40_ = vala_get_ccode_name ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat ("\"", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat (_tmp43_, "\"", NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_ccode_constant_new (_tmp45_);
			_tmp47_ = _tmp46_;
			vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp47_);
			_vala_ccode_node_unref0 (_tmp47_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = _tmp48_;
	vala_ccode_function_close (_tmp49_);
	_tmp50_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_constant_new ("NULL");
	_tmp53_ = _tmp52_;
	vala_ccode_function_add_return (_tmp51_, (ValaCCodeExpression*) _tmp53_);
	_vala_ccode_node_unref0 (_tmp53_);
	_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp55_ = function;
	vala_ccode_file_add_function_declaration (_tmp54_, _tmp55_);
	_tmp56_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp57_ = function;
	vala_ccode_file_add_function (_tmp56_, _tmp57_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static gboolean
vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                 ValaCallable* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters (c);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			ValaParameterDirection _tmp11_;
			ValaParameterDirection _tmp12_;
			_tmp4_ = _param_index;
			_param_index = _tmp4_ + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = _param_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			_tmp11_ = vala_parameter_get_direction (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != VALA_PARAMETER_DIRECTION_IN) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}


static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	gchar* result = NULL;
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeIdentifier* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeFunctionCall* _tmp41_;
	ValaCCodeConstant* _tmp42_;
	ValaCCodeConstant* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeConstant* _tmp46_;
	ValaCCodeFunctionCall* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeFunctionCall* _tmp50_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeIdentifier* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeIdentifier* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeConstant* _tmp58_;
	ValaCCodeConstant* _tmp59_;
	ValaCCodeBinaryExpression* _tmp60_;
	ValaCCodeBinaryExpression* _tmp61_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp62_;
	ValaCCodeIdentifier* _tmp63_;
	ValaCCodeFunctionCall* _tmp64_;
	ValaCCodeFunctionCall* _tmp65_;
	ValaCCodeFunctionCall* _tmp66_;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunction* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunctionCall* _tmp74_;
	ValaCCodeFunctionCall* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunction* _tmp79_;
	ValaCCodeFunction* _tmp80_;
	ValaCCodeIdentifier* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeFunctionCall* _tmp83_;
	ValaCCodeIdentifier* _tmp84_;
	ValaCCodeIdentifier* _tmp85_;
	ValaCCodeFunctionCall* _tmp86_;
	ValaCCodeFunctionCall* _tmp87_;
	ValaCCodeIdentifier* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeFunctionCall* _tmp90_;
	ValaCCodeIdentifier* _tmp91_;
	ValaCCodeIdentifier* _tmp92_;
	ValaCCodeFunction* _tmp93_;
	ValaCCodeFunction* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunctionCall* _tmp98_;
	ValaCCodeFunctionCall* _tmp99_;
	ValaCCodeIdentifier* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeFunctionCall* _tmp102_;
	ValaCCodeIdentifier* _tmp103_;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeFunctionCall* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeIdentifier* _tmp107_;
	ValaCCodeFunctionCall* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeIdentifier* _tmp110_;
	ValaCCodeFunction* _tmp111_;
	ValaCCodeFunction* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunctionCall* _tmp116_;
	ValaCCodeFunctionCall* _tmp117_;
	ValaCCodeIdentifier* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	ValaCCodeFunction* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeFunction* _tmp123_;
	ValaCCodeFunction* _tmp124_;
	ValaCCodeIdentifier* _tmp125_;
	ValaCCodeIdentifier* _tmp126_;
	ValaCCodeFile* _tmp127_;
	ValaCCodeFile* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeFile* _tmp130_;
	ValaCCodeFunction* _tmp131_;
	gchar* _tmp132_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp38_);
	_tmp40_ = _tmp39_;
	_vala_ccode_node_unref0 (_tmp38_);
	vsnprintf = _tmp40_;
	_tmp41_ = vsnprintf;
	_tmp42_ = vala_ccode_constant_new ("NULL");
	_tmp43_ = _tmp42_;
	vala_ccode_function_call_add_argument (_tmp41_, (ValaCCodeExpression*) _tmp43_);
	_vala_ccode_node_unref0 (_tmp43_);
	_tmp44_ = vsnprintf;
	_tmp45_ = vala_ccode_constant_new ("0");
	_tmp46_ = _tmp45_;
	vala_ccode_function_call_add_argument (_tmp44_, (ValaCCodeExpression*) _tmp46_);
	_vala_ccode_node_unref0 (_tmp46_);
	_tmp47_ = vsnprintf;
	_tmp48_ = vala_ccode_identifier_new ("format");
	_tmp49_ = _tmp48_;
	vala_ccode_function_call_add_argument (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = vsnprintf;
	_tmp51_ = vala_ccode_identifier_new ("ap");
	_tmp52_ = _tmp51_;
	vala_ccode_function_call_add_argument (_tmp50_, (ValaCCodeExpression*) _tmp52_);
	_vala_ccode_node_unref0 (_tmp52_);
	_tmp53_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_identifier_new ("length");
	_tmp56_ = _tmp55_;
	_tmp57_ = vsnprintf;
	_tmp58_ = vala_ccode_constant_new ("1");
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp57_, (ValaCCodeExpression*) _tmp59_);
	_tmp61_ = _tmp60_;
	vala_ccode_function_add_assignment (_tmp54_, (ValaCCodeExpression*) _tmp56_, (ValaCCodeExpression*) _tmp61_);
	_vala_ccode_node_unref0 (_tmp61_);
	_vala_ccode_node_unref0 (_tmp59_);
	_vala_ccode_node_unref0 (_tmp56_);
	_tmp62_ = vala_ccode_identifier_new ("va_end");
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp63_);
	_tmp65_ = _tmp64_;
	_vala_ccode_node_unref0 (_tmp63_);
	va_end = _tmp65_;
	_tmp66_ = va_end;
	_tmp67_ = vala_ccode_identifier_new ("ap");
	_tmp68_ = _tmp67_;
	vala_ccode_function_call_add_argument (_tmp66_, (ValaCCodeExpression*) _tmp68_);
	_vala_ccode_node_unref0 (_tmp68_);
	_tmp69_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp70_ = _tmp69_;
	_tmp71_ = va_end;
	vala_ccode_function_add_expression (_tmp70_, (ValaCCodeExpression*) _tmp71_);
	_tmp72_ = vala_ccode_identifier_new ("malloc");
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp73_);
	_tmp75_ = _tmp74_;
	_vala_ccode_node_unref0 (_tmp73_);
	malloc = _tmp75_;
	_tmp76_ = malloc;
	_tmp77_ = vala_ccode_identifier_new ("length");
	_tmp78_ = _tmp77_;
	vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp78_);
	_vala_ccode_node_unref0 (_tmp78_);
	_tmp79_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_ccode_identifier_new ("result");
	_tmp82_ = _tmp81_;
	_tmp83_ = malloc;
	vala_ccode_function_add_assignment (_tmp80_, (ValaCCodeExpression*) _tmp82_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp82_);
	_tmp84_ = vala_ccode_identifier_new ("va_start");
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp85_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp86_;
	_vala_ccode_node_unref0 (_tmp85_);
	_tmp87_ = va_start;
	_tmp88_ = vala_ccode_identifier_new ("ap");
	_tmp89_ = _tmp88_;
	vala_ccode_function_call_add_argument (_tmp87_, (ValaCCodeExpression*) _tmp89_);
	_vala_ccode_node_unref0 (_tmp89_);
	_tmp90_ = va_start;
	_tmp91_ = vala_ccode_identifier_new ("format");
	_tmp92_ = _tmp91_;
	vala_ccode_function_call_add_argument (_tmp90_, (ValaCCodeExpression*) _tmp92_);
	_vala_ccode_node_unref0 (_tmp92_);
	_tmp93_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp94_ = _tmp93_;
	_tmp95_ = va_start;
	vala_ccode_function_add_expression (_tmp94_, (ValaCCodeExpression*) _tmp95_);
	_tmp96_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp97_ = _tmp96_;
	_tmp98_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp98_;
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp99_ = vsnprintf;
	_tmp100_ = vala_ccode_identifier_new ("result");
	_tmp101_ = _tmp100_;
	vala_ccode_function_call_add_argument (_tmp99_, (ValaCCodeExpression*) _tmp101_);
	_vala_ccode_node_unref0 (_tmp101_);
	_tmp102_ = vsnprintf;
	_tmp103_ = vala_ccode_identifier_new ("length");
	_tmp104_ = _tmp103_;
	vala_ccode_function_call_add_argument (_tmp102_, (ValaCCodeExpression*) _tmp104_);
	_vala_ccode_node_unref0 (_tmp104_);
	_tmp105_ = vsnprintf;
	_tmp106_ = vala_ccode_identifier_new ("format");
	_tmp107_ = _tmp106_;
	vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp107_);
	_vala_ccode_node_unref0 (_tmp107_);
	_tmp108_ = vsnprintf;
	_tmp109_ = vala_ccode_identifier_new ("ap");
	_tmp110_ = _tmp109_;
	vala_ccode_function_call_add_argument (_tmp108_, (ValaCCodeExpression*) _tmp110_);
	_vala_ccode_node_unref0 (_tmp110_);
	_tmp111_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp112_, (ValaCCodeExpression*) _tmp113_);
	_tmp114_ = vala_ccode_identifier_new ("va_end");
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp116_;
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp117_ = va_end;
	_tmp118_ = vala_ccode_identifier_new ("ap");
	_tmp119_ = _tmp118_;
	vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp119_);
	_vala_ccode_node_unref0 (_tmp119_);
	_tmp120_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp121_ = _tmp120_;
	_tmp122_ = va_end;
	vala_ccode_function_add_expression (_tmp121_, (ValaCCodeExpression*) _tmp122_);
	_tmp123_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_identifier_new ("result");
	_tmp126_ = _tmp125_;
	vala_ccode_function_add_return (_tmp124_, (ValaCCodeExpression*) _tmp126_);
	_vala_ccode_node_unref0 (_tmp126_);
	_tmp127_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp127_, "stdarg.h", FALSE);
	_tmp128_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp129_ = function;
	vala_ccode_file_add_function_declaration (_tmp128_, _tmp129_);
	_tmp130_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp131_ = function;
	vala_ccode_file_add_function (_tmp130_, _tmp131_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp132_ = g_strdup ("string_printf");
	result = _tmp132_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}


static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}


static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self)
{
}


GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



