/* valaforstatement.c generated by valac, the Vala compiler
 * generated from valaforstatement.vala, do not modify */

/* valaforstatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaForStatementPrivate {
	ValaList* initializer;
	ValaList* iterator;
	ValaExpression* _condition;
	ValaBlock* _body;
};


static gint ValaForStatement_private_offset;
static gpointer vala_for_statement_parent_class = NULL;
static ValaStatementIface * vala_for_statement_vala_statement_parent_iface = NULL;

static void vala_for_statement_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_for_statement_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static void vala_for_statement_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_for_statement_always_true (ValaForStatement* self,
                                         ValaExpression* condition);
static gboolean vala_for_statement_always_false (ValaForStatement* self,
                                          ValaExpression* condition);
static gboolean vala_for_statement_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static void vala_for_statement_finalize (ValaCodeNode * obj);


static inline gpointer
vala_for_statement_get_instance_private (ValaForStatement* self)
{
	return G_STRUCT_MEMBER_P (self, ValaForStatement_private_offset);
}


/**
 * Creates a new for statement.
 *
 * @param condition        loop condition
 * @param body             loop body
 * @param source_reference reference to source code
 * @return                 newly created for statement
 */
ValaForStatement*
vala_for_statement_construct (GType object_type,
                              ValaExpression* condition,
                              ValaBlock* body,
                              ValaSourceReference* source_reference)
{
	ValaForStatement* self = NULL;
	g_return_val_if_fail (body != NULL, NULL);
	self = (ValaForStatement*) vala_code_node_construct (object_type);
	vala_for_statement_set_condition (self, condition);
	vala_for_statement_set_body (self, body);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaForStatement*
vala_for_statement_new (ValaExpression* condition,
                        ValaBlock* body,
                        ValaSourceReference* source_reference)
{
	return vala_for_statement_construct (VALA_TYPE_FOR_STATEMENT, condition, body, source_reference);
}


/**
 * Appends the specified expression to the list of initializers.
 *
 * @param init an initializer expression
 */
void
vala_for_statement_add_initializer (ValaForStatement* self,
                                    ValaExpression* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
	_tmp0_ = self->priv->initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
}


/**
 * Returns a copy of the list of initializers.
 *
 * @return initializer list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_for_statement_get_initializer (ValaForStatement* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializer;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Appends the specified expression to the iterator.
 *
 * @param iter an iterator expression
 */
void
vala_for_statement_add_iterator (ValaForStatement* self,
                                 ValaExpression* iter)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) iter, (ValaCodeNode*) self);
	_tmp0_ = self->priv->iterator;
	vala_collection_add ((ValaCollection*) _tmp0_, iter);
}


/**
 * Returns a copy of the iterator.
 *
 * @return iterator
 */
ValaList*
vala_for_statement_get_iterator (ValaForStatement* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->iterator;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_for_statement_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaForStatement * self;
	self = (ValaForStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_for_statement (visitor, self);
}


static void
vala_for_statement_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaForStatement * self;
	ValaExpression* _tmp13_;
	ValaExpression* _tmp14_;
	ValaBlock* _tmp32_;
	ValaBlock* _tmp33_;
	self = (ValaForStatement*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _init_expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _init_expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _init_expr_index = 0;
		_tmp0_ = self->priv->initializer;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_init_expr_list = _tmp1_;
		_tmp2_ = _init_expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_init_expr_size = _tmp4_;
		_init_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* init_expr = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			_tmp5_ = _init_expr_index;
			_init_expr_index = _tmp5_ + 1;
			_tmp6_ = _init_expr_index;
			_tmp7_ = _init_expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _init_expr_list;
			_tmp9_ = _init_expr_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			init_expr = (ValaExpression*) _tmp10_;
			_tmp11_ = init_expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_tmp12_ = init_expr;
			vala_code_visitor_visit_end_full_expression (visitor, _tmp12_);
			_vala_code_node_unref0 (init_expr);
		}
		_vala_iterable_unref0 (_init_expr_list);
	}
	_tmp13_ = vala_for_statement_get_condition (self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		_tmp15_ = vala_for_statement_get_condition (self);
		_tmp16_ = _tmp15_;
		vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
		_tmp17_ = vala_for_statement_get_condition (self);
		_tmp18_ = _tmp17_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp18_);
	}
	{
		ValaList* _it_expr_list = NULL;
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		gint _it_expr_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _it_expr_index = 0;
		_tmp19_ = self->priv->iterator;
		_tmp20_ = _vala_iterable_ref0 (_tmp19_);
		_it_expr_list = _tmp20_;
		_tmp21_ = _it_expr_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_it_expr_size = _tmp23_;
		_it_expr_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaExpression* it_expr = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			_tmp24_ = _it_expr_index;
			_it_expr_index = _tmp24_ + 1;
			_tmp25_ = _it_expr_index;
			_tmp26_ = _it_expr_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _it_expr_list;
			_tmp28_ = _it_expr_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			it_expr = (ValaExpression*) _tmp29_;
			_tmp30_ = it_expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp30_, visitor);
			_tmp31_ = it_expr;
			vala_code_visitor_visit_end_full_expression (visitor, _tmp31_);
			_vala_code_node_unref0 (it_expr);
		}
		_vala_iterable_unref0 (_it_expr_list);
	}
	_tmp32_ = vala_for_statement_get_body (self);
	_tmp33_ = _tmp32_;
	vala_code_node_accept ((ValaCodeNode*) _tmp33_, visitor);
}


static void
vala_for_statement_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaForStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaForStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_for_statement_get_condition (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_for_statement_set_condition (self, new_node);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				ValaList* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				ValaList* _tmp8_;
				gint _tmp9_;
				gpointer _tmp10_;
				ValaExpression* _tmp11_;
				gboolean _tmp12_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->priv->initializer;
				_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ < _tmp7_)) {
					break;
				}
				_tmp8_ = self->priv->initializer;
				_tmp9_ = i;
				_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
				_tmp11_ = (ValaExpression*) _tmp10_;
				_tmp12_ = _tmp11_ == old_node;
				_vala_code_node_unref0 (_tmp11_);
				if (_tmp12_) {
					ValaList* _tmp13_;
					gint _tmp14_;
					_tmp13_ = self->priv->initializer;
					_tmp14_ = i;
					vala_list_set (_tmp13_, _tmp14_, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_;
				ValaList* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				ValaList* _tmp21_;
				gint _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = i;
				_tmp18_ = self->priv->iterator;
				_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
				_tmp20_ = _tmp19_;
				if (!(_tmp17_ < _tmp20_)) {
					break;
				}
				_tmp21_ = self->priv->iterator;
				_tmp22_ = i;
				_tmp23_ = vala_list_get (_tmp21_, _tmp22_);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = _tmp24_ == old_node;
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gint _tmp27_;
					_tmp26_ = self->priv->iterator;
					_tmp27_ = i;
					vala_list_set (_tmp26_, _tmp27_, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_for_statement_always_true (ValaForStatement* self,
                                ValaExpression* condition)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaBooleanLiteral* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (condition, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) condition) : NULL);
	literal = _tmp0_;
	_tmp2_ = literal;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = literal;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (literal);
	return result;
}


static gboolean
vala_for_statement_always_false (ValaForStatement* self,
                                 ValaExpression* condition)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaBooleanLiteral* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (condition, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) condition) : NULL);
	literal = _tmp0_;
	_tmp2_ = literal;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = literal;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = !_tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (literal);
	return result;
}


static gboolean
vala_for_statement_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaForStatement * self;
	gboolean result = FALSE;
	ValaBlock* block = NULL;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaBlock* _tmp2_;
	gboolean _tmp21_ = FALSE;
	ValaExpression* _tmp22_;
	ValaExpression* _tmp23_;
	ValaLocalVariable* first_local = NULL;
	ValaSemanticAnalyzer* _tmp65_;
	ValaSemanticAnalyzer* _tmp66_;
	ValaDataType* _tmp67_;
	ValaDataType* _tmp68_;
	ValaDataType* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	ValaSourceReference* _tmp72_;
	ValaSourceReference* _tmp73_;
	ValaBooleanLiteral* _tmp74_;
	ValaBooleanLiteral* _tmp75_;
	ValaSourceReference* _tmp76_;
	ValaSourceReference* _tmp77_;
	ValaLocalVariable* _tmp78_;
	ValaLocalVariable* _tmp79_;
	ValaBlock* _tmp80_;
	ValaLocalVariable* _tmp81_;
	ValaSourceReference* _tmp82_;
	ValaSourceReference* _tmp83_;
	ValaDeclarationStatement* _tmp84_;
	ValaDeclarationStatement* _tmp85_;
	ValaBlock* iterator_block = NULL;
	ValaSourceReference* _tmp86_;
	ValaSourceReference* _tmp87_;
	ValaBlock* _tmp88_;
	ValaIfStatement* first_if = NULL;
	ValaLocalVariable* _tmp107_;
	const gchar* _tmp108_;
	const gchar* _tmp109_;
	ValaSourceReference* _tmp110_;
	ValaSourceReference* _tmp111_;
	ValaMemberAccess* _tmp112_;
	ValaMemberAccess* _tmp113_;
	ValaSourceReference* _tmp114_;
	ValaSourceReference* _tmp115_;
	ValaUnaryExpression* _tmp116_;
	ValaUnaryExpression* _tmp117_;
	ValaBlock* _tmp118_;
	ValaSourceReference* _tmp119_;
	ValaSourceReference* _tmp120_;
	ValaIfStatement* _tmp121_;
	ValaIfStatement* _tmp122_;
	ValaBlock* _tmp123_;
	ValaBlock* _tmp124_;
	ValaBlock* _tmp125_;
	ValaBlock* _tmp126_;
	ValaLocalVariable* _tmp127_;
	const gchar* _tmp128_;
	const gchar* _tmp129_;
	ValaSourceReference* _tmp130_;
	ValaSourceReference* _tmp131_;
	ValaMemberAccess* _tmp132_;
	ValaMemberAccess* _tmp133_;
	ValaSourceReference* _tmp134_;
	ValaSourceReference* _tmp135_;
	ValaBooleanLiteral* _tmp136_;
	ValaBooleanLiteral* _tmp137_;
	ValaSourceReference* _tmp138_;
	ValaSourceReference* _tmp139_;
	ValaAssignment* _tmp140_;
	ValaAssignment* _tmp141_;
	ValaSourceReference* _tmp142_;
	ValaSourceReference* _tmp143_;
	ValaExpressionStatement* _tmp144_;
	ValaExpressionStatement* _tmp145_;
	ValaBlock* _tmp146_;
	ValaBlock* _tmp147_;
	ValaBlock* _tmp148_;
	ValaSourceReference* _tmp149_;
	ValaSourceReference* _tmp150_;
	ValaLoop* _tmp151_;
	ValaLoop* _tmp152_;
	ValaBlock* parent_block = NULL;
	ValaCodeNode* _tmp153_;
	ValaCodeNode* _tmp154_;
	ValaBlock* _tmp155_;
	ValaBlock* _tmp156_;
	ValaBlock* _tmp157_;
	self = (ValaForStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_block_new (_tmp1_);
	block = _tmp2_;
	{
		ValaList* _init_expr_list = NULL;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _init_expr_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _init_expr_index = 0;
		_tmp3_ = self->priv->initializer;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_init_expr_list = _tmp4_;
		_tmp5_ = _init_expr_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_init_expr_size = _tmp7_;
		_init_expr_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* init_expr = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaBlock* _tmp14_;
			ValaExpression* _tmp15_;
			ValaExpression* _tmp16_;
			ValaSourceReference* _tmp17_;
			ValaSourceReference* _tmp18_;
			ValaExpressionStatement* _tmp19_;
			ValaExpressionStatement* _tmp20_;
			_tmp8_ = _init_expr_index;
			_init_expr_index = _tmp8_ + 1;
			_tmp9_ = _init_expr_index;
			_tmp10_ = _init_expr_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _init_expr_list;
			_tmp12_ = _init_expr_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			init_expr = (ValaExpression*) _tmp13_;
			_tmp14_ = block;
			_tmp15_ = init_expr;
			_tmp16_ = init_expr;
			_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_expression_statement_new (_tmp15_, _tmp18_);
			_tmp20_ = _tmp19_;
			vala_block_add_statement (_tmp14_, (ValaStatement*) _tmp20_);
			_vala_code_node_unref0 (_tmp20_);
			_vala_code_node_unref0 (init_expr);
		}
		_vala_iterable_unref0 (_init_expr_list);
	}
	_tmp22_ = vala_for_statement_get_condition (self);
	_tmp23_ = _tmp22_;
	if (_tmp23_ == NULL) {
		_tmp21_ = TRUE;
	} else {
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		_tmp24_ = vala_for_statement_get_condition (self);
		_tmp25_ = _tmp24_;
		_tmp21_ = vala_for_statement_always_true (self, _tmp25_);
	}
	if (_tmp21_) {
	} else {
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		_tmp26_ = vala_for_statement_get_condition (self);
		_tmp27_ = _tmp26_;
		if (vala_for_statement_always_false (self, _tmp27_)) {
			ValaBlock* _tmp28_;
			ValaBlock* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaSourceReference* _tmp32_;
			ValaSourceReference* _tmp33_;
			ValaBreakStatement* _tmp34_;
			ValaBreakStatement* _tmp35_;
			_tmp28_ = vala_for_statement_get_body (self);
			_tmp29_ = _tmp28_;
			_tmp30_ = vala_for_statement_get_condition (self);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_break_statement_new (_tmp33_);
			_tmp35_ = _tmp34_;
			vala_block_insert_statement (_tmp29_, 0, (ValaStatement*) _tmp35_);
			_vala_code_node_unref0 (_tmp35_);
		} else {
			ValaUnaryExpression* if_condition = NULL;
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaSourceReference* _tmp40_;
			ValaSourceReference* _tmp41_;
			ValaUnaryExpression* _tmp42_;
			ValaBlock* true_block = NULL;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaSourceReference* _tmp45_;
			ValaSourceReference* _tmp46_;
			ValaBlock* _tmp47_;
			ValaBlock* _tmp48_;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaSourceReference* _tmp51_;
			ValaSourceReference* _tmp52_;
			ValaBreakStatement* _tmp53_;
			ValaBreakStatement* _tmp54_;
			ValaIfStatement* if_stmt = NULL;
			ValaUnaryExpression* _tmp55_;
			ValaBlock* _tmp56_;
			ValaExpression* _tmp57_;
			ValaExpression* _tmp58_;
			ValaSourceReference* _tmp59_;
			ValaSourceReference* _tmp60_;
			ValaIfStatement* _tmp61_;
			ValaBlock* _tmp62_;
			ValaBlock* _tmp63_;
			ValaIfStatement* _tmp64_;
			_tmp36_ = vala_for_statement_get_condition (self);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_for_statement_get_condition (self);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, _tmp37_, _tmp41_);
			if_condition = _tmp42_;
			_tmp43_ = vala_for_statement_get_condition (self);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_block_new (_tmp46_);
			true_block = _tmp47_;
			_tmp48_ = true_block;
			_tmp49_ = vala_for_statement_get_condition (self);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = vala_break_statement_new (_tmp52_);
			_tmp54_ = _tmp53_;
			vala_block_add_statement (_tmp48_, (ValaStatement*) _tmp54_);
			_vala_code_node_unref0 (_tmp54_);
			_tmp55_ = if_condition;
			_tmp56_ = true_block;
			_tmp57_ = vala_for_statement_get_condition (self);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_if_statement_new ((ValaExpression*) _tmp55_, _tmp56_, NULL, _tmp60_);
			if_stmt = _tmp61_;
			_tmp62_ = vala_for_statement_get_body (self);
			_tmp63_ = _tmp62_;
			_tmp64_ = if_stmt;
			vala_block_insert_statement (_tmp63_, 0, (ValaStatement*) _tmp64_);
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (if_condition);
		}
	}
	_tmp65_ = vala_code_context_get_analyzer (context);
	_tmp66_ = _tmp65_;
	_tmp67_ = _tmp66_->bool_type;
	_tmp68_ = vala_data_type_copy (_tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = vala_code_node_get_temp_name ();
	_tmp71_ = _tmp70_;
	_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_boolean_literal_new (TRUE, _tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp77_ = _tmp76_;
	_tmp78_ = vala_local_variable_new (_tmp69_, _tmp71_, (ValaExpression*) _tmp75_, _tmp77_);
	_tmp79_ = _tmp78_;
	_vala_code_node_unref0 (_tmp75_);
	_g_free0 (_tmp71_);
	_vala_code_node_unref0 (_tmp69_);
	first_local = _tmp79_;
	_tmp80_ = block;
	_tmp81_ = first_local;
	_tmp82_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp83_ = _tmp82_;
	_tmp84_ = vala_declaration_statement_new ((ValaSymbol*) _tmp81_, _tmp83_);
	_tmp85_ = _tmp84_;
	vala_block_add_statement (_tmp80_, (ValaStatement*) _tmp85_);
	_vala_code_node_unref0 (_tmp85_);
	_tmp86_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp87_ = _tmp86_;
	_tmp88_ = vala_block_new (_tmp87_);
	iterator_block = _tmp88_;
	{
		ValaList* _it_expr_list = NULL;
		ValaList* _tmp89_;
		ValaList* _tmp90_;
		gint _it_expr_size = 0;
		ValaList* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		gint _it_expr_index = 0;
		_tmp89_ = self->priv->iterator;
		_tmp90_ = _vala_iterable_ref0 (_tmp89_);
		_it_expr_list = _tmp90_;
		_tmp91_ = _it_expr_list;
		_tmp92_ = vala_collection_get_size ((ValaCollection*) _tmp91_);
		_tmp93_ = _tmp92_;
		_it_expr_size = _tmp93_;
		_it_expr_index = -1;
		while (TRUE) {
			gint _tmp94_;
			gint _tmp95_;
			gint _tmp96_;
			ValaExpression* it_expr = NULL;
			ValaList* _tmp97_;
			gint _tmp98_;
			gpointer _tmp99_;
			ValaBlock* _tmp100_;
			ValaExpression* _tmp101_;
			ValaExpression* _tmp102_;
			ValaSourceReference* _tmp103_;
			ValaSourceReference* _tmp104_;
			ValaExpressionStatement* _tmp105_;
			ValaExpressionStatement* _tmp106_;
			_tmp94_ = _it_expr_index;
			_it_expr_index = _tmp94_ + 1;
			_tmp95_ = _it_expr_index;
			_tmp96_ = _it_expr_size;
			if (!(_tmp95_ < _tmp96_)) {
				break;
			}
			_tmp97_ = _it_expr_list;
			_tmp98_ = _it_expr_index;
			_tmp99_ = vala_list_get (_tmp97_, _tmp98_);
			it_expr = (ValaExpression*) _tmp99_;
			_tmp100_ = iterator_block;
			_tmp101_ = it_expr;
			_tmp102_ = it_expr;
			_tmp103_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp102_);
			_tmp104_ = _tmp103_;
			_tmp105_ = vala_expression_statement_new (_tmp101_, _tmp104_);
			_tmp106_ = _tmp105_;
			vala_block_add_statement (_tmp100_, (ValaStatement*) _tmp106_);
			_vala_code_node_unref0 (_tmp106_);
			_vala_code_node_unref0 (it_expr);
		}
		_vala_iterable_unref0 (_it_expr_list);
	}
	_tmp107_ = first_local;
	_tmp108_ = vala_symbol_get_name ((ValaSymbol*) _tmp107_);
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_member_access_new_simple (_tmp109_, _tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaExpression*) _tmp113_, _tmp115_);
	_tmp117_ = _tmp116_;
	_tmp118_ = iterator_block;
	_tmp119_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_if_statement_new ((ValaExpression*) _tmp117_, _tmp118_, NULL, _tmp120_);
	_tmp122_ = _tmp121_;
	_vala_code_node_unref0 (_tmp117_);
	_vala_code_node_unref0 (_tmp113_);
	first_if = _tmp122_;
	_tmp123_ = vala_for_statement_get_body (self);
	_tmp124_ = _tmp123_;
	vala_block_insert_statement (_tmp124_, 0, (ValaStatement*) first_if);
	_tmp125_ = vala_for_statement_get_body (self);
	_tmp126_ = _tmp125_;
	_tmp127_ = first_local;
	_tmp128_ = vala_symbol_get_name ((ValaSymbol*) _tmp127_);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp131_ = _tmp130_;
	_tmp132_ = vala_member_access_new_simple (_tmp129_, _tmp131_);
	_tmp133_ = _tmp132_;
	_tmp134_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp135_ = _tmp134_;
	_tmp136_ = vala_boolean_literal_new (FALSE, _tmp135_);
	_tmp137_ = _tmp136_;
	_tmp138_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp139_ = _tmp138_;
	_tmp140_ = vala_assignment_new ((ValaExpression*) _tmp133_, (ValaExpression*) _tmp137_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp139_);
	_tmp141_ = _tmp140_;
	_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp143_ = _tmp142_;
	_tmp144_ = vala_expression_statement_new ((ValaExpression*) _tmp141_, _tmp143_);
	_tmp145_ = _tmp144_;
	vala_block_insert_statement (_tmp126_, 1, (ValaStatement*) _tmp145_);
	_vala_code_node_unref0 (_tmp145_);
	_vala_code_node_unref0 (_tmp141_);
	_vala_code_node_unref0 (_tmp137_);
	_vala_code_node_unref0 (_tmp133_);
	_tmp146_ = block;
	_tmp147_ = vala_for_statement_get_body (self);
	_tmp148_ = _tmp147_;
	_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp150_ = _tmp149_;
	_tmp151_ = vala_loop_new (_tmp148_, _tmp150_);
	_tmp152_ = _tmp151_;
	vala_block_add_statement (_tmp146_, (ValaStatement*) _tmp152_);
	_vala_code_node_unref0 (_tmp152_);
	_tmp153_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp154_ = _tmp153_;
	_tmp155_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp154_, VALA_TYPE_BLOCK, ValaBlock));
	parent_block = _tmp155_;
	_tmp156_ = block;
	vala_block_replace_statement (parent_block, (ValaStatement*) self, (ValaStatement*) _tmp156_);
	_tmp157_ = block;
	result = vala_code_node_check ((ValaCodeNode*) _tmp157_, context);
	_vala_code_node_unref0 (parent_block);
	_vala_code_node_unref0 (first_if);
	_vala_code_node_unref0 (iterator_block);
	_vala_code_node_unref0 (first_local);
	_vala_code_node_unref0 (block);
	return result;
}


ValaExpression*
vala_for_statement_get_condition (ValaForStatement* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_condition;
	result = _tmp0_;
	return result;
}


void
vala_for_statement_set_condition (ValaForStatement* self,
                                  ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_condition);
	self->priv->_condition = _tmp0_;
	_tmp1_ = self->priv->_condition;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_condition;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


ValaBlock*
vala_for_statement_get_body (ValaForStatement* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


void
vala_for_statement_set_body (ValaForStatement* self,
                             ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_for_statement_class_init (ValaForStatementClass * klass)
{
	vala_for_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_for_statement_finalize;
	g_type_class_adjust_private_offset (klass, &ValaForStatement_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_for_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_for_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_for_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_for_statement_real_check;
}


static void
vala_for_statement_vala_statement_interface_init (ValaStatementIface * iface)
{
	vala_for_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void
vala_for_statement_instance_init (ValaForStatement * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_for_statement_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializer = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->iterator = (ValaList*) _tmp3_;
}


static void
vala_for_statement_finalize (ValaCodeNode * obj)
{
	ValaForStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FOR_STATEMENT, ValaForStatement);
	_vala_iterable_unref0 (self->priv->initializer);
	_vala_iterable_unref0 (self->priv->iterator);
	_vala_code_node_unref0 (self->priv->_condition);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_for_statement_parent_class)->finalize (obj);
}


/**
 * Represents a for iteration statement in the source code.
 */
GType
vala_for_statement_get_type (void)
{
	static volatile gsize vala_for_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_for_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaForStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_for_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaForStatement), 0, (GInstanceInitFunc) vala_for_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_for_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_for_statement_type_id;
		vala_for_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaForStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_for_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		ValaForStatement_private_offset = g_type_add_instance_private (vala_for_statement_type_id, sizeof (ValaForStatementPrivate));
		g_once_init_leave (&vala_for_statement_type_id__volatile, vala_for_statement_type_id);
	}
	return vala_for_statement_type_id__volatile;
}



