/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};


static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                                      ValaEnum* en);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                          ValaCallable* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = str_array_length1;
		_tmp24_ = len;
		_tmp25_ = strlen ((const gchar*) separator);
		_tmp26_ = _tmp25_;
		_tmp27_ = i;
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
		_tmp28_ = len;
		_tmp29_ = g_malloc (_tmp28_);
		res = _tmp29_;
		_tmp30_ = res;
		_tmp31_ = str_array[0];
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
		ptr = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			i = 1;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < str_array_length1)) {
					break;
				}
				_tmp36_ = ptr;
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
				ptr = _tmp37_;
				_tmp39_ = i;
				_tmp40_ = str_array[_tmp39_];
				if (_tmp40_ != NULL) {
					gint _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = i;
					_tmp42_ = str_array[_tmp41_];
					_tmp38_ = (const gchar*) _tmp42_;
				} else {
					_tmp38_ = "";
				}
				_tmp43_ = ptr;
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
				ptr = _tmp44_;
			}
		}
		_tmp45_ = res;
		res = NULL;
		result = (gchar*) _tmp45_;
		return result;
	} else {
		gchar* _tmp46_;
		_tmp46_ = g_strdup ("");
		result = _tmp46_;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp130_;
	GEqualFunc _tmp131_;
	GEqualFunc _tmp132_;
	ValaHashMap* _tmp133_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp134_;
	ValaHashMap* _tmp135_;
	gboolean _tmp136_ = FALSE;
	ValaMethod* _tmp137_;
	gboolean _tmp282_ = FALSE;
	ValaMethod* _tmp283_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp454_;
	ValaCCodeExpression* _tmp455_;
	ValaMethod* _tmp456_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp480_ = FALSE;
	ValaMethod* _tmp481_;
	gboolean _tmp637_ = FALSE;
	ValaMethod* _tmp638_;
	ValaMethod* _tmp690_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp886_;
	ValaIterator* _tmp887_;
	ValaIterator* _tmp1231_;
	gboolean _tmp1241_ = FALSE;
	gboolean _tmp1242_ = FALSE;
	ValaMethod* _tmp1243_;
	gboolean _tmp1368_ = FALSE;
	ValaDelegate* _tmp1369_;
	gboolean _tmp1466_ = FALSE;
	ValaMethod* _tmp1467_;
	gboolean _tmp1483_;
	gboolean _tmp1484_;
	gboolean _tmp1499_;
	ValaDataType* _tmp1524_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1548_;
	ValaDataType* _tmp1549_;
	ValaDataType* _tmp1550_;
	gboolean _tmp1551_;
	gboolean _tmp1552_ = FALSE;
	ValaDataType* _tmp1553_;
	ValaCCodeFunctionCall* _tmp1582_;
	ValaCCodeFunctionCall* _tmp1583_;
	ValaCCodeExpression* out_param_ref = NULL;
	gboolean _tmp1584_;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1599_;
	ValaCCodeFunctionCall* _tmp1600_;
	ValaCCodeFunctionCall* _tmp1624_;
	gboolean _tmp1648_;
	gboolean _tmp1649_;
	gboolean _tmp1675_;
	gboolean _tmp1676_;
	gboolean _tmp1706_;
	gboolean _tmp1712_ = FALSE;
	gboolean _tmp1713_ = FALSE;
	ValaMethod* _tmp1714_;
	gboolean _tmp1752_ = FALSE;
	gboolean _tmp1753_ = FALSE;
	ValaMethod* _tmp1754_;
	ValaMethod* _tmp1773_;
	gboolean _tmp1890_ = FALSE;
	ValaCodeNode* _tmp1891_;
	ValaCodeNode* _tmp1892_;
	ValaList* _tmp1975_;
	ValaIterator* _tmp1976_;
	gboolean _tmp2061_ = FALSE;
	gboolean _tmp2062_ = FALSE;
	ValaMethod* _tmp2063_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_tostring_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_;
			gboolean _tmp57_;
			_tmp56_ = vala_method_call_get_is_constructv_chainup (expr);
			_tmp57_ = _tmp56_;
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp58_;
				ValaMethod* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaCCodeIdentifier* _tmp62_;
				ValaCCodeIdentifier* _tmp63_;
				_tmp58_ = ccall;
				_tmp59_ = m;
				_tmp60_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_ccode_identifier_new (_tmp61_);
				_tmp63_ = _tmp62_;
				vala_ccode_function_call_set_call (_tmp58_, (ValaCCodeExpression*) _tmp63_);
				_vala_ccode_node_unref0 (_tmp63_);
				_g_free0 (_tmp61_);
			}
		}
	} else {
		ValaDataType* _tmp64_;
		_tmp64_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp65_;
			ValaSignalType* _tmp66_;
			gboolean _tmp67_ = FALSE;
			gboolean _tmp68_ = FALSE;
			ValaMemberAccess* _tmp69_;
			_tmp65_ = itype;
			_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp66_;
			_tmp69_ = ma;
			if (_tmp69_ != NULL) {
				ValaMemberAccess* _tmp70_;
				ValaExpression* _tmp71_;
				ValaExpression* _tmp72_;
				_tmp70_ = ma;
				_tmp71_ = vala_member_access_get_inner (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp68_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp68_ = FALSE;
			}
			if (_tmp68_) {
				ValaSignalType* _tmp73_;
				ValaSignal* _tmp74_;
				ValaSignal* _tmp75_;
				gboolean _tmp76_;
				gboolean _tmp77_;
				_tmp73_ = sig_type;
				_tmp74_ = vala_signal_type_get_signal_symbol (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_signal_get_is_virtual (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp67_ = _tmp77_;
			} else {
				_tmp67_ = FALSE;
			}
			if (_tmp67_) {
				ValaSignalType* _tmp78_;
				ValaSignal* _tmp79_;
				ValaSignal* _tmp80_;
				ValaMethod* _tmp81_;
				ValaMethod* _tmp82_;
				ValaMethod* _tmp83_;
				_tmp78_ = sig_type;
				_tmp79_ = vala_signal_type_get_signal_symbol (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_signal_get_default_handler (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = _vala_code_node_ref0 (_tmp82_);
				_vala_code_node_unref0 (m);
				m = _tmp83_;
			} else {
				ValaExpression* _tmp84_;
				ValaExpression* _tmp85_;
				ValaCCodeExpression* _tmp86_;
				_tmp84_ = vala_method_call_get_call (expr);
				_tmp85_ = _tmp84_;
				_tmp86_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp85_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp87_;
			_tmp87_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp88_;
				ValaObjectTypeSymbol* _tmp89_;
				ValaObjectTypeSymbol* _tmp90_;
				ValaClass* _tmp91_;
				ValaClass* _tmp92_;
				ValaCreationMethod* _tmp93_;
				ValaCreationMethod* _tmp94_;
				ValaMethod* _tmp95_;
				ValaMethod* _tmp96_;
				ValaCCodeFile* _tmp97_;
				gchar* real_name = NULL;
				ValaMethod* _tmp98_;
				gchar* _tmp99_;
				gboolean _tmp100_;
				gboolean _tmp101_;
				const gchar* _tmp104_;
				ValaCCodeIdentifier* _tmp105_;
				ValaCCodeIdentifier* _tmp106_;
				ValaCCodeFunctionCall* _tmp107_;
				_tmp88_ = itype;
				_tmp89_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp90_ = _tmp89_;
				_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp91_;
				_tmp92_ = cl;
				_tmp93_ = vala_class_get_default_construction_method (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = _vala_code_node_ref0 ((ValaMethod*) _tmp94_);
				_vala_code_node_unref0 (m);
				m = _tmp95_;
				_tmp96_ = m;
				_tmp97_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp96_, _tmp97_);
				_tmp98_ = m;
				_tmp99_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp98_);
				real_name = _tmp99_;
				_tmp100_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp101_ = _tmp100_;
				if (_tmp101_) {
					ValaMethod* _tmp102_;
					gchar* _tmp103_;
					_tmp102_ = m;
					_tmp103_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp103_;
				}
				_tmp104_ = real_name;
				_tmp105_ = vala_ccode_identifier_new (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp106_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp107_;
				_vala_ccode_node_unref0 (_tmp106_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp108_;
				_tmp108_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp109_;
					ValaTypeSymbol* _tmp110_;
					ValaTypeSymbol* _tmp111_;
					ValaStruct* _tmp112_;
					ValaStruct* _tmp113_;
					ValaMethod* _tmp114_;
					ValaMethod* _tmp115_;
					ValaMethod* _tmp116_;
					ValaMethod* _tmp117_;
					ValaCCodeFile* _tmp118_;
					ValaMethod* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					ValaCCodeIdentifier* _tmp122_;
					ValaCCodeIdentifier* _tmp123_;
					ValaCCodeFunctionCall* _tmp124_;
					_tmp109_ = itype;
					_tmp110_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp111_ = _tmp110_;
					_tmp112_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp112_;
					_tmp113_ = st;
					_tmp114_ = vala_struct_get_default_construction_method (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = _vala_code_node_ref0 (_tmp115_);
					_vala_code_node_unref0 (m);
					m = _tmp116_;
					_tmp117_ = m;
					_tmp118_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp117_, _tmp118_);
					_tmp119_ = m;
					_tmp120_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = vala_ccode_identifier_new (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp123_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp124_;
					_vala_ccode_node_unref0 (_tmp123_);
					_g_free0 (_tmp121_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp125_;
					_tmp125_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp125_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp126_;
						ValaDelegate* _tmp127_;
						ValaDelegate* _tmp128_;
						ValaDelegate* _tmp129_;
						_tmp126_ = itype;
						_tmp127_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp128_ = _tmp127_;
						_tmp129_ = _vala_code_node_ref0 (_tmp128_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp129_;
					}
				}
			}
		}
	}
	_tmp130_ = g_direct_hash;
	_tmp131_ = g_direct_equal;
	_tmp132_ = g_direct_equal;
	_tmp133_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp130_, _tmp131_, _tmp132_);
	in_arg_map = _tmp133_;
	_tmp134_ = in_arg_map;
	_tmp135_ = _vala_map_ref0 (_tmp134_);
	out_arg_map = _tmp135_;
	_tmp137_ = m;
	if (_tmp137_ != NULL) {
		ValaMethod* _tmp138_;
		gboolean _tmp139_;
		gboolean _tmp140_;
		_tmp138_ = m;
		_tmp139_ = vala_method_get_coroutine (_tmp138_);
		_tmp140_ = _tmp139_;
		_tmp136_ = _tmp140_;
	} else {
		_tmp136_ = FALSE;
	}
	if (_tmp136_) {
		ValaMethod* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		ValaCCodeIdentifier* _tmp144_;
		ValaCCodeIdentifier* _tmp145_;
		ValaCCodeFunctionCall* _tmp146_;
		ValaMethod* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		ValaCCodeIdentifier* _tmp150_;
		ValaCCodeIdentifier* _tmp151_;
		ValaCCodeFunctionCall* _tmp152_;
		ValaMemberAccess* _tmp153_;
		ValaExpression* _tmp154_;
		ValaExpression* _tmp155_;
		gboolean _tmp233_ = FALSE;
		ValaMemberAccess* _tmp234_;
		const gchar* _tmp235_;
		const gchar* _tmp236_;
		_tmp141_ = m;
		_tmp142_ = vala_get_ccode_name ((ValaCodeNode*) _tmp141_);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_ccode_identifier_new (_tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp145_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp146_;
		_vala_ccode_node_unref0 (_tmp145_);
		_g_free0 (_tmp143_);
		_tmp147_ = m;
		_tmp148_ = vala_get_ccode_finish_name (_tmp147_);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_ccode_identifier_new (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp151_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp152_;
		_vala_ccode_node_unref0 (_tmp151_);
		_g_free0 (_tmp149_);
		_tmp153_ = ma;
		_tmp154_ = vala_member_access_get_inner (_tmp153_);
		_tmp155_ = _tmp154_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp155_, VALA_TYPE_BASE_ACCESS)) {
			ValaMethod* _tmp156_;
			ValaMethod* _tmp157_;
			ValaMethod* _tmp158_;
			_tmp156_ = m;
			_tmp157_ = vala_method_get_base_method (_tmp156_);
			_tmp158_ = _tmp157_;
			if (_tmp158_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp159_;
				ValaMethod* _tmp160_;
				ValaMethod* _tmp161_;
				ValaSymbol* _tmp162_;
				ValaSymbol* _tmp163_;
				ValaClass* _tmp164_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaClass* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				ValaCCodeIdentifier* _tmp170_;
				ValaCCodeIdentifier* _tmp171_;
				ValaCCodeFunctionCall* _tmp172_;
				ValaCCodeFunctionCall* _tmp173_;
				ValaCCodeFunctionCall* _tmp174_;
				ValaClass* _tmp175_;
				ValaClass* _tmp176_;
				gchar* _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				ValaCCodeIdentifier* _tmp181_;
				ValaCCodeIdentifier* _tmp182_;
				ValaCCodeFunctionCall* _tmp183_;
				ValaCCodeFunctionCall* _tmp184_;
				ValaMethod* _tmp185_;
				gchar* _tmp186_;
				gchar* _tmp187_;
				ValaCCodeMemberAccess* _tmp188_;
				ValaCCodeMemberAccess* _tmp189_;
				ValaCCodeFunctionCall* _tmp190_;
				ValaCCodeFunctionCall* _tmp191_;
				ValaMethod* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				ValaCCodeMemberAccess* _tmp195_;
				ValaCCodeMemberAccess* _tmp196_;
				_tmp159_ = m;
				_tmp160_ = vala_method_get_base_method (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, VALA_TYPE_CLASS, ValaClass));
				base_class = _tmp164_;
				_tmp165_ = base_class;
				_tmp166_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp165_, NULL);
				_tmp167_ = _tmp166_;
				_tmp168_ = g_strdup_printf ("%s_CLASS", _tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = vala_ccode_identifier_new (_tmp169_);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp171_);
				_tmp173_ = _tmp172_;
				_vala_ccode_node_unref0 (_tmp171_);
				_g_free0 (_tmp169_);
				_g_free0 (_tmp167_);
				vcast = _tmp173_;
				_tmp174_ = vcast;
				_tmp175_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp176_, NULL);
				_tmp178_ = _tmp177_;
				_tmp179_ = g_strdup_printf ("%s_parent_class", _tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = vala_ccode_identifier_new (_tmp180_);
				_tmp182_ = _tmp181_;
				vala_ccode_function_call_add_argument (_tmp174_, (ValaCCodeExpression*) _tmp182_);
				_vala_ccode_node_unref0 (_tmp182_);
				_g_free0 (_tmp180_);
				_g_free0 (_tmp178_);
				_tmp183_ = async_call;
				_tmp184_ = vcast;
				_tmp185_ = m;
				_tmp186_ = vala_get_ccode_vfunc_name (_tmp185_);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp184_, _tmp187_);
				_tmp189_ = _tmp188_;
				vala_ccode_function_call_set_call (_tmp183_, (ValaCCodeExpression*) _tmp189_);
				_vala_ccode_node_unref0 (_tmp189_);
				_g_free0 (_tmp187_);
				_tmp190_ = finish_call;
				_tmp191_ = vcast;
				_tmp192_ = m;
				_tmp193_ = vala_get_ccode_finish_vfunc_name (_tmp192_);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp191_, _tmp194_);
				_tmp196_ = _tmp195_;
				vala_ccode_function_call_set_call (_tmp190_, (ValaCCodeExpression*) _tmp196_);
				_vala_ccode_node_unref0 (_tmp196_);
				_g_free0 (_tmp194_);
				_vala_ccode_node_unref0 (vcast);
				_vala_code_node_unref0 (base_class);
			} else {
				ValaMethod* _tmp197_;
				ValaMethod* _tmp198_;
				ValaMethod* _tmp199_;
				_tmp197_ = m;
				_tmp198_ = vala_method_get_base_interface_method (_tmp197_);
				_tmp199_ = _tmp198_;
				if (_tmp199_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp200_;
					ValaMethod* _tmp201_;
					ValaMethod* _tmp202_;
					ValaSymbol* _tmp203_;
					ValaSymbol* _tmp204_;
					ValaInterface* _tmp205_;
					gchar* parent_iface_var = NULL;
					ValaClass* _tmp206_;
					ValaClass* _tmp207_;
					gchar* _tmp208_;
					gchar* _tmp209_;
					ValaInterface* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					gchar* _tmp214_;
					ValaCCodeFunctionCall* _tmp215_;
					const gchar* _tmp216_;
					ValaCCodeIdentifier* _tmp217_;
					ValaCCodeIdentifier* _tmp218_;
					ValaMethod* _tmp219_;
					gchar* _tmp220_;
					gchar* _tmp221_;
					ValaCCodeMemberAccess* _tmp222_;
					ValaCCodeMemberAccess* _tmp223_;
					ValaCCodeFunctionCall* _tmp224_;
					const gchar* _tmp225_;
					ValaCCodeIdentifier* _tmp226_;
					ValaCCodeIdentifier* _tmp227_;
					ValaMethod* _tmp228_;
					gchar* _tmp229_;
					gchar* _tmp230_;
					ValaCCodeMemberAccess* _tmp231_;
					ValaCCodeMemberAccess* _tmp232_;
					_tmp200_ = m;
					_tmp201_ = vala_method_get_base_interface_method (_tmp200_);
					_tmp202_ = _tmp201_;
					_tmp203_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp202_);
					_tmp204_ = _tmp203_;
					_tmp205_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_INTERFACE, ValaInterface));
					base_iface = _tmp205_;
					_tmp206_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp207_ = _tmp206_;
					_tmp208_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp207_, NULL);
					_tmp209_ = _tmp208_;
					_tmp210_ = base_iface;
					_tmp211_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp210_, NULL);
					_tmp212_ = _tmp211_;
					_tmp213_ = g_strdup_printf ("%s_%s_parent_iface", _tmp209_, _tmp212_);
					_tmp214_ = _tmp213_;
					_g_free0 (_tmp212_);
					_g_free0 (_tmp209_);
					parent_iface_var = _tmp214_;
					_tmp215_ = async_call;
					_tmp216_ = parent_iface_var;
					_tmp217_ = vala_ccode_identifier_new (_tmp216_);
					_tmp218_ = _tmp217_;
					_tmp219_ = m;
					_tmp220_ = vala_get_ccode_vfunc_name (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp218_, _tmp221_);
					_tmp223_ = _tmp222_;
					vala_ccode_function_call_set_call (_tmp215_, (ValaCCodeExpression*) _tmp223_);
					_vala_ccode_node_unref0 (_tmp223_);
					_g_free0 (_tmp221_);
					_vala_ccode_node_unref0 (_tmp218_);
					_tmp224_ = finish_call;
					_tmp225_ = parent_iface_var;
					_tmp226_ = vala_ccode_identifier_new (_tmp225_);
					_tmp227_ = _tmp226_;
					_tmp228_ = m;
					_tmp229_ = vala_get_ccode_finish_vfunc_name (_tmp228_);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp227_, _tmp230_);
					_tmp232_ = _tmp231_;
					vala_ccode_function_call_set_call (_tmp224_, (ValaCCodeExpression*) _tmp232_);
					_vala_ccode_node_unref0 (_tmp232_);
					_g_free0 (_tmp230_);
					_vala_ccode_node_unref0 (_tmp227_);
					_g_free0 (parent_iface_var);
					_vala_code_node_unref0 (base_iface);
				}
			}
		}
		_tmp234_ = ma;
		_tmp235_ = vala_member_access_get_member_name (_tmp234_);
		_tmp236_ = _tmp235_;
		if (g_strcmp0 (_tmp236_, "begin") == 0) {
			ValaMemberAccess* _tmp237_;
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			ValaSymbol* _tmp240_;
			ValaSymbol* _tmp241_;
			ValaMemberAccess* _tmp242_;
			ValaSymbol* _tmp243_;
			ValaSymbol* _tmp244_;
			_tmp237_ = ma;
			_tmp238_ = vala_member_access_get_inner (_tmp237_);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_expression_get_symbol_reference (_tmp239_);
			_tmp241_ = _tmp240_;
			_tmp242_ = ma;
			_tmp243_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp242_);
			_tmp244_ = _tmp243_;
			_tmp233_ = _tmp241_ == _tmp244_;
		} else {
			_tmp233_ = FALSE;
		}
		if (_tmp233_) {
			ValaCCodeFunctionCall* _tmp245_;
			ValaCCodeFunctionCall* _tmp246_;
			ValaMethod* _tmp247_;
			ValaList* _tmp248_;
			_tmp245_ = async_call;
			_tmp246_ = _vala_ccode_node_ref0 (_tmp245_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp246_;
			_tmp247_ = m;
			_tmp248_ = vala_method_get_async_begin_parameters (_tmp247_);
			_vala_iterable_unref0 (params);
			params = _tmp248_;
		} else {
			gboolean _tmp249_ = FALSE;
			ValaMemberAccess* _tmp250_;
			const gchar* _tmp251_;
			const gchar* _tmp252_;
			_tmp250_ = ma;
			_tmp251_ = vala_member_access_get_member_name (_tmp250_);
			_tmp252_ = _tmp251_;
			if (g_strcmp0 (_tmp252_, "end") == 0) {
				ValaMemberAccess* _tmp253_;
				ValaExpression* _tmp254_;
				ValaExpression* _tmp255_;
				ValaSymbol* _tmp256_;
				ValaSymbol* _tmp257_;
				ValaMemberAccess* _tmp258_;
				ValaSymbol* _tmp259_;
				ValaSymbol* _tmp260_;
				_tmp253_ = ma;
				_tmp254_ = vala_member_access_get_inner (_tmp253_);
				_tmp255_ = _tmp254_;
				_tmp256_ = vala_expression_get_symbol_reference (_tmp255_);
				_tmp257_ = _tmp256_;
				_tmp258_ = ma;
				_tmp259_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp258_);
				_tmp260_ = _tmp259_;
				_tmp249_ = _tmp257_ == _tmp260_;
			} else {
				_tmp249_ = FALSE;
			}
			if (_tmp249_) {
				ValaCCodeFunctionCall* _tmp261_;
				ValaCCodeFunctionCall* _tmp262_;
				ValaMethod* _tmp263_;
				ValaList* _tmp264_;
				_tmp261_ = finish_call;
				_tmp262_ = _vala_ccode_node_ref0 (_tmp261_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp262_;
				_tmp263_ = m;
				_tmp264_ = vala_method_get_async_end_parameters (_tmp263_);
				_vala_iterable_unref0 (params);
				params = _tmp264_;
			} else {
				gboolean _tmp265_;
				gboolean _tmp266_;
				_tmp265_ = vala_method_call_get_is_yield_expression (expr);
				_tmp266_ = _tmp265_;
				if (!_tmp266_) {
					ValaCCodeFunctionCall* _tmp267_;
					ValaCCodeFunctionCall* _tmp268_;
					ValaMethod* _tmp269_;
					ValaList* _tmp270_;
					_tmp267_ = async_call;
					_tmp268_ = _vala_ccode_node_ref0 (_tmp267_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp268_;
					_tmp269_ = m;
					_tmp270_ = vala_method_get_async_begin_parameters (_tmp269_);
					_vala_iterable_unref0 (params);
					params = _tmp270_;
				} else {
					ValaCCodeFunctionCall* _tmp271_;
					ValaCCodeFunctionCall* _tmp272_;
					GHashFunc _tmp273_;
					GEqualFunc _tmp274_;
					GEqualFunc _tmp275_;
					ValaHashMap* _tmp276_;
					ValaHashMap* _tmp277_;
					ValaCCodeIdentifier* _tmp278_;
					ValaCCodeIdentifier* _tmp279_;
					ValaCCodeMemberAccess* _tmp280_;
					ValaCCodeMemberAccess* _tmp281_;
					_tmp271_ = finish_call;
					_tmp272_ = _vala_ccode_node_ref0 (_tmp271_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp272_;
					_tmp273_ = g_direct_hash;
					_tmp274_ = g_direct_equal;
					_tmp275_ = g_direct_equal;
					_tmp276_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp273_, _tmp274_, _tmp275_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp276_;
					_tmp277_ = out_arg_map;
					_tmp278_ = vala_ccode_identifier_new ("_data_");
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp279_, "_res_");
					_tmp281_ = _tmp280_;
					vala_map_set ((ValaMap*) _tmp277_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp281_);
					_vala_ccode_node_unref0 (_tmp281_);
					_vala_ccode_node_unref0 (_tmp279_);
				}
			}
		}
	}
	_tmp283_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp283_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp284_;
		ValaSymbol* _tmp285_;
		ValaSymbol* _tmp286_;
		_tmp284_ = m;
		_tmp285_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp284_);
		_tmp286_ = _tmp285_;
		_tmp282_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp286_, VALA_TYPE_CLASS);
	} else {
		_tmp282_ = FALSE;
	}
	if (_tmp282_) {
		ValaMethod* _tmp287_;
		ValaSymbol* _tmp288_;
		ValaSymbol* _tmp289_;
		gboolean _tmp290_;
		gboolean _tmp291_;
		ValaClass* _tmp295_;
		ValaClass* _tmp296_;
		gboolean _tmp297_;
		gboolean _tmp298_;
		_tmp287_ = m;
		_tmp288_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp287_);
		_tmp289_ = _tmp288_;
		_tmp290_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_CLASS, ValaClass));
		_tmp291_ = _tmp290_;
		if (!_tmp291_) {
			ValaCCodeFunctionCall* _tmp292_;
			ValaCCodeExpression* _tmp293_;
			ValaCCodeExpression* _tmp294_;
			_tmp292_ = ccall;
			_tmp293_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
			_tmp294_ = _tmp293_;
			vala_ccode_function_call_add_argument (_tmp292_, _tmp294_);
			_vala_ccode_node_unref0 (_tmp294_);
		}
		_tmp295_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp296_ = _tmp295_;
		_tmp297_ = vala_class_get_is_compact (_tmp296_);
		_tmp298_ = _tmp297_;
		if (!_tmp298_) {
			ValaClass* _tmp299_;
			ValaClass* _tmp300_;
			ValaMethod* _tmp301_;
			ValaSymbol* _tmp302_;
			ValaSymbol* _tmp303_;
			_tmp299_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp300_ = _tmp299_;
			_tmp301_ = m;
			_tmp302_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp301_);
			_tmp303_ = _tmp302_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp300_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp303_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp304_;
					ValaClass* _tmp305_;
					ValaList* _tmp306_;
					gint _base_type_size = 0;
					ValaList* _tmp307_;
					gint _tmp308_;
					gint _tmp309_;
					gint _base_type_index = 0;
					_tmp304_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp305_ = _tmp304_;
					_tmp306_ = vala_class_get_base_types (_tmp305_);
					_base_type_list = _tmp306_;
					_tmp307_ = _base_type_list;
					_tmp308_ = vala_collection_get_size ((ValaCollection*) _tmp307_);
					_tmp309_ = _tmp308_;
					_base_type_size = _tmp309_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp310_;
						gint _tmp311_;
						gint _tmp312_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp313_;
						gint _tmp314_;
						gpointer _tmp315_;
						ValaDataType* _tmp316_;
						ValaTypeSymbol* _tmp317_;
						ValaTypeSymbol* _tmp318_;
						_tmp310_ = _base_type_index;
						_base_type_index = _tmp310_ + 1;
						_tmp311_ = _base_type_index;
						_tmp312_ = _base_type_size;
						if (!(_tmp311_ < _tmp312_)) {
							break;
						}
						_tmp313_ = _base_type_list;
						_tmp314_ = _base_type_index;
						_tmp315_ = vala_list_get (_tmp313_, _tmp314_);
						base_type = (ValaDataType*) _tmp315_;
						_tmp316_ = base_type;
						_tmp317_ = vala_data_type_get_data_type (_tmp316_);
						_tmp318_ = _tmp317_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp318_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp319_;
							gchar* _tmp320_;
							gchar* _tmp321_;
							gboolean _tmp322_;
							ValaHashMap* _tmp327_;
							ValaDataType* _tmp328_;
							ValaList* _tmp329_;
							ValaList* _tmp330_;
							ValaList* _tmp331_;
							type_parameters = NULL;
							_tmp319_ = m;
							_tmp320_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp319_);
							_tmp321_ = _tmp320_;
							_tmp322_ = g_strcmp0 (_tmp321_, "g_object_new") == 0;
							_g_free0 (_tmp321_);
							if (_tmp322_) {
								ValaDataType* _tmp323_;
								ValaTypeSymbol* _tmp324_;
								ValaTypeSymbol* _tmp325_;
								ValaList* _tmp326_;
								_tmp323_ = base_type;
								_tmp324_ = vala_data_type_get_data_type (_tmp323_);
								_tmp325_ = _tmp324_;
								_tmp326_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp325_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp326_;
							}
							_tmp327_ = in_arg_map;
							_tmp328_ = base_type;
							_tmp329_ = vala_data_type_get_type_arguments (_tmp328_);
							_tmp330_ = _tmp329_;
							_tmp331_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp327_, _tmp330_, (ValaCodeNode*) expr, TRUE, _tmp331_);
							_vala_iterable_unref0 (_tmp330_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp332_;
				ValaSymbol* _tmp333_;
				ValaSymbol* _tmp334_;
				ValaClass* _tmp335_;
				type_param_index = 0;
				_tmp332_ = m;
				_tmp333_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp332_);
				_tmp334_ = _tmp333_;
				_tmp335_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp334_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp335_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp336_;
					ValaList* _tmp337_;
					gint _type_param_size = 0;
					ValaList* _tmp338_;
					gint _tmp339_;
					gint _tmp340_;
					gint _type_param_index = 0;
					_tmp336_ = cl;
					_tmp337_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp336_);
					_type_param_list = _tmp337_;
					_tmp338_ = _type_param_list;
					_tmp339_ = vala_collection_get_size ((ValaCollection*) _tmp338_);
					_tmp340_ = _tmp339_;
					_type_param_size = _tmp340_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp341_;
						gint _tmp342_;
						gint _tmp343_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp344_;
						gint _tmp345_;
						gpointer _tmp346_;
						ValaHashMap* _tmp347_;
						gint _tmp348_;
						ValaTypeParameter* _tmp349_;
						const gchar* _tmp350_;
						const gchar* _tmp351_;
						gchar* _tmp352_;
						gchar* _tmp353_;
						gchar* _tmp354_;
						gchar* _tmp355_;
						ValaCCodeIdentifier* _tmp356_;
						ValaCCodeIdentifier* _tmp357_;
						ValaHashMap* _tmp358_;
						gint _tmp359_;
						ValaTypeParameter* _tmp360_;
						const gchar* _tmp361_;
						const gchar* _tmp362_;
						gchar* _tmp363_;
						gchar* _tmp364_;
						gchar* _tmp365_;
						gchar* _tmp366_;
						ValaCCodeIdentifier* _tmp367_;
						ValaCCodeIdentifier* _tmp368_;
						ValaHashMap* _tmp369_;
						gint _tmp370_;
						ValaTypeParameter* _tmp371_;
						const gchar* _tmp372_;
						const gchar* _tmp373_;
						gchar* _tmp374_;
						gchar* _tmp375_;
						gchar* _tmp376_;
						gchar* _tmp377_;
						ValaCCodeIdentifier* _tmp378_;
						ValaCCodeIdentifier* _tmp379_;
						gint _tmp380_;
						_tmp341_ = _type_param_index;
						_type_param_index = _tmp341_ + 1;
						_tmp342_ = _type_param_index;
						_tmp343_ = _type_param_size;
						if (!(_tmp342_ < _tmp343_)) {
							break;
						}
						_tmp344_ = _type_param_list;
						_tmp345_ = _type_param_index;
						_tmp346_ = vala_list_get (_tmp344_, _tmp345_);
						type_param = (ValaTypeParameter*) _tmp346_;
						_tmp347_ = in_arg_map;
						_tmp348_ = type_param_index;
						_tmp349_ = type_param;
						_tmp350_ = vala_symbol_get_name ((ValaSymbol*) _tmp349_);
						_tmp351_ = _tmp350_;
						_tmp352_ = g_utf8_strdown (_tmp351_, (gssize) -1);
						_tmp353_ = _tmp352_;
						_tmp354_ = g_strdup_printf ("%s_type", _tmp353_);
						_tmp355_ = _tmp354_;
						_tmp356_ = vala_ccode_identifier_new (_tmp355_);
						_tmp357_ = _tmp356_;
						vala_map_set ((ValaMap*) _tmp347_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp348_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp357_);
						_vala_ccode_node_unref0 (_tmp357_);
						_g_free0 (_tmp355_);
						_g_free0 (_tmp353_);
						_tmp358_ = in_arg_map;
						_tmp359_ = type_param_index;
						_tmp360_ = type_param;
						_tmp361_ = vala_symbol_get_name ((ValaSymbol*) _tmp360_);
						_tmp362_ = _tmp361_;
						_tmp363_ = g_utf8_strdown (_tmp362_, (gssize) -1);
						_tmp364_ = _tmp363_;
						_tmp365_ = g_strdup_printf ("%s_dup_func", _tmp364_);
						_tmp366_ = _tmp365_;
						_tmp367_ = vala_ccode_identifier_new (_tmp366_);
						_tmp368_ = _tmp367_;
						vala_map_set ((ValaMap*) _tmp358_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp359_) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp368_);
						_vala_ccode_node_unref0 (_tmp368_);
						_g_free0 (_tmp366_);
						_g_free0 (_tmp364_);
						_tmp369_ = in_arg_map;
						_tmp370_ = type_param_index;
						_tmp371_ = type_param;
						_tmp372_ = vala_symbol_get_name ((ValaSymbol*) _tmp371_);
						_tmp373_ = _tmp372_;
						_tmp374_ = g_utf8_strdown (_tmp373_, (gssize) -1);
						_tmp375_ = _tmp374_;
						_tmp376_ = g_strdup_printf ("%s_destroy_func", _tmp375_);
						_tmp377_ = _tmp376_;
						_tmp378_ = vala_ccode_identifier_new (_tmp377_);
						_tmp379_ = _tmp378_;
						vala_map_set ((ValaMap*) _tmp369_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp370_) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp379_);
						_vala_ccode_node_unref0 (_tmp379_);
						_g_free0 (_tmp377_);
						_g_free0 (_tmp375_);
						_tmp380_ = type_param_index;
						type_param_index = _tmp380_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp381_;
			ValaClass* _tmp382_;
			ValaClass* _tmp383_;
			ValaClass* _tmp384_;
			ValaClass* _tmp385_;
			_tmp381_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp382_ = _tmp381_;
			_tmp383_ = vala_class_get_base_class (_tmp382_);
			_tmp384_ = _tmp383_;
			_tmp385_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp384_ == _tmp385_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp386_;
				ValaClass* _tmp387_;
				gchar* _tmp388_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp389_;
				ValaCCodeDeclaration* _tmp390_;
				ValaCCodeDeclaration* _tmp391_;
				const gchar* _tmp392_;
				const gchar* _tmp393_;
				const gchar* _tmp394_;
				const gchar* _tmp395_;
				gchar* _tmp396_;
				gchar* _tmp397_;
				ValaCCodeConstant* _tmp398_;
				ValaCCodeConstant* _tmp399_;
				ValaCCodeVariableDeclarator* _tmp400_;
				ValaCCodeVariableDeclarator* _tmp401_;
				ValaCCodeFunction* _tmp402_;
				ValaCCodeFunction* _tmp403_;
				ValaCCodeDeclaration* _tmp404_;
				ValaCCodeFunctionCall* _tmp405_;
				ValaCCodeIdentifier* _tmp406_;
				ValaCCodeIdentifier* _tmp407_;
				ValaCCodeUnaryExpression* _tmp408_;
				ValaCCodeUnaryExpression* _tmp409_;
				ValaCCodeCastExpression* _tmp410_;
				ValaCCodeCastExpression* _tmp411_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp412_;
				ValaCCodeIdentifier* _tmp413_;
				ValaCCodeFunctionCall* _tmp414_;
				ValaCCodeFunctionCall* _tmp415_;
				ValaCCodeFunctionCall* _tmp416_;
				ValaClass* _tmp417_;
				ValaClass* _tmp418_;
				gchar* _tmp419_;
				gchar* _tmp420_;
				ValaCCodeIdentifier* _tmp421_;
				ValaCCodeIdentifier* _tmp422_;
				ValaCCodeFunctionCall* _tmp423_;
				ValaCCodeFunctionCall* _tmp424_;
				_tmp386_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp387_ = _tmp386_;
				_tmp388_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp387_, NULL);
				class_prefix = _tmp388_;
				_tmp389_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp389_;
				_tmp390_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp390_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp391_ = funcs;
				_tmp392_ = class_prefix;
				_tmp393_ = class_prefix;
				_tmp394_ = class_prefix;
				_tmp395_ = class_prefix;
				_tmp396_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp392_, _tmp393_, _tmp394_, _tmp395_);
				_tmp397_ = _tmp396_;
				_tmp398_ = vala_ccode_constant_new (_tmp397_);
				_tmp399_ = _tmp398_;
				_tmp400_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp399_, NULL);
				_tmp401_ = _tmp400_;
				vala_ccode_declaration_add_declarator (_tmp391_, (ValaCCodeDeclarator*) _tmp401_);
				_vala_ccode_node_unref0 (_tmp401_);
				_vala_ccode_node_unref0 (_tmp399_);
				_g_free0 (_tmp397_);
				_tmp402_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp403_ = _tmp402_;
				_tmp404_ = funcs;
				vala_ccode_function_add_statement (_tmp403_, (ValaCCodeNode*) _tmp404_);
				_tmp405_ = ccall;
				_tmp406_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp407_ = _tmp406_;
				_tmp408_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp407_);
				_tmp409_ = _tmp408_;
				_tmp410_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp409_, "GSourceFuncs *");
				_tmp411_ = _tmp410_;
				vala_ccode_function_call_add_argument (_tmp405_, (ValaCCodeExpression*) _tmp411_);
				_vala_ccode_node_unref0 (_tmp411_);
				_vala_ccode_node_unref0 (_tmp409_);
				_vala_ccode_node_unref0 (_tmp407_);
				_tmp412_ = vala_ccode_identifier_new ("sizeof");
				_tmp413_ = _tmp412_;
				_tmp414_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp413_);
				_tmp415_ = _tmp414_;
				_vala_ccode_node_unref0 (_tmp413_);
				csizeof = _tmp415_;
				_tmp416_ = csizeof;
				_tmp417_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp418_ = _tmp417_;
				_tmp419_ = vala_get_ccode_name ((ValaCodeNode*) _tmp418_);
				_tmp420_ = _tmp419_;
				_tmp421_ = vala_ccode_identifier_new (_tmp420_);
				_tmp422_ = _tmp421_;
				vala_ccode_function_call_add_argument (_tmp416_, (ValaCCodeExpression*) _tmp422_);
				_vala_ccode_node_unref0 (_tmp422_);
				_g_free0 (_tmp420_);
				_tmp423_ = ccall;
				_tmp424_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp423_, (ValaCCodeExpression*) _tmp424_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp425_ = FALSE;
		ValaMethod* _tmp426_;
		_tmp426_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp426_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp427_;
			ValaSymbol* _tmp428_;
			ValaSymbol* _tmp429_;
			_tmp427_ = m;
			_tmp428_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp427_);
			_tmp429_ = _tmp428_;
			_tmp425_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp429_, VALA_TYPE_STRUCT);
		} else {
			_tmp425_ = FALSE;
		}
		if (_tmp425_) {
			ValaCCodeFunctionCall* _tmp430_;
			ValaCCodeExpression* _tmp431_;
			ValaCCodeExpression* _tmp432_;
			_tmp430_ = ccall;
			_tmp431_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp432_ = _tmp431_;
			vala_ccode_function_call_add_argument (_tmp430_, _tmp432_);
			_vala_ccode_node_unref0 (_tmp432_);
		} else {
			gboolean _tmp433_ = FALSE;
			gboolean _tmp434_ = FALSE;
			gboolean _tmp435_ = FALSE;
			gboolean _tmp436_ = FALSE;
			ValaMethod* _tmp437_;
			_tmp437_ = m;
			if (_tmp437_ != NULL) {
				ValaMethod* _tmp438_;
				ValaList* _tmp439_;
				ValaList* _tmp440_;
				gint _tmp441_;
				gint _tmp442_;
				_tmp438_ = m;
				_tmp439_ = vala_method_get_type_parameters (_tmp438_);
				_tmp440_ = _tmp439_;
				_tmp441_ = vala_collection_get_size ((ValaCollection*) _tmp440_);
				_tmp442_ = _tmp441_;
				_tmp436_ = _tmp442_ > 0;
				_vala_iterable_unref0 (_tmp440_);
			} else {
				_tmp436_ = FALSE;
			}
			if (_tmp436_) {
				ValaMethod* _tmp443_;
				_tmp443_ = m;
				_tmp435_ = !vala_get_ccode_has_generic_type_parameter (_tmp443_);
			} else {
				_tmp435_ = FALSE;
			}
			if (_tmp435_) {
				ValaMethod* _tmp444_;
				_tmp444_ = m;
				_tmp434_ = !vala_get_ccode_simple_generics (_tmp444_);
			} else {
				_tmp434_ = FALSE;
			}
			if (_tmp434_) {
				gboolean _tmp445_ = FALSE;
				ValaCCodeFunctionCall* _tmp446_;
				ValaCCodeFunctionCall* _tmp447_;
				_tmp446_ = ccall;
				_tmp447_ = finish_call;
				if (_tmp446_ != _tmp447_) {
					_tmp445_ = TRUE;
				} else {
					gboolean _tmp448_;
					gboolean _tmp449_;
					_tmp448_ = vala_method_call_get_is_yield_expression (expr);
					_tmp449_ = _tmp448_;
					_tmp445_ = _tmp449_;
				}
				_tmp433_ = _tmp445_;
			} else {
				_tmp433_ = FALSE;
			}
			if (_tmp433_) {
				ValaHashMap* _tmp450_;
				ValaMemberAccess* _tmp451_;
				ValaList* _tmp452_;
				ValaList* _tmp453_;
				_tmp450_ = in_arg_map;
				_tmp451_ = ma;
				_tmp452_ = vala_member_access_get_type_arguments (_tmp451_);
				_tmp453_ = _tmp452_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp450_, _tmp453_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp453_);
			}
		}
	}
	_tmp454_ = ccall;
	_tmp455_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp454_);
	ccall_expr = _tmp455_;
	_tmp456_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp456_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp457_;
		ValaExpression* _tmp458_;
		ValaExpression* _tmp459_;
		ValaDataType* _tmp460_;
		ValaDataType* _tmp461_;
		ValaArrayType* _tmp462_;
		ValaHashMap* _tmp463_;
		ValaArrayType* _tmp464_;
		ValaDataType* _tmp465_;
		ValaDataType* _tmp466_;
		gchar* _tmp467_;
		gchar* _tmp468_;
		ValaCCodeIdentifier* _tmp469_;
		ValaCCodeIdentifier* _tmp470_;
		_tmp457_ = ma;
		_tmp458_ = vala_member_access_get_inner (_tmp457_);
		_tmp459_ = _tmp458_;
		_tmp460_ = vala_expression_get_value_type (_tmp459_);
		_tmp461_ = _tmp460_;
		_tmp462_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp461_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp462_;
		_tmp463_ = in_arg_map;
		_tmp464_ = array_type;
		_tmp465_ = vala_array_type_get_element_type (_tmp464_);
		_tmp466_ = _tmp465_;
		_tmp467_ = vala_get_ccode_name ((ValaCodeNode*) _tmp466_);
		_tmp468_ = _tmp467_;
		_tmp469_ = vala_ccode_identifier_new (_tmp468_);
		_tmp470_ = _tmp469_;
		vala_map_set ((ValaMap*) _tmp463_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp470_);
		_vala_ccode_node_unref0 (_tmp470_);
		_g_free0 (_tmp468_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp471_;
		_tmp471_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp471_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp472_;
			_tmp472_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp472_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp473_;
				ValaExpression* _tmp474_;
				ValaExpression* _tmp475_;
				ValaTargetValue* _tmp476_;
				ValaTargetValue* _tmp477_;
				ValaTargetValue* _tmp478_;
				ValaTargetValue* _tmp479_;
				_tmp473_ = ma;
				_tmp474_ = vala_member_access_get_inner (_tmp473_);
				_tmp475_ = _tmp474_;
				_tmp476_ = vala_expression_get_target_value (_tmp475_);
				_tmp477_ = _tmp476_;
				_tmp478_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp477_, (ValaCodeNode*) expr);
				_tmp479_ = _tmp478_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp479_);
				_vala_target_value_unref0 (_tmp479_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp481_ = m;
	if (_tmp481_ != NULL) {
		ValaMethod* _tmp482_;
		gboolean _tmp483_;
		gboolean _tmp484_;
		_tmp482_ = m;
		_tmp483_ = vala_method_get_is_async_callback (_tmp482_);
		_tmp484_ = _tmp483_;
		_tmp480_ = _tmp484_;
	} else {
		_tmp480_ = FALSE;
	}
	if (_tmp480_) {
		ValaMethod* _tmp485_;
		ValaMethod* _tmp486_;
		gboolean _tmp487_;
		gboolean _tmp488_;
		ValaHashMap* _tmp502_;
		ValaMethod* _tmp503_;
		ValaCCodeExpression* _tmp504_;
		ValaHashMap* _tmp505_;
		ValaMethod* _tmp506_;
		ValaCCodeExpression* _tmp507_;
		_tmp485_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp486_ = _tmp485_;
		_tmp487_ = vala_method_get_closure (_tmp486_);
		_tmp488_ = _tmp487_;
		if (_tmp488_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp489_;
			ValaSymbol* _tmp490_;
			ValaSymbol* _tmp491_;
			ValaBlock* _tmp492_;
			ValaBlock* _tmp493_;
			ValaBlock* _tmp494_;
			ValaBlock* _tmp495_;
			gchar* _tmp496_;
			gchar* _tmp497_;
			ValaCCodeExpression* _tmp498_;
			ValaCCodeExpression* _tmp499_;
			ValaCCodeMemberAccess* _tmp500_;
			_tmp489_ = m;
			_tmp490_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp489_);
			_tmp491_ = _tmp490_;
			_tmp492_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp491_, VALA_TYPE_METHOD, ValaMethod));
			_tmp493_ = _tmp492_;
			_tmp494_ = _vala_code_node_ref0 (_tmp493_);
			block = _tmp494_;
			_tmp495_ = block;
			_tmp496_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp495_));
			_tmp497_ = _tmp496_;
			_tmp498_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp497_);
			_tmp499_ = _tmp498_;
			_tmp500_ = vala_ccode_member_access_new_pointer (_tmp499_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp500_;
			_vala_ccode_node_unref0 (_tmp499_);
			_g_free0 (_tmp497_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp501_;
			_tmp501_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp501_;
		}
		_tmp502_ = in_arg_map;
		_tmp503_ = m;
		_tmp504_ = instance;
		vala_map_set ((ValaMap*) _tmp502_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp503_), FALSE)), _tmp504_);
		_tmp505_ = out_arg_map;
		_tmp506_ = m;
		_tmp507_ = instance;
		vala_map_set ((ValaMap*) _tmp505_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp506_), FALSE)), _tmp507_);
	} else {
		gboolean _tmp508_ = FALSE;
		gboolean _tmp509_ = FALSE;
		ValaMethod* _tmp510_;
		_tmp510_ = m;
		if (_tmp510_ != NULL) {
			ValaMethod* _tmp511_;
			ValaMemberBinding _tmp512_;
			ValaMemberBinding _tmp513_;
			_tmp511_ = m;
			_tmp512_ = vala_method_get_binding (_tmp511_);
			_tmp513_ = _tmp512_;
			_tmp509_ = _tmp513_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp509_ = FALSE;
		}
		if (_tmp509_) {
			ValaMethod* _tmp514_;
			_tmp514_ = m;
			_tmp508_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp514_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp508_ = FALSE;
		}
		if (_tmp508_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp515_;
			ValaExpression* _tmp516_;
			ValaExpression* _tmp517_;
			ValaTargetValue* _tmp518_;
			ValaTargetValue* _tmp519_;
			ValaTargetValue* _tmp520_;
			gboolean _tmp521_ = FALSE;
			gboolean _tmp522_ = FALSE;
			ValaMemberAccess* _tmp523_;
			const gchar* _tmp524_;
			const gchar* _tmp525_;
			ValaTargetValue* _tmp547_;
			ValaCCodeExpression* _tmp548_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp549_;
			ValaSymbol* _tmp550_;
			ValaSymbol* _tmp551_;
			ValaStruct* _tmp552_;
			gboolean _tmp553_ = FALSE;
			ValaStruct* _tmp554_;
			gboolean _tmp563_;
			gboolean _tmp564_;
			_tmp515_ = ma;
			_tmp516_ = vala_member_access_get_inner (_tmp515_);
			_tmp517_ = _tmp516_;
			_tmp518_ = vala_expression_get_target_value (_tmp517_);
			_tmp519_ = _tmp518_;
			_tmp520_ = _vala_target_value_ref0 (_tmp519_);
			instance_value = _tmp520_;
			_tmp523_ = ma;
			_tmp524_ = vala_member_access_get_member_name (_tmp523_);
			_tmp525_ = _tmp524_;
			if (g_strcmp0 (_tmp525_, "begin") == 0) {
				_tmp522_ = TRUE;
			} else {
				ValaMemberAccess* _tmp526_;
				const gchar* _tmp527_;
				const gchar* _tmp528_;
				_tmp526_ = ma;
				_tmp527_ = vala_member_access_get_member_name (_tmp526_);
				_tmp528_ = _tmp527_;
				_tmp522_ = g_strcmp0 (_tmp528_, "end") == 0;
			}
			if (_tmp522_) {
				ValaMemberAccess* _tmp529_;
				ValaExpression* _tmp530_;
				ValaExpression* _tmp531_;
				ValaSymbol* _tmp532_;
				ValaSymbol* _tmp533_;
				ValaMemberAccess* _tmp534_;
				ValaSymbol* _tmp535_;
				ValaSymbol* _tmp536_;
				_tmp529_ = ma;
				_tmp530_ = vala_member_access_get_inner (_tmp529_);
				_tmp531_ = _tmp530_;
				_tmp532_ = vala_expression_get_symbol_reference (_tmp531_);
				_tmp533_ = _tmp532_;
				_tmp534_ = ma;
				_tmp535_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp534_);
				_tmp536_ = _tmp535_;
				_tmp521_ = _tmp533_ == _tmp536_;
			} else {
				_tmp521_ = FALSE;
			}
			if (_tmp521_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp537_;
				ValaExpression* _tmp538_;
				ValaExpression* _tmp539_;
				ValaMemberAccess* _tmp540_;
				ValaMemberAccess* _tmp541_;
				ValaExpression* _tmp542_;
				ValaExpression* _tmp543_;
				ValaTargetValue* _tmp544_;
				ValaTargetValue* _tmp545_;
				ValaTargetValue* _tmp546_;
				_tmp537_ = ma;
				_tmp538_ = vala_member_access_get_inner (_tmp537_);
				_tmp539_ = _tmp538_;
				_tmp540_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp539_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp540_;
				_tmp541_ = inner_ma;
				_tmp542_ = vala_member_access_get_inner (_tmp541_);
				_tmp543_ = _tmp542_;
				_tmp544_ = vala_expression_get_target_value (_tmp543_);
				_tmp545_ = _tmp544_;
				_tmp546_ = _vala_target_value_ref0 (_tmp545_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp546_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp547_ = instance_value;
			_tmp548_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp547_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp548_;
			_tmp549_ = m;
			_tmp550_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp549_);
			_tmp551_ = _tmp550_;
			_tmp552_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp551_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp551_) : NULL);
			st = _tmp552_;
			_tmp554_ = st;
			if (_tmp554_ != NULL) {
				ValaStruct* _tmp555_;
				_tmp555_ = st;
				_tmp553_ = !vala_struct_is_simple_type (_tmp555_);
			} else {
				_tmp553_ = FALSE;
			}
			if (_tmp553_) {
				ValaTargetValue* _tmp556_;
				ValaTargetValue* _tmp559_;
				ValaCCodeExpression* _tmp560_;
				ValaCCodeExpression* _tmp561_;
				ValaCCodeUnaryExpression* _tmp562_;
				_tmp556_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp556_)) {
					ValaTargetValue* _tmp557_;
					ValaTargetValue* _tmp558_;
					_tmp557_ = instance_value;
					_tmp558_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp557_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp558_;
				}
				_tmp559_ = instance_value;
				_tmp560_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp559_);
				_tmp561_ = _tmp560_;
				_tmp562_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp561_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp562_;
				_vala_ccode_node_unref0 (_tmp561_);
			}
			_tmp563_ = vala_method_call_get_is_yield_expression (expr);
			_tmp564_ = _tmp563_;
			if (_tmp564_) {
				ValaHashMap* _tmp565_;
				ValaMethod* _tmp566_;
				ValaCCodeExpression* _tmp567_;
				ValaMethod* _tmp568_;
				_tmp565_ = in_arg_map;
				_tmp566_ = m;
				_tmp567_ = instance;
				vala_map_set ((ValaMap*) _tmp565_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp566_), FALSE)), _tmp567_);
				_tmp568_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp568_)) {
					ValaHashMap* _tmp569_;
					ValaMethod* _tmp570_;
					ValaCCodeExpression* _tmp571_;
					_tmp569_ = out_arg_map;
					_tmp570_ = m;
					_tmp571_ = instance;
					vala_map_set ((ValaMap*) _tmp569_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp570_), FALSE)), _tmp571_);
				}
			} else {
				gboolean _tmp572_ = FALSE;
				ValaMemberAccess* _tmp573_;
				const gchar* _tmp574_;
				const gchar* _tmp575_;
				_tmp573_ = ma;
				_tmp574_ = vala_member_access_get_member_name (_tmp573_);
				_tmp575_ = _tmp574_;
				if (g_strcmp0 (_tmp575_, "end") != 0) {
					_tmp572_ = TRUE;
				} else {
					ValaMethod* _tmp576_;
					_tmp576_ = m;
					_tmp572_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp576_);
				}
				if (_tmp572_) {
					ValaHashMap* _tmp577_;
					ValaMethod* _tmp578_;
					ValaCCodeExpression* _tmp579_;
					ValaHashMap* _tmp580_;
					ValaMethod* _tmp581_;
					ValaCCodeExpression* _tmp582_;
					_tmp577_ = out_arg_map;
					_tmp578_ = m;
					_tmp579_ = instance;
					vala_map_set ((ValaMap*) _tmp577_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp578_), FALSE)), _tmp579_);
					_tmp580_ = in_arg_map;
					_tmp581_ = m;
					_tmp582_ = instance;
					vala_map_set ((ValaMap*) _tmp580_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp581_), FALSE)), _tmp582_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp583_ = FALSE;
			ValaMethod* _tmp584_;
			_tmp584_ = m;
			if (_tmp584_ != NULL) {
				ValaMethod* _tmp585_;
				ValaMemberBinding _tmp586_;
				ValaMemberBinding _tmp587_;
				_tmp585_ = m;
				_tmp586_ = vala_method_get_binding (_tmp585_);
				_tmp587_ = _tmp586_;
				_tmp583_ = _tmp587_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp583_ = FALSE;
			}
			if (_tmp583_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp588_;
				ValaSymbol* _tmp589_;
				ValaSymbol* _tmp590_;
				ValaClass* _tmp591_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp592_;
				gchar* _tmp593_;
				gchar* _tmp594_;
				gchar* _tmp595_;
				gchar* _tmp596_;
				ValaCCodeIdentifier* _tmp597_;
				ValaCCodeIdentifier* _tmp598_;
				ValaCCodeFunctionCall* _tmp599_;
				ValaCCodeFunctionCall* _tmp600_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp601_;
				ValaExpression* _tmp602_;
				ValaExpression* _tmp603_;
				ValaCCodeFunctionCall* _tmp629_;
				ValaCCodeExpression* _tmp630_;
				ValaHashMap* _tmp631_;
				ValaMethod* _tmp632_;
				ValaCCodeFunctionCall* _tmp633_;
				ValaHashMap* _tmp634_;
				ValaMethod* _tmp635_;
				ValaCCodeFunctionCall* _tmp636_;
				_tmp588_ = m;
				_tmp589_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp588_);
				_tmp590_ = _tmp589_;
				_tmp591_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp590_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp591_;
				_tmp592_ = cl;
				_tmp593_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp592_, NULL);
				_tmp594_ = _tmp593_;
				_tmp595_ = g_strconcat (_tmp594_, "_CLASS", NULL);
				_tmp596_ = _tmp595_;
				_tmp597_ = vala_ccode_identifier_new (_tmp596_);
				_tmp598_ = _tmp597_;
				_tmp599_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp598_);
				_tmp600_ = _tmp599_;
				_vala_ccode_node_unref0 (_tmp598_);
				_g_free0 (_tmp596_);
				_g_free0 (_tmp594_);
				cast = _tmp600_;
				_tmp601_ = ma;
				_tmp602_ = vala_member_access_get_inner (_tmp601_);
				_tmp603_ = _tmp602_;
				if (_tmp603_ == NULL) {
					ValaDataType* _tmp604_;
					ValaDataType* _tmp605_;
					gboolean _tmp606_;
					_tmp604_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp605_ = _tmp604_;
					_tmp606_ = _tmp605_ == NULL;
					_vala_code_node_unref0 (_tmp605_);
					if (_tmp606_) {
						ValaCCodeIdentifier* _tmp607_;
						_tmp607_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp607_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp608_;
						ValaCCodeIdentifier* _tmp609_;
						ValaCCodeFunctionCall* _tmp610_;
						ValaCCodeFunctionCall* _tmp611_;
						ValaCCodeFunctionCall* _tmp612_;
						ValaCCodeExpression* _tmp613_;
						ValaCCodeExpression* _tmp614_;
						ValaCCodeFunctionCall* _tmp615_;
						ValaCCodeExpression* _tmp616_;
						_tmp608_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp609_ = _tmp608_;
						_tmp610_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp609_);
						_tmp611_ = _tmp610_;
						_vala_ccode_node_unref0 (_tmp609_);
						k = _tmp611_;
						_tmp612_ = k;
						_tmp613_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp614_ = _tmp613_;
						vala_ccode_function_call_add_argument (_tmp612_, _tmp614_);
						_vala_ccode_node_unref0 (_tmp614_);
						_tmp615_ = k;
						_tmp616_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp615_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp616_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp617_;
					ValaCCodeIdentifier* _tmp618_;
					ValaCCodeFunctionCall* _tmp619_;
					ValaCCodeFunctionCall* _tmp620_;
					ValaCCodeFunctionCall* _tmp621_;
					ValaMemberAccess* _tmp622_;
					ValaExpression* _tmp623_;
					ValaExpression* _tmp624_;
					ValaCCodeExpression* _tmp625_;
					ValaCCodeExpression* _tmp626_;
					ValaCCodeFunctionCall* _tmp627_;
					ValaCCodeExpression* _tmp628_;
					_tmp617_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp618_ = _tmp617_;
					_tmp619_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp618_);
					_tmp620_ = _tmp619_;
					_vala_ccode_node_unref0 (_tmp618_);
					k = _tmp620_;
					_tmp621_ = k;
					_tmp622_ = ma;
					_tmp623_ = vala_member_access_get_inner (_tmp622_);
					_tmp624_ = _tmp623_;
					_tmp625_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp624_);
					_tmp626_ = _tmp625_;
					vala_ccode_function_call_add_argument (_tmp621_, _tmp626_);
					_vala_ccode_node_unref0 (_tmp626_);
					_tmp627_ = k;
					_tmp628_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp627_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp628_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp629_ = cast;
				_tmp630_ = klass;
				vala_ccode_function_call_add_argument (_tmp629_, _tmp630_);
				_tmp631_ = in_arg_map;
				_tmp632_ = m;
				_tmp633_ = cast;
				vala_map_set ((ValaMap*) _tmp631_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp632_), FALSE)), (ValaCCodeExpression*) _tmp633_);
				_tmp634_ = out_arg_map;
				_tmp635_ = m;
				_tmp636_ = cast;
				vala_map_set ((ValaMap*) _tmp634_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp635_), FALSE)), (ValaCCodeExpression*) _tmp636_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp638_ = m;
	if (_tmp638_ != NULL) {
		ValaMethod* _tmp639_;
		_tmp639_ = m;
		_tmp637_ = vala_get_ccode_has_generic_type_parameter (_tmp639_);
	} else {
		_tmp637_ = FALSE;
	}
	if (_tmp637_) {
		ValaMethod* _tmp640_;
		ValaList* _tmp641_;
		ValaList* _tmp642_;
		gint _tmp643_;
		gint _tmp644_;
		gboolean _tmp645_;
		_tmp640_ = m;
		_tmp641_ = vala_method_get_type_parameters (_tmp640_);
		_tmp642_ = _tmp641_;
		_tmp643_ = vala_collection_get_size ((ValaCollection*) _tmp642_);
		_tmp644_ = _tmp643_;
		_tmp645_ = _tmp644_ > 0;
		_vala_iterable_unref0 (_tmp642_);
		if (_tmp645_) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp646_;
				ValaList* _tmp647_;
				gint _type_arg_size = 0;
				ValaList* _tmp648_;
				gint _tmp649_;
				gint _tmp650_;
				gint _type_arg_index = 0;
				_tmp646_ = ma;
				_tmp647_ = vala_member_access_get_type_arguments (_tmp646_);
				_type_arg_list = _tmp647_;
				_tmp648_ = _type_arg_list;
				_tmp649_ = vala_collection_get_size ((ValaCollection*) _tmp648_);
				_tmp650_ = _tmp649_;
				_type_arg_size = _tmp650_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp651_;
					gint _tmp652_;
					gint _tmp653_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp654_;
					gint _tmp655_;
					gpointer _tmp656_;
					ValaHashMap* _tmp657_;
					ValaMethod* _tmp658_;
					gint _tmp659_;
					ValaDataType* _tmp660_;
					gchar* _tmp661_;
					gchar* _tmp662_;
					ValaCCodeIdentifier* _tmp663_;
					ValaCCodeIdentifier* _tmp664_;
					gint _tmp665_;
					_tmp651_ = _type_arg_index;
					_type_arg_index = _tmp651_ + 1;
					_tmp652_ = _type_arg_index;
					_tmp653_ = _type_arg_size;
					if (!(_tmp652_ < _tmp653_)) {
						break;
					}
					_tmp654_ = _type_arg_list;
					_tmp655_ = _type_arg_index;
					_tmp656_ = vala_list_get (_tmp654_, _tmp655_);
					type_arg = (ValaDataType*) _tmp656_;
					_tmp657_ = in_arg_map;
					_tmp658_ = m;
					_tmp659_ = type_param_index;
					_tmp660_ = type_arg;
					_tmp661_ = vala_get_ccode_name ((ValaCodeNode*) _tmp660_);
					_tmp662_ = _tmp661_;
					_tmp663_ = vala_ccode_identifier_new (_tmp662_);
					_tmp664_ = _tmp663_;
					vala_map_set ((ValaMap*) _tmp657_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp658_) + (0.01 * _tmp659_), FALSE)), (ValaCCodeExpression*) _tmp664_);
					_vala_ccode_node_unref0 (_tmp664_);
					_g_free0 (_tmp662_);
					_tmp665_ = type_param_index;
					type_param_index = _tmp665_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp666_;
				ValaExpression* _tmp667_;
				ValaExpression* _tmp668_;
				ValaDataType* _tmp669_;
				ValaDataType* _tmp670_;
				ValaList* _tmp671_;
				gint _type_arg_size = 0;
				ValaList* _tmp672_;
				gint _tmp673_;
				gint _tmp674_;
				gint _type_arg_index = 0;
				_tmp666_ = ma;
				_tmp667_ = vala_member_access_get_inner (_tmp666_);
				_tmp668_ = _tmp667_;
				_tmp669_ = vala_expression_get_value_type (_tmp668_);
				_tmp670_ = _tmp669_;
				_tmp671_ = vala_data_type_get_type_arguments (_tmp670_);
				_type_arg_list = _tmp671_;
				_tmp672_ = _type_arg_list;
				_tmp673_ = vala_collection_get_size ((ValaCollection*) _tmp672_);
				_tmp674_ = _tmp673_;
				_type_arg_size = _tmp674_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp675_;
					gint _tmp676_;
					gint _tmp677_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp678_;
					gint _tmp679_;
					gpointer _tmp680_;
					ValaHashMap* _tmp681_;
					ValaMethod* _tmp682_;
					gint _tmp683_;
					ValaDataType* _tmp684_;
					gchar* _tmp685_;
					gchar* _tmp686_;
					ValaCCodeIdentifier* _tmp687_;
					ValaCCodeIdentifier* _tmp688_;
					gint _tmp689_;
					_tmp675_ = _type_arg_index;
					_type_arg_index = _tmp675_ + 1;
					_tmp676_ = _type_arg_index;
					_tmp677_ = _type_arg_size;
					if (!(_tmp676_ < _tmp677_)) {
						break;
					}
					_tmp678_ = _type_arg_list;
					_tmp679_ = _type_arg_index;
					_tmp680_ = vala_list_get (_tmp678_, _tmp679_);
					type_arg = (ValaDataType*) _tmp680_;
					_tmp681_ = in_arg_map;
					_tmp682_ = m;
					_tmp683_ = type_param_index;
					_tmp684_ = type_arg;
					_tmp685_ = vala_get_ccode_name ((ValaCodeNode*) _tmp684_);
					_tmp686_ = _tmp685_;
					_tmp687_ = vala_ccode_identifier_new (_tmp686_);
					_tmp688_ = _tmp687_;
					vala_map_set ((ValaMap*) _tmp681_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp682_) + (0.01 * _tmp683_), FALSE)), (ValaCCodeExpression*) _tmp688_);
					_vala_ccode_node_unref0 (_tmp688_);
					_g_free0 (_tmp686_);
					_tmp689_ = type_param_index;
					type_param_index = _tmp689_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp690_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp690_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp691_;
		ValaExpression* _tmp692_;
		ValaExpression* _tmp693_;
		ValaDataType* _tmp694_;
		ValaDataType* _tmp695_;
		ValaArrayType* _tmp696_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp697_;
		ValaCCodeIdentifier* _tmp698_;
		ValaCCodeFunctionCall* _tmp699_;
		ValaCCodeFunctionCall* _tmp700_;
		ValaCCodeFunctionCall* _tmp701_;
		ValaArrayType* _tmp702_;
		ValaDataType* _tmp703_;
		ValaDataType* _tmp704_;
		gchar* _tmp705_;
		gchar* _tmp706_;
		ValaCCodeIdentifier* _tmp707_;
		ValaCCodeIdentifier* _tmp708_;
		ValaHashMap* _tmp709_;
		ValaCCodeFunctionCall* _tmp710_;
		_tmp691_ = ma;
		_tmp692_ = vala_member_access_get_inner (_tmp691_);
		_tmp693_ = _tmp692_;
		_tmp694_ = vala_expression_get_value_type (_tmp693_);
		_tmp695_ = _tmp694_;
		_tmp696_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp695_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp696_;
		_tmp697_ = vala_ccode_identifier_new ("sizeof");
		_tmp698_ = _tmp697_;
		_tmp699_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp698_);
		_tmp700_ = _tmp699_;
		_vala_ccode_node_unref0 (_tmp698_);
		csizeof = _tmp700_;
		_tmp701_ = csizeof;
		_tmp702_ = array_type;
		_tmp703_ = vala_array_type_get_element_type (_tmp702_);
		_tmp704_ = _tmp703_;
		_tmp705_ = vala_get_ccode_name ((ValaCodeNode*) _tmp704_);
		_tmp706_ = _tmp705_;
		_tmp707_ = vala_ccode_identifier_new (_tmp706_);
		_tmp708_ = _tmp707_;
		vala_ccode_function_call_add_argument (_tmp701_, (ValaCCodeExpression*) _tmp708_);
		_vala_ccode_node_unref0 (_tmp708_);
		_g_free0 (_tmp706_);
		_tmp709_ = in_arg_map;
		_tmp710_ = csizeof;
		vala_map_set ((ValaMap*) _tmp709_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp710_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp711_;
		_tmp711_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp711_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaMethod* _tmp712_;
			gint param_nr = 0;
			ValaMethod* _tmp783_;
			_tmp712_ = m;
			vala_method_clear_parameters (_tmp712_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp713_;
				gint _arg_size = 0;
				ValaList* _tmp714_;
				gint _tmp715_;
				gint _tmp716_;
				gint _arg_index = 0;
				_tmp713_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp713_;
				_tmp714_ = _arg_list;
				_tmp715_ = vala_collection_get_size ((ValaCollection*) _tmp714_);
				_tmp716_ = _tmp715_;
				_arg_size = _tmp716_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp717_;
					gint _tmp718_;
					gint _tmp719_;
					ValaExpression* arg = NULL;
					ValaList* _tmp720_;
					gint _tmp721_;
					gpointer _tmp722_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp723_;
					ValaUnaryExpression* _tmp724_;
					gboolean _tmp725_ = FALSE;
					ValaUnaryExpression* _tmp726_;
					gint _tmp770_;
					_tmp717_ = _arg_index;
					_arg_index = _tmp717_ + 1;
					_tmp718_ = _arg_index;
					_tmp719_ = _arg_size;
					if (!(_tmp718_ < _tmp719_)) {
						break;
					}
					_tmp720_ = _arg_list;
					_tmp721_ = _arg_index;
					_tmp722_ = vala_list_get (_tmp720_, _tmp721_);
					arg = (ValaExpression*) _tmp722_;
					_tmp723_ = arg;
					_tmp724_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp723_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp723_) : NULL);
					unary = _tmp724_;
					_tmp726_ = unary;
					if (_tmp726_ != NULL) {
						ValaUnaryExpression* _tmp727_;
						ValaUnaryOperator _tmp728_;
						ValaUnaryOperator _tmp729_;
						_tmp727_ = unary;
						_tmp728_ = vala_unary_expression_get_operator (_tmp727_);
						_tmp729_ = _tmp728_;
						_tmp725_ = _tmp729_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp725_ = FALSE;
					}
					if (_tmp725_) {
						ValaParameter* param = NULL;
						gint _tmp730_;
						gchar* _tmp731_;
						gchar* _tmp732_;
						ValaUnaryExpression* _tmp733_;
						ValaExpression* _tmp734_;
						ValaExpression* _tmp735_;
						ValaDataType* _tmp736_;
						ValaDataType* _tmp737_;
						ValaParameter* _tmp738_;
						ValaParameter* _tmp739_;
						ValaParameter* _tmp740_;
						ValaMethod* _tmp741_;
						ValaParameter* _tmp742_;
						_tmp730_ = param_nr;
						_tmp731_ = g_strdup_printf ("param%d", _tmp730_);
						_tmp732_ = _tmp731_;
						_tmp733_ = unary;
						_tmp734_ = vala_unary_expression_get_inner (_tmp733_);
						_tmp735_ = _tmp734_;
						_tmp736_ = vala_expression_get_value_type (_tmp735_);
						_tmp737_ = _tmp736_;
						_tmp738_ = vala_parameter_new (_tmp732_, _tmp737_, NULL);
						_tmp739_ = _tmp738_;
						_g_free0 (_tmp732_);
						param = _tmp739_;
						_tmp740_ = param;
						vala_parameter_set_direction (_tmp740_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp741_ = m;
						_tmp742_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp741_, _tmp742_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp743_ = FALSE;
						ValaUnaryExpression* _tmp744_;
						_tmp744_ = unary;
						if (_tmp744_ != NULL) {
							ValaUnaryExpression* _tmp745_;
							ValaUnaryOperator _tmp746_;
							ValaUnaryOperator _tmp747_;
							_tmp745_ = unary;
							_tmp746_ = vala_unary_expression_get_operator (_tmp745_);
							_tmp747_ = _tmp746_;
							_tmp743_ = _tmp747_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp743_ = FALSE;
						}
						if (_tmp743_) {
							ValaParameter* param = NULL;
							gint _tmp748_;
							gchar* _tmp749_;
							gchar* _tmp750_;
							ValaUnaryExpression* _tmp751_;
							ValaExpression* _tmp752_;
							ValaExpression* _tmp753_;
							ValaDataType* _tmp754_;
							ValaDataType* _tmp755_;
							ValaParameter* _tmp756_;
							ValaParameter* _tmp757_;
							ValaParameter* _tmp758_;
							ValaMethod* _tmp759_;
							ValaParameter* _tmp760_;
							_tmp748_ = param_nr;
							_tmp749_ = g_strdup_printf ("param%d", _tmp748_);
							_tmp750_ = _tmp749_;
							_tmp751_ = unary;
							_tmp752_ = vala_unary_expression_get_inner (_tmp751_);
							_tmp753_ = _tmp752_;
							_tmp754_ = vala_expression_get_value_type (_tmp753_);
							_tmp755_ = _tmp754_;
							_tmp756_ = vala_parameter_new (_tmp750_, _tmp755_, NULL);
							_tmp757_ = _tmp756_;
							_g_free0 (_tmp750_);
							param = _tmp757_;
							_tmp758_ = param;
							vala_parameter_set_direction (_tmp758_, VALA_PARAMETER_DIRECTION_REF);
							_tmp759_ = m;
							_tmp760_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp759_, _tmp760_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp761_;
							gint _tmp762_;
							gchar* _tmp763_;
							gchar* _tmp764_;
							ValaExpression* _tmp765_;
							ValaDataType* _tmp766_;
							ValaDataType* _tmp767_;
							ValaParameter* _tmp768_;
							ValaParameter* _tmp769_;
							_tmp761_ = m;
							_tmp762_ = param_nr;
							_tmp763_ = g_strdup_printf ("param%d", _tmp762_);
							_tmp764_ = _tmp763_;
							_tmp765_ = arg;
							_tmp766_ = vala_expression_get_value_type (_tmp765_);
							_tmp767_ = _tmp766_;
							_tmp768_ = vala_parameter_new (_tmp764_, _tmp767_, NULL);
							_tmp769_ = _tmp768_;
							vala_callable_add_parameter ((ValaCallable*) _tmp761_, _tmp769_);
							_vala_code_node_unref0 (_tmp769_);
							_g_free0 (_tmp764_);
						}
					}
					_tmp770_ = param_nr;
					param_nr = _tmp770_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp771_;
				ValaList* _tmp772_;
				gint _param_size = 0;
				ValaList* _tmp773_;
				gint _tmp774_;
				gint _tmp775_;
				gint _param_index = 0;
				_tmp771_ = m;
				_tmp772_ = vala_callable_get_parameters ((ValaCallable*) _tmp771_);
				_param_list = _tmp772_;
				_tmp773_ = _param_list;
				_tmp774_ = vala_collection_get_size ((ValaCollection*) _tmp773_);
				_tmp775_ = _tmp774_;
				_param_size = _tmp775_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp776_;
					gint _tmp777_;
					gint _tmp778_;
					ValaParameter* param = NULL;
					ValaList* _tmp779_;
					gint _tmp780_;
					gpointer _tmp781_;
					ValaParameter* _tmp782_;
					_tmp776_ = _param_index;
					_param_index = _tmp776_ + 1;
					_tmp777_ = _param_index;
					_tmp778_ = _param_size;
					if (!(_tmp777_ < _tmp778_)) {
						break;
					}
					_tmp779_ = _param_list;
					_tmp780_ = _param_index;
					_tmp781_ = vala_list_get (_tmp779_, _tmp780_);
					param = (ValaParameter*) _tmp781_;
					_tmp782_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp782_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp783_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp783_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
		} else {
			gboolean _tmp784_ = FALSE;
			ValaMethod* _tmp785_;
			_tmp785_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp785_, VALA_TYPE_CREATION_METHOD)) {
				ValaMethod* _tmp786_;
				ValaSymbol* _tmp787_;
				ValaSymbol* _tmp788_;
				_tmp786_ = m;
				_tmp787_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp786_);
				_tmp788_ = _tmp787_;
				_tmp784_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp788_, VALA_TYPE_CLASS);
			} else {
				_tmp784_ = FALSE;
			}
			if (_tmp784_) {
				ValaCCodeFunction* _tmp789_;
				ValaCCodeFunction* _tmp790_;
				ValaCCodeExpression* _tmp791_;
				ValaCCodeExpression* _tmp792_;
				ValaCCodeFunctionCall* _tmp793_;
				ValaClass* _tmp794_;
				ValaClass* _tmp795_;
				gchar* _tmp796_;
				gchar* _tmp797_;
				gchar* _tmp798_;
				gchar* _tmp799_;
				ValaCCodeCastExpression* _tmp800_;
				ValaCCodeCastExpression* _tmp801_;
				ValaMethod* _tmp802_;
				ValaMethod* _tmp803_;
				ValaBlock* _tmp804_;
				ValaBlock* _tmp805_;
				gboolean _tmp806_;
				gboolean _tmp807_;
				gboolean _tmp834_ = FALSE;
				ValaClass* _tmp835_;
				ValaClass* _tmp836_;
				gboolean _tmp837_;
				gboolean _tmp838_;
				_tmp789_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp790_ = _tmp789_;
				_tmp791_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp792_ = _tmp791_;
				_tmp793_ = ccall;
				_tmp794_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp795_ = _tmp794_;
				_tmp796_ = vala_get_ccode_name ((ValaCodeNode*) _tmp795_);
				_tmp797_ = _tmp796_;
				_tmp798_ = g_strconcat (_tmp797_, "*", NULL);
				_tmp799_ = _tmp798_;
				_tmp800_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp793_, _tmp799_);
				_tmp801_ = _tmp800_;
				vala_ccode_function_add_assignment (_tmp790_, _tmp792_, (ValaCCodeExpression*) _tmp801_);
				_vala_ccode_node_unref0 (_tmp801_);
				_g_free0 (_tmp799_);
				_g_free0 (_tmp797_);
				_vala_ccode_node_unref0 (_tmp792_);
				_tmp802_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp803_ = _tmp802_;
				_tmp804_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp803_);
				_tmp805_ = _tmp804_;
				_tmp806_ = vala_block_get_captured (_tmp805_);
				_tmp807_ = _tmp806_;
				if (_tmp807_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp808_;
					ValaClass* _tmp809_;
					ValaObjectType* _tmp810_;
					ValaObjectType* _tmp811_;
					ValaSourceReference* _tmp812_;
					ValaSourceReference* _tmp813_;
					ValaCCodeExpression* _tmp814_;
					ValaCCodeExpression* _tmp815_;
					ValaCCodeFunctionCall* _tmp816_;
					ValaCCodeFunctionCall* _tmp817_;
					ValaCCodeFunctionCall* _tmp818_;
					ValaCCodeExpression* _tmp819_;
					ValaCCodeExpression* _tmp820_;
					ValaCCodeFunction* _tmp821_;
					ValaCCodeFunction* _tmp822_;
					ValaMethod* _tmp823_;
					ValaMethod* _tmp824_;
					ValaBlock* _tmp825_;
					ValaBlock* _tmp826_;
					gchar* _tmp827_;
					gchar* _tmp828_;
					ValaCCodeExpression* _tmp829_;
					ValaCCodeExpression* _tmp830_;
					ValaCCodeMemberAccess* _tmp831_;
					ValaCCodeMemberAccess* _tmp832_;
					ValaCCodeFunctionCall* _tmp833_;
					_tmp808_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp809_ = _tmp808_;
					_tmp810_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp809_);
					_tmp811_ = _tmp810_;
					_tmp812_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp813_ = _tmp812_;
					_tmp814_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp811_, _tmp813_, FALSE);
					_tmp815_ = _tmp814_;
					_tmp816_ = vala_ccode_function_call_new (_tmp815_);
					_tmp817_ = _tmp816_;
					_vala_ccode_node_unref0 (_tmp815_);
					_vala_code_node_unref0 (_tmp811_);
					ref_call = _tmp817_;
					_tmp818_ = ref_call;
					_tmp819_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp820_ = _tmp819_;
					vala_ccode_function_call_add_argument (_tmp818_, _tmp820_);
					_vala_ccode_node_unref0 (_tmp820_);
					_tmp821_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp822_ = _tmp821_;
					_tmp823_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp824_ = _tmp823_;
					_tmp825_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp824_);
					_tmp826_ = _tmp825_;
					_tmp827_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp826_));
					_tmp828_ = _tmp827_;
					_tmp829_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp828_);
					_tmp830_ = _tmp829_;
					_tmp831_ = vala_ccode_member_access_new_pointer (_tmp830_, "self");
					_tmp832_ = _tmp831_;
					_tmp833_ = ref_call;
					vala_ccode_function_add_assignment (_tmp822_, (ValaCCodeExpression*) _tmp832_, (ValaCCodeExpression*) _tmp833_);
					_vala_ccode_node_unref0 (_tmp832_);
					_vala_ccode_node_unref0 (_tmp830_);
					_g_free0 (_tmp828_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp835_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp836_ = _tmp835_;
				_tmp837_ = vala_class_get_is_compact (_tmp836_);
				_tmp838_ = _tmp837_;
				if (!_tmp838_) {
					ValaClass* _tmp839_;
					ValaClass* _tmp840_;
					ValaList* _tmp841_;
					ValaList* _tmp842_;
					gint _tmp843_;
					gint _tmp844_;
					_tmp839_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp840_ = _tmp839_;
					_tmp841_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp840_);
					_tmp842_ = _tmp841_;
					_tmp843_ = vala_collection_get_size ((ValaCollection*) _tmp842_);
					_tmp844_ = _tmp843_;
					_tmp834_ = _tmp844_ > 0;
					_vala_iterable_unref0 (_tmp842_);
				} else {
					_tmp834_ = FALSE;
				}
				if (_tmp834_) {
					gchar** suffices = NULL;
					gchar* _tmp845_;
					gchar* _tmp846_;
					gchar* _tmp847_;
					gchar** _tmp848_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp845_ = g_strdup ("type");
					_tmp846_ = g_strdup ("dup_func");
					_tmp847_ = g_strdup ("destroy_func");
					_tmp848_ = g_new0 (gchar*, 3 + 1);
					_tmp848_[0] = _tmp845_;
					_tmp848_[1] = _tmp846_;
					_tmp848_[2] = _tmp847_;
					suffices = _tmp848_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp849_;
						ValaClass* _tmp850_;
						ValaList* _tmp851_;
						gint _type_param_size = 0;
						ValaList* _tmp852_;
						gint _tmp853_;
						gint _tmp854_;
						gint _type_param_index = 0;
						_tmp849_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp850_ = _tmp849_;
						_tmp851_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp850_);
						_type_param_list = _tmp851_;
						_tmp852_ = _type_param_list;
						_tmp853_ = vala_collection_get_size ((ValaCollection*) _tmp852_);
						_tmp854_ = _tmp853_;
						_type_param_size = _tmp854_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp855_;
							gint _tmp856_;
							gint _tmp857_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp858_;
							gint _tmp859_;
							gpointer _tmp860_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp861_;
							ValaCCodeIdentifier* _tmp862_;
							ValaCCodeMemberAccess* _tmp863_;
							ValaCCodeMemberAccess* _tmp864_;
							gchar** _tmp865_;
							gint _tmp865__length1;
							_tmp855_ = _type_param_index;
							_type_param_index = _tmp855_ + 1;
							_tmp856_ = _type_param_index;
							_tmp857_ = _type_param_size;
							if (!(_tmp856_ < _tmp857_)) {
								break;
							}
							_tmp858_ = _type_param_list;
							_tmp859_ = _type_param_index;
							_tmp860_ = vala_list_get (_tmp858_, _tmp859_);
							type_param = (ValaTypeParameter*) _tmp860_;
							_tmp861_ = vala_ccode_identifier_new ("self");
							_tmp862_ = _tmp861_;
							_tmp863_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp862_, "priv");
							_tmp864_ = _tmp863_;
							_vala_ccode_node_unref0 (_tmp862_);
							priv_access = _tmp864_;
							_tmp865_ = suffices;
							_tmp865__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp865_;
								suffix_collection_length1 = _tmp865__length1;
								for (suffix_it = 0; suffix_it < _tmp865__length1; suffix_it = suffix_it + 1) {
									gchar* _tmp866_;
									gchar* suffix = NULL;
									_tmp866_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp866_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp867_;
										const gchar* _tmp868_;
										const gchar* _tmp869_;
										gchar* _tmp870_;
										gchar* _tmp871_;
										const gchar* _tmp872_;
										gchar* _tmp873_;
										gchar* _tmp874_;
										ValaCCodeIdentifier* _tmp875_;
										ValaCCodeIdentifier* _tmp876_;
										ValaCCodeFunction* _tmp877_;
										ValaCCodeFunction* _tmp878_;
										ValaCCodeMemberAccess* _tmp879_;
										ValaCCodeIdentifier* _tmp880_;
										const gchar* _tmp881_;
										const gchar* _tmp882_;
										ValaCCodeMemberAccess* _tmp883_;
										ValaCCodeMemberAccess* _tmp884_;
										ValaCCodeIdentifier* _tmp885_;
										_tmp867_ = type_param;
										_tmp868_ = vala_symbol_get_name ((ValaSymbol*) _tmp867_);
										_tmp869_ = _tmp868_;
										_tmp870_ = g_utf8_strdown (_tmp869_, (gssize) -1);
										_tmp871_ = _tmp870_;
										_tmp872_ = suffix;
										_tmp873_ = g_strdup_printf ("%s_%s", _tmp871_, _tmp872_);
										_tmp874_ = _tmp873_;
										_tmp875_ = vala_ccode_identifier_new (_tmp874_);
										_tmp876_ = _tmp875_;
										_g_free0 (_tmp874_);
										_g_free0 (_tmp871_);
										param_name = _tmp876_;
										_tmp877_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp878_ = _tmp877_;
										_tmp879_ = priv_access;
										_tmp880_ = param_name;
										_tmp881_ = vala_ccode_identifier_get_name (_tmp880_);
										_tmp882_ = _tmp881_;
										_tmp883_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp879_, _tmp882_);
										_tmp884_ = _tmp883_;
										_tmp885_ = param_name;
										vala_ccode_function_add_assignment (_tmp878_, (ValaCCodeExpression*) _tmp884_, (ValaCCodeExpression*) _tmp885_);
										_vala_ccode_node_unref0 (_tmp884_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp886_ = params;
	_tmp887_ = vala_iterable_iterator ((ValaIterable*) _tmp886_);
	params_it = _tmp887_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp888_;
		gint _arg_size = 0;
		ValaList* _tmp889_;
		gint _tmp890_;
		gint _tmp891_;
		gint _arg_index = 0;
		_tmp888_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp888_;
		_tmp889_ = _arg_list;
		_tmp890_ = vala_collection_get_size ((ValaCollection*) _tmp889_);
		_tmp891_ = _tmp890_;
		_arg_size = _tmp891_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp892_;
			gint _tmp893_;
			gint _tmp894_;
			ValaExpression* arg = NULL;
			ValaList* _tmp895_;
			gint _tmp896_;
			gpointer _tmp897_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp898_;
			ValaCCodeExpression* _tmp899_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp900_;
			ValaHashMap* _tmp901_;
			ValaIterator* _tmp902_;
			ValaHashMap* _tmp1206_;
			gint _tmp1207_;
			ValaCCodeExpression* _tmp1208_;
			gboolean _tmp1209_ = FALSE;
			ValaExpression* _tmp1210_;
			gint _tmp1230_;
			_tmp892_ = _arg_index;
			_arg_index = _tmp892_ + 1;
			_tmp893_ = _arg_index;
			_tmp894_ = _arg_size;
			if (!(_tmp893_ < _tmp894_)) {
				break;
			}
			_tmp895_ = _arg_list;
			_tmp896_ = _arg_index;
			_tmp897_ = vala_list_get (_tmp895_, _tmp896_);
			arg = (ValaExpression*) _tmp897_;
			_tmp898_ = arg;
			_tmp899_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp898_);
			cexpr = _tmp899_;
			_tmp900_ = in_arg_map;
			_tmp901_ = _vala_map_ref0 (_tmp900_);
			carg_map = _tmp901_;
			_tmp902_ = params_it;
			if (vala_iterator_next (_tmp902_)) {
				ValaParameter* param = NULL;
				ValaIterator* _tmp903_;
				gpointer _tmp904_;
				gboolean _tmp905_ = FALSE;
				ValaParameter* _tmp906_;
				gboolean _tmp907_;
				gboolean _tmp908_;
				gboolean _tmp912_;
				ValaParameter* _tmp1199_;
				gboolean _tmp1200_;
				_tmp903_ = params_it;
				_tmp904_ = vala_iterator_get (_tmp903_);
				param = (ValaParameter*) _tmp904_;
				_tmp906_ = param;
				_tmp907_ = vala_parameter_get_params_array (_tmp906_);
				_tmp908_ = _tmp907_;
				if (_tmp908_) {
					_tmp905_ = TRUE;
				} else {
					ValaParameter* _tmp909_;
					gboolean _tmp910_;
					gboolean _tmp911_;
					_tmp909_ = param;
					_tmp910_ = vala_parameter_get_ellipsis (_tmp909_);
					_tmp911_ = _tmp910_;
					_tmp905_ = _tmp911_;
				}
				ellipsis = _tmp905_;
				_tmp912_ = ellipsis;
				if (!_tmp912_) {
					ValaParameter* _tmp913_;
					ValaParameterDirection _tmp914_;
					ValaParameterDirection _tmp915_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp918_;
					ValaUnaryExpression* _tmp919_;
					gboolean _tmp920_ = FALSE;
					ValaUnaryExpression* _tmp921_;
					ValaParameter* _tmp1187_;
					gchar* _tmp1188_;
					gchar* _tmp1189_;
					gboolean _tmp1190_;
					_tmp913_ = param;
					_tmp914_ = vala_parameter_get_direction (_tmp913_);
					_tmp915_ = _tmp914_;
					if (_tmp915_ == VALA_PARAMETER_DIRECTION_OUT) {
						ValaHashMap* _tmp916_;
						ValaHashMap* _tmp917_;
						_tmp916_ = out_arg_map;
						_tmp917_ = _vala_map_ref0 (_tmp916_);
						_vala_map_unref0 (carg_map);
						carg_map = _tmp917_;
					}
					_tmp918_ = arg;
					_tmp919_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp918_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp918_) : NULL);
					unary = _tmp919_;
					_tmp921_ = unary;
					if (_tmp921_ == NULL) {
						_tmp920_ = TRUE;
					} else {
						ValaUnaryExpression* _tmp922_;
						ValaUnaryOperator _tmp923_;
						ValaUnaryOperator _tmp924_;
						_tmp922_ = unary;
						_tmp923_ = vala_unary_expression_get_operator (_tmp922_);
						_tmp924_ = _tmp923_;
						_tmp920_ = _tmp924_ != VALA_UNARY_OPERATOR_OUT;
					}
					if (_tmp920_) {
						gboolean _tmp925_ = FALSE;
						ValaParameter* _tmp926_;
						ValaParameter* _tmp1063_;
						ValaExpression* _tmp1064_;
						ValaCCodeExpression* _tmp1065_;
						ValaCCodeExpression* _tmp1066_;
						_tmp926_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp926_)) {
							ValaParameter* _tmp927_;
							ValaDataType* _tmp928_;
							ValaDataType* _tmp929_;
							_tmp927_ = param;
							_tmp928_ = vala_variable_get_variable_type ((ValaVariable*) _tmp927_);
							_tmp929_ = _tmp928_;
							_tmp925_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp929_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp925_ = FALSE;
						}
						if (_tmp925_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp930_;
							ValaDataType* _tmp931_;
							ValaDataType* _tmp932_;
							ValaArrayType* _tmp933_;
							_tmp930_ = param;
							_tmp931_ = vala_variable_get_variable_type ((ValaVariable*) _tmp930_);
							_tmp932_ = _tmp931_;
							_tmp933_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp932_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp933_;
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp934_ = FALSE;
									_tmp934_ = TRUE;
									while (TRUE) {
										gint _tmp936_;
										ValaArrayType* _tmp937_;
										gint _tmp938_;
										gint _tmp939_;
										ValaCCodeExpression* array_length_expr = NULL;
										ValaParameter* _tmp940_;
										gchar* _tmp941_;
										gchar* _tmp942_;
										gboolean _tmp943_;
										ValaHashMap* _tmp962_;
										ValaParameter* _tmp963_;
										gint _tmp964_;
										ValaCCodeExpression* _tmp965_;
										if (!_tmp934_) {
											gint _tmp935_;
											_tmp935_ = dim;
											dim = _tmp935_ + 1;
										}
										_tmp934_ = FALSE;
										_tmp936_ = dim;
										_tmp937_ = array_type;
										_tmp938_ = vala_array_type_get_rank (_tmp937_);
										_tmp939_ = _tmp938_;
										if (!(_tmp936_ <= _tmp939_)) {
											break;
										}
										array_length_expr = NULL;
										_tmp940_ = param;
										_tmp941_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp940_);
										_tmp942_ = _tmp941_;
										_tmp943_ = _tmp942_ != NULL;
										_g_free0 (_tmp942_);
										if (_tmp943_) {
											gchar* length_ctype = NULL;
											ValaParameter* _tmp944_;
											gchar* _tmp945_;
											gboolean _tmp946_ = FALSE;
											ValaUnaryExpression* _tmp947_;
											ValaExpression* _tmp953_;
											gint _tmp954_;
											ValaCCodeExpression* _tmp955_;
											ValaCCodeExpression* _tmp956_;
											const gchar* _tmp957_;
											ValaCCodeCastExpression* _tmp958_;
											_tmp944_ = param;
											_tmp945_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp944_);
											length_ctype = _tmp945_;
											_tmp947_ = unary;
											if (_tmp947_ != NULL) {
												ValaUnaryExpression* _tmp948_;
												ValaUnaryOperator _tmp949_;
												ValaUnaryOperator _tmp950_;
												_tmp948_ = unary;
												_tmp949_ = vala_unary_expression_get_operator (_tmp948_);
												_tmp950_ = _tmp949_;
												_tmp946_ = _tmp950_ == VALA_UNARY_OPERATOR_REF;
											} else {
												_tmp946_ = FALSE;
											}
											if (_tmp946_) {
												const gchar* _tmp951_;
												gchar* _tmp952_;
												_tmp951_ = length_ctype;
												_tmp952_ = g_strdup_printf ("%s*", _tmp951_);
												_g_free0 (length_ctype);
												length_ctype = _tmp952_;
											}
											_tmp953_ = arg;
											_tmp954_ = dim;
											_tmp955_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp953_, _tmp954_);
											_tmp956_ = _tmp955_;
											_tmp957_ = length_ctype;
											_tmp958_ = vala_ccode_cast_expression_new (_tmp956_, _tmp957_);
											_vala_ccode_node_unref0 (array_length_expr);
											array_length_expr = (ValaCCodeExpression*) _tmp958_;
											_vala_ccode_node_unref0 (_tmp956_);
											_g_free0 (length_ctype);
										} else {
											ValaExpression* _tmp959_;
											gint _tmp960_;
											ValaCCodeExpression* _tmp961_;
											_tmp959_ = arg;
											_tmp960_ = dim;
											_tmp961_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp959_, _tmp960_);
											_vala_ccode_node_unref0 (array_length_expr);
											array_length_expr = _tmp961_;
										}
										_tmp962_ = carg_map;
										_tmp963_ = param;
										_tmp964_ = dim;
										_tmp965_ = array_length_expr;
										vala_map_set ((ValaMap*) _tmp962_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp963_) + (0.01 * _tmp964_), FALSE)), _tmp965_);
										_vala_ccode_node_unref0 (array_length_expr);
									}
								}
							}
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp966_;
							ValaDataType* _tmp967_;
							ValaDataType* _tmp968_;
							_tmp966_ = param;
							_tmp967_ = vala_variable_get_variable_type ((ValaVariable*) _tmp966_);
							_tmp968_ = _tmp967_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp968_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp969_;
								ValaDataType* _tmp970_;
								ValaDataType* _tmp971_;
								ValaDelegateType* _tmp972_;
								ValaDelegateType* _tmp973_;
								ValaDelegate* _tmp974_;
								ValaDelegate* _tmp975_;
								gboolean _tmp976_;
								gboolean _tmp977_;
								_tmp969_ = param;
								_tmp970_ = vala_variable_get_variable_type ((ValaVariable*) _tmp969_);
								_tmp971_ = _tmp970_;
								_tmp972_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp971_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp972_;
								_tmp973_ = deleg_type;
								_tmp974_ = vala_delegate_type_get_delegate_symbol (_tmp973_);
								_tmp975_ = _tmp974_;
								_tmp976_ = vala_delegate_get_has_target (_tmp975_);
								_tmp977_ = _tmp976_;
								if (_tmp977_) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaCCodeExpression* delegate_target = NULL;
									ValaExpression* _tmp978_;
									ValaCCodeExpression* _tmp979_ = NULL;
									ValaCCodeExpression* _tmp980_;
									ValaCCodeExpression* _tmp981_;
									ValaParameter* _tmp982_;
									gchar* _tmp983_;
									gchar* _tmp984_;
									gboolean _tmp985_;
									_tmp978_ = arg;
									_tmp980_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp978_, &_tmp979_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp979_;
									delegate_target = _tmp980_;
									_tmp981_ = delegate_target;
									_vala_assert (_tmp981_ != NULL, "delegate_target != null");
									_tmp982_ = param;
									_tmp983_ = vala_get_ccode_type ((ValaCodeNode*) _tmp982_);
									_tmp984_ = _tmp983_;
									_tmp985_ = g_strcmp0 (_tmp984_, "GClosure*") == 0;
									_g_free0 (_tmp984_);
									if (_tmp985_) {
										ValaCCodeFunctionCall* closure_new = NULL;
										ValaCCodeIdentifier* _tmp986_;
										ValaCCodeIdentifier* _tmp987_;
										ValaCCodeFunctionCall* _tmp988_;
										ValaCCodeFunctionCall* _tmp989_;
										ValaCCodeFunctionCall* _tmp990_;
										ValaCCodeExpression* _tmp991_;
										ValaCCodeCastExpression* _tmp992_;
										ValaCCodeCastExpression* _tmp993_;
										ValaCCodeFunctionCall* _tmp994_;
										ValaCCodeExpression* _tmp995_;
										ValaCCodeFunctionCall* _tmp996_;
										ValaCCodeExpression* _tmp997_;
										ValaCCodeCastExpression* _tmp998_;
										ValaCCodeCastExpression* _tmp999_;
										ValaCCodeExpression* _tmp1000_;
										ValaCCodeIdentifier* _tmp1001_;
										ValaCCodeIdentifier* _tmp1002_;
										ValaCCodeBinaryExpression* _tmp1003_;
										ValaCCodeBinaryExpression* _tmp1004_;
										ValaCCodeIdentifier* _tmp1005_;
										ValaCCodeIdentifier* _tmp1006_;
										ValaCCodeFunctionCall* _tmp1007_;
										ValaCCodeConditionalExpression* _tmp1008_;
										_tmp986_ = vala_ccode_identifier_new ("g_cclosure_new");
										_tmp987_ = _tmp986_;
										_tmp988_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp987_);
										_tmp989_ = _tmp988_;
										_vala_ccode_node_unref0 (_tmp987_);
										closure_new = _tmp989_;
										_tmp990_ = closure_new;
										_tmp991_ = cexpr;
										_tmp992_ = vala_ccode_cast_expression_new (_tmp991_, "GCallback");
										_tmp993_ = _tmp992_;
										vala_ccode_function_call_add_argument (_tmp990_, (ValaCCodeExpression*) _tmp993_);
										_vala_ccode_node_unref0 (_tmp993_);
										_tmp994_ = closure_new;
										_tmp995_ = delegate_target;
										vala_ccode_function_call_add_argument (_tmp994_, _tmp995_);
										_tmp996_ = closure_new;
										_tmp997_ = delegate_target_destroy_notify;
										_tmp998_ = vala_ccode_cast_expression_new (_tmp997_, "GClosureNotify");
										_tmp999_ = _tmp998_;
										vala_ccode_function_call_add_argument (_tmp996_, (ValaCCodeExpression*) _tmp999_);
										_vala_ccode_node_unref0 (_tmp999_);
										_tmp1000_ = cexpr;
										_tmp1001_ = vala_ccode_identifier_new ("NULL");
										_tmp1002_ = _tmp1001_;
										_tmp1003_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1000_, (ValaCCodeExpression*) _tmp1002_);
										_tmp1004_ = _tmp1003_;
										_tmp1005_ = vala_ccode_identifier_new ("NULL");
										_tmp1006_ = _tmp1005_;
										_tmp1007_ = closure_new;
										_tmp1008_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1004_, (ValaCCodeExpression*) _tmp1006_, (ValaCCodeExpression*) _tmp1007_);
										_vala_ccode_node_unref0 (cexpr);
										cexpr = (ValaCCodeExpression*) _tmp1008_;
										_vala_ccode_node_unref0 (_tmp1006_);
										_vala_ccode_node_unref0 (_tmp1004_);
										_vala_ccode_node_unref0 (_tmp1002_);
										_vala_ccode_node_unref0 (closure_new);
									} else {
										ValaHashMap* _tmp1009_;
										ValaParameter* _tmp1010_;
										ValaCCodeExpression* _tmp1011_;
										ValaDelegateType* _tmp1012_;
										_tmp1009_ = carg_map;
										_tmp1010_ = param;
										_tmp1011_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp1009_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1010_), FALSE)), _tmp1011_);
										_tmp1012_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1012_)) {
											ValaCCodeExpression* _tmp1013_;
											ValaHashMap* _tmp1014_;
											ValaParameter* _tmp1015_;
											ValaCCodeExpression* _tmp1016_;
											_tmp1013_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1013_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1014_ = carg_map;
											_tmp1015_ = param;
											_tmp1016_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1014_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1015_) + 0.01, FALSE)), _tmp1016_);
										}
									}
									_vala_ccode_node_unref0 (delegate_target);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								}
								_vala_code_node_unref0 (deleg_type);
							} else {
								ValaParameter* _tmp1017_;
								ValaDataType* _tmp1018_;
								ValaDataType* _tmp1019_;
								_tmp1017_ = param;
								_tmp1018_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1017_);
								_tmp1019_ = _tmp1018_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1019_, VALA_TYPE_METHOD_TYPE)) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaHashMap* _tmp1020_;
									ValaParameter* _tmp1021_;
									ValaExpression* _tmp1022_;
									ValaCCodeExpression* _tmp1023_ = NULL;
									ValaCCodeExpression* _tmp1024_;
									ValaCCodeExpression* _tmp1025_;
									_tmp1020_ = carg_map;
									_tmp1021_ = param;
									_tmp1022_ = arg;
									_tmp1024_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1022_, &_tmp1023_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp1023_;
									_tmp1025_ = _tmp1024_;
									vala_map_set ((ValaMap*) _tmp1020_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1021_), FALSE)), _tmp1025_);
									_vala_ccode_node_unref0 (_tmp1025_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								} else {
									ValaParameter* _tmp1026_;
									ValaDataType* _tmp1027_;
									ValaDataType* _tmp1028_;
									_tmp1026_ = param;
									_tmp1027_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1026_);
									_tmp1028_ = _tmp1027_;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1028_, VALA_TYPE_GENERIC_TYPE)) {
										gboolean _tmp1029_ = FALSE;
										ValaMethod* _tmp1030_;
										_tmp1030_ = m;
										if (_tmp1030_ != NULL) {
											ValaMethod* _tmp1031_;
											_tmp1031_ = m;
											_tmp1029_ = vala_get_ccode_simple_generics (_tmp1031_);
										} else {
											_tmp1029_ = FALSE;
										}
										if (_tmp1029_) {
											ValaGenericType* generic_type = NULL;
											ValaParameter* _tmp1032_;
											ValaDataType* _tmp1033_;
											ValaDataType* _tmp1034_;
											ValaGenericType* _tmp1035_;
											gint type_param_index = 0;
											ValaMethod* _tmp1036_;
											ValaGenericType* _tmp1037_;
											ValaTypeParameter* _tmp1038_;
											ValaTypeParameter* _tmp1039_;
											const gchar* _tmp1040_;
											const gchar* _tmp1041_;
											ValaDataType* type_arg = NULL;
											ValaMemberAccess* _tmp1042_;
											ValaList* _tmp1043_;
											ValaList* _tmp1044_;
											gint _tmp1045_;
											gpointer _tmp1046_;
											ValaDataType* _tmp1047_;
											ValaParameter* _tmp1048_;
											ValaDataType* _tmp1049_;
											ValaDataType* _tmp1050_;
											gboolean _tmp1051_;
											gboolean _tmp1052_;
											_tmp1032_ = param;
											_tmp1033_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1032_);
											_tmp1034_ = _tmp1033_;
											_tmp1035_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1034_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
											generic_type = _tmp1035_;
											_tmp1036_ = m;
											_tmp1037_ = generic_type;
											_tmp1038_ = vala_generic_type_get_type_parameter (_tmp1037_);
											_tmp1039_ = _tmp1038_;
											_tmp1040_ = vala_symbol_get_name ((ValaSymbol*) _tmp1039_);
											_tmp1041_ = _tmp1040_;
											type_param_index = vala_method_get_type_parameter_index (_tmp1036_, _tmp1041_);
											_tmp1042_ = ma;
											_tmp1043_ = vala_member_access_get_type_arguments (_tmp1042_);
											_tmp1044_ = _tmp1043_;
											_tmp1045_ = type_param_index;
											_tmp1046_ = vala_list_get (_tmp1044_, _tmp1045_);
											_tmp1047_ = (ValaDataType*) _tmp1046_;
											_vala_iterable_unref0 (_tmp1044_);
											type_arg = _tmp1047_;
											_tmp1048_ = param;
											_tmp1049_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1048_);
											_tmp1050_ = _tmp1049_;
											_tmp1051_ = vala_data_type_get_value_owned (_tmp1050_);
											_tmp1052_ = _tmp1051_;
											if (_tmp1052_) {
												ValaDataType* _tmp1053_;
												_tmp1053_ = type_arg;
												if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1053_)) {
													ValaHashMap* _tmp1054_;
													ValaParameter* _tmp1055_;
													ValaDataType* _tmp1056_;
													ValaCCodeExpression* _tmp1057_;
													ValaCCodeExpression* _tmp1058_;
													_tmp1054_ = carg_map;
													_tmp1055_ = param;
													_tmp1056_ = type_arg;
													_tmp1057_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1056_, FALSE);
													_tmp1058_ = _tmp1057_;
													vala_map_set ((ValaMap*) _tmp1054_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1055_), FALSE)), _tmp1058_);
													_vala_ccode_node_unref0 (_tmp1058_);
												} else {
													ValaHashMap* _tmp1059_;
													ValaParameter* _tmp1060_;
													ValaCCodeConstant* _tmp1061_;
													ValaCCodeConstant* _tmp1062_;
													_tmp1059_ = carg_map;
													_tmp1060_ = param;
													_tmp1061_ = vala_ccode_constant_new ("NULL");
													_tmp1062_ = _tmp1061_;
													vala_map_set ((ValaMap*) _tmp1059_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1060_), FALSE)), (ValaCCodeExpression*) _tmp1062_);
													_vala_ccode_node_unref0 (_tmp1062_);
												}
											}
											_vala_code_node_unref0 (type_arg);
											_vala_code_node_unref0 (generic_type);
										}
									}
								}
							}
						}
						_tmp1063_ = param;
						_tmp1064_ = arg;
						_tmp1065_ = cexpr;
						_tmp1066_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1063_, _tmp1064_, _tmp1065_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = _tmp1066_;
					} else {
						ValaExpression* _tmp1067_;
						ValaLocalVariable* temp_var = NULL;
						ValaParameter* _tmp1068_;
						ValaDataType* _tmp1069_;
						ValaDataType* _tmp1070_;
						ValaParameter* _tmp1071_;
						ValaDataType* _tmp1072_;
						ValaDataType* _tmp1073_;
						gboolean _tmp1074_;
						gboolean _tmp1075_;
						ValaLocalVariable* _tmp1076_;
						ValaLocalVariable* _tmp1077_;
						ValaExpression* _tmp1078_;
						ValaLocalVariable* _tmp1079_;
						const gchar* _tmp1080_;
						const gchar* _tmp1081_;
						ValaCCodeExpression* _tmp1082_;
						ValaCCodeExpression* _tmp1083_;
						ValaExpression* _tmp1084_;
						ValaTargetValue* _tmp1085_;
						ValaTargetValue* _tmp1086_;
						ValaExpression* _tmp1087_;
						ValaDataType* _tmp1088_;
						ValaDataType* _tmp1089_;
						ValaExpression* _tmp1090_;
						ValaCCodeExpression* _tmp1091_;
						ValaCCodeExpression* _tmp1092_;
						ValaCCodeUnaryExpression* _tmp1093_;
						gboolean _tmp1094_ = FALSE;
						ValaParameter* _tmp1095_;
						_tmp1067_ = arg;
						vala_expression_set_target_value (_tmp1067_, NULL);
						_tmp1068_ = param;
						_tmp1069_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1068_);
						_tmp1070_ = _tmp1069_;
						_tmp1071_ = param;
						_tmp1072_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1071_);
						_tmp1073_ = _tmp1072_;
						_tmp1074_ = vala_data_type_get_value_owned (_tmp1073_);
						_tmp1075_ = _tmp1074_;
						_tmp1076_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1070_, _tmp1075_, NULL, TRUE);
						temp_var = _tmp1076_;
						_tmp1077_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1077_);
						_tmp1078_ = arg;
						_tmp1079_ = temp_var;
						_tmp1080_ = vala_symbol_get_name ((ValaSymbol*) _tmp1079_);
						_tmp1081_ = _tmp1080_;
						_tmp1082_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1081_);
						_tmp1083_ = _tmp1082_;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1078_, _tmp1083_);
						_vala_ccode_node_unref0 (_tmp1083_);
						_tmp1084_ = arg;
						_tmp1085_ = vala_expression_get_target_value (_tmp1084_);
						_tmp1086_ = _tmp1085_;
						_tmp1087_ = arg;
						_tmp1088_ = vala_expression_get_target_type (_tmp1087_);
						_tmp1089_ = _tmp1088_;
						vala_target_value_set_value_type (_tmp1086_, _tmp1089_);
						_tmp1090_ = arg;
						_tmp1091_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1090_);
						_tmp1092_ = _tmp1091_;
						_tmp1093_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1092_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1093_;
						_vala_ccode_node_unref0 (_tmp1092_);
						_tmp1095_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1095_)) {
							ValaParameter* _tmp1096_;
							ValaDataType* _tmp1097_;
							ValaDataType* _tmp1098_;
							_tmp1096_ = param;
							_tmp1097_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1096_);
							_tmp1098_ = _tmp1097_;
							_tmp1094_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1098_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp1094_ = FALSE;
						}
						if (_tmp1094_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp1099_;
							ValaDataType* _tmp1100_;
							ValaDataType* _tmp1101_;
							ValaArrayType* _tmp1102_;
							ValaDataType* array_length_type = NULL;
							ValaDataType* _tmp1103_;
							ValaDataType* _tmp1104_;
							ValaParameter* _tmp1105_;
							gchar* _tmp1106_;
							gchar* _tmp1107_;
							gboolean _tmp1108_;
							_tmp1099_ = param;
							_tmp1100_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1099_);
							_tmp1101_ = _tmp1100_;
							_tmp1102_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1101_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp1102_;
							_tmp1103_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1104_ = _vala_code_node_ref0 (_tmp1103_);
							array_length_type = _tmp1104_;
							_tmp1105_ = param;
							_tmp1106_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1105_);
							_tmp1107_ = _tmp1106_;
							_tmp1108_ = _tmp1107_ != NULL;
							_g_free0 (_tmp1107_);
							if (_tmp1108_) {
								ValaParameter* _tmp1109_;
								gchar* _tmp1110_;
								gchar* _tmp1111_;
								ValaCType* _tmp1112_;
								_tmp1109_ = param;
								_tmp1110_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1109_);
								_tmp1111_ = _tmp1110_;
								_tmp1112_ = vala_ctype_new (_tmp1111_);
								_vala_code_node_unref0 (array_length_type);
								array_length_type = (ValaDataType*) _tmp1112_;
								_g_free0 (_tmp1111_);
							}
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp1113_ = FALSE;
									_tmp1113_ = TRUE;
									while (TRUE) {
										gint _tmp1115_;
										ValaArrayType* _tmp1116_;
										gint _tmp1117_;
										gint _tmp1118_;
										ValaLocalVariable* temp_array_length = NULL;
										ValaDataType* _tmp1119_;
										ValaLocalVariable* _tmp1120_;
										ValaLocalVariable* _tmp1121_;
										ValaExpression* _tmp1122_;
										ValaLocalVariable* _tmp1123_;
										const gchar* _tmp1124_;
										const gchar* _tmp1125_;
										ValaCCodeExpression* _tmp1126_;
										ValaCCodeExpression* _tmp1127_;
										ValaHashMap* _tmp1128_;
										ValaParameter* _tmp1129_;
										gint _tmp1130_;
										ValaExpression* _tmp1131_;
										ValaList* _tmp1132_;
										ValaList* _tmp1133_;
										gint _tmp1134_;
										gpointer _tmp1135_;
										ValaCCodeExpression* _tmp1136_;
										ValaCCodeUnaryExpression* _tmp1137_;
										ValaCCodeUnaryExpression* _tmp1138_;
										if (!_tmp1113_) {
											gint _tmp1114_;
											_tmp1114_ = dim;
											dim = _tmp1114_ + 1;
										}
										_tmp1113_ = FALSE;
										_tmp1115_ = dim;
										_tmp1116_ = array_type;
										_tmp1117_ = vala_array_type_get_rank (_tmp1116_);
										_tmp1118_ = _tmp1117_;
										if (!(_tmp1115_ <= _tmp1118_)) {
											break;
										}
										_tmp1119_ = array_length_type;
										_tmp1120_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1119_, TRUE, NULL, FALSE);
										temp_array_length = _tmp1120_;
										_tmp1121_ = temp_array_length;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1121_);
										_tmp1122_ = arg;
										_tmp1123_ = temp_array_length;
										_tmp1124_ = vala_symbol_get_name ((ValaSymbol*) _tmp1123_);
										_tmp1125_ = _tmp1124_;
										_tmp1126_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1125_);
										_tmp1127_ = _tmp1126_;
										vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1122_, _tmp1127_);
										_vala_ccode_node_unref0 (_tmp1127_);
										_tmp1128_ = carg_map;
										_tmp1129_ = param;
										_tmp1130_ = dim;
										_tmp1131_ = arg;
										_tmp1132_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1131_);
										_tmp1133_ = _tmp1132_;
										_tmp1134_ = dim;
										_tmp1135_ = vala_list_get (_tmp1133_, _tmp1134_ - 1);
										_tmp1136_ = (ValaCCodeExpression*) _tmp1135_;
										_tmp1137_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1136_);
										_tmp1138_ = _tmp1137_;
										vala_map_set ((ValaMap*) _tmp1128_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1129_) + (0.01 * _tmp1130_), FALSE)), (ValaCCodeExpression*) _tmp1138_);
										_vala_ccode_node_unref0 (_tmp1138_);
										_vala_ccode_node_unref0 (_tmp1136_);
										_vala_iterable_unref0 (_tmp1133_);
										_vala_code_node_unref0 (temp_array_length);
									}
								}
							}
							_vala_code_node_unref0 (array_length_type);
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp1139_;
							ValaDataType* _tmp1140_;
							ValaDataType* _tmp1141_;
							_tmp1139_ = param;
							_tmp1140_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1139_);
							_tmp1141_ = _tmp1140_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1141_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp1142_;
								ValaDataType* _tmp1143_;
								ValaDataType* _tmp1144_;
								ValaDelegateType* _tmp1145_;
								ValaDelegateType* _tmp1146_;
								ValaDelegate* _tmp1147_;
								ValaDelegate* _tmp1148_;
								gboolean _tmp1149_;
								gboolean _tmp1150_;
								_tmp1142_ = param;
								_tmp1143_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1142_);
								_tmp1144_ = _tmp1143_;
								_tmp1145_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1144_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp1145_;
								_tmp1146_ = deleg_type;
								_tmp1147_ = vala_delegate_type_get_delegate_symbol (_tmp1146_);
								_tmp1148_ = _tmp1147_;
								_tmp1149_ = vala_delegate_get_has_target (_tmp1148_);
								_tmp1150_ = _tmp1149_;
								if (_tmp1150_) {
									ValaVoidType* _tmp1151_;
									ValaVoidType* _tmp1152_;
									ValaPointerType* _tmp1153_;
									ValaPointerType* _tmp1154_;
									ValaLocalVariable* _tmp1155_;
									ValaLocalVariable* _tmp1156_;
									ValaExpression* _tmp1157_;
									ValaLocalVariable* _tmp1158_;
									const gchar* _tmp1159_;
									const gchar* _tmp1160_;
									ValaCCodeExpression* _tmp1161_;
									ValaCCodeExpression* _tmp1162_;
									ValaHashMap* _tmp1163_;
									ValaParameter* _tmp1164_;
									ValaExpression* _tmp1165_;
									ValaCCodeExpression* _tmp1166_;
									ValaCCodeExpression* _tmp1167_;
									ValaCCodeUnaryExpression* _tmp1168_;
									ValaCCodeUnaryExpression* _tmp1169_;
									ValaDelegateType* _tmp1170_;
									_tmp1151_ = vala_void_type_new (NULL);
									_tmp1152_ = _tmp1151_;
									_tmp1153_ = vala_pointer_type_new ((ValaDataType*) _tmp1152_, NULL);
									_tmp1154_ = _tmp1153_;
									_tmp1155_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1154_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1155_;
									_vala_code_node_unref0 (_tmp1154_);
									_vala_code_node_unref0 (_tmp1152_);
									_tmp1156_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1156_);
									_tmp1157_ = arg;
									_tmp1158_ = temp_var;
									_tmp1159_ = vala_symbol_get_name ((ValaSymbol*) _tmp1158_);
									_tmp1160_ = _tmp1159_;
									_tmp1161_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1160_);
									_tmp1162_ = _tmp1161_;
									vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1157_, _tmp1162_);
									_vala_ccode_node_unref0 (_tmp1162_);
									_tmp1163_ = carg_map;
									_tmp1164_ = param;
									_tmp1165_ = arg;
									_tmp1166_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1165_);
									_tmp1167_ = _tmp1166_;
									_tmp1168_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1167_);
									_tmp1169_ = _tmp1168_;
									vala_map_set ((ValaMap*) _tmp1163_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1164_), FALSE)), (ValaCCodeExpression*) _tmp1169_);
									_vala_ccode_node_unref0 (_tmp1169_);
									_vala_ccode_node_unref0 (_tmp1167_);
									_tmp1170_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1170_)) {
										ValaDataType* _tmp1171_;
										ValaLocalVariable* _tmp1172_;
										ValaLocalVariable* _tmp1173_;
										ValaExpression* _tmp1174_;
										ValaLocalVariable* _tmp1175_;
										const gchar* _tmp1176_;
										const gchar* _tmp1177_;
										ValaCCodeExpression* _tmp1178_;
										ValaCCodeExpression* _tmp1179_;
										ValaHashMap* _tmp1180_;
										ValaParameter* _tmp1181_;
										ValaExpression* _tmp1182_;
										ValaCCodeExpression* _tmp1183_;
										ValaCCodeExpression* _tmp1184_;
										ValaCCodeUnaryExpression* _tmp1185_;
										ValaCCodeUnaryExpression* _tmp1186_;
										_tmp1171_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
										_tmp1172_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1171_, TRUE, NULL, TRUE);
										_vala_code_node_unref0 (temp_var);
										temp_var = _tmp1172_;
										_tmp1173_ = temp_var;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1173_);
										_tmp1174_ = arg;
										_tmp1175_ = temp_var;
										_tmp1176_ = vala_symbol_get_name ((ValaSymbol*) _tmp1175_);
										_tmp1177_ = _tmp1176_;
										_tmp1178_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1177_);
										_tmp1179_ = _tmp1178_;
										vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1174_, _tmp1179_);
										_vala_ccode_node_unref0 (_tmp1179_);
										_tmp1180_ = carg_map;
										_tmp1181_ = param;
										_tmp1182_ = arg;
										_tmp1183_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1182_);
										_tmp1184_ = _tmp1183_;
										_tmp1185_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1184_);
										_tmp1186_ = _tmp1185_;
										vala_map_set ((ValaMap*) _tmp1180_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1181_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1186_);
										_vala_ccode_node_unref0 (_tmp1186_);
										_vala_ccode_node_unref0 (_tmp1184_);
									}
								}
								_vala_code_node_unref0 (deleg_type);
							}
						}
						_vala_code_node_unref0 (temp_var);
					}
					_tmp1187_ = param;
					_tmp1188_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1187_);
					_tmp1189_ = _tmp1188_;
					_tmp1190_ = _tmp1189_ != NULL;
					_g_free0 (_tmp1189_);
					if (_tmp1190_) {
						ValaCCodeExpression* _tmp1191_;
						ValaParameter* _tmp1192_;
						gchar* _tmp1193_;
						gchar* _tmp1194_;
						ValaCCodeCastExpression* _tmp1195_;
						_tmp1191_ = cexpr;
						_tmp1192_ = param;
						_tmp1193_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1192_);
						_tmp1194_ = _tmp1193_;
						_tmp1195_ = vala_ccode_cast_expression_new (_tmp1191_, _tmp1194_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1195_;
						_g_free0 (_tmp1194_);
					}
					_vala_code_node_unref0 (unary);
				} else {
					ValaExpression* _tmp1196_;
					ValaCCodeExpression* _tmp1197_;
					ValaCCodeExpression* _tmp1198_;
					_tmp1196_ = arg;
					_tmp1197_ = cexpr;
					_tmp1198_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1196_, _tmp1197_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1198_;
				}
				_tmp1199_ = param;
				_tmp1200_ = ellipsis;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_pos (_tmp1199_), _tmp1200_);
				_vala_code_node_unref0 (param);
			} else {
				ValaExpression* _tmp1201_;
				ValaCCodeExpression* _tmp1202_;
				ValaCCodeExpression* _tmp1203_;
				gint _tmp1204_;
				gboolean _tmp1205_;
				_tmp1201_ = arg;
				_tmp1202_ = cexpr;
				_tmp1203_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1201_, _tmp1202_);
				_vala_ccode_node_unref0 (cexpr);
				cexpr = _tmp1203_;
				_tmp1204_ = i;
				_tmp1205_ = ellipsis;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) _tmp1204_, _tmp1205_);
			}
			_tmp1206_ = carg_map;
			_tmp1207_ = arg_pos;
			_tmp1208_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1206_, (gpointer) ((gintptr) _tmp1207_), _tmp1208_);
			_tmp1210_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1210_, VALA_TYPE_NAMED_ARGUMENT)) {
				gboolean _tmp1211_;
				_tmp1211_ = ellipsis;
				_tmp1209_ = _tmp1211_;
			} else {
				_tmp1209_ = FALSE;
			}
			if (_tmp1209_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1212_;
				ValaNamedArgument* _tmp1213_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1214_;
				const gchar* _tmp1215_;
				const gchar* _tmp1216_;
				gchar** _tmp1217_;
				gchar** _tmp1218_;
				gchar** _tmp1219_;
				gint _tmp1219__length1;
				gchar* _tmp1220_;
				gchar* _tmp1221_;
				ValaHashMap* _tmp1222_;
				gint _tmp1223_;
				gboolean _tmp1224_;
				const gchar* _tmp1225_;
				gchar* _tmp1226_;
				gchar* _tmp1227_;
				ValaCCodeConstant* _tmp1228_;
				ValaCCodeConstant* _tmp1229_;
				_tmp1212_ = arg;
				_tmp1213_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1212_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1213_;
				_tmp1214_ = named_arg;
				_tmp1215_ = vala_named_argument_get_name (_tmp1214_);
				_tmp1216_ = _tmp1215_;
				_tmp1218_ = _tmp1217_ = g_strsplit (_tmp1216_, "_", 0);
				_tmp1219_ = _tmp1218_;
				_tmp1219__length1 = _vala_array_length (_tmp1217_);
				_tmp1220_ = _vala_g_strjoinv ("-", _tmp1219_, _vala_array_length (_tmp1217_));
				_tmp1221_ = _tmp1220_;
				_tmp1219_ = (_vala_array_free (_tmp1219_, _tmp1219__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1221_;
				_tmp1222_ = carg_map;
				_tmp1223_ = i;
				_tmp1224_ = ellipsis;
				_tmp1225_ = name;
				_tmp1226_ = g_strdup_printf ("\"%s\"", _tmp1225_);
				_tmp1227_ = _tmp1226_;
				_tmp1228_ = vala_ccode_constant_new (_tmp1227_);
				_tmp1229_ = _tmp1228_;
				vala_map_set ((ValaMap*) _tmp1222_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1223_ - 0.1, _tmp1224_)), (ValaCCodeExpression*) _tmp1229_);
				_vala_ccode_node_unref0 (_tmp1229_);
				_g_free0 (_tmp1227_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1230_ = i;
			i = _tmp1230_ + 1;
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1231_ = params_it;
	if (vala_iterator_next (_tmp1231_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1232_;
		gpointer _tmp1233_;
		gboolean _tmp1234_ = FALSE;
		ValaParameter* _tmp1235_;
		gboolean _tmp1236_;
		gboolean _tmp1237_;
		_tmp1232_ = params_it;
		_tmp1233_ = vala_iterator_get (_tmp1232_);
		param = (ValaParameter*) _tmp1233_;
		_tmp1235_ = param;
		_tmp1236_ = vala_parameter_get_params_array (_tmp1235_);
		_tmp1237_ = _tmp1236_;
		if (_tmp1237_) {
			_tmp1234_ = TRUE;
		} else {
			ValaParameter* _tmp1238_;
			gboolean _tmp1239_;
			gboolean _tmp1240_;
			_tmp1238_ = param;
			_tmp1239_ = vala_parameter_get_ellipsis (_tmp1238_);
			_tmp1240_ = _tmp1239_;
			_tmp1234_ = _tmp1240_;
		}
		_vala_assert (_tmp1234_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1243_ = m;
	if (_tmp1243_ != NULL) {
		ValaMethod* _tmp1244_;
		ValaDataType* _tmp1245_;
		ValaDataType* _tmp1246_;
		_tmp1244_ = m;
		_tmp1245_ = vala_callable_get_return_type ((ValaCallable*) _tmp1244_);
		_tmp1246_ = _tmp1245_;
		_tmp1242_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1246_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1242_ = FALSE;
	}
	if (_tmp1242_) {
		ValaCCodeFunctionCall* _tmp1247_;
		ValaCCodeFunctionCall* _tmp1248_;
		_tmp1247_ = async_call;
		_tmp1248_ = ccall;
		_tmp1241_ = _tmp1247_ != _tmp1248_;
	} else {
		_tmp1241_ = FALSE;
	}
	if (_tmp1241_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1249_;
		ValaDataType* _tmp1250_;
		ValaDataType* _tmp1251_;
		ValaArrayType* _tmp1252_;
		_tmp1249_ = m;
		_tmp1250_ = vala_callable_get_return_type ((ValaCallable*) _tmp1249_);
		_tmp1251_ = _tmp1250_;
		_tmp1252_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1251_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1252_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1253_ = FALSE;
				_tmp1253_ = TRUE;
				while (TRUE) {
					gint _tmp1255_;
					ValaArrayType* _tmp1256_;
					gint _tmp1257_;
					gint _tmp1258_;
					ValaMethod* _tmp1259_;
					if (!_tmp1253_) {
						gint _tmp1254_;
						_tmp1254_ = dim;
						dim = _tmp1254_ + 1;
					}
					_tmp1253_ = FALSE;
					_tmp1255_ = dim;
					_tmp1256_ = array_type;
					_tmp1257_ = vala_array_type_get_rank (_tmp1256_);
					_tmp1258_ = _tmp1257_;
					if (!(_tmp1255_ <= _tmp1258_)) {
						break;
					}
					_tmp1259_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1259_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1260_;
						ValaDataType* _tmp1261_;
						ValaDataType* _tmp1262_;
						ValaLocalVariable* _tmp1263_;
						ValaLocalVariable* _tmp1264_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1265_;
						const gchar* _tmp1266_;
						const gchar* _tmp1267_;
						ValaCCodeExpression* _tmp1268_;
						ValaLocalVariable* _tmp1269_;
						ValaCCodeExpression* _tmp1270_;
						ValaCCodeExpression* _tmp1271_;
						ValaCCodeAssignment* _tmp1272_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1273_;
						ValaCCodeIdentifier* _tmp1274_;
						ValaCCodeFunctionCall* _tmp1275_;
						ValaCCodeFunctionCall* _tmp1276_;
						ValaCCodeFunctionCall* _tmp1277_;
						ValaCCodeExpression* _tmp1278_;
						ValaCCodeFunctionCall* _tmp1279_;
						_tmp1260_ = itype;
						_tmp1261_ = vala_data_type_get_return_type (_tmp1260_);
						_tmp1262_ = _tmp1261_;
						_tmp1263_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1262_, TRUE, NULL, FALSE);
						_tmp1264_ = _tmp1263_;
						_vala_code_node_unref0 (_tmp1262_);
						temp_var = _tmp1264_;
						_tmp1265_ = temp_var;
						_tmp1266_ = vala_symbol_get_name ((ValaSymbol*) _tmp1265_);
						_tmp1267_ = _tmp1266_;
						_tmp1268_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1267_);
						temp_ref = _tmp1268_;
						_tmp1269_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1269_);
						_tmp1270_ = temp_ref;
						_tmp1271_ = ccall_expr;
						_tmp1272_ = vala_ccode_assignment_new (_tmp1270_, _tmp1271_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1272_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1273_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1274_ = _tmp1273_;
						_tmp1275_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1274_);
						_tmp1276_ = _tmp1275_;
						_vala_ccode_node_unref0 (_tmp1274_);
						len_call = _tmp1276_;
						_tmp1277_ = len_call;
						_tmp1278_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1277_, _tmp1278_);
						_tmp1279_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1279_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1280_;
						_tmp1280_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1280_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaMethod* _tmp1281_;
							gchar* _tmp1282_;
							gchar* _tmp1283_;
							gboolean _tmp1284_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1293_;
							const gchar* _tmp1294_;
							const gchar* _tmp1295_;
							ValaCCodeExpression* _tmp1296_;
							ValaLocalVariable* _tmp1297_;
							ValaHashMap* _tmp1298_;
							ValaMethod* _tmp1299_;
							gint _tmp1300_;
							ValaCCodeExpression* _tmp1301_;
							ValaCCodeUnaryExpression* _tmp1302_;
							ValaCCodeUnaryExpression* _tmp1303_;
							ValaCCodeExpression* _tmp1304_;
							_tmp1281_ = m;
							_tmp1282_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1281_);
							_tmp1283_ = _tmp1282_;
							_tmp1284_ = _tmp1283_ == NULL;
							_g_free0 (_tmp1283_);
							if (_tmp1284_) {
								ValaDataType* _tmp1285_;
								ValaLocalVariable* _tmp1286_;
								_tmp1285_ = ((ValaCCodeBaseModule*) self)->int_type;
								_tmp1286_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1285_, TRUE, NULL, FALSE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1286_;
							} else {
								ValaMethod* _tmp1287_;
								gchar* _tmp1288_;
								gchar* _tmp1289_;
								ValaCType* _tmp1290_;
								ValaCType* _tmp1291_;
								ValaLocalVariable* _tmp1292_;
								_tmp1287_ = m;
								_tmp1288_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1287_);
								_tmp1289_ = _tmp1288_;
								_tmp1290_ = vala_ctype_new (_tmp1289_);
								_tmp1291_ = _tmp1290_;
								_tmp1292_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1291_, TRUE, NULL, FALSE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1292_;
								_vala_code_node_unref0 (_tmp1291_);
								_g_free0 (_tmp1289_);
							}
							_tmp1293_ = temp_var;
							_tmp1294_ = vala_symbol_get_name ((ValaSymbol*) _tmp1293_);
							_tmp1295_ = _tmp1294_;
							_tmp1296_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1295_);
							temp_ref = _tmp1296_;
							_tmp1297_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1297_);
							_tmp1298_ = out_arg_map;
							_tmp1299_ = m;
							_tmp1300_ = dim;
							_tmp1301_ = temp_ref;
							_tmp1302_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1301_);
							_tmp1303_ = _tmp1302_;
							vala_map_set ((ValaMap*) _tmp1298_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1299_) + (0.01 * _tmp1300_), FALSE)), (ValaCCodeExpression*) _tmp1303_);
							_vala_ccode_node_unref0 (_tmp1303_);
							_tmp1304_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1304_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaMethod* _tmp1305_;
							gchar* _tmp1306_;
							gchar* _tmp1307_;
							gboolean _tmp1308_;
							_tmp1305_ = m;
							_tmp1306_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1305_);
							_tmp1307_ = _tmp1306_;
							_tmp1308_ = _tmp1307_ != NULL;
							_g_free0 (_tmp1307_);
							if (_tmp1308_) {
								ValaMethod* _tmp1309_;
								gchar* _tmp1310_;
								gchar* _tmp1311_;
								ValaCCodeConstant* _tmp1312_;
								ValaCCodeConstant* _tmp1313_;
								_tmp1309_ = m;
								_tmp1310_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1309_);
								_tmp1311_ = _tmp1310_;
								_tmp1312_ = vala_ccode_constant_new (_tmp1311_);
								_tmp1313_ = _tmp1312_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1313_);
								_vala_ccode_node_unref0 (_tmp1313_);
								_g_free0 (_tmp1311_);
							} else {
								ValaCCodeConstant* _tmp1314_;
								ValaCCodeConstant* _tmp1315_;
								_tmp1314_ = vala_ccode_constant_new ("-1");
								_tmp1315_ = _tmp1314_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1315_);
								_vala_ccode_node_unref0 (_tmp1315_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1316_ = FALSE;
		gboolean _tmp1317_ = FALSE;
		ValaMethod* _tmp1318_;
		_tmp1318_ = m;
		if (_tmp1318_ != NULL) {
			ValaMethod* _tmp1319_;
			ValaDataType* _tmp1320_;
			ValaDataType* _tmp1321_;
			_tmp1319_ = m;
			_tmp1320_ = vala_callable_get_return_type ((ValaCallable*) _tmp1319_);
			_tmp1321_ = _tmp1320_;
			_tmp1317_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1321_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1317_ = FALSE;
		}
		if (_tmp1317_) {
			ValaCCodeFunctionCall* _tmp1322_;
			ValaCCodeFunctionCall* _tmp1323_;
			_tmp1322_ = async_call;
			_tmp1323_ = ccall;
			_tmp1316_ = _tmp1322_ != _tmp1323_;
		} else {
			_tmp1316_ = FALSE;
		}
		if (_tmp1316_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1324_;
			ValaDataType* _tmp1325_;
			ValaDataType* _tmp1326_;
			ValaDelegateType* _tmp1327_;
			ValaDelegateType* _tmp1328_;
			ValaDelegate* _tmp1329_;
			ValaDelegate* _tmp1330_;
			gboolean _tmp1331_;
			gboolean _tmp1332_;
			_tmp1324_ = m;
			_tmp1325_ = vala_callable_get_return_type ((ValaCallable*) _tmp1324_);
			_tmp1326_ = _tmp1325_;
			_tmp1327_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1326_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1327_;
			_tmp1328_ = deleg_type;
			_tmp1329_ = vala_delegate_type_get_delegate_symbol (_tmp1328_);
			_tmp1330_ = _tmp1329_;
			_tmp1331_ = vala_delegate_get_has_target (_tmp1330_);
			_tmp1332_ = _tmp1331_;
			if (_tmp1332_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1333_;
				ValaVoidType* _tmp1334_;
				ValaPointerType* _tmp1335_;
				ValaPointerType* _tmp1336_;
				ValaLocalVariable* _tmp1337_;
				ValaLocalVariable* _tmp1338_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1339_;
				const gchar* _tmp1340_;
				const gchar* _tmp1341_;
				ValaCCodeExpression* _tmp1342_;
				ValaLocalVariable* _tmp1343_;
				ValaHashMap* _tmp1344_;
				ValaMethod* _tmp1345_;
				ValaCCodeExpression* _tmp1346_;
				ValaCCodeUnaryExpression* _tmp1347_;
				ValaCCodeUnaryExpression* _tmp1348_;
				ValaCCodeExpression* _tmp1349_;
				ValaDelegateType* _tmp1350_;
				_tmp1333_ = vala_void_type_new (NULL);
				_tmp1334_ = _tmp1333_;
				_tmp1335_ = vala_pointer_type_new ((ValaDataType*) _tmp1334_, NULL);
				_tmp1336_ = _tmp1335_;
				_tmp1337_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1336_, TRUE, NULL, FALSE);
				_tmp1338_ = _tmp1337_;
				_vala_code_node_unref0 (_tmp1336_);
				_vala_code_node_unref0 (_tmp1334_);
				temp_var = _tmp1338_;
				_tmp1339_ = temp_var;
				_tmp1340_ = vala_symbol_get_name ((ValaSymbol*) _tmp1339_);
				_tmp1341_ = _tmp1340_;
				_tmp1342_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1341_);
				temp_ref = _tmp1342_;
				_tmp1343_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1343_);
				_tmp1344_ = out_arg_map;
				_tmp1345_ = m;
				_tmp1346_ = temp_ref;
				_tmp1347_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1346_);
				_tmp1348_ = _tmp1347_;
				vala_map_set ((ValaMap*) _tmp1344_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1345_), FALSE)), (ValaCCodeExpression*) _tmp1348_);
				_vala_ccode_node_unref0 (_tmp1348_);
				_tmp1349_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1349_);
				_tmp1350_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1350_)) {
					ValaDataType* _tmp1351_;
					ValaLocalVariable* _tmp1352_;
					ValaLocalVariable* _tmp1353_;
					const gchar* _tmp1354_;
					const gchar* _tmp1355_;
					ValaCCodeExpression* _tmp1356_;
					ValaLocalVariable* _tmp1357_;
					ValaHashMap* _tmp1358_;
					ValaMethod* _tmp1359_;
					ValaCCodeExpression* _tmp1360_;
					ValaCCodeUnaryExpression* _tmp1361_;
					ValaCCodeUnaryExpression* _tmp1362_;
					ValaCCodeExpression* _tmp1363_;
					_tmp1351_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1352_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1351_, TRUE, NULL, FALSE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1352_;
					_tmp1353_ = temp_var;
					_tmp1354_ = vala_symbol_get_name ((ValaSymbol*) _tmp1353_);
					_tmp1355_ = _tmp1354_;
					_tmp1356_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1355_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1356_;
					_tmp1357_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1357_);
					_tmp1358_ = out_arg_map;
					_tmp1359_ = m;
					_tmp1360_ = temp_ref;
					_tmp1361_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1360_);
					_tmp1362_ = _tmp1361_;
					vala_map_set ((ValaMap*) _tmp1358_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1359_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1362_);
					_vala_ccode_node_unref0 (_tmp1362_);
					_tmp1363_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1363_);
				} else {
					ValaCCodeConstant* _tmp1364_;
					ValaCCodeConstant* _tmp1365_;
					_tmp1364_ = vala_ccode_constant_new ("NULL");
					_tmp1365_ = _tmp1364_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1365_);
					_vala_ccode_node_unref0 (_tmp1365_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1366_;
				ValaCCodeConstant* _tmp1367_;
				_tmp1366_ = vala_ccode_constant_new ("NULL");
				_tmp1367_ = _tmp1366_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1367_);
				_vala_ccode_node_unref0 (_tmp1367_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1369_ = deleg;
	if (_tmp1369_ != NULL) {
		ValaDelegate* _tmp1370_;
		ValaDataType* _tmp1371_;
		ValaDataType* _tmp1372_;
		_tmp1370_ = deleg;
		_tmp1371_ = vala_callable_get_return_type ((ValaCallable*) _tmp1370_);
		_tmp1372_ = _tmp1371_;
		_tmp1368_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1372_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1368_ = FALSE;
	}
	if (_tmp1368_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1373_;
		ValaDataType* _tmp1374_;
		ValaDataType* _tmp1375_;
		ValaArrayType* _tmp1376_;
		_tmp1373_ = deleg;
		_tmp1374_ = vala_callable_get_return_type ((ValaCallable*) _tmp1373_);
		_tmp1375_ = _tmp1374_;
		_tmp1376_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1375_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1376_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1377_ = FALSE;
				_tmp1377_ = TRUE;
				while (TRUE) {
					gint _tmp1379_;
					ValaArrayType* _tmp1380_;
					gint _tmp1381_;
					gint _tmp1382_;
					ValaDelegate* _tmp1383_;
					if (!_tmp1377_) {
						gint _tmp1378_;
						_tmp1378_ = dim;
						dim = _tmp1378_ + 1;
					}
					_tmp1377_ = FALSE;
					_tmp1379_ = dim;
					_tmp1380_ = array_type;
					_tmp1381_ = vala_array_type_get_rank (_tmp1380_);
					_tmp1382_ = _tmp1381_;
					if (!(_tmp1379_ <= _tmp1382_)) {
						break;
					}
					_tmp1383_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1383_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1384_;
						ValaDataType* _tmp1385_;
						ValaDataType* _tmp1386_;
						ValaLocalVariable* _tmp1387_;
						ValaLocalVariable* _tmp1388_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1389_;
						const gchar* _tmp1390_;
						const gchar* _tmp1391_;
						ValaCCodeExpression* _tmp1392_;
						ValaLocalVariable* _tmp1393_;
						ValaCCodeExpression* _tmp1394_;
						ValaCCodeExpression* _tmp1395_;
						ValaCCodeAssignment* _tmp1396_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1397_;
						ValaCCodeIdentifier* _tmp1398_;
						ValaCCodeFunctionCall* _tmp1399_;
						ValaCCodeFunctionCall* _tmp1400_;
						ValaCCodeFunctionCall* _tmp1401_;
						ValaCCodeExpression* _tmp1402_;
						ValaCCodeFunctionCall* _tmp1403_;
						_tmp1384_ = itype;
						_tmp1385_ = vala_data_type_get_return_type (_tmp1384_);
						_tmp1386_ = _tmp1385_;
						_tmp1387_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1386_, TRUE, NULL, FALSE);
						_tmp1388_ = _tmp1387_;
						_vala_code_node_unref0 (_tmp1386_);
						temp_var = _tmp1388_;
						_tmp1389_ = temp_var;
						_tmp1390_ = vala_symbol_get_name ((ValaSymbol*) _tmp1389_);
						_tmp1391_ = _tmp1390_;
						_tmp1392_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1391_);
						temp_ref = _tmp1392_;
						_tmp1393_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1393_);
						_tmp1394_ = temp_ref;
						_tmp1395_ = ccall_expr;
						_tmp1396_ = vala_ccode_assignment_new (_tmp1394_, _tmp1395_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1396_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1397_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1398_ = _tmp1397_;
						_tmp1399_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1398_);
						_tmp1400_ = _tmp1399_;
						_vala_ccode_node_unref0 (_tmp1398_);
						len_call = _tmp1400_;
						_tmp1401_ = len_call;
						_tmp1402_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1401_, _tmp1402_);
						_tmp1403_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1403_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1404_;
						_tmp1404_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1404_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaDataType* _tmp1405_;
							ValaLocalVariable* _tmp1406_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1407_;
							const gchar* _tmp1408_;
							const gchar* _tmp1409_;
							ValaCCodeExpression* _tmp1410_;
							ValaLocalVariable* _tmp1411_;
							ValaHashMap* _tmp1412_;
							ValaDelegate* _tmp1413_;
							gint _tmp1414_;
							ValaCCodeExpression* _tmp1415_;
							ValaCCodeUnaryExpression* _tmp1416_;
							ValaCCodeUnaryExpression* _tmp1417_;
							ValaCCodeExpression* _tmp1418_;
							_tmp1405_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1406_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1405_, TRUE, NULL, FALSE);
							temp_var = _tmp1406_;
							_tmp1407_ = temp_var;
							_tmp1408_ = vala_symbol_get_name ((ValaSymbol*) _tmp1407_);
							_tmp1409_ = _tmp1408_;
							_tmp1410_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1409_);
							temp_ref = _tmp1410_;
							_tmp1411_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1411_);
							_tmp1412_ = out_arg_map;
							_tmp1413_ = deleg;
							_tmp1414_ = dim;
							_tmp1415_ = temp_ref;
							_tmp1416_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1415_);
							_tmp1417_ = _tmp1416_;
							vala_map_set ((ValaMap*) _tmp1412_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1413_) + (0.01 * _tmp1414_), FALSE)), (ValaCCodeExpression*) _tmp1417_);
							_vala_ccode_node_unref0 (_tmp1417_);
							_tmp1418_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1418_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1419_;
							ValaCCodeConstant* _tmp1420_;
							_tmp1419_ = vala_ccode_constant_new ("-1");
							_tmp1420_ = _tmp1419_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1420_);
							_vala_ccode_node_unref0 (_tmp1420_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1421_ = FALSE;
		ValaDelegate* _tmp1422_;
		_tmp1422_ = deleg;
		if (_tmp1422_ != NULL) {
			ValaDelegate* _tmp1423_;
			ValaDataType* _tmp1424_;
			ValaDataType* _tmp1425_;
			_tmp1423_ = deleg;
			_tmp1424_ = vala_callable_get_return_type ((ValaCallable*) _tmp1423_);
			_tmp1425_ = _tmp1424_;
			_tmp1421_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1425_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1421_ = FALSE;
		}
		if (_tmp1421_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1426_;
			ValaDataType* _tmp1427_;
			ValaDataType* _tmp1428_;
			ValaDelegateType* _tmp1429_;
			ValaDelegateType* _tmp1430_;
			ValaDelegate* _tmp1431_;
			ValaDelegate* _tmp1432_;
			gboolean _tmp1433_;
			gboolean _tmp1434_;
			_tmp1426_ = deleg;
			_tmp1427_ = vala_callable_get_return_type ((ValaCallable*) _tmp1426_);
			_tmp1428_ = _tmp1427_;
			_tmp1429_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1428_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1429_;
			_tmp1430_ = deleg_type;
			_tmp1431_ = vala_delegate_type_get_delegate_symbol (_tmp1430_);
			_tmp1432_ = _tmp1431_;
			_tmp1433_ = vala_delegate_get_has_target (_tmp1432_);
			_tmp1434_ = _tmp1433_;
			if (_tmp1434_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1435_;
				ValaVoidType* _tmp1436_;
				ValaPointerType* _tmp1437_;
				ValaPointerType* _tmp1438_;
				ValaLocalVariable* _tmp1439_;
				ValaLocalVariable* _tmp1440_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1441_;
				const gchar* _tmp1442_;
				const gchar* _tmp1443_;
				ValaCCodeExpression* _tmp1444_;
				ValaLocalVariable* _tmp1445_;
				ValaHashMap* _tmp1446_;
				ValaDelegate* _tmp1447_;
				ValaCCodeExpression* _tmp1448_;
				ValaCCodeUnaryExpression* _tmp1449_;
				ValaCCodeUnaryExpression* _tmp1450_;
				ValaCCodeExpression* _tmp1451_;
				ValaDelegateType* _tmp1452_;
				_tmp1435_ = vala_void_type_new (NULL);
				_tmp1436_ = _tmp1435_;
				_tmp1437_ = vala_pointer_type_new ((ValaDataType*) _tmp1436_, NULL);
				_tmp1438_ = _tmp1437_;
				_tmp1439_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1438_, TRUE, NULL, FALSE);
				_tmp1440_ = _tmp1439_;
				_vala_code_node_unref0 (_tmp1438_);
				_vala_code_node_unref0 (_tmp1436_);
				temp_var = _tmp1440_;
				_tmp1441_ = temp_var;
				_tmp1442_ = vala_symbol_get_name ((ValaSymbol*) _tmp1441_);
				_tmp1443_ = _tmp1442_;
				_tmp1444_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1443_);
				temp_ref = _tmp1444_;
				_tmp1445_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1445_);
				_tmp1446_ = out_arg_map;
				_tmp1447_ = deleg;
				_tmp1448_ = temp_ref;
				_tmp1449_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1448_);
				_tmp1450_ = _tmp1449_;
				vala_map_set ((ValaMap*) _tmp1446_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1447_), FALSE)), (ValaCCodeExpression*) _tmp1450_);
				_vala_ccode_node_unref0 (_tmp1450_);
				_tmp1451_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1451_);
				_tmp1452_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1452_)) {
					ValaDataType* _tmp1453_;
					ValaLocalVariable* _tmp1454_;
					ValaLocalVariable* _tmp1455_;
					const gchar* _tmp1456_;
					const gchar* _tmp1457_;
					ValaCCodeExpression* _tmp1458_;
					ValaLocalVariable* _tmp1459_;
					ValaHashMap* _tmp1460_;
					ValaDelegate* _tmp1461_;
					ValaCCodeExpression* _tmp1462_;
					ValaCCodeUnaryExpression* _tmp1463_;
					ValaCCodeUnaryExpression* _tmp1464_;
					ValaCCodeExpression* _tmp1465_;
					_tmp1453_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1454_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1453_, TRUE, NULL, FALSE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1454_;
					_tmp1455_ = temp_var;
					_tmp1456_ = vala_symbol_get_name ((ValaSymbol*) _tmp1455_);
					_tmp1457_ = _tmp1456_;
					_tmp1458_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1457_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1458_;
					_tmp1459_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1459_);
					_tmp1460_ = out_arg_map;
					_tmp1461_ = deleg;
					_tmp1462_ = temp_ref;
					_tmp1463_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1462_);
					_tmp1464_ = _tmp1463_;
					vala_map_set ((ValaMap*) _tmp1460_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1461_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1464_);
					_vala_ccode_node_unref0 (_tmp1464_);
					_tmp1465_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1465_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1467_ = m;
	if (_tmp1467_ != NULL) {
		ValaMethod* _tmp1468_;
		gboolean _tmp1469_;
		gboolean _tmp1470_;
		_tmp1468_ = m;
		_tmp1469_ = vala_method_get_coroutine (_tmp1468_);
		_tmp1470_ = _tmp1469_;
		_tmp1466_ = _tmp1470_;
	} else {
		_tmp1466_ = FALSE;
	}
	if (_tmp1466_) {
		gboolean _tmp1471_;
		gboolean _tmp1472_;
		_tmp1471_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1472_ = _tmp1471_;
		if (_tmp1472_) {
			ValaHashMap* _tmp1473_;
			ValaMethod* _tmp1474_;
			ValaMethod* _tmp1475_;
			gchar* _tmp1476_;
			gchar* _tmp1477_;
			ValaCCodeIdentifier* _tmp1478_;
			ValaCCodeIdentifier* _tmp1479_;
			ValaHashMap* _tmp1480_;
			ValaCCodeIdentifier* _tmp1481_;
			ValaCCodeIdentifier* _tmp1482_;
			_tmp1473_ = in_arg_map;
			_tmp1474_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1475_ = _tmp1474_;
			_tmp1476_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1475_);
			_tmp1477_ = _tmp1476_;
			_tmp1478_ = vala_ccode_identifier_new (_tmp1477_);
			_tmp1479_ = _tmp1478_;
			vala_map_set ((ValaMap*) _tmp1473_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1479_);
			_vala_ccode_node_unref0 (_tmp1479_);
			_g_free0 (_tmp1477_);
			_tmp1480_ = in_arg_map;
			_tmp1481_ = vala_ccode_identifier_new ("_data_");
			_tmp1482_ = _tmp1481_;
			vala_map_set ((ValaMap*) _tmp1480_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1482_);
			_vala_ccode_node_unref0 (_tmp1482_);
		}
	}
	_tmp1483_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1484_ = _tmp1483_;
	if (_tmp1484_) {
		ValaHashMap* _tmp1485_;
		ValaCCodeExpression* _tmp1486_;
		ValaCCodeExpression* _tmp1487_;
		ValaCCodeUnaryExpression* _tmp1488_;
		ValaCCodeUnaryExpression* _tmp1489_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1485_ = out_arg_map;
		_tmp1486_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
		_tmp1487_ = _tmp1486_;
		_tmp1488_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1487_);
		_tmp1489_ = _tmp1488_;
		vala_map_set ((ValaMap*) _tmp1485_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1489_);
		_vala_ccode_node_unref0 (_tmp1489_);
		_vala_ccode_node_unref0 (_tmp1487_);
	} else {
		gboolean _tmp1490_ = FALSE;
		gboolean _tmp1491_ = FALSE;
		ValaMethod* _tmp1492_;
		_tmp1492_ = m;
		if (_tmp1492_ != NULL) {
			ValaMethod* _tmp1493_;
			_tmp1493_ = m;
			_tmp1491_ = vala_method_has_error_type_parameter (_tmp1493_);
		} else {
			_tmp1491_ = FALSE;
		}
		if (_tmp1491_) {
			ValaCCodeFunctionCall* _tmp1494_;
			ValaCCodeFunctionCall* _tmp1495_;
			_tmp1494_ = async_call;
			_tmp1495_ = ccall;
			_tmp1490_ = _tmp1494_ != _tmp1495_;
		} else {
			_tmp1490_ = FALSE;
		}
		if (_tmp1490_) {
			ValaHashMap* _tmp1496_;
			ValaCCodeConstant* _tmp1497_;
			ValaCCodeConstant* _tmp1498_;
			_tmp1496_ = out_arg_map;
			_tmp1497_ = vala_ccode_constant_new ("NULL");
			_tmp1498_ = _tmp1497_;
			vala_map_set ((ValaMap*) _tmp1496_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1498_);
			_vala_ccode_node_unref0 (_tmp1498_);
		}
	}
	_tmp1499_ = ellipsis;
	if (_tmp1499_) {
		ValaMethod* _tmp1500_;
		_tmp1500_ = m;
		if (_tmp1500_ == NULL) {
			ValaHashMap* _tmp1501_;
			ValaCCodeConstant* _tmp1502_;
			ValaCCodeConstant* _tmp1503_;
			_tmp1501_ = in_arg_map;
			_tmp1502_ = vala_ccode_constant_new ("NULL");
			_tmp1503_ = _tmp1502_;
			vala_map_set ((ValaMap*) _tmp1501_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1503_);
			_vala_ccode_node_unref0 (_tmp1503_);
		} else {
			gboolean _tmp1504_ = FALSE;
			gboolean _tmp1505_ = FALSE;
			gboolean _tmp1506_ = FALSE;
			ValaMethod* _tmp1507_;
			gboolean _tmp1508_;
			gboolean _tmp1509_;
			_tmp1507_ = m;
			_tmp1508_ = vala_method_get_printf_format (_tmp1507_);
			_tmp1509_ = _tmp1508_;
			if (!_tmp1509_) {
				ValaMethod* _tmp1510_;
				gboolean _tmp1511_;
				gboolean _tmp1512_;
				_tmp1510_ = m;
				_tmp1511_ = vala_method_get_scanf_format (_tmp1510_);
				_tmp1512_ = _tmp1511_;
				_tmp1506_ = !_tmp1512_;
			} else {
				_tmp1506_ = FALSE;
			}
			if (_tmp1506_) {
				ValaMethod* _tmp1513_;
				gchar* _tmp1514_;
				gchar* _tmp1515_;
				_tmp1513_ = m;
				_tmp1514_ = vala_get_ccode_sentinel (_tmp1513_);
				_tmp1515_ = _tmp1514_;
				_tmp1505_ = g_strcmp0 (_tmp1515_, "") != 0;
				_g_free0 (_tmp1515_);
			} else {
				_tmp1505_ = FALSE;
			}
			if (_tmp1505_) {
				gboolean _tmp1516_;
				gboolean _tmp1517_;
				_tmp1516_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1517_ = _tmp1516_;
				_tmp1504_ = !_tmp1517_;
			} else {
				_tmp1504_ = FALSE;
			}
			if (_tmp1504_) {
				ValaHashMap* _tmp1518_;
				ValaMethod* _tmp1519_;
				gchar* _tmp1520_;
				gchar* _tmp1521_;
				ValaCCodeConstant* _tmp1522_;
				ValaCCodeConstant* _tmp1523_;
				_tmp1518_ = in_arg_map;
				_tmp1519_ = m;
				_tmp1520_ = vala_get_ccode_sentinel (_tmp1519_);
				_tmp1521_ = _tmp1520_;
				_tmp1522_ = vala_ccode_constant_new (_tmp1521_);
				_tmp1523_ = _tmp1522_;
				vala_map_set ((ValaMap*) _tmp1518_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1523_);
				_vala_ccode_node_unref0 (_tmp1523_);
				_g_free0 (_tmp1521_);
			}
		}
	}
	_tmp1524_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1524_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1525_;
		ValaDelegateType* _tmp1526_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1527_;
		ValaDelegate* _tmp1528_;
		ValaDelegate* _tmp1529_;
		ValaDelegate* _tmp1530_;
		ValaDelegate* _tmp1531_;
		gboolean _tmp1532_;
		gboolean _tmp1533_;
		_tmp1525_ = itype;
		_tmp1526_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1525_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1526_;
		_tmp1527_ = deleg_type;
		_tmp1528_ = vala_delegate_type_get_delegate_symbol (_tmp1527_);
		_tmp1529_ = _tmp1528_;
		_tmp1530_ = _vala_code_node_ref0 (_tmp1529_);
		d = _tmp1530_;
		_tmp1531_ = d;
		_tmp1532_ = vala_delegate_get_has_target (_tmp1531_);
		_tmp1533_ = _tmp1532_;
		if (_tmp1533_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1534_;
			ValaDelegate* _tmp1535_;
			ValaExpression* _tmp1536_;
			ValaExpression* _tmp1537_;
			ValaCCodeExpression* _tmp1538_ = NULL;
			ValaCCodeExpression* _tmp1539_;
			ValaCCodeExpression* _tmp1540_;
			ValaHashMap* _tmp1541_;
			ValaDelegate* _tmp1542_;
			ValaExpression* _tmp1543_;
			ValaExpression* _tmp1544_;
			ValaCCodeExpression* _tmp1545_ = NULL;
			ValaCCodeExpression* _tmp1546_;
			ValaCCodeExpression* _tmp1547_;
			_tmp1534_ = in_arg_map;
			_tmp1535_ = d;
			_tmp1536_ = vala_method_call_get_call (expr);
			_tmp1537_ = _tmp1536_;
			_tmp1539_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1537_, &_tmp1538_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1538_;
			_tmp1540_ = _tmp1539_;
			vala_map_set ((ValaMap*) _tmp1534_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1535_), FALSE)), _tmp1540_);
			_vala_ccode_node_unref0 (_tmp1540_);
			_tmp1541_ = out_arg_map;
			_tmp1542_ = d;
			_tmp1543_ = vala_method_call_get_call (expr);
			_tmp1544_ = _tmp1543_;
			_tmp1546_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1544_, &_tmp1545_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1545_;
			_tmp1547_ = _tmp1546_;
			vala_map_set ((ValaMap*) _tmp1541_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1542_), FALSE)), _tmp1547_);
			_vala_ccode_node_unref0 (_tmp1547_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1548_ = itype;
	_tmp1549_ = vala_data_type_get_return_type (_tmp1548_);
	_tmp1550_ = _tmp1549_;
	_tmp1551_ = vala_data_type_is_real_non_null_struct_type (_tmp1550_);
	_vala_code_node_unref0 (_tmp1550_);
	return_result_via_out_param = _tmp1551_;
	_tmp1553_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1553_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1554_;
		ValaDataType* _tmp1555_;
		ValaDataType* _tmp1556_;
		_tmp1554_ = itype;
		_tmp1555_ = vala_data_type_get_return_type (_tmp1554_);
		_tmp1556_ = _tmp1555_;
		_tmp1552_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1556_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1556_);
	} else {
		_tmp1552_ = FALSE;
	}
	if (_tmp1552_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1557_;
		ValaSignal* _tmp1558_;
		ValaSignal* _tmp1559_;
		ValaSignal* _tmp1560_;
		gboolean _tmp1561_ = FALSE;
		gboolean _tmp1562_ = FALSE;
		ValaMemberAccess* _tmp1563_;
		_tmp1557_ = itype;
		_tmp1558_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1557_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1559_ = _tmp1558_;
		_tmp1560_ = _vala_code_node_ref0 (_tmp1559_);
		sig = _tmp1560_;
		_tmp1563_ = ma;
		if (_tmp1563_ != NULL) {
			ValaMemberAccess* _tmp1564_;
			ValaExpression* _tmp1565_;
			ValaExpression* _tmp1566_;
			_tmp1564_ = ma;
			_tmp1565_ = vala_member_access_get_inner (_tmp1564_);
			_tmp1566_ = _tmp1565_;
			_tmp1562_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1566_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1562_ = FALSE;
		}
		if (_tmp1562_) {
			ValaSignal* _tmp1567_;
			gboolean _tmp1568_;
			gboolean _tmp1569_;
			_tmp1567_ = sig;
			_tmp1568_ = vala_signal_get_is_virtual (_tmp1567_);
			_tmp1569_ = _tmp1568_;
			_tmp1561_ = _tmp1569_;
		} else {
			_tmp1561_ = FALSE;
		}
		if (_tmp1561_) {
		} else {
			gboolean _tmp1570_ = FALSE;
			ValaSignal* _tmp1571_;
			_tmp1571_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1571_)) {
				_tmp1570_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1572_;
				ValaSourceReference* _tmp1573_;
				ValaSourceReference* _tmp1574_;
				ValaSourceFile* _tmp1575_;
				ValaSourceFile* _tmp1576_;
				ValaSignal* _tmp1577_;
				ValaSourceReference* _tmp1578_;
				ValaSourceReference* _tmp1579_;
				ValaSourceFile* _tmp1580_;
				ValaSourceFile* _tmp1581_;
				_tmp1572_ = ma;
				_tmp1573_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1572_);
				_tmp1574_ = _tmp1573_;
				_tmp1575_ = vala_source_reference_get_file (_tmp1574_);
				_tmp1576_ = _tmp1575_;
				_tmp1577_ = sig;
				_tmp1578_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1577_);
				_tmp1579_ = _tmp1578_;
				_tmp1580_ = vala_source_reference_get_file (_tmp1579_);
				_tmp1581_ = _tmp1580_;
				_tmp1570_ = _tmp1576_ == _tmp1581_;
			}
			if (_tmp1570_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1582_ = async_call;
	_tmp1583_ = ccall;
	if (_tmp1582_ == _tmp1583_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	_tmp1584_ = return_result_via_out_param;
	if (_tmp1584_) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1585_;
		ValaDataType* _tmp1586_;
		ValaDataType* _tmp1587_;
		ValaLocalVariable* _tmp1588_;
		ValaLocalVariable* _tmp1589_;
		ValaLocalVariable* _tmp1590_;
		const gchar* _tmp1591_;
		const gchar* _tmp1592_;
		ValaCCodeExpression* _tmp1593_;
		ValaLocalVariable* _tmp1594_;
		ValaHashMap* _tmp1595_;
		ValaCCodeExpression* _tmp1596_;
		ValaCCodeUnaryExpression* _tmp1597_;
		ValaCCodeUnaryExpression* _tmp1598_;
		_tmp1585_ = itype;
		_tmp1586_ = vala_data_type_get_return_type (_tmp1585_);
		_tmp1587_ = _tmp1586_;
		_tmp1588_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1587_, TRUE, NULL, TRUE);
		_tmp1589_ = _tmp1588_;
		_vala_code_node_unref0 (_tmp1587_);
		out_param_var = _tmp1589_;
		_tmp1590_ = out_param_var;
		_tmp1591_ = vala_symbol_get_name ((ValaSymbol*) _tmp1590_);
		_tmp1592_ = _tmp1591_;
		_tmp1593_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1592_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1593_;
		_tmp1594_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1594_);
		_tmp1595_ = out_arg_map;
		_tmp1596_ = out_param_ref;
		_tmp1597_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1596_);
		_tmp1598_ = _tmp1597_;
		vala_map_set ((ValaMap*) _tmp1595_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1598_);
		_vala_ccode_node_unref0 (_tmp1598_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1599_ = async_call;
	_tmp1600_ = ccall;
	if (_tmp1599_ != _tmp1600_) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1617_;
			ValaCCodeFunctionCall* _tmp1618_;
			ValaHashMap* _tmp1619_;
			gint _tmp1620_;
			gpointer _tmp1621_;
			ValaCCodeExpression* _tmp1622_;
			gint _tmp1623_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1601_;
				ValaSet* _tmp1602_;
				ValaSet* _tmp1603_;
				ValaIterator* _tmp1604_;
				ValaIterator* _tmp1605_;
				_tmp1601_ = out_arg_map;
				_tmp1602_ = vala_map_get_keys ((ValaMap*) _tmp1601_);
				_tmp1603_ = _tmp1602_;
				_tmp1604_ = vala_iterable_iterator ((ValaIterable*) _tmp1603_);
				_tmp1605_ = _tmp1604_;
				_vala_iterable_unref0 (_tmp1603_);
				_pos_it = _tmp1605_;
				while (TRUE) {
					ValaIterator* _tmp1606_;
					gint pos = 0;
					ValaIterator* _tmp1607_;
					gpointer _tmp1608_;
					gboolean _tmp1609_ = FALSE;
					gint _tmp1610_;
					gint _tmp1611_;
					_tmp1606_ = _pos_it;
					if (!vala_iterator_next (_tmp1606_)) {
						break;
					}
					_tmp1607_ = _pos_it;
					_tmp1608_ = vala_iterator_get (_tmp1607_);
					pos = (gint) ((gintptr) _tmp1608_);
					_tmp1610_ = pos;
					_tmp1611_ = last_pos;
					if (_tmp1610_ > _tmp1611_) {
						gboolean _tmp1612_ = FALSE;
						gint _tmp1613_;
						_tmp1613_ = min_pos;
						if (_tmp1613_ == -1) {
							_tmp1612_ = TRUE;
						} else {
							gint _tmp1614_;
							gint _tmp1615_;
							_tmp1614_ = pos;
							_tmp1615_ = min_pos;
							_tmp1612_ = _tmp1614_ < _tmp1615_;
						}
						_tmp1609_ = _tmp1612_;
					} else {
						_tmp1609_ = FALSE;
					}
					if (_tmp1609_) {
						gint _tmp1616_;
						_tmp1616_ = pos;
						min_pos = _tmp1616_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1617_ = min_pos;
			if (_tmp1617_ == -1) {
				break;
			}
			_tmp1618_ = ccall;
			_tmp1619_ = out_arg_map;
			_tmp1620_ = min_pos;
			_tmp1621_ = vala_map_get ((ValaMap*) _tmp1619_, (gpointer) ((gintptr) _tmp1620_));
			_tmp1622_ = (ValaCCodeExpression*) _tmp1621_;
			vala_ccode_function_call_add_argument (_tmp1618_, _tmp1622_);
			_vala_ccode_node_unref0 (_tmp1622_);
			_tmp1623_ = min_pos;
			last_pos = _tmp1623_;
		}
	}
	_tmp1624_ = async_call;
	if (_tmp1624_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1641_;
			ValaCCodeFunctionCall* _tmp1642_;
			ValaHashMap* _tmp1643_;
			gint _tmp1644_;
			gpointer _tmp1645_;
			ValaCCodeExpression* _tmp1646_;
			gint _tmp1647_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1625_;
				ValaSet* _tmp1626_;
				ValaSet* _tmp1627_;
				ValaIterator* _tmp1628_;
				ValaIterator* _tmp1629_;
				_tmp1625_ = in_arg_map;
				_tmp1626_ = vala_map_get_keys ((ValaMap*) _tmp1625_);
				_tmp1627_ = _tmp1626_;
				_tmp1628_ = vala_iterable_iterator ((ValaIterable*) _tmp1627_);
				_tmp1629_ = _tmp1628_;
				_vala_iterable_unref0 (_tmp1627_);
				_pos_it = _tmp1629_;
				while (TRUE) {
					ValaIterator* _tmp1630_;
					gint pos = 0;
					ValaIterator* _tmp1631_;
					gpointer _tmp1632_;
					gboolean _tmp1633_ = FALSE;
					gint _tmp1634_;
					gint _tmp1635_;
					_tmp1630_ = _pos_it;
					if (!vala_iterator_next (_tmp1630_)) {
						break;
					}
					_tmp1631_ = _pos_it;
					_tmp1632_ = vala_iterator_get (_tmp1631_);
					pos = (gint) ((gintptr) _tmp1632_);
					_tmp1634_ = pos;
					_tmp1635_ = last_pos;
					if (_tmp1634_ > _tmp1635_) {
						gboolean _tmp1636_ = FALSE;
						gint _tmp1637_;
						_tmp1637_ = min_pos;
						if (_tmp1637_ == -1) {
							_tmp1636_ = TRUE;
						} else {
							gint _tmp1638_;
							gint _tmp1639_;
							_tmp1638_ = pos;
							_tmp1639_ = min_pos;
							_tmp1636_ = _tmp1638_ < _tmp1639_;
						}
						_tmp1633_ = _tmp1636_;
					} else {
						_tmp1633_ = FALSE;
					}
					if (_tmp1633_) {
						gint _tmp1640_;
						_tmp1640_ = pos;
						min_pos = _tmp1640_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1641_ = min_pos;
			if (_tmp1641_ == -1) {
				break;
			}
			_tmp1642_ = async_call;
			_tmp1643_ = in_arg_map;
			_tmp1644_ = min_pos;
			_tmp1645_ = vala_map_get ((ValaMap*) _tmp1643_, (gpointer) ((gintptr) _tmp1644_));
			_tmp1646_ = (ValaCCodeExpression*) _tmp1645_;
			vala_ccode_function_call_add_argument (_tmp1642_, _tmp1646_);
			_vala_ccode_node_unref0 (_tmp1646_);
			_tmp1647_ = min_pos;
			last_pos = _tmp1647_;
		}
	}
	_tmp1648_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1649_ = _tmp1648_;
	if (_tmp1649_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1650_;
		gint _tmp1651_;
		ValaCCodeFunction* _tmp1652_;
		ValaCCodeFunction* _tmp1653_;
		ValaCCodeIdentifier* _tmp1654_;
		ValaCCodeIdentifier* _tmp1655_;
		ValaCCodeMemberAccess* _tmp1656_;
		ValaCCodeMemberAccess* _tmp1657_;
		gint _tmp1658_;
		gchar* _tmp1659_;
		gchar* _tmp1660_;
		ValaCCodeConstant* _tmp1661_;
		ValaCCodeConstant* _tmp1662_;
		ValaCCodeFunction* _tmp1663_;
		ValaCCodeFunction* _tmp1664_;
		ValaCCodeFunctionCall* _tmp1665_;
		ValaCCodeFunction* _tmp1666_;
		ValaCCodeFunction* _tmp1667_;
		ValaCCodeConstant* _tmp1668_;
		ValaCCodeConstant* _tmp1669_;
		ValaCCodeFunction* _tmp1670_;
		ValaCCodeFunction* _tmp1671_;
		gint _tmp1672_;
		gchar* _tmp1673_;
		gchar* _tmp1674_;
		_tmp1650_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1651_ = _tmp1650_->next_coroutine_state;
		_tmp1650_->next_coroutine_state = _tmp1651_ + 1;
		state = _tmp1651_;
		_tmp1652_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1653_ = _tmp1652_;
		_tmp1654_ = vala_ccode_identifier_new ("_data_");
		_tmp1655_ = _tmp1654_;
		_tmp1656_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1655_, "_state_");
		_tmp1657_ = _tmp1656_;
		_tmp1658_ = state;
		_tmp1659_ = g_strdup_printf ("%i", _tmp1658_);
		_tmp1660_ = _tmp1659_;
		_tmp1661_ = vala_ccode_constant_new (_tmp1660_);
		_tmp1662_ = _tmp1661_;
		vala_ccode_function_add_assignment (_tmp1653_, (ValaCCodeExpression*) _tmp1657_, (ValaCCodeExpression*) _tmp1662_);
		_vala_ccode_node_unref0 (_tmp1662_);
		_g_free0 (_tmp1660_);
		_vala_ccode_node_unref0 (_tmp1657_);
		_vala_ccode_node_unref0 (_tmp1655_);
		_tmp1663_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1664_ = _tmp1663_;
		_tmp1665_ = async_call;
		vala_ccode_function_add_expression (_tmp1664_, (ValaCCodeExpression*) _tmp1665_);
		_tmp1666_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1667_ = _tmp1666_;
		_tmp1668_ = vala_ccode_constant_new ("FALSE");
		_tmp1669_ = _tmp1668_;
		vala_ccode_function_add_return (_tmp1667_, (ValaCCodeExpression*) _tmp1669_);
		_vala_ccode_node_unref0 (_tmp1669_);
		_tmp1670_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1671_ = _tmp1670_;
		_tmp1672_ = state;
		_tmp1673_ = g_strdup_printf ("_state_%d", _tmp1672_);
		_tmp1674_ = _tmp1673_;
		vala_ccode_function_add_label (_tmp1671_, _tmp1674_);
		_g_free0 (_tmp1674_);
	}
	_tmp1675_ = vala_method_call_get_is_assert (expr);
	_tmp1676_ = _tmp1675_;
	if (_tmp1676_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1677_;
		ValaSourceReference* _tmp1678_;
		ValaSourceLocation _tmp1679_ = {0};
		ValaSourceLocation _tmp1680_;
		gchar* _tmp1681_;
		ValaSourceReference* _tmp1682_;
		ValaSourceReference* _tmp1683_;
		ValaSourceLocation _tmp1684_ = {0};
		ValaSourceLocation _tmp1685_;
		gchar* _tmp1686_;
		ValaSourceReference* _tmp1687_;
		ValaSourceReference* _tmp1688_;
		ValaSourceLocation _tmp1689_ = {0};
		ValaSourceLocation _tmp1690_;
		gchar* _tmp1691_;
		gchar* _tmp1692_;
		ValaCCodeFunctionCall* _tmp1693_;
		ValaCCodeIdentifier* _tmp1694_;
		ValaCCodeIdentifier* _tmp1695_;
		ValaCCodeFunctionCall* _tmp1696_;
		const gchar* _tmp1697_;
		gchar* _tmp1698_;
		gchar* _tmp1699_;
		gchar* _tmp1700_;
		gchar* _tmp1701_;
		gchar* _tmp1702_;
		gchar* _tmp1703_;
		ValaCCodeConstant* _tmp1704_;
		ValaCCodeConstant* _tmp1705_;
		_tmp1677_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1678_ = _tmp1677_;
		vala_source_reference_get_begin (_tmp1678_, &_tmp1679_);
		_tmp1680_ = _tmp1679_;
		_tmp1681_ = _tmp1680_.pos;
		_tmp1682_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1683_ = _tmp1682_;
		vala_source_reference_get_end (_tmp1683_, &_tmp1684_);
		_tmp1685_ = _tmp1684_;
		_tmp1686_ = _tmp1685_.pos;
		_tmp1687_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1688_ = _tmp1687_;
		vala_source_reference_get_begin (_tmp1688_, &_tmp1689_);
		_tmp1690_ = _tmp1689_;
		_tmp1691_ = _tmp1690_.pos;
		_tmp1692_ = string_substring ((const gchar*) _tmp1681_, (glong) 0, (glong) ((gint) (_tmp1686_ - _tmp1691_)));
		message = _tmp1692_;
		_tmp1693_ = ccall;
		_tmp1694_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1695_ = _tmp1694_;
		vala_ccode_function_call_set_call (_tmp1693_, (ValaCCodeExpression*) _tmp1695_);
		_vala_ccode_node_unref0 (_tmp1695_);
		_tmp1696_ = ccall;
		_tmp1697_ = message;
		_tmp1698_ = string_replace (_tmp1697_, "\n", " ");
		_tmp1699_ = _tmp1698_;
		_tmp1700_ = g_strescape (_tmp1699_, "");
		_tmp1701_ = _tmp1700_;
		_tmp1702_ = g_strdup_printf ("\"%s\"", _tmp1701_);
		_tmp1703_ = _tmp1702_;
		_tmp1704_ = vala_ccode_constant_new (_tmp1703_);
		_tmp1705_ = _tmp1704_;
		vala_ccode_function_call_add_argument (_tmp1696_, (ValaCCodeExpression*) _tmp1705_);
		_vala_ccode_node_unref0 (_tmp1705_);
		_g_free0 (_tmp1703_);
		_g_free0 (_tmp1701_);
		_g_free0 (_tmp1699_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	_tmp1706_ = return_result_via_out_param;
	if (_tmp1706_) {
		ValaCCodeFunction* _tmp1707_;
		ValaCCodeFunction* _tmp1708_;
		ValaCCodeExpression* _tmp1709_;
		ValaCCodeExpression* _tmp1710_;
		ValaCCodeExpression* _tmp1711_;
		_tmp1707_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1708_ = _tmp1707_;
		_tmp1709_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1708_, _tmp1709_);
		_tmp1710_ = out_param_ref;
		_tmp1711_ = _vala_ccode_node_ref0 (_tmp1710_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1711_;
	}
	_tmp1714_ = m;
	if (_tmp1714_ != NULL) {
		ValaMethod* _tmp1715_;
		ValaMemberBinding _tmp1716_;
		ValaMemberBinding _tmp1717_;
		_tmp1715_ = m;
		_tmp1716_ = vala_method_get_binding (_tmp1715_);
		_tmp1717_ = _tmp1716_;
		_tmp1713_ = _tmp1717_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1713_ = FALSE;
	}
	if (_tmp1713_) {
		ValaMethod* _tmp1718_;
		gboolean _tmp1719_;
		gboolean _tmp1720_;
		_tmp1718_ = m;
		_tmp1719_ = vala_method_get_returns_modified_pointer (_tmp1718_);
		_tmp1720_ = _tmp1719_;
		_tmp1712_ = _tmp1720_;
	} else {
		_tmp1712_ = FALSE;
	}
	if (_tmp1712_) {
		gboolean _tmp1721_ = FALSE;
		gboolean _tmp1722_ = FALSE;
		ValaMemberAccess* _tmp1723_;
		_tmp1723_ = ma;
		if (_tmp1723_ != NULL) {
			ValaMemberAccess* _tmp1724_;
			ValaExpression* _tmp1725_;
			ValaExpression* _tmp1726_;
			ValaSymbol* _tmp1727_;
			ValaSymbol* _tmp1728_;
			_tmp1724_ = ma;
			_tmp1725_ = vala_member_access_get_inner (_tmp1724_);
			_tmp1726_ = _tmp1725_;
			_tmp1727_ = vala_expression_get_symbol_reference (_tmp1726_);
			_tmp1728_ = _tmp1727_;
			_tmp1722_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1728_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1722_ = FALSE;
		}
		if (_tmp1722_) {
			ValaMemberAccess* _tmp1729_;
			ValaExpression* _tmp1730_;
			ValaExpression* _tmp1731_;
			_tmp1729_ = ma;
			_tmp1730_ = vala_member_access_get_inner (_tmp1729_);
			_tmp1731_ = _tmp1730_;
			_tmp1721_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1731_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1721_ = FALSE;
		}
		if (_tmp1721_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1732_;
			ValaExpression* _tmp1733_;
			ValaExpression* _tmp1734_;
			ValaSymbol* _tmp1735_;
			ValaSymbol* _tmp1736_;
			ValaProperty* _tmp1737_;
			ValaProperty* _tmp1738_;
			ValaMemberAccess* _tmp1739_;
			ValaExpression* _tmp1740_;
			ValaExpression* _tmp1741_;
			ValaExpression* _tmp1742_;
			ValaExpression* _tmp1743_;
			ValaDataType* _tmp1744_;
			ValaDataType* _tmp1745_;
			ValaCCodeExpression* _tmp1746_;
			ValaGLibValue* _tmp1747_;
			ValaGLibValue* _tmp1748_;
			_tmp1732_ = ma;
			_tmp1733_ = vala_member_access_get_inner (_tmp1732_);
			_tmp1734_ = _tmp1733_;
			_tmp1735_ = vala_expression_get_symbol_reference (_tmp1734_);
			_tmp1736_ = _tmp1735_;
			_tmp1737_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1736_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1737_;
			_tmp1738_ = prop;
			_tmp1739_ = ma;
			_tmp1740_ = vala_member_access_get_inner (_tmp1739_);
			_tmp1741_ = _tmp1740_;
			_tmp1742_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1741_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1743_ = _tmp1742_;
			_tmp1744_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1745_ = _tmp1744_;
			_tmp1746_ = ccall_expr;
			_tmp1747_ = vala_glib_value_new (_tmp1745_, _tmp1746_, FALSE);
			_tmp1748_ = _tmp1747_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1738_, _tmp1743_, (ValaTargetValue*) _tmp1748_);
			_vala_target_value_unref0 (_tmp1748_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1749_;
			ValaCCodeExpression* _tmp1750_;
			ValaCCodeAssignment* _tmp1751_;
			_tmp1749_ = instance;
			_tmp1750_ = ccall_expr;
			_tmp1751_ = vala_ccode_assignment_new (_tmp1749_, _tmp1750_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1751_;
		}
	}
	_tmp1754_ = m;
	if (_tmp1754_ != NULL) {
		ValaMethod* _tmp1755_;
		gchar* _tmp1756_;
		gchar* _tmp1757_;
		_tmp1755_ = m;
		_tmp1756_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1755_);
		_tmp1757_ = _tmp1756_;
		_tmp1753_ = _tmp1757_ != NULL;
		_g_free0 (_tmp1757_);
	} else {
		_tmp1753_ = FALSE;
	}
	if (_tmp1753_) {
		ValaMethod* _tmp1758_;
		gchar* _tmp1759_;
		gchar* _tmp1760_;
		ValaMethod* _tmp1761_;
		ValaDataType* _tmp1762_;
		ValaDataType* _tmp1763_;
		gchar* _tmp1764_;
		gchar* _tmp1765_;
		_tmp1758_ = m;
		_tmp1759_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1758_);
		_tmp1760_ = _tmp1759_;
		_tmp1761_ = m;
		_tmp1762_ = vala_callable_get_return_type ((ValaCallable*) _tmp1761_);
		_tmp1763_ = _tmp1762_;
		_tmp1764_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1763_);
		_tmp1765_ = _tmp1764_;
		_tmp1752_ = g_strcmp0 (_tmp1760_, _tmp1765_) != 0;
		_g_free0 (_tmp1765_);
		_g_free0 (_tmp1760_);
	} else {
		_tmp1752_ = FALSE;
	}
	if (_tmp1752_) {
		ValaCCodeExpression* _tmp1766_;
		ValaMethod* _tmp1767_;
		ValaDataType* _tmp1768_;
		ValaDataType* _tmp1769_;
		gchar* _tmp1770_;
		gchar* _tmp1771_;
		ValaCCodeCastExpression* _tmp1772_;
		_tmp1766_ = ccall_expr;
		_tmp1767_ = m;
		_tmp1768_ = vala_callable_get_return_type ((ValaCallable*) _tmp1767_);
		_tmp1769_ = _tmp1768_;
		_tmp1770_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1769_);
		_tmp1771_ = _tmp1770_;
		_tmp1772_ = vala_ccode_cast_expression_new (_tmp1766_, _tmp1771_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1772_;
		_g_free0 (_tmp1771_);
	}
	_tmp1773_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1773_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1774_;
		ValaList* _tmp1775_;
		ValaIterator* _tmp1776_;
		ValaIterator* _tmp1777_;
		ValaIterator* _tmp1778_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1779_;
		gpointer _tmp1780_;
		ValaExpression* _tmp1781_;
		ValaCCodeExpression* _tmp1782_;
		ValaCCodeExpression* _tmp1783_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1784_;
		ValaLocalVariable* _tmp1785_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1786_;
		const gchar* _tmp1787_;
		const gchar* _tmp1788_;
		ValaCCodeExpression* _tmp1789_;
		ValaLocalVariable* _tmp1790_;
		ValaCCodeFile* _tmp1791_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1792_;
		ValaExpression* _tmp1793_;
		ValaExpression* _tmp1794_;
		ValaCCodeExpression* _tmp1795_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1796_;
		ValaExpression* _tmp1797_;
		ValaExpression* _tmp1798_;
		ValaCCodeExpression* _tmp1799_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1800_;
		ValaExpression* _tmp1801_;
		ValaExpression* _tmp1802_;
		ValaDataType* _tmp1803_;
		ValaDataType* _tmp1804_;
		ValaArrayType* _tmp1805_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1806_;
		ValaDataType* _tmp1807_;
		ValaDataType* _tmp1808_;
		gchar* _tmp1809_;
		gchar* _tmp1810_;
		gchar* _tmp1811_;
		gchar* _tmp1812_;
		ValaCCodeIdentifier* _tmp1813_;
		ValaCCodeIdentifier* _tmp1814_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1815_;
		ValaCCodeExpression* _tmp1816_;
		ValaCCodeBinaryExpression* _tmp1817_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1818_;
		ValaCCodeExpression* _tmp1819_;
		ValaCCodeBinaryExpression* _tmp1820_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1821_;
		ValaCCodeIdentifier* _tmp1822_;
		ValaCCodeFunctionCall* _tmp1823_;
		ValaCCodeFunctionCall* _tmp1824_;
		ValaCCodeFunctionCall* _tmp1825_;
		ValaCCodeExpression* _tmp1826_;
		ValaCCodeExpression* _tmp1827_;
		ValaCCodeBinaryExpression* _tmp1828_;
		ValaCCodeBinaryExpression* _tmp1829_;
		ValaCCodeFunctionCall* _tmp1830_;
		ValaCCodeConstant* _tmp1831_;
		ValaCCodeConstant* _tmp1832_;
		ValaCCodeFunctionCall* _tmp1833_;
		ValaCCodeIdentifier* _tmp1834_;
		ValaCCodeBinaryExpression* _tmp1835_;
		ValaCCodeBinaryExpression* _tmp1836_;
		ValaCCodeBinaryExpression* _tmp1837_;
		ValaCCodeFunction* _tmp1838_;
		ValaCCodeFunction* _tmp1839_;
		ValaCCodeExpression* _tmp1840_;
		ValaCCodeExpression* _tmp1841_;
		ValaCCodeFunction* _tmp1842_;
		ValaCCodeFunction* _tmp1843_;
		ValaCCodeExpression* _tmp1844_;
		ValaCCodeFunction* _tmp1845_;
		ValaCCodeFunction* _tmp1846_;
		ValaCCodeBinaryExpression* _tmp1847_;
		ValaCCodeFunctionCall* _tmp1848_;
		ValaCCodeConstant* _tmp1849_;
		ValaCCodeConstant* _tmp1850_;
		ValaCCodeConditionalExpression* _tmp1851_;
		ValaCCodeConditionalExpression* _tmp1852_;
		ValaCCodeFunction* _tmp1853_;
		ValaCCodeFunction* _tmp1854_;
		ValaMemberAccess* _tmp1855_;
		ValaExpression* _tmp1856_;
		ValaExpression* _tmp1857_;
		ValaCCodeExpression* _tmp1858_;
		ValaCCodeExpression* _tmp1859_;
		ValaCCodeExpression* _tmp1860_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1861_;
		ValaExpression* _tmp1862_;
		ValaExpression* _tmp1863_;
		ValaSymbol* _tmp1864_;
		ValaSymbol* _tmp1865_;
		ValaSymbol* _tmp1866_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1867_;
		ValaLocalVariable* _tmp1868_;
		gboolean _tmp1869_ = FALSE;
		gboolean _tmp1870_ = FALSE;
		ValaSymbol* _tmp1871_;
		_tmp1774_ = vala_method_call_get_argument_list (expr);
		_tmp1775_ = _tmp1774_;
		_tmp1776_ = vala_iterable_iterator ((ValaIterable*) _tmp1775_);
		_tmp1777_ = _tmp1776_;
		_vala_iterable_unref0 (_tmp1775_);
		arg_it = _tmp1777_;
		_tmp1778_ = arg_it;
		vala_iterator_next (_tmp1778_);
		_tmp1779_ = arg_it;
		_tmp1780_ = vala_iterator_get (_tmp1779_);
		_tmp1781_ = (ValaExpression*) _tmp1780_;
		_tmp1782_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1781_);
		_tmp1783_ = _tmp1782_;
		_vala_code_node_unref0 (_tmp1781_);
		new_size = _tmp1783_;
		_tmp1784_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1785_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1784_, TRUE, NULL, FALSE);
		temp_decl = _tmp1785_;
		_tmp1786_ = temp_decl;
		_tmp1787_ = vala_symbol_get_name ((ValaSymbol*) _tmp1786_);
		_tmp1788_ = _tmp1787_;
		_tmp1789_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1788_);
		temp_ref = _tmp1789_;
		_tmp1790_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1790_);
		_tmp1791_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1791_, "string.h", FALSE);
		_tmp1792_ = ma;
		_tmp1793_ = vala_member_access_get_inner (_tmp1792_);
		_tmp1794_ = _tmp1793_;
		_tmp1795_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1794_, 1);
		clen = _tmp1795_;
		_tmp1796_ = ma;
		_tmp1797_ = vala_member_access_get_inner (_tmp1796_);
		_tmp1798_ = _tmp1797_;
		_tmp1799_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1798_);
		celems = _tmp1799_;
		_tmp1800_ = ma;
		_tmp1801_ = vala_member_access_get_inner (_tmp1800_);
		_tmp1802_ = _tmp1801_;
		_tmp1803_ = vala_expression_get_value_type (_tmp1802_);
		_tmp1804_ = _tmp1803_;
		_tmp1805_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1804_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1805_;
		_tmp1806_ = array_type;
		_tmp1807_ = vala_array_type_get_element_type (_tmp1806_);
		_tmp1808_ = _tmp1807_;
		_tmp1809_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1808_);
		_tmp1810_ = _tmp1809_;
		_tmp1811_ = g_strdup_printf ("sizeof (%s)", _tmp1810_);
		_tmp1812_ = _tmp1811_;
		_tmp1813_ = vala_ccode_identifier_new (_tmp1812_);
		_tmp1814_ = _tmp1813_;
		_g_free0 (_tmp1812_);
		_g_free0 (_tmp1810_);
		csizeof = _tmp1814_;
		_tmp1815_ = temp_ref;
		_tmp1816_ = clen;
		_tmp1817_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1815_, _tmp1816_);
		cdelta = _tmp1817_;
		_tmp1818_ = temp_ref;
		_tmp1819_ = clen;
		_tmp1820_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1818_, _tmp1819_);
		ccheck = _tmp1820_;
		_tmp1821_ = vala_ccode_identifier_new ("memset");
		_tmp1822_ = _tmp1821_;
		_tmp1823_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1822_);
		_tmp1824_ = _tmp1823_;
		_vala_ccode_node_unref0 (_tmp1822_);
		czero = _tmp1824_;
		_tmp1825_ = czero;
		_tmp1826_ = celems;
		_tmp1827_ = clen;
		_tmp1828_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1826_, _tmp1827_);
		_tmp1829_ = _tmp1828_;
		vala_ccode_function_call_add_argument (_tmp1825_, (ValaCCodeExpression*) _tmp1829_);
		_vala_ccode_node_unref0 (_tmp1829_);
		_tmp1830_ = czero;
		_tmp1831_ = vala_ccode_constant_new ("0");
		_tmp1832_ = _tmp1831_;
		vala_ccode_function_call_add_argument (_tmp1830_, (ValaCCodeExpression*) _tmp1832_);
		_vala_ccode_node_unref0 (_tmp1832_);
		_tmp1833_ = czero;
		_tmp1834_ = csizeof;
		_tmp1835_ = cdelta;
		_tmp1836_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1834_, (ValaCCodeExpression*) _tmp1835_);
		_tmp1837_ = _tmp1836_;
		vala_ccode_function_call_add_argument (_tmp1833_, (ValaCCodeExpression*) _tmp1837_);
		_vala_ccode_node_unref0 (_tmp1837_);
		_tmp1838_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1839_ = _tmp1838_;
		_tmp1840_ = temp_ref;
		_tmp1841_ = new_size;
		vala_ccode_function_add_assignment (_tmp1839_, _tmp1840_, _tmp1841_);
		_tmp1842_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1843_ = _tmp1842_;
		_tmp1844_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1843_, _tmp1844_);
		_tmp1845_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1846_ = _tmp1845_;
		_tmp1847_ = ccheck;
		_tmp1848_ = czero;
		_tmp1849_ = vala_ccode_constant_new ("NULL");
		_tmp1850_ = _tmp1849_;
		_tmp1851_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1847_, (ValaCCodeExpression*) _tmp1848_, (ValaCCodeExpression*) _tmp1850_);
		_tmp1852_ = _tmp1851_;
		vala_ccode_function_add_expression (_tmp1846_, (ValaCCodeExpression*) _tmp1852_);
		_vala_ccode_node_unref0 (_tmp1852_);
		_vala_ccode_node_unref0 (_tmp1850_);
		_tmp1853_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1854_ = _tmp1853_;
		_tmp1855_ = ma;
		_tmp1856_ = vala_member_access_get_inner (_tmp1855_);
		_tmp1857_ = _tmp1856_;
		_tmp1858_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1857_, 1);
		_tmp1859_ = _tmp1858_;
		_tmp1860_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1854_, _tmp1859_, _tmp1860_);
		_vala_ccode_node_unref0 (_tmp1859_);
		_tmp1861_ = ma;
		_tmp1862_ = vala_member_access_get_inner (_tmp1861_);
		_tmp1863_ = _tmp1862_;
		_tmp1864_ = vala_expression_get_symbol_reference (_tmp1863_);
		_tmp1865_ = _tmp1864_;
		_tmp1866_ = _vala_code_node_ref0 (_tmp1865_);
		array_var = _tmp1866_;
		_tmp1867_ = array_var;
		_tmp1868_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1867_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1867_) : NULL);
		array_local = _tmp1868_;
		_tmp1871_ = array_var;
		if (_tmp1871_ != NULL) {
			ValaSymbol* _tmp1872_;
			_tmp1872_ = array_var;
			_tmp1870_ = vala_symbol_is_internal_symbol (_tmp1872_);
		} else {
			_tmp1870_ = FALSE;
		}
		if (_tmp1870_) {
			gboolean _tmp1873_ = FALSE;
			gboolean _tmp1874_ = FALSE;
			ValaSymbol* _tmp1875_;
			_tmp1875_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1875_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1876_;
				gboolean _tmp1877_;
				gboolean _tmp1878_;
				_tmp1876_ = array_local;
				_tmp1877_ = vala_local_variable_get_captured (_tmp1876_);
				_tmp1878_ = _tmp1877_;
				_tmp1874_ = !_tmp1878_;
			} else {
				_tmp1874_ = FALSE;
			}
			if (_tmp1874_) {
				_tmp1873_ = TRUE;
			} else {
				ValaSymbol* _tmp1879_;
				_tmp1879_ = array_var;
				_tmp1873_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1879_, VALA_TYPE_FIELD);
			}
			_tmp1869_ = _tmp1873_;
		} else {
			_tmp1869_ = FALSE;
		}
		if (_tmp1869_) {
			ValaCCodeFunction* _tmp1880_;
			ValaCCodeFunction* _tmp1881_;
			ValaMemberAccess* _tmp1882_;
			ValaExpression* _tmp1883_;
			ValaExpression* _tmp1884_;
			ValaTargetValue* _tmp1885_;
			ValaTargetValue* _tmp1886_;
			ValaCCodeExpression* _tmp1887_;
			ValaCCodeExpression* _tmp1888_;
			ValaCCodeExpression* _tmp1889_;
			_tmp1880_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1881_ = _tmp1880_;
			_tmp1882_ = ma;
			_tmp1883_ = vala_member_access_get_inner (_tmp1882_);
			_tmp1884_ = _tmp1883_;
			_tmp1885_ = vala_expression_get_target_value (_tmp1884_);
			_tmp1886_ = _tmp1885_;
			_tmp1887_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1886_);
			_tmp1888_ = _tmp1887_;
			_tmp1889_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1881_, _tmp1888_, _tmp1889_);
			_vala_ccode_node_unref0 (_tmp1888_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1891_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1892_ = _tmp1891_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1892_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1893_;
		ValaDataType* _tmp1894_;
		_tmp1893_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1894_ = _tmp1893_;
		_tmp1890_ = !vala_data_type_is_disposable (_tmp1894_);
	} else {
		_tmp1890_ = FALSE;
	}
	if (_tmp1890_) {
		gboolean _tmp1895_ = FALSE;
		ValaCCodeExpression* _tmp1896_;
		_tmp1896_ = ccall_expr;
		if (_tmp1896_ != NULL) {
			gboolean _tmp1897_;
			_tmp1897_ = return_result_via_out_param;
			_tmp1895_ = !_tmp1897_;
		} else {
			_tmp1895_ = FALSE;
		}
		if (_tmp1895_) {
			ValaCCodeFunction* _tmp1898_;
			ValaCCodeFunction* _tmp1899_;
			ValaCCodeExpression* _tmp1900_;
			_tmp1898_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1899_ = _tmp1898_;
			_tmp1900_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1899_, _tmp1900_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1901_;
		ValaDataType* _tmp1902_;
		gboolean _tmp1903_ = FALSE;
		ValaDataType* _tmp1904_;
		ValaDataType* _tmp1905_;
		gboolean _tmp1932_ = FALSE;
		ValaMethod* _tmp1933_;
		_tmp1901_ = itype;
		_tmp1902_ = vala_data_type_get_return_type (_tmp1901_);
		result_type = _tmp1902_;
		_tmp1904_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1905_ = _tmp1904_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1905_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1906_;
			ValaDataType* _tmp1907_;
			_tmp1906_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1907_ = _tmp1906_;
			_tmp1903_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1907_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1903_ = FALSE;
		}
		if (_tmp1903_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1908_;
			ValaDataType* _tmp1909_;
			ValaTypeParameter* _tmp1910_;
			ValaTypeParameter* _tmp1911_;
			ValaTypeParameter* _tmp1912_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1913_;
			ValaSymbol* _tmp1914_;
			ValaSymbol* _tmp1915_;
			ValaSymbol* _tmp1916_;
			ValaSymbol* _tmp1917_;
			ValaStruct* _tmp1918_;
			gboolean _tmp1919_ = FALSE;
			ValaTypeParameter* _tmp1920_;
			ValaSymbol* _tmp1921_;
			ValaSymbol* _tmp1922_;
			ValaTypeSymbol* _tmp1923_;
			_tmp1908_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1909_ = _tmp1908_;
			_tmp1910_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1909_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1911_ = _tmp1910_;
			_tmp1912_ = _vala_code_node_ref0 (_tmp1911_);
			type_parameter = _tmp1912_;
			_tmp1913_ = type_parameter;
			_tmp1914_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1913_);
			_tmp1915_ = _tmp1914_;
			_tmp1916_ = vala_symbol_get_parent_symbol (_tmp1915_);
			_tmp1917_ = _tmp1916_;
			_tmp1918_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1917_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1917_) : NULL);
			st = _tmp1918_;
			_tmp1920_ = type_parameter;
			_tmp1921_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1920_);
			_tmp1922_ = _tmp1921_;
			_tmp1923_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1922_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1923_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1919_ = TRUE;
			} else {
				gboolean _tmp1924_ = FALSE;
				ValaStruct* _tmp1925_;
				_tmp1925_ = st;
				if (_tmp1925_ != NULL) {
					ValaStruct* _tmp1926_;
					gchar* _tmp1927_;
					gchar* _tmp1928_;
					_tmp1926_ = st;
					_tmp1927_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1926_);
					_tmp1928_ = _tmp1927_;
					_tmp1924_ = g_strcmp0 (_tmp1928_, "va_list") == 0;
					_g_free0 (_tmp1928_);
				} else {
					_tmp1924_ = FALSE;
				}
				_tmp1919_ = _tmp1924_;
			}
			if (_tmp1919_) {
				ValaDataType* _tmp1929_;
				ValaDataType* _tmp1930_;
				ValaDataType* _tmp1931_;
				_tmp1929_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1930_ = _tmp1929_;
				_tmp1931_ = _vala_code_node_ref0 (_tmp1930_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1931_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1933_ = m;
		if (_tmp1933_ != NULL) {
			ValaMethod* _tmp1934_;
			_tmp1934_ = m;
			_tmp1932_ = vala_method_get_format_arg_index (_tmp1934_) >= 0;
		} else {
			_tmp1932_ = FALSE;
		}
		if (_tmp1932_) {
			ValaCCodeExpression* _tmp1935_;
			_tmp1935_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1935_);
		} else {
			gboolean _tmp1936_ = FALSE;
			ValaMethod* _tmp1937_;
			_tmp1937_ = m;
			if (_tmp1937_ != NULL) {
				ValaMethod* _tmp1938_;
				_tmp1938_ = m;
				_tmp1936_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1938_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1936_ = FALSE;
			}
			if (_tmp1936_) {
				ValaCCodeExpression* _tmp1939_;
				_tmp1939_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1939_);
			} else {
				gboolean _tmp1940_ = FALSE;
				gboolean _tmp1941_ = FALSE;
				gboolean _tmp1942_;
				_tmp1942_ = return_result_via_out_param;
				if (!_tmp1942_) {
					gboolean _tmp1943_ = FALSE;
					gboolean _tmp1944_ = FALSE;
					ValaMethod* _tmp1945_;
					_tmp1945_ = m;
					if (_tmp1945_ != NULL) {
						ValaMethod* _tmp1946_;
						_tmp1946_ = m;
						_tmp1944_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp1946_);
					} else {
						_tmp1944_ = FALSE;
					}
					if (_tmp1944_) {
						_tmp1943_ = TRUE;
					} else {
						gboolean _tmp1947_ = FALSE;
						ValaDelegate* _tmp1948_;
						_tmp1948_ = deleg;
						if (_tmp1948_ != NULL) {
							ValaDelegate* _tmp1949_;
							_tmp1949_ = deleg;
							_tmp1947_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp1949_);
						} else {
							_tmp1947_ = FALSE;
						}
						_tmp1943_ = _tmp1947_;
					}
					_tmp1941_ = _tmp1943_;
				} else {
					_tmp1941_ = FALSE;
				}
				if (_tmp1941_) {
					gboolean _tmp1950_ = FALSE;
					ValaDataType* _tmp1951_;
					_tmp1951_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1951_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp1952_;
						_tmp1952_ = result_type;
						_tmp1950_ = !vala_data_type_is_disposable (_tmp1952_);
					} else {
						_tmp1950_ = FALSE;
					}
					_tmp1940_ = _tmp1950_;
				} else {
					_tmp1940_ = FALSE;
				}
				if (_tmp1940_) {
					ValaCCodeExpression* _tmp1953_;
					_tmp1953_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1953_);
				} else {
					gboolean _tmp1954_;
					_tmp1954_ = return_result_via_out_param;
					if (!_tmp1954_) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1955_;
						ValaDataType* _tmp1956_;
						gboolean _tmp1957_;
						gboolean _tmp1958_;
						ValaLocalVariable* _tmp1959_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1960_;
						const gchar* _tmp1961_;
						const gchar* _tmp1962_;
						ValaCCodeExpression* _tmp1963_;
						ValaLocalVariable* _tmp1964_;
						ValaCCodeFunction* _tmp1965_;
						ValaCCodeFunction* _tmp1966_;
						ValaCCodeExpression* _tmp1967_;
						ValaCCodeExpression* _tmp1968_;
						ValaCCodeExpression* _tmp1969_;
						ValaTargetValue* _tmp1970_;
						ValaTargetValue* _tmp1971_;
						_tmp1955_ = result_type;
						_tmp1956_ = result_type;
						_tmp1957_ = vala_data_type_get_value_owned (_tmp1956_);
						_tmp1958_ = _tmp1957_;
						_tmp1959_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1955_, _tmp1958_, NULL, FALSE);
						temp_var = _tmp1959_;
						_tmp1960_ = temp_var;
						_tmp1961_ = vala_symbol_get_name ((ValaSymbol*) _tmp1960_);
						_tmp1962_ = _tmp1961_;
						_tmp1963_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1962_);
						temp_ref = _tmp1963_;
						_tmp1964_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1964_);
						_tmp1965_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp1966_ = _tmp1965_;
						_tmp1967_ = temp_ref;
						_tmp1968_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp1966_, _tmp1967_, _tmp1968_);
						_tmp1969_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1969_);
						_tmp1970_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1971_ = _tmp1970_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1971_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp1972_;
						ValaTargetValue* _tmp1973_;
						ValaTargetValue* _tmp1974_;
						_tmp1972_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1972_);
						_tmp1973_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1974_ = _tmp1973_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1974_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp1975_ = params;
	_tmp1976_ = vala_iterable_iterator ((ValaIterable*) _tmp1975_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp1976_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1977_;
		gint _arg_size = 0;
		ValaList* _tmp1978_;
		gint _tmp1979_;
		gint _tmp1980_;
		gint _arg_index = 0;
		_tmp1977_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp1977_;
		_tmp1978_ = _arg_list;
		_tmp1979_ = vala_collection_get_size ((ValaCollection*) _tmp1978_);
		_tmp1980_ = _tmp1979_;
		_arg_size = _tmp1980_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp1981_;
			gint _tmp1982_;
			gint _tmp1983_;
			ValaExpression* arg = NULL;
			ValaList* _tmp1984_;
			gint _tmp1985_;
			gpointer _tmp1986_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1987_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp1997_;
			ValaUnaryExpression* _tmp1998_;
			gboolean _tmp1999_ = FALSE;
			ValaUnaryExpression* _tmp2000_;
			ValaUnaryExpression* _tmp2004_;
			ValaExpression* _tmp2005_;
			ValaExpression* _tmp2006_;
			ValaDataType* _tmp2007_;
			ValaDataType* _tmp2008_;
			ValaUnaryExpression* _tmp2018_;
			ValaExpression* _tmp2019_;
			ValaExpression* _tmp2020_;
			ValaTargetValue* _tmp2021_;
			ValaTargetValue* _tmp2022_;
			ValaUnaryExpression* _tmp2023_;
			ValaTargetValue* _tmp2024_;
			ValaTargetValue* _tmp2025_;
			ValaUnaryExpression* _tmp2026_;
			ValaExpression* _tmp2027_;
			ValaExpression* _tmp2028_;
			ValaDataType* _tmp2029_;
			ValaDataType* _tmp2030_;
			ValaExpression* _tmp2031_;
			ValaTargetValue* _tmp2032_;
			ValaTargetValue* _tmp2033_;
			ValaSourceReference* _tmp2034_;
			ValaSourceReference* _tmp2035_;
			gboolean _tmp2036_ = FALSE;
			ValaParameter* _tmp2037_;
			_tmp1981_ = _arg_index;
			_arg_index = _tmp1981_ + 1;
			_tmp1982_ = _arg_index;
			_tmp1983_ = _arg_size;
			if (!(_tmp1982_ < _tmp1983_)) {
				break;
			}
			_tmp1984_ = _arg_list;
			_tmp1985_ = _arg_index;
			_tmp1986_ = vala_list_get (_tmp1984_, _tmp1985_);
			arg = (ValaExpression*) _tmp1986_;
			param = NULL;
			_tmp1987_ = params_it;
			if (vala_iterator_next (_tmp1987_)) {
				ValaIterator* _tmp1988_;
				gpointer _tmp1989_;
				gboolean _tmp1990_ = FALSE;
				ValaParameter* _tmp1991_;
				gboolean _tmp1992_;
				gboolean _tmp1993_;
				_tmp1988_ = params_it;
				_tmp1989_ = vala_iterator_get (_tmp1988_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1989_;
				_tmp1991_ = param;
				_tmp1992_ = vala_parameter_get_params_array (_tmp1991_);
				_tmp1993_ = _tmp1992_;
				if (_tmp1993_) {
					_tmp1990_ = TRUE;
				} else {
					ValaParameter* _tmp1994_;
					gboolean _tmp1995_;
					gboolean _tmp1996_;
					_tmp1994_ = param;
					_tmp1995_ = vala_parameter_get_ellipsis (_tmp1994_);
					_tmp1996_ = _tmp1995_;
					_tmp1990_ = _tmp1996_;
				}
				if (_tmp1990_) {
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (arg);
					break;
				}
			}
			_tmp1997_ = arg;
			_tmp1998_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1997_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1997_) : NULL);
			unary = _tmp1998_;
			_tmp2000_ = unary;
			if (_tmp2000_ == NULL) {
				_tmp1999_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2001_;
				ValaUnaryOperator _tmp2002_;
				ValaUnaryOperator _tmp2003_;
				_tmp2001_ = unary;
				_tmp2002_ = vala_unary_expression_get_operator (_tmp2001_);
				_tmp2003_ = _tmp2002_;
				_tmp1999_ = _tmp2003_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp1999_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2004_ = unary;
			_tmp2005_ = vala_unary_expression_get_inner (_tmp2004_);
			_tmp2006_ = _tmp2005_;
			_tmp2007_ = vala_expression_get_value_type (_tmp2006_);
			_tmp2008_ = _tmp2007_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp2008_)) {
				ValaCCodeFunction* _tmp2009_;
				ValaCCodeFunction* _tmp2010_;
				ValaUnaryExpression* _tmp2011_;
				ValaExpression* _tmp2012_;
				ValaExpression* _tmp2013_;
				ValaTargetValue* _tmp2014_;
				ValaTargetValue* _tmp2015_;
				ValaCCodeExpression* _tmp2016_;
				ValaCCodeExpression* _tmp2017_;
				_tmp2009_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2010_ = _tmp2009_;
				_tmp2011_ = unary;
				_tmp2012_ = vala_unary_expression_get_inner (_tmp2011_);
				_tmp2013_ = _tmp2012_;
				_tmp2014_ = vala_expression_get_target_value (_tmp2013_);
				_tmp2015_ = _tmp2014_;
				_tmp2016_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2015_, FALSE);
				_tmp2017_ = _tmp2016_;
				vala_ccode_function_add_expression (_tmp2010_, _tmp2017_);
				_vala_ccode_node_unref0 (_tmp2017_);
			}
			_tmp2018_ = unary;
			_tmp2019_ = vala_unary_expression_get_inner (_tmp2018_);
			_tmp2020_ = _tmp2019_;
			_tmp2021_ = vala_expression_get_target_value (_tmp2020_);
			_tmp2022_ = _tmp2021_;
			_tmp2023_ = unary;
			_tmp2024_ = vala_expression_get_target_value ((ValaExpression*) _tmp2023_);
			_tmp2025_ = _tmp2024_;
			_tmp2026_ = unary;
			_tmp2027_ = vala_unary_expression_get_inner (_tmp2026_);
			_tmp2028_ = _tmp2027_;
			_tmp2029_ = vala_expression_get_value_type (_tmp2028_);
			_tmp2030_ = _tmp2029_;
			_tmp2031_ = arg;
			_tmp2032_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2025_, _tmp2030_, (ValaCodeNode*) _tmp2031_);
			_tmp2033_ = _tmp2032_;
			_tmp2034_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2035_ = _tmp2034_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2022_, _tmp2033_, _tmp2035_);
			_vala_target_value_unref0 (_tmp2033_);
			_tmp2037_ = param;
			if (_tmp2037_ != NULL) {
				ValaParameter* _tmp2038_;
				_tmp2038_ = param;
				_tmp2036_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2038_);
			} else {
				_tmp2036_ = FALSE;
			}
			if (_tmp2036_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2039_;
				ValaCCodeIdentifier* _tmp2040_;
				ValaCCodeFunctionCall* _tmp2041_;
				ValaCCodeFunctionCall* _tmp2042_;
				ValaCCodeFunctionCall* _tmp2043_;
				ValaUnaryExpression* _tmp2044_;
				ValaExpression* _tmp2045_;
				ValaExpression* _tmp2046_;
				ValaTargetValue* _tmp2047_;
				ValaTargetValue* _tmp2048_;
				ValaCCodeExpression* _tmp2049_;
				ValaCCodeExpression* _tmp2050_;
				ValaCCodeFunction* _tmp2051_;
				ValaCCodeFunction* _tmp2052_;
				ValaUnaryExpression* _tmp2053_;
				ValaExpression* _tmp2054_;
				ValaExpression* _tmp2055_;
				ValaTargetValue* _tmp2056_;
				ValaTargetValue* _tmp2057_;
				ValaCCodeExpression* _tmp2058_;
				ValaCCodeExpression* _tmp2059_;
				ValaCCodeFunctionCall* _tmp2060_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2039_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2040_ = _tmp2039_;
				_tmp2041_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2040_);
				_tmp2042_ = _tmp2041_;
				_vala_ccode_node_unref0 (_tmp2040_);
				len_call = _tmp2042_;
				_tmp2043_ = len_call;
				_tmp2044_ = unary;
				_tmp2045_ = vala_unary_expression_get_inner (_tmp2044_);
				_tmp2046_ = _tmp2045_;
				_tmp2047_ = vala_expression_get_target_value (_tmp2046_);
				_tmp2048_ = _tmp2047_;
				_tmp2049_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2048_);
				_tmp2050_ = _tmp2049_;
				vala_ccode_function_call_add_argument (_tmp2043_, _tmp2050_);
				_vala_ccode_node_unref0 (_tmp2050_);
				_tmp2051_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2052_ = _tmp2051_;
				_tmp2053_ = unary;
				_tmp2054_ = vala_unary_expression_get_inner (_tmp2053_);
				_tmp2055_ = _tmp2054_;
				_tmp2056_ = vala_expression_get_target_value (_tmp2055_);
				_tmp2057_ = _tmp2056_;
				_tmp2058_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2057_, 1);
				_tmp2059_ = _tmp2058_;
				_tmp2060_ = len_call;
				vala_ccode_function_add_assignment (_tmp2052_, _tmp2059_, (ValaCCodeExpression*) _tmp2060_);
				_vala_ccode_node_unref0 (_tmp2059_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2063_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2063_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2064_;
		ValaSymbol* _tmp2065_;
		ValaSymbol* _tmp2066_;
		_tmp2064_ = m;
		_tmp2065_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2064_);
		_tmp2066_ = _tmp2065_;
		_tmp2062_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2066_, VALA_TYPE_CLASS);
	} else {
		_tmp2062_ = FALSE;
	}
	if (_tmp2062_) {
		gboolean _tmp2067_ = FALSE;
		gboolean _tmp2068_ = FALSE;
		ValaClass* _tmp2069_;
		ValaClass* _tmp2070_;
		gboolean _tmp2071_;
		gboolean _tmp2072_;
		_tmp2069_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2070_ = _tmp2069_;
		_tmp2071_ = vala_class_get_is_compact (_tmp2070_);
		_tmp2072_ = _tmp2071_;
		if (_tmp2072_) {
			ValaClass* _tmp2073_;
			ValaClass* _tmp2074_;
			ValaClass* _tmp2075_;
			ValaClass* _tmp2076_;
			_tmp2073_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2074_ = _tmp2073_;
			_tmp2075_ = vala_class_get_base_class (_tmp2074_);
			_tmp2076_ = _tmp2075_;
			_tmp2068_ = _tmp2076_ != NULL;
		} else {
			_tmp2068_ = FALSE;
		}
		if (_tmp2068_) {
			_tmp2067_ = TRUE;
		} else {
			ValaClass* _tmp2077_;
			ValaClass* _tmp2078_;
			ValaClass* _tmp2079_;
			ValaClass* _tmp2080_;
			ValaClass* _tmp2081_;
			_tmp2077_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2078_ = _tmp2077_;
			_tmp2079_ = vala_class_get_base_class (_tmp2078_);
			_tmp2080_ = _tmp2079_;
			_tmp2081_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2067_ = _tmp2080_ == _tmp2081_;
		}
		_tmp2061_ = _tmp2067_;
	} else {
		_tmp2061_ = FALSE;
	}
	if (_tmp2061_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2082_;
		ValaClass* _tmp2083_;
		gchar* _tmp2084_;
		gchar* _tmp2085_;
		gchar* _tmp2086_;
		gchar* _tmp2087_;
		ValaCCodeIdentifier* _tmp2088_;
		ValaCCodeIdentifier* _tmp2089_;
		ValaCCodeFunctionCall* _tmp2090_;
		ValaCCodeFunctionCall* _tmp2091_;
		ValaCCodeFunctionCall* _tmp2092_;
		ValaCCodeExpression* _tmp2093_;
		ValaCCodeExpression* _tmp2094_;
		ValaCCodeFunction* _tmp2095_;
		ValaCCodeFunction* _tmp2096_;
		ValaCCodeFunctionCall* _tmp2097_;
		_tmp2082_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2083_ = _tmp2082_;
		_tmp2084_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2083_, NULL);
		_tmp2085_ = _tmp2084_;
		_tmp2086_ = g_strdup_printf ("%s_instance_init", _tmp2085_);
		_tmp2087_ = _tmp2086_;
		_tmp2088_ = vala_ccode_identifier_new (_tmp2087_);
		_tmp2089_ = _tmp2088_;
		_tmp2090_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2089_);
		_tmp2091_ = _tmp2090_;
		_vala_ccode_node_unref0 (_tmp2089_);
		_g_free0 (_tmp2087_);
		_g_free0 (_tmp2085_);
		cinitcall = _tmp2091_;
		_tmp2092_ = cinitcall;
		_tmp2093_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2094_ = _tmp2093_;
		vala_ccode_function_call_add_argument (_tmp2092_, _tmp2094_);
		_vala_ccode_node_unref0 (_tmp2094_);
		_tmp2095_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2096_ = _tmp2095_;
		_tmp2097_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2096_, (ValaCCodeExpression*) _tmp2097_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}


static gchar*
vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                               ValaEnum* en)
{
	gchar* result = NULL;
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeConstant* _tmp53_;
	ValaCCodeFile* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	ValaCCodeFile* _tmp56_;
	ValaCCodeFunction* _tmp57_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaCCodeFunction* _tmp31_;
			ValaEnumValue* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeIdentifier* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaCCodeFunction* _tmp38_;
			ValaEnumValue* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			ValaCCodeConstant* _tmp47_;
			_tmp24_ = _enum_value_index;
			_enum_value_index = _tmp24_ + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = _enum_value_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			enum_value = (ValaEnumValue*) _tmp29_;
			_tmp30_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = enum_value;
			_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_identifier_new (_tmp34_);
			_tmp36_ = _tmp35_;
			vala_ccode_function_add_case (_tmp31_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
			_g_free0 (_tmp34_);
			_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = enum_value;
			_tmp40_ = vala_get_ccode_name ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat ("\"", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat (_tmp43_, "\"", NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_ccode_constant_new (_tmp45_);
			_tmp47_ = _tmp46_;
			vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp47_);
			_vala_ccode_node_unref0 (_tmp47_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = _tmp48_;
	vala_ccode_function_close (_tmp49_);
	_tmp50_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_constant_new ("NULL");
	_tmp53_ = _tmp52_;
	vala_ccode_function_add_return (_tmp51_, (ValaCCodeExpression*) _tmp53_);
	_vala_ccode_node_unref0 (_tmp53_);
	_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp55_ = function;
	vala_ccode_file_add_function_declaration (_tmp54_, _tmp55_);
	_tmp56_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp57_ = function;
	vala_ccode_file_add_function (_tmp56_, _tmp57_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static gboolean
vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                 ValaCallable* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters (c);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			ValaParameterDirection _tmp11_;
			ValaParameterDirection _tmp12_;
			_tmp4_ = _param_index;
			_param_index = _tmp4_ + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = _param_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			_tmp11_ = vala_parameter_get_direction (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != VALA_PARAMETER_DIRECTION_IN) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}


static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor *, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}


static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self)
{
}


GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



