/* valatypecheck.c generated by valac, the Vala compiler
 * generated from valatypecheck.vala, do not modify */

/* valatypecheck.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaTypeCheckPrivate {
	ValaExpression* _expression;
	ValaDataType* _data_type;
};


static gpointer vala_typecheck_parent_class = NULL;

#define VALA_TYPECHECK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPECHECK, ValaTypeCheckPrivate))
static void vala_typecheck_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_typecheck_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_typecheck_real_is_pure (ValaExpression* base);
static void vala_typecheck_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static void vala_typecheck_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_typecheck_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_typecheck_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_typecheck_finalize (ValaCodeNode * obj);


/**
 * Creates a new type check expression.
 *
 * @param expr   an expression
 * @param type   a data type
 * @param source reference to source code
 * @return       newly created type check expression
 */
ValaTypeCheck* vala_typecheck_construct (GType object_type, ValaExpression* expr, ValaDataType* type, ValaSourceReference* source) {
	ValaTypeCheck* self = NULL;
	ValaExpression* _tmp0_;
	ValaDataType* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_val_if_fail (expr != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (ValaTypeCheck*) vala_expression_construct (object_type);
	_tmp0_ = expr;
	vala_typecheck_set_expression (self, _tmp0_);
	_tmp1_ = type;
	vala_typecheck_set_type_reference (self, _tmp1_);
	_tmp2_ = source;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp2_);
	return self;
}


ValaTypeCheck* vala_typecheck_new (ValaExpression* expr, ValaDataType* type, ValaSourceReference* source) {
	return vala_typecheck_construct (VALA_TYPE_TYPECHECK, expr, type, source);
}


static void vala_typecheck_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaTypeCheck * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaTypeCheck*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_type_check (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


static void vala_typecheck_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaTypeCheck * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	ValaDataType* _tmp3_;
	ValaDataType* _tmp4_;
	ValaCodeVisitor* _tmp5_;
	self = (ValaTypeCheck*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_typecheck_get_expression (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = vala_typecheck_get_type_reference (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp4_, _tmp5_);
}


static gboolean vala_typecheck_real_is_pure (ValaExpression* base) {
	ValaTypeCheck * self;
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_;
	self = (ValaTypeCheck*) base;
	_tmp0_ = vala_typecheck_get_expression (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_is_pure (_tmp1_);
	result = _tmp2_;
	return result;
}


static void vala_typecheck_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaTypeCheck * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaTypeCheck*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_typecheck_get_type_reference (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_typecheck_set_type_reference (self, _tmp3_);
	}
}


static void vala_typecheck_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaTypeCheck * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaTypeCheck*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_typecheck_get_expression (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_typecheck_set_expression (self, _tmp3_);
	}
}


static gboolean vala_typecheck_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaTypeCheck * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaCodeContext* _tmp9_;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	ValaTypeSymbol* _tmp20_;
	ValaTypeSymbol* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	ValaList* _tmp24_;
	ValaList* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gboolean _tmp28_;
	ValaCodeContext* _tmp32_;
	ValaSemanticAnalyzer* _tmp33_;
	ValaSemanticAnalyzer* _tmp34_;
	ValaDataType* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	self = (ValaTypeCheck*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_typecheck_get_expression (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp5_, _tmp6_);
	_tmp7_ = vala_typecheck_get_type_reference (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp8_, _tmp9_);
	_tmp10_ = vala_typecheck_get_expression (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_expression_get_value_type (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == NULL) {
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaSourceReference* _tmp16_;
		ValaSourceReference* _tmp17_;
		_tmp14_ = vala_typecheck_get_expression (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp15_);
		_tmp17_ = _tmp16_;
		vala_report_error (_tmp17_, "invalid left operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp18_ = vala_typecheck_get_type_reference (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_data_type_get_data_type (_tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_ == NULL) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp22_ = vala_typecheck_get_type_reference (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_data_type_get_type_arguments (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _tmp27_ > 0;
	_vala_iterable_unref0 (_tmp25_);
	if (_tmp28_) {
		ValaDataType* _tmp29_;
		ValaSourceReference* _tmp30_;
		ValaSourceReference* _tmp31_;
		_tmp29_ = self->priv->_data_type;
		_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp29_);
		_tmp31_ = _tmp30_;
		vala_report_warning (_tmp31_, "Type argument list has no effect");
	}
	_tmp32_ = context;
	_tmp33_ = vala_code_context_get_analyzer (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = _tmp34_->bool_type;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp35_);
	_tmp36_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp37_ = _tmp36_;
	result = !_tmp37_;
	return result;
}


static void vala_typecheck_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaTypeCheck * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeGenerator* _tmp2_;
	ValaCodeGenerator* _tmp3_;
	ValaCodeGenerator* _tmp4_;
	self = (ValaTypeCheck*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_typecheck_get_expression (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = codegen;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = codegen;
	vala_code_visitor_visit_type_check ((ValaCodeVisitor*) _tmp3_, self);
	_tmp4_ = codegen;
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp4_, (ValaExpression*) self);
}


ValaExpression* vala_typecheck_get_expression (ValaTypeCheck* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expression;
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_typecheck_set_expression (ValaTypeCheck* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_expression);
	self->priv->_expression = _tmp1_;
	_tmp2_ = self->priv->_expression;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaDataType* vala_typecheck_get_type_reference (ValaTypeCheck* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void vala_typecheck_set_type_reference (ValaTypeCheck* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp1_;
	_tmp2_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


static void vala_typecheck_class_init (ValaTypeCheckClass * klass) {
	vala_typecheck_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_typecheck_finalize;
	g_type_class_add_private (klass, sizeof (ValaTypeCheckPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_typecheck_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_typecheck_real_accept_children;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_typecheck_real_is_pure;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_typecheck_real_replace_type;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_typecheck_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_typecheck_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_typecheck_real_emit;
}


static void vala_typecheck_instance_init (ValaTypeCheck * self) {
	self->priv = VALA_TYPECHECK_GET_PRIVATE (self);
}


static void vala_typecheck_finalize (ValaCodeNode * obj) {
	ValaTypeCheck * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_TYPECHECK, ValaTypeCheck);
	_vala_code_node_unref0 (self->priv->_expression);
	_vala_code_node_unref0 (self->priv->_data_type);
	VALA_CODE_NODE_CLASS (vala_typecheck_parent_class)->finalize (obj);
}


/**
 * Represents a type check (`is`) expression in the source code.
 */
GType vala_typecheck_get_type (void) {
	static volatile gsize vala_typecheck_type_id__volatile = 0;
	if (g_once_init_enter (&vala_typecheck_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeCheckClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_typecheck_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeCheck), 0, (GInstanceInitFunc) vala_typecheck_instance_init, NULL };
		GType vala_typecheck_type_id;
		vala_typecheck_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaTypeCheck", &g_define_type_info, 0);
		g_once_init_leave (&vala_typecheck_type_id__volatile, vala_typecheck_type_id);
	}
	return vala_typecheck_type_id__volatile;
}



