/* valacastexpression.c generated by valac, the Vala compiler
 * generated from valacastexpression.vala, do not modify */

/* valacastexpression.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaCastExpressionPrivate {
	gboolean _is_silent_cast;
	gboolean _is_non_null_cast;
	ValaExpression* _inner;
	ValaDataType* _data_type;
};


static gpointer vala_cast_expression_parent_class = NULL;

#define VALA_CAST_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionPrivate))
static void vala_cast_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_cast_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_cast_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_cast_expression_real_is_pure (ValaExpression* base);
static gboolean vala_cast_expression_real_is_accessible (ValaExpression* base, ValaSymbol* sym);
static void vala_cast_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_cast_expression_real_check (ValaCodeNode* base, ValaCodeContext* context);
static gboolean vala_cast_expression_is_gvariant (ValaCastExpression* self, ValaCodeContext* context, ValaDataType* type);
static void vala_cast_expression_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_cast_expression_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_cast_expression_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection);
static gboolean vala_cast_expression_real_is_constant (ValaExpression* base);
static void vala_cast_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new cast expression.
 *
 * @param inner           expression to be cast
 * @param type_reference  target type
 * @return                newly created cast expression
 */
ValaCastExpression* vala_cast_expression_construct (GType object_type, ValaExpression* inner, ValaDataType* type_reference, ValaSourceReference* source_reference, gboolean is_silent_cast) {
	ValaCastExpression* self = NULL;
	ValaDataType* _tmp0_;
	ValaSourceReference* _tmp1_;
	gboolean _tmp2_;
	ValaExpression* _tmp3_;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (type_reference != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaCastExpression*) vala_expression_construct (object_type);
	_tmp0_ = type_reference;
	vala_cast_expression_set_type_reference (self, _tmp0_);
	_tmp1_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp1_);
	_tmp2_ = is_silent_cast;
	vala_cast_expression_set_is_silent_cast (self, _tmp2_);
	_tmp3_ = inner;
	vala_cast_expression_set_inner (self, _tmp3_);
	return self;
}


ValaCastExpression* vala_cast_expression_new (ValaExpression* inner, ValaDataType* type_reference, ValaSourceReference* source_reference, gboolean is_silent_cast) {
	return vala_cast_expression_construct (VALA_TYPE_CAST_EXPRESSION, inner, type_reference, source_reference, is_silent_cast);
}


ValaCastExpression* vala_cast_expression_construct_non_null (GType object_type, ValaExpression* inner, ValaSourceReference* source_reference) {
	ValaCastExpression* self = NULL;
	ValaExpression* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaCastExpression*) vala_expression_construct (object_type);
	_tmp0_ = inner;
	vala_cast_expression_set_inner (self, _tmp0_);
	vala_cast_expression_set_is_non_null_cast (self, TRUE);
	_tmp1_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp1_);
	return self;
}


ValaCastExpression* vala_cast_expression_new_non_null (ValaExpression* inner, ValaSourceReference* source_reference) {
	return vala_cast_expression_construct_non_null (VALA_TYPE_CAST_EXPRESSION, inner, source_reference);
}


static void vala_cast_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCastExpression * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_cast_expression (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


static void vala_cast_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	gboolean _tmp3_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->_is_non_null_cast;
	if (!_tmp3_) {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaCodeVisitor* _tmp6_;
		_tmp4_ = vala_cast_expression_get_type_reference (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, _tmp6_);
	}
}


static void vala_cast_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_cast_expression_set_inner (self, _tmp3_);
	}
}


static gboolean vala_cast_expression_real_is_pure (ValaExpression* base) {
	ValaCastExpression * self;
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_;
	self = (ValaCastExpression*) base;
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_is_pure (_tmp1_);
	result = _tmp2_;
	return result;
}


static gboolean vala_cast_expression_real_is_accessible (ValaExpression* base, ValaSymbol* sym) {
	ValaCastExpression * self;
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaSymbol* _tmp2_;
	gboolean _tmp3_;
	self = (ValaCastExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = sym;
	_tmp3_ = vala_expression_is_accessible (_tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


static void vala_cast_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaCastExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_cast_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_cast_expression_set_type_reference (self, _tmp3_);
	}
}


static gboolean vala_cast_expression_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaCastExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaCodeContext* _tmp6_;
	gboolean _tmp7_;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	gboolean _tmp14_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	ValaCodeContext* _tmp25_;
	gboolean _tmp26_ = FALSE;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp47_;
	ValaDataType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaExpression* _tmp51_;
	ValaExpression* _tmp52_;
	ValaDataType* _tmp53_;
	ValaDataType* _tmp54_;
	gboolean _tmp55_;
	gboolean _tmp56_;
	gboolean _tmp57_;
	gboolean _tmp60_ = FALSE;
	ValaCodeContext* _tmp61_;
	ValaExpression* _tmp62_;
	ValaExpression* _tmp63_;
	ValaDataType* _tmp64_;
	ValaDataType* _tmp65_;
	gboolean _tmp66_;
	ValaExpression* _tmp73_;
	ValaExpression* _tmp74_;
	ValaExpression* _tmp75_;
	ValaExpression* _tmp76_;
	ValaDataType* _tmp77_;
	ValaDataType* _tmp78_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	gboolean _tmp81_;
	gboolean _tmp82_;
	self = (ValaCastExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_cast_expression_get_inner (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	_tmp7_ = vala_code_node_check ((ValaCodeNode*) _tmp5_, _tmp6_);
	if (!_tmp7_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp8_ = vala_cast_expression_get_inner (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_expression_get_value_type (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == NULL) {
		ValaSourceReference* _tmp12_;
		ValaSourceReference* _tmp13_;
		_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp13_ = _tmp12_;
		vala_report_error (_tmp13_, "Invalid cast expression");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp14_ = self->priv->_is_non_null_cast;
	if (_tmp14_) {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaDataType* _tmp19_;
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		_tmp15_ = vala_cast_expression_get_inner (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_expression_get_value_type (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_copy (_tmp18_);
		_tmp20_ = _tmp19_;
		vala_cast_expression_set_type_reference (self, _tmp20_);
		_vala_code_node_unref0 (_tmp20_);
		_tmp21_ = vala_cast_expression_get_type_reference (self);
		_tmp22_ = _tmp21_;
		vala_data_type_set_nullable (_tmp22_, FALSE);
	}
	_tmp23_ = vala_cast_expression_get_type_reference (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp24_, _tmp25_);
	_tmp27_ = vala_cast_expression_get_type_reference (self);
	_tmp28_ = _tmp27_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaExpression* _tmp29_;
		ValaExpression* _tmp30_;
		ValaDataType* _tmp31_;
		ValaDataType* _tmp32_;
		_tmp29_ = vala_cast_expression_get_inner (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_expression_get_value_type (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp26_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, VALA_TYPE_METHOD_TYPE);
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		ValaDataType* _tmp33_;
		ValaDataType* _tmp34_;
		_tmp33_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp34_ = _tmp33_;
		if (_tmp34_ != NULL) {
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaDataType* _tmp39_;
			ValaDataType* _tmp40_;
			gboolean _tmp41_;
			gboolean _tmp42_;
			_tmp35_ = vala_cast_expression_get_inner (self);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_data_type_get_value_owned (_tmp40_);
			_tmp42_ = _tmp41_;
			vala_data_type_set_value_owned (_tmp38_, _tmp42_);
		} else {
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			_tmp43_ = vala_cast_expression_get_inner (self);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			vala_data_type_set_value_owned (_tmp46_, TRUE);
		}
	}
	_tmp47_ = vala_cast_expression_get_type_reference (self);
	_tmp48_ = _tmp47_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp48_);
	_tmp49_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_cast_expression_get_inner (self);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_expression_get_value_type (_tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_data_type_get_value_owned (_tmp54_);
	_tmp56_ = _tmp55_;
	vala_data_type_set_value_owned (_tmp50_, _tmp56_);
	_tmp57_ = self->priv->_is_silent_cast;
	if (_tmp57_) {
		ValaDataType* _tmp58_;
		ValaDataType* _tmp59_;
		_tmp58_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp59_ = _tmp58_;
		vala_data_type_set_nullable (_tmp59_, TRUE);
	}
	_tmp61_ = context;
	_tmp62_ = vala_cast_expression_get_inner (self);
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_expression_get_value_type (_tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = vala_cast_expression_is_gvariant (self, _tmp61_, _tmp65_);
	if (_tmp66_) {
		ValaCodeContext* _tmp67_;
		ValaDataType* _tmp68_;
		ValaDataType* _tmp69_;
		gboolean _tmp70_;
		_tmp67_ = context;
		_tmp68_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_cast_expression_is_gvariant (self, _tmp67_, _tmp69_);
		_tmp60_ = !_tmp70_;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		_tmp71_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp72_ = _tmp71_;
		vala_data_type_set_value_owned (_tmp72_, TRUE);
	}
	_tmp73_ = vala_cast_expression_get_inner (self);
	_tmp74_ = _tmp73_;
	_tmp75_ = vala_cast_expression_get_inner (self);
	_tmp76_ = _tmp75_;
	_tmp77_ = vala_expression_get_value_type (_tmp76_);
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_data_type_copy (_tmp78_);
	_tmp80_ = _tmp79_;
	vala_expression_set_target_type (_tmp74_, _tmp80_);
	_vala_code_node_unref0 (_tmp80_);
	_tmp81_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp82_ = _tmp81_;
	result = !_tmp82_;
	return result;
}


static gboolean vala_cast_expression_is_gvariant (ValaCastExpression* self, ValaCodeContext* context, ValaDataType* type) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp1_ = type;
	_tmp2_ = vala_data_type_get_data_type (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaDataType* _tmp4_;
		ValaTypeSymbol* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		ValaCodeContext* _tmp7_;
		ValaSemanticAnalyzer* _tmp8_;
		ValaSemanticAnalyzer* _tmp9_;
		ValaObjectType* _tmp10_;
		ValaTypeSymbol* _tmp11_;
		ValaTypeSymbol* _tmp12_;
		gboolean _tmp13_;
		_tmp4_ = type;
		_tmp5_ = vala_data_type_get_data_type (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = context;
		_tmp8_ = vala_code_context_get_analyzer (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_->gvariant_type;
		_tmp11_ = vala_data_type_get_data_type ((ValaDataType*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_typesymbol_is_subtype_of (_tmp6_, _tmp12_);
		_tmp0_ = _tmp13_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void vala_cast_expression_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeGenerator* _tmp2_;
	ValaCodeGenerator* _tmp3_;
	ValaCodeGenerator* _tmp4_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = codegen;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = codegen;
	vala_code_visitor_visit_cast_expression ((ValaCodeVisitor*) _tmp3_, self);
	_tmp4_ = codegen;
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp4_, (ValaExpression*) self);
}


static void vala_cast_expression_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCollection* _tmp2_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = collection;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, _tmp2_);
}


static void vala_cast_expression_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCollection* _tmp2_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = collection;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, _tmp2_);
}


static gboolean vala_cast_expression_real_is_constant (ValaExpression* base) {
	ValaCastExpression * self;
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_;
	self = (ValaCastExpression*) base;
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_is_constant (_tmp1_);
	result = _tmp2_;
	return result;
}


ValaExpression* vala_cast_expression_get_inner (ValaCastExpression* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_cast_expression_set_inner (ValaCastExpression* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp1_;
	_tmp2_ = self->priv->_inner;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaDataType* vala_cast_expression_get_type_reference (ValaCastExpression* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void vala_cast_expression_set_type_reference (ValaCastExpression* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp1_;
	_tmp2_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


gboolean vala_cast_expression_get_is_silent_cast (ValaCastExpression* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_silent_cast;
	result = _tmp0_;
	return result;
}


void vala_cast_expression_set_is_silent_cast (ValaCastExpression* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_silent_cast = _tmp0_;
}


gboolean vala_cast_expression_get_is_non_null_cast (ValaCastExpression* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_non_null_cast;
	result = _tmp0_;
	return result;
}


void vala_cast_expression_set_is_non_null_cast (ValaCastExpression* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_non_null_cast = _tmp0_;
}


static void vala_cast_expression_class_init (ValaCastExpressionClass * klass) {
	vala_cast_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_cast_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaCastExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_cast_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_cast_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_cast_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_cast_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_cast_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_cast_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_cast_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_cast_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_cast_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_cast_expression_real_get_used_variables;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression *)) vala_cast_expression_real_is_constant;
}


static void vala_cast_expression_instance_init (ValaCastExpression * self) {
	self->priv = VALA_CAST_EXPRESSION_GET_PRIVATE (self);
}


static void vala_cast_expression_finalize (ValaCodeNode * obj) {
	ValaCastExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_code_node_unref0 (self->priv->_data_type);
	VALA_CODE_NODE_CLASS (vala_cast_expression_parent_class)->finalize (obj);
}


/**
 * Represents a type cast in the source code.
 */
GType vala_cast_expression_get_type (void) {
	static volatile gsize vala_cast_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_cast_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCastExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_cast_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCastExpression), 0, (GInstanceInitFunc) vala_cast_expression_instance_init, NULL };
		GType vala_cast_expression_type_id;
		vala_cast_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaCastExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_cast_expression_type_id__volatile, vala_cast_expression_type_id);
	}
	return vala_cast_expression_type_id__volatile;
}



