/* valasymbolresolver.c generated by valac, the Vala compiler
 * generated from valasymbolresolver.vala, do not modify */

/* valasymbolresolver.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_SYMBOL_RESOLVER_0_PROPERTY,
	VALA_SYMBOL_RESOLVER_NUM_PROPERTIES
};
static GParamSpec* vala_symbol_resolver_properties[VALA_SYMBOL_RESOLVER_NUM_PROPERTIES];
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_scope_unref0(var) ((var == NULL) ? NULL : (var = (vala_scope_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaSymbolResolverPrivate {
	ValaCodeContext* context;
	ValaSymbol* root_symbol;
	ValaScope* current_scope;
};


static gpointer vala_symbol_resolver_parent_class = NULL;

#define VALA_SYMBOL_RESOLVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SYMBOL_RESOLVER, ValaSymbolResolverPrivate))
static void vala_symbol_resolver_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_symbol_resolver_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_symbol_resolver_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_symbol_resolver_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_symbol_resolver_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_symbol_resolver_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed);
static void vala_symbol_resolver_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb);
static void vala_symbol_resolver_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_symbol_resolver_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_symbol_resolver_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_symbol_resolver_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_symbol_resolver_real_visit_formal_parameter (ValaCodeVisitor* base, ValaParameter* p);
static void vala_symbol_resolver_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_symbol_resolver_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_symbol_resolver_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static void vala_symbol_resolver_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void vala_symbol_resolver_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void vala_symbol_resolver_real_visit_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_symbol_resolver_real_visit_using_directive (ValaCodeVisitor* base, ValaUsingDirective* ns);
static ValaSymbol* vala_symbol_resolver_resolve_symbol (ValaSymbolResolver* self, ValaUnresolvedSymbol* unresolved_symbol);
static ValaDataType* vala_symbol_resolver_get_type_for_struct (ValaSymbolResolver* self, ValaStruct* st, ValaStruct* base_struct);
static ValaDataType* vala_symbol_resolver_resolve_type (ValaSymbolResolver* self, ValaUnresolvedType* unresolved_type);
static void vala_symbol_resolver_real_visit_data_type (ValaCodeVisitor* base, ValaDataType* data_type);
static void vala_symbol_resolver_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt);
static void vala_symbol_resolver_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local);
static void vala_symbol_resolver_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list);
static void vala_symbol_resolver_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt);
static void vala_symbol_resolver_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void vala_symbol_resolver_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static void vala_symbol_resolver_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section);
static void vala_symbol_resolver_real_visit_switch_label (ValaCodeVisitor* base, ValaSwitchLabel* label);
static void vala_symbol_resolver_real_visit_loop (ValaCodeVisitor* base, ValaLoop* stmt);
static void vala_symbol_resolver_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt);
static void vala_symbol_resolver_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt);
static void vala_symbol_resolver_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt);
static void vala_symbol_resolver_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void vala_symbol_resolver_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static void vala_symbol_resolver_real_visit_yield_statement (ValaCodeVisitor* base, ValaYieldStatement* stmt);
static void vala_symbol_resolver_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt);
static void vala_symbol_resolver_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static void vala_symbol_resolver_real_visit_delete_statement (ValaCodeVisitor* base, ValaDeleteStatement* stmt);
static void vala_symbol_resolver_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
static void vala_symbol_resolver_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* e);
static void vala_symbol_resolver_real_visit_template (ValaCodeVisitor* base, ValaTemplate* tmpl);
static void vala_symbol_resolver_real_visit_tuple (ValaCodeVisitor* base, ValaTuple* tuple);
static void vala_symbol_resolver_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
static void vala_symbol_resolver_real_visit_method_call (ValaCodeVisitor* base, ValaMethodCall* expr);
static void vala_symbol_resolver_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
static void vala_symbol_resolver_real_visit_slice_expression (ValaCodeVisitor* base, ValaSliceExpression* expr);
static void vala_symbol_resolver_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr);
static void vala_symbol_resolver_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr);
static void vala_symbol_resolver_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr);
static void vala_symbol_resolver_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr);
static void vala_symbol_resolver_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr);
static void vala_symbol_resolver_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr);
static void vala_symbol_resolver_real_visit_named_argument (ValaCodeVisitor* base, ValaNamedArgument* expr);
static void vala_symbol_resolver_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr);
static void vala_symbol_resolver_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr);
static void vala_symbol_resolver_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr);
static void vala_symbol_resolver_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr);
static void vala_symbol_resolver_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr);
static void vala_symbol_resolver_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l);
static void vala_symbol_resolver_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a);
static void vala_symbol_resolver_finalize (ValaCodeVisitor * obj);


/**
 * Resolve symbol names in the specified code context.
 *
 * @param context a code context
 */
static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_symbol_resolver_resolve (ValaSymbolResolver* self, ValaCodeContext* context) {
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaNamespace* _tmp7_;
	ValaNamespace* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp1_ = _vala_code_context_ref0 (_tmp0_);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	_tmp2_ = context;
	_tmp3_ = vala_code_context_get_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp4_);
	_vala_code_node_unref0 (self->priv->root_symbol);
	self->priv->root_symbol = _tmp5_;
	_tmp6_ = context;
	_tmp7_ = vala_code_context_get_root (_tmp6_);
	_tmp8_ = _tmp7_;
	vala_code_node_accept ((ValaCodeNode*) _tmp8_, (ValaCodeVisitor*) self);
}


static gpointer _vala_scope_ref0 (gpointer self) {
	return self ? vala_scope_ref (self) : NULL;
}


static void vala_symbol_resolver_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaSymbolResolver * self;
	ValaScope* old_scope = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	ValaNamespace* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaScope* _tmp7_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = self->priv->current_scope;
	_tmp1_ = _vala_scope_ref0 (_tmp0_);
	old_scope = _tmp1_;
	_tmp2_ = ns;
	_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_scope_ref0 (_tmp4_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp5_;
	_tmp6_ = ns;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp6_, (ValaCodeVisitor*) self);
	_tmp7_ = _vala_scope_ref0 (old_scope);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp7_;
	_vala_scope_unref0 (old_scope);
}


static void vala_symbol_resolver_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaSymbolResolver * self;
	ValaClass* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaClass* _tmp4_;
	ValaClass* _tmp5_;
	ValaScope* _tmp65_;
	ValaScope* _tmp66_;
	ValaScope* _tmp67_;
	ValaScope* _tmp68_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = cl;
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_scope_ref0 (_tmp2_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp3_;
	_tmp4_ = cl;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp4_, (ValaCodeVisitor*) self);
	_tmp5_ = cl;
	vala_class_set_base_class (_tmp5_, NULL);
	{
		ValaList* _type_list = NULL;
		ValaClass* _tmp6_;
		ValaList* _tmp7_;
		gint _type_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _type_index = 0;
		_tmp6_ = cl;
		_tmp7_ = vala_class_get_base_types (_tmp6_);
		_type_list = _tmp7_;
		_tmp8_ = _type_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_type_size = _tmp10_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			ValaDataType* type = NULL;
			ValaList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			ValaDataType* _tmp17_;
			ValaTypeSymbol* _tmp18_;
			ValaTypeSymbol* _tmp19_;
			_tmp11_ = _type_index;
			_type_index = _tmp11_ + 1;
			_tmp12_ = _type_index;
			_tmp13_ = _type_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _type_list;
			_tmp15_ = _type_index;
			_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
			type = (ValaDataType*) _tmp16_;
			_tmp17_ = type;
			_tmp18_ = vala_data_type_get_data_type (_tmp17_);
			_tmp19_ = _tmp18_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALA_TYPE_CLASS)) {
				ValaClass* _tmp20_;
				ValaClass* _tmp21_;
				ValaClass* _tmp22_;
				ValaClass* _tmp42_;
				ValaDataType* _tmp43_;
				ValaTypeSymbol* _tmp44_;
				ValaTypeSymbol* _tmp45_;
				ValaClass* _tmp46_;
				ValaClass* _tmp47_;
				ValaClass* _tmp48_;
				ValaClass* _tmp49_;
				gboolean _tmp50_;
				_tmp20_ = cl;
				_tmp21_ = vala_class_get_base_class (_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp22_ != NULL) {
					ValaClass* _tmp23_;
					ValaDataType* _tmp24_;
					ValaSourceReference* _tmp25_;
					ValaSourceReference* _tmp26_;
					ValaClass* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					ValaClass* _tmp30_;
					ValaClass* _tmp31_;
					ValaClass* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					ValaDataType* _tmp35_;
					ValaTypeSymbol* _tmp36_;
					ValaTypeSymbol* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					_tmp23_ = cl;
					vala_code_node_set_error ((ValaCodeNode*) _tmp23_, TRUE);
					_tmp24_ = type;
					_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = cl;
					_tmp28_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = cl;
					_tmp31_ = vala_class_get_base_class (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = type;
					_tmp36_ = vala_data_type_get_data_type (_tmp35_);
					_tmp37_ = _tmp36_;
					_tmp38_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = g_strdup_printf ("%s: Classes cannot have multiple base classes (`%s' and `%s')", _tmp29_, _tmp34_, _tmp39_);
					_tmp41_ = _tmp40_;
					vala_report_error (_tmp26_, _tmp41_);
					_g_free0 (_tmp41_);
					_g_free0 (_tmp39_);
					_g_free0 (_tmp34_);
					_g_free0 (_tmp29_);
					_vala_code_node_unref0 (type);
					_vala_iterable_unref0 (_type_list);
					return;
				}
				_tmp42_ = cl;
				_tmp43_ = type;
				_tmp44_ = vala_data_type_get_data_type (_tmp43_);
				_tmp45_ = _tmp44_;
				vala_class_set_base_class (_tmp42_, G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_CLASS, ValaClass));
				_tmp46_ = cl;
				_tmp47_ = vala_class_get_base_class (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = cl;
				_tmp50_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp48_, (ValaTypeSymbol*) _tmp49_);
				if (_tmp50_) {
					ValaClass* _tmp51_;
					ValaDataType* _tmp52_;
					ValaSourceReference* _tmp53_;
					ValaSourceReference* _tmp54_;
					ValaClass* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					ValaClass* _tmp58_;
					ValaClass* _tmp59_;
					ValaClass* _tmp60_;
					gchar* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					gchar* _tmp64_;
					_tmp51_ = cl;
					vala_code_node_set_error ((ValaCodeNode*) _tmp51_, TRUE);
					_tmp52_ = type;
					_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp52_);
					_tmp54_ = _tmp53_;
					_tmp55_ = cl;
					_tmp56_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = cl;
					_tmp59_ = vala_class_get_base_class (_tmp58_);
					_tmp60_ = _tmp59_;
					_tmp61_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp60_);
					_tmp62_ = _tmp61_;
					_tmp63_ = g_strdup_printf ("Base class cycle (`%s' and `%s')", _tmp57_, _tmp62_);
					_tmp64_ = _tmp63_;
					vala_report_error (_tmp54_, _tmp64_);
					_g_free0 (_tmp64_);
					_g_free0 (_tmp62_);
					_g_free0 (_tmp57_);
					_vala_code_node_unref0 (type);
					_vala_iterable_unref0 (_type_list);
					return;
				}
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	_tmp65_ = self->priv->current_scope;
	_tmp66_ = vala_scope_get_parent_scope (_tmp65_);
	_tmp67_ = _tmp66_;
	_tmp68_ = _vala_scope_ref0 (_tmp67_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp68_;
}


static void vala_symbol_resolver_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaSymbolResolver * self;
	ValaStruct* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaStruct* _tmp4_;
	ValaStruct* _tmp5_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaScope* _tmp28_;
	ValaScope* _tmp29_;
	ValaScope* _tmp30_;
	ValaScope* _tmp31_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = st;
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_scope_ref0 (_tmp2_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp3_;
	_tmp4_ = st;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp4_, (ValaCodeVisitor*) self);
	_tmp5_ = st;
	_tmp6_ = vala_struct_get_base_type (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaStruct* base_type = NULL;
		ValaStruct* _tmp8_;
		ValaStruct* _tmp9_;
		ValaStruct* _tmp10_;
		ValaStruct* _tmp11_;
		ValaStruct* _tmp12_;
		_tmp8_ = st;
		_tmp9_ = vala_struct_get_base_struct (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		base_type = _tmp11_;
		_tmp12_ = base_type;
		if (_tmp12_ != NULL) {
			ValaStruct* _tmp13_;
			ValaStruct* _tmp14_;
			gboolean _tmp15_;
			_tmp13_ = base_type;
			_tmp14_ = st;
			_tmp15_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp13_, (ValaTypeSymbol*) _tmp14_);
			if (_tmp15_) {
				ValaStruct* _tmp16_;
				ValaStruct* _tmp17_;
				ValaSourceReference* _tmp18_;
				ValaSourceReference* _tmp19_;
				ValaStruct* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				ValaStruct* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp16_ = st;
				vala_code_node_set_error ((ValaCodeNode*) _tmp16_, TRUE);
				_tmp17_ = base_type;
				_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = st;
				_tmp21_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = base_type;
				_tmp24_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strdup_printf ("Base struct cycle (`%s' and `%s')", _tmp22_, _tmp25_);
				_tmp27_ = _tmp26_;
				vala_report_error (_tmp19_, _tmp27_);
				_g_free0 (_tmp27_);
				_g_free0 (_tmp25_);
				_g_free0 (_tmp22_);
				_vala_code_node_unref0 (base_type);
				return;
			}
		}
		_vala_code_node_unref0 (base_type);
	}
	_tmp28_ = self->priv->current_scope;
	_tmp29_ = vala_scope_get_parent_scope (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = _vala_scope_ref0 (_tmp30_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp31_;
}


static void vala_symbol_resolver_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaSymbolResolver * self;
	ValaInterface* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaInterface* _tmp4_;
	ValaScope* _tmp39_;
	ValaScope* _tmp40_;
	ValaScope* _tmp41_;
	ValaScope* _tmp42_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = iface;
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_scope_ref0 (_tmp2_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp3_;
	_tmp4_ = iface;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp4_, (ValaCodeVisitor*) self);
	{
		ValaList* _type_list = NULL;
		ValaInterface* _tmp5_;
		ValaList* _tmp6_;
		gint _type_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _type_index = 0;
		_tmp5_ = iface;
		_tmp6_ = vala_interface_get_prerequisites (_tmp5_);
		_type_list = _tmp6_;
		_tmp7_ = _type_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_type_size = _tmp9_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaDataType* type = NULL;
			ValaList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_;
			gboolean _tmp16_ = FALSE;
			ValaDataType* _tmp17_;
			ValaTypeSymbol* _tmp18_;
			ValaTypeSymbol* _tmp19_;
			_tmp10_ = _type_index;
			_type_index = _tmp10_ + 1;
			_tmp11_ = _type_index;
			_tmp12_ = _type_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _type_list;
			_tmp14_ = _type_index;
			_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
			type = (ValaDataType*) _tmp15_;
			_tmp17_ = type;
			_tmp18_ = vala_data_type_get_data_type (_tmp17_);
			_tmp19_ = _tmp18_;
			if (_tmp19_ != NULL) {
				ValaDataType* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				ValaTypeSymbol* _tmp22_;
				ValaInterface* _tmp23_;
				gboolean _tmp24_;
				_tmp20_ = type;
				_tmp21_ = vala_data_type_get_data_type (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = iface;
				_tmp24_ = vala_typesymbol_is_subtype_of (_tmp22_, (ValaTypeSymbol*) _tmp23_);
				_tmp16_ = _tmp24_;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				ValaInterface* _tmp25_;
				ValaDataType* _tmp26_;
				ValaSourceReference* _tmp27_;
				ValaSourceReference* _tmp28_;
				ValaInterface* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				ValaDataType* _tmp32_;
				ValaTypeSymbol* _tmp33_;
				ValaTypeSymbol* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				_tmp25_ = iface;
				vala_code_node_set_error ((ValaCodeNode*) _tmp25_, TRUE);
				_tmp26_ = type;
				_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = iface;
				_tmp30_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = type;
				_tmp33_ = vala_data_type_get_data_type (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_strdup_printf ("Prerequisite cycle (`%s' and `%s')", _tmp31_, _tmp36_);
				_tmp38_ = _tmp37_;
				vala_report_error (_tmp28_, _tmp38_);
				_g_free0 (_tmp38_);
				_g_free0 (_tmp36_);
				_g_free0 (_tmp31_);
				_vala_code_node_unref0 (type);
				_vala_iterable_unref0 (_type_list);
				return;
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	_tmp39_ = self->priv->current_scope;
	_tmp40_ = vala_scope_get_parent_scope (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = _vala_scope_ref0 (_tmp41_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp42_;
}


static void vala_symbol_resolver_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaSymbolResolver * self;
	ValaEnum* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaEnum* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = en;
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_scope_ref0 (_tmp2_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp3_;
	_tmp4_ = en;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp4_, (ValaCodeVisitor*) self);
	_tmp5_ = self->priv->current_scope;
	_tmp6_ = vala_scope_get_parent_scope (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_scope_ref0 (_tmp7_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp8_;
}


static void vala_symbol_resolver_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed) {
	ValaSymbolResolver * self;
	ValaErrorDomain* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaErrorDomain* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (ed != NULL);
	_tmp0_ = ed;
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_scope_ref0 (_tmp2_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp3_;
	_tmp4_ = ed;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp4_, (ValaCodeVisitor*) self);
	_tmp5_ = self->priv->current_scope;
	_tmp6_ = vala_scope_get_parent_scope (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_scope_ref0 (_tmp7_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp8_;
}


static void vala_symbol_resolver_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb) {
	ValaSymbolResolver * self;
	ValaDelegate* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaDelegate* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (cb != NULL);
	_tmp0_ = cb;
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_scope_ref0 (_tmp2_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp3_;
	_tmp4_ = cb;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp4_, (ValaCodeVisitor*) self);
	_tmp5_ = self->priv->current_scope;
	_tmp6_ = vala_scope_get_parent_scope (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_scope_ref0 (_tmp7_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp8_;
}


static void vala_symbol_resolver_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	ValaSymbolResolver * self;
	ValaScope* old_scope = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	ValaConstant* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaConstant* _tmp9_;
	ValaScope* _tmp10_;
	ValaScope* _tmp11_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->current_scope;
	_tmp1_ = _vala_scope_ref0 (_tmp0_);
	old_scope = _tmp1_;
	_tmp2_ = c;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_BLOCK)) {
		ValaConstant* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaScope* _tmp8_;
		_tmp5_ = c;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _vala_scope_ref0 (_tmp7_);
		_vala_scope_unref0 (self->priv->current_scope);
		self->priv->current_scope = _tmp8_;
	}
	_tmp9_ = c;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp9_, (ValaCodeVisitor*) self);
	_tmp10_ = old_scope;
	_tmp11_ = _vala_scope_ref0 (_tmp10_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp11_;
	_vala_scope_unref0 (old_scope);
}


static void vala_symbol_resolver_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaSymbolResolver * self;
	ValaField* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaField* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = f;
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_scope_ref0 (_tmp2_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp3_;
	_tmp4_ = f;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp4_, (ValaCodeVisitor*) self);
	_tmp5_ = self->priv->current_scope;
	_tmp6_ = vala_scope_get_parent_scope (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_scope_ref0 (_tmp7_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp8_;
}


static void vala_symbol_resolver_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaSymbolResolver * self;
	ValaMethod* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaMethod* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_scope_ref0 (_tmp2_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp3_;
	_tmp4_ = m;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp4_, (ValaCodeVisitor*) self);
	_tmp5_ = self->priv->current_scope;
	_tmp6_ = vala_scope_get_parent_scope (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_scope_ref0 (_tmp7_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp8_;
}


static void vala_symbol_resolver_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	ValaSymbolResolver * self;
	ValaCreationMethod* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_formal_parameter (ValaCodeVisitor* base, ValaParameter* p) {
	ValaSymbolResolver * self;
	ValaParameter* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (p != NULL);
	_tmp0_ = p;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaSymbolResolver * self;
	ValaProperty* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc) {
	ValaSymbolResolver * self;
	ValaPropertyAccessor* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (acc != NULL);
	_tmp0_ = acc;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaSymbolResolver * self;
	ValaSignal* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = sig;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c) {
	ValaSymbolResolver * self;
	ValaConstructor* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d) {
	ValaSymbolResolver * self;
	ValaDestructor* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = d;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_block (ValaCodeVisitor* base, ValaBlock* b) {
	ValaSymbolResolver * self;
	ValaBlock* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (b != NULL);
	_tmp0_ = b;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_using_directive (ValaCodeVisitor* base, ValaUsingDirective* ns) {
	ValaSymbolResolver * self;
	ValaUnresolvedSymbol* unresolved_symbol = NULL;
	ValaUsingDirective* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaUnresolvedSymbol* _tmp3_;
	ValaUnresolvedSymbol* _tmp4_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = ns;
	_tmp1_ = vala_using_directive_get_namespace_symbol (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_UNRESOLVED_SYMBOL) ? ((ValaUnresolvedSymbol*) _tmp2_) : NULL);
	unresolved_symbol = _tmp3_;
	_tmp4_ = unresolved_symbol;
	if (_tmp4_ != NULL) {
		ValaUsingDirective* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaUsingDirective* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp5_ = ns;
		_tmp6_ = unresolved_symbol;
		_tmp7_ = vala_symbol_resolver_resolve_symbol (self, _tmp6_);
		_tmp8_ = _tmp7_;
		vala_using_directive_set_namespace_symbol (_tmp5_, _tmp8_);
		_vala_code_node_unref0 (_tmp8_);
		_tmp9_ = ns;
		_tmp10_ = vala_using_directive_get_namespace_symbol (_tmp9_);
		_tmp11_ = _tmp10_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_NAMESPACE)) {
			ValaUsingDirective* _tmp12_;
			ValaUsingDirective* _tmp13_;
			ValaSourceReference* _tmp14_;
			ValaSourceReference* _tmp15_;
			ValaUnresolvedSymbol* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp12_ = ns;
			vala_code_node_set_error ((ValaCodeNode*) _tmp12_, TRUE);
			_tmp13_ = ns;
			_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = unresolved_symbol;
			_tmp17_ = vala_code_node_to_string ((ValaCodeNode*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup_printf ("The namespace name `%s' could not be found", _tmp18_);
			_tmp20_ = _tmp19_;
			vala_report_error (_tmp15_, _tmp20_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp18_);
			_vala_code_node_unref0 (unresolved_symbol);
			return;
		}
	}
	_vala_code_node_unref0 (unresolved_symbol);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static ValaSymbol* vala_symbol_resolver_resolve_symbol (ValaSymbolResolver* self, ValaUnresolvedSymbol* unresolved_symbol) {
	ValaSymbol* result = NULL;
	ValaUnresolvedSymbol* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (unresolved_symbol != NULL, NULL);
	_tmp0_ = unresolved_symbol;
	_tmp1_ = vala_unresolved_symbol_get_qualified (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ValaSymbol* _tmp3_;
		ValaScope* _tmp4_;
		ValaScope* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		ValaSymbol* _tmp9_;
		_tmp3_ = self->priv->root_symbol;
		_tmp4_ = vala_symbol_get_scope (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = unresolved_symbol;
		_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_scope_lookup (_tmp5_, _tmp8_);
		result = _tmp9_;
		return result;
	} else {
		ValaUnresolvedSymbol* _tmp10_;
		ValaUnresolvedSymbol* _tmp11_;
		ValaUnresolvedSymbol* _tmp12_;
		_tmp10_ = unresolved_symbol;
		_tmp11_ = vala_unresolved_symbol_get_inner (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == NULL) {
			ValaSymbol* sym = NULL;
			ValaScope* scope = NULL;
			ValaScope* _tmp13_;
			ValaScope* _tmp14_;
			gboolean _tmp32_ = FALSE;
			ValaSymbol* _tmp33_;
			sym = NULL;
			_tmp13_ = self->priv->current_scope;
			_tmp14_ = _vala_scope_ref0 (_tmp13_);
			scope = _tmp14_;
			while (TRUE) {
				gboolean _tmp15_ = FALSE;
				ValaSymbol* _tmp16_;
				ValaScope* _tmp18_;
				ValaUnresolvedSymbol* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				ValaSymbol* _tmp22_;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				ValaSymbol* _tmp25_;
				ValaScope* _tmp28_;
				ValaScope* _tmp29_;
				ValaScope* _tmp30_;
				ValaScope* _tmp31_;
				_tmp16_ = sym;
				if (_tmp16_ == NULL) {
					ValaScope* _tmp17_;
					_tmp17_ = scope;
					_tmp15_ = _tmp17_ != NULL;
				} else {
					_tmp15_ = FALSE;
				}
				if (!_tmp15_) {
					break;
				}
				_tmp18_ = scope;
				_tmp19_ = unresolved_symbol;
				_tmp20_ = vala_symbol_get_name ((ValaSymbol*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_scope_lookup (_tmp18_, _tmp21_);
				_vala_code_node_unref0 (sym);
				sym = _tmp22_;
				_tmp25_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_NAMESPACE)) {
					_tmp24_ = TRUE;
				} else {
					ValaSymbol* _tmp26_;
					_tmp26_ = sym;
					_tmp24_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, VALA_TYPE_TYPESYMBOL);
				}
				if (_tmp24_) {
					_tmp23_ = TRUE;
				} else {
					ValaSymbol* _tmp27_;
					_tmp27_ = sym;
					_tmp23_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_TYPEPARAMETER);
				}
				if (!_tmp23_) {
					_vala_code_node_unref0 (sym);
					sym = NULL;
				}
				_tmp28_ = scope;
				_tmp29_ = vala_scope_get_parent_scope (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = _vala_scope_ref0 (_tmp30_);
				_vala_scope_unref0 (scope);
				scope = _tmp31_;
			}
			_tmp33_ = sym;
			if (_tmp33_ == NULL) {
				ValaUnresolvedSymbol* _tmp34_;
				ValaSourceReference* _tmp35_;
				ValaSourceReference* _tmp36_;
				_tmp34_ = unresolved_symbol;
				_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp32_ = _tmp36_ != NULL;
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				{
					ValaList* _ns_list = NULL;
					ValaUnresolvedSymbol* _tmp37_;
					ValaSourceReference* _tmp38_;
					ValaSourceReference* _tmp39_;
					ValaList* _tmp40_;
					ValaList* _tmp41_;
					ValaList* _tmp42_;
					gint _ns_size = 0;
					ValaList* _tmp43_;
					gint _tmp44_;
					gint _tmp45_;
					gint _ns_index = 0;
					_tmp37_ = unresolved_symbol;
					_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = vala_source_reference_get_using_directives (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = _vala_iterable_ref0 (_tmp41_);
					_ns_list = _tmp42_;
					_tmp43_ = _ns_list;
					_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
					_tmp45_ = _tmp44_;
					_ns_size = _tmp45_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp46_;
						gint _tmp47_;
						gint _tmp48_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp49_;
						gint _tmp50_;
						gpointer _tmp51_;
						gboolean _tmp52_ = FALSE;
						ValaUsingDirective* _tmp53_;
						gboolean _tmp54_;
						gboolean _tmp55_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp59_;
						ValaSymbol* _tmp60_;
						ValaSymbol* _tmp61_;
						ValaScope* _tmp62_;
						ValaScope* _tmp63_;
						ValaUnresolvedSymbol* _tmp64_;
						const gchar* _tmp65_;
						const gchar* _tmp66_;
						ValaSymbol* _tmp67_;
						gboolean _tmp68_ = FALSE;
						gboolean _tmp69_ = FALSE;
						ValaSymbol* _tmp70_;
						ValaSymbol* _tmp73_;
						_tmp46_ = _ns_index;
						_ns_index = _tmp46_ + 1;
						_tmp47_ = _ns_index;
						_tmp48_ = _ns_size;
						if (!(_tmp47_ < _tmp48_)) {
							break;
						}
						_tmp49_ = _ns_list;
						_tmp50_ = _ns_index;
						_tmp51_ = vala_list_get (_tmp49_, _tmp50_);
						ns = (ValaUsingDirective*) _tmp51_;
						_tmp53_ = ns;
						_tmp54_ = vala_code_node_get_error ((ValaCodeNode*) _tmp53_);
						_tmp55_ = _tmp54_;
						if (_tmp55_) {
							_tmp52_ = TRUE;
						} else {
							ValaUsingDirective* _tmp56_;
							ValaSymbol* _tmp57_;
							ValaSymbol* _tmp58_;
							_tmp56_ = ns;
							_tmp57_ = vala_using_directive_get_namespace_symbol (_tmp56_);
							_tmp58_ = _tmp57_;
							_tmp52_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp58_, VALA_TYPE_UNRESOLVED_SYMBOL);
						}
						if (_tmp52_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp59_ = ns;
						_tmp60_ = vala_using_directive_get_namespace_symbol (_tmp59_);
						_tmp61_ = _tmp60_;
						_tmp62_ = vala_symbol_get_scope (_tmp61_);
						_tmp63_ = _tmp62_;
						_tmp64_ = unresolved_symbol;
						_tmp65_ = vala_symbol_get_name ((ValaSymbol*) _tmp64_);
						_tmp66_ = _tmp65_;
						_tmp67_ = vala_scope_lookup (_tmp63_, _tmp66_);
						local_sym = _tmp67_;
						_tmp70_ = local_sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, VALA_TYPE_NAMESPACE)) {
							_tmp69_ = TRUE;
						} else {
							ValaSymbol* _tmp71_;
							_tmp71_ = local_sym;
							_tmp69_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, VALA_TYPE_TYPESYMBOL);
						}
						if (_tmp69_) {
							_tmp68_ = TRUE;
						} else {
							ValaSymbol* _tmp72_;
							_tmp72_ = sym;
							_tmp68_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALA_TYPE_TYPEPARAMETER);
						}
						if (!_tmp68_) {
							_vala_code_node_unref0 (local_sym);
							local_sym = NULL;
						}
						_tmp73_ = local_sym;
						if (_tmp73_ != NULL) {
							gboolean _tmp74_ = FALSE;
							ValaSymbol* _tmp75_;
							ValaSymbol* _tmp93_;
							ValaSymbol* _tmp94_;
							_tmp75_ = sym;
							if (_tmp75_ != NULL) {
								ValaSymbol* _tmp76_;
								ValaSymbol* _tmp77_;
								_tmp76_ = sym;
								_tmp77_ = local_sym;
								_tmp74_ = _tmp76_ != _tmp77_;
							} else {
								_tmp74_ = FALSE;
							}
							if (_tmp74_) {
								ValaUnresolvedSymbol* _tmp78_;
								ValaUnresolvedSymbol* _tmp79_;
								ValaSourceReference* _tmp80_;
								ValaSourceReference* _tmp81_;
								ValaUnresolvedSymbol* _tmp82_;
								const gchar* _tmp83_;
								const gchar* _tmp84_;
								ValaSymbol* _tmp85_;
								gchar* _tmp86_;
								gchar* _tmp87_;
								ValaSymbol* _tmp88_;
								gchar* _tmp89_;
								gchar* _tmp90_;
								gchar* _tmp91_;
								gchar* _tmp92_;
								_tmp78_ = unresolved_symbol;
								vala_code_node_set_error ((ValaCodeNode*) _tmp78_, TRUE);
								_tmp79_ = unresolved_symbol;
								_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp79_);
								_tmp81_ = _tmp80_;
								_tmp82_ = unresolved_symbol;
								_tmp83_ = vala_symbol_get_name ((ValaSymbol*) _tmp82_);
								_tmp84_ = _tmp83_;
								_tmp85_ = sym;
								_tmp86_ = vala_symbol_get_full_name (_tmp85_);
								_tmp87_ = _tmp86_;
								_tmp88_ = local_sym;
								_tmp89_ = vala_symbol_get_full_name (_tmp88_);
								_tmp90_ = _tmp89_;
								_tmp91_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp84_, _tmp87_, _tmp90_);
								_tmp92_ = _tmp91_;
								vala_report_error (_tmp81_, _tmp92_);
								_g_free0 (_tmp92_);
								_g_free0 (_tmp90_);
								_g_free0 (_tmp87_);
								result = NULL;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_scope_unref0 (scope);
								_vala_code_node_unref0 (sym);
								return result;
							}
							_tmp93_ = local_sym;
							_tmp94_ = _vala_code_node_ref0 (_tmp93_);
							_vala_code_node_unref0 (sym);
							sym = _tmp94_;
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			result = sym;
			_vala_scope_unref0 (scope);
			return result;
		} else {
			ValaSymbol* parent_symbol = NULL;
			ValaUnresolvedSymbol* _tmp95_;
			ValaUnresolvedSymbol* _tmp96_;
			ValaUnresolvedSymbol* _tmp97_;
			ValaSymbol* _tmp98_;
			ValaSymbol* _tmp99_;
			ValaSymbol* _tmp113_;
			ValaSymbol* _tmp114_;
			ValaScope* _tmp115_;
			ValaScope* _tmp116_;
			ValaUnresolvedSymbol* _tmp117_;
			const gchar* _tmp118_;
			const gchar* _tmp119_;
			ValaSymbol* _tmp120_;
			_tmp95_ = unresolved_symbol;
			_tmp96_ = vala_unresolved_symbol_get_inner (_tmp95_);
			_tmp97_ = _tmp96_;
			_tmp98_ = vala_symbol_resolver_resolve_symbol (self, _tmp97_);
			parent_symbol = _tmp98_;
			_tmp99_ = parent_symbol;
			if (_tmp99_ == NULL) {
				ValaUnresolvedSymbol* _tmp100_;
				ValaUnresolvedSymbol* _tmp101_;
				ValaUnresolvedSymbol* _tmp102_;
				ValaUnresolvedSymbol* _tmp103_;
				ValaSourceReference* _tmp104_;
				ValaSourceReference* _tmp105_;
				ValaUnresolvedSymbol* _tmp106_;
				ValaUnresolvedSymbol* _tmp107_;
				ValaUnresolvedSymbol* _tmp108_;
				const gchar* _tmp109_;
				const gchar* _tmp110_;
				gchar* _tmp111_;
				gchar* _tmp112_;
				_tmp100_ = unresolved_symbol;
				vala_code_node_set_error ((ValaCodeNode*) _tmp100_, TRUE);
				_tmp101_ = unresolved_symbol;
				_tmp102_ = vala_unresolved_symbol_get_inner (_tmp101_);
				_tmp103_ = _tmp102_;
				_tmp104_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp103_);
				_tmp105_ = _tmp104_;
				_tmp106_ = unresolved_symbol;
				_tmp107_ = vala_unresolved_symbol_get_inner (_tmp106_);
				_tmp108_ = _tmp107_;
				_tmp109_ = vala_symbol_get_name ((ValaSymbol*) _tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = g_strdup_printf ("The symbol `%s' could not be found", _tmp110_);
				_tmp112_ = _tmp111_;
				vala_report_error (_tmp105_, _tmp112_);
				_g_free0 (_tmp112_);
				result = NULL;
				_vala_code_node_unref0 (parent_symbol);
				return result;
			}
			_tmp113_ = parent_symbol;
			vala_symbol_set_used (_tmp113_, TRUE);
			_tmp114_ = parent_symbol;
			_tmp115_ = vala_symbol_get_scope (_tmp114_);
			_tmp116_ = _tmp115_;
			_tmp117_ = unresolved_symbol;
			_tmp118_ = vala_symbol_get_name ((ValaSymbol*) _tmp117_);
			_tmp119_ = _tmp118_;
			_tmp120_ = vala_scope_lookup (_tmp116_, _tmp119_);
			result = _tmp120_;
			_vala_code_node_unref0 (parent_symbol);
			return result;
		}
	}
}


static ValaDataType* vala_symbol_resolver_get_type_for_struct (ValaSymbolResolver* self, ValaStruct* st, ValaStruct* base_struct) {
	ValaDataType* result = NULL;
	ValaStruct* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaStruct* _tmp14_;
	ValaStruct* _tmp15_;
	ValaStruct* _tmp16_;
	ValaStruct* _tmp22_;
	ValaAttribute* _tmp23_;
	ValaAttribute* _tmp24_;
	gboolean _tmp25_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (st != NULL, NULL);
	g_return_val_if_fail (base_struct != NULL, NULL);
	_tmp0_ = st;
	_tmp1_ = vala_struct_get_base_type (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaScope* old_scope = NULL;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		ValaStruct* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaScope* _tmp8_;
		ValaStruct* _tmp9_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		ValaScope* _tmp12_;
		ValaScope* _tmp13_;
		_tmp3_ = self->priv->current_scope;
		_tmp4_ = _vala_scope_ref0 (_tmp3_);
		old_scope = _tmp4_;
		_tmp5_ = st;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _vala_scope_ref0 (_tmp7_);
		_vala_scope_unref0 (self->priv->current_scope);
		self->priv->current_scope = _tmp8_;
		_tmp9_ = st;
		_tmp10_ = vala_struct_get_base_type (_tmp9_);
		_tmp11_ = _tmp10_;
		vala_code_node_accept ((ValaCodeNode*) _tmp11_, (ValaCodeVisitor*) self);
		_tmp12_ = old_scope;
		_tmp13_ = _vala_scope_ref0 (_tmp12_);
		_vala_scope_unref0 (self->priv->current_scope);
		self->priv->current_scope = _tmp13_;
		_vala_scope_unref0 (old_scope);
	}
	_tmp14_ = base_struct;
	_tmp15_ = vala_struct_get_base_struct (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValaStruct* _tmp17_;
		ValaStruct* _tmp18_;
		ValaStruct* _tmp19_;
		ValaStruct* _tmp20_;
		ValaDataType* _tmp21_;
		_tmp17_ = st;
		_tmp18_ = base_struct;
		_tmp19_ = vala_struct_get_base_struct (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_symbol_resolver_get_type_for_struct (self, _tmp17_, _tmp20_);
		result = _tmp21_;
		return result;
	}
	_tmp22_ = base_struct;
	_tmp23_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp22_, "BooleanType");
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_ != NULL;
	_vala_code_node_unref0 (_tmp24_);
	if (_tmp25_) {
		ValaStruct* _tmp26_;
		ValaBooleanType* _tmp27_;
		_tmp26_ = st;
		_tmp27_ = vala_boolean_type_new (_tmp26_);
		result = (ValaDataType*) _tmp27_;
		return result;
	} else {
		ValaStruct* _tmp28_;
		ValaAttribute* _tmp29_;
		ValaAttribute* _tmp30_;
		gboolean _tmp31_;
		_tmp28_ = base_struct;
		_tmp29_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp28_, "IntegerType");
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_ != NULL;
		_vala_code_node_unref0 (_tmp30_);
		if (_tmp31_) {
			ValaStruct* _tmp32_;
			ValaIntegerType* _tmp33_;
			_tmp32_ = st;
			_tmp33_ = vala_integer_type_new (_tmp32_, NULL, NULL);
			result = (ValaDataType*) _tmp33_;
			return result;
		} else {
			ValaStruct* _tmp34_;
			ValaAttribute* _tmp35_;
			ValaAttribute* _tmp36_;
			gboolean _tmp37_;
			_tmp34_ = base_struct;
			_tmp35_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp34_, "FloatingType");
			_tmp36_ = _tmp35_;
			_tmp37_ = _tmp36_ != NULL;
			_vala_code_node_unref0 (_tmp36_);
			if (_tmp37_) {
				ValaStruct* _tmp38_;
				ValaFloatingType* _tmp39_;
				_tmp38_ = st;
				_tmp39_ = vala_floating_type_new (_tmp38_);
				result = (ValaDataType*) _tmp39_;
				return result;
			} else {
				ValaStruct* _tmp40_;
				ValaStructValueType* _tmp41_;
				_tmp40_ = st;
				_tmp41_ = vala_struct_value_type_new (_tmp40_);
				result = (ValaDataType*) _tmp41_;
				return result;
			}
		}
	}
}


static ValaDataType* vala_symbol_resolver_resolve_type (ValaSymbolResolver* self, ValaUnresolvedType* unresolved_type) {
	ValaDataType* result = NULL;
	ValaDataType* type = NULL;
	ValaUnresolvedType* _tmp0_;
	ValaUnresolvedSymbol* _tmp1_;
	ValaUnresolvedSymbol* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaSymbol* sym = NULL;
	ValaUnresolvedType* _tmp6_;
	ValaUnresolvedSymbol* _tmp7_;
	ValaUnresolvedSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp27_;
	ValaDataType* _tmp89_;
	ValaUnresolvedType* _tmp90_;
	ValaSourceReference* _tmp91_;
	ValaSourceReference* _tmp92_;
	ValaDataType* _tmp93_;
	ValaUnresolvedType* _tmp94_;
	gboolean _tmp95_;
	gboolean _tmp96_;
	ValaSymbol* _tmp97_;
	ValaDataType* _tmp98_;
	ValaDataType* _tmp104_;
	ValaUnresolvedType* _tmp105_;
	gboolean _tmp106_;
	gboolean _tmp107_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (unresolved_type != NULL, NULL);
	type = NULL;
	_tmp0_ = unresolved_type;
	_tmp1_ = vala_unresolved_type_get_unresolved_symbol (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "void") == 0) {
		ValaVoidType* _tmp5_;
		_tmp5_ = vala_void_type_new (NULL);
		result = (ValaDataType*) _tmp5_;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp6_ = unresolved_type;
	_tmp7_ = vala_unresolved_type_get_unresolved_symbol (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_symbol_resolver_resolve_symbol (self, _tmp8_);
	sym = _tmp9_;
	_tmp10_ = sym;
	if (_tmp10_ == NULL) {
		ValaUnresolvedType* _tmp11_;
		ValaUnresolvedSymbol* _tmp12_;
		ValaUnresolvedSymbol* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		ValaInvalidType* _tmp26_;
		_tmp11_ = unresolved_type;
		_tmp12_ = vala_unresolved_type_get_unresolved_symbol (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_code_node_get_error ((ValaCodeNode*) _tmp13_);
		_tmp15_ = _tmp14_;
		if (!_tmp15_) {
			ValaUnresolvedType* _tmp16_;
			ValaSourceReference* _tmp17_;
			ValaSourceReference* _tmp18_;
			ValaUnresolvedType* _tmp19_;
			ValaUnresolvedSymbol* _tmp20_;
			ValaUnresolvedSymbol* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp16_ = unresolved_type;
			_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = unresolved_type;
			_tmp20_ = vala_unresolved_type_get_unresolved_symbol (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_code_node_to_string ((ValaCodeNode*) _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strdup_printf ("The type name `%s' could not be found", _tmp23_);
			_tmp25_ = _tmp24_;
			vala_report_error (_tmp18_, _tmp25_);
			_g_free0 (_tmp25_);
			_g_free0 (_tmp23_);
		}
		_tmp26_ = vala_invalid_type_new ();
		result = (ValaDataType*) _tmp26_;
		_vala_code_node_unref0 (sym);
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp27_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_TYPEPARAMETER)) {
		ValaSymbol* _tmp28_;
		ValaGenericType* _tmp29_;
		_tmp28_ = sym;
		_tmp29_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp29_;
	} else {
		ValaSymbol* _tmp30_;
		_tmp30_ = sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, VALA_TYPE_TYPESYMBOL)) {
			ValaSymbol* _tmp31_;
			_tmp31_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_DELEGATE)) {
				ValaSymbol* _tmp32_;
				ValaDelegateType* _tmp33_;
				_tmp32_ = sym;
				_tmp33_ = vala_delegate_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_DELEGATE, ValaDelegate));
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp33_;
			} else {
				ValaSymbol* _tmp34_;
				_tmp34_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, VALA_TYPE_CLASS)) {
					ValaClass* cl = NULL;
					ValaSymbol* _tmp35_;
					ValaClass* _tmp36_;
					ValaClass* _tmp37_;
					gboolean _tmp38_;
					gboolean _tmp39_;
					_tmp35_ = sym;
					_tmp36_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_CLASS, ValaClass));
					cl = _tmp36_;
					_tmp37_ = cl;
					_tmp38_ = vala_class_get_is_error_base (_tmp37_);
					_tmp39_ = _tmp38_;
					if (_tmp39_) {
						ValaUnresolvedType* _tmp40_;
						ValaSourceReference* _tmp41_;
						ValaSourceReference* _tmp42_;
						ValaErrorType* _tmp43_;
						_tmp40_ = unresolved_type;
						_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = vala_error_type_new (NULL, NULL, _tmp42_);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp43_;
					} else {
						ValaClass* _tmp44_;
						ValaObjectType* _tmp45_;
						_tmp44_ = cl;
						_tmp45_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp44_);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp45_;
					}
					_vala_code_node_unref0 (cl);
				} else {
					ValaSymbol* _tmp46_;
					_tmp46_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, VALA_TYPE_INTERFACE)) {
						ValaSymbol* _tmp47_;
						ValaObjectType* _tmp48_;
						_tmp47_ = sym;
						_tmp48_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_INTERFACE, ValaInterface));
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp48_;
					} else {
						ValaSymbol* _tmp49_;
						_tmp49_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, VALA_TYPE_STRUCT)) {
							ValaSymbol* _tmp50_;
							ValaSymbol* _tmp51_;
							ValaDataType* _tmp52_;
							_tmp50_ = sym;
							_tmp51_ = sym;
							_tmp52_ = vala_symbol_resolver_get_type_for_struct (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_STRUCT, ValaStruct), G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, VALA_TYPE_STRUCT, ValaStruct));
							_vala_code_node_unref0 (type);
							type = _tmp52_;
						} else {
							ValaSymbol* _tmp53_;
							_tmp53_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, VALA_TYPE_ENUM)) {
								ValaSymbol* _tmp54_;
								ValaEnumValueType* _tmp55_;
								_tmp54_ = sym;
								_tmp55_ = vala_enum_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, VALA_TYPE_ENUM, ValaEnum));
								_vala_code_node_unref0 (type);
								type = (ValaDataType*) _tmp55_;
							} else {
								ValaSymbol* _tmp56_;
								_tmp56_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, VALA_TYPE_ERROR_DOMAIN)) {
									ValaSymbol* _tmp57_;
									ValaUnresolvedType* _tmp58_;
									ValaSourceReference* _tmp59_;
									ValaSourceReference* _tmp60_;
									ValaErrorType* _tmp61_;
									_tmp57_ = sym;
									_tmp58_ = unresolved_type;
									_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp58_);
									_tmp60_ = _tmp59_;
									_tmp61_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), NULL, _tmp60_);
									_vala_code_node_unref0 (type);
									type = (ValaDataType*) _tmp61_;
								} else {
									ValaSymbol* _tmp62_;
									_tmp62_ = sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, VALA_TYPE_ERROR_CODE)) {
										ValaSymbol* _tmp63_;
										ValaSymbol* _tmp64_;
										ValaSymbol* _tmp65_;
										ValaSymbol* _tmp66_;
										ValaUnresolvedType* _tmp67_;
										ValaSourceReference* _tmp68_;
										ValaSourceReference* _tmp69_;
										ValaErrorType* _tmp70_;
										_tmp63_ = sym;
										_tmp64_ = vala_symbol_get_parent_symbol (_tmp63_);
										_tmp65_ = _tmp64_;
										_tmp66_ = sym;
										_tmp67_ = unresolved_type;
										_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
										_tmp69_ = _tmp68_;
										_tmp70_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp69_);
										_vala_code_node_unref0 (type);
										type = (ValaDataType*) _tmp70_;
									} else {
										ValaUnresolvedType* _tmp71_;
										ValaSourceReference* _tmp72_;
										ValaSourceReference* _tmp73_;
										ValaSymbol* _tmp74_;
										gchar* _tmp75_;
										gchar* _tmp76_;
										gchar* _tmp77_;
										gchar* _tmp78_;
										ValaInvalidType* _tmp79_;
										_tmp71_ = unresolved_type;
										_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp71_);
										_tmp73_ = _tmp72_;
										_tmp74_ = sym;
										_tmp75_ = vala_symbol_get_full_name (_tmp74_);
										_tmp76_ = _tmp75_;
										_tmp77_ = g_strdup_printf ("internal error: `%s' is not a supported type", _tmp76_);
										_tmp78_ = _tmp77_;
										vala_report_error (_tmp73_, _tmp78_);
										_g_free0 (_tmp78_);
										_g_free0 (_tmp76_);
										_tmp79_ = vala_invalid_type_new ();
										result = (ValaDataType*) _tmp79_;
										_vala_code_node_unref0 (sym);
										_vala_code_node_unref0 (type);
										return result;
									}
								}
							}
						}
					}
				}
			}
		} else {
			ValaUnresolvedType* _tmp80_;
			ValaSourceReference* _tmp81_;
			ValaSourceReference* _tmp82_;
			ValaSymbol* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			ValaInvalidType* _tmp88_;
			_tmp80_ = unresolved_type;
			_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = sym;
			_tmp84_ = vala_symbol_get_full_name (_tmp83_);
			_tmp85_ = _tmp84_;
			_tmp86_ = g_strdup_printf ("`%s' is not a type", _tmp85_);
			_tmp87_ = _tmp86_;
			vala_report_error (_tmp82_, _tmp87_);
			_g_free0 (_tmp87_);
			_g_free0 (_tmp85_);
			_tmp88_ = vala_invalid_type_new ();
			result = (ValaDataType*) _tmp88_;
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			return result;
		}
	}
	_tmp89_ = type;
	_tmp90_ = unresolved_type;
	_tmp91_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp90_);
	_tmp92_ = _tmp91_;
	vala_code_node_set_source_reference ((ValaCodeNode*) _tmp89_, _tmp92_);
	_tmp93_ = type;
	_tmp94_ = unresolved_type;
	_tmp95_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp94_);
	_tmp96_ = _tmp95_;
	vala_data_type_set_value_owned (_tmp93_, _tmp96_);
	_tmp97_ = sym;
	vala_symbol_set_used (_tmp97_, TRUE);
	_tmp98_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_GENERIC_TYPE)) {
		ValaDataType* _tmp99_;
		_tmp99_ = type;
		vala_data_type_set_nullable (_tmp99_, TRUE);
	} else {
		ValaDataType* _tmp100_;
		ValaUnresolvedType* _tmp101_;
		gboolean _tmp102_;
		gboolean _tmp103_;
		_tmp100_ = type;
		_tmp101_ = unresolved_type;
		_tmp102_ = vala_data_type_get_nullable ((ValaDataType*) _tmp101_);
		_tmp103_ = _tmp102_;
		vala_data_type_set_nullable (_tmp100_, _tmp103_);
	}
	_tmp104_ = type;
	_tmp105_ = unresolved_type;
	_tmp106_ = vala_data_type_get_is_dynamic ((ValaDataType*) _tmp105_);
	_tmp107_ = _tmp106_;
	vala_data_type_set_is_dynamic (_tmp104_, _tmp107_);
	{
		ValaList* _type_arg_list = NULL;
		ValaUnresolvedType* _tmp108_;
		ValaList* _tmp109_;
		gint _type_arg_size = 0;
		ValaList* _tmp110_;
		gint _tmp111_;
		gint _tmp112_;
		gint _type_arg_index = 0;
		_tmp108_ = unresolved_type;
		_tmp109_ = vala_data_type_get_type_arguments ((ValaDataType*) _tmp108_);
		_type_arg_list = _tmp109_;
		_tmp110_ = _type_arg_list;
		_tmp111_ = vala_collection_get_size ((ValaCollection*) _tmp110_);
		_tmp112_ = _tmp111_;
		_type_arg_size = _tmp112_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp113_;
			gint _tmp114_;
			gint _tmp115_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp116_;
			gint _tmp117_;
			gpointer _tmp118_;
			ValaDataType* _tmp119_;
			ValaDataType* _tmp120_;
			_tmp113_ = _type_arg_index;
			_type_arg_index = _tmp113_ + 1;
			_tmp114_ = _type_arg_index;
			_tmp115_ = _type_arg_size;
			if (!(_tmp114_ < _tmp115_)) {
				break;
			}
			_tmp116_ = _type_arg_list;
			_tmp117_ = _type_arg_index;
			_tmp118_ = vala_list_get (_tmp116_, _tmp117_);
			type_arg = (ValaDataType*) _tmp118_;
			_tmp119_ = type;
			_tmp120_ = type_arg;
			vala_data_type_add_type_argument (_tmp119_, _tmp120_);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	result = type;
	_vala_code_node_unref0 (sym);
	return result;
}


static void vala_symbol_resolver_real_visit_data_type (ValaCodeVisitor* base, ValaDataType* data_type) {
	ValaSymbolResolver * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaUnresolvedType* unresolved_type = NULL;
	ValaDataType* _tmp2_;
	ValaUnresolvedType* _tmp3_;
	ValaUnresolvedType* _tmp4_;
	ValaCodeNode* _tmp5_;
	ValaCodeNode* _tmp6_;
	ValaUnresolvedType* _tmp7_;
	ValaUnresolvedType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (data_type != NULL);
	_tmp0_ = data_type;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
	_tmp1_ = data_type;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_UNRESOLVED_TYPE)) {
		return;
	}
	_tmp2_ = data_type;
	_tmp3_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
	unresolved_type = _tmp3_;
	_tmp4_ = unresolved_type;
	_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = unresolved_type;
	_tmp8_ = unresolved_type;
	_tmp9_ = vala_symbol_resolver_resolve_type (self, _tmp8_);
	_tmp10_ = _tmp9_;
	vala_code_node_replace_type (_tmp6_, (ValaDataType*) _tmp7_, _tmp10_);
	_vala_code_node_unref0 (_tmp10_);
	_vala_code_node_unref0 (unresolved_type);
}


static void vala_symbol_resolver_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt) {
	ValaSymbolResolver * self;
	ValaDeclarationStatement* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local) {
	ValaSymbolResolver * self;
	ValaLocalVariable* _tmp0_;
	ValaCodeContext* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (local != NULL);
	_tmp0_ = local;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_experimental_non_null (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		ValaLocalVariable* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		_tmp4_ = local;
		_tmp5_ = vala_variable_get_variable_type ((ValaVariable*) _tmp4_);
		_tmp6_ = _tmp5_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_REFERENCE_TYPE)) {
			ValaArrayType* array_type = NULL;
			ValaLocalVariable* _tmp7_;
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			ValaArrayType* _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaArrayType* _tmp12_;
			_tmp7_ = local;
			_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp9_) : NULL);
			array_type = _tmp10_;
			_tmp12_ = array_type;
			if (_tmp12_ != NULL) {
				ValaArrayType* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				_tmp13_ = array_type;
				_tmp14_ = vala_array_type_get_fixed_length (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp11_ = _tmp15_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
			} else {
				ValaLocalVariable* _tmp16_;
				ValaDataType* _tmp17_;
				ValaDataType* _tmp18_;
				_tmp16_ = local;
				_tmp17_ = vala_variable_get_variable_type ((ValaVariable*) _tmp16_);
				_tmp18_ = _tmp17_;
				vala_data_type_set_nullable (_tmp18_, TRUE);
			}
			_vala_code_node_unref0 (array_type);
		}
	}
}


static void vala_symbol_resolver_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list) {
	ValaSymbolResolver * self;
	ValaInitializerList* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (list != NULL);
	_tmp0_ = list;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt) {
	ValaSymbolResolver * self;
	ValaExpressionStatement* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt) {
	ValaSymbolResolver * self;
	ValaIfStatement* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt) {
	ValaSymbolResolver * self;
	ValaSwitchStatement* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section) {
	ValaSymbolResolver * self;
	ValaSwitchSection* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (section != NULL);
	_tmp0_ = section;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_switch_label (ValaCodeVisitor* base, ValaSwitchLabel* label) {
	ValaSymbolResolver * self;
	ValaSwitchLabel* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (label != NULL);
	_tmp0_ = label;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_loop (ValaCodeVisitor* base, ValaLoop* stmt) {
	ValaSymbolResolver * self;
	ValaLoop* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt) {
	ValaSymbolResolver * self;
	ValaWhileStatement* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt) {
	ValaSymbolResolver * self;
	ValaDoStatement* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt) {
	ValaSymbolResolver * self;
	ValaForStatement* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt) {
	ValaSymbolResolver * self;
	ValaForeachStatement* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt) {
	ValaSymbolResolver * self;
	ValaReturnStatement* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_yield_statement (ValaCodeVisitor* base, ValaYieldStatement* stmt) {
	ValaSymbolResolver * self;
	ValaYieldStatement* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt) {
	ValaSymbolResolver * self;
	ValaThrowStatement* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt) {
	ValaSymbolResolver * self;
	ValaTryStatement* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_delete_statement (ValaCodeVisitor* base, ValaDeleteStatement* stmt) {
	ValaSymbolResolver * self;
	ValaDeleteStatement* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause) {
	ValaSymbolResolver * self;
	ValaCatchClause* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (clause != NULL);
	_tmp0_ = clause;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* e) {
	ValaSymbolResolver * self;
	ValaArrayCreationExpression* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_template (ValaCodeVisitor* base, ValaTemplate* tmpl) {
	ValaSymbolResolver * self;
	ValaTemplate* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (tmpl != NULL);
	_tmp0_ = tmpl;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_tuple (ValaCodeVisitor* base, ValaTuple* tuple) {
	ValaSymbolResolver * self;
	ValaTuple* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (tuple != NULL);
	_tmp0_ = tuple;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr) {
	ValaSymbolResolver * self;
	ValaMemberAccess* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_method_call (ValaCodeVisitor* base, ValaMethodCall* expr) {
	ValaSymbolResolver * self;
	ValaMethodCall* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr) {
	ValaSymbolResolver * self;
	ValaElementAccess* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_slice_expression (ValaCodeVisitor* base, ValaSliceExpression* expr) {
	ValaSymbolResolver * self;
	ValaSliceExpression* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr) {
	ValaSymbolResolver * self;
	ValaPostfixExpression* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr) {
	ValaSymbolResolver * self;
	ValaObjectCreationExpression* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr) {
	ValaSymbolResolver * self;
	ValaSizeofExpression* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr) {
	ValaSymbolResolver * self;
	ValaTypeofExpression* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr) {
	ValaSymbolResolver * self;
	ValaUnaryExpression* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr) {
	ValaSymbolResolver * self;
	ValaCastExpression* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_named_argument (ValaCodeVisitor* base, ValaNamedArgument* expr) {
	ValaSymbolResolver * self;
	ValaNamedArgument* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr) {
	ValaSymbolResolver * self;
	ValaAddressofExpression* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr) {
	ValaSymbolResolver * self;
	ValaReferenceTransferExpression* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr) {
	ValaSymbolResolver * self;
	ValaBinaryExpression* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr) {
	ValaSymbolResolver * self;
	ValaTypeCheck* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr) {
	ValaSymbolResolver * self;
	ValaConditionalExpression* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l) {
	ValaSymbolResolver * self;
	ValaLambdaExpression* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (l != NULL);
	_tmp0_ = l;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_symbol_resolver_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a) {
	ValaSymbolResolver * self;
	ValaAssignment* _tmp0_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (a != NULL);
	_tmp0_ = a;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


ValaSymbolResolver* vala_symbol_resolver_construct (GType object_type) {
	ValaSymbolResolver* self = NULL;
	self = (ValaSymbolResolver*) vala_code_visitor_construct (object_type);
	return self;
}


ValaSymbolResolver* vala_symbol_resolver_new (void) {
	return vala_symbol_resolver_construct (VALA_TYPE_SYMBOL_RESOLVER);
}


static void vala_symbol_resolver_class_init (ValaSymbolResolverClass * klass) {
	vala_symbol_resolver_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_symbol_resolver_finalize;
	g_type_class_add_private (klass, sizeof (ValaSymbolResolverPrivate));
	((ValaCodeVisitorClass *) klass)->visit_namespace = (void (*) (ValaCodeVisitor *, ValaNamespace*)) vala_symbol_resolver_real_visit_namespace;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor *, ValaClass*)) vala_symbol_resolver_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor *, ValaStruct*)) vala_symbol_resolver_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor *, ValaInterface*)) vala_symbol_resolver_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor *, ValaEnum*)) vala_symbol_resolver_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor *, ValaErrorDomain*)) vala_symbol_resolver_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_delegate = (void (*) (ValaCodeVisitor *, ValaDelegate*)) vala_symbol_resolver_real_visit_delegate;
	((ValaCodeVisitorClass *) klass)->visit_constant = (void (*) (ValaCodeVisitor *, ValaConstant*)) vala_symbol_resolver_real_visit_constant;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor *, ValaField*)) vala_symbol_resolver_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor *, ValaMethod*)) vala_symbol_resolver_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor *, ValaCreationMethod*)) vala_symbol_resolver_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_formal_parameter = (void (*) (ValaCodeVisitor *, ValaParameter*)) vala_symbol_resolver_real_visit_formal_parameter;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor *, ValaProperty*)) vala_symbol_resolver_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_property_accessor = (void (*) (ValaCodeVisitor *, ValaPropertyAccessor*)) vala_symbol_resolver_real_visit_property_accessor;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor *, ValaSignal*)) vala_symbol_resolver_real_visit_signal;
	((ValaCodeVisitorClass *) klass)->visit_constructor = (void (*) (ValaCodeVisitor *, ValaConstructor*)) vala_symbol_resolver_real_visit_constructor;
	((ValaCodeVisitorClass *) klass)->visit_destructor = (void (*) (ValaCodeVisitor *, ValaDestructor*)) vala_symbol_resolver_real_visit_destructor;
	((ValaCodeVisitorClass *) klass)->visit_block = (void (*) (ValaCodeVisitor *, ValaBlock*)) vala_symbol_resolver_real_visit_block;
	((ValaCodeVisitorClass *) klass)->visit_using_directive = (void (*) (ValaCodeVisitor *, ValaUsingDirective*)) vala_symbol_resolver_real_visit_using_directive;
	((ValaCodeVisitorClass *) klass)->visit_data_type = (void (*) (ValaCodeVisitor *, ValaDataType*)) vala_symbol_resolver_real_visit_data_type;
	((ValaCodeVisitorClass *) klass)->visit_declaration_statement = (void (*) (ValaCodeVisitor *, ValaDeclarationStatement*)) vala_symbol_resolver_real_visit_declaration_statement;
	((ValaCodeVisitorClass *) klass)->visit_local_variable = (void (*) (ValaCodeVisitor *, ValaLocalVariable*)) vala_symbol_resolver_real_visit_local_variable;
	((ValaCodeVisitorClass *) klass)->visit_initializer_list = (void (*) (ValaCodeVisitor *, ValaInitializerList*)) vala_symbol_resolver_real_visit_initializer_list;
	((ValaCodeVisitorClass *) klass)->visit_expression_statement = (void (*) (ValaCodeVisitor *, ValaExpressionStatement*)) vala_symbol_resolver_real_visit_expression_statement;
	((ValaCodeVisitorClass *) klass)->visit_if_statement = (void (*) (ValaCodeVisitor *, ValaIfStatement*)) vala_symbol_resolver_real_visit_if_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_statement = (void (*) (ValaCodeVisitor *, ValaSwitchStatement*)) vala_symbol_resolver_real_visit_switch_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_section = (void (*) (ValaCodeVisitor *, ValaSwitchSection*)) vala_symbol_resolver_real_visit_switch_section;
	((ValaCodeVisitorClass *) klass)->visit_switch_label = (void (*) (ValaCodeVisitor *, ValaSwitchLabel*)) vala_symbol_resolver_real_visit_switch_label;
	((ValaCodeVisitorClass *) klass)->visit_loop = (void (*) (ValaCodeVisitor *, ValaLoop*)) vala_symbol_resolver_real_visit_loop;
	((ValaCodeVisitorClass *) klass)->visit_while_statement = (void (*) (ValaCodeVisitor *, ValaWhileStatement*)) vala_symbol_resolver_real_visit_while_statement;
	((ValaCodeVisitorClass *) klass)->visit_do_statement = (void (*) (ValaCodeVisitor *, ValaDoStatement*)) vala_symbol_resolver_real_visit_do_statement;
	((ValaCodeVisitorClass *) klass)->visit_for_statement = (void (*) (ValaCodeVisitor *, ValaForStatement*)) vala_symbol_resolver_real_visit_for_statement;
	((ValaCodeVisitorClass *) klass)->visit_foreach_statement = (void (*) (ValaCodeVisitor *, ValaForeachStatement*)) vala_symbol_resolver_real_visit_foreach_statement;
	((ValaCodeVisitorClass *) klass)->visit_return_statement = (void (*) (ValaCodeVisitor *, ValaReturnStatement*)) vala_symbol_resolver_real_visit_return_statement;
	((ValaCodeVisitorClass *) klass)->visit_yield_statement = (void (*) (ValaCodeVisitor *, ValaYieldStatement*)) vala_symbol_resolver_real_visit_yield_statement;
	((ValaCodeVisitorClass *) klass)->visit_throw_statement = (void (*) (ValaCodeVisitor *, ValaThrowStatement*)) vala_symbol_resolver_real_visit_throw_statement;
	((ValaCodeVisitorClass *) klass)->visit_try_statement = (void (*) (ValaCodeVisitor *, ValaTryStatement*)) vala_symbol_resolver_real_visit_try_statement;
	((ValaCodeVisitorClass *) klass)->visit_delete_statement = (void (*) (ValaCodeVisitor *, ValaDeleteStatement*)) vala_symbol_resolver_real_visit_delete_statement;
	((ValaCodeVisitorClass *) klass)->visit_catch_clause = (void (*) (ValaCodeVisitor *, ValaCatchClause*)) vala_symbol_resolver_real_visit_catch_clause;
	((ValaCodeVisitorClass *) klass)->visit_array_creation_expression = (void (*) (ValaCodeVisitor *, ValaArrayCreationExpression*)) vala_symbol_resolver_real_visit_array_creation_expression;
	((ValaCodeVisitorClass *) klass)->visit_template = (void (*) (ValaCodeVisitor *, ValaTemplate*)) vala_symbol_resolver_real_visit_template;
	((ValaCodeVisitorClass *) klass)->visit_tuple = (void (*) (ValaCodeVisitor *, ValaTuple*)) vala_symbol_resolver_real_visit_tuple;
	((ValaCodeVisitorClass *) klass)->visit_member_access = (void (*) (ValaCodeVisitor *, ValaMemberAccess*)) vala_symbol_resolver_real_visit_member_access;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor *, ValaMethodCall*)) vala_symbol_resolver_real_visit_method_call;
	((ValaCodeVisitorClass *) klass)->visit_element_access = (void (*) (ValaCodeVisitor *, ValaElementAccess*)) vala_symbol_resolver_real_visit_element_access;
	((ValaCodeVisitorClass *) klass)->visit_slice_expression = (void (*) (ValaCodeVisitor *, ValaSliceExpression*)) vala_symbol_resolver_real_visit_slice_expression;
	((ValaCodeVisitorClass *) klass)->visit_postfix_expression = (void (*) (ValaCodeVisitor *, ValaPostfixExpression*)) vala_symbol_resolver_real_visit_postfix_expression;
	((ValaCodeVisitorClass *) klass)->visit_object_creation_expression = (void (*) (ValaCodeVisitor *, ValaObjectCreationExpression*)) vala_symbol_resolver_real_visit_object_creation_expression;
	((ValaCodeVisitorClass *) klass)->visit_sizeof_expression = (void (*) (ValaCodeVisitor *, ValaSizeofExpression*)) vala_symbol_resolver_real_visit_sizeof_expression;
	((ValaCodeVisitorClass *) klass)->visit_typeof_expression = (void (*) (ValaCodeVisitor *, ValaTypeofExpression*)) vala_symbol_resolver_real_visit_typeof_expression;
	((ValaCodeVisitorClass *) klass)->visit_unary_expression = (void (*) (ValaCodeVisitor *, ValaUnaryExpression*)) vala_symbol_resolver_real_visit_unary_expression;
	((ValaCodeVisitorClass *) klass)->visit_cast_expression = (void (*) (ValaCodeVisitor *, ValaCastExpression*)) vala_symbol_resolver_real_visit_cast_expression;
	((ValaCodeVisitorClass *) klass)->visit_named_argument = (void (*) (ValaCodeVisitor *, ValaNamedArgument*)) vala_symbol_resolver_real_visit_named_argument;
	((ValaCodeVisitorClass *) klass)->visit_addressof_expression = (void (*) (ValaCodeVisitor *, ValaAddressofExpression*)) vala_symbol_resolver_real_visit_addressof_expression;
	((ValaCodeVisitorClass *) klass)->visit_reference_transfer_expression = (void (*) (ValaCodeVisitor *, ValaReferenceTransferExpression*)) vala_symbol_resolver_real_visit_reference_transfer_expression;
	((ValaCodeVisitorClass *) klass)->visit_binary_expression = (void (*) (ValaCodeVisitor *, ValaBinaryExpression*)) vala_symbol_resolver_real_visit_binary_expression;
	((ValaCodeVisitorClass *) klass)->visit_type_check = (void (*) (ValaCodeVisitor *, ValaTypeCheck*)) vala_symbol_resolver_real_visit_type_check;
	((ValaCodeVisitorClass *) klass)->visit_conditional_expression = (void (*) (ValaCodeVisitor *, ValaConditionalExpression*)) vala_symbol_resolver_real_visit_conditional_expression;
	((ValaCodeVisitorClass *) klass)->visit_lambda_expression = (void (*) (ValaCodeVisitor *, ValaLambdaExpression*)) vala_symbol_resolver_real_visit_lambda_expression;
	((ValaCodeVisitorClass *) klass)->visit_assignment = (void (*) (ValaCodeVisitor *, ValaAssignment*)) vala_symbol_resolver_real_visit_assignment;
}


static void vala_symbol_resolver_instance_init (ValaSymbolResolver * self) {
	self->priv = VALA_SYMBOL_RESOLVER_GET_PRIVATE (self);
}


static void vala_symbol_resolver_finalize (ValaCodeVisitor * obj) {
	ValaSymbolResolver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SYMBOL_RESOLVER, ValaSymbolResolver);
	_vala_code_context_unref0 (self->priv->context);
	_vala_code_node_unref0 (self->priv->root_symbol);
	_vala_scope_unref0 (self->priv->current_scope);
	VALA_CODE_VISITOR_CLASS (vala_symbol_resolver_parent_class)->finalize (obj);
}


/**
 * Code visitor resolving symbol names.
 */
GType vala_symbol_resolver_get_type (void) {
	static volatile gsize vala_symbol_resolver_type_id__volatile = 0;
	if (g_once_init_enter (&vala_symbol_resolver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSymbolResolverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_symbol_resolver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSymbolResolver), 0, (GInstanceInitFunc) vala_symbol_resolver_instance_init, NULL };
		GType vala_symbol_resolver_type_id;
		vala_symbol_resolver_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaSymbolResolver", &g_define_type_info, 0);
		g_once_init_leave (&vala_symbol_resolver_type_id__volatile, vala_symbol_resolver_type_id);
	}
	return vala_symbol_resolver_type_id__volatile;
}



