#
# Copyright 2017 Pixar
#
# Licensed under the Apache License, Version 2.0 (the "Apache License")
# with the following modification; you may not use this file except in
# compliance with the Apache License and the following modification to it:
# Section 6. Trademarks. is deleted and replaced with:
#
# 6. Trademarks. This License does not grant permission to use the trade
#    names, trademarks, service marks, or product names of the Licensor
#    and its affiliates, except as required to comply with Section 4(c) of
#    the License and to reproduce the content of the NOTICE file.
#
# You may obtain a copy of the Apache License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the Apache License with the above modification is
# distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied. See the Apache License for the specific
# language governing permissions and limitations under the Apache License.
#

# Import a UI file generated by the build to detect which version of PySide to use.
from attributeValueEditorUI import QtCore

if QtCore.__name__.startswith('PySide.'):
    from PySide import QtGui, QtOpenGL
    from PySide import QtGui as QtWidgets

    # Patch missing functions to make PySide look like PySide2
    if not hasattr(QtGui.QApplication, 'devicePixelRatio'):
        QtGui.QApplication.devicePixelRatio = lambda self: 1

    if not hasattr(QtWidgets.QHeaderView, 'setSectionResizeMode'):
        QtWidgets.QHeaderView.setSectionResizeMode = \
            QtWidgets.QHeaderView.setResizeMode

    if not hasattr(QtGui.QMenu, 'setToolTipsVisible'):
        QtGui.QMenu.setToolTipsVisible = lambda self, _: None

    if hasattr(QtGui.QWheelEvent, 'delta') \
        and not hasattr(QtGui.QWheelEvent, 'angleDelta'):
        def angleDelta(self):
            return QtCore.QPoint(0, self.delta())
        QtGui.QWheelEvent.angleDelta = angleDelta

    # Patch missing classes to make PySide look like PySide2
    if not hasattr(QtCore, 'QItemSelectionModel'):
        QtCore.QItemSelectionModel = QtGui.QItemSelectionModel
        
    if not hasattr(QtCore, 'QStringListModel'):
        QtCore.QStringListModel = QtGui.QStringListModel

elif QtCore.__name__.startswith('PySide2.'):
    from PySide2 import QtGui, QtWidgets, QtOpenGL
    
    # Older versions still have QtGui.QStringListModel - this
    # is apparently a bug:
    #    https://bugreports.qt.io/browse/PYSIDE-614
    if not hasattr(QtCore, 'QStringListModel'):
        QtCore.QStringListModel = QtGui.QStringListModel
else:
    raise ImportError()
