//
// Copyright 2016 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//

#line 3 "<stdout>"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 39
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE textFileFormatYyrestart(yyin ,yyscanner )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via textFileFormatYyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void textFileFormatYyrestart (FILE *input_file ,yyscan_t yyscanner );
void textFileFormatYy_switch_to_buffer (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
YY_BUFFER_STATE textFileFormatYy_create_buffer (FILE *file,int size ,yyscan_t yyscanner );
void textFileFormatYy_delete_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void textFileFormatYy_flush_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void textFileFormatYypush_buffer_state (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
void textFileFormatYypop_buffer_state (yyscan_t yyscanner );

static void textFileFormatYyensure_buffer_stack (yyscan_t yyscanner );
static void textFileFormatYy_load_buffer_state (yyscan_t yyscanner );
static void textFileFormatYy_init_buffer (YY_BUFFER_STATE b,FILE *file ,yyscan_t yyscanner );

#define YY_FLUSH_BUFFER textFileFormatYy_flush_buffer(YY_CURRENT_BUFFER ,yyscanner)

YY_BUFFER_STATE textFileFormatYy_scan_buffer (char *base,yy_size_t size ,yyscan_t yyscanner );
YY_BUFFER_STATE textFileFormatYy_scan_string (yyconst char *yy_str ,yyscan_t yyscanner );
YY_BUFFER_STATE textFileFormatYy_scan_bytes (yyconst char *bytes,yy_size_t len ,yyscan_t yyscanner );

void *textFileFormatYyalloc (yy_size_t ,yyscan_t yyscanner );
void *textFileFormatYyrealloc (void *,yy_size_t ,yyscan_t yyscanner );
void textFileFormatYyfree (void * ,yyscan_t yyscanner );

#define yy_new_buffer textFileFormatYy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        textFileFormatYyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            textFileFormatYy_create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        textFileFormatYyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            textFileFormatYy_create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define textFileFormatYywrap(yyscanner) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state (yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  ,yyscan_t yyscanner);
static int yy_get_next_buffer (yyscan_t yyscanner );
static void yy_fatal_error (yyconst char msg[] ,yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 69
#define YY_END_OF_BUFFER 70
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[390] =
    {   0,
        0,    0,    0,    0,   70,   68,    1,    7,    7,   68,
        2,   67,   68,   67,   67,   68,   62,   68,   67,   49,
       49,   68,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,    5,    5,    5,    5,    5,
        1,    7,    0,    0,    0,    2,    0,    0,    0,    0,
       61,   63,    0,   65,    4,    3,   64,   62,    0,    0,
       52,    0,   53,   49,    0,   49,   68,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,    6,   56,   58,    0,    0,   56,    0,   55,

       57,    0,    0,   55,    0,    0,    0,    3,   64,    0,
       64,   53,    0,    0,   51,   49,    8,   49,   49,   49,
       49,   16,   49,   49,   49,   20,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   34,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,    0,    0,    0,
        0,    0,    0,   66,    0,   65,    0,    0,    0,   50,
       51,    0,   24,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   22,   49,   49,   26,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,   50,    0,   49,   10,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   37,   49,
       49,   49,   49,   49,   49,   49,   49,   60,    0,   59,
        0,   54,    0,    9,   11,   49,   13,   49,   17,   49,
       49,   49,   49,   25,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   60,   59,   54,   54,   12,   49,   15,   49,   49,
       49,   49,   27,   49,   49,   30,   49,   49,   49,   35,
       49,   49,   49,   49,   49,   49,   44,   49,   48,   54,

       54,   49,   49,   49,   21,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   47,   54,
       49,   49,   49,   49,   49,   49,   49,   49,   33,   36,
       49,   38,   49,   49,   49,   49,   49,   14,   18,   49,
       49,   28,   49,   31,   32,   49,   49,   49,   49,   49,
       45,   19,   49,   49,   40,   49,   49,   49,   43,   46,
       23,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       42,   49,   49,   41,   49,   49,   29,   39,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    6,    7,    8,    9,    6,    9,   10,    9,
        9,   11,   12,    9,   13,   14,   15,   16,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   18,    9,   19,
        9,   20,    6,   21,   22,   23,   24,   25,   26,   27,
       23,   23,   23,   23,   23,   28,   23,   29,   23,   30,
       23,   23,   31,   23,   32,   23,   23,   23,   23,   23,
        9,   33,    9,    6,   23,    6,   34,   35,   36,   37,

       38,   39,   40,   41,   42,   23,   43,   44,   45,   46,
       47,   48,   23,   49,   50,   51,   52,   53,   23,   54,
       55,   56,    9,    6,    9,    6,    1,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,

        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6
    } ;

static yyconst flex_int32_t yy_meta[57] =
    {   0,
        1,    1,    2,    3,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    5,    5,    6,    7,    4,
        4,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    4,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8
    } ;

static yyconst flex_int16_t yy_base[411] =
    {   0,
        0,    0,   54,   56,  906,  907,   59,  907,  902,   55,
        0,  907,   53,   52,   54,   61,   64,  884,  882,  884,
       56,  855,   59,   57,   73,   64,   55,   61,   66,   74,
       75,   80,   82,   81,   96,  907,  907,  907,  885,  853,
      116,  907,  110,  891,  122,    0,   73,  887,  121,  117,
      122,  130,  850,  124,  907,    0,  135,  149,  164,  875,
      907,  873,  872,  874,  873,  124,  907,  127,  119,  135,
      139,  140,  153,  160,  164,  131,  156,  141,  165,  161,
      166,  170,  171,  173,  175,  177,  176,  188,  180,  183,
      187,  185,  907,  907,  907,  200,  206,  208,  228,  907,

      907,  198,  214,  216,  226,  851,  238,    0,  226,  221,
      228,  907,  225,    0,  871,  222,  870,  230,  235,  238,
      239,  244,  245,  247,  248,  869,  249,  251,  253,  252,
      254,  255,  256,  258,  257,  262,  261,  263,  264,  274,
      268,  289,  271,  275,  276,  277,  291,  304,  879,  316,
      303,  875,  318,  907,  308,  310,  301,  337,  309,  866,
      865,  864,  863,  311,  313,  314,  317,  325,  326,  329,
      327,  330,  332,  862,  335,  344,  861,  336,  334,  342,
      347,  348,  343,  352,  350,  349,  353,  355,  359,  357,
      371,  372,  376,  377,  378,  871,  391,  393,  398,  867,

      392,  394,  403,  413,  436,  858,  857,  392,  856,  390,
      410,  400,  389,  394,  401,  417,  423,  403,  404,  424,
      425,  429,  431,  432,  434,  435,  436,  438,  855,  442,
      441,  443,  444,  445,  449,  446,  448,  907,  865,  907,
      860,  829,  487,  807,  800,  450,  453,  452,  799,  464,
      462,  455,  467,  791,  468,  466,  481,  482,  475,  484,
      486,  489,  493,  495,  496,  497,  500,  502,  503,  504,
      505,  786,  772,  752,  503,  751,  507,  750,  509,  514,
      511,  513,  743,  522,  515,  742,  524,  526,  532,  735,
      533,  534,  535,  536,  538,  541,  734,  540,  727,  907,

      571,  545,  542,  551,  726,  550,  547,  563,  561,  562,
      559,  564,  565,  567,  568,  583,  584,  577,  715,  621,
      586,  588,  589,  590,  594,  595,  598,  600,  714,  712,
      608,  711,  601,  609,  611,  614,  593,  710,  708,  615,
      616,  705,  617,  703,  702,  612,  618,  619,  629,  620,
      623,  699,  631,  637,  697,  638,  635,  642,  695,  693,
      688,  639,  643,  646,  647,  649,  653,  654,  658,  656,
      663,  664,  665,  666,  667,  668,  670,  671,  675,  677,
      686,  678,  679,  685,  681,  684,  346,  198,  907,  734,
      742,  750,  758,  766,  771,  775,  783,  791,  799,  807,

      815,  818,  826,  834,  839,   77,  843,  851,  859,  863
    } ;

static yyconst flex_int16_t yy_def[411] =
    {   0,
      389,    1,  390,  390,  389,  389,  389,  389,  389,  391,
      392,  389,  393,  389,  389,  389,  389,  394,  395,  396,
      396,  389,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  389,  389,  389,  389,  389,
      389,  389,  391,  397,  398,  392,  393,  399,  400,  389,
      389,  389,  389,  389,  389,  401,  389,  389,  389,  394,
      389,  395,  389,  396,  402,  396,  389,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  389,  389,  389,  403,  391,  391,  398,  389,

      389,  404,  393,  393,  400,  389,  389,  401,  389,  389,
      389,  389,  405,  406,  407,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  403,  403,  408,
      404,  404,  409,  389,  389,  389,  405,  405,  405,  410,
      407,  402,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  403,  403,  408,  408,  404,

      404,  409,  409,  405,  405,  410,  389,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  389,  403,  389,
      404,  389,  405,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  403,  404,  389,  405,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  389,

      405,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  405,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
      396,  396,  396,  396,  396,  396,  396,  396,    0,  389,
      389,  389,  389,  389,  389,  389,  389,  389,  389,  389,

      389,  389,  389,  389,  389,  389,  389,  389,  389,  389
    } ;

static yyconst flex_int16_t yy_nxt[964] =
    {   0,
        6,    7,    8,    9,    7,    6,   10,   11,   12,   13,
        6,    6,   14,   15,   16,   17,   17,   12,   18,    6,
       19,   20,   20,   20,   20,   20,   20,   20,   21,   20,
       20,   20,   22,   23,   20,   24,   25,   20,   20,   20,
       20,   26,   27,   20,   20,   28,   29,   30,   31,   32,
       33,   34,   35,   20,   20,   20,   37,   38,   37,   38,
       41,   44,   48,   41,   39,   50,   39,   51,   52,   54,
       54,   55,   65,   65,   65,   56,   65,   57,   65,   58,
       58,   65,  100,   65,  160,   49,   40,   45,   40,   59,
       65,   65,   65,   53,   78,   68,   77,   65,   65,   65,

       70,   59,   66,   71,   79,   49,   69,   81,   72,   76,
       73,   82,   84,   65,   74,   86,   94,   41,   80,   75,
       41,   85,   83,   90,   47,   43,   91,   87,   98,   92,
      104,   88,   54,   54,   89,   57,   65,   52,   52,   54,
       54,   65,   45,   57,   65,   52,   52,   59,   65,  107,
      109,  109,   65,  105,   99,   59,   65,   65,   65,   59,
       59,  107,   57,  117,   58,   58,  118,   59,  119,  116,
       65,  127,   59,   65,   59,  110,  110,   65,   65,  111,
      111,   65,   65,   65,  120,  129,   59,   65,   65,  121,
       65,  122,   65,   65,   65,  124,  123,   65,  131,  126,

       65,  128,   65,  130,   65,   65,  149,  152,  134,  125,
      140,  136,   94,  141,   94,   65,  137,  135,  133,  138,
      132,  139,  142,  100,  144,  100,  143,  145,  146,   47,
      153,   43,  150,  147,   98,  104,  111,  111,   45,   65,
       45,  109,  109,  111,  111,  158,   49,   65,   49,  155,
      155,   59,   65,  156,  156,   65,   65,  159,  105,  163,
       99,   65,   65,   59,   65,   65,   65,  164,   65,   65,
       65,   65,   65,   65,   65,   65,  166,  169,   65,   65,
       65,   65,  170,  167,  165,   65,  173,  174,   65,  168,
      175,   65,   65,   65,   65,  172,  180,  171,  178,  183,

      179,  176,  177,  188,  182,  181,   65,  184,   65,  190,
      149,  185,  152,  192,  186,  193,  189,  187,  148,  191,
      151,  158,  198,  156,  156,  156,  156,  202,   65,  205,
       65,   65,  194,  159,   65,  153,  150,  157,  157,  157,
      157,  159,   65,   65,   65,  195,   65,   65,  199,   65,
      203,   65,   65,   65,  211,  210,  208,  204,  218,   65,
       65,   65,  209,   65,   65,   65,   65,   65,  215,   65,
       65,  212,   65,  216,   65,  221,   65,  213,  228,  214,
      217,  219,  220,  222,  223,  224,  227,  226,   65,   65,
      229,  225,  231,   65,   65,   65,  230,  149,  232,  239,

      148,  152,  234,  241,  198,  151,   65,   65,  233,   65,
      236,   65,  202,  157,  157,  157,  157,   65,   65,  237,
       65,   65,  235,  150,  153,  199,  203,   65,  244,  245,
      199,  249,  248,  242,   65,  203,  157,  157,  157,  157,
       65,   65,   65,  253,  247,  246,   65,  250,   65,   65,
      251,   65,   65,   65,  254,   65,  243,  255,   65,   65,
       65,   65,   65,   65,  252,   65,   65,   65,  261,   65,
       65,  260,   65,  262,  256,  264,  258,  277,  268,   65,
      259,   65,  257,   65,   65,   65,  263,  157,  157,  157,
      157,  270,   65,  271,  267,  265,  266,  269,   65,   65,

      276,   65,  278,   65,  283,  281,   65,  275,  282,  279,
       65,  285,   65,   65,   65,  284,  280,   65,  286,   65,
       65,   65,   65,  301,   65,  287,   65,  294,   65,  288,
       65,   65,   65,  293,  291,  159,  289,  290,  292,   65,
      302,   65,  303,   65,  299,  304,  296,  297,  295,   65,
       65,   65,   65,   65,  298,   65,  306,   65,   65,   65,
      305,  310,   65,  307,   65,  309,  308,   65,   65,  311,
      318,  157,  157,  157,  157,  313,   65,  312,   65,   65,
       65,   65,   65,  314,   65,   65,  324,  315,  317,  319,
      322,  320,  316,  325,   65,  321,  323,  326,  327,  328,

       65,   65,  333,   65,  334,   65,   65,   65,  329,  335,
       65,   65,   65,  330,  337,   65,  332,   65,   65,  338,
      331,  157,  157,  157,  157,   65,   65,  336,   65,   65,
      340,   65,   65,   65,   65,   65,   65,   65,  341,  342,
       65,  242,  339,  351,  343,  346,   65,  344,   65,  345,
      347,  350,   65,  353,   65,   65,   65,  348,  357,   65,
       65,  355,  349,   65,   65,  352,   65,  354,  356,  359,
       65,   65,  360,   65,  358,   65,  361,  365,  362,  363,
       65,   65,   65,   65,   65,   65,  364,   65,   65,  366,
      368,  372,   65,  367,   65,   65,   65,  369,   65,  373,

      370,   65,   65,   65,  371,   65,  374,  378,  379,  376,
       65,  377,   65,  375,   65,  381,   65,  382,  380,   65,
       65,  383,   65,  385,  386,   65,  384,   65,   65,   65,
      387,   65,   65,  388,   36,   36,   36,   36,   36,   36,
       36,   36,   43,   65,   65,   43,   43,   43,   43,   43,
       46,   65,   65,   46,   46,   46,   46,   46,   47,   65,
       65,   47,   47,   47,   47,   47,   60,   65,   65,   60,
       60,   60,  300,   60,   62,   62,   62,   62,   62,   64,
       64,  240,   64,   95,   95,   95,   95,   95,   95,   95,
       95,   97,  238,   97,   97,   97,   97,   97,   97,  101,

      101,  101,  101,  101,  101,  101,  101,  103,   65,  103,
      103,  103,  103,  103,  103,  108,   65,   65,  108,  108,
      108,  108,  108,  115,   65,  115,  148,  148,  148,  148,
      148,  148,  148,  148,  151,  151,  151,  151,  151,  151,
      151,  151,  157,  157,  157,  157,  157,  161,  161,  274,
      161,  197,  197,  197,  197,  197,  197,  197,  197,  201,
      201,  201,  201,  201,  201,  201,  201,  206,  206,  273,
      206,  272,   65,   65,  114,  207,  240,  238,   65,   65,
       65,  389,  162,  207,  200,  196,   65,   65,  162,  154,
      114,   65,  113,  112,   61,  106,  102,   96,   67,   93,

       67,   65,   63,   61,   42,  389,    5,  389,  389,  389,
      389,  389,  389,  389,  389,  389,  389,  389,  389,  389,
      389,  389,  389,  389,  389,  389,  389,  389,  389,  389,
      389,  389,  389,  389,  389,  389,  389,  389,  389,  389,
      389,  389,  389,  389,  389,  389,  389,  389,  389,  389,
      389,  389,  389,  389,  389,  389,  389,  389,  389,  389,
      389,  389,  389
    } ;

static yyconst flex_int16_t yy_chk[964] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    3,    3,    4,    4,
        7,   10,   13,    7,    3,   14,    4,   14,   14,   15,
       15,   16,   27,   21,   24,   16,   23,   17,   28,   17,
       17,   26,   47,   29,  406,   13,    3,   10,    4,   17,
       25,   30,   31,   14,   28,   23,   27,   32,   34,   33,

       24,   17,   21,   24,   29,   47,   23,   30,   24,   26,
       25,   30,   31,   35,   25,   32,   43,   41,   29,   25,
       41,   31,   30,   33,   49,   45,   34,   32,   45,   35,
       49,   32,   50,   50,   32,   51,   69,   51,   51,   54,
       54,   66,   43,   52,   68,   52,   52,   51,   76,   54,
       57,   57,   70,   49,   45,   52,   71,   72,   78,   51,
       57,   54,   58,   68,   58,   58,   69,   52,   70,   66,
       73,   76,   57,   77,   58,   59,   59,   74,   80,   59,
       59,   75,   79,   81,   71,   78,   58,   82,   83,   72,
       84,   73,   85,   87,   86,   74,   73,   89,   80,   75,

       90,   77,   92,   79,   91,   88,   96,  102,   83,   74,
       86,   84,   97,   87,   98,  388,   84,   83,   82,   84,
       81,   85,   88,  103,   89,  104,   88,   90,   91,  105,
      102,   99,   96,   92,   99,  105,  110,  110,   97,  116,
       98,  109,  109,  111,  111,  113,  103,  118,  104,  107,
      107,  109,  119,  107,  107,  120,  121,  113,  105,  116,
       99,  122,  123,  109,  124,  125,  127,  118,  128,  130,
      129,  131,  132,  133,  135,  134,  120,  122,  137,  136,
      138,  139,  123,  120,  119,  141,  127,  128,  143,  121,
      129,  140,  144,  145,  146,  125,  134,  124,  132,  136,

      133,  130,  131,  141,  135,  134,  142,  137,  147,  143,
      148,  138,  151,  145,  139,  146,  142,  140,  150,  144,
      153,  157,  150,  155,  155,  156,  156,  153,  164,  159,
      165,  166,  147,  157,  167,  151,  148,  158,  158,  158,
      158,  159,  168,  169,  171,  147,  170,  172,  150,  173,
      153,  179,  175,  178,  167,  166,  164,  158,  175,  180,
      183,  176,  165,  387,  181,  182,  186,  185,  171,  184,
      187,  168,  188,  172,  190,  179,  189,  169,  186,  170,
      173,  176,  178,  180,  181,  182,  185,  184,  191,  192,
      187,  183,  189,  193,  194,  195,  188,  197,  190,  198,

      199,  201,  192,  202,  199,  203,  213,  210,  191,  208,
      194,  214,  203,  204,  204,  204,  204,  212,  215,  195,
      218,  219,  193,  197,  201,  198,  202,  211,  208,  210,
      199,  214,  213,  204,  216,  203,  205,  205,  205,  205,
      217,  220,  221,  218,  212,  211,  222,  215,  223,  224,
      216,  225,  226,  227,  219,  228,  205,  220,  231,  230,
      232,  233,  234,  236,  217,  237,  235,  246,  226,  248,
      247,  225,  252,  227,  221,  230,  223,  247,  234,  251,
      224,  250,  222,  256,  253,  255,  228,  243,  243,  243,
      243,  236,  259,  237,  233,  231,  232,  235,  257,  258,

      246,  260,  248,  261,  255,  252,  262,  243,  253,  250,
      263,  257,  264,  265,  266,  256,  251,  267,  258,  268,
      269,  270,  271,  275,  277,  259,  279,  266,  281,  260,
      282,  280,  285,  265,  263,  275,  261,  262,  264,  284,
      277,  287,  279,  288,  271,  280,  268,  269,  267,  289,
      291,  292,  293,  294,  270,  295,  282,  298,  296,  303,
      281,  288,  302,  284,  307,  287,  285,  306,  304,  289,
      298,  301,  301,  301,  301,  292,  311,  291,  309,  310,
      308,  312,  313,  293,  314,  315,  306,  294,  296,  298,
      303,  301,  295,  307,  318,  302,  304,  308,  309,  310,

      316,  317,  315,  321,  316,  322,  323,  324,  311,  316,
      337,  325,  326,  312,  318,  327,  314,  328,  333,  321,
      313,  320,  320,  320,  320,  331,  334,  317,  335,  346,
      323,  336,  340,  341,  343,  347,  348,  350,  324,  325,
      351,  320,  322,  337,  326,  331,  349,  327,  353,  328,
      333,  336,  357,  341,  354,  356,  362,  334,  348,  358,
      363,  346,  335,  364,  365,  340,  366,  343,  347,  350,
      367,  368,  351,  370,  349,  369,  353,  358,  354,  356,
      371,  372,  373,  374,  375,  376,  357,  377,  378,  362,
      364,  368,  379,  363,  380,  382,  383,  365,  385,  369,

      366,  386,  384,  381,  367,  361,  370,  374,  375,  372,
      360,  373,  359,  371,  355,  377,  352,  378,  376,  345,
      344,  379,  342,  382,  383,  339,  380,  338,  332,  330,
      385,  329,  319,  386,  390,  390,  390,  390,  390,  390,
      390,  390,  391,  305,  299,  391,  391,  391,  391,  391,
      392,  297,  290,  392,  392,  392,  392,  392,  393,  286,
      283,  393,  393,  393,  393,  393,  394,  278,  276,  394,
      394,  394,  274,  394,  395,  395,  395,  395,  395,  396,
      396,  273,  396,  397,  397,  397,  397,  397,  397,  397,
      397,  398,  272,  398,  398,  398,  398,  398,  398,  399,

      399,  399,  399,  399,  399,  399,  399,  400,  254,  400,
      400,  400,  400,  400,  400,  401,  249,  245,  401,  401,
      401,  401,  401,  402,  244,  402,  403,  403,  403,  403,
      403,  403,  403,  403,  404,  404,  404,  404,  404,  404,
      404,  404,  405,  405,  405,  405,  405,  407,  407,  242,
      407,  408,  408,  408,  408,  408,  408,  408,  408,  409,
      409,  409,  409,  409,  409,  409,  409,  410,  410,  241,
      410,  239,  229,  209,  207,  206,  200,  196,  177,  174,
      163,  162,  161,  160,  152,  149,  126,  117,  115,  106,
       65,   64,   63,   62,   60,   53,   48,   44,   40,   39,

       22,   20,   19,   18,    9,    5,  389,  389,  389,  389,
      389,  389,  389,  389,  389,  389,  389,  389,  389,  389,
      389,  389,  389,  389,  389,  389,  389,  389,  389,  389,
      389,  389,  389,  389,  389,  389,  389,  389,  389,  389,
      389,  389,  389,  389,  389,  389,  389,  389,  389,  389,
      389,  389,  389,  389,  389,  389,  389,  389,  389,  389,
      389,  389,  389
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "pxr/usd/sdf/textFileFormat.ll"
#line 2 "pxr/usd/sdf/textFileFormat.ll"
//
// Copyright 2016 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//

#include "pxr/pxr.h"
#include "pxr/base/arch/fileSystem.h"
#include "pxr/base/tf/stringUtils.h"
#include "pxr/usd/sdf/textParserContext.h"
#include "pxr/usd/sdf/parserHelpers.h"

// Token table from yacc file
#include "textFileFormat.tab.h"

#ifndef fileno
#define fileno(fd) ArchFileNo(fd)
#endif
#ifndef isatty
#define isatty(fd) ArchFileIsaTTY(fd)
#endif

using std::map;
using std::vector;

PXR_NAMESPACE_USING_DIRECTIVE

#define YYSTYPE Sdf_ParserHelpers::Value

// As a pure parser, we must define the following
#define YY_DECL int textFileFormatYylex(YYSTYPE *yylval_param, yyscan_t yyscanner)

// The context object will be used to store global state for the parser.
#define YY_EXTRA_TYPE Sdf_TextParserContext *

/* Configuration options for flex */
/* States */

#line 834 "<stdout>"

#define INITIAL 0
#define SLASHTERIX_COMMENT 1

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    yy_size_t yy_n_chars;
    yy_size_t yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    }; /* end struct yyguts_t */

static int yy_init_globals (yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
int textFileFormatYylex_init (yyscan_t* scanner);

int textFileFormatYylex_init_extra (YY_EXTRA_TYPE user_defined,yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int textFileFormatYylex_destroy (yyscan_t yyscanner );

int textFileFormatYyget_debug (yyscan_t yyscanner );

void textFileFormatYyset_debug (int debug_flag ,yyscan_t yyscanner );

YY_EXTRA_TYPE textFileFormatYyget_extra (yyscan_t yyscanner );

void textFileFormatYyset_extra (YY_EXTRA_TYPE user_defined ,yyscan_t yyscanner );

FILE *textFileFormatYyget_in (yyscan_t yyscanner );

void textFileFormatYyset_in  (FILE * in_str ,yyscan_t yyscanner );

FILE *textFileFormatYyget_out (yyscan_t yyscanner );

void textFileFormatYyset_out  (FILE * out_str ,yyscan_t yyscanner );

yy_size_t textFileFormatYyget_leng (yyscan_t yyscanner );

char *textFileFormatYyget_text (yyscan_t yyscanner );

int textFileFormatYyget_lineno (yyscan_t yyscanner );

void textFileFormatYyset_lineno (int line_number ,yyscan_t yyscanner );

int textFileFormatYyget_column  (yyscan_t yyscanner );

void textFileFormatYyset_column (int column_no ,yyscan_t yyscanner );

YYSTYPE * textFileFormatYyget_lval (yyscan_t yyscanner );

void textFileFormatYyset_lval (YYSTYPE * yylval_param ,yyscan_t yyscanner );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int textFileFormatYywrap (yyscan_t yyscanner );
#else
extern int textFileFormatYywrap (yyscan_t yyscanner );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int ,yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * ,yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (yyscan_t yyscanner );
#else
static int input (yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int textFileFormatYylex \
               (YYSTYPE * yylval_param ,yyscan_t yyscanner);

#define YY_DECL int textFileFormatYylex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			textFileFormatYyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				textFileFormatYy_create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
		}

		textFileFormatYy_load_buffer_state(yyscanner );
		}

	{
#line 66 "pxr/usd/sdf/textFileFormat.ll"


    /* skip over whitespace and comments */
    /* handle the first line # comment specially, since it contains the
       magic token */
#line 1105 "<stdout>"

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				yyg->yy_last_accepting_state = yy_current_state;
				yyg->yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 390 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 907 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yyg->yy_hold_char;
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 71 "pxr/usd/sdf/textFileFormat.ll"
{}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 72 "pxr/usd/sdf/textFileFormat.ll"
{
        if (yyextra->menvaLineNo == 1) {
            (*yylval_param) = std::string(yytext, yyleng);
            return TOK_MAGIC;
        }
    }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 78 "pxr/usd/sdf/textFileFormat.ll"
{}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 79 "pxr/usd/sdf/textFileFormat.ll"
BEGIN SLASHTERIX_COMMENT ;
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 80 "pxr/usd/sdf/textFileFormat.ll"
;
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 81 "pxr/usd/sdf/textFileFormat.ll"
BEGIN INITIAL ;
	YY_BREAK
/* newline is returned as TOK_NL
     * Note that newlines embedded in quoted strings and tuples are counted
     * as part of the token and do NOT emit a separate TOK_NL.
     */
case 7:
/* rule 7 can match eol */
YY_RULE_SETUP
#line 87 "pxr/usd/sdf/textFileFormat.ll"
{
        yyextra->menvaLineNo++;
        return TOK_NL;
    }
	YY_BREAK
/* literal keywords.  we return the yytext so that the yacc grammar
       can make use of it. */
case 8:
YY_RULE_SETUP
#line 94 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_ADD; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 95 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_APPEND; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 96 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_CLASS; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 97 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_CONFIG; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 98 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_CONNECT; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 99 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_CUSTOM; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 100 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_CUSTOMDATA; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 101 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_DEFAULT; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 102 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_DEF; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 103 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_DELETE; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 104 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_DICTIONARY; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 105 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_DISPLAYUNIT; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 106 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_DOC; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 107 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_INHERITS; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 108 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_KIND; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 109 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_NAMECHILDREN; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 110 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_NONE; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 111 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_OFFSET; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 112 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_OVER; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 113 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_PAYLOAD; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 114 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_PERMISSION; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 115 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_PREFIX_SUBSTITUTIONS; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 116 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_PREPEND; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 117 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_PROPERTIES; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 118 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_REFERENCES; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 119 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_RELOCATES; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 120 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_REL; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 121 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_REORDER; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 122 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_ROOTPRIMS; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 123 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_SCALE; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 124 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_SUBLAYERS; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 125 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_SUFFIX_SUBSTITUTIONS; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 126 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_SPECIALIZES; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 127 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_SYMMETRYARGUMENTS; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 128 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_SYMMETRYFUNCTION; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 129 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_TIME_SAMPLES; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 130 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_UNIFORM; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 131 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_VARIANTSET; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 132 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_VARIANTSETS; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 133 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_VARIANTS; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 134 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_VARYING; }
	YY_BREAK
/* unquoted C/Python identifier */
case 49:
YY_RULE_SETUP
#line 137 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = std::string(yytext, yyleng);
        return TOK_IDENTIFIER;
    }
	YY_BREAK
/* unquoted C++ namespaced identifier -- see bug 10775 */
case 50:
YY_RULE_SETUP
#line 143 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = std::string(yytext, yyleng);
        return TOK_CXX_NAMESPACED_IDENTIFIER;
    }
	YY_BREAK
/* unquoted namespaced identifier.  matches any number of colon
     * delimited C/Python identifiers */
case 51:
YY_RULE_SETUP
#line 150 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = std::string(yytext, yyleng);
        return TOK_NAMESPACED_IDENTIFIER;
    }
	YY_BREAK
/* scene paths */
case 52:
YY_RULE_SETUP
#line 156 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = Sdf_EvalQuotedString(yytext, yyleng, 1);
        return TOK_PATHREF;
    }
	YY_BREAK
/* Single '@'-delimited asset references */
case 53:
YY_RULE_SETUP
#line 162 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = 
            Sdf_EvalAssetPath(yytext, yyleng, /* tripleDelimited = */ false);
        return TOK_ASSETREF;
    }
	YY_BREAK
/* Triple '@'-delimited asset references. */
case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
#line 169 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = 
            Sdf_EvalAssetPath(yytext, yyleng, /* tripleDelimited = */ true);
        return TOK_ASSETREF;
    }
	YY_BREAK
/* Singly quoted, single line strings with escapes.
       Note: we handle empty singly quoted strings below, to disambiguate
       them from the beginning of triply-quoted strings.
       Ex: "Foo \"foo\"" */
case 55:
#line 180 "pxr/usd/sdf/textFileFormat.ll"
case 56:
YY_RULE_SETUP
#line 180 "pxr/usd/sdf/textFileFormat.ll"
{  /* " //<- unfreak out coloring code */
        (*yylval_param) = Sdf_EvalQuotedString(yytext, yyleng, 1);
        return TOK_STRING;
    }
	YY_BREAK
/* Empty singly quoted strings that aren't the beginning of
       a triply-quoted string. */
case 57:
/* rule 57 can match eol */
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_bp + 2);
yyg->yy_c_buf_p = yy_cp = yy_bp + 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 187 "pxr/usd/sdf/textFileFormat.ll"
{  /* ' // <- keep syntax coloring from freaking out */
        (*yylval_param) = std::string();
        return TOK_STRING;
    }
	YY_BREAK
case 58:
/* rule 58 can match eol */
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_bp + 2);
yyg->yy_c_buf_p = yy_cp = yy_bp + 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 191 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = std::string();
        return TOK_STRING;
    }
	YY_BREAK
/* Triply quoted, multi-line strings with escapes.
       Ex: """A\n\"B\"\nC""" */
case 59:
/* rule 59 can match eol */
#line 199 "pxr/usd/sdf/textFileFormat.ll"
case 60:
/* rule 60 can match eol */
YY_RULE_SETUP
#line 199 "pxr/usd/sdf/textFileFormat.ll"
{  /* " //<- unfreak out coloring code */

        unsigned int numlines = 0;
        (*yylval_param) = Sdf_EvalQuotedString(yytext, yyleng, 3, &numlines);
        yyextra->menvaLineNo += numlines;
        return TOK_STRING;
    }
	YY_BREAK
/* Super special case for negative 0.  We have to store this as a double to
     * preserve the sign.  There is no negative zero integral value, and we
     * don't know at this point what the final stored type will be. */
case 61:
YY_RULE_SETUP
#line 210 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = double(-0.0);
        return TOK_NUMBER;
   }
	YY_BREAK
/* Positive integers: store as uint64_t if in range, otherwise double. */
case 62:
YY_RULE_SETUP
#line 216 "pxr/usd/sdf/textFileFormat.ll"
{
        bool outOfRange = false;
        (*yylval_param) = TfStringToUInt64(yytext, &outOfRange);
        if (outOfRange) {
           TF_WARN("Integer literal '%s' on line %d%s%s out of range, parsing "
                   "as double.  Consider exponential notation for large "
                   "floating point values.", yytext, yyextra->menvaLineNo,
                   yyextra->fileContext.empty() ? "" : " in file ",
                   yyextra->fileContext.empty() ? "" :
                   yyextra->fileContext.c_str());
           (*yylval_param) = TfStringToDouble(yytext);
        }
        return TOK_NUMBER;
    }
	YY_BREAK
/* Negative integers: store as long. */
case 63:
YY_RULE_SETUP
#line 232 "pxr/usd/sdf/textFileFormat.ll"
{
        bool outOfRange = false;
        (*yylval_param) = TfStringToInt64(yytext, &outOfRange);
        if (outOfRange) {
           TF_WARN("Integer literal '%s' on line %d%s%s out of range, parsing "
                   "as double.  Consider exponential notation for large "
                   "floating point values.", yytext, yyextra->menvaLineNo,
                   yyextra->fileContext.empty() ? "" : " in file ",
                   yyextra->fileContext.empty() ? "" :
                   yyextra->fileContext.c_str());
           (*yylval_param) = TfStringToDouble(yytext);
        }
        return TOK_NUMBER;
    }
	YY_BREAK
/* Numbers with decimal places or exponents: store as double. */
case 64:
#line 249 "pxr/usd/sdf/textFileFormat.ll"
case 65:
YY_RULE_SETUP
#line 249 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = TfStringToDouble(yytext);
        return TOK_NUMBER;
    }
	YY_BREAK
/* regexps for negative infinity.  we don't handle inf and nan here
     * because they look like identifiers.  we handle them in parser where
     * we have the additional context we need to distinguish them from
     * identifiers. */
case 66:
YY_RULE_SETUP
#line 258 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = -std::numeric_limits<double>::infinity();
        return TOK_NUMBER;
    }
	YY_BREAK
/* various single-character punctuation.  return the character
     * itself as the token.
     */
case 67:
YY_RULE_SETUP
#line 266 "pxr/usd/sdf/textFileFormat.ll"
{
        return yytext[0];
    }
	YY_BREAK
/* the default rule is to ECHO any unmatched character.  by returning a
     * token that the parser does not know how to handle these become syntax
     * errors instead.
     */
case 68:
YY_RULE_SETUP
#line 274 "pxr/usd/sdf/textFileFormat.ll"
{
        return TOK_SYNTAX_ERROR;
    }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 278 "pxr/usd/sdf/textFileFormat.ll"
ECHO;
	YY_BREAK
#line 1633 "<stdout>"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(SLASHTERIX_COMMENT):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * textFileFormatYylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( textFileFormatYywrap(yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of textFileFormatYylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = yyg->yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					textFileFormatYyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2 ,yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			textFileFormatYyrestart(yyin  ,yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) (yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) textFileFormatYyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size ,yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yyg->yy_last_accepting_state = yy_current_state;
			yyg->yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 390 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	register int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */
	register char *yy_cp = yyg->yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yyg->yy_last_accepting_state = yy_current_state;
		yyg->yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 390 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 389);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			yy_size_t offset = yyg->yy_c_buf_p - yyg->yytext_ptr;
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					textFileFormatYyrestart(yyin ,yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( textFileFormatYywrap(yyscanner ) )
						return EOF;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void textFileFormatYyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        textFileFormatYyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            textFileFormatYy_create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
	}

	textFileFormatYy_init_buffer(YY_CURRENT_BUFFER,input_file ,yyscanner);
	textFileFormatYy_load_buffer_state(yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void textFileFormatYy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		textFileFormatYypop_buffer_state();
	 *		textFileFormatYypush_buffer_state(new_buffer);
     */
	textFileFormatYyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	textFileFormatYy_load_buffer_state(yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (textFileFormatYywrap()) processing, but the only time this flag
	 * is looked at is after textFileFormatYywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void textFileFormatYy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE textFileFormatYy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) textFileFormatYyalloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in textFileFormatYy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) textFileFormatYyalloc(b->yy_buf_size + 2 ,yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in textFileFormatYy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	textFileFormatYy_init_buffer(b,file ,yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with textFileFormatYy_create_buffer()
 * @param yyscanner The scanner object.
 */
    void textFileFormatYy_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		textFileFormatYyfree((void *) b->yy_ch_buf ,yyscanner );

	textFileFormatYyfree((void *) b ,yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a textFileFormatYyrestart() or at EOF.
 */
    static void textFileFormatYy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	textFileFormatYy_flush_buffer(b ,yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then textFileFormatYy_init_buffer was _probably_
     * called from textFileFormatYyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void textFileFormatYy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		textFileFormatYy_load_buffer_state(yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void textFileFormatYypush_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	textFileFormatYyensure_buffer_stack(yyscanner);

	/* This block is copied from textFileFormatYy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from textFileFormatYy_switch_to_buffer. */
	textFileFormatYy_load_buffer_state(yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void textFileFormatYypop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	textFileFormatYy_delete_buffer(YY_CURRENT_BUFFER ,yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		textFileFormatYy_load_buffer_state(yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void textFileFormatYyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)textFileFormatYyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in textFileFormatYyensure_buffer_stack()" );
								  
		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)textFileFormatYyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in textFileFormatYyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE textFileFormatYy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) textFileFormatYyalloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in textFileFormatYy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	textFileFormatYy_switch_to_buffer(b ,yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to textFileFormatYylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       textFileFormatYy_scan_bytes() instead.
 */
YY_BUFFER_STATE textFileFormatYy_scan_string (yyconst char * yystr , yyscan_t yyscanner)
{
    
	return textFileFormatYy_scan_bytes(yystr,strlen(yystr) ,yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to textFileFormatYylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE textFileFormatYy_scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	yy_size_t i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) textFileFormatYyalloc(n ,yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in textFileFormatYy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = textFileFormatYy_scan_buffer(buf,n ,yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in textFileFormatYy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg , yyscan_t yyscanner)
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE textFileFormatYyget_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int textFileFormatYyget_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int textFileFormatYyget_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *textFileFormatYyget_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *textFileFormatYyget_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
yy_size_t textFileFormatYyget_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *textFileFormatYyget_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void textFileFormatYyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void textFileFormatYyset_lineno (int  line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "textFileFormatYyset_lineno called with no buffer" );
    
    yylineno = line_number;
}

/** Set the current column.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void textFileFormatYyset_column (int  column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "textFileFormatYyset_column called with no buffer" );
    
    yycolumn = column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see textFileFormatYy_switch_to_buffer
 */
void textFileFormatYyset_in (FILE *  in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = in_str ;
}

void textFileFormatYyset_out (FILE *  out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = out_str ;
}

int textFileFormatYyget_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void textFileFormatYyset_debug (int  bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * textFileFormatYyget_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void textFileFormatYyset_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

/* User-visible API */

/* textFileFormatYylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */

int textFileFormatYylex_init(yyscan_t* ptr_yy_globals)

{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) textFileFormatYyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* textFileFormatYylex_init_extra has the same functionality as textFileFormatYylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to textFileFormatYyalloc in
 * the yyextra field.
 */

int textFileFormatYylex_init_extra(YY_EXTRA_TYPE yy_user_defined,yyscan_t* ptr_yy_globals )

{
    struct yyguts_t dummy_yyguts;

    textFileFormatYyset_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }
	
    *ptr_yy_globals = (yyscan_t) textFileFormatYyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );
	
    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }
    
    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));
    
    textFileFormatYyset_extra (yy_user_defined, *ptr_yy_globals);
    
    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from textFileFormatYylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = 0;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = (char *) 0;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * textFileFormatYylex_init()
     */
    return 0;
}

/* textFileFormatYylex_destroy is for both reentrant and non-reentrant scanners. */
int textFileFormatYylex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		textFileFormatYy_delete_buffer(YY_CURRENT_BUFFER ,yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		textFileFormatYypop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	textFileFormatYyfree(yyg->yy_buffer_stack ,yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        textFileFormatYyfree(yyg->yy_start_stack ,yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * textFileFormatYylex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    textFileFormatYyfree ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n , yyscan_t yyscanner)
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s , yyscan_t yyscanner)
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *textFileFormatYyalloc (yy_size_t  size , yyscan_t yyscanner)
{
	return (void *) malloc( size );
}

void *textFileFormatYyrealloc  (void * ptr, yy_size_t  size , yyscan_t yyscanner)
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void textFileFormatYyfree (void * ptr , yyscan_t yyscanner)
{
	free( (char *) ptr );	/* see textFileFormatYyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 278 "pxr/usd/sdf/textFileFormat.ll"



