/* arm.v4a-linux.elf-fold.h
   created from arm.v4a-linux.elf-fold.bin, 6560 (0x19a0) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2023 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2023 Laszlo Molnar
   Copyright (C) 2000-2023 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_ARM_V4A_LINUX_ELF_FOLD_SIZE    6560
#define STUB_ARM_V4A_LINUX_ELF_FOLD_ADLER32 0xb3c5a41d
#define STUB_ARM_V4A_LINUX_ELF_FOLD_CRC32   0xd438b2fd

unsigned char stub_arm_v4a_linux_elf_fold[6560] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 40,  0,  1,  0,  0,  0, 64,128,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   8, 11,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   7,  0,  4,  0, 34,  0,  0,  0,192, 31,189,232, 13, 16,160,225,
/* 0x0040 */   1,218, 77,226, 13,  0,160,225,240, 31, 45,233,  4, 48,145,228,
/* 0x0050 */   0,  0, 83,227,  4, 48,128,228,  4,  0,  0, 26,  0, 64,160,225,
/* 0x0060 */   4, 48,128,228,  4, 48,145,228,  0,  0, 83,227,  4, 48,128,228,
/* 0x0070 */  10,  0,  0, 26,  1, 80,160,225, 12,  0,177,232,  0,  0, 82,227,
/* 0x0080 */  12,  0,160,232, 15,  0,  0, 26,  1, 96,160,225,  0,144,160,225,
/* 0x0090 */   1, 42,160,227,  0, 16,160,225, 14,  0,160,225,  1, 32, 66,226,
/* 0x00a0 */ 254,255,255,235,  1, 10,112,227, 14, 16,160, 33, 14,  0,160, 35,
/* 0x00b0 */   0, 32,129,224,  6,  0,160,225,  0, 48,160,227,  1, 48, 96,229,
/* 0x00c0 */   1, 48,114,229,  1, 48, 96,229,  2,  0, 81,225, 33,  0,  0, 26,
/* 0x00d0 */  61, 48,160,227,  1, 48, 96,229, 32, 48,160,227,  1, 48, 96,229,
/* 0x00e0 */   1, 48, 96,229,  1, 48, 96,229,  0,  0,132,229, 32,  1,160,225,
/* 0x00f0 */   0,  1,160,225,  0, 48, 38,224,  4, 48,  3,226,  4, 48, 35,226,
/* 0x0100 */   3,  0, 64,224,  6, 48, 64,224,  5, 48,131,224,  9, 16,160,225,
/* 0x0110 */  24, 80,157,229, 24,  0,141,229,  4, 32, 49,229, 13,  0, 81,225,
/* 0x0120 */   4, 32, 32,229, 55,  0,  0, 26,  0,208,160,225, 16, 12,189,232,
/* 0x0130 */  10,220, 77,226,  4,144,154,229, 13,128,160,225,  0,112,154,229,
/* 0x0140 */ 176, 96,143,226, 12,144,137,226,248, 15, 45,233, 15,  0,189,232,
/* 0x0150 */ 254,255,255,235, 20,208,141,226, 10,220,141,226, 16,  0,141,229,
/* 0x0160 */ 104, 16,155,229, 11,  0,160,225,254,255,255,235, 11,  0,160,225,
/* 0x0170 */ 254,255,255,235,  4, 64,157,228,  0, 80,160,227, 48,  0, 45,233,
/* 0x0180 */   2, 48,160,227,  1, 32,160,227,  1, 26,160,227,  0,  0,160,227,
/* 0x0190 */ 254,255,255,235,  3,  0,189,232,254,255,255,235,  7, 64,189,232,
/* 0x01a0 */   0, 48,160,227,  0, 64,160,227,  0, 80,160,227,  0, 96,160,227,
/* 0x01b0 */   0,128,160,227,  0,144,160,227,  0,160,160,227,  0,176,160,227,
/* 0x01c0 */   1,199, 77,226, 32,112, 29,228,  0,112,141,229,  0,112,157,229,
/* 0x01d0 */  13,  0, 92,225, 98,  0,  0, 58,  1,215,141,226,  0,112,160,227,
/* 0x01e0 */   0,192,160,227, 14,240,160,225, 47,112,114,111, 99, 47,115,101,
/* 0x01f0 */ 108,102, 47,101,120,101,  0,  0,255, 48,  3,226, 80,  0, 83,227,
/* 0x0200 */  14,240,160, 17, 33, 17,176,225,  0,  0, 80, 19, 14,240,160,  1,
/* 0x0210 */   1, 16, 65,226,  1, 33,144,231, 15, 52,  2,226, 11,  4, 83,227,
/* 0x0220 */ 127,  0,  0, 26,255, 52,  2,226,  1, 32, 66,224,255, 36,194,227,
/* 0x0230 */   3, 32,130,225,  1, 33,128,231,  0,  0, 81,227,117,  0,  0, 26,
/* 0x0240 */  14,240,160,225,240,  1,240,231, 14,240,160,225,  1,  0,144,239,
/* 0x0250 */   3,  0,144,239, 14,240,160,225,  4,  0,144,239, 14,240,160,225,
/* 0x0260 */   5,  0,144,239, 14,240,160,225,  6,  0,144,239, 14,240,160,225,
/* 0x0270 */  10,  0,144,239, 14,240,160,225, 20,  0,144,239, 14,240,160,225,
/* 0x0280 */  45,  0,144,239, 14,240,160,225, 85,  0,144,239, 14,240,160,225,
/* 0x0290 */  91,  0,144,239, 14,240,160,225, 56,192,159,229,  0,192, 12,224,
/* 0x02a0 */  12,  0, 64,224, 12, 16,129,224,125,  0,144,239, 14,240,160,225,
/* 0x02b0 */  48, 64, 45,233, 16, 80,157,229, 12, 64,157,229, 37, 86,160,225,
/* 0x02c0 */  16,192,159,229,  0,192, 12,224, 12,  0, 64,224, 12, 16,129,224,
/* 0x02d0 */ 192,  0,144,239, 48,128,189,232,255, 15,  0,  0,192,  0,144,239,
/* 0x02e0 */  48,128,189,232,  0, 32,160,227,  2,  0,159,239, 14,240,160,225,
/* 0x02f0 */ 104,  0, 31,229, 14,240,160,225, 48, 64, 45,233,208, 66, 31,229,
/* 0x0300 */   0, 80,160,227,  4, 48,131,225,  0, 64,224,227,161,  0,  0,234,
/* 0x0310 */   0,192,160,225,  1, 16, 65,224,  0, 32,160,225,128,  1,144,224,
/* 0x0320 */ 129, 17,161,224,162, 30,129,224,  0, 32,160,225,  0,  2,144,224,
/* 0x0330 */   1, 18,161,224, 34, 30,129,224,  0, 32,160,225,  0,  4,144,224,
/* 0x0340 */   1, 20,161,224, 34, 28,129,224,  0, 32,160,225,  0,  8,144,224,
/* 0x0350 */   1, 24,161,224, 34, 24,129,224,140, 15, 80,224,172, 16,193,224,
/* 0x0360 */  12,  0,144,224,  0,  0,161,226, 14,240,160,225,  0,  0, 80,227,
/* 0x0370 */  30,255, 47,  1,  0, 48,144,229,  1,  0, 83,225,  8,  0,128, 18,
/* 0x0380 */ 206,  0,  0, 26,  4, 32,128,229, 30,255, 47,225,  0,  0,159,229,
/* 0x0390 */  30,255, 47,225,  0,240,255,255,  0, 48,144,229,  2,  0, 83,225,
/* 0x03a0 */   4, 48,144,229,  4,224, 45,229,  3,192,160, 33,  2,224,160,225,
/* 0x03b0 */   2, 32,160, 33,227,  0,  0, 42,127,  0,160,227,254,255,255,235,
/* 0x03c0 */   1, 48, 92,229,  1, 48, 65,229,  1, 32, 66,226,  1,  0,114,227,
/* 0x03d0 */   1,192,140,226,  1, 16,129,226,225,  0,  0, 26,  4, 32,144,229,
/* 0x03e0 */   0, 48,144,229, 14, 32,130,224,  3, 48,110,224,  0, 48,128,229,
/* 0x03f0 */   4, 32,128,229,  4,240,157,228,240, 64, 45,233,  0, 80,160,225,
/* 0x0400 */  20,208, 77,226,  1, 64,160,225,  2,112,160,225,  3, 96,160,225,
/* 0x0410 */  59,  1,  0,234,  4, 16,141,226,  5,  0,160,225, 12, 32,160,227,
/* 0x0420 */ 215,  0,  0,235,  4,224,157,229,  0,  0, 94,227,  8, 16,157,229,
/* 0x0430 */   5,  1,  0, 26,  0, 49,159,229,  3,  0, 81,225,  7,  1,  0, 26,
/* 0x0440 */   0, 48,149,229,  0,  0, 83,227,  7,  1,  0, 26, 62,  1,  0,234,
/* 0x0450 */   0,  0, 81,227,  9,  1,  0, 26,127,  0,160,227,254,255,255,235,
/* 0x0460 */  14,  0, 81,225,  7,  1,  0,138,  0, 48,148,229,  3,  0, 94,225,
/* 0x0470 */   7,  1,  0,138, 14,  0, 81,225, 50,  1,  0, 42, 12,192,221,229,
/* 0x0480 */   4,  0,149,229,  4, 32,148,229, 16, 48,141,226, 16,224,141,229,
/* 0x0490 */   0,192,141,229, 15,224,160,225, 23,255, 47,225,  0,  0, 80,227,
/* 0x04a0 */   7,  1,  0, 26, 16, 16,157,229,  4, 48,157,229,  3,  0, 81,225,
/* 0x04b0 */   7,  1,  0, 26, 13, 32,221,229,  0,  0, 82,227,  0,  0, 86, 19,
/* 0x04c0 */  44,  1,  0, 10,  2, 12, 81,227, 39,  1,  0,138,  0, 48,148,229,
/* 0x04d0 */   1,  0, 83,225, 44,  1,  0, 26,  2, 48,160,225,  4,  0,148,229,
/* 0x04e0 */  14, 32,221,229, 15,224,160,225, 22,255, 47,225,  8, 48,157,229,
/* 0x04f0 */   6,  0,149,232,  3, 32,130,224,  1, 16, 99,224,  6,  0,133,232,
/* 0x0500 */  54,  1,  0,234,  1, 32,160,225,  5,  0,160,225,  4, 16,148,229,
/* 0x0510 */ 215,  0,  0,235,  4, 48,157,229,  6,  0,148,232,  3, 32,130,224,
/* 0x0520 */   1, 16, 99,224,  6,  0,132,232,  0, 48,148,229,  0,  0, 83,227,
/* 0x0530 */ 246,  0,  0, 26, 20,208,141,226,240,128,189,232, 85, 80, 88, 33,
/* 0x0540 */ 240, 79, 45,233,  1,128,160,225, 28, 16,145,229, 48,208, 77,226,
/* 0x0550 */   0,  0, 82,227, 12, 32,141,229, 16,  0,141,229,  8, 48,141,229,
/* 0x0560 */   1, 80,136,224, 88,  1,  0, 10, 84, 32,157,229,  0,  0,146,229,
/* 0x0570 */ 176, 49,208,225, 52, 16,128,226,  2,  0, 83,227, 40, 48,145, 21,
/* 0x0580 */   0,176, 99, 16,  8,  0,145,  5, 11,  0,160, 17, 20, 16,145,229,
/* 0x0590 */   0,176,160,  3,254,255,255,235,126,  1,  0,234,176, 49,216,225,
/* 0x05a0 */ 188, 34,216,225,  3,  0, 83,227, 12, 16,157,229, 16,224,160, 19,
/* 0x05b0 */   0,224,160,  3,  1,192, 66,226,  5,  0,160,225,  0, 64,224,227,
/* 0x05c0 */ 112,  1,  0,234,  0, 48,144,229,  1,  0, 83,227,110,  1,  0, 26,
/* 0x05d0 */  20, 48,144,229,  0,  0, 83,227,110,  1,  0, 10,  8, 32,144,229,
/* 0x05e0 */   2, 48,131,224,  3,  0, 81,225,  3, 16,160, 49,  2,  0, 84,225,
/* 0x05f0 */   2, 64,160, 33, 32,  0,128,226,  1,192, 76,226,  0,  0, 92,227,
/* 0x0600 */  98,  1,  0,170,255, 78,196,227, 15, 64,196,227,  1, 16,100,224,
/* 0x0610 */ 255, 30,129,226, 15, 16,129,226,255, 30,193,227, 15, 16,193,227,
/* 0x0620 */  14, 48,160,225,  4,  0,160,225,  0, 32,160,227,254,255,255,235,
/* 0x0630 */   0,176,100,224, 52, 48,160,227,155,  3,  3,224, 32, 80,133,226,
/* 0x0640 */  32, 48,141,229,  0, 48,160,227, 24, 48,141,229, 53,  2,  0,234,
/* 0x0650 */  12,192,157,229,  0,  0, 92,227,145,  1,  0, 10, 32, 48, 21,229,
/* 0x0660 */   6,  0, 83,227,145,  1,  0, 26, 24, 32, 21,229,  8,  0,157,229,
/* 0x0670 */   2, 32,139,224,  3, 16,160,227,204,  0,  0,235, 49,  2,  0,234,
/* 0x0680 */  32, 48, 21,229,  1,  0, 83,227, 49,  2,  0, 26, 12, 48, 21,229,
/* 0x0690 */   0,  0, 83,227, 49,  2,  0, 10, 12,  0,157,229,  0,  0, 80,227,
/* 0x06a0 */ 172,  1,  0, 10, 28, 48, 21,229,  0,  0, 83,227,172,  1,  0, 26,
/* 0x06b0 */  28, 48,152,229, 24, 32, 21,229,  3, 32,130,224,  2, 32,139,224,
/* 0x06c0 */   3, 16,160,227,  8,  0,157,229,204,  0,  0,235,  8,  0,157,229,
/* 0x06d0 */   5, 16,160,227,188, 34,216,225,204,  0,  0,235,  8,  0,157,229,
/* 0x06e0 */   4, 16,160,227,186, 34,216,225,204,  0,  0,235,  8, 16, 21,229,
/* 0x06f0 */ 168, 34,159,229,  7, 48,  1,226,  3, 49,160,225, 50, 67,160,225,
/* 0x0700 */  24, 48, 21,229,  3, 48,139,224, 20, 48,141,229, 20,192,157,229,
/* 0x0710 */  16, 48, 21,229, 12, 42,160,225, 34, 42,160,225, 12,  0,157,229,
/* 0x0720 */  40, 48,141,229,  2,160,131,224, 12, 48, 21,229,  0,  0, 80,227,
/* 0x0730 */  44,192,141,229,  7,144,  4,226, 36, 48,141,229, 12, 96, 98,224,
/* 0x0740 */ 211,  1,  0, 10,  1,  0, 17,227,  3, 32,160,  3,  7, 32,160, 19,
/* 0x0750 */   6,  0,160,225, 10, 16,160,225, 16, 48,160,227,254,255,255,235,
/* 0x0760 */   0,  0, 86,225, 32,  2,  0, 26, 88,192,157,229,  4, 48, 20,226,
/* 0x0770 */  12, 48,160, 17, 12,  0,157,229, 40, 16,141,226, 16, 32,157,229,
/* 0x0780 */ 239,  0,  0,235,223,  1,  0,234, 28,192, 21,229, 12,192, 98,224,
/* 0x0790 */   4,192,141,229, 16,192,157,229,  6,  0,160,225, 10, 16,160,225,
/* 0x07a0 */   9, 32,160,225, 18, 48,160,227,  0,192,141,229,254,255,255,235,
/* 0x07b0 */   0,  0, 86,225, 32,  2,  0, 26,  0, 48,106,226,  3,122,160,225,
/* 0x07c0 */   2,  0, 25,227, 39,122,160,225,236,  1,  0, 10,  0,  0, 87,227,
/* 0x07d0 */ 236,  1,  0, 10, 10, 16,134,224,  7, 32,160,225,  0, 48,160,227,
/* 0x07e0 */   1, 32, 82,226,  1, 48,193,228,232,  1,  0, 26, 12,  0,157,229,
/* 0x07f0 */   0,  0, 80,227, 34,  2,  0, 10,254,255,255,235, 32, 48, 21,229,
/* 0x0800 */   1,  0, 83,227, 28,  0,141,229, 26,  2,  0, 26,  8, 48, 21,229,
/* 0x0810 */   1,  0, 19,227, 26,  2,  0, 10, 12, 32, 21,229, 16, 48, 21,229,
/* 0x0820 */   3,  0, 82,225, 24, 16, 21,229, 64,  2,  0, 26,  1, 48,130,224,
/* 0x0830 */   3, 48,131,226,  3, 48,139,224,  3, 32,195,227,  0, 48, 98,226,
/* 0x0840 */   3, 58,160,225, 35, 58,160,225,  7,  0, 83,227, 64,  2,  0,154,
/* 0x0850 */  17,  2,  0,234,  0,224,160,227,  0,192,224,227, 14,  0,160,225,
/* 0x0860 */   1, 26,160,227,  7, 32,160,227, 34, 48,160,227,  0, 80,141,232,
/* 0x0870 */ 254,255,255,235,  0,  0, 80,227, 71,  2,  0, 26, 26,  2,  0,234,
/* 0x0880 */   3, 48,130,226,  3, 64,195,227, 28, 32,157,229, 16, 49,159,229,
/* 0x0890 */  12,  0,132,232,  4,  0,160,225,  8, 16,132,226,254,255,255,235,
/* 0x08a0 */  84,  2,  0,234,  6,  0,160,225, 10, 16,160,225,  9, 32,160,225,
/* 0x08b0 */ 254,255,255,235,  0,  0, 80,227, 34,  2,  0, 10,127,  0,160,227,
/* 0x08c0 */ 254,255,255,235, 20,192,157,229, 36,  0,157,229,  7, 48,138,224,
/* 0x08d0 */   0, 16,140,224,  3, 64,134,224,  1,  0, 84,225, 49,  2,  0, 42,
/* 0x08e0 */   1, 16,100,224,  9, 32,160,225,  4,  0,160,225, 16, 48,160,227,
/* 0x08f0 */ 254,255,255,235,  0,  0, 84,225, 49,  2,  0, 10, 48,  2,  0,234,
/* 0x0900 */  24, 32,157,229,  1, 32,130,226, 24, 32,141,229, 32, 80,133,226,
/* 0x0910 */ 188, 50,216,225, 24,192,157,229,  3,  0, 92,225,133,  1,  0,186,
/* 0x0920 */  84,  0,157,229,  0,  0, 80,227,  0,176,128, 21, 24,  0,152,229,
/* 0x0930 */   0,  0,139,224, 48,208,141,226,240,143,189,232, 28, 48, 21,229,
/* 0x0940 */   0,  0, 83,227, 32, 32,157,  5,  2, 48,129,  0,  8, 32,131,  2,
/* 0x0950 */  17,  2,  0, 10,  6,  2,  0,234,  3, 48,128,226,  3, 64,195,227,
/* 0x0960 */  28, 48,157,229,  0, 48,132,229, 52, 48,159,229,  8, 16,132,226,
/* 0x0970 */   4,  0,160,225,  4, 48,132,229,254,255,255,235,  4,  0,160,225,
/* 0x0980 */   8, 16,160,227,  5, 32,160,227,254,255,255,235,  4, 32,160,225,
/* 0x0990 */   8,  0,157,229,  0, 16,160,227,204,  0,  0,235, 26,  2,  0,234,
/* 0x09a0 */  64, 98, 81,115, 14,240,160,225,240, 71, 45,233, 12,208, 77,226,
/* 0x09b0 */  52, 96,141,226,  0,144,160,225,  1,112,160,225,  3,128,160,225,
/* 0x09c0 */   6,  0,160,225, 44, 16,141,226,  0, 48,160,227, 48,160,157,229,
/* 0x09d0 */   2, 80,160,225, 52, 64,157,229,239,  0,  0,235, 60, 48,157,229,
/* 0x09e0 */  12,224,141,226, 56,192,157,229,  4, 48, 46,229, 12,192,100,224,
/* 0x09f0 */   6, 32,160,225, 10, 16,160,225,  9, 48,160,225,  5,  0,160,225,
/* 0x0a00 */  56,192,141,229,  0,224,141,229, 52,112,141,229,  4,128,141,229,
/* 0x0a10 */  65,  1,  0,235,  0, 64,160,225,  9, 16,160,227,  9,  0,160,225,
/* 0x0a20 */   4, 32,160,225,204,  0,  0,235,188,  2,218,225, 52, 32,138,226,
/* 0x0a30 */   0, 16,160,227,163,  2,  0,234,  0, 48,146,229,  3,  0, 83,227,
/* 0x0a40 */ 161,  2,  0, 26,  8, 48,146,229,  8,  0,157,229,  0, 16,160,227,
/* 0x0a50 */   0,  0,131,224,  1, 32,160,225,254,255,255,235,  0, 80, 80,226,
/* 0x0a60 */ 143,  2,  0,186, 10, 16,160,225,  2, 44,160,227,254,255,255,235,
/* 0x0a70 */   2, 12, 80,227,145,  2,  0, 10,127,  0,160,227,254,255,255,235,
/* 0x0a80 */   0,224,160,227, 14, 32,160,225,  8,192,141,226, 10, 16,160,225,
/* 0x0a90 */   9, 48,160,225,  5,  0,160,225,  0, 80,141,232, 65,  1,  0,235,
/* 0x0aa0 */   7, 16,160,227,  0, 64,160,225,  8, 32,157,229,  9,  0,160,225,
/* 0x0ab0 */ 204,  0,  0,235,  5,  0,160,225,254,255,255,235,165,  2,  0,234,
/* 0x0ac0 */  32, 32,130,226,  1, 16,129,226,  0,  0, 81,225,127,  2,  0,186,
/* 0x0ad0 */   4,  0,160,225, 12,208,141,226,240,135,189,232,  0, 46,115,121,
/* 0x0ae0 */ 109,116, 97, 98,  0, 46,115,116,114,116, 97, 98,  0, 46,115,104,
/* 0x0af0 */ 115,116,114,116, 97, 98,  0, 46,114,101,108, 46,116,101,120,116,
/* 0x0b00 */   0, 46, 98,115,115,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b30 */  31,  0,  0,  0,  1,  0,  0,  0,  7,  0,  0,  0, 64,128,  0,  0,
/* 0x0b40 */  52,  0,  0,  0,168, 10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b50 */   4,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,  9,  0,  0,  0,
/* 0x0b60 */   0,  0,  0,  0,  0,  0,  0,  0, 56, 22,  0,  0,104,  3,  0,  0,
/* 0x0b70 */   5,  0,  0,  0,  1,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x0b80 */  37,  0,  0,  0,  8,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b90 */ 220, 10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ba0 */   1,  0,  0,  0,  0,  0,  0,  0, 17,  0,  0,  0,  3,  0,  0,  0,
/* 0x0bb0 */   0,  0,  0,  0,  0,  0,  0,  0,220, 10,  0,  0, 42,  0,  0,  0,
/* 0x0bc0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0bd0 */   1,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0be0 */  32, 12,  0,  0,160,  6,  0,  0,  6,  0,  0,  0, 85,  0,  0,  0,
/* 0x0bf0 */   4,  0,  0,  0, 16,  0,  0,  0,  9,  0,  0,  0,  3,  0,  0,  0,
/* 0x0c00 */   0,  0,  0,  0,  0,  0,  0,  0,192, 18,  0,  0,120,  3,  0,  0,
/* 0x0c10 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,
/* 0x0c40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  3,  0,
/* 0x0c50 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,241,255,
/* 0x0c60 */  30,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0c70 */  35,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  1,  0,
/* 0x0c80 */  38,  0,  0,  0,  0,  0,144,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0c90 */  56,  0,  0,  0, 52,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0ca0 */  70,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0cb0 */  77,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0cc0 */  85,  0,  0,  0, 32,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0cd0 */  99,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0ce0 */ 107,  0,  0,  0, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0cf0 */ 115,  0,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0d00 */ 125,  0,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0d10 */ 135,  0,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0d20 */ 145,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0d30 */ 152,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0d40 */ 159,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0d50 */ 168,  0,  0,  0, 32,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0d60 */ 182,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0d70 */ 194,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0d80 */ 204,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0d90 */ 214,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0da0 */ 223,  0,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0db0 */ 234,  0,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0dc0 */ 244,  0,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0dd0 */ 252,  0,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0de0 */   5,  1,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0df0 */  20,  1,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0e00 */  35,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,
/* 0x0e10 */  45,  1,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0e20 */  51,  1,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,
/* 0x0e30 */  62,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0e40 */  69,  1,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0e50 */  76,  1,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0e60 */  86,  1,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0e70 */  91,  1,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0e80 */  98,  1,  0,  0, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0e90 */ 105,  1,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0ea0 */ 113,  1,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0eb0 */ 122,  1,  0,  0, 28,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0ec0 */ 130,  1,  0,  0,124,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,
/* 0x0ed0 */ 138,  1,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0ee0 */ 146,  1,  0,  0,196,  1,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,
/* 0x0ef0 */ 157,  1,  0,  0,144,  1,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,
/* 0x0f00 */ 163,  1,  0,  0,180,  1,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,
/* 0x0f10 */ 177,  1,  0,  0,194,  1,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,
/* 0x0f20 */ 193,  1,  0,  0,220,  1,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,
/* 0x0f30 */ 201,  1,  0,  0,  4,  2,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,
/* 0x0f40 */ 209,  1,  0,  0,  1,  0,144,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0f50 */ 219,  1,  0,  0,  3,  0,144,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0f60 */ 229,  1,  0,  0,  4,  0,144,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0f70 */ 240,  1,  0,  0,  5,  0,144,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0f80 */ 250,  1,  0,  0,  6,  0,144,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0f90 */   5,  2,  0,  0, 10,  0,144,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0fa0 */  17,  2,  0,  0, 20,  0,144,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0fb0 */  29,  2,  0,  0, 45,  0,144,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0fc0 */  38,  2,  0,  0, 85,  0,144,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0fd0 */  52,  2,  0,  0,192,  0,144,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0fe0 */  63,  2,  0,  0,125,  0,144,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x0ff0 */  77,  2,  0,  0, 91,  0,144,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x1000 */  89,  2,  0,  0,  0,  0,159,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x1010 */ 103,  2,  0,  0,  2,  0,159,  0,  0,  0,  0,  0,  0,  0,241,255,
/* 0x1020 */ 123,  2,  0,  0, 16,  2,  0,  0,  0,  0,  0,  0,  1,  0,  1,  0,
/* 0x1030 */  35,  0,  0,  0, 20,  2,  0,  0,  0,  0,  0,  0,  2,  0,  1,  0,
/* 0x1040 */ 126,  2,  0,  0,164,  2,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,
/* 0x1050 */ 134,  2,  0,  0,140,  2,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,
/* 0x1060 */ 123,  2,  0,  0,164,  2,  0,  0,  0,  0,  0,  0,  1,  0,  1,  0,
/* 0x1070 */  35,  0,  0,  0,168,  2,  0,  0,  0,  0,  0,  0,  2,  0,  1,  0,
/* 0x1080 */ 142,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,241,255,
/* 0x1090 */ 167,  2,  0,  0, 56,  3,  0,  0, 32,  0,  0,  0,  2,  0,  1,  0,
/* 0x10a0 */  35,  0,  0,  0, 56,  3,  0,  0,  0,  0,  0,  0,  2,  0,  1,  0,
/* 0x10b0 */ 123,  2,  0,  0, 96,  3,  0,  0,  0,  0,  0,  0,  1,  0,  1,  0,
/* 0x10c0 */ 175,  2,  0,  0,100,  3,  0,  0, 96,  0,  0,  0,  2,  0,  1,  0,
/* 0x10d0 */  35,  0,  0,  0,100,  3,  0,  0,  0,  0,  0,  0,  2,  0,  1,  0,
/* 0x10e0 */ 181,  2,  0,  0,196,  3,  0,  0, 72,  1,  0,  0,  2,  0,  1,  0,
/* 0x10f0 */ 123,  2,  0,  0,  8,  5,  0,  0,  0,  0,  0,  0,  1,  0,  1,  0,
/* 0x1100 */ 194,  2,  0,  0, 12,  5,  0,  0,104,  4,  0,  0,  2,  0,  1,  0,
/* 0x1110 */  35,  0,  0,  0, 12,  5,  0,  0,  0,  0,  0,  0,  2,  0,  1,  0,
/* 0x1120 */ 123,  2,  0,  0,108,  9,  0,  0,  0,  0,  0,  0,  1,  0,  1,  0,
/* 0x1130 */  35,  0,  0,  0,116,  9,  0,  0,  0,  0,  0,  0,  2,  0,  1,  0,
/* 0x1140 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,241,255,
/* 0x1150 */ 123,  2,  0,  0, 64,128,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,
/* 0x1160 */ 123,  2,  0,  0,120,131,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,
/* 0x1170 */ 202,  2,  0,  0, 88,  3,  0,  0, 12,  0,  0,  0, 18,  0,  1,  0,
/* 0x1180 */ 216,  2,  0,  0, 92,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x1190 */ 223,  2,  0,  0,188,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x11a0 */ 238,  2,  0,  0, 68,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x11b0 */ 245,  2,  0,  0, 84,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x11c0 */ 254,  2,  0,  0,220,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x11d0 */   8,  3,  0,  0,124,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x11e0 */  13,  3,  0,  0,176,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x11f0 */  27,  3,  0,  0,196,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x1200 */  41,  3,  0,  0, 36,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x1210 */  47,  3,  0,  0, 28,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x1220 */  52,  3,  0,  0, 60,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x1230 */  59,  3,  0,  0, 16,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x1240 */  67,  3,  0,  0,100,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x1250 */  76,  3,  0,  0, 24,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x1260 */  81,  3,  0,  0,116,  9,  0,  0, 52,  1,  0,  0, 18,  0,  1,  0,
/* 0x1270 */  90,  3,  0,  0, 76,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x1280 */  94,  3,  0,  0, 44,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x1290 */  99,  3,  0,  0,220,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x12a0 */ 105,  3,  0,  0,100,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x12b0 */ 114,  3,  0,  0, 52,  2,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x12c0 */   0,115,114, 99, 47, 97,114,109, 46,118, 52, 97, 45,108,105,110,
/* 0x12d0 */ 117,120, 46,101,108,102, 45,102,111,108,100, 46, 83,  0, 78, 66,
/* 0x12e0 */  80, 87,  0, 36, 97,  0, 95, 95, 78, 82, 95, 83, 89, 83, 67, 65,
/* 0x12f0 */  76, 76, 95, 66, 65, 83, 69,  0,115,122, 95, 69,108,102, 51, 50,
/* 0x1300 */  95, 69,104,100,114,  0,101, 95,116,121,112,101,  0, 69, 84, 95,
/* 0x1310 */  69, 88, 69, 67,  0,115,122, 95, 69,108,102, 51, 50, 95, 80,104,
/* 0x1320 */ 100,114,  0,112, 95,118, 97,100,100,114,  0,112, 95,109,101,109,
/* 0x1330 */ 115,122,  0,115,122, 95,108, 95,105,110,102,111,  0,115,122, 95,
/* 0x1340 */ 112, 95,105,110,102,111,  0,115,122, 95, 98, 95,105,110,102,111,
/* 0x1350 */   0,115,122, 95,117,110, 99,  0,115,122, 95, 99,112,114,  0, 98,
/* 0x1360 */  95,109,101,116,104,111,100,  0, 77, 65, 80, 95, 65, 78, 79, 78,
/* 0x1370 */  89, 77, 79, 85, 83,  0, 77, 65, 80, 95, 80, 82, 73, 86, 65, 84,
/* 0x1380 */  69,  0, 77, 65, 80, 95, 70, 73, 88, 69, 68,  0, 80, 82, 79, 84,
/* 0x1390 */  95, 82, 69, 65, 68,  0, 79, 95, 82, 68, 79, 78, 76, 89,  0, 80,
/* 0x13a0 */  65, 71, 69, 95, 83, 72, 73, 70, 84,  0, 80, 65, 71, 69, 95, 83,
/* 0x13b0 */  73, 90, 69,  0, 80, 65, 84, 72, 77, 65, 88,  0, 80, 65, 84, 72,
/* 0x13c0 */  95, 77, 65, 88,  0, 77, 65, 88, 95, 69, 76, 70, 95, 72, 68, 82,
/* 0x13d0 */  95, 51, 50,  0, 77, 65, 88, 95, 69, 76, 70, 95, 72, 68, 82, 95,
/* 0x13e0 */  54, 52,  0,109,102,108,103, 95,100, 97,116, 97,  0, 83, 80, 95,
/* 0x13f0 */ 102,100,  0,102,111,108,100, 95, 98,101,103,105,110,  0, 70, 95,
/* 0x1400 */  76, 69, 78, 88,  0, 70, 95, 65, 68, 82, 88,  0, 70, 95,101,108,
/* 0x1410 */ 102, 97,100,100,114,  0, 70, 95,102,100,  0, 70, 95, 65, 68, 82,
/* 0x1420 */  85,  0, 70, 95, 76, 69, 78, 85,  0, 70, 95,102, 95,101,120,112,
/* 0x1430 */   0, 70, 95,101, 95, 97,117,120,118,  0, 70, 95,101,110,116,114,
/* 0x1440 */ 121,  0,108,105,110,107, 95,111,107,  0, 70, 95,100,101,108,116,
/* 0x1450 */  97,  0,102, 95,117,110,102,105,108,116,101,114,  0,115,119,101,
/* 0x1460 */ 101,112,  0,112,114,111, 99, 95,115,101,108,102, 95,101,120,101,
/* 0x1470 */   0,112,114,111, 99, 95,115,101,108,102, 95, 97,108,105,103,110,
/* 0x1480 */   0,116,111,112, 95,117,110,102,  0,116,115,116, 95,117,110,102,
/* 0x1490 */   0, 95, 95, 78, 82, 95,101,120,105,116,  0, 95, 95, 78, 82, 95,
/* 0x14a0 */ 114,101, 97,100,  0, 95, 95, 78, 82, 95,119,114,105,116,101,  0,
/* 0x14b0 */  95, 95, 78, 82, 95,111,112,101,110,  0, 95, 95, 78, 82, 95, 99,
/* 0x14c0 */ 108,111,115,101,  0, 95, 95, 78, 82, 95,117,110,108,105,110,107,
/* 0x14d0 */   0, 95, 95, 78, 82, 95,103,101,116,112,105,100,  0, 95, 95, 78,
/* 0x14e0 */  82, 95, 98,114,107,  0, 95, 95, 78, 82, 95,114,101, 97,100,108,
/* 0x14f0 */ 105,110,107,  0, 95, 95, 78, 82, 95,109,109, 97,112, 50,  0, 95,
/* 0x1500 */  95, 78, 82, 95,109,112,114,111,116,101, 99,116,  0, 95, 95, 78,
/* 0x1510 */  82, 95,109,117,110,109, 97,112,  0, 95, 95, 65, 82, 77, 95, 78,
/* 0x1520 */  82, 95, 66, 65, 83, 69,  0, 95, 95, 65, 82, 77, 95, 78, 82, 95,
/* 0x1530 */  99, 97, 99,104,101,102,108,117,115,104,  0, 36,100,  0,109, 95,
/* 0x1540 */ 111,102,102, 52,107,  0,109,109, 97,112, 95,100,111,  0, 97,114,
/* 0x1550 */ 109, 46,118, 52, 97, 45,108,105,110,117,120, 46,101,108,102, 45,
/* 0x1560 */ 109, 97,105,110, 46, 99,  0, 97,117,120,118, 95,117,112,  0,120,
/* 0x1570 */ 114,101, 97,100,  0,117,110,112, 97, 99,107, 69,120,116,101,110,
/* 0x1580 */ 116,  0,100,111, 95,120,109, 97,112,  0,103,101,116, 95,112, 97,
/* 0x1590 */ 103,101, 95,109, 97,115,107,  0,109,117,110,109, 97,112,  0,103,
/* 0x15a0 */ 101,116, 95,115,121,115, 95,109,117,110,109, 97,112,  0,103,101,
/* 0x15b0 */ 116,112,105,100,  0,114,101, 97,100,108,105,110,107,  0, 95, 95,
/* 0x15c0 */ 117,100,105,118,115,105, 51,  0,109,109, 97,112,  0, 95, 95, 99,
/* 0x15d0 */ 108,101, 97,114, 95, 99, 97, 99,104,101,  0,109,109, 97,112, 95,
/* 0x15e0 */ 112,114,105,118, 97,110,111,110,  0,119,114,105,116,101,  0,114,
/* 0x15f0 */ 101, 97,100,  0,117,110,108,105,110,107,  0,109,121, 95, 98,107,
/* 0x1600 */ 112,116,  0, 80,112,114,111,116,101, 99,116,  0,101,120,105,116,
/* 0x1610 */   0,117,112,120, 95,109, 97,105,110,  0, 98,114,107,  0,111,112,
/* 0x1620 */ 101,110,  0,100,105,118, 49, 48,  0,109,112,114,111,116,101, 99,
/* 0x1630 */ 116,  0, 99,108,111,115,101,  0, 36,  0,  0,  0,  1,  1,  0,  0,
/* 0x1640 */  60,  0,  0,  0,  1,  1,  0,  0, 80,  0,  0,  0,  1,  1,  0,  0,
/* 0x1650 */ 108,  0,  0,  0,  1, 89,  0,  0,152,  0,  0,  0,  1,  1,  0,  0,
/* 0x1660 */ 240,  0,  0,  0,  1,  1,  0,  0, 28,  1,  0,  0,  1,100,  0,  0,
/* 0x1670 */  52,  1,  0,  0,  1,101,  0,  0, 60,  1,  0,  0,  1, 86,  0,  0,
/* 0x1680 */  92,  1,  0,  0,  1, 91,  0,  0,100,  1,  0,  0,  1,105,  0,  0,
/* 0x1690 */ 160,  1,  0,  0,  1,  1,  0,  0,236,  1,  0,  0,  1,  1,  0,  0,
/* 0x16a0 */   8,  2,  0,  0,  1,  1,  0,  0,216,  2,  0,  0,  1,  1,  0,  0,
/* 0x16b0 */  76,  3,  0,  0,  1,  1,  0,  0,128,  3,  0,  0,  1,  1,  0,  0,
/* 0x16c0 */ 136,  3,  0,  0,  1, 99,  0,  0,164,  3,  0,  0,  1,  1,  0,  0,
/* 0x16d0 */ 220,  3,  0,  0,  1,  1,  0,  0,236,  3,  0,  0,  1,  1,  0,  0,
/* 0x16e0 */ 252,  3,  0,  0,  1,  1,  0,  0,  8,  4,  0,  0,  1,  1,  0,  0,
/* 0x16f0 */  20,  4,  0,  0,  1,  1,  0,  0, 24,  4,  0,  0,  1,  1,  0,  0,
/* 0x1700 */  32,  4,  0,  0,  1,  1,  0,  0, 40,  4,  0,  0,  1, 99,  0,  0,
/* 0x1710 */  48,  4,  0,  0,  1,  1,  0,  0, 60,  4,  0,  0,  1,  1,  0,  0,
/* 0x1720 */  68,  4,  0,  0,  1,  1,  0,  0,108,  4,  0,  0,  1,  1,  0,  0,
/* 0x1730 */ 124,  4,  0,  0,  1,  1,  0,  0,140,  4,  0,  0,  1,  1,  0,  0,
/* 0x1740 */ 148,  4,  0,  0,  1,  1,  0,  0,160,  4,  0,  0,  1,  1,  0,  0,
/* 0x1750 */ 204,  4,  0,  0,  1,  1,  0,  0,220,  4,  0,  0,  1,  1,  0,  0,
/* 0x1760 */ 252,  4,  0,  0,  1,  1,  0,  0, 48,  5,  0,  0,  1,  1,  0,  0,
/* 0x1770 */  96,  5,  0,  0,  1, 86,  0,  0,100,  5,  0,  0,  1,  1,  0,  0,
/* 0x1780 */ 140,  5,  0,  0,  1,  1,  0,  0,152,  5,  0,  0,  1,  1,  0,  0,
/* 0x1790 */ 164,  5,  0,  0,  1,  1,  0,  0,204,  5,  0,  0,  1,  1,  0,  0,
/* 0x17a0 */ 248,  5,  0,  0,  1, 93,  0,  0, 24,  6,  0,  0,  1,  1,  0,  0,
/* 0x17b0 */  36,  6,  0,  0,  1,  1,  0,  0, 48,  6,  0,  0,  1,  1,  0,  0,
/* 0x17c0 */  68,  6,  0,  0,  1,  1,  0,  0, 72,  6,  0,  0,  1,  1,  0,  0,
/* 0x17d0 */  84,  6,  0,  0,  1,  1,  0,  0, 96,  6,  0,  0,  1,  1,  0,  0,
/* 0x17e0 */ 108,  6,  0,  0,  1,  1,  0,  0,120,  6,  0,  0,  1,  1,  0,  0,
/* 0x17f0 */ 148,  6,  0,  0,  1,  1,  0,  0,164,  6,  0,  0,  1,  1,  0,  0,
/* 0x1800 */ 180,  6,  0,  0,  1,  1,  0,  0, 12,  7,  0,  0,  1,  1,  0,  0,
/* 0x1810 */  40,  7,  0,  0,  1, 93,  0,  0, 48,  7,  0,  0,  1,  1,  0,  0,
/* 0x1820 */  76,  7,  0,  0,  1,  1,  0,  0, 80,  7,  0,  0,  1,  1,  0,  0,
/* 0x1830 */ 120,  7,  0,  0,  1, 91,  0,  0,128,  7,  0,  0,  1,  1,  0,  0,
/* 0x1840 */ 148,  7,  0,  0,  1,  1,  0,  0,156,  7,  0,  0,  1,  1,  0,  0,
/* 0x1850 */ 180,  7,  0,  0,  1,  1,  0,  0,192,  7,  0,  0,  1,  1,  0,  0,
/* 0x1860 */ 196,  7,  0,  0,  1, 87,  0,  0,212,  7,  0,  0,  1,  1,  0,  0,
/* 0x1870 */ 224,  7,  0,  0,  1,  1,  0,  0,244,  7,  0,  0,  1,  1,  0,  0,
/* 0x1880 */  24,  8,  0,  0,  1,  1,  0,  0, 28,  8,  0,  0,  1,  1,  0,  0,
/* 0x1890 */  60,  8,  0,  0,  1, 91,  0,  0, 68,  8,  0,  0,  1,  1,  0,  0,
/* 0x18a0 */  72,  8,  0,  0,  1,  1,  0,  0,104,  8,  0,  0,  1, 92,  0,  0,
/* 0x18b0 */ 108,  8,  0,  0,  1,  1,  0,  0,124,  8,  0,  0,  1, 98,  0,  0,
/* 0x18c0 */ 132,  8,  0,  0,  1,  1,  0,  0,140,  8,  0,  0,  1, 99,  0,  0,
/* 0x18d0 */ 168,  8,  0,  0,  1,  1,  0,  0,188,  8,  0,  0,  1, 93,  0,  0,
/* 0x18e0 */ 196,  8,  0,  0,  1,  1,  0,  0,200,  8,  0,  0,  1,  1,  0,  0,
/* 0x18f0 */ 232,  8,  0,  0,  1,  1,  0,  0, 28,  9,  0,  0,  1,  1,  0,  0,
/* 0x1900 */  32,  9,  0,  0,  1,  1,  0,  0, 68,  9,  0,  0,  1, 92,  0,  0,
/* 0x1910 */  84,  9,  0,  0,  1, 98,  0,  0,100,  9,  0,  0,  1,  1,  0,  0,
/* 0x1920 */ 104,  9,  0,  0,  1,  1,  0,  0,164,  9,  0,  0,  1,  1,  0,  0,
/* 0x1930 */ 220,  9,  0,  0,  1,  1,  0,  0,240,  9,  0,  0,  1,  1,  0,  0,
/* 0x1940 */   0, 10,  0,  0,  1,  1,  0,  0, 12, 10,  0,  0,  1,  1,  0,  0,
/* 0x1950 */  36, 10,  0,  0,  1,102,  0,  0, 44, 10,  0,  0,  1,  1,  0,  0,
/* 0x1960 */  56, 10,  0,  0,  1, 95,  0,  0, 64, 10,  0,  0,  1,  1,  0,  0,
/* 0x1970 */  72, 10,  0,  0,  1, 99,  0,  0,104, 10,  0,  0,  1,  1,  0,  0,
/* 0x1980 */ 124, 10,  0,  0,  1,  1,  0,  0,132, 10,  0,  0,  1,105,  0,  0,
/* 0x1990 */ 136, 10,  0,  0,  1,  1,  0,  0,152, 10,  0,  0,  1,  1,  0,  0
};
