/* mips.r3000-linux.elf-entry.h
   created from mips.r3000-linux.elf-entry.bin, 9758 (0x261e) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2018 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2018 Laszlo Molnar
   Copyright (C) 2000-2018 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_MIPS_R3000_LINUX_ELF_ENTRY_SIZE    9758
#define STUB_MIPS_R3000_LINUX_ELF_ENTRY_ADLER32 0x6feb230c
#define STUB_MIPS_R3000_LINUX_ELF_ENTRY_CRC32   0x1539d37a

unsigned char stub_mips_r3000_linux_elf_entry[9758] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  2,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0,  8,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0, 28,248,  0,  0,  0,  1,  0, 52,  0,  0,  0,  0,  0, 40,
/* 0x0030 */   0,  0,  0,  0,  4, 17,  0, 82, 39,254,  0,  0, 60, 13,128,  0,
/* 0x0040 */   1,160, 72, 33, 36, 11,  0,  1,  4, 17,  0, 77, 36, 15,  0,  1,
/* 0x0050 */  17,192,  0,  5,144,142,  0,  0, 36,132,  0,  1, 36,198,  0,  1,
/* 0x0060 */  16,  0,255,249,160,206,255,255,  4, 17,  0, 69,  0, 15,120, 64,
/* 0x0070 */   4, 17,  0, 67,  1,238,120, 33, 21,192,  0,  5, 37,238,255,254,
/* 0x0080 */   4, 17,  0, 63,  1,238,120, 33, 16,  0,255,247,  1,238,120, 33,
/* 0x0090 */  21,192,  0,  5, 37,239,255,253,  4, 17,  0, 57,  1, 96,120, 33,
/* 0x00a0 */  16,  0,  0, 11, 49,204,  0,  1,144,142,  0,  0,  0, 15,122,  0,
/* 0x00b0 */   1,238,120, 33, 37,238,  0,  1, 17,192,255,255, 36,132,  0,  1,
/* 0x00c0 */   0, 15,120, 66, 37,239,  0,  1,  1,224, 88, 33, 49,204,  0,  1,
/* 0x00d0 */   4, 17,  0, 43,  0,  0,  0,  0, 21,128,  0, 12, 37,204,255,254,
/* 0x00e0 */  17,192,  0,  5, 36, 12,  0,  1,  4, 17,  0, 37,  0,  0,  0,  0,
/* 0x00f0 */  16,  0,  0,  6,  1,192, 96, 33,  4, 17,  0, 33,  0, 12, 96, 64,
/* 0x0100 */   4, 17,  0, 31,  1,142, 96, 33, 17,192,255,251, 45,238,  5,  1,
/* 0x0110 */  37,140,  0,  5,  1,142, 96, 35,  0,207,120, 35,145,238,  0,  0,
/* 0x0120 */  37,140,255,255, 37,239,  0,  1, 36,198,  0,  1, 21,128,255,251,
/* 0x0130 */ 160,206,255,255, 16,  0,255,196,  0,  0,  0,  0,136,137,  0,  0,
/* 0x0140 */ 152,137,  0,  3, 60,  1,  0,255, 52, 33,  0,255,  0,  9,114,  2,
/* 0x0150 */   1,193,112, 36,  1, 33, 72, 36,  0,  9, 74,  0,  1, 46, 72, 37,
/* 0x0160 */   0,  9,116,  2,  0,  9, 76,  0,  1, 46, 72, 37, 36,132,  0,  4,
/* 0x0170 */   0,  9,119,194,  0,  9, 72, 64,  3,224,  0,  8, 37, 41,  0,  1,
/* 0x0180 */  17,169,255,238,  0,  9,119,194,  3,224,  0,  8,  0,  9, 72, 64,
/* 0x0190 */  60, 13,128,  0,  1,160, 72, 33, 36, 11,  0,  1,  4, 17,  0, 73,
/* 0x01a0 */  36, 15,  0,  1, 17,192,  0,  5,144,142,  0,  0, 36,132,  0,  1,
/* 0x01b0 */  36,198,  0,  1, 16,  0,255,249,160,206,255,255,  4, 17,  0, 65,
/* 0x01c0 */   0, 15,120, 64,  4, 17,  0, 63,  1,238,120, 33, 21,192,  0,  5,
/* 0x01d0 */  37,238,255,254,  4, 17,  0, 59,  1,207,120, 33, 16,  0,255,247,
/* 0x01e0 */   1,238,120, 33, 21,192,  0,  5, 37,239,255,253,  4, 17,  0, 53,
/* 0x01f0 */   1, 96,120, 33, 16,  0,  0, 11, 49,204,  0,  1,144,142,  0,  0,
/* 0x0200 */   0, 15,122,  0,  1,238,120, 33, 37,238,  0,  1, 17,192,255,255,
/* 0x0210 */  36,132,  0,  1,  0, 15,120, 66, 37,239,  0,  1,  1,224, 88, 33,
/* 0x0220 */  49,204,  0,  1,  4, 17,  0, 39,  0, 12, 96, 64,  1,142, 96, 33,
/* 0x0230 */  21,128,  0,  7, 37,140,255,254, 36, 12,  0,  1,  4, 17,  0, 33,
/* 0x0240 */   0, 12, 96, 64,  4, 17,  0, 31,  1,142, 96, 33, 17,192,255,251,
/* 0x0250 */  45,238,  5,  1, 37,140,  0,  4,  1,142, 96, 35,  0,207,120, 35,
/* 0x0260 */ 145,238,  0,  0, 37,140,255,255, 37,239,  0,  1, 36,198,  0,  1,
/* 0x0270 */  21,128,255,251,160,206,255,255, 16,  0,255,200,  0,  0,  0,  0,
/* 0x0280 */ 136,137,  0,  0,152,137,  0,  3, 60,  1,  0,255, 52, 33,  0,255,
/* 0x0290 */   0,  9,114,  2,  1,193,112, 36,  1, 33, 72, 36,  0,  9, 74,  0,
/* 0x02a0 */   1, 46, 72, 37,  0,  9,116,  2,  0,  9, 76,  0,  1, 46, 72, 37,
/* 0x02b0 */  36,132,  0,  4,  0,  9,119,194,  0,  9, 72, 64,  3,224,  0,  8,
/* 0x02c0 */  37, 41,  0,  1, 17,169,255,238,  0,  9,119,194,  3,224,  0,  8,
/* 0x02d0 */   0,  9, 72, 64, 60, 13,128,  0,  1,160, 72, 33, 36, 11,  0,  1,
/* 0x02e0 */   4, 17,  0, 66, 36, 15,  0,  1, 17,192,  0,  5,144,142,  0,  0,
/* 0x02f0 */  36,132,  0,  1, 36,198,  0,  1, 16,  0,255,249,160,206,255,255,
/* 0x0300 */   4, 17,  0, 58,  0, 15,120, 64,  4, 17,  0, 56,  1,238,120, 33,
/* 0x0310 */  17,192,255,251, 36, 14,  0,  2, 21,238,  0,  3, 37,239,255,253,
/* 0x0320 */  16,  0,  0,  7,  1, 96,120, 33,144,142,  0,  0,  0, 15,122,  0,
/* 0x0330 */   1,238,120, 33, 37,239,  0,  1, 17,224,255,255, 36,132,  0,  1,
/* 0x0340 */   4, 17,  0, 42,  1,224, 88, 33,  1,192, 96, 33,  4, 17,  0, 39,
/* 0x0350 */   0, 12, 96, 64,  1,142, 96, 33, 21,128,  0,  7, 37,140,255,254,
/* 0x0360 */  36, 12,  0,  1,  4, 17,  0, 33,  0, 12, 96, 64,  4, 17,  0, 31,
/* 0x0370 */   1,142, 96, 33, 17,192,255,251, 45,238, 13,  1, 37,140,  0,  4,
/* 0x0380 */   1,142, 96, 35,  0,207,120, 35,145,238,  0,  0, 37,140,255,255,
/* 0x0390 */  37,239,  0,  1, 36,198,  0,  1, 21,128,255,251,160,206,255,255,
/* 0x03a0 */  16,  0,255,207,  0,  0,  0,  0,136,137,  0,  0,152,137,  0,  3,
/* 0x03b0 */  60,  1,  0,255, 52, 33,  0,255,  0,  9,114,  2,  1,193,112, 36,
/* 0x03c0 */   1, 33, 72, 36,  0,  9, 74,  0,  1, 46, 72, 37,  0,  9,116,  2,
/* 0x03d0 */   0,  9, 76,  0,  1, 46, 72, 37, 36,132,  0,  4,  0,  9,119,194,
/* 0x03e0 */   0,  9, 72, 64,  3,224,  0,  8, 37, 41,  0,  1, 17,169,255,238,
/* 0x03f0 */   0,  9,119,194,  3,224,  0,  8,  0,  9, 72, 64,144,153,  0,  0,
/* 0x0400 */  36,  1,250,  0,144,152,  0,  1, 51, 34,  0,  7,  0, 25,200,194,
/* 0x0410 */   3, 33,  8,  4, 36, 33,241, 96,  3,161,232, 33,175,161,  0, 40,
/* 0x0420 */  39,170,  0, 32,175,191,  0, 44,140,233,  0,  0,175,166,  0, 36,
/* 0x0430 */   0,192, 64, 33, 39,167,  0, 28, 36,166,255,254, 36,133,  0,  2,
/* 0x0440 */  39,164,  0, 48,160,130,  0,  2, 51,  1,  0, 15,160,129,  0,  0,
/* 0x0450 */   0, 24,193,  2,  4, 17,  0, 16,160,152,  0,  1,175,162,  0, 28,
/* 0x0460 */ 143,164,  0, 36,143,165,  0, 32, 36,  6,  0,  3, 36,  2, 16, 51,
/* 0x0470 */   0,  0,  0, 12,143,162,  0, 28,143,161,  0, 40,143,191,  0, 44,
/* 0x0480 */   3,161,  8, 35, 39,189,  0,  4, 23,161,255,254,175,160,255,252,
/* 0x0490 */   3,224,  0,  8,  0,  0,  0,  0, 39,189,255,200,175,183,  0, 52,
/* 0x04a0 */ 175,182,  0, 48,175,181,  0, 44,175,180,  0, 40,175,179,  0, 36,
/* 0x04b0 */ 175,178,  0, 32,175,177,  0, 28,175,176,  0, 24,  0,160,168, 33,
/* 0x04c0 */ 175,167,  0, 12,  1,  0,152, 33,175,169,  0, 16,175,170,  0, 20,
/* 0x04d0 */  36,144,  0,  4,144,130,  0,  2, 36,  3,  0,  1,  0, 67, 16,  4,
/* 0x04e0 */  36, 66,255,255,175,162,  0,  8,144,130,  0,  1,  0,  0,  0,  0,
/* 0x04f0 */   0, 67, 16,  4, 36, 66,255,255,175,162,  0,  4,144,150,  0,  0,
/* 0x0500 */ 172,224,  0,  0,173, 64,  0,  0,144,132,  0,  1,  0,  0,  0,  0,
/* 0x0510 */   2,196, 32, 33, 36,  2,  3,  0,  0,130, 32,  4, 36,132,  7, 54,
/* 0x0520 */   2,  0, 16, 33, 16,  0,  0,  4,  0,  0, 88, 33, 36,  3,  4,  0,
/* 0x0530 */ 164, 67,255,254, 37,107,  0,  1, 21,100,255,252, 36, 66,  0,  2,
/* 0x0540 */   2,166, 56, 33,  2,160,104, 33,  0,  0,192, 33,  0,  0, 32, 33,
/* 0x0550 */   0,245, 16, 35, 16,130,  2,123,  0, 24, 26,  0,145,162,  0,  0,
/* 0x0560 */   0,  0,  0,  0,  0, 98,192, 37, 36,132,  0,  1, 36,  2,  0,  5,
/* 0x0570 */  20,130,255,247, 37,173,  0,  1,  0,  0, 80, 33,  0,  0,112, 33,
/* 0x0580 */   0,  0,144, 33, 36, 17,  0,  1, 36, 20,  0,  1, 36, 23,  0,  1,
/* 0x0590 */ 175,183,  0,  0, 16,  0,  2, 87, 36, 15,255,255, 52, 70,255,255,
/* 0x05a0 */   0,207, 16, 43, 20, 64,  0,  8,  0,  0,  0,  0, 17,167,  2,101,
/* 0x05b0 */   0, 15,122,  0,  0, 24, 26,  0,145,162,  0,  0,  0,  0,  0,  0,
/* 0x05c0 */   0, 98,192, 37, 37,173,  0,  1,143,163,  0,  8,  0,  0,  0,  0,
/* 0x05d0 */   1, 67, 40, 36,  0, 18,201,  0,  0,185, 16, 33,  0,  2, 16, 64,
/* 0x05e0 */   2,  2, 88, 33,149, 99,  0,  0,  0, 15, 18,194,  0, 67,  0, 24,
/* 0x05f0 */   0,  0, 96, 18,  3, 12, 16, 43, 16, 64,  0,125, 36,  2,  8,  0,
/* 0x0600 */   0, 67, 16, 35,  0,  2, 17, 67,  0, 98, 16, 33,165, 98,  0,  0,
/* 0x0610 */ 143,163,  0,  4,  0,  0,  0,  0,  1, 67, 16, 36,  2,194, 24,  4,
/* 0x0620 */  36,  2,  0,  8,  0, 86, 16, 35,  0, 78, 16,  7,  0, 98, 16, 33,
/* 0x0630 */   0,  2, 26, 64,  0,  2, 18,192,  0, 67, 16, 35,  2,  2, 16, 33,
/* 0x0640 */  36, 70, 14,108, 42, 66,  0,  7, 16, 64,  0,  3,  1,128,120, 33,
/* 0x0650 */  16,  0,  0, 85, 36,  5,  0,  1,  1, 81, 16, 35,  2, 98, 16, 33,
/* 0x0660 */ 144, 89,  0,  0, 36,  5,  0,  1, 60,  2,  0,255, 52, 66,255,255,
/* 0x0670 */   0, 79, 16, 43, 20, 64,  0,  8,  0,  0,  0,  0, 17,167,  2, 49,
/* 0x0680 */   0, 15,122,  0,  0, 24, 26,  0,145,162,  0,  0,  0,  0,  0,  0,
/* 0x0690 */   0, 98,192, 37, 37,173,  0,  1,  0, 25,200, 64, 51, 44,  1,  0,
/* 0x06a0 */   0, 12, 16, 64,  0,194, 16, 33,  0,  5,112, 64,  0, 78, 88, 33,
/* 0x06b0 */ 149, 99,  2,  0,  0, 15, 18,194,  0, 67,  0, 24,  0,  0, 32, 18,
/* 0x06c0 */   3,  4, 16, 43, 16, 64,  0,  9, 36,  2,  8,  0,  0, 67, 16, 35,
/* 0x06d0 */   0,  2, 17, 67,  0, 98, 16, 33,165, 98,  2,  0, 21,128,  0, 41,
/* 0x06e0 */   1,192, 40, 33, 16,  0,  0,  9,  0,128,120, 33,  1,228,120, 35,
/* 0x06f0 */   3,  4,192, 35,  0,  3, 17, 66,  0, 98, 16, 35,165, 98,  2,  0,
/* 0x0700 */  36,162,  0,  1, 17,128,  0, 40,  0,162, 40, 33, 40,162,  1,  0,
/* 0x0710 */  16, 64,  0, 37, 60,  2,  0,255, 16,  0,255,213, 52, 66,255,255,
/* 0x0720 */  52, 66,255,255,  0, 79, 16, 43, 20, 64,  0,  9,  0,  5, 96, 64,
/* 0x0730 */  17,167,  2,  4,  0, 15,122,  0,  0, 24, 26,  0,145,162,  0,  0,
/* 0x0740 */   0,  0,  0,  0,  0, 98,192, 37, 37,173,  0,  1,  0,  5, 96, 64,
/* 0x0750 */   0,204, 88, 33,149, 99,  0,  0,  0, 15, 18,194,  0, 67,  0, 24,
/* 0x0760 */   0,  0, 32, 18,  3,  4, 16, 43, 16, 64,  0,  8, 36,  2,  8,  0,
/* 0x0770 */   0, 67, 16, 35,  0,  2, 17, 67,  0, 98, 16, 33,165, 98,  0,  0,
/* 0x0780 */   1,128, 40, 33, 16,  0,  0,  8,  0,128,120, 33,  1,228,120, 35,
/* 0x0790 */   3,  4,192, 35,  0,  3, 17, 66,  0, 98, 16, 35,165, 98,  0,  0,
/* 0x07a0 */  36,162,  0,  1,  0,162, 40, 33, 40,162,  1,  0, 20, 64,255,220,
/* 0x07b0 */  60,  2,  0,255, 48,174,  0,255,  2,106, 16, 33,160, 78,  0,  0,
/* 0x07c0 */  42, 66,  0,  4, 16, 64,  0,  3, 37, 67,  0,  1, 16,  0,  1,200,
/* 0x07d0 */   0,  0,144, 33, 42, 66,  0, 10, 16, 64,  0,  3,  0,  0,  0,  0,
/* 0x07e0 */  16,  0,  1,195, 38, 82,255,253, 16,  0,  1,193, 38, 82,255,250,
/* 0x07f0 */   1,236, 32, 35,  0,  3, 17, 66,  0, 98, 16, 35,165, 98,  0,  0,
/* 0x0800 */   0,196, 16, 43, 20, 64,  0,  8,  3, 12,192, 35, 17,167,  1,205,
/* 0x0810 */   0,  4, 34,  0,  0, 24, 26,  0,145,162,  0,  0,  0,  0,  0,  0,
/* 0x0820 */   0, 98,192, 37, 37,173,  0,  1,  0, 18, 16, 64,  2,  2,112, 33,
/* 0x0830 */ 149,195,  1,128,  0,  4, 18,194,  0, 67,  0, 24,  0,  0, 96, 18,
/* 0x0840 */   3, 12, 16, 43, 16, 64,  0, 15, 36,  2,  8,  0,  0, 67, 16, 35,
/* 0x0850 */   0,  2, 17, 67,  0, 98, 16, 33,165,194,  1,128, 42, 66,  0,  7,
/* 0x0860 */  20, 64,  0,  2,  0,  0,144, 33, 36, 18,  0,  3, 38, 14,  6,100,
/* 0x0870 */ 175,183,  0,  0,  2,128,184, 33,  2, 32,160, 33, 16,  0,  0,144,
/* 0x0880 */   1,128, 88, 33,  0,140, 88, 35,  0,  3, 17, 66,  0, 98, 16, 35,
/* 0x0890 */ 165,194,  1,128,  0,203, 16, 43, 20, 64,  0,  8,  3, 12,192, 35,
/* 0x08a0 */  17,167,  1,168,  0, 11, 90,  0,  0, 24, 26,  0,145,162,  0,  0,
/* 0x08b0 */   0,  0,  0,  0,  0, 98,192, 37, 37,173,  0,  1,149,195,  1,152,
/* 0x08c0 */   0, 11, 18,194,  0, 67,  0, 24,  0,  0, 32, 18,  3,  4, 16, 43,
/* 0x08d0 */  16, 64,  0, 50, 36,  2,  8,  0,  0, 67, 16, 35,  0,  2, 17, 67,
/* 0x08e0 */   0, 98, 16, 33,165,194,  1,152, 60,  2,  1,  0,  0,130, 16, 43,
/* 0x08f0 */  16, 64,  0,  8,  0,128, 88, 33, 17,167,  1,146,  0,  4, 90,  0,
/* 0x0900 */   0, 24, 26,  0,145,162,  0,  0,  0,  0,  0,  0,  0, 98,192, 37,
/* 0x0910 */  37,173,  0,  1,  0, 25, 16, 64,  2,  2, 24, 33,  0,  5, 16, 64,
/* 0x0920 */   0, 98, 32, 33,148,131,  1,224,  0, 11, 18,194,  0, 67,  0, 24,
/* 0x0930 */   0,  0, 96, 18,  3, 12, 16, 43, 16, 64,  0, 18, 36,  2,  8,  0,
/* 0x0940 */   0, 67, 16, 35,  0,  2, 17, 67,  0, 98, 16, 33, 17, 64,  1,125,
/* 0x0950 */ 164,130,  1,224, 42, 66,  0,  7, 20, 64,  0,  2, 36, 18,  0,  9,
/* 0x0960 */  36, 18,  0, 11,  1, 81, 16, 35,  2, 98, 16, 33,144, 78,  0,  0,
/* 0x0970 */   2,106, 16, 33,160, 78,  0,  0, 37, 67,  0,  1, 16,  0,  1, 92,
/* 0x0980 */   1,128,120, 33,  1,108, 88, 35,  3, 12,192, 35,  0,  3, 17, 66,
/* 0x0990 */   0, 98, 16, 35, 16,  0,  0, 69,164,130,  1,224,  1,100, 88, 35,
/* 0x09a0 */   0,  3, 17, 66,  0, 98, 16, 35,165,194,  1,152,  0,203, 16, 43,
/* 0x09b0 */  20, 64,  0,  8,  3,  4,192, 35, 17,167,  1, 98,  0, 11, 90,  0,
/* 0x09c0 */   0, 24, 26,  0,145,162,  0,  0,  0,  0,  0,  0,  0, 98,192, 37,
/* 0x09d0 */  37,173,  0,  1,149,195,  1,176,  0, 11, 18,194,  0, 67,  0, 24,
/* 0x09e0 */   0,  0, 32, 18,  3,  4, 16, 43, 16, 64,  0,  7, 36,  2,  8,  0,
/* 0x09f0 */   0, 67, 16, 35,  0,  2, 17, 67,  0, 98, 16, 33,165,194,  1,176,
/* 0x0a00 */  16,  0,  0, 28,  2,128, 16, 33,  1,100, 88, 35,  0,  3, 17, 66,
/* 0x0a10 */   0, 98, 16, 35,165,194,  1,176,  0,203, 16, 43, 20, 64,  0,  8,
/* 0x0a20 */   3,  4,192, 35, 17,167,  1, 71,  0, 11, 90,  0,  0, 24, 26,  0,
/* 0x0a30 */ 145,162,  0,  0,  0,  0,  0,  0,  0, 98,192, 37, 37,173,  0,  1,
/* 0x0a40 */ 149,195,  1,200,  0, 11, 18,194,  0, 67,  0, 24,  0,  0, 32, 18,
/* 0x0a50 */   3,  4, 16, 43, 16, 64,  0, 11, 36,  2,  8,  0,  0, 67, 16, 35,
/* 0x0a60 */   0,  2, 17, 67,  0, 98, 16, 33,165,194,  1,200,  2,224, 16, 33,
/* 0x0a70 */   2,128,184, 33,  2, 32,160, 33,  0, 64,136, 33, 16,  0,  0, 11,
/* 0x0a80 */   0,128, 88, 33,  1,100, 88, 35,  3,  4,192, 35,  0,  3, 17, 66,
/* 0x0a90 */   0, 98, 16, 35,165,194,  1,200,143,162,  0,  0,175,183,  0,  0,
/* 0x0aa0 */   2,128,184, 33,  2, 32,160, 33,  0, 64,136, 33, 42, 66,  0,  7,
/* 0x0ab0 */  20, 64,  0,  2, 36, 18,  0,  8, 36, 18,  0, 11, 38, 14, 10,104,
/* 0x0ac0 */  60,  2,  0,255, 52, 76,255,255,  1,139, 16, 43, 20, 64,  0,  8,
/* 0x0ad0 */   0,  0,  0,  0, 17,167,  1, 27,  0, 11, 90,  0,  0, 24, 26,  0,
/* 0x0ae0 */ 145,162,  0,  0,  0,  0,  0,  0,  0, 98,192, 37, 37,173,  0,  1,
/* 0x0af0 */ 149,195,  0,  0,  0, 11, 18,194,  0, 67,  0, 24,  0,  0, 32, 18,
/* 0x0b00 */   3,  4, 16, 43, 16, 64,  0, 12, 36,  2,  8,  0,  0, 67, 16, 35,
/* 0x0b10 */   0,  2, 17, 67,  0, 98, 16, 33,165,194,  0,  0,  0,  5, 17,  0,
/* 0x0b20 */   1,194, 16, 33, 36, 69,  0,  4,  0,128,120, 33, 36,  8,  0,  3,
/* 0x0b30 */  16,  0,  0, 41,  0,  0, 48, 33,  1,100, 88, 35,  0,  3, 17, 66,
/* 0x0b40 */   0, 98, 16, 35,165,194,  0,  0,  1,139, 16, 43, 20, 64,  0,  8,
/* 0x0b50 */   3,  4,192, 35, 17,167,  0,251,  0, 11, 90,  0,  0, 24, 26,  0,
/* 0x0b60 */ 145,162,  0,  0,  0,  0,  0,  0,  0, 98,192, 37, 37,173,  0,  1,
/* 0x0b70 */ 149,195,  0,  2,  0, 11, 18,194,  0, 67,  0, 24,  0,  0, 32, 18,
/* 0x0b80 */   3,  4, 16, 43, 16, 64,  0, 12, 36,  2,  8,  0,  0, 67, 16, 35,
/* 0x0b90 */   0,  2, 17, 67,  0, 98, 16, 33,165,194,  0,  2,  0,  5, 17,  0,
/* 0x0ba0 */   1,194, 16, 33, 36, 69,  1,  4,  0,128,120, 33, 36,  8,  0,  3,
/* 0x0bb0 */  16,  0,  0,  9, 36,  6,  0,  8,  1,100,120, 35,  3,  4,192, 35,
/* 0x0bc0 */   0,  3, 17, 66,  0, 98, 16, 35,165,194,  0,  2, 37,197,  2,  4,
/* 0x0bd0 */  36,  8,  0,  8, 36,  6,  0, 16,  1,  0,112, 33, 36, 25,  0,  1,
/* 0x0be0 */  60,  2,  0,255, 52, 66,255,255,  0, 79, 16, 43, 20, 64,  0,  9,
/* 0x0bf0 */   0, 25, 96, 64, 17,167,  0,211,  0, 15,122,  0,  0, 24, 26,  0,
/* 0x0c00 */ 145,162,  0,  0,  0,  0,  0,  0,  0, 98,192, 37, 37,173,  0,  1,
/* 0x0c10 */   0, 25, 96, 64,  0,172, 88, 33,149, 99,  0,  0,  0, 15, 18,194,
/* 0x0c20 */   0, 67,  0, 24,  0,  0, 32, 18,  3,  4, 16, 43, 16, 64,  0,  8,
/* 0x0c30 */  36,  2,  8,  0,  0, 67, 16, 35,  0,  2, 17, 67,  0, 98, 16, 33,
/* 0x0c40 */ 165, 98,  0,  0,  1,128,200, 33, 16,  0,  0,  8,  0,128,120, 33,
/* 0x0c50 */   1,228,120, 35,  3,  4,192, 35,  0,  3, 17, 66,  0, 98, 16, 35,
/* 0x0c60 */ 165, 98,  0,  0, 39, 34,  0,  1,  3, 34,200, 33, 37,206,255,255,
/* 0x0c70 */  21,192,255,220, 60,  2,  0,255, 36,  2,  0,  1,  1,  2, 16,  4,
/* 0x0c80 */   3, 34, 16, 35,  0, 70, 72, 33, 42, 66,  0,  4, 16, 64,  0,134,
/* 0x0c90 */  41, 34,  0,  4, 20, 64,  0,  2,  1, 32, 24, 33, 36,  3,  0,  3,
/* 0x0ca0 */   0,  3, 17,192,  2,  2, 16, 33, 36, 70,  3, 96, 36, 14,  0,  1,
/* 0x0cb0 */  36, 25,  0,  6, 60,  2,  0,255, 52, 66,255,255,  0, 79, 16, 43,
/* 0x0cc0 */  20, 64,  0,  9,  0, 14, 96, 64, 17,167,  0,158,  0, 15,122,  0,
/* 0x0cd0 */   0, 24, 26,  0,145,162,  0,  0,  0,  0,  0,  0,  0, 98,192, 37,
/* 0x0ce0 */  37,173,  0,  1,  0, 14, 96, 64,  0,204, 88, 33,149, 99,  0,  0,
/* 0x0cf0 */   0, 15, 18,194,  0, 67,  0, 24,  0,  0, 32, 18,  3,  4, 16, 43,
/* 0x0d00 */  16, 64,  0,  8, 36,  2,  8,  0,  0, 67, 16, 35,  0,  2, 17, 67,
/* 0x0d10 */   0, 98, 16, 33,165, 98,  0,  0,  1,128,112, 33, 16,  0,  0,  8,
/* 0x0d20 */   0,128,120, 33,  1,228,120, 35,  3,  4,192, 35,  0,  3, 17, 66,
/* 0x0d30 */   0, 98, 16, 35,165, 98,  0,  0, 37,194,  0,  1,  1,194,112, 33,
/* 0x0d40 */  39, 57,255,255, 23, 32,255,220, 60,  2,  0,255, 37,195,255,192,
/* 0x0d50 */  40, 98,  0,  4, 20, 64,  0, 80,  0, 96,112, 33,  0,  3, 32, 67,
/* 0x0d60 */  48, 98,  0,  1, 52, 75,  0,  2, 40, 98,  0, 14, 16, 64,  0,  8,
/* 0x0d70 */  36,153,255,255,  3, 43,112,  4,  0, 14, 16, 64,  2,  2, 32, 33,
/* 0x0d80 */   0,  3, 16, 64,  0,130, 16, 35, 16,  0,  0, 26, 36, 72,  5, 94,
/* 0x0d90 */  36,132,255,251, 60,  2,  0,255, 52, 66,255,255,  0, 79, 16, 43,
/* 0x0da0 */  20, 64,  0,  8,  0,  0,  0,  0, 17,167,  0,102,  0, 15,122,  0,
/* 0x0db0 */   0, 24, 26,  0,145,162,  0,  0,  0,  0,  0,  0,  0, 98,192, 37,
/* 0x0dc0 */  37,173,  0,  1,  0, 15,120, 66,  3, 15, 16, 43, 20, 64,  0,  3,
/* 0x0dd0 */   0, 11, 88, 64,  3, 15,192, 35, 53,107,  0,  1, 36,132,255,255,
/* 0x0de0 */  20,128,255,237, 60,  2,  0,255, 38,  8,  6, 68,  0, 11,113,  0,
/* 0x0df0 */  36, 25,  0,  4, 36,  6,  0,  1, 36,  5,  0,  1, 60,  2,  0,255,
/* 0x0e00 */  52, 66,255,255,  0, 79, 16, 43, 20, 64,  0,  9,  0,  5, 96, 64,
/* 0x0e10 */  17,167,  0, 76,  0, 15,122,  0,  0, 24, 26,  0,145,162,  0,  0,
/* 0x0e20 */   0,  0,  0,  0,  0, 98,192, 37, 37,173,  0,  1,  0,  5, 96, 64,
/* 0x0e30 */   1, 12, 88, 33,149, 99,  0,  0,  0, 15, 18,194,  0, 67,  0, 24,
/* 0x0e40 */   0,  0, 32, 18,  3,  4, 16, 43, 16, 64,  0,  8, 36,  2,  8,  0,
/* 0x0e50 */   0, 67, 16, 35,  0,  2, 17, 67,  0, 98, 16, 33,165, 98,  0,  0,
/* 0x0e60 */   1,128, 40, 33, 16,  0,  0,  9,  0,128,120, 33,  1,228,120, 35,
/* 0x0e70 */   3,  4,192, 35,  0,  3, 17, 66,  0, 98, 16, 35,165, 98,  0,  0,
/* 0x0e80 */  36,162,  0,  1,  0,162, 40, 33,  1,198,112, 37, 39, 57,255,255,
/* 0x0e90 */  23, 32,255,218,  0,  6, 48, 64, 37,209,  0,  1, 18, 32,  0, 26,
/* 0x0ea0 */  60,  2,  0,255, 38, 82,  0,  7,  1, 81, 16, 43, 20, 64,  0, 38,
/* 0x0eb0 */  36,  2,  0,  1,  1, 81, 16, 35,  2, 98, 88, 33,  2,106, 32, 33,
/* 0x0ec0 */   1, 64, 24, 33,145,110,  0,  0, 36, 99,  0,  1,  1, 73, 16, 33,
/* 0x0ed0 */  36, 66,  0,  2, 16, 98,  0,  6,160,142,  0,  0, 37,107,  0,  1,
/* 0x0ee0 */ 143,162,  0, 16,  0,  0,  0,  0, 20, 98,255,246, 36,132,  0,  1,
/* 0x0ef0 */   0, 96, 80, 33,143,163,  0, 16,  0,  0,  0,  0,  1, 67, 16, 43,
/* 0x0f00 */  20, 64,253,166, 60,  2,  0,255, 52, 66,255,255,  0, 79, 16, 43,
/* 0x0f10 */  20, 64,  0,  4,  1,181, 40, 35, 17,167,  0, 10, 37,173,  0,  1,
/* 0x0f20 */   1,181, 40, 35,143,162,  0, 12,  0,  0,  0,  0,172, 69,  0,  0,
/* 0x0f30 */ 143,163,  0, 20,  0,  0,  0,  0,172,106,  0,  0, 16,  0,  0,  2,
/* 0x0f40 */   0,  0, 16, 33, 36,  2,  0,  1,143,183,  0, 52,143,182,  0, 48,
/* 0x0f50 */ 143,181,  0, 44,143,180,  0, 40,143,179,  0, 36,143,178,  0, 32,
/* 0x0f60 */ 143,177,  0, 28,143,176,  0, 24,  3,224,  0,  8, 39,189,  0, 56,
/* 0x0f70 */  39,189,255,200,175,183,  0, 52,175,182,  0, 48,175,181,  0, 44,
/* 0x0f80 */ 175,180,  0, 40,175,179,  0, 36,175,178,  0, 32,175,177,  0, 28,
/* 0x0f90 */ 175,176,  0, 24,  0,160,168, 33,175,167,  0, 12,  1,  0,152, 33,
/* 0x0fa0 */ 175,169,  0, 16,175,170,  0, 20, 36,144,  0,  4,144,130,  0,  2,
/* 0x0fb0 */  36,  3,  0,  1,  0, 67, 16,  4, 36, 66,255,255,175,162,  0,  8,
/* 0x0fc0 */ 144,130,  0,  1,  0,  0,  0,  0,  0, 67, 16,  4, 36, 66,255,255,
/* 0x0fd0 */ 175,162,  0,  4,144,150,  0,  0,172,224,  0,  0,173, 64,  0,  0,
/* 0x0fe0 */ 144,132,  0,  1,  0,  0,  0,  0,  2,196, 32, 33, 36,  2,  3,  0,
/* 0x0ff0 */   0,130, 32,  4, 36,132,  7, 54,  2,  0, 16, 33, 16,  0,  0,  4,
/* 0x1000 */   0,  0, 88, 33, 36,  3,  4,  0,164, 67,255,254, 37,107,  0,  1,
/* 0x1010 */  21,100,255,252, 36, 66,  0,  2,  2,166, 56, 33,  2,160,104, 33,
/* 0x1020 */   0,  0,192, 33,  0,  0, 32, 33,  0,245, 16, 35, 16,130,  2,123,
/* 0x1030 */   0, 24, 26,  0,145,162,  0,  0,  0,  0,  0,  0,  0, 98,192, 37,
/* 0x1040 */  36,132,  0,  1, 36,  2,  0,  5, 20,130,255,247, 37,173,  0,  1,
/* 0x1050 */   0,  0, 80, 33,  0,  0,112, 33,  0,  0,144, 33, 36, 17,  0,  1,
/* 0x1060 */  36, 20,  0,  1, 36, 23,  0,  1,175,183,  0,  0, 16,  0,  2, 87,
/* 0x1070 */  36, 15,255,255, 52, 70,255,255,  0,207, 16, 43, 20, 64,  0,  8,
/* 0x1080 */   0,  0,  0,  0, 17,167,  2,101,  0, 15,122,  0,  0, 24, 26,  0,
/* 0x1090 */ 145,162,  0,  0,  0,  0,  0,  0,  0, 98,192, 37, 37,173,  0,  1,
/* 0x10a0 */ 143,163,  0,  8,  0,  0,  0,  0,  1, 67, 40, 36,  0, 18,201,  0,
/* 0x10b0 */   0,185, 16, 33,  0,  2, 16, 64,  2,  2, 88, 33,149, 99,  0,  0,
/* 0x10c0 */   0, 15, 18,194,  0, 67,  0, 24,  0,  0, 96, 18,  3, 12, 16, 43,
/* 0x10d0 */  16, 64,  0,125, 36,  2,  8,  0,  0, 67, 16, 35,  0,  2, 17, 67,
/* 0x10e0 */   0, 98, 16, 33,165, 98,  0,  0,143,163,  0,  4,  0,  0,  0,  0,
/* 0x10f0 */   1, 67, 16, 36,  2,194, 24,  4, 36,  2,  0,  8,  0, 86, 16, 35,
/* 0x1100 */   0, 78, 16,  7,  0, 98, 16, 33,  0,  2, 26, 64,  0,  2, 18,192,
/* 0x1110 */   0, 67, 16, 35,  2,  2, 16, 33, 36, 70, 14,108, 42, 66,  0,  7,
/* 0x1120 */  16, 64,  0,  3,  1,128,120, 33, 16,  0,  0, 85, 36,  5,  0,  1,
/* 0x1130 */   1, 81, 16, 35,  2, 98, 16, 33,144, 89,  0,  0, 36,  5,  0,  1,
/* 0x1140 */  60,  2,  0,255, 52, 66,255,255,  0, 79, 16, 43, 20, 64,  0,  8,
/* 0x1150 */   0,  0,  0,  0, 17,167,  2, 49,  0, 15,122,  0,  0, 24, 26,  0,
/* 0x1160 */ 145,162,  0,  0,  0,  0,  0,  0,  0, 98,192, 37, 37,173,  0,  1,
/* 0x1170 */   0, 25,200, 64, 51, 44,  1,  0,  0, 12, 16, 64,  0,194, 16, 33,
/* 0x1180 */   0,  5,112, 64,  0, 78, 88, 33,149, 99,  2,  0,  0, 15, 18,194,
/* 0x1190 */   0, 67,  0, 24,  0,  0, 32, 18,  3,  4, 16, 43, 16, 64,  0,  9,
/* 0x11a0 */  36,  2,  8,  0,  0, 67, 16, 35,  0,  2, 17, 67,  0, 98, 16, 33,
/* 0x11b0 */ 165, 98,  2,  0, 21,128,  0, 41,  1,192, 40, 33, 16,  0,  0,  9,
/* 0x11c0 */   0,128,120, 33,  1,228,120, 35,  3,  4,192, 35,  0,  3, 17, 66,
/* 0x11d0 */   0, 98, 16, 35,165, 98,  2,  0, 36,162,  0,  1, 17,128,  0, 40,
/* 0x11e0 */   0,162, 40, 33, 40,162,  1,  0, 16, 64,  0, 37, 60,  2,  0,255,
/* 0x11f0 */  16,  0,255,213, 52, 66,255,255, 52, 66,255,255,  0, 79, 16, 43,
/* 0x1200 */  20, 64,  0,  9,  0,  5, 96, 64, 17,167,  2,  4,  0, 15,122,  0,
/* 0x1210 */   0, 24, 26,  0,145,162,  0,  0,  0,  0,  0,  0,  0, 98,192, 37,
/* 0x1220 */  37,173,  0,  1,  0,  5, 96, 64,  0,204, 88, 33,149, 99,  0,  0,
/* 0x1230 */   0, 15, 18,194,  0, 67,  0, 24,  0,  0, 32, 18,  3,  4, 16, 43,
/* 0x1240 */  16, 64,  0,  8, 36,  2,  8,  0,  0, 67, 16, 35,  0,  2, 17, 67,
/* 0x1250 */   0, 98, 16, 33,165, 98,  0,  0,  1,128, 40, 33, 16,  0,  0,  8,
/* 0x1260 */   0,128,120, 33,  1,228,120, 35,  3,  4,192, 35,  0,  3, 17, 66,
/* 0x1270 */   0, 98, 16, 35,165, 98,  0,  0, 36,162,  0,  1,  0,162, 40, 33,
/* 0x1280 */  40,162,  1,  0, 20, 64,255,220, 60,  2,  0,255, 48,174,  0,255,
/* 0x1290 */   2,106, 16, 33,160, 78,  0,  0, 42, 66,  0,  4, 16, 64,  0,  3,
/* 0x12a0 */  37, 67,  0,  1, 16,  0,  1,200,  0,  0,144, 33, 42, 66,  0, 10,
/* 0x12b0 */  16, 64,  0,  3,  0,  0,  0,  0, 16,  0,  1,195, 38, 82,255,253,
/* 0x12c0 */  16,  0,  1,193, 38, 82,255,250,  1,236, 32, 35,  0,  3, 17, 66,
/* 0x12d0 */   0, 98, 16, 35,165, 98,  0,  0,  0,196, 16, 43, 20, 64,  0,  8,
/* 0x12e0 */   3, 12,192, 35, 17,167,  1,205,  0,  4, 34,  0,  0, 24, 26,  0,
/* 0x12f0 */ 145,162,  0,  0,  0,  0,  0,  0,  0, 98,192, 37, 37,173,  0,  1,
/* 0x1300 */   0, 18, 16, 64,  2,  2,112, 33,149,195,  1,128,  0,  4, 18,194,
/* 0x1310 */   0, 67,  0, 24,  0,  0, 96, 18,  3, 12, 16, 43, 16, 64,  0, 15,
/* 0x1320 */  36,  2,  8,  0,  0, 67, 16, 35,  0,  2, 17, 67,  0, 98, 16, 33,
/* 0x1330 */ 165,194,  1,128, 42, 66,  0,  7, 20, 64,  0,  2,  0,  0,144, 33,
/* 0x1340 */  36, 18,  0,  3, 38, 14,  6,100,175,183,  0,  0,  2,128,184, 33,
/* 0x1350 */   2, 32,160, 33, 16,  0,  0,144,  1,128, 88, 33,  0,140, 88, 35,
/* 0x1360 */   0,  3, 17, 66,  0, 98, 16, 35,165,194,  1,128,  0,203, 16, 43,
/* 0x1370 */  20, 64,  0,  8,  3, 12,192, 35, 17,167,  1,168,  0, 11, 90,  0,
/* 0x1380 */   0, 24, 26,  0,145,162,  0,  0,  0,  0,  0,  0,  0, 98,192, 37,
/* 0x1390 */  37,173,  0,  1,149,195,  1,152,  0, 11, 18,194,  0, 67,  0, 24,
/* 0x13a0 */   0,  0, 32, 18,  3,  4, 16, 43, 16, 64,  0, 50, 36,  2,  8,  0,
/* 0x13b0 */   0, 67, 16, 35,  0,  2, 17, 67,  0, 98, 16, 33,165,194,  1,152,
/* 0x13c0 */  60,  2,  1,  0,  0,130, 16, 43, 16, 64,  0,  8,  0,128, 88, 33,
/* 0x13d0 */  17,167,  1,146,  0,  4, 90,  0,  0, 24, 26,  0,145,162,  0,  0,
/* 0x13e0 */   0,  0,  0,  0,  0, 98,192, 37, 37,173,  0,  1,  0, 25, 16, 64,
/* 0x13f0 */   2,  2, 24, 33,  0,  5, 16, 64,  0, 98, 32, 33,148,131,  1,224,
/* 0x1400 */   0, 11, 18,194,  0, 67,  0, 24,  0,  0, 96, 18,  3, 12, 16, 43,
/* 0x1410 */  16, 64,  0, 18, 36,  2,  8,  0,  0, 67, 16, 35,  0,  2, 17, 67,
/* 0x1420 */   0, 98, 16, 33, 17, 64,  1,125,164,130,  1,224, 42, 66,  0,  7,
/* 0x1430 */  20, 64,  0,  2, 36, 18,  0,  9, 36, 18,  0, 11,  1, 81, 16, 35,
/* 0x1440 */   2, 98, 16, 33,144, 78,  0,  0,  2,106, 16, 33,160, 78,  0,  0,
/* 0x1450 */  37, 67,  0,  1, 16,  0,  1, 92,  1,128,120, 33,  1,108, 88, 35,
/* 0x1460 */   3, 12,192, 35,  0,  3, 17, 66,  0, 98, 16, 35, 16,  0,  0, 69,
/* 0x1470 */ 164,130,  1,224,  1,100, 88, 35,  0,  3, 17, 66,  0, 98, 16, 35,
/* 0x1480 */ 165,194,  1,152,  0,203, 16, 43, 20, 64,  0,  8,  3,  4,192, 35,
/* 0x1490 */  17,167,  1, 98,  0, 11, 90,  0,  0, 24, 26,  0,145,162,  0,  0,
/* 0x14a0 */   0,  0,  0,  0,  0, 98,192, 37, 37,173,  0,  1,149,195,  1,176,
/* 0x14b0 */   0, 11, 18,194,  0, 67,  0, 24,  0,  0, 32, 18,  3,  4, 16, 43,
/* 0x14c0 */  16, 64,  0,  7, 36,  2,  8,  0,  0, 67, 16, 35,  0,  2, 17, 67,
/* 0x14d0 */   0, 98, 16, 33,165,194,  1,176, 16,  0,  0, 28,  2,128, 16, 33,
/* 0x14e0 */   1,100, 88, 35,  0,  3, 17, 66,  0, 98, 16, 35,165,194,  1,176,
/* 0x14f0 */   0,203, 16, 43, 20, 64,  0,  8,  3,  4,192, 35, 17,167,  1, 71,
/* 0x1500 */   0, 11, 90,  0,  0, 24, 26,  0,145,162,  0,  0,  0,  0,  0,  0,
/* 0x1510 */   0, 98,192, 37, 37,173,  0,  1,149,195,  1,200,  0, 11, 18,194,
/* 0x1520 */   0, 67,  0, 24,  0,  0, 32, 18,  3,  4, 16, 43, 16, 64,  0, 11,
/* 0x1530 */  36,  2,  8,  0,  0, 67, 16, 35,  0,  2, 17, 67,  0, 98, 16, 33,
/* 0x1540 */ 165,194,  1,200,  2,224, 16, 33,  2,128,184, 33,  2, 32,160, 33,
/* 0x1550 */   0, 64,136, 33, 16,  0,  0, 11,  0,128, 88, 33,  1,100, 88, 35,
/* 0x1560 */   3,  4,192, 35,  0,  3, 17, 66,  0, 98, 16, 35,165,194,  1,200,
/* 0x1570 */ 143,162,  0,  0,175,183,  0,  0,  2,128,184, 33,  2, 32,160, 33,
/* 0x1580 */   0, 64,136, 33, 42, 66,  0,  7, 20, 64,  0,  2, 36, 18,  0,  8,
/* 0x1590 */  36, 18,  0, 11, 38, 14, 10,104, 60,  2,  0,255, 52, 76,255,255,
/* 0x15a0 */   1,139, 16, 43, 20, 64,  0,  8,  0,  0,  0,  0, 17,167,  1, 27,
/* 0x15b0 */   0, 11, 90,  0,  0, 24, 26,  0,145,162,  0,  0,  0,  0,  0,  0,
/* 0x15c0 */   0, 98,192, 37, 37,173,  0,  1,149,195,  0,  0,  0, 11, 18,194,
/* 0x15d0 */   0, 67,  0, 24,  0,  0, 32, 18,  3,  4, 16, 43, 16, 64,  0, 12,
/* 0x15e0 */  36,  2,  8,  0,  0, 67, 16, 35,  0,  2, 17, 67,  0, 98, 16, 33,
/* 0x15f0 */ 165,194,  0,  0,  0,  5, 17,  0,  1,194, 16, 33, 36, 69,  0,  4,
/* 0x1600 */   0,128,120, 33, 36,  8,  0,  3, 16,  0,  0, 41,  0,  0, 48, 33,
/* 0x1610 */   1,100, 88, 35,  0,  3, 17, 66,  0, 98, 16, 35,165,194,  0,  0,
/* 0x1620 */   1,139, 16, 43, 20, 64,  0,  8,  3,  4,192, 35, 17,167,  0,251,
/* 0x1630 */   0, 11, 90,  0,  0, 24, 26,  0,145,162,  0,  0,  0,  0,  0,  0,
/* 0x1640 */   0, 98,192, 37, 37,173,  0,  1,149,195,  0,  2,  0, 11, 18,194,
/* 0x1650 */   0, 67,  0, 24,  0,  0, 32, 18,  3,  4, 16, 43, 16, 64,  0, 12,
/* 0x1660 */  36,  2,  8,  0,  0, 67, 16, 35,  0,  2, 17, 67,  0, 98, 16, 33,
/* 0x1670 */ 165,194,  0,  2,  0,  5, 17,  0,  1,194, 16, 33, 36, 69,  1,  4,
/* 0x1680 */   0,128,120, 33, 36,  8,  0,  3, 16,  0,  0,  9, 36,  6,  0,  8,
/* 0x1690 */   1,100,120, 35,  3,  4,192, 35,  0,  3, 17, 66,  0, 98, 16, 35,
/* 0x16a0 */ 165,194,  0,  2, 37,197,  2,  4, 36,  8,  0,  8, 36,  6,  0, 16,
/* 0x16b0 */   1,  0,112, 33, 36, 25,  0,  1, 60,  2,  0,255, 52, 66,255,255,
/* 0x16c0 */   0, 79, 16, 43, 20, 64,  0,  9,  0, 25, 96, 64, 17,167,  0,211,
/* 0x16d0 */   0, 15,122,  0,  0, 24, 26,  0,145,162,  0,  0,  0,  0,  0,  0,
/* 0x16e0 */   0, 98,192, 37, 37,173,  0,  1,  0, 25, 96, 64,  0,172, 88, 33,
/* 0x16f0 */ 149, 99,  0,  0,  0, 15, 18,194,  0, 67,  0, 24,  0,  0, 32, 18,
/* 0x1700 */   3,  4, 16, 43, 16, 64,  0,  8, 36,  2,  8,  0,  0, 67, 16, 35,
/* 0x1710 */   0,  2, 17, 67,  0, 98, 16, 33,165, 98,  0,  0,  1,128,200, 33,
/* 0x1720 */  16,  0,  0,  8,  0,128,120, 33,  1,228,120, 35,  3,  4,192, 35,
/* 0x1730 */   0,  3, 17, 66,  0, 98, 16, 35,165, 98,  0,  0, 39, 34,  0,  1,
/* 0x1740 */   3, 34,200, 33, 37,206,255,255, 21,192,255,220, 60,  2,  0,255,
/* 0x1750 */  36,  2,  0,  1,  1,  2, 16,  4,  3, 34, 16, 35,  0, 70, 72, 33,
/* 0x1760 */  42, 66,  0,  4, 16, 64,  0,134, 41, 34,  0,  4, 20, 64,  0,  2,
/* 0x1770 */   1, 32, 24, 33, 36,  3,  0,  3,  0,  3, 17,192,  2,  2, 16, 33,
/* 0x1780 */  36, 70,  3, 96, 36, 14,  0,  1, 36, 25,  0,  6, 60,  2,  0,255,
/* 0x1790 */  52, 66,255,255,  0, 79, 16, 43, 20, 64,  0,  9,  0, 14, 96, 64,
/* 0x17a0 */  17,167,  0,158,  0, 15,122,  0,  0, 24, 26,  0,145,162,  0,  0,
/* 0x17b0 */   0,  0,  0,  0,  0, 98,192, 37, 37,173,  0,  1,  0, 14, 96, 64,
/* 0x17c0 */   0,204, 88, 33,149, 99,  0,  0,  0, 15, 18,194,  0, 67,  0, 24,
/* 0x17d0 */   0,  0, 32, 18,  3,  4, 16, 43, 16, 64,  0,  8, 36,  2,  8,  0,
/* 0x17e0 */   0, 67, 16, 35,  0,  2, 17, 67,  0, 98, 16, 33,165, 98,  0,  0,
/* 0x17f0 */   1,128,112, 33, 16,  0,  0,  8,  0,128,120, 33,  1,228,120, 35,
/* 0x1800 */   3,  4,192, 35,  0,  3, 17, 66,  0, 98, 16, 35,165, 98,  0,  0,
/* 0x1810 */  37,194,  0,  1,  1,194,112, 33, 39, 57,255,255, 23, 32,255,220,
/* 0x1820 */  60,  2,  0,255, 37,195,255,192, 40, 98,  0,  4, 20, 64,  0, 80,
/* 0x1830 */   0, 96,112, 33,  0,  3, 32, 67, 48, 98,  0,  1, 52, 75,  0,  2,
/* 0x1840 */  40, 98,  0, 14, 16, 64,  0,  8, 36,153,255,255,  3, 43,112,  4,
/* 0x1850 */   0, 14, 16, 64,  2,  2, 32, 33,  0,  3, 16, 64,  0,130, 16, 35,
/* 0x1860 */  16,  0,  0, 26, 36, 72,  5, 94, 36,132,255,251, 60,  2,  0,255,
/* 0x1870 */  52, 66,255,255,  0, 79, 16, 43, 20, 64,  0,  8,  0,  0,  0,  0,
/* 0x1880 */  17,167,  0,102,  0, 15,122,  0,  0, 24, 26,  0,145,162,  0,  0,
/* 0x1890 */   0,  0,  0,  0,  0, 98,192, 37, 37,173,  0,  1,  0, 15,120, 66,
/* 0x18a0 */   3, 15, 16, 43, 20, 64,  0,  3,  0, 11, 88, 64,  3, 15,192, 35,
/* 0x18b0 */  53,107,  0,  1, 36,132,255,255, 20,128,255,237, 60,  2,  0,255,
/* 0x18c0 */  38,  8,  6, 68,  0, 11,113,  0, 36, 25,  0,  4, 36,  6,  0,  1,
/* 0x18d0 */  36,  5,  0,  1, 60,  2,  0,255, 52, 66,255,255,  0, 79, 16, 43,
/* 0x18e0 */  20, 64,  0,  9,  0,  5, 96, 64, 17,167,  0, 76,  0, 15,122,  0,
/* 0x18f0 */   0, 24, 26,  0,145,162,  0,  0,  0,  0,  0,  0,  0, 98,192, 37,
/* 0x1900 */  37,173,  0,  1,  0,  5, 96, 64,  1, 12, 88, 33,149, 99,  0,  0,
/* 0x1910 */   0, 15, 18,194,  0, 67,  0, 24,  0,  0, 32, 18,  3,  4, 16, 43,
/* 0x1920 */  16, 64,  0,  8, 36,  2,  8,  0,  0, 67, 16, 35,  0,  2, 17, 67,
/* 0x1930 */   0, 98, 16, 33,165, 98,  0,  0,  1,128, 40, 33, 16,  0,  0,  9,
/* 0x1940 */   0,128,120, 33,  1,228,120, 35,  3,  4,192, 35,  0,  3, 17, 66,
/* 0x1950 */   0, 98, 16, 35,165, 98,  0,  0, 36,162,  0,  1,  0,162, 40, 33,
/* 0x1960 */   1,198,112, 37, 39, 57,255,255, 23, 32,255,218,  0,  6, 48, 64,
/* 0x1970 */  37,209,  0,  1, 18, 32,  0, 26, 60,  2,  0,255, 38, 82,  0,  7,
/* 0x1980 */   1, 81, 16, 43, 20, 64,  0, 38, 36,  2,  0,  1,  1, 81, 16, 35,
/* 0x1990 */   2, 98, 88, 33,  2,106, 32, 33,  1, 64, 24, 33,145,110,  0,  0,
/* 0x19a0 */  36, 99,  0,  1,  1, 73, 16, 33, 36, 66,  0,  2, 16, 98,  0,  6,
/* 0x19b0 */ 160,142,  0,  0, 37,107,  0,  1,143,162,  0, 16,  0,  0,  0,  0,
/* 0x19c0 */  20, 98,255,246, 36,132,  0,  1,  0, 96, 80, 33,143,163,  0, 16,
/* 0x19d0 */   0,  0,  0,  0,  1, 67, 16, 43, 20, 64,253,166, 60,  2,  0,255,
/* 0x19e0 */  52, 66,255,255,  0, 79, 16, 43, 20, 64,  0,  4,  1,181, 40, 35,
/* 0x19f0 */  17,167,  0, 10, 37,173,  0,  1,  1,181, 40, 35,143,162,  0, 12,
/* 0x1a00 */   0,  0,  0,  0,172, 69,  0,  0,143,163,  0, 20,  0,  0,  0,  0,
/* 0x1a10 */ 172,106,  0,  0, 16,  0,  0,  2,  0,  0, 16, 33, 36,  2,  0,  1,
/* 0x1a20 */ 143,183,  0, 52,143,182,  0, 48,143,181,  0, 44,143,180,  0, 40,
/* 0x1a30 */ 143,179,  0, 36,143,178,  0, 32,143,177,  0, 28,143,176,  0, 24,
/* 0x1a40 */   3,224,  0,  8, 39,189,  0, 56,  0,  0,  0, 13, 39,189,255,252,
/* 0x1a50 */ 175,191,  0,  0,  0,164, 40, 32,172,230,  0,  0,140,227,  0,  0,
/* 0x1a60 */   0,133,192, 35,143,191,  0,  0,175,184,  0,  0,  0, 96, 32, 33,
/* 0x1a70 */   0,195, 40, 35,172,229,  0,  0, 36,  6,  0,  3, 36,  2, 16, 51,
/* 0x1a80 */   0,  0,  0, 12,143,162,  0,  0,  3,224,  0,  8, 39,189,  0,  4,
/* 0x1a90 */  36,  6,  0, 30,  4, 17,255,255,  3,224, 40, 33, 80, 82, 79, 84,
/* 0x1aa0 */  95, 69, 88, 69, 67,124, 80, 82, 79, 84, 95, 87, 82, 73, 84, 69,
/* 0x1ab0 */  32,102, 97,105,108,101,100, 46, 10,  0,  0,  0, 36,  4,  0,  2,
/* 0x1ac0 */  36,  2, 15,164,  0,  0,  0, 12, 36,  4,  0,127, 36,  2, 15,161,
/* 0x1ad0 */   0,  0,  0, 12, 39,189,255,224,175,188,  0, 16,  3,224, 32, 33,
/* 0x1ae0 */  36,  5,  0,  0, 36,  2, 15,165,  0,  0,  0, 12,175,162,  0, 20,
/* 0x1af0 */ 143,194,255,244, 39,213,255,244, 36,  8,255,255,142,147,  0,  0,
/* 0x1b00 */  36,  7,  8,  2,  2,162,168, 34, 36,  4,  0,  0,  2,149, 16, 34,
/* 0x1b10 */   2, 98, 40, 32,175,165,  0, 28,  4, 17,  0, 41,  0,160,136, 33,
/* 0x1b20 */ 175,162,  0, 24,142,130,  0,  4,  2, 51, 40, 34,143,168,  0, 20,
/* 0x1b30 */  36,  7,  0, 18,  0,162, 40, 32,  4, 17,  0, 33,143,164,  0, 24,
/* 0x1b40 */   0, 85,144, 34,  3,192,248, 33,  3,210,240, 32,142,144,255,252,
/* 0x1b50 */  38,132,  0, 12,  2,146,160, 32,  2,147, 72, 32,  3,220, 64, 36,
/* 0x1b60 */ 175,168,  0,  8,  1, 40, 72, 34,175,169,  0, 12,130,136,  0,  8,
/* 0x1b70 */ 175,179,  0,  0,  2,128, 48, 33,142,133,  0,  4,  3,224,248,  9,
/* 0x1b80 */   3,160, 56, 33,142,130,  0,  0,  0, 28, 26, 66, 48, 99,255,255,
/* 0x1b90 */   0, 67, 16, 37,174,130,  0,  0, 36,  6,  0,  5,143,165,  0, 12,
/* 0x1ba0 */ 143,164,  0,  8, 36,  2, 16, 29,  0,  0,  0, 12, 34,159,  0, 16,
/* 0x1bb0 */ 143,209,255,244,  2,176,128, 32,  3,224,  0,  8,  2, 18,128, 32,
/* 0x1bc0 */  36,  9,  0,  0, 36,  6,  0,  3, 39,189,255,224,175,168,  0, 16,
/* 0x1bd0 */ 175,169,  0, 20, 36,  2, 15,250,  0,  0,  0, 12, 20,224,  0,  3,
/* 0x1be0 */   0,  0,  0,  0,  3,224,  0,  8, 39,189,  0, 32,  0,  0,  0, 13,
/* 0x1bf0 */ 140,131,  0,  0, 36,132,  0,  4, 20, 96,255,253,  0,128,176, 33,
/* 0x1c00 */   3,224,  0,  8, 36,  8,  0,  6,  4, 17,255,249,  3,160, 32, 33,
/* 0x1c10 */   4, 17,255,247,  2,192, 32, 33,140,131,  0,  0, 36,132,  0,  8,
/* 0x1c20 */  16,104,  0,  3,140,130,255,252, 20, 96,255,251, 36,  2, 16,  0,
/* 0x1c30 */   0,  2,224, 34,  4, 17,255,167, 39,244,  0, 20, 47,112,114,111,
/* 0x1c40 */  99, 47,115,101,108,102, 47,101,120,101,  0,  0,  0,  0,  0,  0,
/* 0x1c50 */ 102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 51,
/* 0x1c60 */  50, 45, 98,105,103,109,105,112,115, 10, 10, 83,101, 99,116,105,
/* 0x1c70 */ 111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32,
/* 0x1c80 */  32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32,
/* 0x1c90 */  32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32,
/* 0x1ca0 */  32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,
/* 0x1cb0 */ 108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 69,
/* 0x1cc0 */  76, 70, 77, 65, 73, 78, 88, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x1cd0 */  48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1ce0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1cf0 */  48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1d00 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x1d10 */  79, 78, 76, 89, 10, 32, 32, 49, 32, 78, 82, 86, 50, 69, 32, 32,
/* 0x1d20 */  32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 53, 52, 32,
/* 0x1d30 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1d40 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 99, 32, 32, 50,
/* 0x1d50 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1d60 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1d70 */  32, 50, 32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d80 */  32, 48, 48, 48, 48, 48, 49, 52, 52, 32, 32, 48, 48, 48, 48, 48,
/* 0x1d90 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1da0 */  48, 48, 48, 48, 49, 57, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1db0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x1dc0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 78, 82, 86,
/* 0x1dd0 */  50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1de0 */  49, 50, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1df0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,100,
/* 0x1e00 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1e10 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1e20 */  76, 89, 10, 32, 32, 52, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x1e30 */  48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 57, 99, 32, 32, 48,
/* 0x1e40 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e50 */  48, 32, 32, 48, 48, 48, 48, 48, 51,102, 99, 32, 32, 50, 42, 42,
/* 0x1e60 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x1e70 */  68, 79, 78, 76, 89, 10, 32, 32, 53, 32, 76, 90, 77, 65, 95, 68,
/* 0x1e80 */  69, 67, 50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 97,100, 56,
/* 0x1e90 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1ea0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 57, 56, 32, 32,
/* 0x1eb0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1ec0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 76, 90, 77,
/* 0x1ed0 */  65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1ee0 */  97,100, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1ef0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,102, 55,
/* 0x1f00 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1f10 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32,
/* 0x1f20 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48,
/* 0x1f30 */  48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f40 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1f50 */  49, 97, 52, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1f60 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1f70 */  32, 56, 32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32,
/* 0x1f80 */  32, 48, 48, 48, 48, 48, 48, 49, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1f90 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1fa0 */  48, 48, 48, 49, 97, 52, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1fb0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1fc0 */  89, 10, 32, 32, 57, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 32,
/* 0x1fd0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 48, 32, 32, 48, 48,
/* 0x1fe0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ff0 */  32, 32, 48, 48, 48, 48, 49, 97, 53, 99, 32, 32, 50, 42, 42, 48,
/* 0x2000 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x2010 */  79, 78, 76, 89, 10, 32, 49, 48, 32, 67, 70, 76, 85, 83, 72, 32,
/* 0x2020 */  32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 52, 32,
/* 0x2030 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2040 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 54, 99, 32, 32, 50,
/* 0x2050 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x2060 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 69, 76, 70, 77,
/* 0x2070 */  65, 73, 78, 89, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2080 */  50, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2090 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 57, 48,
/* 0x20a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x20b0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x20c0 */  89, 10, 32, 49, 50, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 32,
/* 0x20d0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 57, 52, 32, 32, 48, 48,
/* 0x20e0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x20f0 */  32, 32, 48, 48, 48, 48, 49, 97, 98, 99, 32, 32, 50, 42, 42, 50,
/* 0x2100 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x2110 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66,
/* 0x2120 */  79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48,
/* 0x2130 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 84,
/* 0x2140 */  65, 73, 76,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86,
/* 0x2150 */  95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x2160 */  32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,  9,
/* 0x2170 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x2180 */  90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x2190 */ 100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,  9, 48, 48, 48, 48,
/* 0x21a0 */  48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48,
/* 0x21b0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x21c0 */  82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82,
/* 0x21d0 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x21e0 */  32, 32,100, 32, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48,
/* 0x21f0 */  48, 48, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x2200 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66,
/* 0x2210 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 66, 10,
/* 0x2220 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2230 */  32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48, 48, 48,
/* 0x2240 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10,
/* 0x2250 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2260 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48,
/* 0x2270 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2280 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2290 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48,
/* 0x22a0 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x22b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x22c0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48,
/* 0x22d0 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10,
/* 0x22e0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x22f0 */  32, 78, 82, 86, 95, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48,
/* 0x2300 */  48, 48, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48,
/* 0x2310 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 70, 76,
/* 0x2320 */  85, 83, 72,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 70, 76,
/* 0x2330 */  85, 83, 72, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x2340 */  32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89,  9, 48, 48,
/* 0x2350 */  48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 10,
/* 0x2360 */  48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 79,
/* 0x2370 */  32, 69, 76, 70, 77, 65, 73, 78, 88,  9, 48, 48, 48, 48, 48, 48,
/* 0x2380 */  48, 48, 32, 95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x2390 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x23a0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 79, 95, 66, 73, 78, 70,
/* 0x23b0 */  79, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x23c0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65,
/* 0x23d0 */  73, 78, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x23e0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x23f0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2400 */  82, 95, 77, 73, 80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32,
/* 0x2410 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 10, 82, 69, 76, 79,
/* 0x2420 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x2430 */  79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83,
/* 0x2440 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x2450 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x2460 */  48, 48, 48, 55, 99, 32, 82, 95, 77, 73, 80, 83, 95, 80, 67, 49,
/* 0x2470 */  54, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76,
/* 0x2480 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x2490 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93,
/* 0x24a0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x24b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x24c0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 55, 99, 32, 82, 95, 77, 73,
/* 0x24d0 */  80, 83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x24e0 */  86, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x24f0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x2500 */  78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x2510 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2520 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 54,
/* 0x2530 */  52, 32, 82, 95, 77, 73, 80, 83, 95, 80, 67, 49, 54, 32, 32, 32,
/* 0x2540 */  32, 32, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 10, 82, 69,
/* 0x2550 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x2560 */  32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 89, 93, 58,
/* 0x2570 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x2580 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x2590 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 77, 73, 80,
/* 0x25a0 */  83, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x25b0 */  77, 65, 73, 78, 90, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x25c0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69,
/* 0x25d0 */  76, 70, 77, 65, 73, 78, 90, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x25e0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x25f0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x2600 */  49, 57, 48, 32, 82, 95, 77, 73, 80, 83, 95, 51, 50, 32, 32, 32,
/* 0x2610 */  32, 32, 32, 32, 32, 32, 79, 95, 66, 73, 78, 70, 79, 10
};
