/*
 Uptime Client v5.0 beta

 $Id: uplog.h,v 1.11 2003/05/26 20:57:23 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 1999-2002 Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 */

/**
 * @filename    uplog.h
 */

#if !defined UPLOG_H
#define UPLOG_H 1

/**
 * Emulate <syslog.h>
 */
#if !defined PLATFORM_WINNT && !defined PLATFORM_BEOS
#   if !defined SYSLOG_H
#      define SYSLOG_H
#      include <syslog.h>
#   endif /* !SYSLOG_H */
#else
#   include "compat/syslog.h"
#endif /* !PLATFORM_WINNT && !PLATFORM_BEOS*/

/**
 * for FreeBSD <syslog.h>
 */
#if !defined __printflike
#   define __printflike(a, b)
#endif

extern void uplog(int, const char *, ...);

#endif /* !UPLOG_H */
