/*@unused@*/ static const char rcsid[] =
    "@(#)$Id: uplog.c,v 1.14 2002/11/19 01:02:31 carstenklapp Exp $";

/*
 Uptime Client v5.0 beta
 
 $Id: uplog.c,v 1.14 2002/11/19 01:02:31 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 2002 Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 */

/**
 * @filename    uplog.c
 *
 * @desc        System logging functions
 */

/* System includes */
#if !defined PLATFORM_WINNT
#endif /* !PLATFORM_WINNT */
#include <stdio.h>
#include <stdarg.h>

/* My includes */
#include "uplog.h"

/**
 * @desc    Wrapper function for syslog
 */
void
uplog(int priority, const char *message, ...)
{
    va_list args;

   /* FIXME: callers must be careful not to pop this */
    char   formattedMessage[1024];

    va_start(args, message);    /* initialize vararg mechanism */
    vsprintf(formattedMessage, message, args);  /* build message */

   /* report the event */
#if defined SYSLOG_H
    openlog("upclient", LOG_PID, LOG_DAEMON);
    syslog(priority, (priority == LOG_DEBUG) ? "DEBUG: %s" : "%s",
           formattedMessage);
    closelog();
#else
   /* If syslog emulation in uplog.h fails, not much else we can do at this
      point. Try stderr. */
    fprintf(stderr, "upclient[]: %s\n", formattedMessage);
#endif /* SYSLOG_H */

    va_end(args);
}
