/*@unused@*/ static const char rcsid[] =
    "@(#)UpClient 5.0b8CVS -- $Id: upclient.c,v 1.56 2003/05/26 19:54:04 carstenklapp Exp $";

/*
 Uptime Client v5.0 beta

 $Id: upclient.c,v 1.56 2003/05/26 19:54:04 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 1999-2002 Martijn Broenland, Alex C. de Haas, Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 Alex C. de Haas <alex@uptimes.net>
 Martijn Broenland <tgm@uptimes.net>
 */

/**
 * @filename    upclient.c
 */

/* Common system includes */
#include <stdio.h>

/*#include <stdlib.h>*/
#include <errno.h>
#include <string.h>

/* Include if not compiling on WinNT */
#if !defined PLATFORM_WINNT
#include <unistd.h>
#include <sys/types.h>  /* size_t */
/*    #include <netdb.h>*/

/*    #include <netinet/in.h>*/
#include <sys/socket.h>

/*    #include <sys/utsname.h>*/
#endif /* !PLATFORM_WINNT */

/* Include if not compiling on WinNT or BeOS */
#if !defined PLATFORM_WINNT && !defined PLATFORM_BEOS
#   include <sysexits.h>
                                                              /* # include <arpa/inet.h> *//* not for
                                                                 NetBSD? */
#elif
#   include "compat/sysexits.h"
#endif

#if defined PLATFORM_LINUX
#   include <signal.h>
#   include <netdb.h>
#endif /* PLATFORM_LINUX */

#if defined PLATFORM_WINNT
    /* Special Windows includes */
#   include <windows.h>
#endif /* PLATFORM_WINNT */

#if defined PLATFORM_BEOS
    /* Special BeOS includes */
#   include <OS.h>
#   include <netdb.h>
#endif /* PLATFORM_BEOS */

#if defined PLATFORM_ULTRIX

    /**
     * Special Ultrix includes. Are they all needed here in
     * upclient.c? or only in stats-sol.c?
     */
#   include <fcntl.h>
#   include <nlist.h>
#   include <sys/fixpoint.h>
#   include <sys/cpudata.h>
#endif

#if defined PLATFORM_AIX

    /**
     * Special AIX includes. Are they all needed in in upclient.c? or
     * only in stats-aix.c?
     */
#   include <utmp.h>
#   include <fcntl.h>
#   include <sys/nlist.h>
#   include <sys/select.h>
#   include <sys/sysinfo.h>
#   include <sys/systemcfg.h>
#endif

#if defined PLATFORM_SOLARIS
#   include <signal.h>
#   include <netdb.h>
#endif /* PLATFORM_SOLARIS */

#if defined PLATFORM_BSD
#   include <signal.h>
#endif /* PLATFORM_BSD */

/* Satisfy our own needs */
#include "upclient.h"
#include "version.h"
#include "options.h"
#include "stats.h"
#include "uplog.h"      /* wrapper for <syslog.h> */
#include "transmit.h"

#if defined PLATFORM_UNIXWARE
#   if !defined HOURS_PER_DAY
#      define HOURS_PER_DAY 60;
#   endif /* !defined HOURS_PER_DAY */

#   if !defined MINUTES_PER_HOUR
#      define MINUTES_PER_HOUR 60;
#   endif /* !defined MINUTES_PER_HOUR */

#   if !defined SECONDS_PER_MINUTE
#      define SECONDS_PER_MINUTE 60;
#   endif /* !defined SECONDS_PER_MINUTE */

/* Calculate idle time as an average over the whole day */
#   define NUM_IDLE_ELEMENTS ((HOURS_PER_DAY * MINUTES_PER_HOUR * SECONDS_PER_MINUTE) / INTERVAL)
int    past_idle_times[NUM_IDLE_ELEMENTS] = { -1 };
#endif /* PLATFORM_UNIXWARE */

#include "locale.h"     /* gettext */

/* local */
#if !defined PLATFORM_WINNT
#   include <sys/time.h>
struct itimerval timer;
#endif /* !PLATFORM_WINNT */

int    main(int argc, char **argv);
void   print_version(void);
void   usage(void);
void   daemon_timertick( /* @unused@ */ int signum);
void   parent_check_oldPidfile_exists(void);
void   daemon_termination_handler(int signum);
void   daemon_hup_handler(int signum);
void   parent_write_pidfile(pid_t pid);
void   parent_end_message(pid_t pid);
void   daemon_setup_signalHandlers(void);
void   daemon_delete_pidfile(void);
void   daemon_hello_syslog(void);
void   daemon_startTimer(void);

/**
 * @desc    For most Unices, this makes Upclient ticks
 */
void
daemon_timertick( /* @unused@ */ int signum)
{
    send_update();
}

/**
 * @desc    Examine existing process ID file to see if an upclient
 *          process is aleady running.
 */
void
parent_check_oldPidfile_exists(void)
{
    FILE  *fp;

#if defined PLATFORM_SOLARIS
    int    pid = 0;
#else
    pid_t  pid = 0;
#endif /* PLATFORM_SOLARIS */
    int    killerr;

    fp = fopen(cfg_pidfile, "r");
    if (fp) {
       /* The pidfile exists. Now see if the process is still running */
        if (!fscanf(fp, "%d", &pid))
            pid = 0;
        if (fclose(fp)) {
            uplog(LOG_ERR, "%s parent_check_oldPidfile_exists() %s",
                  _("ERROR:"), strerror(errno));
            fprintf(stderr, "%s parent_check_oldPidfile_exists() %s",
                    _("ERROR:"), strerror(errno));
        }
        if (pid) {
            if (verbose > 2) {
                uplog(LOG_INFO, "%s %s\n", _("verbose 3:"),
                      _("Found a stale pidfile."));
                fprintf(stderr, "upclient: %s %s\n", _("verbose 3:"),
                        _("Found a stale pidfile."));
            }
            killerr = kill(pid, 0);
#if defined DEBUG
            uplog(LOG_DEBUG, "killerr %s (%d) %s\n", _("ERROR:"), errno,
                  strerror(errno));
            fprintf(stderr, "upclient DEBUG: killerr %s (%d) %s\n", _("ERROR:"),
                    errno, strerror(errno));
#endif /* DEBUG */
            if (killerr && (errno == 3)) {      /* No such process */
               /* A pidfile was found but no process is running (that we could
                  detect). If verbose==2 then we haven't already output a
                  message due to verbose==3 so show one now */
                if (verbose == 2) {
                    uplog(LOG_INFO, "%s %s\n", _("verbose 2:"),
                          _("Found a stale pidfile."));
                    fprintf(stderr, "upclient: %s %s\n", _("verbose 2:"),
                            _("Found a stale pidfile."));
                }
            }
            else if ((killerr && (errno == ESRCH || errno == EPERM)) ||
                     !killerr) {
                uplog(LOG_ERR, "%s pid=[%d]", _("upclient is already running."),
                      pid);
                fprintf(stderr, "%s pid=[%d]\n",
                        _("upclient is already running."), (int)pid);
                exit(EX_CANTCREAT);
            }
            else {
                uplog(LOG_ERR,
                      "%s unknown error parent_check_oldPidfile_exists() %s",
                      _("ERROR:"), strerror(errno));
                fprintf(stderr,
                        "%s unknown error parent_check_oldPidfile_exists() %s\n",
                        _("ERROR:"), strerror(errno));
            }
        }
    }
    else {
       /* probably no pidfile or could not open pidfile. Should probably check
          which and quit if could not open. */
#if defined DEBUG
        fprintf(stderr, "upclient: DEBUG: %s %d %s (don't panic)\n",
                _("ERROR:"), errno, strerror(errno));
        uplog(LOG_DEBUG, "%s %d %s (don't panic)\n", _("ERROR:"), errno,
              strerror(errno));
#endif /* DEBUG */
    }
   /* Okay to go. */
}

/**
 * @desc    For Unices, write a nice process ID file.
 */
void
parent_write_pidfile(pid_t pid)
{
    FILE  *fp;

    fp = fopen(cfg_pidfile, "w");
    if (!fp) {
        uplog(LOG_ERR, "%s %s %s", _("FATAL ERROR:"), _("Can't write pidfile:"),
              strerror(errno));
        fprintf(stderr, "upclient: %s %s %s\n", _("FATAL ERROR:"),
                _("Can't write pidfile:"), strerror(errno));
        kill(pid, SIGKILL);     /* reap my child */
        exit(EX_CANTCREAT);
    }
    fprintf(fp, "%d\n", (int)pid);
    if (verbose > 1) {
        uplog(LOG_INFO, "%s %s %s", _("verbose 2:"), _("Writing pidfile:"),
              cfg_pidfile);
        fprintf(stderr, "upclient: %s %s %s\n", _("verbose 2:"),
                _("Writing pidfile:"), cfg_pidfile);
    }
    if (fclose(fp)) {
        uplog(LOG_ERR, "unable to close pidfile after writing %s",
              strerror(errno));
        fprintf(stderr, "unable to close pidfile after writing %s",
                strerror(errno));
        exit(EX_CANTCREAT);
    }
}

/**
 * @desc    Cleanup pid file before quitting
 */
void
daemon_delete_pidfile(void)
{

    if (verbose > 1) {
        uplog(LOG_INFO, "%s %s %s", _("verbose 2:"), _("Removing pidfile:"),
              cfg_pidfile);
    }
    if ((errno = unlink(cfg_pidfile))) {
        uplog(LOG_NOTICE, "%s %s %s", _("NOTE:"),
              _("Unable to remove pidfile:"), strerror(errno));
    }
}

/**
 * @desc    Function called to cleanup before quitting, when TERM signal
 *          received
 */
void
daemon_termination_handler(int signum)
{
   /* cleanup before termination */
    daemon_delete_pidfile();

   /* buh bye */
    uplog(LOG_INFO, _("Uptime Client %s terminated, signal %d"),
          UPCLIENT_VERSION, signum);
    if (SIG_ERR == signal(signum, daemon_termination_handler))
        uplog(LOG_ERR, "daemon_termination_handler %s", strerror(errno));

    exit(EX_OK);        /* That's all Folks! */
}

/**
 * @desc    Function called when HUP signal received
 */
void
daemon_hup_handler(int signum)
{
/* #if defined DEBUG */
    uplog(LOG_INFO,
          _("Uptime Client %s received signal %d so reloading config file."),
          UPCLIENT_VERSION, signum);

/* #endif */
    if (SIG_ERR == signal(signum, daemon_hup_handler))
        uplog(LOG_ERR, "daemon_hup_handler %s", strerror(errno));
    read_config();
    timer.it_interval.tv_sec = cfg_interval;
    if (setitimer(ITIMER_REAL, &timer, NULL) == -1) {
        uplog(LOG_ERR, "%s reset setitimer(): %s", _("FATAL ERROR:"),
              strerror(errno));
        exit(EX_OSERR);
    }

    if (verbose > 1) {
        uplog(LOG_INFO, _("verbose: Interval timer reset: %d s."),
              cfg_interval);
    }
}

/**
 * @desc    Parent process prints version string to stderr
 */
void
print_version(void)
{
    fprintf(stderr,
            _("UpClient %s by Carsten Klapp <carstenklapp@users.sf.net>\n"),
            UPCLIENT_VERSION);
}

/**
 * @desc    Parent process prints usage info to stderr when user runs
 *          upclient -h
 */
void
usage(void)
{
   /* BETA NOTICE */
    fprintf(stderr, "\n%s\n\n",
            _
            ("This is beta software. Please report UpClient 5 problems and success \nstories to <carstenklapp@users.sf.net>"));
    print_version();
    fprintf(stderr, "  %s upclient [-hqVvv]\n", _("Usage:"));
    fprintf(stderr, "  %s %s\n\n", _("Configuration file:"), CONFIGFILE);
    fprintf(stderr, "  %s\n", _("Read the man page for more information."));
}

/**
 * @desc    Parent process prints final message to stderr before dying
 *          that daemon is running and what the child's pid is. But let the
 *          child also report these messages to syslog so the child's pid will
 *          be shown there.
 */
void
parent_end_message(pid_t pid)
{
    int    ipid = (int)pid;     /* only using pid within a formatted string
                                   from here on */

    char   message[1024];

    sprintf(message, _("Uptime Client %s started"), UPCLIENT_VERSION);
    fprintf(stderr, "upclient[%d]: %s\n", ipid, message);

    if (verbose > 1) {
        char   message[1024];

        sprintf(message, _("Verbose level is %d."), verbose);
        fprintf(stderr, "upclient[%d]: %s\n", ipid, message);
    }
    if (verbose < 1) {
        fprintf(stderr, "upclient[%d]: %s\n", ipid,
                _
                ("Quiet mode enabled, no uptime transmissions will be logged."));
    }
#if defined DEBUG
    fprintf(stderr, "upclient[%d]: %s\n", ipid, _("DEBUG mode enabled"));
    if (verbose == 0) {
        char   message[1024];

        sprintf(message, _("Verbose level is %d."), verbose);
        fprintf(stderr, "upclient[%d]: DEBUG: %s\n", ipid, message);
    }
#endif /* DEBUG */
#if defined PARANOID
    fprintf(stderr, "upclient[%d]: %s\n", ipid, _("PARANOID mode enabled"));
#endif /* PARANOID */
    fprintf(stderr, "upclient[%d]: %s\n", ipid,
            _
            ("This is beta software. Please report UpClient 5 problems and success stories to <carstenklapp@users.sf.net>"));
}

/**
 * @desc    Daemon-child's first words
 */
void
daemon_hello_syslog(void)
{
/* first message from child to syslog */
    uplog(LOG_INFO, _("Uptime Client %s started"), UPCLIENT_VERSION);
    if (verbose > 0) {
        uplog(LOG_INFO, _("Verbose level is %d."), verbose);
    }
    if (verbose < 1) {
        uplog(LOG_INFO,
              _("Quiet mode enabled, no uptime transmissions will be logged."));
    }
#if defined DEBUG
    uplog(LOG_INFO, _("DEBUG mode enabled"));
    if (verbose == 0) {
        char   message[1024];

        sprintf(message, _("Verbose level is %d."), verbose);
        uplog(LOG_DEBUG, "%s", message);
    }
#endif /* DEBUG */
#if defined PARANOID
    uplog(LOG_INFO, _("PARANOID mode enabled"));
#endif /* PARANOID */
    uplog(LOG_INFO,
          _
          ("This is beta software. Please report UpClient 5 problems and success stories to <carstenklapp@users.sf.net>"));
}

/**
 * @desc    Daemon starts up a repeating timer and designates a function
 *          to hande the alarm signal
 */
#if !defined PLATFORM_UNIXWARE && !defined PLATFORM_WINNT && !defined PLATFORM_BEOS
void
daemon_startTimer(void)
{
    struct sigaction sa;

    sigemptyset(&sa.sa_mask);
    sa.sa_flags = 0;
#if defined SA_RESTART
    sa.sa_flags |= SA_RESTART;
#endif /* SA_RESTART */
#if defined SA_INTERRUPT
    sa.sa_flags &= ~SA_INTERRUPT;
#endif /* SA_INTERRUPT */
   /* establish handler fuction for alarm signal */
    sa.sa_handler = daemon_timertick;
    if (sigaction(SIGALRM, &sa, NULL) == -1) {
       /* perror("sigaction"); */
        uplog(LOG_ERR, "%s sigaction() %s", _("FATAL ERROR:"), strerror(errno));
        exit(EX_OSERR);
    }

    timer.it_value.tv_sec = 1;
    timer.it_value.tv_usec = 0;
    timer.it_interval.tv_sec = cfg_interval;
    timer.it_interval.tv_usec = 0;

    if (verbose > 2) {
        uplog(LOG_INFO, "%s Interval timer set: %d s.", _("verbose 3:"),
              cfg_interval);
    }

    if (setitimer(ITIMER_REAL, &timer, NULL) == -1) {
       /* perror("setitimer"); */
        uplog(LOG_ERR, "%s setitimer() %s", _("FATAL ERROR:"), strerror(errno));
        exit(EX_OSERR);
    }
}
#endif

/**
 * @desc    Daemon designates functions to hande various OS signals:
 *          TERM, HUP
 */
#if !defined PLATFORM_WINNT
void
daemon_setup_signalHandlers(void)
{
   /* ignore SIGTERM and call termination_handler */
    if (signal(SIGTERM, daemon_termination_handler) == SIG_IGN) {
        if (SIG_ERR == signal(SIGTERM, SIG_IGN))
            uplog(LOG_ERR,
                  "daemon_setup_signalHandlers: daemon_termination_handler: SIGTERM %s",
                  strerror(errno));
    }

    if (SIG_ERR == signal(SIGINT, SIG_IGN))     /* ignore SIGINT */
        uplog(LOG_ERR, "daemon_setup_signalHandlers SIGINT %s",
              strerror(errno));
   /* designate handler for SIGHUP (to reread config file) */
    if (signal(SIGHUP, daemon_hup_handler) == SIG_IGN) {
        struct sigaction sa;

        if (SIG_ERR == signal(SIGHUP, SIG_IGN))
            uplog(LOG_ERR,
                  "daemon_setup_signalHandlers: daemon_hup_handler SIGHUP %s",
                  strerror(errno));
       /* See
          http://users.mat.unimi.it/~dip/software/linux/howto/GCC-HOWTO-4.html */

        sigaction(SIGHUP, (struct sigaction *)0, &sa);
#if defined SA_RESTART
        sa.sa_flags |= SA_RESTART;
#endif /* SA_RESTART */
#if defined SA_INTERRUPT
        sa.sa_flags &= ~SA_INTERRUPT;
#endif /* SA_INTERRUPT */
        sigaction(SIGHUP, &sa, (struct sigaction *)0);
    }
}
#endif /* !defined PLATFORM_WINNT */

/**
 * @desc    If you don't know what this does, please leave Right Now
 */
int
main(int argc, char **argv)
{
   /* struct itimerval timer; */
#if !defined PLATFORM_WINNT
   /* Yet Another Warning Nullifyer (yawn) */
    pid_t  pid;
#endif /* !PLATFORM_WINNT */
#if defined PLATFORM_SOLARIS
    int    pauseResult; /* for pause() or sigsuspend() */
#endif /* PLATFORM_SOLARIS */
    int    i;

#define MAX_ARG_LEN 255
    char   argbuf[MAX_ARG_LEN];

   /* Tell Gettext where to find mo files */
#ifdef LOCALEPATH
    setlocale(LC_ALL, "");
    bindtextdomain("upclient", LOCALEPATH);
    textdomain("upclient");
#endif

   /* parse arguments */
#if defined DEBUG
    uplog(LOG_DEBUG,
          "------------------------------------------------------------");
    uplog(LOG_DEBUG, "Parsing command-line arguments");
#endif /* DEBUG */

   /**
    * Workaround for potential internal buffer overflow in older
    * implementations of getopt(), by suppressing default getopt error
    * message which is printed when an option error is discovered.
    *
    * http://www.tao.ca/writing/archives/security/0335.html
    */
    opterr = 0;

    while ((i = getopt(argc, argv, "hVvc:p:")) != -1) {
        switch (i) {
            case 'V':
                print_version();
                exit(EX_OK);
            case 'v':
                verbose++;
                break;
            case 'q':
                break;
            case 'c':
               /* truncate optarg before printing it out to avoid buffer
                  overflow */
                strncpy(argbuf, optarg, sizeof(argbuf) - 1);
                argbuf[sizeof(argbuf) - 1] = 0;
                uplog(LOG_NOTICE,
                      "Not using %.255s for config file (unimplemented).\n",
                      argbuf);
                fprintf(stderr,
                        "Not using %.255s for config file (unimplemented).\n",
                        argbuf);
                break;
            case 'p':
               /* truncate optarg before printing it out to avoid buffer
                  overflow */
                strncpy(argbuf, optarg, sizeof(argbuf) - 1);
                argbuf[sizeof(argbuf) - 1] = 0;
                uplog(LOG_NOTICE,
                      "Not using %.255s for pid file (unimplemented).\n",
                      argbuf);
                fprintf(stderr,
                        "Not using %.255s for pid file (unimplemented).\n",
                        argbuf);
                break;
            case 'h':
            case '?':
            default:
                usage();
                exit(EX_OK);
        }
    }
    argc -= optind;
    argv += optind;
    if (verbose > 3) {
        verbose = 3;    /* limit Maximum-Verbosity(tm) */
    }
    parent_check_oldPidfile_exists();   /* check whether upclient is already
                                           running */
    read_config();      /* Read configuration file */

#if !defined PLATFORM_WINNT
   /* && !defined DEBUG */
   /* Fork into background */
    pid = fork();
    if (pid < 0) {
       /* error encountered, no child has been created! */
        fprintf(stderr, "%s fork(): %s (%s)\n", _("FATAL ERROR:"),
                _("Couldn't fork into background"), strerror(errno));
        exit(EX_OSERR);
    }
    if (pid != 0) {
       /* sleep a few seconds before quitting so any outstanding stderr
          messages don't clobber the appearance of the shell prompt, which
          might confuse the user */

        (void)sleep(2);
       /* this is the parent, and hence should be terminated */
        exit(EX_OK);

    }   /* child continues */
   /* See: http://www.manualy.sk/sock-faq/unix-socket-faq-4.html */
   /* request a new session (job control) */
    if (setsid() == -1) {
        fprintf(stderr,
                "%s upclient[%d]: %s DEBUG: setsid()==[EPERM] Oops you shouldn't see this message\n",
                _("FATAL ERROR:"), (int)pid, UPCLIENT_VERSION);
        uplog(LOG_ERR,
              "%s upclient[%d]: %s DEBUG: setsid()==[EPERM] Oops you shouldn't see this message\n",
              _("FATAL ERROR:"), (int)pid, UPCLIENT_VERSION);
        exit(EX_OSERR);
    }
   /* Fork again to avoid potential zombie process */
    pid = fork();
    if (pid < 0) {
       /* error encountered, no grandchild has been created! */
        fprintf(stderr, "%s fork(): %s (%s)\n", _("FATAL ERROR:"),
                _("Couldn't fork into background"), strerror(errno));
        exit(EX_OSERR);
    }
    if (pid != 0) {
        parent_write_pidfile(pid);
        parent_end_message(pid);
        exit(EX_OK);    /* this is the child, hence should exit */
    }
   /**
    * Grandchild continues, do some prep work
    */
   /* close STDOUT, STDIN, STDERR file descriptors */
    if (close(0))       /* STDIN_FILENO */
        uplog(LOG_ERR, "close(0) %s", strerror(errno));
    if (close(1))       /* STDOUT_FILENO */
        uplog(LOG_ERR, "close(1) %s", strerror(errno));
    if (close(2))       /* STDERR_FILENO */
        uplog(LOG_ERR, "close(2) %s", strerror(errno));
   /* lose file creation mode mask inherited by parent */
    (void)umask(0);
   /* change to working dir, none needed for upclient */
    if (chdir("/"))
        uplog(LOG_ERR, "chdir(\"/\") %s", strerror(errno));

    daemon_hello_syslog();      /* greet syslog */
   /* Designate signal handler functions which will do clean up before
      termination */

    daemon_setup_signalHandlers();

#endif /* !PLATFORM_WINNT */

   /**
    * Set the alarm then go to sleep...
    *
    * http://www.opengroup.org/onlinepubs/007904975/functions/sleep.html
    */

#if !defined PLATFORM_UNIXWARE && !defined PLATFORM_WINNT && !defined PLATFORM_BEOS
   /* Setup the timer */
   /* DEBUGGING: use 'sudo kill -SIGALRM `cat /var/run/upclient.pid`' to force
      an immediate uptime transmission. */
    daemon_startTimer();
   /* Now go idle(tm) */
    for (;;) {
      /** 
       *  NOTE: Solaris just loops and does nothing if we use sleep()!
       *  This might occur on other systems too!!
       *
       *  The problem is POSIX doesn't define how an OS should handle
       *  catching of signals during sleep, so an alarm (or other
       *  non-critical signals) might go unnoticed.
       *
       *  To overcome this unpredictable scenario we pause()
       *  instead. Pause is made obsolete by sigsuspend(2) <signal.h>
       *  but causes a race condition on Solaris 7 & 8 where all cpu
       *  time is gobbled up.
       */
#if defined PLATFORM_SOLARIS
      /**
       * Keep trying to pause until the os doesn't give us an
       * error. Not sure if this is really needed but it doesn't seem
       * to hurt.
       */
        do {
            pauseResult = pause();
           /* pauseResult = sigsuspend(ITIMER_REAL); */
#if defined DEBUG
            uplog(LOG_DEBUG, "pause() said %s.", strerror(errno));
           /* uplog(LOG_DEBUG, "sigsuspend() said %s.", strerror(errno)); */
#endif /* DEBUG */
        } while ((pauseResult == -1) && (errno == EINTR));
#if defined DEBUG
        uplog(LOG_DEBUG, "Looping again.");
#endif /* DEBUG */
#else
        /**
	 * Sleep() works fine so long as the OS allows us to catch any
	 * alarms we might have missed when we wake up.
	 */
        (void)sleep((unsigned int)cfg_interval);

#endif /* defined PLATFORM_SOLARIS */
    }
#endif

#if defined PLATFORM_UNIXWARE
    for (;;) {
        send_update();
    }
#elif defined PLATFORM_BEOS
    for (;;) {
        send_update();
        (void)sleep((unsigned int)cfg_interval);
    }
#elif defined PLATFORM_WINNT
    startWinsock();
    printf("Uptime Client started\n");
    for (;;) {
        send_update();
#if !defined MILLISECONDS_PER_SECOND
#      define MILLISECONDS_PER_SECOND 1000
#endif /* !defined MILLISECONDS_PER_SECOND */
        Sleep(cfg_interval * MILLISECONDS_PER_SECOND);  /* sleep interval in
                                                           seconds */
    }
#endif

#if !defined PLATFORM_UNIXWARE  /* warning eater */
    return 1;
#endif /* !PLATFORM_UNIXWARE */
}
