/*
 Uptime Client v5.0 beta

 $Id: stats.h,v 1.24 2002/12/18 00:01:19 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 1999-2002 Martijn Broenland, Alex C. de Haas, Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 Alex C. de Haas <alex@uptimes.net>
 Martijn Broenland <tgm@uptimes.net>
 */

/**
 * @filename    stats.h
 */

#if !defined STATS_H
#define STATS_H 1

#if defined PLATFORM_BSD || defined PLATFORM_SOLARIS
#   include <time.h>
#endif /* PLATFORM_BSD || PLATFORM_SOLARIS */

extern void getstats(unsigned long *uptimeminutes, double *UsagePercent,
                     double *IdlePercent, char *osname, char *osversion,
                     char *cpu, double *loadavg);

#if defined PLATFORM_BSD || defined PLATFORM_SOLARIS
time_t initBoottime(void);
#endif /* PLATFORM_BSD || PLATFORM_SOLARIS */

#if defined PLATFORM_BSD || defined PLATFORM_SOLARIS || defined PLATFORM_LINUX || defined PLATFORM_BEOS
void   getUptime(unsigned long *uptimeminutes);
void   getLoadIdle(double *UsagePercent, double *IdlePercent);
void   getLoadavg(double *loadavg);
void   initOS(char *os, char *osversion);
void   initCPU(char *cpu);
void   logcalc(char *whatwascalculateddesc, char *value);

#endif /* PLATFORM_BSD || PLATFORM_SOLARIS || PLATFORM_LINUX || PLATFORM_BEOS */

/* Char array sizes */
#define OS_SIZE        16       /* As required by the Uptimes Protocol */
#define OSVERSION_SIZE 64       /* Protocol is not clear on this one */
#define CPU_SIZE       64       /* Protocol is not clear on this one either */

#endif /* !STATS_H */
