/*
 Uptime Client v5.0 beta
 
 $Id: stats-beos.c,v 1.23 2002/12/22 17:53:42 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 1999-2002 Martijn Broenland, Alex C. de Haas, Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 Alex C. de Haas <alex@uptimes.net>
 Martijn Broenland <tgm@uptimes.net>
 */

/**
 * @filename    stats-beos.c
 *
 * @desc        Retrieve stats for the BeOS platform
 */

#if defined PLATFORM_BEOS

/*@unused@*/ static const char rcsid[] =
    "@(#)$Id: stats-beos.c,v 1.23 2002/12/22 17:53:42 carstenklapp Exp $";

/* My includes */
#include "upclient.h"
#include "options.h"
#include "stats.h"

/* System includes */
#include <stdio.h>
#include <errno.h>
#include <sys/utsname.h>
#include <OS.h>

/**
 * @desc    Verbose level 3 logging of calulations
 */
void
logcalc(char *whatwascalculateddesc, char *value)
{
#if defined DEBUG
    uplog(LOG_DEBUG, _("%s calculated: %s"), whatwascalculateddesc, value);
#endif /* DEBUG */
}

/**
 * @desc    Get cpu once
 */
void
initCPU(char *cpu)
{
    static int initialized = 0;

    if (!initialized) {
        initialized = 1;
        struct utsname uts;

        strncpy(cpu, uts.machine, CPU_SIZE - 1);
        logcalc(_("CPU"), cpu);
    }
}

/**
 * @desc    Get os & osversion once
 */
void
initOS(char *osname, char *osversion)
{
    static int initialized = 0;

    if (!initialized) {
        struct utsname uts;

        initialized = 1;

        uname(&uts);

        if (cfg_sendosname) {
            strlcpy(osname, uts.sysname, OS_SIZE - 1);
            logcalc(_("OS"), osname);
        }

        if (cfg_sendosversion) {
            strlcpy(osversion, uts.release, OSVERSION_SIZE - 1);
            logcalc(_("OS version"), osversion);
        }
    }
}

/**
 * @desc    Get uptime
 */
void
getUptime(unsigned long *uptimeminutes)
{
    double up = 0;

   /* Get uptime */
    up = system_time();
    if (up == 0)
        up = 1;

    *uptimeminutes = (int)(up / 60000000);

#if defined DEBUG
    uplog(LOG_DEBUG, "getUptime() uptime: %d", *uptimeminutes);
#endif /* DEBUG */
}

void
getLoadIdle(double *UsagePercent, double *IdlePercent)
{
    if (cfg_SendUsage) {
        uplog(LOG_WARNING,
              _("%s %s not implemented for this operating system %s"),
              _("WARNING:"), _("Usage and idle percentages"), "(stats-beos.c)");
        cfg_SendUsage = 0;
    }
}

void
getLoadavg(double *loadavg)
{
    if (cfg_sendloadavg) {
        uplog(LOG_WARNING,
              _("%s %s not implemented for this operating system %s"),
              _("WARNING:"), _("Load-average"), "(stats-beos.c)");
        cfg_sendloadavg = 0;
    }
}

/**
 * @desc    Get statistics
 */
void
getstats(unsigned long *uptimeminutes, double *UsagePercent,
         double *IdlePercent, char *osname, char *osversion, char *cpu,
         double *loadavg)
{

    getUptime(&*uptimeminutes);

    if (cfg_SendUsage || cfg_SendIdle)
        getLoadIdle(&*UsagePercent, &*IdlePercent);

    if (cfg_sendosname || cfg_sendosversion)
        initOS(&*osname, &*osversion);

    if (cfg_sendcpu)
        initCPU(&*cpu);

    if (cfg_sendloadavg)
        getLoadavg(&*loadavg);

}
#endif /* PLATFORM_BEOS */
