/*
 Uptime Client v5.0 beta
 
 $Id: options.h,v 1.29 2003/05/26 19:54:04 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 1999-2002 Martijn Broenland, Alex C. de Haas, Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 Alex C. de Haas <alex@uptimes.net>
 Martijn Broenland <tgm@uptimes.net>
 */

/**
 * @filename    options.h
 */

#if !defined OPTIONS_H
#define OPTIONS_H 1

#define AUTHKEY_REQUIRED_LEN    32
#define UPSERVER_MAXLEN        256
#define PIDFILE_MAXLEN         256
#define PROXYSERVER_MAXLEN     256
#define PROXYUSER_MAXLEN        32
#define PROXYPASS_MAXLEN        32

#include "transmit.h"
#if !defined PLATFORM_WINNT && !defined PLATFORM_BEOS
#   include <netinet/in.h>      /* in_port_t */
#endif
/* Some Linux with old system headers might need this */
/* #if defined PLATFORM_LINUX
typedef uint16_t in_port_t;
                        #endif*//* PLATFORM_LINUX */

#if defined __APPLE__   /* in_port_t, Mac OS X Server */
#   if __APPLE_CC__ << 1151
#      include <sys/types.h>
typedef unsigned long in_port_t;
#   endif /* __APPLE_CC__ << 1151 */
#endif /* __APPLE__ */

/* External global variables: config options */
extern char cfg_authkey[AUTHKEY_REQUIRED_LEN + 1];
extern char cfg_upserver[UPSERVER_MAXLEN + 1];
extern long int cfg_interval;
extern char cfg_pidfile[PIDFILE_MAXLEN + 1];
extern char cfg_proxyserver[PROXYSERVER_MAXLEN + 1];
extern in_port_t cfg_udpport;
extern in_port_t cfg_proxyport;
extern char cfg_proxyuser[PROXYUSER_MAXLEN + 1];
extern char cfg_proxypass[PROXYPASS_MAXLEN + 1];
extern unsigned short int cfg_SendIdle;
extern unsigned short int cfg_SendUsage;
extern unsigned short int cfg_sendosname;
extern unsigned short int cfg_sendosversion;
extern unsigned short int cfg_sendcpu;
extern unsigned short int cfg_sendcpudetail;
extern unsigned short int cfg_sendloadavg;

/* External global variables: set to reflect config options */
extern unsigned short int have_proxyserver;
extern unsigned short int have_proxyuser;
extern unsigned short int verbose;

/* External functions */
extern void read_config(void);

#if !defined CONFIGFILE
#   define CONFIGFILE "/etc/upclient.conf"
#endif
#if !defined PIDFILE
#   define PIDFILE "/var/run/upclient.pid"
#endif

#endif /* !OPTIONS_H */
