.\"$Id: upclient.man,v 1.9 2003/05/26 21:35:19 carstenklapp Exp $
.\"
.Dd Tue Dec 2 2002      \" DATE 
.Dt __BINNAME__ 8          \" Program name and manual section number 
.Os GPL
.Sh NAME                \" Section Header - required - don't modify 
.Nm __BINNAME__
.\" The following lines are read in generating the apropos(man -k) database.
.\" Use only key words here as the database is built based on the words here
.\" and in the .ND line. 
.\" Use .Nm macro to designate other names for the documented program.
.Nd logs system uptime with
.Ar __UPTIMES_SERVER__ .

.Sh SYNOPSIS            \" Section Header - required - don't modify
.Op sudo
.Ic __BINNAME__
.Op -h
.Op -V
.Op -v|-vv|-vvv
.Pp
.Op sudo
.Ic kill `cat __PIDFILE__`

.Sh DESCRIPTION         \" Section Header - required - don't modify
.Nm Client for Ar The Uptimes Project
.Pp                     \" Inserts a space
The Uptimes Project collects data on the amount of time a computer has
been running since its last reboot and provides statistics on various
operating system and hardware configurations.
.Pp
Upon starting, the daemon logs a brief message to stderr and syslog
(on those operating systems that support syslog) then forks into the
background. If the daemon cannot start it will try to output error
messages to stderr and syslog. Normally the daemon runs quietly and
unobtrusively in the background.
.Pp
.Sh OPTIONS             \" Section Header - required - don't modify
.Bl -tag
By default no uptime transmissions will be logged. This means that
once __NAME__ has started, there will be no indication in the
system logs that __NAME__ is still running unless it encounters a
problem.
.It -v
Every few minutes whenever __NAME__ transmits data to the server an
entry will be recorded to syslog. This is useful for monitoring
whether __NAME__ is working.
.It -vv
Verbose-verbose mode. A few additional status and error messages will be
logged to aid basic troubleshooting.
.It -vvv
Verbose-verbose-verbose mode may be useful for troubleshooting or to satisfy
curiosity. To see even more status messages, __NAME__ can be compiled
in DEBUG mode (see below).
.It -h
Display a brief usage message and exit.
.It -V
Show the version and exit.
.El
.Pp
If you need to stop __NAME__, signal it with TERM and it will clean up
its pid file then quit. The easiest way to do this is
.Op sudo
.Ic kill `cat __PIDFILE__` . 
The daemon ignores INT signals.
.Pp

.Sh GETTING STARTED     \" Section Header - required - don't modify
 1. Create an account at:
.Ar http://uptimes.wonko.com/ .
 2. Add a host, this gives you an authorization key.
 3. Paste your auth key into
.Pa __CONFIGFILE__ .
 4. Start the upclient daemon:
.Op sudo
.Ic __SBINDIR__/__BINNAME__.
 5. Visit your account at
.Ar http://uptimes.wonko.com/
to view your
    machine's status and other collected statistics.
.Pp

.Sh CONTROLLING UPCLIENT
.Bl -tag

__NAME__ performs certain actions when it receives certain signals:
.It SIGALRM
Resets the timer and causes __NAME__ to transmit uptime status immediately.
.It SIGHUP
Tells __NAME__ to re-read the configuration file and restart.
.El

.Sh TROUBLESHOOTING     \" somebody help me.....
If you suspect a problem with __NAME__, check your
.Ar syslog
for upclient messages.
.Pp
.Ar "My AuthKey is correct but __NAME__ refuses to start due to 'ERROR:
.Ar AuthKey is not 32 bytes long!'".

Remove any enclosing braces < > from the authkey. As of 5.0b7 these
have been removed from the upclient.conf template to avoid confusion.
.Pp
.Ar "The uptime server is not receiving any reports. Everything appears
.Ar fine and my machine is not behind a firewall."

Make sure the client is not compiled with -DPARANOID. This flag is for
debugging only, it prevents any reports from actually being
transmitted.
.Pp
On BSD systems __NAME__ must be run as root to send usage and idle
time. As of __NAME__ 5.0b6, Darwin / Mac OS X no longer has this
requirement as new code was added for Mach-based systems where this
restriction does not apply.
.Pp
Use the following command to trigger an immediate __NAME__
transmission:
.Pp
.Op    sudo
kill -SIGALRM `cat __PIDFILE__`
.Pp
To have __NAME__ output many debugging messages to the syslog,
recompile it in debug mode. Set the EXTRA_CFLAGS envvar to '-DDEBUG',
or edit the Makefile to add '-DDEBUG' to the CFLAGS line in the
section appropriate for your system, like this:
.Pp
    CFLAGS='-DDEBUG' \\
.Pp

.Sh FILES               \" File used or created by the topic of the man page
.Bl -tag -compact
.It Pa __SBINDIR__/__BINNAME__
client
.It Pa __CONFIGFILE__
configuration
.It Pa __PIDFILE__
process id
.It Pa __DATADIR__/doc/__BINNAME__/
documentation
.El

.Sh AUTHORS
 Carsten Klapp <carstenklapp@users.sourceforge.net>
 Protocol 5 client
.Pp
 Ryan Grove <ryan@wonko.com>
 Protocol 5, Uptimes Server and web site
.Pp
 Alex C. de Haas <alex@uptimes.net>
 Protocol 4 client
.Pp
 Martijn Broenland <tgm@uptimes.net>
 Original Author
.Pp
Many people have contributed to the uptime client. Please see
__DATADIR__/doc/__BINNAME__/AUTHORS.

.Sh LICENSE
Copyright \(co 1999-2002 Martijn Broenland, Alex C. de Haas, Carsten Klapp
.Pp
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.
.Pp
This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
General Public License for more details.
.Pp
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

.Sh SEE ALSO 
.\" List links in ascending order by section, alphabetically within a
.\" section. Please do not reference files that do not exist without filing
.\" a bug report.
.Xr uptime 1 , 
.Xr ruptime 1 ,
.Xr getloadavg 3 ,
.Xr uname 3 ,
.Xr sysctl 8

.Sh BUGS                \" Document known, unremedied bugs 

IMPORTANT: 5.0b8 includes bug fixes to prevent potential buffer
overflows which could present a local root compromise on BSD-based
systems including Mac OS X. All upclient 5 beta users should upgrade
to 5.0b8 as soon as possible.

WARNING: There are potential security issues under Linux (strcpy in
stats-lns.c). For now this isn't a critical issue as upclient does not
require superuser priveleges to run under Linux. This will be fixed in
the next beta.

When __CONFIGFILE__ cannot be found at the compiled-in path, __NAME__
tries to find one in a couple other locations, and logs which one is
being used instead. If there are errors in the "alternate" config
file, __NAME__ will mention the name and path of the compiled-in
config file instead of the one found.

.Sh HISTORY             \" Document history if command behaves in a unique manner 
Version 5 by default transmits uptime information via UDP to port
49153 to reduce load on the server. If you are behind a closed
firewall or using a proxy server the client uses the older protocol
4.2 via HTTP instead, with the same functionality. See
__DATADIR__/doc/__BINNAME__/ for more information.
.Pp
$Id: upclient.man,v 1.9 2003/05/26 21:35:19 carstenklapp Exp $
