#!/bin/sh
#
# enumstr.sh - a tool generating a function mapping enumerator to its
# string representation
#
# Copyright (C) 2019 Masatake YAMATO
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Usage:
#
#  ./enumstr.sh <input-file> <enum-name> <fname> [PREFIX_FOR_TRIMMING]
#
# Example:
#
#   bash ./misc/enumstr.sh parsers/jscript.c eTokenType tokenTypeName
#
echo 'static const char *'"$3"'(enum '$2' e)'
printf '{ /* Generated by misc/enumstr.sh with cmdline '"\"$1\" \"$2\" \"$3\""
if [ -n "$4" ]; then
	echo " \"$4\""' */'
else
	echo ' */'
fi
echo '	switch (e)'
echo '	{'
./ctags --quiet --options=NONE -o - --languages=C --kinds-C=e -x --_xformat="%N enum:%s" $1 | grep $2 | while read N S; do
	n=$N
	if [ -n "$4" ]; then
		n=${N#$4}
	fi
	printf "		case %24s: return %s;\n" "$N" "\"$n\""
done
echo '		default: return "UNKNOWN";'
echo '	}'
echo '}'
