
First we'll add a definition:

```unison
ability DeathStar where
  attack : Text -> ()

spaceAttack1 x =
  y = attack "saturn"
  z = attack "neptune"
  "All done"
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These new definitions are ok to `add`:
    
      ability DeathStar
      spaceAttack1 : x ->{DeathStar} Text

```
Add it to the codebase:

```ucm
.> add

  ⍟ I've added these definitions:
  
    ability DeathStar
    spaceAttack1 : x ->{DeathStar} Text

```
Now we'll try to add a different definition that runs the actions in a different order. This should work fine:

```unison
spaceAttack2 x =
  z = attack "neptune"
  y = attack "saturn"
  "All done"
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These new definitions are ok to `add`:
    
      spaceAttack2 : x ->{DeathStar} Text

```
```ucm
.> add

  ⍟ I've added these definitions:
  
    spaceAttack2 : x ->{DeathStar} Text

```
Previously, this would fail because the hashing algorithm was being given one big let rec block whose binding order was normalized.
