Checks that squash and merge do the same thing, with nontrivial history that
includes a merge conflict.

```unison
x.a.p = "af"
x.a.q = "ef"
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These new definitions are ok to `add`:
    
      x.a.p : Text
      x.a.q : Text

```
```ucm
.> add

  ⍟ I've added these definitions:
  
    x.a.p : Text
    x.a.q : Text

.> fork x y

  Done.

.> fork x s

  Done.

.> fork x m

  Done.

.> delete y.a.p

  Name changes:
  
    Original    Changes
    1. m.a.p ┐  2. y.a.p (removed)
    3. s.a.p │  
    4. x.a.p │  
    5. y.a.p ┘  
  
  Tip: You can use `undo` or `reflog` to undo this change.

```
```unison
y.a.p = "fij"
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These new definitions are ok to `add`:
    
      y.a.p : Text

```
```ucm
.> add

  ⍟ I've added these definitions:
  
    y.a.p : Text

```
```unison
y.b.p = "wie"
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These new definitions are ok to `add`:
    
      y.b.p : Text

```
Merge back into the ancestor.

```ucm
.> add

  ⍟ I've added these definitions:
  
    y.b.p : Text

.> merge y.b y.a

  Here's what's changed in y.a after the merge:
  
  New name conflicts:
  
    1. p#a3ef1630bu : Text
       ↓
    2. ┌ p#a3ef1630bu : Text
    3. └ p#fjqpdmdeqi : Text
  
  Tip: You can use `todo` to see if this generated any work to
       do in this namespace and `test` to run the tests. Or you
       can use `undo` or `reflog` to undo the results of this
       merge.

.> delete.term 1

  Resolved name conflicts:
  
    1. ┌ y.a.p#a3ef1630bu : Text
    2. └ y.a.p#fjqpdmdeqi : Text
       ↓
    3. y.a.p#fjqpdmdeqi : Text
  
  Tip: You can use `undo` or `reflog` to undo this change.

.> merge y m

  Here's what's changed in m after the merge:
  
  Updates:
  
    1. a.p : Text
       ↓
    2. a.p : Text
  
  Added definitions:
  
    3. ┌ a.p : Text
    4. └ b.p : Text
  
  Tip: You can use `todo` to see if this generated any work to
       do in this namespace and `test` to run the tests. Or you
       can use `undo` or `reflog` to undo the results of this
       merge.

.> squash y s

  Here's what's changed in s after the merge:
  
  Updates:
  
    1. a.p : Text
       ↓
    2. a.p : Text
  
  Added definitions:
  
    3. ┌ a.p : Text
    4. └ b.p : Text
  
  Tip: You can use `todo` to see if this generated any work to
       do in this namespace and `test` to run the tests. Or you
       can use `undo` or `reflog` to undo the results of this
       merge.

.s> todo

  ✅
  
  No conflicts or edits in progress.

.m> todo

  ✅
  
  No conflicts or edits in progress.

```
