

```ucm:hide
.> builtins.mergeio
.> pull https://github.com/unisonweb/base_v2:.trunk .base
```

```unison

toException : Either Failure a ->{Exception} a
toException = cases
  Left e -> raise e
  Right a -> a

putText : Handle -> Text ->{IO, Exception} ()
putText h t = putBytes h (toUtf8 t)

bugFail = cases
  Failure typ _ _ -> bug (Failure typ "problem" (Any ()))

Exception.unsafeRun! : '{Exception, g} a -> '{g} a
Exception.unsafeRun! e _ = 
    h : Request {Exception} a -> a 
    h = cases 
        {Exception.raise fail -> _ } -> 
            bugFail fail
        {a} -> a 
    handle !e with h 

hello : Text -> Text -> {IO, Exception} ()
hello host port = 
    socket = serverSocket (Some host) port
    msg = toUtf8 "Hello there" 
    socketSend socket msg
    closeSocket socket 

myServer = unsafeRun! '(hello "127.0.0.1" "0")

```

```ucm:error
.> run myServer 
```
