/*
	Copyright (C) 2009 -=[dxp]=-

	This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef GLOBALS_H
#define GLOBALS_H 1

#define _GNU_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/resource.h>
#include <inttypes.h>
#include <signal.h>
#include <fcntl.h>
#include <termios.h>
#include "config.h"

#define convert(index) \
{ \
	j = digest[(index)]; \
		output[(index) << 1] = fasthex[( j >> 4 ) & 0x0f]; \
			output[( (index) << 1 ) + 1] = fasthex[j & 0x0f]; \
}

#define MAX_WORD_SIZE 32	// Maximum length of string to brute
#define MAX_HASH_LEN 40		// Maximum length of hash in ascii format
#define LINE_BUF_LEN 64		// Maximum length of line to read from file

enum {
	MODE_SINGLE=1,
	MODE_FILE
};

enum {
	HASH_MD5=1,
	HASH_SHA1
};

struct node {
	uint8_t digest[20];
	struct node * next;
};

extern struct			rusage	usage;
extern struct termios	tio_isaved, tio_osaved, tio_set;
extern unsigned int		pd_len;
extern unsigned int		wlen;
extern uint64_t			cnt_words, cnt_chars;	// counter for words and characters tested.
extern uint32_t			err;					// Return value after comparing digests.
extern uint32_t			word_rf_len;			// Length of generated ascii word to brute.
extern uint32_t			dig_off;
extern char				alphabet[];
extern char				password_hash[];
extern uint8_t			word_rf[];
extern const char		fasthex[];
extern unsigned char *	password_digest;
//extern uint8_t			sha1_digest[];
//extern uint8_t			md5_digest[];
extern uint8_t			ssl_digest[];
extern FILE	*			fd;
extern uint32_t			input_mode;			// Source of input (argument or file)
extern char *			line_buf;			// Dynamically allocated buffer to hold a line from file
extern size_t			line_len;			// Length of line
typedef struct node NODE_T;
extern NODE_T *		list;		// Start of linked list, digests converted from strings in the input file
extern NODE_T *		list_pvt;	// Current pointer to a node within a list
extern NODE_T *		list_tmp;	// Temporary pointer to a node within a list
extern uint32_t		hash_mode;	// Type of HASH given

#include "functions.h"

#endif /* ! INCLUDES_H */
