/* <html><head><title>ReorderImages source</title></head><body>
<h2>How to make ReorderImages</h2>
<ol>
<li>Build ImgLib.o analyzeUtil.o ImgLibError.o VLib.o (from
<a
href="http://porkpie.loni.ucla.edu/BMD_HTML/SharedCode/SharedSoftware.html#Anchor-UCLA-35829
">www.brainmapping.org</a>)
<li>compile ReorderImages, linking the objects above. You will need to have C++ extensions
and the Math Library.
A typical command might be:<br><font face=courier>
cc ImgLib.o analyzeUtil.o ImgLibError.o VLib.o Analyze2Genesis.c -lm -o ReorderImages</font>
</ol>
<center>
<table border=2 cellpadding=8 width="90%"><tr><td>
This software is made available <b>AS IS</b> and no warranty is made as to its accuracy
or performance.<p>
Unlimited academic use of this software is granted, except that the any
publications that derive from its use, or any new software that incorporates
its underlying sources or algorithms must specifically acknowledge the author.
Modification of the program to meet local needs is encouraged, but all such
changes are to be communicated to the author to support the continued growth
of these tools.
<p>
Commercial, for-profit, use of the sources or algorithms is expressly prohibited
without permission of the
<a href="mailto:mscohen@ucla.edu">author</a>.
<p>
Unless otherwise stated, I do not offer technical support beyond that found on the
<a href="http://porkpie.loni.ucla.edu/HowTo/eq.html">
Brain Mapping Center support pages</a>.
</td></tr></table></center>
<pre>
$Log$ */

/* $Author$
*  $Date$
*  $Log:$
*/

#include "getopt.h"
#include "ImgLib.h"

#define false 0
#define true 1
#ifndef noErr
#define noErr 0
#endif

#undef MAC
#ifdef MAC
#include <console.h>
#include <sioux.h>
#endif

/* globals */
typedef struct {
	char    OutFileName[255];
	char    InFileName[255];
	char    OutBaseName[256];
	char    orderFileName[256];
	short   output_datatype;
	IMAGE   inIm;
	IMAGE   outIm;
	Boolean Verbose;
	FILE    *inFile;
	FILE    *outFile;
	FILE    *ProcFile;
	FILE    *orderFile;
} UtilGlobal;

UtilGlobal u;

/* PROTOTYPES */
OSErr ReOrderImages( FILE *inFile, FILE *outFile, FILE *orderFile );
void  print_usage( char *name );
OSErr ProcessCommandLine( int argc, char *argv[] );
OSErr OutBaseNameFromOutName( char *OutFileName, char *OutBaseName );

/******************************    ReOrderImages     ***************************
*   Simply reads the images using GetSelectedVolume in the order chosen from orderFile
*   and sends them to outFile.
*************************************************************************************/
OSErr ReOrderImages( FILE *inFile, FILE *outFile, FILE *orderFile )
{
	OSErr   error = noErr;
        int	ret;
	long    theTimePt;
	void    *inData, *outData;
	long    outVolSize, inVolSize;
	char    timePtTxt[32];
        char	c;
	IMAGE   hdrIm;

	inVolSize  = u.inIm.dim.isoX * u.inIm.dim.isoY
	           * u.inIm.dim.n_slices * get_datasize( u.inIm.data_type );
	outVolSize = u.outIm.dim.isoX * u.outIm.dim.isoY
	           * u.outIm.dim.n_slices * get_datasize( u.outIm.data_type );
	inData  = ck_malloc( inVolSize,  "Storage for input data" );

	fprintf( u.ProcFile, "Output order: " );
	
        do {
		
                ret = fscanf( orderFile, "%s", timePtTxt );
                
                if ( ret == 0 ) { 	// empty file
			break;
		};
		
		theTimePt = atol( timePtTxt ) - 1;	// Input is numbered from 1, not 0
		if( u.Verbose ) {
			printf( "\tTime point %s:%d\n", timePtTxt, theTimePt);
		}

		fprintf( u.ProcFile, "%s ", timePtTxt );

		error = GetSelectedVolume( inFile, &u.inIm, inData, theTimePt );
		RETURNONERROR;

/* convert the contents of outdata to the transformed version of indata */	
		error = ck_fwrite( inData, 1, outVolSize, outFile );
		ILError( error, "Writing output file" );
                
                c = fgetc( orderFile );
                
	} while ( c != EOF && c != '\n' && c != '\r' );

	fprintf( u.ProcFile, "\n\n" );
	return error;
}

/***********************************************/
void print_usage( char *name )
{
	printf( "USAGE: %s -i infile.ext -o outfilebasename -f imageOrderFile\n\n", name );
	printf( "The imageOrderFile contains a list of numbers representing the\n" );
	printf( "desired order of the time points in the output image file\n\n" );
	printf( "Output file type based on output file name.\n" );
}

/******************************    ProcessCommandLine     ***************************
*   capture the user input, mostly globals
*************************************************************************************/
OSErr ProcessCommandLine( int argc, char *argv[] )
{
	OSErr error = noErr;

	int argp = EOF;
	short argsProcessed = 0;

	while ( (argp=getopt(argc,argv,"i:o:f:Vh?OPTIONS")) != EOF )
	switch( argp )   {
		case 'o':
			strcpy( u.OutFileName, optarg );
		break;

		case 'i':
			strcpy( u.InFileName, optarg );
		break;

		case 'f':
			strcpy( u.orderFileName, optarg );
		break;

		case 'V':
			u.Verbose = true;
		break;

		case 'h':
		case '?':
		default:
			print_usage( argv[0] );
			exit( -1 );
	}
	
/* check for required arguments */
	if( !strlen( u.InFileName ) || !strlen( u.OutFileName ) || !strlen( u.orderFileName )) {
DBG( "args" );
		print_usage( argv[0] );
		exit( -1 );
	}

	return error;
}

/*********************************************************************/

int main( int argc, char *argv[] )
{
	OSErr   error = noErr;
	static  char id[] = "$Revision$$Date$";
	FILE    *inFile, *outFile;

#ifdef MAC
	SIOUXSettings.autocloseonquit = false;
	SIOUXSettings.asktosaveonclose = false;
	argc = ccommand(&argv);
#endif

	error = ProcessCommandLine( argc, argv );
	ILError( error, "error in command line" );

	error = OpenProcFile( argc, argv, u.OutFileName, id, &u.ProcFile );
	ILError( error, "error opening Proc file" );

/* read in the input image header */
	error = UC_Readheader( u.InFileName, &u.inIm );
	ILError( error, "Input image header" );

	memcpy( &u.outIm, &u.inIm, sizeof( IMAGE ));	// copy the input header to the output header, or?

	error = OutBaseNameFromOutName( u.OutFileName, u.OutBaseName );
	ILError( error, "Failed getting output name base" );

	error = FindOutputType( u.OutFileName, &u.outIm.file_type, &u.outIm.data_type );
	ILError( error, "Failed getting output name base" );

	error = ck_fopen( &u.inFile, u.InFileName,  "r" );
	ILError( error, "Opening infile" );

	error = ck_fopen( &u.outFile, u.OutFileName,  "w" );
	ILError( error, "Opening outfile" );
	
	error = ck_fopen( &u.orderFile, u.orderFileName,  "r" );
	ILError( error, "Opening outfile" );
	
/* do something */
	error = ReOrderImages( u.inFile, u.outFile, u.orderFile );
	ILError( error, argv[0] );

	error = ck_fclose( u.orderFile );
	ILError( error, "infile" );

	error = ck_fclose( u.outFile );
	ILError( error, "infile" );

	error = ck_fclose( u.inFile );
	ILError( error, "infile" );

	error = CreateHeader( u.outIm.file_type, &u.outIm, u.OutBaseName );
	ILError( error, "creating output header" );

/* dump processing file contents */
	fprintf( u.ProcFile,"TIME POINTS:       %d\n", u.inIm.dim.timePts );
	fprintf( u.ProcFile,"NUM SLICES:        %d\n", u.inIm.dim.n_slices );

	ck_fclose( u.ProcFile );
	
	return 0;
}

/***********************************************/

OSErr OutBaseNameFromOutName( char *OutFileName, char *OutBaseName )
{
	OSErr error = noErr;

	strcpy( OutBaseName, OutFileName );
	*strrchr( OutBaseName, '.' ) = '\0';    /* terminate before the extension */
	
	if( !strlen( OutBaseName )) {
		return UNKNOWNTYPE;
	}

	return error;
}


