#!/bin/bash
# 2010-08-06 Aurelio Jargas
#
# Quick tests to spot changes in samples.
# NOT integrated into main test suite, you must run it alone.
#
# Tip: regenerate affected samples:
# cd ../../ && for t in TARGETS; do txt2tags -t $t samples/sample.t2t; done

errors=0
svn_root='../..'
txt2tags=$svn_root/txt2tags
samples_path=$svn_root/samples
input=$samples_path/sample.t2t

# This filters removes information that may change between conversions,
# as macro expansions (date)
filter() {
	sed '
		# remove date from header
		s,[0-9][0-9]/[0-9][0-9]/[0-9][0-9][0-9][0-9],DATE,
		# lout escapes / with "/" in headers
		s,[0-9][0-9]"/"[0-9][0-9]"/"[0-9][0-9][0-9][0-9],DATE,
		
		# avoids macro expansion differences
		s/today is [0-9]\{8\}/today is TODAY/
		s/which gives: ..-..-..../which gives: TODAY/
		# man escapes - with \-
		s/which gives: ..\\-..\\-..../which gives: TODAY/
		
		# remove version
		/generated by/ s/txt2tags [0-9.b]\{1,\} /txt2tags /
		
		# remove cmdline
		/cmdline: / s/txt2tags .*/txt2tags/
	' $1
}

for template in $samples_path/sample* 
do
	output=$(basename "$template")
	target=$(basename "$template" | cut -d . -f 2)
	
	test "$target" = 't2t' && continue  # ignore sample.t2t

	if test $(basename "$template") = 'sample-slides-80x25.art'
	then
		$txt2tags -t $target -i $input -o $output --slides
	else
		$txt2tags -t $target -i $input -o $output
	fi
	
	diff -u <(filter $template) <(filter $output) > $output.diff
	
	if test -s $output.diff
	then
		errors=1
		echo $target >> tmp
	else
		rm $output.diff
		rm $output
	fi
done

if test $errors -eq 0
then
	echo
	echo "All samples are OK"
else
	echo
	echo "Found errors here:"
	ls -1 sample*
	echo
	echo "Failed targets:" $(cat tmp)
	rm tmp
fi
