'\" t
.\" ** The above line should force tbl to be a preprocessor **
.\" Man page for X vncpasswd
.\"
.\" Copyright (C) 1998 Marcus.Brinkmann@ruhr-uni-bochum.de
.\" Copyright (C) 2000 Red Hat, Inc.
.\" Copyright (C) 2001-2003 Constantin Kaplinsky
.\" Copyright (C) 2005-2008 Sun Microsystems, Inc.
.\" Copyright (C) 2010 University Corporation for Atmospheric Research
.\" Copyright (C) 2010, 2015, 2018 D. R. Commander
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the file LICENCE.TXT that comes with the
.\" TightVNC distribution.
.\"
.TH vncpasswd 1 "October 2018" "" "TurboVNC"
.SH NAME
vncpasswd \- set passwords for TurboVNC sessions
.SH SYNOPSIS
\fBvncpasswd\fR [\-v] [\fIfile\fR]
.br
\fBvncpasswd\fR \-t [\-v]
.br
\fBvncpasswd\fR \-f
.br
\fBvncpasswd\fR \-o [\-v] [\-display \fIVNC-display\fR]
.br
\fBvncpasswd\fR \-c [\-display \fIVNC-display\fR]
.br
\fBvncpasswd\fR \-a \fIuser\fR [\-v] [\-display \fIVNC-display\fR]
.br
\fBvncpasswd\fR \-r \fIuser\fR [\-display \fIVNC-display\fR]
.br
.SH DESCRIPTION
The \fBvncpasswd\fR utility can be used to create and change
passwords for Xvnc (the TurboVNC virtual X server.)  \fBXvnc\fR uses these
passwords when started with the \fB\-rfbauth\fR command line option
(or when started from the \fBvncserver\fR script.)

\fBvncpasswd\fR allows one to enter a primary VNC password and an
optional view-only password.  \fBXvnc\fR will ignore mouse and keyboard
input from viewers that authenticate with the view-only password.

The password filename defaults to \fB$HOME/.vnc/passwd\fR, unless the
\fB\-t\fR command line option was used (see the OPTIONS section
below.)  The \fB$HOME/.vnc/\fR directory will be created if it does not
exist.

Each password has to be longer than five characters (unless the
\fB\-f\fR command line option was used-- see its description below.)
Only the first eight characters are significant.  If the primary
password is too short, then vncpasswd will abort.  If the view-only
password is too short, then only the primary password will be saved.

Unless a filename was explicitly provided in the command line, then this
utility may perform certain sanity checks to prevent writing a
password file into some hazardous place.
.br
.SH ONE-TIME PASSWORD (OTP) SUPPORT
If the TurboVNC session is configured to support one-time passwords, then
\fBvncpasswd\fR can be used to generate new one-time passwords for both full
control and, optionally, view-only access.  A one-time password is valid for
one successful connection from a VNC viewer to the TurboVNC session.  For each
subsequent connection, a new one-time password must be generated.
\fBvncpasswd\fR can also be used to clear any one-time passwords that are
currently enabled for a TurboVNC session.
.br
.SH USER ACCESS CONTROL LIST SUPPORT
If the TurboVNC Server is configured to support user access control lists
(ACLs) for the PAM User/Password authentication method, then \fBvncpasswd\fR
can be used to add users to or remove users from a session's ACL.  Be careful
not to remove yourself from the list, or you will not be able to connect again
until you re-add yourself.
.br
.SH OPTIONS
.TP
\fB\-t\fR
Write passwords into \fB/tmp/$USER-vnc/passwd\fR, creating the
\fB/tmp/$USER-vnc/\fR directory if it does not exist and checking the
permissions on that directory (the mode must be 700.)  This option can
help to improve security if your home directory is shared on the
network (e.g. when using NFS.)
.TP
\fB\-f\fR
Filter mode.  Read plain-text passwords from stdin, and write encrypted
versions to stdout.  One or two passwords (full-control and view-only)
can be supplied in the input stream, with a new line terminating each password.
Note that in filter mode, short or even empty passwords will be
silently accepted.
.TP
\fB\-v\fR
Also prompt for a view-only password, or generate a one-time view-only password.

If adding a user to the user ACL, then the \fB\-v\fR option specifies that the
user should be granted view-only access instead of full control.
.TP
\fB\-display\fR \fIVNC-display\fR
This option specifies the X display of the TurboVNC session to use when
setting/clearing one-time passwords or adding users to/removing users from the
ACL.  If \fIVNC-display\fR is not specified, then it defaults to the value of
the \fBDISPLAY\fR environment variable.
.TP
\fB\-o\fR
Generate a one-time full control password for \fIVNC-display\fR.
.TP
\fB\-c\fR
Clear any one-time passwords on \fIVNC-display\fR.
.TP
\fB\-a\fR \fIuser\fR
Add \fIuser\fR to \fIVNC-display\fR's user ACL.  The \fB\-v\fR option can also
be specified in order to restrict this user's access to view-only.
.TP
\fB\-r\fR \fIuser\fR
Remove \fIuser\fR from \fIVNC-display\fR's user ACL.
.SH EXIT CODES
If at least one password was saved successfully, or if the one-time password
or user ACL operation succeeded, then \fBvncpasswd\fR will
exit with status 0.  Otherwise, it will exit with status 1.
.SH SEE ALSO
\fBvncserver\fR(1), \fBXvnc\fR(1), \fBvncviewer\fR(1),
\fBvncconnect\fR(1)
.SH AUTHORS
VNC was originally developed at AT&T Laboratories Cambridge.  TightVNC
additions were implemented by Constantin Kaplinsky.  TurboVNC, based
on TightVNC, is provided by The VirtualGL Project.  Many other people
participated in development, testing and support.

\fBMan page authors:\fR
.br
Marcus Brinkmann <Marcus.Brinkmann@ruhr-uni-bochum.de>
.br
Tim Waugh <twaugh@redhat.com>
.br
Constantin Kaplinsky <const@tightvnc.com>
.br
D. R. Commander <information@turbovnc.org>
.br
Craig Ruff <cruff@ucar.edu>
