'\" t
.\" ** The above line should force tbl to be a preprocessor **
.\" Man page for X vncconnect
.\"
.\" Copyright (C) 2000, 2001 Red Hat, Inc.
.\" Copyright (C) 2001-2003 Constantin Kaplinsky
.\" Copyright (C) 2005-2008 Sun Microsystems, Inc.
.\" Copyright (C) 2010, 2013, 2018 D. R. Commander.
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the file LICENCE.TXT that comes with the
.\" TightVNC distribution.
.\"
.TH vncconnect 1 "October 2018" "" "TurboVNC"
.SH NAME
vncconnect \- connect a TurboVNC session to a listening VNC viewer
.SH SYNOPSIS
.nf
\fBvncconnect\fR [\-display \fIVNC-display\fR] [\-disconnect] \fIclient\fR[:\fIport\fR]
.fi
.SH DESCRIPTION
\fBvncconnect\fR can be used to initiate a "reverse connection" between a
TurboVNC session and a VNC viewer that has been started in "listen mode."  The
viewer should be running on the machine specified by \fIclient\fR and listening
on the port specified by \fIport\fR (if \fIport\fR is not specified, then the
default of 5500 is used.)
.SH OPTIONS
.TP
\fB\-display\fR \fIVNC-display\fR
The X display of the TurboVNC session that you wish to connect to a listening
viewer (default: read from the \fBDISPLAY\fR environment variable)
.TP
\fB\-disconnect\fR
Disconnect all listening viewers from a particular TurboVNC session
.SH EXIT CODES
When used to initiate a reverse connection, \fBvncconnect\fR will exit with
status 0 if the connection was successful.  It will exit with status 1 if the
connection failed (which would be the case if there was no listening viewer
running on the specified client and port, if a firewall prevented the
connection, or if reverse connections had been disallowed in the TurboVNC
Server's security configuration file.)

When used to disconnect reverse connections, \fBvncconnect\fR will exit with
status 0 if one or more listening viewers were successfully disconnected.
Otherwise, it will exit with status 1.
.SH SEE ALSO
\fBvncviewer\fR(1), \fBvncserver\fR(1), \fBXvnc\fR(1), \fBvncpasswd\fR(1)
.SH AUTHORS
VNC was originally developed at AT&T Laboratories Cambridge. TightVNC
additions were implemented by Constantin Kaplinsky. TurboVNC, based
on TightVNC, is provided by The VirtualGL Project. Many other people
participated in development, testing and support.

\fBMan page authors:\fR
.br
Tim Waugh <twaugh@redhat.com>
.br
Constantin Kaplinsky <const@tightvnc.com>
.br
D. R. Commander <information@turbovnc.org>
