import Foundation

extension BuildRule {
    /// Mapping of file types supported by a build rule to Xcode's internal representation.
    /// All values were coppied from `pbxproj`.
    public enum FileType: String, Codable {
        case instrumentsPackageDefinition = "com.apple.instruments.package-definition"
        case metalAIR = "compiled.air"
        case machO = "compiled.mach-o"
        case machOObject = "compiled.mach-o.objfile"
        case siriKitIntent = "file.intentdefinition"
        case coreMLMachineLearning = "file.mlmodel"
        case rcProjectDocument = "file.rcproject"
        case skyboxDocument = "file.skybox"
        case interfaceBuilderStoryboard = "file.storyboard"
        case interfaceBuilder = "file.xib"
        case documentationCatalog = "folder.documentationcatalog"
        case coreMLMachineLearningModelPackage = "folder.mlpackage"
        case assemblyAsm = "sourcecode.asm"
        case assemblyAsmAsm = "sourcecode.asm.asm"
        case llvmAssembly = "sourcecode.asm.llvm"
        case cSource = "sourcecode.c"
        case clipsSource = "sourcecode.clips"
        case cppSource = "sourcecode.cpp"
        case dtraceSource = "sourcecode.dtrace"
        case dylanSource = "sourcecode.dylan"
        case fortranSource = "sourcecode.fortran"
        case glslSource = "sourcecode.glsl"
        case iigSource = "sourcecode.iig"
        case javaSource = "sourcecode.java"
        case lexSource = "sourcecode.lex"
        case metalShaderSource = "sourcecode.metal"
        case migSource = "sourcecode.mig"
        case nasmAssembly = "sourcecode.nasm"
        case openCLSource = "sourcecode.opencl"
        case pascalSource = "sourcecode.pascal"
        case protobufSource = "sourcecode.protobuf"
        case rezSource = "sourcecode.rez"
        case swiftSource = "sourcecode.swift"
        case yaccSource = "sourcecode.yacc"
        case localizationString = "text.plist.strings"
        case localizationStringDictionary = "text.plist.stringsdict"
        case xcAppExtensionPoints = "text.plist.xcappextensionpoints"
        case xcodeSpecificationPlist = "text.plist.xcspec"
        case dae = "text.xml.dae"
        case nib = "wrapper.nib"
        case interfaceBuilderStoryboardPackage = "wrapper.storyboardc"
        case classModel = "wrapper.xcclassmodel"
        case dataModel = "wrapper.xcdatamodel"
        case dataModelVersion = "wrapper.xcdatamodeld"
        case mappingModel = "wrapper.xcmappingmodel"
        case sourceFilesWithNamesMatching = "pattern.proxy"
    }
}
