// Triple-DES test vectors

struct TV_TDES {
    uint8_t key[24];
    uint8_t plain[8];
    uint8_t cipher[8];
};

static const TV_TDES tv_tdes [] = {
    {
        {0x12, 0x4E, 0x1E, 0xAA, 0xBC, 0xAB, 0xF5, 0x3C,
         0x94, 0x6D, 0x7E, 0x79, 0x54, 0x12, 0x96, 0x00,
         0x9C, 0x30, 0x97, 0x17, 0xC9, 0xCC, 0xD8, 0xC9},
        {0x34, 0x3C, 0x7F, 0x81, 0x03, 0xBD, 0x27, 0x23},
        {0xB8, 0x56, 0xED, 0x66, 0x9A, 0xBA, 0x30, 0x47},
    },
    {
        {0x9F, 0x2D, 0xF7, 0xA4, 0x51, 0x4A, 0x67, 0xD9,
         0xB1, 0xBF, 0xB9, 0xAE, 0x02, 0xF3, 0x30, 0xCC,
         0x99, 0x12, 0x3A, 0x07, 0x09, 0x5D, 0x62, 0xC3},
        {0x71, 0x0E, 0x69, 0x19, 0x2B, 0xAA, 0x6C, 0x54},
        {0x58, 0xB3, 0x06, 0x4D, 0xEC, 0x13, 0x33, 0x72},
    },
    {
        {0x66, 0xCC, 0x3B, 0x73, 0xCF, 0x94, 0x45, 0x12,
         0xF2, 0x97, 0x64, 0x60, 0x8E, 0xD9, 0x17, 0x66,
         0xAC, 0x2F, 0x61, 0x4E, 0x81, 0x71, 0xD8, 0x31},
        {0x67, 0x5B, 0x19, 0x58, 0xAE, 0xD2, 0x32, 0x35},
        {0xAD, 0xA1, 0x54, 0x69, 0x9A, 0x25, 0x94, 0xCB},
    },
    {
        {0xCE, 0xB5, 0xF7, 0xCD, 0x4B, 0xBE, 0xE0, 0xEB,
         0x95, 0x7C, 0x82, 0xF2, 0x9B, 0x5B, 0xA7, 0xCA,
         0x0C, 0x8E, 0xAC, 0x77, 0x20, 0xD9, 0xAA, 0x9D},
        {0x1C, 0xF2, 0xF0, 0x9B, 0x24, 0xFE, 0xEB, 0xAD},
        {0x74, 0x59, 0x7E, 0x21, 0x2F, 0xDA, 0x14, 0x22},
    },
    {
        {0xC6, 0x9C, 0x15, 0x9D, 0x45, 0x2C, 0x76, 0xAC,
         0x25, 0x1C, 0xFB, 0x07, 0xD6, 0x04, 0xC7, 0xB4,
         0xD9, 0xC0, 0x79, 0xC2, 0x9C, 0x9A, 0x12, 0x10},
        {0x02, 0x21, 0x3B, 0xB7, 0x93, 0x47, 0x20, 0xEA},
        {0xC9, 0x94, 0x99, 0xFF, 0xA1, 0xDC, 0x8B, 0x37},
    },
    {
        {0x59, 0x59, 0xE4, 0x38, 0x1E, 0x47, 0x11, 0xF1,
         0x4B, 0x0C, 0xAE, 0x51, 0x73, 0x0E, 0x64, 0x56,
         0x9D, 0xCB, 0xF4, 0x02, 0x4E, 0xA6, 0xCB, 0xA7},
        {0x70, 0xDA, 0x0B, 0x96, 0xFC, 0x5D, 0xFD, 0x40},
        {0xFE, 0xA6, 0x54, 0x1E, 0x14, 0xDC, 0xAB, 0x9E},
    },
    {
        {0x76, 0x47, 0x8E, 0x0D, 0x28, 0x75, 0x1F, 0xB0,
         0x6E, 0xF0, 0x45, 0x5A, 0xF0, 0x43, 0xE3, 0x80,
         0xE4, 0xDB, 0x0E, 0x7C, 0xA2, 0xB7, 0x13, 0xAE},
        {0xA6, 0x8D, 0xC8, 0xD5, 0xAC, 0x15, 0x08, 0x4A},
        {0x8C, 0x74, 0xF4, 0xDC, 0x7A, 0xA9, 0xFD, 0xE7},
    },
    {
        {0x68, 0xCC, 0xB7, 0x78, 0x03, 0xD4, 0x12, 0xEB,
         0x74, 0x5F, 0xFD, 0x45, 0xDC, 0x84, 0x8B, 0x02,
         0x87, 0x4E, 0x36, 0xF7, 0xF7, 0xDA, 0x4B, 0xEF},
        {0x3E, 0xFA, 0x36, 0xDF, 0xA7, 0x4A, 0x95, 0x2A},
        {0xDF, 0x2D, 0x6B, 0xCA, 0x28, 0x8D, 0x6B, 0x00},
    },
    {
        {0x2B, 0xCB, 0xD5, 0xDF, 0x31, 0x03, 0x49, 0x90,
         0x79, 0xF3, 0x95, 0xFE, 0x8E, 0x5B, 0xEB, 0xA1,
         0x7A, 0x33, 0x71, 0x9F, 0x5E, 0xE4, 0xF9, 0x06},
        {0x22, 0x9D, 0x08, 0xAB, 0x8D, 0x1C, 0xE7, 0x7E},
        {0x5B, 0x84, 0x20, 0xF2, 0xB7, 0x63, 0xC0, 0x30},
    },
    {
        {0x0E, 0xC2, 0xF6, 0x38, 0x71, 0xE8, 0xB4, 0x12,
         0x1E, 0x53, 0xF9, 0xF3, 0x4F, 0x73, 0x0F, 0x41,
         0xF3, 0xA9, 0xE2, 0x94, 0x88, 0x9C, 0x0E, 0xD6},
        {0x19, 0x44, 0x4E, 0x4A, 0x7F, 0xB4, 0x80, 0x04},
        {0x09, 0x09, 0x8E, 0xD5, 0xE7, 0x6A, 0x3A, 0x9F},
    },
    {
        {0x2C, 0x4B, 0x7B, 0xCF, 0xE9, 0x9D, 0xAF, 0x26,
         0x4A, 0x51, 0x98, 0xB6, 0x2B, 0x31, 0xAA, 0x68,
         0x80, 0x10, 0xAE, 0x6C, 0x3F, 0x63, 0x8A, 0x96},
        {0x8A, 0xB3, 0x7A, 0x21, 0x25, 0xAF, 0x1A, 0x1F},
        {0x74, 0xFF, 0x1A, 0x52, 0x11, 0xE3, 0x1F, 0xAB},
    },
    {
        {0x56, 0x5B, 0x9E, 0x4C, 0xA3, 0xF1, 0x7B, 0x37,
         0x0D, 0xD8, 0x5E, 0x30, 0xA6, 0xDB, 0x5D, 0x15,
         0x56, 0x77, 0x6B, 0x21, 0xAF, 0x90, 0x2C, 0x3C},
        {0x5D, 0xFE, 0x1A, 0x85, 0xC3, 0x6C, 0xD9, 0x48},
        {0x06, 0x3C, 0xC6, 0x44, 0x83, 0x59, 0xD0, 0xC4},
    },
    {
        {0xBA, 0x0F, 0xCA, 0xE9, 0xFB, 0x43, 0xE7, 0x28,
         0x85, 0x88, 0x25, 0xEB, 0x7A, 0xFC, 0x35, 0xAE,
         0x54, 0x31, 0xD7, 0x85, 0x65, 0x6B, 0x09, 0xD7},
        {0x5E, 0x92, 0xE4, 0x84, 0x7B, 0x5A, 0x5C, 0x5B},
        {0x62, 0xB9, 0x53, 0x17, 0x09, 0xA5, 0xE7, 0x08},
    },
    {
        {0xC5, 0x70, 0x2F, 0xCB, 0x63, 0x6C, 0x39, 0xBA,
         0xBC, 0xF5, 0x0E, 0xC2, 0xBE, 0x83, 0x53, 0xA4,
         0x2C, 0xC7, 0x2C, 0xA5, 0x48, 0x86, 0xBE, 0x2F},
        {0x71, 0x27, 0xCC, 0x28, 0xBE, 0x25, 0x32, 0x3C},
        {0x8C, 0xF3, 0x44, 0xF5, 0x3F, 0x8B, 0xDC, 0xCA},
    },
    {
        {0x40, 0x3E, 0x10, 0x34, 0x05, 0xC8, 0x0C, 0x68,
         0x99, 0x29, 0xEE, 0xEB, 0x93, 0x42, 0x7B, 0x8C,
         0xED, 0xEB, 0x9E, 0x59, 0x64, 0x3B, 0x07, 0x66},
        {0x9B, 0x12, 0x75, 0xE6, 0x1E, 0xAB, 0x10, 0x8B},
        {0xEE, 0x91, 0xF2, 0x9C, 0x09, 0x62, 0x6E, 0xD1},
    },
    {
        {0x74, 0x2C, 0x0D, 0xCF, 0x6A, 0xDD, 0x1C, 0x0D,
         0x70, 0x42, 0x2B, 0xEA, 0x4D, 0x2B, 0xD2, 0xE7,
         0xCC, 0xB4, 0xCE, 0xED, 0xE3, 0x69, 0x18, 0x3A},
        {0x3C, 0x79, 0x49, 0x1B, 0x30, 0x09, 0x41, 0xA1},
        {0x31, 0x5E, 0x28, 0xE7, 0xCA, 0x5A, 0x6B, 0xE1},
    },
    {
        {0xCD, 0xD4, 0xD0, 0x99, 0xD7, 0x5A, 0x2D, 0xBE,
         0xCB, 0xEE, 0xAD, 0x2A, 0x3A, 0xC9, 0x06, 0x28,
         0x79, 0x7A, 0x08, 0xB8, 0x2E, 0xB1, 0x6D, 0xF6},
        {0xAC, 0x82, 0x72, 0xD6, 0x5F, 0xF5, 0x44, 0x47},
        {0x4E, 0x58, 0x17, 0xCA, 0x4A, 0xEB, 0x96, 0x47},
    },
    {
        {0x22, 0xAF, 0xC3, 0xA8, 0xE1, 0x25, 0x9E, 0x89,
         0x56, 0x83, 0x2D, 0xEB, 0x7C, 0xB7, 0x51, 0x24,
         0xAB, 0x36, 0xDF, 0x69, 0x38, 0xA3, 0xCF, 0xE1},
        {0xAB, 0xE5, 0x6E, 0x47, 0x8C, 0xDF, 0x2B, 0xBA},
        {0x3B, 0x83, 0xA8, 0x40, 0xF6, 0x57, 0xD5, 0xAA},
    },
    {
        {0x86, 0x2F, 0xD8, 0x94, 0xC8, 0x60, 0xC4, 0x0B,
         0x4F, 0x1C, 0x25, 0xFF, 0xCA, 0xB0, 0xBC, 0xAA,
         0xA0, 0x50, 0xE2, 0xB8, 0x23, 0x48, 0x04, 0x25},
        {0xB7, 0xDC, 0xA1, 0x2C, 0x27, 0xE8, 0x60, 0xFF},
        {0x49, 0x87, 0x5F, 0x69, 0x57, 0xD2, 0x25, 0x55},
    },
    {
        {0xEF, 0xE9, 0xB4, 0xA2, 0xDA, 0x56, 0x2E, 0xB0,
         0x51, 0xC1, 0x10, 0x13, 0x74, 0x47, 0x33, 0x9C,
         0xC7, 0x95, 0x04, 0x21, 0x89, 0xFA, 0xDB, 0xEF},
        {0x6C, 0x5B, 0x91, 0x76, 0xDF, 0x40, 0xB0, 0x16},
        {0xF2, 0xDF, 0x0F, 0x9E, 0xEF, 0x20, 0x98, 0xF5},
    },
    {
        {0xD1, 0xB3, 0xDC, 0x38, 0x83, 0x90, 0x4D, 0xB2,
         0xEC, 0xC4, 0xB1, 0x98, 0xB5, 0x8F, 0x03, 0xC8,
         0x0B, 0xBE, 0xD2, 0xB8, 0x45, 0x57, 0xA3, 0xD3},
        {0x0B, 0x7B, 0x0E, 0xF2, 0x81, 0xA9, 0xDF, 0x6B},
        {0x4D, 0x7D, 0xB0, 0xC2, 0x3D, 0x3B, 0xB8, 0xB2},
    },
    {
        {0x7E, 0x8F, 0x34, 0x45, 0xE3, 0x36, 0x6F, 0x27,
         0xE6, 0xE3, 0x1C, 0x91, 0x1B, 0x68, 0x7D, 0x08,
         0xFA, 0xFB, 0x35, 0x86, 0x57, 0xD0, 0x74, 0x20},
        {0x8E, 0xBE, 0x5A, 0x17, 0xE1, 0x4A, 0xBD, 0x64},
        {0xCD, 0x83, 0xEF, 0xF0, 0x4B, 0xC0, 0xA6, 0x99},
    },
    {
        {0xC0, 0xED, 0x79, 0x07, 0x75, 0xEC, 0xFD, 0xF6,
         0x0F, 0x97, 0x27, 0x9A, 0xFA, 0xD9, 0xF8, 0xA7,
         0xE1, 0x99, 0xA5, 0x83, 0xC6, 0x79, 0xBD, 0x3A},
        {0xB1, 0xA7, 0xA7, 0x45, 0x19, 0x31, 0x8D, 0xB9},
        {0x3F, 0x9C, 0x12, 0x75, 0x9E, 0xA1, 0x10, 0x29},
    },
    {
        {0x00, 0xE8, 0x32, 0x45, 0x99, 0x0B, 0xB6, 0xB6,
         0xEF, 0x69, 0x53, 0x7B, 0xD2, 0x03, 0xD1, 0xB6,
         0xF1, 0x82, 0xF7, 0x49, 0x9F, 0x63, 0x6E, 0x51},
        {0x2B, 0x40, 0xDE, 0xC1, 0x8E, 0x83, 0xAB, 0xAC},
        {0x49, 0x59, 0xCA, 0x74, 0x39, 0x47, 0xFD, 0x34},
    },
    {
        {0xF7, 0x25, 0x56, 0xE3, 0x10, 0x13, 0x74, 0xC1,
         0xDE, 0x3B, 0x0E, 0xCC, 0xF5, 0x16, 0x5E, 0xB5,
         0x76, 0xE7, 0x62, 0x75, 0xDC, 0x43, 0xB7, 0xB1},
        {0x76, 0xA8, 0x5A, 0xC9, 0xBF, 0xC3, 0xEF, 0x36},
        {0x6D, 0x5F, 0x16, 0xF0, 0x99, 0x71, 0x76, 0x98},
    },
    {
        {0x73, 0x14, 0xE8, 0x12, 0xF9, 0x23, 0x8B, 0xD9,
         0xA3, 0x6E, 0x8F, 0xFC, 0xEE, 0x0F, 0x67, 0xE0,
         0x08, 0x5D, 0x7F, 0x26, 0x0D, 0x48, 0xED, 0xEA},
        {0x71, 0x78, 0x4E, 0x2D, 0xC1, 0x38, 0x20, 0xE8},
        {0x55, 0x03, 0x03, 0x1B, 0x5B, 0xBB, 0x56, 0x2E},
    },
    {
        {0x69, 0xE8, 0x60, 0xD6, 0x0A, 0xCF, 0x70, 0x12,
         0x14, 0x80, 0xEE, 0x88, 0xF8, 0x08, 0x5B, 0xB1,
         0xA4, 0xAF, 0x4A, 0x23, 0x02, 0xF5, 0x2A, 0xBE},
        {0x5B, 0x29, 0x94, 0x4D, 0x5A, 0xF2, 0x0E, 0xED},
        {0x4B, 0xFE, 0x6F, 0x34, 0xB4, 0xBD, 0x47, 0x02},
    },
    {
        {0x5D, 0x3F, 0x1D, 0xDA, 0xA6, 0x0D, 0xFA, 0x45,
         0xA9, 0x5B, 0x69, 0x20, 0x2F, 0x5D, 0xC7, 0x00,
         0xAE, 0x8C, 0x30, 0x21, 0x9A, 0x8C, 0xA5, 0x8F},
        {0x50, 0xD2, 0xC9, 0x05, 0x9E, 0xFD, 0xFC, 0xCC},
        {0x1F, 0x41, 0x02, 0xE4, 0x71, 0xB1, 0x57, 0x69},
    },
    {
        {0xDE, 0xCB, 0x67, 0x29, 0xC9, 0x55, 0x08, 0x4F,
         0x7D, 0x93, 0xF1, 0xC3, 0x5F, 0x71, 0x33, 0xEB,
         0xF9, 0xC8, 0x9C, 0x32, 0x2D, 0x2F, 0x8E, 0x71},
        {0x1A, 0x06, 0x28, 0xDC, 0xFB, 0x94, 0xAE, 0x6E},
        {0xBE, 0x2D, 0x6D, 0x6A, 0xD2, 0x8A, 0xCB, 0x46},
    },
    {
        {0x26, 0xF8, 0xE8, 0xA5, 0xC1, 0x63, 0x57, 0x5C,
         0xF0, 0x75, 0xEC, 0xD6, 0x4E, 0x59, 0x17, 0x25,
         0xEA, 0x9A, 0x60, 0xEE, 0x12, 0x5B, 0x82, 0x16},
        {0xA0, 0x43, 0xCE, 0x08, 0x9D, 0xA5, 0xA1, 0xCA},
        {0xC2, 0xF7, 0xC4, 0x3B, 0xAB, 0x68, 0x3C, 0x30},
    },
    {
        {0xEF, 0x1B, 0x47, 0xA6, 0x6A, 0xBA, 0x23, 0x87,
         0x26, 0x92, 0x94, 0xD5, 0xE7, 0x01, 0x7D, 0x6C,
         0x2D, 0x14, 0x46, 0x73, 0x46, 0xE5, 0xAE, 0xEC},
        {0xF2, 0x17, 0x5B, 0x93, 0x0E, 0x63, 0xCF, 0x1B},
        {0x2A, 0x01, 0xC1, 0xE3, 0xDE, 0xE7, 0x60, 0x39},
    },
    {
        {0x95, 0x54, 0x8B, 0x26, 0xFB, 0x09, 0x25, 0x7F,
         0xE8, 0x4C, 0x0D, 0x13, 0x6E, 0x54, 0x62, 0x88,
         0xFF, 0x5F, 0xEE, 0x5D, 0x9E, 0x86, 0x61, 0xAB},
        {0xDC, 0x9B, 0x80, 0x13, 0xF9, 0x87, 0x5B, 0xFC},
        {0x52, 0x77, 0x76, 0x36, 0x85, 0xE3, 0x0A, 0x7C},
    },
    {
        {0x02, 0x60, 0x75, 0x25, 0x35, 0xF2, 0x7A, 0x25,
         0xB7, 0x0A, 0x75, 0x00, 0xBF, 0x24, 0xEE, 0xB8,
         0x9B, 0xCC, 0x07, 0xF6, 0x1D, 0x4A, 0xFD, 0xFA},
        {0x79, 0x7E, 0x81, 0xC0, 0xA1, 0xB8, 0x7F, 0x12},
        {0xBE, 0x31, 0x5F, 0xF6, 0xA2, 0x2A, 0x34, 0x9D},
    },
    {
        {0xD2, 0x38, 0x97, 0x14, 0xE6, 0x02, 0xF5, 0xF6,
         0x27, 0x20, 0x97, 0x81, 0xB5, 0xB5, 0xD1, 0x29,
         0x26, 0x7E, 0xB3, 0xB4, 0xA1, 0x5E, 0xB2, 0x15},
        {0xA0, 0x06, 0x1B, 0x99, 0xBD, 0x92, 0xDA, 0x82},
        {0x33, 0xC6, 0x26, 0xE9, 0xEF, 0x80, 0x2D, 0x05},
    },
    {
        {0xDD, 0xF7, 0x78, 0xC4, 0x96, 0x46, 0x22, 0x2F,
         0x25, 0x95, 0xAD, 0xD7, 0xAA, 0xD5, 0xA4, 0xFB,
         0x7C, 0xF6, 0x4B, 0x79, 0x43, 0x7E, 0x16, 0x18},
        {0xCE, 0x1C, 0xA1, 0x0D, 0x19, 0x03, 0x3A, 0xB5},
        {0x4C, 0x3C, 0xC2, 0x17, 0xA2, 0x2E, 0x2D, 0x2A},
    },
    {
        {0x8C, 0xBD, 0x0E, 0x46, 0x3E, 0xD1, 0xDF, 0x81,
         0xA3, 0x1F, 0x28, 0x13, 0xB0, 0xED, 0x37, 0xF6,
         0x41, 0x8E, 0x2B, 0x6E, 0x84, 0xCE, 0xF4, 0x7E},
        {0x54, 0x3F, 0xF3, 0xC2, 0x26, 0x87, 0xCE, 0x38},
        {0x52, 0x04, 0x77, 0xC2, 0x29, 0x5F, 0x2D, 0x4D},
    },
    {
        {0xD9, 0x02, 0xF6, 0x91, 0xC8, 0x6B, 0x11, 0x9A,
         0xEC, 0x15, 0x3F, 0xA7, 0xC9, 0x66, 0x12, 0xD6,
         0xEF, 0xB0, 0xEB, 0x98, 0xE7, 0xDA, 0xC3, 0x53},
        {0x0C, 0x61, 0x30, 0x88, 0x7C, 0xCA, 0xC7, 0x91},
        {0xE9, 0x36, 0xD1, 0x95, 0x11, 0x1D, 0x38, 0xA8},
    },
    {
        {0xDA, 0x02, 0xC7, 0x76, 0x9C, 0x73, 0x2C, 0xB0,
         0xCE, 0xD5, 0xE0, 0x9E, 0xE5, 0xA1, 0xBC, 0x64,
         0xB5, 0xDC, 0x76, 0x33, 0x02, 0x26, 0x85, 0x3E},
        {0x7E, 0xF7, 0x4A, 0x5F, 0xF8, 0xE5, 0x23, 0x0B},
        {0xB9, 0x7F, 0x48, 0xA2, 0xBC, 0x30, 0x73, 0x8F},
    },
    {
        {0x8A, 0xAF, 0x93, 0xCC, 0xEF, 0x65, 0x70, 0x02,
         0x98, 0xB8, 0x3A, 0x06, 0xCA, 0x01, 0x77, 0x81,
         0x96, 0xC3, 0x0B, 0x22, 0x09, 0x4C, 0xD9, 0x33},
        {0x30, 0xE5, 0x9D, 0x0C, 0xAA, 0x59, 0xE4, 0x20},
        {0x6C, 0x61, 0xD6, 0x9B, 0x14, 0x57, 0x17, 0xB9},
    },
    {
        {0xDC, 0xCF, 0x5D, 0x21, 0x4D, 0xC7, 0x8D, 0x92,
         0xD5, 0x56, 0x6A, 0x0C, 0x81, 0xA9, 0xF1, 0x2B,
         0xE8, 0x06, 0x69, 0x2D, 0x27, 0x22, 0x8A, 0x9A},
        {0x5C, 0x80, 0x6D, 0xA4, 0x17, 0x2E, 0x5F, 0x16},
        {0xDF, 0x34, 0x12, 0x37, 0x4F, 0xAE, 0x70, 0xD3},
    },
    {
        {0x6B, 0x33, 0x3D, 0xF4, 0x2E, 0x4A, 0x5E, 0x8F,
         0xEA, 0x4E, 0xAB, 0xFC, 0x8B, 0x73, 0x65, 0xE1,
         0x70, 0xA4, 0x16, 0xCF, 0x96, 0xDC, 0xF8, 0x7D},
        {0x8A, 0xAB, 0xC1, 0xCF, 0xA1, 0xB5, 0xC5, 0x03},
        {0x0F, 0xB3, 0xE3, 0xF4, 0xAD, 0x8A, 0x0D, 0x1C},
    },
    {
        {0x9C, 0xCF, 0x95, 0x03, 0xC0, 0x1D, 0x1E, 0xEA,
         0x09, 0x84, 0xD9, 0xDE, 0x1C, 0xD7, 0x86, 0x4C,
         0x8C, 0xDD, 0xFE, 0x39, 0xE9, 0xD1, 0x04, 0x19},
        {0x88, 0x8D, 0x9A, 0x58, 0xE2, 0x1E, 0x00, 0x8C},
        {0x12, 0x33, 0xD5, 0x1D, 0x1B, 0x53, 0x31, 0x8F},
    },
    {
        {0xEF, 0x17, 0xB1, 0xAB, 0x6C, 0x32, 0x3B, 0x8D,
         0xB8, 0x86, 0x05, 0x13, 0xE9, 0x10, 0x0D, 0x63,
         0xCB, 0xFE, 0xDF, 0xEE, 0x3C, 0x3E, 0xAF, 0x07},
        {0x06, 0x4D, 0xCF, 0x06, 0x3E, 0x82, 0x29, 0x49},
        {0x84, 0x2A, 0xEA, 0xC2, 0xFB, 0xCA, 0x42, 0x09},
    },
    {
        {0x1A, 0x8F, 0x61, 0x87, 0x1A, 0x64, 0x63, 0xF1,
         0x37, 0xD9, 0x1C, 0xEF, 0x47, 0x14, 0xC9, 0xCF,
         0xB2, 0x95, 0x8E, 0x5F, 0x0A, 0xCB, 0x87, 0x97},
        {0xAF, 0x99, 0xD4, 0x3F, 0x2B, 0x58, 0x59, 0xB5},
        {0xA8, 0xED, 0xAD, 0x82, 0xF9, 0xD8, 0xB2, 0x06},
    },
    {
        {0xA2, 0xCC, 0xE7, 0x9A, 0xFF, 0x09, 0x91, 0xE8,
         0xE6, 0x7A, 0x25, 0x13, 0x08, 0x01, 0x0C, 0x51,
         0x06, 0x02, 0x8D, 0x78, 0x13, 0xBB, 0xA8, 0x6F},
        {0x61, 0xC9, 0x43, 0xCA, 0xCA, 0xA1, 0xF0, 0xE9},
        {0xE2, 0xC3, 0x5D, 0x7A, 0x75, 0x52, 0x51, 0x59},
    },
    {
        {0xCA, 0x7D, 0x85, 0x5B, 0x44, 0xF7, 0x38, 0xB6,
         0x7B, 0xBE, 0xDF, 0x14, 0x0A, 0xCA, 0xA1, 0x9D,
         0x3A, 0x4A, 0x63, 0x21, 0x6A, 0x42, 0xDB, 0x1F},
        {0x4C, 0xC1, 0xC3, 0x7F, 0xB2, 0xFF, 0xEA, 0xDD},
        {0xE2, 0x01, 0x23, 0xE6, 0x9D, 0x19, 0x17, 0x5B},
    },
    {
        {0xEB, 0x8D, 0xDC, 0x65, 0xE2, 0xC7, 0x8D, 0x38,
         0x5F, 0xF7, 0x90, 0x7E, 0x19, 0x7A, 0x2D, 0x8C,
         0xA1, 0x12, 0x22, 0x52, 0xA0, 0x09, 0x4C, 0xA7},
        {0xA9, 0xE4, 0x76, 0xBB, 0xA3, 0x4E, 0xCB, 0x4A},
        {0xBA, 0x1F, 0x36, 0xF3, 0xB9, 0xA8, 0x71, 0xE1},
    },
    {
        {0x75, 0xB1, 0x8F, 0x68, 0x3F, 0x32, 0x21, 0x91,
         0x21, 0x54, 0x7F, 0x16, 0x97, 0xC9, 0x65, 0xDB,
         0x71, 0x53, 0xCC, 0xD0, 0x47, 0x18, 0xF3, 0x2B},
        {0xB0, 0xE1, 0x56, 0x7C, 0xAA, 0x44, 0x90, 0xC5},
        {0x52, 0x3E, 0x7F, 0x4E, 0x42, 0x1D, 0x75, 0x18},
    },
    {
        {0x69, 0x03, 0x85, 0x26, 0x19, 0xF5, 0x9A, 0x19,
         0xBB, 0xD3, 0x85, 0x22, 0x15, 0x26, 0x7E, 0x87,
         0x00, 0xEF, 0xAF, 0x52, 0xEF, 0xE0, 0xD5, 0x92},
        {0x93, 0x29, 0x3A, 0x8E, 0x7B, 0xD8, 0xA0, 0x65},
        {0xBF, 0x2C, 0x6B, 0xE1, 0xB8, 0x97, 0x0E, 0x5D},
    },
    {
        {0x4B, 0x63, 0xD9, 0x18, 0xEF, 0xBC, 0xED, 0x52,
         0xD4, 0xE3, 0x21, 0x41, 0x76, 0xAD, 0xF1, 0x86,
         0xB0, 0x3F, 0x6E, 0x49, 0xD7, 0xD4, 0xEB, 0x66},
        {0x42, 0xE0, 0x22, 0xB8, 0xD2, 0xCC, 0xEB, 0x15},
        {0x90, 0x81, 0x8C, 0x5F, 0x3C, 0xA9, 0x35, 0xBD},
    },
    {
        {0x40, 0x8D, 0x9F, 0xE7, 0xFE, 0x1D, 0xE2, 0x9E,
         0x31, 0x91, 0x86, 0x12, 0xB2, 0x7C, 0xE8, 0x9C,
         0xD4, 0x3A, 0x50, 0x4B, 0xF2, 0xF3, 0x0D, 0x64},
        {0x34, 0x9B, 0x00, 0x2C, 0xDA, 0xFE, 0x0E, 0x53},
        {0x3E, 0x1C, 0x67, 0x57, 0x03, 0x9D, 0x5B, 0x16},
    },
    {
        {0x50, 0xBA, 0x74, 0xEA, 0x73, 0x8A, 0x90, 0xE9,
         0x11, 0x50, 0x7E, 0x12, 0x73, 0x19, 0x59, 0x46,
         0x00, 0xF3, 0xED, 0x76, 0x36, 0x76, 0xB4, 0x6B},
        {0x8C, 0x37, 0xBE, 0x8A, 0x17, 0xE4, 0x28, 0xE5},
        {0x18, 0xAA, 0x20, 0x33, 0x6F, 0xB9, 0xA2, 0xF4},
    },
    {
        {0x74, 0x1C, 0xC7, 0x2F, 0x47, 0x01, 0x5E, 0x28,
         0x6C, 0x26, 0x4D, 0x3C, 0xD2, 0x18, 0x39, 0x62,
         0xF5, 0x0C, 0x3C, 0x02, 0x9A, 0x1D, 0x54, 0xC0},
        {0x49, 0xE8, 0x37, 0x9B, 0x87, 0xA1, 0x36, 0xC7},
        {0x97, 0xF8, 0x96, 0xCE, 0xC2, 0x66, 0xEC, 0x36},
    },
    {
        {0x48, 0x70, 0x37, 0x1A, 0xC3, 0x42, 0xF4, 0x67,
         0xF2, 0x1D, 0xCD, 0x0A, 0xD1, 0x44, 0x12, 0x8B,
         0xA6, 0x30, 0x8F, 0xF8, 0x11, 0xC9, 0xA8, 0x50},
        {0x5B, 0xFE, 0x27, 0xB9, 0xE5, 0x49, 0xFC, 0x20},
        {0x6D, 0x80, 0xC6, 0xA7, 0x6D, 0xBC, 0xA0, 0xCB},
    },
    {
        {0x2B, 0xCD, 0xFA, 0x69, 0x34, 0xB4, 0x77, 0xCB,
         0x8B, 0x0B, 0x95, 0x2B, 0x49, 0xA0, 0x5D, 0x9D,
         0x55, 0xE7, 0xAC, 0xFF, 0xCA, 0x24, 0x47, 0x36},
        {0xDD, 0x6E, 0x60, 0xBD, 0x5C, 0x7D, 0xEC, 0x6E},
        {0x6F, 0x08, 0x31, 0x32, 0x4B, 0xC6, 0xB0, 0xBC},
    },
    {
        {0x5B, 0xEE, 0x4C, 0xF1, 0x55, 0xA7, 0x21, 0xFE,
         0xFD, 0xBC, 0x3C, 0x23, 0xCE, 0xE2, 0xE8, 0x11,
         0x65, 0x5E, 0x35, 0x4E, 0x17, 0x60, 0x76, 0xED},
        {0x11, 0x29, 0x12, 0x04, 0x5E, 0x07, 0x96, 0xD2},
        {0x1C, 0x47, 0x6D, 0x0A, 0x4D, 0xEE, 0x68, 0xE3},
    },
    {
        {0x2B, 0x38, 0x57, 0x05, 0xCC, 0xD5, 0x85, 0x53,
         0xB2, 0x8F, 0x9D, 0xAA, 0xBD, 0x37, 0x02, 0xFF,
         0x35, 0x96, 0x9C, 0x27, 0x8D, 0x56, 0xCC, 0x6D},
        {0x90, 0xDC, 0x25, 0x7C, 0xC4, 0xC2, 0x81, 0x57},
        {0x40, 0xE3, 0xBA, 0x24, 0x19, 0xCE, 0x47, 0xA9},
    },
    {
        {0xE1, 0x0F, 0xBD, 0xBB, 0x9F, 0x3D, 0x70, 0x4C,
         0xFB, 0xD3, 0xB1, 0xE5, 0x9D, 0xFA, 0x11, 0x5F,
         0x50, 0xD2, 0xD7, 0x25, 0xB7, 0x10, 0xB3, 0x93},
        {0x81, 0x97, 0x75, 0xEF, 0x9E, 0xB7, 0x1C, 0x68},
        {0x38, 0x35, 0x63, 0xA5, 0x90, 0xA7, 0xD1, 0xBD},
    },
    {
        {0xD3, 0x3C, 0x24, 0xA7, 0xE2, 0x3C, 0x4C, 0xC2,
         0x6F, 0x82, 0x45, 0x9E, 0xC1, 0xEB, 0xCE, 0x8C,
         0x85, 0x59, 0x71, 0xCE, 0xE6, 0x1A, 0xCF, 0xB1},
        {0x9C, 0xBC, 0xB0, 0xF7, 0x26, 0xC6, 0x25, 0xD3},
        {0x5D, 0x19, 0x3F, 0x9B, 0xED, 0xD1, 0xE3, 0x9A},
    },
    {
        {0xEE, 0x9F, 0xFD, 0x28, 0x28, 0x12, 0x45, 0x73,
         0x0A, 0x25, 0xD3, 0x60, 0xF5, 0x62, 0xC0, 0xD6,
         0x06, 0xB1, 0x90, 0xF0, 0xA0, 0xBB, 0x4C, 0xD1},
        {0x40, 0xD6, 0x44, 0x17, 0x0E, 0x9F, 0x97, 0xEA},
        {0x15, 0x15, 0xD5, 0x7D, 0xFB, 0xB6, 0xAA, 0x25},
    },
    {
        {0xE2, 0x09, 0x5D, 0x3A, 0x73, 0x0F, 0xB8, 0xFC,
         0xD1, 0x12, 0x8C, 0x99, 0xF3, 0x12, 0x44, 0xB1,
         0x3A, 0x7E, 0x3E, 0x25, 0x53, 0x0B, 0xF7, 0x53},
        {0x42, 0x1B, 0xEB, 0x24, 0x84, 0xC4, 0x1E, 0x0C},
        {0x02, 0x5F, 0xCB, 0x64, 0xC7, 0xAB, 0x37, 0x5D},
    },
    {
        {0x39, 0xEE, 0x65, 0x4E, 0xD9, 0xEE, 0x78, 0x25,
         0x21, 0xA2, 0xBD, 0x31, 0xEF, 0x6B, 0xBB, 0xA4,
         0x4D, 0x87, 0x09, 0xFA, 0x07, 0xE1, 0xE9, 0x37},
        {0xD5, 0x78, 0x97, 0x23, 0xE2, 0xA5, 0x9A, 0x73},
        {0xBA, 0x31, 0xC9, 0x25, 0x96, 0x52, 0x20, 0xE5},
    },
    {
        {0x7A, 0x86, 0x46, 0x63, 0xE0, 0xDB, 0x20, 0x6A,
         0x0B, 0x32, 0x3F, 0x0A, 0x3C, 0x09, 0x9A, 0x12,
         0x2C, 0x45, 0x04, 0x93, 0x83, 0x62, 0xEA, 0xDF},
        {0x2C, 0x28, 0x88, 0xF2, 0x78, 0xCA, 0xF5, 0xF0},
        {0x0B, 0x81, 0xD1, 0xEE, 0x64, 0x4A, 0x74, 0xBA},
    },
    {
        {0x5D, 0x28, 0x14, 0x39, 0x94, 0xF8, 0x78, 0x2A,
         0x8E, 0xB0, 0x96, 0x44, 0x85, 0x75, 0x55, 0x4D,
         0x65, 0xD9, 0xC9, 0xCF, 0x7C, 0x63, 0xB9, 0xAF},
        {0xC8, 0x71, 0x5F, 0x17, 0xF4, 0xE9, 0x73, 0x7C},
        {0x1C, 0x20, 0xF3, 0x78, 0xBD, 0x6B, 0xC4, 0x28},
    },
};
