#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 2400
#define LARGE_STATE_COUNT 25
#define SYMBOL_COUNT 170
#define ALIAS_COUNT 1
#define TOKEN_COUNT 65
#define EXTERNAL_TOKEN_COUNT 9
#define FIELD_COUNT 28
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 206

enum {
  sym_identifier = 1,
  anon_sym_package = 2,
  anon_sym_DOT = 3,
  anon_sym_object = 4,
  anon_sym_import = 5,
  anon_sym_COMMA = 6,
  anon_sym_LBRACE = 7,
  anon_sym_RBRACE = 8,
  anon_sym_EQ_GT = 9,
  anon_sym_case = 10,
  anon_sym_class = 11,
  anon_sym_trait = 12,
  anon_sym_LBRACK = 13,
  anon_sym_RBRACK = 14,
  anon_sym_PLUS = 15,
  anon_sym_DASH = 16,
  anon_sym_LT_COLON = 17,
  anon_sym_GT_COLON = 18,
  anon_sym_LT_PERCENT = 19,
  anon_sym_COLON = 20,
  anon_sym_AT = 21,
  anon_sym_val = 22,
  anon_sym_EQ = 23,
  anon_sym_var = 24,
  anon_sym_type = 25,
  anon_sym_def = 26,
  anon_sym_abstract = 27,
  anon_sym_final = 28,
  anon_sym_sealed = 29,
  anon_sym_implicit = 30,
  anon_sym_lazy = 31,
  anon_sym_override = 32,
  anon_sym_private = 33,
  anon_sym_protected = 34,
  anon_sym_extends = 35,
  anon_sym_LPAREN = 36,
  anon_sym_RPAREN = 37,
  anon_sym_with = 38,
  anon_sym_POUND = 39,
  anon_sym_STAR = 40,
  anon_sym_PIPE = 41,
  anon_sym_if = 42,
  anon_sym_else = 43,
  anon_sym_match = 44,
  anon_sym_try = 45,
  anon_sym_catch = 46,
  anon_sym_finally = 47,
  anon_sym_new = 48,
  anon_sym_BANG = 49,
  anon_sym_TILDE = 50,
  sym_wildcard = 51,
  sym_operator_identifier = 52,
  sym_number = 53,
  anon_sym_DOLLAR = 54,
  anon_sym_SEMI = 55,
  sym_comment = 56,
  sym__automatic_semicolon = 57,
  sym__simple_string = 58,
  sym__string_start = 59,
  sym__string_middle = 60,
  sym__string_end = 61,
  sym__multiline_string_start = 62,
  sym__multiline_string_middle = 63,
  sym__multiline_string_end = 64,
  sym_compilation_unit = 65,
  sym_package_clause = 66,
  sym_package_identifier = 67,
  sym_package_object = 68,
  sym_import_declaration = 69,
  sym__import_expression = 70,
  sym_import_selectors = 71,
  sym_renamed_identifier = 72,
  sym_object_definition = 73,
  sym__object_definition = 74,
  sym_class_definition = 75,
  sym_trait_definition = 76,
  sym_type_parameters = 77,
  sym__variant_type_parameter = 78,
  sym_covariant_type_parameter = 79,
  sym_contravariant_type_parameter = 80,
  sym__type_parameter = 81,
  sym_upper_bound = 82,
  sym_lower_bound = 83,
  sym_view_bound = 84,
  sym_context_bound = 85,
  sym_template_body = 86,
  sym_annotation = 87,
  sym_val_definition = 88,
  sym_val_declaration = 89,
  sym_var_declaration = 90,
  sym_var_definition = 91,
  sym_type_definition = 92,
  sym_function_definition = 93,
  sym_function_declaration = 94,
  sym_modifiers = 95,
  sym_extends_clause = 96,
  sym_class_parameters = 97,
  sym_parameters = 98,
  sym_class_parameter = 99,
  sym_parameter = 100,
  sym__block = 101,
  sym_block = 102,
  sym__type = 103,
  sym__annotated_type = 104,
  sym__simple_type = 105,
  sym_compound_type = 106,
  sym_infix_type = 107,
  sym_tuple_type = 108,
  sym_stable_type_identifier = 109,
  sym_stable_identifier = 110,
  sym_generic_type = 111,
  sym_projected_type = 112,
  sym_function_type = 113,
  sym_parameter_types = 114,
  sym_lazy_parameter_type = 115,
  sym_repeated_parameter_type = 116,
  sym_case_class_pattern = 117,
  sym_infix_pattern = 118,
  sym_capture_pattern = 119,
  sym_typed_pattern = 120,
  sym_alternative_pattern = 121,
  sym_tuple_pattern = 122,
  sym__expression = 123,
  sym_if_expression = 124,
  sym_match_expression = 125,
  sym_try_expression = 126,
  sym_catch_clause = 127,
  sym_finally_clause = 128,
  sym_case_block = 129,
  sym_case_clause = 130,
  sym_guard = 131,
  sym_assignment_expression = 132,
  sym_generic_function = 133,
  sym_call_expression = 134,
  sym_field_expression = 135,
  sym_instance_expression = 136,
  sym_infix_expression = 137,
  sym_prefix_expression = 138,
  sym_tuple_expression = 139,
  sym_parenthesized_expression = 140,
  sym_type_arguments = 141,
  sym_arguments = 142,
  sym_string_transform_expression = 143,
  sym_string = 144,
  sym_interpolation = 145,
  aux_sym_compilation_unit_repeat1 = 146,
  aux_sym_package_identifier_repeat1 = 147,
  aux_sym_import_declaration_repeat1 = 148,
  aux_sym_import_selectors_repeat1 = 149,
  aux_sym_class_definition_repeat1 = 150,
  aux_sym_class_definition_repeat2 = 151,
  aux_sym_type_parameters_repeat1 = 152,
  aux_sym__type_parameter_repeat1 = 153,
  aux_sym__type_parameter_repeat2 = 154,
  aux_sym_annotation_repeat1 = 155,
  aux_sym_val_declaration_repeat1 = 156,
  aux_sym_function_definition_repeat1 = 157,
  aux_sym_modifiers_repeat1 = 158,
  aux_sym_class_parameters_repeat1 = 159,
  aux_sym_parameters_repeat1 = 160,
  aux_sym__block_repeat1 = 161,
  aux_sym_compound_type_repeat1 = 162,
  aux_sym_tuple_type_repeat1 = 163,
  aux_sym_parameter_types_repeat1 = 164,
  aux_sym_case_class_pattern_repeat1 = 165,
  aux_sym_case_block_repeat1 = 166,
  aux_sym_tuple_expression_repeat1 = 167,
  aux_sym_string_repeat1 = 168,
  aux_sym_string_repeat2 = 169,
  alias_sym_type_identifier = 170,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_package] = "package",
  [anon_sym_DOT] = ".",
  [anon_sym_object] = "object",
  [anon_sym_import] = "import",
  [anon_sym_COMMA] = ",",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_case] = "case",
  [anon_sym_class] = "class",
  [anon_sym_trait] = "trait",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_LT_COLON] = "<:",
  [anon_sym_GT_COLON] = ">:",
  [anon_sym_LT_PERCENT] = "<%",
  [anon_sym_COLON] = ":",
  [anon_sym_AT] = "@",
  [anon_sym_val] = "val",
  [anon_sym_EQ] = "=",
  [anon_sym_var] = "var",
  [anon_sym_type] = "type",
  [anon_sym_def] = "def",
  [anon_sym_abstract] = "abstract",
  [anon_sym_final] = "final",
  [anon_sym_sealed] = "sealed",
  [anon_sym_implicit] = "implicit",
  [anon_sym_lazy] = "lazy",
  [anon_sym_override] = "override",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_extends] = "extends",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_with] = "with",
  [anon_sym_POUND] = "#",
  [anon_sym_STAR] = "*",
  [anon_sym_PIPE] = "|",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_match] = "match",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_new] = "new",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [sym_wildcard] = "wildcard",
  [sym_operator_identifier] = "operator_identifier",
  [sym_number] = "number",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_SEMI] = ";",
  [sym_comment] = "comment",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__simple_string] = "_simple_string",
  [sym__string_start] = "_string_start",
  [sym__string_middle] = "_string_middle",
  [sym__string_end] = "_string_end",
  [sym__multiline_string_start] = "_multiline_string_start",
  [sym__multiline_string_middle] = "_multiline_string_middle",
  [sym__multiline_string_end] = "_multiline_string_end",
  [sym_compilation_unit] = "compilation_unit",
  [sym_package_clause] = "package_clause",
  [sym_package_identifier] = "package_identifier",
  [sym_package_object] = "package_object",
  [sym_import_declaration] = "import_declaration",
  [sym__import_expression] = "_import_expression",
  [sym_import_selectors] = "import_selectors",
  [sym_renamed_identifier] = "renamed_identifier",
  [sym_object_definition] = "object_definition",
  [sym__object_definition] = "_object_definition",
  [sym_class_definition] = "class_definition",
  [sym_trait_definition] = "trait_definition",
  [sym_type_parameters] = "type_parameters",
  [sym__variant_type_parameter] = "_variant_type_parameter",
  [sym_covariant_type_parameter] = "covariant_type_parameter",
  [sym_contravariant_type_parameter] = "contravariant_type_parameter",
  [sym__type_parameter] = "_type_parameter",
  [sym_upper_bound] = "upper_bound",
  [sym_lower_bound] = "lower_bound",
  [sym_view_bound] = "view_bound",
  [sym_context_bound] = "context_bound",
  [sym_template_body] = "template_body",
  [sym_annotation] = "annotation",
  [sym_val_definition] = "val_definition",
  [sym_val_declaration] = "val_declaration",
  [sym_var_declaration] = "var_declaration",
  [sym_var_definition] = "var_definition",
  [sym_type_definition] = "type_definition",
  [sym_function_definition] = "function_definition",
  [sym_function_declaration] = "function_declaration",
  [sym_modifiers] = "modifiers",
  [sym_extends_clause] = "extends_clause",
  [sym_class_parameters] = "class_parameters",
  [sym_parameters] = "parameters",
  [sym_class_parameter] = "class_parameter",
  [sym_parameter] = "parameter",
  [sym__block] = "_block",
  [sym_block] = "block",
  [sym__type] = "_type",
  [sym__annotated_type] = "_annotated_type",
  [sym__simple_type] = "_simple_type",
  [sym_compound_type] = "compound_type",
  [sym_infix_type] = "infix_type",
  [sym_tuple_type] = "tuple_type",
  [sym_stable_type_identifier] = "stable_type_identifier",
  [sym_stable_identifier] = "stable_identifier",
  [sym_generic_type] = "generic_type",
  [sym_projected_type] = "projected_type",
  [sym_function_type] = "function_type",
  [sym_parameter_types] = "parameter_types",
  [sym_lazy_parameter_type] = "lazy_parameter_type",
  [sym_repeated_parameter_type] = "repeated_parameter_type",
  [sym_case_class_pattern] = "case_class_pattern",
  [sym_infix_pattern] = "infix_pattern",
  [sym_capture_pattern] = "capture_pattern",
  [sym_typed_pattern] = "typed_pattern",
  [sym_alternative_pattern] = "alternative_pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym__expression] = "_expression",
  [sym_if_expression] = "if_expression",
  [sym_match_expression] = "match_expression",
  [sym_try_expression] = "try_expression",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_case_block] = "case_block",
  [sym_case_clause] = "case_clause",
  [sym_guard] = "guard",
  [sym_assignment_expression] = "assignment_expression",
  [sym_generic_function] = "generic_function",
  [sym_call_expression] = "call_expression",
  [sym_field_expression] = "field_expression",
  [sym_instance_expression] = "instance_expression",
  [sym_infix_expression] = "infix_expression",
  [sym_prefix_expression] = "prefix_expression",
  [sym_tuple_expression] = "tuple_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_type_arguments] = "type_arguments",
  [sym_arguments] = "arguments",
  [sym_string_transform_expression] = "string_transform_expression",
  [sym_string] = "string",
  [sym_interpolation] = "interpolation",
  [aux_sym_compilation_unit_repeat1] = "compilation_unit_repeat1",
  [aux_sym_package_identifier_repeat1] = "package_identifier_repeat1",
  [aux_sym_import_declaration_repeat1] = "import_declaration_repeat1",
  [aux_sym_import_selectors_repeat1] = "import_selectors_repeat1",
  [aux_sym_class_definition_repeat1] = "class_definition_repeat1",
  [aux_sym_class_definition_repeat2] = "class_definition_repeat2",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym__type_parameter_repeat1] = "_type_parameter_repeat1",
  [aux_sym__type_parameter_repeat2] = "_type_parameter_repeat2",
  [aux_sym_annotation_repeat1] = "annotation_repeat1",
  [aux_sym_val_declaration_repeat1] = "val_declaration_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_modifiers_repeat1] = "modifiers_repeat1",
  [aux_sym_class_parameters_repeat1] = "class_parameters_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym__block_repeat1] = "_block_repeat1",
  [aux_sym_compound_type_repeat1] = "compound_type_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_parameter_types_repeat1] = "parameter_types_repeat1",
  [aux_sym_case_class_pattern_repeat1] = "case_class_pattern_repeat1",
  [aux_sym_case_block_repeat1] = "case_block_repeat1",
  [aux_sym_tuple_expression_repeat1] = "tuple_expression_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [alias_sym_type_identifier] = "type_identifier",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_object] = anon_sym_object,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_trait] = anon_sym_trait,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_LT_COLON] = anon_sym_LT_COLON,
  [anon_sym_GT_COLON] = anon_sym_GT_COLON,
  [anon_sym_LT_PERCENT] = anon_sym_LT_PERCENT,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_val] = anon_sym_val,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_sealed] = anon_sym_sealed,
  [anon_sym_implicit] = anon_sym_implicit,
  [anon_sym_lazy] = anon_sym_lazy,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [sym_wildcard] = sym_wildcard,
  [sym_operator_identifier] = sym_operator_identifier,
  [sym_number] = sym_number,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [sym_comment] = sym_comment,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__simple_string] = sym__simple_string,
  [sym__string_start] = sym__string_start,
  [sym__string_middle] = sym__string_middle,
  [sym__string_end] = sym__string_end,
  [sym__multiline_string_start] = sym__multiline_string_start,
  [sym__multiline_string_middle] = sym__multiline_string_middle,
  [sym__multiline_string_end] = sym__multiline_string_end,
  [sym_compilation_unit] = sym_compilation_unit,
  [sym_package_clause] = sym_package_clause,
  [sym_package_identifier] = sym_package_identifier,
  [sym_package_object] = sym_package_object,
  [sym_import_declaration] = sym_import_declaration,
  [sym__import_expression] = sym__import_expression,
  [sym_import_selectors] = sym_import_selectors,
  [sym_renamed_identifier] = sym_renamed_identifier,
  [sym_object_definition] = sym_object_definition,
  [sym__object_definition] = sym__object_definition,
  [sym_class_definition] = sym_class_definition,
  [sym_trait_definition] = sym_trait_definition,
  [sym_type_parameters] = sym_type_parameters,
  [sym__variant_type_parameter] = sym__variant_type_parameter,
  [sym_covariant_type_parameter] = sym_covariant_type_parameter,
  [sym_contravariant_type_parameter] = sym_contravariant_type_parameter,
  [sym__type_parameter] = sym__type_parameter,
  [sym_upper_bound] = sym_upper_bound,
  [sym_lower_bound] = sym_lower_bound,
  [sym_view_bound] = sym_view_bound,
  [sym_context_bound] = sym_context_bound,
  [sym_template_body] = sym_template_body,
  [sym_annotation] = sym_annotation,
  [sym_val_definition] = sym_val_definition,
  [sym_val_declaration] = sym_val_declaration,
  [sym_var_declaration] = sym_var_declaration,
  [sym_var_definition] = sym_var_definition,
  [sym_type_definition] = sym_type_definition,
  [sym_function_definition] = sym_function_definition,
  [sym_function_declaration] = sym_function_declaration,
  [sym_modifiers] = sym_modifiers,
  [sym_extends_clause] = sym_extends_clause,
  [sym_class_parameters] = sym_class_parameters,
  [sym_parameters] = sym_parameters,
  [sym_class_parameter] = sym_class_parameter,
  [sym_parameter] = sym_parameter,
  [sym__block] = sym__block,
  [sym_block] = sym_block,
  [sym__type] = sym__type,
  [sym__annotated_type] = sym__annotated_type,
  [sym__simple_type] = sym__simple_type,
  [sym_compound_type] = sym_compound_type,
  [sym_infix_type] = sym_infix_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_stable_type_identifier] = sym_stable_type_identifier,
  [sym_stable_identifier] = sym_stable_identifier,
  [sym_generic_type] = sym_generic_type,
  [sym_projected_type] = sym_projected_type,
  [sym_function_type] = sym_function_type,
  [sym_parameter_types] = sym_parameter_types,
  [sym_lazy_parameter_type] = sym_lazy_parameter_type,
  [sym_repeated_parameter_type] = sym_repeated_parameter_type,
  [sym_case_class_pattern] = sym_case_class_pattern,
  [sym_infix_pattern] = sym_infix_pattern,
  [sym_capture_pattern] = sym_capture_pattern,
  [sym_typed_pattern] = sym_typed_pattern,
  [sym_alternative_pattern] = sym_alternative_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym__expression] = sym__expression,
  [sym_if_expression] = sym_if_expression,
  [sym_match_expression] = sym_match_expression,
  [sym_try_expression] = sym_try_expression,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_case_block] = sym_case_block,
  [sym_case_clause] = sym_case_clause,
  [sym_guard] = sym_guard,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_generic_function] = sym_generic_function,
  [sym_call_expression] = sym_call_expression,
  [sym_field_expression] = sym_field_expression,
  [sym_instance_expression] = sym_instance_expression,
  [sym_infix_expression] = sym_infix_expression,
  [sym_prefix_expression] = sym_prefix_expression,
  [sym_tuple_expression] = sym_tuple_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_type_arguments] = sym_type_arguments,
  [sym_arguments] = sym_arguments,
  [sym_string_transform_expression] = sym_string_transform_expression,
  [sym_string] = sym_string,
  [sym_interpolation] = sym_interpolation,
  [aux_sym_compilation_unit_repeat1] = aux_sym_compilation_unit_repeat1,
  [aux_sym_package_identifier_repeat1] = aux_sym_package_identifier_repeat1,
  [aux_sym_import_declaration_repeat1] = aux_sym_import_declaration_repeat1,
  [aux_sym_import_selectors_repeat1] = aux_sym_import_selectors_repeat1,
  [aux_sym_class_definition_repeat1] = aux_sym_class_definition_repeat1,
  [aux_sym_class_definition_repeat2] = aux_sym_class_definition_repeat2,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym__type_parameter_repeat1] = aux_sym__type_parameter_repeat1,
  [aux_sym__type_parameter_repeat2] = aux_sym__type_parameter_repeat2,
  [aux_sym_annotation_repeat1] = aux_sym_annotation_repeat1,
  [aux_sym_val_declaration_repeat1] = aux_sym_val_declaration_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_modifiers_repeat1] = aux_sym_modifiers_repeat1,
  [aux_sym_class_parameters_repeat1] = aux_sym_class_parameters_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym__block_repeat1] = aux_sym__block_repeat1,
  [aux_sym_compound_type_repeat1] = aux_sym_compound_type_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_parameter_types_repeat1] = aux_sym_parameter_types_repeat1,
  [aux_sym_case_class_pattern_repeat1] = aux_sym_case_class_pattern_repeat1,
  [aux_sym_case_block_repeat1] = aux_sym_case_block_repeat1,
  [aux_sym_tuple_expression_repeat1] = aux_sym_tuple_expression_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_object] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_trait] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_val] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sealed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implicit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lazy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_string] = {
    .visible = false,
    .named = true,
  },
  [sym__string_start] = {
    .visible = false,
    .named = true,
  },
  [sym__string_middle] = {
    .visible = false,
    .named = true,
  },
  [sym__string_end] = {
    .visible = false,
    .named = true,
  },
  [sym__multiline_string_start] = {
    .visible = false,
    .named = true,
  },
  [sym__multiline_string_middle] = {
    .visible = false,
    .named = true,
  },
  [sym__multiline_string_end] = {
    .visible = false,
    .named = true,
  },
  [sym_compilation_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_package_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_package_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_package_object] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__import_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_import_selectors] = {
    .visible = true,
    .named = true,
  },
  [sym_renamed_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_object_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__object_definition] = {
    .visible = false,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_trait_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__variant_type_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_covariant_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_contravariant_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__type_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_upper_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_lower_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_view_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_context_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_template_body] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_val_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_val_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_var_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_var_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_class_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_class_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__block] = {
    .visible = false,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__annotated_type] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_type] = {
    .visible = false,
    .named = true,
  },
  [sym_compound_type] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_stable_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_stable_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_projected_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_lazy_parameter_type] = {
    .visible = true,
    .named = true,
  },
  [sym_repeated_parameter_type] = {
    .visible = true,
    .named = true,
  },
  [sym_case_class_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_capture_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_alternative_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_if_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_match_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_try_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_block] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_guard] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_function] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instance_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_string_transform_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_compilation_unit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_package_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_selectors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_definition_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_parameter_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_parameter_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_val_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_compound_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_types_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_class_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_arguments = 3,
  field_base = 4,
  field_body = 5,
  field_bound = 6,
  field_class_parameters = 7,
  field_condition = 8,
  field_consequence = 9,
  field_default_value = 10,
  field_extend = 11,
  field_extra = 12,
  field_field = 13,
  field_function = 14,
  field_left = 15,
  field_name = 16,
  field_operator = 17,
  field_parameter_types = 18,
  field_parameters = 19,
  field_path = 20,
  field_pattern = 21,
  field_return_type = 22,
  field_right = 23,
  field_selector = 24,
  field_type = 25,
  field_type_arguments = 26,
  field_type_parameters = 27,
  field_value = 28,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_base] = "base",
  [field_body] = "body",
  [field_bound] = "bound",
  [field_class_parameters] = "class_parameters",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_default_value] = "default_value",
  [field_extend] = "extend",
  [field_extra] = "extra",
  [field_field] = "field",
  [field_function] = "function",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_parameter_types] = "parameter_types",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_pattern] = "pattern",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_selector] = "selector",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 3},
  [4] = {.index = 5, .length = 1},
  [5] = {.index = 6, .length = 1},
  [7] = {.index = 7, .length = 3},
  [8] = {.index = 10, .length = 2},
  [9] = {.index = 12, .length = 2},
  [10] = {.index = 14, .length = 2},
  [11] = {.index = 16, .length = 2},
  [12] = {.index = 18, .length = 1},
  [13] = {.index = 19, .length = 2},
  [14] = {.index = 21, .length = 2},
  [15] = {.index = 23, .length = 2},
  [16] = {.index = 25, .length = 2},
  [17] = {.index = 27, .length = 2},
  [18] = {.index = 29, .length = 2},
  [19] = {.index = 31, .length = 1},
  [20] = {.index = 32, .length = 3},
  [21] = {.index = 35, .length = 2},
  [22] = {.index = 37, .length = 2},
  [23] = {.index = 39, .length = 2},
  [24] = {.index = 41, .length = 2},
  [25] = {.index = 43, .length = 2},
  [26] = {.index = 45, .length = 3},
  [27] = {.index = 48, .length = 3},
  [28] = {.index = 51, .length = 3},
  [29] = {.index = 54, .length = 3},
  [30] = {.index = 57, .length = 3},
  [31] = {.index = 60, .length = 3},
  [32] = {.index = 63, .length = 2},
  [34] = {.index = 65, .length = 2},
  [35] = {.index = 67, .length = 2},
  [36] = {.index = 69, .length = 2},
  [37] = {.index = 71, .length = 2},
  [38] = {.index = 73, .length = 2},
  [39] = {.index = 75, .length = 1},
  [40] = {.index = 76, .length = 3},
  [41] = {.index = 79, .length = 2},
  [42] = {.index = 75, .length = 1},
  [43] = {.index = 69, .length = 2},
  [44] = {.index = 81, .length = 2},
  [45] = {.index = 83, .length = 2},
  [46] = {.index = 85, .length = 3},
  [47] = {.index = 88, .length = 3},
  [48] = {.index = 91, .length = 1},
  [49] = {.index = 92, .length = 2},
  [50] = {.index = 94, .length = 1},
  [51] = {.index = 95, .length = 2},
  [52] = {.index = 97, .length = 2},
  [53] = {.index = 99, .length = 3},
  [54] = {.index = 102, .length = 3},
  [55] = {.index = 105, .length = 3},
  [56] = {.index = 108, .length = 3},
  [57] = {.index = 111, .length = 3},
  [58] = {.index = 114, .length = 3},
  [59] = {.index = 117, .length = 3},
  [60] = {.index = 120, .length = 2},
  [61] = {.index = 122, .length = 2},
  [62] = {.index = 124, .length = 4},
  [63] = {.index = 128, .length = 4},
  [64] = {.index = 132, .length = 4},
  [65] = {.index = 136, .length = 4},
  [66] = {.index = 140, .length = 1},
  [67] = {.index = 141, .length = 2},
  [68] = {.index = 143, .length = 2},
  [69] = {.index = 145, .length = 2},
  [70] = {.index = 147, .length = 3},
  [71] = {.index = 145, .length = 2},
  [72] = {.index = 150, .length = 3},
  [73] = {.index = 153, .length = 3},
  [74] = {.index = 156, .length = 3},
  [75] = {.index = 159, .length = 3},
  [76] = {.index = 162, .length = 4},
  [77] = {.index = 166, .length = 3},
  [78] = {.index = 169, .length = 3},
  [79] = {.index = 172, .length = 2},
  [80] = {.index = 174, .length = 2},
  [81] = {.index = 176, .length = 2},
  [82] = {.index = 178, .length = 2},
  [83] = {.index = 180, .length = 2},
  [84] = {.index = 182, .length = 2},
  [85] = {.index = 180, .length = 2},
  [86] = {.index = 184, .length = 2},
  [87] = {.index = 186, .length = 2},
  [88] = {.index = 188, .length = 3},
  [89] = {.index = 191, .length = 3},
  [90] = {.index = 194, .length = 1},
  [91] = {.index = 195, .length = 2},
  [92] = {.index = 197, .length = 2},
  [93] = {.index = 199, .length = 2},
  [94] = {.index = 201, .length = 2},
  [95] = {.index = 203, .length = 2},
  [96] = {.index = 205, .length = 3},
  [97] = {.index = 208, .length = 4},
  [98] = {.index = 212, .length = 4},
  [99] = {.index = 216, .length = 4},
  [100] = {.index = 220, .length = 4},
  [101] = {.index = 224, .length = 3},
  [102] = {.index = 227, .length = 3},
  [103] = {.index = 230, .length = 6},
  [104] = {.index = 236, .length = 6},
  [105] = {.index = 242, .length = 2},
  [106] = {.index = 244, .length = 2},
  [107] = {.index = 246, .length = 5},
  [108] = {.index = 251, .length = 3},
  [109] = {.index = 254, .length = 3},
  [110] = {.index = 254, .length = 3},
  [111] = {.index = 257, .length = 3},
  [112] = {.index = 260, .length = 4},
  [113] = {.index = 264, .length = 4},
  [114] = {.index = 268, .length = 4},
  [115] = {.index = 272, .length = 4},
  [116] = {.index = 276, .length = 3},
  [117] = {.index = 279, .length = 3},
  [118] = {.index = 282, .length = 3},
  [119] = {.index = 285, .length = 3},
  [120] = {.index = 288, .length = 3},
  [121] = {.index = 291, .length = 3},
  [122] = {.index = 294, .length = 3},
  [123] = {.index = 297, .length = 3},
  [124] = {.index = 300, .length = 3},
  [125] = {.index = 303, .length = 3},
  [126] = {.index = 306, .length = 3},
  [127] = {.index = 309, .length = 4},
  [128] = {.index = 313, .length = 3},
  [129] = {.index = 316, .length = 3},
  [130] = {.index = 319, .length = 2},
  [131] = {.index = 321, .length = 2},
  [132] = {.index = 323, .length = 2},
  [133] = {.index = 325, .length = 2},
  [134] = {.index = 327, .length = 2},
  [135] = {.index = 329, .length = 2},
  [136] = {.index = 327, .length = 2},
  [137] = {.index = 331, .length = 2},
  [138] = {.index = 333, .length = 2},
  [139] = {.index = 335, .length = 3},
  [140] = {.index = 338, .length = 3},
  [141] = {.index = 341, .length = 1},
  [142] = {.index = 342, .length = 2},
  [143] = {.index = 344, .length = 5},
  [144] = {.index = 349, .length = 4},
  [145] = {.index = 353, .length = 4},
  [146] = {.index = 357, .length = 2},
  [147] = {.index = 359, .length = 4},
  [148] = {.index = 363, .length = 5},
  [149] = {.index = 368, .length = 4},
  [150] = {.index = 372, .length = 4},
  [151] = {.index = 376, .length = 4},
  [152] = {.index = 380, .length = 4},
  [153] = {.index = 384, .length = 4},
  [154] = {.index = 388, .length = 3},
  [155] = {.index = 391, .length = 3},
  [156] = {.index = 394, .length = 4},
  [157] = {.index = 398, .length = 4},
  [158] = {.index = 402, .length = 4},
  [159] = {.index = 406, .length = 4},
  [160] = {.index = 410, .length = 3},
  [161] = {.index = 413, .length = 3},
  [162] = {.index = 416, .length = 3},
  [163] = {.index = 419, .length = 3},
  [164] = {.index = 422, .length = 3},
  [165] = {.index = 425, .length = 3},
  [166] = {.index = 428, .length = 3},
  [167] = {.index = 431, .length = 3},
  [168] = {.index = 434, .length = 3},
  [169] = {.index = 437, .length = 3},
  [170] = {.index = 440, .length = 3},
  [171] = {.index = 443, .length = 4},
  [172] = {.index = 447, .length = 3},
  [173] = {.index = 450, .length = 3},
  [174] = {.index = 453, .length = 2},
  [175] = {.index = 455, .length = 1},
  [176] = {.index = 456, .length = 3},
  [177] = {.index = 459, .length = 5},
  [178] = {.index = 464, .length = 5},
  [179] = {.index = 469, .length = 3},
  [180] = {.index = 472, .length = 2},
  [181] = {.index = 474, .length = 5},
  [182] = {.index = 479, .length = 5},
  [183] = {.index = 484, .length = 4},
  [184] = {.index = 488, .length = 5},
  [185] = {.index = 493, .length = 4},
  [186] = {.index = 497, .length = 4},
  [187] = {.index = 501, .length = 4},
  [188] = {.index = 505, .length = 4},
  [189] = {.index = 509, .length = 4},
  [190] = {.index = 513, .length = 3},
  [191] = {.index = 516, .length = 3},
  [192] = {.index = 519, .length = 4},
  [193] = {.index = 523, .length = 4},
  [194] = {.index = 527, .length = 4},
  [195] = {.index = 531, .length = 4},
  [196] = {.index = 535, .length = 2},
  [197] = {.index = 537, .length = 6},
  [198] = {.index = 543, .length = 3},
  [199] = {.index = 546, .length = 5},
  [200] = {.index = 551, .length = 5},
  [201] = {.index = 556, .length = 4},
  [202] = {.index = 560, .length = 5},
  [203] = {.index = 565, .length = 4},
  [204] = {.index = 569, .length = 3},
  [205] = {.index = 572, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
  [1] =
    {field_name, 0},
  [2] =
    {field_body, 1, .inherited = true},
    {field_extend, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [5] =
    {field_path, 0},
  [6] =
    {field_path, 1, .inherited = true},
  [7] =
    {field_body, 2, .inherited = true},
    {field_extend, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [10] =
    {field_body, 2},
    {field_name, 1},
  [12] =
    {field_body, 1},
    {field_name, 0},
  [14] =
    {field_extend, 1},
    {field_name, 0},
  [16] =
    {field_path, 1, .inherited = true},
    {field_path, 2, .inherited = true},
  [18] =
    {field_name, 2},
  [19] =
    {field_name, 1},
    {field_type_parameters, 2},
  [21] =
    {field_extend, 2},
    {field_name, 1},
  [23] =
    {field_class_parameters, 2},
    {field_name, 1},
  [25] =
    {field_type, 0},
    {field_type_arguments, 1},
  [27] =
    {field_arguments, 2},
    {field_name, 1},
  [29] =
    {field_name, 1},
    {field_parameters, 2},
  [31] =
    {field_type, 1},
  [32] =
    {field_body, 2},
    {field_extend, 1},
    {field_name, 0},
  [35] =
    {field_path, 0, .inherited = true},
    {field_path, 1, .inherited = true},
  [37] =
    {field_name, 2},
    {field_type_parameters, 3},
  [39] =
    {field_body, 3},
    {field_name, 2},
  [41] =
    {field_extend, 3},
    {field_name, 2},
  [43] =
    {field_class_parameters, 3},
    {field_name, 2},
  [45] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [48] =
    {field_extend, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [51] =
    {field_class_parameters, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [54] =
    {field_body, 3},
    {field_extend, 2},
    {field_name, 1},
  [57] =
    {field_body, 3},
    {field_class_parameters, 2},
    {field_name, 1},
  [60] =
    {field_class_parameters, 2},
    {field_extend, 3},
    {field_name, 1},
  [63] =
    {field_base, 0},
    {field_extra, 1, .inherited = true},
  [65] =
    {field_selector, 2},
    {field_type, 0},
  [67] =
    {field_pattern, 0},
    {field_type, 2},
  [69] =
    {field_name, 1},
    {field_type, 3},
  [71] =
    {field_name, 0},
    {field_pattern, 2},
  [73] =
    {field_pattern, 1},
    {field_value, 3},
  [75] =
    {field_type, 0},
  [76] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [79] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [81] =
    {field_name, 1},
    {field_return_type, 3},
  [83] =
    {field_body, 3},
    {field_name, 1},
  [85] =
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [88] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [91] =
    {field_name, 3},
  [92] =
    {field_name, 2},
    {field_parameters, 3},
  [94] =
    {field_body, 1},
  [95] =
    {field_function, 0},
    {field_type_arguments, 1},
  [97] =
    {field_arguments, 1},
    {field_function, 0},
  [99] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [102] =
    {field_extend, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [105] =
    {field_class_parameters, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [108] =
    {field_body, 4},
    {field_extend, 3},
    {field_name, 2},
  [111] =
    {field_body, 4},
    {field_class_parameters, 3},
    {field_name, 2},
  [114] =
    {field_class_parameters, 3},
    {field_extend, 4},
    {field_name, 2},
  [117] =
    {field_bound, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [120] =
    {field_name, 0},
    {field_type_parameters, 1},
  [122] =
    {field_bound, 1},
    {field_name, 0},
  [124] =
    {field_body, 4},
    {field_extend, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [128] =
    {field_body, 4},
    {field_class_parameters, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [132] =
    {field_class_parameters, 3},
    {field_extend, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [136] =
    {field_body, 4},
    {field_class_parameters, 2},
    {field_extend, 3},
    {field_name, 1},
  [140] =
    {field_extra, 1},
  [141] =
    {field_extra, 0, .inherited = true},
    {field_extra, 1, .inherited = true},
  [143] =
    {field_parameter_types, 0},
    {field_return_type, 2},
  [145] =
    {field_pattern, 2},
    {field_type, 0},
  [147] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_type, 4},
  [150] =
    {field_name, 1},
    {field_type, 4},
    {field_type_parameters, 2},
  [153] =
    {field_body, 4},
    {field_name, 1},
    {field_return_type, 3},
  [156] =
    {field_name, 1},
    {field_return_type, 4},
    {field_type_parameters, 2},
  [159] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [162] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [166] =
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [169] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [172] =
    {field_name, 3},
    {field_type_parameters, 4},
  [174] =
    {field_body, 4},
    {field_name, 3},
  [176] =
    {field_extend, 4},
    {field_name, 3},
  [178] =
    {field_class_parameters, 4},
    {field_name, 3},
  [180] =
    {field_name, 2},
    {field_type, 4},
  [182] =
    {field_pattern, 2},
    {field_value, 4},
  [184] =
    {field_name, 2},
    {field_return_type, 4},
  [186] =
    {field_body, 4},
    {field_name, 2},
  [188] =
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [191] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [194] =
    {field_name, 4},
  [195] =
    {field_name, 3},
    {field_parameters, 4},
  [197] =
    {field_condition, 1},
    {field_consequence, 2},
  [199] =
    {field_field, 2},
    {field_value, 0},
  [201] =
    {field_left, 0},
    {field_right, 2},
  [203] =
    {field_body, 2},
    {field_value, 0},
  [205] =
    {field_arguments, 1},
    {field_body, 2},
    {field_function, 0},
  [208] =
    {field_body, 5},
    {field_extend, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [212] =
    {field_body, 5},
    {field_class_parameters, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [216] =
    {field_class_parameters, 4},
    {field_extend, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [220] =
    {field_body, 5},
    {field_class_parameters, 3},
    {field_extend, 4},
    {field_name, 2},
  [224] =
    {field_bound, 2},
    {field_name, 0},
    {field_type_parameters, 1},
  [227] =
    {field_bound, 1},
    {field_bound, 2},
    {field_name, 0},
  [230] =
    {field_bound, 1, .inherited = true},
    {field_bound, 2, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [236] =
    {field_bound, 0, .inherited = true},
    {field_bound, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [242] =
    {field_name, 0},
    {field_type, 2},
  [244] =
    {field_default_value, 2},
    {field_name, 0},
  [246] =
    {field_body, 5},
    {field_class_parameters, 3},
    {field_extend, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [251] =
    {field_pattern, 1},
    {field_type, 3},
    {field_value, 5},
  [254] =
    {field_pattern, 2},
    {field_pattern, 3},
    {field_type, 0},
  [257] =
    {field_body, 5},
    {field_name, 1},
    {field_return_type, 3},
  [260] =
    {field_body, 5},
    {field_name, 1},
    {field_return_type, 4},
    {field_type_parameters, 2},
  [264] =
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [268] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [272] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [276] =
    {field_body, 5},
    {field_name, 3},
    {field_type_parameters, 4},
  [279] =
    {field_extend, 5},
    {field_name, 3},
    {field_type_parameters, 4},
  [282] =
    {field_class_parameters, 5},
    {field_name, 3},
    {field_type_parameters, 4},
  [285] =
    {field_body, 5},
    {field_extend, 4},
    {field_name, 3},
  [288] =
    {field_body, 5},
    {field_class_parameters, 4},
    {field_name, 3},
  [291] =
    {field_class_parameters, 4},
    {field_extend, 5},
    {field_name, 3},
  [294] =
    {field_name, 2},
    {field_name, 3, .inherited = true},
    {field_type, 5},
  [297] =
    {field_name, 2},
    {field_type, 5},
    {field_type_parameters, 3},
  [300] =
    {field_body, 5},
    {field_name, 2},
    {field_return_type, 4},
  [303] =
    {field_name, 2},
    {field_return_type, 5},
    {field_type_parameters, 3},
  [306] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [309] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [313] =
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [316] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [319] =
    {field_name, 4},
    {field_type_parameters, 5},
  [321] =
    {field_body, 5},
    {field_name, 4},
  [323] =
    {field_extend, 5},
    {field_name, 4},
  [325] =
    {field_class_parameters, 5},
    {field_name, 4},
  [327] =
    {field_name, 3},
    {field_type, 5},
  [329] =
    {field_pattern, 3},
    {field_value, 5},
  [331] =
    {field_name, 3},
    {field_return_type, 5},
  [333] =
    {field_body, 5},
    {field_name, 3},
  [335] =
    {field_name, 3},
    {field_parameters, 5},
    {field_type_parameters, 4},
  [338] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4},
  [341] =
    {field_pattern, 1},
  [342] =
    {field_alias, 2},
    {field_name, 0},
  [344] =
    {field_body, 6},
    {field_class_parameters, 4},
    {field_extend, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [349] =
    {field_bound, 2},
    {field_bound, 3},
    {field_name, 0},
    {field_type_parameters, 1},
  [353] =
    {field_bound, 1},
    {field_bound, 2},
    {field_bound, 3},
    {field_name, 0},
  [357] =
    {field_default_value, 3},
    {field_name, 1},
  [359] =
    {field_body, 6},
    {field_name, 1},
    {field_return_type, 4},
    {field_type_parameters, 2},
  [363] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [368] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [372] =
    {field_body, 6},
    {field_extend, 5},
    {field_name, 3},
    {field_type_parameters, 4},
  [376] =
    {field_body, 6},
    {field_class_parameters, 5},
    {field_name, 3},
    {field_type_parameters, 4},
  [380] =
    {field_class_parameters, 5},
    {field_extend, 6},
    {field_name, 3},
    {field_type_parameters, 4},
  [384] =
    {field_body, 6},
    {field_class_parameters, 4},
    {field_extend, 5},
    {field_name, 3},
  [388] =
    {field_pattern, 2},
    {field_type, 4},
    {field_value, 6},
  [391] =
    {field_body, 6},
    {field_name, 2},
    {field_return_type, 4},
  [394] =
    {field_body, 6},
    {field_name, 2},
    {field_return_type, 5},
    {field_type_parameters, 3},
  [398] =
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [402] =
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [406] =
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [410] =
    {field_body, 6},
    {field_name, 4},
    {field_type_parameters, 5},
  [413] =
    {field_extend, 6},
    {field_name, 4},
    {field_type_parameters, 5},
  [416] =
    {field_class_parameters, 6},
    {field_name, 4},
    {field_type_parameters, 5},
  [419] =
    {field_body, 6},
    {field_extend, 5},
    {field_name, 4},
  [422] =
    {field_body, 6},
    {field_class_parameters, 5},
    {field_name, 4},
  [425] =
    {field_class_parameters, 5},
    {field_extend, 6},
    {field_name, 4},
  [428] =
    {field_name, 3},
    {field_name, 4, .inherited = true},
    {field_type, 6},
  [431] =
    {field_name, 3},
    {field_type, 6},
    {field_type_parameters, 4},
  [434] =
    {field_body, 6},
    {field_name, 3},
    {field_return_type, 5},
  [437] =
    {field_name, 3},
    {field_return_type, 6},
    {field_type_parameters, 4},
  [440] =
    {field_body, 6},
    {field_name, 3},
    {field_type_parameters, 4},
  [443] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 5},
    {field_type_parameters, 4},
  [447] =
    {field_name, 3},
    {field_parameters, 4},
    {field_return_type, 6},
  [450] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 4},
  [453] =
    {field_body, 3},
    {field_pattern, 1},
  [455] =
    {field_condition, 1},
  [456] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [459] =
    {field_bound, 2},
    {field_bound, 3},
    {field_bound, 4},
    {field_name, 0},
    {field_type_parameters, 1},
  [464] =
    {field_bound, 1},
    {field_bound, 2},
    {field_bound, 3},
    {field_bound, 4},
    {field_name, 0},
  [469] =
    {field_default_value, 4},
    {field_name, 0},
    {field_type, 2},
  [472] =
    {field_default_value, 4},
    {field_name, 2},
  [474] =
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [479] =
    {field_body, 7},
    {field_class_parameters, 5},
    {field_extend, 6},
    {field_name, 3},
    {field_type_parameters, 4},
  [484] =
    {field_body, 7},
    {field_name, 2},
    {field_return_type, 5},
    {field_type_parameters, 3},
  [488] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [493] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [497] =
    {field_body, 7},
    {field_extend, 6},
    {field_name, 4},
    {field_type_parameters, 5},
  [501] =
    {field_body, 7},
    {field_class_parameters, 6},
    {field_name, 4},
    {field_type_parameters, 5},
  [505] =
    {field_class_parameters, 6},
    {field_extend, 7},
    {field_name, 4},
    {field_type_parameters, 5},
  [509] =
    {field_body, 7},
    {field_class_parameters, 5},
    {field_extend, 6},
    {field_name, 4},
  [513] =
    {field_pattern, 3},
    {field_type, 5},
    {field_value, 7},
  [516] =
    {field_body, 7},
    {field_name, 3},
    {field_return_type, 5},
  [519] =
    {field_body, 7},
    {field_name, 3},
    {field_return_type, 6},
    {field_type_parameters, 4},
  [523] =
    {field_name, 3},
    {field_parameters, 5},
    {field_return_type, 7},
    {field_type_parameters, 4},
  [527] =
    {field_body, 7},
    {field_name, 3},
    {field_parameters, 5},
    {field_type_parameters, 4},
  [531] =
    {field_body, 7},
    {field_name, 3},
    {field_parameters, 4},
    {field_return_type, 6},
  [535] =
    {field_body, 4},
    {field_pattern, 1},
  [537] =
    {field_bound, 2},
    {field_bound, 3},
    {field_bound, 4},
    {field_bound, 5},
    {field_name, 0},
    {field_type_parameters, 1},
  [543] =
    {field_default_value, 5},
    {field_name, 1},
    {field_type, 3},
  [546] =
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [551] =
    {field_body, 8},
    {field_class_parameters, 6},
    {field_extend, 7},
    {field_name, 4},
    {field_type_parameters, 5},
  [556] =
    {field_body, 8},
    {field_name, 3},
    {field_return_type, 6},
    {field_type_parameters, 4},
  [560] =
    {field_body, 8},
    {field_name, 3},
    {field_parameters, 5},
    {field_return_type, 7},
    {field_type_parameters, 4},
  [565] =
    {field_body, 8},
    {field_name, 3},
    {field_parameters, 4},
    {field_return_type, 6},
  [569] =
    {field_default_value, 6},
    {field_name, 2},
    {field_type, 4},
  [572] =
    {field_body, 9},
    {field_name, 3},
    {field_parameters, 5},
    {field_return_type, 7},
    {field_type_parameters, 4},
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [6] = {
    [0] = alias_sym_type_identifier,
  },
  [33] = {
    [2] = alias_sym_type_identifier,
  },
  [34] = {
    [2] = alias_sym_type_identifier,
  },
  [39] = {
    [0] = alias_sym_type_identifier,
  },
  [43] = {
    [1] = alias_sym_type_identifier,
  },
  [69] = {
    [0] = alias_sym_type_identifier,
  },
  [72] = {
    [1] = alias_sym_type_identifier,
  },
  [85] = {
    [2] = alias_sym_type_identifier,
  },
  [109] = {
    [0] = alias_sym_type_identifier,
  },
  [123] = {
    [2] = alias_sym_type_identifier,
  },
  [136] = {
    [3] = alias_sym_type_identifier,
  },
  [167] = {
    [3] = alias_sym_type_identifier,
  },
};

static uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_operator_identifier_character_set_1(int32_t c) {
  return (c < ';'
    ? (c < '\''
      ? (c < '"'
        ? c == 0
        : c <= '"')
      : (c <= '\'' || (c >= '.' && c <= '9')))
    : (c <= ';' || (c < '`'
      ? (c < ']'
        ? c == '['
        : c <= ']')
      : (c <= '{' || c == '}'))));
}

static inline bool sym_operator_identifier_character_set_2(int32_t c) {
  return (c < ';'
    ? (c < '\''
      ? (c < '"'
        ? c == 0
        : c <= '"')
      : (c <= '(' || (c >= '.' && c <= '9')))
    : (c <= ';' || (c < '`'
      ? (c < ']'
        ? c == '['
        : c <= ']')
      : (c <= '{' || c == '}'))));
}

static inline bool sym_operator_identifier_character_set_4(int32_t c) {
  return (c < '.'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : (c <= '\n' || c == '\r'))
      : (c <= ' ' || (c < '\''
        ? c == '"'
        : (c <= ')' || c == ','))))
    : (c <= '.' || (c < ']'
      ? (c < ';'
        ? (c >= '0' && c <= '9')
        : (c <= ';' || (c >= 'A' && c <= '[')))
      : (c <= ']' || (c < '}'
        ? (c >= '_' && c <= '{')
        : c <= '}')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(41);
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(67);
      if (lookahead == '$') ADVANCE(85);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(51);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(52);
      if (lookahead == '.') ADVANCE(43);
      if (lookahead == '/') ADVANCE(23);
      if (lookahead == ':') ADVANCE(58);
      if (lookahead == ';') ADVANCE(86);
      if (lookahead == '<') ADVANCE(8);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(31);
      if (lookahead == '@') ADVANCE(60);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '|') ADVANCE(71);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '~') ADVANCE(74);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(84);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '+') ADVANCE(51);
      if (lookahead == '-') ADVANCE(52);
      if (lookahead == '/') ADVANCE(23);
      if (lookahead == '@') ADVANCE(60);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '~') ADVANCE(74);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(84);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 2:
      if (lookahead == '#') ADVANCE(68);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '=') ADVANCE(63);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != ';' &&
          lookahead != ']' &&
          (lookahead < '`' || '{' < lookahead) &&
          lookahead != '}') ADVANCE(83);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(68);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != ';' &&
          lookahead != ']' &&
          (lookahead < '`' || '{' < lookahead) &&
          lookahead != '}') ADVANCE(83);
      END_STATE();
    case 4:
      if (lookahead == '#') ADVANCE(68);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '|') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '0' || ';' < lookahead) &&
          lookahead != ']' &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(83);
      END_STATE();
    case 5:
      if (lookahead == '#') ADVANCE(68);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(80);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '0' || ';' < lookahead) &&
          (lookahead < '`' || '{' < lookahead) &&
          lookahead != '}') ADVANCE(83);
      END_STATE();
    case 6:
      if (lookahead == '#') ADVANCE(68);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '0' || ';' < lookahead) &&
          (lookahead < '`' || '{' < lookahead) &&
          lookahead != '}') ADVANCE(83);
      END_STATE();
    case 7:
      if (lookahead == '#') ADVANCE(68);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '0' || ';' < lookahead) &&
          (lookahead < '`' || '{' < lookahead) &&
          lookahead != '}') ADVANCE(83);
      END_STATE();
    case 8:
      if (lookahead == '%') ADVANCE(56);
      if (lookahead == ':') ADVANCE(53);
      END_STATE();
    case 9:
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '=') ADVANCE(63);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (!sym_operator_identifier_character_set_1(lookahead)) ADVANCE(83);
      END_STATE();
    case 10:
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (!sym_operator_identifier_character_set_1(lookahead)) ADVANCE(83);
      END_STATE();
    case 11:
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '|') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '0' || ';' < lookahead) &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(83);
      END_STATE();
    case 12:
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '|') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '0' || ';' < lookahead) &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(83);
      END_STATE();
    case 13:
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ';') ADVANCE(86);
      if (lookahead == '=') ADVANCE(64);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != ']' &&
          lookahead != '`') ADVANCE(83);
      END_STATE();
    case 14:
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ';') ADVANCE(86);
      if (lookahead == '=') ADVANCE(63);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != ']' &&
          lookahead != '`') ADVANCE(83);
      END_STATE();
    case 15:
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ';') ADVANCE(86);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '.' || '9' < lookahead) &&
          lookahead != '[' &&
          lookahead != '`') ADVANCE(83);
      END_STATE();
    case 16:
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(80);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '.' || ';' < lookahead) &&
          lookahead != '[' &&
          (lookahead < '`' || '{' < lookahead) &&
          lookahead != '}') ADVANCE(83);
      END_STATE();
    case 17:
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '.' || ';' < lookahead) &&
          lookahead != '[' &&
          (lookahead < '`' || '{' < lookahead) &&
          lookahead != '}') ADVANCE(83);
      END_STATE();
    case 18:
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '.' || ';' < lookahead) &&
          lookahead != '[' &&
          (lookahead < '`' || '{' < lookahead) &&
          lookahead != '}') ADVANCE(83);
      END_STATE();
    case 19:
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '=') ADVANCE(63);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (!sym_operator_identifier_character_set_2(lookahead)) ADVANCE(83);
      END_STATE();
    case 20:
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(20)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (!sym_operator_identifier_character_set_2(lookahead)) ADVANCE(83);
      END_STATE();
    case 21:
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '|') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '(' &&
          (lookahead < '.' || ';' < lookahead) &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(83);
      END_STATE();
    case 22:
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '|') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '(' &&
          (lookahead < '.' || ';' < lookahead) &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(83);
      END_STATE();
    case 23:
      if (lookahead == '*') ADVANCE(25);
      if (lookahead == '/') ADVANCE(88);
      END_STATE();
    case 24:
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '/') ADVANCE(87);
      if (lookahead != 0) ADVANCE(25);
      END_STATE();
    case 25:
      if (lookahead == '*') ADVANCE(24);
      if (lookahead != 0) ADVANCE(25);
      END_STATE();
    case 26:
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(80);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '.' || ';' < lookahead) &&
          lookahead != '[' &&
          (lookahead < '`' || '{' < lookahead) &&
          lookahead != '}') ADVANCE(83);
      END_STATE();
    case 27:
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '.' || ';' < lookahead) &&
          lookahead != '[' &&
          (lookahead < '`' || '{' < lookahead) &&
          lookahead != '}') ADVANCE(83);
      END_STATE();
    case 28:
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '.' || ';' < lookahead) &&
          lookahead != '[' &&
          (lookahead < '`' || '{' < lookahead) &&
          lookahead != '}') ADVANCE(83);
      END_STATE();
    case 29:
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == ';') ADVANCE(86);
      if (lookahead == '=') ADVANCE(64);
      if (lookahead == '|') ADVANCE(72);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(29)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          (lookahead < '.' || '9' < lookahead) &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '`' || '{' < lookahead)) ADVANCE(83);
      END_STATE();
    case 30:
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == ';') ADVANCE(86);
      if (lookahead == '=') ADVANCE(63);
      if (lookahead == '|') ADVANCE(72);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          (lookahead < '.' || '9' < lookahead) &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '`' || '{' < lookahead)) ADVANCE(83);
      END_STATE();
    case 31:
      if (lookahead == ':') ADVANCE(54);
      END_STATE();
    case 32:
      if (eof) ADVANCE(41);
      if (lookahead == '#') ADVANCE(67);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == '+') ADVANCE(51);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(52);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(23);
      if (lookahead == ';') ADVANCE(86);
      if (lookahead == '@') ADVANCE(60);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(32)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 33:
      if (eof) ADVANCE(41);
      if (lookahead == '#') ADVANCE(68);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ';') ADVANCE(86);
      if (lookahead == '=') ADVANCE(63);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != ']' &&
          lookahead != '`') ADVANCE(83);
      END_STATE();
    case 34:
      if (eof) ADVANCE(41);
      if (lookahead == '#') ADVANCE(68);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ';') ADVANCE(86);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '`') ADVANCE(83);
      END_STATE();
    case 35:
      if (eof) ADVANCE(41);
      if (lookahead == '#') ADVANCE(68);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == ';') ADVANCE(86);
      if (lookahead == '=') ADVANCE(63);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '|') ADVANCE(72);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != ']' &&
          (lookahead < '`' || '{' < lookahead)) ADVANCE(83);
      END_STATE();
    case 36:
      if (eof) ADVANCE(41);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ';') ADVANCE(86);
      if (lookahead == '=') ADVANCE(63);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(36)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '.' || '9' < lookahead) &&
          lookahead != '[' &&
          lookahead != ']' &&
          lookahead != '`') ADVANCE(83);
      END_STATE();
    case 37:
      if (eof) ADVANCE(41);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ';') ADVANCE(86);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(37)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '.' || '9' < lookahead) &&
          lookahead != '[' &&
          lookahead != '`') ADVANCE(83);
      END_STATE();
    case 38:
      if (eof) ADVANCE(41);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '=') ADVANCE(64);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '|') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(38)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '0' || ';' < lookahead) &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(83);
      END_STATE();
    case 39:
      if (eof) ADVANCE(41);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '=') ADVANCE(64);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(39)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != ';' &&
          lookahead != ']' &&
          lookahead != '`' &&
          lookahead != '}') ADVANCE(83);
      END_STATE();
    case 40:
      if (eof) ADVANCE(41);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == ';') ADVANCE(86);
      if (lookahead == '=') ADVANCE(63);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '|') ADVANCE(72);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(40)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          (lookahead < '.' || '9' < lookahead) &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '`' || '{' < lookahead)) ADVANCE(83);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(84);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      if (!sym_operator_identifier_character_set_4(lookahead)) ADVANCE(83);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LT_COLON);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_GT_COLON);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_GT_COLON);
      if (!sym_operator_identifier_character_set_4(lookahead)) ADVANCE(83);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_LT_PERCENT);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_LT_PERCENT);
      if (!sym_operator_identifier_character_set_4(lookahead)) ADVANCE(83);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (!sym_operator_identifier_character_set_4(lookahead)) ADVANCE(83);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_AT);
      if (!sym_operator_identifier_character_set_4(lookahead)) ADVANCE(83);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(47);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(48);
      if (!sym_operator_identifier_character_set_4(lookahead)) ADVANCE(83);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (!sym_operator_identifier_character_set_4(lookahead)) ADVANCE(83);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (!sym_operator_identifier_character_set_4(lookahead)) ADVANCE(83);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (!sym_operator_identifier_character_set_4(lookahead)) ADVANCE(83);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (!sym_operator_identifier_character_set_4(lookahead)) ADVANCE(83);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_operator_identifier);
      if (lookahead == '%') ADVANCE(57);
      if (!sym_operator_identifier_character_set_4(lookahead)) ADVANCE(83);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_operator_identifier);
      if (lookahead == '*') ADVANCE(79);
      if (lookahead == '/') ADVANCE(82);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          (lookahead < '.' || '9' < lookahead) &&
          lookahead != ';' &&
          (lookahead < 'A' || '[' < lookahead) &&
          lookahead != ']' &&
          (lookahead < '_' || '{' < lookahead) &&
          lookahead != '}') ADVANCE(83);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_operator_identifier);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '/') ADVANCE(83);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '"' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ',' ||
          ('.' <= lookahead && lookahead <= '9') ||
          lookahead == ';' ||
          ('A' <= lookahead && lookahead <= '[') ||
          lookahead == ']' ||
          ('_' <= lookahead && lookahead <= '{') ||
          lookahead == '}') ADVANCE(25);
      if (lookahead != 0) ADVANCE(79);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_operator_identifier);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '"' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ',' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == ';' ||
          ('A' <= lookahead && lookahead <= '[') ||
          lookahead == ']' ||
          ('_' <= lookahead && lookahead <= '{') ||
          lookahead == '}') ADVANCE(25);
      if (lookahead != 0) ADVANCE(79);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_operator_identifier);
      if (lookahead == ':') ADVANCE(55);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          lookahead != '.' &&
          (lookahead < '0' || ';' < lookahead) &&
          (lookahead < 'A' || '[' < lookahead) &&
          lookahead != ']' &&
          (lookahead < '_' || '{' < lookahead) &&
          lookahead != '}') ADVANCE(83);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_operator_identifier);
      if (lookahead == '>') ADVANCE(48);
      if (!sym_operator_identifier_character_set_4(lookahead)) ADVANCE(83);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_operator_identifier);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '"' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ',' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == ';' ||
          ('A' <= lookahead && lookahead <= '[') ||
          lookahead == ']' ||
          ('_' <= lookahead && lookahead <= '{') ||
          lookahead == '}') ADVANCE(88);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(82);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_operator_identifier);
      if (!sym_operator_identifier_character_set_4(lookahead)) ADVANCE(83);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(84);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(88);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '_') ADVANCE(1);
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'p') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'v') ADVANCE(15);
      if (lookahead == 'w') ADVANCE(16);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      ACCEPT_TOKEN(sym_wildcard);
      END_STATE();
    case 2:
      if (lookahead == 'b') ADVANCE(17);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(18);
      if (lookahead == 'l') ADVANCE(19);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(20);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(21);
      if (lookahead == 'x') ADVANCE(22);
      END_STATE();
    case 6:
      if (lookahead == 'i') ADVANCE(23);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(24);
      if (lookahead == 'm') ADVANCE(25);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(26);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(27);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(28);
      END_STATE();
    case 11:
      if (lookahead == 'b') ADVANCE(29);
      if (lookahead == 'v') ADVANCE(30);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(34);
      if (lookahead == 'y') ADVANCE(35);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(36);
      END_STATE();
    case 16:
      if (lookahead == 'i') ADVANCE(37);
      END_STATE();
    case 17:
      if (lookahead == 's') ADVANCE(38);
      END_STATE();
    case 18:
      if (lookahead == 's') ADVANCE(39);
      if (lookahead == 't') ADVANCE(40);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(41);
      END_STATE();
    case 20:
      if (lookahead == 'f') ADVANCE(42);
      END_STATE();
    case 21:
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 22:
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 23:
      if (lookahead == 'n') ADVANCE(45);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 25:
      if (lookahead == 'p') ADVANCE(46);
      END_STATE();
    case 26:
      if (lookahead == 'z') ADVANCE(47);
      END_STATE();
    case 27:
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 28:
      if (lookahead == 'w') ADVANCE(49);
      END_STATE();
    case 29:
      if (lookahead == 'j') ADVANCE(50);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 31:
      if (lookahead == 'c') ADVANCE(52);
      END_STATE();
    case 32:
      if (lookahead == 'i') ADVANCE(53);
      if (lookahead == 'o') ADVANCE(54);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 34:
      if (lookahead == 'a') ADVANCE(56);
      if (lookahead == 'y') ADVANCE(57);
      END_STATE();
    case 35:
      if (lookahead == 'p') ADVANCE(58);
      END_STATE();
    case 36:
      if (lookahead == 'l') ADVANCE(59);
      if (lookahead == 'r') ADVANCE(60);
      END_STATE();
    case 37:
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 38:
      if (lookahead == 't') ADVANCE(62);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(63);
      END_STATE();
    case 40:
      if (lookahead == 'c') ADVANCE(64);
      END_STATE();
    case 41:
      if (lookahead == 's') ADVANCE(65);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(68);
      END_STATE();
    case 46:
      if (lookahead == 'l') ADVANCE(69);
      if (lookahead == 'o') ADVANCE(70);
      END_STATE();
    case 47:
      if (lookahead == 'y') ADVANCE(71);
      END_STATE();
    case 48:
      if (lookahead == 'c') ADVANCE(72);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(73);
      END_STATE();
    case 51:
      if (lookahead == 'r') ADVANCE(74);
      END_STATE();
    case 52:
      if (lookahead == 'k') ADVANCE(75);
      END_STATE();
    case 53:
      if (lookahead == 'v') ADVANCE(76);
      END_STATE();
    case 54:
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 55:
      if (lookahead == 'l') ADVANCE(78);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(79);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_val);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 61:
      if (lookahead == 'h') ADVANCE(81);
      END_STATE();
    case 62:
      if (lookahead == 'r') ADVANCE(82);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 64:
      if (lookahead == 'h') ADVANCE(83);
      END_STATE();
    case 65:
      if (lookahead == 's') ADVANCE(84);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 67:
      if (lookahead == 'n') ADVANCE(85);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(86);
      END_STATE();
    case 69:
      if (lookahead == 'i') ADVANCE(87);
      END_STATE();
    case 70:
      if (lookahead == 'r') ADVANCE(88);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_lazy);
      END_STATE();
    case 72:
      if (lookahead == 'h') ADVANCE(89);
      END_STATE();
    case 73:
      if (lookahead == 'c') ADVANCE(90);
      END_STATE();
    case 74:
      if (lookahead == 'r') ADVANCE(91);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(92);
      END_STATE();
    case 76:
      if (lookahead == 'a') ADVANCE(93);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 82:
      if (lookahead == 'a') ADVANCE(97);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 85:
      if (lookahead == 'd') ADVANCE(98);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == 'l') ADVANCE(99);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(100);
      END_STATE();
    case 88:
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 90:
      if (lookahead == 't') ADVANCE(102);
      END_STATE();
    case 91:
      if (lookahead == 'i') ADVANCE(103);
      END_STATE();
    case 92:
      if (lookahead == 'g') ADVANCE(104);
      END_STATE();
    case 93:
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 94:
      if (lookahead == 'c') ADVANCE(106);
      END_STATE();
    case 95:
      if (lookahead == 'd') ADVANCE(107);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_trait);
      END_STATE();
    case 97:
      if (lookahead == 'c') ADVANCE(108);
      END_STATE();
    case 98:
      if (lookahead == 's') ADVANCE(109);
      END_STATE();
    case 99:
      if (lookahead == 'y') ADVANCE(110);
      END_STATE();
    case 100:
      if (lookahead == 'i') ADVANCE(111);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_object);
      END_STATE();
    case 103:
      if (lookahead == 'd') ADVANCE(112);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(113);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(114);
      END_STATE();
    case 106:
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_sealed);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(116);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_implicit);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 119:
      if (lookahead == 'd') ADVANCE(120);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 1, .external_lex_state = 2},
  [3] = {.lex_state = 1, .external_lex_state = 2},
  [4] = {.lex_state = 1, .external_lex_state = 2},
  [5] = {.lex_state = 1, .external_lex_state = 2},
  [6] = {.lex_state = 1, .external_lex_state = 2},
  [7] = {.lex_state = 1, .external_lex_state = 2},
  [8] = {.lex_state = 1, .external_lex_state = 2},
  [9] = {.lex_state = 1, .external_lex_state = 2},
  [10] = {.lex_state = 1, .external_lex_state = 2},
  [11] = {.lex_state = 1, .external_lex_state = 2},
  [12] = {.lex_state = 1, .external_lex_state = 2},
  [13] = {.lex_state = 1, .external_lex_state = 2},
  [14] = {.lex_state = 1, .external_lex_state = 2},
  [15] = {.lex_state = 1, .external_lex_state = 2},
  [16] = {.lex_state = 1, .external_lex_state = 2},
  [17] = {.lex_state = 1, .external_lex_state = 2},
  [18] = {.lex_state = 1, .external_lex_state = 2},
  [19] = {.lex_state = 1, .external_lex_state = 2},
  [20] = {.lex_state = 1, .external_lex_state = 2},
  [21] = {.lex_state = 1, .external_lex_state = 2},
  [22] = {.lex_state = 1, .external_lex_state = 2},
  [23] = {.lex_state = 1, .external_lex_state = 2},
  [24] = {.lex_state = 1, .external_lex_state = 2},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 39, .external_lex_state = 3},
  [28] = {.lex_state = 39, .external_lex_state = 3},
  [29] = {.lex_state = 39, .external_lex_state = 4},
  [30] = {.lex_state = 39},
  [31] = {.lex_state = 35},
  [32] = {.lex_state = 39, .external_lex_state = 2},
  [33] = {.lex_state = 39, .external_lex_state = 3},
  [34] = {.lex_state = 39},
  [35] = {.lex_state = 1, .external_lex_state = 2},
  [36] = {.lex_state = 1, .external_lex_state = 2},
  [37] = {.lex_state = 39, .external_lex_state = 3},
  [38] = {.lex_state = 39, .external_lex_state = 3},
  [39] = {.lex_state = 39, .external_lex_state = 3},
  [40] = {.lex_state = 39, .external_lex_state = 3},
  [41] = {.lex_state = 39, .external_lex_state = 3},
  [42] = {.lex_state = 39, .external_lex_state = 3},
  [43] = {.lex_state = 39, .external_lex_state = 4},
  [44] = {.lex_state = 33},
  [45] = {.lex_state = 1, .external_lex_state = 2},
  [46] = {.lex_state = 39, .external_lex_state = 3},
  [47] = {.lex_state = 1, .external_lex_state = 2},
  [48] = {.lex_state = 1, .external_lex_state = 2},
  [49] = {.lex_state = 1, .external_lex_state = 2},
  [50] = {.lex_state = 1, .external_lex_state = 2},
  [51] = {.lex_state = 1, .external_lex_state = 2},
  [52] = {.lex_state = 39},
  [53] = {.lex_state = 39, .external_lex_state = 3},
  [54] = {.lex_state = 1, .external_lex_state = 2},
  [55] = {.lex_state = 1, .external_lex_state = 2},
  [56] = {.lex_state = 1, .external_lex_state = 2},
  [57] = {.lex_state = 1, .external_lex_state = 2},
  [58] = {.lex_state = 1, .external_lex_state = 2},
  [59] = {.lex_state = 1, .external_lex_state = 2},
  [60] = {.lex_state = 1, .external_lex_state = 2},
  [61] = {.lex_state = 1, .external_lex_state = 2},
  [62] = {.lex_state = 1, .external_lex_state = 2},
  [63] = {.lex_state = 1, .external_lex_state = 2},
  [64] = {.lex_state = 1, .external_lex_state = 2},
  [65] = {.lex_state = 1, .external_lex_state = 2},
  [66] = {.lex_state = 1, .external_lex_state = 2},
  [67] = {.lex_state = 1, .external_lex_state = 2},
  [68] = {.lex_state = 1, .external_lex_state = 2},
  [69] = {.lex_state = 1, .external_lex_state = 2},
  [70] = {.lex_state = 35},
  [71] = {.lex_state = 1, .external_lex_state = 2},
  [72] = {.lex_state = 1, .external_lex_state = 2},
  [73] = {.lex_state = 1, .external_lex_state = 2},
  [74] = {.lex_state = 1, .external_lex_state = 2},
  [75] = {.lex_state = 1, .external_lex_state = 2},
  [76] = {.lex_state = 1, .external_lex_state = 2},
  [77] = {.lex_state = 1, .external_lex_state = 2},
  [78] = {.lex_state = 1, .external_lex_state = 2},
  [79] = {.lex_state = 1, .external_lex_state = 2},
  [80] = {.lex_state = 1, .external_lex_state = 2},
  [81] = {.lex_state = 1, .external_lex_state = 2},
  [82] = {.lex_state = 1, .external_lex_state = 2},
  [83] = {.lex_state = 1, .external_lex_state = 2},
  [84] = {.lex_state = 1, .external_lex_state = 2},
  [85] = {.lex_state = 1, .external_lex_state = 2},
  [86] = {.lex_state = 34},
  [87] = {.lex_state = 39, .external_lex_state = 2},
  [88] = {.lex_state = 1, .external_lex_state = 2},
  [89] = {.lex_state = 1, .external_lex_state = 2},
  [90] = {.lex_state = 1, .external_lex_state = 2},
  [91] = {.lex_state = 1, .external_lex_state = 2},
  [92] = {.lex_state = 1, .external_lex_state = 2},
  [93] = {.lex_state = 1, .external_lex_state = 2},
  [94] = {.lex_state = 34},
  [95] = {.lex_state = 39},
  [96] = {.lex_state = 39},
  [97] = {.lex_state = 1, .external_lex_state = 2},
  [98] = {.lex_state = 1, .external_lex_state = 2},
  [99] = {.lex_state = 1, .external_lex_state = 2},
  [100] = {.lex_state = 1, .external_lex_state = 2},
  [101] = {.lex_state = 1, .external_lex_state = 2},
  [102] = {.lex_state = 1, .external_lex_state = 2},
  [103] = {.lex_state = 1, .external_lex_state = 2},
  [104] = {.lex_state = 39},
  [105] = {.lex_state = 1, .external_lex_state = 2},
  [106] = {.lex_state = 1, .external_lex_state = 2},
  [107] = {.lex_state = 1, .external_lex_state = 2},
  [108] = {.lex_state = 1, .external_lex_state = 2},
  [109] = {.lex_state = 1, .external_lex_state = 2},
  [110] = {.lex_state = 1, .external_lex_state = 2},
  [111] = {.lex_state = 39},
  [112] = {.lex_state = 1, .external_lex_state = 2},
  [113] = {.lex_state = 1, .external_lex_state = 2},
  [114] = {.lex_state = 1, .external_lex_state = 2},
  [115] = {.lex_state = 1, .external_lex_state = 2},
  [116] = {.lex_state = 1, .external_lex_state = 2},
  [117] = {.lex_state = 1, .external_lex_state = 2},
  [118] = {.lex_state = 1, .external_lex_state = 2},
  [119] = {.lex_state = 1, .external_lex_state = 2},
  [120] = {.lex_state = 1, .external_lex_state = 2},
  [121] = {.lex_state = 39},
  [122] = {.lex_state = 1, .external_lex_state = 2},
  [123] = {.lex_state = 1, .external_lex_state = 2},
  [124] = {.lex_state = 1, .external_lex_state = 2},
  [125] = {.lex_state = 1, .external_lex_state = 2},
  [126] = {.lex_state = 1, .external_lex_state = 2},
  [127] = {.lex_state = 1, .external_lex_state = 2},
  [128] = {.lex_state = 39},
  [129] = {.lex_state = 1, .external_lex_state = 2},
  [130] = {.lex_state = 1, .external_lex_state = 2},
  [131] = {.lex_state = 1, .external_lex_state = 2},
  [132] = {.lex_state = 1, .external_lex_state = 2},
  [133] = {.lex_state = 1, .external_lex_state = 2},
  [134] = {.lex_state = 1, .external_lex_state = 2},
  [135] = {.lex_state = 1, .external_lex_state = 2},
  [136] = {.lex_state = 1, .external_lex_state = 2},
  [137] = {.lex_state = 1, .external_lex_state = 2},
  [138] = {.lex_state = 1, .external_lex_state = 2},
  [139] = {.lex_state = 1, .external_lex_state = 2},
  [140] = {.lex_state = 1, .external_lex_state = 2},
  [141] = {.lex_state = 1, .external_lex_state = 2},
  [142] = {.lex_state = 1, .external_lex_state = 2},
  [143] = {.lex_state = 1, .external_lex_state = 2},
  [144] = {.lex_state = 1, .external_lex_state = 2},
  [145] = {.lex_state = 35},
  [146] = {.lex_state = 1, .external_lex_state = 2},
  [147] = {.lex_state = 1, .external_lex_state = 2},
  [148] = {.lex_state = 1, .external_lex_state = 2},
  [149] = {.lex_state = 1, .external_lex_state = 2},
  [150] = {.lex_state = 1, .external_lex_state = 2},
  [151] = {.lex_state = 1, .external_lex_state = 2},
  [152] = {.lex_state = 1, .external_lex_state = 2},
  [153] = {.lex_state = 1, .external_lex_state = 2},
  [154] = {.lex_state = 1, .external_lex_state = 2},
  [155] = {.lex_state = 1, .external_lex_state = 2},
  [156] = {.lex_state = 1, .external_lex_state = 2},
  [157] = {.lex_state = 39, .external_lex_state = 3},
  [158] = {.lex_state = 1, .external_lex_state = 2},
  [159] = {.lex_state = 1, .external_lex_state = 2},
  [160] = {.lex_state = 1, .external_lex_state = 2},
  [161] = {.lex_state = 1, .external_lex_state = 2},
  [162] = {.lex_state = 1, .external_lex_state = 2},
  [163] = {.lex_state = 35},
  [164] = {.lex_state = 1, .external_lex_state = 2},
  [165] = {.lex_state = 1, .external_lex_state = 2},
  [166] = {.lex_state = 1, .external_lex_state = 2},
  [167] = {.lex_state = 1, .external_lex_state = 2},
  [168] = {.lex_state = 1, .external_lex_state = 2},
  [169] = {.lex_state = 1, .external_lex_state = 2},
  [170] = {.lex_state = 1, .external_lex_state = 2},
  [171] = {.lex_state = 1, .external_lex_state = 2},
  [172] = {.lex_state = 1, .external_lex_state = 2},
  [173] = {.lex_state = 1, .external_lex_state = 2},
  [174] = {.lex_state = 1, .external_lex_state = 2},
  [175] = {.lex_state = 1, .external_lex_state = 2},
  [176] = {.lex_state = 1, .external_lex_state = 2},
  [177] = {.lex_state = 1, .external_lex_state = 2},
  [178] = {.lex_state = 1, .external_lex_state = 2},
  [179] = {.lex_state = 1, .external_lex_state = 2},
  [180] = {.lex_state = 1, .external_lex_state = 2},
  [181] = {.lex_state = 1, .external_lex_state = 2},
  [182] = {.lex_state = 1, .external_lex_state = 2},
  [183] = {.lex_state = 1, .external_lex_state = 2},
  [184] = {.lex_state = 1, .external_lex_state = 2},
  [185] = {.lex_state = 1, .external_lex_state = 2},
  [186] = {.lex_state = 1, .external_lex_state = 2},
  [187] = {.lex_state = 1, .external_lex_state = 2},
  [188] = {.lex_state = 1, .external_lex_state = 2},
  [189] = {.lex_state = 1, .external_lex_state = 2},
  [190] = {.lex_state = 1, .external_lex_state = 2},
  [191] = {.lex_state = 1, .external_lex_state = 2},
  [192] = {.lex_state = 1, .external_lex_state = 2},
  [193] = {.lex_state = 1, .external_lex_state = 2},
  [194] = {.lex_state = 1, .external_lex_state = 2},
  [195] = {.lex_state = 1, .external_lex_state = 2},
  [196] = {.lex_state = 1, .external_lex_state = 2},
  [197] = {.lex_state = 1, .external_lex_state = 2},
  [198] = {.lex_state = 1, .external_lex_state = 2},
  [199] = {.lex_state = 1, .external_lex_state = 2},
  [200] = {.lex_state = 1, .external_lex_state = 2},
  [201] = {.lex_state = 1, .external_lex_state = 2},
  [202] = {.lex_state = 1, .external_lex_state = 2},
  [203] = {.lex_state = 1, .external_lex_state = 2},
  [204] = {.lex_state = 1, .external_lex_state = 2},
  [205] = {.lex_state = 1, .external_lex_state = 2},
  [206] = {.lex_state = 1, .external_lex_state = 2},
  [207] = {.lex_state = 1, .external_lex_state = 2},
  [208] = {.lex_state = 1, .external_lex_state = 2},
  [209] = {.lex_state = 1, .external_lex_state = 2},
  [210] = {.lex_state = 1, .external_lex_state = 2},
  [211] = {.lex_state = 1, .external_lex_state = 2},
  [212] = {.lex_state = 33},
  [213] = {.lex_state = 1, .external_lex_state = 2},
  [214] = {.lex_state = 1, .external_lex_state = 2},
  [215] = {.lex_state = 1, .external_lex_state = 2},
  [216] = {.lex_state = 1, .external_lex_state = 2},
  [217] = {.lex_state = 1, .external_lex_state = 2},
  [218] = {.lex_state = 1, .external_lex_state = 2},
  [219] = {.lex_state = 1, .external_lex_state = 2},
  [220] = {.lex_state = 1, .external_lex_state = 2},
  [221] = {.lex_state = 1, .external_lex_state = 2},
  [222] = {.lex_state = 1, .external_lex_state = 2},
  [223] = {.lex_state = 1, .external_lex_state = 2},
  [224] = {.lex_state = 1, .external_lex_state = 2},
  [225] = {.lex_state = 1, .external_lex_state = 2},
  [226] = {.lex_state = 1, .external_lex_state = 2},
  [227] = {.lex_state = 1, .external_lex_state = 2},
  [228] = {.lex_state = 1, .external_lex_state = 2},
  [229] = {.lex_state = 1, .external_lex_state = 2},
  [230] = {.lex_state = 39, .external_lex_state = 3},
  [231] = {.lex_state = 39, .external_lex_state = 3},
  [232] = {.lex_state = 39, .external_lex_state = 3},
  [233] = {.lex_state = 1, .external_lex_state = 2},
  [234] = {.lex_state = 1, .external_lex_state = 2},
  [235] = {.lex_state = 1, .external_lex_state = 2},
  [236] = {.lex_state = 1, .external_lex_state = 2},
  [237] = {.lex_state = 1, .external_lex_state = 2},
  [238] = {.lex_state = 1, .external_lex_state = 2},
  [239] = {.lex_state = 1, .external_lex_state = 2},
  [240] = {.lex_state = 1, .external_lex_state = 2},
  [241] = {.lex_state = 1, .external_lex_state = 2},
  [242] = {.lex_state = 1, .external_lex_state = 2},
  [243] = {.lex_state = 1, .external_lex_state = 2},
  [244] = {.lex_state = 1, .external_lex_state = 2},
  [245] = {.lex_state = 39, .external_lex_state = 3},
  [246] = {.lex_state = 1, .external_lex_state = 2},
  [247] = {.lex_state = 1, .external_lex_state = 2},
  [248] = {.lex_state = 1, .external_lex_state = 2},
  [249] = {.lex_state = 1, .external_lex_state = 2},
  [250] = {.lex_state = 1, .external_lex_state = 2},
  [251] = {.lex_state = 1, .external_lex_state = 2},
  [252] = {.lex_state = 1, .external_lex_state = 2},
  [253] = {.lex_state = 1, .external_lex_state = 2},
  [254] = {.lex_state = 1, .external_lex_state = 2},
  [255] = {.lex_state = 1, .external_lex_state = 2},
  [256] = {.lex_state = 1, .external_lex_state = 2},
  [257] = {.lex_state = 1, .external_lex_state = 2},
  [258] = {.lex_state = 1, .external_lex_state = 2},
  [259] = {.lex_state = 1, .external_lex_state = 2},
  [260] = {.lex_state = 1, .external_lex_state = 2},
  [261] = {.lex_state = 1, .external_lex_state = 2},
  [262] = {.lex_state = 1, .external_lex_state = 2},
  [263] = {.lex_state = 1, .external_lex_state = 2},
  [264] = {.lex_state = 1, .external_lex_state = 2},
  [265] = {.lex_state = 1, .external_lex_state = 2},
  [266] = {.lex_state = 1, .external_lex_state = 2},
  [267] = {.lex_state = 0},
  [268] = {.lex_state = 33},
  [269] = {.lex_state = 39, .external_lex_state = 3},
  [270] = {.lex_state = 39, .external_lex_state = 3},
  [271] = {.lex_state = 35},
  [272] = {.lex_state = 39, .external_lex_state = 3},
  [273] = {.lex_state = 39, .external_lex_state = 3},
  [274] = {.lex_state = 39, .external_lex_state = 3},
  [275] = {.lex_state = 39, .external_lex_state = 3},
  [276] = {.lex_state = 35},
  [277] = {.lex_state = 39, .external_lex_state = 3},
  [278] = {.lex_state = 39, .external_lex_state = 3},
  [279] = {.lex_state = 39, .external_lex_state = 3},
  [280] = {.lex_state = 39, .external_lex_state = 3},
  [281] = {.lex_state = 39, .external_lex_state = 3},
  [282] = {.lex_state = 39, .external_lex_state = 3},
  [283] = {.lex_state = 33},
  [284] = {.lex_state = 39, .external_lex_state = 3},
  [285] = {.lex_state = 39, .external_lex_state = 3},
  [286] = {.lex_state = 39, .external_lex_state = 3},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 39},
  [289] = {.lex_state = 40},
  [290] = {.lex_state = 39, .external_lex_state = 3},
  [291] = {.lex_state = 39},
  [292] = {.lex_state = 39, .external_lex_state = 3},
  [293] = {.lex_state = 39, .external_lex_state = 3},
  [294] = {.lex_state = 39, .external_lex_state = 3},
  [295] = {.lex_state = 39, .external_lex_state = 3},
  [296] = {.lex_state = 39},
  [297] = {.lex_state = 39, .external_lex_state = 3},
  [298] = {.lex_state = 39, .external_lex_state = 3},
  [299] = {.lex_state = 39, .external_lex_state = 3},
  [300] = {.lex_state = 35},
  [301] = {.lex_state = 40},
  [302] = {.lex_state = 39, .external_lex_state = 3},
  [303] = {.lex_state = 35},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 35},
  [306] = {.lex_state = 39, .external_lex_state = 3},
  [307] = {.lex_state = 39, .external_lex_state = 3},
  [308] = {.lex_state = 39, .external_lex_state = 3},
  [309] = {.lex_state = 35},
  [310] = {.lex_state = 39, .external_lex_state = 3},
  [311] = {.lex_state = 39},
  [312] = {.lex_state = 39, .external_lex_state = 3},
  [313] = {.lex_state = 39},
  [314] = {.lex_state = 39},
  [315] = {.lex_state = 33},
  [316] = {.lex_state = 39},
  [317] = {.lex_state = 40},
  [318] = {.lex_state = 39},
  [319] = {.lex_state = 39},
  [320] = {.lex_state = 39},
  [321] = {.lex_state = 39},
  [322] = {.lex_state = 39, .external_lex_state = 3},
  [323] = {.lex_state = 39},
  [324] = {.lex_state = 39},
  [325] = {.lex_state = 39, .external_lex_state = 3},
  [326] = {.lex_state = 39},
  [327] = {.lex_state = 39},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 39, .external_lex_state = 3},
  [330] = {.lex_state = 39},
  [331] = {.lex_state = 39},
  [332] = {.lex_state = 39},
  [333] = {.lex_state = 39},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 34},
  [336] = {.lex_state = 33},
  [337] = {.lex_state = 36},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 35},
  [340] = {.lex_state = 33},
  [341] = {.lex_state = 39},
  [342] = {.lex_state = 33},
  [343] = {.lex_state = 33},
  [344] = {.lex_state = 33},
  [345] = {.lex_state = 39},
  [346] = {.lex_state = 39},
  [347] = {.lex_state = 39},
  [348] = {.lex_state = 39},
  [349] = {.lex_state = 39},
  [350] = {.lex_state = 39},
  [351] = {.lex_state = 40},
  [352] = {.lex_state = 34},
  [353] = {.lex_state = 39},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 39},
  [356] = {.lex_state = 39},
  [357] = {.lex_state = 39},
  [358] = {.lex_state = 39},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 39},
  [361] = {.lex_state = 39},
  [362] = {.lex_state = 39},
  [363] = {.lex_state = 39},
  [364] = {.lex_state = 36},
  [365] = {.lex_state = 39},
  [366] = {.lex_state = 39},
  [367] = {.lex_state = 39},
  [368] = {.lex_state = 39},
  [369] = {.lex_state = 39},
  [370] = {.lex_state = 39},
  [371] = {.lex_state = 39},
  [372] = {.lex_state = 39},
  [373] = {.lex_state = 39},
  [374] = {.lex_state = 39},
  [375] = {.lex_state = 39},
  [376] = {.lex_state = 39},
  [377] = {.lex_state = 39},
  [378] = {.lex_state = 39},
  [379] = {.lex_state = 39},
  [380] = {.lex_state = 39},
  [381] = {.lex_state = 39},
  [382] = {.lex_state = 39},
  [383] = {.lex_state = 39},
  [384] = {.lex_state = 39},
  [385] = {.lex_state = 39},
  [386] = {.lex_state = 39},
  [387] = {.lex_state = 39},
  [388] = {.lex_state = 39},
  [389] = {.lex_state = 39},
  [390] = {.lex_state = 39},
  [391] = {.lex_state = 39},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 39},
  [394] = {.lex_state = 39},
  [395] = {.lex_state = 39},
  [396] = {.lex_state = 39},
  [397] = {.lex_state = 39},
  [398] = {.lex_state = 39},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 34},
  [401] = {.lex_state = 39, .external_lex_state = 3},
  [402] = {.lex_state = 39, .external_lex_state = 3},
  [403] = {.lex_state = 39, .external_lex_state = 3},
  [404] = {.lex_state = 39, .external_lex_state = 3},
  [405] = {.lex_state = 33},
  [406] = {.lex_state = 36},
  [407] = {.lex_state = 36},
  [408] = {.lex_state = 39, .external_lex_state = 3},
  [409] = {.lex_state = 40},
  [410] = {.lex_state = 39, .external_lex_state = 3},
  [411] = {.lex_state = 34},
  [412] = {.lex_state = 34},
  [413] = {.lex_state = 37},
  [414] = {.lex_state = 39, .external_lex_state = 3},
  [415] = {.lex_state = 37},
  [416] = {.lex_state = 39, .external_lex_state = 3},
  [417] = {.lex_state = 39, .external_lex_state = 3},
  [418] = {.lex_state = 34},
  [419] = {.lex_state = 40},
  [420] = {.lex_state = 39, .external_lex_state = 3},
  [421] = {.lex_state = 39, .external_lex_state = 3},
  [422] = {.lex_state = 39},
  [423] = {.lex_state = 39},
  [424] = {.lex_state = 37},
  [425] = {.lex_state = 39, .external_lex_state = 3},
  [426] = {.lex_state = 39, .external_lex_state = 3},
  [427] = {.lex_state = 34},
  [428] = {.lex_state = 39, .external_lex_state = 3},
  [429] = {.lex_state = 39, .external_lex_state = 3},
  [430] = {.lex_state = 39, .external_lex_state = 3},
  [431] = {.lex_state = 40},
  [432] = {.lex_state = 39, .external_lex_state = 3},
  [433] = {.lex_state = 40},
  [434] = {.lex_state = 40},
  [435] = {.lex_state = 39, .external_lex_state = 3},
  [436] = {.lex_state = 39, .external_lex_state = 3},
  [437] = {.lex_state = 37},
  [438] = {.lex_state = 40},
  [439] = {.lex_state = 34},
  [440] = {.lex_state = 39},
  [441] = {.lex_state = 40},
  [442] = {.lex_state = 34},
  [443] = {.lex_state = 39},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 37},
  [446] = {.lex_state = 40},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 39},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 0},
  [452] = {.lex_state = 37},
  [453] = {.lex_state = 0},
  [454] = {.lex_state = 0},
  [455] = {.lex_state = 0},
  [456] = {.lex_state = 0},
  [457] = {.lex_state = 39},
  [458] = {.lex_state = 39},
  [459] = {.lex_state = 39},
  [460] = {.lex_state = 36},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 39},
  [463] = {.lex_state = 36},
  [464] = {.lex_state = 0},
  [465] = {.lex_state = 37},
  [466] = {.lex_state = 39},
  [467] = {.lex_state = 36},
  [468] = {.lex_state = 39},
  [469] = {.lex_state = 36},
  [470] = {.lex_state = 0},
  [471] = {.lex_state = 0},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 37},
  [474] = {.lex_state = 39},
  [475] = {.lex_state = 39},
  [476] = {.lex_state = 36},
  [477] = {.lex_state = 39},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 39},
  [480] = {.lex_state = 0},
  [481] = {.lex_state = 39},
  [482] = {.lex_state = 39},
  [483] = {.lex_state = 0},
  [484] = {.lex_state = 0},
  [485] = {.lex_state = 39},
  [486] = {.lex_state = 0},
  [487] = {.lex_state = 36},
  [488] = {.lex_state = 39},
  [489] = {.lex_state = 39},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 36},
  [492] = {.lex_state = 0},
  [493] = {.lex_state = 39},
  [494] = {.lex_state = 39},
  [495] = {.lex_state = 36},
  [496] = {.lex_state = 40},
  [497] = {.lex_state = 40},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 37},
  [501] = {.lex_state = 37},
  [502] = {.lex_state = 37},
  [503] = {.lex_state = 37},
  [504] = {.lex_state = 38},
  [505] = {.lex_state = 37},
  [506] = {.lex_state = 38},
  [507] = {.lex_state = 38},
  [508] = {.lex_state = 36},
  [509] = {.lex_state = 0},
  [510] = {.lex_state = 38},
  [511] = {.lex_state = 38},
  [512] = {.lex_state = 37},
  [513] = {.lex_state = 36},
  [514] = {.lex_state = 38},
  [515] = {.lex_state = 38},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 32},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 32},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 32},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 32},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 32},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 0},
  [548] = {.lex_state = 32},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 32},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 32},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 0},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 0},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 0},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 1, .external_lex_state = 2},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 13, .external_lex_state = 5},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 13, .external_lex_state = 6},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 35, .external_lex_state = 7},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 1, .external_lex_state = 2},
  [691] = {.lex_state = 35, .external_lex_state = 7},
  [692] = {.lex_state = 1, .external_lex_state = 2},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 1, .external_lex_state = 2},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 13, .external_lex_state = 5},
  [699] = {.lex_state = 13, .external_lex_state = 8},
  [700] = {.lex_state = 1, .external_lex_state = 2},
  [701] = {.lex_state = 33, .external_lex_state = 7},
  [702] = {.lex_state = 1, .external_lex_state = 2},
  [703] = {.lex_state = 13, .external_lex_state = 7},
  [704] = {.lex_state = 1, .external_lex_state = 2},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 1, .external_lex_state = 2},
  [707] = {.lex_state = 1, .external_lex_state = 2},
  [708] = {.lex_state = 1, .external_lex_state = 2},
  [709] = {.lex_state = 1, .external_lex_state = 2},
  [710] = {.lex_state = 35, .external_lex_state = 7},
  [711] = {.lex_state = 4},
  [712] = {.lex_state = 33, .external_lex_state = 7},
  [713] = {.lex_state = 1, .external_lex_state = 2},
  [714] = {.lex_state = 1, .external_lex_state = 2},
  [715] = {.lex_state = 13, .external_lex_state = 5},
  [716] = {.lex_state = 1, .external_lex_state = 2},
  [717] = {.lex_state = 13, .external_lex_state = 5},
  [718] = {.lex_state = 34, .external_lex_state = 7},
  [719] = {.lex_state = 13, .external_lex_state = 5},
  [720] = {.lex_state = 1, .external_lex_state = 2},
  [721] = {.lex_state = 5},
  [722] = {.lex_state = 13, .external_lex_state = 5},
  [723] = {.lex_state = 1, .external_lex_state = 2},
  [724] = {.lex_state = 13, .external_lex_state = 3},
  [725] = {.lex_state = 1, .external_lex_state = 2},
  [726] = {.lex_state = 1, .external_lex_state = 2},
  [727] = {.lex_state = 1, .external_lex_state = 2},
  [728] = {.lex_state = 13, .external_lex_state = 5},
  [729] = {.lex_state = 1, .external_lex_state = 2},
  [730] = {.lex_state = 1, .external_lex_state = 2},
  [731] = {.lex_state = 1, .external_lex_state = 2},
  [732] = {.lex_state = 1, .external_lex_state = 2},
  [733] = {.lex_state = 1, .external_lex_state = 2},
  [734] = {.lex_state = 1, .external_lex_state = 2},
  [735] = {.lex_state = 35, .external_lex_state = 7},
  [736] = {.lex_state = 13, .external_lex_state = 5},
  [737] = {.lex_state = 13, .external_lex_state = 4},
  [738] = {.lex_state = 1, .external_lex_state = 2},
  [739] = {.lex_state = 1, .external_lex_state = 2},
  [740] = {.lex_state = 1, .external_lex_state = 2},
  [741] = {.lex_state = 1, .external_lex_state = 2},
  [742] = {.lex_state = 1, .external_lex_state = 2},
  [743] = {.lex_state = 13, .external_lex_state = 7},
  [744] = {.lex_state = 1, .external_lex_state = 2},
  [745] = {.lex_state = 1, .external_lex_state = 2},
  [746] = {.lex_state = 13, .external_lex_state = 5},
  [747] = {.lex_state = 34, .external_lex_state = 7},
  [748] = {.lex_state = 13, .external_lex_state = 5},
  [749] = {.lex_state = 1, .external_lex_state = 2},
  [750] = {.lex_state = 4},
  [751] = {.lex_state = 13, .external_lex_state = 7},
  [752] = {.lex_state = 13, .external_lex_state = 7},
  [753] = {.lex_state = 33, .external_lex_state = 7},
  [754] = {.lex_state = 13, .external_lex_state = 5},
  [755] = {.lex_state = 13, .external_lex_state = 3},
  [756] = {.lex_state = 35, .external_lex_state = 7},
  [757] = {.lex_state = 13, .external_lex_state = 5},
  [758] = {.lex_state = 13, .external_lex_state = 5},
  [759] = {.lex_state = 35, .external_lex_state = 7},
  [760] = {.lex_state = 33, .external_lex_state = 7},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 35, .external_lex_state = 7},
  [763] = {.lex_state = 40, .external_lex_state = 7},
  [764] = {.lex_state = 35, .external_lex_state = 7},
  [765] = {.lex_state = 13, .external_lex_state = 7},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 35, .external_lex_state = 7},
  [768] = {.lex_state = 13},
  [769] = {.lex_state = 14, .external_lex_state = 4},
  [770] = {.lex_state = 6},
  [771] = {.lex_state = 13, .external_lex_state = 5},
  [772] = {.lex_state = 40, .external_lex_state = 7},
  [773] = {.lex_state = 35, .external_lex_state = 7},
  [774] = {.lex_state = 13, .external_lex_state = 7},
  [775] = {.lex_state = 14, .external_lex_state = 3},
  [776] = {.lex_state = 2},
  [777] = {.lex_state = 13, .external_lex_state = 7},
  [778] = {.lex_state = 13, .external_lex_state = 7},
  [779] = {.lex_state = 13, .external_lex_state = 2},
  [780] = {.lex_state = 5},
  [781] = {.lex_state = 13, .external_lex_state = 3},
  [782] = {.lex_state = 33, .external_lex_state = 7},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 13, .external_lex_state = 5},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 5},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 14, .external_lex_state = 2},
  [795] = {.lex_state = 13},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 6},
  [799] = {.lex_state = 13, .external_lex_state = 7},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 5},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 13, .external_lex_state = 5},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 14, .external_lex_state = 3},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 13, .external_lex_state = 5},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 4},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 13, .external_lex_state = 5},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 4},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 13, .external_lex_state = 3},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 13, .external_lex_state = 7},
  [853] = {.lex_state = 7},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 14},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 13, .external_lex_state = 7},
  [865] = {.lex_state = 13, .external_lex_state = 7},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 13, .external_lex_state = 3},
  [871] = {.lex_state = 13, .external_lex_state = 3},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 13, .external_lex_state = 3},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 13, .external_lex_state = 3},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 13, .external_lex_state = 5},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 33},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 13, .external_lex_state = 3},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 2},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 35},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 13, .external_lex_state = 5},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 13, .external_lex_state = 5},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 13, .external_lex_state = 5},
  [909] = {.lex_state = 13, .external_lex_state = 5},
  [910] = {.lex_state = 33, .external_lex_state = 7},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 13, .external_lex_state = 5},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 13, .external_lex_state = 5},
  [916] = {.lex_state = 13, .external_lex_state = 5},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 33, .external_lex_state = 7},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 13, .external_lex_state = 5},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 13, .external_lex_state = 5},
  [931] = {.lex_state = 13, .external_lex_state = 5},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 13, .external_lex_state = 5},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 13, .external_lex_state = 5},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 13, .external_lex_state = 5},
  [946] = {.lex_state = 1, .external_lex_state = 2},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 13, .external_lex_state = 5},
  [951] = {.lex_state = 13, .external_lex_state = 5},
  [952] = {.lex_state = 34, .external_lex_state = 7},
  [953] = {.lex_state = 34},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 40, .external_lex_state = 7},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 34, .external_lex_state = 7},
  [959] = {.lex_state = 13, .external_lex_state = 3},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 3},
  [962] = {.lex_state = 35, .external_lex_state = 7},
  [963] = {.lex_state = 0},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 36, .external_lex_state = 7},
  [969] = {.lex_state = 40, .external_lex_state = 7},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 13, .external_lex_state = 7},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 33, .external_lex_state = 7},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 33, .external_lex_state = 7},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 36, .external_lex_state = 7},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 33, .external_lex_state = 7},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 13, .external_lex_state = 7},
  [990] = {.lex_state = 2},
  [991] = {.lex_state = 14, .external_lex_state = 3},
  [992] = {.lex_state = 13, .external_lex_state = 7},
  [993] = {.lex_state = 13, .external_lex_state = 7},
  [994] = {.lex_state = 13, .external_lex_state = 7},
  [995] = {.lex_state = 14, .external_lex_state = 3},
  [996] = {.lex_state = 13, .external_lex_state = 3},
  [997] = {.lex_state = 6},
  [998] = {.lex_state = 13, .external_lex_state = 7},
  [999] = {.lex_state = 13, .external_lex_state = 7},
  [1000] = {.lex_state = 7},
  [1001] = {.lex_state = 13, .external_lex_state = 7},
  [1002] = {.lex_state = 13, .external_lex_state = 7},
  [1003] = {.lex_state = 6},
  [1004] = {.lex_state = 13, .external_lex_state = 7},
  [1005] = {.lex_state = 13, .external_lex_state = 7},
  [1006] = {.lex_state = 5},
  [1007] = {.lex_state = 13, .external_lex_state = 7},
  [1008] = {.lex_state = 3},
  [1009] = {.lex_state = 14},
  [1010] = {.lex_state = 16},
  [1011] = {.lex_state = 5},
  [1012] = {.lex_state = 5},
  [1013] = {.lex_state = 16},
  [1014] = {.lex_state = 36, .external_lex_state = 7},
  [1015] = {.lex_state = 5},
  [1016] = {.lex_state = 13, .external_lex_state = 7},
  [1017] = {.lex_state = 13, .external_lex_state = 7},
  [1018] = {.lex_state = 13, .external_lex_state = 7},
  [1019] = {.lex_state = 0, .external_lex_state = 7},
  [1020] = {.lex_state = 13, .external_lex_state = 7},
  [1021] = {.lex_state = 13, .external_lex_state = 7},
  [1022] = {.lex_state = 33, .external_lex_state = 7},
  [1023] = {.lex_state = 34},
  [1024] = {.lex_state = 4},
  [1025] = {.lex_state = 13, .external_lex_state = 7},
  [1026] = {.lex_state = 13, .external_lex_state = 3},
  [1027] = {.lex_state = 36, .external_lex_state = 7},
  [1028] = {.lex_state = 13, .external_lex_state = 7},
  [1029] = {.lex_state = 13},
  [1030] = {.lex_state = 13},
  [1031] = {.lex_state = 11},
  [1032] = {.lex_state = 4},
  [1033] = {.lex_state = 0, .external_lex_state = 7},
  [1034] = {.lex_state = 13, .external_lex_state = 7},
  [1035] = {.lex_state = 4},
  [1036] = {.lex_state = 13, .external_lex_state = 7},
  [1037] = {.lex_state = 5},
  [1038] = {.lex_state = 11},
  [1039] = {.lex_state = 4},
  [1040] = {.lex_state = 0, .external_lex_state = 7},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 14, .external_lex_state = 3},
  [1043] = {.lex_state = 5},
  [1044] = {.lex_state = 13},
  [1045] = {.lex_state = 14, .external_lex_state = 3},
  [1046] = {.lex_state = 13, .external_lex_state = 7},
  [1047] = {.lex_state = 13, .external_lex_state = 7},
  [1048] = {.lex_state = 13, .external_lex_state = 7},
  [1049] = {.lex_state = 13, .external_lex_state = 3},
  [1050] = {.lex_state = 0, .external_lex_state = 7},
  [1051] = {.lex_state = 13, .external_lex_state = 7},
  [1052] = {.lex_state = 14, .external_lex_state = 3},
  [1053] = {.lex_state = 34, .external_lex_state = 7},
  [1054] = {.lex_state = 13, .external_lex_state = 7},
  [1055] = {.lex_state = 13},
  [1056] = {.lex_state = 13, .external_lex_state = 7},
  [1057] = {.lex_state = 14, .external_lex_state = 3},
  [1058] = {.lex_state = 13, .external_lex_state = 7},
  [1059] = {.lex_state = 13, .external_lex_state = 7},
  [1060] = {.lex_state = 37, .external_lex_state = 7},
  [1061] = {.lex_state = 13, .external_lex_state = 7},
  [1062] = {.lex_state = 13, .external_lex_state = 7},
  [1063] = {.lex_state = 13, .external_lex_state = 7},
  [1064] = {.lex_state = 33},
  [1065] = {.lex_state = 34, .external_lex_state = 7},
  [1066] = {.lex_state = 13, .external_lex_state = 7},
  [1067] = {.lex_state = 13, .external_lex_state = 7},
  [1068] = {.lex_state = 13, .external_lex_state = 7},
  [1069] = {.lex_state = 13, .external_lex_state = 7},
  [1070] = {.lex_state = 4},
  [1071] = {.lex_state = 13},
  [1072] = {.lex_state = 13, .external_lex_state = 7},
  [1073] = {.lex_state = 13, .external_lex_state = 3},
  [1074] = {.lex_state = 0, .external_lex_state = 7},
  [1075] = {.lex_state = 13, .external_lex_state = 7},
  [1076] = {.lex_state = 4},
  [1077] = {.lex_state = 40, .external_lex_state = 7},
  [1078] = {.lex_state = 13, .external_lex_state = 7},
  [1079] = {.lex_state = 40, .external_lex_state = 7},
  [1080] = {.lex_state = 40, .external_lex_state = 7},
  [1081] = {.lex_state = 34, .external_lex_state = 7},
  [1082] = {.lex_state = 13, .external_lex_state = 7},
  [1083] = {.lex_state = 37, .external_lex_state = 7},
  [1084] = {.lex_state = 13, .external_lex_state = 7},
  [1085] = {.lex_state = 13, .external_lex_state = 7},
  [1086] = {.lex_state = 34, .external_lex_state = 7},
  [1087] = {.lex_state = 13, .external_lex_state = 7},
  [1088] = {.lex_state = 13, .external_lex_state = 7},
  [1089] = {.lex_state = 0, .external_lex_state = 7},
  [1090] = {.lex_state = 37, .external_lex_state = 7},
  [1091] = {.lex_state = 13, .external_lex_state = 7},
  [1092] = {.lex_state = 13, .external_lex_state = 7},
  [1093] = {.lex_state = 13},
  [1094] = {.lex_state = 13, .external_lex_state = 7},
  [1095] = {.lex_state = 0, .external_lex_state = 7},
  [1096] = {.lex_state = 34, .external_lex_state = 7},
  [1097] = {.lex_state = 13, .external_lex_state = 7},
  [1098] = {.lex_state = 14, .external_lex_state = 3},
  [1099] = {.lex_state = 13, .external_lex_state = 7},
  [1100] = {.lex_state = 34, .external_lex_state = 7},
  [1101] = {.lex_state = 13, .external_lex_state = 7},
  [1102] = {.lex_state = 13, .external_lex_state = 7},
  [1103] = {.lex_state = 13, .external_lex_state = 7},
  [1104] = {.lex_state = 13, .external_lex_state = 7},
  [1105] = {.lex_state = 13, .external_lex_state = 7},
  [1106] = {.lex_state = 34, .external_lex_state = 7},
  [1107] = {.lex_state = 13, .external_lex_state = 7},
  [1108] = {.lex_state = 13, .external_lex_state = 7},
  [1109] = {.lex_state = 14, .external_lex_state = 3},
  [1110] = {.lex_state = 2},
  [1111] = {.lex_state = 13, .external_lex_state = 7},
  [1112] = {.lex_state = 13, .external_lex_state = 7},
  [1113] = {.lex_state = 13, .external_lex_state = 7},
  [1114] = {.lex_state = 35},
  [1115] = {.lex_state = 37, .external_lex_state = 7},
  [1116] = {.lex_state = 13},
  [1117] = {.lex_state = 13, .external_lex_state = 3},
  [1118] = {.lex_state = 13},
  [1119] = {.lex_state = 9},
  [1120] = {.lex_state = 17},
  [1121] = {.lex_state = 6},
  [1122] = {.lex_state = 13},
  [1123] = {.lex_state = 6},
  [1124] = {.lex_state = 17},
  [1125] = {.lex_state = 2},
  [1126] = {.lex_state = 6},
  [1127] = {.lex_state = 13},
  [1128] = {.lex_state = 2},
  [1129] = {.lex_state = 13},
  [1130] = {.lex_state = 14},
  [1131] = {.lex_state = 2},
  [1132] = {.lex_state = 14},
  [1133] = {.lex_state = 9},
  [1134] = {.lex_state = 2},
  [1135] = {.lex_state = 13},
  [1136] = {.lex_state = 14},
  [1137] = {.lex_state = 14},
  [1138] = {.lex_state = 13},
  [1139] = {.lex_state = 13},
  [1140] = {.lex_state = 13, .external_lex_state = 3},
  [1141] = {.lex_state = 2},
  [1142] = {.lex_state = 13},
  [1143] = {.lex_state = 14},
  [1144] = {.lex_state = 14},
  [1145] = {.lex_state = 13, .external_lex_state = 3},
  [1146] = {.lex_state = 34},
  [1147] = {.lex_state = 13},
  [1148] = {.lex_state = 13},
  [1149] = {.lex_state = 16},
  [1150] = {.lex_state = 2},
  [1151] = {.lex_state = 13, .external_lex_state = 3},
  [1152] = {.lex_state = 13, .external_lex_state = 3},
  [1153] = {.lex_state = 13},
  [1154] = {.lex_state = 6},
  [1155] = {.lex_state = 6},
  [1156] = {.lex_state = 13},
  [1157] = {.lex_state = 13},
  [1158] = {.lex_state = 13},
  [1159] = {.lex_state = 13},
  [1160] = {.lex_state = 13},
  [1161] = {.lex_state = 13},
  [1162] = {.lex_state = 6},
  [1163] = {.lex_state = 5},
  [1164] = {.lex_state = 13},
  [1165] = {.lex_state = 13},
  [1166] = {.lex_state = 13},
  [1167] = {.lex_state = 13},
  [1168] = {.lex_state = 13, .external_lex_state = 3},
  [1169] = {.lex_state = 13},
  [1170] = {.lex_state = 13},
  [1171] = {.lex_state = 34},
  [1172] = {.lex_state = 16},
  [1173] = {.lex_state = 33},
  [1174] = {.lex_state = 14, .external_lex_state = 3},
  [1175] = {.lex_state = 13},
  [1176] = {.lex_state = 13, .external_lex_state = 3},
  [1177] = {.lex_state = 11},
  [1178] = {.lex_state = 13},
  [1179] = {.lex_state = 13},
  [1180] = {.lex_state = 30, .external_lex_state = 7},
  [1181] = {.lex_state = 35},
  [1182] = {.lex_state = 13},
  [1183] = {.lex_state = 30, .external_lex_state = 7},
  [1184] = {.lex_state = 13},
  [1185] = {.lex_state = 30, .external_lex_state = 7},
  [1186] = {.lex_state = 13, .external_lex_state = 3},
  [1187] = {.lex_state = 13},
  [1188] = {.lex_state = 13},
  [1189] = {.lex_state = 7},
  [1190] = {.lex_state = 13},
  [1191] = {.lex_state = 13, .external_lex_state = 3},
  [1192] = {.lex_state = 4},
  [1193] = {.lex_state = 13},
  [1194] = {.lex_state = 13},
  [1195] = {.lex_state = 35},
  [1196] = {.lex_state = 13},
  [1197] = {.lex_state = 13},
  [1198] = {.lex_state = 3},
  [1199] = {.lex_state = 13},
  [1200] = {.lex_state = 13, .external_lex_state = 3},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 11},
  [1203] = {.lex_state = 13},
  [1204] = {.lex_state = 13, .external_lex_state = 3},
  [1205] = {.lex_state = 13},
  [1206] = {.lex_state = 14, .external_lex_state = 3},
  [1207] = {.lex_state = 13, .external_lex_state = 3},
  [1208] = {.lex_state = 13},
  [1209] = {.lex_state = 7},
  [1210] = {.lex_state = 14, .external_lex_state = 3},
  [1211] = {.lex_state = 13},
  [1212] = {.lex_state = 13},
  [1213] = {.lex_state = 36, .external_lex_state = 7},
  [1214] = {.lex_state = 14, .external_lex_state = 3},
  [1215] = {.lex_state = 33},
  [1216] = {.lex_state = 13, .external_lex_state = 3},
  [1217] = {.lex_state = 13, .external_lex_state = 3},
  [1218] = {.lex_state = 30, .external_lex_state = 7},
  [1219] = {.lex_state = 36, .external_lex_state = 7},
  [1220] = {.lex_state = 13, .external_lex_state = 3},
  [1221] = {.lex_state = 13, .external_lex_state = 3},
  [1222] = {.lex_state = 13, .external_lex_state = 3},
  [1223] = {.lex_state = 3},
  [1224] = {.lex_state = 13, .external_lex_state = 3},
  [1225] = {.lex_state = 13, .external_lex_state = 3},
  [1226] = {.lex_state = 36, .external_lex_state = 7},
  [1227] = {.lex_state = 13, .external_lex_state = 3},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 33},
  [1230] = {.lex_state = 13},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 0, .external_lex_state = 7},
  [1233] = {.lex_state = 14, .external_lex_state = 3},
  [1234] = {.lex_state = 3},
  [1235] = {.lex_state = 14, .external_lex_state = 3},
  [1236] = {.lex_state = 13},
  [1237] = {.lex_state = 13},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0, .external_lex_state = 7},
  [1240] = {.lex_state = 7},
  [1241] = {.lex_state = 35},
  [1242] = {.lex_state = 18},
  [1243] = {.lex_state = 7},
  [1244] = {.lex_state = 10},
  [1245] = {.lex_state = 3},
  [1246] = {.lex_state = 10},
  [1247] = {.lex_state = 7},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 13},
  [1250] = {.lex_state = 33},
  [1251] = {.lex_state = 18},
  [1252] = {.lex_state = 13},
  [1253] = {.lex_state = 3},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 7},
  [1256] = {.lex_state = 0, .external_lex_state = 7},
  [1257] = {.lex_state = 0, .external_lex_state = 7},
  [1258] = {.lex_state = 0},
  [1259] = {.lex_state = 14, .external_lex_state = 3},
  [1260] = {.lex_state = 34},
  [1261] = {.lex_state = 33},
  [1262] = {.lex_state = 40},
  [1263] = {.lex_state = 35},
  [1264] = {.lex_state = 0},
  [1265] = {.lex_state = 0, .external_lex_state = 7},
  [1266] = {.lex_state = 34},
  [1267] = {.lex_state = 35},
  [1268] = {.lex_state = 0},
  [1269] = {.lex_state = 13},
  [1270] = {.lex_state = 0, .external_lex_state = 7},
  [1271] = {.lex_state = 37},
  [1272] = {.lex_state = 14, .external_lex_state = 3},
  [1273] = {.lex_state = 14, .external_lex_state = 3},
  [1274] = {.lex_state = 0, .external_lex_state = 7},
  [1275] = {.lex_state = 35},
  [1276] = {.lex_state = 0, .external_lex_state = 7},
  [1277] = {.lex_state = 14, .external_lex_state = 3},
  [1278] = {.lex_state = 13},
  [1279] = {.lex_state = 33},
  [1280] = {.lex_state = 30, .external_lex_state = 7},
  [1281] = {.lex_state = 0},
  [1282] = {.lex_state = 14, .external_lex_state = 3},
  [1283] = {.lex_state = 36},
  [1284] = {.lex_state = 13},
  [1285] = {.lex_state = 14, .external_lex_state = 3},
  [1286] = {.lex_state = 13},
  [1287] = {.lex_state = 11},
  [1288] = {.lex_state = 33},
  [1289] = {.lex_state = 13},
  [1290] = {.lex_state = 37, .external_lex_state = 7},
  [1291] = {.lex_state = 0, .external_lex_state = 7},
  [1292] = {.lex_state = 14},
  [1293] = {.lex_state = 13},
  [1294] = {.lex_state = 3},
  [1295] = {.lex_state = 13},
  [1296] = {.lex_state = 13},
  [1297] = {.lex_state = 0, .external_lex_state = 7},
  [1298] = {.lex_state = 0, .external_lex_state = 7},
  [1299] = {.lex_state = 0, .external_lex_state = 7},
  [1300] = {.lex_state = 9},
  [1301] = {.lex_state = 14, .external_lex_state = 3},
  [1302] = {.lex_state = 37, .external_lex_state = 7},
  [1303] = {.lex_state = 14, .external_lex_state = 3},
  [1304] = {.lex_state = 14},
  [1305] = {.lex_state = 13},
  [1306] = {.lex_state = 40},
  [1307] = {.lex_state = 14, .external_lex_state = 3},
  [1308] = {.lex_state = 37, .external_lex_state = 7},
  [1309] = {.lex_state = 14, .external_lex_state = 3},
  [1310] = {.lex_state = 3},
  [1311] = {.lex_state = 13},
  [1312] = {.lex_state = 0},
  [1313] = {.lex_state = 13},
  [1314] = {.lex_state = 14, .external_lex_state = 7},
  [1315] = {.lex_state = 0, .external_lex_state = 7},
  [1316] = {.lex_state = 0, .external_lex_state = 7},
  [1317] = {.lex_state = 13},
  [1318] = {.lex_state = 13},
  [1319] = {.lex_state = 14, .external_lex_state = 7},
  [1320] = {.lex_state = 0, .external_lex_state = 7},
  [1321] = {.lex_state = 13},
  [1322] = {.lex_state = 14, .external_lex_state = 3},
  [1323] = {.lex_state = 0},
  [1324] = {.lex_state = 0},
  [1325] = {.lex_state = 15, .external_lex_state = 7},
  [1326] = {.lex_state = 0, .external_lex_state = 7},
  [1327] = {.lex_state = 0},
  [1328] = {.lex_state = 13},
  [1329] = {.lex_state = 14},
  [1330] = {.lex_state = 14, .external_lex_state = 3},
  [1331] = {.lex_state = 33},
  [1332] = {.lex_state = 0, .external_lex_state = 7},
  [1333] = {.lex_state = 0, .external_lex_state = 7},
  [1334] = {.lex_state = 14, .external_lex_state = 7},
  [1335] = {.lex_state = 3},
  [1336] = {.lex_state = 36},
  [1337] = {.lex_state = 14, .external_lex_state = 7},
  [1338] = {.lex_state = 0},
  [1339] = {.lex_state = 2},
  [1340] = {.lex_state = 14, .external_lex_state = 3},
  [1341] = {.lex_state = 0},
  [1342] = {.lex_state = 0, .external_lex_state = 7},
  [1343] = {.lex_state = 15, .external_lex_state = 7},
  [1344] = {.lex_state = 13},
  [1345] = {.lex_state = 0, .external_lex_state = 7},
  [1346] = {.lex_state = 13},
  [1347] = {.lex_state = 13},
  [1348] = {.lex_state = 34},
  [1349] = {.lex_state = 34},
  [1350] = {.lex_state = 17},
  [1351] = {.lex_state = 13},
  [1352] = {.lex_state = 0},
  [1353] = {.lex_state = 34},
  [1354] = {.lex_state = 14, .external_lex_state = 3},
  [1355] = {.lex_state = 14, .external_lex_state = 3},
  [1356] = {.lex_state = 0},
  [1357] = {.lex_state = 34},
  [1358] = {.lex_state = 37},
  [1359] = {.lex_state = 6},
  [1360] = {.lex_state = 13},
  [1361] = {.lex_state = 35},
  [1362] = {.lex_state = 13},
  [1363] = {.lex_state = 13},
  [1364] = {.lex_state = 14, .external_lex_state = 3},
  [1365] = {.lex_state = 14},
  [1366] = {.lex_state = 9},
  [1367] = {.lex_state = 15, .external_lex_state = 7},
  [1368] = {.lex_state = 35},
  [1369] = {.lex_state = 13},
  [1370] = {.lex_state = 13},
  [1371] = {.lex_state = 11},
  [1372] = {.lex_state = 16},
  [1373] = {.lex_state = 17},
  [1374] = {.lex_state = 13},
  [1375] = {.lex_state = 15, .external_lex_state = 7},
  [1376] = {.lex_state = 0},
  [1377] = {.lex_state = 14, .external_lex_state = 3},
  [1378] = {.lex_state = 13},
  [1379] = {.lex_state = 0, .external_lex_state = 7},
  [1380] = {.lex_state = 7},
  [1381] = {.lex_state = 16},
  [1382] = {.lex_state = 16},
  [1383] = {.lex_state = 14, .external_lex_state = 3},
  [1384] = {.lex_state = 11},
  [1385] = {.lex_state = 7},
  [1386] = {.lex_state = 0},
  [1387] = {.lex_state = 0},
  [1388] = {.lex_state = 37},
  [1389] = {.lex_state = 12},
  [1390] = {.lex_state = 0, .external_lex_state = 7},
  [1391] = {.lex_state = 14},
  [1392] = {.lex_state = 14},
  [1393] = {.lex_state = 14},
  [1394] = {.lex_state = 38},
  [1395] = {.lex_state = 14},
  [1396] = {.lex_state = 14},
  [1397] = {.lex_state = 15, .external_lex_state = 7},
  [1398] = {.lex_state = 14},
  [1399] = {.lex_state = 38},
  [1400] = {.lex_state = 14},
  [1401] = {.lex_state = 14},
  [1402] = {.lex_state = 40},
  [1403] = {.lex_state = 14},
  [1404] = {.lex_state = 12},
  [1405] = {.lex_state = 35},
  [1406] = {.lex_state = 14},
  [1407] = {.lex_state = 14},
  [1408] = {.lex_state = 0},
  [1409] = {.lex_state = 37},
  [1410] = {.lex_state = 12},
  [1411] = {.lex_state = 14},
  [1412] = {.lex_state = 14},
  [1413] = {.lex_state = 12},
  [1414] = {.lex_state = 0},
  [1415] = {.lex_state = 12},
  [1416] = {.lex_state = 10},
  [1417] = {.lex_state = 14},
  [1418] = {.lex_state = 30, .external_lex_state = 7},
  [1419] = {.lex_state = 14},
  [1420] = {.lex_state = 34},
  [1421] = {.lex_state = 38},
  [1422] = {.lex_state = 18},
  [1423] = {.lex_state = 14},
  [1424] = {.lex_state = 38},
  [1425] = {.lex_state = 40},
  [1426] = {.lex_state = 3},
  [1427] = {.lex_state = 12},
  [1428] = {.lex_state = 38},
  [1429] = {.lex_state = 14, .external_lex_state = 7},
  [1430] = {.lex_state = 38},
  [1431] = {.lex_state = 36},
  [1432] = {.lex_state = 26},
  [1433] = {.lex_state = 0, .external_lex_state = 7},
  [1434] = {.lex_state = 14},
  [1435] = {.lex_state = 26},
  [1436] = {.lex_state = 7},
  [1437] = {.lex_state = 38},
  [1438] = {.lex_state = 14},
  [1439] = {.lex_state = 14},
  [1440] = {.lex_state = 38},
  [1441] = {.lex_state = 38},
  [1442] = {.lex_state = 26},
  [1443] = {.lex_state = 10},
  [1444] = {.lex_state = 38},
  [1445] = {.lex_state = 9},
  [1446] = {.lex_state = 0},
  [1447] = {.lex_state = 14},
  [1448] = {.lex_state = 9},
  [1449] = {.lex_state = 26},
  [1450] = {.lex_state = 38},
  [1451] = {.lex_state = 33},
  [1452] = {.lex_state = 9},
  [1453] = {.lex_state = 14},
  [1454] = {.lex_state = 11},
  [1455] = {.lex_state = 38},
  [1456] = {.lex_state = 36},
  [1457] = {.lex_state = 17},
  [1458] = {.lex_state = 13},
  [1459] = {.lex_state = 30, .external_lex_state = 7},
  [1460] = {.lex_state = 21},
  [1461] = {.lex_state = 17},
  [1462] = {.lex_state = 17},
  [1463] = {.lex_state = 21},
  [1464] = {.lex_state = 18},
  [1465] = {.lex_state = 21},
  [1466] = {.lex_state = 21},
  [1467] = {.lex_state = 18},
  [1468] = {.lex_state = 18},
  [1469] = {.lex_state = 18},
  [1470] = {.lex_state = 29, .external_lex_state = 7},
  [1471] = {.lex_state = 37},
  [1472] = {.lex_state = 0},
  [1473] = {.lex_state = 0},
  [1474] = {.lex_state = 36},
  [1475] = {.lex_state = 36},
  [1476] = {.lex_state = 12},
  [1477] = {.lex_state = 12},
  [1478] = {.lex_state = 36},
  [1479] = {.lex_state = 21},
  [1480] = {.lex_state = 12},
  [1481] = {.lex_state = 12},
  [1482] = {.lex_state = 0},
  [1483] = {.lex_state = 0},
  [1484] = {.lex_state = 12},
  [1485] = {.lex_state = 29, .external_lex_state = 7},
  [1486] = {.lex_state = 26},
  [1487] = {.lex_state = 0, .external_lex_state = 7},
  [1488] = {.lex_state = 11},
  [1489] = {.lex_state = 29, .external_lex_state = 7},
  [1490] = {.lex_state = 11},
  [1491] = {.lex_state = 29, .external_lex_state = 7},
  [1492] = {.lex_state = 14, .external_lex_state = 7},
  [1493] = {.lex_state = 0},
  [1494] = {.lex_state = 0},
  [1495] = {.lex_state = 29, .external_lex_state = 7},
  [1496] = {.lex_state = 0},
  [1497] = {.lex_state = 27},
  [1498] = {.lex_state = 19},
  [1499] = {.lex_state = 27},
  [1500] = {.lex_state = 11},
  [1501] = {.lex_state = 0},
  [1502] = {.lex_state = 0, .external_lex_state = 7},
  [1503] = {.lex_state = 0},
  [1504] = {.lex_state = 19},
  [1505] = {.lex_state = 14, .external_lex_state = 7},
  [1506] = {.lex_state = 0},
  [1507] = {.lex_state = 27},
  [1508] = {.lex_state = 29, .external_lex_state = 7},
  [1509] = {.lex_state = 37},
  [1510] = {.lex_state = 29, .external_lex_state = 7},
  [1511] = {.lex_state = 0},
  [1512] = {.lex_state = 0},
  [1513] = {.lex_state = 12},
  [1514] = {.lex_state = 19},
  [1515] = {.lex_state = 0},
  [1516] = {.lex_state = 19},
  [1517] = {.lex_state = 12},
  [1518] = {.lex_state = 10},
  [1519] = {.lex_state = 0},
  [1520] = {.lex_state = 37},
  [1521] = {.lex_state = 15, .external_lex_state = 7},
  [1522] = {.lex_state = 10},
  [1523] = {.lex_state = 0},
  [1524] = {.lex_state = 40},
  [1525] = {.lex_state = 0},
  [1526] = {.lex_state = 0},
  [1527] = {.lex_state = 27},
  [1528] = {.lex_state = 15, .external_lex_state = 7},
  [1529] = {.lex_state = 40},
  [1530] = {.lex_state = 0},
  [1531] = {.lex_state = 40},
  [1532] = {.lex_state = 0, .external_lex_state = 7},
  [1533] = {.lex_state = 10},
  [1534] = {.lex_state = 0},
  [1535] = {.lex_state = 0},
  [1536] = {.lex_state = 15},
  [1537] = {.lex_state = 0},
  [1538] = {.lex_state = 0},
  [1539] = {.lex_state = 0},
  [1540] = {.lex_state = 0},
  [1541] = {.lex_state = 38},
  [1542] = {.lex_state = 0},
  [1543] = {.lex_state = 0},
  [1544] = {.lex_state = 0},
  [1545] = {.lex_state = 0, .external_lex_state = 7},
  [1546] = {.lex_state = 15},
  [1547] = {.lex_state = 38},
  [1548] = {.lex_state = 0},
  [1549] = {.lex_state = 30},
  [1550] = {.lex_state = 28},
  [1551] = {.lex_state = 30},
  [1552] = {.lex_state = 15},
  [1553] = {.lex_state = 38},
  [1554] = {.lex_state = 0},
  [1555] = {.lex_state = 0, .external_lex_state = 7},
  [1556] = {.lex_state = 0},
  [1557] = {.lex_state = 30},
  [1558] = {.lex_state = 0},
  [1559] = {.lex_state = 0},
  [1560] = {.lex_state = 28},
  [1561] = {.lex_state = 0},
  [1562] = {.lex_state = 0},
  [1563] = {.lex_state = 0},
  [1564] = {.lex_state = 27},
  [1565] = {.lex_state = 0, .external_lex_state = 7},
  [1566] = {.lex_state = 19},
  [1567] = {.lex_state = 0},
  [1568] = {.lex_state = 0},
  [1569] = {.lex_state = 0},
  [1570] = {.lex_state = 0, .external_lex_state = 7},
  [1571] = {.lex_state = 30},
  [1572] = {.lex_state = 26},
  [1573] = {.lex_state = 0, .external_lex_state = 7},
  [1574] = {.lex_state = 28},
  [1575] = {.lex_state = 28},
  [1576] = {.lex_state = 0},
  [1577] = {.lex_state = 0},
  [1578] = {.lex_state = 0},
  [1579] = {.lex_state = 26},
  [1580] = {.lex_state = 0},
  [1581] = {.lex_state = 0},
  [1582] = {.lex_state = 20},
  [1583] = {.lex_state = 0, .external_lex_state = 7},
  [1584] = {.lex_state = 21},
  [1585] = {.lex_state = 20},
  [1586] = {.lex_state = 14},
  [1587] = {.lex_state = 0},
  [1588] = {.lex_state = 0},
  [1589] = {.lex_state = 14},
  [1590] = {.lex_state = 0},
  [1591] = {.lex_state = 0},
  [1592] = {.lex_state = 20},
  [1593] = {.lex_state = 14},
  [1594] = {.lex_state = 0},
  [1595] = {.lex_state = 20},
  [1596] = {.lex_state = 21},
  [1597] = {.lex_state = 0},
  [1598] = {.lex_state = 14},
  [1599] = {.lex_state = 0},
  [1600] = {.lex_state = 15},
  [1601] = {.lex_state = 0, .external_lex_state = 7},
  [1602] = {.lex_state = 0, .external_lex_state = 7},
  [1603] = {.lex_state = 32, .external_lex_state = 7},
  [1604] = {.lex_state = 22},
  [1605] = {.lex_state = 19},
  [1606] = {.lex_state = 22},
  [1607] = {.lex_state = 0},
  [1608] = {.lex_state = 15},
  [1609] = {.lex_state = 0, .external_lex_state = 7},
  [1610] = {.lex_state = 30},
  [1611] = {.lex_state = 0},
  [1612] = {.lex_state = 0},
  [1613] = {.lex_state = 22},
  [1614] = {.lex_state = 32, .external_lex_state = 7},
  [1615] = {.lex_state = 22},
  [1616] = {.lex_state = 22},
  [1617] = {.lex_state = 0, .external_lex_state = 7},
  [1618] = {.lex_state = 0, .external_lex_state = 7},
  [1619] = {.lex_state = 0, .external_lex_state = 7},
  [1620] = {.lex_state = 22},
  [1621] = {.lex_state = 27},
  [1622] = {.lex_state = 0, .external_lex_state = 7},
  [1623] = {.lex_state = 14},
  [1624] = {.lex_state = 19},
  [1625] = {.lex_state = 0, .external_lex_state = 7},
  [1626] = {.lex_state = 27},
  [1627] = {.lex_state = 0, .external_lex_state = 7},
  [1628] = {.lex_state = 32, .external_lex_state = 7},
  [1629] = {.lex_state = 0, .external_lex_state = 7},
  [1630] = {.lex_state = 21},
  [1631] = {.lex_state = 0, .external_lex_state = 7},
  [1632] = {.lex_state = 28},
  [1633] = {.lex_state = 0, .external_lex_state = 7},
  [1634] = {.lex_state = 0, .external_lex_state = 7},
  [1635] = {.lex_state = 0, .external_lex_state = 7},
  [1636] = {.lex_state = 0, .external_lex_state = 7},
  [1637] = {.lex_state = 20},
  [1638] = {.lex_state = 21},
  [1639] = {.lex_state = 0, .external_lex_state = 7},
  [1640] = {.lex_state = 0, .external_lex_state = 7},
  [1641] = {.lex_state = 0, .external_lex_state = 7},
  [1642] = {.lex_state = 0, .external_lex_state = 7},
  [1643] = {.lex_state = 0, .external_lex_state = 7},
  [1644] = {.lex_state = 0, .external_lex_state = 7},
  [1645] = {.lex_state = 22},
  [1646] = {.lex_state = 14},
  [1647] = {.lex_state = 21},
  [1648] = {.lex_state = 0, .external_lex_state = 7},
  [1649] = {.lex_state = 0, .external_lex_state = 7},
  [1650] = {.lex_state = 21},
  [1651] = {.lex_state = 20},
  [1652] = {.lex_state = 0, .external_lex_state = 7},
  [1653] = {.lex_state = 21},
  [1654] = {.lex_state = 21},
  [1655] = {.lex_state = 21},
  [1656] = {.lex_state = 0, .external_lex_state = 7},
  [1657] = {.lex_state = 0},
  [1658] = {.lex_state = 21},
  [1659] = {.lex_state = 21},
  [1660] = {.lex_state = 21},
  [1661] = {.lex_state = 28},
  [1662] = {.lex_state = 21},
  [1663] = {.lex_state = 15},
  [1664] = {.lex_state = 32, .external_lex_state = 7},
  [1665] = {.lex_state = 0, .external_lex_state = 7},
  [1666] = {.lex_state = 22},
  [1667] = {.lex_state = 0, .external_lex_state = 7},
  [1668] = {.lex_state = 0, .external_lex_state = 7},
  [1669] = {.lex_state = 0, .external_lex_state = 7},
  [1670] = {.lex_state = 22},
  [1671] = {.lex_state = 0},
  [1672] = {.lex_state = 22},
  [1673] = {.lex_state = 32, .external_lex_state = 7},
  [1674] = {.lex_state = 21},
  [1675] = {.lex_state = 21},
  [1676] = {.lex_state = 22},
  [1677] = {.lex_state = 22},
  [1678] = {.lex_state = 30},
  [1679] = {.lex_state = 0},
  [1680] = {.lex_state = 22},
  [1681] = {.lex_state = 0},
  [1682] = {.lex_state = 0, .external_lex_state = 7},
  [1683] = {.lex_state = 0, .external_lex_state = 7},
  [1684] = {.lex_state = 0},
  [1685] = {.lex_state = 21},
  [1686] = {.lex_state = 0, .external_lex_state = 7},
  [1687] = {.lex_state = 0, .external_lex_state = 7},
  [1688] = {.lex_state = 22},
  [1689] = {.lex_state = 0, .external_lex_state = 7},
  [1690] = {.lex_state = 0},
  [1691] = {.lex_state = 0, .external_lex_state = 7},
  [1692] = {.lex_state = 0},
  [1693] = {.lex_state = 22},
  [1694] = {.lex_state = 14},
  [1695] = {.lex_state = 22},
  [1696] = {.lex_state = 28},
  [1697] = {.lex_state = 20},
  [1698] = {.lex_state = 30},
  [1699] = {.lex_state = 0, .external_lex_state = 7},
  [1700] = {.lex_state = 22},
  [1701] = {.lex_state = 22},
  [1702] = {.lex_state = 22},
  [1703] = {.lex_state = 21},
  [1704] = {.lex_state = 0, .external_lex_state = 7},
  [1705] = {.lex_state = 22},
  [1706] = {.lex_state = 22},
  [1707] = {.lex_state = 0, .external_lex_state = 7},
  [1708] = {.lex_state = 22},
  [1709] = {.lex_state = 0, .external_lex_state = 7},
  [1710] = {.lex_state = 0},
  [1711] = {.lex_state = 0, .external_lex_state = 7},
  [1712] = {.lex_state = 22},
  [1713] = {.lex_state = 22},
  [1714] = {.lex_state = 21},
  [1715] = {.lex_state = 22},
  [1716] = {.lex_state = 21},
  [1717] = {.lex_state = 32, .external_lex_state = 7},
  [1718] = {.lex_state = 0, .external_lex_state = 7},
  [1719] = {.lex_state = 21},
  [1720] = {.lex_state = 15},
  [1721] = {.lex_state = 0, .external_lex_state = 7},
  [1722] = {.lex_state = 29},
  [1723] = {.lex_state = 0, .external_lex_state = 7},
  [1724] = {.lex_state = 0},
  [1725] = {.lex_state = 0},
  [1726] = {.lex_state = 0, .external_lex_state = 7},
  [1727] = {.lex_state = 29},
  [1728] = {.lex_state = 0},
  [1729] = {.lex_state = 29},
  [1730] = {.lex_state = 0},
  [1731] = {.lex_state = 29},
  [1732] = {.lex_state = 29},
  [1733] = {.lex_state = 29},
  [1734] = {.lex_state = 29},
  [1735] = {.lex_state = 29},
  [1736] = {.lex_state = 0},
  [1737] = {.lex_state = 29},
  [1738] = {.lex_state = 0},
  [1739] = {.lex_state = 29},
  [1740] = {.lex_state = 29},
  [1741] = {.lex_state = 29},
  [1742] = {.lex_state = 0},
  [1743] = {.lex_state = 29},
  [1744] = {.lex_state = 0, .external_lex_state = 7},
  [1745] = {.lex_state = 0, .external_lex_state = 7},
  [1746] = {.lex_state = 29},
  [1747] = {.lex_state = 29},
  [1748] = {.lex_state = 29},
  [1749] = {.lex_state = 0, .external_lex_state = 7},
  [1750] = {.lex_state = 0},
  [1751] = {.lex_state = 0},
  [1752] = {.lex_state = 29},
  [1753] = {.lex_state = 29},
  [1754] = {.lex_state = 29},
  [1755] = {.lex_state = 29},
  [1756] = {.lex_state = 29},
  [1757] = {.lex_state = 0},
  [1758] = {.lex_state = 0},
  [1759] = {.lex_state = 0},
  [1760] = {.lex_state = 29},
  [1761] = {.lex_state = 29},
  [1762] = {.lex_state = 29},
  [1763] = {.lex_state = 29},
  [1764] = {.lex_state = 0},
  [1765] = {.lex_state = 0},
  [1766] = {.lex_state = 0, .external_lex_state = 7},
  [1767] = {.lex_state = 29},
  [1768] = {.lex_state = 0},
  [1769] = {.lex_state = 0},
  [1770] = {.lex_state = 0},
  [1771] = {.lex_state = 0},
  [1772] = {.lex_state = 0},
  [1773] = {.lex_state = 0, .external_lex_state = 7},
  [1774] = {.lex_state = 0},
  [1775] = {.lex_state = 0},
  [1776] = {.lex_state = 0},
  [1777] = {.lex_state = 0},
  [1778] = {.lex_state = 29},
  [1779] = {.lex_state = 0},
  [1780] = {.lex_state = 29},
  [1781] = {.lex_state = 29},
  [1782] = {.lex_state = 29},
  [1783] = {.lex_state = 0, .external_lex_state = 7},
  [1784] = {.lex_state = 29},
  [1785] = {.lex_state = 29},
  [1786] = {.lex_state = 0, .external_lex_state = 7},
  [1787] = {.lex_state = 29},
  [1788] = {.lex_state = 29},
  [1789] = {.lex_state = 29},
  [1790] = {.lex_state = 0},
  [1791] = {.lex_state = 0},
  [1792] = {.lex_state = 29},
  [1793] = {.lex_state = 29},
  [1794] = {.lex_state = 29},
  [1795] = {.lex_state = 29},
  [1796] = {.lex_state = 0, .external_lex_state = 7},
  [1797] = {.lex_state = 0, .external_lex_state = 7},
  [1798] = {.lex_state = 0, .external_lex_state = 7},
  [1799] = {.lex_state = 0, .external_lex_state = 7},
  [1800] = {.lex_state = 0, .external_lex_state = 7},
  [1801] = {.lex_state = 0},
  [1802] = {.lex_state = 0},
  [1803] = {.lex_state = 0, .external_lex_state = 7},
  [1804] = {.lex_state = 0, .external_lex_state = 7},
  [1805] = {.lex_state = 0},
  [1806] = {.lex_state = 0},
  [1807] = {.lex_state = 0, .external_lex_state = 7},
  [1808] = {.lex_state = 0},
  [1809] = {.lex_state = 0},
  [1810] = {.lex_state = 0, .external_lex_state = 7},
  [1811] = {.lex_state = 0, .external_lex_state = 7},
  [1812] = {.lex_state = 0},
  [1813] = {.lex_state = 0, .external_lex_state = 7},
  [1814] = {.lex_state = 0},
  [1815] = {.lex_state = 0, .external_lex_state = 7},
  [1816] = {.lex_state = 0, .external_lex_state = 7},
  [1817] = {.lex_state = 0, .external_lex_state = 7},
  [1818] = {.lex_state = 0, .external_lex_state = 7},
  [1819] = {.lex_state = 0, .external_lex_state = 7},
  [1820] = {.lex_state = 0},
  [1821] = {.lex_state = 0, .external_lex_state = 7},
  [1822] = {.lex_state = 0},
  [1823] = {.lex_state = 0, .external_lex_state = 7},
  [1824] = {.lex_state = 0, .external_lex_state = 7},
  [1825] = {.lex_state = 0, .external_lex_state = 7},
  [1826] = {.lex_state = 0, .external_lex_state = 7},
  [1827] = {.lex_state = 0},
  [1828] = {.lex_state = 0, .external_lex_state = 7},
  [1829] = {.lex_state = 0},
  [1830] = {.lex_state = 0},
  [1831] = {.lex_state = 0, .external_lex_state = 7},
  [1832] = {.lex_state = 0, .external_lex_state = 7},
  [1833] = {.lex_state = 0},
  [1834] = {.lex_state = 0, .external_lex_state = 7},
  [1835] = {.lex_state = 0, .external_lex_state = 7},
  [1836] = {.lex_state = 0, .external_lex_state = 7},
  [1837] = {.lex_state = 0},
  [1838] = {.lex_state = 0, .external_lex_state = 7},
  [1839] = {.lex_state = 0, .external_lex_state = 7},
  [1840] = {.lex_state = 0, .external_lex_state = 7},
  [1841] = {.lex_state = 0, .external_lex_state = 7},
  [1842] = {.lex_state = 0},
  [1843] = {.lex_state = 0, .external_lex_state = 7},
  [1844] = {.lex_state = 0},
  [1845] = {.lex_state = 0, .external_lex_state = 7},
  [1846] = {.lex_state = 0, .external_lex_state = 7},
  [1847] = {.lex_state = 0, .external_lex_state = 7},
  [1848] = {.lex_state = 0, .external_lex_state = 7},
  [1849] = {.lex_state = 0, .external_lex_state = 7},
  [1850] = {.lex_state = 0, .external_lex_state = 7},
  [1851] = {.lex_state = 0},
  [1852] = {.lex_state = 0},
  [1853] = {.lex_state = 0, .external_lex_state = 7},
  [1854] = {.lex_state = 0, .external_lex_state = 7},
  [1855] = {.lex_state = 0},
  [1856] = {.lex_state = 0},
  [1857] = {.lex_state = 0},
  [1858] = {.lex_state = 0, .external_lex_state = 7},
  [1859] = {.lex_state = 0, .external_lex_state = 7},
  [1860] = {.lex_state = 0, .external_lex_state = 7},
  [1861] = {.lex_state = 0, .external_lex_state = 7},
  [1862] = {.lex_state = 0, .external_lex_state = 7},
  [1863] = {.lex_state = 0, .external_lex_state = 7},
  [1864] = {.lex_state = 0, .external_lex_state = 7},
  [1865] = {.lex_state = 0},
  [1866] = {.lex_state = 0, .external_lex_state = 7},
  [1867] = {.lex_state = 0, .external_lex_state = 7},
  [1868] = {.lex_state = 0},
  [1869] = {.lex_state = 0},
  [1870] = {.lex_state = 0},
  [1871] = {.lex_state = 0, .external_lex_state = 7},
  [1872] = {.lex_state = 0, .external_lex_state = 7},
  [1873] = {.lex_state = 0, .external_lex_state = 7},
  [1874] = {.lex_state = 0, .external_lex_state = 7},
  [1875] = {.lex_state = 0, .external_lex_state = 7},
  [1876] = {.lex_state = 0, .external_lex_state = 7},
  [1877] = {.lex_state = 0, .external_lex_state = 7},
  [1878] = {.lex_state = 0},
  [1879] = {.lex_state = 0, .external_lex_state = 7},
  [1880] = {.lex_state = 0},
  [1881] = {.lex_state = 0, .external_lex_state = 7},
  [1882] = {.lex_state = 0, .external_lex_state = 7},
  [1883] = {.lex_state = 0},
  [1884] = {.lex_state = 0, .external_lex_state = 7},
  [1885] = {.lex_state = 0, .external_lex_state = 7},
  [1886] = {.lex_state = 0, .external_lex_state = 7},
  [1887] = {.lex_state = 0},
  [1888] = {.lex_state = 0, .external_lex_state = 7},
  [1889] = {.lex_state = 0, .external_lex_state = 7},
  [1890] = {.lex_state = 0, .external_lex_state = 7},
  [1891] = {.lex_state = 0, .external_lex_state = 7},
  [1892] = {.lex_state = 0, .external_lex_state = 7},
  [1893] = {.lex_state = 0, .external_lex_state = 7},
  [1894] = {.lex_state = 0, .external_lex_state = 7},
  [1895] = {.lex_state = 0},
  [1896] = {.lex_state = 0, .external_lex_state = 7},
  [1897] = {.lex_state = 0, .external_lex_state = 7},
  [1898] = {.lex_state = 0, .external_lex_state = 7},
  [1899] = {.lex_state = 0, .external_lex_state = 7},
  [1900] = {.lex_state = 0, .external_lex_state = 7},
  [1901] = {.lex_state = 0},
  [1902] = {.lex_state = 0, .external_lex_state = 7},
  [1903] = {.lex_state = 0, .external_lex_state = 7},
  [1904] = {.lex_state = 0, .external_lex_state = 7},
  [1905] = {.lex_state = 0, .external_lex_state = 7},
  [1906] = {.lex_state = 0},
  [1907] = {.lex_state = 0, .external_lex_state = 7},
  [1908] = {.lex_state = 0, .external_lex_state = 7},
  [1909] = {.lex_state = 0},
  [1910] = {.lex_state = 0, .external_lex_state = 7},
  [1911] = {.lex_state = 0},
  [1912] = {.lex_state = 0, .external_lex_state = 7},
  [1913] = {.lex_state = 0, .external_lex_state = 7},
  [1914] = {.lex_state = 0},
  [1915] = {.lex_state = 0, .external_lex_state = 7},
  [1916] = {.lex_state = 0, .external_lex_state = 7},
  [1917] = {.lex_state = 0, .external_lex_state = 7},
  [1918] = {.lex_state = 0, .external_lex_state = 9},
  [1919] = {.lex_state = 0, .external_lex_state = 9},
  [1920] = {.lex_state = 0},
  [1921] = {.lex_state = 0},
  [1922] = {.lex_state = 0},
  [1923] = {.lex_state = 0},
  [1924] = {.lex_state = 0, .external_lex_state = 9},
  [1925] = {.lex_state = 0, .external_lex_state = 10},
  [1926] = {.lex_state = 0},
  [1927] = {.lex_state = 0},
  [1928] = {.lex_state = 0},
  [1929] = {.lex_state = 0},
  [1930] = {.lex_state = 0},
  [1931] = {.lex_state = 0},
  [1932] = {.lex_state = 0},
  [1933] = {.lex_state = 0},
  [1934] = {.lex_state = 0},
  [1935] = {.lex_state = 0},
  [1936] = {.lex_state = 0},
  [1937] = {.lex_state = 0, .external_lex_state = 9},
  [1938] = {.lex_state = 0, .external_lex_state = 10},
  [1939] = {.lex_state = 0},
  [1940] = {.lex_state = 0, .external_lex_state = 10},
  [1941] = {.lex_state = 0},
  [1942] = {.lex_state = 0},
  [1943] = {.lex_state = 0, .external_lex_state = 9},
  [1944] = {.lex_state = 0},
  [1945] = {.lex_state = 0},
  [1946] = {.lex_state = 0},
  [1947] = {.lex_state = 0},
  [1948] = {.lex_state = 0},
  [1949] = {.lex_state = 0},
  [1950] = {.lex_state = 0},
  [1951] = {.lex_state = 0},
  [1952] = {.lex_state = 0},
  [1953] = {.lex_state = 0},
  [1954] = {.lex_state = 0},
  [1955] = {.lex_state = 0, .external_lex_state = 9},
  [1956] = {.lex_state = 0, .external_lex_state = 10},
  [1957] = {.lex_state = 0},
  [1958] = {.lex_state = 0},
  [1959] = {.lex_state = 0},
  [1960] = {.lex_state = 0},
  [1961] = {.lex_state = 0, .external_lex_state = 10},
  [1962] = {.lex_state = 0},
  [1963] = {.lex_state = 0},
  [1964] = {.lex_state = 0, .external_lex_state = 9},
  [1965] = {.lex_state = 0},
  [1966] = {.lex_state = 0},
  [1967] = {.lex_state = 0},
  [1968] = {.lex_state = 0, .external_lex_state = 9},
  [1969] = {.lex_state = 0, .external_lex_state = 10},
  [1970] = {.lex_state = 0},
  [1971] = {.lex_state = 0},
  [1972] = {.lex_state = 0},
  [1973] = {.lex_state = 0},
  [1974] = {.lex_state = 0, .external_lex_state = 10},
  [1975] = {.lex_state = 0, .external_lex_state = 9},
  [1976] = {.lex_state = 0},
  [1977] = {.lex_state = 0},
  [1978] = {.lex_state = 0},
  [1979] = {.lex_state = 0, .external_lex_state = 9},
  [1980] = {.lex_state = 0},
  [1981] = {.lex_state = 0},
  [1982] = {.lex_state = 0},
  [1983] = {.lex_state = 0},
  [1984] = {.lex_state = 0},
  [1985] = {.lex_state = 0},
  [1986] = {.lex_state = 0, .external_lex_state = 9},
  [1987] = {.lex_state = 0, .external_lex_state = 10},
  [1988] = {.lex_state = 0},
  [1989] = {.lex_state = 0},
  [1990] = {.lex_state = 0},
  [1991] = {.lex_state = 0},
  [1992] = {.lex_state = 0, .external_lex_state = 10},
  [1993] = {.lex_state = 0},
  [1994] = {.lex_state = 0},
  [1995] = {.lex_state = 0, .external_lex_state = 9},
  [1996] = {.lex_state = 0},
  [1997] = {.lex_state = 0},
  [1998] = {.lex_state = 0},
  [1999] = {.lex_state = 0, .external_lex_state = 9},
  [2000] = {.lex_state = 0, .external_lex_state = 10},
  [2001] = {.lex_state = 0},
  [2002] = {.lex_state = 0},
  [2003] = {.lex_state = 0},
  [2004] = {.lex_state = 0, .external_lex_state = 9},
  [2005] = {.lex_state = 0},
  [2006] = {.lex_state = 0},
  [2007] = {.lex_state = 0},
  [2008] = {.lex_state = 0},
  [2009] = {.lex_state = 0},
  [2010] = {.lex_state = 0},
  [2011] = {.lex_state = 0},
  [2012] = {.lex_state = 0},
  [2013] = {.lex_state = 0},
  [2014] = {.lex_state = 0},
  [2015] = {.lex_state = 0, .external_lex_state = 10},
  [2016] = {.lex_state = 0},
  [2017] = {.lex_state = 0, .external_lex_state = 9},
  [2018] = {.lex_state = 0, .external_lex_state = 10},
  [2019] = {.lex_state = 0},
  [2020] = {.lex_state = 0},
  [2021] = {.lex_state = 0, .external_lex_state = 10},
  [2022] = {.lex_state = 0},
  [2023] = {.lex_state = 0},
  [2024] = {.lex_state = 0},
  [2025] = {.lex_state = 0},
  [2026] = {.lex_state = 0},
  [2027] = {.lex_state = 0},
  [2028] = {.lex_state = 0},
  [2029] = {.lex_state = 0},
  [2030] = {.lex_state = 0, .external_lex_state = 9},
  [2031] = {.lex_state = 0, .external_lex_state = 10},
  [2032] = {.lex_state = 0},
  [2033] = {.lex_state = 0},
  [2034] = {.lex_state = 0},
  [2035] = {.lex_state = 0},
  [2036] = {.lex_state = 0},
  [2037] = {.lex_state = 0},
  [2038] = {.lex_state = 0},
  [2039] = {.lex_state = 0},
  [2040] = {.lex_state = 0},
  [2041] = {.lex_state = 0},
  [2042] = {.lex_state = 0, .external_lex_state = 9},
  [2043] = {.lex_state = 0},
  [2044] = {.lex_state = 0},
  [2045] = {.lex_state = 0, .external_lex_state = 10},
  [2046] = {.lex_state = 0},
  [2047] = {.lex_state = 0},
  [2048] = {.lex_state = 0, .external_lex_state = 10},
  [2049] = {.lex_state = 0},
  [2050] = {.lex_state = 0},
  [2051] = {.lex_state = 0},
  [2052] = {.lex_state = 0},
  [2053] = {.lex_state = 0},
  [2054] = {.lex_state = 0},
  [2055] = {.lex_state = 0},
  [2056] = {.lex_state = 0, .external_lex_state = 10},
  [2057] = {.lex_state = 0},
  [2058] = {.lex_state = 0},
  [2059] = {.lex_state = 0},
  [2060] = {.lex_state = 0, .external_lex_state = 9},
  [2061] = {.lex_state = 0, .external_lex_state = 10},
  [2062] = {.lex_state = 0},
  [2063] = {.lex_state = 0},
  [2064] = {.lex_state = 0},
  [2065] = {.lex_state = 0},
  [2066] = {.lex_state = 0},
  [2067] = {.lex_state = 0},
  [2068] = {.lex_state = 0},
  [2069] = {.lex_state = 0},
  [2070] = {.lex_state = 0},
  [2071] = {.lex_state = 0},
  [2072] = {.lex_state = 0},
  [2073] = {.lex_state = 0},
  [2074] = {.lex_state = 0},
  [2075] = {.lex_state = 0},
  [2076] = {.lex_state = 0, .external_lex_state = 9},
  [2077] = {.lex_state = 0, .external_lex_state = 10},
  [2078] = {.lex_state = 0},
  [2079] = {.lex_state = 0},
  [2080] = {.lex_state = 0},
  [2081] = {.lex_state = 0},
  [2082] = {.lex_state = 0},
  [2083] = {.lex_state = 0},
  [2084] = {.lex_state = 0},
  [2085] = {.lex_state = 0, .external_lex_state = 9},
  [2086] = {.lex_state = 0, .external_lex_state = 10},
  [2087] = {.lex_state = 0},
  [2088] = {.lex_state = 0},
  [2089] = {.lex_state = 0},
  [2090] = {.lex_state = 0},
  [2091] = {.lex_state = 0},
  [2092] = {.lex_state = 0},
  [2093] = {.lex_state = 0},
  [2094] = {.lex_state = 0},
  [2095] = {.lex_state = 0, .external_lex_state = 9},
  [2096] = {.lex_state = 0, .external_lex_state = 10},
  [2097] = {.lex_state = 0},
  [2098] = {.lex_state = 0},
  [2099] = {.lex_state = 0},
  [2100] = {.lex_state = 0},
  [2101] = {.lex_state = 0},
  [2102] = {.lex_state = 0},
  [2103] = {.lex_state = 0},
  [2104] = {.lex_state = 0, .external_lex_state = 9},
  [2105] = {.lex_state = 0, .external_lex_state = 10},
  [2106] = {.lex_state = 0},
  [2107] = {.lex_state = 0},
  [2108] = {.lex_state = 0},
  [2109] = {.lex_state = 0},
  [2110] = {.lex_state = 0},
  [2111] = {.lex_state = 0},
  [2112] = {.lex_state = 0},
  [2113] = {.lex_state = 0},
  [2114] = {.lex_state = 0, .external_lex_state = 9},
  [2115] = {.lex_state = 0, .external_lex_state = 10},
  [2116] = {.lex_state = 0},
  [2117] = {.lex_state = 0},
  [2118] = {.lex_state = 0},
  [2119] = {.lex_state = 0},
  [2120] = {.lex_state = 0},
  [2121] = {.lex_state = 0},
  [2122] = {.lex_state = 0},
  [2123] = {.lex_state = 0, .external_lex_state = 9},
  [2124] = {.lex_state = 0, .external_lex_state = 10},
  [2125] = {.lex_state = 0},
  [2126] = {.lex_state = 0},
  [2127] = {.lex_state = 0},
  [2128] = {.lex_state = 0},
  [2129] = {.lex_state = 0},
  [2130] = {.lex_state = 0},
  [2131] = {.lex_state = 0},
  [2132] = {.lex_state = 0},
  [2133] = {.lex_state = 0},
  [2134] = {.lex_state = 0},
  [2135] = {.lex_state = 0},
  [2136] = {.lex_state = 0},
  [2137] = {.lex_state = 0},
  [2138] = {.lex_state = 0},
  [2139] = {.lex_state = 0},
  [2140] = {.lex_state = 0},
  [2141] = {.lex_state = 0},
  [2142] = {.lex_state = 0},
  [2143] = {.lex_state = 0},
  [2144] = {.lex_state = 0},
  [2145] = {.lex_state = 0, .external_lex_state = 9},
  [2146] = {.lex_state = 0},
  [2147] = {.lex_state = 0, .external_lex_state = 10},
  [2148] = {.lex_state = 0},
  [2149] = {.lex_state = 0},
  [2150] = {.lex_state = 0},
  [2151] = {.lex_state = 0},
  [2152] = {.lex_state = 0},
  [2153] = {.lex_state = 0},
  [2154] = {.lex_state = 0},
  [2155] = {.lex_state = 0, .external_lex_state = 10},
  [2156] = {.lex_state = 0},
  [2157] = {.lex_state = 0, .external_lex_state = 9},
  [2158] = {.lex_state = 0},
  [2159] = {.lex_state = 0},
  [2160] = {.lex_state = 0},
  [2161] = {.lex_state = 0},
  [2162] = {.lex_state = 0, .external_lex_state = 10},
  [2163] = {.lex_state = 0},
  [2164] = {.lex_state = 0},
  [2165] = {.lex_state = 0},
  [2166] = {.lex_state = 0},
  [2167] = {.lex_state = 0, .external_lex_state = 9},
  [2168] = {.lex_state = 0},
  [2169] = {.lex_state = 0},
  [2170] = {.lex_state = 0},
  [2171] = {.lex_state = 0},
  [2172] = {.lex_state = 0},
  [2173] = {.lex_state = 0},
  [2174] = {.lex_state = 0},
  [2175] = {.lex_state = 0},
  [2176] = {.lex_state = 0},
  [2177] = {.lex_state = 0},
  [2178] = {.lex_state = 0},
  [2179] = {.lex_state = 0},
  [2180] = {.lex_state = 0},
  [2181] = {.lex_state = 0},
  [2182] = {.lex_state = 0},
  [2183] = {.lex_state = 0},
  [2184] = {.lex_state = 0},
  [2185] = {.lex_state = 0},
  [2186] = {.lex_state = 0},
  [2187] = {.lex_state = 0},
  [2188] = {.lex_state = 0},
  [2189] = {.lex_state = 0},
  [2190] = {.lex_state = 0},
  [2191] = {.lex_state = 0},
  [2192] = {.lex_state = 0},
  [2193] = {.lex_state = 0},
  [2194] = {.lex_state = 0},
  [2195] = {.lex_state = 0},
  [2196] = {.lex_state = 0},
  [2197] = {.lex_state = 0},
  [2198] = {.lex_state = 0},
  [2199] = {.lex_state = 0},
  [2200] = {.lex_state = 0, .external_lex_state = 10},
  [2201] = {.lex_state = 0, .external_lex_state = 10},
  [2202] = {.lex_state = 0, .external_lex_state = 9},
  [2203] = {.lex_state = 0},
  [2204] = {.lex_state = 0, .external_lex_state = 9},
  [2205] = {.lex_state = 0},
  [2206] = {.lex_state = 0},
  [2207] = {.lex_state = 0},
  [2208] = {.lex_state = 0},
  [2209] = {.lex_state = 0},
  [2210] = {.lex_state = 0, .external_lex_state = 10},
  [2211] = {.lex_state = 0},
  [2212] = {.lex_state = 0},
  [2213] = {.lex_state = 0},
  [2214] = {.lex_state = 0},
  [2215] = {.lex_state = 0},
  [2216] = {.lex_state = 0},
  [2217] = {.lex_state = 0},
  [2218] = {.lex_state = 0},
  [2219] = {.lex_state = 0},
  [2220] = {.lex_state = 0},
  [2221] = {.lex_state = 0},
  [2222] = {.lex_state = 0},
  [2223] = {.lex_state = 0},
  [2224] = {.lex_state = 0},
  [2225] = {.lex_state = 0},
  [2226] = {.lex_state = 0},
  [2227] = {.lex_state = 0},
  [2228] = {.lex_state = 0},
  [2229] = {.lex_state = 0},
  [2230] = {.lex_state = 0},
  [2231] = {.lex_state = 0},
  [2232] = {.lex_state = 0},
  [2233] = {.lex_state = 0},
  [2234] = {.lex_state = 0},
  [2235] = {.lex_state = 0},
  [2236] = {.lex_state = 0},
  [2237] = {.lex_state = 0},
  [2238] = {.lex_state = 0},
  [2239] = {.lex_state = 0, .external_lex_state = 9},
  [2240] = {.lex_state = 0},
  [2241] = {.lex_state = 0},
  [2242] = {.lex_state = 0},
  [2243] = {.lex_state = 0},
  [2244] = {.lex_state = 0},
  [2245] = {.lex_state = 0},
  [2246] = {.lex_state = 0, .external_lex_state = 10},
  [2247] = {.lex_state = 0},
  [2248] = {.lex_state = 0},
  [2249] = {.lex_state = 0},
  [2250] = {.lex_state = 0, .external_lex_state = 9},
  [2251] = {.lex_state = 0},
  [2252] = {.lex_state = 0},
  [2253] = {.lex_state = 0},
  [2254] = {.lex_state = 0},
  [2255] = {.lex_state = 0},
  [2256] = {.lex_state = 0},
  [2257] = {.lex_state = 0},
  [2258] = {.lex_state = 0},
  [2259] = {.lex_state = 0},
  [2260] = {.lex_state = 0},
  [2261] = {.lex_state = 0},
  [2262] = {.lex_state = 0},
  [2263] = {.lex_state = 0},
  [2264] = {.lex_state = 0},
  [2265] = {.lex_state = 0},
  [2266] = {.lex_state = 0},
  [2267] = {.lex_state = 0},
  [2268] = {.lex_state = 0},
  [2269] = {.lex_state = 0},
  [2270] = {.lex_state = 0},
  [2271] = {.lex_state = 0},
  [2272] = {.lex_state = 32},
  [2273] = {.lex_state = 0},
  [2274] = {.lex_state = 0},
  [2275] = {.lex_state = 0},
  [2276] = {.lex_state = 0},
  [2277] = {.lex_state = 0},
  [2278] = {.lex_state = 0},
  [2279] = {.lex_state = 0},
  [2280] = {.lex_state = 0},
  [2281] = {.lex_state = 0},
  [2282] = {.lex_state = 0},
  [2283] = {.lex_state = 0},
  [2284] = {.lex_state = 32},
  [2285] = {.lex_state = 0},
  [2286] = {.lex_state = 0},
  [2287] = {.lex_state = 0},
  [2288] = {.lex_state = 0},
  [2289] = {.lex_state = 0},
  [2290] = {.lex_state = 0},
  [2291] = {.lex_state = 0},
  [2292] = {.lex_state = 0},
  [2293] = {.lex_state = 32},
  [2294] = {.lex_state = 0},
  [2295] = {.lex_state = 0},
  [2296] = {.lex_state = 0},
  [2297] = {.lex_state = 0},
  [2298] = {.lex_state = 0},
  [2299] = {.lex_state = 0},
  [2300] = {.lex_state = 0},
  [2301] = {.lex_state = 0},
  [2302] = {.lex_state = 32},
  [2303] = {.lex_state = 0},
  [2304] = {.lex_state = 0},
  [2305] = {.lex_state = 0},
  [2306] = {.lex_state = 0},
  [2307] = {.lex_state = 0},
  [2308] = {.lex_state = 0},
  [2309] = {.lex_state = 0},
  [2310] = {.lex_state = 0},
  [2311] = {.lex_state = 32},
  [2312] = {.lex_state = 0},
  [2313] = {.lex_state = 0},
  [2314] = {.lex_state = 0},
  [2315] = {.lex_state = 0},
  [2316] = {.lex_state = 0},
  [2317] = {.lex_state = 0},
  [2318] = {.lex_state = 32},
  [2319] = {.lex_state = 0},
  [2320] = {.lex_state = 32},
  [2321] = {.lex_state = 0},
  [2322] = {.lex_state = 0},
  [2323] = {.lex_state = 32},
  [2324] = {.lex_state = 0},
  [2325] = {.lex_state = 0},
  [2326] = {.lex_state = 0},
  [2327] = {.lex_state = 0},
  [2328] = {.lex_state = 0},
  [2329] = {.lex_state = 32},
  [2330] = {.lex_state = 0},
  [2331] = {.lex_state = 0},
  [2332] = {.lex_state = 0},
  [2333] = {.lex_state = 0},
  [2334] = {.lex_state = 0},
  [2335] = {.lex_state = 0},
  [2336] = {.lex_state = 0},
  [2337] = {.lex_state = 0},
  [2338] = {.lex_state = 32},
  [2339] = {.lex_state = 0},
  [2340] = {.lex_state = 0},
  [2341] = {.lex_state = 0},
  [2342] = {.lex_state = 0},
  [2343] = {.lex_state = 0},
  [2344] = {.lex_state = 0},
  [2345] = {.lex_state = 0},
  [2346] = {.lex_state = 32},
  [2347] = {.lex_state = 0},
  [2348] = {.lex_state = 0},
  [2349] = {.lex_state = 0},
  [2350] = {.lex_state = 0},
  [2351] = {.lex_state = 0},
  [2352] = {.lex_state = 0},
  [2353] = {.lex_state = 32},
  [2354] = {.lex_state = 0},
  [2355] = {.lex_state = 0},
  [2356] = {.lex_state = 0},
  [2357] = {.lex_state = 0},
  [2358] = {.lex_state = 0},
  [2359] = {.lex_state = 0},
  [2360] = {.lex_state = 32},
  [2361] = {.lex_state = 0},
  [2362] = {.lex_state = 0},
  [2363] = {.lex_state = 0},
  [2364] = {.lex_state = 0},
  [2365] = {.lex_state = 0},
  [2366] = {.lex_state = 0},
  [2367] = {.lex_state = 32},
  [2368] = {.lex_state = 0},
  [2369] = {.lex_state = 0},
  [2370] = {.lex_state = 0},
  [2371] = {.lex_state = 0},
  [2372] = {.lex_state = 32},
  [2373] = {.lex_state = 0},
  [2374] = {.lex_state = 0},
  [2375] = {.lex_state = 0},
  [2376] = {.lex_state = 0},
  [2377] = {.lex_state = 32},
  [2378] = {.lex_state = 0},
  [2379] = {.lex_state = 0},
  [2380] = {.lex_state = 0},
  [2381] = {.lex_state = 0},
  [2382] = {.lex_state = 0},
  [2383] = {.lex_state = 0},
  [2384] = {.lex_state = 0},
  [2385] = {.lex_state = 0},
  [2386] = {.lex_state = 0},
  [2387] = {.lex_state = 0},
  [2388] = {.lex_state = 0},
  [2389] = {.lex_state = 0},
  [2390] = {.lex_state = 0},
  [2391] = {.lex_state = 0},
  [2392] = {.lex_state = 0},
  [2393] = {.lex_state = 0},
  [2394] = {.lex_state = 0},
  [2395] = {.lex_state = 0},
  [2396] = {.lex_state = 0},
  [2397] = {.lex_state = 0},
  [2398] = {.lex_state = 0},
  [2399] = {.lex_state = 0},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__simple_string = 1,
  ts_external_token__string_start = 2,
  ts_external_token__string_middle = 3,
  ts_external_token__string_end = 4,
  ts_external_token__multiline_string_start = 5,
  ts_external_token__multiline_string_middle = 6,
  ts_external_token__multiline_string_end = 7,
  ts_external_token_else = 8,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__simple_string] = sym__simple_string,
  [ts_external_token__string_start] = sym__string_start,
  [ts_external_token__string_middle] = sym__string_middle,
  [ts_external_token__string_end] = sym__string_end,
  [ts_external_token__multiline_string_start] = sym__multiline_string_start,
  [ts_external_token__multiline_string_middle] = sym__multiline_string_middle,
  [ts_external_token__multiline_string_end] = sym__multiline_string_end,
  [ts_external_token_else] = anon_sym_else,
};

static bool ts_external_scanner_states[11][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__simple_string] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__string_middle] = true,
    [ts_external_token__string_end] = true,
    [ts_external_token__multiline_string_start] = true,
    [ts_external_token__multiline_string_middle] = true,
    [ts_external_token__multiline_string_end] = true,
    [ts_external_token_else] = true,
  },
  [2] = {
    [ts_external_token__simple_string] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__multiline_string_start] = true,
  },
  [3] = {
    [ts_external_token_else] = true,
  },
  [4] = {
    [ts_external_token__simple_string] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__multiline_string_start] = true,
    [ts_external_token_else] = true,
  },
  [5] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token_else] = true,
  },
  [6] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__simple_string] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__multiline_string_start] = true,
    [ts_external_token_else] = true,
  },
  [7] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [8] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__simple_string] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__multiline_string_start] = true,
  },
  [9] = {
    [ts_external_token__string_middle] = true,
    [ts_external_token__string_end] = true,
  },
  [10] = {
    [ts_external_token__multiline_string_middle] = true,
    [ts_external_token__multiline_string_end] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_object] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_trait] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_LT_COLON] = ACTIONS(1),
    [anon_sym_GT_COLON] = ACTIONS(1),
    [anon_sym_LT_PERCENT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_val] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_final] = ACTIONS(1),
    [anon_sym_sealed] = ACTIONS(1),
    [anon_sym_implicit] = ACTIONS(1),
    [anon_sym_lazy] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [sym_wildcard] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__simple_string] = ACTIONS(1),
    [sym__string_start] = ACTIONS(1),
    [sym__string_middle] = ACTIONS(1),
    [sym__string_end] = ACTIONS(1),
    [sym__multiline_string_start] = ACTIONS(1),
    [sym__multiline_string_middle] = ACTIONS(1),
    [sym__multiline_string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_compilation_unit] = STATE(2349),
    [sym_package_clause] = STATE(26),
    [sym_package_object] = STATE(26),
    [sym_import_declaration] = STATE(26),
    [sym_object_definition] = STATE(26),
    [sym_class_definition] = STATE(26),
    [sym_trait_definition] = STATE(26),
    [sym_annotation] = STATE(667),
    [sym_val_definition] = STATE(26),
    [sym_val_declaration] = STATE(26),
    [sym_var_declaration] = STATE(26),
    [sym_var_definition] = STATE(26),
    [sym_type_definition] = STATE(26),
    [sym_function_definition] = STATE(26),
    [sym_function_declaration] = STATE(26),
    [sym_modifiers] = STATE(1671),
    [aux_sym_compilation_unit_repeat1] = STATE(26),
    [aux_sym_class_definition_repeat1] = STATE(667),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_package] = ACTIONS(7),
    [anon_sym_object] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_case] = ACTIONS(13),
    [anon_sym_class] = ACTIONS(15),
    [anon_sym_trait] = ACTIONS(17),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_def] = ACTIONS(27),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_sealed] = ACTIONS(29),
    [anon_sym_implicit] = ACTIONS(29),
    [anon_sym_lazy] = ACTIONS(29),
    [anon_sym_override] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2273),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_case_clause] = STATE(1844),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [aux_sym_case_block_repeat1] = STATE(1844),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(41),
    [anon_sym_case] = ACTIONS(43),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [3] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2351),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_case_clause] = STATE(1852),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [aux_sym_case_block_repeat1] = STATE(1852),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(77),
    [anon_sym_case] = ACTIONS(43),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [4] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2375),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_case_clause] = STATE(1809),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [aux_sym_case_block_repeat1] = STATE(1809),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(79),
    [anon_sym_case] = ACTIONS(43),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [5] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2327),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_case_clause] = STATE(1909),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [aux_sym_case_block_repeat1] = STATE(1909),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(43),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [6] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2343),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_case_clause] = STATE(1883),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [aux_sym_case_block_repeat1] = STATE(1883),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(83),
    [anon_sym_case] = ACTIONS(43),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [7] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2336),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_case_clause] = STATE(1906),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [aux_sym_case_block_repeat1] = STATE(1906),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(43),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [8] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2361),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_case_clause] = STATE(1829),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [aux_sym_case_block_repeat1] = STATE(1829),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(43),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [9] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2292),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_case_clause] = STATE(1878),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [aux_sym_case_block_repeat1] = STATE(1878),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(89),
    [anon_sym_case] = ACTIONS(43),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [10] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2388),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_case_clause] = STATE(1814),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [aux_sym_case_block_repeat1] = STATE(1814),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(91),
    [anon_sym_case] = ACTIONS(43),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [11] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2325),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_case_clause] = STATE(1851),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [aux_sym_case_block_repeat1] = STATE(1851),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(93),
    [anon_sym_case] = ACTIONS(43),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [12] = {
    [sym_package_clause] = STATE(1723),
    [sym_package_object] = STATE(1723),
    [sym_import_declaration] = STATE(1723),
    [sym_object_definition] = STATE(1723),
    [sym_class_definition] = STATE(1723),
    [sym_trait_definition] = STATE(1723),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1723),
    [sym_val_declaration] = STATE(1723),
    [sym_var_declaration] = STATE(1723),
    [sym_var_definition] = STATE(1723),
    [sym_type_definition] = STATE(1723),
    [sym_function_definition] = STATE(1723),
    [sym_function_declaration] = STATE(1723),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2219),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(865),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(95),
    [anon_sym_case] = ACTIONS(97),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [13] = {
    [sym_package_clause] = STATE(1723),
    [sym_package_object] = STATE(1723),
    [sym_import_declaration] = STATE(1723),
    [sym_object_definition] = STATE(1723),
    [sym_class_definition] = STATE(1723),
    [sym_trait_definition] = STATE(1723),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1723),
    [sym_val_declaration] = STATE(1723),
    [sym_var_declaration] = STATE(1723),
    [sym_var_definition] = STATE(1723),
    [sym_type_definition] = STATE(1723),
    [sym_function_definition] = STATE(1723),
    [sym_function_declaration] = STATE(1723),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2191),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(865),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(99),
    [anon_sym_case] = ACTIONS(101),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [14] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2276),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(103),
    [anon_sym_case] = ACTIONS(105),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [15] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2371),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(107),
    [anon_sym_case] = ACTIONS(105),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [16] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2298),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(109),
    [anon_sym_case] = ACTIONS(105),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [17] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2313),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(111),
    [anon_sym_case] = ACTIONS(105),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [18] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2316),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(113),
    [anon_sym_case] = ACTIONS(105),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [19] = {
    [sym_package_clause] = STATE(1894),
    [sym_package_object] = STATE(1894),
    [sym_import_declaration] = STATE(1894),
    [sym_object_definition] = STATE(1894),
    [sym_class_definition] = STATE(1894),
    [sym_trait_definition] = STATE(1894),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1894),
    [sym_val_declaration] = STATE(1894),
    [sym_var_declaration] = STATE(1894),
    [sym_var_definition] = STATE(1894),
    [sym_type_definition] = STATE(1894),
    [sym_function_definition] = STATE(1894),
    [sym_function_declaration] = STATE(1894),
    [sym_modifiers] = STATE(1692),
    [sym__block] = STATE(2291),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1048),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(115),
    [anon_sym_case] = ACTIONS(105),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [20] = {
    [sym_package_clause] = STATE(1886),
    [sym_package_object] = STATE(1886),
    [sym_import_declaration] = STATE(1886),
    [sym_object_definition] = STATE(1886),
    [sym_class_definition] = STATE(1886),
    [sym_trait_definition] = STATE(1886),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1886),
    [sym_val_declaration] = STATE(1886),
    [sym_var_declaration] = STATE(1886),
    [sym_var_definition] = STATE(1886),
    [sym_type_definition] = STATE(1886),
    [sym_function_definition] = STATE(1886),
    [sym_function_declaration] = STATE(1886),
    [sym_modifiers] = STATE(1692),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1058),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(117),
    [anon_sym_case] = ACTIONS(105),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [21] = {
    [sym_package_clause] = STATE(1886),
    [sym_package_object] = STATE(1886),
    [sym_import_declaration] = STATE(1886),
    [sym_object_definition] = STATE(1886),
    [sym_class_definition] = STATE(1886),
    [sym_trait_definition] = STATE(1886),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1886),
    [sym_val_declaration] = STATE(1886),
    [sym_var_declaration] = STATE(1886),
    [sym_var_definition] = STATE(1886),
    [sym_type_definition] = STATE(1886),
    [sym_function_definition] = STATE(1886),
    [sym_function_declaration] = STATE(1886),
    [sym_modifiers] = STATE(1692),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1058),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(119),
    [anon_sym_case] = ACTIONS(121),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [22] = {
    [sym_package_clause] = STATE(1886),
    [sym_package_object] = STATE(1886),
    [sym_import_declaration] = STATE(1886),
    [sym_object_definition] = STATE(1886),
    [sym_class_definition] = STATE(1886),
    [sym_trait_definition] = STATE(1886),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1886),
    [sym_val_declaration] = STATE(1886),
    [sym_var_declaration] = STATE(1886),
    [sym_var_definition] = STATE(1886),
    [sym_type_definition] = STATE(1886),
    [sym_function_definition] = STATE(1886),
    [sym_function_declaration] = STATE(1886),
    [sym_modifiers] = STATE(1692),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1058),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(117),
    [anon_sym_case] = ACTIONS(123),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [23] = {
    [sym_package_clause] = STATE(1886),
    [sym_package_object] = STATE(1886),
    [sym_import_declaration] = STATE(1886),
    [sym_object_definition] = STATE(1886),
    [sym_class_definition] = STATE(1886),
    [sym_trait_definition] = STATE(1886),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1886),
    [sym_val_declaration] = STATE(1886),
    [sym_var_declaration] = STATE(1886),
    [sym_var_definition] = STATE(1886),
    [sym_type_definition] = STATE(1886),
    [sym_function_definition] = STATE(1886),
    [sym_function_declaration] = STATE(1886),
    [sym_modifiers] = STATE(1692),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1058),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(119),
    [anon_sym_case] = ACTIONS(105),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
  [24] = {
    [sym_package_clause] = STATE(1886),
    [sym_package_object] = STATE(1886),
    [sym_import_declaration] = STATE(1886),
    [sym_object_definition] = STATE(1886),
    [sym_class_definition] = STATE(1886),
    [sym_trait_definition] = STATE(1886),
    [sym_annotation] = STATE(668),
    [sym_val_definition] = STATE(1886),
    [sym_val_declaration] = STATE(1886),
    [sym_var_declaration] = STATE(1886),
    [sym_var_definition] = STATE(1886),
    [sym_type_definition] = STATE(1886),
    [sym_function_definition] = STATE(1886),
    [sym_function_declaration] = STATE(1886),
    [sym_modifiers] = STATE(1692),
    [sym_block] = STATE(1063),
    [sym__expression] = STATE(1058),
    [sym_if_expression] = STATE(1063),
    [sym_match_expression] = STATE(1063),
    [sym_try_expression] = STATE(1063),
    [sym_case_block] = STATE(1063),
    [sym_assignment_expression] = STATE(1063),
    [sym_generic_function] = STATE(1063),
    [sym_call_expression] = STATE(1063),
    [sym_field_expression] = STATE(1063),
    [sym_instance_expression] = STATE(1063),
    [sym_infix_expression] = STATE(1063),
    [sym_prefix_expression] = STATE(1063),
    [sym_tuple_expression] = STATE(1063),
    [sym_parenthesized_expression] = STATE(1063),
    [sym_string_transform_expression] = STATE(1063),
    [sym_string] = STATE(1063),
    [aux_sym_class_definition_repeat1] = STATE(668),
    [aux_sym_modifiers_repeat1] = STATE(761),
    [sym_identifier] = ACTIONS(31),
    [anon_sym_package] = ACTIONS(33),
    [anon_sym_object] = ACTIONS(35),
    [anon_sym_import] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_case] = ACTIONS(105),
    [anon_sym_class] = ACTIONS(45),
    [anon_sym_trait] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_val] = ACTIONS(51),
    [anon_sym_var] = ACTIONS(53),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_def] = ACTIONS(57),
    [anon_sym_abstract] = ACTIONS(59),
    [anon_sym_final] = ACTIONS(59),
    [anon_sym_sealed] = ACTIONS(59),
    [anon_sym_implicit] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(59),
    [anon_sym_private] = ACTIONS(59),
    [anon_sym_protected] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_try] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(49),
    [sym_number] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym__simple_string] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
    [sym__multiline_string_start] = ACTIONS(75),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(125), 1,
      ts_builtin_sym_end,
    ACTIONS(127), 1,
      anon_sym_package,
    ACTIONS(130), 1,
      anon_sym_object,
    ACTIONS(133), 1,
      anon_sym_import,
    ACTIONS(136), 1,
      anon_sym_case,
    ACTIONS(139), 1,
      anon_sym_class,
    ACTIONS(142), 1,
      anon_sym_trait,
    ACTIONS(145), 1,
      anon_sym_AT,
    ACTIONS(148), 1,
      anon_sym_val,
    ACTIONS(151), 1,
      anon_sym_var,
    ACTIONS(154), 1,
      anon_sym_type,
    ACTIONS(157), 1,
      anon_sym_def,
    STATE(761), 1,
      aux_sym_modifiers_repeat1,
    STATE(1671), 1,
      sym_modifiers,
    STATE(667), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(160), 8,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
    STATE(25), 14,
      sym_package_clause,
      sym_package_object,
      sym_import_declaration,
      sym_object_definition,
      sym_class_definition,
      sym_trait_definition,
      sym_val_definition,
      sym_val_declaration,
      sym_var_declaration,
      sym_var_definition,
      sym_type_definition,
      sym_function_definition,
      sym_function_declaration,
      aux_sym_compilation_unit_repeat1,
  [76] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_package,
    ACTIONS(9), 1,
      anon_sym_object,
    ACTIONS(11), 1,
      anon_sym_import,
    ACTIONS(13), 1,
      anon_sym_case,
    ACTIONS(15), 1,
      anon_sym_class,
    ACTIONS(17), 1,
      anon_sym_trait,
    ACTIONS(19), 1,
      anon_sym_AT,
    ACTIONS(21), 1,
      anon_sym_val,
    ACTIONS(23), 1,
      anon_sym_var,
    ACTIONS(25), 1,
      anon_sym_type,
    ACTIONS(27), 1,
      anon_sym_def,
    ACTIONS(163), 1,
      ts_builtin_sym_end,
    STATE(761), 1,
      aux_sym_modifiers_repeat1,
    STATE(1671), 1,
      sym_modifiers,
    STATE(667), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(29), 8,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
    STATE(25), 14,
      sym_package_clause,
      sym_package_object,
      sym_import_declaration,
      sym_object_definition,
      sym_class_definition,
      sym_trait_definition,
      sym_val_definition,
      sym_val_declaration,
      sym_var_declaration,
      sym_var_definition,
      sym_type_definition,
      sym_function_definition,
      sym_function_declaration,
      aux_sym_compilation_unit_repeat1,
  [152] = 15,
    ACTIONS(165), 1,
      ts_builtin_sym_end,
    ACTIONS(171), 1,
      anon_sym_DOT,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_EQ,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_finally,
    ACTIONS(185), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    STATE(157), 1,
      sym_catch_clause,
    STATE(290), 1,
      sym_type_arguments,
    STATE(306), 1,
      sym_finally_clause,
    ACTIONS(167), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(169), 20,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
  [218] = 15,
    ACTIONS(165), 1,
      ts_builtin_sym_end,
    ACTIONS(171), 1,
      anon_sym_DOT,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_EQ,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(187), 1,
      anon_sym_finally,
    STATE(33), 1,
      sym_arguments,
    STATE(275), 1,
      sym_catch_clause,
    STATE(290), 1,
      sym_type_arguments,
    STATE(417), 1,
      sym_finally_clause,
    ACTIONS(167), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(169), 20,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
  [284] = 7,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(193), 1,
      sym__simple_string,
    ACTIONS(195), 1,
      sym__string_start,
    ACTIONS(197), 1,
      sym__multiline_string_start,
    STATE(308), 1,
      sym_string,
    ACTIONS(189), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(191), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [334] = 15,
    ACTIONS(165), 1,
      ts_builtin_sym_end,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(201), 1,
      anon_sym_DOT,
    ACTIONS(203), 1,
      anon_sym_LBRACK,
    ACTIONS(205), 1,
      anon_sym_EQ,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_match,
    ACTIONS(211), 1,
      anon_sym_catch,
    ACTIONS(213), 1,
      anon_sym_finally,
    STATE(52), 1,
      sym_arguments,
    STATE(311), 1,
      sym_catch_clause,
    STATE(341), 1,
      sym_type_arguments,
    STATE(389), 1,
      sym_finally_clause,
    ACTIONS(199), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(169), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [399] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(215), 1,
      ts_builtin_sym_end,
    ACTIONS(219), 1,
      anon_sym_LBRACK,
    ACTIONS(221), 1,
      anon_sym_LPAREN,
    ACTIONS(223), 1,
      anon_sym_POUND,
    STATE(309), 1,
      sym_type_arguments,
    STATE(289), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(217), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [450] = 7,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(225), 1,
      sym__simple_string,
    ACTIONS(227), 1,
      sym__string_start,
    ACTIONS(229), 1,
      sym__multiline_string_start,
    STATE(346), 1,
      sym_string,
    ACTIONS(189), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(191), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [499] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(235), 1,
      anon_sym_LBRACE,
    STATE(285), 2,
      sym_block,
      sym_case_block,
    ACTIONS(231), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(233), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [544] = 15,
    ACTIONS(165), 1,
      ts_builtin_sym_end,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(201), 1,
      anon_sym_DOT,
    ACTIONS(203), 1,
      anon_sym_LBRACK,
    ACTIONS(205), 1,
      anon_sym_EQ,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_match,
    ACTIONS(211), 1,
      anon_sym_catch,
    ACTIONS(237), 1,
      anon_sym_finally,
    STATE(52), 1,
      sym_arguments,
    STATE(341), 1,
      sym_type_arguments,
    STATE(370), 1,
      sym_catch_clause,
    STATE(443), 1,
      sym_finally_clause,
    ACTIONS(199), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(169), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [609] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(247), 1,
      anon_sym_RPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1182), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [673] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(263), 1,
      anon_sym_RPAREN,
    STATE(1165), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [737] = 8,
    ACTIONS(171), 1,
      anon_sym_DOT,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(265), 1,
      ts_builtin_sym_end,
    STATE(33), 1,
      sym_arguments,
    STATE(290), 1,
      sym_type_arguments,
    ACTIONS(267), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [787] = 10,
    ACTIONS(171), 1,
      anon_sym_DOT,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_EQ,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(269), 1,
      ts_builtin_sym_end,
    STATE(33), 1,
      sym_arguments,
    STATE(290), 1,
      sym_type_arguments,
    ACTIONS(167), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(271), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
  [841] = 8,
    ACTIONS(171), 1,
      anon_sym_DOT,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(273), 1,
      ts_builtin_sym_end,
    STATE(33), 1,
      sym_arguments,
    STATE(290), 1,
      sym_type_arguments,
    ACTIONS(275), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [891] = 8,
    ACTIONS(171), 1,
      anon_sym_DOT,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(277), 1,
      ts_builtin_sym_end,
    STATE(33), 1,
      sym_arguments,
    STATE(290), 1,
      sym_type_arguments,
    ACTIONS(279), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [941] = 11,
    ACTIONS(171), 1,
      anon_sym_DOT,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_EQ,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(281), 1,
      ts_builtin_sym_end,
    STATE(33), 1,
      sym_arguments,
    STATE(290), 1,
      sym_type_arguments,
    ACTIONS(167), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(283), 22,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_finally,
  [997] = 11,
    ACTIONS(171), 1,
      anon_sym_DOT,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_EQ,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(285), 1,
      ts_builtin_sym_end,
    STATE(33), 1,
      sym_arguments,
    STATE(290), 1,
      sym_type_arguments,
    ACTIONS(167), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(287), 22,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_finally,
  [1053] = 7,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(289), 1,
      sym__simple_string,
    ACTIONS(291), 1,
      sym__string_start,
    ACTIONS(293), 1,
      sym__multiline_string_start,
    STATE(432), 1,
      sym_string,
    ACTIONS(189), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(191), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [1101] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_POUND,
    STATE(315), 1,
      sym_type_arguments,
    ACTIONS(215), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    STATE(364), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(217), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [1151] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(301), 1,
      anon_sym_RPAREN,
    STATE(1129), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [1215] = 12,
    ACTIONS(171), 1,
      anon_sym_DOT,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_EQ,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(303), 1,
      ts_builtin_sym_end,
    ACTIONS(307), 1,
      anon_sym_else,
    STATE(33), 1,
      sym_arguments,
    STATE(290), 1,
      sym_type_arguments,
    ACTIONS(167), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(305), 21,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_catch,
      anon_sym_finally,
  [1273] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(309), 1,
      anon_sym_RPAREN,
    STATE(1158), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [1337] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(311), 1,
      anon_sym_RPAREN,
    STATE(1156), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [1401] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(313), 1,
      anon_sym_RPAREN,
    STATE(1161), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [1465] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(315), 1,
      anon_sym_RPAREN,
    STATE(1142), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [1529] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(317), 1,
      anon_sym_RPAREN,
    STATE(1118), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [1593] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    STATE(368), 2,
      sym_block,
      sym_case_block,
    ACTIONS(231), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(233), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [1637] = 12,
    ACTIONS(171), 1,
      anon_sym_DOT,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_EQ,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(303), 1,
      ts_builtin_sym_end,
    ACTIONS(321), 1,
      anon_sym_else,
    STATE(33), 1,
      sym_arguments,
    STATE(290), 1,
      sym_type_arguments,
    ACTIONS(167), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(305), 21,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_catch,
      anon_sym_finally,
  [1695] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(323), 1,
      anon_sym_RPAREN,
    STATE(1138), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [1759] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(325), 1,
      anon_sym_RPAREN,
    STATE(1160), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [1823] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(327), 1,
      anon_sym_RPAREN,
    STATE(1212), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [1887] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(329), 1,
      anon_sym_RPAREN,
    STATE(1193), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [1951] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(331), 1,
      anon_sym_RPAREN,
    STATE(1147), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [2015] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(333), 1,
      anon_sym_RPAREN,
    STATE(1159), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [2079] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(335), 1,
      anon_sym_RPAREN,
    STATE(1164), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [2143] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(337), 1,
      anon_sym_RPAREN,
    STATE(1167), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [2207] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(339), 1,
      anon_sym_RPAREN,
    STATE(1169), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [2271] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(341), 1,
      anon_sym_RPAREN,
    STATE(1175), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [2335] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(343), 1,
      anon_sym_RPAREN,
    STATE(1153), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [2399] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(345), 1,
      anon_sym_RPAREN,
    STATE(1179), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [2463] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(347), 1,
      anon_sym_RPAREN,
    STATE(1203), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [2527] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(349), 1,
      anon_sym_RPAREN,
    STATE(1197), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [2591] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(351), 1,
      anon_sym_RPAREN,
    STATE(1184), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [2655] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(353), 1,
      anon_sym_RPAREN,
    STATE(1188), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [2719] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(219), 1,
      anon_sym_LBRACK,
    ACTIONS(223), 1,
      anon_sym_POUND,
    ACTIONS(355), 1,
      ts_builtin_sym_end,
    ACTIONS(359), 1,
      anon_sym_AT,
    STATE(309), 1,
      sym_type_arguments,
    STATE(351), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(357), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [2769] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(361), 1,
      anon_sym_RPAREN,
    STATE(1196), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [2833] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(363), 1,
      anon_sym_RPAREN,
    STATE(1122), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [2897] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(365), 1,
      anon_sym_RPAREN,
    STATE(1127), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [2961] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    ACTIONS(367), 1,
      anon_sym_RPAREN,
    STATE(1205), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [3025] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1346), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [3086] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(314), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [3147] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(993), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [3208] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(994), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [3269] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_LBRACE,
    ACTIONS(397), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_if,
    ACTIONS(401), 1,
      anon_sym_try,
    ACTIONS(403), 1,
      anon_sym_new,
    ACTIONS(405), 1,
      sym_number,
    ACTIONS(407), 1,
      sym__simple_string,
    ACTIONS(409), 1,
      sym__string_start,
    ACTIONS(411), 1,
      sym__multiline_string_start,
    STATE(736), 1,
      sym__expression,
    ACTIONS(395), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(935), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [3330] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(998), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [3391] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1001), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [3452] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1194), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [3513] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1002), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [3574] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1004), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [3635] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1005), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [3696] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(413), 1,
      anon_sym_LBRACK,
    ACTIONS(415), 1,
      anon_sym_LPAREN,
    ACTIONS(417), 1,
      anon_sym_POUND,
    STATE(427), 1,
      sym_type_arguments,
    ACTIONS(215), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    STATE(424), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(217), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [3745] = 7,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(489), 1,
      sym_string,
    ACTIONS(189), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(191), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [3792] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(378), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [3853] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(387), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [3914] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_LBRACE,
    ACTIONS(425), 1,
      anon_sym_LPAREN,
    ACTIONS(427), 1,
      anon_sym_if,
    ACTIONS(429), 1,
      anon_sym_try,
    ACTIONS(431), 1,
      anon_sym_new,
    ACTIONS(433), 1,
      sym_number,
    ACTIONS(435), 1,
      sym__simple_string,
    ACTIONS(437), 1,
      sym__string_start,
    ACTIONS(439), 1,
      sym__multiline_string_start,
    STATE(1132), 1,
      sym__expression,
    ACTIONS(423), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1392), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [3975] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_LBRACE,
    ACTIONS(425), 1,
      anon_sym_LPAREN,
    ACTIONS(427), 1,
      anon_sym_if,
    ACTIONS(429), 1,
      anon_sym_try,
    ACTIONS(431), 1,
      anon_sym_new,
    ACTIONS(433), 1,
      sym_number,
    ACTIONS(435), 1,
      sym__simple_string,
    ACTIONS(437), 1,
      sym__string_start,
    ACTIONS(439), 1,
      sym__multiline_string_start,
    STATE(1130), 1,
      sym__expression,
    ACTIONS(423), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1392), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [4036] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(394), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [4097] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(375), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [4158] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(413), 1,
      anon_sym_LBRACK,
    ACTIONS(417), 1,
      anon_sym_POUND,
    ACTIONS(441), 1,
      anon_sym_AT,
    STATE(427), 1,
      sym_type_arguments,
    STATE(413), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(355), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(357), 22,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [4207] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(201), 1,
      anon_sym_DOT,
    ACTIONS(203), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(265), 1,
      ts_builtin_sym_end,
    STATE(52), 1,
      sym_arguments,
    STATE(341), 1,
      sym_type_arguments,
    ACTIONS(267), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [4256] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(201), 1,
      anon_sym_DOT,
    ACTIONS(203), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(277), 1,
      ts_builtin_sym_end,
    STATE(52), 1,
      sym_arguments,
    STATE(341), 1,
      sym_type_arguments,
    ACTIONS(279), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [4305] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(225), 1,
      sym__simple_string,
    ACTIONS(227), 1,
      sym__string_start,
    ACTIONS(229), 1,
      sym__multiline_string_start,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(447), 1,
      anon_sym_LPAREN,
    ACTIONS(449), 1,
      anon_sym_if,
    ACTIONS(451), 1,
      anon_sym_try,
    ACTIONS(453), 1,
      anon_sym_new,
    ACTIONS(455), 1,
      sym_number,
    STATE(104), 1,
      sym__expression,
    ACTIONS(445), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(353), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [4366] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(225), 1,
      sym__simple_string,
    ACTIONS(227), 1,
      sym__string_start,
    ACTIONS(229), 1,
      sym__multiline_string_start,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(447), 1,
      anon_sym_LPAREN,
    ACTIONS(449), 1,
      anon_sym_if,
    ACTIONS(451), 1,
      anon_sym_try,
    ACTIONS(453), 1,
      anon_sym_new,
    ACTIONS(455), 1,
      sym_number,
    STATE(111), 1,
      sym__expression,
    ACTIONS(445), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(353), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [4427] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(225), 1,
      sym__simple_string,
    ACTIONS(227), 1,
      sym__string_start,
    ACTIONS(229), 1,
      sym__multiline_string_start,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(447), 1,
      anon_sym_LPAREN,
    ACTIONS(449), 1,
      anon_sym_if,
    ACTIONS(451), 1,
      anon_sym_try,
    ACTIONS(453), 1,
      anon_sym_new,
    ACTIONS(455), 1,
      sym_number,
    STATE(121), 1,
      sym__expression,
    ACTIONS(445), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(353), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [4488] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1236), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [4549] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(321), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [4610] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1097), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [4671] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1344), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [4732] = 10,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(201), 1,
      anon_sym_DOT,
    ACTIONS(203), 1,
      anon_sym_LBRACK,
    ACTIONS(205), 1,
      anon_sym_EQ,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(269), 1,
      ts_builtin_sym_end,
    STATE(52), 1,
      sym_arguments,
    STATE(341), 1,
      sym_type_arguments,
    ACTIONS(199), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(271), 22,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
  [4785] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(366), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [4846] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(365), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [4907] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(361), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [4968] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(367), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [5029] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1208), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [5090] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACE,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_new,
    ACTIONS(471), 1,
      sym_number,
    ACTIONS(473), 1,
      sym__simple_string,
    ACTIONS(475), 1,
      sym__string_start,
    ACTIONS(477), 1,
      sym__multiline_string_start,
    STATE(991), 1,
      sym__expression,
    ACTIONS(461), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1377), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [5151] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(201), 1,
      anon_sym_DOT,
    ACTIONS(203), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      ts_builtin_sym_end,
    STATE(52), 1,
      sym_arguments,
    STATE(341), 1,
      sym_type_arguments,
    ACTIONS(275), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [5200] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACE,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_new,
    ACTIONS(471), 1,
      sym_number,
    ACTIONS(473), 1,
      sym__simple_string,
    ACTIONS(475), 1,
      sym__string_start,
    ACTIONS(477), 1,
      sym__multiline_string_start,
    STATE(775), 1,
      sym__expression,
    ACTIONS(461), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1377), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [5261] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(381), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [5322] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACE,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_new,
    ACTIONS(471), 1,
      sym_number,
    ACTIONS(473), 1,
      sym__simple_string,
    ACTIONS(475), 1,
      sym__string_start,
    ACTIONS(477), 1,
      sym__multiline_string_start,
    STATE(995), 1,
      sym__expression,
    ACTIONS(461), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1377), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [5383] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACE,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_new,
    ACTIONS(471), 1,
      sym_number,
    ACTIONS(473), 1,
      sym__simple_string,
    ACTIONS(475), 1,
      sym__string_start,
    ACTIONS(477), 1,
      sym__multiline_string_start,
    STATE(1109), 1,
      sym__expression,
    ACTIONS(461), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1377), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [5444] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_LBRACE,
    ACTIONS(425), 1,
      anon_sym_LPAREN,
    ACTIONS(427), 1,
      anon_sym_if,
    ACTIONS(429), 1,
      anon_sym_try,
    ACTIONS(431), 1,
      anon_sym_new,
    ACTIONS(433), 1,
      sym_number,
    ACTIONS(435), 1,
      sym__simple_string,
    ACTIONS(437), 1,
      sym__string_start,
    ACTIONS(439), 1,
      sym__multiline_string_start,
    STATE(1143), 1,
      sym__expression,
    ACTIONS(423), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1392), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [5505] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(398), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [5566] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_LBRACE,
    ACTIONS(425), 1,
      anon_sym_LPAREN,
    ACTIONS(427), 1,
      anon_sym_if,
    ACTIONS(429), 1,
      anon_sym_try,
    ACTIONS(431), 1,
      anon_sym_new,
    ACTIONS(433), 1,
      sym_number,
    ACTIONS(435), 1,
      sym__simple_string,
    ACTIONS(437), 1,
      sym__string_start,
    ACTIONS(439), 1,
      sym__multiline_string_start,
    STATE(860), 1,
      sym__expression,
    ACTIONS(423), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1392), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [5627] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1347), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [5688] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(225), 1,
      sym__simple_string,
    ACTIONS(227), 1,
      sym__string_start,
    ACTIONS(229), 1,
      sym__multiline_string_start,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(447), 1,
      anon_sym_LPAREN,
    ACTIONS(449), 1,
      anon_sym_if,
    ACTIONS(451), 1,
      anon_sym_try,
    ACTIONS(453), 1,
      anon_sym_new,
    ACTIONS(455), 1,
      sym_number,
    STATE(128), 1,
      sym__expression,
    ACTIONS(445), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(353), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [5749] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(201), 1,
      anon_sym_DOT,
    ACTIONS(203), 1,
      anon_sym_LBRACK,
    ACTIONS(205), 1,
      anon_sym_EQ,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_match,
    ACTIONS(281), 1,
      ts_builtin_sym_end,
    STATE(52), 1,
      sym_arguments,
    STATE(341), 1,
      sym_type_arguments,
    ACTIONS(199), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(283), 21,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_catch,
      anon_sym_finally,
  [5804] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_LBRACE,
    ACTIONS(425), 1,
      anon_sym_LPAREN,
    ACTIONS(427), 1,
      anon_sym_if,
    ACTIONS(429), 1,
      anon_sym_try,
    ACTIONS(431), 1,
      anon_sym_new,
    ACTIONS(433), 1,
      sym_number,
    ACTIONS(435), 1,
      sym__simple_string,
    ACTIONS(437), 1,
      sym__string_start,
    ACTIONS(439), 1,
      sym__multiline_string_start,
    STATE(1144), 1,
      sym__expression,
    ACTIONS(423), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1392), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [5865] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACE,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_new,
    ACTIONS(471), 1,
      sym_number,
    ACTIONS(473), 1,
      sym__simple_string,
    ACTIONS(475), 1,
      sym__string_start,
    ACTIONS(477), 1,
      sym__multiline_string_start,
    STATE(1098), 1,
      sym__expression,
    ACTIONS(461), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1377), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [5926] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      sym__simple_string,
    ACTIONS(195), 1,
      sym__string_start,
    ACTIONS(197), 1,
      sym__multiline_string_start,
    ACTIONS(235), 1,
      anon_sym_LBRACE,
    ACTIONS(479), 1,
      sym_identifier,
    ACTIONS(483), 1,
      anon_sym_LPAREN,
    ACTIONS(485), 1,
      anon_sym_if,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_new,
    ACTIONS(491), 1,
      sym_number,
    STATE(40), 1,
      sym__expression,
    ACTIONS(481), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(272), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [5987] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      sym__simple_string,
    ACTIONS(195), 1,
      sym__string_start,
    ACTIONS(197), 1,
      sym__multiline_string_start,
    ACTIONS(235), 1,
      anon_sym_LBRACE,
    ACTIONS(479), 1,
      sym_identifier,
    ACTIONS(483), 1,
      anon_sym_LPAREN,
    ACTIONS(485), 1,
      anon_sym_if,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_new,
    ACTIONS(491), 1,
      sym_number,
    STATE(27), 1,
      sym__expression,
    ACTIONS(481), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(272), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [6048] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      sym__simple_string,
    ACTIONS(195), 1,
      sym__string_start,
    ACTIONS(197), 1,
      sym__multiline_string_start,
    ACTIONS(235), 1,
      anon_sym_LBRACE,
    ACTIONS(479), 1,
      sym_identifier,
    ACTIONS(483), 1,
      anon_sym_LPAREN,
    ACTIONS(485), 1,
      anon_sym_if,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_new,
    ACTIONS(491), 1,
      sym_number,
    STATE(37), 1,
      sym__expression,
    ACTIONS(481), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(272), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [6109] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(390), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [6170] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(201), 1,
      anon_sym_DOT,
    ACTIONS(203), 1,
      anon_sym_LBRACK,
    ACTIONS(205), 1,
      anon_sym_EQ,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_match,
    ACTIONS(285), 1,
      ts_builtin_sym_end,
    STATE(52), 1,
      sym_arguments,
    STATE(341), 1,
      sym_type_arguments,
    ACTIONS(199), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(287), 21,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_catch,
      anon_sym_finally,
  [6225] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(388), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [6286] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(386), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [6347] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(384), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [6408] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(777), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [6469] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1135), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [6530] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      sym__simple_string,
    ACTIONS(195), 1,
      sym__string_start,
    ACTIONS(197), 1,
      sym__multiline_string_start,
    ACTIONS(235), 1,
      anon_sym_LBRACE,
    ACTIONS(479), 1,
      sym_identifier,
    ACTIONS(483), 1,
      anon_sym_LPAREN,
    ACTIONS(485), 1,
      anon_sym_if,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_new,
    ACTIONS(491), 1,
      sym_number,
    STATE(46), 1,
      sym__expression,
    ACTIONS(481), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(272), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [6591] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(703), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [6652] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(774), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [6713] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(383), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [6774] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 1,
      sym__simple_string,
    ACTIONS(291), 1,
      sym__string_start,
    ACTIONS(293), 1,
      sym__multiline_string_start,
    ACTIONS(493), 1,
      sym_identifier,
    ACTIONS(495), 1,
      anon_sym_LBRACE,
    ACTIONS(499), 1,
      anon_sym_LPAREN,
    ACTIONS(501), 1,
      anon_sym_if,
    ACTIONS(503), 1,
      anon_sym_try,
    ACTIONS(505), 1,
      anon_sym_new,
    ACTIONS(507), 1,
      sym_number,
    STATE(278), 1,
      sym__expression,
    ACTIONS(497), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(425), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [6835] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      sym__simple_string,
    ACTIONS(195), 1,
      sym__string_start,
    ACTIONS(197), 1,
      sym__multiline_string_start,
    ACTIONS(235), 1,
      anon_sym_LBRACE,
    ACTIONS(479), 1,
      sym_identifier,
    ACTIONS(483), 1,
      anon_sym_LPAREN,
    ACTIONS(485), 1,
      anon_sym_if,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_new,
    ACTIONS(491), 1,
      sym_number,
    STATE(28), 1,
      sym__expression,
    ACTIONS(481), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(272), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [6896] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 1,
      sym__simple_string,
    ACTIONS(291), 1,
      sym__string_start,
    ACTIONS(293), 1,
      sym__multiline_string_start,
    ACTIONS(493), 1,
      sym_identifier,
    ACTIONS(495), 1,
      anon_sym_LBRACE,
    ACTIONS(499), 1,
      anon_sym_LPAREN,
    ACTIONS(501), 1,
      anon_sym_if,
    ACTIONS(503), 1,
      anon_sym_try,
    ACTIONS(505), 1,
      anon_sym_new,
    ACTIONS(507), 1,
      sym_number,
    STATE(279), 1,
      sym__expression,
    ACTIONS(497), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(425), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [6957] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1104), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [7018] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(380), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [7079] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1069), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [7140] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(371), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [7201] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(513), 1,
      anon_sym_DOT,
    ACTIONS(509), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(511), 27,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [7242] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1107), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [7303] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1360), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [7364] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1362), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [7425] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1374), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [7486] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(989), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [7547] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      sym__simple_string,
    ACTIONS(195), 1,
      sym__string_start,
    ACTIONS(197), 1,
      sym__multiline_string_start,
    ACTIONS(235), 1,
      anon_sym_LBRACE,
    ACTIONS(479), 1,
      sym_identifier,
    ACTIONS(483), 1,
      anon_sym_LPAREN,
    ACTIONS(485), 1,
      anon_sym_if,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_new,
    ACTIONS(491), 1,
      sym_number,
    STATE(41), 1,
      sym__expression,
    ACTIONS(481), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(272), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [7608] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 1,
      sym__simple_string,
    ACTIONS(291), 1,
      sym__string_start,
    ACTIONS(293), 1,
      sym__multiline_string_start,
    ACTIONS(493), 1,
      sym_identifier,
    ACTIONS(495), 1,
      anon_sym_LBRACE,
    ACTIONS(499), 1,
      anon_sym_LPAREN,
    ACTIONS(501), 1,
      anon_sym_if,
    ACTIONS(503), 1,
      anon_sym_try,
    ACTIONS(505), 1,
      anon_sym_new,
    ACTIONS(507), 1,
      sym_number,
    STATE(298), 1,
      sym__expression,
    ACTIONS(497), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(425), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [7669] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(521), 1,
      anon_sym_LPAREN,
    ACTIONS(523), 1,
      anon_sym_if,
    ACTIONS(525), 1,
      anon_sym_try,
    ACTIONS(527), 1,
      anon_sym_new,
    ACTIONS(529), 1,
      sym_number,
    ACTIONS(531), 1,
      sym__simple_string,
    ACTIONS(533), 1,
      sym__string_start,
    ACTIONS(535), 1,
      sym__multiline_string_start,
    STATE(894), 1,
      sym__expression,
    ACTIONS(519), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1191), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [7730] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(521), 1,
      anon_sym_LPAREN,
    ACTIONS(523), 1,
      anon_sym_if,
    ACTIONS(525), 1,
      anon_sym_try,
    ACTIONS(527), 1,
      anon_sym_new,
    ACTIONS(529), 1,
      sym_number,
    ACTIONS(531), 1,
      sym__simple_string,
    ACTIONS(533), 1,
      sym__string_start,
    ACTIONS(535), 1,
      sym__multiline_string_start,
    STATE(724), 1,
      sym__expression,
    ACTIONS(519), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1191), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [7791] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(521), 1,
      anon_sym_LPAREN,
    ACTIONS(523), 1,
      anon_sym_if,
    ACTIONS(525), 1,
      anon_sym_try,
    ACTIONS(527), 1,
      anon_sym_new,
    ACTIONS(529), 1,
      sym_number,
    ACTIONS(531), 1,
      sym__simple_string,
    ACTIONS(533), 1,
      sym__string_start,
    ACTIONS(535), 1,
      sym__multiline_string_start,
    STATE(781), 1,
      sym__expression,
    ACTIONS(519), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1191), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [7852] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1092), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [7913] = 5,
    ACTIONS(183), 1,
      anon_sym_finally,
    ACTIONS(185), 1,
      sym_comment,
    STATE(282), 1,
      sym_finally_clause,
    ACTIONS(537), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(539), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      sym_identifier,
      sym_operator_identifier,
  [7956] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(521), 1,
      anon_sym_LPAREN,
    ACTIONS(523), 1,
      anon_sym_if,
    ACTIONS(525), 1,
      anon_sym_try,
    ACTIONS(527), 1,
      anon_sym_new,
    ACTIONS(529), 1,
      sym_number,
    ACTIONS(531), 1,
      sym__simple_string,
    ACTIONS(533), 1,
      sym__string_start,
    ACTIONS(535), 1,
      sym__multiline_string_start,
    STATE(959), 1,
      sym__expression,
    ACTIONS(519), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1191), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8017] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACE,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_new,
    ACTIONS(471), 1,
      sym_number,
    ACTIONS(473), 1,
      sym__simple_string,
    ACTIONS(475), 1,
      sym__string_start,
    ACTIONS(477), 1,
      sym__multiline_string_start,
    STATE(1042), 1,
      sym__expression,
    ACTIONS(461), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1377), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8078] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_LBRACE,
    ACTIONS(397), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_if,
    ACTIONS(401), 1,
      anon_sym_try,
    ACTIONS(403), 1,
      anon_sym_new,
    ACTIONS(405), 1,
      sym_number,
    ACTIONS(407), 1,
      sym__simple_string,
    ACTIONS(409), 1,
      sym__string_start,
    ACTIONS(411), 1,
      sym__multiline_string_start,
    STATE(717), 1,
      sym__expression,
    ACTIONS(395), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(935), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8139] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_LBRACE,
    ACTIONS(397), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_if,
    ACTIONS(401), 1,
      anon_sym_try,
    ACTIONS(403), 1,
      anon_sym_new,
    ACTIONS(405), 1,
      sym_number,
    ACTIONS(407), 1,
      sym__simple_string,
    ACTIONS(409), 1,
      sym__string_start,
    ACTIONS(411), 1,
      sym__multiline_string_start,
    STATE(674), 1,
      sym__expression,
    ACTIONS(395), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(935), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8200] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_LBRACE,
    ACTIONS(397), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_if,
    ACTIONS(401), 1,
      anon_sym_try,
    ACTIONS(403), 1,
      anon_sym_new,
    ACTIONS(405), 1,
      sym_number,
    ACTIONS(407), 1,
      sym__simple_string,
    ACTIONS(409), 1,
      sym__string_start,
    ACTIONS(411), 1,
      sym__multiline_string_start,
    STATE(715), 1,
      sym__expression,
    ACTIONS(395), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(935), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8261] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(541), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(543), 27,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [8302] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACE,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_new,
    ACTIONS(471), 1,
      sym_number,
    ACTIONS(473), 1,
      sym__simple_string,
    ACTIONS(475), 1,
      sym__string_start,
    ACTIONS(477), 1,
      sym__multiline_string_start,
    STATE(1045), 1,
      sym__expression,
    ACTIONS(461), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1377), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8363] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1113), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8424] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_LBRACE,
    ACTIONS(397), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_if,
    ACTIONS(401), 1,
      anon_sym_try,
    ACTIONS(403), 1,
      anon_sym_new,
    ACTIONS(405), 1,
      sym_number,
    ACTIONS(407), 1,
      sym__simple_string,
    ACTIONS(409), 1,
      sym__string_start,
    ACTIONS(411), 1,
      sym__multiline_string_start,
    STATE(748), 1,
      sym__expression,
    ACTIONS(395), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(935), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8485] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1020), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8546] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_LBRACE,
    ACTIONS(397), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_if,
    ACTIONS(401), 1,
      anon_sym_try,
    ACTIONS(403), 1,
      anon_sym_new,
    ACTIONS(405), 1,
      sym_number,
    ACTIONS(407), 1,
      sym__simple_string,
    ACTIONS(409), 1,
      sym__string_start,
    ACTIONS(411), 1,
      sym__multiline_string_start,
    STATE(746), 1,
      sym__expression,
    ACTIONS(395), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(935), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8607] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(765), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8668] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACE,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_new,
    ACTIONS(471), 1,
      sym_number,
    ACTIONS(473), 1,
      sym__simple_string,
    ACTIONS(475), 1,
      sym__string_start,
    ACTIONS(477), 1,
      sym__multiline_string_start,
    STATE(1052), 1,
      sym__expression,
    ACTIONS(461), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1377), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8729] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_LBRACE,
    ACTIONS(425), 1,
      anon_sym_LPAREN,
    ACTIONS(427), 1,
      anon_sym_if,
    ACTIONS(429), 1,
      anon_sym_try,
    ACTIONS(431), 1,
      anon_sym_new,
    ACTIONS(433), 1,
      sym_number,
    ACTIONS(435), 1,
      sym__simple_string,
    ACTIONS(437), 1,
      sym__string_start,
    ACTIONS(439), 1,
      sym__multiline_string_start,
    STATE(1401), 1,
      sym__expression,
    ACTIONS(423), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1392), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8790] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1099), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8851] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1157), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8912] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(992), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [8973] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1044), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9034] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(225), 1,
      sym__simple_string,
    ACTIONS(227), 1,
      sym__string_start,
    ACTIONS(229), 1,
      sym__multiline_string_start,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(447), 1,
      anon_sym_LPAREN,
    ACTIONS(449), 1,
      anon_sym_if,
    ACTIONS(451), 1,
      anon_sym_try,
    ACTIONS(453), 1,
      anon_sym_new,
    ACTIONS(455), 1,
      sym_number,
    STATE(96), 1,
      sym__expression,
    ACTIONS(445), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(353), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9095] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(225), 1,
      sym__simple_string,
    ACTIONS(227), 1,
      sym__string_start,
    ACTIONS(229), 1,
      sym__multiline_string_start,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(447), 1,
      anon_sym_LPAREN,
    ACTIONS(449), 1,
      anon_sym_if,
    ACTIONS(451), 1,
      anon_sym_try,
    ACTIONS(453), 1,
      anon_sym_new,
    ACTIONS(455), 1,
      sym_number,
    STATE(30), 1,
      sym__expression,
    ACTIONS(445), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(353), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9156] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(355), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9217] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(225), 1,
      sym__simple_string,
    ACTIONS(227), 1,
      sym__string_start,
    ACTIONS(229), 1,
      sym__multiline_string_start,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(447), 1,
      anon_sym_LPAREN,
    ACTIONS(449), 1,
      anon_sym_if,
    ACTIONS(451), 1,
      anon_sym_try,
    ACTIONS(453), 1,
      anon_sym_new,
    ACTIONS(455), 1,
      sym_number,
    STATE(95), 1,
      sym__expression,
    ACTIONS(445), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(353), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9278] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1021), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9339] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1211), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9400] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1017), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9461] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 1,
      sym__simple_string,
    ACTIONS(291), 1,
      sym__string_start,
    ACTIONS(293), 1,
      sym__multiline_string_start,
    ACTIONS(493), 1,
      sym_identifier,
    ACTIONS(495), 1,
      anon_sym_LBRACE,
    ACTIONS(499), 1,
      anon_sym_LPAREN,
    ACTIONS(501), 1,
      anon_sym_if,
    ACTIONS(503), 1,
      anon_sym_try,
    ACTIONS(505), 1,
      anon_sym_new,
    ACTIONS(507), 1,
      sym_number,
    STATE(312), 1,
      sym__expression,
    ACTIONS(497), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(425), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9522] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(360), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9583] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(350), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9644] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(225), 1,
      sym__simple_string,
    ACTIONS(227), 1,
      sym__string_start,
    ACTIONS(229), 1,
      sym__multiline_string_start,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(447), 1,
      anon_sym_LPAREN,
    ACTIONS(449), 1,
      anon_sym_if,
    ACTIONS(451), 1,
      anon_sym_try,
    ACTIONS(453), 1,
      anon_sym_new,
    ACTIONS(455), 1,
      sym_number,
    STATE(34), 1,
      sym__expression,
    ACTIONS(445), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(353), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9705] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_LBRACE,
    ACTIONS(397), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_if,
    ACTIONS(401), 1,
      anon_sym_try,
    ACTIONS(403), 1,
      anon_sym_new,
    ACTIONS(405), 1,
      sym_number,
    ACTIONS(407), 1,
      sym__simple_string,
    ACTIONS(409), 1,
      sym__string_start,
    ACTIONS(411), 1,
      sym__multiline_string_start,
    STATE(719), 1,
      sym__expression,
    ACTIONS(395), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(935), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9766] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(356), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9827] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_LBRACE,
    ACTIONS(397), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_if,
    ACTIONS(401), 1,
      anon_sym_try,
    ACTIONS(403), 1,
      anon_sym_new,
    ACTIONS(405), 1,
      sym_number,
    ACTIONS(407), 1,
      sym__simple_string,
    ACTIONS(409), 1,
      sym__string_start,
    ACTIONS(411), 1,
      sym__multiline_string_start,
    STATE(722), 1,
      sym__expression,
    ACTIONS(395), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(935), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9888] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(349), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [9949] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1025), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10010] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1028), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10071] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(333), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10132] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1139), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10193] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1054), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10254] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1093), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10315] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(332), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10376] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1166), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10437] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACE,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_new,
    ACTIONS(471), 1,
      sym_number,
    ACTIONS(473), 1,
      sym__simple_string,
    ACTIONS(475), 1,
      sym__string_start,
    ACTIONS(477), 1,
      sym__multiline_string_start,
    STATE(1057), 1,
      sym__expression,
    ACTIONS(461), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1377), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10498] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1190), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10559] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(327), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10620] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(324), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10681] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(521), 1,
      anon_sym_LPAREN,
    ACTIONS(523), 1,
      anon_sym_if,
    ACTIONS(525), 1,
      anon_sym_try,
    ACTIONS(527), 1,
      anon_sym_new,
    ACTIONS(529), 1,
      sym_number,
    ACTIONS(531), 1,
      sym__simple_string,
    ACTIONS(533), 1,
      sym__string_start,
    ACTIONS(535), 1,
      sym__multiline_string_start,
    STATE(845), 1,
      sym__expression,
    ACTIONS(519), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1191), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10742] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1378), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10803] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1029), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10864] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(768), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10925] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1030), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [10986] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1088), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [11047] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1091), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [11108] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1085), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [11169] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1111), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [11230] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_POUND,
    ACTIONS(547), 1,
      anon_sym_AT,
    STATE(315), 1,
      sym_type_arguments,
    ACTIONS(355), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    STATE(406), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(357), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [11279] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1094), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [11340] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(999), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [11401] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1066), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [11462] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1084), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [11523] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(372), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [11584] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1082), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [11645] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1078), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [11706] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1252), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [11767] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(521), 1,
      anon_sym_LPAREN,
    ACTIONS(523), 1,
      anon_sym_if,
    ACTIONS(525), 1,
      anon_sym_try,
    ACTIONS(527), 1,
      anon_sym_new,
    ACTIONS(529), 1,
      sym_number,
    ACTIONS(531), 1,
      sym__simple_string,
    ACTIONS(533), 1,
      sym__string_start,
    ACTIONS(535), 1,
      sym__multiline_string_start,
    STATE(878), 1,
      sym__expression,
    ACTIONS(519), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1191), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [11828] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(521), 1,
      anon_sym_LPAREN,
    ACTIONS(523), 1,
      anon_sym_if,
    ACTIONS(525), 1,
      anon_sym_try,
    ACTIONS(527), 1,
      anon_sym_new,
    ACTIONS(529), 1,
      sym_number,
    ACTIONS(531), 1,
      sym__simple_string,
    ACTIONS(533), 1,
      sym__string_start,
    ACTIONS(535), 1,
      sym__multiline_string_start,
    STATE(875), 1,
      sym__expression,
    ACTIONS(519), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1191), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [11889] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1075), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [11950] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1370), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [12011] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(521), 1,
      anon_sym_LPAREN,
    ACTIONS(523), 1,
      anon_sym_if,
    ACTIONS(525), 1,
      anon_sym_try,
    ACTIONS(527), 1,
      anon_sym_new,
    ACTIONS(529), 1,
      sym_number,
    ACTIONS(531), 1,
      sym__simple_string,
    ACTIONS(533), 1,
      sym__string_start,
    ACTIONS(535), 1,
      sym__multiline_string_start,
    STATE(871), 1,
      sym__expression,
    ACTIONS(519), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1191), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [12072] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1278), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [12133] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      sym__simple_string,
    ACTIONS(195), 1,
      sym__string_start,
    ACTIONS(197), 1,
      sym__multiline_string_start,
    ACTIONS(235), 1,
      anon_sym_LBRACE,
    ACTIONS(479), 1,
      sym_identifier,
    ACTIONS(483), 1,
      anon_sym_LPAREN,
    ACTIONS(485), 1,
      anon_sym_if,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_new,
    ACTIONS(491), 1,
      sym_number,
    STATE(42), 1,
      sym__expression,
    ACTIONS(481), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(272), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [12194] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(521), 1,
      anon_sym_LPAREN,
    ACTIONS(523), 1,
      anon_sym_if,
    ACTIONS(525), 1,
      anon_sym_try,
    ACTIONS(527), 1,
      anon_sym_new,
    ACTIONS(529), 1,
      sym_number,
    ACTIONS(531), 1,
      sym__simple_string,
    ACTIONS(533), 1,
      sym__string_start,
    ACTIONS(535), 1,
      sym__multiline_string_start,
    STATE(870), 1,
      sym__expression,
    ACTIONS(519), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1191), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [12255] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1199), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [12316] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(549), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(551), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [12355] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(553), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(555), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [12394] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(557), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(559), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [12433] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(374), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [12494] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(373), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [12555] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1068), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [12616] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1116), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [12677] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(752), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [12738] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(376), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [12799] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      sym__simple_string,
    ACTIONS(195), 1,
      sym__string_start,
    ACTIONS(197), 1,
      sym__multiline_string_start,
    ACTIONS(235), 1,
      anon_sym_LBRACE,
    ACTIONS(479), 1,
      sym_identifier,
    ACTIONS(483), 1,
      anon_sym_LPAREN,
    ACTIONS(485), 1,
      anon_sym_if,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_new,
    ACTIONS(491), 1,
      sym_number,
    STATE(38), 1,
      sym__expression,
    ACTIONS(481), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(272), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [12860] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(751), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [12921] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 1,
      sym__simple_string,
    ACTIONS(291), 1,
      sym__string_start,
    ACTIONS(293), 1,
      sym__multiline_string_start,
    ACTIONS(493), 1,
      sym_identifier,
    ACTIONS(495), 1,
      anon_sym_LBRACE,
    ACTIONS(499), 1,
      anon_sym_LPAREN,
    ACTIONS(501), 1,
      anon_sym_if,
    ACTIONS(503), 1,
      anon_sym_try,
    ACTIONS(505), 1,
      anon_sym_new,
    ACTIONS(507), 1,
      sym_number,
    STATE(274), 1,
      sym__expression,
    ACTIONS(497), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(425), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [12982] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 1,
      sym__simple_string,
    ACTIONS(291), 1,
      sym__string_start,
    ACTIONS(293), 1,
      sym__multiline_string_start,
    ACTIONS(493), 1,
      sym_identifier,
    ACTIONS(495), 1,
      anon_sym_LBRACE,
    ACTIONS(499), 1,
      anon_sym_LPAREN,
    ACTIONS(501), 1,
      anon_sym_if,
    ACTIONS(503), 1,
      anon_sym_try,
    ACTIONS(505), 1,
      anon_sym_new,
    ACTIONS(507), 1,
      sym_number,
    STATE(273), 1,
      sym__expression,
    ACTIONS(497), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(425), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [13043] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(382), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [13104] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1072), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [13165] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(495), 1,
      anon_sym_LBRACE,
    STATE(408), 2,
      sym_block,
      sym_case_block,
    ACTIONS(231), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(233), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [13208] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1071), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [13269] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(385), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [13330] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(778), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [13391] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 1,
      sym__simple_string,
    ACTIONS(291), 1,
      sym__string_start,
    ACTIONS(293), 1,
      sym__multiline_string_start,
    ACTIONS(493), 1,
      sym_identifier,
    ACTIONS(495), 1,
      anon_sym_LBRACE,
    ACTIONS(499), 1,
      anon_sym_LPAREN,
    ACTIONS(501), 1,
      anon_sym_if,
    ACTIONS(503), 1,
      anon_sym_try,
    ACTIONS(505), 1,
      anon_sym_new,
    ACTIONS(507), 1,
      sym_number,
    STATE(270), 1,
      sym__expression,
    ACTIONS(497), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(425), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [13452] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      sym__simple_string,
    ACTIONS(195), 1,
      sym__string_start,
    ACTIONS(197), 1,
      sym__multiline_string_start,
    ACTIONS(235), 1,
      anon_sym_LBRACE,
    ACTIONS(479), 1,
      sym_identifier,
    ACTIONS(483), 1,
      anon_sym_LPAREN,
    ACTIONS(485), 1,
      anon_sym_if,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_new,
    ACTIONS(491), 1,
      sym_number,
    STATE(39), 1,
      sym__expression,
    ACTIONS(481), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(272), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [13513] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_try,
    ACTIONS(67), 1,
      anon_sym_new,
    ACTIONS(69), 1,
      sym_number,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    STATE(1067), 1,
      sym__expression,
    ACTIONS(49), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1063), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [13574] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(318), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [13635] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(391), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [13696] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_LBRACE,
    ACTIONS(425), 1,
      anon_sym_LPAREN,
    ACTIONS(427), 1,
      anon_sym_if,
    ACTIONS(429), 1,
      anon_sym_try,
    ACTIONS(431), 1,
      anon_sym_new,
    ACTIONS(433), 1,
      sym_number,
    ACTIONS(435), 1,
      sym__simple_string,
    ACTIONS(437), 1,
      sym__string_start,
    ACTIONS(439), 1,
      sym__multiline_string_start,
    STATE(1137), 1,
      sym__expression,
    ACTIONS(423), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1392), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [13757] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_LBRACE,
    ACTIONS(425), 1,
      anon_sym_LPAREN,
    ACTIONS(427), 1,
      anon_sym_if,
    ACTIONS(429), 1,
      anon_sym_try,
    ACTIONS(431), 1,
      anon_sym_new,
    ACTIONS(433), 1,
      sym_number,
    ACTIONS(435), 1,
      sym__simple_string,
    ACTIONS(437), 1,
      sym__string_start,
    ACTIONS(439), 1,
      sym__multiline_string_start,
    STATE(1136), 1,
      sym__expression,
    ACTIONS(423), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1392), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [13818] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(319), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [13879] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 1,
      sym__simple_string,
    ACTIONS(291), 1,
      sym__string_start,
    ACTIONS(293), 1,
      sym__multiline_string_start,
    ACTIONS(493), 1,
      sym_identifier,
    ACTIONS(495), 1,
      anon_sym_LBRACE,
    ACTIONS(499), 1,
      anon_sym_LPAREN,
    ACTIONS(501), 1,
      anon_sym_if,
    ACTIONS(503), 1,
      anon_sym_try,
    ACTIONS(505), 1,
      anon_sym_new,
    ACTIONS(507), 1,
      sym_number,
    STATE(269), 1,
      sym__expression,
    ACTIONS(497), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(425), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [13940] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_LBRACE,
    ACTIONS(397), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_if,
    ACTIONS(401), 1,
      anon_sym_try,
    ACTIONS(403), 1,
      anon_sym_new,
    ACTIONS(405), 1,
      sym_number,
    ACTIONS(407), 1,
      sym__simple_string,
    ACTIONS(409), 1,
      sym__string_start,
    ACTIONS(411), 1,
      sym__multiline_string_start,
    STATE(728), 1,
      sym__expression,
    ACTIONS(395), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(935), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [14001] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(320), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [14062] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(331), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [14123] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(345), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [14184] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1458), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [14245] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      sym__simple_string,
    ACTIONS(195), 1,
      sym__string_start,
    ACTIONS(197), 1,
      sym__multiline_string_start,
    ACTIONS(235), 1,
      anon_sym_LBRACE,
    ACTIONS(479), 1,
      sym_identifier,
    ACTIONS(483), 1,
      anon_sym_LPAREN,
    ACTIONS(485), 1,
      anon_sym_if,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_new,
    ACTIONS(491), 1,
      sym_number,
    STATE(53), 1,
      sym__expression,
    ACTIONS(481), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(272), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [14306] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(363), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [14367] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_if,
    ACTIONS(251), 1,
      anon_sym_try,
    ACTIONS(253), 1,
      anon_sym_new,
    ACTIONS(255), 1,
      sym_number,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1055), 1,
      sym__expression,
    ACTIONS(243), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(1284), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [14428] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_LPAREN,
    ACTIONS(377), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_try,
    ACTIONS(381), 1,
      anon_sym_new,
    ACTIONS(383), 1,
      sym_number,
    ACTIONS(385), 1,
      sym__simple_string,
    ACTIONS(387), 1,
      sym__string_start,
    ACTIONS(389), 1,
      sym__multiline_string_start,
    STATE(377), 1,
      sym__expression,
    ACTIONS(373), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(477), 16,
      sym_block,
      sym_if_expression,
      sym_match_expression,
      sym_try_expression,
      sym_case_block,
      sym_assignment_expression,
      sym_generic_function,
      sym_call_expression,
      sym_field_expression,
      sym_instance_expression,
      sym_infix_expression,
      sym_prefix_expression,
      sym_tuple_expression,
      sym_parenthesized_expression,
      sym_string_transform_expression,
      sym_string,
  [14489] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(561), 30,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_RBRACK,
      anon_sym_GT_COLON,
      anon_sym_LT_PERCENT,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_STAR,
  [14525] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(541), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(543), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [14565] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(285), 1,
      ts_builtin_sym_end,
    ACTIONS(565), 1,
      anon_sym_DOT,
    ACTIONS(567), 1,
      anon_sym_LBRACK,
    ACTIONS(569), 1,
      anon_sym_EQ,
    ACTIONS(571), 1,
      anon_sym_LPAREN,
    ACTIONS(573), 1,
      anon_sym_match,
    STATE(245), 1,
      sym_arguments,
    STATE(429), 1,
      sym_type_arguments,
    ACTIONS(563), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(287), 20,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
  [14619] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(281), 1,
      ts_builtin_sym_end,
    ACTIONS(565), 1,
      anon_sym_DOT,
    ACTIONS(567), 1,
      anon_sym_LBRACK,
    ACTIONS(569), 1,
      anon_sym_EQ,
    ACTIONS(571), 1,
      anon_sym_LPAREN,
    ACTIONS(573), 1,
      anon_sym_match,
    STATE(245), 1,
      sym_arguments,
    STATE(429), 1,
      sym_type_arguments,
    ACTIONS(563), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(283), 20,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
  [14673] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(575), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(577), 27,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [14711] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(189), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(191), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [14749] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(273), 1,
      ts_builtin_sym_end,
    ACTIONS(565), 1,
      anon_sym_DOT,
    ACTIONS(567), 1,
      anon_sym_LBRACK,
    ACTIONS(571), 1,
      anon_sym_LPAREN,
    STATE(245), 1,
      sym_arguments,
    STATE(429), 1,
      sym_type_arguments,
    ACTIONS(275), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [14797] = 10,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(269), 1,
      ts_builtin_sym_end,
    ACTIONS(565), 1,
      anon_sym_DOT,
    ACTIONS(567), 1,
      anon_sym_LBRACK,
    ACTIONS(569), 1,
      anon_sym_EQ,
    ACTIONS(571), 1,
      anon_sym_LPAREN,
    STATE(245), 1,
      sym_arguments,
    STATE(429), 1,
      sym_type_arguments,
    ACTIONS(563), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(271), 21,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
  [14849] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(187), 1,
      anon_sym_finally,
    STATE(403), 1,
      sym_finally_clause,
    ACTIONS(537), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(539), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [14891] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(579), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(581), 27,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [14929] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(583), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(585), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [14967] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(277), 1,
      ts_builtin_sym_end,
    ACTIONS(565), 1,
      anon_sym_DOT,
    ACTIONS(567), 1,
      anon_sym_LBRACK,
    ACTIONS(571), 1,
      anon_sym_LPAREN,
    STATE(245), 1,
      sym_arguments,
    STATE(429), 1,
      sym_type_arguments,
    ACTIONS(279), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [15015] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(265), 1,
      ts_builtin_sym_end,
    ACTIONS(565), 1,
      anon_sym_DOT,
    ACTIONS(567), 1,
      anon_sym_LBRACK,
    ACTIONS(571), 1,
      anon_sym_LPAREN,
    STATE(245), 1,
      sym_arguments,
    STATE(429), 1,
      sym_type_arguments,
    ACTIONS(267), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [15063] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(587), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(589), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15101] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(591), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(593), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15139] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(595), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(597), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15177] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(599), 1,
      anon_sym_DOT,
    ACTIONS(509), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(511), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [15217] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(601), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(603), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15255] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(605), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(607), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15293] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(609), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(611), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15331] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(613), 30,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_RBRACK,
      anon_sym_LT_COLON,
      anon_sym_GT_COLON,
      anon_sym_LT_PERCENT,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_extends,
      anon_sym_LPAREN,
  [15367] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(553), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(555), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15405] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_LPAREN,
    ACTIONS(615), 1,
      ts_builtin_sym_end,
    STATE(301), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(617), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [15447] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(619), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(621), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15485] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(549), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(551), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15523] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(579), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(581), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15561] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(623), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(625), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15599] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(575), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(577), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15637] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(627), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(629), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15675] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(557), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(559), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15713] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(631), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(633), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15751] = 12,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(303), 1,
      ts_builtin_sym_end,
    ACTIONS(565), 1,
      anon_sym_DOT,
    ACTIONS(567), 1,
      anon_sym_LBRACK,
    ACTIONS(569), 1,
      anon_sym_EQ,
    ACTIONS(571), 1,
      anon_sym_LPAREN,
    ACTIONS(573), 1,
      anon_sym_match,
    ACTIONS(635), 1,
      anon_sym_else,
    STATE(245), 1,
      sym_arguments,
    STATE(429), 1,
      sym_type_arguments,
    ACTIONS(563), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(305), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [15807] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(637), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(639), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15845] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(641), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(643), 27,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [15883] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(645), 1,
      ts_builtin_sym_end,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    STATE(301), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(647), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [15925] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(652), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(654), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [15963] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(656), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(658), 27,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [16001] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(660), 30,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_RBRACK,
      anon_sym_LT_COLON,
      anon_sym_GT_COLON,
      anon_sym_LT_PERCENT,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_extends,
      anon_sym_LPAREN,
  [16037] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(662), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(664), 27,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [16075] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(537), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(539), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [16113] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(666), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(668), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [16151] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(670), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(672), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [16189] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(674), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(676), 27,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [16227] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(678), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(680), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [16265] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(213), 1,
      anon_sym_finally,
    STATE(358), 1,
      sym_finally_clause,
    ACTIONS(537), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(539), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      sym_identifier,
      sym_operator_identifier,
  [16307] = 12,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(303), 1,
      ts_builtin_sym_end,
    ACTIONS(565), 1,
      anon_sym_DOT,
    ACTIONS(567), 1,
      anon_sym_LBRACK,
    ACTIONS(569), 1,
      anon_sym_EQ,
    ACTIONS(571), 1,
      anon_sym_LPAREN,
    ACTIONS(573), 1,
      anon_sym_match,
    ACTIONS(682), 1,
      anon_sym_else,
    STATE(245), 1,
      sym_arguments,
    STATE(429), 1,
      sym_type_arguments,
    ACTIONS(563), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(305), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [16363] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    STATE(475), 2,
      sym_block,
      sym_case_block,
    ACTIONS(231), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(233), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [16405] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(684), 1,
      ts_builtin_sym_end,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(688), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [16458] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(674), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(676), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [16495] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(666), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(668), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [16532] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(700), 1,
      ts_builtin_sym_end,
    ACTIONS(704), 1,
      anon_sym_AT,
    STATE(317), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(702), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [16573] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(707), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(709), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [16626] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(711), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(713), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [16679] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(715), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(717), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [16732] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(719), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(721), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [16785] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(549), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(551), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [16822] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(575), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(577), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [16859] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(723), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(725), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [16912] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(553), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(555), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [16949] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(579), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(581), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [16986] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(727), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(729), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [17039] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(450), 1,
      sym_type_parameters,
    STATE(545), 1,
      sym_extends_clause,
    STATE(660), 1,
      sym_template_body,
    STATE(449), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(731), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [17090] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(557), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(559), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [17127] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(678), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(680), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [17164] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(741), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(743), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [17217] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(745), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(747), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [17270] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(749), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(751), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [17323] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(757), 1,
      anon_sym_COLON,
    ACTIONS(759), 1,
      anon_sym_EQ,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    STATE(490), 1,
      sym_type_parameters,
    STATE(624), 1,
      sym_block,
    STATE(486), 2,
      sym_parameters,
      aux_sym_function_definition_repeat1,
    ACTIONS(753), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [17374] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(763), 1,
      anon_sym_DOT,
    ACTIONS(509), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(511), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [17413] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(656), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(658), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [17450] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(765), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    STATE(337), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(647), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [17491] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(483), 1,
      sym_type_parameters,
    STATE(562), 1,
      sym_extends_clause,
    STATE(625), 1,
      sym_template_body,
    STATE(480), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(768), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [17542] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(662), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
    ACTIONS(664), 27,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [17579] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(575), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(577), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [17616] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(619), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(621), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [17653] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(579), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(581), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [17690] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(662), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(664), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [17727] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(641), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(643), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [17764] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(770), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(772), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [17817] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(670), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(672), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [17854] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(587), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(589), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [17891] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(583), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(585), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [17928] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(774), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(776), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [17981] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(778), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(780), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [18034] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(359), 1,
      anon_sym_AT,
    ACTIONS(782), 1,
      ts_builtin_sym_end,
    STATE(317), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(784), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [18075] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(541), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(543), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [18114] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(189), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(191), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [18151] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(464), 1,
      sym_type_parameters,
    STATE(570), 1,
      sym_extends_clause,
    STATE(587), 1,
      sym_template_body,
    STATE(492), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(786), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [18202] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(788), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(790), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [18255] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(265), 1,
      ts_builtin_sym_end,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(267), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [18302] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(591), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(593), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [18339] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(595), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(597), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [18376] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    ACTIONS(794), 1,
      anon_sym_COLON,
    ACTIONS(796), 1,
      anon_sym_EQ,
    STATE(454), 1,
      sym_type_parameters,
    STATE(632), 1,
      sym_block,
    STATE(456), 2,
      sym_parameters,
      aux_sym_function_definition_repeat1,
    ACTIONS(792), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [18427] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(277), 1,
      ts_builtin_sym_end,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(279), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [18474] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(798), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(800), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [18527] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(609), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(611), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [18564] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(802), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(804), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [18617] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(615), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    STATE(337), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(617), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [18658] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(806), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(808), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [18711] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(810), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(812), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [18764] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(814), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(816), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [18817] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(605), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(607), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [18854] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(631), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(633), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [18891] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(237), 1,
      anon_sym_finally,
    STATE(459), 1,
      sym_finally_clause,
    ACTIONS(537), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(539), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [18932] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(818), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(820), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [18985] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(822), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(824), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [19038] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(826), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(828), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [19091] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(830), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(832), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [19144] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(285), 1,
      ts_builtin_sym_end,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(287), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [19197] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(834), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(836), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [19250] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(838), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(840), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [19303] = 10,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(269), 1,
      ts_builtin_sym_end,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(271), 20,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
  [19354] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(627), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(629), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [19391] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(842), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(844), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [19444] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(846), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(848), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [19497] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(850), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(852), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [19550] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(854), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(856), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [19603] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(858), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(860), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [19656] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(862), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(864), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [19709] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(866), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(868), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [19762] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(273), 1,
      ts_builtin_sym_end,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(275), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [19809] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(870), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(872), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [19862] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(537), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(539), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [19899] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(874), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(876), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [19952] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(878), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(880), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [20005] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    ACTIONS(884), 1,
      anon_sym_COLON,
    ACTIONS(886), 1,
      anon_sym_EQ,
    STATE(453), 1,
      sym_type_parameters,
    STATE(643), 1,
      sym_block,
    STATE(451), 2,
      sym_parameters,
      aux_sym_function_definition_repeat1,
    ACTIONS(882), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [20056] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(601), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(603), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [20093] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(281), 1,
      ts_builtin_sym_end,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(283), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [20146] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(637), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(639), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [20183] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(652), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(654), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [20220] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(623), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(625), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [20257] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_match,
    ACTIONS(888), 1,
      ts_builtin_sym_end,
    STATE(313), 1,
      sym_arguments,
    STATE(468), 1,
      sym_type_arguments,
    ACTIONS(686), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(890), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [20310] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(470), 1,
      sym_type_parameters,
    STATE(577), 1,
      sym_extends_clause,
    STATE(595), 1,
      sym_template_body,
    STATE(444), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(892), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [20361] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(662), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(664), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [20397] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(575), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(577), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [20433] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(579), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(581), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [20469] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(595), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(597), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [20505] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(609), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(611), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [20541] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(662), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
    ACTIONS(664), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [20577] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(547), 1,
      anon_sym_AT,
    ACTIONS(782), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    STATE(407), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(784), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [20617] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(894), 1,
      anon_sym_AT,
    ACTIONS(700), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    STATE(407), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(702), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [20657] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(605), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(607), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [20693] = 7,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(897), 1,
      ts_builtin_sym_end,
    ACTIONS(903), 1,
      anon_sym_EQ_GT,
    ACTIONS(905), 1,
      anon_sym_with,
    STATE(419), 1,
      aux_sym_compound_type_repeat1,
    ACTIONS(899), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(901), 22,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_PIPE,
  [20737] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(637), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(639), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [20773] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(575), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(577), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [20809] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(641), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(643), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [20845] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_AT,
    STATE(437), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(782), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(784), 22,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [20885] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(666), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(668), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [20921] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(907), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    STATE(415), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(647), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [20961] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(652), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(654), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [20997] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(537), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(539), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [21033] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(656), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(658), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [21069] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(905), 1,
      anon_sym_with,
    ACTIONS(910), 1,
      ts_builtin_sym_end,
    STATE(438), 1,
      aux_sym_compound_type_repeat1,
    ACTIONS(912), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [21109] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(591), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(593), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [21145] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(678), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(680), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [21181] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(549), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(551), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [21217] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(557), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(559), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [21253] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(415), 1,
      anon_sym_LPAREN,
    ACTIONS(615), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    STATE(415), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(617), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [21293] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(189), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(191), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [21329] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(631), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(633), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [21365] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(674), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(676), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [21401] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(627), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(629), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [21437] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(619), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(621), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [21473] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(623), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(625), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [21509] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(557), 2,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
    ACTIONS(559), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [21545] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(670), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(672), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [21581] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(553), 2,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
    ACTIONS(555), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [21617] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(905), 1,
      anon_sym_with,
    ACTIONS(914), 1,
      ts_builtin_sym_end,
    STATE(419), 1,
      aux_sym_compound_type_repeat1,
    ACTIONS(916), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [21657] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(587), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(589), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [21693] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(583), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(585), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_else,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [21729] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_AT,
    STATE(437), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(700), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(702), 22,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [21769] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(921), 1,
      ts_builtin_sym_end,
    ACTIONS(925), 1,
      anon_sym_with,
    STATE(438), 1,
      aux_sym_compound_type_repeat1,
    ACTIONS(923), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [21809] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(579), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(581), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [21845] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(553), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(555), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [21881] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(549), 2,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
    ACTIONS(551), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [21917] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(662), 4,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(664), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [21953] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(537), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(539), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [21988] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(572), 1,
      sym_extends_clause,
    STATE(606), 1,
      sym_template_body,
    STATE(509), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(928), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [22033] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(930), 1,
      anon_sym_with,
    STATE(445), 1,
      aux_sym_compound_type_repeat1,
    ACTIONS(921), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(923), 22,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_operator_identifier,
  [22072] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(933), 1,
      ts_builtin_sym_end,
    ACTIONS(935), 26,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [22107] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    ACTIONS(939), 1,
      anon_sym_COLON,
    ACTIONS(941), 1,
      anon_sym_EQ,
    STATE(616), 1,
      sym_block,
    STATE(498), 2,
      sym_parameters,
      aux_sym_function_definition_repeat1,
    ACTIONS(937), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [22152] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(627), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(629), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [22187] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(559), 1,
      sym_extends_clause,
    STATE(588), 1,
      sym_template_body,
    STATE(509), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(943), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [22232] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(567), 1,
      sym_extends_clause,
    STATE(665), 1,
      sym_template_body,
    STATE(461), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(945), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [22277] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    ACTIONS(949), 1,
      anon_sym_COLON,
    ACTIONS(951), 1,
      anon_sym_EQ,
    STATE(642), 1,
      sym_block,
    STATE(498), 2,
      sym_parameters,
      aux_sym_function_definition_repeat1,
    ACTIONS(947), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [22322] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(953), 1,
      anon_sym_with,
    STATE(473), 1,
      aux_sym_compound_type_repeat1,
    ACTIONS(914), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(916), 22,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_operator_identifier,
  [22361] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    ACTIONS(957), 1,
      anon_sym_COLON,
    ACTIONS(959), 1,
      anon_sym_EQ,
    STATE(640), 1,
      sym_block,
    STATE(447), 2,
      sym_parameters,
      aux_sym_function_definition_repeat1,
    ACTIONS(955), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [22406] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    ACTIONS(963), 1,
      anon_sym_COLON,
    ACTIONS(965), 1,
      anon_sym_EQ,
    STATE(628), 1,
      sym_block,
    STATE(471), 2,
      sym_parameters,
      aux_sym_function_definition_repeat1,
    ACTIONS(961), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [22451] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    ACTIONS(969), 1,
      anon_sym_COLON,
    ACTIONS(971), 1,
      anon_sym_EQ,
    STATE(621), 1,
      sym_block,
    STATE(498), 2,
      sym_parameters,
      aux_sym_function_definition_repeat1,
    ACTIONS(967), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [22496] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    ACTIONS(975), 1,
      anon_sym_COLON,
    ACTIONS(977), 1,
      anon_sym_EQ,
    STATE(629), 1,
      sym_block,
    STATE(498), 2,
      sym_parameters,
      aux_sym_function_definition_repeat1,
    ACTIONS(973), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [22541] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(591), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(593), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [22576] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(623), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(625), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [22611] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(595), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(597), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [22646] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(549), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(551), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [22681] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(556), 1,
      sym_extends_clause,
    STATE(653), 1,
      sym_template_body,
    STATE(509), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(979), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [22726] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(583), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(585), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [22761] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(553), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(555), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [22796] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(552), 1,
      sym_extends_clause,
    STATE(647), 1,
      sym_template_body,
    STATE(472), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(981), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [22841] = 7,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(903), 1,
      anon_sym_EQ_GT,
    ACTIONS(953), 1,
      anon_sym_with,
    STATE(473), 1,
      aux_sym_compound_type_repeat1,
    ACTIONS(983), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(897), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(901), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [22884] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(631), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(633), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [22919] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(985), 1,
      anon_sym_with,
    STATE(467), 1,
      aux_sym_compound_type_repeat1,
    ACTIONS(921), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    ACTIONS(923), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_operator_identifier,
  [22958] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(619), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(621), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [22993] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(988), 1,
      anon_sym_with,
    STATE(487), 1,
      aux_sym_compound_type_repeat1,
    ACTIONS(914), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    ACTIONS(916), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_operator_identifier,
  [23032] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(554), 1,
      sym_extends_clause,
    STATE(603), 1,
      sym_template_body,
    STATE(478), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(990), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [23077] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    ACTIONS(994), 1,
      anon_sym_COLON,
    ACTIONS(996), 1,
      anon_sym_EQ,
    STATE(596), 1,
      sym_block,
    STATE(498), 2,
      sym_parameters,
      aux_sym_function_definition_repeat1,
    ACTIONS(992), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [23122] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(575), 1,
      sym_extends_clause,
    STATE(663), 1,
      sym_template_body,
    STATE(509), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(998), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [23167] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(953), 1,
      anon_sym_with,
    STATE(445), 1,
      aux_sym_compound_type_repeat1,
    ACTIONS(910), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(912), 22,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_operator_identifier,
  [23206] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(609), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(611), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [23241] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(605), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(607), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [23276] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(557), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(559), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [23311] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(189), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(191), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [23346] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(571), 1,
      sym_extends_clause,
    STATE(636), 1,
      sym_template_body,
    STATE(509), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(1000), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [23391] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(587), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(589), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [23426] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(569), 1,
      sym_extends_clause,
    STATE(618), 1,
      sym_template_body,
    STATE(509), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(1002), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [23471] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(637), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(639), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [23506] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(575), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(577), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [23541] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(547), 1,
      sym_extends_clause,
    STATE(622), 1,
      sym_template_body,
    STATE(484), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(1004), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [23586] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(564), 1,
      sym_extends_clause,
    STATE(593), 1,
      sym_template_body,
    STATE(509), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(1006), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [23631] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(652), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(654), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [23666] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    ACTIONS(1010), 1,
      anon_sym_COLON,
    ACTIONS(1012), 1,
      anon_sym_EQ,
    STATE(657), 1,
      sym_block,
    STATE(498), 2,
      sym_parameters,
      aux_sym_function_definition_repeat1,
    ACTIONS(1008), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [23711] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(988), 1,
      anon_sym_with,
    STATE(467), 1,
      aux_sym_compound_type_repeat1,
    ACTIONS(910), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    ACTIONS(912), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_operator_identifier,
  [23750] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(579), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(581), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [23785] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(670), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(672), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [23820] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    ACTIONS(1016), 1,
      anon_sym_COLON,
    ACTIONS(1018), 1,
      anon_sym_EQ,
    STATE(651), 1,
      sym_block,
    STATE(455), 2,
      sym_parameters,
      aux_sym_function_definition_repeat1,
    ACTIONS(1014), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [23865] = 7,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(903), 1,
      anon_sym_EQ_GT,
    ACTIONS(988), 1,
      anon_sym_with,
    STATE(487), 1,
      aux_sym_compound_type_repeat1,
    ACTIONS(897), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    ACTIONS(1020), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(901), 20,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [23908] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_extends,
    ACTIONS(739), 1,
      anon_sym_LPAREN,
    STATE(555), 1,
      sym_extends_clause,
    STATE(666), 1,
      sym_template_body,
    STATE(509), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(1022), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [23953] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(666), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(668), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [23988] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(678), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(680), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_match,
      sym_identifier,
      sym_operator_identifier,
  [24023] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(933), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    ACTIONS(935), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [24057] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(897), 1,
      ts_builtin_sym_end,
    ACTIONS(903), 1,
      anon_sym_EQ_GT,
    ACTIONS(899), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(901), 22,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_PIPE,
  [24095] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(914), 1,
      ts_builtin_sym_end,
    ACTIONS(916), 25,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [24129] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1026), 1,
      anon_sym_LPAREN,
    STATE(498), 2,
      sym_parameters,
      aux_sym_function_definition_repeat1,
    ACTIONS(1024), 23,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [24165] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(737), 1,
      anon_sym_extends,
    STATE(517), 1,
      sym_type_parameters,
    STATE(568), 1,
      sym_extends_clause,
    STATE(659), 1,
      sym_template_body,
    ACTIONS(1029), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [24209] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(557), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(559), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [24243] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(553), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(555), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [24277] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(933), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(935), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [24311] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(549), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(551), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [24345] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1031), 1,
      ts_builtin_sym_end,
    ACTIONS(1037), 1,
      anon_sym_EQ,
    ACTIONS(1033), 4,
      anon_sym_COLON,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(1035), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [24382] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(914), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(916), 22,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_operator_identifier,
  [24415] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1039), 1,
      ts_builtin_sym_end,
    ACTIONS(1043), 1,
      anon_sym_EQ,
    ACTIONS(1033), 4,
      anon_sym_COLON,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(1041), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [24452] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1045), 1,
      ts_builtin_sym_end,
    ACTIONS(1049), 1,
      anon_sym_EQ,
    ACTIONS(1033), 4,
      anon_sym_COLON,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(1047), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [24489] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(903), 1,
      anon_sym_EQ_GT,
    ACTIONS(897), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    ACTIONS(1020), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(901), 20,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [24526] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_LPAREN,
    STATE(509), 2,
      sym_class_parameters,
      aux_sym_class_definition_repeat2,
    ACTIONS(1051), 22,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_extends,
  [24561] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1056), 1,
      ts_builtin_sym_end,
    ACTIONS(1060), 1,
      anon_sym_EQ,
    ACTIONS(1033), 4,
      anon_sym_COLON,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(1058), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [24598] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1062), 1,
      ts_builtin_sym_end,
    ACTIONS(1066), 1,
      anon_sym_EQ,
    ACTIONS(1033), 4,
      anon_sym_COLON,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(1064), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [24635] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(903), 1,
      anon_sym_EQ_GT,
    ACTIONS(983), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(897), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(901), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [24672] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(914), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
    ACTIONS(916), 23,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_operator_identifier,
  [24705] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1068), 1,
      ts_builtin_sym_end,
    ACTIONS(1072), 1,
      anon_sym_EQ,
    ACTIONS(1033), 4,
      anon_sym_COLON,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(1070), 19,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [24742] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(561), 1,
      ts_builtin_sym_end,
    ACTIONS(1074), 24,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [24775] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 24,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_LPAREN,
  [24805] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_extends,
    STATE(544), 1,
      sym_extends_clause,
    STATE(662), 1,
      sym_template_body,
    ACTIONS(1078), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [24843] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1080), 24,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_LPAREN,
  [24873] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1082), 24,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_LPAREN,
  [24903] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1084), 24,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_EQ,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_LPAREN,
  [24933] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_extends,
    STATE(561), 1,
      sym_extends_clause,
    STATE(614), 1,
      sym_template_body,
    ACTIONS(1086), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [24971] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1088), 1,
      anon_sym_DOT,
    ACTIONS(509), 6,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
    ACTIONS(511), 16,
      anon_sym_case,
      anon_sym_class,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_wildcard,
  [25004] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(1092), 1,
      anon_sym_EQ,
    STATE(601), 1,
      sym_block,
    ACTIONS(1090), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25039] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(1096), 1,
      anon_sym_EQ,
    STATE(602), 1,
      sym_block,
    ACTIONS(1094), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25074] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(1100), 1,
      anon_sym_EQ,
    STATE(591), 1,
      sym_block,
    ACTIONS(1098), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25109] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1104), 1,
      anon_sym_DOT,
    STATE(540), 1,
      aux_sym_package_identifier_repeat1,
    ACTIONS(1102), 21,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25142] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(1108), 1,
      anon_sym_EQ,
    STATE(654), 1,
      sym_block,
    ACTIONS(1106), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25177] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1110), 23,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_extends,
      anon_sym_LPAREN,
  [25206] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(1114), 1,
      anon_sym_EQ,
    STATE(634), 1,
      sym_block,
    ACTIONS(1112), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25241] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(1118), 1,
      anon_sym_EQ,
    STATE(598), 1,
      sym_block,
    ACTIONS(1116), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25276] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1120), 23,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_extends,
      anon_sym_LPAREN,
  [25305] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(1124), 1,
      anon_sym_EQ,
    STATE(620), 1,
      sym_block,
    ACTIONS(1122), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25340] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 23,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_extends,
      anon_sym_LPAREN,
  [25369] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1130), 1,
      anon_sym_LPAREN,
    STATE(584), 1,
      sym_arguments,
    ACTIONS(1128), 21,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25402] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(1134), 1,
      anon_sym_EQ,
    STATE(612), 1,
      sym_block,
    ACTIONS(1132), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25437] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1138), 1,
      anon_sym_DOT,
    STATE(536), 1,
      aux_sym_package_identifier_repeat1,
    ACTIONS(1136), 21,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25470] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(1143), 1,
      anon_sym_EQ,
    STATE(641), 1,
      sym_block,
    ACTIONS(1141), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25505] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(1147), 1,
      anon_sym_EQ,
    STATE(645), 1,
      sym_block,
    ACTIONS(1145), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25540] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(1151), 1,
      anon_sym_EQ,
    STATE(623), 1,
      sym_block,
    ACTIONS(1149), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25575] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1104), 1,
      anon_sym_DOT,
    STATE(536), 1,
      aux_sym_package_identifier_repeat1,
    ACTIONS(1153), 21,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25608] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_LBRACE,
    ACTIONS(1157), 1,
      anon_sym_EQ,
    STATE(626), 1,
      sym_block,
    ACTIONS(1155), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25643] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(541), 6,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
    ACTIONS(543), 16,
      anon_sym_case,
      anon_sym_class,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_wildcard,
  [25676] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1159), 23,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_extends,
      anon_sym_LPAREN,
  [25705] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(646), 1,
      sym_template_body,
    ACTIONS(1161), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25737] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(664), 1,
      sym_template_body,
    ACTIONS(1163), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25769] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(604), 1,
      sym_template_body,
    ACTIONS(1165), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25801] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(592), 1,
      sym_template_body,
    ACTIONS(1167), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25833] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_DOT,
    ACTIONS(1169), 21,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25863] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(656), 6,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
    ACTIONS(658), 16,
      anon_sym_case,
      anon_sym_class,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_wildcard,
  [25893] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(557), 22,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_LPAREN,
  [25921] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1175), 1,
      anon_sym_COMMA,
    STATE(563), 1,
      aux_sym_import_declaration_repeat1,
    ACTIONS(1173), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25953] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(585), 1,
      sym_template_body,
    ACTIONS(1177), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [25985] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(662), 6,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
    ACTIONS(664), 16,
      anon_sym_case,
      anon_sym_class,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_wildcard,
  [26015] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(635), 1,
      sym_template_body,
    ACTIONS(1179), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26047] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(661), 1,
      sym_template_body,
    ACTIONS(1181), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26079] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(586), 1,
      sym_template_body,
    ACTIONS(1183), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26111] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 6,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
    ACTIONS(643), 16,
      anon_sym_case,
      anon_sym_class,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_wildcard,
  [26141] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(579), 6,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
    ACTIONS(581), 16,
      anon_sym_case,
      anon_sym_class,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_wildcard,
  [26171] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(649), 1,
      sym_template_body,
    ACTIONS(1185), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26203] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 22,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_LPAREN,
  [26231] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(597), 1,
      sym_template_body,
    ACTIONS(1187), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26263] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(619), 1,
      sym_template_body,
    ACTIONS(1189), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26295] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1175), 1,
      anon_sym_COMMA,
    STATE(574), 1,
      aux_sym_import_declaration_repeat1,
    ACTIONS(1191), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26327] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(631), 1,
      sym_template_body,
    ACTIONS(1193), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26359] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 22,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_DOT,
      anon_sym_object,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26387] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(575), 6,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
    ACTIONS(577), 16,
      anon_sym_case,
      anon_sym_class,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_wildcard,
  [26417] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(655), 1,
      sym_template_body,
    ACTIONS(1195), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26449] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(650), 1,
      sym_template_body,
    ACTIONS(1197), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26481] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(594), 1,
      sym_template_body,
    ACTIONS(1199), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26513] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(658), 1,
      sym_template_body,
    ACTIONS(1201), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26545] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(652), 1,
      sym_template_body,
    ACTIONS(1203), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26577] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(637), 1,
      sym_template_body,
    ACTIONS(1205), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26609] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 22,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_LPAREN,
  [26637] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_COMMA,
    STATE(574), 1,
      aux_sym_import_declaration_repeat1,
    ACTIONS(1207), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26669] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(630), 1,
      sym_template_body,
    ACTIONS(1212), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26701] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1136), 22,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_DOT,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26729] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    STATE(605), 1,
      sym_template_body,
    ACTIONS(1214), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26761] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 6,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
    ACTIONS(676), 16,
      anon_sym_case,
      anon_sym_class,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
      sym_identifier,
      sym_wildcard,
  [26791] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1216), 21,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26818] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1218), 21,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26845] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1220), 21,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26872] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 21,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26899] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1130), 1,
      anon_sym_LPAREN,
    ACTIONS(1224), 1,
      anon_sym_LBRACK,
    ACTIONS(1226), 1,
      anon_sym_POUND,
    STATE(578), 1,
      sym_type_arguments,
    STATE(680), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(215), 15,
      anon_sym_case,
      anon_sym_class,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26936] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1228), 21,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_LBRACE,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26963] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1230), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [26989] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1232), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27015] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1234), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27041] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1236), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27067] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1238), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27093] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27119] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27145] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1244), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27171] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1246), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27197] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1248), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27223] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1250), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27249] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1252), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27275] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1254), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27301] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1256), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27327] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1258), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27353] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1260), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27379] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1262), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27405] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1264), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27431] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1266), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27457] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1268), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27483] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1270), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27509] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1272), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27535] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1274), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27561] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1276), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27587] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1278), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27613] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1280), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27639] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1282), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27665] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1284), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27691] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1286), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27717] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1288), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27743] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27769] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1290), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27795] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1292), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27821] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1294), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27847] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1296), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27873] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1298), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27899] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1300), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27925] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1302), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27951] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1304), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [27977] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1306), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28003] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1308), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28029] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1310), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28055] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1312), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28081] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1314), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28107] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1316), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28133] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1318), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28159] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1320), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28185] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1322), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28211] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1324), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28237] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1326), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28263] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1328), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28289] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1330), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28315] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1332), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28341] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1334), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28367] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1336), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28393] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1338), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28419] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1340), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28445] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1342), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28471] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1344), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28497] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1346), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28523] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1348), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28549] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1350), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28575] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1352), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28601] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28627] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1354), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28653] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1356), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28679] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1358), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28705] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1360), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28731] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1362), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28757] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1364), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28783] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1366), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28809] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1368), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28835] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1370), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28861] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1372), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28887] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1374), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28913] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1376), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28939] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1378), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28965] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1380), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [28991] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1382), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [29017] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1384), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [29043] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1386), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [29069] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1388), 20,
      ts_builtin_sym_end,
      anon_sym_package,
      anon_sym_object,
      anon_sym_import,
      anon_sym_case,
      anon_sym_class,
      anon_sym_trait,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [29095] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AT,
    ACTIONS(1390), 1,
      anon_sym_case,
    ACTIONS(1392), 1,
      anon_sym_class,
    ACTIONS(1394), 1,
      anon_sym_val,
    ACTIONS(1396), 1,
      anon_sym_var,
    ACTIONS(1398), 1,
      anon_sym_type,
    ACTIONS(1400), 1,
      anon_sym_def,
    STATE(761), 1,
      aux_sym_modifiers_repeat1,
    STATE(1681), 1,
      sym_modifiers,
    STATE(697), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(29), 8,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [29140] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AT,
    ACTIONS(1402), 1,
      anon_sym_case,
    ACTIONS(1404), 1,
      anon_sym_class,
    ACTIONS(1406), 1,
      anon_sym_val,
    ACTIONS(1408), 1,
      anon_sym_var,
    ACTIONS(1410), 1,
      anon_sym_type,
    ACTIONS(1412), 1,
      anon_sym_def,
    STATE(761), 1,
      aux_sym_modifiers_repeat1,
    STATE(1684), 1,
      sym_modifiers,
    STATE(697), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(29), 8,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [29185] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1791), 2,
      sym__type,
      sym_function_type,
    STATE(1973), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [29229] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1775), 2,
      sym__type,
      sym_function_type,
    STATE(1973), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [29273] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1725), 2,
      sym__type,
      sym_function_type,
    STATE(1973), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [29317] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1422), 1,
      sym_identifier,
    ACTIONS(1424), 1,
      anon_sym_object,
    ACTIONS(1426), 1,
      anon_sym_class,
    ACTIONS(1428), 1,
      anon_sym_LPAREN,
    ACTIONS(1430), 1,
      sym_wildcard,
    ACTIONS(1432), 1,
      sym_number,
    ACTIONS(1434), 1,
      sym__simple_string,
    ACTIONS(1436), 1,
      sym__string_start,
    ACTIONS(1438), 1,
      sym__multiline_string_start,
    STATE(2275), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1638), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [29363] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1738), 2,
      sym__type,
      sym_function_type,
    STATE(1973), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [29407] = 15,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1442), 1,
      anon_sym_DOT,
    ACTIONS(1444), 1,
      anon_sym_LBRACK,
    ACTIONS(1446), 1,
      anon_sym_EQ,
    ACTIONS(1448), 1,
      anon_sym_LPAREN,
    ACTIONS(1450), 1,
      anon_sym_match,
    ACTIONS(1452), 1,
      anon_sym_catch,
    ACTIONS(1454), 1,
      anon_sym_finally,
    STATE(698), 1,
      sym_arguments,
    STATE(758), 1,
      sym_catch_clause,
    STATE(916), 1,
      sym_finally_clause,
    STATE(930), 1,
      sym_type_arguments,
    ACTIONS(169), 2,
      anon_sym_case,
      anon_sym_else,
    ACTIONS(1440), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(165), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
  [29457] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1765), 2,
      sym__type,
      sym_function_type,
    STATE(1973), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [29501] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1742), 2,
      sym__type,
      sym_function_type,
    STATE(1973), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [29545] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1758), 2,
      sym__type,
      sym_function_type,
    STATE(1973), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [29589] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1770), 2,
      sym__type,
      sym_function_type,
    STATE(1973), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [29633] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1728), 2,
      sym__type,
      sym_function_type,
    STATE(1973), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [29677] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1130), 1,
      anon_sym_LPAREN,
    STATE(686), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(615), 15,
      anon_sym_case,
      anon_sym_class,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [29705] = 7,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(407), 1,
      sym__simple_string,
    ACTIONS(409), 1,
      sym__string_start,
    ACTIONS(411), 1,
      sym__multiline_string_start,
    STATE(931), 1,
      sym_string,
    ACTIONS(189), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(191), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [29739] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1750), 2,
      sym__type,
      sym_function_type,
    STATE(1973), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [29783] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1771), 2,
      sym__type,
      sym_function_type,
    STATE(1973), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [29827] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1774), 2,
      sym__type,
      sym_function_type,
    STATE(1973), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [29871] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1456), 1,
      anon_sym_LBRACK,
    ACTIONS(1458), 1,
      anon_sym_LPAREN,
    ACTIONS(1460), 1,
      anon_sym_POUND,
    STATE(773), 1,
      sym_type_arguments,
    STATE(772), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(215), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(217), 9,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [29907] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1462), 1,
      anon_sym_LPAREN,
    STATE(686), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(645), 15,
      anon_sym_case,
      anon_sym_class,
      anon_sym_AT,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [29935] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1790), 2,
      sym__type,
      sym_function_type,
    STATE(1973), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [29979] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1736), 2,
      sym__type,
      sym_function_type,
    STATE(1973), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [30023] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1779), 2,
      sym__type,
      sym_function_type,
    STATE(1973), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [30067] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1465), 1,
      sym_identifier,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1469), 1,
      anon_sym_RPAREN,
    ACTIONS(1471), 1,
      sym_wildcard,
    ACTIONS(1473), 1,
      sym_number,
    ACTIONS(1475), 1,
      sym__simple_string,
    ACTIONS(1477), 1,
      sym__string_start,
    ACTIONS(1479), 1,
      sym__multiline_string_start,
    STATE(2312), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1604), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [30110] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1456), 1,
      anon_sym_LBRACK,
    ACTIONS(1460), 1,
      anon_sym_POUND,
    ACTIONS(1481), 1,
      anon_sym_AT,
    STATE(773), 1,
      sym_type_arguments,
    STATE(956), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(355), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(357), 8,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [30145] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1475), 1,
      sym__simple_string,
    ACTIONS(1477), 1,
      sym__string_start,
    ACTIONS(1479), 1,
      sym__multiline_string_start,
    ACTIONS(1483), 1,
      sym_identifier,
    ACTIONS(1485), 1,
      anon_sym_RPAREN,
    ACTIONS(1487), 1,
      sym_wildcard,
    ACTIONS(1489), 1,
      sym_number,
    STATE(2312), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1615), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [30188] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2052), 2,
      sym__type,
      sym_function_type,
    STATE(2216), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [30229] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1475), 1,
      sym__simple_string,
    ACTIONS(1477), 1,
      sym__string_start,
    ACTIONS(1479), 1,
      sym__multiline_string_start,
    ACTIONS(1491), 1,
      sym_identifier,
    ACTIONS(1493), 1,
      anon_sym_RPAREN,
    ACTIONS(1495), 1,
      sym_wildcard,
    ACTIONS(1497), 1,
      sym_number,
    STATE(2312), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1620), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [30272] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1499), 1,
      sym_identifier,
    ACTIONS(1501), 1,
      anon_sym_EQ_GT,
    ACTIONS(1503), 1,
      anon_sym_LPAREN,
    STATE(1498), 1,
      sym__annotated_type,
    STATE(2357), 1,
      sym_parameter_types,
    STATE(2360), 1,
      sym_stable_identifier,
    STATE(1605), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1808), 2,
      sym__type,
      sym_function_type,
    STATE(2071), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(896), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [30313] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1499), 1,
      sym_identifier,
    ACTIONS(1501), 1,
      anon_sym_EQ_GT,
    ACTIONS(1503), 1,
      anon_sym_LPAREN,
    STATE(1498), 1,
      sym__annotated_type,
    STATE(2357), 1,
      sym_parameter_types,
    STATE(2360), 1,
      sym_stable_identifier,
    STATE(1605), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1833), 2,
      sym__type,
      sym_function_type,
    STATE(2120), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(896), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [30354] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1505), 1,
      anon_sym_AT,
    STATE(697), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(700), 14,
      anon_sym_case,
      anon_sym_class,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [30381] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(393), 1,
      anon_sym_LBRACE,
    STATE(909), 2,
      sym_block,
      sym_case_block,
    ACTIONS(231), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(233), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [30410] = 7,
    ACTIONS(71), 1,
      sym__simple_string,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(75), 1,
      sym__multiline_string_start,
    ACTIONS(185), 1,
      sym_comment,
    STATE(1112), 1,
      sym_string,
    ACTIONS(189), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(191), 7,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [30443] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1475), 1,
      sym__simple_string,
    ACTIONS(1477), 1,
      sym__string_start,
    ACTIONS(1479), 1,
      sym__multiline_string_start,
    ACTIONS(1508), 1,
      sym_identifier,
    ACTIONS(1510), 1,
      anon_sym_RPAREN,
    ACTIONS(1512), 1,
      sym_wildcard,
    ACTIONS(1514), 1,
      sym_number,
    STATE(2312), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1616), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [30486] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1516), 1,
      anon_sym_LBRACK,
    ACTIONS(1518), 1,
      anon_sym_LPAREN,
    ACTIONS(1520), 1,
      anon_sym_POUND,
    STATE(975), 1,
      sym_type_arguments,
    STATE(968), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(215), 4,
      sym__automatic_semicolon,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(217), 7,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [30521] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1475), 1,
      sym__simple_string,
    ACTIONS(1477), 1,
      sym__string_start,
    ACTIONS(1479), 1,
      sym__multiline_string_start,
    ACTIONS(1522), 1,
      sym_identifier,
    ACTIONS(1524), 1,
      anon_sym_RPAREN,
    ACTIONS(1526), 1,
      sym_wildcard,
    ACTIONS(1528), 1,
      sym_number,
    STATE(2312), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1606), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [30564] = 15,
    ACTIONS(169), 1,
      anon_sym_case,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1532), 1,
      anon_sym_DOT,
    ACTIONS(1534), 1,
      anon_sym_LBRACK,
    ACTIONS(1536), 1,
      anon_sym_EQ,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    ACTIONS(1540), 1,
      anon_sym_match,
    ACTIONS(1542), 1,
      anon_sym_catch,
    ACTIONS(1544), 1,
      anon_sym_finally,
    STATE(743), 1,
      sym_arguments,
    STATE(852), 1,
      sym_catch_clause,
    STATE(1056), 1,
      sym_finally_clause,
    STATE(1102), 1,
      sym_type_arguments,
    ACTIONS(1530), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(165), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
  [30613] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1475), 1,
      sym__simple_string,
    ACTIONS(1477), 1,
      sym__string_start,
    ACTIONS(1479), 1,
      sym__multiline_string_start,
    ACTIONS(1546), 1,
      sym_identifier,
    ACTIONS(1548), 1,
      anon_sym_RPAREN,
    ACTIONS(1550), 1,
      sym_wildcard,
    ACTIONS(1552), 1,
      sym_number,
    STATE(2312), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1613), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [30656] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1416), 1,
      anon_sym_EQ_GT,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2035), 2,
      sym__type,
      sym_function_type,
    STATE(2216), 2,
      sym_lazy_parameter_type,
      sym_repeated_parameter_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [30697] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1422), 1,
      sym_identifier,
    ACTIONS(1428), 1,
      anon_sym_LPAREN,
    ACTIONS(1430), 1,
      sym_wildcard,
    ACTIONS(1432), 1,
      sym_number,
    ACTIONS(1434), 1,
      sym__simple_string,
    ACTIONS(1436), 1,
      sym__string_start,
    ACTIONS(1438), 1,
      sym__multiline_string_start,
    STATE(2275), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1638), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [30737] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1475), 1,
      sym__simple_string,
    ACTIONS(1477), 1,
      sym__string_start,
    ACTIONS(1479), 1,
      sym__multiline_string_start,
    ACTIONS(1554), 1,
      sym_identifier,
    ACTIONS(1556), 1,
      sym_wildcard,
    ACTIONS(1558), 1,
      sym_number,
    STATE(2312), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1712), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [30777] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1475), 1,
      sym__simple_string,
    ACTIONS(1477), 1,
      sym__string_start,
    ACTIONS(1479), 1,
      sym__multiline_string_start,
    ACTIONS(1560), 1,
      sym_identifier,
    ACTIONS(1562), 1,
      sym_wildcard,
    ACTIONS(1564), 1,
      sym_number,
    STATE(2312), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1672), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [30817] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1475), 1,
      sym__simple_string,
    ACTIONS(1477), 1,
      sym__string_start,
    ACTIONS(1479), 1,
      sym__multiline_string_start,
    ACTIONS(1566), 1,
      sym_identifier,
    ACTIONS(1568), 1,
      sym_wildcard,
    ACTIONS(1570), 1,
      sym_number,
    STATE(2312), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1666), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [30857] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1572), 1,
      anon_sym_DOT,
    ACTIONS(509), 5,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(511), 10,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [30883] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1574), 1,
      anon_sym_LBRACK,
    ACTIONS(1576), 1,
      anon_sym_LPAREN,
    ACTIONS(1578), 1,
      anon_sym_POUND,
    STATE(1039), 1,
      sym_type_arguments,
    ACTIONS(215), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(1038), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(217), 8,
      anon_sym_EQ_GT,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_with,
      anon_sym_PIPE,
      anon_sym_if,
      sym_identifier,
      sym_operator_identifier,
  [30917] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1516), 1,
      anon_sym_LBRACK,
    ACTIONS(1520), 1,
      anon_sym_POUND,
    ACTIONS(1580), 1,
      anon_sym_AT,
    STATE(975), 1,
      sym_type_arguments,
    STATE(1027), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(355), 4,
      sym__automatic_semicolon,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(357), 6,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [30951] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1582), 1,
      sym_identifier,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1586), 1,
      sym_wildcard,
    ACTIONS(1588), 1,
      sym_number,
    ACTIONS(1590), 1,
      sym__simple_string,
    ACTIONS(1592), 1,
      sym__string_start,
    ACTIONS(1594), 1,
      sym__multiline_string_start,
    STATE(2296), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1731), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [30991] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1590), 1,
      sym__simple_string,
    ACTIONS(1592), 1,
      sym__string_start,
    ACTIONS(1594), 1,
      sym__multiline_string_start,
    ACTIONS(1596), 1,
      sym_identifier,
    ACTIONS(1598), 1,
      sym_wildcard,
    ACTIONS(1600), 1,
      sym_number,
    STATE(2296), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1753), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [31031] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1442), 1,
      anon_sym_DOT,
    ACTIONS(1444), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_LPAREN,
    STATE(698), 1,
      sym_arguments,
    STATE(930), 1,
      sym_type_arguments,
    ACTIONS(265), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(267), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [31065] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1475), 1,
      sym__simple_string,
    ACTIONS(1477), 1,
      sym__string_start,
    ACTIONS(1479), 1,
      sym__multiline_string_start,
    ACTIONS(1602), 1,
      sym_identifier,
    ACTIONS(1604), 1,
      sym_wildcard,
    ACTIONS(1606), 1,
      sym_number,
    STATE(2312), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1693), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [31105] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1442), 1,
      anon_sym_DOT,
    ACTIONS(1444), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_LPAREN,
    STATE(698), 1,
      sym_arguments,
    STATE(930), 1,
      sym_type_arguments,
    ACTIONS(277), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(279), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [31139] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1608), 1,
      anon_sym_LBRACK,
    ACTIONS(1610), 1,
      anon_sym_AT,
    ACTIONS(1612), 1,
      anon_sym_POUND,
    STATE(1086), 1,
      sym_type_arguments,
    STATE(1115), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(355), 5,
      sym__automatic_semicolon,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(357), 5,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [31173] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1442), 1,
      anon_sym_DOT,
    ACTIONS(1444), 1,
      anon_sym_LBRACK,
    ACTIONS(1446), 1,
      anon_sym_EQ,
    ACTIONS(1448), 1,
      anon_sym_LPAREN,
    ACTIONS(1450), 1,
      anon_sym_match,
    STATE(698), 1,
      sym_arguments,
    STATE(930), 1,
      sym_type_arguments,
    ACTIONS(1440), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(281), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(283), 4,
      anon_sym_case,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_finally,
  [31213] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1475), 1,
      sym__simple_string,
    ACTIONS(1477), 1,
      sym__string_start,
    ACTIONS(1479), 1,
      sym__multiline_string_start,
    ACTIONS(1614), 1,
      sym_identifier,
    ACTIONS(1616), 1,
      sym_wildcard,
    ACTIONS(1618), 1,
      sym_number,
    STATE(2312), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1680), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [31253] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1620), 1,
      anon_sym_LBRACK,
    ACTIONS(1622), 1,
      anon_sym_LPAREN,
    ACTIONS(1624), 1,
      anon_sym_POUND,
    STATE(1015), 1,
      sym_type_arguments,
    ACTIONS(215), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    STATE(1013), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(217), 8,
      anon_sym_EQ_GT,
      anon_sym_GT_COLON,
      anon_sym_LT_PERCENT,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [31287] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1442), 1,
      anon_sym_DOT,
    ACTIONS(1444), 1,
      anon_sym_LBRACK,
    ACTIONS(1446), 1,
      anon_sym_EQ,
    ACTIONS(1448), 1,
      anon_sym_LPAREN,
    ACTIONS(1450), 1,
      anon_sym_match,
    STATE(698), 1,
      sym_arguments,
    STATE(930), 1,
      sym_type_arguments,
    ACTIONS(1440), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(285), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(287), 4,
      anon_sym_case,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_finally,
  [31327] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1590), 1,
      sym__simple_string,
    ACTIONS(1592), 1,
      sym__string_start,
    ACTIONS(1594), 1,
      sym__multiline_string_start,
    ACTIONS(1626), 1,
      sym_identifier,
    ACTIONS(1628), 1,
      sym_wildcard,
    ACTIONS(1630), 1,
      sym_number,
    STATE(2296), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1732), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [31367] = 15,
    ACTIONS(169), 1,
      anon_sym_else,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1634), 1,
      anon_sym_DOT,
    ACTIONS(1636), 1,
      anon_sym_LBRACK,
    ACTIONS(1638), 1,
      anon_sym_EQ,
    ACTIONS(1640), 1,
      anon_sym_LPAREN,
    ACTIONS(1642), 1,
      anon_sym_match,
    ACTIONS(1644), 1,
      anon_sym_catch,
    ACTIONS(1646), 1,
      anon_sym_finally,
    STATE(755), 1,
      sym_arguments,
    STATE(1073), 1,
      sym_catch_clause,
    STATE(1207), 1,
      sym_type_arguments,
    STATE(1224), 1,
      sym_finally_clause,
    ACTIONS(165), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1632), 2,
      sym_identifier,
      sym_operator_identifier,
  [31415] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1590), 1,
      sym__simple_string,
    ACTIONS(1592), 1,
      sym__string_start,
    ACTIONS(1594), 1,
      sym__multiline_string_start,
    ACTIONS(1648), 1,
      sym_identifier,
    ACTIONS(1650), 1,
      sym_wildcard,
    ACTIONS(1652), 1,
      sym_number,
    STATE(2296), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1756), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [31455] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1428), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      sym__simple_string,
    ACTIONS(1436), 1,
      sym__string_start,
    ACTIONS(1438), 1,
      sym__multiline_string_start,
    ACTIONS(1654), 1,
      sym_identifier,
    ACTIONS(1656), 1,
      sym_wildcard,
    ACTIONS(1658), 1,
      sym_number,
    STATE(2275), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1662), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [31495] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1590), 1,
      sym__simple_string,
    ACTIONS(1592), 1,
      sym__string_start,
    ACTIONS(1594), 1,
      sym__multiline_string_start,
    ACTIONS(1660), 1,
      sym_identifier,
    ACTIONS(1662), 1,
      sym_wildcard,
    ACTIONS(1664), 1,
      sym_number,
    STATE(2296), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1793), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [31535] = 12,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1442), 1,
      anon_sym_DOT,
    ACTIONS(1444), 1,
      anon_sym_LBRACK,
    ACTIONS(1446), 1,
      anon_sym_EQ,
    ACTIONS(1448), 1,
      anon_sym_LPAREN,
    ACTIONS(1450), 1,
      anon_sym_match,
    ACTIONS(1666), 1,
      anon_sym_else,
    STATE(698), 1,
      sym_arguments,
    STATE(930), 1,
      sym_type_arguments,
    ACTIONS(1440), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(303), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(305), 3,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
  [31577] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1428), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      sym__simple_string,
    ACTIONS(1436), 1,
      sym__string_start,
    ACTIONS(1438), 1,
      sym__multiline_string_start,
    ACTIONS(1668), 1,
      sym_identifier,
    ACTIONS(1670), 1,
      sym_wildcard,
    ACTIONS(1672), 1,
      sym_number,
    STATE(2275), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1719), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [31617] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1428), 1,
      anon_sym_LPAREN,
    ACTIONS(1434), 1,
      sym__simple_string,
    ACTIONS(1436), 1,
      sym__string_start,
    ACTIONS(1438), 1,
      sym__multiline_string_start,
    ACTIONS(1674), 1,
      sym_identifier,
    ACTIONS(1676), 1,
      sym_wildcard,
    ACTIONS(1678), 1,
      sym_number,
    STATE(2275), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1714), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [31657] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1590), 1,
      sym__simple_string,
    ACTIONS(1592), 1,
      sym__string_start,
    ACTIONS(1594), 1,
      sym__multiline_string_start,
    ACTIONS(1680), 1,
      sym_identifier,
    ACTIONS(1682), 1,
      sym_wildcard,
    ACTIONS(1684), 1,
      sym_number,
    STATE(2296), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1781), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [31697] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1590), 1,
      sym__simple_string,
    ACTIONS(1592), 1,
      sym__string_start,
    ACTIONS(1594), 1,
      sym__multiline_string_start,
    ACTIONS(1686), 1,
      sym_identifier,
    ACTIONS(1688), 1,
      sym_wildcard,
    ACTIONS(1690), 1,
      sym_number,
    STATE(2296), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1722), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [31737] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1590), 1,
      sym__simple_string,
    ACTIONS(1592), 1,
      sym__string_start,
    ACTIONS(1594), 1,
      sym__multiline_string_start,
    ACTIONS(1692), 1,
      sym_identifier,
    ACTIONS(1694), 1,
      sym_wildcard,
    ACTIONS(1696), 1,
      sym_number,
    STATE(2296), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1755), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [31777] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1590), 1,
      sym__simple_string,
    ACTIONS(1592), 1,
      sym__string_start,
    ACTIONS(1594), 1,
      sym__multiline_string_start,
    ACTIONS(1698), 1,
      sym_identifier,
    ACTIONS(1700), 1,
      sym_wildcard,
    ACTIONS(1702), 1,
      sym_number,
    STATE(2296), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1746), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [31817] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(541), 5,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(543), 10,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [31843] = 12,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1442), 1,
      anon_sym_DOT,
    ACTIONS(1444), 1,
      anon_sym_LBRACK,
    ACTIONS(1446), 1,
      anon_sym_EQ,
    ACTIONS(1448), 1,
      anon_sym_LPAREN,
    ACTIONS(1450), 1,
      anon_sym_match,
    ACTIONS(1704), 1,
      anon_sym_else,
    STATE(698), 1,
      sym_arguments,
    STATE(930), 1,
      sym_type_arguments,
    ACTIONS(1440), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(303), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(305), 3,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
  [31885] = 7,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(531), 1,
      sym__simple_string,
    ACTIONS(533), 1,
      sym__string_start,
    ACTIONS(535), 1,
      sym__multiline_string_start,
    STATE(1204), 1,
      sym_string,
    ACTIONS(189), 5,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(191), 7,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [31917] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1590), 1,
      sym__simple_string,
    ACTIONS(1592), 1,
      sym__string_start,
    ACTIONS(1594), 1,
      sym__multiline_string_start,
    ACTIONS(1706), 1,
      sym_identifier,
    ACTIONS(1708), 1,
      sym_wildcard,
    ACTIONS(1710), 1,
      sym_number,
    STATE(2296), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1760), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [31957] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1590), 1,
      sym__simple_string,
    ACTIONS(1592), 1,
      sym__string_start,
    ACTIONS(1594), 1,
      sym__multiline_string_start,
    ACTIONS(1712), 1,
      sym_identifier,
    ACTIONS(1714), 1,
      sym_wildcard,
    ACTIONS(1716), 1,
      sym_number,
    STATE(2296), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1762), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [31997] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1590), 1,
      sym__simple_string,
    ACTIONS(1592), 1,
      sym__string_start,
    ACTIONS(1594), 1,
      sym__multiline_string_start,
    ACTIONS(1718), 1,
      sym_identifier,
    ACTIONS(1720), 1,
      sym_wildcard,
    ACTIONS(1722), 1,
      sym_number,
    STATE(2296), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1761), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [32037] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1590), 1,
      sym__simple_string,
    ACTIONS(1592), 1,
      sym__string_start,
    ACTIONS(1594), 1,
      sym__multiline_string_start,
    ACTIONS(1724), 1,
      sym_identifier,
    ACTIONS(1726), 1,
      sym_wildcard,
    ACTIONS(1728), 1,
      sym_number,
    STATE(2296), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1752), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [32077] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1590), 1,
      sym__simple_string,
    ACTIONS(1592), 1,
      sym__string_start,
    ACTIONS(1594), 1,
      sym__multiline_string_start,
    ACTIONS(1730), 1,
      sym_identifier,
    ACTIONS(1732), 1,
      sym_wildcard,
    ACTIONS(1734), 1,
      sym_number,
    STATE(2296), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1735), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [32117] = 5,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    ACTIONS(185), 1,
      sym_comment,
    STATE(1062), 2,
      sym_block,
      sym_case_block,
    ACTIONS(231), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(233), 7,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [32145] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1590), 1,
      sym__simple_string,
    ACTIONS(1592), 1,
      sym__string_start,
    ACTIONS(1594), 1,
      sym__multiline_string_start,
    ACTIONS(1736), 1,
      sym_identifier,
    ACTIONS(1738), 1,
      sym_wildcard,
    ACTIONS(1740), 1,
      sym_number,
    STATE(2296), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1727), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [32185] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1475), 1,
      sym__simple_string,
    ACTIONS(1477), 1,
      sym__string_start,
    ACTIONS(1479), 1,
      sym__multiline_string_start,
    ACTIONS(1742), 1,
      sym_identifier,
    ACTIONS(1744), 1,
      sym_wildcard,
    ACTIONS(1746), 1,
      sym_number,
    STATE(2312), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1713), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [32225] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1442), 1,
      anon_sym_DOT,
    ACTIONS(1444), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_LPAREN,
    STATE(698), 1,
      sym_arguments,
    STATE(930), 1,
      sym_type_arguments,
    ACTIONS(273), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(275), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [32259] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1608), 1,
      anon_sym_LBRACK,
    ACTIONS(1612), 1,
      anon_sym_POUND,
    ACTIONS(1748), 1,
      anon_sym_LPAREN,
    STATE(1086), 1,
      sym_type_arguments,
    STATE(1083), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(215), 4,
      sym__automatic_semicolon,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(217), 6,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_AT,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [32293] = 10,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1442), 1,
      anon_sym_DOT,
    ACTIONS(1444), 1,
      anon_sym_LBRACK,
    ACTIONS(1446), 1,
      anon_sym_EQ,
    ACTIONS(1448), 1,
      anon_sym_LPAREN,
    STATE(698), 1,
      sym_arguments,
    STATE(930), 1,
      sym_type_arguments,
    ACTIONS(1440), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(269), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(271), 5,
      anon_sym_case,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
  [32331] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1475), 1,
      sym__simple_string,
    ACTIONS(1477), 1,
      sym__string_start,
    ACTIONS(1479), 1,
      sym__multiline_string_start,
    ACTIONS(1750), 1,
      sym_identifier,
    ACTIONS(1752), 1,
      sym_wildcard,
    ACTIONS(1754), 1,
      sym_number,
    STATE(2312), 1,
      sym_stable_type_identifier,
    STATE(2323), 1,
      sym_stable_identifier,
    STATE(1645), 7,
      sym_case_class_pattern,
      sym_infix_pattern,
      sym_capture_pattern,
      sym_typed_pattern,
      sym_alternative_pattern,
      sym_tuple_pattern,
      sym_string,
  [32371] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1574), 1,
      anon_sym_LBRACK,
    ACTIONS(1578), 1,
      anon_sym_POUND,
    ACTIONS(1756), 1,
      anon_sym_AT,
    STATE(1039), 1,
      sym_type_arguments,
    ACTIONS(355), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(1202), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(357), 7,
      anon_sym_EQ_GT,
      anon_sym_COLON,
      anon_sym_with,
      anon_sym_PIPE,
      anon_sym_if,
      sym_identifier,
      sym_operator_identifier,
  [32404] = 10,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1532), 1,
      anon_sym_DOT,
    ACTIONS(1534), 1,
      anon_sym_LBRACK,
    ACTIONS(1536), 1,
      anon_sym_EQ,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(743), 1,
      sym_arguments,
    STATE(1102), 1,
      sym_type_arguments,
    ACTIONS(1530), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(269), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(271), 4,
      anon_sym_case,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
  [32441] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1532), 1,
      anon_sym_DOT,
    ACTIONS(1534), 1,
      anon_sym_LBRACK,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(743), 1,
      sym_arguments,
    STATE(1102), 1,
      sym_type_arguments,
    ACTIONS(273), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(275), 7,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [32474] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(541), 6,
      sym__automatic_semicolon,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(543), 8,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [32499] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(557), 7,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(559), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [32522] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    STATE(1222), 2,
      sym_block,
      sym_case_block,
    ACTIONS(231), 5,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(233), 7,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [32549] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(579), 5,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(581), 10,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [32572] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(549), 7,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(551), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [32595] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1454), 1,
      anon_sym_finally,
    STATE(906), 1,
      sym_finally_clause,
    ACTIONS(537), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(539), 7,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      sym_identifier,
      sym_operator_identifier,
  [32622] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(575), 5,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(577), 10,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [32645] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1758), 1,
      anon_sym_DOT,
    ACTIONS(509), 6,
      sym__automatic_semicolon,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(511), 8,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [32670] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(766), 1,
      aux_sym_modifiers_repeat1,
    ACTIONS(1760), 6,
      anon_sym_case,
      anon_sym_class,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
    ACTIONS(1762), 8,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [32695] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(641), 5,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(643), 10,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [32718] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1764), 1,
      anon_sym_LPAREN,
    STATE(763), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(645), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(647), 9,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [32745] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(656), 5,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(658), 10,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [32768] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1532), 1,
      anon_sym_DOT,
    ACTIONS(1534), 1,
      anon_sym_LBRACK,
    ACTIONS(1536), 1,
      anon_sym_EQ,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    ACTIONS(1540), 1,
      anon_sym_match,
    STATE(743), 1,
      sym_arguments,
    STATE(1102), 1,
      sym_type_arguments,
    ACTIONS(1530), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(285), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(287), 3,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
  [32807] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(766), 1,
      aux_sym_modifiers_repeat1,
    ACTIONS(1767), 6,
      anon_sym_case,
      anon_sym_class,
      anon_sym_val,
      anon_sym_var,
      anon_sym_type,
      anon_sym_def,
    ACTIONS(1769), 8,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_sealed,
      anon_sym_implicit,
      anon_sym_lazy,
      anon_sym_override,
      anon_sym_private,
      anon_sym_protected,
  [32832] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(662), 5,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(664), 10,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [32855] = 14,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1774), 1,
      anon_sym_DOT,
    ACTIONS(1776), 1,
      anon_sym_LBRACK,
    ACTIONS(1778), 1,
      anon_sym_EQ,
    ACTIONS(1780), 1,
      anon_sym_LPAREN,
    ACTIONS(1782), 1,
      anon_sym_match,
    ACTIONS(1784), 1,
      anon_sym_catch,
    ACTIONS(1786), 1,
      anon_sym_finally,
    STATE(795), 1,
      sym_arguments,
    STATE(1178), 1,
      sym_catch_clause,
    STATE(1293), 1,
      sym_finally_clause,
    STATE(1351), 1,
      sym_type_arguments,
    ACTIONS(165), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1772), 2,
      sym_identifier,
      sym_operator_identifier,
  [32900] = 7,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym__simple_string,
    ACTIONS(475), 1,
      sym__string_start,
    ACTIONS(477), 1,
      sym__multiline_string_start,
    STATE(1354), 1,
      sym_string,
    ACTIONS(189), 3,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(191), 8,
      anon_sym_EQ_GT,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [32931] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1788), 1,
      anon_sym_LBRACK,
    ACTIONS(1790), 1,
      anon_sym_LPAREN,
    ACTIONS(1792), 1,
      anon_sym_POUND,
    STATE(1126), 1,
      sym_type_arguments,
    ACTIONS(215), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    STATE(1124), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(217), 7,
      anon_sym_EQ_GT,
      anon_sym_LT_PERCENT,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [32964] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(553), 7,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(555), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [32987] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1458), 1,
      anon_sym_LPAREN,
    STATE(763), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(615), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(617), 9,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [33014] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(674), 5,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(676), 10,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [33037] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1532), 1,
      anon_sym_DOT,
    ACTIONS(1534), 1,
      anon_sym_LBRACK,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(743), 1,
      sym_arguments,
    STATE(1102), 1,
      sym_type_arguments,
    ACTIONS(277), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(279), 7,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [33070] = 14,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1796), 1,
      anon_sym_DOT,
    ACTIONS(1798), 1,
      anon_sym_LBRACK,
    ACTIONS(1800), 1,
      anon_sym_EQ,
    ACTIONS(1802), 1,
      anon_sym_LPAREN,
    ACTIONS(1804), 1,
      anon_sym_match,
    ACTIONS(1806), 1,
      anon_sym_catch,
    ACTIONS(1808), 1,
      anon_sym_finally,
    STATE(823), 1,
      sym_arguments,
    STATE(1174), 1,
      sym_catch_clause,
    STATE(1303), 1,
      sym_finally_clause,
    STATE(1330), 1,
      sym_type_arguments,
    ACTIONS(169), 2,
      anon_sym_EQ_GT,
      anon_sym_else,
    ACTIONS(1794), 2,
      sym_identifier,
      sym_operator_identifier,
  [33115] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1810), 1,
      anon_sym_LBRACK,
    ACTIONS(1812), 1,
      anon_sym_LPAREN,
    ACTIONS(1814), 1,
      anon_sym_POUND,
    STATE(1134), 1,
      sym_type_arguments,
    ACTIONS(215), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(1133), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(217), 7,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_STAR,
      sym_identifier,
      sym_operator_identifier,
  [33148] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1532), 1,
      anon_sym_DOT,
    ACTIONS(1534), 1,
      anon_sym_LBRACK,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(743), 1,
      sym_arguments,
    STATE(1102), 1,
      sym_type_arguments,
    ACTIONS(265), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(267), 7,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [33181] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1532), 1,
      anon_sym_DOT,
    ACTIONS(1534), 1,
      anon_sym_LBRACK,
    ACTIONS(1536), 1,
      anon_sym_EQ,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    ACTIONS(1540), 1,
      anon_sym_match,
    STATE(743), 1,
      sym_arguments,
    STATE(1102), 1,
      sym_type_arguments,
    ACTIONS(1530), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(281), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(283), 3,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
  [33220] = 7,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(257), 1,
      sym__simple_string,
    ACTIONS(259), 1,
      sym__string_start,
    ACTIONS(261), 1,
      sym__multiline_string_start,
    STATE(1363), 1,
      sym_string,
    ACTIONS(189), 5,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(191), 6,
      anon_sym_EQ,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [33251] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1620), 1,
      anon_sym_LBRACK,
    ACTIONS(1624), 1,
      anon_sym_POUND,
    ACTIONS(1816), 1,
      anon_sym_AT,
    STATE(1015), 1,
      sym_type_arguments,
    ACTIONS(355), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    STATE(1172), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(357), 7,
      anon_sym_EQ_GT,
      anon_sym_GT_COLON,
      anon_sym_LT_PERCENT,
      anon_sym_COLON,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [33284] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1634), 1,
      anon_sym_DOT,
    ACTIONS(1636), 1,
      anon_sym_LBRACK,
    ACTIONS(1640), 1,
      anon_sym_LPAREN,
    STATE(755), 1,
      sym_arguments,
    STATE(1207), 1,
      sym_type_arguments,
    ACTIONS(265), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(267), 7,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [33316] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(662), 6,
      sym__automatic_semicolon,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(664), 8,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [33338] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1818), 1,
      sym_identifier,
    ACTIONS(1820), 1,
      anon_sym_LPAREN,
    STATE(1586), 1,
      sym__annotated_type,
    STATE(2350), 1,
      sym_parameter_types,
    STATE(2353), 1,
      sym_stable_identifier,
    STATE(1646), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2011), 2,
      sym__type,
      sym_function_type,
    STATE(1064), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [33372] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1818), 1,
      sym_identifier,
    ACTIONS(1820), 1,
      anon_sym_LPAREN,
    STATE(1586), 1,
      sym__annotated_type,
    STATE(2350), 1,
      sym_parameter_types,
    STATE(2353), 1,
      sym_stable_identifier,
    STATE(1646), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2026), 2,
      sym__type,
      sym_function_type,
    STATE(1064), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [33406] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1822), 1,
      sym_identifier,
    ACTIONS(1824), 1,
      anon_sym_LPAREN,
    STATE(465), 1,
      sym__annotated_type,
    STATE(2272), 1,
      sym_stable_identifier,
    STATE(2295), 1,
      sym_parameter_types,
    STATE(267), 2,
      sym__type,
      sym_function_type,
    STATE(512), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(94), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [33440] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1826), 1,
      sym_identifier,
    ACTIONS(1828), 1,
      anon_sym_LPAREN,
    STATE(1314), 1,
      sym__annotated_type,
    STATE(2374), 1,
      sym_parameter_types,
    STATE(2377), 1,
      sym_stable_identifier,
    STATE(1505), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1640), 2,
      sym__type,
      sym_function_type,
    STATE(712), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [33474] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(583), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(585), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [33496] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1830), 1,
      sym_identifier,
    ACTIONS(1832), 1,
      anon_sym_LPAREN,
    STATE(1367), 1,
      sym__annotated_type,
    STATE(2364), 1,
      sym_parameter_types,
    STATE(2367), 1,
      sym_stable_identifier,
    STATE(1521), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1891), 2,
      sym__type,
      sym_function_type,
    STATE(718), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [33530] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2044), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [33564] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2062), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [33598] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(267), 2,
      sym__type,
      sym_function_type,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [33632] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(541), 4,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
    ACTIONS(543), 9,
      anon_sym_EQ_GT,
      anon_sym_GT_COLON,
      anon_sym_LT_PERCENT,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [33656] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2075), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [33690] = 7,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(435), 1,
      sym__simple_string,
    ACTIONS(437), 1,
      sym__string_start,
    ACTIONS(439), 1,
      sym__multiline_string_start,
    STATE(1417), 1,
      sym_string,
    ACTIONS(189), 3,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(191), 7,
      anon_sym_EQ_GT,
      anon_sym_EQ,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [33720] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    STATE(1269), 2,
      sym_block,
      sym_case_block,
    ACTIONS(231), 5,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(233), 6,
      anon_sym_EQ,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [33746] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2092), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [33780] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2106), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [33814] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1788), 1,
      anon_sym_LBRACK,
    ACTIONS(1792), 1,
      anon_sym_POUND,
    ACTIONS(1838), 1,
      anon_sym_AT,
    STATE(1126), 1,
      sym_type_arguments,
    ACTIONS(355), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    STATE(1350), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(357), 6,
      anon_sym_EQ_GT,
      anon_sym_LT_PERCENT,
      anon_sym_COLON,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [33846] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(553), 7,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(555), 7,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [33868] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1822), 1,
      sym_identifier,
    ACTIONS(1824), 1,
      anon_sym_LPAREN,
    STATE(465), 1,
      sym__annotated_type,
    STATE(2272), 1,
      sym_stable_identifier,
    STATE(2295), 1,
      sym_parameter_types,
    STATE(512), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(599), 2,
      sym__type,
      sym_function_type,
    STATE(94), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [33902] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2125), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [33936] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1840), 1,
      sym_identifier,
    ACTIONS(1842), 1,
      anon_sym_LPAREN,
    STATE(1180), 1,
      sym__annotated_type,
    STATE(2369), 1,
      sym_parameter_types,
    STATE(2372), 1,
      sym_stable_identifier,
    STATE(1459), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1470), 2,
      sym__type,
      sym_function_type,
    STATE(691), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [33970] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1844), 1,
      sym_identifier,
    ACTIONS(1846), 1,
      anon_sym_LPAREN,
    STATE(1557), 1,
      sym__annotated_type,
    STATE(2297), 1,
      sym_parameter_types,
    STATE(2302), 1,
      sym_stable_identifier,
    STATE(1698), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1754), 2,
      sym__type,
      sym_function_type,
    STATE(1114), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34004] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1840), 1,
      sym_identifier,
    ACTIONS(1842), 1,
      anon_sym_LPAREN,
    STATE(1180), 1,
      sym__annotated_type,
    STATE(2369), 1,
      sym_parameter_types,
    STATE(2372), 1,
      sym_stable_identifier,
    STATE(1459), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1485), 2,
      sym__type,
      sym_function_type,
    STATE(691), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34038] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2023), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34072] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1830), 1,
      sym_identifier,
    ACTIONS(1832), 1,
      anon_sym_LPAREN,
    STATE(1367), 1,
      sym__annotated_type,
    STATE(2364), 1,
      sym_parameter_types,
    STATE(2367), 1,
      sym_stable_identifier,
    STATE(1521), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1866), 2,
      sym__type,
      sym_function_type,
    STATE(718), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34106] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1848), 1,
      anon_sym_DOT,
    ACTIONS(509), 4,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
    ACTIONS(511), 9,
      anon_sym_EQ_GT,
      anon_sym_GT_COLON,
      anon_sym_LT_PERCENT,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [34130] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2173), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34164] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2168), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34198] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1990), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34232] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2163), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34266] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2158), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34300] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1830), 1,
      sym_identifier,
    ACTIONS(1832), 1,
      anon_sym_LPAREN,
    STATE(1367), 1,
      sym__annotated_type,
    STATE(2364), 1,
      sym_parameter_types,
    STATE(2367), 1,
      sym_stable_identifier,
    STATE(1521), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1863), 2,
      sym__type,
      sym_function_type,
    STATE(718), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34334] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1830), 1,
      sym_identifier,
    ACTIONS(1832), 1,
      anon_sym_LPAREN,
    STATE(1367), 1,
      sym__annotated_type,
    STATE(2364), 1,
      sym_parameter_types,
    STATE(2367), 1,
      sym_stable_identifier,
    STATE(1521), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1862), 2,
      sym__type,
      sym_function_type,
    STATE(718), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34368] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1850), 1,
      sym_identifier,
    ACTIONS(1852), 1,
      anon_sym_LPAREN,
    STATE(409), 1,
      sym__annotated_type,
    STATE(2288), 1,
      sym_parameter_types,
    STATE(2293), 1,
      sym_stable_identifier,
    STATE(496), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(515), 2,
      sym__type,
      sym_function_type,
    STATE(70), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34402] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2011), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34436] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2154), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34470] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1830), 1,
      sym_identifier,
    ACTIONS(1832), 1,
      anon_sym_LPAREN,
    STATE(1367), 1,
      sym__annotated_type,
    STATE(2364), 1,
      sym_parameter_types,
    STATE(2367), 1,
      sym_stable_identifier,
    STATE(1521), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1631), 2,
      sym__type,
      sym_function_type,
    STATE(718), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34504] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(623), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(625), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [34526] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1854), 1,
      sym_identifier,
    ACTIONS(1856), 1,
      anon_sym_LPAREN,
    STATE(1596), 1,
      sym__annotated_type,
    STATE(2320), 1,
      sym_stable_identifier,
    STATE(2378), 1,
      sym_parameter_types,
    STATE(1653), 2,
      sym__type,
      sym_function_type,
    STATE(1703), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(750), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34560] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2149), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34594] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1826), 1,
      sym_identifier,
    ACTIONS(1828), 1,
      anon_sym_LPAREN,
    STATE(1314), 1,
      sym__annotated_type,
    STATE(2374), 1,
      sym_parameter_types,
    STATE(2377), 1,
      sym_stable_identifier,
    STATE(1505), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1617), 2,
      sym__type,
      sym_function_type,
    STATE(712), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34628] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_LBRACE,
    STATE(1282), 2,
      sym_block,
      sym_case_block,
    ACTIONS(231), 3,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
    ACTIONS(233), 8,
      anon_sym_EQ_GT,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [34654] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1826), 1,
      sym_identifier,
    ACTIONS(1828), 1,
      anon_sym_LPAREN,
    STATE(1314), 1,
      sym__annotated_type,
    STATE(2374), 1,
      sym_parameter_types,
    STATE(2377), 1,
      sym_stable_identifier,
    STATE(1505), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1618), 2,
      sym__type,
      sym_function_type,
    STATE(712), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34688] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1844), 1,
      sym_identifier,
    ACTIONS(1846), 1,
      anon_sym_LPAREN,
    STATE(1557), 1,
      sym__annotated_type,
    STATE(2297), 1,
      sym_parameter_types,
    STATE(2302), 1,
      sym_stable_identifier,
    STATE(1698), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1778), 2,
      sym__type,
      sym_function_type,
    STATE(1114), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34722] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1840), 1,
      sym_identifier,
    ACTIONS(1842), 1,
      anon_sym_LPAREN,
    STATE(1180), 1,
      sym__annotated_type,
    STATE(2369), 1,
      sym_parameter_types,
    STATE(2372), 1,
      sym_stable_identifier,
    STATE(1459), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1510), 2,
      sym__type,
      sym_function_type,
    STATE(691), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34756] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    STATE(1592), 1,
      sym__annotated_type,
    STATE(2277), 1,
      sym_parameter_types,
    STATE(2284), 1,
      sym_stable_identifier,
    STATE(267), 2,
      sym__type,
      sym_function_type,
    STATE(1697), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1008), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34790] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2144), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34824] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1840), 1,
      sym_identifier,
    ACTIONS(1842), 1,
      anon_sym_LPAREN,
    STATE(1180), 1,
      sym__annotated_type,
    STATE(2369), 1,
      sym_parameter_types,
    STATE(2372), 1,
      sym_stable_identifier,
    STATE(1459), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1508), 2,
      sym__type,
      sym_function_type,
    STATE(691), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34858] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1858), 1,
      sym_identifier,
    ACTIONS(1860), 1,
      anon_sym_LPAREN,
    STATE(491), 1,
      sym__annotated_type,
    STATE(2306), 1,
      sym_parameter_types,
    STATE(2311), 1,
      sym_stable_identifier,
    STATE(508), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(525), 2,
      sym__type,
      sym_function_type,
    STATE(212), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34892] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1822), 1,
      sym_identifier,
    ACTIONS(1824), 1,
      anon_sym_LPAREN,
    STATE(465), 1,
      sym__annotated_type,
    STATE(2272), 1,
      sym_stable_identifier,
    STATE(2295), 1,
      sym_parameter_types,
    STATE(512), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(617), 2,
      sym__type,
      sym_function_type,
    STATE(94), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34926] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2138), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [34960] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(627), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(629), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [34982] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(1864), 1,
      anon_sym_LT_COLON,
    ACTIONS(1866), 1,
      anon_sym_GT_COLON,
    ACTIONS(1868), 1,
      anon_sym_LT_PERCENT,
    ACTIONS(1870), 1,
      anon_sym_COLON,
    STATE(1201), 1,
      sym_type_parameters,
    STATE(1387), 1,
      sym_upper_bound,
    STATE(1580), 1,
      sym_lower_bound,
    ACTIONS(1862), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    STATE(1578), 2,
      sym_view_bound,
      aux_sym__type_parameter_repeat1,
    STATE(1769), 2,
      sym_context_bound,
      aux_sym__type_parameter_repeat2,
  [35022] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1830), 1,
      sym_identifier,
    ACTIONS(1832), 1,
      anon_sym_LPAREN,
    STATE(1367), 1,
      sym__annotated_type,
    STATE(2364), 1,
      sym_parameter_types,
    STATE(2367), 1,
      sym_stable_identifier,
    STATE(1521), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1838), 2,
      sym__type,
      sym_function_type,
    STATE(718), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35056] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(541), 4,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(543), 9,
      anon_sym_EQ_GT,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      anon_sym_if,
      sym_identifier,
      sym_operator_identifier,
  [35080] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1822), 1,
      sym_identifier,
    ACTIONS(1824), 1,
      anon_sym_LPAREN,
    STATE(465), 1,
      sym__annotated_type,
    STATE(2272), 1,
      sym_stable_identifier,
    STATE(2295), 1,
      sym_parameter_types,
    STATE(512), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(611), 2,
      sym__type,
      sym_function_type,
    STATE(94), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35114] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(631), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(633), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [35136] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1858), 1,
      sym_identifier,
    ACTIONS(1860), 1,
      anon_sym_LPAREN,
    STATE(491), 1,
      sym__annotated_type,
    STATE(2306), 1,
      sym_parameter_types,
    STATE(2311), 1,
      sym_stable_identifier,
    STATE(508), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(530), 2,
      sym__type,
      sym_function_type,
    STATE(212), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35170] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1872), 1,
      anon_sym_DOT,
    ACTIONS(509), 4,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(511), 9,
      anon_sym_EQ_GT,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      anon_sym_if,
      sym_identifier,
      sym_operator_identifier,
  [35194] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2129), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35228] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1858), 1,
      sym_identifier,
    ACTIONS(1860), 1,
      anon_sym_LPAREN,
    STATE(491), 1,
      sym__annotated_type,
    STATE(2306), 1,
      sym_parameter_types,
    STATE(2311), 1,
      sym_stable_identifier,
    STATE(508), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(524), 2,
      sym__type,
      sym_function_type,
    STATE(212), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35262] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1850), 1,
      sym_identifier,
    ACTIONS(1852), 1,
      anon_sym_LPAREN,
    STATE(409), 1,
      sym__annotated_type,
    STATE(2288), 1,
      sym_parameter_types,
    STATE(2293), 1,
      sym_stable_identifier,
    STATE(496), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(514), 2,
      sym__type,
      sym_function_type,
    STATE(70), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35296] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1858), 1,
      sym_identifier,
    ACTIONS(1860), 1,
      anon_sym_LPAREN,
    STATE(491), 1,
      sym__annotated_type,
    STATE(2306), 1,
      sym_parameter_types,
    STATE(2311), 1,
      sym_stable_identifier,
    STATE(267), 2,
      sym__type,
      sym_function_type,
    STATE(508), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(212), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35330] = 12,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1634), 1,
      anon_sym_DOT,
    ACTIONS(1636), 1,
      anon_sym_LBRACK,
    ACTIONS(1638), 1,
      anon_sym_EQ,
    ACTIONS(1640), 1,
      anon_sym_LPAREN,
    ACTIONS(1642), 1,
      anon_sym_match,
    ACTIONS(1874), 1,
      anon_sym_else,
    STATE(755), 1,
      sym_arguments,
    STATE(1207), 1,
      sym_type_arguments,
    ACTIONS(303), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(305), 2,
      anon_sym_catch,
      anon_sym_finally,
    ACTIONS(1632), 2,
      sym_identifier,
      sym_operator_identifier,
  [35370] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2121), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35404] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1844), 1,
      sym_identifier,
    ACTIONS(1846), 1,
      anon_sym_LPAREN,
    STATE(1557), 1,
      sym__annotated_type,
    STATE(2297), 1,
      sym_parameter_types,
    STATE(2302), 1,
      sym_stable_identifier,
    STATE(1698), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1789), 2,
      sym__type,
      sym_function_type,
    STATE(1114), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35438] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1850), 1,
      sym_identifier,
    ACTIONS(1852), 1,
      anon_sym_LPAREN,
    STATE(409), 1,
      sym__annotated_type,
    STATE(2288), 1,
      sym_parameter_types,
    STATE(2293), 1,
      sym_stable_identifier,
    STATE(496), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(510), 2,
      sym__type,
      sym_function_type,
    STATE(70), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35472] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1844), 1,
      sym_identifier,
    ACTIONS(1846), 1,
      anon_sym_LPAREN,
    STATE(1557), 1,
      sym__annotated_type,
    STATE(2297), 1,
      sym_parameter_types,
    STATE(2302), 1,
      sym_stable_identifier,
    STATE(1698), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1767), 2,
      sym__type,
      sym_function_type,
    STATE(1114), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35506] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1822), 1,
      sym_identifier,
    ACTIONS(1824), 1,
      anon_sym_LPAREN,
    STATE(465), 1,
      sym__annotated_type,
    STATE(2272), 1,
      sym_stable_identifier,
    STATE(2295), 1,
      sym_parameter_types,
    STATE(512), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(633), 2,
      sym__type,
      sym_function_type,
    STATE(94), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35540] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1858), 1,
      sym_identifier,
    ACTIONS(1860), 1,
      anon_sym_LPAREN,
    STATE(491), 1,
      sym__annotated_type,
    STATE(2306), 1,
      sym_parameter_types,
    STATE(2311), 1,
      sym_stable_identifier,
    STATE(508), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(535), 2,
      sym__type,
      sym_function_type,
    STATE(212), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35574] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1544), 1,
      anon_sym_finally,
    STATE(1105), 1,
      sym_finally_clause,
    ACTIONS(537), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(539), 6,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_match,
      anon_sym_catch,
      sym_identifier,
      sym_operator_identifier,
  [35600] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1876), 1,
      anon_sym_LBRACK,
    ACTIONS(1878), 1,
      anon_sym_LPAREN,
    ACTIONS(1880), 1,
      anon_sym_POUND,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(215), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    STATE(1251), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(217), 6,
      anon_sym_EQ_GT,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [35632] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1854), 1,
      sym_identifier,
    ACTIONS(1856), 1,
      anon_sym_LPAREN,
    STATE(1479), 1,
      sym__annotated_type,
    STATE(2315), 1,
      sym_parameter_types,
    STATE(2320), 1,
      sym_stable_identifier,
    STATE(1630), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1708), 2,
      sym__type,
      sym_function_type,
    STATE(750), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35666] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2110), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35700] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2102), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35734] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2091), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35768] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1826), 1,
      sym_identifier,
    ACTIONS(1828), 1,
      anon_sym_LPAREN,
    STATE(1314), 1,
      sym__annotated_type,
    STATE(2374), 1,
      sym_parameter_types,
    STATE(2377), 1,
      sym_stable_identifier,
    STATE(1505), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1622), 2,
      sym__type,
      sym_function_type,
    STATE(712), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35802] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2083), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35836] = 14,
    ACTIONS(169), 1,
      anon_sym_EQ_GT,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1884), 1,
      anon_sym_DOT,
    ACTIONS(1886), 1,
      anon_sym_LBRACK,
    ACTIONS(1888), 1,
      anon_sym_EQ,
    ACTIONS(1890), 1,
      anon_sym_LPAREN,
    ACTIONS(1892), 1,
      anon_sym_match,
    ACTIONS(1894), 1,
      anon_sym_catch,
    ACTIONS(1896), 1,
      anon_sym_finally,
    STATE(1009), 1,
      sym_arguments,
    STATE(1365), 1,
      sym_catch_clause,
    STATE(1395), 1,
      sym_finally_clause,
    STATE(1423), 1,
      sym_type_arguments,
    ACTIONS(1882), 2,
      sym_identifier,
      sym_operator_identifier,
  [35880] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1826), 1,
      sym_identifier,
    ACTIONS(1828), 1,
      anon_sym_LPAREN,
    STATE(1314), 1,
      sym__annotated_type,
    STATE(2374), 1,
      sym_parameter_types,
    STATE(2377), 1,
      sym_stable_identifier,
    STATE(1505), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1629), 2,
      sym__type,
      sym_function_type,
    STATE(712), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35914] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2072), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35948] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1898), 1,
      sym_identifier,
    ACTIONS(1900), 1,
      anon_sym_LPAREN,
    STATE(1432), 1,
      sym__annotated_type,
    STATE(2324), 1,
      sym_parameter_types,
    STATE(2329), 1,
      sym_stable_identifier,
    STATE(267), 2,
      sym__type,
      sym_function_type,
    STATE(1579), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(780), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [35982] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(549), 7,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(551), 7,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [36004] = 13,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1532), 1,
      anon_sym_DOT,
    ACTIONS(1534), 1,
      anon_sym_LBRACK,
    ACTIONS(1536), 1,
      anon_sym_EQ,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    ACTIONS(1540), 1,
      anon_sym_match,
    ACTIONS(1902), 1,
      anon_sym_RBRACE,
    ACTIONS(1904), 1,
      anon_sym_case,
    STATE(743), 1,
      sym_arguments,
    STATE(1102), 1,
      sym_type_arguments,
    STATE(1766), 1,
      aux_sym__block_repeat1,
    ACTIONS(1530), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(1906), 2,
      sym__automatic_semicolon,
      anon_sym_SEMI,
  [36046] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1830), 1,
      sym_identifier,
    ACTIONS(1832), 1,
      anon_sym_LPAREN,
    STATE(1367), 1,
      sym__annotated_type,
    STATE(2364), 1,
      sym_parameter_types,
    STATE(2367), 1,
      sym_stable_identifier,
    STATE(1521), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1839), 2,
      sym__type,
      sym_function_type,
    STATE(718), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36080] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1822), 1,
      sym_identifier,
    ACTIONS(1824), 1,
      anon_sym_LPAREN,
    STATE(465), 1,
      sym__annotated_type,
    STATE(2272), 1,
      sym_stable_identifier,
    STATE(2295), 1,
      sym_parameter_types,
    STATE(512), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(613), 2,
      sym__type,
      sym_function_type,
    STATE(94), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36114] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1908), 1,
      sym_identifier,
    ACTIONS(1910), 1,
      anon_sym_LPAREN,
    STATE(1550), 1,
      sym__annotated_type,
    STATE(2342), 1,
      sym_parameter_types,
    STATE(2346), 1,
      sym_stable_identifier,
    STATE(1696), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2003), 2,
      sym__type,
      sym_function_type,
    STATE(1000), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36148] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1912), 1,
      sym_identifier,
    ACTIONS(1914), 1,
      anon_sym_LPAREN,
    STATE(1507), 1,
      sym__annotated_type,
    STATE(2333), 1,
      sym_parameter_types,
    STATE(2338), 1,
      sym_stable_identifier,
    STATE(1621), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1856), 2,
      sym__type,
      sym_function_type,
    STATE(798), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36182] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1634), 1,
      anon_sym_DOT,
    ACTIONS(1636), 1,
      anon_sym_LBRACK,
    ACTIONS(1638), 1,
      anon_sym_EQ,
    ACTIONS(1640), 1,
      anon_sym_LPAREN,
    ACTIONS(1642), 1,
      anon_sym_match,
    STATE(755), 1,
      sym_arguments,
    STATE(1207), 1,
      sym_type_arguments,
    ACTIONS(285), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1632), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(287), 3,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_finally,
  [36220] = 11,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1634), 1,
      anon_sym_DOT,
    ACTIONS(1636), 1,
      anon_sym_LBRACK,
    ACTIONS(1638), 1,
      anon_sym_EQ,
    ACTIONS(1640), 1,
      anon_sym_LPAREN,
    ACTIONS(1642), 1,
      anon_sym_match,
    STATE(755), 1,
      sym_arguments,
    STATE(1207), 1,
      sym_type_arguments,
    ACTIONS(281), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1632), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(283), 3,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_finally,
  [36258] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2058), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36292] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1912), 1,
      sym_identifier,
    ACTIONS(1914), 1,
      anon_sym_LPAREN,
    STATE(1507), 1,
      sym__annotated_type,
    STATE(2333), 1,
      sym_parameter_types,
    STATE(2338), 1,
      sym_stable_identifier,
    STATE(1621), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1857), 2,
      sym__type,
      sym_function_type,
    STATE(798), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36326] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1898), 1,
      sym_identifier,
    ACTIONS(1900), 1,
      anon_sym_LPAREN,
    STATE(1432), 1,
      sym__annotated_type,
    STATE(2324), 1,
      sym_parameter_types,
    STATE(2329), 1,
      sym_stable_identifier,
    STATE(1579), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1759), 2,
      sym__type,
      sym_function_type,
    STATE(780), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36360] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1634), 1,
      anon_sym_DOT,
    ACTIONS(1636), 1,
      anon_sym_LBRACK,
    ACTIONS(1640), 1,
      anon_sym_LPAREN,
    STATE(755), 1,
      sym_arguments,
    STATE(1207), 1,
      sym_type_arguments,
    ACTIONS(273), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(275), 7,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [36392] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2043), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36426] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2028), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36460] = 10,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1634), 1,
      anon_sym_DOT,
    ACTIONS(1636), 1,
      anon_sym_LBRACK,
    ACTIONS(1638), 1,
      anon_sym_EQ,
    ACTIONS(1640), 1,
      anon_sym_LPAREN,
    STATE(755), 1,
      sym_arguments,
    STATE(1207), 1,
      sym_type_arguments,
    ACTIONS(269), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1632), 2,
      sym_identifier,
      sym_operator_identifier,
    ACTIONS(271), 4,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
  [36496] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1818), 1,
      sym_identifier,
    ACTIONS(1820), 1,
      anon_sym_LPAREN,
    STATE(1586), 1,
      sym__annotated_type,
    STATE(2350), 1,
      sym_parameter_types,
    STATE(2353), 1,
      sym_stable_identifier,
    STATE(1646), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2118), 2,
      sym__type,
      sym_function_type,
    STATE(1064), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36530] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2013), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36564] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2032), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36598] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(666), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(668), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [36620] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1997), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36654] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1982), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36688] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1912), 1,
      sym_identifier,
    ACTIONS(1914), 1,
      anon_sym_LPAREN,
    STATE(1507), 1,
      sym__annotated_type,
    STATE(2333), 1,
      sym_parameter_types,
    STATE(2338), 1,
      sym_stable_identifier,
    STATE(267), 2,
      sym__type,
      sym_function_type,
    STATE(1621), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(798), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36722] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1966), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36756] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1951), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36790] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1935), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36824] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1858), 1,
      sym_identifier,
    ACTIONS(1860), 1,
      anon_sym_LPAREN,
    STATE(491), 1,
      sym__annotated_type,
    STATE(2306), 1,
      sym_parameter_types,
    STATE(2311), 1,
      sym_stable_identifier,
    STATE(508), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(532), 2,
      sym__type,
      sym_function_type,
    STATE(212), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36858] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1916), 1,
      anon_sym_LBRACK,
    ACTIONS(1918), 1,
      anon_sym_LPAREN,
    ACTIONS(1920), 1,
      anon_sym_POUND,
    STATE(1279), 1,
      sym_type_arguments,
    ACTIONS(215), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(1283), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(217), 6,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [36890] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1822), 1,
      sym_identifier,
    ACTIONS(1824), 1,
      anon_sym_LPAREN,
    STATE(465), 1,
      sym__annotated_type,
    STATE(2272), 1,
      sym_stable_identifier,
    STATE(2295), 1,
      sym_parameter_types,
    STATE(512), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(639), 2,
      sym__type,
      sym_function_type,
    STATE(94), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36924] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1844), 1,
      sym_identifier,
    ACTIONS(1846), 1,
      anon_sym_LPAREN,
    STATE(1557), 1,
      sym__annotated_type,
    STATE(2297), 1,
      sym_parameter_types,
    STATE(2302), 1,
      sym_stable_identifier,
    STATE(1698), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1785), 2,
      sym__type,
      sym_function_type,
    STATE(1114), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36958] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1920), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [36992] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1634), 1,
      anon_sym_DOT,
    ACTIONS(1636), 1,
      anon_sym_LBRACK,
    ACTIONS(1640), 1,
      anon_sym_LPAREN,
    STATE(755), 1,
      sym_arguments,
    STATE(1207), 1,
      sym_type_arguments,
    ACTIONS(277), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(279), 7,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [37024] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1850), 1,
      sym_identifier,
    ACTIONS(1852), 1,
      anon_sym_LPAREN,
    STATE(409), 1,
      sym__annotated_type,
    STATE(2288), 1,
      sym_parameter_types,
    STATE(2293), 1,
      sym_stable_identifier,
    STATE(496), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(504), 2,
      sym__type,
      sym_function_type,
    STATE(70), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37058] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1810), 1,
      anon_sym_LBRACK,
    ACTIONS(1814), 1,
      anon_sym_POUND,
    ACTIONS(1922), 1,
      anon_sym_AT,
    STATE(1134), 1,
      sym_type_arguments,
    ACTIONS(355), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(1300), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(357), 6,
      anon_sym_EQ_GT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_STAR,
      sym_identifier,
      sym_operator_identifier,
  [37090] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1948), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37124] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1908), 1,
      sym_identifier,
    ACTIONS(1910), 1,
      anon_sym_LPAREN,
    STATE(1550), 1,
      sym__annotated_type,
    STATE(2342), 1,
      sym_parameter_types,
    STATE(2346), 1,
      sym_stable_identifier,
    STATE(267), 2,
      sym__type,
      sym_function_type,
    STATE(1696), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1000), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37158] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1844), 1,
      sym_identifier,
    ACTIONS(1846), 1,
      anon_sym_LPAREN,
    STATE(1557), 1,
      sym__annotated_type,
    STATE(2297), 1,
      sym_parameter_types,
    STATE(2302), 1,
      sym_stable_identifier,
    STATE(1698), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1740), 2,
      sym__type,
      sym_function_type,
    STATE(1114), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37192] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1822), 1,
      sym_identifier,
    ACTIONS(1824), 1,
      anon_sym_LPAREN,
    STATE(465), 1,
      sym__annotated_type,
    STATE(2272), 1,
      sym_stable_identifier,
    STATE(2295), 1,
      sym_parameter_types,
    STATE(512), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(600), 2,
      sym__type,
      sym_function_type,
    STATE(94), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37226] = 7,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1924), 1,
      anon_sym_LBRACK,
    ACTIONS(1926), 1,
      anon_sym_LPAREN,
    ACTIONS(1928), 1,
      anon_sym_POUND,
    STATE(1275), 1,
      sym_type_arguments,
    STATE(1306), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(217), 8,
      anon_sym_EQ_GT,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [37256] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1822), 1,
      sym_identifier,
    ACTIONS(1824), 1,
      anon_sym_LPAREN,
    STATE(465), 1,
      sym__annotated_type,
    STATE(2272), 1,
      sym_stable_identifier,
    STATE(2295), 1,
      sym_parameter_types,
    STATE(512), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(608), 2,
      sym__type,
      sym_function_type,
    STATE(94), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37290] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(591), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(593), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [37312] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1965), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37346] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1830), 1,
      sym_identifier,
    ACTIONS(1832), 1,
      anon_sym_LPAREN,
    STATE(1367), 1,
      sym__annotated_type,
    STATE(2364), 1,
      sym_parameter_types,
    STATE(2367), 1,
      sym_stable_identifier,
    STATE(1521), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1843), 2,
      sym__type,
      sym_function_type,
    STATE(718), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37380] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(595), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(597), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [37402] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1822), 1,
      sym_identifier,
    ACTIONS(1824), 1,
      anon_sym_LPAREN,
    STATE(465), 1,
      sym__annotated_type,
    STATE(2272), 1,
      sym_stable_identifier,
    STATE(2295), 1,
      sym_parameter_types,
    STATE(512), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(609), 2,
      sym__type,
      sym_function_type,
    STATE(94), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37436] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(609), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(611), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [37458] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(605), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(607), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [37480] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(575), 6,
      sym__automatic_semicolon,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(577), 8,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [37502] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1980), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37536] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(637), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(639), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [37558] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1998), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37592] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1822), 1,
      sym_identifier,
    ACTIONS(1824), 1,
      anon_sym_LPAREN,
    STATE(465), 1,
      sym__annotated_type,
    STATE(2272), 1,
      sym_stable_identifier,
    STATE(2295), 1,
      sym_parameter_types,
    STATE(512), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(610), 2,
      sym__type,
      sym_function_type,
    STATE(94), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37626] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(652), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(654), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [37648] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(537), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(539), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [37670] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1858), 1,
      sym_identifier,
    ACTIONS(1860), 1,
      anon_sym_LPAREN,
    STATE(491), 1,
      sym__annotated_type,
    STATE(2306), 1,
      sym_parameter_types,
    STATE(2311), 1,
      sym_stable_identifier,
    STATE(508), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(537), 2,
      sym__type,
      sym_function_type,
    STATE(212), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37704] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(579), 6,
      sym__automatic_semicolon,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(581), 8,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [37726] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1822), 1,
      sym_identifier,
    ACTIONS(1824), 1,
      anon_sym_LPAREN,
    STATE(465), 1,
      sym__annotated_type,
    STATE(2272), 1,
      sym_stable_identifier,
    STATE(2295), 1,
      sym_parameter_types,
    STATE(512), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(607), 2,
      sym__type,
      sym_function_type,
    STATE(94), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37760] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1830), 1,
      sym_identifier,
    ACTIONS(1832), 1,
      anon_sym_LPAREN,
    STATE(1367), 1,
      sym__annotated_type,
    STATE(2364), 1,
      sym_parameter_types,
    STATE(2367), 1,
      sym_stable_identifier,
    STATE(1521), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1847), 2,
      sym__type,
      sym_function_type,
    STATE(718), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37794] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1858), 1,
      sym_identifier,
    ACTIONS(1860), 1,
      anon_sym_LPAREN,
    STATE(491), 1,
      sym__annotated_type,
    STATE(2306), 1,
      sym_parameter_types,
    STATE(2311), 1,
      sym_stable_identifier,
    STATE(508), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(538), 2,
      sym__type,
      sym_function_type,
    STATE(212), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37828] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1818), 1,
      sym_identifier,
    ACTIONS(1820), 1,
      anon_sym_LPAREN,
    STATE(1586), 1,
      sym__annotated_type,
    STATE(2350), 1,
      sym_parameter_types,
    STATE(2353), 1,
      sym_stable_identifier,
    STATE(267), 2,
      sym__type,
      sym_function_type,
    STATE(1646), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1064), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37862] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2033), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37896] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2057), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37930] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(678), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(680), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [37952] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1844), 1,
      sym_identifier,
    ACTIONS(1846), 1,
      anon_sym_LPAREN,
    STATE(1557), 1,
      sym__annotated_type,
    STATE(2297), 1,
      sym_parameter_types,
    STATE(2302), 1,
      sym_stable_identifier,
    STATE(1698), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1792), 2,
      sym__type,
      sym_function_type,
    STATE(1114), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [37986] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1844), 1,
      sym_identifier,
    ACTIONS(1846), 1,
      anon_sym_LPAREN,
    STATE(1557), 1,
      sym__annotated_type,
    STATE(2297), 1,
      sym_parameter_types,
    STATE(2302), 1,
      sym_stable_identifier,
    STATE(1698), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1788), 2,
      sym__type,
      sym_function_type,
    STATE(1114), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38020] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1854), 1,
      sym_identifier,
    ACTIONS(1856), 1,
      anon_sym_LPAREN,
    STATE(1479), 1,
      sym__annotated_type,
    STATE(2315), 1,
      sym_parameter_types,
    STATE(2320), 1,
      sym_stable_identifier,
    STATE(1630), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1715), 2,
      sym__type,
      sym_function_type,
    STATE(750), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38054] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1844), 1,
      sym_identifier,
    ACTIONS(1846), 1,
      anon_sym_LPAREN,
    STATE(1557), 1,
      sym__annotated_type,
    STATE(2297), 1,
      sym_parameter_types,
    STATE(2302), 1,
      sym_stable_identifier,
    STATE(1698), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1784), 2,
      sym__type,
      sym_function_type,
    STATE(1114), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38088] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(619), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(621), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [38110] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(670), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(672), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [38132] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1499), 1,
      sym_identifier,
    ACTIONS(1503), 1,
      anon_sym_LPAREN,
    STATE(1498), 1,
      sym__annotated_type,
    STATE(2357), 1,
      sym_parameter_types,
    STATE(2360), 1,
      sym_stable_identifier,
    STATE(267), 2,
      sym__type,
      sym_function_type,
    STATE(1605), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(896), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38166] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(587), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(589), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [38188] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1844), 1,
      sym_identifier,
    ACTIONS(1846), 1,
      anon_sym_LPAREN,
    STATE(1557), 1,
      sym__annotated_type,
    STATE(2297), 1,
      sym_parameter_types,
    STATE(2302), 1,
      sym_stable_identifier,
    STATE(1698), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1782), 2,
      sym__type,
      sym_function_type,
    STATE(1114), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38222] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(189), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(191), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [38244] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1850), 1,
      sym_identifier,
    ACTIONS(1852), 1,
      anon_sym_LPAREN,
    STATE(409), 1,
      sym__annotated_type,
    STATE(2288), 1,
      sym_parameter_types,
    STATE(2293), 1,
      sym_stable_identifier,
    STATE(496), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(506), 2,
      sym__type,
      sym_function_type,
    STATE(70), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38278] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1818), 1,
      sym_identifier,
    ACTIONS(1820), 1,
      anon_sym_LPAREN,
    STATE(1586), 1,
      sym__annotated_type,
    STATE(2350), 1,
      sym_parameter_types,
    STATE(2353), 1,
      sym_stable_identifier,
    STATE(1646), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2136), 2,
      sym__type,
      sym_function_type,
    STATE(1064), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38312] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1858), 1,
      sym_identifier,
    ACTIONS(1860), 1,
      anon_sym_LPAREN,
    STATE(491), 1,
      sym__annotated_type,
    STATE(2306), 1,
      sym_parameter_types,
    STATE(2311), 1,
      sym_stable_identifier,
    STATE(508), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(527), 2,
      sym__type,
      sym_function_type,
    STATE(212), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38346] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1844), 1,
      sym_identifier,
    ACTIONS(1846), 1,
      anon_sym_LPAREN,
    STATE(1557), 1,
      sym__annotated_type,
    STATE(2297), 1,
      sym_parameter_types,
    STATE(2302), 1,
      sym_stable_identifier,
    STATE(1698), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1747), 2,
      sym__type,
      sym_function_type,
    STATE(1114), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38380] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1826), 1,
      sym_identifier,
    ACTIONS(1828), 1,
      anon_sym_LPAREN,
    STATE(1314), 1,
      sym__annotated_type,
    STATE(2374), 1,
      sym_parameter_types,
    STATE(2377), 1,
      sym_stable_identifier,
    STATE(1505), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1633), 2,
      sym__type,
      sym_function_type,
    STATE(712), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38414] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1830), 1,
      sym_identifier,
    ACTIONS(1832), 1,
      anon_sym_LPAREN,
    STATE(1367), 1,
      sym__annotated_type,
    STATE(2364), 1,
      sym_parameter_types,
    STATE(2367), 1,
      sym_stable_identifier,
    STATE(1521), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1636), 2,
      sym__type,
      sym_function_type,
    STATE(718), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38448] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1844), 1,
      sym_identifier,
    ACTIONS(1846), 1,
      anon_sym_LPAREN,
    STATE(1557), 1,
      sym__annotated_type,
    STATE(2297), 1,
      sym_parameter_types,
    STATE(2302), 1,
      sym_stable_identifier,
    STATE(1698), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1743), 2,
      sym__type,
      sym_function_type,
    STATE(1114), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38482] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1858), 1,
      sym_identifier,
    ACTIONS(1860), 1,
      anon_sym_LPAREN,
    STATE(491), 1,
      sym__annotated_type,
    STATE(2306), 1,
      sym_parameter_types,
    STATE(2311), 1,
      sym_stable_identifier,
    STATE(508), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(529), 2,
      sym__type,
      sym_function_type,
    STATE(212), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38516] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1826), 1,
      sym_identifier,
    ACTIONS(1828), 1,
      anon_sym_LPAREN,
    STATE(1314), 1,
      sym__annotated_type,
    STATE(2374), 1,
      sym_parameter_types,
    STATE(2377), 1,
      sym_stable_identifier,
    STATE(1505), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1635), 2,
      sym__type,
      sym_function_type,
    STATE(712), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38550] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(601), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(603), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [38572] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(668), 4,
      anon_sym_if,
      anon_sym_try,
      anon_sym_new,
      sym_identifier,
    ACTIONS(666), 10,
      sym__simple_string,
      sym__string_start,
      sym__multiline_string_start,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      sym_number,
  [38594] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1840), 1,
      sym_identifier,
    ACTIONS(1842), 1,
      anon_sym_LPAREN,
    STATE(1180), 1,
      sym__annotated_type,
    STATE(2369), 1,
      sym_parameter_types,
    STATE(2372), 1,
      sym_stable_identifier,
    STATE(1459), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1495), 2,
      sym__type,
      sym_function_type,
    STATE(691), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38628] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2159), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38662] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1822), 1,
      sym_identifier,
    ACTIONS(1824), 1,
      anon_sym_LPAREN,
    STATE(465), 1,
      sym__annotated_type,
    STATE(2272), 1,
      sym_stable_identifier,
    STATE(2295), 1,
      sym_parameter_types,
    STATE(512), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(534), 2,
      sym__type,
      sym_function_type,
    STATE(94), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38696] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(579), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(581), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [38718] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(575), 6,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(577), 8,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_else,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [38740] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1930), 1,
      anon_sym_DOT,
    ACTIONS(509), 6,
      sym__automatic_semicolon,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(511), 7,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_AT,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [38764] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1932), 1,
      anon_sym_LBRACK,
    ACTIONS(1934), 1,
      anon_sym_LPAREN,
    ACTIONS(1936), 1,
      anon_sym_POUND,
    STATE(1266), 1,
      sym_type_arguments,
    STATE(1271), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(215), 3,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
    ACTIONS(217), 5,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [38796] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1826), 1,
      sym_identifier,
    ACTIONS(1828), 1,
      anon_sym_LPAREN,
    STATE(1314), 1,
      sym__annotated_type,
    STATE(2374), 1,
      sym_parameter_types,
    STATE(2377), 1,
      sym_stable_identifier,
    STATE(1505), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1636), 2,
      sym__type,
      sym_function_type,
    STATE(712), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38830] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1840), 1,
      sym_identifier,
    ACTIONS(1842), 1,
      anon_sym_LPAREN,
    STATE(1180), 1,
      sym__annotated_type,
    STATE(2369), 1,
      sym_parameter_types,
    STATE(2372), 1,
      sym_stable_identifier,
    STATE(1459), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1491), 2,
      sym__type,
      sym_function_type,
    STATE(691), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38864] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1481), 1,
      anon_sym_AT,
    STATE(969), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(782), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(784), 8,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [38890] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1854), 1,
      sym_identifier,
    ACTIONS(1856), 1,
      anon_sym_LPAREN,
    STATE(1596), 1,
      sym__annotated_type,
    STATE(2320), 1,
      sym_stable_identifier,
    STATE(2378), 1,
      sym_parameter_types,
    STATE(1650), 2,
      sym__type,
      sym_function_type,
    STATE(1703), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(750), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [38924] = 4,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(541), 6,
      sym__automatic_semicolon,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(543), 7,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_AT,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [38948] = 12,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1634), 1,
      anon_sym_DOT,
    ACTIONS(1636), 1,
      anon_sym_LBRACK,
    ACTIONS(1638), 1,
      anon_sym_EQ,
    ACTIONS(1640), 1,
      anon_sym_LPAREN,
    ACTIONS(1642), 1,
      anon_sym_match,
    ACTIONS(1938), 1,
      anon_sym_else,
    STATE(755), 1,
      sym_arguments,
    STATE(1207), 1,
      sym_type_arguments,
    ACTIONS(303), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(305), 2,
      anon_sym_catch,
      anon_sym_finally,
    ACTIONS(1632), 2,
      sym_identifier,
      sym_operator_identifier,
  [38988] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1840), 1,
      sym_identifier,
    ACTIONS(1842), 1,
      anon_sym_LPAREN,
    STATE(1180), 1,
      sym__annotated_type,
    STATE(2369), 1,
      sym_parameter_types,
    STATE(2372), 1,
      sym_stable_identifier,
    STATE(1459), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1489), 2,
      sym__type,
      sym_function_type,
    STATE(691), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39022] = 8,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1940), 1,
      anon_sym_LBRACK,
    ACTIONS(1942), 1,
      anon_sym_LPAREN,
    ACTIONS(1944), 1,
      anon_sym_POUND,
    STATE(1253), 1,
      sym_type_arguments,
    ACTIONS(215), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(1244), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(217), 6,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_with,
      anon_sym_STAR,
      sym_identifier,
      sym_operator_identifier,
  [39054] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(662), 4,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SEMI,
    ACTIONS(664), 10,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [39076] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1858), 1,
      sym_identifier,
    ACTIONS(1860), 1,
      anon_sym_LPAREN,
    STATE(491), 1,
      sym__annotated_type,
    STATE(2306), 1,
      sym_parameter_types,
    STATE(2311), 1,
      sym_stable_identifier,
    STATE(508), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(541), 2,
      sym__type,
      sym_function_type,
    STATE(212), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39110] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2041), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39144] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1826), 1,
      sym_identifier,
    ACTIONS(1828), 1,
      anon_sym_LPAREN,
    STATE(1314), 1,
      sym__annotated_type,
    STATE(2374), 1,
      sym_parameter_types,
    STATE(2377), 1,
      sym_stable_identifier,
    STATE(1505), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1619), 2,
      sym__type,
      sym_function_type,
    STATE(712), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39178] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 1,
      sym_identifier,
    ACTIONS(1836), 1,
      anon_sym_LPAREN,
    STATE(1600), 1,
      sym__annotated_type,
    STATE(2318), 1,
      sym_stable_identifier,
    STATE(2348), 1,
      sym_parameter_types,
    STATE(1663), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(2140), 2,
      sym__type,
      sym_function_type,
    STATE(1023), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39212] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1844), 1,
      sym_identifier,
    ACTIONS(1846), 1,
      anon_sym_LPAREN,
    STATE(1557), 1,
      sym__annotated_type,
    STATE(2297), 1,
      sym_parameter_types,
    STATE(2302), 1,
      sym_stable_identifier,
    STATE(1698), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1739), 2,
      sym__type,
      sym_function_type,
    STATE(1114), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39246] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1518), 1,
      anon_sym_LPAREN,
    STATE(981), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(615), 4,
      sym__automatic_semicolon,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(617), 7,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [39272] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1946), 1,
      anon_sym_AT,
    STATE(969), 2,
      sym_annotation,
      aux_sym_class_definition_repeat1,
    ACTIONS(700), 3,
      sym__automatic_semicolon,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(702), 8,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_PIPE,
      sym_identifier,
      sym_operator_identifier,
  [39298] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1830), 1,
      sym_identifier,
    ACTIONS(1832), 1,
      anon_sym_LPAREN,
    STATE(1367), 1,
      sym__annotated_type,
    STATE(2364), 1,
      sym_parameter_types,
    STATE(2367), 1,
      sym_stable_identifier,
    STATE(1521), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1876), 2,
      sym__type,
      sym_function_type,
    STATE(718), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39332] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1844), 1,
      sym_identifier,
    ACTIONS(1846), 1,
      anon_sym_LPAREN,
    STATE(1557), 1,
      sym__annotated_type,
    STATE(2297), 1,
      sym_parameter_types,
    STATE(2302), 1,
      sym_stable_identifier,
    STATE(1698), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1729), 2,
      sym__type,
      sym_function_type,
    STATE(1114), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39366] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(557), 7,
      sym__automatic_semicolon,
      anon_sym_DOT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(559), 7,
      anon_sym_case,
      anon_sym_EQ,
      anon_sym_match,
      anon_sym_catch,
      anon_sym_finally,
      sym_identifier,
      sym_operator_identifier,
  [39388] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1858), 1,
      sym_identifier,
    ACTIONS(1860), 1,
      anon_sym_LPAREN,
    STATE(491), 1,
      sym__annotated_type,
    STATE(2306), 1,
      sym_parameter_types,
    STATE(2311), 1,
      sym_stable_identifier,
    STATE(508), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(523), 2,
      sym__type,
      sym_function_type,
    STATE(212), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39422] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1850), 1,
      sym_identifier,
    ACTIONS(1852), 1,
      anon_sym_LPAREN,
    STATE(409), 1,
      sym__annotated_type,
    STATE(2288), 1,
      sym_parameter_types,
    STATE(2293), 1,
      sym_stable_identifier,
    STATE(496), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(511), 2,
      sym__type,
      sym_function_type,
    STATE(70), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39456] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(674), 6,
      sym__automatic_semicolon,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(676), 8,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [39478] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1830), 1,
      sym_identifier,
    ACTIONS(1832), 1,
      anon_sym_LPAREN,
    STATE(1367), 1,
      sym__annotated_type,
    STATE(2364), 1,
      sym_parameter_types,
    STATE(2367), 1,
      sym_stable_identifier,
    STATE(1521), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1889), 2,
      sym__type,
      sym_function_type,
    STATE(718), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39512] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1850), 1,
      sym_identifier,
    ACTIONS(1852), 1,
      anon_sym_LPAREN,
    STATE(409), 1,
      sym__annotated_type,
    STATE(2288), 1,
      sym_parameter_types,
    STATE(2293), 1,
      sym_stable_identifier,
    STATE(496), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(507), 2,
      sym__type,
      sym_function_type,
    STATE(70), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39546] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1830), 1,
      sym_identifier,
    ACTIONS(1832), 1,
      anon_sym_LPAREN,
    STATE(1367), 1,
      sym__annotated_type,
    STATE(2364), 1,
      sym_parameter_types,
    STATE(2367), 1,
      sym_stable_identifier,
    STATE(1521), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1871), 2,
      sym__type,
      sym_function_type,
    STATE(718), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39580] = 3,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(641), 6,
      sym__automatic_semicolon,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
    ACTIONS(643), 8,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      anon_sym_POUND,
      sym_identifier,
      sym_operator_identifier,
  [39602] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1826), 1,
      sym_identifier,
    ACTIONS(1828), 1,
      anon_sym_LPAREN,
    STATE(1314), 1,
      sym__annotated_type,
    STATE(2374), 1,
      sym_parameter_types,
    STATE(2377), 1,
      sym_stable_identifier,
    STATE(1505), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1601), 2,
      sym__type,
      sym_function_type,
    STATE(712), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39636] = 5,
    ACTIONS(185), 1,
      sym_comment,
    ACTIONS(1949), 1,
      anon_sym_LPAREN,
    STATE(981), 2,
      sym_arguments,
      aux_sym_annotation_repeat1,
    ACTIONS(645), 4,
      sym__automatic_semicolon,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(647), 7,
      anon_sym_EQ_GT,
      anon_sym_case,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_with,
      sym_identifier,
      sym_operator_identifier,
  [39662] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1826), 1,
      sym_identifier,
    ACTIONS(1828), 1,
      anon_sym_LPAREN,
    STATE(1314), 1,
      sym__annotated_type,
    STATE(2374), 1,
      sym_parameter_types,
    STATE(2377), 1,
      sym_stable_identifier,
    STATE(1505), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1625), 2,
      sym__type,
      sym_function_type,
    STATE(712), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39696] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1826), 1,
      sym_identifier,
    ACTIONS(1828), 1,
      anon_sym_LPAREN,
    STATE(1314), 1,
      sym__annotated_type,
    STATE(2374), 1,
      sym_parameter_types,
    STATE(2377), 1,
      sym_stable_identifier,
    STATE(1505), 2,
      sym_compound_type,
      sym_infix_type,
    STATE(1639), 2,
      sym__type,
      sym_function_type,
    STATE(712), 5,
      sym__simple_type,
      sym_tuple_type,
      sym_stable_type_identifier,
      sym_generic_type,
      sym_projected_type,
  [39730] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1830), 1,
      sym_identifier,
    ACTIONS(1832), 1,
      anon_sym_LPAREN,
    STATE(1367), 1,
      sym__annotated_type,
    STATE(2364), 1,
      sym_parameter_types,
    STATE(2367), 1,
      sym_stable_identifier,
    STATE