#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1404
#define LARGE_STATE_COUNT 28
#define SYMBOL_COUNT 212
#define ALIAS_COUNT 5
#define TOKEN_COUNT 94
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 35
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 109

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_LF = 2,
  anon_sym_SEMI = 3,
  anon_sym_NULL = 4,
  anon_sym_package = 5,
  anon_sym_import = 6,
  anon_sym_DOT = 7,
  sym_blank_identifier = 8,
  anon_sym_LPAREN = 9,
  anon_sym_RPAREN = 10,
  anon_sym_const = 11,
  anon_sym_COMMA = 12,
  anon_sym_EQ = 13,
  anon_sym_var = 14,
  anon_sym_func = 15,
  anon_sym_LBRACK = 16,
  anon_sym_RBRACK = 17,
  anon_sym_DOT_DOT_DOT = 18,
  anon_sym_type = 19,
  anon_sym_STAR = 20,
  anon_sym_struct = 21,
  anon_sym_TILDE = 22,
  anon_sym_LBRACE = 23,
  anon_sym_RBRACE = 24,
  anon_sym_interface = 25,
  anon_sym_PIPE = 26,
  anon_sym_map = 27,
  anon_sym_chan = 28,
  anon_sym_LT_DASH = 29,
  anon_sym_COLON_EQ = 30,
  anon_sym_PLUS_PLUS = 31,
  anon_sym_DASH_DASH = 32,
  anon_sym_STAR_EQ = 33,
  anon_sym_SLASH_EQ = 34,
  anon_sym_PERCENT_EQ = 35,
  anon_sym_LT_LT_EQ = 36,
  anon_sym_GT_GT_EQ = 37,
  anon_sym_AMP_EQ = 38,
  anon_sym_AMP_CARET_EQ = 39,
  anon_sym_PLUS_EQ = 40,
  anon_sym_DASH_EQ = 41,
  anon_sym_PIPE_EQ = 42,
  anon_sym_CARET_EQ = 43,
  anon_sym_COLON = 44,
  anon_sym_fallthrough = 45,
  anon_sym_break = 46,
  anon_sym_continue = 47,
  anon_sym_goto = 48,
  anon_sym_return = 49,
  anon_sym_go = 50,
  anon_sym_defer = 51,
  anon_sym_if = 52,
  anon_sym_else = 53,
  anon_sym_for = 54,
  anon_sym_range = 55,
  anon_sym_switch = 56,
  anon_sym_case = 57,
  anon_sym_default = 58,
  anon_sym_select = 59,
  anon_sym_new = 60,
  anon_sym_make = 61,
  anon_sym_PLUS = 62,
  anon_sym_DASH = 63,
  anon_sym_BANG = 64,
  anon_sym_CARET = 65,
  anon_sym_AMP = 66,
  anon_sym_SLASH = 67,
  anon_sym_PERCENT = 68,
  anon_sym_LT_LT = 69,
  anon_sym_GT_GT = 70,
  anon_sym_AMP_CARET = 71,
  anon_sym_EQ_EQ = 72,
  anon_sym_BANG_EQ = 73,
  anon_sym_LT = 74,
  anon_sym_LT_EQ = 75,
  anon_sym_GT = 76,
  anon_sym_GT_EQ = 77,
  anon_sym_AMP_AMP = 78,
  anon_sym_PIPE_PIPE = 79,
  sym_raw_string_literal = 80,
  anon_sym_DQUOTE = 81,
  anon_sym_DQUOTE2 = 82,
  sym__interpreted_string_literal_basic_content = 83,
  sym_escape_sequence = 84,
  sym_int_literal = 85,
  sym_float_literal = 86,
  sym_imaginary_literal = 87,
  sym_rune_literal = 88,
  sym_nil = 89,
  sym_true = 90,
  sym_false = 91,
  sym_iota = 92,
  sym_comment = 93,
  sym_source_file = 94,
  sym_package_clause = 95,
  sym_import_declaration = 96,
  sym_import_spec = 97,
  sym_dot = 98,
  sym_import_spec_list = 99,
  sym__declaration = 100,
  sym_const_declaration = 101,
  sym_const_spec = 102,
  sym_var_declaration = 103,
  sym_var_spec = 104,
  sym_var_spec_list = 105,
  sym_function_declaration = 106,
  sym_method_declaration = 107,
  sym_type_parameter_list = 108,
  sym_type_parameter_declaration = 109,
  sym_parameter_list = 110,
  sym_parameter_declaration = 111,
  sym_variadic_parameter_declaration = 112,
  sym_type_alias = 113,
  sym_type_declaration = 114,
  sym_type_spec = 115,
  sym_expression_list = 116,
  sym_parenthesized_type = 117,
  sym__simple_type = 118,
  sym_generic_type = 119,
  sym_type_arguments = 120,
  sym_pointer_type = 121,
  sym_array_type = 122,
  sym_implicit_length_array_type = 123,
  sym_slice_type = 124,
  sym_struct_type = 125,
  sym_negated_type = 126,
  sym_field_declaration_list = 127,
  sym_field_declaration = 128,
  sym_interface_type = 129,
  sym_method_elem = 130,
  sym_type_elem = 131,
  sym_map_type = 132,
  sym_channel_type = 133,
  sym_function_type = 134,
  sym_block = 135,
  sym__statement_list = 136,
  sym__statement = 137,
  sym_empty_statement = 138,
  sym__simple_statement = 139,
  sym_expression_statement = 140,
  sym_send_statement = 141,
  sym_receive_statement = 142,
  sym_inc_statement = 143,
  sym_dec_statement = 144,
  sym_assignment_statement = 145,
  sym_short_var_declaration = 146,
  sym_labeled_statement = 147,
  sym_empty_labeled_statement = 148,
  sym_fallthrough_statement = 149,
  sym_break_statement = 150,
  sym_continue_statement = 151,
  sym_goto_statement = 152,
  sym_return_statement = 153,
  sym_go_statement = 154,
  sym_defer_statement = 155,
  sym_if_statement = 156,
  sym_for_statement = 157,
  sym_for_clause = 158,
  sym_range_clause = 159,
  sym_expression_switch_statement = 160,
  sym_expression_case = 161,
  sym_default_case = 162,
  sym_type_switch_statement = 163,
  sym__type_switch_header = 164,
  sym_type_case = 165,
  sym_select_statement = 166,
  sym_communication_case = 167,
  sym__expression = 168,
  sym_parenthesized_expression = 169,
  sym_call_expression = 170,
  sym_variadic_argument = 171,
  sym_special_argument_list = 172,
  sym_argument_list = 173,
  sym_selector_expression = 174,
  sym_index_expression = 175,
  sym_slice_expression = 176,
  sym_type_assertion_expression = 177,
  sym_type_conversion_expression = 178,
  sym_type_instantiation_expression = 179,
  sym_composite_literal = 180,
  sym_literal_value = 181,
  sym_literal_element = 182,
  sym_keyed_element = 183,
  sym_func_literal = 184,
  sym_unary_expression = 185,
  sym_binary_expression = 186,
  sym_qualified_type = 187,
  sym_interpreted_string_literal = 188,
  aux_sym_source_file_repeat1 = 189,
  aux_sym_import_spec_list_repeat1 = 190,
  aux_sym_const_declaration_repeat1 = 191,
  aux_sym_const_spec_repeat1 = 192,
  aux_sym_var_spec_repeat1 = 193,
  aux_sym_var_spec_list_repeat1 = 194,
  aux_sym_type_parameter_list_repeat1 = 195,
  aux_sym_parameter_list_repeat1 = 196,
  aux_sym_type_declaration_repeat1 = 197,
  aux_sym_expression_list_repeat1 = 198,
  aux_sym_type_arguments_repeat1 = 199,
  aux_sym_field_declaration_list_repeat1 = 200,
  aux_sym_field_declaration_repeat1 = 201,
  aux_sym_interface_type_repeat1 = 202,
  aux_sym_type_elem_repeat1 = 203,
  aux_sym__statement_list_repeat1 = 204,
  aux_sym_expression_switch_statement_repeat1 = 205,
  aux_sym_type_switch_statement_repeat1 = 206,
  aux_sym_type_case_repeat1 = 207,
  aux_sym_select_statement_repeat1 = 208,
  aux_sym_argument_list_repeat1 = 209,
  aux_sym_literal_value_repeat1 = 210,
  aux_sym_interpreted_string_literal_repeat1 = 211,
  alias_sym_field_identifier = 212,
  alias_sym_label_name = 213,
  alias_sym_package_identifier = 214,
  alias_sym_type_constraint = 215,
  alias_sym_type_identifier = 216,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_LF] = "\n",
  [anon_sym_SEMI] = ";",
  [anon_sym_NULL] = "\0",
  [anon_sym_package] = "package",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [sym_blank_identifier] = "blank_identifier",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_const] = "const",
  [anon_sym_COMMA] = ",",
  [anon_sym_EQ] = "=",
  [anon_sym_var] = "var",
  [anon_sym_func] = "func",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_type] = "type",
  [anon_sym_STAR] = "*",
  [anon_sym_struct] = "struct",
  [anon_sym_TILDE] = "~",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_interface] = "interface",
  [anon_sym_PIPE] = "|",
  [anon_sym_map] = "map",
  [anon_sym_chan] = "chan",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_AMP_CARET_EQ] = "&^=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_COLON] = ":",
  [anon_sym_fallthrough] = "fallthrough",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_goto] = "goto",
  [anon_sym_return] = "return",
  [anon_sym_go] = "go",
  [anon_sym_defer] = "defer",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_range] = "range",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_select] = "select",
  [anon_sym_new] = "identifier",
  [anon_sym_make] = "identifier",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_BANG] = "!",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_AMP_CARET] = "&^",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [sym_raw_string_literal] = "raw_string_literal",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DQUOTE2] = "\"",
  [sym__interpreted_string_literal_basic_content] = "_interpreted_string_literal_basic_content",
  [sym_escape_sequence] = "escape_sequence",
  [sym_int_literal] = "int_literal",
  [sym_float_literal] = "float_literal",
  [sym_imaginary_literal] = "imaginary_literal",
  [sym_rune_literal] = "rune_literal",
  [sym_nil] = "nil",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_iota] = "iota",
  [sym_comment] = "comment",
  [sym_source_file] = "source_file",
  [sym_package_clause] = "package_clause",
  [sym_import_declaration] = "import_declaration",
  [sym_import_spec] = "import_spec",
  [sym_dot] = "dot",
  [sym_import_spec_list] = "import_spec_list",
  [sym__declaration] = "_declaration",
  [sym_const_declaration] = "const_declaration",
  [sym_const_spec] = "const_spec",
  [sym_var_declaration] = "var_declaration",
  [sym_var_spec] = "var_spec",
  [sym_var_spec_list] = "var_spec_list",
  [sym_function_declaration] = "function_declaration",
  [sym_method_declaration] = "method_declaration",
  [sym_type_parameter_list] = "type_parameter_list",
  [sym_type_parameter_declaration] = "type_parameter_declaration",
  [sym_parameter_list] = "parameter_list",
  [sym_parameter_declaration] = "parameter_declaration",
  [sym_variadic_parameter_declaration] = "variadic_parameter_declaration",
  [sym_type_alias] = "type_alias",
  [sym_type_declaration] = "type_declaration",
  [sym_type_spec] = "type_spec",
  [sym_expression_list] = "expression_list",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym__simple_type] = "_simple_type",
  [sym_generic_type] = "generic_type",
  [sym_type_arguments] = "type_arguments",
  [sym_pointer_type] = "pointer_type",
  [sym_array_type] = "array_type",
  [sym_implicit_length_array_type] = "implicit_length_array_type",
  [sym_slice_type] = "slice_type",
  [sym_struct_type] = "struct_type",
  [sym_negated_type] = "negated_type",
  [sym_field_declaration_list] = "field_declaration_list",
  [sym_field_declaration] = "field_declaration",
  [sym_interface_type] = "interface_type",
  [sym_method_elem] = "method_elem",
  [sym_type_elem] = "type_elem",
  [sym_map_type] = "map_type",
  [sym_channel_type] = "channel_type",
  [sym_function_type] = "function_type",
  [sym_block] = "block",
  [sym__statement_list] = "_statement_list",
  [sym__statement] = "_statement",
  [sym_empty_statement] = "empty_statement",
  [sym__simple_statement] = "_simple_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_send_statement] = "send_statement",
  [sym_receive_statement] = "receive_statement",
  [sym_inc_statement] = "inc_statement",
  [sym_dec_statement] = "dec_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym_short_var_declaration] = "short_var_declaration",
  [sym_labeled_statement] = "labeled_statement",
  [sym_empty_labeled_statement] = "labeled_statement",
  [sym_fallthrough_statement] = "fallthrough_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_return_statement] = "return_statement",
  [sym_go_statement] = "go_statement",
  [sym_defer_statement] = "defer_statement",
  [sym_if_statement] = "if_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_clause] = "for_clause",
  [sym_range_clause] = "range_clause",
  [sym_expression_switch_statement] = "expression_switch_statement",
  [sym_expression_case] = "expression_case",
  [sym_default_case] = "default_case",
  [sym_type_switch_statement] = "type_switch_statement",
  [sym__type_switch_header] = "_type_switch_header",
  [sym_type_case] = "type_case",
  [sym_select_statement] = "select_statement",
  [sym_communication_case] = "communication_case",
  [sym__expression] = "_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_call_expression] = "call_expression",
  [sym_variadic_argument] = "variadic_argument",
  [sym_special_argument_list] = "argument_list",
  [sym_argument_list] = "argument_list",
  [sym_selector_expression] = "selector_expression",
  [sym_index_expression] = "index_expression",
  [sym_slice_expression] = "slice_expression",
  [sym_type_assertion_expression] = "type_assertion_expression",
  [sym_type_conversion_expression] = "type_conversion_expression",
  [sym_type_instantiation_expression] = "type_instantiation_expression",
  [sym_composite_literal] = "composite_literal",
  [sym_literal_value] = "literal_value",
  [sym_literal_element] = "literal_element",
  [sym_keyed_element] = "keyed_element",
  [sym_func_literal] = "func_literal",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_qualified_type] = "qualified_type",
  [sym_interpreted_string_literal] = "interpreted_string_literal",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_import_spec_list_repeat1] = "import_spec_list_repeat1",
  [aux_sym_const_declaration_repeat1] = "const_declaration_repeat1",
  [aux_sym_const_spec_repeat1] = "const_spec_repeat1",
  [aux_sym_var_spec_repeat1] = "var_spec_repeat1",
  [aux_sym_var_spec_list_repeat1] = "var_spec_list_repeat1",
  [aux_sym_type_parameter_list_repeat1] = "type_parameter_list_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_type_declaration_repeat1] = "type_declaration_repeat1",
  [aux_sym_expression_list_repeat1] = "expression_list_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_field_declaration_list_repeat1] = "field_declaration_list_repeat1",
  [aux_sym_field_declaration_repeat1] = "field_declaration_repeat1",
  [aux_sym_interface_type_repeat1] = "interface_type_repeat1",
  [aux_sym_type_elem_repeat1] = "type_elem_repeat1",
  [aux_sym__statement_list_repeat1] = "_statement_list_repeat1",
  [aux_sym_expression_switch_statement_repeat1] = "expression_switch_statement_repeat1",
  [aux_sym_type_switch_statement_repeat1] = "type_switch_statement_repeat1",
  [aux_sym_type_case_repeat1] = "type_case_repeat1",
  [aux_sym_select_statement_repeat1] = "select_statement_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_literal_value_repeat1] = "literal_value_repeat1",
  [aux_sym_interpreted_string_literal_repeat1] = "interpreted_string_literal_repeat1",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_label_name] = "label_name",
  [alias_sym_package_identifier] = "package_identifier",
  [alias_sym_type_constraint] = "type_constraint",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_NULL] = anon_sym_NULL,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_blank_identifier] = sym_blank_identifier,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_func] = anon_sym_func,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_map] = anon_sym_map,
  [anon_sym_chan] = anon_sym_chan,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_AMP_CARET_EQ] = anon_sym_AMP_CARET_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_fallthrough] = anon_sym_fallthrough,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_go] = anon_sym_go,
  [anon_sym_defer] = anon_sym_defer,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_range] = anon_sym_range,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_select] = anon_sym_select,
  [anon_sym_new] = sym_identifier,
  [anon_sym_make] = sym_identifier,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_AMP_CARET] = anon_sym_AMP_CARET,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [sym_raw_string_literal] = sym_raw_string_literal,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [sym__interpreted_string_literal_basic_content] = sym__interpreted_string_literal_basic_content,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_int_literal] = sym_int_literal,
  [sym_float_literal] = sym_float_literal,
  [sym_imaginary_literal] = sym_imaginary_literal,
  [sym_rune_literal] = sym_rune_literal,
  [sym_nil] = sym_nil,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_iota] = sym_iota,
  [sym_comment] = sym_comment,
  [sym_source_file] = sym_source_file,
  [sym_package_clause] = sym_package_clause,
  [sym_import_declaration] = sym_import_declaration,
  [sym_import_spec] = sym_import_spec,
  [sym_dot] = sym_dot,
  [sym_import_spec_list] = sym_import_spec_list,
  [sym__declaration] = sym__declaration,
  [sym_const_declaration] = sym_const_declaration,
  [sym_const_spec] = sym_const_spec,
  [sym_var_declaration] = sym_var_declaration,
  [sym_var_spec] = sym_var_spec,
  [sym_var_spec_list] = sym_var_spec_list,
  [sym_function_declaration] = sym_function_declaration,
  [sym_method_declaration] = sym_method_declaration,
  [sym_type_parameter_list] = sym_type_parameter_list,
  [sym_type_parameter_declaration] = sym_type_parameter_declaration,
  [sym_parameter_list] = sym_parameter_list,
  [sym_parameter_declaration] = sym_parameter_declaration,
  [sym_variadic_parameter_declaration] = sym_variadic_parameter_declaration,
  [sym_type_alias] = sym_type_alias,
  [sym_type_declaration] = sym_type_declaration,
  [sym_type_spec] = sym_type_spec,
  [sym_expression_list] = sym_expression_list,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym__simple_type] = sym__simple_type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_pointer_type] = sym_pointer_type,
  [sym_array_type] = sym_array_type,
  [sym_implicit_length_array_type] = sym_implicit_length_array_type,
  [sym_slice_type] = sym_slice_type,
  [sym_struct_type] = sym_struct_type,
  [sym_negated_type] = sym_negated_type,
  [sym_field_declaration_list] = sym_field_declaration_list,
  [sym_field_declaration] = sym_field_declaration,
  [sym_interface_type] = sym_interface_type,
  [sym_method_elem] = sym_method_elem,
  [sym_type_elem] = sym_type_elem,
  [sym_map_type] = sym_map_type,
  [sym_channel_type] = sym_channel_type,
  [sym_function_type] = sym_function_type,
  [sym_block] = sym_block,
  [sym__statement_list] = sym__statement_list,
  [sym__statement] = sym__statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym__simple_statement] = sym__simple_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_send_statement] = sym_send_statement,
  [sym_receive_statement] = sym_receive_statement,
  [sym_inc_statement] = sym_inc_statement,
  [sym_dec_statement] = sym_dec_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym_short_var_declaration] = sym_short_var_declaration,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_empty_labeled_statement] = sym_labeled_statement,
  [sym_fallthrough_statement] = sym_fallthrough_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_go_statement] = sym_go_statement,
  [sym_defer_statement] = sym_defer_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_clause] = sym_for_clause,
  [sym_range_clause] = sym_range_clause,
  [sym_expression_switch_statement] = sym_expression_switch_statement,
  [sym_expression_case] = sym_expression_case,
  [sym_default_case] = sym_default_case,
  [sym_type_switch_statement] = sym_type_switch_statement,
  [sym__type_switch_header] = sym__type_switch_header,
  [sym_type_case] = sym_type_case,
  [sym_select_statement] = sym_select_statement,
  [sym_communication_case] = sym_communication_case,
  [sym__expression] = sym__expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_variadic_argument] = sym_variadic_argument,
  [sym_special_argument_list] = sym_argument_list,
  [sym_argument_list] = sym_argument_list,
  [sym_selector_expression] = sym_selector_expression,
  [sym_index_expression] = sym_index_expression,
  [sym_slice_expression] = sym_slice_expression,
  [sym_type_assertion_expression] = sym_type_assertion_expression,
  [sym_type_conversion_expression] = sym_type_conversion_expression,
  [sym_type_instantiation_expression] = sym_type_instantiation_expression,
  [sym_composite_literal] = sym_composite_literal,
  [sym_literal_value] = sym_literal_value,
  [sym_literal_element] = sym_literal_element,
  [sym_keyed_element] = sym_keyed_element,
  [sym_func_literal] = sym_func_literal,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_qualified_type] = sym_qualified_type,
  [sym_interpreted_string_literal] = sym_interpreted_string_literal,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_import_spec_list_repeat1] = aux_sym_import_spec_list_repeat1,
  [aux_sym_const_declaration_repeat1] = aux_sym_const_declaration_repeat1,
  [aux_sym_const_spec_repeat1] = aux_sym_const_spec_repeat1,
  [aux_sym_var_spec_repeat1] = aux_sym_var_spec_repeat1,
  [aux_sym_var_spec_list_repeat1] = aux_sym_var_spec_list_repeat1,
  [aux_sym_type_parameter_list_repeat1] = aux_sym_type_parameter_list_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_type_declaration_repeat1] = aux_sym_type_declaration_repeat1,
  [aux_sym_expression_list_repeat1] = aux_sym_expression_list_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_field_declaration_list_repeat1] = aux_sym_field_declaration_list_repeat1,
  [aux_sym_field_declaration_repeat1] = aux_sym_field_declaration_repeat1,
  [aux_sym_interface_type_repeat1] = aux_sym_interface_type_repeat1,
  [aux_sym_type_elem_repeat1] = aux_sym_type_elem_repeat1,
  [aux_sym__statement_list_repeat1] = aux_sym__statement_list_repeat1,
  [aux_sym_expression_switch_statement_repeat1] = aux_sym_expression_switch_statement_repeat1,
  [aux_sym_type_switch_statement_repeat1] = aux_sym_type_switch_statement_repeat1,
  [aux_sym_type_case_repeat1] = aux_sym_type_case_repeat1,
  [aux_sym_select_statement_repeat1] = aux_sym_select_statement_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_literal_value_repeat1] = aux_sym_literal_value_repeat1,
  [aux_sym_interpreted_string_literal_repeat1] = aux_sym_interpreted_string_literal_repeat1,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_label_name] = alias_sym_label_name,
  [alias_sym_package_identifier] = alias_sym_package_identifier,
  [alias_sym_type_constraint] = alias_sym_type_constraint,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_blank_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_func] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_map] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_chan] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fallthrough] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_go] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_range] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_select] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_make] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [sym_raw_string_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [sym__interpreted_string_literal_basic_content] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_imaginary_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_rune_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_iota] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_package_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_dot] = {
    .visible = true,
    .named = true,
  },
  [sym_import_spec_list] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_const_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_const_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_var_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_var_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_var_spec_list] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_implicit_length_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_type] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_type] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_type] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_type] = {
    .visible = true,
    .named = true,
  },
  [sym_method_elem] = {
    .visible = true,
    .named = true,
  },
  [sym_type_elem] = {
    .visible = true,
    .named = true,
  },
  [sym_map_type] = {
    .visible = true,
    .named = true,
  },
  [sym_channel_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__statement_list] = {
    .visible = false,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_send_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_receive_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_inc_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_dec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_short_var_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_fallthrough_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_go_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_defer_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_range_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_case] = {
    .visible = true,
    .named = true,
  },
  [sym_default_case] = {
    .visible = true,
    .named = true,
  },
  [sym_type_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__type_switch_header] = {
    .visible = false,
    .named = true,
  },
  [sym_type_case] = {
    .visible = true,
    .named = true,
  },
  [sym_select_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_communication_case] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_special_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_selector_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_assertion_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_conversion_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_instantiation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_composite_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_value] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_element] = {
    .visible = true,
    .named = true,
  },
  [sym_keyed_element] = {
    .visible = true,
    .named = true,
  },
  [sym_func_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_type] = {
    .visible = true,
    .named = true,
  },
  [sym_interpreted_string_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_spec_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_const_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_const_spec_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_var_spec_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_var_spec_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_elem_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__statement_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_case_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_select_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_literal_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_label_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_package_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_constraint] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_arguments = 3,
  field_body = 4,
  field_capacity = 5,
  field_channel = 6,
  field_communication = 7,
  field_condition = 8,
  field_consequence = 9,
  field_element = 10,
  field_end = 11,
  field_field = 12,
  field_function = 13,
  field_index = 14,
  field_initializer = 15,
  field_key = 16,
  field_label = 17,
  field_left = 18,
  field_length = 19,
  field_name = 20,
  field_operand = 21,
  field_operator = 22,
  field_package = 23,
  field_parameters = 24,
  field_path = 25,
  field_receiver = 26,
  field_result = 27,
  field_right = 28,
  field_start = 29,
  field_tag = 30,
  field_type = 31,
  field_type_arguments = 32,
  field_type_parameters = 33,
  field_update = 34,
  field_value = 35,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_capacity] = "capacity",
  [field_channel] = "channel",
  [field_communication] = "communication",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_element] = "element",
  [field_end] = "end",
  [field_field] = "field",
  [field_function] = "function",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_label] = "label",
  [field_left] = "left",
  [field_length] = "length",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_package] = "package",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_receiver] = "receiver",
  [field_result] = "result",
  [field_right] = "right",
  [field_start] = "start",
  [field_tag] = "tag",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 2},
  [7] = {.index = 5, .length = 1},
  [9] = {.index = 6, .length = 1},
  [10] = {.index = 7, .length = 2},
  [11] = {.index = 9, .length = 2},
  [12] = {.index = 11, .length = 2},
  [13] = {.index = 11, .length = 2},
  [14] = {.index = 9, .length = 2},
  [15] = {.index = 13, .length = 2},
  [16] = {.index = 13, .length = 2},
  [17] = {.index = 15, .length = 2},
  [18] = {.index = 17, .length = 2},
  [19] = {.index = 19, .length = 1},
  [20] = {.index = 20, .length = 2},
  [21] = {.index = 22, .length = 2},
  [22] = {.index = 24, .length = 2},
  [23] = {.index = 26, .length = 1},
  [24] = {.index = 17, .length = 2},
  [25] = {.index = 19, .length = 1},
  [26] = {.index = 27, .length = 1},
  [27] = {.index = 28, .length = 1},
  [28] = {.index = 29, .length = 2},
  [29] = {.index = 31, .length = 1},
  [30] = {.index = 32, .length = 1},
  [31] = {.index = 33, .length = 2},
  [32] = {.index = 35, .length = 3},
  [33] = {.index = 38, .length = 2},
  [34] = {.index = 40, .length = 2},
  [35] = {.index = 42, .length = 2},
  [36] = {.index = 44, .length = 3},
  [37] = {.index = 47, .length = 2},
  [38] = {.index = 49, .length = 1},
  [39] = {.index = 50, .length = 3},
  [40] = {.index = 53, .length = 2},
  [41] = {.index = 55, .length = 1},
  [42] = {.index = 56, .length = 3},
  [43] = {.index = 59, .length = 3},
  [44] = {.index = 62, .length = 3},
  [45] = {.index = 65, .length = 3},
  [46] = {.index = 68, .length = 3},
  [47] = {.index = 71, .length = 1},
  [48] = {.index = 72, .length = 2},
  [49] = {.index = 74, .length = 2},
  [50] = {.index = 76, .length = 3},
  [51] = {.index = 55, .length = 1},
  [52] = {.index = 79, .length = 2},
  [53] = {.index = 17, .length = 2},
  [54] = {.index = 79, .length = 2},
  [55] = {.index = 81, .length = 2},
  [56] = {.index = 83, .length = 1},
  [57] = {.index = 84, .length = 1},
  [58] = {.index = 85, .length = 1},
  [59] = {.index = 86, .length = 3},
  [60] = {.index = 89, .length = 1},
  [61] = {.index = 90, .length = 2},
  [62] = {.index = 92, .length = 1},
  [63] = {.index = 93, .length = 2},
  [64] = {.index = 95, .length = 3},
  [65] = {.index = 98, .length = 3},
  [66] = {.index = 101, .length = 3},
  [67] = {.index = 74, .length = 2},
  [68] = {.index = 17, .length = 2},
  [69] = {.index = 104, .length = 4},
  [70] = {.index = 108, .length = 4},
  [71] = {.index = 112, .length = 4},
  [72] = {.index = 116, .length = 4},
  [73] = {.index = 120, .length = 4},
  [74] = {.index = 124, .length = 2},
  [75] = {.index = 124, .length = 2},
  [76] = {.index = 49, .length = 1},
  [77] = {.index = 126, .length = 3},
  [78] = {.index = 50, .length = 3},
  [79] = {.index = 129, .length = 3},
  [80] = {.index = 132, .length = 2},
  [81] = {.index = 134, .length = 3},
  [82] = {.index = 137, .length = 3},
  [83] = {.index = 140, .length = 2},
  [84] = {.index = 142, .length = 2},
  [85] = {.index = 144, .length = 2},
  [86] = {.index = 146, .length = 2},
  [87] = {.index = 148, .length = 1},
  [88] = {.index = 149, .length = 1},
  [89] = {.index = 150, .length = 2},
  [90] = {.index = 152, .length = 2},
  [91] = {.index = 154, .length = 2},
  [92] = {.index = 156, .length = 4},
  [93] = {.index = 160, .length = 4},
  [94] = {.index = 50, .length = 3},
  [95] = {.index = 164, .length = 5},
  [96] = {.index = 169, .length = 5},
  [97] = {.index = 174, .length = 4},
  [98] = {.index = 178, .length = 3},
  [99] = {.index = 181, .length = 2},
  [100] = {.index = 183, .length = 1},
  [101] = {.index = 184, .length = 3},
  [102] = {.index = 187, .length = 4},
  [103] = {.index = 191, .length = 2},
  [104] = {.index = 193, .length = 3},
  [105] = {.index = 196, .length = 2},
  [106] = {.index = 198, .length = 2},
  [107] = {.index = 200, .length = 4},
  [108] = {.index = 204, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_path, 0},
  [1] =
    {field_name, 0},
  [2] =
    {field_parameters, 1},
  [3] =
    {field_operand, 1},
    {field_operator, 0},
  [5] =
    {field_value, 1},
  [6] =
    {field_body, 1},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_type, 0},
    {field_type_arguments, 1},
  [11] =
    {field_body, 1},
    {field_type, 0},
  [13] =
    {field_name, 0},
    {field_path, 1},
  [15] =
    {field_name, 0},
    {field_name, 1},
  [17] =
    {field_name, 0},
    {field_type, 1},
  [19] =
    {field_type, 0},
  [20] =
    {field_name, 1},
    {field_parameters, 2},
  [22] =
    {field_parameters, 1},
    {field_result, 2},
  [24] =
    {field_body, 2},
    {field_parameters, 1},
  [26] =
    {field_element, 2},
  [27] =
    {field_label, 0},
  [28] =
    {field_value, 2},
  [29] =
    {field_condition, 1},
    {field_consequence, 2},
  [31] =
    {field_right, 1},
  [32] =
    {field_body, 2},
  [33] =
    {field_name, 2},
    {field_package, 0},
  [35] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [38] =
    {field_left, 0},
    {field_right, 2},
  [40] =
    {field_field, 2},
    {field_operand, 0},
  [42] =
    {field_channel, 0},
    {field_value, 2},
  [44] =
    {field_arguments, 2},
    {field_function, 0},
    {field_type_arguments, 1},
  [47] =
    {field_name, 0},
    {field_value, 2},
  [49] =
    {field_name, 1},
  [50] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_type, 2},
  [53] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [55] =
    {field_type, 1},
  [56] =
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [59] =
    {field_name, 1},
    {field_parameters, 2},
    {field_result, 3},
  [62] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [65] =
    {field_name, 2},
    {field_parameters, 3},
    {field_receiver, 1},
  [68] =
    {field_body, 3},
    {field_parameters, 1},
    {field_result, 2},
  [71] =
    {field_element, 3},
  [72] =
    {field_element, 3},
    {field_length, 1},
  [74] =
    {field_name, 0},
    {field_type, 2},
  [76] =
    {field_name, 0},
    {field_type, 2},
    {field_type_parameters, 1},
  [79] =
    {field_tag, 1},
    {field_type, 0},
  [81] =
    {field_name, 0},
    {field_parameters, 1},
  [83] =
    {field_update, 2},
  [84] =
    {field_condition, 1},
  [85] =
    {field_initializer, 0},
  [86] =
    {field_alias, 1, .inherited = true},
    {field_initializer, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [89] =
    {field_right, 0},
  [90] =
    {field_operand, 2},
    {field_type, 0},
  [92] =
    {field_operand, 0},
  [93] =
    {field_index, 2},
    {field_operand, 0},
  [95] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 3},
  [98] =
    {field_name, 0},
    {field_name, 1},
    {field_value, 3},
  [101] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_value, 3},
  [104] =
    {field_name, 1},
    {field_parameters, 3},
    {field_result, 4},
    {field_type_parameters, 2},
  [108] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [112] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
    {field_result, 3},
  [116] =
    {field_name, 2},
    {field_parameters, 3},
    {field_receiver, 1},
    {field_result, 4},
  [120] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
    {field_receiver, 1},
  [124] =
    {field_tag, 2},
    {field_type, 1},
  [126] =
    {field_name, 0},
    {field_tag, 2},
    {field_type, 1},
  [129] =
    {field_name, 0},
    {field_parameters, 1},
    {field_result, 2},
  [132] =
    {field_key, 2},
    {field_value, 4},
  [134] =
    {field_condition, 3},
    {field_consequence, 4},
    {field_initializer, 1},
  [137] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [140] =
    {field_condition, 1},
    {field_update, 3},
  [142] =
    {field_left, 0},
    {field_right, 3},
  [144] =
    {field_initializer, 0},
    {field_update, 3},
  [146] =
    {field_condition, 2},
    {field_initializer, 0},
  [148] =
    {field_initializer, 1},
  [149] =
    {field_communication, 1},
  [150] =
    {field_operand, 0},
    {field_type, 3},
  [152] =
    {field_end, 3},
    {field_operand, 0},
  [154] =
    {field_operand, 0},
    {field_start, 2},
  [156] =
    {field_name, 0},
    {field_name, 1},
    {field_type, 2},
    {field_value, 4},
  [160] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_type, 2},
    {field_value, 4},
  [164] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 3},
    {field_result, 4},
    {field_type_parameters, 2},
  [169] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
    {field_receiver, 1},
    {field_result, 4},
  [174] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_tag, 3},
    {field_type, 2},
  [178] =
    {field_condition, 2},
    {field_initializer, 0},
    {field_update, 4},
  [181] =
    {field_initializer, 1},
    {field_value, 3},
  [183] =
    {field_value, 0},
  [184] =
    {field_end, 4},
    {field_operand, 0},
    {field_start, 2},
  [187] =
    {field_alternative, 6},
    {field_condition, 3},
    {field_consequence, 4},
    {field_initializer, 1},
  [191] =
    {field_type, 1},
    {field_type, 2},
  [193] =
    {field_capacity, 5},
    {field_end, 3},
    {field_operand, 0},
  [196] =
    {field_alias, 0},
    {field_value, 2},
  [198] =
    {field_initializer, 0},
    {field_value, 2},
  [200] =
    {field_capacity, 6},
    {field_end, 4},
    {field_operand, 0},
    {field_start, 2},
  [204] =
    {field_alias, 2},
    {field_initializer, 0},
    {field_value, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [2] = {
    [1] = alias_sym_package_identifier,
  },
  [8] = {
    [1] = alias_sym_label_name,
  },
  [11] = {
    [0] = alias_sym_type_identifier,
  },
  [12] = {
    [0] = alias_sym_type_identifier,
  },
  [16] = {
    [0] = alias_sym_package_identifier,
  },
  [24] = {
    [0] = alias_sym_type_identifier,
  },
  [25] = {
    [0] = alias_sym_type_identifier,
  },
  [26] = {
    [0] = alias_sym_label_name,
  },
  [31] = {
    [0] = alias_sym_package_identifier,
    [2] = alias_sym_type_identifier,
  },
  [34] = {
    [2] = alias_sym_field_identifier,
  },
  [45] = {
    [2] = alias_sym_field_identifier,
  },
  [49] = {
    [0] = alias_sym_type_identifier,
  },
  [50] = {
    [0] = alias_sym_type_identifier,
  },
  [51] = {
    [1] = alias_sym_type_identifier,
  },
  [52] = {
    [0] = alias_sym_type_identifier,
  },
  [53] = {
    [0] = alias_sym_field_identifier,
  },
  [55] = {
    [0] = alias_sym_field_identifier,
  },
  [68] = {
    [1] = alias_sym_type_constraint,
  },
  [72] = {
    [2] = alias_sym_field_identifier,
  },
  [73] = {
    [2] = alias_sym_field_identifier,
  },
  [74] = {
    [1] = alias_sym_type_identifier,
  },
  [76] = {
    [1] = alias_sym_field_identifier,
  },
  [77] = {
    [0] = alias_sym_field_identifier,
  },
  [78] = {
    [0] = alias_sym_field_identifier,
  },
  [79] = {
    [0] = alias_sym_field_identifier,
  },
  [94] = {
    [2] = alias_sym_type_constraint,
  },
  [96] = {
    [2] = alias_sym_field_identifier,
  },
  [97] = {
    [0] = alias_sym_field_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_type_elem, 2,
    sym_type_elem,
    alias_sym_type_constraint,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 12,
  [14] = 12,
  [15] = 12,
  [16] = 12,
  [17] = 12,
  [18] = 12,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 29,
  [31] = 29,
  [32] = 29,
  [33] = 29,
  [34] = 29,
  [35] = 35,
  [36] = 36,
  [37] = 36,
  [38] = 35,
  [39] = 36,
  [40] = 35,
  [41] = 35,
  [42] = 36,
  [43] = 36,
  [44] = 36,
  [45] = 35,
  [46] = 35,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 54,
  [56] = 56,
  [57] = 57,
  [58] = 52,
  [59] = 54,
  [60] = 56,
  [61] = 57,
  [62] = 51,
  [63] = 52,
  [64] = 64,
  [65] = 57,
  [66] = 52,
  [67] = 67,
  [68] = 57,
  [69] = 54,
  [70] = 57,
  [71] = 52,
  [72] = 54,
  [73] = 57,
  [74] = 52,
  [75] = 75,
  [76] = 51,
  [77] = 51,
  [78] = 51,
  [79] = 51,
  [80] = 54,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 81,
  [86] = 86,
  [87] = 87,
  [88] = 82,
  [89] = 89,
  [90] = 90,
  [91] = 81,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 83,
  [96] = 84,
  [97] = 92,
  [98] = 81,
  [99] = 99,
  [100] = 82,
  [101] = 82,
  [102] = 92,
  [103] = 103,
  [104] = 84,
  [105] = 105,
  [106] = 83,
  [107] = 107,
  [108] = 83,
  [109] = 84,
  [110] = 110,
  [111] = 83,
  [112] = 112,
  [113] = 82,
  [114] = 114,
  [115] = 84,
  [116] = 81,
  [117] = 92,
  [118] = 86,
  [119] = 119,
  [120] = 83,
  [121] = 84,
  [122] = 90,
  [123] = 86,
  [124] = 124,
  [125] = 82,
  [126] = 126,
  [127] = 90,
  [128] = 81,
  [129] = 92,
  [130] = 92,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 132,
  [140] = 140,
  [141] = 133,
  [142] = 142,
  [143] = 140,
  [144] = 134,
  [145] = 131,
  [146] = 146,
  [147] = 137,
  [148] = 136,
  [149] = 149,
  [150] = 150,
  [151] = 138,
  [152] = 132,
  [153] = 133,
  [154] = 134,
  [155] = 131,
  [156] = 136,
  [157] = 157,
  [158] = 137,
  [159] = 159,
  [160] = 150,
  [161] = 142,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 136,
  [167] = 137,
  [168] = 168,
  [169] = 142,
  [170] = 142,
  [171] = 171,
  [172] = 150,
  [173] = 142,
  [174] = 136,
  [175] = 138,
  [176] = 137,
  [177] = 132,
  [178] = 138,
  [179] = 133,
  [180] = 134,
  [181] = 131,
  [182] = 150,
  [183] = 138,
  [184] = 132,
  [185] = 133,
  [186] = 134,
  [187] = 131,
  [188] = 150,
  [189] = 136,
  [190] = 138,
  [191] = 137,
  [192] = 132,
  [193] = 133,
  [194] = 134,
  [195] = 131,
  [196] = 150,
  [197] = 138,
  [198] = 132,
  [199] = 133,
  [200] = 134,
  [201] = 131,
  [202] = 150,
  [203] = 136,
  [204] = 138,
  [205] = 137,
  [206] = 136,
  [207] = 137,
  [208] = 136,
  [209] = 136,
  [210] = 135,
  [211] = 164,
  [212] = 132,
  [213] = 168,
  [214] = 171,
  [215] = 135,
  [216] = 164,
  [217] = 133,
  [218] = 168,
  [219] = 171,
  [220] = 135,
  [221] = 164,
  [222] = 134,
  [223] = 168,
  [224] = 171,
  [225] = 135,
  [226] = 164,
  [227] = 131,
  [228] = 168,
  [229] = 171,
  [230] = 135,
  [231] = 164,
  [232] = 150,
  [233] = 168,
  [234] = 171,
  [235] = 140,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 243,
  [291] = 239,
  [292] = 242,
  [293] = 247,
  [294] = 241,
  [295] = 244,
  [296] = 240,
  [297] = 246,
  [298] = 251,
  [299] = 264,
  [300] = 249,
  [301] = 285,
  [302] = 286,
  [303] = 265,
  [304] = 253,
  [305] = 254,
  [306] = 266,
  [307] = 252,
  [308] = 279,
  [309] = 268,
  [310] = 248,
  [311] = 267,
  [312] = 288,
  [313] = 269,
  [314] = 282,
  [315] = 283,
  [316] = 287,
  [317] = 257,
  [318] = 256,
  [319] = 258,
  [320] = 260,
  [321] = 261,
  [322] = 262,
  [323] = 263,
  [324] = 250,
  [325] = 271,
  [326] = 272,
  [327] = 273,
  [328] = 274,
  [329] = 275,
  [330] = 276,
  [331] = 277,
  [332] = 278,
  [333] = 284,
  [334] = 280,
  [335] = 281,
  [336] = 270,
  [337] = 240,
  [338] = 243,
  [339] = 246,
  [340] = 247,
  [341] = 241,
  [342] = 244,
  [343] = 242,
  [344] = 344,
  [345] = 251,
  [346] = 262,
  [347] = 277,
  [348] = 278,
  [349] = 280,
  [350] = 281,
  [351] = 282,
  [352] = 283,
  [353] = 284,
  [354] = 285,
  [355] = 286,
  [356] = 252,
  [357] = 250,
  [358] = 264,
  [359] = 271,
  [360] = 272,
  [361] = 273,
  [362] = 266,
  [363] = 274,
  [364] = 249,
  [365] = 265,
  [366] = 263,
  [367] = 254,
  [368] = 279,
  [369] = 275,
  [370] = 268,
  [371] = 248,
  [372] = 267,
  [373] = 288,
  [374] = 269,
  [375] = 270,
  [376] = 276,
  [377] = 287,
  [378] = 257,
  [379] = 256,
  [380] = 258,
  [381] = 260,
  [382] = 261,
  [383] = 253,
  [384] = 384,
  [385] = 385,
  [386] = 384,
  [387] = 242,
  [388] = 246,
  [389] = 251,
  [390] = 240,
  [391] = 391,
  [392] = 392,
  [393] = 256,
  [394] = 266,
  [395] = 395,
  [396] = 249,
  [397] = 265,
  [398] = 253,
  [399] = 254,
  [400] = 279,
  [401] = 268,
  [402] = 248,
  [403] = 267,
  [404] = 288,
  [405] = 269,
  [406] = 270,
  [407] = 287,
  [408] = 257,
  [409] = 250,
  [410] = 258,
  [411] = 260,
  [412] = 261,
  [413] = 262,
  [414] = 263,
  [415] = 264,
  [416] = 271,
  [417] = 272,
  [418] = 273,
  [419] = 274,
  [420] = 275,
  [421] = 276,
  [422] = 277,
  [423] = 278,
  [424] = 280,
  [425] = 281,
  [426] = 282,
  [427] = 283,
  [428] = 284,
  [429] = 285,
  [430] = 286,
  [431] = 240,
  [432] = 252,
  [433] = 242,
  [434] = 241,
  [435] = 384,
  [436] = 246,
  [437] = 247,
  [438] = 243,
  [439] = 344,
  [440] = 247,
  [441] = 244,
  [442] = 243,
  [443] = 244,
  [444] = 241,
  [445] = 384,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 240,
  [453] = 251,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 271,
  [458] = 269,
  [459] = 248,
  [460] = 247,
  [461] = 243,
  [462] = 241,
  [463] = 244,
  [464] = 270,
  [465] = 287,
  [466] = 252,
  [467] = 467,
  [468] = 257,
  [469] = 256,
  [470] = 258,
  [471] = 260,
  [472] = 261,
  [473] = 262,
  [474] = 263,
  [475] = 264,
  [476] = 272,
  [477] = 273,
  [478] = 467,
  [479] = 250,
  [480] = 274,
  [481] = 268,
  [482] = 344,
  [483] = 276,
  [484] = 277,
  [485] = 278,
  [486] = 280,
  [487] = 242,
  [488] = 467,
  [489] = 281,
  [490] = 282,
  [491] = 384,
  [492] = 384,
  [493] = 455,
  [494] = 283,
  [495] = 246,
  [496] = 284,
  [497] = 285,
  [498] = 286,
  [499] = 456,
  [500] = 454,
  [501] = 279,
  [502] = 266,
  [503] = 267,
  [504] = 265,
  [505] = 253,
  [506] = 249,
  [507] = 254,
  [508] = 288,
  [509] = 275,
  [510] = 510,
  [511] = 511,
  [512] = 511,
  [513] = 513,
  [514] = 240,
  [515] = 251,
  [516] = 511,
  [517] = 517,
  [518] = 517,
  [519] = 517,
  [520] = 240,
  [521] = 511,
  [522] = 395,
  [523] = 510,
  [524] = 524,
  [525] = 511,
  [526] = 510,
  [527] = 511,
  [528] = 281,
  [529] = 250,
  [530] = 530,
  [531] = 530,
  [532] = 532,
  [533] = 533,
  [534] = 266,
  [535] = 240,
  [536] = 536,
  [537] = 249,
  [538] = 265,
  [539] = 253,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 254,
  [544] = 540,
  [545] = 279,
  [546] = 247,
  [547] = 547,
  [548] = 268,
  [549] = 243,
  [550] = 241,
  [551] = 244,
  [552] = 248,
  [553] = 267,
  [554] = 288,
  [555] = 269,
  [556] = 556,
  [557] = 557,
  [558] = 247,
  [559] = 243,
  [560] = 241,
  [561] = 244,
  [562] = 530,
  [563] = 556,
  [564] = 540,
  [565] = 565,
  [566] = 287,
  [567] = 257,
  [568] = 256,
  [569] = 258,
  [570] = 260,
  [571] = 261,
  [572] = 262,
  [573] = 263,
  [574] = 264,
  [575] = 271,
  [576] = 272,
  [577] = 273,
  [578] = 274,
  [579] = 275,
  [580] = 276,
  [581] = 277,
  [582] = 278,
  [583] = 280,
  [584] = 282,
  [585] = 283,
  [586] = 284,
  [587] = 285,
  [588] = 286,
  [589] = 556,
  [590] = 395,
  [591] = 252,
  [592] = 270,
  [593] = 593,
  [594] = 594,
  [595] = 595,
  [596] = 596,
  [597] = 344,
  [598] = 598,
  [599] = 598,
  [600] = 596,
  [601] = 448,
  [602] = 602,
  [603] = 603,
  [604] = 448,
  [605] = 602,
  [606] = 603,
  [607] = 602,
  [608] = 594,
  [609] = 594,
  [610] = 610,
  [611] = 344,
  [612] = 603,
  [613] = 448,
  [614] = 593,
  [615] = 610,
  [616] = 603,
  [617] = 598,
  [618] = 603,
  [619] = 610,
  [620] = 620,
  [621] = 594,
  [622] = 447,
  [623] = 594,
  [624] = 624,
  [625] = 596,
  [626] = 603,
  [627] = 448,
  [628] = 448,
  [629] = 602,
  [630] = 630,
  [631] = 598,
  [632] = 594,
  [633] = 602,
  [634] = 602,
  [635] = 635,
  [636] = 598,
  [637] = 598,
  [638] = 638,
  [639] = 447,
  [640] = 640,
  [641] = 641,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 646,
  [647] = 646,
  [648] = 648,
  [649] = 638,
  [650] = 640,
  [651] = 644,
  [652] = 648,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 646,
  [658] = 638,
  [659] = 640,
  [660] = 660,
  [661] = 661,
  [662] = 662,
  [663] = 644,
  [664] = 648,
  [665] = 653,
  [666] = 654,
  [667] = 654,
  [668] = 668,
  [669] = 646,
  [670] = 638,
  [671] = 640,
  [672] = 644,
  [673] = 648,
  [674] = 653,
  [675] = 654,
  [676] = 646,
  [677] = 640,
  [678] = 644,
  [679] = 648,
  [680] = 653,
  [681] = 654,
  [682] = 646,
  [683] = 638,
  [684] = 640,
  [685] = 644,
  [686] = 648,
  [687] = 653,
  [688] = 654,
  [689] = 638,
  [690] = 642,
  [691] = 642,
  [692] = 692,
  [693] = 653,
  [694] = 694,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 696,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 696,
  [707] = 699,
  [708] = 700,
  [709] = 702,
  [710] = 703,
  [711] = 696,
  [712] = 712,
  [713] = 704,
  [714] = 714,
  [715] = 715,
  [716] = 714,
  [717] = 694,
  [718] = 697,
  [719] = 696,
  [720] = 720,
  [721] = 712,
  [722] = 704,
  [723] = 723,
  [724] = 715,
  [725] = 699,
  [726] = 714,
  [727] = 694,
  [728] = 700,
  [729] = 729,
  [730] = 695,
  [731] = 702,
  [732] = 703,
  [733] = 733,
  [734] = 703,
  [735] = 699,
  [736] = 715,
  [737] = 700,
  [738] = 694,
  [739] = 702,
  [740] = 712,
  [741] = 741,
  [742] = 704,
  [743] = 702,
  [744] = 696,
  [745] = 715,
  [746] = 699,
  [747] = 694,
  [748] = 700,
  [749] = 749,
  [750] = 750,
  [751] = 704,
  [752] = 715,
  [753] = 694,
  [754] = 715,
  [755] = 702,
  [756] = 756,
  [757] = 703,
  [758] = 703,
  [759] = 733,
  [760] = 699,
  [761] = 705,
  [762] = 695,
  [763] = 733,
  [764] = 700,
  [765] = 705,
  [766] = 695,
  [767] = 733,
  [768] = 705,
  [769] = 695,
  [770] = 733,
  [771] = 705,
  [772] = 695,
  [773] = 733,
  [774] = 705,
  [775] = 704,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 776,
  [783] = 779,
  [784] = 778,
  [785] = 777,
  [786] = 778,
  [787] = 779,
  [788] = 776,
  [789] = 777,
  [790] = 790,
  [791] = 791,
  [792] = 792,
  [793] = 792,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 796,
  [800] = 795,
  [801] = 801,
  [802] = 802,
  [803] = 795,
  [804] = 804,
  [805] = 805,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 792,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 796,
  [837] = 837,
  [838] = 837,
  [839] = 839,
  [840] = 840,
  [841] = 792,
  [842] = 827,
  [843] = 816,
  [844] = 806,
  [845] = 845,
  [846] = 821,
  [847] = 804,
  [848] = 796,
  [849] = 849,
  [850] = 811,
  [851] = 818,
  [852] = 810,
  [853] = 830,
  [854] = 813,
  [855] = 855,
  [856] = 826,
  [857] = 815,
  [858] = 807,
  [859] = 812,
  [860] = 823,
  [861] = 845,
  [862] = 814,
  [863] = 849,
  [864] = 864,
  [865] = 824,
  [866] = 825,
  [867] = 817,
  [868] = 868,
  [869] = 869,
  [870] = 808,
  [871] = 828,
  [872] = 864,
  [873] = 809,
  [874] = 829,
  [875] = 822,
  [876] = 831,
  [877] = 820,
  [878] = 819,
  [879] = 879,
  [880] = 880,
  [881] = 790,
  [882] = 882,
  [883] = 879,
  [884] = 879,
  [885] = 885,
  [886] = 886,
  [887] = 792,
  [888] = 791,
  [889] = 885,
  [890] = 885,
  [891] = 792,
  [892] = 886,
  [893] = 886,
  [894] = 894,
  [895] = 796,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 796,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 828,
  [918] = 829,
  [919] = 830,
  [920] = 831,
  [921] = 827,
  [922] = 922,
  [923] = 923,
  [924] = 804,
  [925] = 925,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 818,
  [937] = 806,
  [938] = 810,
  [939] = 812,
  [940] = 940,
  [941] = 941,
  [942] = 815,
  [943] = 943,
  [944] = 819,
  [945] = 945,
  [946] = 822,
  [947] = 947,
  [948] = 948,
  [949] = 949,
  [950] = 807,
  [951] = 951,
  [952] = 952,
  [953] = 808,
  [954] = 809,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 958,
  [959] = 959,
  [960] = 960,
  [961] = 811,
  [962] = 962,
  [963] = 963,
  [964] = 964,
  [965] = 965,
  [966] = 966,
  [967] = 967,
  [968] = 813,
  [969] = 969,
  [970] = 970,
  [971] = 971,
  [972] = 791,
  [973] = 814,
  [974] = 974,
  [975] = 975,
  [976] = 945,
  [977] = 977,
  [978] = 978,
  [979] = 790,
  [980] = 816,
  [981] = 981,
  [982] = 982,
  [983] = 817,
  [984] = 984,
  [985] = 985,
  [986] = 986,
  [987] = 987,
  [988] = 988,
  [989] = 820,
  [990] = 990,
  [991] = 991,
  [992] = 821,
  [993] = 993,
  [994] = 994,
  [995] = 995,
  [996] = 996,
  [997] = 997,
  [998] = 998,
  [999] = 823,
  [1000] = 824,
  [1001] = 825,
  [1002] = 826,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 855,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 855,
  [1023] = 1021,
  [1024] = 1024,
  [1025] = 1021,
  [1026] = 1024,
  [1027] = 1020,
  [1028] = 1028,
  [1029] = 1029,
  [1030] = 1030,
  [1031] = 855,
  [1032] = 855,
  [1033] = 1029,
  [1034] = 1034,
  [1035] = 1020,
  [1036] = 1036,
  [1037] = 1037,
  [1038] = 1024,
  [1039] = 1039,
  [1040] = 1030,
  [1041] = 855,
  [1042] = 1042,
  [1043] = 1039,
  [1044] = 959,
  [1045] = 1045,
  [1046] = 1046,
  [1047] = 1030,
  [1048] = 915,
  [1049] = 914,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 249,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1051,
  [1068] = 894,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 1050,
  [1072] = 880,
  [1073] = 1052,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1051,
  [1079] = 1079,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1051,
  [1084] = 894,
  [1085] = 1085,
  [1086] = 880,
  [1087] = 1052,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 880,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1051,
  [1096] = 894,
  [1097] = 1050,
  [1098] = 1050,
  [1099] = 880,
  [1100] = 1052,
  [1101] = 1101,
  [1102] = 252,
  [1103] = 1088,
  [1104] = 894,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1051,
  [1108] = 894,
  [1109] = 248,
  [1110] = 1060,
  [1111] = 1050,
  [1112] = 1069,
  [1113] = 880,
  [1114] = 1052,
  [1115] = 1115,
  [1116] = 1050,
  [1117] = 1007,
  [1118] = 1051,
  [1119] = 1050,
  [1120] = 1052,
  [1121] = 250,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 923,
  [1128] = 1128,
  [1129] = 1091,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 977,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 1124,
  [1138] = 1136,
  [1139] = 1139,
  [1140] = 1140,
  [1141] = 1140,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1144,
  [1145] = 1145,
  [1146] = 1145,
  [1147] = 1147,
  [1148] = 1148,
  [1149] = 1149,
  [1150] = 1150,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 1155,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 1158,
  [1159] = 1159,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1152,
  [1163] = 1135,
  [1164] = 1164,
  [1165] = 1140,
  [1166] = 1144,
  [1167] = 1167,
  [1168] = 1145,
  [1169] = 1123,
  [1170] = 1170,
  [1171] = 1076,
  [1172] = 1142,
  [1173] = 1144,
  [1174] = 1135,
  [1175] = 1175,
  [1176] = 1176,
  [1177] = 1160,
  [1178] = 1161,
  [1179] = 1152,
  [1180] = 1135,
  [1181] = 1140,
  [1182] = 1144,
  [1183] = 1183,
  [1184] = 1167,
  [1185] = 1145,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 790,
  [1189] = 1143,
  [1190] = 1190,
  [1191] = 1064,
  [1192] = 1161,
  [1193] = 1160,
  [1194] = 1194,
  [1195] = 1161,
  [1196] = 1152,
  [1197] = 1197,
  [1198] = 1135,
  [1199] = 1140,
  [1200] = 1140,
  [1201] = 1144,
  [1202] = 1167,
  [1203] = 1126,
  [1204] = 1145,
  [1205] = 1142,
  [1206] = 1160,
  [1207] = 1207,
  [1208] = 1150,
  [1209] = 1144,
  [1210] = 1081,
  [1211] = 1053,
  [1212] = 1054,
  [1213] = 1143,
  [1214] = 1167,
  [1215] = 1215,
  [1216] = 1216,
  [1217] = 1161,
  [1218] = 1145,
  [1219] = 1219,
  [1220] = 791,
  [1221] = 1160,
  [1222] = 1150,
  [1223] = 1152,
  [1224] = 1160,
  [1225] = 1135,
  [1226] = 791,
  [1227] = 1149,
  [1228] = 1167,
  [1229] = 1216,
  [1230] = 1230,
  [1231] = 1151,
  [1232] = 1122,
  [1233] = 1161,
  [1234] = 1128,
  [1235] = 1066,
  [1236] = 1136,
  [1237] = 1237,
  [1238] = 1152,
  [1239] = 1239,
  [1240] = 1045,
  [1241] = 1065,
  [1242] = 1167,
  [1243] = 1243,
  [1244] = 1244,
  [1245] = 1245,
  [1246] = 1246,
  [1247] = 1244,
  [1248] = 1248,
  [1249] = 1243,
  [1250] = 1250,
  [1251] = 1248,
  [1252] = 1252,
  [1253] = 1015,
  [1254] = 1016,
  [1255] = 1255,
  [1256] = 1255,
  [1257] = 1257,
  [1258] = 1258,
  [1259] = 1255,
  [1260] = 1252,
  [1261] = 1261,
  [1262] = 1244,
  [1263] = 1263,
  [1264] = 1264,
  [1265] = 1248,
  [1266] = 1255,
  [1267] = 1248,
  [1268] = 1258,
  [1269] = 1269,
  [1270] = 1270,
  [1271] = 1243,
  [1272] = 1258,
  [1273] = 1273,
  [1274] = 1274,
  [1275] = 1255,
  [1276] = 1003,
  [1277] = 1277,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1280,
  [1281] = 970,
  [1282] = 1282,
  [1283] = 1283,
  [1284] = 1017,
  [1285] = 1248,
  [1286] = 1286,
  [1287] = 1287,
  [1288] = 1288,
  [1289] = 1289,
  [1290] = 1280,
  [1291] = 1291,
  [1292] = 1258,
  [1293] = 1258,
  [1294] = 1280,
  [1295] = 1258,
  [1296] = 1296,
  [1297] = 1297,
  [1298] = 1298,
  [1299] = 1299,
  [1300] = 1280,
  [1301] = 1301,
  [1302] = 1244,
  [1303] = 1280,
  [1304] = 1304,
  [1305] = 1280,
  [1306] = 1283,
  [1307] = 1244,
  [1308] = 1308,
  [1309] = 1248,
  [1310] = 1310,
  [1311] = 1283,
  [1312] = 1283,
  [1313] = 1255,
  [1314] = 1283,
  [1315] = 1283,
  [1316] = 1244,
  [1317] = 1317,
  [1318] = 1318,
  [1319] = 1319,
  [1320] = 1320,
  [1321] = 1321,
  [1322] = 1322,
  [1323] = 1323,
  [1324] = 1324,
  [1325] = 1325,
  [1326] = 1318,
  [1327] = 1325,
  [1328] = 1324,
  [1329] = 1318,
  [1330] = 1330,
  [1331] = 1331,
  [1332] = 1332,
  [1333] = 1333,
  [1334] = 1319,
  [1335] = 1318,
  [1336] = 1333,
  [1337] = 1337,
  [1338] = 1318,
  [1339] = 1319,
  [1340] = 1333,
  [1341] = 1341,
  [1342] = 1342,
  [1343] = 1321,
  [1344] = 1344,
  [1345] = 1345,
  [1346] = 1319,
  [1347] = 1324,
  [1348] = 1324,
  [1349] = 1349,
  [1350] = 1331,
  [1351] = 1351,
  [1352] = 1352,
  [1353] = 1318,
  [1354] = 1354,
  [1355] = 1321,
  [1356] = 1342,
  [1357] = 1319,
  [1358] = 1358,
  [1359] = 1321,
  [1360] = 1360,
  [1361] = 1342,
  [1362] = 1325,
  [1363] = 1317,
  [1364] = 1352,
  [1365] = 1365,
  [1366] = 1322,
  [1367] = 1367,
  [1368] = 1368,
  [1369] = 1319,
  [1370] = 1370,
  [1371] = 1352,
  [1372] = 1372,
  [1373] = 1373,
  [1374] = 1374,
  [1375] = 1352,
  [1376] = 1376,
  [1377] = 1325,
  [1378] = 1325,
  [1379] = 1352,
  [1380] = 1365,
  [1381] = 1321,
  [1382] = 1319,
  [1383] = 1321,
  [1384] = 1384,
  [1385] = 1385,
  [1386] = 1386,
  [1387] = 1324,
  [1388] = 1352,
  [1389] = 1322,
  [1390] = 1390,
  [1391] = 1391,
  [1392] = 1392,
  [1393] = 1317,
  [1394] = 1394,
  [1395] = 1317,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1324,
  [1399] = 1317,
  [1400] = 1325,
  [1401] = 1317,
  [1402] = 1402,
  [1403] = 1365,
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6},
  {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f}, {0x671, 0x6d3},
  {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f}, {0x74d, 0x7a5},
  {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824}, {0x828, 0x828},
  {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950},
  {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10},
  {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa72, 0xa74},
  {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0},
  {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95},
  {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0}, {0xc05, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61}, {0xc80, 0xc80},
  {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde}, {0xce0, 0xce1},
  {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd5f, 0xd61},
  {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30}, {0xe32, 0xe32},
  {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb2},
  {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c}, {0xf88, 0xf8c},
  {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081},
  {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd},
  {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751},
  {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x18a8}, {0x18aa, 0x18aa},
  {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54},
  {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f},
  {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa},
  {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x2102, 0x2102},
  {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25},
  {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6},
  {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029}, {0x3031, 0x3035},
  {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e},
  {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9},
  {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb},
  {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef},
  {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1},
  {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06},
  {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xd7a3},
  {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28},
  {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d},
  {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf},
  {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d},
  {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d},
  {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
  {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808},
  {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5},
  {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27},
  {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11075, 0x11075}, {0x11083, 0x110af},
  {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176}, {0x11183, 0x111b2}, {0x111c1, 0x111c4},
  {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d},
  {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333},
  {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x11461}, {0x11480, 0x114af},
  {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644}, {0x11680, 0x116aa}, {0x116b8, 0x116b8},
  {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916},
  {0x11918, 0x1192f}, {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1}, {0x119e3, 0x119e3}, {0x11a00, 0x11a00},
  {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e},
  {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68},
  {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11f02, 0x11f02}, {0x11f04, 0x11f10}, {0x11f12, 0x11f33}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399},
  {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e},
  {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a},
  {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3},
  {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb},
  {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2},
  {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514},
  {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0},
  {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8},
  {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e},
  {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, {0x1e4d0, 0x1e4eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4},
  {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32},
  {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f},
  {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62},
  {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b},
  {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0},
  {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xb7, 0xb7}, {0xba, 0xba},
  {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x300, 0x374},
  {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481},
  {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd}, {0x5bf, 0x5bf}, {0x5c1, 0x5c2},
  {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669}, {0x66e, 0x6d3}, {0x6d5, 0x6dc},
  {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5}, {0x7fa, 0x7fa}, {0x7fd, 0x7fd},
  {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1}, {0x8e3, 0x963}, {0x966, 0x96f},
  {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bc, 0x9c4},
  {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1}, {0x9fc, 0x9fc}, {0x9fe, 0x9fe},
  {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39},
  {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa66, 0xa75},
  {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabc, 0xac5},
  {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff}, {0xb01, 0xb03}, {0xb05, 0xb0c},
  {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44}, {0xb47, 0xb48}, {0xb4b, 0xb4d},
  {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90},
  {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbbe, 0xbc2},
  {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28},
  {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc63},
  {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbc, 0xcc4},
  {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef}, {0xcf1, 0xcf3}, {0xd00, 0xd0c},
  {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63}, {0xd66, 0xd6f}, {0xd7a, 0xd7f},
  {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xdca, 0xdca}, {0xdcf, 0xdd4},
  {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e}, {0xe50, 0xe59}, {0xe81, 0xe82},
  {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xec8, 0xece},
  {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35}, {0xf37, 0xf37}, {0xf39, 0xf39},
  {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6}, {0x1000, 0x1049}, {0x1050, 0x109d},
  {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258},
  {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5},
  {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371}, {0x1380, 0x138f}, {0x13a0, 0x13f5},
  {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1715}, {0x171f, 0x1734},
  {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dd}, {0x17e0, 0x17e9},
  {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b},
  {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c},
  {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c}, {0x1b50, 0x1b59}, {0x1b6b, 0x1b73},
  {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2},
  {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200c, 0x200d}, {0x203f, 0x2040}, {0x2054, 0x2054}, {0x2071, 0x2071},
  {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113},
  {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149},
  {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67},
  {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce},
  {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096},
  {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x4dbf},
  {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1}, {0xa717, 0xa71f},
  {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827}, {0xa82c, 0xa82c}, {0xa840, 0xa873},
  {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c}, {0xa980, 0xa9c0},
  {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2}, {0xaadb, 0xaadd},
  {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a},
  {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d},
  {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41},
  {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f},
  {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a}, {0xff65, 0xffbe}, {0xffc2, 0xffc7},
  {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d},
  {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102e0}, {0x10300, 0x1031f},
  {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9},
  {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595},
  {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785},
  {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855},
  {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf},
  {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a3f}, {0x10a60, 0x10a7c},
  {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48},
  {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1}, {0x10efd, 0x10f1c},
  {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075}, {0x1107f, 0x110ba},
  {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, {0x11150, 0x11173}, {0x11176, 0x11176},
  {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x11241}, {0x11280, 0x11286},
  {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c},
  {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d},
  {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, {0x11450, 0x11459}, {0x1145e, 0x11461},
  {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640}, {0x11644, 0x11644},
  {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11740, 0x11746}, {0x11800, 0x1183a},
  {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938}, {0x1193b, 0x11943},
  {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a47, 0x11a47}, {0x11a50, 0x11a99},
  {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7},
  {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, {0x11d50, 0x11d59},
  {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6}, {0x11f00, 0x11f10},
  {0x11f12, 0x11f3a}, {0x11f3e, 0x11f42}, {0x11f50, 0x11f59}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0},
  {0x13000, 0x1342f}, {0x13440, 0x13455}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe}, {0x16ac0, 0x16ac9},
  {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f},
  {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1}, {0x17000, 0x187f7}, {0x18800, 0x18cd5},
  {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155},
  {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d},
  {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1d400, 0x1d454},
  {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3},
  {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546},
  {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e},
  {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c},
  {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018},
  {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, {0x1e08f, 0x1e08f}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149},
  {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe},
  {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24},
  {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49},
  {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d},
  {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e},
  {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739},
  {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af}, {0xe0100, 0xe01ef},
};

static TSCharacterRange sym_rune_literal_character_set_1[] = {
  {'"', '"'}, {'\'', '\''}, {'0', '7'}, {'U', 'U'}, {'\\', '\\'}, {'a', 'b'}, {'f', 'f'}, {'n', 'n'},
  {'r', 'r'}, {'t', 'v'}, {'x', 'x'},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(60);
      ADVANCE_MAP(
        0, 63,
        '!', 107,
        '"', 138,
        '%', 116,
        '&', 111,
        '\'', 22,
        '(', 67,
        ')', 68,
        '*', 76,
        '+', 101,
        ',', 69,
        '-', 104,
        '.', 66,
        '/', 114,
        '0', 147,
        ':', 99,
        ';', 62,
        '<', 125,
        '=', 71,
        '>', 130,
        '[', 72,
        '\\', 20,
        ']', 73,
        '^', 109,
        '`', 26,
        '{', 78,
        '|', 81,
        '}', 79,
        '~', 77,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(58);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(149);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(135);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        0, 63,
        '\n', 61,
        '!', 17,
        '%', 115,
        '&', 112,
        '(', 67,
        '*', 75,
        '+', 100,
        ',', 69,
        '-', 103,
        '.', 64,
        '/', 113,
        ';', 62,
        '<', 128,
        '=', 19,
        '>', 131,
        '[', 72,
        '^', 108,
        '{', 78,
        '|', 82,
        '}', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(135);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(16);
      if (lookahead == '"') ADVANCE(138);
      if (lookahead == '/') ADVANCE(139);
      if (lookahead == '\\') ADVANCE(20);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(142);
      if (lookahead != 0) ADVANCE(143);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 17,
        '"', 137,
        '%', 115,
        '&', 112,
        '(', 67,
        ')', 68,
        '*', 75,
        '+', 100,
        ',', 69,
        '-', 103,
        '.', 65,
        '/', 113,
        ':', 99,
        '<', 126,
        '=', 71,
        '>', 131,
        '[', 72,
        ']', 73,
        '^', 108,
        '`', 26,
        '{', 78,
        '|', 82,
        '~', 77,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(135);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 17,
        '%', 116,
        '&', 111,
        '(', 67,
        '*', 76,
        '+', 101,
        ',', 69,
        '-', 104,
        '.', 64,
        '/', 114,
        ':', 18,
        ';', 62,
        '<', 125,
        '=', 71,
        '>', 130,
        '[', 72,
        '^', 109,
        '{', 78,
        '|', 81,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 17,
        '%', 116,
        '&', 111,
        '(', 67,
        '*', 76,
        '+', 102,
        ',', 69,
        '-', 105,
        '.', 64,
        '/', 114,
        ':', 18,
        '<', 127,
        '=', 71,
        '>', 130,
        '[', 72,
        '^', 109,
        '{', 78,
        '|', 81,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 17,
        '%', 115,
        '&', 112,
        '(', 67,
        ')', 68,
        '*', 75,
        '+', 100,
        ',', 69,
        '-', 103,
        '.', 65,
        '/', 113,
        ':', 99,
        ';', 62,
        '<', 128,
        '=', 71,
        '>', 131,
        '[', 72,
        ']', 73,
        '^', 108,
        '{', 78,
        '|', 82,
        '}', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      END_STATE();
    case 7:
      if (lookahead == '\'') ADVANCE(157);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(159);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead == '/') ADVANCE(158);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 11:
      if (lookahead == '-') ADVANCE(83);
      END_STATE();
    case 12:
      if (lookahead == '.') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(153);
      END_STATE();
    case 13:
      if (lookahead == '.') ADVANCE(155);
      if (lookahead == '_') ADVANCE(36);
      if (lookahead == 'i') ADVANCE(156);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(13);
      END_STATE();
    case 14:
      if (lookahead == '.') ADVANCE(74);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == '_') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(150);
      END_STATE();
    case 16:
      if (lookahead == '/') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16);
      END_STATE();
    case 17:
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 18:
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 20:
      if (lookahead == 'U') ADVANCE(54);
      if (lookahead == 'u') ADVANCE(46);
      if (lookahead == 'x') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      if (lookahead != 0) ADVANCE(144);
      END_STATE();
    case 21:
      if (lookahead == 'U') ADVANCE(55);
      if (lookahead == 'u') ADVANCE(47);
      if (lookahead == 'x') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(33);
      if (set_contains(sym_rune_literal_character_set_1, 11, lookahead)) ADVANCE(7);
      END_STATE();
    case 22:
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(7);
      END_STATE();
    case 23:
      if (lookahead == '_') ADVANCE(29);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(151);
      END_STATE();
    case 24:
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(24);
      END_STATE();
    case 25:
      if (lookahead == '_') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(152);
      END_STATE();
    case 26:
      if (lookahead == '`') ADVANCE(136);
      if (lookahead != 0) ADVANCE(26);
      END_STATE();
    case 27:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(154);
      END_STATE();
    case 28:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(24);
      END_STATE();
    case 29:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(151);
      END_STATE();
    case 30:
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(13);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(148);
      END_STATE();
    case 31:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(7);
      END_STATE();
    case 32:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(152);
      END_STATE();
    case 33:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(31);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(149);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(153);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(13);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(154);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(7);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(144);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(150);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(24);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(38);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 56:
      if (eof) ADVANCE(60);
      ADVANCE_MAP(
        0, 63,
        '\n', 61,
        '!', 106,
        '"', 137,
        '&', 110,
        '\'', 22,
        '(', 67,
        ')', 68,
        '*', 75,
        '+', 100,
        ',', 69,
        '-', 103,
        '.', 35,
        '/', 8,
        '0', 147,
        ';', 62,
        '<', 11,
        '=', 70,
        '[', 72,
        '^', 108,
        '`', 26,
        '{', 78,
        '|', 80,
        '}', 79,
        '~', 77,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(56);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(149);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(135);
      END_STATE();
    case 57:
      if (eof) ADVANCE(60);
      ADVANCE_MAP(
        0, 63,
        '\n', 61,
        '!', 17,
        '"', 137,
        '%', 116,
        '&', 111,
        '(', 67,
        ')', 68,
        '*', 76,
        '+', 101,
        ',', 69,
        '-', 104,
        '.', 64,
        '/', 114,
        ':', 99,
        ';', 62,
        '<', 125,
        '=', 71,
        '>', 130,
        '[', 72,
        '^', 109,
        '`', 26,
        '{', 78,
        '|', 81,
        '}', 79,
        '~', 77,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(57);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(135);
      END_STATE();
    case 58:
      if (eof) ADVANCE(60);
      ADVANCE_MAP(
        0, 63,
        '!', 107,
        '"', 137,
        '%', 116,
        '&', 111,
        '\'', 22,
        '(', 67,
        ')', 68,
        '*', 76,
        '+', 101,
        ',', 69,
        '-', 104,
        '.', 66,
        '/', 114,
        '0', 147,
        ':', 99,
        ';', 62,
        '<', 125,
        '=', 71,
        '>', 130,
        '[', 72,
        ']', 73,
        '^', 109,
        '`', 26,
        '{', 78,
        '|', 81,
        '}', 79,
        '~', 77,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(58);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(149);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(135);
      END_STATE();
    case 59:
      if (eof) ADVANCE(60);
      ADVANCE_MAP(
        '!', 106,
        '"', 137,
        '&', 110,
        '\'', 22,
        '(', 67,
        ')', 68,
        '*', 75,
        '+', 100,
        ',', 69,
        '-', 103,
        '.', 12,
        '/', 8,
        '0', 147,
        ':', 98,
        ';', 62,
        '<', 11,
        '[', 72,
        ']', 73,
        '^', 108,
        '`', 26,
        '{', 78,
        '}', 79,
        '~', 77,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(59);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(149);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(135);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(61);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_NULL);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(14);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(153);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(87);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(96);
      if (lookahead == '|') ADVANCE(134);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(134);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_AMP_CARET_EQ);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(85);
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(133);
      if (lookahead == '=') ADVANCE(92);
      if (lookahead == '^') ADVANCE(122);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(133);
      if (lookahead == '^') ADVANCE(121);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(159);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(159);
      if (lookahead == '=') ADVANCE(88);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(89);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(90);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(91);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_AMP_CARET);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_AMP_CARET);
      if (lookahead == '=') ADVANCE(93);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '<') ADVANCE(118);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '<') ADVANCE(117);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(118);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(117);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(132);
      if (lookahead == '>') ADVANCE(120);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(132);
      if (lookahead == '>') ADVANCE(119);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_identifier);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(135);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_raw_string_literal);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym__interpreted_string_literal_basic_content);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(143);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym__interpreted_string_literal_basic_content);
      if (lookahead == '*') ADVANCE(140);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(141);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym__interpreted_string_literal_basic_content);
      if (lookahead == '*') ADVANCE(140);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(141);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym__interpreted_string_literal_basic_content);
      if (lookahead == '/') ADVANCE(139);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(142);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(143);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym__interpreted_string_literal_basic_content);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(144);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(145);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_int_literal);
      ADVANCE_MAP(
        '.', 155,
        '_', 30,
        'i', 156,
        'B', 23,
        'b', 23,
        'E', 27,
        'e', 27,
        'O', 25,
        'o', 25,
        'X', 15,
        'x', 15,
        '8', 13,
        '9', 13,
      );
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(148);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(155);
      if (lookahead == '_') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(156);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(13);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(148);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(155);
      if (lookahead == '_') ADVANCE(34);
      if (lookahead == 'i') ADVANCE(156);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(149);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(28);
      if (lookahead == '_') ADVANCE(40);
      if (lookahead == 'i') ADVANCE(156);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(150);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(156);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(151);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(32);
      if (lookahead == 'i') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(152);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == '_') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(156);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(153);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == '_') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(154);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == 'i') ADVANCE(156);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(153);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_imaginary_literal);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_rune_literal);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(159);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        '_', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'g', 7,
        'i', 8,
        'm', 9,
        'n', 10,
        'p', 11,
        'r', 12,
        's', 13,
        't', 14,
        'v', 15,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      ACCEPT_TOKEN(sym_blank_identifier);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(16);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(17);
      if (lookahead == 'h') ADVANCE(18);
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(20);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(21);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'u') ADVANCE(24);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(26);
      if (lookahead == 'm') ADVANCE(27);
      if (lookahead == 'n') ADVANCE(28);
      if (lookahead == 'o') ADVANCE(29);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(30);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(32);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(33);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'e') ADVANCE(35);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(36);
      if (lookahead == 't') ADVANCE(37);
      if (lookahead == 'w') ADVANCE(38);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(39);
      if (lookahead == 'y') ADVANCE(40);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(41);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 17:
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(44);
      END_STATE();
    case 19:
      if (lookahead == 'n') ADVANCE(45);
      END_STATE();
    case 20:
      if (lookahead == 'f') ADVANCE(46);
      END_STATE();
    case 21:
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 22:
      if (lookahead == 'l') ADVANCE(48);
      END_STATE();
    case 23:
      if (lookahead == 'r') ADVANCE(49);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(50);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_go);
      if (lookahead == 't') ADVANCE(51);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 27:
      if (lookahead == 'p') ADVANCE(52);
      END_STATE();
    case 28:
      if (lookahead == 't') ADVANCE(53);
      END_STATE();
    case 29:
      if (lookahead == 't') ADVANCE(54);
      END_STATE();
    case 30:
      if (lookahead == 'k') ADVANCE(55);
      if (lookahead == 'p') ADVANCE(56);
      END_STATE();
    case 31:
      if (lookahead == 'w') ADVANCE(57);
      END_STATE();
    case 32:
      if (lookahead == 'l') ADVANCE(58);
      END_STATE();
    case 33:
      if (lookahead == 'c') ADVANCE(59);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 36:
      if (lookahead == 'l') ADVANCE(62);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(63);
      END_STATE();
    case 38:
      if (lookahead == 'i') ADVANCE(64);
      END_STATE();
    case 39:
      if (lookahead == 'u') ADVANCE(65);
      END_STATE();
    case 40:
      if (lookahead == 'p') ADVANCE(66);
      END_STATE();
    case 41:
      if (lookahead == 'r') ADVANCE(67);
      END_STATE();
    case 42:
      if (lookahead == 'a') ADVANCE(68);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(69);
      END_STATE();
    case 44:
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(71);
      if (lookahead == 't') ADVANCE(72);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(73);
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(75);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(76);
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 50:
      if (lookahead == 'c') ADVANCE(78);
      END_STATE();
    case 51:
      if (lookahead == 'o') ADVANCE(79);
      END_STATE();
    case 52:
      if (lookahead == 'o') ADVANCE(80);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(81);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(82);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_map);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 59:
      if (lookahead == 'k') ADVANCE(84);
      END_STATE();
    case 60:
      if (lookahead == 'g') ADVANCE(85);
      END_STATE();
    case 61:
      if (lookahead == 'u') ADVANCE(86);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(87);
      END_STATE();
    case 63:
      if (lookahead == 'u') ADVANCE(88);
      END_STATE();
    case 64:
      if (lookahead == 't') ADVANCE(89);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(91);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 68:
      if (lookahead == 'k') ADVANCE(92);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_chan);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(93);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 73:
      if (lookahead == 'u') ADVANCE(95);
      END_STATE();
    case 74:
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 76:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_func);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 80:
      if (lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 81:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_iota);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_make);
      END_STATE();
    case 84:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 86:
      if (lookahead == 'r') ADVANCE(103);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(104);
      END_STATE();
    case 88:
      if (lookahead == 'c') ADVANCE(105);
      END_STATE();
    case 89:
      if (lookahead == 'c') ADVANCE(106);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 94:
      if (lookahead == 'n') ADVANCE(107);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(108);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_defer);
      END_STATE();
    case 97:
      if (lookahead == 'h') ADVANCE(109);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 100:
      if (lookahead == 'f') ADVANCE(111);
      END_STATE();
    case 101:
      if (lookahead == 'g') ADVANCE(112);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_range);
      END_STATE();
    case 103:
      if (lookahead == 'n') ADVANCE(113);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(114);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 106:
      if (lookahead == 'h') ADVANCE(116);
      END_STATE();
    case 107:
      if (lookahead == 'u') ADVANCE(117);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(118);
      END_STATE();
    case 109:
      if (lookahead == 'r') ADVANCE(119);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 111:
      if (lookahead == 'a') ADVANCE(120);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_select);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(122);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 119:
      if (lookahead == 'o') ADVANCE(123);
      END_STATE();
    case 120:
      if (lookahead == 'c') ADVANCE(124);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 123:
      if (lookahead == 'u') ADVANCE(125);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 125:
      if (lookahead == 'g') ADVANCE(127);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 127:
      if (lookahead == 'h') ADVANCE(128);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_fallthrough);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 59},
  [2] = {.lex_state = 59},
  [3] = {.lex_state = 59},
  [4] = {.lex_state = 59},
  [5] = {.lex_state = 59},
  [6] = {.lex_state = 59},
  [7] = {.lex_state = 59},
  [8] = {.lex_state = 59},
  [9] = {.lex_state = 59},
  [10] = {.lex_state = 59},
  [11] = {.lex_state = 59},
  [12] = {.lex_state = 59},
  [13] = {.lex_state = 59},
  [14] = {.lex_state = 59},
  [15] = {.lex_state = 59},
  [16] = {.lex_state = 59},
  [17] = {.lex_state = 59},
  [18] = {.lex_state = 59},
  [19] = {.lex_state = 59},
  [20] = {.lex_state = 59},
  [21] = {.lex_state = 59},
  [22] = {.lex_state = 59},
  [23] = {.lex_state = 59},
  [24] = {.lex_state = 59},
  [25] = {.lex_state = 59},
  [26] = {.lex_state = 59},
  [27] = {.lex_state = 59},
  [28] = {.lex_state = 56},
  [29] = {.lex_state = 59},
  [30] = {.lex_state = 59},
  [31] = {.lex_state = 59},
  [32] = {.lex_state = 59},
  [33] = {.lex_state = 59},
  [34] = {.lex_state = 59},
  [35] = {.lex_state = 59},
  [36] = {.lex_state = 59},
  [37] = {.lex_state = 59},
  [38] = {.lex_state = 59},
  [39] = {.lex_state = 59},
  [40] = {.lex_state = 59},
  [41] = {.lex_state = 59},
  [42] = {.lex_state = 59},
  [43] = {.lex_state = 59},
  [44] = {.lex_state = 59},
  [45] = {.lex_state = 59},
  [46] = {.lex_state = 59},
  [47] = {.lex_state = 59},
  [48] = {.lex_state = 59},
  [49] = {.lex_state = 59},
  [50] = {.lex_state = 59},
  [51] = {.lex_state = 59},
  [52] = {.lex_state = 59},
  [53] = {.lex_state = 59},
  [54] = {.lex_state = 59},
  [55] = {.lex_state = 59},
  [56] = {.lex_state = 59},
  [57] = {.lex_state = 59},
  [58] = {.lex_state = 59},
  [59] = {.lex_state = 59},
  [60] = {.lex_state = 59},
  [61] = {.lex_state = 59},
  [62] = {.lex_state = 59},
  [63] = {.lex_state = 59},
  [64] = {.lex_state = 59},
  [65] = {.lex_state = 59},
  [66] = {.lex_state = 59},
  [67] = {.lex_state = 59},
  [68] = {.lex_state = 59},
  [69] = {.lex_state = 59},
  [70] = {.lex_state = 59},
  [71] = {.lex_state = 59},
  [72] = {.lex_state = 59},
  [73] = {.lex_state = 59},
  [74] = {.lex_state = 59},
  [75] = {.lex_state = 59},
  [76] = {.lex_state = 59},
  [77] = {.lex_state = 59},
  [78] = {.lex_state = 59},
  [79] = {.lex_state = 59},
  [80] = {.lex_state = 59},
  [81] = {.lex_state = 59},
  [82] = {.lex_state = 59},
  [83] = {.lex_state = 59},
  [84] = {.lex_state = 59},
  [85] = {.lex_state = 59},
  [86] = {.lex_state = 59},
  [87] = {.lex_state = 59},
  [88] = {.lex_state = 59},
  [89] = {.lex_state = 59},
  [90] = {.lex_state = 59},
  [91] = {.lex_state = 59},
  [92] = {.lex_state = 59},
  [93] = {.lex_state = 59},
  [94] = {.lex_state = 59},
  [95] = {.lex_state = 59},
  [96] = {.lex_state = 59},
  [97] = {.lex_state = 59},
  [98] = {.lex_state = 59},
  [99] = {.lex_state = 59},
  [100] = {.lex_state = 59},
  [101] = {.lex_state = 59},
  [102] = {.lex_state = 59},
  [103] = {.lex_state = 59},
  [104] = {.lex_state = 59},
  [105] = {.lex_state = 59},
  [106] = {.lex_state = 59},
  [107] = {.lex_state = 59},
  [108] = {.lex_state = 59},
  [109] = {.lex_state = 59},
  [110] = {.lex_state = 59},
  [111] = {.lex_state = 59},
  [112] = {.lex_state = 59},
  [113] = {.lex_state = 59},
  [114] = {.lex_state = 59},
  [115] = {.lex_state = 59},
  [116] = {.lex_state = 59},
  [117] = {.lex_state = 59},
  [118] = {.lex_state = 59},
  [119] = {.lex_state = 59},
  [120] = {.lex_state = 59},
  [121] = {.lex_state = 59},
  [122] = {.lex_state = 59},
  [123] = {.lex_state = 59},
  [124] = {.lex_state = 59},
  [125] = {.lex_state = 59},
  [126] = {.lex_state = 59},
  [127] = {.lex_state = 59},
  [128] = {.lex_state = 59},
  [129] = {.lex_state = 59},
  [130] = {.lex_state = 59},
  [131] = {.lex_state = 59},
  [132] = {.lex_state = 59},
  [133] = {.lex_state = 59},
  [134] = {.lex_state = 59},
  [135] = {.lex_state = 59},
  [136] = {.lex_state = 59},
  [137] = {.lex_state = 59},
  [138] = {.lex_state = 59},
  [139] = {.lex_state = 59},
  [140] = {.lex_state = 59},
  [141] = {.lex_state = 59},
  [142] = {.lex_state = 59},
  [143] = {.lex_state = 59},
  [144] = {.lex_state = 59},
  [145] = {.lex_state = 59},
  [146] = {.lex_state = 59},
  [147] = {.lex_state = 59},
  [148] = {.lex_state = 59},
  [149] = {.lex_state = 59},
  [150] = {.lex_state = 59},
  [151] = {.lex_state = 59},
  [152] = {.lex_state = 59},
  [153] = {.lex_state = 59},
  [154] = {.lex_state = 59},
  [155] = {.lex_state = 59},
  [156] = {.lex_state = 59},
  [157] = {.lex_state = 59},
  [158] = {.lex_state = 59},
  [159] = {.lex_state = 59},
  [160] = {.lex_state = 59},
  [161] = {.lex_state = 59},
  [162] = {.lex_state = 59},
  [163] = {.lex_state = 59},
  [164] = {.lex_state = 59},
  [165] = {.lex_state = 59},
  [166] = {.lex_state = 59},
  [167] = {.lex_state = 59},
  [168] = {.lex_state = 59},
  [169] = {.lex_state = 59},
  [170] = {.lex_state = 59},
  [171] = {.lex_state = 59},
  [172] = {.lex_state = 59},
  [173] = {.lex_state = 59},
  [174] = {.lex_state = 59},
  [175] = {.lex_state = 59},
  [176] = {.lex_state = 59},
  [177] = {.lex_state = 59},
  [178] = {.lex_state = 59},
  [179] = {.lex_state = 59},
  [180] = {.lex_state = 59},
  [181] = {.lex_state = 59},
  [182] = {.lex_state = 59},
  [183] = {.lex_state = 59},
  [184] = {.lex_state = 59},
  [185] = {.lex_state = 59},
  [186] = {.lex_state = 59},
  [187] = {.lex_state = 59},
  [188] = {.lex_state = 59},
  [189] = {.lex_state = 59},
  [190] = {.lex_state = 59},
  [191] = {.lex_state = 59},
  [192] = {.lex_state = 59},
  [193] = {.lex_state = 59},
  [194] = {.lex_state = 59},
  [195] = {.lex_state = 59},
  [196] = {.lex_state = 59},
  [197] = {.lex_state = 59},
  [198] = {.lex_state = 59},
  [199] = {.lex_state = 59},
  [200] = {.lex_state = 59},
  [201] = {.lex_state = 59},
  [202] = {.lex_state = 59},
  [203] = {.lex_state = 59},
  [204] = {.lex_state = 59},
  [205] = {.lex_state = 59},
  [206] = {.lex_state = 59},
  [207] = {.lex_state = 59},
  [208] = {.lex_state = 59},
  [209] = {.lex_state = 59},
  [210] = {.lex_state = 59},
  [211] = {.lex_state = 59},
  [212] = {.lex_state = 59},
  [213] = {.lex_state = 59},
  [214] = {.lex_state = 59},
  [215] = {.lex_state = 59},
  [216] = {.lex_state = 59},
  [217] = {.lex_state = 59},
  [218] = {.lex_state = 59},
  [219] = {.lex_state = 59},
  [220] = {.lex_state = 59},
  [221] = {.lex_state = 59},
  [222] = {.lex_state = 59},
  [223] = {.lex_state = 59},
  [224] = {.lex_state = 59},
  [225] = {.lex_state = 59},
  [226] = {.lex_state = 59},
  [227] = {.lex_state = 59},
  [228] = {.lex_state = 59},
  [229] = {.lex_state = 59},
  [230] = {.lex_state = 59},
  [231] = {.lex_state = 59},
  [232] = {.lex_state = 59},
  [233] = {.lex_state = 59},
  [234] = {.lex_state = 59},
  [235] = {.lex_state = 59},
  [236] = {.lex_state = 3},
  [237] = {.lex_state = 57},
  [238] = {.lex_state = 57},
  [239] = {.lex_state = 57},
  [240] = {.lex_state = 57},
  [241] = {.lex_state = 57},
  [242] = {.lex_state = 57},
  [243] = {.lex_state = 57},
  [244] = {.lex_state = 57},
  [245] = {.lex_state = 59},
  [246] = {.lex_state = 57},
  [247] = {.lex_state = 57},
  [248] = {.lex_state = 57},
  [249] = {.lex_state = 57},
  [250] = {.lex_state = 57},
  [251] = {.lex_state = 57},
  [252] = {.lex_state = 57},
  [253] = {.lex_state = 57},
  [254] = {.lex_state = 57},
  [255] = {.lex_state = 4},
  [256] = {.lex_state = 57},
  [257] = {.lex_state = 57},
  [258] = {.lex_state = 57},
  [259] = {.lex_state = 4},
  [260] = {.lex_state = 57},
  [261] = {.lex_state = 57},
  [262] = {.lex_state = 57},
  [263] = {.lex_state = 57},
  [264] = {.lex_state = 57},
  [265] = {.lex_state = 57},
  [266] = {.lex_state = 57},
  [267] = {.lex_state = 57},
  [268] = {.lex_state = 57},
  [269] = {.lex_state = 57},
  [270] = {.lex_state = 57},
  [271] = {.lex_state = 57},
  [272] = {.lex_state = 57},
  [273] = {.lex_state = 57},
  [274] = {.lex_state = 57},
  [275] = {.lex_state = 57},
  [276] = {.lex_state = 57},
  [277] = {.lex_state = 57},
  [278] = {.lex_state = 57},
  [279] = {.lex_state = 57},
  [280] = {.lex_state = 57},
  [281] = {.lex_state = 57},
  [282] = {.lex_state = 57},
  [283] = {.lex_state = 57},
  [284] = {.lex_state = 57},
  [285] = {.lex_state = 57},
  [286] = {.lex_state = 57},
  [287] = {.lex_state = 57},
  [288] = {.lex_state = 57},
  [289] = {.lex_state = 4},
  [290] = {.lex_state = 4},
  [291] = {.lex_state = 4},
  [292] = {.lex_state = 4},
  [293] = {.lex_state = 4},
  [294] = {.lex_state = 4},
  [295] = {.lex_state = 4},
  [296] = {.lex_state = 4},
  [297] = {.lex_state = 4},
  [298] = {.lex_state = 4},
  [299] = {.lex_state = 4},
  [300] = {.lex_state = 4},
  [301] = {.lex_state = 4},
  [302] = {.lex_state = 4},
  [303] = {.lex_state = 4},
  [304] = {.lex_state = 4},
  [305] = {.lex_state = 4},
  [306] = {.lex_state = 4},
  [307] = {.lex_state = 4},
  [308] = {.lex_state = 4},
  [309] = {.lex_state = 4},
  [310] = {.lex_state = 4},
  [311] = {.lex_state = 4},
  [312] = {.lex_state = 4},
  [313] = {.lex_state = 4},
  [314] = {.lex_state = 4},
  [315] = {.lex_state = 4},
  [316] = {.lex_state = 4},
  [317] = {.lex_state = 4},
  [318] = {.lex_state = 4},
  [319] = {.lex_state = 4},
  [320] = {.lex_state = 4},
  [321] = {.lex_state = 4},
  [322] = {.lex_state = 4},
  [323] = {.lex_state = 4},
  [324] = {.lex_state = 4},
  [325] = {.lex_state = 4},
  [326] = {.lex_state = 4},
  [327] = {.lex_state = 4},
  [328] = {.lex_state = 4},
  [329] = {.lex_state = 4},
  [330] = {.lex_state = 4},
  [331] = {.lex_state = 4},
  [332] = {.lex_state = 4},
  [333] = {.lex_state = 4},
  [334] = {.lex_state = 4},
  [335] = {.lex_state = 4},
  [336] = {.lex_state = 4},
  [337] = {.lex_state = 5},
  [338] = {.lex_state = 5},
  [339] = {.lex_state = 5},
  [340] = {.lex_state = 5},
  [341] = {.lex_state = 5},
  [342] = {.lex_state = 5},
  [343] = {.lex_state = 5},
  [344] = {.lex_state = 5},
  [345] = {.lex_state = 5},
  [346] = {.lex_state = 5},
  [347] = {.lex_state = 5},
  [348] = {.lex_state = 5},
  [349] = {.lex_state = 5},
  [350] = {.lex_state = 5},
  [351] = {.lex_state = 5},
  [352] = {.lex_state = 5},
  [353] = {.lex_state = 5},
  [354] = {.lex_state = 5},
  [355] = {.lex_state = 5},
  [356] = {.lex_state = 5},
  [357] = {.lex_state = 5},
  [358] = {.lex_state = 5},
  [359] = {.lex_state = 5},
  [360] = {.lex_state = 5},
  [361] = {.lex_state = 5},
  [362] = {.lex_state = 5},
  [363] = {.lex_state = 5},
  [364] = {.lex_state = 5},
  [365] = {.lex_state = 5},
  [366] = {.lex_state = 5},
  [367] = {.lex_state = 5},
  [368] = {.lex_state = 5},
  [369] = {.lex_state = 5},
  [370] = {.lex_state = 5},
  [371] = {.lex_state = 5},
  [372] = {.lex_state = 5},
  [373] = {.lex_state = 5},
  [374] = {.lex_state = 5},
  [375] = {.lex_state = 5},
  [376] = {.lex_state = 5},
  [377] = {.lex_state = 5},
  [378] = {.lex_state = 5},
  [379] = {.lex_state = 5},
  [380] = {.lex_state = 5},
  [381] = {.lex_state = 5},
  [382] = {.lex_state = 5},
  [383] = {.lex_state = 5},
  [384] = {.lex_state = 56},
  [385] = {.lex_state = 57},
  [386] = {.lex_state = 56},
  [387] = {.lex_state = 6},
  [388] = {.lex_state = 6},
  [389] = {.lex_state = 6},
  [390] = {.lex_state = 6},
  [391] = {.lex_state = 56},
  [392] = {.lex_state = 56},
  [393] = {.lex_state = 6},
  [394] = {.lex_state = 6},
  [395] = {.lex_state = 1},
  [396] = {.lex_state = 6},
  [397] = {.lex_state = 6},
  [398] = {.lex_state = 6},
  [399] = {.lex_state = 6},
  [400] = {.lex_state = 6},
  [401] = {.lex_state = 6},
  [402] = {.lex_state = 6},
  [403] = {.lex_state = 6},
  [404] = {.lex_state = 6},
  [405] = {.lex_state = 6},
  [406] = {.lex_state = 6},
  [407] = {.lex_state = 6},
  [408] = {.lex_state = 6},
  [409] = {.lex_state = 6},
  [410] = {.lex_state = 6},
  [411] = {.lex_state = 6},
  [412] = {.lex_state = 6},
  [413] = {.lex_state = 6},
  [414] = {.lex_state = 6},
  [415] = {.lex_state = 6},
  [416] = {.lex_state = 6},
  [417] = {.lex_state = 6},
  [418] = {.lex_state = 6},
  [419] = {.lex_state = 6},
  [420] = {.lex_state = 6},
  [421] = {.lex_state = 6},
  [422] = {.lex_state = 6},
  [423] = {.lex_state = 6},
  [424] = {.lex_state = 6},
  [425] = {.lex_state = 6},
  [426] = {.lex_state = 6},
  [427] = {.lex_state = 6},
  [428] = {.lex_state = 6},
  [429] = {.lex_state = 6},
  [430] = {.lex_state = 6},
  [431] = {.lex_state = 1},
  [432] = {.lex_state = 6},
  [433] = {.lex_state = 1},
  [434] = {.lex_state = 1},
  [435] = {.lex_state = 0},
  [436] = {.lex_state = 1},
  [437] = {.lex_state = 6},
  [438] = {.lex_state = 1},
  [439] = {.lex_state = 1},
  [440] = {.lex_state = 1},
  [441] = {.lex_state = 1},
  [442] = {.lex_state = 6},
  [443] = {.lex_state = 6},
  [444] = {.lex_state = 6},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 1},
  [447] = {.lex_state = 1},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 3},
  [450] = {.lex_state = 3},
  [451] = {.lex_state = 1},
  [452] = {.lex_state = 3},
  [453] = {.lex_state = 1},
  [454] = {.lex_state = 56},
  [455] = {.lex_state = 56},
  [456] = {.lex_state = 56},
  [457] = {.lex_state = 1},
  [458] = {.lex_state = 1},
  [459] = {.lex_state = 1},
  [460] = {.lex_state = 3},
  [461] = {.lex_state = 3},
  [462] = {.lex_state = 3},
  [463] = {.lex_state = 3},
  [464] = {.lex_state = 1},
  [465] = {.lex_state = 1},
  [466] = {.lex_state = 1},
  [467] = {.lex_state = 0},
  [468] = {.lex_state = 1},
  [469] = {.lex_state = 1},
  [470] = {.lex_state = 1},
  [471] = {.lex_state = 1},
  [472] = {.lex_state = 1},
  [473] = {.lex_state = 1},
  [474] = {.lex_state = 1},
  [475] = {.lex_state = 1},
  [476] = {.lex_state = 1},
  [477] = {.lex_state = 1},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 1},
  [480] = {.lex_state = 1},
  [481] = {.lex_state = 1},
  [482] = {.lex_state = 6},
  [483] = {.lex_state = 1},
  [484] = {.lex_state = 1},
  [485] = {.lex_state = 1},
  [486] = {.lex_state = 1},
  [487] = {.lex_state = 3},
  [488] = {.lex_state = 0},
  [489] = {.lex_state = 1},
  [490] = {.lex_state = 1},
  [491] = {.lex_state = 56},
  [492] = {.lex_state = 56},
  [493] = {.lex_state = 56},
  [494] = {.lex_state = 1},
  [495] = {.lex_state = 3},
  [496] = {.lex_state = 1},
  [497] = {.lex_state = 1},
  [498] = {.lex_state = 1},
  [499] = {.lex_state = 56},
  [500] = {.lex_state = 56},
  [501] = {.lex_state = 1},
  [502] = {.lex_state = 1},
  [503] = {.lex_state = 1},
  [504] = {.lex_state = 1},
  [505] = {.lex_state = 1},
  [506] = {.lex_state = 1},
  [507] = {.lex_state = 1},
  [508] = {.lex_state = 1},
  [509] = {.lex_state = 1},
  [510] = {.lex_state = 0},
  [511] = {.lex_state = 6},
  [512] = {.lex_state = 6},
  [513] = {.lex_state = 6},
  [514] = {.lex_state = 6},
  [515] = {.lex_state = 3},
  [516] = {.lex_state = 6},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 6},
  [521] = {.lex_state = 6},
  [522] = {.lex_state = 6},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 56},
  [525] = {.lex_state = 6},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 6},
  [528] = {.lex_state = 3},
  [529] = {.lex_state = 3},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 3},
  [535] = {.lex_state = 6},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 3},
  [538] = {.lex_state = 3},
  [539] = {.lex_state = 3},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 6},
  [542] = {.lex_state = 6},
  [543] = {.lex_state = 3},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 3},
  [546] = {.lex_state = 6},
  [547] = {.lex_state = 0},
  [548] = {.lex_state = 3},
  [549] = {.lex_state = 6},
  [550] = {.lex_state = 6},
  [551] = {.lex_state = 6},
  [552] = {.lex_state = 3},
  [553] = {.lex_state = 3},
  [554] = {.lex_state = 3},
  [555] = {.lex_state = 3},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 6},
  [559] = {.lex_state = 6},
  [560] = {.lex_state = 6},
  [561] = {.lex_state = 6},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 6},
  [566] = {.lex_state = 3},
  [567] = {.lex_state = 3},
  [568] = {.lex_state = 3},
  [569] = {.lex_state = 3},
  [570] = {.lex_state = 3},
  [571] = {.lex_state = 3},
  [572] = {.lex_state = 3},
  [573] = {.lex_state = 3},
  [574] = {.lex_state = 3},
  [575] = {.lex_state = 3},
  [576] = {.lex_state = 3},
  [577] = {.lex_state = 3},
  [578] = {.lex_state = 3},
  [579] = {.lex_state = 3},
  [580] = {.lex_state = 3},
  [581] = {.lex_state = 3},
  [582] = {.lex_state = 3},
  [583] = {.lex_state = 3},
  [584] = {.lex_state = 3},
  [585] = {.lex_state = 3},
  [586] = {.lex_state = 3},
  [587] = {.lex_state = 3},
  [588] = {.lex_state = 3},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 6},
  [591] = {.lex_state = 3},
  [592] = {.lex_state = 3},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 6},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 6},
  [598] = {.lex_state = 6},
  [599] = {.lex_state = 6},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 6},
  [603] = {.lex_state = 6},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 6},
  [606] = {.lex_state = 6},
  [607] = {.lex_state = 6},
  [608] = {.lex_state = 6},
  [609] = {.lex_state = 6},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 6},
  [612] = {.lex_state = 6},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 6},
  [617] = {.lex_state = 6},
  [618] = {.lex_state = 6},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 6},
  [622] = {.lex_state = 6},
  [623] = {.lex_state = 6},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 6},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 6},
  [630] = {.lex_state = 6},
  [631] = {.lex_state = 6},
  [632] = {.lex_state = 6},
  [633] = {.lex_state = 6},
  [634] = {.lex_state = 6},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 6},
  [637] = {.lex_state = 6},
  [638] = {.lex_state = 6},
  [639] = {.lex_state = 6},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 6},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 6},
  [646] = {.lex_state = 6},
  [647] = {.lex_state = 6},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 6},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 6},
  [654] = {.lex_state = 6},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 6},
  [658] = {.lex_state = 6},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 6},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 6},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 6},
  [666] = {.lex_state = 6},
  [667] = {.lex_state = 6},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 6},
  [670] = {.lex_state = 6},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 6},
  [675] = {.lex_state = 6},
  [676] = {.lex_state = 6},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 6},
  [681] = {.lex_state = 6},
  [682] = {.lex_state = 6},
  [683] = {.lex_state = 6},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 6},
  [688] = {.lex_state = 6},
  [689] = {.lex_state = 6},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 6},
  [693] = {.lex_state = 6},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 6},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 56},
  [777] = {.lex_state = 56},
  [778] = {.lex_state = 56},
  [779] = {.lex_state = 56},
  [780] = {.lex_state = 56},
  [781] = {.lex_state = 56},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 56},
  [787] = {.lex_state = 56},
  [788] = {.lex_state = 56},
  [789] = {.lex_state = 56},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 57},
  [793] = {.lex_state = 57},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 56},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 56},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 56},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 56},
  [807] = {.lex_state = 56},
  [808] = {.lex_state = 56},
  [809] = {.lex_state = 56},
  [810] = {.lex_state = 56},
  [811] = {.lex_state = 56},
  [812] = {.lex_state = 56},
  [813] = {.lex_state = 56},
  [814] = {.lex_state = 56},
  [815] = {.lex_state = 56},
  [816] = {.lex_state = 56},
  [817] = {.lex_state = 56},
  [818] = {.lex_state = 56},
  [819] = {.lex_state = 56},
  [820] = {.lex_state = 56},
  [821] = {.lex_state = 56},
  [822] = {.lex_state = 56},
  [823] = {.lex_state = 56},
  [824] = {.lex_state = 56},
  [825] = {.lex_state = 56},
  [826] = {.lex_state = 56},
  [827] = {.lex_state = 56},
  [828] = {.lex_state = 56},
  [829] = {.lex_state = 56},
  [830] = {.lex_state = 56},
  [831] = {.lex_state = 56},
  [832] = {.lex_state = 3},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 3},
  [838] = {.lex_state = 3},
  [839] = {.lex_state = 57},
  [840] = {.lex_state = 57},
  [841] = {.lex_state = 3},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 3},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 3},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 3},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 3},
  [864] = {.lex_state = 3},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 56},
  [869] = {.lex_state = 56},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 3},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 56},
  [882] = {.lex_state = 3},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 57},
  [888] = {.lex_state = 56},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 57},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 56},
  [896] = {.lex_state = 56},
  [897] = {.lex_state = 56},
  [898] = {.lex_state = 56},
  [899] = {.lex_state = 56},
  [900] = {.lex_state = 56},
  [901] = {.lex_state = 56},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 56},
  [904] = {.lex_state = 56},
  [905] = {.lex_state = 56},
  [906] = {.lex_state = 56},
  [907] = {.lex_state = 56},
  [908] = {.lex_state = 56},
  [909] = {.lex_state = 56},
  [910] = {.lex_state = 56},
  [911] = {.lex_state = 56},
  [912] = {.lex_state = 56},
  [913] = {.lex_state = 56},
  [914] = {.lex_state = 56},
  [915] = {.lex_state = 56},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 56},
  [918] = {.lex_state = 56},
  [919] = {.lex_state = 56},
  [920] = {.lex_state = 56},
  [921] = {.lex_state = 56},
  [922] = {.lex_state = 56},
  [923] = {.lex_state = 56},
  [924] = {.lex_state = 56},
  [925] = {.lex_state = 56},
  [926] = {.lex_state = 56},
  [927] = {.lex_state = 56},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 56},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 56},
  [933] = {.lex_state = 56},
  [934] = {.lex_state = 56},
  [935] = {.lex_state = 56},
  [936] = {.lex_state = 56},
  [937] = {.lex_state = 56},
  [938] = {.lex_state = 56},
  [939] = {.lex_state = 56},
  [940] = {.lex_state = 56},
  [941] = {.lex_state = 56},
  [942] = {.lex_state = 56},
  [943] = {.lex_state = 56},
  [944] = {.lex_state = 56},
  [945] = {.lex_state = 3},
  [946] = {.lex_state = 56},
  [947] = {.lex_state = 56},
  [948] = {.lex_state = 56},
  [949] = {.lex_state = 56},
  [950] = {.lex_state = 56},
  [951] = {.lex_state = 56},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 56},
  [954] = {.lex_state = 56},
  [955] = {.lex_state = 56},
  [956] = {.lex_state = 56},
  [957] = {.lex_state = 56},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 56},
  [960] = {.lex_state = 56},
  [961] = {.lex_state = 56},
  [962] = {.lex_state = 56},
  [963] = {.lex_state = 56},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 56},
  [966] = {.lex_state = 56},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 56},
  [969] = {.lex_state = 56},
  [970] = {.lex_state = 56},
  [971] = {.lex_state = 56},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 56},
  [974] = {.lex_state = 56},
  [975] = {.lex_state = 56},
  [976] = {.lex_state = 3},
  [977] = {.lex_state = 56},
  [978] = {.lex_state = 56},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 56},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 56},
  [984] = {.lex_state = 56},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 56},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 56},
  [990] = {.lex_state = 56},
  [991] = {.lex_state = 56},
  [992] = {.lex_state = 56},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 56},
  [995] = {.lex_state = 56},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 56},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 56},
  [1000] = {.lex_state = 56},
  [1001] = {.lex_state = 56},
  [1002] = {.lex_state = 56},
  [1003] = {.lex_state = 56},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 56},
  [1006] = {.lex_state = 56},
  [1007] = {.lex_state = 56},
  [1008] = {.lex_state = 56},
  [1009] = {.lex_state = 56},
  [1010] = {.lex_state = 56},
  [1011] = {.lex_state = 56},
  [1012] = {.lex_state = 56},
  [1013] = {.lex_state = 56},
  [1014] = {.lex_state = 56},
  [1015] = {.lex_state = 56},
  [1016] = {.lex_state = 56},
  [1017] = {.lex_state = 56},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 56},
  [1021] = {.lex_state = 56},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 56},
  [1024] = {.lex_state = 56},
  [1025] = {.lex_state = 56},
  [1026] = {.lex_state = 56},
  [1027] = {.lex_state = 56},
  [1028] = {.lex_state = 56},
  [1029] = {.lex_state = 56},
  [1030] = {.lex_state = 56},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 56},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 56},
  [1036] = {.lex_state = 56},
  [1037] = {.lex_state = 56},
  [1038] = {.lex_state = 56},
  [1039] = {.lex_state = 56},
  [1040] = {.lex_state = 56},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 56},
  [1044] = {.lex_state = 56},
  [1045] = {.lex_state = 56},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 56},
  [1048] = {.lex_state = 56},
  [1049] = {.lex_state = 56},
  [1050] = {.lex_state = 2},
  [1051] = {.lex_state = 2},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 56},
  [1054] = {.lex_state = 56},
  [1055] = {.lex_state = 56},
  [1056] = {.lex_state = 56},
  [1057] = {.lex_state = 56},
  [1058] = {.lex_state = 56},
  [1059] = {.lex_state = 56},
  [1060] = {.lex_state = 56},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 56},
  [1064] = {.lex_state = 56},
  [1065] = {.lex_state = 56},
  [1066] = {.lex_state = 56},
  [1067] = {.lex_state = 2},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 56},
  [1070] = {.lex_state = 56},
  [1071] = {.lex_state = 2},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 56},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 56},
  [1077] = {.lex_state = 56},
  [1078] = {.lex_state = 2},
  [1079] = {.lex_state = 56},
  [1080] = {.lex_state = 2},
  [1081] = {.lex_state = 56},
  [1082] = {.lex_state = 56},
  [1083] = {.lex_state = 2},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 56},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 56},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 56},
  [1095] = {.lex_state = 2},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 2},
  [1098] = {.lex_state = 2},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 56},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 2},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 56},
  [1110] = {.lex_state = 56},
  [1111] = {.lex_state = 2},
  [1112] = {.lex_state = 56},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 56},
  [1116] = {.lex_state = 2},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 2},
  [1119] = {.lex_state = 2},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 56},
  [1122] = {.lex_state = 56},
  [1123] = {.lex_state = 56},
  [1124] = {.lex_state = 56},
  [1125] = {.lex_state = 56},
  [1126] = {.lex_state = 56},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 56},
  [1129] = {.lex_state = 56},
  [1130] = {.lex_state = 56},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 56},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 59},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 59},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 56},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 0},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 0},
  [1163] = {.lex_state = 0},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 0},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 56},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 56},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 0},
  [1175] = {.lex_state = 56},
  [1176] = {.lex_state = 56},
  [1177] = {.lex_state = 0},
  [1178] = {.lex_state = 0},
  [1179] = {.lex_state = 0},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 0},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 0},
  [1185] = {.lex_state = 0},
  [1186] = {.lex_state = 0},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 0},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 0},
  [1191] = {.lex_state = 56},
  [1192] = {.lex_state = 0},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 0},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 0},
  [1199] = {.lex_state = 0},
  [1200] = {.lex_state = 0},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 56},
  [1204] = {.lex_state = 0},
  [1205] = {.lex_state = 0},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 56},
  [1208] = {.lex_state = 0},
  [1209] = {.lex_state = 0},
  [1210] = {.lex_state = 56},
  [1211] = {.lex_state = 56},
  [1212] = {.lex_state = 56},
  [1213] = {.lex_state = 0},
  [1214] = {.lex_state = 0},
  [1215] = {.lex_state = 0},
  [1216] = {.lex_state = 0},
  [1217] = {.lex_state = 0},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 0},
  [1220] = {.lex_state = 0},
  [1221] = {.lex_state = 0},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 0},
  [1224] = {.lex_state = 0},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 59},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 0},
  [1230] = {.lex_state = 0},
  [1231] = {.lex_state = 59},
  [1232] = {.lex_state = 56},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 56},
  [1235] = {.lex_state = 56},
  [1236] = {.lex_state = 0},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 0},
  [1241] = {.lex_state = 56},
  [1242] = {.lex_state = 0},
  [1243] = {.lex_state = 0},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 0},
  [1246] = {.lex_state = 0},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 0},
  [1250] = {.lex_state = 0},
  [1251] = {.lex_state = 0},
  [1252] = {.lex_state = 0},
  [1253] = {.lex_state = 0},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 0},
  [1256] = {.lex_state = 0},
  [1257] = {.lex_state = 0},
  [1258] = {.lex_state = 0},
  [1259] = {.lex_state = 0},
  [1260] = {.lex_state = 0},
  [1261] = {.lex_state = 0},
  [1262] = {.lex_state = 0},
  [1263] = {.lex_state = 0},
  [1264] = {.lex_state = 0},
  [1265] = {.lex_state = 0},
  [1266] = {.lex_state = 0},
  [1267] = {.lex_state = 0},
  [1268] = {.lex_state = 0},
  [1269] = {.lex_state = 0},
  [1270] = {.lex_state = 0},
  [1271] = {.lex_state = 0},
  [1272] = {.lex_state = 0},
  [1273] = {.lex_state = 0},
  [1274] = {.lex_state = 0},
  [1275] = {.lex_state = 0},
  [1276] = {.lex_state = 0},
  [1277] = {.lex_state = 0},
  [1278] = {.lex_state = 0},
  [1279] = {.lex_state = 0},
  [1280] = {.lex_state = 0},
  [1281] = {.lex_state = 0},
  [1282] = {.lex_state = 0},
  [1283] = {.lex_state = 0},
  [1284] = {.lex_state = 0},
  [1285] = {.lex_state = 0},
  [1286] = {.lex_state = 0},
  [1287] = {.lex_state = 59},
  [1288] = {.lex_state = 0},
  [1289] = {.lex_state = 0},
  [1290] = {.lex_state = 0},
  [1291] = {.lex_state = 0},
  [1292] = {.lex_state = 0},
  [1293] = {.lex_state = 0},
  [1294] = {.lex_state = 0},
  [1295] = {.lex_state = 0},
  [1296] = {.lex_state = 0},
  [1297] = {.lex_state = 0},
  [1298] = {.lex_state = 0},
  [1299] = {.lex_state = 0},
  [1300] = {.lex_state = 0},
  [1301] = {.lex_state = 0},
  [1302] = {.lex_state = 0},
  [1303] = {.lex_state = 0},
  [1304] = {.lex_state = 0},
  [1305] = {.lex_state = 0},
  [1306] = {.lex_state = 0},
  [1307] = {.lex_state = 0},
  [1308] = {.lex_state = 0},
  [1309] = {.lex_state = 0},
  [1310] = {.lex_state = 0},
  [1311] = {.lex_state = 0},
  [1312] = {.lex_state = 0},
  [1313] = {.lex_state = 0},
  [1314] = {.lex_state = 0},
  [1315] = {.lex_state = 0},
  [1316] = {.lex_state = 0},
  [1317] = {.lex_state = 0},
  [1318] = {.lex_state = 0},
  [1319] = {.lex_state = 0},
  [1320] = {.lex_state = 0},
  [1321] = {.lex_state = 0},
  [1322] = {.lex_state = 0},
  [1323] = {.lex_state = 0},
  [1324] = {.lex_state = 0},
  [1325] = {.lex_state = 0},
  [1326] = {.lex_state = 0},
  [1327] = {.lex_state = 0},
  [1328] = {.lex_state = 0},
  [1329] = {.lex_state = 0},
  [1330] = {.lex_state = 0},
  [1331] = {.lex_state = 0},
  [1332] = {.lex_state = 0},
  [1333] = {.lex_state = 0},
  [1334] = {.lex_state = 0},
  [1335] = {.lex_state = 0},
  [1336] = {.lex_state = 0},
  [1337] = {.lex_state = 0},
  [1338] = {.lex_state = 0},
  [1339] = {.lex_state = 0},
  [1340] = {.lex_state = 0},
  [1341] = {.lex_state = 0},
  [1342] = {.lex_state = 0},
  [1343] = {.lex_state = 0},
  [1344] = {.lex_state = 0},
  [1345] = {.lex_state = 0},
  [1346] = {.lex_state = 0},
  [1347] = {.lex_state = 0},
  [1348] = {.lex_state = 0},
  [1349] = {.lex_state = 0},
  [1350] = {.lex_state = 0},
  [1351] = {.lex_state = 0},
  [1352] = {.lex_state = 0},
  [1353] = {.lex_state = 0},
  [1354] = {.lex_state = 0},
  [1355] = {.lex_state = 0},
  [1356] = {.lex_state = 0},
  [1357] = {.lex_state = 0},
  [1358] = {.lex_state = 0},
  [1359] = {.lex_state = 0},
  [1360] = {.lex_state = 0},
  [1361] = {.lex_state = 0},
  [1362] = {.lex_state = 0},
  [1363] = {.lex_state = 0},
  [1364] = {.lex_state = 0},
  [1365] = {.lex_state = 0},
  [1366] = {.lex_state = 0},
  [1367] = {.lex_state = 0},
  [1368] = {.lex_state = 0},
  [1369] = {.lex_state = 0},
  [1370] = {.lex_state = 0},
  [1371] = {.lex_state = 0},
  [1372] = {.lex_state = 0},
  [1373] = {.lex_state = 0},
  [1374] = {.lex_state = 0},
  [1375] = {.lex_state = 0},
  [1376] = {.lex_state = 0},
  [1377] = {.lex_state = 0},
  [1378] = {.lex_state = 0},
  [1379] = {.lex_state = 0},
  [1380] = {.lex_state = 0},
  [1381] = {.lex_state = 0},
  [1382] = {.lex_state = 0},
  [1383] = {.lex_state = 0},
  [1384] = {.lex_state = 0},
  [1385] = {.lex_state = 0},
  [1386] = {.lex_state = 0},
  [1387] = {.lex_state = 0},
  [1388] = {.lex_state = 0},
  [1389] = {.lex_state = 0},
  [1390] = {.lex_state = 0},
  [1391] = {.lex_state = 0},
  [1392] = {.lex_state = 0},
  [1393] = {.lex_state = 0},
  [1394] = {.lex_state = 0},
  [1395] = {.lex_state = 0},
  [1396] = {.lex_state = 0},
  [1397] = {.lex_state = 0},
  [1398] = {.lex_state = 0},
  [1399] = {.lex_state = 0},
  [1400] = {.lex_state = 0},
  [1401] = {.lex_state = 0},
  [1402] = {.lex_state = 0},
  [1403] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_NULL] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [sym_blank_identifier] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_func] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_map] = ACTIONS(1),
    [anon_sym_chan] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_AMP_CARET_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_fallthrough] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_go] = ACTIONS(1),
    [anon_sym_defer] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_range] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_select] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_make] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_AMP_CARET] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [sym_raw_string_literal] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE2] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_int_literal] = ACTIONS(1),
    [sym_float_literal] = ACTIONS(1),
    [sym_imaginary_literal] = ACTIONS(1),
    [sym_rune_literal] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_iota] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(1384),
    [sym_package_clause] = STATE(1070),
    [sym_import_declaration] = STATE(1070),
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_function_declaration] = STATE(1070),
    [sym_method_declaration] = STATE(1070),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement] = STATE(1207),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_package] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_package_clause] = STATE(1094),
    [sym_import_declaration] = STATE(1094),
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_function_declaration] = STATE(1094),
    [sym_method_declaration] = STATE(1094),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement] = STATE(1207),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_package] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_package_clause] = STATE(1207),
    [sym_import_declaration] = STATE(1207),
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_function_declaration] = STATE(1207),
    [sym_method_declaration] = STATE(1207),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement] = STATE(1207),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(77),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_SEMI] = ACTIONS(82),
    [anon_sym_package] = ACTIONS(85),
    [anon_sym_import] = ACTIONS(88),
    [anon_sym_LPAREN] = ACTIONS(91),
    [anon_sym_const] = ACTIONS(94),
    [anon_sym_var] = ACTIONS(97),
    [anon_sym_func] = ACTIONS(100),
    [anon_sym_LBRACK] = ACTIONS(103),
    [anon_sym_type] = ACTIONS(106),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_struct] = ACTIONS(112),
    [anon_sym_TILDE] = ACTIONS(115),
    [anon_sym_LBRACE] = ACTIONS(118),
    [anon_sym_interface] = ACTIONS(121),
    [anon_sym_map] = ACTIONS(124),
    [anon_sym_chan] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(130),
    [anon_sym_fallthrough] = ACTIONS(133),
    [anon_sym_break] = ACTIONS(136),
    [anon_sym_continue] = ACTIONS(139),
    [anon_sym_goto] = ACTIONS(142),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_go] = ACTIONS(148),
    [anon_sym_defer] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(154),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(160),
    [anon_sym_select] = ACTIONS(163),
    [anon_sym_new] = ACTIONS(166),
    [anon_sym_make] = ACTIONS(166),
    [anon_sym_PLUS] = ACTIONS(169),
    [anon_sym_DASH] = ACTIONS(169),
    [anon_sym_BANG] = ACTIONS(169),
    [anon_sym_CARET] = ACTIONS(169),
    [anon_sym_AMP] = ACTIONS(169),
    [sym_raw_string_literal] = ACTIONS(172),
    [anon_sym_DQUOTE] = ACTIONS(175),
    [sym_int_literal] = ACTIONS(178),
    [sym_float_literal] = ACTIONS(178),
    [sym_imaginary_literal] = ACTIONS(172),
    [sym_rune_literal] = ACTIONS(172),
    [sym_nil] = ACTIONS(178),
    [sym_true] = ACTIONS(178),
    [sym_false] = ACTIONS(178),
    [sym_iota] = ACTIONS(178),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement_list] = STATE(1157),
    [sym__statement] = STATE(898),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_empty_labeled_statement] = STATE(1157),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(185),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(187),
    [anon_sym_default] = ACTIONS(187),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement_list] = STATE(1148),
    [sym__statement] = STATE(898),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_empty_labeled_statement] = STATE(1148),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(189),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(191),
    [anon_sym_default] = ACTIONS(191),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement_list] = STATE(1147),
    [sym__statement] = STATE(898),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_empty_labeled_statement] = STATE(1147),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(193),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(195),
    [anon_sym_default] = ACTIONS(195),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement_list] = STATE(1194),
    [sym__statement] = STATE(898),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_empty_labeled_statement] = STATE(1194),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(197),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(199),
    [anon_sym_default] = ACTIONS(199),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement_list] = STATE(1190),
    [sym__statement] = STATE(898),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_empty_labeled_statement] = STATE(1190),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(201),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(203),
    [anon_sym_default] = ACTIONS(203),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement] = STATE(974),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_empty_labeled_statement] = STATE(1156),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(205),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(207),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement] = STATE(974),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_empty_labeled_statement] = STATE(1230),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(209),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(211),
    [anon_sym_default] = ACTIONS(211),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement] = STATE(966),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(213),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(215),
    [anon_sym_default] = ACTIONS(215),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement_list] = STATE(1382),
    [sym__statement] = STATE(898),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_empty_labeled_statement] = STATE(1382),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(217),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement_list] = STATE(1369),
    [sym__statement] = STATE(898),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_empty_labeled_statement] = STATE(1369),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(219),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement_list] = STATE(1346),
    [sym__statement] = STATE(898),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_empty_labeled_statement] = STATE(1346),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(221),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement_list] = STATE(1319),
    [sym__statement] = STATE(898),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_empty_labeled_statement] = STATE(1319),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(223),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement_list] = STATE(1339),
    [sym__statement] = STATE(898),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_empty_labeled_statement] = STATE(1339),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(225),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement_list] = STATE(1357),
    [sym__statement] = STATE(898),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_empty_labeled_statement] = STATE(1357),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(227),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement_list] = STATE(1334),
    [sym__statement] = STATE(898),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_empty_labeled_statement] = STATE(1334),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(229),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement] = STATE(966),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__declaration] = STATE(978),
    [sym_const_declaration] = STATE(978),
    [sym_var_declaration] = STATE(978),
    [sym_type_declaration] = STATE(978),
    [sym_expression_list] = STATE(803),
    [sym_parenthesized_type] = STATE(1306),
    [sym__simple_type] = STATE(1306),
    [sym_generic_type] = STATE(1104),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1104),
    [sym_implicit_length_array_type] = STATE(1272),
    [sym_slice_type] = STATE(1104),
    [sym_struct_type] = STATE(1104),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1104),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(978),
    [sym__statement] = STATE(974),
    [sym_empty_statement] = STATE(978),
    [sym__simple_statement] = STATE(978),
    [sym_expression_statement] = STATE(1003),
    [sym_send_statement] = STATE(1003),
    [sym_inc_statement] = STATE(1003),
    [sym_dec_statement] = STATE(1003),
    [sym_assignment_statement] = STATE(1003),
    [sym_short_var_declaration] = STATE(1003),
    [sym_labeled_statement] = STATE(978),
    [sym_fallthrough_statement] = STATE(978),
    [sym_break_statement] = STATE(978),
    [sym_continue_statement] = STATE(978),
    [sym_goto_statement] = STATE(978),
    [sym_return_statement] = STATE(978),
    [sym_go_statement] = STATE(978),
    [sym_defer_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_expression_switch_statement] = STATE(978),
    [sym_type_switch_statement] = STATE(978),
    [sym_select_statement] = STATE(978),
    [sym__expression] = STATE(239),
    [sym_parenthesized_expression] = STATE(266),
    [sym_call_expression] = STATE(266),
    [sym_selector_expression] = STATE(266),
    [sym_index_expression] = STATE(266),
    [sym_slice_expression] = STATE(266),
    [sym_type_assertion_expression] = STATE(266),
    [sym_type_conversion_expression] = STATE(266),
    [sym_type_instantiation_expression] = STATE(266),
    [sym_composite_literal] = STATE(266),
    [sym_func_literal] = STATE(266),
    [sym_unary_expression] = STATE(266),
    [sym_binary_expression] = STATE(266),
    [sym_qualified_type] = STATE(1032),
    [sym_interpreted_string_literal] = STATE(266),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(69),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_expression_list] = STATE(797),
    [sym_parenthesized_type] = STATE(1314),
    [sym__simple_type] = STATE(1314),
    [sym_generic_type] = STATE(1084),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1084),
    [sym_implicit_length_array_type] = STATE(1293),
    [sym_slice_type] = STATE(1084),
    [sym_struct_type] = STATE(1084),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1084),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym_block] = STATE(956),
    [sym__simple_statement] = STATE(1394),
    [sym_expression_statement] = STATE(1276),
    [sym_send_statement] = STATE(1276),
    [sym_inc_statement] = STATE(1276),
    [sym_dec_statement] = STATE(1276),
    [sym_assignment_statement] = STATE(1276),
    [sym_short_var_declaration] = STATE(1276),
    [sym_for_clause] = STATE(1308),
    [sym_range_clause] = STATE(1308),
    [sym__expression] = STATE(259),
    [sym_parenthesized_expression] = STATE(306),
    [sym_call_expression] = STATE(306),
    [sym_selector_expression] = STATE(306),
    [sym_index_expression] = STATE(306),
    [sym_slice_expression] = STATE(306),
    [sym_type_assertion_expression] = STATE(306),
    [sym_type_conversion_expression] = STATE(306),
    [sym_type_instantiation_expression] = STATE(306),
    [sym_composite_literal] = STATE(306),
    [sym_func_literal] = STATE(306),
    [sym_unary_expression] = STATE(306),
    [sym_binary_expression] = STATE(306),
    [sym_qualified_type] = STATE(1018),
    [sym_interpreted_string_literal] = STATE(306),
    [sym_identifier] = ACTIONS(231),
    [anon_sym_SEMI] = ACTIONS(233),
    [anon_sym_LPAREN] = ACTIONS(235),
    [anon_sym_func] = ACTIONS(237),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(241),
    [anon_sym_range] = ACTIONS(243),
    [anon_sym_new] = ACTIONS(245),
    [anon_sym_make] = ACTIONS(245),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(247),
    [anon_sym_BANG] = ACTIONS(247),
    [anon_sym_CARET] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(247),
    [sym_raw_string_literal] = ACTIONS(249),
    [anon_sym_DQUOTE] = ACTIONS(251),
    [sym_int_literal] = ACTIONS(253),
    [sym_float_literal] = ACTIONS(253),
    [sym_imaginary_literal] = ACTIONS(249),
    [sym_rune_literal] = ACTIONS(249),
    [sym_nil] = ACTIONS(253),
    [sym_true] = ACTIONS(253),
    [sym_false] = ACTIONS(253),
    [sym_iota] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym_expression_list] = STATE(798),
    [sym_parenthesized_type] = STATE(1314),
    [sym__simple_type] = STATE(1314),
    [sym_generic_type] = STATE(1084),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1084),
    [sym_implicit_length_array_type] = STATE(1293),
    [sym_slice_type] = STATE(1084),
    [sym_struct_type] = STATE(1084),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1084),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym__simple_statement] = STATE(1386),
    [sym_expression_statement] = STATE(1276),
    [sym_send_statement] = STATE(1276),
    [sym_inc_statement] = STATE(1276),
    [sym_dec_statement] = STATE(1276),
    [sym_assignment_statement] = STATE(1276),
    [sym_short_var_declaration] = STATE(1276),
    [sym__type_switch_header] = STATE(1402),
    [sym__expression] = STATE(289),
    [sym_parenthesized_expression] = STATE(306),
    [sym_call_expression] = STATE(306),
    [sym_selector_expression] = STATE(306),
    [sym_index_expression] = STATE(306),
    [sym_slice_expression] = STATE(306),
    [sym_type_assertion_expression] = STATE(306),
    [sym_type_conversion_expression] = STATE(306),
    [sym_type_instantiation_expression] = STATE(306),
    [sym_composite_literal] = STATE(306),
    [sym_func_literal] = STATE(306),
    [sym_unary_expression] = STATE(306),
    [sym_binary_expression] = STATE(306),
    [sym_qualified_type] = STATE(1018),
    [sym_interpreted_string_literal] = STATE(306),
    [sym_identifier] = ACTIONS(231),
    [anon_sym_LPAREN] = ACTIONS(235),
    [anon_sym_func] = ACTIONS(237),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(255),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(241),
    [anon_sym_new] = ACTIONS(245),
    [anon_sym_make] = ACTIONS(245),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(247),
    [anon_sym_BANG] = ACTIONS(247),
    [anon_sym_CARET] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(247),
    [sym_raw_string_literal] = ACTIONS(249),
    [anon_sym_DQUOTE] = ACTIONS(251),
    [sym_int_literal] = ACTIONS(253),
    [sym_float_literal] = ACTIONS(253),
    [sym_imaginary_literal] = ACTIONS(249),
    [sym_rune_literal] = ACTIONS(249),
    [sym_nil] = ACTIONS(253),
    [sym_true] = ACTIONS(253),
    [sym_false] = ACTIONS(253),
    [sym_iota] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym_expression_list] = STATE(795),
    [sym_parenthesized_type] = STATE(1314),
    [sym__simple_type] = STATE(1314),
    [sym_generic_type] = STATE(1084),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1084),
    [sym_implicit_length_array_type] = STATE(1293),
    [sym_slice_type] = STATE(1084),
    [sym_struct_type] = STATE(1084),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1084),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym__simple_statement] = STATE(1341),
    [sym_expression_statement] = STATE(1276),
    [sym_send_statement] = STATE(1276),
    [sym_inc_statement] = STATE(1276),
    [sym_dec_statement] = STATE(1276),
    [sym_assignment_statement] = STATE(1276),
    [sym_short_var_declaration] = STATE(1276),
    [sym__expression] = STATE(291),
    [sym_parenthesized_expression] = STATE(306),
    [sym_call_expression] = STATE(306),
    [sym_selector_expression] = STATE(306),
    [sym_index_expression] = STATE(306),
    [sym_slice_expression] = STATE(306),
    [sym_type_assertion_expression] = STATE(306),
    [sym_type_conversion_expression] = STATE(306),
    [sym_type_instantiation_expression] = STATE(306),
    [sym_composite_literal] = STATE(306),
    [sym_func_literal] = STATE(306),
    [sym_unary_expression] = STATE(306),
    [sym_binary_expression] = STATE(306),
    [sym_qualified_type] = STATE(1018),
    [sym_interpreted_string_literal] = STATE(306),
    [sym_identifier] = ACTIONS(231),
    [anon_sym_LPAREN] = ACTIONS(235),
    [anon_sym_func] = ACTIONS(237),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(257),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(241),
    [anon_sym_new] = ACTIONS(245),
    [anon_sym_make] = ACTIONS(245),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(247),
    [anon_sym_BANG] = ACTIONS(247),
    [anon_sym_CARET] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(247),
    [sym_raw_string_literal] = ACTIONS(249),
    [anon_sym_DQUOTE] = ACTIONS(251),
    [sym_int_literal] = ACTIONS(253),
    [sym_float_literal] = ACTIONS(253),
    [sym_imaginary_literal] = ACTIONS(249),
    [sym_rune_literal] = ACTIONS(249),
    [sym_nil] = ACTIONS(253),
    [sym_true] = ACTIONS(253),
    [sym_false] = ACTIONS(253),
    [sym_iota] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym_expression_list] = STATE(795),
    [sym_parenthesized_type] = STATE(1314),
    [sym__simple_type] = STATE(1314),
    [sym_generic_type] = STATE(1084),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1084),
    [sym_implicit_length_array_type] = STATE(1293),
    [sym_slice_type] = STATE(1084),
    [sym_struct_type] = STATE(1084),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1084),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym__simple_statement] = STATE(1358),
    [sym_expression_statement] = STATE(1276),
    [sym_send_statement] = STATE(1276),
    [sym_inc_statement] = STATE(1276),
    [sym_dec_statement] = STATE(1276),
    [sym_assignment_statement] = STATE(1276),
    [sym_short_var_declaration] = STATE(1276),
    [sym__expression] = STATE(291),
    [sym_parenthesized_expression] = STATE(306),
    [sym_call_expression] = STATE(306),
    [sym_selector_expression] = STATE(306),
    [sym_index_expression] = STATE(306),
    [sym_slice_expression] = STATE(306),
    [sym_type_assertion_expression] = STATE(306),
    [sym_type_conversion_expression] = STATE(306),
    [sym_type_instantiation_expression] = STATE(306),
    [sym_composite_literal] = STATE(306),
    [sym_func_literal] = STATE(306),
    [sym_unary_expression] = STATE(306),
    [sym_binary_expression] = STATE(306),
    [sym_qualified_type] = STATE(1018),
    [sym_interpreted_string_literal] = STATE(306),
    [sym_identifier] = ACTIONS(231),
    [anon_sym_LPAREN] = ACTIONS(235),
    [anon_sym_func] = ACTIONS(237),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(259),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(241),
    [anon_sym_new] = ACTIONS(245),
    [anon_sym_make] = ACTIONS(245),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(247),
    [anon_sym_BANG] = ACTIONS(247),
    [anon_sym_CARET] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(247),
    [sym_raw_string_literal] = ACTIONS(249),
    [anon_sym_DQUOTE] = ACTIONS(251),
    [sym_int_literal] = ACTIONS(253),
    [sym_float_literal] = ACTIONS(253),
    [sym_imaginary_literal] = ACTIONS(249),
    [sym_rune_literal] = ACTIONS(249),
    [sym_nil] = ACTIONS(253),
    [sym_true] = ACTIONS(253),
    [sym_false] = ACTIONS(253),
    [sym_iota] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym_expression_list] = STATE(795),
    [sym_parenthesized_type] = STATE(1314),
    [sym__simple_type] = STATE(1314),
    [sym_generic_type] = STATE(1084),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1084),
    [sym_implicit_length_array_type] = STATE(1293),
    [sym_slice_type] = STATE(1084),
    [sym_struct_type] = STATE(1084),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1084),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym__simple_statement] = STATE(1373),
    [sym_expression_statement] = STATE(1276),
    [sym_send_statement] = STATE(1276),
    [sym_inc_statement] = STATE(1276),
    [sym_dec_statement] = STATE(1276),
    [sym_assignment_statement] = STATE(1276),
    [sym_short_var_declaration] = STATE(1276),
    [sym__expression] = STATE(291),
    [sym_parenthesized_expression] = STATE(306),
    [sym_call_expression] = STATE(306),
    [sym_selector_expression] = STATE(306),
    [sym_index_expression] = STATE(306),
    [sym_slice_expression] = STATE(306),
    [sym_type_assertion_expression] = STATE(306),
    [sym_type_conversion_expression] = STATE(306),
    [sym_type_instantiation_expression] = STATE(306),
    [sym_composite_literal] = STATE(306),
    [sym_func_literal] = STATE(306),
    [sym_unary_expression] = STATE(306),
    [sym_binary_expression] = STATE(306),
    [sym_qualified_type] = STATE(1018),
    [sym_interpreted_string_literal] = STATE(306),
    [sym_identifier] = ACTIONS(231),
    [anon_sym_LPAREN] = ACTIONS(235),
    [anon_sym_func] = ACTIONS(237),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(261),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(241),
    [anon_sym_new] = ACTIONS(245),
    [anon_sym_make] = ACTIONS(245),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(247),
    [anon_sym_BANG] = ACTIONS(247),
    [anon_sym_CARET] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(247),
    [sym_raw_string_literal] = ACTIONS(249),
    [anon_sym_DQUOTE] = ACTIONS(251),
    [sym_int_literal] = ACTIONS(253),
    [sym_float_literal] = ACTIONS(253),
    [sym_imaginary_literal] = ACTIONS(249),
    [sym_rune_literal] = ACTIONS(249),
    [sym_nil] = ACTIONS(253),
    [sym_true] = ACTIONS(253),
    [sym_false] = ACTIONS(253),
    [sym_iota] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym_expression_list] = STATE(795),
    [sym_parenthesized_type] = STATE(1314),
    [sym__simple_type] = STATE(1314),
    [sym_generic_type] = STATE(1084),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1084),
    [sym_implicit_length_array_type] = STATE(1293),
    [sym_slice_type] = STATE(1084),
    [sym_struct_type] = STATE(1084),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1084),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym__simple_statement] = STATE(1351),
    [sym_expression_statement] = STATE(1276),
    [sym_send_statement] = STATE(1276),
    [sym_inc_statement] = STATE(1276),
    [sym_dec_statement] = STATE(1276),
    [sym_assignment_statement] = STATE(1276),
    [sym_short_var_declaration] = STATE(1276),
    [sym__expression] = STATE(291),
    [sym_parenthesized_expression] = STATE(306),
    [sym_call_expression] = STATE(306),
    [sym_selector_expression] = STATE(306),
    [sym_index_expression] = STATE(306),
    [sym_slice_expression] = STATE(306),
    [sym_type_assertion_expression] = STATE(306),
    [sym_type_conversion_expression] = STATE(306),
    [sym_type_instantiation_expression] = STATE(306),
    [sym_composite_literal] = STATE(306),
    [sym_func_literal] = STATE(306),
    [sym_unary_expression] = STATE(306),
    [sym_binary_expression] = STATE(306),
    [sym_qualified_type] = STATE(1018),
    [sym_interpreted_string_literal] = STATE(306),
    [sym_identifier] = ACTIONS(231),
    [anon_sym_LPAREN] = ACTIONS(235),
    [anon_sym_func] = ACTIONS(237),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(263),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(241),
    [anon_sym_new] = ACTIONS(245),
    [anon_sym_make] = ACTIONS(245),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(247),
    [anon_sym_BANG] = ACTIONS(247),
    [anon_sym_CARET] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(247),
    [sym_raw_string_literal] = ACTIONS(249),
    [anon_sym_DQUOTE] = ACTIONS(251),
    [sym_int_literal] = ACTIONS(253),
    [sym_float_literal] = ACTIONS(253),
    [sym_imaginary_literal] = ACTIONS(249),
    [sym_rune_literal] = ACTIONS(249),
    [sym_nil] = ACTIONS(253),
    [sym_true] = ACTIONS(253),
    [sym_false] = ACTIONS(253),
    [sym_iota] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym_expression_list] = STATE(800),
    [sym_parenthesized_type] = STATE(1314),
    [sym__simple_type] = STATE(1314),
    [sym_generic_type] = STATE(1084),
    [sym_pointer_type] = STATE(858),
    [sym_array_type] = STATE(1084),
    [sym_implicit_length_array_type] = STATE(1293),
    [sym_slice_type] = STATE(1084),
    [sym_struct_type] = STATE(1084),
    [sym_negated_type] = STATE(836),
    [sym_interface_type] = STATE(858),
    [sym_map_type] = STATE(1084),
    [sym_channel_type] = STATE(858),
    [sym_function_type] = STATE(858),
    [sym__simple_statement] = STATE(1360),
    [sym_expression_statement] = STATE(1276),
    [sym_send_statement] = STATE(1276),
    [sym_inc_statement] = STATE(1276),
    [sym_dec_statement] = STATE(1276),
    [sym_assignment_statement] = STATE(1276),
    [sym_short_var_declaration] = STATE(1276),
    [sym__expression] = STATE(255),
    [sym_parenthesized_expression] = STATE(306),
    [sym_call_expression] = STATE(306),
    [sym_selector_expression] = STATE(306),
    [sym_index_expression] = STATE(306),
    [sym_slice_expression] = STATE(306),
    [sym_type_assertion_expression] = STATE(306),
    [sym_type_conversion_expression] = STATE(306),
    [sym_type_instantiation_expression] = STATE(306),
    [sym_composite_literal] = STATE(306),
    [sym_func_literal] = STATE(306),
    [sym_unary_expression] = STATE(306),
    [sym_binary_expression] = STATE(306),
    [sym_qualified_type] = STATE(1018),
    [sym_interpreted_string_literal] = STATE(306),
    [sym_identifier] = ACTIONS(231),
    [anon_sym_LPAREN] = ACTIONS(235),
    [anon_sym_func] = ACTIONS(237),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(241),
    [anon_sym_new] = ACTIONS(245),
    [anon_sym_make] = ACTIONS(245),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(247),
    [anon_sym_BANG] = ACTIONS(247),
    [anon_sym_CARET] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(247),
    [sym_raw_string_literal] = ACTIONS(249),
    [anon_sym_DQUOTE] = ACTIONS(251),
    [sym_int_literal] = ACTIONS(253),
    [sym_float_literal] = ACTIONS(253),
    [sym_imaginary_literal] = ACTIONS(249),
    [sym_rune_literal] = ACTIONS(249),
    [sym_nil] = ACTIONS(253),
    [sym_true] = ACTIONS(253),
    [sym_false] = ACTIONS(253),
    [sym_iota] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 27,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(267), 1,
      anon_sym_LF,
    ACTIONS(271), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(275), 1,
      anon_sym_LBRACK,
    ACTIONS(277), 1,
      anon_sym_STAR,
    ACTIONS(279), 1,
      anon_sym_TILDE,
    ACTIONS(281), 1,
      anon_sym_LT_DASH,
    ACTIONS(289), 1,
      anon_sym_DQUOTE,
    ACTIONS(291), 1,
      sym_comment,
    STATE(395), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1013), 1,
      sym_expression_list,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(269), 5,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(285), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 9,
      sym_raw_string_literal,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [119] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(297), 1,
      anon_sym_COMMA,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(305), 1,
      anon_sym_RBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1100), 1,
      sym_literal_element,
    STATE(1178), 1,
      sym_keyed_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [245] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(319), 1,
      anon_sym_COMMA,
    ACTIONS(321), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1073), 1,
      sym_literal_element,
    STATE(1233), 1,
      sym_keyed_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [371] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(323), 1,
      anon_sym_COMMA,
    ACTIONS(325), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1087), 1,
      sym_literal_element,
    STATE(1161), 1,
      sym_keyed_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [497] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(327), 1,
      anon_sym_COMMA,
    ACTIONS(329), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1052), 1,
      sym_literal_element,
    STATE(1192), 1,
      sym_keyed_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [623] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(331), 1,
      anon_sym_COMMA,
    ACTIONS(333), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1114), 1,
      sym_literal_element,
    STATE(1195), 1,
      sym_keyed_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [749] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1120), 1,
      sym_literal_element,
    STATE(1217), 1,
      sym_keyed_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [875] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(339), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1187), 1,
      sym_literal_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1263), 1,
      sym_keyed_element,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [998] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(341), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1187), 1,
      sym_literal_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1263), 1,
      sym_keyed_element,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1121] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(343), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1187), 1,
      sym_literal_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1263), 1,
      sym_keyed_element,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1244] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1187), 1,
      sym_literal_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1263), 1,
      sym_keyed_element,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1367] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(347), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1187), 1,
      sym_literal_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1263), 1,
      sym_keyed_element,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1490] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(349), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1187), 1,
      sym_literal_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1263), 1,
      sym_keyed_element,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1613] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(351), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1187), 1,
      sym_literal_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1263), 1,
      sym_keyed_element,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1736] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(353), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1187), 1,
      sym_literal_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1263), 1,
      sym_keyed_element,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1859] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(355), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1187), 1,
      sym_literal_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1263), 1,
      sym_keyed_element,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1982] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(357), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1187), 1,
      sym_literal_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1263), 1,
      sym_keyed_element,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2105] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(359), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1187), 1,
      sym_literal_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1263), 1,
      sym_keyed_element,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2228] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(361), 1,
      anon_sym_RBRACE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1187), 1,
      sym_literal_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1263), 1,
      sym_keyed_element,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2351] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1187), 1,
      sym_literal_element,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1263), 1,
      sym_keyed_element,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2471] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(565), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1237), 1,
      sym_literal_value,
    STATE(1264), 1,
      sym_literal_element,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2588] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(363), 1,
      sym_identifier,
    ACTIONS(365), 1,
      anon_sym_LPAREN,
    ACTIONS(367), 1,
      anon_sym_func,
    ACTIONS(369), 1,
      anon_sym_STAR,
    ACTIONS(371), 1,
      anon_sym_LT_DASH,
    ACTIONS(379), 1,
      anon_sym_DQUOTE,
    STATE(449), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1022), 1,
      sym_qualified_type,
    STATE(1258), 1,
      sym_implicit_length_array_type,
    STATE(1261), 1,
      sym_expression_list,
    ACTIONS(373), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1283), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1349), 2,
      sym_send_statement,
      sym_receive_statement,
    ACTIONS(377), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(375), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1108), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(381), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(534), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2703] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      anon_sym_RBRACK,
    ACTIONS(385), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(689), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2817] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(387), 1,
      sym_identifier,
    ACTIONS(389), 1,
      anon_sym_STAR,
    ACTIONS(391), 1,
      anon_sym_COLON,
    STATE(594), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1150), 1,
      sym_type_elem,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1004), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2931] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(395), 1,
      anon_sym_RPAREN,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(541), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1245), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3045] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(407), 1,
      anon_sym_LBRACE,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    STATE(513), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    STATE(1396), 1,
      sym_expression_list,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3159] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(413), 1,
      anon_sym_RPAREN,
    STATE(527), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1174), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3273] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(415), 1,
      anon_sym_RPAREN,
    STATE(512), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1225), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3387] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(387), 1,
      sym_identifier,
    ACTIONS(389), 1,
      anon_sym_STAR,
    ACTIONS(417), 1,
      anon_sym_RBRACK,
    STATE(658), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1208), 1,
      sym_type_elem,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1004), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3501] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(419), 1,
      anon_sym_RPAREN,
    STATE(541), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1245), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3615] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(421), 1,
      anon_sym_RPAREN,
    STATE(541), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1245), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3729] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(423), 1,
      anon_sym_RPAREN,
    STATE(525), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1135), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3843] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(387), 1,
      sym_identifier,
    ACTIONS(389), 1,
      anon_sym_STAR,
    ACTIONS(425), 1,
      anon_sym_RBRACK,
    STATE(649), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1150), 1,
      sym_type_elem,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1004), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3957] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(427), 1,
      anon_sym_RPAREN,
    STATE(541), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1245), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4071] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(387), 1,
      sym_identifier,
    ACTIONS(389), 1,
      anon_sym_STAR,
    ACTIONS(429), 1,
      anon_sym_COLON,
    STATE(623), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1150), 1,
      sym_type_elem,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1004), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4185] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(431), 1,
      anon_sym_RPAREN,
    STATE(541), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1245), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4299] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(433), 1,
      anon_sym_range,
    STATE(522), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    STATE(1284), 1,
      sym_expression_list,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4413] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(435), 1,
      anon_sym_RPAREN,
    STATE(541), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1245), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4527] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(437), 1,
      anon_sym_RPAREN,
    STATE(541), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1245), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4641] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(417), 1,
      anon_sym_RBRACK,
    ACTIONS(439), 1,
      sym_identifier,
    STATE(658), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1159), 1,
      sym_type_parameter_declaration,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4755] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(441), 1,
      anon_sym_RPAREN,
    STATE(541), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1245), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4869] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(443), 1,
      anon_sym_RPAREN,
    STATE(511), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1180), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4983] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(445), 1,
      anon_sym_RPAREN,
    STATE(541), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1245), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5097] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(447), 1,
      anon_sym_RPAREN,
    STATE(541), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1245), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5211] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(449), 1,
      anon_sym_RPAREN,
    STATE(516), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1198), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5325] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(451), 1,
      anon_sym_RPAREN,
    STATE(541), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1245), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5439] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(453), 1,
      anon_sym_RPAREN,
    STATE(541), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1245), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5553] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(433), 1,
      anon_sym_range,
    STATE(522), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    STATE(1281), 1,
      sym_expression_list,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5667] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(387), 1,
      sym_identifier,
    ACTIONS(389), 1,
      anon_sym_STAR,
    ACTIONS(455), 1,
      anon_sym_COLON,
    STATE(621), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1150), 1,
      sym_type_elem,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1004), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5781] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(387), 1,
      sym_identifier,
    ACTIONS(389), 1,
      anon_sym_STAR,
    ACTIONS(457), 1,
      anon_sym_COLON,
    STATE(632), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1150), 1,
      sym_type_elem,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1004), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5895] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(387), 1,
      sym_identifier,
    ACTIONS(389), 1,
      anon_sym_STAR,
    ACTIONS(459), 1,
      anon_sym_COLON,
    STATE(609), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1150), 1,
      sym_type_elem,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1004), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6009] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(387), 1,
      sym_identifier,
    ACTIONS(389), 1,
      anon_sym_STAR,
    ACTIONS(461), 1,
      anon_sym_COLON,
    STATE(608), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1150), 1,
      sym_type_elem,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1004), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6123] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(463), 1,
      anon_sym_RPAREN,
    STATE(521), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1163), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6237] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(465), 1,
      anon_sym_RBRACK,
    STATE(637), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6348] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_RBRACK,
    STATE(649), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6459] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(467), 1,
      anon_sym_RBRACK,
    STATE(606), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6570] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(469), 1,
      anon_sym_RPAREN,
    STATE(597), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6681] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(471), 1,
      anon_sym_RBRACK,
    STATE(636), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6792] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    STATE(590), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    STATE(1281), 1,
      sym_expression_list,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6903] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(473), 1,
      anon_sym_SEMI,
    STATE(692), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7014] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      anon_sym_RBRACK,
    STATE(670), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7125] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(395), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(934), 1,
      sym_expression_list,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7236] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    STATE(590), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    STATE(1284), 1,
      sym_expression_list,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7347] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(489), 1,
      anon_sym_RBRACK,
    STATE(617), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7458] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(491), 1,
      anon_sym_RPAREN,
    STATE(597), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7569] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(395), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(941), 1,
      sym_expression_list,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7680] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(542), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    STATE(1284), 1,
      sym_expression_list,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7791] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(493), 1,
      anon_sym_RBRACK,
    STATE(612), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7902] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(495), 1,
      anon_sym_RPAREN,
    STATE(597), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8013] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(497), 1,
      anon_sym_RPAREN,
    STATE(597), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8124] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(499), 1,
      anon_sym_RBRACK,
    STATE(631), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8235] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(541), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1245), 1,
      sym_variadic_argument,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8346] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      anon_sym_RBRACK,
    STATE(689), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8457] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(501), 1,
      anon_sym_RBRACK,
    STATE(638), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8568] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(503), 1,
      anon_sym_RPAREN,
    STATE(597), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8679] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(395), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1008), 1,
      sym_expression_list,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8790] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(505), 1,
      anon_sym_RPAREN,
    STATE(597), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8901] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(522), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    STATE(1372), 1,
      sym_expression_list,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9012] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(507), 1,
      anon_sym_RBRACK,
    STATE(616), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9123] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(509), 1,
      anon_sym_SEMI,
    STATE(641), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9234] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(511), 1,
      anon_sym_RBRACK,
    STATE(618), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9345] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(513), 1,
      anon_sym_RPAREN,
    STATE(597), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9456] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(395), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(948), 1,
      sym_expression_list,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9567] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(515), 1,
      anon_sym_RBRACK,
    STATE(626), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9678] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(395), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(949), 1,
      sym_expression_list,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9789] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(517), 1,
      anon_sym_RBRACK,
    STATE(683), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9900] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(395), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(951), 1,
      sym_expression_list,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10011] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(519), 1,
      anon_sym_RPAREN,
    STATE(597), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10122] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(521), 1,
      anon_sym_RBRACK,
    STATE(598), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10233] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(523), 1,
      anon_sym_RPAREN,
    STATE(597), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10344] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(395), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(970), 1,
      sym_expression_list,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10455] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(395), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1009), 1,
      sym_expression_list,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10566] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(525), 1,
      anon_sym_RBRACK,
    STATE(603), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10677] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(527), 1,
      anon_sym_RPAREN,
    STATE(597), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10788] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(395), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1017), 1,
      sym_expression_list,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10899] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(522), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    STATE(1281), 1,
      sym_expression_list,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11010] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(395), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1010), 1,
      sym_expression_list,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11121] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(417), 1,
      anon_sym_RBRACK,
    STATE(658), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11232] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(395), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1011), 1,
      sym_expression_list,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11343] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(522), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    STATE(1284), 1,
      sym_expression_list,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11454] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(529), 1,
      anon_sym_RBRACK,
    STATE(599), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11565] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(531), 1,
      anon_sym_RPAREN,
    STATE(597), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11676] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(533), 1,
      anon_sym_RPAREN,
    STATE(597), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11787] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(363), 1,
      sym_identifier,
    ACTIONS(365), 1,
      anon_sym_LPAREN,
    ACTIONS(367), 1,
      anon_sym_func,
    ACTIONS(369), 1,
      anon_sym_STAR,
    ACTIONS(371), 1,
      anon_sym_LT_DASH,
    ACTIONS(379), 1,
      anon_sym_DQUOTE,
    STATE(463), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1022), 1,
      sym_qualified_type,
    STATE(1258), 1,
      sym_implicit_length_array_type,
    ACTIONS(373), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1283), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(377), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(375), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1108), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(381), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(534), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11895] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(363), 1,
      sym_identifier,
    ACTIONS(365), 1,
      anon_sym_LPAREN,
    ACTIONS(367), 1,
      anon_sym_func,
    ACTIONS(369), 1,
      anon_sym_STAR,
    ACTIONS(371), 1,
      anon_sym_LT_DASH,
    ACTIONS(379), 1,
      anon_sym_DQUOTE,
    STATE(460), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1022), 1,
      sym_qualified_type,
    STATE(1258), 1,
      sym_implicit_length_array_type,
    ACTIONS(373), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1283), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(377), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(375), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1108), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(381), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(534), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12003] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(363), 1,
      sym_identifier,
    ACTIONS(365), 1,
      anon_sym_LPAREN,
    ACTIONS(367), 1,
      anon_sym_func,
    ACTIONS(369), 1,
      anon_sym_STAR,
    ACTIONS(371), 1,
      anon_sym_LT_DASH,
    ACTIONS(379), 1,
      anon_sym_DQUOTE,
    STATE(461), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1022), 1,
      sym_qualified_type,
    STATE(1258), 1,
      sym_implicit_length_array_type,
    ACTIONS(373), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1283), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(377), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(375), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1108), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(381), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(534), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12111] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(363), 1,
      sym_identifier,
    ACTIONS(365), 1,
      anon_sym_LPAREN,
    ACTIONS(367), 1,
      anon_sym_func,
    ACTIONS(369), 1,
      anon_sym_STAR,
    ACTIONS(371), 1,
      anon_sym_LT_DASH,
    ACTIONS(379), 1,
      anon_sym_DQUOTE,
    STATE(462), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1022), 1,
      sym_qualified_type,
    STATE(1258), 1,
      sym_implicit_length_array_type,
    ACTIONS(373), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1283), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(377), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(375), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1108), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(381), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(534), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12219] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(535), 1,
      anon_sym_STAR,
    STATE(646), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1197), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12327] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(535), 1,
      anon_sym_STAR,
    STATE(387), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(952), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12435] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(537), 1,
      anon_sym_chan,
    STATE(387), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12543] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(183), 1,
      anon_sym_func,
    ACTIONS(539), 1,
      sym_identifier,
    STATE(246), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1032), 1,
      sym_qualified_type,
    STATE(1272), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1306), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(69), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1104), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(266), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12651] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(183), 1,
      anon_sym_func,
    ACTIONS(539), 1,
      sym_identifier,
    STATE(247), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1032), 1,
      sym_qualified_type,
    STATE(1272), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1306), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(69), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1104), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(266), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12759] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(447), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12867] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(183), 1,
      anon_sym_func,
    ACTIONS(539), 1,
      sym_identifier,
    STATE(243), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1032), 1,
      sym_qualified_type,
    STATE(1272), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1306), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(69), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1104), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(266), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12975] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(439), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13083] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    STATE(639), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13191] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(183), 1,
      anon_sym_func,
    ACTIONS(539), 1,
      sym_identifier,
    STATE(241), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1032), 1,
      sym_qualified_type,
    STATE(1272), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1306), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(69), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1104), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(266), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13299] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(183), 1,
      anon_sym_func,
    ACTIONS(539), 1,
      sym_identifier,
    STATE(244), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1032), 1,
      sym_qualified_type,
    STATE(1272), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1306), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(69), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1104), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(266), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13407] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    STATE(645), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13515] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(183), 1,
      anon_sym_func,
    ACTIONS(537), 1,
      anon_sym_chan,
    ACTIONS(539), 1,
      sym_identifier,
    STATE(242), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1032), 1,
      sym_qualified_type,
    STATE(1272), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1306), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(69), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1104), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(266), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13623] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(183), 1,
      anon_sym_func,
    ACTIONS(539), 1,
      sym_identifier,
    STATE(242), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1032), 1,
      sym_qualified_type,
    STATE(1272), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(952), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(69), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1104), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(266), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13731] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    STATE(662), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13839] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    STATE(387), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13947] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    STATE(388), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14055] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    STATE(546), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14163] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    STATE(549), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14271] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    STATE(550), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14379] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    STATE(551), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14487] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(387), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(952), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14595] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(446), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14703] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(537), 1,
      anon_sym_chan,
    STATE(387), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14811] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    STATE(630), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14919] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(183), 1,
      anon_sym_func,
    ACTIONS(539), 1,
      sym_identifier,
    STATE(242), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1032), 1,
      sym_qualified_type,
    STATE(1272), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1306), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(69), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1104), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(266), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15027] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(597), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15135] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(720), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15243] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(660), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15351] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(634), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15459] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(451), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15567] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(433), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(952), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15675] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    ACTIONS(537), 1,
      anon_sym_chan,
    STATE(433), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15783] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(693), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15891] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(541), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LPAREN,
    ACTIONS(545), 1,
      anon_sym_func,
    ACTIONS(547), 1,
      anon_sym_STAR,
    ACTIONS(549), 1,
      anon_sym_LT_DASH,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    STATE(344), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1031), 1,
      sym_qualified_type,
    STATE(1295), 1,
      sym_implicit_length_array_type,
    ACTIONS(551), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1315), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(555), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(553), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1096), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(559), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(362), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15999] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    STATE(611), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16107] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(667), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16215] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(387), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16323] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(482), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16431] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(231), 1,
      sym_identifier,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_func,
    ACTIONS(239), 1,
      anon_sym_STAR,
    ACTIONS(241), 1,
      anon_sym_LT_DASH,
    ACTIONS(251), 1,
      anon_sym_DQUOTE,
    STATE(292), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1018), 1,
      sym_qualified_type,
    STATE(1293), 1,
      sym_implicit_length_array_type,
    ACTIONS(245), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(952), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(249), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(247), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1084), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(253), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(306), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16539] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(388), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16647] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(231), 1,
      sym_identifier,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_func,
    ACTIONS(239), 1,
      anon_sym_STAR,
    ACTIONS(241), 1,
      anon_sym_LT_DASH,
    ACTIONS(251), 1,
      anon_sym_DQUOTE,
    ACTIONS(537), 1,
      anon_sym_chan,
    STATE(292), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1018), 1,
      sym_qualified_type,
    STATE(1293), 1,
      sym_implicit_length_array_type,
    ACTIONS(245), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1314), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(249), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(247), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1084), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(253), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(306), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16755] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(558), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16863] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(363), 1,
      sym_identifier,
    ACTIONS(365), 1,
      anon_sym_LPAREN,
    ACTIONS(367), 1,
      anon_sym_func,
    ACTIONS(369), 1,
      anon_sym_STAR,
    ACTIONS(371), 1,
      anon_sym_LT_DASH,
    ACTIONS(379), 1,
      anon_sym_DQUOTE,
    STATE(495), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1022), 1,
      sym_qualified_type,
    STATE(1258), 1,
      sym_implicit_length_array_type,
    ACTIONS(373), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1283), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(377), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(375), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1108), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(381), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(534), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16971] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(559), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17079] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(560), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17187] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(561), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17295] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(387), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17403] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(388), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17511] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(437), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17619] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(442), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17727] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(444), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17835] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(443), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17943] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(433), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18051] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(387), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(952), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18159] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(436), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18267] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    ACTIONS(537), 1,
      anon_sym_chan,
    STATE(387), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18375] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(440), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18483] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(438), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18591] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(434), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18699] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(265), 1,
      sym_identifier,
    ACTIONS(273), 1,
      anon_sym_func,
    ACTIONS(477), 1,
      anon_sym_LPAREN,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_LT_DASH,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(441), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1041), 1,
      sym_qualified_type,
    STATE(1292), 1,
      sym_implicit_length_array_type,
    ACTIONS(283), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1312), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(485), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1068), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(287), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(502), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18807] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(231), 1,
      sym_identifier,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_func,
    ACTIONS(239), 1,
      anon_sym_STAR,
    ACTIONS(241), 1,
      anon_sym_LT_DASH,
    ACTIONS(251), 1,
      anon_sym_DQUOTE,
    STATE(292), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1018), 1,
      sym_qualified_type,
    STATE(1293), 1,
      sym_implicit_length_array_type,
    ACTIONS(245), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1314), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(249), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(247), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1084), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(253), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(306), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18915] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(231), 1,
      sym_identifier,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_func,
    ACTIONS(239), 1,
      anon_sym_STAR,
    ACTIONS(241), 1,
      anon_sym_LT_DASH,
    ACTIONS(251), 1,
      anon_sym_DQUOTE,
    STATE(297), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1018), 1,
      sym_qualified_type,
    STATE(1293), 1,
      sym_implicit_length_array_type,
    ACTIONS(245), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1314), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(249), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(247), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1084), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(253), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(306), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19023] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(231), 1,
      sym_identifier,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_func,
    ACTIONS(239), 1,
      anon_sym_STAR,
    ACTIONS(241), 1,
      anon_sym_LT_DASH,
    ACTIONS(251), 1,
      anon_sym_DQUOTE,
    STATE(293), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1018), 1,
      sym_qualified_type,
    STATE(1293), 1,
      sym_implicit_length_array_type,
    ACTIONS(245), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1314), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(249), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(247), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1084), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(253), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(306), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19131] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(231), 1,
      sym_identifier,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_func,
    ACTIONS(239), 1,
      anon_sym_STAR,
    ACTIONS(241), 1,
      anon_sym_LT_DASH,
    ACTIONS(251), 1,
      anon_sym_DQUOTE,
    STATE(290), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1018), 1,
      sym_qualified_type,
    STATE(1293), 1,
      sym_implicit_length_array_type,
    ACTIONS(245), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1314), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(249), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(247), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1084), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(253), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(306), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19239] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(231), 1,
      sym_identifier,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_func,
    ACTIONS(239), 1,
      anon_sym_STAR,
    ACTIONS(241), 1,
      anon_sym_LT_DASH,
    ACTIONS(251), 1,
      anon_sym_DQUOTE,
    STATE(294), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1018), 1,
      sym_qualified_type,
    STATE(1293), 1,
      sym_implicit_length_array_type,
    ACTIONS(245), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1314), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(249), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(247), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1084), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(253), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(306), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19347] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(231), 1,
      sym_identifier,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_func,
    ACTIONS(239), 1,
      anon_sym_STAR,
    ACTIONS(241), 1,
      anon_sym_LT_DASH,
    ACTIONS(251), 1,
      anon_sym_DQUOTE,
    STATE(295), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1018), 1,
      sym_qualified_type,
    STATE(1293), 1,
      sym_implicit_length_array_type,
    ACTIONS(245), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1314), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(249), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(247), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1084), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(253), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(306), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19455] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(541), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LPAREN,
    ACTIONS(545), 1,
      anon_sym_func,
    ACTIONS(547), 1,
      anon_sym_STAR,
    ACTIONS(549), 1,
      anon_sym_LT_DASH,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    STATE(343), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1031), 1,
      sym_qualified_type,
    STATE(1295), 1,
      sym_implicit_length_array_type,
    ACTIONS(551), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1315), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(555), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(553), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1096), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(559), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(362), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19563] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(403), 1,
      sym_identifier,
    ACTIONS(405), 1,
      anon_sym_STAR,
    ACTIONS(409), 1,
      anon_sym_LT_DASH,
    STATE(387), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(952), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(411), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19671] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(541), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LPAREN,
    ACTIONS(545), 1,
      anon_sym_func,
    ACTIONS(547), 1,
      anon_sym_STAR,
    ACTIONS(549), 1,
      anon_sym_LT_DASH,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    STATE(339), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1031), 1,
      sym_qualified_type,
    STATE(1295), 1,
      sym_implicit_length_array_type,
    ACTIONS(551), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1315), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(555), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(553), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1096), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(559), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(362), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19779] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(537), 1,
      anon_sym_chan,
    ACTIONS(541), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LPAREN,
    ACTIONS(545), 1,
      anon_sym_func,
    ACTIONS(547), 1,
      anon_sym_STAR,
    ACTIONS(549), 1,
      anon_sym_LT_DASH,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    STATE(343), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1031), 1,
      sym_qualified_type,
    STATE(1295), 1,
      sym_implicit_length_array_type,
    ACTIONS(551), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1315), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(555), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(553), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1096), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(559), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(362), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19887] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(541), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LPAREN,
    ACTIONS(545), 1,
      anon_sym_func,
    ACTIONS(547), 1,
      anon_sym_STAR,
    ACTIONS(549), 1,
      anon_sym_LT_DASH,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    STATE(343), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1031), 1,
      sym_qualified_type,
    STATE(1295), 1,
      sym_implicit_length_array_type,
    ACTIONS(551), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(952), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(555), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(553), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1096), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(559), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(362), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19995] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(363), 1,
      sym_identifier,
    ACTIONS(365), 1,
      anon_sym_LPAREN,
    ACTIONS(367), 1,
      anon_sym_func,
    ACTIONS(369), 1,
      anon_sym_STAR,
    ACTIONS(371), 1,
      anon_sym_LT_DASH,
    ACTIONS(379), 1,
      anon_sym_DQUOTE,
    ACTIONS(537), 1,
      anon_sym_chan,
    STATE(487), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1022), 1,
      sym_qualified_type,
    STATE(1258), 1,
      sym_implicit_length_array_type,
    ACTIONS(373), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1283), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(377), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(375), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1108), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(381), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(534), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20103] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(387), 1,
      sym_identifier,
    ACTIONS(389), 1,
      anon_sym_STAR,
    STATE(387), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(952), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20211] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(363), 1,
      sym_identifier,
    ACTIONS(365), 1,
      anon_sym_LPAREN,
    ACTIONS(367), 1,
      anon_sym_func,
    ACTIONS(369), 1,
      anon_sym_STAR,
    ACTIONS(371), 1,
      anon_sym_LT_DASH,
    ACTIONS(379), 1,
      anon_sym_DQUOTE,
    STATE(487), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1022), 1,
      sym_qualified_type,
    STATE(1258), 1,
      sym_implicit_length_array_type,
    ACTIONS(373), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(952), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(377), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(375), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1108), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(381), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(534), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20319] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(535), 1,
      anon_sym_STAR,
    STATE(647), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1197), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20427] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(607), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20535] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(541), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LPAREN,
    ACTIONS(545), 1,
      anon_sym_func,
    ACTIONS(547), 1,
      anon_sym_STAR,
    ACTIONS(549), 1,
      anon_sym_LT_DASH,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    STATE(340), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1031), 1,
      sym_qualified_type,
    STATE(1295), 1,
      sym_implicit_length_array_type,
    ACTIONS(551), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1315), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(555), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(553), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1096), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(559), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(362), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20643] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(653), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20751] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(654), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20859] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(535), 1,
      anon_sym_STAR,
    STATE(657), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1197), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20967] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(629), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21075] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(541), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LPAREN,
    ACTIONS(545), 1,
      anon_sym_func,
    ACTIONS(547), 1,
      anon_sym_STAR,
    ACTIONS(549), 1,
      anon_sym_LT_DASH,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    STATE(338), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1031), 1,
      sym_qualified_type,
    STATE(1295), 1,
      sym_implicit_length_array_type,
    ACTIONS(551), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1315), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(555), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(553), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1096), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(559), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(362), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21183] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(665), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21291] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(666), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21399] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(535), 1,
      anon_sym_STAR,
    STATE(669), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1197), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21507] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(602), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21615] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(541), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LPAREN,
    ACTIONS(545), 1,
      anon_sym_func,
    ACTIONS(547), 1,
      anon_sym_STAR,
    ACTIONS(549), 1,
      anon_sym_LT_DASH,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    STATE(341), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1031), 1,
      sym_qualified_type,
    STATE(1295), 1,
      sym_implicit_length_array_type,
    ACTIONS(551), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1315), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(555), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(553), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1096), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(559), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(362), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21723] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(674), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21831] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(675), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21939] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(535), 1,
      anon_sym_STAR,
    STATE(676), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1197), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22047] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(605), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22155] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(541), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LPAREN,
    ACTIONS(545), 1,
      anon_sym_func,
    ACTIONS(547), 1,
      anon_sym_STAR,
    ACTIONS(549), 1,
      anon_sym_LT_DASH,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    STATE(342), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1031), 1,
      sym_qualified_type,
    STATE(1295), 1,
      sym_implicit_length_array_type,
    ACTIONS(551), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1315), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(555), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(553), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1096), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(559), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(362), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22263] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(680), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22371] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(681), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22479] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    ACTIONS(535), 1,
      anon_sym_STAR,
    STATE(682), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1197), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22587] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_STAR,
    ACTIONS(399), 1,
      anon_sym_LT_DASH,
    STATE(633), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(401), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22695] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(363), 1,
      sym_identifier,
    ACTIONS(365), 1,
      anon_sym_LPAREN,
    ACTIONS(367), 1,
      anon_sym_func,
    ACTIONS(369), 1,
      anon_sym_STAR,
    ACTIONS(371), 1,
      anon_sym_LT_DASH,
    ACTIONS(379), 1,
      anon_sym_DQUOTE,
    STATE(487), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(1022), 1,
      sym_qualified_type,
    STATE(1258), 1,
      sym_implicit_length_array_type,
    ACTIONS(373), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1283), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(377), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(375), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1108), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(381), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(534), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22803] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(687), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22911] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(688), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [23019] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(293), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_func,
    ACTIONS(301), 1,
      anon_sym_STAR,
    ACTIONS(307), 1,
      anon_sym_LT_DASH,
    ACTIONS(315), 1,
      anon_sym_DQUOTE,
    STATE(622), 1,
      sym__expression,
    STATE(836), 1,
      sym_negated_type,
    STATE(855), 1,
      sym_qualified_type,
    STATE(1268), 1,
      sym_implicit_length_array_type,
    ACTIONS(309), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(313), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(858), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(311), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(894), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(317), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(394), 13,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_type_instantiation_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [23127] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(561), 1,
      sym_identifier,
    ACTIONS(563), 1,
      anon_sym_DOT,
    ACTIONS(566), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_COMMA,
    ACTIONS(572), 1,
      anon_sym_func,
    ACTIONS(574), 1,
      anon_sym_LBRACK,
    ACTIONS(580), 1,
      anon_sym_STAR,
    ACTIONS(585), 1,
      anon_sym_map,
    ACTIONS(587), 1,
      anon_sym_chan,
    ACTIONS(589), 1,
      anon_sym_LT_DASH,
    STATE(398), 1,
      sym_literal_value,
    STATE(533), 1,
      aux_sym_var_spec_repeat1,
    STATE(854), 1,
      sym_type_arguments,
    STATE(1310), 1,
      sym_type_elem,
    STATE(848), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1117), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(583), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(578), 14,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23227] = 10,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(578), 1,
      anon_sym_LF,
    ACTIONS(591), 1,
      anon_sym_DOT,
    ACTIONS(594), 1,
      anon_sym_LPAREN,
    ACTIONS(597), 1,
      anon_sym_LBRACK,
    ACTIONS(601), 1,
      anon_sym_LBRACE,
    ACTIONS(603), 1,
      anon_sym_COLON,
    STATE(253), 1,
      sym_literal_value,
    STATE(854), 1,
      sym_type_arguments,
    ACTIONS(583), 41,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23298] = 10,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(578), 1,
      anon_sym_LF,
    ACTIONS(591), 1,
      anon_sym_DOT,
    ACTIONS(594), 1,
      anon_sym_LPAREN,
    ACTIONS(597), 1,
      anon_sym_LBRACK,
    ACTIONS(601), 1,
      anon_sym_LBRACE,
    ACTIONS(605), 1,
      anon_sym_COLON,
    STATE(253), 1,
      sym_literal_value,
    STATE(854), 1,
      sym_type_arguments,
    ACTIONS(583), 41,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23369] = 19,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(607), 1,
      anon_sym_LF,
    ACTIONS(611), 1,
      anon_sym_DOT,
    ACTIONS(613), 1,
      anon_sym_LPAREN,
    ACTIONS(615), 1,
      anon_sym_COMMA,
    ACTIONS(619), 1,
      anon_sym_LBRACK,
    ACTIONS(625), 1,
      anon_sym_LT_DASH,
    ACTIONS(627), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(629), 1,
      anon_sym_DASH_DASH,
    ACTIONS(633), 1,
      anon_sym_AMP_AMP,
    ACTIONS(635), 1,
      anon_sym_PIPE_PIPE,
    STATE(265), 1,
      sym_argument_list,
    STATE(790), 1,
      aux_sym_expression_list_repeat1,
    STATE(1256), 1,
      sym_type_arguments,
    ACTIONS(623), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(609), 5,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(631), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(621), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(617), 13,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [23457] = 9,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(578), 1,
      anon_sym_LF,
    ACTIONS(591), 1,
      anon_sym_DOT,
    ACTIONS(594), 1,
      anon_sym_LPAREN,
    ACTIONS(597), 1,
      anon_sym_LBRACK,
    ACTIONS(601), 1,
      anon_sym_LBRACE,
    STATE(253), 1,
      sym_literal_value,
    STATE(854), 1,
      sym_type_arguments,
    ACTIONS(583), 41,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23525] = 11,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(611), 1,
      anon_sym_DOT,
    ACTIONS(613), 1,
      anon_sym_LPAREN,
    ACTIONS(619), 1,
      anon_sym_LBRACK,
    ACTIONS(637), 1,
      anon_sym_LF,
    STATE(265), 1,
      sym_argument_list,
    STATE(1256), 1,
      sym_type_arguments,
    ACTIONS(623), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(631), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(621), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(639), 24,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23596] = 8,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(611), 1,
      anon_sym_DOT,
    ACTIONS(613), 1,
      anon_sym_LPAREN,
    ACTIONS(619), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_LF,
    STATE(265), 1,
      sym_argument_list,
    STATE(1256), 1,
      sym_type_arguments,
    ACTIONS(643), 41,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23661] = 10,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(611), 1,
      anon_sym_DOT,
    ACTIONS(613), 1,
      anon_sym_LPAREN,
    ACTIONS(619), 1,
      anon_sym_LBRACK,
    ACTIONS(637), 1,
      anon_sym_LF,
    STATE(265), 1,
      sym_argument_list,
    STATE(1256), 1,
      sym_type_arguments,
    ACTIONS(623), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(621), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(639), 30,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23730] = 12,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(611), 1,
      anon_sym_DOT,
    ACTIONS(613), 1,
      anon_sym_LPAREN,
    ACTIONS(619), 1,
      anon_sym_LBRACK,
    ACTIONS(633), 1,
      anon_sym_AMP_AMP,
    ACTIONS(637), 1,
      anon_sym_LF,
    STATE(265), 1,
      sym_argument_list,
    STATE(1256), 1,
      sym_type_arguments,
    ACTIONS(623), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(631), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(621), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(639), 23,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PIPE_PIPE,
  [23803] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 17,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(645), 30,
      anon_sym_package,
      anon_sym_import,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_struct,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      sym_identifier,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23858] = 8,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(611), 1,
      anon_sym_DOT,
    ACTIONS(613), 1,
      anon_sym_LPAREN,
    ACTIONS(619), 1,
      anon_sym_LBRACK,
    ACTIONS(637), 1,
      anon_sym_LF,
    STATE(265), 1,
      sym_argument_list,
    STATE(1256), 1,
      sym_type_arguments,
    ACTIONS(639), 41,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23923] = 9,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(611), 1,
      anon_sym_DOT,
    ACTIONS(613), 1,
      anon_sym_LPAREN,
    ACTIONS(619), 1,
      anon_sym_LBRACK,
    ACTIONS(637), 1,
      anon_sym_LF,
    STATE(265), 1,
      sym_argument_list,
    STATE(1256), 1,
      sym_type_arguments,
    ACTIONS(621), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(639), 34,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23990] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(647), 1,
      anon_sym_LF,
    ACTIONS(649), 45,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_else,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24044] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_LF,
    ACTIONS(653), 45,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_else,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24098] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(655), 1,
      anon_sym_LF,
    ACTIONS(657), 45,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24152] = 5,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(578), 1,
      anon_sym_LF,
    ACTIONS(659), 1,
      anon_sym_LPAREN,
    STATE(265), 1,
      sym_special_argument_list,
    ACTIONS(583), 43,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24210] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(661), 1,
      anon_sym_LF,
    ACTIONS(663), 45,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24264] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(665), 1,
      anon_sym_LF,
    ACTIONS(667), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24317] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(669), 1,
      anon_sym_LF,
    ACTIONS(671), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24370] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LBRACE,
    ACTIONS(607), 1,
      anon_sym_SEMI,
    ACTIONS(617), 1,
      anon_sym_EQ,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(677), 1,
      anon_sym_COMMA,
    ACTIONS(679), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_LT_DASH,
    ACTIONS(689), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(691), 1,
      anon_sym_DASH_DASH,
    ACTIONS(697), 1,
      anon_sym_AMP_AMP,
    ACTIONS(699), 1,
      anon_sym_PIPE_PIPE,
    STATE(303), 1,
      sym_argument_list,
    STATE(790), 1,
      aux_sym_expression_list_repeat1,
    STATE(901), 1,
      sym_block,
    STATE(1259), 1,
      sym_type_arguments,
    ACTIONS(695), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(683), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(693), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(681), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(687), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [24461] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(701), 1,
      anon_sym_LF,
    ACTIONS(703), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24514] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(705), 1,
      anon_sym_LF,
    ACTIONS(707), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24567] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(709), 1,
      anon_sym_LF,
    ACTIONS(711), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24620] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LBRACE,
    ACTIONS(607), 1,
      anon_sym_SEMI,
    ACTIONS(617), 1,
      anon_sym_EQ,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(677), 1,
      anon_sym_COMMA,
    ACTIONS(679), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_LT_DASH,
    ACTIONS(689), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(691), 1,
      anon_sym_DASH_DASH,
    ACTIONS(697), 1,
      anon_sym_AMP_AMP,
    ACTIONS(699), 1,
      anon_sym_PIPE_PIPE,
    STATE(303), 1,
      sym_argument_list,
    STATE(790), 1,
      aux_sym_expression_list_repeat1,
    STATE(913), 1,
      sym_block,
    STATE(1259), 1,
      sym_type_arguments,
    ACTIONS(695), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(683), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(693), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(681), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(687), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [24711] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(713), 1,
      anon_sym_LF,
    ACTIONS(715), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24764] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(717), 1,
      anon_sym_LF,
    ACTIONS(719), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24817] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(721), 1,
      anon_sym_LF,
    ACTIONS(723), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24870] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(725), 1,
      anon_sym_LF,
    ACTIONS(727), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24923] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(729), 1,
      anon_sym_LF,
    ACTIONS(731), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24976] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LF,
    ACTIONS(735), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25029] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(578), 1,
      anon_sym_LF,
    ACTIONS(583), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25082] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(737), 1,
      anon_sym_LF,
    ACTIONS(739), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25135] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(741), 1,
      anon_sym_LF,
    ACTIONS(743), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25188] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(745), 1,
      anon_sym_LF,
    ACTIONS(747), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25241] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(749), 1,
      anon_sym_LF,
    ACTIONS(751), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25294] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(753), 1,
      anon_sym_LF,
    ACTIONS(755), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25347] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(757), 1,
      anon_sym_LF,
    ACTIONS(759), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25400] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(761), 1,
      anon_sym_LF,
    ACTIONS(763), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25453] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(765), 1,
      anon_sym_LF,
    ACTIONS(767), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25506] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(769), 1,
      anon_sym_LF,
    ACTIONS(771), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25559] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_LF,
    ACTIONS(775), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25612] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(777), 1,
      anon_sym_LF,
    ACTIONS(779), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25665] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(781), 1,
      anon_sym_LF,
    ACTIONS(783), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25718] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(785), 1,
      anon_sym_LF,
    ACTIONS(787), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25771] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(789), 1,
      anon_sym_LF,
    ACTIONS(791), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25824] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(793), 1,
      anon_sym_LF,
    ACTIONS(795), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25877] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_LF,
    ACTIONS(799), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25930] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(801), 1,
      anon_sym_LF,
    ACTIONS(803), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25983] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(805), 1,
      anon_sym_LF,
    ACTIONS(807), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26036] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(809), 1,
      anon_sym_LF,
    ACTIONS(811), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26089] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(813), 1,
      anon_sym_LF,
    ACTIONS(815), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26142] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(817), 1,
      anon_sym_LF,
    ACTIONS(819), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26195] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(821), 1,
      anon_sym_LF,
    ACTIONS(823), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26248] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      anon_sym_SEMI,
    ACTIONS(617), 1,
      anon_sym_EQ,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(677), 1,
      anon_sym_COMMA,
    ACTIONS(679), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_LT_DASH,
    ACTIONS(689), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(691), 1,
      anon_sym_DASH_DASH,
    ACTIONS(697), 1,
      anon_sym_AMP_AMP,
    ACTIONS(699), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(825), 1,
      anon_sym_DOT,
    ACTIONS(827), 1,
      anon_sym_LBRACE,
    STATE(303), 1,
      sym_argument_list,
    STATE(790), 1,
      aux_sym_expression_list_repeat1,
    STATE(1259), 1,
      sym_type_arguments,
    ACTIONS(695), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(683), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(693), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(681), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(687), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [26336] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(679), 1,
      anon_sym_LBRACK,
    STATE(303), 1,
      sym_argument_list,
    STATE(1259), 1,
      sym_type_arguments,
    ACTIONS(639), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(683), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(681), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(637), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26401] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      anon_sym_LBRACE,
    ACTIONS(617), 1,
      anon_sym_EQ,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(677), 1,
      anon_sym_COMMA,
    ACTIONS(679), 1,
      anon_sym_LBRACK,
    ACTIONS(689), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(691), 1,
      anon_sym_DASH_DASH,
    ACTIONS(697), 1,
      anon_sym_AMP_AMP,
    ACTIONS(699), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(829), 1,
      anon_sym_LT_DASH,
    STATE(303), 1,
      sym_argument_list,
    STATE(790), 1,
      aux_sym_expression_list_repeat1,
    STATE(1259), 1,
      sym_type_arguments,
    ACTIONS(695), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(683), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(693), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(681), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(687), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [26486] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(679), 1,
      anon_sym_LBRACK,
    STATE(303), 1,
      sym_argument_list,
    STATE(1259), 1,
      sym_type_arguments,
    ACTIONS(643), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(641), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26547] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(679), 1,
      anon_sym_LBRACK,
    STATE(303), 1,
      sym_argument_list,
    STATE(1259), 1,
      sym_type_arguments,
    ACTIONS(639), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(681), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(637), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26610] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_EQ,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(679), 1,
      anon_sym_LBRACK,
    STATE(303), 1,
      sym_argument_list,
    STATE(1259), 1,
      sym_type_arguments,
    ACTIONS(695), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(683), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(693), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(681), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(637), 20,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26679] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_EQ,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(679), 1,
      anon_sym_LBRACK,
    ACTIONS(697), 1,
      anon_sym_AMP_AMP,
    STATE(303), 1,
      sym_argument_list,
    STATE(1259), 1,
      sym_type_arguments,
    ACTIONS(695), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(683), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(693), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(681), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(637), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_PIPE,
  [26750] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(563), 1,
      anon_sym_DOT,
    ACTIONS(831), 1,
      anon_sym_LPAREN,
    ACTIONS(834), 1,
      anon_sym_LBRACK,
    STATE(304), 1,
      sym_literal_value,
    STATE(854), 1,
      sym_type_arguments,
    ACTIONS(583), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26811] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(679), 1,
      anon_sym_LBRACK,
    STATE(303), 1,
      sym_argument_list,
    STATE(1259), 1,
      sym_type_arguments,
    ACTIONS(639), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(637), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26872] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 1,
      anon_sym_LPAREN,
    STATE(303), 1,
      sym_special_argument_list,
    ACTIONS(583), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 26,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26926] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(731), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(729), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26975] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(653), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(651), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27024] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(809), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(813), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27122] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(733), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(667), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(665), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27220] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(671), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(669), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27269] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27318] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(663), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(661), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27367] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(787), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(785), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27416] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(743), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(741), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27465] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(647), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27514] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(739), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(737), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27563] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(821), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27612] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(747), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(745), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27661] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(797), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27710] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(801), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27759] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(817), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27808] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(707), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(705), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27857] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(701), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27906] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(709), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27955] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(715), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(713), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28004] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(719), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(717), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28053] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(723), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(721), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28102] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(727), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(725), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28151] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(657), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(655), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28200] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(753), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28249] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(759), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(757), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28298] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(763), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(761), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28347] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(767), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(765), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28396] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(771), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(769), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28445] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(775), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(773), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28494] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(777), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28543] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(783), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(781), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28592] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(805), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28641] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(789), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28690] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(793), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28739] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(749), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28788] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(563), 1,
      anon_sym_DOT,
    ACTIONS(831), 1,
      anon_sym_LPAREN,
    ACTIONS(834), 1,
      anon_sym_LBRACK,
    ACTIONS(840), 1,
      anon_sym_LBRACE,
    STATE(383), 1,
      sym_literal_value,
    STATE(854), 1,
      sym_type_arguments,
    ACTIONS(583), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28847] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_DOT,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(846), 1,
      anon_sym_LBRACK,
    STATE(365), 1,
      sym_argument_list,
    STATE(1313), 1,
      sym_type_arguments,
    ACTIONS(639), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(850), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(848), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(637), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28907] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_DOT,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(846), 1,
      anon_sym_LBRACK,
    STATE(365), 1,
      sym_argument_list,
    STATE(1313), 1,
      sym_type_arguments,
    ACTIONS(639), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(637), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28963] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_DOT,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(846), 1,
      anon_sym_LBRACK,
    STATE(365), 1,
      sym_argument_list,
    STATE(1313), 1,
      sym_type_arguments,
    ACTIONS(639), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(848), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(637), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29021] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_EQ,
    ACTIONS(842), 1,
      anon_sym_DOT,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(846), 1,
      anon_sym_LBRACK,
    STATE(365), 1,
      sym_argument_list,
    STATE(1313), 1,
      sym_type_arguments,
    ACTIONS(854), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(850), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(852), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(848), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(637), 15,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29085] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_EQ,
    ACTIONS(842), 1,
      anon_sym_DOT,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(846), 1,
      anon_sym_LBRACK,
    ACTIONS(856), 1,
      anon_sym_AMP_AMP,
    STATE(365), 1,
      sym_argument_list,
    STATE(1313), 1,
      sym_type_arguments,
    ACTIONS(854), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(850), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(852), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(848), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(637), 14,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_PIPE,
  [29151] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_DOT,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(846), 1,
      anon_sym_LBRACK,
    STATE(365), 1,
      sym_argument_list,
    STATE(1313), 1,
      sym_type_arguments,
    ACTIONS(643), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(641), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29207] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_DOT,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(846), 1,
      anon_sym_LBRACK,
    ACTIONS(856), 1,
      anon_sym_AMP_AMP,
    ACTIONS(860), 1,
      anon_sym_EQ,
    ACTIONS(862), 1,
      anon_sym_PIPE_PIPE,
    STATE(365), 1,
      sym_argument_list,
    STATE(1313), 1,
      sym_type_arguments,
    ACTIONS(854), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(850), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(852), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(848), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(858), 13,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [29275] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 1,
      anon_sym_LPAREN,
    STATE(365), 1,
      sym_special_argument_list,
    ACTIONS(583), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 21,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29324] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(723), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(721), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29368] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(777), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(783), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(781), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29456] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(789), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29500] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(793), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29544] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(797), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(801), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29632] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(805), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29676] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(809), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29720] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(813), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29764] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(663), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(661), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29808] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(657), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(655), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29852] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(731), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(729), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29896] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(753), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29940] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(759), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(757), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29984] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(763), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(761), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30028] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30072] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(767), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(765), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30116] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(653), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(651), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30160] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(733), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30204] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(727), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(725), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30248] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(671), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(669), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30292] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(787), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(785), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30336] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(771), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(769), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30380] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(743), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(741), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30424] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(647), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30468] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(739), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(737), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30512] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(821), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30556] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(747), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(745), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30600] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(749), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30644] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(775), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(773), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30688] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(817), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30732] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(707), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(705), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30776] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(701), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30820] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(709), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30864] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(715), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(713), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30908] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(719), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(717), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30952] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(667), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(665), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30996] = 17,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(866), 1,
      sym_identifier,
    ACTIONS(868), 1,
      anon_sym_LF,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(874), 1,
      anon_sym_func,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_STAR,
    ACTIONS(880), 1,
      anon_sym_struct,
    ACTIONS(882), 1,
      anon_sym_TILDE,
    ACTIONS(884), 1,
      anon_sym_interface,
    ACTIONS(886), 1,
      anon_sym_map,
    ACTIONS(888), 1,
      anon_sym_chan,
    ACTIONS(890), 1,
      anon_sym_LT_DASH,
    STATE(796), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(830), 2,
      sym_parameter_list,
      sym__simple_type,
    STATE(807), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(870), 10,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
  [31067] = 24,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(880), 1,
      anon_sym_struct,
    ACTIONS(882), 1,
      anon_sym_TILDE,
    ACTIONS(884), 1,
      anon_sym_interface,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(894), 1,
      anon_sym_LF,
    ACTIONS(898), 1,
      anon_sym_DOT,
    ACTIONS(900), 1,
      anon_sym_LPAREN,
    ACTIONS(902), 1,
      anon_sym_COMMA,
    ACTIONS(904), 1,
      anon_sym_func,
    ACTIONS(906), 1,
      anon_sym_LBRACK,
    ACTIONS(908), 1,
      anon_sym_STAR,
    ACTIONS(910), 1,
      anon_sym_map,
    ACTIONS(912), 1,
      anon_sym_chan,
    ACTIONS(914), 1,
      anon_sym_LT_DASH,
    ACTIONS(916), 1,
      sym_raw_string_literal,
    ACTIONS(918), 1,
      anon_sym_DQUOTE,
    STATE(635), 1,
      aux_sym_field_declaration_repeat1,
    STATE(813), 1,
      sym_type_arguments,
    STATE(1079), 1,
      sym_interpreted_string_literal,
    STATE(799), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(906), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(896), 3,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_RBRACE,
    STATE(807), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [31152] = 17,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(868), 1,
      anon_sym_LF,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(880), 1,
      anon_sym_struct,
    ACTIONS(882), 1,
      anon_sym_TILDE,
    ACTIONS(884), 1,
      anon_sym_interface,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(904), 1,
      anon_sym_func,
    ACTIONS(908), 1,
      anon_sym_STAR,
    ACTIONS(910), 1,
      anon_sym_map,
    ACTIONS(912), 1,
      anon_sym_chan,
    ACTIONS(914), 1,
      anon_sym_LT_DASH,
    ACTIONS(920), 1,
      anon_sym_LBRACK,
    STATE(799), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(830), 2,
      sym_parameter_list,
      sym__simple_type,
    STATE(807), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(870), 10,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
  [31223] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 1,
      anon_sym_DOT,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_LBRACK,
    STATE(397), 1,
      sym_argument_list,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(643), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(641), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31275] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 1,
      anon_sym_DOT,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_LBRACK,
    STATE(397), 1,
      sym_argument_list,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(639), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(637), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31327] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 1,
      anon_sym_LPAREN,
    STATE(397), 1,
      sym_special_argument_list,
    ACTIONS(583), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 23,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31372] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(563), 1,
      anon_sym_DOT,
    ACTIONS(834), 1,
      anon_sym_LBRACK,
    STATE(398), 1,
      sym_literal_value,
    STATE(854), 1,
      sym_type_arguments,
    ACTIONS(831), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(583), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31425] = 20,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(279), 1,
      anon_sym_TILDE,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(561), 1,
      sym_identifier,
    ACTIONS(572), 1,
      anon_sym_func,
    ACTIONS(585), 1,
      anon_sym_map,
    ACTIONS(587), 1,
      anon_sym_chan,
    ACTIONS(930), 1,
      anon_sym_LF,
    ACTIONS(934), 1,
      anon_sym_LPAREN,
    ACTIONS(936), 1,
      anon_sym_COMMA,
    ACTIONS(938), 1,
      anon_sym_EQ,
    ACTIONS(940), 1,
      anon_sym_LBRACK,
    ACTIONS(942), 1,
      anon_sym_STAR,
    ACTIONS(944), 1,
      anon_sym_LT_DASH,
    STATE(392), 1,
      aux_sym_const_spec_repeat1,
    STATE(848), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1323), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(932), 5,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [31500] = 20,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(279), 1,
      anon_sym_TILDE,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(561), 1,
      sym_identifier,
    ACTIONS(572), 1,
      anon_sym_func,
    ACTIONS(585), 1,
      anon_sym_map,
    ACTIONS(587), 1,
      anon_sym_chan,
    ACTIONS(934), 1,
      anon_sym_LPAREN,
    ACTIONS(936), 1,
      anon_sym_COMMA,
    ACTIONS(940), 1,
      anon_sym_LBRACK,
    ACTIONS(942), 1,
      anon_sym_STAR,
    ACTIONS(944), 1,
      anon_sym_LT_DASH,
    ACTIONS(946), 1,
      anon_sym_LF,
    ACTIONS(950), 1,
      anon_sym_EQ,
    STATE(780), 1,
      aux_sym_const_spec_repeat1,
    STATE(848), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1320), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(948), 5,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [31575] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(701), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31615] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31655] = 15,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(687), 1,
      anon_sym_LF,
    ACTIONS(952), 1,
      anon_sym_DOT,
    ACTIONS(954), 1,
      anon_sym_LPAREN,
    ACTIONS(956), 1,
      anon_sym_COMMA,
    ACTIONS(958), 1,
      anon_sym_LBRACK,
    ACTIONS(966), 1,
      anon_sym_AMP_AMP,
    ACTIONS(968), 1,
      anon_sym_PIPE_PIPE,
    STATE(504), 1,
      sym_argument_list,
    STATE(881), 1,
      aux_sym_expression_list_repeat1,
    STATE(1275), 1,
      sym_type_arguments,
    ACTIONS(962), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(617), 5,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(964), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(960), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [31719] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(653), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(651), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31759] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(733), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31799] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(667), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(665), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31839] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(671), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(669), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31879] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(787), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(785), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(743), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(741), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31959] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(647), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31999] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(739), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(737), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32039] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(821), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32079] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(747), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(745), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(749), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32159] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(817), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32199] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(707), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(705), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32239] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(657), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(655), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32279] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(709), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32319] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(715), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(713), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32359] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(719), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(717), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32399] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(723), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(721), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32439] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(727), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(725), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32479] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(731), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(729), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(753), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32559] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(759), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(757), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32599] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(763), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(761), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32639] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(767), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(765), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32679] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(771), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(769), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32719] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(775), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(773), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32759] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(777), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32799] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(783), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(781), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32839] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(789), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32879] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(793), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(797), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32959] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(801), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32999] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(805), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33039] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(809), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33079] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(813), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33119] = 9,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(578), 1,
      anon_sym_LF,
    ACTIONS(591), 1,
      anon_sym_DOT,
    ACTIONS(594), 1,
      anon_sym_LPAREN,
    ACTIONS(597), 1,
      anon_sym_LBRACK,
    ACTIONS(970), 1,
      anon_sym_LBRACE,
    STATE(505), 1,
      sym_literal_value,
    STATE(854), 1,
      sym_type_arguments,
    ACTIONS(583), 25,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(663), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(661), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33211] = 8,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(641), 1,
      anon_sym_LF,
    ACTIONS(952), 1,
      anon_sym_DOT,
    ACTIONS(954), 1,
      anon_sym_LPAREN,
    ACTIONS(958), 1,
      anon_sym_LBRACK,
    STATE(504), 1,
      sym_argument_list,
    STATE(1275), 1,
      sym_type_arguments,
    ACTIONS(643), 25,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33260] = 11,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(637), 1,
      anon_sym_LF,
    ACTIONS(952), 1,
      anon_sym_DOT,
    ACTIONS(954), 1,
      anon_sym_LPAREN,
    ACTIONS(958), 1,
      anon_sym_LBRACK,
    STATE(504), 1,
      sym_argument_list,
    STATE(1275), 1,
      sym_type_arguments,
    ACTIONS(962), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(964), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(960), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(639), 8,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33315] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(561), 1,
      sym_identifier,
    ACTIONS(572), 1,
      anon_sym_func,
    ACTIONS(585), 1,
      anon_sym_map,
    ACTIONS(587), 1,
      anon_sym_chan,
    ACTIONS(589), 1,
      anon_sym_LT_DASH,
    ACTIONS(972), 1,
      anon_sym_LPAREN,
    ACTIONS(974), 1,
      anon_sym_LBRACK,
    ACTIONS(976), 1,
      anon_sym_STAR,
    STATE(848), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(853), 2,
      sym_parameter_list,
      sym__simple_type,
    ACTIONS(868), 7,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_COLON,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [33380] = 8,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(637), 1,
      anon_sym_LF,
    ACTIONS(952), 1,
      anon_sym_DOT,
    ACTIONS(954), 1,
      anon_sym_LPAREN,
    ACTIONS(958), 1,
      anon_sym_LBRACK,
    STATE(504), 1,
      sym_argument_list,
    STATE(1275), 1,
      sym_type_arguments,
    ACTIONS(639), 25,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33429] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_LBRACK,
    ACTIONS(978), 1,
      anon_sym_DOT,
    STATE(397), 1,
      sym_argument_list,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(982), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(639), 5,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(980), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(637), 14,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33482] = 10,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(637), 1,
      anon_sym_LF,
    ACTIONS(952), 1,
      anon_sym_DOT,
    ACTIONS(954), 1,
      anon_sym_LPAREN,
    ACTIONS(958), 1,
      anon_sym_LBRACK,
    STATE(504), 1,
      sym_argument_list,
    STATE(1275), 1,
      sym_type_arguments,
    ACTIONS(962), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(960), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(639), 14,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33535] = 13,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(858), 1,
      anon_sym_LF,
    ACTIONS(952), 1,
      anon_sym_DOT,
    ACTIONS(954), 1,
      anon_sym_LPAREN,
    ACTIONS(958), 1,
      anon_sym_LBRACK,
    ACTIONS(966), 1,
      anon_sym_AMP_AMP,
    ACTIONS(968), 1,
      anon_sym_PIPE_PIPE,
    STATE(504), 1,
      sym_argument_list,
    STATE(1275), 1,
      sym_type_arguments,
    ACTIONS(962), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(860), 6,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(964), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(960), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [33594] = 9,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(637), 1,
      anon_sym_LF,
    ACTIONS(952), 1,
      anon_sym_DOT,
    ACTIONS(954), 1,
      anon_sym_LPAREN,
    ACTIONS(958), 1,
      anon_sym_LBRACK,
    STATE(504), 1,
      sym_argument_list,
    STATE(1275), 1,
      sym_type_arguments,
    ACTIONS(960), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(639), 18,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33645] = 12,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(637), 1,
      anon_sym_LF,
    ACTIONS(952), 1,
      anon_sym_DOT,
    ACTIONS(954), 1,
      anon_sym_LPAREN,
    ACTIONS(958), 1,
      anon_sym_LBRACK,
    ACTIONS(966), 1,
      anon_sym_AMP_AMP,
    STATE(504), 1,
      sym_argument_list,
    STATE(1275), 1,
      sym_type_arguments,
    ACTIONS(962), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(964), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(639), 7,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PIPE_PIPE,
    ACTIONS(960), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [33702] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_LBRACK,
    ACTIONS(978), 1,
      anon_sym_DOT,
    ACTIONS(984), 1,
      anon_sym_PIPE,
    STATE(397), 1,
      sym_argument_list,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(982), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(986), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(639), 4,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(980), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(637), 11,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33759] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_LBRACK,
    ACTIONS(978), 1,
      anon_sym_DOT,
    ACTIONS(984), 1,
      anon_sym_PIPE,
    ACTIONS(992), 1,
      anon_sym_AMP_AMP,
    STATE(397), 1,
      sym_argument_list,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(639), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    ACTIONS(982), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(990), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(986), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(988), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(980), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(637), 6,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PIPE_PIPE,
  [33822] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_LBRACK,
    ACTIONS(978), 1,
      anon_sym_DOT,
    ACTIONS(984), 1,
      anon_sym_PIPE,
    STATE(397), 1,
      sym_argument_list,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(639), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    ACTIONS(982), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(990), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(986), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(988), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(980), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(637), 7,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33883] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(972), 1,
      anon_sym_LPAREN,
    ACTIONS(994), 1,
      sym_identifier,
    ACTIONS(996), 1,
      anon_sym_func,
    ACTIONS(998), 1,
      anon_sym_LBRACK,
    ACTIONS(1000), 1,
      anon_sym_STAR,
    ACTIONS(1002), 1,
      anon_sym_LT_DASH,
    STATE(836), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(853), 2,
      sym_parameter_list,
      sym__simple_type,
    ACTIONS(868), 7,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_COLON,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [33948] = 13,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(952), 1,
      anon_sym_DOT,
    ACTIONS(954), 1,
      anon_sym_LPAREN,
    ACTIONS(958), 1,
      anon_sym_LBRACK,
    ACTIONS(966), 1,
      anon_sym_AMP_AMP,
    ACTIONS(968), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1004), 1,
      anon_sym_LF,
    STATE(504), 1,
      sym_argument_list,
    STATE(1275), 1,
      sym_type_arguments,
    ACTIONS(962), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1006), 5,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(964), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(960), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34006] = 13,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(952), 1,
      anon_sym_DOT,
    ACTIONS(954), 1,
      anon_sym_LPAREN,
    ACTIONS(958), 1,
      anon_sym_LBRACK,
    ACTIONS(966), 1,
      anon_sym_AMP_AMP,
    ACTIONS(968), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1008), 1,
      anon_sym_LF,
    STATE(504), 1,
      sym_argument_list,
    STATE(1275), 1,
      sym_type_arguments,
    ACTIONS(962), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1010), 5,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(964), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(960), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34064] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(972), 1,
      anon_sym_LPAREN,
    ACTIONS(994), 1,
      sym_identifier,
    ACTIONS(996), 1,
      anon_sym_func,
    ACTIONS(998), 1,
      anon_sym_LBRACK,
    ACTIONS(1000), 1,
      anon_sym_STAR,
    ACTIONS(1002), 1,
      anon_sym_LT_DASH,
    ACTIONS(1012), 1,
      anon_sym_LBRACE,
    STATE(401), 1,
      sym_block,
    STATE(836), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(880), 2,
      sym_parameter_list,
      sym__simple_type,
    ACTIONS(868), 4,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_PIPE,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [34132] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(617), 1,
      anon_sym_EQ,
    ACTIONS(685), 1,
      anon_sym_LT_DASH,
    ACTIONS(687), 1,
      anon_sym_COLON_EQ,
    ACTIONS(1014), 1,
      anon_sym_DOT,
    ACTIONS(1016), 1,
      anon_sym_LPAREN,
    ACTIONS(1018), 1,
      anon_sym_COMMA,
    ACTIONS(1020), 1,
      anon_sym_LBRACK,
    ACTIONS(1024), 1,
      anon_sym_PIPE,
    ACTIONS(1026), 1,
      anon_sym_COLON,
    ACTIONS(1036), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1038), 1,
      anon_sym_PIPE_PIPE,
    STATE(538), 1,
      sym_argument_list,
    STATE(979), 1,
      aux_sym_expression_list_repeat1,
    STATE(1266), 1,
      sym_type_arguments,
    ACTIONS(1030), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1034), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1032), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1022), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34204] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(561), 1,
      sym_identifier,
    ACTIONS(572), 1,
      anon_sym_func,
    ACTIONS(585), 1,
      anon_sym_map,
    ACTIONS(587), 1,
      anon_sym_chan,
    ACTIONS(589), 1,
      anon_sym_LT_DASH,
    ACTIONS(976), 1,
      anon_sym_STAR,
    ACTIONS(1040), 1,
      anon_sym_DOT,
    ACTIONS(1042), 1,
      anon_sym_LPAREN,
    ACTIONS(1044), 1,
      anon_sym_RPAREN,
    ACTIONS(1046), 1,
      anon_sym_COMMA,
    ACTIONS(1049), 1,
      anon_sym_LBRACK,
    ACTIONS(1051), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(595), 1,
      aux_sym_var_spec_repeat1,
    STATE(854), 1,
      sym_type_arguments,
    STATE(848), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1286), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [34278] = 13,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(952), 1,
      anon_sym_DOT,
    ACTIONS(954), 1,
      anon_sym_LPAREN,
    ACTIONS(958), 1,
      anon_sym_LBRACK,
    ACTIONS(966), 1,
      anon_sym_AMP_AMP,
    ACTIONS(968), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1053), 1,
      anon_sym_LF,
    STATE(504), 1,
      sym_argument_list,
    STATE(1275), 1,
      sym_type_arguments,
    ACTIONS(962), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1055), 5,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(964), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(960), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34336] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(563), 1,
      anon_sym_DOT,
    ACTIONS(831), 1,
      anon_sym_LPAREN,
    ACTIONS(834), 1,
      anon_sym_LBRACK,
    ACTIONS(1057), 1,
      anon_sym_LBRACE,
    STATE(539), 1,
      sym_literal_value,
    STATE(854), 1,
      sym_type_arguments,
    ACTIONS(583), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 17,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34386] = 5,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(578), 1,
      anon_sym_LF,
    ACTIONS(1059), 1,
      anon_sym_LPAREN,
    STATE(504), 1,
      sym_special_argument_list,
    ACTIONS(583), 27,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34428] = 19,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(1063), 1,
      sym_identifier,
    ACTIONS(1067), 1,
      anon_sym_LPAREN,
    ACTIONS(1069), 1,
      anon_sym_func,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_STAR,
    ACTIONS(1075), 1,
      anon_sym_struct,
    ACTIONS(1077), 1,
      anon_sym_TILDE,
    ACTIONS(1079), 1,
      anon_sym_LBRACE,
    ACTIONS(1081), 1,
      anon_sym_interface,
    ACTIONS(1083), 1,
      anon_sym_map,
    ACTIONS(1085), 1,
      anon_sym_chan,
    ACTIONS(1087), 1,
      anon_sym_LT_DASH,
    STATE(1065), 1,
      sym_block,
    ACTIONS(1061), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1065), 2,
      anon_sym_SEMI,
      anon_sym_NULL,
    STATE(910), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(915), 2,
      sym_parameter_list,
      sym__simple_type,
    STATE(950), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [34498] = 19,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(1063), 1,
      sym_identifier,
    ACTIONS(1067), 1,
      anon_sym_LPAREN,
    ACTIONS(1069), 1,
      anon_sym_func,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_STAR,
    ACTIONS(1075), 1,
      anon_sym_struct,
    ACTIONS(1077), 1,
      anon_sym_TILDE,
    ACTIONS(1079), 1,
      anon_sym_LBRACE,
    ACTIONS(1081), 1,
      anon_sym_interface,
    ACTIONS(1083), 1,
      anon_sym_map,
    ACTIONS(1085), 1,
      anon_sym_chan,
    ACTIONS(1087), 1,
      anon_sym_LT_DASH,
    STATE(1066), 1,
      sym_block,
    ACTIONS(1089), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1091), 2,
      anon_sym_SEMI,
      anon_sym_NULL,
    STATE(910), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(959), 2,
      sym_parameter_list,
      sym__simple_type,
    STATE(950), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [34568] = 19,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(1063), 1,
      sym_identifier,
    ACTIONS(1067), 1,
      anon_sym_LPAREN,
    ACTIONS(1069), 1,
      anon_sym_func,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_STAR,
    ACTIONS(1075), 1,
      anon_sym_struct,
    ACTIONS(1077), 1,
      anon_sym_TILDE,
    ACTIONS(1079), 1,
      anon_sym_LBRACE,
    ACTIONS(1081), 1,
      anon_sym_interface,
    ACTIONS(1083), 1,
      anon_sym_map,
    ACTIONS(1085), 1,
      anon_sym_chan,
    ACTIONS(1087), 1,
      anon_sym_LT_DASH,
    STATE(1081), 1,
      sym_block,
    ACTIONS(1093), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1095), 2,
      anon_sym_SEMI,
      anon_sym_NULL,
    STATE(910), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(914), 2,
      sym_parameter_list,
      sym__simple_type,
    STATE(950), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [34638] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(753), 1,
      anon_sym_LF,
    ACTIONS(755), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34675] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(745), 1,
      anon_sym_LF,
    ACTIONS(747), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34712] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(647), 1,
      anon_sym_LF,
    ACTIONS(649), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34749] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_DOT,
    ACTIONS(1016), 1,
      anon_sym_LPAREN,
    ACTIONS(1020), 1,
      anon_sym_LBRACK,
    STATE(538), 1,
      sym_argument_list,
    STATE(1266), 1,
      sym_type_arguments,
    ACTIONS(1030), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(639), 5,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1022), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(637), 12,
      anon_sym_COMMA,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34800] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_DOT,
    ACTIONS(1016), 1,
      anon_sym_LPAREN,
    ACTIONS(1020), 1,
      anon_sym_LBRACK,
    ACTIONS(1024), 1,
      anon_sym_PIPE,
    STATE(538), 1,
      sym_argument_list,
    STATE(1266), 1,
      sym_type_arguments,
    ACTIONS(1030), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1028), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(639), 4,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1022), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(637), 9,
      anon_sym_COMMA,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34855] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_DOT,
    ACTIONS(1016), 1,
      anon_sym_LPAREN,
    ACTIONS(1020), 1,
      anon_sym_LBRACK,
    ACTIONS(1024), 1,
      anon_sym_PIPE,
    STATE(538), 1,
      sym_argument_list,
    STATE(1266), 1,
      sym_type_arguments,
    ACTIONS(639), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    ACTIONS(1030), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1034), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1032), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(637), 5,
      anon_sym_COMMA,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(1022), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34914] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_DOT,
    ACTIONS(1016), 1,
      anon_sym_LPAREN,
    ACTIONS(1020), 1,
      anon_sym_LBRACK,
    ACTIONS(1024), 1,
      anon_sym_PIPE,
    ACTIONS(1036), 1,
      anon_sym_AMP_AMP,
    STATE(538), 1,
      sym_argument_list,
    STATE(1266), 1,
      sym_type_arguments,
    ACTIONS(639), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    ACTIONS(1030), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1034), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(637), 4,
      anon_sym_COMMA,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PIPE_PIPE,
    ACTIONS(1032), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1022), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34975] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(749), 1,
      anon_sym_LF,
    ACTIONS(751), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35012] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(817), 1,
      anon_sym_LF,
    ACTIONS(819), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35049] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(661), 1,
      anon_sym_LF,
    ACTIONS(663), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35086] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(572), 1,
      anon_sym_func,
    ACTIONS(585), 1,
      anon_sym_map,
    ACTIONS(587), 1,
      anon_sym_chan,
    ACTIONS(589), 1,
      anon_sym_LT_DASH,
    ACTIONS(974), 1,
      anon_sym_LBRACK,
    ACTIONS(976), 1,
      anon_sym_STAR,
    ACTIONS(1042), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      sym_identifier,
    ACTIONS(1099), 1,
      anon_sym_RPAREN,
    ACTIONS(1101), 1,
      anon_sym_COMMA,
    ACTIONS(1103), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(848), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1189), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(1273), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [35155] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(705), 1,
      anon_sym_LF,
    ACTIONS(707), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35192] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(701), 1,
      anon_sym_LF,
    ACTIONS(703), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35229] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(709), 1,
      anon_sym_LF,
    ACTIONS(711), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35266] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(713), 1,
      anon_sym_LF,
    ACTIONS(715), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35303] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(717), 1,
      anon_sym_LF,
    ACTIONS(719), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35340] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(721), 1,
      anon_sym_LF,
    ACTIONS(723), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35377] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(725), 1,
      anon_sym_LF,
    ACTIONS(727), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35414] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(729), 1,
      anon_sym_LF,
    ACTIONS(731), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35451] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(757), 1,
      anon_sym_LF,
    ACTIONS(759), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35488] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(761), 1,
      anon_sym_LF,
    ACTIONS(763), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35525] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(572), 1,
      anon_sym_func,
    ACTIONS(585), 1,
      anon_sym_map,
    ACTIONS(587), 1,
      anon_sym_chan,
    ACTIONS(589), 1,
      anon_sym_LT_DASH,
    ACTIONS(974), 1,
      anon_sym_LBRACK,
    ACTIONS(976), 1,
      anon_sym_STAR,
    ACTIONS(1042), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      sym_identifier,
    ACTIONS(1103), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1105), 1,
      anon_sym_RPAREN,
    ACTIONS(1107), 1,
      anon_sym_COMMA,
    STATE(848), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1213), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(1273), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [35594] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(655), 1,
      anon_sym_LF,
    ACTIONS(657), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35631] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(765), 1,
      anon_sym_LF,
    ACTIONS(767), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35668] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(741), 1,
      anon_sym_LF,
    ACTIONS(743), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35705] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_LBRACK,
    ACTIONS(978), 1,
      anon_sym_DOT,
    ACTIONS(984), 1,
      anon_sym_PIPE,
    ACTIONS(992), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1109), 1,
      anon_sym_PIPE_PIPE,
    STATE(397), 1,
      sym_argument_list,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(860), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    ACTIONS(982), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(990), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(858), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
    ACTIONS(986), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(988), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(980), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [35768] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_LF,
    ACTIONS(775), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35805] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(777), 1,
      anon_sym_LF,
    ACTIONS(779), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35842] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(781), 1,
      anon_sym_LF,
    ACTIONS(783), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35879] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(789), 1,
      anon_sym_LF,
    ACTIONS(791), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35916] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_DOT,
    ACTIONS(1016), 1,
      anon_sym_LPAREN,
    ACTIONS(1020), 1,
      anon_sym_LBRACK,
    STATE(538), 1,
      sym_argument_list,
    STATE(1266), 1,
      sym_type_arguments,
    ACTIONS(643), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(641), 17,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35963] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(572), 1,
      anon_sym_func,
    ACTIONS(585), 1,
      anon_sym_map,
    ACTIONS(587), 1,
      anon_sym_chan,
    ACTIONS(589), 1,
      anon_sym_LT_DASH,
    ACTIONS(974), 1,
      anon_sym_LBRACK,
    ACTIONS(976), 1,
      anon_sym_STAR,
    ACTIONS(1042), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      sym_identifier,
    ACTIONS(1103), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1111), 1,
      anon_sym_RPAREN,
    ACTIONS(1113), 1,
      anon_sym_COMMA,
    STATE(848), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1143), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(1273), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [36032] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(793), 1,
      anon_sym_LF,
    ACTIONS(795), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36069] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_LF,
    ACTIONS(799), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36106] = 17,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(1063), 1,
      sym_identifier,
    ACTIONS(1067), 1,
      anon_sym_LPAREN,
    ACTIONS(1069), 1,
      anon_sym_func,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1073), 1,
      anon_sym_STAR,
    ACTIONS(1075), 1,
      anon_sym_struct,
    ACTIONS(1077), 1,
      anon_sym_TILDE,
    ACTIONS(1081), 1,
      anon_sym_interface,
    ACTIONS(1083), 1,
      anon_sym_map,
    ACTIONS(1085), 1,
      anon_sym_chan,
    ACTIONS(1087), 1,
      anon_sym_LT_DASH,
    ACTIONS(868), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    STATE(910), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(919), 2,
      sym_parameter_list,
      sym__simple_type,
    ACTIONS(870), 3,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_LBRACE,
    STATE(950), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [36171] = 17,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(1067), 1,
      anon_sym_LPAREN,
    ACTIONS(1075), 1,
      anon_sym_struct,
    ACTIONS(1077), 1,
      anon_sym_TILDE,
    ACTIONS(1081), 1,
      anon_sym_interface,
    ACTIONS(1115), 1,
      sym_identifier,
    ACTIONS(1117), 1,
      anon_sym_func,
    ACTIONS(1119), 1,
      anon_sym_LBRACK,
    ACTIONS(1121), 1,
      anon_sym_STAR,
    ACTIONS(1123), 1,
      anon_sym_map,
    ACTIONS(1125), 1,
      anon_sym_chan,
    ACTIONS(1127), 1,
      anon_sym_LT_DASH,
    ACTIONS(868), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    STATE(895), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(919), 2,
      sym_parameter_list,
      sym__simple_type,
    ACTIONS(870), 3,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_LBRACE,
    STATE(950), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [36236] = 19,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(880), 1,
      anon_sym_struct,
    ACTIONS(882), 1,
      anon_sym_TILDE,
    ACTIONS(884), 1,
      anon_sym_interface,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(904), 1,
      anon_sym_func,
    ACTIONS(908), 1,
      anon_sym_STAR,
    ACTIONS(910), 1,
      anon_sym_map,
    ACTIONS(912), 1,
      anon_sym_chan,
    ACTIONS(914), 1,
      anon_sym_LT_DASH,
    ACTIONS(920), 1,
      anon_sym_LBRACK,
    ACTIONS(1089), 1,
      anon_sym_LF,
    ACTIONS(1129), 1,
      anon_sym_LBRACE,
    STATE(1235), 1,
      sym_block,
    ACTIONS(1091), 2,
      anon_sym_SEMI,
      anon_sym_NULL,
    STATE(799), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1044), 2,
      sym_parameter_list,
      sym__simple_type,
    STATE(807), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [36305] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(801), 1,
      anon_sym_LF,
    ACTIONS(803), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36342] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_DOT,
    ACTIONS(1016), 1,
      anon_sym_LPAREN,
    ACTIONS(1020), 1,
      anon_sym_LBRACK,
    STATE(538), 1,
      sym_argument_list,
    STATE(1266), 1,
      sym_type_arguments,
    ACTIONS(639), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(637), 17,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36389] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(805), 1,
      anon_sym_LF,
    ACTIONS(807), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36426] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(809), 1,
      anon_sym_LF,
    ACTIONS(811), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36463] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(813), 1,
      anon_sym_LF,
    ACTIONS(815), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36500] = 19,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(880), 1,
      anon_sym_struct,
    ACTIONS(882), 1,
      anon_sym_TILDE,
    ACTIONS(884), 1,
      anon_sym_interface,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(904), 1,
      anon_sym_func,
    ACTIONS(908), 1,
      anon_sym_STAR,
    ACTIONS(910), 1,
      anon_sym_map,
    ACTIONS(912), 1,
      anon_sym_chan,
    ACTIONS(914), 1,
      anon_sym_LT_DASH,
    ACTIONS(920), 1,
      anon_sym_LBRACK,
    ACTIONS(1093), 1,
      anon_sym_LF,
    ACTIONS(1129), 1,
      anon_sym_LBRACE,
    STATE(1210), 1,
      sym_block,
    ACTIONS(1095), 2,
      anon_sym_SEMI,
      anon_sym_NULL,
    STATE(799), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1049), 2,
      sym_parameter_list,
      sym__simple_type,
    STATE(807), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [36569] = 19,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(880), 1,
      anon_sym_struct,
    ACTIONS(882), 1,
      anon_sym_TILDE,
    ACTIONS(884), 1,
      anon_sym_interface,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(904), 1,
      anon_sym_func,
    ACTIONS(908), 1,
      anon_sym_STAR,
    ACTIONS(910), 1,
      anon_sym_map,
    ACTIONS(912), 1,
      anon_sym_chan,
    ACTIONS(914), 1,
      anon_sym_LT_DASH,
    ACTIONS(920), 1,
      anon_sym_LBRACK,
    ACTIONS(1061), 1,
      anon_sym_LF,
    ACTIONS(1129), 1,
      anon_sym_LBRACE,
    STATE(1241), 1,
      sym_block,
    ACTIONS(1065), 2,
      anon_sym_SEMI,
      anon_sym_NULL,
    STATE(799), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1048), 2,
      sym_parameter_list,
      sym__simple_type,
    STATE(807), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [36638] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(785), 1,
      anon_sym_LF,
    ACTIONS(787), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36675] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(578), 1,
      anon_sym_LF,
    ACTIONS(583), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36712] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(737), 1,
      anon_sym_LF,
    ACTIONS(739), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36749] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_LF,
    ACTIONS(735), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36786] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(665), 1,
      anon_sym_LF,
    ACTIONS(667), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36823] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_LF,
    ACTIONS(653), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36860] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(669), 1,
      anon_sym_LF,
    ACTIONS(671), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36897] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(821), 1,
      anon_sym_LF,
    ACTIONS(823), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36934] = 3,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(769), 1,
      anon_sym_LF,
    ACTIONS(771), 28,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36971] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(572), 1,
      anon_sym_func,
    ACTIONS(585), 1,
      anon_sym_map,
    ACTIONS(587), 1,
      anon_sym_chan,
    ACTIONS(589), 1,
      anon_sym_LT_DASH,
    ACTIONS(974), 1,
      anon_sym_LBRACK,
    ACTIONS(976), 1,
      anon_sym_STAR,
    ACTIONS(1042), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      sym_identifier,
    ACTIONS(1103), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1131), 1,
      anon_sym_RPAREN,
    STATE(848), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1273), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1304), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [37037] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 1,
      anon_sym_DOT,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_LBRACK,
    ACTIONS(1133), 1,
      anon_sym_RPAREN,
    ACTIONS(1135), 1,
      anon_sym_COMMA,
    ACTIONS(1137), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1141), 1,
      anon_sym_PIPE,
    ACTIONS(1151), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1153), 1,
      anon_sym_PIPE_PIPE,
    STATE(397), 1,
      sym_argument_list,
    STATE(1185), 1,
      aux_sym_argument_list_repeat1,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(1145), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1149), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1143), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1147), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1139), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37103] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 1,
      anon_sym_DOT,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_LBRACK,
    ACTIONS(1137), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1141), 1,
      anon_sym_PIPE,
    ACTIONS(1151), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1153), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1155), 1,
      anon_sym_RPAREN,
    ACTIONS(1157), 1,
      anon_sym_COMMA,
    STATE(397), 1,
      sym_argument_list,
    STATE(1145), 1,
      aux_sym_argument_list_repeat1,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(1145), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1149), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1143), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1147), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1139), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37169] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(687), 1,
      anon_sym_COLON_EQ,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_LBRACK,
    ACTIONS(1018), 1,
      anon_sym_COMMA,
    ACTIONS(1159), 1,
      anon_sym_DOT,
    ACTIONS(1163), 1,
      anon_sym_LBRACE,
    ACTIONS(1165), 1,
      anon_sym_PIPE,
    ACTIONS(1175), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1177), 1,
      anon_sym_PIPE_PIPE,
    STATE(397), 1,
      sym_argument_list,
    STATE(979), 1,
      aux_sym_expression_list_repeat1,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(1169), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1173), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1167), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1171), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1161), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37235] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_DOT,
    ACTIONS(831), 1,
      anon_sym_LPAREN,
    ACTIONS(834), 1,
      anon_sym_LBRACK,
    STATE(398), 1,
      sym_literal_value,
    STATE(854), 1,
      sym_type_arguments,
    ACTIONS(583), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 17,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [37283] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1179), 1,
      anon_sym_LPAREN,
    STATE(538), 1,
      sym_special_argument_list,
    ACTIONS(583), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 19,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [37323] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 1,
      anon_sym_DOT,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_LBRACK,
    ACTIONS(1137), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1141), 1,
      anon_sym_PIPE,
    ACTIONS(1151), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1153), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1181), 1,
      anon_sym_RPAREN,
    ACTIONS(1183), 1,
      anon_sym_COMMA,
    STATE(397), 1,
      sym_argument_list,
    STATE(1204), 1,
      aux_sym_argument_list_repeat1,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(1145), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1149), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1143), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1147), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1139), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37389] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(572), 1,
      anon_sym_func,
    ACTIONS(585), 1,
      anon_sym_map,
    ACTIONS(587), 1,
      anon_sym_chan,
    ACTIONS(589), 1,
      anon_sym_LT_DASH,
    ACTIONS(974), 1,
      anon_sym_LBRACK,
    ACTIONS(976), 1,
      anon_sym_STAR,
    ACTIONS(1042), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      sym_identifier,
    ACTIONS(1103), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_RPAREN,
    STATE(848), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1273), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1304), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [37455] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(572), 1,
      anon_sym_func,
    ACTIONS(585), 1,
      anon_sym_map,
    ACTIONS(587), 1,
      anon_sym_chan,
    ACTIONS(589), 1,
      anon_sym_LT_DASH,
    ACTIONS(974), 1,
      anon_sym_LBRACK,
    ACTIONS(976), 1,
      anon_sym_STAR,
    ACTIONS(1042), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      sym_identifier,
    ACTIONS(1103), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1187), 1,
      anon_sym_RPAREN,
    STATE(848), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1273), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1304), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [37521] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(572), 1,
      anon_sym_func,
    ACTIONS(585), 1,
      anon_sym_map,
    ACTIONS(587), 1,
      anon_sym_chan,
    ACTIONS(589), 1,
      anon_sym_LT_DASH,
    ACTIONS(974), 1,
      anon_sym_LBRACK,
    ACTIONS(976), 1,
      anon_sym_STAR,
    ACTIONS(1042), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      sym_identifier,
    ACTIONS(1103), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1189), 1,
      anon_sym_RPAREN,
    STATE(848), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1273), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1304), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [37587] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(563), 1,
      anon_sym_DOT,
    ACTIONS(594), 1,
      anon_sym_PIPE,
    ACTIONS(834), 1,
      anon_sym_LBRACK,
    ACTIONS(1044), 1,
      anon_sym_COMMA,
    STATE(398), 1,
      sym_literal_value,
    STATE(854), 1,
      sym_type_arguments,
    ACTIONS(831), 2,
      anon_sym_LPAREN,
      anon_sym_RBRACK,
    ACTIONS(583), 4,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 15,
      anon_sym_STAR,
      anon_sym_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [37639] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 1,
      anon_sym_DOT,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_LBRACK,
    ACTIONS(1137), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1141), 1,
      anon_sym_PIPE,
    ACTIONS(1151), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1153), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1191), 1,
      anon_sym_RPAREN,
    ACTIONS(1193), 1,
      anon_sym_COMMA,
    STATE(397), 1,
      sym_argument_list,
    STATE(1168), 1,
      aux_sym_argument_list_repeat1,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(1145), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1149), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1143), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1147), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1139), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37705] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_LBRACK,
    ACTIONS(978), 1,
      anon_sym_DOT,
    ACTIONS(984), 1,
      anon_sym_PIPE,
    ACTIONS(992), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1018), 1,
      anon_sym_COMMA,
    ACTIONS(1109), 1,
      anon_sym_PIPE_PIPE,
    STATE(397), 1,
      sym_argument_list,
    STATE(979), 1,
      aux_sym_expression_list_repeat1,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(687), 2,
      anon_sym_SEMI,
      anon_sym_COLON,
    ACTIONS(982), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(990), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(986), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(988), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(980), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37769] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(572), 1,
      anon_sym_func,
    ACTIONS(585), 1,
      anon_sym_map,
    ACTIONS(587), 1,
      anon_sym_chan,
    ACTIONS(589), 1,
      anon_sym_LT_DASH,
    ACTIONS(974), 1,
      anon_sym_LBRACK,
    ACTIONS(976), 1,
      anon_sym_STAR,
    ACTIONS(1042), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      sym_identifier,
    ACTIONS(1103), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1195), 1,
      anon_sym_RPAREN,
    STATE(848), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1273), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1304), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [37835] = 17,
    ACTIONS(291), 1,
      sym_comment,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(880), 1,
      anon_sym_struct,
    ACTIONS(882), 1,
      anon_sym_TILDE,
    ACTIONS(884), 1,
      anon_sym_interface,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(904), 1,
      anon_sym_func,
    ACTIONS(908), 1,
      anon_sym_STAR,
    ACTIONS(910), 1,
      anon_sym_map,
    ACTIONS(912), 1,
      anon_sym_chan,
    ACTIONS(914), 1,
      anon_sym_LT_DASH,
    ACTIONS(920), 1,
      anon_sym_LBRACK,
    ACTIONS(1197), 1,
      anon_sym_LF,
    STATE(799), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1130), 2,
      sym_parameter_list,
      sym__simple_type,
    ACTIONS(1199), 3,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_RBRACE,
    STATE(807), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [37899] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 1,
      anon_sym_DOT,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_LBRACK,
    ACTIONS(1137), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1141), 1,
      anon_sym_PIPE,
    ACTIONS(1151), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1153), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1201), 1,
      anon_sym_RPAREN,
    ACTIONS(1203), 1,
      anon_sym_COMMA,
    STATE(397), 1,
      sym_argument_list,
    STATE(1146), 1,
      aux_sym_argument_list_repeat1,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(1145), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1149), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1143), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1147), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1139), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37965] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(572), 1,
      anon_sym_func,
    ACTIONS(585), 1,
      anon_sym_map,
    ACTIONS(587), 1,
      anon_sym_chan,
    ACTIONS(589), 1,
      anon_sym_LT_DASH,
    ACTIONS(974), 1,
      anon_sym_LBRACK,
    ACTIONS(976), 1,
      anon_sym_STAR,
    ACTIONS(1042), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      sym_identifier,
    ACTIONS(1103), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1205), 1,
      anon_sym_RPAREN,
    STATE(848), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1273), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1304), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [38031] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 1,
      anon_sym_DOT,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_LBRACK,
    ACTIONS(1137), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1141), 1,
      anon_sym_PIPE,
    ACTIONS(1151), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1153), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1207), 1,
      anon_sym_RPAREN,
    ACTIONS(1209), 1,
      anon_sym_COMMA,
    STATE(397), 1,
      sym_argument_list,
    STATE(1218), 1,
      aux_sym_argument_list_repeat1,
    STATE(1255), 1,
      sym_type_arguments,
    ACTIONS(1145), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1149), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1143), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1147), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1139), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [38097] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(793), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38132] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(657), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(655), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38167] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(880), 1,
      anon_sym_struct,
    ACTIONS(884), 1,
      anon_sym_interface,
    ACTIONS(904), 1,
      anon_sym_func,
    ACTIONS(910), 1,
      anon_sym_map,
    ACTIONS(912), 1,
      anon_sym_chan,
    ACTIONS(1211), 1,
      sym_identifier,
    ACTIONS(1213), 1,
      anon_sym_LPAREN,
    ACTIONS(1215), 1,
      anon_sym_LBRACK,
    ACTIONS(1217), 1,
      anon_sym_STAR,
    ACTIONS(1219), 1,
      anon_sym_TILDE,
    ACTIONS(1221), 1,
      anon_sym_RBRACE,
    ACTIONS(1223), 1,
      anon_sym_LT_DASH,
    STATE(799), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1007), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1074), 2,
      sym_method_elem,
      sym_type_elem,
    STATE(807), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [38230] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(880), 1,
      anon_sym_struct,
    ACTIONS(884), 1,
      anon_sym_interface,
    ACTIONS(904), 1,
      anon_sym_func,
    ACTIONS(910), 1,
      anon_sym_map,
    ACTIONS(912), 1,
      anon_sym_chan,
    ACTIONS(1211), 1,
      sym_identifier,
    ACTIONS(1213), 1,
      anon_sym_LPAREN,
    ACTIONS(1215), 1,
      anon_sym_LBRACK,
    ACTIONS(1217), 1,
      anon_sym_STAR,
    ACTIONS(1219), 1,
      anon_sym_TILDE,
    ACTIONS(1223), 1,
      anon_sym_LT_DASH,
    ACTIONS(1225), 1,
      anon_sym_RBRACE,
    STATE(799), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1007), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1074), 2,
      sym_method_elem,
      sym_type_elem,
    STATE(807), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [38293] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(570), 1,
      anon_sym_COMMA,
    ACTIONS(880), 1,
      anon_sym_struct,
    ACTIONS(884), 1,
      anon_sym_interface,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(904), 1,
      anon_sym_func,
    ACTIONS(910), 1,
      anon_sym_map,
    ACTIONS(912), 1,
      anon_sym_chan,
    ACTIONS(1213), 1,
      anon_sym_LPAREN,
    ACTIONS(1215), 1,
      anon_sym_LBRACK,
    ACTIONS(1217), 1,
      anon_sym_STAR,
    ACTIONS(1219), 1,
      anon_sym_TILDE,
    ACTIONS(1223), 1,
      anon_sym_LT_DASH,
    ACTIONS(1227), 1,
      anon_sym_EQ,
    STATE(536), 1,
      aux_sym_var_spec_repeat1,
    STATE(799), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(900), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(807), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [38358] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(561), 1,
      sym_identifier,
    ACTIONS(570), 1,
      anon_sym_COMMA,
    ACTIONS(572), 1,
      anon_sym_func,
    ACTIONS(585), 1,
      anon_sym_map,
    ACTIONS(587), 1,
      anon_sym_chan,
    ACTIONS(589), 1,
      anon_sym_LT_DASH,
    ACTIONS(974), 1,
      anon_sym_LBRACK,
    ACTIONS(976), 1,
      anon_sym_STAR,
    ACTIONS(1042), 1,
      anon_sym_LPAREN,
    STATE(794), 1,
      aux_sym_var_spec_repeat1,
    STATE(1289), 1,
      sym_type_elem,
    STATE(848), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(1117), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(858), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [38423] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38458] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(563), 1,
      anon_sym_DOT,
    ACTIONS(831), 1,
      anon_sym_LPAREN,
    ACTIONS(834), 1,
      anon_sym_LBRACK,
    STATE(398), 1,
      sym_literal_value,
    STATE(854), 1,
      sym_type_arguments,
    ACTIONS(583), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 17,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38503] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(570), 1,
      anon_sym_COMMA,
    ACTIONS(880), 1,
      anon_sym_struct,
    ACTIONS(884), 1,
      anon_sym_interface,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(904), 1,
      anon_sym_func,
    ACTIONS(910), 1,
      anon_sym_map,
    ACTIONS(912), 1,
      anon_sym_chan,
    ACTIONS(1213), 1,
      anon_sym_LPAREN,
    ACTIONS(1215), 1,
      anon_sym_LBRACK,
    ACTIONS(1217), 1,
      anon_sym_STAR,
    ACTIONS(1219), 1,
      anon_sym_TILDE,
    ACTIONS(1223), 1,
      anon_sym_LT_DASH,
    ACTIONS(1229), 1,
      anon_sym_EQ,
    STATE(794), 1,
      aux_sym_var_spec_repeat1,
    STATE(896), 1,
      sym__simple_type,
    STATE(911), 1,
      sym_parenthesized_type,
    STATE(799), 2,
      sym_negated_type,
      sym_qualified_type,
    STATE(807), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [38570] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(653), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(651), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38605] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(733), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38640] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(667), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(665), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38675] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(880), 1,
      anon_sym_struct,
    ACTIONS(884), 1,
      anon_sym_interface,
    ACTIONS(904), 1,
      anon_sym_func,
    ACTIONS(910), 1,
      anon_sym_map,
    ACTION