#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 9725
#define LARGE_STATE_COUNT 2578
#define SYMBOL_COUNT 522
#define ALIAS_COUNT 5
#define TOKEN_COUNT 213
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 50
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 214

enum ts_symbol_identifiers {
  sym_identifier = 1,
  aux_sym_preproc_include_token1 = 2,
  aux_sym_preproc_include_token2 = 3,
  aux_sym_preproc_def_token1 = 4,
  anon_sym_LPAREN = 5,
  anon_sym_DOT_DOT_DOT = 6,
  anon_sym_COMMA = 7,
  anon_sym_RPAREN = 8,
  aux_sym_preproc_if_token1 = 9,
  anon_sym_LF = 10,
  aux_sym_preproc_if_token2 = 11,
  aux_sym_preproc_ifdef_token1 = 12,
  aux_sym_preproc_ifdef_token2 = 13,
  aux_sym_preproc_else_token1 = 14,
  aux_sym_preproc_elif_token1 = 15,
  aux_sym_preproc_elifdef_token1 = 16,
  aux_sym_preproc_elifdef_token2 = 17,
  sym_preproc_arg = 18,
  sym_preproc_directive = 19,
  anon_sym_LPAREN2 = 20,
  anon_sym_defined = 21,
  anon_sym_BANG = 22,
  anon_sym_TILDE = 23,
  anon_sym_DASH = 24,
  anon_sym_PLUS = 25,
  anon_sym_STAR = 26,
  anon_sym_SLASH = 27,
  anon_sym_PERCENT = 28,
  anon_sym_PIPE_PIPE = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE = 31,
  anon_sym_CARET = 32,
  anon_sym_AMP = 33,
  anon_sym_EQ_EQ = 34,
  anon_sym_BANG_EQ = 35,
  anon_sym_GT = 36,
  anon_sym_GT_EQ = 37,
  anon_sym_LT_EQ = 38,
  anon_sym_LT = 39,
  anon_sym_LT_LT = 40,
  anon_sym_GT_GT = 41,
  anon_sym_SEMI = 42,
  anon_sym___extension__ = 43,
  anon_sym_typedef = 44,
  anon_sym_extern = 45,
  anon_sym___attribute__ = 46,
  anon_sym_COLON_COLON = 47,
  anon_sym_LBRACK_LBRACK = 48,
  anon_sym_RBRACK_RBRACK = 49,
  anon_sym___declspec = 50,
  anon_sym___based = 51,
  anon_sym___cdecl = 52,
  anon_sym___clrcall = 53,
  anon_sym___stdcall = 54,
  anon_sym___fastcall = 55,
  anon_sym___thiscall = 56,
  anon_sym___vectorcall = 57,
  sym_ms_restrict_modifier = 58,
  sym_ms_unsigned_ptr_modifier = 59,
  sym_ms_signed_ptr_modifier = 60,
  anon_sym__unaligned = 61,
  anon_sym___unaligned = 62,
  anon_sym_LBRACE = 63,
  anon_sym_RBRACE = 64,
  anon_sym_signed = 65,
  anon_sym_unsigned = 66,
  anon_sym_long = 67,
  anon_sym_short = 68,
  anon_sym_LBRACK = 69,
  anon_sym_RBRACK = 70,
  anon_sym_EQ = 71,
  anon_sym_static = 72,
  anon_sym_register = 73,
  anon_sym_inline = 74,
  anon_sym___inline = 75,
  anon_sym___inline__ = 76,
  anon_sym___forceinline = 77,
  anon_sym_thread_local = 78,
  anon_sym___thread = 79,
  anon_sym_const = 80,
  anon_sym_constexpr = 81,
  anon_sym_volatile = 82,
  anon_sym_restrict = 83,
  anon_sym___restrict__ = 84,
  anon_sym__Atomic = 85,
  anon_sym__Noreturn = 86,
  anon_sym_noreturn = 87,
  anon_sym_mutable = 88,
  anon_sym_constinit = 89,
  anon_sym_consteval = 90,
  sym_primitive_type = 91,
  anon_sym_enum = 92,
  anon_sym_class = 93,
  anon_sym_struct = 94,
  anon_sym_union = 95,
  anon_sym_COLON = 96,
  anon_sym_if = 97,
  anon_sym_else = 98,
  anon_sym_switch = 99,
  anon_sym_case = 100,
  anon_sym_default = 101,
  anon_sym_while = 102,
  anon_sym_do = 103,
  anon_sym_for = 104,
  anon_sym_return = 105,
  anon_sym_break = 106,
  anon_sym_continue = 107,
  anon_sym_goto = 108,
  anon_sym___try = 109,
  anon_sym___except = 110,
  anon_sym___finally = 111,
  anon_sym___leave = 112,
  anon_sym_QMARK = 113,
  anon_sym_STAR_EQ = 114,
  anon_sym_SLASH_EQ = 115,
  anon_sym_PERCENT_EQ = 116,
  anon_sym_PLUS_EQ = 117,
  anon_sym_DASH_EQ = 118,
  anon_sym_LT_LT_EQ = 119,
  anon_sym_GT_GT_EQ = 120,
  anon_sym_AMP_EQ = 121,
  anon_sym_CARET_EQ = 122,
  anon_sym_PIPE_EQ = 123,
  anon_sym_and_eq = 124,
  anon_sym_or_eq = 125,
  anon_sym_xor_eq = 126,
  anon_sym_not = 127,
  anon_sym_compl = 128,
  anon_sym_LT_EQ_GT = 129,
  anon_sym_or = 130,
  anon_sym_and = 131,
  anon_sym_bitor = 132,
  anon_sym_xor = 133,
  anon_sym_bitand = 134,
  anon_sym_not_eq = 135,
  anon_sym_DASH_DASH = 136,
  anon_sym_PLUS_PLUS = 137,
  anon_sym_sizeof = 138,
  anon_sym___alignof__ = 139,
  anon_sym___alignof = 140,
  anon_sym__alignof = 141,
  anon_sym_alignof = 142,
  anon_sym__Alignof = 143,
  anon_sym_offsetof = 144,
  anon_sym__Generic = 145,
  anon_sym_asm = 146,
  anon_sym___asm__ = 147,
  anon_sym_DOT = 148,
  anon_sym_DOT_STAR = 149,
  anon_sym_DASH_GT = 150,
  sym_number_literal = 151,
  anon_sym_L_SQUOTE = 152,
  anon_sym_u_SQUOTE = 153,
  anon_sym_U_SQUOTE = 154,
  anon_sym_u8_SQUOTE = 155,
  anon_sym_SQUOTE = 156,
  aux_sym_char_literal_token1 = 157,
  anon_sym_L_DQUOTE = 158,
  anon_sym_u_DQUOTE = 159,
  anon_sym_U_DQUOTE = 160,
  anon_sym_u8_DQUOTE = 161,
  anon_sym_DQUOTE = 162,
  aux_sym_string_literal_token1 = 163,
  sym_escape_sequence = 164,
  sym_system_lib_string = 165,
  sym_true = 166,
  sym_false = 167,
  anon_sym_NULL = 168,
  anon_sym_nullptr = 169,
  sym_comment = 170,
  sym_auto = 171,
  anon_sym_decltype = 172,
  anon_sym_final = 173,
  anon_sym_override = 174,
  anon_sym_virtual = 175,
  anon_sym_alignas = 176,
  anon_sym_explicit = 177,
  anon_sym_typename = 178,
  anon_sym_template = 179,
  anon_sym_GT2 = 180,
  anon_sym_operator = 181,
  anon_sym_try = 182,
  anon_sym_delete = 183,
  anon_sym_friend = 184,
  anon_sym_public = 185,
  anon_sym_private = 186,
  anon_sym_protected = 187,
  anon_sym_noexcept = 188,
  anon_sym_throw = 189,
  anon_sym_namespace = 190,
  anon_sym_using = 191,
  anon_sym_static_assert = 192,
  anon_sym_concept = 193,
  anon_sym_co_return = 194,
  anon_sym_co_yield = 195,
  anon_sym_catch = 196,
  anon_sym_R_DQUOTE = 197,
  anon_sym_LR_DQUOTE = 198,
  anon_sym_uR_DQUOTE = 199,
  anon_sym_UR_DQUOTE = 200,
  anon_sym_u8R_DQUOTE = 201,
  anon_sym_co_await = 202,
  anon_sym_new = 203,
  anon_sym_requires = 204,
  anon_sym_DASH_GT_STAR = 205,
  anon_sym_LPAREN_RPAREN = 206,
  anon_sym_LBRACK_RBRACK = 207,
  anon_sym_DQUOTE_DQUOTE = 208,
  sym_this = 209,
  sym_literal_suffix = 210,
  sym_raw_string_delimiter = 211,
  sym_raw_string_content = 212,
  sym_translation_unit = 213,
  sym_preproc_include = 214,
  sym_preproc_def = 215,
  sym_preproc_function_def = 216,
  sym_preproc_params = 217,
  sym_preproc_call = 218,
  sym_preproc_if = 219,
  sym_preproc_ifdef = 220,
  sym_preproc_else = 221,
  sym_preproc_elif = 222,
  sym_preproc_elifdef = 223,
  sym_preproc_if_in_field_declaration_list = 224,
  sym_preproc_ifdef_in_field_declaration_list = 225,
  sym_preproc_else_in_field_declaration_list = 226,
  sym_preproc_elif_in_field_declaration_list = 227,
  sym_preproc_elifdef_in_field_declaration_list = 228,
  sym_preproc_if_in_enumerator_list = 229,
  sym_preproc_ifdef_in_enumerator_list = 230,
  sym_preproc_else_in_enumerator_list = 231,
  sym_preproc_elif_in_enumerator_list = 232,
  sym_preproc_elifdef_in_enumerator_list = 233,
  sym_preproc_if_in_enumerator_list_no_comma = 234,
  sym_preproc_ifdef_in_enumerator_list_no_comma = 235,
  sym_preproc_else_in_enumerator_list_no_comma = 236,
  sym_preproc_elif_in_enumerator_list_no_comma = 237,
  sym_preproc_elifdef_in_enumerator_list_no_comma = 238,
  sym__preproc_expression = 239,
  sym_preproc_parenthesized_expression = 240,
  sym_preproc_defined = 241,
  sym_preproc_unary_expression = 242,
  sym_preproc_call_expression = 243,
  sym_preproc_argument_list = 244,
  sym_preproc_binary_expression = 245,
  sym_function_definition = 246,
  sym_declaration = 247,
  sym_type_definition = 248,
  sym__type_definition_type = 249,
  sym__type_definition_declarators = 250,
  sym__declaration_modifiers = 251,
  sym__declaration_specifiers = 252,
  sym_linkage_specification = 253,
  sym_attribute_specifier = 254,
  sym_attribute = 255,
  sym_attribute_declaration = 256,
  sym_ms_declspec_modifier = 257,
  sym_ms_based_modifier = 258,
  sym_ms_call_modifier = 259,
  sym_ms_unaligned_ptr_modifier = 260,
  sym_ms_pointer_modifier = 261,
  sym_declaration_list = 262,
  sym__declarator = 263,
  sym__field_declarator = 264,
  sym__type_declarator = 265,
  sym__abstract_declarator = 266,
  sym_parenthesized_declarator = 267,
  sym_parenthesized_field_declarator = 268,
  sym_parenthesized_type_declarator = 269,
  sym_abstract_parenthesized_declarator = 270,
  sym_attributed_declarator = 271,
  sym_attributed_field_declarator = 272,
  sym_attributed_type_declarator = 273,
  sym_pointer_declarator = 274,
  sym_pointer_field_declarator = 275,
  sym_pointer_type_declarator = 276,
  sym_abstract_pointer_declarator = 277,
  sym_function_declarator = 278,
  sym_function_field_declarator = 279,
  sym_function_type_declarator = 280,
  sym_abstract_function_declarator = 281,
  sym_array_declarator = 282,
  sym_array_field_declarator = 283,
  sym_array_type_declarator = 284,
  sym_abstract_array_declarator = 285,
  sym_init_declarator = 286,
  sym_compound_statement = 287,
  sym_storage_class_specifier = 288,
  sym_type_qualifier = 289,
  sym__type_specifier = 290,
  sym_sized_type_specifier = 291,
  sym_enum_specifier = 292,
  sym_enumerator_list = 293,
  sym_struct_specifier = 294,
  sym_union_specifier = 295,
  sym_field_declaration_list = 296,
  sym__field_declaration_list_item = 297,
  sym_field_declaration = 298,
  sym_bitfield_clause = 299,
  sym_enumerator = 300,
  sym_parameter_list = 301,
  sym_parameter_declaration = 302,
  sym_attributed_statement = 303,
  sym_labeled_statement = 304,
  sym__top_level_expression_statement = 305,
  sym_expression_statement = 306,
  sym_if_statement = 307,
  sym_else_clause = 308,
  sym_switch_statement = 309,
  sym_case_statement = 310,
  sym_while_statement = 311,
  sym_do_statement = 312,
  sym_for_statement = 313,
  sym__for_statement_body = 314,
  sym_return_statement = 315,
  sym_break_statement = 316,
  sym_continue_statement = 317,
  sym_goto_statement = 318,
  sym_seh_try_statement = 319,
  sym_seh_except_clause = 320,
  sym_seh_finally_clause = 321,
  sym_seh_leave_statement = 322,
  sym__expression = 323,
  sym__expression_not_binary = 324,
  sym__string = 325,
  sym_comma_expression = 326,
  sym_conditional_expression = 327,
  sym_assignment_expression = 328,
  sym_pointer_expression = 329,
  sym_unary_expression = 330,
  sym_binary_expression = 331,
  sym_update_expression = 332,
  sym_cast_expression = 333,
  sym_type_descriptor = 334,
  sym_sizeof_expression = 335,
  sym_alignof_expression = 336,
  sym_offsetof_expression = 337,
  sym_generic_expression = 338,
  sym_subscript_expression = 339,
  sym_call_expression = 340,
  sym_gnu_asm_expression = 341,
  sym_gnu_asm_qualifier = 342,
  sym_gnu_asm_output_operand_list = 343,
  sym_gnu_asm_output_operand = 344,
  sym_gnu_asm_input_operand_list = 345,
  sym_gnu_asm_input_operand = 346,
  sym_gnu_asm_clobber_list = 347,
  sym_gnu_asm_goto_list = 348,
  sym_argument_list = 349,
  sym_field_expression = 350,
  sym_compound_literal_expression = 351,
  sym_parenthesized_expression = 352,
  sym_initializer_list = 353,
  sym_initializer_pair = 354,
  sym_subscript_designator = 355,
  sym_subscript_range_designator = 356,
  sym_field_designator = 357,
  sym_char_literal = 358,
  sym_concatenated_string = 359,
  sym_string_literal = 360,
  sym_null = 361,
  sym__empty_declaration = 362,
  sym_placeholder_type_specifier = 363,
  sym_decltype_auto = 364,
  sym_decltype = 365,
  sym__class_declaration = 366,
  sym__class_declaration_item = 367,
  sym_class_specifier = 368,
  sym__class_name = 369,
  sym_virtual_specifier = 370,
  sym_virtual = 371,
  sym_alignas_specifier = 372,
  sym_explicit_function_specifier = 373,
  sym_base_class_clause = 374,
  sym__enum_base_clause = 375,
  sym_dependent_type = 376,
  sym_template_declaration = 377,
  sym_template_instantiation = 378,
  sym_template_parameter_list = 379,
  sym_type_parameter_declaration = 380,
  sym_variadic_type_parameter_declaration = 381,
  sym_optional_type_parameter_declaration = 382,
  sym_template_template_parameter_declaration = 383,
  sym_optional_parameter_declaration = 384,
  sym_variadic_parameter_declaration = 385,
  sym_variadic_declarator = 386,
  sym_variadic_reference_declarator = 387,
  sym_operator_cast = 388,
  sym_field_initializer_list = 389,
  sym_field_initializer = 390,
  sym_inline_method_definition = 391,
  sym__constructor_specifiers = 392,
  sym_operator_cast_definition = 393,
  sym_operator_cast_declaration = 394,
  sym_constructor_try_statement = 395,
  sym_constructor_or_destructor_definition = 396,
  sym_constructor_or_destructor_declaration = 397,
  sym_default_method_clause = 398,
  sym_delete_method_clause = 399,
  sym_friend_declaration = 400,
  sym_access_specifier = 401,
  sym_reference_declarator = 402,
  sym_reference_field_declarator = 403,
  sym_abstract_reference_declarator = 404,
  sym_structured_binding_declarator = 405,
  sym_ref_qualifier = 406,
  sym__function_declarator_seq = 407,
  sym__function_attributes_start = 408,
  sym__function_exception_specification = 409,
  sym__function_attributes_end = 410,
  sym__function_postfix = 411,
  sym_trailing_return_type = 412,
  sym_noexcept = 413,
  sym_throw_specifier = 414,
  sym_template_type = 415,
  sym_template_method = 416,
  sym_template_function = 417,
  sym_template_argument_list = 418,
  sym_namespace_definition = 419,
  sym_namespace_alias_definition = 420,
  sym__namespace_specifier = 421,
  sym_nested_namespace_specifier = 422,
  sym_using_declaration = 423,
  sym_alias_declaration = 424,
  sym_static_assert_declaration = 425,
  sym_concept_definition = 426,
  sym_for_range_loop = 427,
  sym__for_range_loop_body = 428,
  sym_init_statement = 429,
  sym_condition_clause = 430,
  sym_condition_declaration = 431,
  sym_co_return_statement = 432,
  sym_co_yield_statement = 433,
  sym_throw_statement = 434,
  sym_try_statement = 435,
  sym_catch_clause = 436,
  sym_raw_string_literal = 437,
  sym_subscript_argument_list = 438,
  sym_co_await_expression = 439,
  sym_new_expression = 440,
  sym_new_declarator = 441,
  sym_delete_expression = 442,
  sym_type_requirement = 443,
  sym_compound_requirement = 444,
  sym__requirement = 445,
  sym_requirement_seq = 446,
  sym_constraint_conjunction = 447,
  sym_constraint_disjunction = 448,
  sym__requirement_clause_constraint = 449,
  sym_requires_clause = 450,
  sym_requires_parameter_list = 451,
  sym_requires_expression = 452,
  sym_lambda_expression = 453,
  sym_lambda_capture_specifier = 454,
  sym_lambda_default_capture = 455,
  sym__fold_operator = 456,
  sym__binary_fold_operator = 457,
  sym__unary_left_fold = 458,
  sym__unary_right_fold = 459,
  sym__binary_fold = 460,
  sym_fold_expression = 461,
  sym_parameter_pack_expansion = 462,
  sym_type_parameter_pack_expansion = 463,
  sym_destructor_name = 464,
  sym_dependent_identifier = 465,
  sym_dependent_field_identifier = 466,
  sym_dependent_type_identifier = 467,
  sym__scope_resolution = 468,
  sym_qualified_field_identifier = 469,
  sym_qualified_identifier = 470,
  sym_qualified_type_identifier = 471,
  sym_qualified_operator_cast_identifier = 472,
  sym__assignment_expression_lhs = 473,
  sym_operator_name = 474,
  sym_user_defined_literal = 475,
  aux_sym_translation_unit_repeat1 = 476,
  aux_sym_preproc_params_repeat1 = 477,
  aux_sym_preproc_if_repeat1 = 478,
  aux_sym_preproc_if_in_field_declaration_list_repeat1 = 479,
  aux_sym_preproc_if_in_enumerator_list_repeat1 = 480,
  aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1 = 481,
  aux_sym_preproc_argument_list_repeat1 = 482,
  aux_sym_declaration_repeat1 = 483,
  aux_sym_type_definition_repeat1 = 484,
  aux_sym__type_definition_type_repeat1 = 485,
  aux_sym__type_definition_declarators_repeat1 = 486,
  aux_sym__declaration_specifiers_repeat1 = 487,
  aux_sym_attribute_declaration_repeat1 = 488,
  aux_sym_attributed_declarator_repeat1 = 489,
  aux_sym_pointer_declarator_repeat1 = 490,
  aux_sym_sized_type_specifier_repeat1 = 491,
  aux_sym_enumerator_list_repeat1 = 492,
  aux_sym_field_declaration_repeat1 = 493,
  aux_sym_parameter_list_repeat1 = 494,
  aux_sym_case_statement_repeat1 = 495,
  aux_sym_generic_expression_repeat1 = 496,
  aux_sym_gnu_asm_expression_repeat1 = 497,
  aux_sym_gnu_asm_output_operand_list_repeat1 = 498,
  aux_sym_gnu_asm_input_operand_list_repeat1 = 499,
  aux_sym_gnu_asm_clobber_list_repeat1 = 500,
  aux_sym_gnu_asm_goto_list_repeat1 = 501,
  aux_sym_argument_list_repeat1 = 502,
  aux_sym_initializer_list_repeat1 = 503,
  aux_sym_initializer_pair_repeat1 = 504,
  aux_sym_char_literal_repeat1 = 505,
  aux_sym_concatenated_string_repeat1 = 506,
  aux_sym_string_literal_repeat1 = 507,
  aux_sym__class_declaration_repeat1 = 508,
  aux_sym_base_class_clause_repeat1 = 509,
  aux_sym_template_parameter_list_repeat1 = 510,
  aux_sym_field_initializer_list_repeat1 = 511,
  aux_sym_operator_cast_definition_repeat1 = 512,
  aux_sym_constructor_try_statement_repeat1 = 513,
  aux_sym_structured_binding_declarator_repeat1 = 514,
  aux_sym__function_postfix_repeat1 = 515,
  aux_sym_throw_specifier_repeat1 = 516,
  aux_sym_template_argument_list_repeat1 = 517,
  aux_sym_subscript_argument_list_repeat1 = 518,
  aux_sym_requirement_seq_repeat1 = 519,
  aux_sym_requires_parameter_list_repeat1 = 520,
  aux_sym_lambda_capture_specifier_repeat1 = 521,
  alias_sym_field_identifier = 522,
  alias_sym_namespace_identifier = 523,
  alias_sym_simple_requirement = 524,
  alias_sym_statement_identifier = 525,
  alias_sym_type_identifier = 526,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [aux_sym_preproc_include_token1] = "#include",
  [aux_sym_preproc_include_token2] = "preproc_include_token2",
  [aux_sym_preproc_def_token1] = "#define",
  [anon_sym_LPAREN] = "(",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [aux_sym_preproc_if_token1] = "#if",
  [anon_sym_LF] = "\n",
  [aux_sym_preproc_if_token2] = "#endif",
  [aux_sym_preproc_ifdef_token1] = "#ifdef",
  [aux_sym_preproc_ifdef_token2] = "#ifndef",
  [aux_sym_preproc_else_token1] = "#else",
  [aux_sym_preproc_elif_token1] = "#elif",
  [aux_sym_preproc_elifdef_token1] = "#elifdef",
  [aux_sym_preproc_elifdef_token2] = "#elifndef",
  [sym_preproc_arg] = "preproc_arg",
  [sym_preproc_directive] = "preproc_directive",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_defined] = "defined",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_SEMI] = ";",
  [anon_sym___extension__] = "__extension__",
  [anon_sym_typedef] = "typedef",
  [anon_sym_extern] = "extern",
  [anon_sym___attribute__] = "__attribute__",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym___declspec] = "__declspec",
  [anon_sym___based] = "__based",
  [anon_sym___cdecl] = "__cdecl",
  [anon_sym___clrcall] = "__clrcall",
  [anon_sym___stdcall] = "__stdcall",
  [anon_sym___fastcall] = "__fastcall",
  [anon_sym___thiscall] = "__thiscall",
  [anon_sym___vectorcall] = "__vectorcall",
  [sym_ms_restrict_modifier] = "ms_restrict_modifier",
  [sym_ms_unsigned_ptr_modifier] = "ms_unsigned_ptr_modifier",
  [sym_ms_signed_ptr_modifier] = "ms_signed_ptr_modifier",
  [anon_sym__unaligned] = "_unaligned",
  [anon_sym___unaligned] = "__unaligned",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_signed] = "signed",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_long] = "long",
  [anon_sym_short] = "short",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_EQ] = "=",
  [anon_sym_static] = "static",
  [anon_sym_register] = "register",
  [anon_sym_inline] = "inline",
  [anon_sym___inline] = "__inline",
  [anon_sym___inline__] = "__inline__",
  [anon_sym___forceinline] = "__forceinline",
  [anon_sym_thread_local] = "thread_local",
  [anon_sym___thread] = "__thread",
  [anon_sym_const] = "const",
  [anon_sym_constexpr] = "constexpr",
  [anon_sym_volatile] = "volatile",
  [anon_sym_restrict] = "restrict",
  [anon_sym___restrict__] = "__restrict__",
  [anon_sym__Atomic] = "_Atomic",
  [anon_sym__Noreturn] = "_Noreturn",
  [anon_sym_noreturn] = "noreturn",
  [anon_sym_mutable] = "mutable",
  [anon_sym_constinit] = "constinit",
  [anon_sym_consteval] = "consteval",
  [sym_primitive_type] = "primitive_type",
  [anon_sym_enum] = "enum",
  [anon_sym_class] = "class",
  [anon_sym_struct] = "struct",
  [anon_sym_union] = "union",
  [anon_sym_COLON] = ":",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_for] = "for",
  [anon_sym_return] = "return",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_goto] = "goto",
  [anon_sym___try] = "__try",
  [anon_sym___except] = "__except",
  [anon_sym___finally] = "__finally",
  [anon_sym___leave] = "__leave",
  [anon_sym_QMARK] = "\?",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_and_eq] = "and_eq",
  [anon_sym_or_eq] = "or_eq",
  [anon_sym_xor_eq] = "xor_eq",
  [anon_sym_not] = "not",
  [anon_sym_compl] = "compl",
  [anon_sym_LT_EQ_GT] = "<=>",
  [anon_sym_or] = "or",
  [anon_sym_and] = "and",
  [anon_sym_bitor] = "bitor",
  [anon_sym_xor] = "xor",
  [anon_sym_bitand] = "bitand",
  [anon_sym_not_eq] = "not_eq",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_sizeof] = "sizeof",
  [anon_sym___alignof__] = "__alignof__",
  [anon_sym___alignof] = "__alignof",
  [anon_sym__alignof] = "_alignof",
  [anon_sym_alignof] = "alignof",
  [anon_sym__Alignof] = "_Alignof",
  [anon_sym_offsetof] = "offsetof",
  [anon_sym__Generic] = "_Generic",
  [anon_sym_asm] = "asm",
  [anon_sym___asm__] = "__asm__",
  [anon_sym_DOT] = ".",
  [anon_sym_DOT_STAR] = ".*",
  [anon_sym_DASH_GT] = "->",
  [sym_number_literal] = "number_literal",
  [anon_sym_L_SQUOTE] = "L'",
  [anon_sym_u_SQUOTE] = "u'",
  [anon_sym_U_SQUOTE] = "U'",
  [anon_sym_u8_SQUOTE] = "u8'",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_char_literal_token1] = "character",
  [anon_sym_L_DQUOTE] = "L\"",
  [anon_sym_u_DQUOTE] = "u\"",
  [anon_sym_U_DQUOTE] = "U\"",
  [anon_sym_u8_DQUOTE] = "u8\"",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_literal_token1] = "string_content",
  [sym_escape_sequence] = "escape_sequence",
  [sym_system_lib_string] = "system_lib_string",
  [sym_true] = "true",
  [sym_false] = "false",
  [anon_sym_NULL] = "NULL",
  [anon_sym_nullptr] = "nullptr",
  [sym_comment] = "comment",
  [sym_auto] = "auto",
  [anon_sym_decltype] = "decltype",
  [anon_sym_final] = "final",
  [anon_sym_override] = "override",
  [anon_sym_virtual] = "virtual",
  [anon_sym_alignas] = "alignas",
  [anon_sym_explicit] = "explicit",
  [anon_sym_typename] = "typename",
  [anon_sym_template] = "template",
  [anon_sym_GT2] = ">",
  [anon_sym_operator] = "operator",
  [anon_sym_try] = "try",
  [anon_sym_delete] = "delete",
  [anon_sym_friend] = "friend",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_noexcept] = "noexcept",
  [anon_sym_throw] = "throw",
  [anon_sym_namespace] = "namespace",
  [anon_sym_using] = "using",
  [anon_sym_static_assert] = "static_assert",
  [anon_sym_concept] = "concept",
  [anon_sym_co_return] = "co_return",
  [anon_sym_co_yield] = "co_yield",
  [anon_sym_catch] = "catch",
  [anon_sym_R_DQUOTE] = "R\"",
  [anon_sym_LR_DQUOTE] = "LR\"",
  [anon_sym_uR_DQUOTE] = "uR\"",
  [anon_sym_UR_DQUOTE] = "UR\"",
  [anon_sym_u8R_DQUOTE] = "u8R\"",
  [anon_sym_co_await] = "co_await",
  [anon_sym_new] = "new",
  [anon_sym_requires] = "requires",
  [anon_sym_DASH_GT_STAR] = "->*",
  [anon_sym_LPAREN_RPAREN] = "()",
  [anon_sym_LBRACK_RBRACK] = "[]",
  [anon_sym_DQUOTE_DQUOTE] = "\"\"",
  [sym_this] = "this",
  [sym_literal_suffix] = "literal_suffix",
  [sym_raw_string_delimiter] = "raw_string_delimiter",
  [sym_raw_string_content] = "raw_string_content",
  [sym_translation_unit] = "translation_unit",
  [sym_preproc_include] = "preproc_include",
  [sym_preproc_def] = "preproc_def",
  [sym_preproc_function_def] = "preproc_function_def",
  [sym_preproc_params] = "preproc_params",
  [sym_preproc_call] = "preproc_call",
  [sym_preproc_if] = "preproc_if",
  [sym_preproc_ifdef] = "preproc_ifdef",
  [sym_preproc_else] = "preproc_else",
  [sym_preproc_elif] = "preproc_elif",
  [sym_preproc_elifdef] = "preproc_elifdef",
  [sym_preproc_if_in_field_declaration_list] = "preproc_if",
  [sym_preproc_ifdef_in_field_declaration_list] = "preproc_ifdef",
  [sym_preproc_else_in_field_declaration_list] = "preproc_else",
  [sym_preproc_elif_in_field_declaration_list] = "preproc_elif",
  [sym_preproc_elifdef_in_field_declaration_list] = "preproc_elifdef",
  [sym_preproc_if_in_enumerator_list] = "preproc_if",
  [sym_preproc_ifdef_in_enumerator_list] = "preproc_ifdef",
  [sym_preproc_else_in_enumerator_list] = "preproc_else",
  [sym_preproc_elif_in_enumerator_list] = "preproc_elif",
  [sym_preproc_elifdef_in_enumerator_list] = "preproc_elifdef",
  [sym_preproc_if_in_enumerator_list_no_comma] = "preproc_if",
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = "preproc_ifdef",
  [sym_preproc_else_in_enumerator_list_no_comma] = "preproc_else",
  [sym_preproc_elif_in_enumerator_list_no_comma] = "preproc_elif",
  [sym_preproc_elifdef_in_enumerator_list_no_comma] = "preproc_elifdef",
  [sym__preproc_expression] = "_preproc_expression",
  [sym_preproc_parenthesized_expression] = "parenthesized_expression",
  [sym_preproc_defined] = "preproc_defined",
  [sym_preproc_unary_expression] = "unary_expression",
  [sym_preproc_call_expression] = "call_expression",
  [sym_preproc_argument_list] = "argument_list",
  [sym_preproc_binary_expression] = "binary_expression",
  [sym_function_definition] = "function_definition",
  [sym_declaration] = "declaration",
  [sym_type_definition] = "type_definition",
  [sym__type_definition_type] = "_type_definition_type",
  [sym__type_definition_declarators] = "_type_definition_declarators",
  [sym__declaration_modifiers] = "_declaration_modifiers",
  [sym__declaration_specifiers] = "_declaration_specifiers",
  [sym_linkage_specification] = "linkage_specification",
  [sym_attribute_specifier] = "attribute_specifier",
  [sym_attribute] = "attribute",
  [sym_attribute_declaration] = "attribute_declaration",
  [sym_ms_declspec_modifier] = "ms_declspec_modifier",
  [sym_ms_based_modifier] = "ms_based_modifier",
  [sym_ms_call_modifier] = "ms_call_modifier",
  [sym_ms_unaligned_ptr_modifier] = "ms_unaligned_ptr_modifier",
  [sym_ms_pointer_modifier] = "ms_pointer_modifier",
  [sym_declaration_list] = "declaration_list",
  [sym__declarator] = "_declarator",
  [sym__field_declarator] = "_field_declarator",
  [sym__type_declarator] = "_type_declarator",
  [sym__abstract_declarator] = "_abstract_declarator",
  [sym_parenthesized_declarator] = "parenthesized_declarator",
  [sym_parenthesized_field_declarator] = "parenthesized_declarator",
  [sym_parenthesized_type_declarator] = "parenthesized_declarator",
  [sym_abstract_parenthesized_declarator] = "abstract_parenthesized_declarator",
  [sym_attributed_declarator] = "attributed_declarator",
  [sym_attributed_field_declarator] = "attributed_declarator",
  [sym_attributed_type_declarator] = "attributed_declarator",
  [sym_pointer_declarator] = "pointer_declarator",
  [sym_pointer_field_declarator] = "pointer_declarator",
  [sym_pointer_type_declarator] = "pointer_type_declarator",
  [sym_abstract_pointer_declarator] = "abstract_pointer_declarator",
  [sym_function_declarator] = "function_declarator",
  [sym_function_field_declarator] = "function_declarator",
  [sym_function_type_declarator] = "function_declarator",
  [sym_abstract_function_declarator] = "abstract_function_declarator",
  [sym_array_declarator] = "array_declarator",
  [sym_array_field_declarator] = "array_declarator",
  [sym_array_type_declarator] = "array_declarator",
  [sym_abstract_array_declarator] = "abstract_array_declarator",
  [sym_init_declarator] = "init_declarator",
  [sym_compound_statement] = "compound_statement",
  [sym_storage_class_specifier] = "storage_class_specifier",
  [sym_type_qualifier] = "type_qualifier",
  [sym__type_specifier] = "_type_specifier",
  [sym_sized_type_specifier] = "sized_type_specifier",
  [sym_enum_specifier] = "enum_specifier",
  [sym_enumerator_list] = "enumerator_list",
  [sym_struct_specifier] = "struct_specifier",
  [sym_union_specifier] = "union_specifier",
  [sym_field_declaration_list] = "field_declaration_list",
  [sym__field_declaration_list_item] = "_field_declaration_list_item",
  [sym_field_declaration] = "field_declaration",
  [sym_bitfield_clause] = "bitfield_clause",
  [sym_enumerator] = "enumerator",
  [sym_parameter_list] = "parameter_list",
  [sym_parameter_declaration] = "parameter_declaration",
  [sym_attributed_statement] = "attributed_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym__top_level_expression_statement] = "expression_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_if_statement] = "if_statement",
  [sym_else_clause] = "else_clause",
  [sym_switch_statement] = "switch_statement",
  [sym_case_statement] = "case_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_for_statement] = "for_statement",
  [sym__for_statement_body] = "_for_statement_body",
  [sym_return_statement] = "return_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_seh_try_statement] = "seh_try_statement",
  [sym_seh_except_clause] = "seh_except_clause",
  [sym_seh_finally_clause] = "seh_finally_clause",
  [sym_seh_leave_statement] = "seh_leave_statement",
  [sym__expression] = "_expression",
  [sym__expression_not_binary] = "_expression_not_binary",
  [sym__string] = "_string",
  [sym_comma_expression] = "comma_expression",
  [sym_conditional_expression] = "conditional_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_pointer_expression] = "pointer_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_update_expression] = "update_expression",
  [sym_cast_expression] = "cast_expression",
  [sym_type_descriptor] = "type_descriptor",
  [sym_sizeof_expression] = "sizeof_expression",
  [sym_alignof_expression] = "alignof_expression",
  [sym_offsetof_expression] = "offsetof_expression",
  [sym_generic_expression] = "generic_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_call_expression] = "call_expression",
  [sym_gnu_asm_expression] = "gnu_asm_expression",
  [sym_gnu_asm_qualifier] = "gnu_asm_qualifier",
  [sym_gnu_asm_output_operand_list] = "gnu_asm_output_operand_list",
  [sym_gnu_asm_output_operand] = "gnu_asm_output_operand",
  [sym_gnu_asm_input_operand_list] = "gnu_asm_input_operand_list",
  [sym_gnu_asm_input_operand] = "gnu_asm_input_operand",
  [sym_gnu_asm_clobber_list] = "gnu_asm_clobber_list",
  [sym_gnu_asm_goto_list] = "gnu_asm_goto_list",
  [sym_argument_list] = "argument_list",
  [sym_field_expression] = "field_expression",
  [sym_compound_literal_expression] = "compound_literal_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_initializer_list] = "initializer_list",
  [sym_initializer_pair] = "initializer_pair",
  [sym_subscript_designator] = "subscript_designator",
  [sym_subscript_range_designator] = "subscript_range_designator",
  [sym_field_designator] = "field_designator",
  [sym_char_literal] = "char_literal",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string_literal] = "string_literal",
  [sym_null] = "null",
  [sym__empty_declaration] = "_empty_declaration",
  [sym_placeholder_type_specifier] = "placeholder_type_specifier",
  [sym_decltype_auto] = "decltype",
  [sym_decltype] = "decltype",
  [sym__class_declaration] = "_class_declaration",
  [sym__class_declaration_item] = "_class_declaration_item",
  [sym_class_specifier] = "class_specifier",
  [sym__class_name] = "_class_name",
  [sym_virtual_specifier] = "virtual_specifier",
  [sym_virtual] = "virtual",
  [sym_alignas_specifier] = "alignas_specifier",
  [sym_explicit_function_specifier] = "explicit_function_specifier",
  [sym_base_class_clause] = "base_class_clause",
  [sym__enum_base_clause] = "_enum_base_clause",
  [sym_dependent_type] = "dependent_type",
  [sym_template_declaration] = "template_declaration",
  [sym_template_instantiation] = "template_instantiation",
  [sym_template_parameter_list] = "template_parameter_list",
  [sym_type_parameter_declaration] = "type_parameter_declaration",
  [sym_variadic_type_parameter_declaration] = "variadic_type_parameter_declaration",
  [sym_optional_type_parameter_declaration] = "optional_type_parameter_declaration",
  [sym_template_template_parameter_declaration] = "template_template_parameter_declaration",
  [sym_optional_parameter_declaration] = "optional_parameter_declaration",
  [sym_variadic_parameter_declaration] = "variadic_parameter_declaration",
  [sym_variadic_declarator] = "variadic_declarator",
  [sym_variadic_reference_declarator] = "reference_declarator",
  [sym_operator_cast] = "operator_cast",
  [sym_field_initializer_list] = "field_initializer_list",
  [sym_field_initializer] = "field_initializer",
  [sym_inline_method_definition] = "function_definition",
  [sym__constructor_specifiers] = "_constructor_specifiers",
  [sym_operator_cast_definition] = "function_definition",
  [sym_operator_cast_declaration] = "declaration",
  [sym_constructor_try_statement] = "try_statement",
  [sym_constructor_or_destructor_definition] = "function_definition",
  [sym_constructor_or_destructor_declaration] = "declaration",
  [sym_default_method_clause] = "default_method_clause",
  [sym_delete_method_clause] = "delete_method_clause",
  [sym_friend_declaration] = "friend_declaration",
  [sym_access_specifier] = "access_specifier",
  [sym_reference_declarator] = "reference_declarator",
  [sym_reference_field_declarator] = "reference_declarator",
  [sym_abstract_reference_declarator] = "abstract_reference_declarator",
  [sym_structured_binding_declarator] = "structured_binding_declarator",
  [sym_ref_qualifier] = "ref_qualifier",
  [sym__function_declarator_seq] = "_function_declarator_seq",
  [sym__function_attributes_start] = "_function_attributes_start",
  [sym__function_exception_specification] = "_function_exception_specification",
  [sym__function_attributes_end] = "_function_attributes_end",
  [sym__function_postfix] = "_function_postfix",
  [sym_trailing_return_type] = "trailing_return_type",
  [sym_noexcept] = "noexcept",
  [sym_throw_specifier] = "throw_specifier",
  [sym_template_type] = "template_type",
  [sym_template_method] = "template_method",
  [sym_template_function] = "template_function",
  [sym_template_argument_list] = "template_argument_list",
  [sym_namespace_definition] = "namespace_definition",
  [sym_namespace_alias_definition] = "namespace_alias_definition",
  [sym__namespace_specifier] = "_namespace_specifier",
  [sym_nested_namespace_specifier] = "nested_namespace_specifier",
  [sym_using_declaration] = "using_declaration",
  [sym_alias_declaration] = "alias_declaration",
  [sym_static_assert_declaration] = "static_assert_declaration",
  [sym_concept_definition] = "concept_definition",
  [sym_for_range_loop] = "for_range_loop",
  [sym__for_range_loop_body] = "_for_range_loop_body",
  [sym_init_statement] = "init_statement",
  [sym_condition_clause] = "condition_clause",
  [sym_condition_declaration] = "declaration",
  [sym_co_return_statement] = "co_return_statement",
  [sym_co_yield_statement] = "co_yield_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_raw_string_literal] = "raw_string_literal",
  [sym_subscript_argument_list] = "subscript_argument_list",
  [sym_co_await_expression] = "co_await_expression",
  [sym_new_expression] = "new_expression",
  [sym_new_declarator] = "new_declarator",
  [sym_delete_expression] = "delete_expression",
  [sym_type_requirement] = "type_requirement",
  [sym_compound_requirement] = "compound_requirement",
  [sym__requirement] = "_requirement",
  [sym_requirement_seq] = "requirement_seq",
  [sym_constraint_conjunction] = "constraint_conjunction",
  [sym_constraint_disjunction] = "constraint_disjunction",
  [sym__requirement_clause_constraint] = "_requirement_clause_constraint",
  [sym_requires_clause] = "requires_clause",
  [sym_requires_parameter_list] = "parameter_list",
  [sym_requires_expression] = "requires_expression",
  [sym_lambda_expression] = "lambda_expression",
  [sym_lambda_capture_specifier] = "lambda_capture_specifier",
  [sym_lambda_default_capture] = "lambda_default_capture",
  [sym__fold_operator] = "_fold_operator",
  [sym__binary_fold_operator] = "_binary_fold_operator",
  [sym__unary_left_fold] = "_unary_left_fold",
  [sym__unary_right_fold] = "_unary_right_fold",
  [sym__binary_fold] = "_binary_fold",
  [sym_fold_expression] = "fold_expression",
  [sym_parameter_pack_expansion] = "parameter_pack_expansion",
  [sym_type_parameter_pack_expansion] = "parameter_pack_expansion",
  [sym_destructor_name] = "destructor_name",
  [sym_dependent_identifier] = "dependent_name",
  [sym_dependent_field_identifier] = "dependent_name",
  [sym_dependent_type_identifier] = "dependent_name",
  [sym__scope_resolution] = "_scope_resolution",
  [sym_qualified_field_identifier] = "qualified_identifier",
  [sym_qualified_identifier] = "qualified_identifier",
  [sym_qualified_type_identifier] = "qualified_identifier",
  [sym_qualified_operator_cast_identifier] = "qualified_identifier",
  [sym__assignment_expression_lhs] = "assignment_expression",
  [sym_operator_name] = "operator_name",
  [sym_user_defined_literal] = "user_defined_literal",
  [aux_sym_translation_unit_repeat1] = "translation_unit_repeat1",
  [aux_sym_preproc_params_repeat1] = "preproc_params_repeat1",
  [aux_sym_preproc_if_repeat1] = "preproc_if_repeat1",
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = "preproc_if_in_field_declaration_list_repeat1",
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = "preproc_if_in_enumerator_list_repeat1",
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = "preproc_if_in_enumerator_list_no_comma_repeat1",
  [aux_sym_preproc_argument_list_repeat1] = "preproc_argument_list_repeat1",
  [aux_sym_declaration_repeat1] = "declaration_repeat1",
  [aux_sym_type_definition_repeat1] = "type_definition_repeat1",
  [aux_sym__type_definition_type_repeat1] = "_type_definition_type_repeat1",
  [aux_sym__type_definition_declarators_repeat1] = "_type_definition_declarators_repeat1",
  [aux_sym__declaration_specifiers_repeat1] = "_declaration_specifiers_repeat1",
  [aux_sym_attribute_declaration_repeat1] = "attribute_declaration_repeat1",
  [aux_sym_attributed_declarator_repeat1] = "attributed_declarator_repeat1",
  [aux_sym_pointer_declarator_repeat1] = "pointer_declarator_repeat1",
  [aux_sym_sized_type_specifier_repeat1] = "sized_type_specifier_repeat1",
  [aux_sym_enumerator_list_repeat1] = "enumerator_list_repeat1",
  [aux_sym_field_declaration_repeat1] = "field_declaration_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_generic_expression_repeat1] = "generic_expression_repeat1",
  [aux_sym_gnu_asm_expression_repeat1] = "gnu_asm_expression_repeat1",
  [aux_sym_gnu_asm_output_operand_list_repeat1] = "gnu_asm_output_operand_list_repeat1",
  [aux_sym_gnu_asm_input_operand_list_repeat1] = "gnu_asm_input_operand_list_repeat1",
  [aux_sym_gnu_asm_clobber_list_repeat1] = "gnu_asm_clobber_list_repeat1",
  [aux_sym_gnu_asm_goto_list_repeat1] = "gnu_asm_goto_list_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_initializer_list_repeat1] = "initializer_list_repeat1",
  [aux_sym_initializer_pair_repeat1] = "initializer_pair_repeat1",
  [aux_sym_char_literal_repeat1] = "char_literal_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [aux_sym__class_declaration_repeat1] = "_class_declaration_repeat1",
  [aux_sym_base_class_clause_repeat1] = "base_class_clause_repeat1",
  [aux_sym_template_parameter_list_repeat1] = "template_parameter_list_repeat1",
  [aux_sym_field_initializer_list_repeat1] = "field_initializer_list_repeat1",
  [aux_sym_operator_cast_definition_repeat1] = "operator_cast_definition_repeat1",
  [aux_sym_constructor_try_statement_repeat1] = "constructor_try_statement_repeat1",
  [aux_sym_structured_binding_declarator_repeat1] = "structured_binding_declarator_repeat1",
  [aux_sym__function_postfix_repeat1] = "_function_postfix_repeat1",
  [aux_sym_throw_specifier_repeat1] = "throw_specifier_repeat1",
  [aux_sym_template_argument_list_repeat1] = "template_argument_list_repeat1",
  [aux_sym_subscript_argument_list_repeat1] = "subscript_argument_list_repeat1",
  [aux_sym_requirement_seq_repeat1] = "requirement_seq_repeat1",
  [aux_sym_requires_parameter_list_repeat1] = "requires_parameter_list_repeat1",
  [aux_sym_lambda_capture_specifier_repeat1] = "lambda_capture_specifier_repeat1",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_namespace_identifier] = "namespace_identifier",
  [alias_sym_simple_requirement] = "simple_requirement",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [aux_sym_preproc_include_token1] = aux_sym_preproc_include_token1,
  [aux_sym_preproc_include_token2] = aux_sym_preproc_include_token2,
  [aux_sym_preproc_def_token1] = aux_sym_preproc_def_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_preproc_if_token1] = aux_sym_preproc_if_token1,
  [anon_sym_LF] = anon_sym_LF,
  [aux_sym_preproc_if_token2] = aux_sym_preproc_if_token2,
  [aux_sym_preproc_ifdef_token1] = aux_sym_preproc_ifdef_token1,
  [aux_sym_preproc_ifdef_token2] = aux_sym_preproc_ifdef_token2,
  [aux_sym_preproc_else_token1] = aux_sym_preproc_else_token1,
  [aux_sym_preproc_elif_token1] = aux_sym_preproc_elif_token1,
  [aux_sym_preproc_elifdef_token1] = aux_sym_preproc_elifdef_token1,
  [aux_sym_preproc_elifdef_token2] = aux_sym_preproc_elifdef_token2,
  [sym_preproc_arg] = sym_preproc_arg,
  [sym_preproc_directive] = sym_preproc_directive,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_defined] = anon_sym_defined,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym___extension__] = anon_sym___extension__,
  [anon_sym_typedef] = anon_sym_typedef,
  [anon_sym_extern] = anon_sym_extern,
  [anon_sym___attribute__] = anon_sym___attribute__,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym___declspec] = anon_sym___declspec,
  [anon_sym___based] = anon_sym___based,
  [anon_sym___cdecl] = anon_sym___cdecl,
  [anon_sym___clrcall] = anon_sym___clrcall,
  [anon_sym___stdcall] = anon_sym___stdcall,
  [anon_sym___fastcall] = anon_sym___fastcall,
  [anon_sym___thiscall] = anon_sym___thiscall,
  [anon_sym___vectorcall] = anon_sym___vectorcall,
  [sym_ms_restrict_modifier] = sym_ms_restrict_modifier,
  [sym_ms_unsigned_ptr_modifier] = sym_ms_unsigned_ptr_modifier,
  [sym_ms_signed_ptr_modifier] = sym_ms_signed_ptr_modifier,
  [anon_sym__unaligned] = anon_sym__unaligned,
  [anon_sym___unaligned] = anon_sym___unaligned,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_signed] = anon_sym_signed,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_register] = anon_sym_register,
  [anon_sym_inline] = anon_sym_inline,
  [anon_sym___inline] = anon_sym___inline,
  [anon_sym___inline__] = anon_sym___inline__,
  [anon_sym___forceinline] = anon_sym___forceinline,
  [anon_sym_thread_local] = anon_sym_thread_local,
  [anon_sym___thread] = anon_sym___thread,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_constexpr] = anon_sym_constexpr,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_restrict] = anon_sym_restrict,
  [anon_sym___restrict__] = anon_sym___restrict__,
  [anon_sym__Atomic] = anon_sym__Atomic,
  [anon_sym__Noreturn] = anon_sym__Noreturn,
  [anon_sym_noreturn] = anon_sym_noreturn,
  [anon_sym_mutable] = anon_sym_mutable,
  [anon_sym_constinit] = anon_sym_constinit,
  [anon_sym_consteval] = anon_sym_consteval,
  [sym_primitive_type] = sym_primitive_type,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym___try] = anon_sym___try,
  [anon_sym___except] = anon_sym___except,
  [anon_sym___finally] = anon_sym___finally,
  [anon_sym___leave] = anon_sym___leave,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_and_eq] = anon_sym_and_eq,
  [anon_sym_or_eq] = anon_sym_or_eq,
  [anon_sym_xor_eq] = anon_sym_xor_eq,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_compl] = anon_sym_compl,
  [anon_sym_LT_EQ_GT] = anon_sym_LT_EQ_GT,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_bitor] = anon_sym_bitor,
  [anon_sym_xor] = anon_sym_xor,
  [anon_sym_bitand] = anon_sym_bitand,
  [anon_sym_not_eq] = anon_sym_not_eq,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_sizeof] = anon_sym_sizeof,
  [anon_sym___alignof__] = anon_sym___alignof__,
  [anon_sym___alignof] = anon_sym___alignof,
  [anon_sym__alignof] = anon_sym__alignof,
  [anon_sym_alignof] = anon_sym_alignof,
  [anon_sym__Alignof] = anon_sym__Alignof,
  [anon_sym_offsetof] = anon_sym_offsetof,
  [anon_sym__Generic] = anon_sym__Generic,
  [anon_sym_asm] = anon_sym_asm,
  [anon_sym___asm__] = anon_sym___asm__,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DOT_STAR] = anon_sym_DOT_STAR,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [sym_number_literal] = sym_number_literal,
  [anon_sym_L_SQUOTE] = anon_sym_L_SQUOTE,
  [anon_sym_u_SQUOTE] = anon_sym_u_SQUOTE,
  [anon_sym_U_SQUOTE] = anon_sym_U_SQUOTE,
  [anon_sym_u8_SQUOTE] = anon_sym_u8_SQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_char_literal_token1] = aux_sym_char_literal_token1,
  [anon_sym_L_DQUOTE] = anon_sym_L_DQUOTE,
  [anon_sym_u_DQUOTE] = anon_sym_u_DQUOTE,
  [anon_sym_U_DQUOTE] = anon_sym_U_DQUOTE,
  [anon_sym_u8_DQUOTE] = anon_sym_u8_DQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_system_lib_string] = sym_system_lib_string,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [anon_sym_NULL] = anon_sym_NULL,
  [anon_sym_nullptr] = anon_sym_nullptr,
  [sym_comment] = sym_comment,
  [sym_auto] = sym_auto,
  [anon_sym_decltype] = anon_sym_decltype,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_virtual] = anon_sym_virtual,
  [anon_sym_alignas] = anon_sym_alignas,
  [anon_sym_explicit] = anon_sym_explicit,
  [anon_sym_typename] = anon_sym_typename,
  [anon_sym_template] = anon_sym_template,
  [anon_sym_GT2] = anon_sym_GT,
  [anon_sym_operator] = anon_sym_operator,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_friend] = anon_sym_friend,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_noexcept] = anon_sym_noexcept,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_static_assert] = anon_sym_static_assert,
  [anon_sym_concept] = anon_sym_concept,
  [anon_sym_co_return] = anon_sym_co_return,
  [anon_sym_co_yield] = anon_sym_co_yield,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_R_DQUOTE] = anon_sym_R_DQUOTE,
  [anon_sym_LR_DQUOTE] = anon_sym_LR_DQUOTE,
  [anon_sym_uR_DQUOTE] = anon_sym_uR_DQUOTE,
  [anon_sym_UR_DQUOTE] = anon_sym_UR_DQUOTE,
  [anon_sym_u8R_DQUOTE] = anon_sym_u8R_DQUOTE,
  [anon_sym_co_await] = anon_sym_co_await,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_requires] = anon_sym_requires,
  [anon_sym_DASH_GT_STAR] = anon_sym_DASH_GT_STAR,
  [anon_sym_LPAREN_RPAREN] = anon_sym_LPAREN_RPAREN,
  [anon_sym_LBRACK_RBRACK] = anon_sym_LBRACK_RBRACK,
  [anon_sym_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE,
  [sym_this] = sym_this,
  [sym_literal_suffix] = sym_literal_suffix,
  [sym_raw_string_delimiter] = sym_raw_string_delimiter,
  [sym_raw_string_content] = sym_raw_string_content,
  [sym_translation_unit] = sym_translation_unit,
  [sym_preproc_include] = sym_preproc_include,
  [sym_preproc_def] = sym_preproc_def,
  [sym_preproc_function_def] = sym_preproc_function_def,
  [sym_preproc_params] = sym_preproc_params,
  [sym_preproc_call] = sym_preproc_call,
  [sym_preproc_if] = sym_preproc_if,
  [sym_preproc_ifdef] = sym_preproc_ifdef,
  [sym_preproc_else] = sym_preproc_else,
  [sym_preproc_elif] = sym_preproc_elif,
  [sym_preproc_elifdef] = sym_preproc_elifdef,
  [sym_preproc_if_in_field_declaration_list] = sym_preproc_if,
  [sym_preproc_ifdef_in_field_declaration_list] = sym_preproc_ifdef,
  [sym_preproc_else_in_field_declaration_list] = sym_preproc_else,
  [sym_preproc_elif_in_field_declaration_list] = sym_preproc_elif,
  [sym_preproc_elifdef_in_field_declaration_list] = sym_preproc_elifdef,
  [sym_preproc_if_in_enumerator_list] = sym_preproc_if,
  [sym_preproc_ifdef_in_enumerator_list] = sym_preproc_ifdef,
  [sym_preproc_else_in_enumerator_list] = sym_preproc_else,
  [sym_preproc_elif_in_enumerator_list] = sym_preproc_elif,
  [sym_preproc_elifdef_in_enumerator_list] = sym_preproc_elifdef,
  [sym_preproc_if_in_enumerator_list_no_comma] = sym_preproc_if,
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = sym_preproc_ifdef,
  [sym_preproc_else_in_enumerator_list_no_comma] = sym_preproc_else,
  [sym_preproc_elif_in_enumerator_list_no_comma] = sym_preproc_elif,
  [sym_preproc_elifdef_in_enumerator_list_no_comma] = sym_preproc_elifdef,
  [sym__preproc_expression] = sym__preproc_expression,
  [sym_preproc_parenthesized_expression] = sym_parenthesized_expression,
  [sym_preproc_defined] = sym_preproc_defined,
  [sym_preproc_unary_expression] = sym_unary_expression,
  [sym_preproc_call_expression] = sym_call_expression,
  [sym_preproc_argument_list] = sym_argument_list,
  [sym_preproc_binary_expression] = sym_binary_expression,
  [sym_function_definition] = sym_function_definition,
  [sym_declaration] = sym_declaration,
  [sym_type_definition] = sym_type_definition,
  [sym__type_definition_type] = sym__type_definition_type,
  [sym__type_definition_declarators] = sym__type_definition_declarators,
  [sym__declaration_modifiers] = sym__declaration_modifiers,
  [sym__declaration_specifiers] = sym__declaration_specifiers,
  [sym_linkage_specification] = sym_linkage_specification,
  [sym_attribute_specifier] = sym_attribute_specifier,
  [sym_attribute] = sym_attribute,
  [sym_attribute_declaration] = sym_attribute_declaration,
  [sym_ms_declspec_modifier] = sym_ms_declspec_modifier,
  [sym_ms_based_modifier] = sym_ms_based_modifier,
  [sym_ms_call_modifier] = sym_ms_call_modifier,
  [sym_ms_unaligned_ptr_modifier] = sym_ms_unaligned_ptr_modifier,
  [sym_ms_pointer_modifier] = sym_ms_pointer_modifier,
  [sym_declaration_list] = sym_declaration_list,
  [sym__declarator] = sym__declarator,
  [sym__field_declarator] = sym__field_declarator,
  [sym__type_declarator] = sym__type_declarator,
  [sym__abstract_declarator] = sym__abstract_declarator,
  [sym_parenthesized_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_field_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_type_declarator] = sym_parenthesized_declarator,
  [sym_abstract_parenthesized_declarator] = sym_abstract_parenthesized_declarator,
  [sym_attributed_declarator] = sym_attributed_declarator,
  [sym_attributed_field_declarator] = sym_attributed_declarator,
  [sym_attributed_type_declarator] = sym_attributed_declarator,
  [sym_pointer_declarator] = sym_pointer_declarator,
  [sym_pointer_field_declarator] = sym_pointer_declarator,
  [sym_pointer_type_declarator] = sym_pointer_type_declarator,
  [sym_abstract_pointer_declarator] = sym_abstract_pointer_declarator,
  [sym_function_declarator] = sym_function_declarator,
  [sym_function_field_declarator] = sym_function_declarator,
  [sym_function_type_declarator] = sym_function_declarator,
  [sym_abstract_function_declarator] = sym_abstract_function_declarator,
  [sym_array_declarator] = sym_array_declarator,
  [sym_array_field_declarator] = sym_array_declarator,
  [sym_array_type_declarator] = sym_array_declarator,
  [sym_abstract_array_declarator] = sym_abstract_array_declarator,
  [sym_init_declarator] = sym_init_declarator,
  [sym_compound_statement] = sym_compound_statement,
  [sym_storage_class_specifier] = sym_storage_class_specifier,
  [sym_type_qualifier] = sym_type_qualifier,
  [sym__type_specifier] = sym__type_specifier,
  [sym_sized_type_specifier] = sym_sized_type_specifier,
  [sym_enum_specifier] = sym_enum_specifier,
  [sym_enumerator_list] = sym_enumerator_list,
  [sym_struct_specifier] = sym_struct_specifier,
  [sym_union_specifier] = sym_union_specifier,
  [sym_field_declaration_list] = sym_field_declaration_list,
  [sym__field_declaration_list_item] = sym__field_declaration_list_item,
  [sym_field_declaration] = sym_field_declaration,
  [sym_bitfield_clause] = sym_bitfield_clause,
  [sym_enumerator] = sym_enumerator,
  [sym_parameter_list] = sym_parameter_list,
  [sym_parameter_declaration] = sym_parameter_declaration,
  [sym_attributed_statement] = sym_attributed_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym__top_level_expression_statement] = sym_expression_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_else_clause] = sym_else_clause,
  [sym_switch_statement] = sym_switch_statement,
  [sym_case_statement] = sym_case_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_for_statement] = sym_for_statement,
  [sym__for_statement_body] = sym__for_statement_body,
  [sym_return_statement] = sym_return_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_seh_try_statement] = sym_seh_try_statement,
  [sym_seh_except_clause] = sym_seh_except_clause,
  [sym_seh_finally_clause] = sym_seh_finally_clause,
  [sym_seh_leave_statement] = sym_seh_leave_statement,
  [sym__expression] = sym__expression,
  [sym__expression_not_binary] = sym__expression_not_binary,
  [sym__string] = sym__string,
  [sym_comma_expression] = sym_comma_expression,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_pointer_expression] = sym_pointer_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_type_descriptor] = sym_type_descriptor,
  [sym_sizeof_expression] = sym_sizeof_expression,
  [sym_alignof_expression] = sym_alignof_expression,
  [sym_offsetof_expression] = sym_offsetof_expression,
  [sym_generic_expression] = sym_generic_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_gnu_asm_expression] = sym_gnu_asm_expression,
  [sym_gnu_asm_qualifier] = sym_gnu_asm_qualifier,
  [sym_gnu_asm_output_operand_list] = sym_gnu_asm_output_operand_list,
  [sym_gnu_asm_output_operand] = sym_gnu_asm_output_operand,
  [sym_gnu_asm_input_operand_list] = sym_gnu_asm_input_operand_list,
  [sym_gnu_asm_input_operand] = sym_gnu_asm_input_operand,
  [sym_gnu_asm_clobber_list] = sym_gnu_asm_clobber_list,
  [sym_gnu_asm_goto_list] = sym_gnu_asm_goto_list,
  [sym_argument_list] = sym_argument_list,
  [sym_field_expression] = sym_field_expression,
  [sym_compound_literal_expression] = sym_compound_literal_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_initializer_list] = sym_initializer_list,
  [sym_initializer_pair] = sym_initializer_pair,
  [sym_subscript_designator] = sym_subscript_designator,
  [sym_subscript_range_designator] = sym_subscript_range_designator,
  [sym_field_designator] = sym_field_designator,
  [sym_char_literal] = sym_char_literal,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string_literal] = sym_string_literal,
  [sym_null] = sym_null,
  [sym__empty_declaration] = sym__empty_declaration,
  [sym_placeholder_type_specifier] = sym_placeholder_type_specifier,
  [sym_decltype_auto] = sym_decltype,
  [sym_decltype] = sym_decltype,
  [sym__class_declaration] = sym__class_declaration,
  [sym__class_declaration_item] = sym__class_declaration_item,
  [sym_class_specifier] = sym_class_specifier,
  [sym__class_name] = sym__class_name,
  [sym_virtual_specifier] = sym_virtual_specifier,
  [sym_virtual] = sym_virtual,
  [sym_alignas_specifier] = sym_alignas_specifier,
  [sym_explicit_function_specifier] = sym_explicit_function_specifier,
  [sym_base_class_clause] = sym_base_class_clause,
  [sym__enum_base_clause] = sym__enum_base_clause,
  [sym_dependent_type] = sym_dependent_type,
  [sym_template_declaration] = sym_template_declaration,
  [sym_template_instantiation] = sym_template_instantiation,
  [sym_template_parameter_list] = sym_template_parameter_list,
  [sym_type_parameter_declaration] = sym_type_parameter_declaration,
  [sym_variadic_type_parameter_declaration] = sym_variadic_type_parameter_declaration,
  [sym_optional_type_parameter_declaration] = sym_optional_type_parameter_declaration,
  [sym_template_template_parameter_declaration] = sym_template_template_parameter_declaration,
  [sym_optional_parameter_declaration] = sym_optional_parameter_declaration,
  [sym_variadic_parameter_declaration] = sym_variadic_parameter_declaration,
  [sym_variadic_declarator] = sym_variadic_declarator,
  [sym_variadic_reference_declarator] = sym_reference_declarator,
  [sym_operator_cast] = sym_operator_cast,
  [sym_field_initializer_list] = sym_field_initializer_list,
  [sym_field_initializer] = sym_field_initializer,
  [sym_inline_method_definition] = sym_function_definition,
  [sym__constructor_specifiers] = sym__constructor_specifiers,
  [sym_operator_cast_definition] = sym_function_definition,
  [sym_operator_cast_declaration] = sym_declaration,
  [sym_constructor_try_statement] = sym_try_statement,
  [sym_constructor_or_destructor_definition] = sym_function_definition,
  [sym_constructor_or_destructor_declaration] = sym_declaration,
  [sym_default_method_clause] = sym_default_method_clause,
  [sym_delete_method_clause] = sym_delete_method_clause,
  [sym_friend_declaration] = sym_friend_declaration,
  [sym_access_specifier] = sym_access_specifier,
  [sym_reference_declarator] = sym_reference_declarator,
  [sym_reference_field_declarator] = sym_reference_declarator,
  [sym_abstract_reference_declarator] = sym_abstract_reference_declarator,
  [sym_structured_binding_declarator] = sym_structured_binding_declarator,
  [sym_ref_qualifier] = sym_ref_qualifier,
  [sym__function_declarator_seq] = sym__function_declarator_seq,
  [sym__function_attributes_start] = sym__function_attributes_start,
  [sym__function_exception_specification] = sym__function_exception_specification,
  [sym__function_attributes_end] = sym__function_attributes_end,
  [sym__function_postfix] = sym__function_postfix,
  [sym_trailing_return_type] = sym_trailing_return_type,
  [sym_noexcept] = sym_noexcept,
  [sym_throw_specifier] = sym_throw_specifier,
  [sym_template_type] = sym_template_type,
  [sym_template_method] = sym_template_method,
  [sym_template_function] = sym_template_function,
  [sym_template_argument_list] = sym_template_argument_list,
  [sym_namespace_definition] = sym_namespace_definition,
  [sym_namespace_alias_definition] = sym_namespace_alias_definition,
  [sym__namespace_specifier] = sym__namespace_specifier,
  [sym_nested_namespace_specifier] = sym_nested_namespace_specifier,
  [sym_using_declaration] = sym_using_declaration,
  [sym_alias_declaration] = sym_alias_declaration,
  [sym_static_assert_declaration] = sym_static_assert_declaration,
  [sym_concept_definition] = sym_concept_definition,
  [sym_for_range_loop] = sym_for_range_loop,
  [sym__for_range_loop_body] = sym__for_range_loop_body,
  [sym_init_statement] = sym_init_statement,
  [sym_condition_clause] = sym_condition_clause,
  [sym_condition_declaration] = sym_declaration,
  [sym_co_return_statement] = sym_co_return_statement,
  [sym_co_yield_statement] = sym_co_yield_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_raw_string_literal] = sym_raw_string_literal,
  [sym_subscript_argument_list] = sym_subscript_argument_list,
  [sym_co_await_expression] = sym_co_await_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_new_declarator] = sym_new_declarator,
  [sym_delete_expression] = sym_delete_expression,
  [sym_type_requirement] = sym_type_requirement,
  [sym_compound_requirement] = sym_compound_requirement,
  [sym__requirement] = sym__requirement,
  [sym_requirement_seq] = sym_requirement_seq,
  [sym_constraint_conjunction] = sym_constraint_conjunction,
  [sym_constraint_disjunction] = sym_constraint_disjunction,
  [sym__requirement_clause_constraint] = sym__requirement_clause_constraint,
  [sym_requires_clause] = sym_requires_clause,
  [sym_requires_parameter_list] = sym_parameter_list,
  [sym_requires_expression] = sym_requires_expression,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_lambda_capture_specifier] = sym_lambda_capture_specifier,
  [sym_lambda_default_capture] = sym_lambda_default_capture,
  [sym__fold_operator] = sym__fold_operator,
  [sym__binary_fold_operator] = sym__binary_fold_operator,
  [sym__unary_left_fold] = sym__unary_left_fold,
  [sym__unary_right_fold] = sym__unary_right_fold,
  [sym__binary_fold] = sym__binary_fold,
  [sym_fold_expression] = sym_fold_expression,
  [sym_parameter_pack_expansion] = sym_parameter_pack_expansion,
  [sym_type_parameter_pack_expansion] = sym_parameter_pack_expansion,
  [sym_destructor_name] = sym_destructor_name,
  [sym_dependent_identifier] = sym_dependent_identifier,
  [sym_dependent_field_identifier] = sym_dependent_identifier,
  [sym_dependent_type_identifier] = sym_dependent_identifier,
  [sym__scope_resolution] = sym__scope_resolution,
  [sym_qualified_field_identifier] = sym_qualified_identifier,
  [sym_qualified_identifier] = sym_qualified_identifier,
  [sym_qualified_type_identifier] = sym_qualified_identifier,
  [sym_qualified_operator_cast_identifier] = sym_qualified_identifier,
  [sym__assignment_expression_lhs] = sym_assignment_expression,
  [sym_operator_name] = sym_operator_name,
  [sym_user_defined_literal] = sym_user_defined_literal,
  [aux_sym_translation_unit_repeat1] = aux_sym_translation_unit_repeat1,
  [aux_sym_preproc_params_repeat1] = aux_sym_preproc_params_repeat1,
  [aux_sym_preproc_if_repeat1] = aux_sym_preproc_if_repeat1,
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = aux_sym_preproc_if_in_field_declaration_list_repeat1,
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = aux_sym_preproc_if_in_enumerator_list_repeat1,
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1,
  [aux_sym_preproc_argument_list_repeat1] = aux_sym_preproc_argument_list_repeat1,
  [aux_sym_declaration_repeat1] = aux_sym_declaration_repeat1,
  [aux_sym_type_definition_repeat1] = aux_sym_type_definition_repeat1,
  [aux_sym__type_definition_type_repeat1] = aux_sym__type_definition_type_repeat1,
  [aux_sym__type_definition_declarators_repeat1] = aux_sym__type_definition_declarators_repeat1,
  [aux_sym__declaration_specifiers_repeat1] = aux_sym__declaration_specifiers_repeat1,
  [aux_sym_attribute_declaration_repeat1] = aux_sym_attribute_declaration_repeat1,
  [aux_sym_attributed_declarator_repeat1] = aux_sym_attributed_declarator_repeat1,
  [aux_sym_pointer_declarator_repeat1] = aux_sym_pointer_declarator_repeat1,
  [aux_sym_sized_type_specifier_repeat1] = aux_sym_sized_type_specifier_repeat1,
  [aux_sym_enumerator_list_repeat1] = aux_sym_enumerator_list_repeat1,
  [aux_sym_field_declaration_repeat1] = aux_sym_field_declaration_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_case_statement_repeat1] = aux_sym_case_statement_repeat1,
  [aux_sym_generic_expression_repeat1] = aux_sym_generic_expression_repeat1,
  [aux_sym_gnu_asm_expression_repeat1] = aux_sym_gnu_asm_expression_repeat1,
  [aux_sym_gnu_asm_output_operand_list_repeat1] = aux_sym_gnu_asm_output_operand_list_repeat1,
  [aux_sym_gnu_asm_input_operand_list_repeat1] = aux_sym_gnu_asm_input_operand_list_repeat1,
  [aux_sym_gnu_asm_clobber_list_repeat1] = aux_sym_gnu_asm_clobber_list_repeat1,
  [aux_sym_gnu_asm_goto_list_repeat1] = aux_sym_gnu_asm_goto_list_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_initializer_list_repeat1] = aux_sym_initializer_list_repeat1,
  [aux_sym_initializer_pair_repeat1] = aux_sym_initializer_pair_repeat1,
  [aux_sym_char_literal_repeat1] = aux_sym_char_literal_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [aux_sym__class_declaration_repeat1] = aux_sym__class_declaration_repeat1,
  [aux_sym_base_class_clause_repeat1] = aux_sym_base_class_clause_repeat1,
  [aux_sym_template_parameter_list_repeat1] = aux_sym_template_parameter_list_repeat1,
  [aux_sym_field_initializer_list_repeat1] = aux_sym_field_initializer_list_repeat1,
  [aux_sym_operator_cast_definition_repeat1] = aux_sym_operator_cast_definition_repeat1,
  [aux_sym_constructor_try_statement_repeat1] = aux_sym_constructor_try_statement_repeat1,
  [aux_sym_structured_binding_declarator_repeat1] = aux_sym_structured_binding_declarator_repeat1,
  [aux_sym__function_postfix_repeat1] = aux_sym__function_postfix_repeat1,
  [aux_sym_throw_specifier_repeat1] = aux_sym_throw_specifier_repeat1,
  [aux_sym_template_argument_list_repeat1] = aux_sym_template_argument_list_repeat1,
  [aux_sym_subscript_argument_list_repeat1] = aux_sym_subscript_argument_list_repeat1,
  [aux_sym_requirement_seq_repeat1] = aux_sym_requirement_seq_repeat1,
  [aux_sym_requires_parameter_list_repeat1] = aux_sym_requires_parameter_list_repeat1,
  [aux_sym_lambda_capture_specifier_repeat1] = aux_sym_lambda_capture_specifier_repeat1,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_namespace_identifier] = alias_sym_namespace_identifier,
  [alias_sym_simple_requirement] = alias_sym_simple_requirement,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_preproc_include_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_include_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_def_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_else_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elif_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [sym_preproc_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_directive] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defined] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___extension__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typedef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___attribute__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___declspec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___based] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___cdecl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___clrcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___stdcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___fastcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___thiscall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___vectorcall] = {
    .visible = true,
    .named = false,
  },
  [sym_ms_restrict_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unsigned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_signed_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_register] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___inline__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___forceinline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_thread_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___thread] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constexpr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_restrict] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___restrict__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Atomic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Noreturn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noreturn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mutable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constinit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_consteval] = {
    .visible = true,
    .named = false,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___leave] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and_eq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or_eq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor_eq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_compl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bitor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bitand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not_eq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sizeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___alignof__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_offsetof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Generic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___asm__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_char_literal_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token1] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_system_lib_string] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nullptr] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_auto] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_decltype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_virtual] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alignas] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_explicit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typename] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_template] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_operator] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_friend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noexcept] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_concept] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_co_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_co_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_R_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LR_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uR_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UR_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8R_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_co_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_requires] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_string_delimiter] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym_translation_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_include] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_params] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym__preproc_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_preproc_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_defined] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__type_definition_type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_definition_declarators] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration_modifiers] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration_specifiers] = {
    .visible = false,
    .named = true,
  },
  [sym_linkage_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_declspec_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_based_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_call_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unaligned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_pointer_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__field_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__type_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__abstract_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_init_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_storage_class_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym__type_specifier] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_sized_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_union_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__field_declaration_list_item] = {
    .visible = false,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_bitfield_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__top_level_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_statement_body] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_leave_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__expression_not_binary] = {
    .visible = false,
    .named = true,
  },
  [sym__string] = {
    .visible = false,
    .named = true,
  },
  [sym_comma_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym_sizeof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_alignof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_offsetof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_output_operand_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_output_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_input_operand_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_input_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_clobber_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_goto_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_literal_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_list] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_range_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_field_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_char_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_placeholder_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_decltype_auto] = {
    .visible = true,
    .named = true,
  },
  [sym_decltype] = {
    .visible = true,
    .named = true,
  },
  [sym__class_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__class_declaration_item] = {
    .visible = false,
    .named = true,
  },
  [sym_class_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym__class_name] = {
    .visible = false,
    .named = true,
  },
  [sym_virtual_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_virtual] = {
    .visible = true,
    .named = true,
  },
  [sym_alignas_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_explicit_function_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_base_class_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__enum_base_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_dependent_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_template_instantiation] = {
    .visible = true,
    .named = true,
  },
  [sym_template_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_type_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_template_template_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_reference_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_field_initializer_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_specifiers] = {
    .visible = false,
    .named = true,
  },
  [sym_operator_cast_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_cast_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_or_destructor_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_or_destructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_default_method_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_method_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_friend_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_access_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_reference_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_structured_binding_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym__function_declarator_seq] = {
    .visible = false,
    .named = true,
  },
  [sym__function_attributes_start] = {
    .visible = false,
    .named = true,
  },
  [sym__function_exception_specification] = {
    .visible = false,
    .named = true,
  },
  [sym__function_attributes_end] = {
    .visible = false,
    .named = true,
  },
  [sym__function_postfix] = {
    .visible = false,
    .named = true,
  },
  [sym_trailing_return_type] = {
    .visible = true,
    .named = true,
  },
  [sym_noexcept] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_template_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_method] = {
    .visible = true,
    .named = true,
  },
  [sym_template_function] = {
    .visible = true,
    .named = true,
  },
  [sym_template_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_alias_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__namespace_specifier] = {
    .visible = false,
    .named = true,
  },
  [sym_nested_namespace_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_using_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_static_assert_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_concept_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_for_range_loop] = {
    .visible = true,
    .named = true,
  },
  [sym__for_range_loop_body] = {
    .visible = false,
    .named = true,
  },
  [sym_init_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_co_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_co_yield_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_co_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_requirement] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_requirement] = {
    .visible = true,
    .named = true,
  },
  [sym__requirement] = {
    .visible = false,
    .named = true,
  },
  [sym_requirement_seq] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint_conjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym__requirement_clause_constraint] = {
    .visible = false,
    .named = true,
  },
  [sym_requires_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_requires_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_requires_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_capture_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_default_capture] = {
    .visible = true,
    .named = true,
  },
  [sym__fold_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__binary_fold_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__unary_left_fold] = {
    .visible = false,
    .named = true,
  },
  [sym__unary_right_fold] = {
    .visible = false,
    .named = true,
  },
  [sym__binary_fold] = {
    .visible = false,
    .named = true,
  },
  [sym_fold_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_pack_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_pack_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_destructor_name] = {
    .visible = true,
    .named = true,
  },
  [sym_dependent_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_dependent_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_dependent_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__scope_resolution] = {
    .visible = false,
    .named = true,
  },
  [sym_qualified_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_operator_cast_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__assignment_expression_lhs] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_name] = {
    .visible = true,
    .named = true,
  },
  [sym_user_defined_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_translation_unit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_params_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_definition_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_definition_declarators_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__declaration_specifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attributed_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pointer_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sized_type_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_generic_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_output_operand_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_input_operand_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_clobber_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_goto_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_pair_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_char_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__class_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_base_class_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_initializer_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operator_cast_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constructor_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_structured_binding_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__function_postfix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_throw_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_requirement_seq_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_requires_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_lambda_capture_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_namespace_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_simple_requirement] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_assembly_code = 4,
  field_base = 5,
  field_body = 6,
  field_captures = 7,
  field_clobbers = 8,
  field_condition = 9,
  field_consequence = 10,
  field_constraint = 11,
  field_declarator = 12,
  field_default_type = 13,
  field_default_value = 14,
  field_delimiter = 15,
  field_designator = 16,
  field_directive = 17,
  field_end = 18,
  field_field = 19,
  field_filter = 20,
  field_function = 21,
  field_goto_labels = 22,
  field_indices = 23,
  field_initializer = 24,
  field_input_operands = 25,
  field_label = 26,
  field_left = 27,
  field_length = 28,
  field_member = 29,
  field_message = 30,
  field_name = 31,
  field_operand = 32,
  field_operator = 33,
  field_output_operands = 34,
  field_parameters = 35,
  field_path = 36,
  field_pattern = 37,
  field_placement = 38,
  field_prefix = 39,
  field_register = 40,
  field_requirements = 41,
  field_right = 42,
  field_scope = 43,
  field_size = 44,
  field_start = 45,
  field_symbol = 46,
  field_template_parameters = 47,
  field_type = 48,
  field_update = 49,
  field_value = 50,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_assembly_code] = "assembly_code",
  [field_base] = "base",
  [field_body] = "body",
  [field_captures] = "captures",
  [field_clobbers] = "clobbers",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_declarator] = "declarator",
  [field_default_type] = "default_type",
  [field_default_value] = "default_value",
  [field_delimiter] = "delimiter",
  [field_designator] = "designator",
  [field_directive] = "directive",
  [field_end] = "end",
  [field_field] = "field",
  [field_filter] = "filter",
  [field_function] = "function",
  [field_goto_labels] = "goto_labels",
  [field_indices] = "indices",
  [field_initializer] = "initializer",
  [field_input_operands] = "input_operands",
  [field_label] = "label",
  [field_left] = "left",
  [field_length] = "length",
  [field_member] = "member",
  [field_message] = "message",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_output_operands] = "output_operands",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_pattern] = "pattern",
  [field_placement] = "placement",
  [field_prefix] = "prefix",
  [field_register] = "register",
  [field_requirements] = "requirements",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_size] = "size",
  [field_start] = "start",
  [field_symbol] = "symbol",
  [field_template_parameters] = "template_parameters",
  [field_type] = "type",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 2},
  [5] = {.index = 4, .length = 1},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 8, .length = 2},
  [9] = {.index = 10, .length = 1},
  [10] = {.index = 11, .length = 1},
  [11] = {.index = 12, .length = 1},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 2},
  [14] = {.index = 17, .length = 1},
  [15] = {.index = 18, .length = 1},
  [16] = {.index = 19, .length = 2},
  [17] = {.index = 19, .length = 2},
  [18] = {.index = 0, .length = 1},
  [20] = {.index = 21, .length = 1},
  [21] = {.index = 22, .length = 1},
  [22] = {.index = 23, .length = 1},
  [23] = {.index = 24, .length = 1},
  [24] = {.index = 25, .length = 2},
  [25] = {.index = 27, .length = 2},
  [26] = {.index = 29, .length = 1},
  [27] = {.index = 30, .length = 1},
  [28] = {.index = 31, .length = 1},
  [29] = {.index = 32, .length = 2},
  [30] = {.index = 34, .length = 2},
  [31] = {.index = 18, .length = 1},
  [32] = {.index = 36, .length = 2},
  [33] = {.index = 38, .length = 1},
  [34] = {.index = 39, .length = 2},
  [35] = {.index = 39, .length = 2},
  [36] = {.index = 21, .length = 1},
  [37] = {.index = 41, .length = 1},
  [38] = {.index = 42, .length = 2},
  [39] = {.index = 44, .length = 2},
  [40] = {.index = 46, .length = 3},
  [41] = {.index = 49, .length = 1},
  [44] = {.index = 50, .length = 2},
  [45] = {.index = 52, .length = 1},
  [46] = {.index = 53, .length = 1},
  [47] = {.index = 54, .length = 1},
  [48] = {.index = 55, .length = 2},
  [49] = {.index = 57, .length = 2},
  [50] = {.index = 59, .length = 2},
  [51] = {.index = 61, .length = 2},
  [52] = {.index = 63, .length = 2},
  [53] = {.index = 65, .length = 1},
  [54] = {.index = 66, .length = 3},
  [55] = {.index = 69, .length = 1},
  [56] = {.index = 70, .length = 1},
  [57] = {.index = 71, .length = 1},
  [58] = {.index = 72, .length = 2},
  [60] = {.index = 55, .length = 2},
  [61] = {.index = 74, .length = 2},
  [62] = {.index = 76, .length = 2},
  [63] = {.index = 78, .length = 2},
  [65] = {.index = 80, .length = 2},
  [66] = {.index = 82, .length = 2},
  [67] = {.index = 84, .length = 3},
  [68] = {.index = 87, .length = 2},
  [69] = {.index = 89, .length = 2},
  [70] = {.index = 91, .length = 3},
  [71] = {.index = 91, .length = 3},
  [72] = {.index = 94, .length = 3},
  [73] = {.index = 97, .length = 3},
  [74] = {.index = 100, .length = 3},
  [75] = {.index = 103, .length = 2},
  [76] = {.index = 105, .length = 2},
  [77] = {.index = 107, .length = 2},
  [78] = {.index = 109, .length = 1},
  [79] = {.index = 110, .length = 2},
  [80] = {.index = 112, .length = 2},
  [81] = {.index = 114, .length = 2},
  [82] = {.index = 116, .length = 3},
  [83] = {.index = 119, .length = 2},
  [84] = {.index = 121, .length = 1},
  [85] = {.index = 122, .length = 2},
  [86] = {.index = 124, .length = 2},
  [87] = {.index = 126, .length = 2},
  [88] = {.index = 128, .length = 2},
  [89] = {.index = 130, .length = 2},
  [90] = {.index = 132, .length = 2},
  [91] = {.index = 134, .length = 2},
  [92] = {.index = 136, .length = 2},
  [93] = {.index = 136, .length = 2},
  [95] = {.index = 138, .length = 2},
  [96] = {.index = 140, .length = 1},
  [97] = {.index = 140, .length = 1},
  [98] = {.index = 141, .length = 3},
  [100] = {.index = 144, .length = 2},
  [101] = {.index = 146, .length = 2},
  [102] = {.index = 148, .length = 2},
  [103] = {.index = 150, .length = 3},
  [104] = {.index = 153, .length = 1},
  [105] = {.index = 154, .length = 1},
  [107] = {.index = 155, .length = 3},
  [108] = {.index = 158, .length = 3},
  [109] = {.index = 161, .length = 3},
  [110] = {.index = 164, .length = 3},
  [111] = {.index = 167, .length = 2},
  [112] = {.index = 169, .length = 3},
  [113] = {.index = 172, .length = 3},
  [114] = {.index = 175, .length = 2},
  [115] = {.index = 177, .length = 3},
  [116] = {.index = 180, .length = 2},
  [117] = {.index = 19, .length = 2},
  [118] = {.index = 39, .length = 2},
  [119] = {.index = 182, .length = 2},
  [120] = {.index = 184, .length = 2},
  [121] = {.index = 186, .length = 1},
  [122] = {.index = 187, .length = 4},
  [123] = {.index = 191, .length = 4},
  [124] = {.index = 195, .length = 2},
  [125] = {.index = 197, .length = 3},
  [126] = {.index = 200, .length = 2},
  [127] = {.index = 202, .length = 2},
  [128] = {.index = 204, .length = 1},
  [129] = {.index = 205, .length = 2},
  [130] = {.index = 207, .length = 2},
  [131] = {.index = 209, .length = 3},
  [132] = {.index = 212, .length = 3},
  [133] = {.index = 215, .length = 3},
  [134] = {.index = 218, .length = 2},
  [135] = {.index = 218, .length = 2},
  [136] = {.index = 220, .length = 2},
  [137] = {.index = 222, .length = 3},
  [138] = {.index = 225, .length = 2},
  [139] = {.index = 227, .length = 2},
  [140] = {.index = 229, .length = 3},
  [141] = {.index = 232, .length = 2},
  [142] = {.index = 234, .length = 3},
  [143] = {.index = 237, .length = 2},
  [144] = {.index = 239, .length = 1},
  [145] = {.index = 240, .length = 2},
  [146] = {.index = 242, .length = 2},
  [147] = {.index = 244, .length = 4},
  [148] = {.index = 248, .length = 5},
  [149] = {.index = 253, .length = 1},
  [150] = {.index = 254, .length = 1},
  [151] = {.index = 255, .length = 2},
  [152] = {.index = 257, .length = 1},
  [154] = {.index = 258, .length = 1},
  [155] = {.index = 259, .length = 2},
  [156] = {.index = 261, .length = 2},
  [157] = {.index = 11, .length = 1},
  [158] = {.index = 11, .length = 1},
  [159] = {.index = 263, .length = 2},
  [160] = {.index = 265, .length = 1},
  [161] = {.index = 266, .length = 1},
  [162] = {.index = 267, .length = 4},
  [163] = {.index = 271, .length = 2},
  [164] = {.index = 273, .length = 4},
  [165] = {.index = 277, .length = 1},
  [166] = {.index = 278, .length = 3},
  [167] = {.index = 281, .length = 2},
  [168] = {.index = 283, .length = 3},
  [169] = {.index = 286, .length = 1},
  [170] = {.index = 287, .length = 5},
  [171] = {.index = 292, .length = 2},
  [172] = {.index = 294, .length = 2},
  [173] = {.index = 296, .length = 4},
  [174] = {.index = 300, .length = 2},
  [175] = {.index = 302, .length = 3},
  [176] = {.index = 305, .length = 4},
  [177] = {.index = 309, .length = 4},
  [178] = {.index = 313, .length = 3},
  [179] = {.index = 316, .length = 2},
  [180] = {.index = 318, .length = 3},
  [181] = {.index = 321, .length = 3},
  [182] = {.index = 324, .length = 2},
  [183] = {.index = 326, .length = 2},
  [184] = {.index = 328, .length = 2},
  [185] = {.index = 330, .length = 2},
  [186] = {.index = 332, .length = 3},
  [187] = {.index = 335, .length = 2},
  [188] = {.index = 337, .length = 2},
  [189] = {.index = 339, .length = 3},
  [190] = {.index = 342, .length = 2},
  [191] = {.index = 344, .length = 2},
  [192] = {.index = 346, .length = 2},
  [193] = {.index = 348, .length = 4},
  [194] = {.index = 352, .length = 5},
  [195] = {.index = 357, .length = 3},
  [196] = {.index = 360, .length = 4},
  [197] = {.index = 364, .length = 2},
  [198] = {.index = 366, .length = 1},
  [199] = {.index = 367, .length = 4},
  [200] = {.index = 371, .length = 3},
  [201] = {.index = 374, .length = 2},
  [202] = {.index = 376, .length = 1},
  [203] = {.index = 377, .length = 5},
  [204] = {.index = 382, .length = 2},
  [205] = {.index = 384, .length = 2},
  [206] = {.index = 65, .length = 1},
  [207] = {.index = 386, .length = 5},
  [208] = {.index = 391, .length = 4},
  [209] = {.index = 395, .length = 2},
  [210] = {.index = 397, .length = 2},
  [211] = {.index = 399, .length = 5},
  [212] = {.index = 404, .length = 2},
  [213] = {.index = 406, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_type, 0},
  [1] =
    {field_directive, 0},
  [2] =
    {field_argument, 1},
    {field_operator, 0},
  [4] =
    {field_declarator, 1},
  [5] =
    {field_name, 0},
  [6] =
    {field_arguments, 1},
    {field_function, 0},
  [8] =
    {field_type, 0},
    {field_value, 1},
  [10] =
    {field_body, 1},
  [11] =
    {field_name, 1},
  [12] =
    {field_body, 0},
  [13] =
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [15] =
    {field_body, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [17] =
    {field_value, 1},
  [18] =
    {field_scope, 0},
  [19] =
    {field_arguments, 1},
    {field_name, 0},
  [21] =
    {field_type, 1},
  [22] =
    {field_requirements, 1},
  [23] =
    {field_constraint, 1},
  [24] =
    {field_parameters, 0},
  [25] =
    {field_declarator, 0},
    {field_parameters, 1, .inherited = true},
  [27] =
    {field_body, 1},
    {field_declarator, 0},
  [29] =
    {field_declarator, 0},
  [30] =
    {field_constraint, 0},
  [31] =
    {field_pattern, 0},
  [32] =
    {field_argument, 0},
    {field_operator, 1},
  [34] =
    {field_argument, 0},
    {field_indices, 1},
  [36] =
    {field_body, 1},
    {field_captures, 0},
  [38] =
    {field_parameters, 0, .inherited = true},
  [39] =
    {field_name, 1},
    {field_scope, 0, .inherited = true},
  [41] =
    {field_path, 1},
  [42] =
    {field_argument, 1},
    {field_directive, 0},
  [44] =
    {field_declarator, 1},
    {field_type, 0},
  [46] =
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
  [49] =
    {field_declarator, 2},
  [50] =
    {field_body, 2},
    {field_value, 1},
  [52] =
    {field_type, 2},
  [53] =
    {field_body, 2},
  [54] =
    {field_name, 2},
  [55] =
    {field_body, 2},
    {field_name, 1},
  [57] =
    {field_base, 2, .inherited = true},
    {field_name, 1},
  [59] =
    {field_body, 1},
    {field_name, 0},
  [61] =
    {field_condition, 1},
    {field_consequence, 2},
  [63] =
    {field_body, 2},
    {field_condition, 1},
  [65] =
    {field_label, 1},
  [66] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [69] =
    {field_label, 0},
  [70] =
    {field_type, 0, .inherited = true},
  [71] =
    {field_parameters, 1},
  [72] =
    {field_declarator, 2},
    {field_type, 1, .inherited = true},
  [74] =
    {field_arguments, 2},
    {field_type, 1},
  [76] =
    {field_declarator, 2},
    {field_type, 1},
  [78] =
    {field_placement, 1},
    {field_type, 2},
  [80] =
    {field_parameters, 1},
    {field_requirements, 2},
  [82] =
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [84] =
    {field_body, 2},
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [87] =
    {field_declarator, 0},
    {field_value, 1},
  [89] =
    {field_body, 2},
    {field_declarator, 0},
  [91] =
    {field_argument, 0},
    {field_field, 2},
    {field_operator, 1},
  [94] =
    {field_body, 2},
    {field_captures, 0},
    {field_declarator, 1},
  [97] =
    {field_body, 2},
    {field_captures, 0},
    {field_template_parameters, 1},
  [100] =
    {field_name, 1},
    {field_name, 2},
    {field_scope, 0, .inherited = true},
  [103] =
    {field_body, 2},
    {field_declarator, 1},
  [105] =
    {field_name, 1},
    {field_value, 2},
  [107] =
    {field_name, 1},
    {field_parameters, 2},
  [109] =
    {field_condition, 1},
  [110] =
    {field_alternative, 2},
    {field_name, 1},
  [112] =
    {field_declarator, 2},
    {field_type, 0},
  [114] =
    {field_left, 0},
    {field_right, 2},
  [116] =
    {field_left, 0},
    {field_operator, 1, .inherited = true},
    {field_right, 2},
  [119] =
    {field_type, 1},
    {field_value, 3},
  [121] =
    {field_declarator, 3},
  [122] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [124] =
    {field_declarator, 0},
    {field_parameters, 1},
  [126] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [128] =
    {field_arguments, 3},
    {field_type, 2},
  [130] =
    {field_declarator, 3},
    {field_type, 2},
  [132] =
    {field_placement, 2},
    {field_type, 3},
  [134] =
    {field_name, 2},
    {field_prefix, 0},
  [136] =
    {field_body, 3},
    {field_name, 2},
  [138] =
    {field_base, 3, .inherited = true},
    {field_name, 2},
  [140] =
    {field_base, 1},
  [141] =
    {field_base, 2, .inherited = true},
    {field_body, 3},
    {field_name, 1},
  [144] =
    {field_body, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [146] =
    {field_body, 2},
    {field_name, 0},
  [148] =
    {field_condition, 2},
    {field_consequence, 3},
  [150] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [153] =
    {field_initializer, 0},
  [154] =
    {field_assembly_code, 2},
  [155] =
    {field_arguments, 3},
    {field_declarator, 2},
    {field_type, 1},
  [158] =
    {field_arguments, 3},
    {field_placement, 1},
    {field_type, 2},
  [161] =
    {field_declarator, 3},
    {field_placement, 1},
    {field_type, 2},
  [164] =
    {field_body, 3},
    {field_declarator, 2},
    {field_type, 0, .inherited = true},
  [167] =
    {field_declarator, 0},
    {field_value, 2},
  [169] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_type, 0, .inherited = true},
  [172] =
    {field_declarator, 1},
    {field_declarator, 2, .inherited = true},
    {field_type, 0, .inherited = true},
  [175] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [177] =
    {field_body, 3},
    {field_declarator, 2},
    {field_type, 1, .inherited = true},
  [180] =
    {field_declarator, 0},
    {field_size, 2},
  [182] =
    {field_alternative, 3},
    {field_condition, 0},
  [184] =
    {field_declarator, 0},
    {field_default_value, 2},
  [186] =
    {field_size, 1},
  [187] =
    {field_body, 3},
    {field_captures, 0},
    {field_declarator, 2},
    {field_template_parameters, 1},
  [191] =
    {field_body, 3},
    {field_captures, 0},
    {field_constraint, 2},
    {field_template_parameters, 1},
  [195] =
    {field_body, 3},
    {field_declarator, 1},
  [197] =
    {field_name, 1},
    {field_parameters, 2},
    {field_value, 3},
  [200] =
    {field_alternative, 3},
    {field_condition, 1},
  [202] =
    {field_alternative, 3},
    {field_name, 1},
  [204] =
    {field_operator, 0},
  [205] =
    {field_declarator, 3},
    {field_type, 1},
  [207] =
    {field_declarator, 3, .inherited = true},
    {field_type, 2, .inherited = true},
  [209] =
    {field_arguments, 4},
    {field_declarator, 3},
    {field_type, 2},
  [212] =
    {field_arguments, 4},
    {field_placement, 2},
    {field_type, 3},
  [215] =
    {field_declarator, 4},
    {field_placement, 2},
    {field_type, 3},
  [218] =
    {field_designator, 0},
    {field_value, 2},
  [220] =
    {field_name, 0},
    {field_value, 2},
  [222] =
    {field_base, 3, .inherited = true},
    {field_body, 4},
    {field_name, 2},
  [225] =
    {field_body, 3},
    {field_name, 0},
  [227] =
    {field_body, 3, .inherited = true},
    {field_name, 3, .inherited = true},
  [229] =
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
    {field_value, 2},
  [232] =
    {field_initializer, 1},
    {field_value, 2},
  [234] =
    {field_alternative, 4},
    {field_condition, 2},
    {field_consequence, 3},
  [237] =
    {field_body, 1},
    {field_condition, 3},
  [239] =
    {field_update, 2},
  [240] =
    {field_initializer, 0},
    {field_update, 2},
  [242] =
    {field_condition, 1},
    {field_initializer, 0},
  [244] =
    {field_body, 4},
    {field_condition, 2, .inherited = true},
    {field_initializer, 2, .inherited = true},
    {field_update, 2, .inherited = true},
  [248] =
    {field_body, 4},
    {field_declarator, 2, .inherited = true},
    {field_initializer, 2, .inherited = true},
    {field_right, 2, .inherited = true},
    {field_type, 2, .inherited = true},
  [253] =
    {field_value, 3},
  [254] =
    {field_operand, 1},
  [255] =
    {field_assembly_code, 2},
    {field_output_operands, 3},
  [257] =
    {field_assembly_code, 3},
  [258] =
    {field_default_type, 2},
  [259] =
    {field_default_value, 2},
    {field_type, 0, .inherited = true},
  [261] =
    {field_body, 2},
    {field_parameters, 1},
  [263] =
    {field_name, 1},
    {field_type, 3},
  [265] =
    {field_condition, 2},
  [266] =
    {field_length, 1},
  [267] =
    {field_arguments, 4},
    {field_declarator, 3},
    {field_placement, 1},
    {field_type, 2},
  [271] =
    {field_declarator, 1},
    {field_declarator, 2},
  [273] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_declarator, 3, .inherited = true},
    {field_type, 0, .inherited = true},
  [277] =
    {field_declarator, 4},
  [278] =
    {field_body, 4},
    {field_declarator, 3},
    {field_type, 1, .inherited = true},
  [281] =
    {field_declarator, 0},
    {field_size, 3},
  [283] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [286] =
    {field_size, 2},
  [287] =
    {field_body, 4},
    {field_captures, 0},
    {field_constraint, 2},
    {field_declarator, 3},
    {field_template_parameters, 1},
  [292] =
    {field_declarator, 1},
    {field_default_value, 3},
  [294] =
    {field_alternative, 4},
    {field_condition, 1},
  [296] =
    {field_arguments, 5},
    {field_declarator, 4},
    {field_placement, 2},
    {field_type, 3},
  [300] =
    {field_body, 2},
    {field_filter, 1},
  [302] =
    {field_declarator, 1},
    {field_default_value, 2},
    {field_type, 0, .inherited = true},
  [305] =
    {field_declarator, 1},
    {field_declarator, 2, .inherited = true},
    {field_default_value, 2, .inherited = true},
    {field_type, 0, .inherited = true},
  [309] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
    {field_default_value, 0, .inherited = true},
    {field_default_value, 1, .inherited = true},
  [313] =
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
    {field_value, 3},
  [316] =
    {field_condition, 1},
    {field_update, 3},
  [318] =
    {field_condition, 1},
    {field_initializer, 0},
    {field_update, 3},
  [321] =
    {field_declarator, 1},
    {field_right, 3},
    {field_type, 0, .inherited = true},
  [324] =
    {field_initializer, 0},
    {field_update, 3},
  [326] =
    {field_condition, 2},
    {field_initializer, 0},
  [328] =
    {field_member, 4},
    {field_type, 2},
  [330] =
    {field_operand, 1},
    {field_operand, 2, .inherited = true},
  [332] =
    {field_assembly_code, 2},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [335] =
    {field_assembly_code, 3},
    {field_output_operands, 4},
  [337] =
    {field_default_type, 3},
    {field_name, 1},
  [339] =
    {field_declarator, 1},
    {field_default_value, 3},
    {field_type, 0, .inherited = true},
  [342] =
    {field_name, 1},
    {field_type, 4},
  [344] =
    {field_end, 3},
    {field_start, 1},
  [346] =
    {field_declarator, 1},
    {field_default_value, 2},
  [348] =
    {field_declarator, 1},
    {field_declarator, 3, .inherited = true},
    {field_default_value, 3, .inherited = true},
    {field_type, 0, .inherited = true},
  [352] =
    {field_declarator, 1},
    {field_declarator, 3, .inherited = true},
    {field_default_value, 2},
    {field_default_value, 3, .inherited = true},
    {field_type, 0, .inherited = true},
  [357] =
    {field_condition, 2},
    {field_initializer, 0},
    {field_update, 4},
  [360] =
    {field_declarator, 2},
    {field_initializer, 0},
    {field_right, 4},
    {field_type, 1, .inherited = true},
  [364] =
    {field_operand, 0, .inherited = true},
    {field_operand, 1, .inherited = true},
  [366] =
    {field_register, 1},
  [367] =
    {field_assembly_code, 2},
    {field_clobbers, 5},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [371] =
    {field_assembly_code, 3},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [374] =
    {field_condition, 2},
    {field_message, 4},
  [376] =
    {field_delimiter, 1},
  [377] =
    {field_declarator, 1},
    {field_declarator, 4, .inherited = true},
    {field_default_value, 3},
    {field_default_value, 4, .inherited = true},
    {field_type, 0, .inherited = true},
  [382] =
    {field_constraint, 0},
    {field_value, 2},
  [384] =
    {field_register, 1},
    {field_register, 2, .inherited = true},
  [386] =
    {field_assembly_code, 2},
    {field_clobbers, 5},
    {field_goto_labels, 6},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [391] =
    {field_assembly_code, 3},
    {field_clobbers, 6},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [395] =
    {field_register, 0, .inherited = true},
    {field_register, 1, .inherited = true},
  [397] =
    {field_label, 1},
    {field_label, 2, .inherited = true},
  [399] =
    {field_assembly_code, 3},
    {field_clobbers, 6},
    {field_goto_labels, 7},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [404] =
    {field_label, 0, .inherited = true},
    {field_label, 1, .inherited = true},
  [406] =
    {field_constraint, 3},
    {field_symbol, 1},
    {field_value, 5},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [15] = {
    [0] = alias_sym_namespace_identifier,
  },
  [16] = {
    [0] = alias_sym_type_identifier,
  },
  [18] = {
    [0] = alias_sym_type_identifier,
  },
  [19] = {
    [0] = alias_sym_namespace_identifier,
  },
  [35] = {
    [1] = alias_sym_type_identifier,
  },
  [36] = {
    [1] = alias_sym_type_identifier,
  },
  [42] = {
    [0] = sym_primitive_type,
  },
  [43] = {
    [0] = sym_pointer_declarator,
  },
  [53] = {
    [1] = alias_sym_statement_identifier,
  },
  [55] = {
    [0] = alias_sym_statement_identifier,
  },
  [59] = {
    [1] = alias_sym_namespace_identifier,
  },
  [60] = {
    [1] = alias_sym_namespace_identifier,
  },
  [64] = {
    [0] = alias_sym_simple_requirement,
  },
  [70] = {
    [2] = alias_sym_field_identifier,
  },
  [92] = {
    [2] = alias_sym_namespace_identifier,
  },
  [94] = {
    [1] = alias_sym_field_identifier,
  },
  [97] = {
    [1] = alias_sym_type_identifier,
  },
  [99] = {
    [0] = alias_sym_field_identifier,
  },
  [106] = {
    [1] = alias_sym_type_identifier,
  },
  [117] = {
    [0] = alias_sym_field_identifier,
  },
  [118] = {
    [1] = alias_sym_field_identifier,
  },
  [134] = {
    [0] = alias_sym_field_identifier,
  },
  [153] = {
    [2] = alias_sym_type_identifier,
  },
  [157] = {
    [1] = alias_sym_namespace_identifier,
    [3] = alias_sym_namespace_identifier,
  },
  [158] = {
    [1] = alias_sym_namespace_identifier,
  },
  [159] = {
    [1] = alias_sym_type_identifier,
  },
  [184] = {
    [4] = alias_sym_field_identifier,
  },
  [188] = {
    [1] = alias_sym_type_identifier,
  },
  [190] = {
    [1] = alias_sym_type_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_pointer_type_declarator, 2,
    sym_pointer_type_declarator,
    sym_pointer_declarator,
  sym_expression_statement, 2,
    sym_expression_statement,
    alias_sym_simple_requirement,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 2,
  [6] = 2,
  [7] = 2,
  [8] = 2,
  [9] = 2,
  [10] = 2,
  [11] = 2,
  [12] = 2,
  [13] = 2,
  [14] = 2,
  [15] = 2,
  [16] = 16,
  [17] = 17,
  [18] = 17,
  [19] = 17,
  [20] = 17,
  [21] = 16,
  [22] = 16,
  [23] = 17,
  [24] = 16,
  [25] = 16,
  [26] = 26,
  [27] = 26,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 30,
  [32] = 32,
  [33] = 33,
  [34] = 30,
  [35] = 26,
  [36] = 30,
  [37] = 26,
  [38] = 38,
  [39] = 30,
  [40] = 26,
  [41] = 38,
  [42] = 42,
  [43] = 43,
  [44] = 43,
  [45] = 43,
  [46] = 42,
  [47] = 47,
  [48] = 42,
  [49] = 43,
  [50] = 43,
  [51] = 47,
  [52] = 42,
  [53] = 43,
  [54] = 54,
  [55] = 43,
  [56] = 42,
  [57] = 43,
  [58] = 42,
  [59] = 43,
  [60] = 43,
  [61] = 42,
  [62] = 42,
  [63] = 42,
  [64] = 42,
  [65] = 54,
  [66] = 43,
  [67] = 47,
  [68] = 43,
  [69] = 43,
  [70] = 38,
  [71] = 42,
  [72] = 42,
  [73] = 38,
  [74] = 42,
  [75] = 42,
  [76] = 43,
  [77] = 42,
  [78] = 54,
  [79] = 42,
  [80] = 43,
  [81] = 42,
  [82] = 43,
  [83] = 43,
  [84] = 43,
  [85] = 85,
  [86] = 43,
  [87] = 42,
  [88] = 47,
  [89] = 42,
  [90] = 42,
  [91] = 43,
  [92] = 43,
  [93] = 54,
  [94] = 94,
  [95] = 47,
  [96] = 54,
  [97] = 42,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 103,
  [106] = 104,
  [107] = 100,
  [108] = 102,
  [109] = 101,
  [110] = 101,
  [111] = 101,
  [112] = 102,
  [113] = 104,
  [114] = 102,
  [115] = 100,
  [116] = 103,
  [117] = 104,
  [118] = 103,
  [119] = 101,
  [120] = 102,
  [121] = 100,
  [122] = 104,
  [123] = 100,
  [124] = 103,
  [125] = 102,
  [126] = 104,
  [127] = 100,
  [128] = 101,
  [129] = 103,
  [130] = 130,
  [131] = 130,
  [132] = 130,
  [133] = 130,
  [134] = 130,
  [135] = 130,
  [136] = 130,
  [137] = 137,
  [138] = 138,
  [139] = 138,
  [140] = 138,
  [141] = 138,
  [142] = 138,
  [143] = 138,
  [144] = 138,
  [145] = 138,
  [146] = 146,
  [147] = 147,
  [148] = 147,
  [149] = 147,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 151,
  [154] = 154,
  [155] = 151,
  [156] = 156,
  [157] = 151,
  [158] = 151,
  [159] = 159,
  [160] = 160,
  [161] = 159,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 165,
  [167] = 163,
  [168] = 160,
  [169] = 160,
  [170] = 170,
  [171] = 159,
  [172] = 170,
  [173] = 163,
  [174] = 162,
  [175] = 175,
  [176] = 175,
  [177] = 160,
  [178] = 164,
  [179] = 179,
  [180] = 170,
  [181] = 181,
  [182] = 170,
  [183] = 160,
  [184] = 163,
  [185] = 151,
  [186] = 162,
  [187] = 175,
  [188] = 151,
  [189] = 159,
  [190] = 181,
  [191] = 175,
  [192] = 181,
  [193] = 179,
  [194] = 165,
  [195] = 164,
  [196] = 164,
  [197] = 165,
  [198] = 159,
  [199] = 179,
  [200] = 181,
  [201] = 160,
  [202] = 170,
  [203] = 163,
  [204] = 162,
  [205] = 175,
  [206] = 179,
  [207] = 165,
  [208] = 170,
  [209] = 164,
  [210] = 159,
  [211] = 179,
  [212] = 181,
  [213] = 175,
  [214] = 165,
  [215] = 179,
  [216] = 165,
  [217] = 162,
  [218] = 164,
  [219] = 164,
  [220] = 163,
  [221] = 160,
  [222] = 181,
  [223] = 159,
  [224] = 163,
  [225] = 179,
  [226] = 181,
  [227] = 162,
  [228] = 175,
  [229] = 162,
  [230] = 230,
  [231] = 151,
  [232] = 232,
  [233] = 233,
  [234] = 233,
  [235] = 233,
  [236] = 233,
  [237] = 237,
  [238] = 237,
  [239] = 233,
  [240] = 233,
  [241] = 237,
  [242] = 237,
  [243] = 233,
  [244] = 244,
  [245] = 233,
  [246] = 237,
  [247] = 237,
  [248] = 237,
  [249] = 237,
  [250] = 233,
  [251] = 237,
  [252] = 237,
  [253] = 253,
  [254] = 233,
  [255] = 237,
  [256] = 237,
  [257] = 233,
  [258] = 233,
  [259] = 233,
  [260] = 237,
  [261] = 233,
  [262] = 237,
  [263] = 237,
  [264] = 233,
  [265] = 154,
  [266] = 266,
  [267] = 152,
  [268] = 230,
  [269] = 232,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 253,
  [283] = 283,
  [284] = 244,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 266,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 230,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 271,
  [376] = 376,
  [377] = 232,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 354,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 360,
  [390] = 360,
  [391] = 354,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 354,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 270,
  [405] = 232,
  [406] = 406,
  [407] = 407,
  [408] = 230,
  [409] = 230,
  [410] = 410,
  [411] = 154,
  [412] = 152,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 360,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 232,
  [438] = 335,
  [439] = 302,
  [440] = 334,
  [441] = 441,
  [442] = 320,
  [443] = 322,
  [444] = 323,
  [445] = 331,
  [446] = 330,
  [447] = 329,
  [448] = 328,
  [449] = 327,
  [450] = 326,
  [451] = 325,
  [452] = 283,
  [453] = 324,
  [454] = 321,
  [455] = 285,
  [456] = 319,
  [457] = 338,
  [458] = 318,
  [459] = 441,
  [460] = 340,
  [461] = 313,
  [462] = 312,
  [463] = 333,
  [464] = 311,
  [465] = 253,
  [466] = 244,
  [467] = 310,
  [468] = 309,
  [469] = 253,
  [470] = 308,
  [471] = 305,
  [472] = 307,
  [473] = 342,
  [474] = 337,
  [475] = 304,
  [476] = 299,
  [477] = 441,
  [478] = 303,
  [479] = 275,
  [480] = 341,
  [481] = 343,
  [482] = 298,
  [483] = 344,
  [484] = 277,
  [485] = 279,
  [486] = 280,
  [487] = 441,
  [488] = 297,
  [489] = 441,
  [490] = 441,
  [491] = 296,
  [492] = 244,
  [493] = 339,
  [494] = 295,
  [495] = 317,
  [496] = 291,
  [497] = 336,
  [498] = 290,
  [499] = 289,
  [500] = 332,
  [501] = 316,
  [502] = 278,
  [503] = 315,
  [504] = 286,
  [505] = 273,
  [506] = 314,
  [507] = 306,
  [508] = 274,
  [509] = 441,
  [510] = 272,
  [511] = 281,
  [512] = 288,
  [513] = 345,
  [514] = 292,
  [515] = 301,
  [516] = 276,
  [517] = 346,
  [518] = 347,
  [519] = 294,
  [520] = 441,
  [521] = 441,
  [522] = 293,
  [523] = 348,
  [524] = 350,
  [525] = 349,
  [526] = 441,
  [527] = 441,
  [528] = 441,
  [529] = 441,
  [530] = 441,
  [531] = 300,
  [532] = 441,
  [533] = 441,
  [534] = 441,
  [535] = 441,
  [536] = 287,
  [537] = 441,
  [538] = 436,
  [539] = 416,
  [540] = 355,
  [541] = 379,
  [542] = 394,
  [543] = 418,
  [544] = 393,
  [545] = 357,
  [546] = 380,
  [547] = 385,
  [548] = 378,
  [549] = 266,
  [550] = 376,
  [551] = 374,
  [552] = 384,
  [553] = 373,
  [554] = 366,
  [555] = 270,
  [556] = 387,
  [557] = 406,
  [558] = 388,
  [559] = 435,
  [560] = 434,
  [561] = 410,
  [562] = 365,
  [563] = 352,
  [564] = 403,
  [565] = 402,
  [566] = 401,
  [567] = 400,
  [568] = 407,
  [569] = 415,
  [570] = 417,
  [571] = 419,
  [572] = 422,
  [573] = 270,
  [574] = 425,
  [575] = 152,
  [576] = 399,
  [577] = 392,
  [578] = 414,
  [579] = 423,
  [580] = 426,
  [581] = 427,
  [582] = 154,
  [583] = 429,
  [584] = 430,
  [585] = 431,
  [586] = 266,
  [587] = 266,
  [588] = 362,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 152,
  [593] = 270,
  [594] = 154,
  [595] = 433,
  [596] = 271,
  [597] = 397,
  [598] = 421,
  [599] = 386,
  [600] = 364,
  [601] = 396,
  [602] = 398,
  [603] = 363,
  [604] = 271,
  [605] = 356,
  [606] = 358,
  [607] = 359,
  [608] = 353,
  [609] = 361,
  [610] = 432,
  [611] = 413,
  [612] = 590,
  [613] = 420,
  [614] = 271,
  [615] = 368,
  [616] = 369,
  [617] = 370,
  [618] = 371,
  [619] = 372,
  [620] = 317,
  [621] = 298,
  [622] = 340,
  [623] = 274,
  [624] = 273,
  [625] = 286,
  [626] = 278,
  [627] = 332,
  [628] = 289,
  [629] = 290,
  [630] = 291,
  [631] = 295,
  [632] = 296,
  [633] = 297,
  [634] = 302,
  [635] = 301,
  [636] = 303,
  [637] = 304,
  [638] = 305,
  [639] = 308,
  [640] = 309,
  [641] = 310,
  [642] = 311,
  [643] = 312,
  [644] = 313,
  [645] = 318,
  [646] = 319,
  [647] = 321,
  [648] = 324,
  [649] = 325,
  [650] = 326,
  [651] = 327,
  [652] = 294,
  [653] = 293,
  [654] = 328,
  [655] = 329,
  [656] = 330,
  [657] = 331,
  [658] = 334,
  [659] = 336,
  [660] = 306,
  [661] = 342,
  [662] = 349,
  [663] = 350,
  [664] = 348,
  [665] = 347,
  [666] = 346,
  [667] = 281,
  [668] = 345,
  [669] = 344,
  [670] = 343,
  [671] = 276,
  [672] = 283,
  [673] = 275,
  [674] = 307,
  [675] = 292,
  [676] = 340,
  [677] = 275,
  [678] = 276,
  [679] = 338,
  [680] = 285,
  [681] = 681,
  [682] = 288,
  [683] = 683,
  [684] = 283,
  [685] = 283,
  [686] = 335,
  [687] = 337,
  [688] = 275,
  [689] = 689,
  [690] = 341,
  [691] = 323,
  [692] = 322,
  [693] = 320,
  [694] = 337,
  [695] = 335,
  [696] = 288,
  [697] = 292,
  [698] = 272,
  [699] = 699,
  [700] = 700,
  [701] = 276,
  [702] = 314,
  [703] = 281,
  [704] = 272,
  [705] = 274,
  [706] = 273,
  [707] = 281,
  [708] = 315,
  [709] = 286,
  [710] = 278,
  [711] = 332,
  [712] = 289,
  [713] = 290,
  [714] = 291,
  [715] = 295,
  [716] = 296,
  [717] = 272,
  [718] = 297,
  [719] = 302,
  [720] = 303,
  [721] = 304,
  [722] = 681,
  [723] = 305,
  [724] = 308,
  [725] = 689,
  [726] = 274,
  [727] = 273,
  [728] = 309,
  [729] = 310,
  [730] = 311,
  [731] = 312,
  [732] = 313,
  [733] = 318,
  [734] = 286,
  [735] = 278,
  [736] = 319,
  [737] = 332,
  [738] = 321,
  [739] = 289,
  [740] = 316,
  [741] = 290,
  [742] = 324,
  [743] = 325,
  [744] = 326,
  [745] = 291,
  [746] = 327,
  [747] = 317,
  [748] = 328,
  [749] = 295,
  [750] = 296,
  [751] = 329,
  [752] = 330,
  [753] = 331,
  [754] = 754,
  [755] = 334,
  [756] = 336,
  [757] = 342,
  [758] = 349,
  [759] = 297,
  [760] = 350,
  [761] = 348,
  [762] = 347,
  [763] = 346,
  [764] = 302,
  [765] = 303,
  [766] = 304,
  [767] = 305,
  [768] = 308,
  [769] = 345,
  [770] = 309,
  [771] = 310,
  [772] = 311,
  [773] = 312,
  [774] = 313,
  [775] = 318,
  [776] = 323,
  [777] = 344,
  [778] = 343,
  [779] = 319,
  [780] = 322,
  [781] = 285,
  [782] = 321,
  [783] = 320,
  [784] = 324,
  [785] = 325,
  [786] = 341,
  [787] = 326,
  [788] = 327,
  [789] = 337,
  [790] = 335,
  [791] = 328,
  [792] = 329,
  [793] = 330,
  [794] = 331,
  [795] = 334,
  [796] = 336,
  [797] = 342,
  [798] = 349,
  [799] = 350,
  [800] = 348,
  [801] = 347,
  [802] = 346,
  [803] = 345,
  [804] = 344,
  [805] = 343,
  [806] = 681,
  [807] = 323,
  [808] = 322,
  [809] = 689,
  [810] = 341,
  [811] = 287,
  [812] = 320,
  [813] = 300,
  [814] = 285,
  [815] = 293,
  [816] = 294,
  [817] = 280,
  [818] = 279,
  [819] = 277,
  [820] = 301,
  [821] = 298,
  [822] = 299,
  [823] = 306,
  [824] = 314,
  [825] = 315,
  [826] = 316,
  [827] = 317,
  [828] = 339,
  [829] = 280,
  [830] = 287,
  [831] = 333,
  [832] = 279,
  [833] = 333,
  [834] = 333,
  [835] = 299,
  [836] = 277,
  [837] = 298,
  [838] = 277,
  [839] = 279,
  [840] = 287,
  [841] = 841,
  [842] = 280,
  [843] = 339,
  [844] = 338,
  [845] = 339,
  [846] = 338,
  [847] = 689,
  [848] = 300,
  [849] = 681,
  [850] = 340,
  [851] = 316,
  [852] = 307,
  [853] = 315,
  [854] = 307,
  [855] = 314,
  [856] = 306,
  [857] = 301,
  [858] = 294,
  [859] = 293,
  [860] = 292,
  [861] = 288,
  [862] = 299,
  [863] = 300,
  [864] = 402,
  [865] = 413,
  [866] = 426,
  [867] = 423,
  [868] = 426,
  [869] = 414,
  [870] = 423,
  [871] = 425,
  [872] = 358,
  [873] = 340,
  [874] = 429,
  [875] = 430,
  [876] = 356,
  [877] = 431,
  [878] = 387,
  [879] = 416,
  [880] = 429,
  [881] = 414,
  [882] = 352,
  [883] = 430,
  [884] = 435,
  [885] = 356,
  [886] = 431,
  [887] = 410,
  [888] = 403,
  [889] = 384,
  [890] = 372,
  [891] = 371,
  [892] = 435,
  [893] = 394,
  [894] = 355,
  [895] = 436,
  [896] = 370,
  [897] = 402,
  [898] = 401,
  [899] = 400,
  [900] = 399,
  [901] = 357,
  [902] = 352,
  [903] = 392,
  [904] = 379,
  [905] = 380,
  [906] = 398,
  [907] = 406,
  [908] = 388,
  [909] = 369,
  [910] = 368,
  [911] = 396,
  [912] = 434,
  [913] = 427,
  [914] = 244,
  [915] = 407,
  [916] = 415,
  [917] = 417,
  [918] = 419,
  [919] = 422,
  [920] = 425,
  [921] = 433,
  [922] = 421,
  [923] = 362,
  [924] = 413,
  [925] = 422,
  [926] = 421,
  [927] = 420,
  [928] = 427,
  [929] = 420,
  [930] = 364,
  [931] = 361,
  [932] = 419,
  [933] = 436,
  [934] = 432,
  [935] = 363,
  [936] = 365,
  [937] = 368,
  [938] = 418,
  [939] = 369,
  [940] = 370,
  [941] = 432,
  [942] = 417,
  [943] = 371,
  [944] = 372,
  [945] = 373,
  [946] = 366,
  [947] = 394,
  [948] = 353,
  [949] = 374,
  [950] = 415,
  [951] = 363,
  [952] = 365,
  [953] = 433,
  [954] = 397,
  [955] = 364,
  [956] = 366,
  [957] = 355,
  [958] = 386,
  [959] = 359,
  [960] = 373,
  [961] = 374,
  [962] = 393,
  [963] = 387,
  [964] = 359,
  [965] = 385,
  [966] = 353,
  [967] = 376,
  [968] = 361,
  [969] = 384,
  [970] = 379,
  [971] = 380,
  [972] = 362,
  [973] = 378,
  [974] = 385,
  [975] = 386,
  [976] = 406,
  [977] = 388,
  [978] = 393,
  [979] = 253,
  [980] = 416,
  [981] = 378,
  [982] = 418,
  [983] = 410,
  [984] = 397,
  [985] = 434,
  [986] = 151,
  [987] = 392,
  [988] = 358,
  [989] = 357,
  [990] = 376,
  [991] = 399,
  [992] = 400,
  [993] = 401,
  [994] = 396,
  [995] = 407,
  [996] = 398,
  [997] = 403,
  [998] = 394,
  [999] = 434,
  [1000] = 841,
  [1001] = 151,
  [1002] = 151,
  [1003] = 1003,
  [1004] = 430,
  [1005] = 365,
  [1006] = 366,
  [1007] = 417,
  [1008] = 1003,
  [1009] = 415,
  [1010] = 1010,
  [1011] = 363,
  [1012] = 368,
  [1013] = 392,
  [1014] = 1003,
  [1015] = 353,
  [1016] = 151,
  [1017] = 364,
  [1018] = 1003,
  [1019] = 1010,
  [1020] = 352,
  [1021] = 359,
  [1022] = 419,
  [1023] = 393,
  [1024] = 355,
  [1025] = 387,
  [1026] = 369,
  [1027] = 397,
  [1028] = 418,
  [1029] = 385,
  [1030] = 1003,
  [1031] = 416,
  [1032] = 1003,
  [1033] = 399,
  [1034] = 384,
  [1035] = 403,
  [1036] = 1010,
  [1037] = 370,
  [1038] = 1010,
  [1039] = 413,
  [1040] = 420,
  [1041] = 407,
  [1042] = 421,
  [1043] = 1003,
  [1044] = 433,
  [1045] = 1003,
  [1046] = 422,
  [1047] = 1010,
  [1048] = 425,
  [1049] = 362,
  [1050] = 841,
  [1051] = 356,
  [1052] = 1010,
  [1053] = 388,
  [1054] = 410,
  [1055] = 358,
  [1056] = 379,
  [1057] = 380,
  [1058] = 1010,
  [1059] = 1059,
  [1060] = 1003,
  [1061] = 1003,
  [1062] = 841,
  [1063] = 357,
  [1064] = 436,
  [1065] = 1065,
  [1066] = 1010,
  [1067] = 406,
  [1068] = 378,
  [1069] = 376,
  [1070] = 386,
  [1071] = 1010,
  [1072] = 432,
  [1073] = 400,
  [1074] = 1010,
  [1075] = 414,
  [1076] = 398,
  [1077] = 396,
  [1078] = 371,
  [1079] = 435,
  [1080] = 372,
  [1081] = 431,
  [1082] = 361,
  [1083] = 374,
  [1084] = 373,
  [1085] = 1085,
  [1086] = 1003,
  [1087] = 401,
  [1088] = 402,
  [1089] = 429,
  [1090] = 427,
  [1091] = 426,
  [1092] = 1010,
  [1093] = 423,
  [1094] = 1010,
  [1095] = 1003,
  [1096] = 151,
  [1097] = 151,
  [1098] = 151,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1100,
  [1102] = 1102,
  [1103] = 1102,
  [1104] = 1102,
  [1105] = 1102,
  [1106] = 1102,
  [1107] = 1102,
  [1108] = 1102,
  [1109] = 1102,
  [1110] = 1102,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1113,
  [1115] = 1113,
  [1116] = 1113,
  [1117] = 1113,
  [1118] = 1113,
  [1119] = 1113,
  [1120] = 1113,
  [1121] = 1113,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 232,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1129,
  [1131] = 230,
  [1132] = 1132,
  [1133] = 1124,
  [1134] = 1124,
  [1135] = 1135,
  [1136] = 1125,
  [1137] = 1129,
  [1138] = 1138,
  [1139] = 1132,
  [1140] = 1124,
  [1141] = 1132,
  [1142] = 1124,
  [1143] = 1143,
  [1144] = 1144,
  [1145] = 1145,
  [1146] = 1128,
  [1147] = 1147,
  [1148] = 1132,
  [1149] = 1132,
  [1150] = 1145,
  [1151] = 1147,
  [1152] = 1129,
  [1153] = 1129,
  [1154] = 1154,
  [1155] = 1154,
  [1156] = 270,
  [1157] = 271,
  [1158] = 266,
  [1159] = 152,
  [1160] = 154,
  [1161] = 321,
  [1162] = 281,
  [1163] = 320,
  [1164] = 293,
  [1165] = 322,
  [1166] = 294,
  [1167] = 323,
  [1168] = 300,
  [1169] = 1112,
  [1170] = 283,
  [1171] = 287,
  [1172] = 301,
  [1173] = 288,
  [1174] = 306,
  [1175] = 314,
  [1176] = 292,
  [1177] = 315,
  [1178] = 316,
  [1179] = 317,
  [1180] = 339,
  [1181] = 333,
  [1182] = 299,
  [1183] = 285,
  [1184] = 1184,
  [1185] = 298,
  [1186] = 341,
  [1187] = 343,
  [1188] = 344,
  [1189] = 345,
  [1190] = 277,
  [1191] = 346,
  [1192] = 347,
  [1193] = 279,
  [1194] = 348,
  [1195] = 350,
  [1196] = 349,
  [1197] = 342,
  [1198] = 336,
  [1199] = 334,
  [1200] = 307,
  [1201] = 331,
  [1202] = 1123,
  [1203] = 330,
  [1204] = 329,
  [1205] = 328,
  [1206] = 327,
  [1207] = 326,
  [1208] = 325,
  [1209] = 324,
  [1210] = 335,
  [1211] = 319,
  [1212] = 318,
  [1213] = 313,
  [1214] = 312,
  [1215] = 311,
  [1216] = 310,
  [1217] = 309,
  [1218] = 308,
  [1219] = 305,
  [1220] = 304,
  [1221] = 303,
  [1222] = 302,
  [1223] = 297,
  [1224] = 1111,
  [1225] = 275,
  [1226] = 337,
  [1227] = 296,
  [1228] = 338,
  [1229] = 295,
  [1230] = 276,
  [1231] = 291,
  [1232] = 290,
  [1233] = 289,
  [1234] = 332,
  [1235] = 278,
  [1236] = 286,
  [1237] = 280,
  [1238] = 273,
  [1239] = 274,
  [1240] = 272,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 1241,
  [1244] = 1244,
  [1245] = 1241,
  [1246] = 1244,
  [1247] = 1244,
  [1248] = 1241,
  [1249] = 1241,
  [1250] = 1250,
  [1251] = 1250,
  [1252] = 1244,
  [1253] = 1253,
  [1254] = 1244,
  [1255] = 1244,
  [1256] = 1241,
  [1257] = 1250,
  [1258] = 1244,
  [1259] = 1250,
  [1260] = 1241,
  [1261] = 1244,
  [1262] = 1250,
  [1263] = 1244,
  [1264] = 1244,
  [1265] = 1250,
  [1266] = 1250,
  [1267] = 1250,
  [1268] = 1250,
  [1269] = 1244,
  [1270] = 1250,
  [1271] = 1241,
  [1272] = 1250,
  [1273] = 1273,
  [1274] = 1274,
  [1275] = 1275,
  [1276] = 1275,
  [1277] = 1275,
  [1278] = 1273,
  [1279] = 1273,
  [1280] = 1275,
  [1281] = 1273,
  [1282] = 1282,
  [1283] = 1273,
  [1284] = 1275,
  [1285] = 1282,
  [1286] = 1282,
  [1287] = 1282,
  [1288] = 1274,
  [1289] = 1282,
  [1290] = 1273,
  [1291] = 1282,
  [1292] = 1275,
  [1293] = 1273,
  [1294] = 1273,
  [1295] = 1275,
  [1296] = 1275,
  [1297] = 1274,
  [1298] = 1298,
  [1299] = 1299,
  [1300] = 1299,
  [1301] = 1299,
  [1302] = 1299,
  [1303] = 1299,
  [1304] = 1299,
  [1305] = 1299,
  [1306] = 1299,
  [1307] = 1299,
  [1308] = 1308,
  [1309] = 1309,
  [1310] = 1309,
  [1311] = 1308,
  [1312] = 1308,
  [1313] = 1309,
  [1314] = 1309,
  [1315] = 1309,
  [1316] = 1309,
  [1317] = 1308,
  [1318] = 1309,
  [1319] = 1309,
  [1320] = 1308,
  [1321] = 1321,
  [1322] = 1309,
  [1323] = 1309,
  [1324] = 1309,
  [1325] = 1308,
  [1326] = 1326,
  [1327] = 1327,
  [1328] = 1328,
  [1329] = 1327,
  [1330] = 1328,
  [1331] = 1328,
  [1332] = 1332,
  [1333] = 1333,
  [1334] = 1334,
  [1335] = 1328,
  [1336] = 1327,
  [1337] = 1327,
  [1338] = 1333,
  [1339] = 1339,
  [1340] = 1333,
  [1341] = 1341,
  [1342] = 1342,
  [1343] = 1328,
  [1344] = 1333,
  [1345] = 1333,
  [1346] = 1332,
  [1347] = 1327,
  [1348] = 1328,
  [1349] = 1333,
  [1350] = 1350,
  [1351] = 1351,
  [1352] = 1333,
  [1353] = 1353,
  [1354] = 1332,
  [1355] = 1333,
  [1356] = 1333,
  [1357] = 1357,
  [1358] = 1328,
  [1359] = 1327,
  [1360] = 1332,
  [1361] = 1361,
  [1362] = 1327,
  [1363] = 1363,
  [1364] = 1332,
  [1365] = 1326,
  [1366] = 1366,
  [1367] = 1333,
  [1368] = 1368,
  [1369] = 1332,
  [1370] = 1370,
  [1371] = 1327,
  [1372] = 1372,
  [1373] = 1332,
  [1374] = 1326,
  [1375] = 1339,
  [1376] = 1328,
  [1377] = 1327,
  [1378] = 1333,
  [1379] = 1332,
  [1380] = 1332,
  [1381] = 1328,
  [1382] = 1332,
  [1383] = 1333,
  [1384] = 1327,
  [1385] = 1332,
  [1386] = 1328,
  [1387] = 1387,
  [1388] = 1339,
  [1389] = 1327,
  [1390] = 1390,
  [1391] = 1327,
  [1392] = 1333,
  [1393] = 1327,
  [1394] = 1332,
  [1395] = 1328,
  [1396] = 1328,
  [1397] = 1328,
  [1398] = 1332,
  [1399] = 1339,
  [1400] = 1332,
  [1401] = 1327,
  [1402] = 1328,
  [1403] = 1327,
  [1404] = 1333,
  [1405] = 1333,
  [1406] = 1326,
  [1407] = 1332,
  [1408] = 1328,
  [1409] = 1409,
  [1410] = 1410,
  [1411] = 1411,
  [1412] = 1412,
  [1413] = 1413,
  [1414] = 1413,
  [1415] = 1415,
  [1416] = 1416,
  [1417] = 1417,
  [1418] = 1413,
  [1419] = 1412,
  [1420] = 1413,
  [1421] = 1413,
  [1422] = 1422,
  [1423] = 1413,
  [1424] = 1410,
  [1425] = 1425,
  [1426] = 1413,
  [1427] = 1412,
  [1428] = 1428,
  [1429] = 1413,
  [1430] = 1410,
  [1431] = 1431,
  [1432] = 1413,
  [1433] = 1433,
  [1434] = 1434,
  [1435] = 1412,
  [1436] = 1412,
  [1437] = 1412,
  [1438] = 1438,
  [1439] = 1412,
  [1440] = 1440,
  [1441] = 1413,
  [1442] = 1412,
  [1443] = 1443,
  [1444] = 1412,
  [1445] = 1412,
  [1446] = 1410,
  [1447] = 1412,
  [1448] = 1412,
  [1449] = 1449,
  [1450] = 1450,
  [1451] = 1413,
  [1452] = 1412,
  [1453] = 1410,
  [1454] = 1454,
  [1455] = 1410,
  [1456] = 1413,
  [1457] = 1413,
  [1458] = 1412,
  [1459] = 1413,
  [1460] = 1413,
  [1461] = 1412,
  [1462] = 1410,
  [1463] = 1410,
  [1464] = 1464,
  [1465] = 1465,
  [1466] = 1466,
  [1467] = 1467,
  [1468] = 1468,
  [1469] = 1469,
  [1470] = 1470,
  [1471] = 1471,
  [1472] = 1472,
  [1473] = 1473,
  [1474] = 1472,
  [1475] = 1475,
  [1476] = 1476,
  [1477] = 1477,
  [1478] = 1478,
  [1479] = 1479,
  [1480] = 1480,
  [1481] = 1481,
  [1482] = 1482,
  [1483] = 1483,
  [1484] = 1484,
  [1485] = 1485,
  [1486] = 1486,
  [1487] = 1487,
  [1488] = 1488,
  [1489] = 1489,
  [1490] = 1473,
  [1491] = 1491,
  [1492] = 1470,
  [1493] = 1493,
  [1494] = 1494,
  [1495] = 1495,
  [1496] = 1487,
  [1497] = 1489,
  [1498] = 1465,
  [1499] = 1499,
  [1500] = 1500,
  [1501] = 1501,
  [1502] = 1502,
  [1503] = 1499,
  [1504] = 1504,
  [1505] = 1505,
  [1506] = 1506,
  [1507] = 1487,
  [1508] = 1508,
  [1509] = 1471,
  [1510] = 1499,
  [1511] = 1487,
  [1512] = 1506,
  [1513] = 1513,
  [1514] = 1475,
  [1515] = 1487,
  [1516] = 1508,
  [1517] = 1488,
  [1518] = 1506,
  [1519] = 1487,
  [1520] = 1489,
  [1521] = 1465,
  [1522] = 1499,
  [1523] = 1499,
  [1524] = 1487,
  [1525] = 1505,
  [1526] = 1504,
  [1527] = 1506,
  [1528] = 1513,
  [1529] = 1502,
  [1530] = 1501,
  [1531] = 1500,
  [1532] = 1508,
  [1533] = 1487,
  [1534] = 1466,
  [1535] = 1495,
  [1536] = 1475,
  [1537] = 1489,
  [1538] = 1487,
  [1539] = 1539,
  [1540] = 1540,
  [1541] = 1465,
  [1542] = 1487,
  [1543] = 1506,
  [1544] = 1491,
  [1545] = 1508,
  [1546] = 1486,
  [1547] = 1468,
  [1548] = 1467,
  [1549] = 1493,
  [1550] = 1483,
  [1551] = 1551,
  [1552] = 1482,
  [1553] = 1481,
  [1554] = 1499,
  [1555] = 1487,
  [1556] = 1499,
  [1557] = 1480,
  [1558] = 1479,
  [1559] = 1478,
  [1560] = 1485,
  [1561] = 1499,
  [1562] = 1484,
  [1563] = 1477,
  [1564] = 1476,
  [1565] = 1499,
  [1566] = 1566,
  [1567] = 1508,
  [1568] = 1499,
  [1569] = 1499,
  [1570] = 1499,
  [1571] = 1487,
  [1572] = 1487,
  [1573] = 1475,
  [1574] = 1475,
  [1575] = 1489,
  [1576] = 1487,
  [1577] = 1508,
  [1578] = 1506,
  [1579] = 1487,
  [1580] = 1469,
  [1581] = 1581,
  [1582] = 1582,
  [1583] = 1583,
  [1584] = 1584,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1587,
  [1588] = 1582,
  [1589] = 1589,
  [1590] = 1590,
  [1591] = 1591,
  [1592] = 1592,
  [1593] = 1593,
  [1594] = 1587,
  [1595] = 1592,
  [1596] = 1592,
  [1597] = 1592,
  [1598] = 1591,
  [1599] = 1599,
  [1600] = 1592,
  [1601] = 1601,
  [1602] = 1602,
  [1603] = 1592,
  [1604] = 1604,
  [1605] = 1605,
  [1606] = 1587,
  [1607] = 1592,
  [1608] = 1608,
  [1609] = 1609,
  [1610] = 1610,
  [1611] = 1608,
  [1612] = 1590,
  [1613] = 1585,
  [1614] = 1583,
  [1615] = 1593,
  [1616] = 1616,
  [1617] = 1586,
  [1618] = 1591,
  [1619] = 1593,
  [1620] = 1589,
  [1621] = 1583,
  [1622] = 1604,
  [1623] = 1587,
  [1624] = 1584,
  [1625] = 1625,
  [1626] = 1604,
  [1627] = 1589,
  [1628] = 1601,
  [1629] = 1581,
  [1630] = 1584,
  [1631] = 1608,
  [1632] = 1590,
  [1633] = 1589,
  [1634] = 1605,
  [1635] = 1583,
  [1636] = 1593,
  [1637] = 1585,
  [1638] = 1581,
  [1639] = 1639,
  [1640] = 1586,
  [1641] = 1625,
  [1642] = 1642,
  [1643] = 1604,
  [1644] = 1581,
  [1645] = 1645,
  [1646] = 1642,
  [1647] = 1647,
  [1648] = 1587,
  [1649] = 1645,
  [1650] = 1650,
  [1651] = 1604,
  [1652] = 1601,
  [1653] = 1653,
  [1654] = 1584,
  [1655] = 1589,
  [1656] = 1650,
  [1657] = 1604,
  [1658] = 1593,
  [1659] = 1583,
  [1660] = 1604,
  [1661] = 1587,
  [1662] = 1584,
  [1663] = 1589,
  [1664] = 1664,
  [1665] = 1653,
  [1666] = 1642,
  [1667] = 1587,
  [1668] = 1587,
  [1669] = 1593,
  [1670] = 1670,
  [1671] = 1671,
  [1672] = 1672,
  [1673] = 1609,
  [1674] = 1604,
  [1675] = 1605,
  [1676] = 1653,
  [1677] = 1664,
  [1678] = 1602,
  [1679] = 1610,
  [1680] = 1589,
  [1681] = 1584,
  [1682] = 1604,
  [1683] = 1586,
  [1684] = 1650,
  [1685] = 1582,
  [1686] = 1625,
  [1687] = 1670,
  [1688] = 1583,
  [1689] = 1583,
  [1690] = 1593,
  [1691] = 1601,
  [1692] = 1671,
  [1693] = 1608,
  [1694] = 1590,
  [1695] = 1585,
  [1696] = 1645,
  [1697] = 1697,
  [1698] = 1581,
  [1699] = 1650,
  [1700] = 1670,
  [1701] = 1642,
  [1702] = 1645,
  [1703] = 1664,
  [1704] = 1604,
  [1705] = 1645,
  [1706] = 1591,
  [1707] = 1650,
  [1708] = 1664,
  [1709] = 1653,
  [1710] = 1642,
  [1711] = 1697,
  [1712] = 1582,
  [1713] = 1604,
  [1714] = 1584,
  [1715] = 1587,
  [1716] = 1716,
  [1717] = 1716,
  [1718] = 1716,
  [1719] = 1719,
  [1720] = 1716,
  [1721] = 1721,
  [1722] = 1716,
  [1723] = 1716,
  [1724] = 1716,
  [1725] = 1664,
  [1726] = 1581,
  [1727] = 1585,
  [1728] = 1592,
  [1729] = 1590,
  [1730] = 1608,
  [1731] = 1601,
  [1732] = 1670,
  [1733] = 1586,
  [1734] = 1583,
  [1735] = 1735,
  [1736] = 1736,
  [1737] = 1593,
  [1738] = 1583,
  [1739] = 1591,
  [1740] = 1591,
  [1741] = 1599,
  [1742] = 1742,
  [1743] = 1591,
  [1744] = 1593,
  [1745] = 1716,
  [1746] = 1586,
  [1747] = 1589,
  [1748] = 1671,
  [1749] = 1586,
  [1750] = 1601,
  [1751] = 1589,
  [1752] = 1608,
  [1753] = 1590,
  [1754] = 1585,
  [1755] = 1581,
  [1756] = 1642,
  [1757] = 1645,
  [1758] = 1650,
  [1759] = 1584,
  [1760] = 1664,
  [1761] = 1653,
  [1762] = 1583,
  [1763] = 1672,
  [1764] = 1764,
  [1765] = 1591,
  [1766] = 1584,
  [1767] = 1697,
  [1768] = 1768,
  [1769] = 1586,
  [1770] = 1586,
  [1771] = 1591,
  [1772] = 1697,
  [1773] = 1609,
  [1774] = 1587,
  [1775] = 1775,
  [1776] = 1616,
  [1777] = 1697,
  [1778] = 1583,
  [1779] = 1586,
  [1780] = 1602,
  [1781] = 1609,
  [1782] = 1586,
  [1783] = 1593,
  [1784] = 1672,
  [1785] = 1785,
  [1786] = 1671,
  [1787] = 1697,
  [1788] = 1587,
  [1789] = 1591,
  [1790] = 1790,
  [1791] = 1601,
  [1792] = 1591,
  [1793] = 1586,
  [1794] = 1599,
  [1795] = 1591,
  [1796] = 1586,
  [1797] = 1582,
  [1798] = 1609,
  [1799] = 1602,
  [1800] = 1605,
  [1801] = 1608,
  [1802] = 1609,
  [1803] = 1672,
  [1804] = 1671,
  [1805] = 1582,
  [1806] = 1590,
  [1807] = 1585,
  [1808] = 1587,
  [1809] = 1602,
  [1810] = 1645,
  [1811] = 1581,
  [1812] = 1642,
  [1813] = 1605,
  [1814] = 1645,
  [1815] = 1609,
  [1816] = 1672,
  [1817] = 1601,
  [1818] = 1671,
  [1819] = 1584,
  [1820] = 1653,
  [1821] = 1664,
  [1822] = 1650,
  [1823] = 1645,
  [1824] = 1642,
  [1825] = 1581,
  [1826] = 1585,
  [1827] = 1590,
  [1828] = 1608,
  [1829] = 1601,
  [1830] = 1589,
  [1831] = 1831,
  [1832] = 1602,
  [1833] = 1608,
  [1834] = 1586,
  [1835] = 1590,
  [1836] = 1584,
  [1837] = 1591,
  [1838] = 1605,
  [1839] = 1672,
  [1840] = 1625,
  [1841] = 1602,
  [1842] = 1842,
  [1843] = 1604,
  [1844] = 1604,
  [1845] = 1672,
  [1846] = 1650,
  [1847] = 1605,
  [1848] = 1664,
  [1849] = 1583,
  [1850] = 1653,
  [1851] = 1593,
  [1852] = 1589,
  [1853] = 1593,
  [1854] = 1581,
  [1855] = 1653,
  [1856] = 1593,
  [1857] = 1583,
  [1858] = 1582,
  [1859] = 1591,
  [1860] = 1584,
  [1861] = 1609,
  [1862] = 1601,
  [1863] = 1593,
  [1864] = 1583,
  [1865] = 1608,
  [1866] = 1672,
  [1867] = 1671,
  [1868] = 1584,
  [1869] = 1590,
  [1870] = 1670,
  [1871] = 1604,
  [1872] = 1625,
  [1873] = 1653,
  [1874] = 1587,
  [1875] = 1664,
  [1876] = 1584,
  [1877] = 1650,
  [1878] = 1671,
  [1879] = 1642,
  [1880] = 1583,
  [1881] = 1593,
  [1882] = 1582,
  [1883] = 1645,
  [1884] = 1642,
  [1885] = 1585,
  [1886] = 1585,
  [1887] = 1589,
  [1888] = 1590,
  [1889] = 1581,
  [1890] = 1608,
  [1891] = 1589,
  [1892] = 1601,
  [1893] = 1608,
  [1894] = 1590,
  [1895] = 1601,
  [1896] = 1585,
  [1897] = 1642,
  [1898] = 1587,
  [1899] = 1645,
  [1900] = 1589,
  [1901] = 1901,
  [1902] = 1581,
  [1903] = 1642,
  [1904] = 1650,
  [1905] = 1645,
  [1906] = 1602,
  [1907] = 1697,
  [1908] = 1650,
  [1909] = 1664,
  [1910] = 1653,
  [1911] = 1653,
  [1912] = 1625,
  [1913] = 1768,
  [1914] = 1587,
  [1915] = 1664,
  [1916] = 1764,
  [1917] = 1670,
  [1918] = 1605,
  [1919] = 1653,
  [1920] = 1609,
  [1921] = 1602,
  [1922] = 1922,
  [1923] = 1645,
  [1924] = 1650,
  [1925] = 1586,
  [1926] = 1591,
  [1927] = 1601,
  [1928] = 1584,
  [1929] = 1608,
  [1930] = 1672,
  [1931] = 1716,
  [1932] = 1664,
  [1933] = 1604,
  [1934] = 1653,
  [1935] = 1653,
  [1936] = 1664,
  [1937] = 1650,
  [1938] = 1785,
  [1939] = 1653,
  [1940] = 1664,
  [1941] = 1664,
  [1942] = 1650,
  [1943] = 1585,
  [1944] = 1590,
  [1945] = 1645,
  [1946] = 1642,
  [1947] = 1642,
  [1948] = 1610,
  [1949] = 1581,
  [1950] = 1585,
  [1951] = 1585,
  [1952] = 1581,
  [1953] = 1585,
  [1954] = 1590,
  [1955] = 1581,
  [1956] = 1956,
  [1957] = 1608,
  [1958] = 1642,
  [1959] = 1601,
  [1960] = 1590,
  [1961] = 1608,
  [1962] = 1601,
  [1963] = 1589,
  [1964] = 1671,
  [1965] = 1650,
  [1966] = 1645,
  [1967] = 1967,
  [1968] = 1968,
  [1969] = 1969,
  [1970] = 1970,
  [1971] = 1971,
  [1972] = 1972,
  [1973] = 1973,
  [1974] = 1974,
  [1975] = 1975,
  [1976] = 1976,
  [1977] = 1976,
  [1978] = 1978,
  [1979] = 1978,
  [1980] = 1978,
  [1981] = 1978,
  [1982] = 1978,
  [1983] = 1983,
  [1984] = 433,
  [1985] = 421,
  [1986] = 1967,
  [1987] = 1967,
  [1988] = 1971,
  [1989] = 1970,
  [1990] = 1968,
  [1991] = 1975,
  [1992] = 1992,
  [1993] = 1967,
  [1994] = 1969,
  [1995] = 1973,
  [1996] = 1975,
  [1997] = 1972,
  [1998] = 1974,
  [1999] = 1973,
  [2000] = 1972,
  [2001] = 1974,
  [2002] = 1969,
  [2003] = 1975,
  [2004] = 1968,
  [2005] = 1970,
  [2006] = 1274,
  [2007] = 1971,
  [2008] = 1274,
  [2009] = 1974,
  [2010] = 1969,
  [2011] = 1971,
  [2012] = 1975,
  [2013] = 1970,
  [2014] = 1972,
  [2015] = 1968,
  [2016] = 1973,
  [2017] = 1975,
  [2018] = 2018,
  [2019] = 2018,
  [2020] = 2018,
  [2021] = 2018,
  [2022] = 2018,
  [2023] = 2023,
  [2024] = 2023,
  [2025] = 2023,
  [2026] = 2026,
  [2027] = 2023,
  [2028] = 2023,
  [2029] = 2023,
  [2030] = 2023,
  [2031] = 2023,
  [2032] = 2023,
  [2033] = 2033,
  [2034] = 2034,
  [2035] = 2035,
  [2036] = 2036,
  [2037] = 2037,
  [2038] = 2038,
  [2039] = 2039,
  [2040] = 2040,
  [2041] = 2041,
  [2042] = 2042,
  [2043] = 2043,
  [2044] = 2044,
  [2045] = 2045,
  [2046] = 2046,
  [2047] = 2045,
  [2048] = 2048,
  [2049] = 2049,
  [2050] = 2050,
  [2051] = 2051,
  [2052] = 2052,
  [2053] = 2053,
  [2054] = 2054,
  [2055] = 1975,
  [2056] = 1975,
  [2057] = 2057,
  [2058] = 2058,
  [2059] = 2059,
  [2060] = 1969,
  [2061] = 2059,
  [2062] = 2059,
  [2063] = 2063,
  [2064] = 2064,
  [2065] = 1972,
  [2066] = 1971,
  [2067] = 1973,
  [2068] = 2068,
  [2069] = 1968,
  [2070] = 2070,
  [2071] = 2071,
  [2072] = 1974,
  [2073] = 2059,
  [2074] = 2059,
  [2075] = 1970,
  [2076] = 1974,
  [2077] = 230,
  [2078] = 1968,
  [2079] = 2063,
  [2080] = 253,
  [2081] = 244,
  [2082] = 232,
  [2083] = 1970,
  [2084] = 1969,
  [2085] = 2085,
  [2086] = 1972,
  [2087] = 2033,
  [2088] = 2088,
  [2089] = 1971,
  [2090] = 2090,
  [2091] = 1973,
  [2092] = 2092,
  [2093] = 2092,
  [2094] = 2094,
  [2095] = 2092,
  [2096] = 2092,
  [2097] = 2094,
  [2098] = 2092,
  [2099] = 2094,
  [2100] = 2092,
  [2101] = 340,
  [2102] = 2094,
  [2103] = 1967,
  [2104] = 2094,
  [2105] = 2105,
  [2106] = 2092,
  [2107] = 1975,
  [2108] = 2092,
  [2109] = 340,
  [2110] = 2092,
  [2111] = 253,
  [2112] = 2112,
  [2113] = 2113,
  [2114] = 271,
  [2115] = 1967,
  [2116] = 2116,
  [2117] = 232,
  [2118] = 152,
  [2119] = 2119,
  [2120] = 154,
  [2121] = 2121,
  [2122] = 2122,
  [2123] = 230,
  [2124] = 244,
  [2125] = 2125,
  [2126] = 2126,
  [2127] = 2033,
  [2128] = 2033,
  [2129] = 2129,
  [2130] = 378,
  [2131] = 1968,
  [2132] = 2048,
  [2133] = 421,
  [2134] = 364,
  [2135] = 2135,
  [2136] = 1967,
  [2137] = 2137,
  [2138] = 2051,
  [2139] = 337,
  [2140] = 335,
  [2141] = 1972,
  [2142] = 2037,
  [2143] = 283,
  [2144] = 1971,
  [2145] = 340,
  [2146] = 396,
  [2147] = 398,
  [2148] = 2148,
  [2149] = 1973,
  [2150] = 423,
  [2151] = 1975,
  [2152] = 427,
  [2153] = 307,
  [2154] = 2154,
  [2155] = 356,
  [2156] = 432,
  [2157] = 358,
  [2158] = 2158,
  [2159] = 2129,
  [2160] = 2160,
  [2161] = 413,
  [2162] = 288,
  [2163] = 2033,
  [2164] = 2129,
  [2165] = 2160,
  [2166] = 2166,
  [2167] = 1970,
  [2168] = 1969,
  [2169] = 1968,
  [2170] = 1974,
  [2171] = 415,
  [2172] = 394,
  [2173] = 2026,
  [2174] = 387,
  [2175] = 429,
  [2176] = 1971,
  [2177] = 2158,
  [2178] = 2178,
  [2179] = 2179,
  [2180] = 431,
  [2181] = 2181,
  [2182] = 2182,
  [2183] = 2183,
  [2184] = 2184,
  [2185] = 2185,
  [2186] = 2186,
  [2187] = 2187,
  [2188] = 2188,
  [2189] = 384,
  [2190] = 2121,
  [2191] = 417,
  [2192] = 2122,
  [2193] = 2193,
  [2194] = 1973,
  [2195] = 402,
  [2196] = 2196,
  [2197] = 2197,
  [2198] = 2198,
  [2199] = 376,
  [2200] = 2200,
  [2201] = 414,
  [2202] = 374,
  [2203] = 2203,
  [2204] = 2204,
  [2205] = 410,
  [2206] = 2206,
  [2207] = 373,
  [2208] = 2208,
  [2209] = 2209,
  [2210] = 372,
  [2211] = 371,
  [2212] = 2212,
  [2213] = 2213,
  [2214] = 2214,
  [2215] = 2215,
  [2216] = 2216,
  [2217] = 2217,
  [2218] = 403,
  [2219] = 275,
  [2220] = 2220,
  [2221] = 2221,
  [2222] = 2222,
  [2223] = 370,
  [2224] = 2224,
  [2225] = 320,
  [2226] = 352,
  [2227] = 1972,
  [2228] = 426,
  [2229] = 2229,
  [2230] = 433,
  [2231] = 322,
  [2232] = 369,
  [2233] = 355,
  [2234] = 2182,
  [2235] = 2178,
  [2236] = 368,
  [2237] = 379,
  [2238] = 380,
  [2239] = 386,
  [2240] = 406,
  [2241] = 292,
  [2242] = 388,
  [2243] = 2179,
  [2244] = 430,
  [2245] = 1970,
  [2246] = 1969,
  [2247] = 1974,
  [2248] = 323,
  [2249] = 2249,
  [2250] = 420,
  [2251] = 2251,
  [2252] = 2252,
  [2253] = 2253,
  [2254] = 340,
  [2255] = 2255,
  [2256] = 2256,
  [2257] = 2257,
  [2258] = 2258,
  [2259] = 434,
  [2260] = 419,
  [2261] = 2261,
  [2262] = 2262,
  [2263] = 232,
  [2264] = 2264,
  [2265] = 2265,
  [2266] = 2266,
  [2267] = 232,
  [2268] = 2268,
  [2269] = 2269,
  [2270] = 230,
  [2271] = 230,
  [2272] = 2272,
  [2273] = 2051,
  [2274] = 2274,
  [2275] = 2275,
  [2276] = 253,
  [2277] = 2277,
  [2278] = 2026,
  [2279] = 2279,
  [2280] = 2280,
  [2281] = 2281,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 2284,
  [2285] = 2285,
  [2286] = 2286,
  [2287] = 2229,
  [2288] = 2033,
  [2289] = 271,
  [2290] = 2229,
  [2291] = 2291,
  [2292] = 2292,
  [2293] = 2293,
  [2294] = 2229,
  [2295] = 2295,
  [2296] = 244,
  [2297] = 2033,
  [2298] = 2122,
  [2299] = 2299,
  [2300] = 2121,
  [2301] = 2301,
  [2302] = 2302,
  [2303] = 2229,
  [2304] = 2037,
  [2305] = 2305,
  [2306] = 2306,
  [2307] = 2261,
  [2308] = 2308,
  [2309] = 2309,
  [2310] = 2310,
  [2311] = 154,
  [2312] = 152,
  [2313] = 2313,
  [2314] = 2261,
  [2315] = 1975,
  [2316] = 2316,
  [2317] = 2261,
  [2318] = 2261,
  [2319] = 2261,
  [2320] = 2261,
  [2321] = 2261,
  [2322] = 2037,
  [2323] = 2051,
  [2324] = 2324,
  [2325] = 2325,
  [2326] = 2326,
  [2327] = 2048,
  [2328] = 2033,
  [2329] = 2329,
  [2330] = 2261,
  [2331] = 2033,
  [2332] = 2272,
  [2333] = 2333,
  [2334] = 2334,
  [2335] = 244,
  [2336] = 2229,
  [2337] = 2229,
  [2338] = 2338,
  [2339] = 2339,
  [2340] = 2048,
  [2341] = 253,
  [2342] = 2264,
  [2343] = 2343,
  [2344] = 2344,
  [2345] = 2345,
  [2346] = 2346,
  [2347] = 2347,
  [2348] = 2348,
  [2349] = 2349,
  [2350] = 2206,
  [2351] = 340,
  [2352] = 387,
  [2353] = 2208,
  [2354] = 2064,
  [2355] = 307,
  [2356] = 2209,
  [2357] = 2212,
  [2358] = 2213,
  [2359] = 2214,
  [2360] = 2215,
  [2361] = 372,
  [2362] = 371,
  [2363] = 2216,
  [2364] = 2217,
  [2365] = 2220,
  [2366] = 2221,
  [2367] = 2222,
  [2368] = 2258,
  [2369] = 2257,
  [2370] = 2256,
  [2371] = 2255,
  [2372] = 430,
  [2373] = 2253,
  [2374] = 2252,
  [2375] = 2251,
  [2376] = 2033,
  [2377] = 434,
  [2378] = 369,
  [2379] = 2379,
  [2380] = 368,
  [2381] = 398,
  [2382] = 431,
  [2383] = 2071,
  [2384] = 396,
  [2385] = 2385,
  [2386] = 420,
  [2387] = 419,
  [2388] = 2249,
  [2389] = 2037,
  [2390] = 2048,
  [2391] = 335,
  [2392] = 384,
  [2393] = 417,
  [2394] = 415,
  [2395] = 2268,
  [2396] = 2396,
  [2397] = 413,
  [2398] = 2398,
  [2399] = 337,
  [2400] = 402,
  [2401] = 426,
  [2402] = 364,
  [2403] = 432,
  [2404] = 2204,
  [2405] = 2405,
  [2406] = 2203,
  [2407] = 2200,
  [2408] = 2137,
  [2409] = 352,
  [2410] = 414,
  [2411] = 2411,
  [2412] = 2166,
  [2413] = 2135,
  [2414] = 421,
  [2415] = 2033,
  [2416] = 376,
  [2417] = 2417,
  [2418] = 2313,
  [2419] = 433,
  [2420] = 2068,
  [2421] = 423,
  [2422] = 2422,
  [2423] = 2423,
  [2424] = 394,
  [2425] = 2198,
  [2426] = 2396,
  [2427] = 283,
  [2428] = 2428,
  [2429] = 355,
  [2430] = 2197,
  [2431] = 2326,
  [2432] = 340,
  [2433] = 2196,
  [2434] = 370,
  [2435] = 2033,
  [2436] = 2436,
  [2437] = 2437,
  [2438] = 2051,
  [2439] = 2439,
  [2440] = 2440,
  [2441] = 275,
  [2442] = 2193,
  [2443] = 356,
  [2444] = 2275,
  [2445] = 2306,
  [2446] = 2446,
  [2447] = 410,
  [2448] = 358,
  [2449] = 403,
  [2450] = 379,
  [2451] = 2451,
  [2452] = 2396,
  [2453] = 2453,
  [2454] = 323,
  [2455] = 380,
  [2456] = 340,
  [2457] = 429,
  [2458] = 386,
  [2459] = 427,
  [2460] = 292,
  [2461] = 378,
  [2462] = 322,
  [2463] = 320,
  [2464] = 374,
  [2465] = 288,
  [2466] = 2466,
  [2467] = 2467,
  [2468] = 2326,
  [2469] = 406,
  [2470] = 388,
  [2471] = 2428,
  [2472] = 2313,
  [2473] = 2188,
  [2474] = 2187,
  [2475] = 2186,
  [2476] = 2185,
  [2477] = 2184,
  [2478] = 2183,
  [2479] = 373,
  [2480] = 2181,
  [2481] = 2070,
  [2482] = 340,
  [2483] = 2154,
  [2484] = 2033,
  [2485] = 2396,
  [2486] = 2333,
  [2487] = 2339,
  [2488] = 2306,
  [2489] = 2489,
  [2490] = 2325,
  [2491] = 2491,
  [2492] = 2492,
  [2493] = 2493,
  [2494] = 2494,
  [2495] = 2063,
  [2496] = 2324,
  [2497] = 2497,
  [2498] = 2498,
  [2499] = 2499,
  [2500] = 2491,
  [2501] = 2295,
  [2502] = 154,
  [2503] = 152,
  [2504] = 2071,
  [2505] = 2422,
  [2506] = 2291,
  [2507] = 2064,
  [2508] = 2343,
  [2509] = 2509,
  [2510] = 2119,
  [2511] = 2511,
  [2512] = 2348,
  [2513] = 2285,
  [2514] = 154,
  [2515] = 2283,
  [2516] = 2281,
  [2517] = 2068,
  [2518] = 2282,
  [2519] = 2519,
  [2520] = 2493,
  [2521] = 2063,
  [2522] = 2497,
  [2523] = 152,
  [2524] = 1967,
  [2525] = 2122,
  [2526] = 2266,
  [2527] = 2308,
  [2528] = 2269,
  [2529] = 2121,
  [2530] = 2299,
  [2531] = 2302,
  [2532] = 2344,
  [2533] = 2279,
  [2534] = 2334,
  [2535] = 2280,
  [2536] = 2536,
  [2537] = 2346,
  [2538] = 2090,
  [2539] = 2338,
  [2540] = 2540,
  [2541] = 2541,
  [2542] = 2542,
  [2543] = 2309,
  [2544] = 2349,
  [2545] = 2262,
  [2546] = 2310,
  [2547] = 2121,
  [2548] = 2125,
  [2549] = 2549,
  [2550] = 2122,
  [2551] = 2549,
  [2552] = 2552,
  [2553] = 2553,
  [2554] = 2284,
  [2555] = 2277,
  [2556] = 2494,
  [2557] = 2286,
  [2558] = 2347,
  [2559] = 2559,
  [2560] = 271,
  [2561] = 2274,
  [2562] = 2499,
  [2563] = 2293,
  [2564] = 2564,
  [2565] = 2265,
  [2566] = 2566,
  [2567] = 271,
  [2568] = 2345,
  [2569] = 2070,
  [2570] = 2570,
  [2571] = 2571,
  [2572] = 2498,
  [2573] = 2573,
  [2574] = 2574,
  [2575] = 2301,
  [2576] = 2292,
  [2577] = 2268,
  [2578] = 356,
  [2579] = 420,
  [2580] = 2580,
  [2581] = 410,
  [2582] = 403,
  [2583] = 2222,
  [2584] = 2221,
  [2585] = 2220,
  [2586] = 2051,
  [2587] = 2493,
  [2588] = 2494,
  [2589] = 2491,
  [2590] = 352,
  [2591] = 2217,
  [2592] = 307,
  [2593] = 2037,
  [2594] = 394,
  [2595] = 402,
  [2596] = 2216,
  [2597] = 378,
  [2598] = 355,
  [2599] = 376,
  [2600] = 374,
  [2601] = 2135,
  [2602] = 414,
  [2603] = 1975,
  [2604] = 423,
  [2605] = 356,
  [2606] = 373,
  [2607] = 426,
  [2608] = 427,
  [2609] = 335,
  [2610] = 337,
  [2611] = 429,
  [2612] = 430,
  [2613] = 431,
  [2614] = 2215,
  [2615] = 2214,
  [2616] = 307,
  [2617] = 2213,
  [2618] = 2497,
  [2619] = 2498,
  [2620] = 2212,
  [2621] = 379,
  [2622] = 2258,
  [2623] = 380,
  [2624] = 2257,
  [2625] = 283,
  [2626] = 2137,
  [2627] = 2137,
  [2628] = 2256,
  [2629] = 1111,
  [2630] = 2255,
  [2631] = 2209,
  [2632] = 419,
  [2633] = 386,
  [2634] = 417,
  [2635] = 2635,
  [2636] = 358,
  [2637] = 415,
  [2638] = 2638,
  [2639] = 364,
  [2640] = 2499,
  [2641] = 2048,
  [2642] = 2135,
  [2643] = 323,
  [2644] = 322,
  [2645] = 320,
  [2646] = 387,
  [2647] = 384,
  [2648] = 2648,
  [2649] = 2253,
  [2650] = 2252,
  [2651] = 372,
  [2652] = 371,
  [2653] = 421,
  [2654] = 2251,
  [2655] = 2549,
  [2656] = 2656,
  [2657] = 406,
  [2658] = 388,
  [2659] = 370,
  [2660] = 275,
  [2661] = 369,
  [2662] = 368,
  [2663] = 433,
  [2664] = 2492,
  [2665] = 335,
  [2666] = 2121,
  [2667] = 2122,
  [2668] = 288,
  [2669] = 2068,
  [2670] = 337,
  [2671] = 2064,
  [2672] = 2672,
  [2673] = 292,
  [2674] = 2071,
  [2675] = 2070,
  [2676] = 292,
  [2677] = 288,
  [2678] = 2181,
  [2679] = 2206,
  [2680] = 2204,
  [2681] = 2203,
  [2682] = 2183,
  [2683] = 2184,
  [2684] = 2185,
  [2685] = 2186,
  [2686] = 2208,
  [2687] = 2198,
  [2688] = 2187,
  [2689] = 2197,
  [2690] = 2188,
  [2691] = 1112,
  [2692] = 421,
  [2693] = 420,
  [2694] = 432,
  [2695] = 2070,
  [2696] = 364,
  [2697] = 320,
  [2698] = 322,
  [2699] = 2196,
  [2700] = 2068,
  [2701] = 323,
  [2702] = 2193,
  [2703] = 283,
  [2704] = 413,
  [2705] = 413,
  [2706] = 275,
  [2707] = 415,
  [2708] = 417,
  [2709] = 434,
  [2710] = 419,
  [2711] = 2251,
  [2712] = 2252,
  [2713] = 2253,
  [2714] = 2255,
  [2715] = 2256,
  [2716] = 2200,
  [2717] = 2090,
  [2718] = 396,
  [2719] = 2188,
  [2720] = 2257,
  [2721] = 2258,
  [2722] = 2187,
  [2723] = 2064,
  [2724] = 2186,
  [2725] = 396,
  [2726] = 2071,
  [2727] = 433,
  [2728] = 398,
  [2729] = 2185,
  [2730] = 2184,
  [2731] = 2183,
  [2732] = 368,
  [2733] = 398,
  [2734] = 2222,
  [2735] = 2492,
  [2736] = 2221,
  [2737] = 2220,
  [2738] = 2217,
  [2739] = 2216,
  [2740] = 2215,
  [2741] = 2063,
  [2742] = 2181,
  [2743] = 434,
  [2744] = 2214,
  [2745] = 2213,
  [2746] = 2212,
  [2747] = 2209,
  [2748] = 369,
  [2749] = 370,
  [2750] = 432,
  [2751] = 2208,
  [2752] = 2206,
  [2753] = 2204,
  [2754] = 2203,
  [2755] = 2200,
  [2756] = 388,
  [2757] = 406,
  [2758] = 386,
  [2759] = 2198,
  [2760] = 380,
  [2761] = 379,
  [2762] = 2197,
  [2763] = 371,
  [2764] = 372,
  [2765] = 355,
  [2766] = 394,
  [2767] = 2767,
  [2768] = 2196,
  [2769] = 352,
  [2770] = 402,
  [2771] = 403,
  [2772] = 2193,
  [2773] = 373,
  [2774] = 2326,
  [2775] = 374,
  [2776] = 410,
  [2777] = 376,
  [2778] = 2428,
  [2779] = 378,
  [2780] = 414,
  [2781] = 384,
  [2782] = 387,
  [2783] = 358,
  [2784] = 2313,
  [2785] = 423,
  [2786] = 426,
  [2787] = 427,
  [2788] = 429,
  [2789] = 431,
  [2790] = 2790,
  [2791] = 430,
  [2792] = 2792,
  [2793] = 2793,
  [2794] = 2794,
  [2795] = 2326,
  [2796] = 2796,
  [2797] = 2063,
  [2798] = 152,
  [2799] = 2306,
  [2800] = 2497,
  [2801] = 2801,
  [2802] = 1111,
  [2803] = 2498,
  [2804] = 2804,
  [2805] = 2499,
  [2806] = 2806,
  [2807] = 2494,
  [2808] = 2549,
  [2809] = 2493,
  [2810] = 154,
  [2811] = 2811,
  [2812] = 2063,
  [2813] = 2071,
  [2814] = 1112,
  [2815] = 2178,
  [2816] = 2816,
  [2817] = 2817,
  [2818] = 2818,
  [2819] = 2064,
  [2820] = 2491,
  [2821] = 2821,
  [2822] = 2071,
  [2823] = 2068,
  [2824] = 2182,
  [2825] = 2825,
  [2826] = 2264,
  [2827] = 2264,
  [2828] = 2828,
  [2829] = 2829,
  [2830] = 2830,
  [2831] = 2831,
  [2832] = 2179,
  [2833] = 2833,
  [2834] = 2068,
  [2835] = 2178,
  [2836] = 2326,
  [2837] = 2070,
  [2838] = 2182,
  [2839] = 2158,
  [2840] = 2840,
  [2841] = 2313,
  [2842] = 2125,
  [2843] = 2090,
  [2844] = 2313,
  [2845] = 2119,
  [2846] = 2846,
  [2847] = 2847,
  [2848] = 2179,
  [2849] = 2070,
  [2850] = 2070,
  [2851] = 1970,
  [2852] = 2071,
  [2853] = 2064,
  [2854] = 1972,
  [2855] = 1971,
  [2856] = 1974,
  [2857] = 1969,
  [2858] = 1973,
  [2859] = 2859,
  [2860] = 2068,
  [2861] = 2064,
  [2862] = 1968,
  [2863] = 2063,
  [2864] = 2158,
  [2865] = 2865,
  [2866] = 2866,
  [2867] = 2867,
  [2868] = 2638,
  [2869] = 2052,
  [2870] = 2053,
  [2871] = 2040,
  [2872] = 2872,
  [2873] = 2873,
  [2874] = 2874,
  [2875] = 2875,
  [2876] = 2876,
  [2877] = 2877,
  [2878] = 2878,
  [2879] = 2648,
  [2880] = 2880,
  [2881] = 2881,
  [2882] = 2882,
  [2883] = 2883,
  [2884] = 2884,
  [2885] = 2885,
  [2886] = 2886,
  [2887] = 1972,
  [2888] = 1971,
  [2889] = 2049,
  [2890] = 2050,
  [2891] = 2070,
  [2892] = 2638,
  [2893] = 2893,
  [2894] = 2326,
  [2895] = 2329,
  [2896] = 2896,
  [2897] = 2428,
  [2898] = 2898,
  [2899] = 2899,
  [2900] = 2179,
  [2901] = 2313,
  [2902] = 2902,
  [2903] = 2182,
  [2904] = 1973,
  [2905] = 1968,
  [2906] = 2178,
  [2907] = 2068,
  [2908] = 1970,
  [2909] = 2909,
  [2910] = 1969,
  [2911] = 2635,
  [2912] = 1974,
  [2913] = 2913,
  [2914] = 2158,
  [2915] = 2915,
  [2916] = 2916,
  [2917] = 2917,
  [2918] = 2918,
  [2919] = 2090,
  [2920] = 2920,
  [2921] = 2039,
  [2922] = 2859,
  [2923] = 2042,
  [2924] = 2038,
  [2925] = 154,
  [2926] = 2926,
  [2927] = 2927,
  [2928] = 2928,
  [2929] = 2929,
  [2930] = 2930,
  [2931] = 2648,
  [2932] = 2932,
  [2933] = 2034,
  [2934] = 2035,
  [2935] = 2935,
  [2936] = 2936,
  [2937] = 2937,
  [2938] = 2046,
  [2939] = 2825,
  [2940] = 2656,
  [2941] = 2941,
  [2942] = 2305,
  [2943] = 2071,
  [2944] = 2041,
  [2945] = 2945,
  [2946] = 2946,
  [2947] = 2064,
  [2948] = 2948,
  [2949] = 2063,
  [2950] = 2950,
  [2951] = 2951,
  [2952] = 2492,
  [2953] = 2953,
  [2954] = 2954,
  [2955] = 152,
  [2956] = 2956,
  [2957] = 2957,
  [2958] = 2044,
  [2959] = 2036,
  [2960] = 2960,
  [2961] = 2961,
  [2962] = 2026,
  [2963] = 2963,
  [2964] = 2964,
  [2965] = 2656,
  [2966] = 2966,
  [2967] = 2967,
  [2968] = 2306,
  [2969] = 2969,
  [2970] = 2043,
  [2971] = 2971,
  [2972] = 2122,
  [2973] = 2635,
  [2974] = 2121,
  [2975] = 2975,
  [2976] = 2976,
  [2977] = 2090,
  [2978] = 2466,
  [2979] = 2491,
  [2980] = 2656,
  [2981] = 2648,
  [2982] = 2439,
  [2983] = 2983,
  [2984] = 2491,
  [2985] = 2453,
  [2986] = 2051,
  [2987] = 2113,
  [2988] = 2116,
  [2989] = 2437,
  [2990] = 2493,
  [2991] = 2493,
  [2992] = 2494,
  [2993] = 2440,
  [2994] = 2428,
  [2995] = 2119,
  [2996] = 2417,
  [2997] = 2494,
  [2998] = 2998,
  [2999] = 2398,
  [3000] = 2125,
  [3001] = 2126,
  [3002] = 3002,
  [3003] = 2405,
  [3004] = 2451,
  [3005] = 2037,
  [3006] = 2071,
  [3007] = 2048,
  [3008] = 2064,
  [3009] = 2264,
  [3010] = 2112,
  [3011] = 2436,
  [3012] = 2467,
  [3013] = 2068,
  [3014] = 2497,
  [3015] = 2070,
  [3016] = 2549,
  [3017] = 2498,
  [3018] = 2549,
  [3019] = 2499,
  [3020] = 2446,
  [3021] = 2499,
  [3022] = 2497,
  [3023] = 2498,
  [3024] = 2070,
  [3025] = 3025,
  [3026] = 2119,
  [3027] = 2178,
  [3028] = 2182,
  [3029] = 2064,
  [3030] = 2179,
  [3031] = 2071,
  [3032] = 2492,
  [3033] = 2492,
  [3034] = 2026,
  [3035] = 2090,
  [3036] = 2063,
  [3037] = 2158,
  [3038] = 2166,
  [3039] = 2154,
  [3040] = 2638,
  [3041] = 2306,
  [3042] = 2491,
  [3043] = 2306,
  [3044] = 2305,
  [3045] = 2635,
  [3046] = 2549,
  [3047] = 3047,
  [3048] = 2125,
  [3049] = 2068,
  [3050] = 3050,
  [3051] = 2499,
  [3052] = 2329,
  [3053] = 2493,
  [3054] = 2494,
  [3055] = 2498,
  [3056] = 2313,
  [3057] = 2497,
  [3058] = 2249,
  [3059] = 2326,
  [3060] = 2090,
  [3061] = 2125,
  [3062] = 2324,
  [3063] = 2326,
  [3064] = 2308,
  [3065] = 2398,
  [3066] = 2277,
  [3067] = 2281,
  [3068] = 2279,
  [3069] = 2269,
  [3070] = 2266,
  [3071] = 2309,
  [3072] = 2299,
  [3073] = 2283,
  [3074] = 2282,
  [3075] = 2405,
  [3076] = 2334,
  [3077] = 2285,
  [3078] = 2333,
  [3079] = 2451,
  [3080] = 2345,
  [3081] = 2116,
  [3082] = 2466,
  [3083] = 2301,
  [3084] = 2492,
  [3085] = 2178,
  [3086] = 2182,
  [3087] = 2467,
  [3088] = 2113,
  [3089] = 2313,
  [3090] = 2291,
  [3091] = 2295,
  [3092] = 2274,
  [3093] = 2179,
  [3094] = 2280,
  [3095] = 2119,
  [3096] = 2436,
  [3097] = 2437,
  [3098] = 2417,
  [3099] = 2292,
  [3100] = 2265,
  [3101] = 2284,
  [3102] = 2325,
  [3103] = 2286,
  [3104] = 2293,
  [3105] = 2302,
  [3106] = 2638,
  [3107] = 2262,
  [3108] = 2635,
  [3109] = 2348,
  [3110] = 2343,
  [3111] = 2439,
  [3112] = 2347,
  [3113] = 2453,
  [3114] = 2440,
  [3115] = 2428,
  [3116] = 2339,
  [3117] = 2158,
  [3118] = 2264,
  [3119] = 2349,
  [3120] = 2346,
  [3121] = 2026,
  [3122] = 2310,
  [3123] = 3123,
  [3124] = 2344,
  [3125] = 2446,
  [3126] = 2112,
  [3127] = 2338,
  [3128] = 2126,
  [3129] = 2026,
  [3130] = 2064,
  [3131] = 2262,
  [3132] = 3132,
  [3133] = 1970,
  [3134] = 3134,
  [3135] = 2119,
  [3136] = 2423,
  [3137] = 1968,
  [3138] = 2280,
  [3139] = 1973,
  [3140] = 3140,
  [3141] = 1971,
  [3142] = 3142,
  [3143] = 2385,
  [3144] = 3144,
  [3145] = 2063,
  [3146] = 2491,
  [3147] = 2491,
  [3148] = 3148,
  [3149] = 2493,
  [3150] = 2249,
  [3151] = 3151,
  [3152] = 2493,
  [3153] = 2264,
  [3154] = 3154,
  [3155] = 1974,
  [3156] = 2494,
  [3157] = 2494,
  [3158] = 3158,
  [3159] = 2411,
  [3160] = 2329,
  [3161] = 3161,
  [3162] = 2158,
  [3163] = 3163,
  [3164] = 2499,
  [3165] = 1969,
  [3166] = 3166,
  [3167] = 1972,
  [3168] = 2068,
  [3169] = 3169,
  [3170] = 2112,
  [3171] = 2497,
  [3172] = 2497,
  [3173] = 2310,
  [3174] = 2305,
  [3175] = 2071,
  [3176] = 2498,
  [3177] = 2498,
  [3178] = 2154,
  [3179] = 2305,
  [3180] = 3180,
  [3181] = 2302,
  [3182] = 2166,
  [3183] = 2113,
  [3184] = 2499,
  [3185] = 2125,
  [3186] = 2285,
  [3187] = 2126,
  [3188] = 3188,
  [3189] = 2549,
  [3190] = 2549,
  [3191] = 2178,
  [3192] = 2379,
  [3193] = 2182,
  [3194] = 2179,
  [3195] = 3195,
  [3196] = 2293,
  [3197] = 2070,
  [3198] = 2026,
  [3199] = 2329,
  [3200] = 2116,
  [3201] = 3201,
  [3202] = 3202,
  [3203] = 1974,
  [3204] = 2301,
  [3205] = 2274,
  [3206] = 2277,
  [3207] = 2509,
  [3208] = 2281,
  [3209] = 3209,
  [3210] = 2440,
  [3211] = 2439,
  [3212] = 2283,
  [3213] = 2291,
  [3214] = 3202,
  [3215] = 2295,
  [3216] = 2417,
  [3217] = 2930,
  [3218] = 2026,
  [3219] = 1975,
  [3220] = 2866,
  [3221] = 2918,
  [3222] = 2917,
  [3223] = 2179,
  [3224] = 2467,
  [3225] = 2308,
  [3226] = 2309,
  [3227] = 2920,
  [3228] = 2466,
  [3229] = 2182,
  [3230] = 2178,
  [3231] = 2451,
  [3232] = 2268,
  [3233] = 2405,
  [3234] = 3234,
  [3235] = 2867,
  [3236] = 2158,
  [3237] = 2398,
  [3238] = 2265,
  [3239] = 2635,
  [3240] = 2440,
  [3241] = 2975,
  [3242] = 2292,
  [3243] = 2439,
  [3244] = 3234,
  [3245] = 2893,
  [3246] = 2264,
  [3247] = 2178,
  [3248] = 2182,
  [3249] = 3202,
  [3250] = 2179,
  [3251] = 2638,
  [3252] = 2329,
  [3253] = 3253,
  [3254] = 3202,
  [3255] = 2282,
  [3256] = 1974,
  [3257] = 1969,
  [3258] = 1970,
  [3259] = 2436,
  [3260] = 2437,
  [3261] = 2299,
  [3262] = 2902,
  [3263] = 2266,
  [3264] = 3234,
  [3265] = 2422,
  [3266] = 2269,
  [3267] = 2279,
  [3268] = 2284,
  [3269] = 2467,
  [3270] = 2417,
  [3271] = 2305,
  [3272] = 3272,
  [3273] = 2286,
  [3274] = 2398,
  [3275] = 3202,
  [3276] = 3234,
  [3277] = 2345,
  [3278] = 2158,
  [3279] = 2492,
  [3280] = 1968,
  [3281] = 1973,
  [3282] = 1971,
  [3283] = 2339,
  [3284] = 2338,
  [3285] = 2264,
  [3286] = 2334,
  [3287] = 2333,
  [3288] = 2349,
  [3289] = 3289,
  [3290] = 2519,
  [3291] = 2492,
  [3292] = 2540,
  [3293] = 2325,
  [3294] = 2324,
  [3295] = 3234,
  [3296] = 3296,
  [3297] = 2574,
  [3298] = 2346,
  [3299] = 3234,
  [3300] = 2511,
  [3301] = 3301,
  [3302] = 2453,
  [3303] = 2344,
  [3304] = 1972,
  [3305] = 2489,
  [3306] = 1967,
  [3307] = 2268,
  [3308] = 338,
  [3309] = 2453,
  [3310] = 2446,
  [3311] = 2347,
  [3312] = 2343,
  [3313] = 2348,
  [3314] = 1974,
  [3315] = 3234,
  [3316] = 2971,
  [3317] = 3234,
  [3318] = 1969,
  [3319] = 1970,
  [3320] = 1968,
  [3321] = 2446,
  [3322] = 2405,
  [3323] = 1973,
  [3324] = 1971,
  [3325] = 2451,
  [3326] = 2436,
  [3327] = 3234,
  [3328] = 285,
  [3329] = 2437,
  [3330] = 2960,
  [3331] = 1972,
  [3332] = 2466,
  [3333] = 3333,
  [3334] = 1972,
  [3335] = 3335,
  [3336] = 1971,
  [3337] = 1973,
  [3338] = 1968,
  [3339] = 1970,
  [3340] = 1969,
  [3341] = 2398,
  [3342] = 2262,
  [3343] = 3158,
  [3344] = 3161,
  [3345] = 3163,
  [3346] = 3140,
  [3347] = 3289,
  [3348] = 3166,
  [3349] = 3134,
  [3350] = 2423,
  [3351] = 3351,
  [3352] = 2280,
  [3353] = 2280,
  [3354] = 3154,
  [3355] = 3151,
  [3356] = 2310,
  [3357] = 2302,
  [3358] = 3296,
  [3359] = 3169,
  [3360] = 3144,
  [3361] = 3142,
  [3362] = 2285,
  [3363] = 2379,
  [3364] = 2249,
  [3365] = 2249,
  [3366] = 3201,
  [3367] = 3132,
  [3368] = 2285,
  [3369] = 2293,
  [3370] = 2437,
  [3371] = 2436,
  [3372] = 2166,
  [3373] = 3188,
  [3374] = 3333,
  [3375] = 1967,
  [3376] = 2264,
  [3377] = 3377,
  [3378] = 3144,
  [3379] = 2310,
  [3380] = 2417,
  [3381] = 3188,
  [3382] = 3195,
  [3383] = 1975,
  [3384] = 2302,
  [3385] = 2439,
  [3386] = 2440,
  [3387] = 3134,
  [3388] = 3351,
  [3389] = 2411,
  [3390] = 3180,
  [3391] = 3140,
  [3392] = 2467,
  [3393] = 2466,
  [3394] = 2451,
  [3395] = 2405,
  [3396] = 2293,
  [3397] = 2767,
  [3398] = 2446,
  [3399] = 2580,
  [3400] = 3142,
  [3401] = 2453,
  [3402] = 3169,
  [3403] = 2821,
  [3404] = 2817,
  [3405] = 3154,
  [3406] = 2818,
  [3407] = 3148,
  [3408] = 2829,
  [3409] = 3132,
  [3410] = 1967,
  [3411] = 2262,
  [3412] = 2126,
  [3413] = 2166,
  [3414] = 2154,
  [3415] = 2112,
  [3416] = 2026,
  [3417] = 2828,
  [3418] = 3418,
  [3419] = 2804,
  [3420] = 3151,
  [3421] = 3421,
  [3422] = 3148,
  [3423] = 2385,
  [3424] = 2116,
  [3425] = 3195,
  [3426] = 3426,
  [3427] = 3166,
  [3428] = 3180,
  [3429] = 3201,
  [3430] = 2806,
  [3431] = 3431,
  [3432] = 3158,
  [3433] = 3351,
  [3434] = 3351,
  [3435] = 3161,
  [3436] = 2790,
  [3437] = 2113,
  [3438] = 2154,
  [3439] = 3163,
  [3440] = 3440,
  [3441] = 2339,
  [3442] = 2274,
  [3443] = 1968,
  [3444] = 2349,
  [3445] = 2346,
  [3446] = 1973,
  [3447] = 2325,
  [3448] = 1971,
  [3449] = 2249,
  [3450] = 2344,
  [3451] = 2282,
  [3452] = 2347,
  [3453] = 2299,
  [3454] = 2266,
  [3455] = 2269,
  [3456] = 2279,
  [3457] = 3457,
  [3458] = 2541,
  [3459] = 2536,
  [3460] = 2542,
  [3461] = 2553,
  [3462] = 2343,
  [3463] = 2291,
  [3464] = 2301,
  [3465] = 3289,
  [3466] = 2489,
  [3467] = 2309,
  [3468] = 2308,
  [3469] = 2830,
  [3470] = 2284,
  [3471] = 2295,
  [3472] = 2291,
  [3473] = 2292,
  [3474] = 2348,
  [3475] = 2283,
  [3476] = 1967,
  [3477] = 2281,
  [3478] = 2329,
  [3479] = 2277,
  [3480] = 3440,
  [3481] = 2274,
  [3482] = 2286,
  [3483] = 3440,
  [3484] = 2265,
  [3485] = 3440,
  [3486] = 1111,
  [3487] = 2519,
  [3488] = 2422,
  [3489] = 2509,
  [3490] = 2574,
  [3491] = 1970,
  [3492] = 3457,
  [3493] = 2299,
  [3494] = 2345,
  [3495] = 2154,
  [3496] = 3333,
  [3497] = 2266,
  [3498] = 2269,
  [3499] = 2348,
  [3500] = 1975,
  [3501] = 2343,
  [3502] = 2268,
  [3503] = 2166,
  [3504] = 2792,
  [3505] = 3296,
  [3506] = 2347,
  [3507] = 3457,
  [3508] = 2570,
  [3509] = 2422,
  [3510] = 2339,
  [3511] = 1972,
  [3512] = 2283,
  [3513] = 2338,
  [3514] = 3457,
  [3515] = 2265,
  [3516] = 2345,
  [3517] = 2324,
  [3518] = 2295,
  [3519] = 3440,
  [3520] = 2573,
  [3521] = 2423,
  [3522] = 2344,
  [3523] = 2566,
  [3524] = 2564,
  [3525] = 2846,
  [3526] = 2293,
  [3527] = 2540,
  [3528] = 2281,
  [3529] = 2309,
  [3530] = 2831,
  [3531] = 2385,
  [3532] = 3457,
  [3533] = 2280,
  [3534] = 2334,
  [3535] = 2333,
  [3536] = 2333,
  [3537] = 2279,
  [3538] = 2847,
  [3539] = 2308,
  [3540] = 2305,
  [3541] = 2292,
  [3542] = 1974,
  [3543] = 3440,
  [3544] = 2301,
  [3545] = 2282,
  [3546] = 2329,
  [3547] = 2310,
  [3548] = 2302,
  [3549] = 2285,
  [3550] = 3440,
  [3551] = 3457,
  [3552] = 2286,
  [3553] = 2325,
  [3554] = 2334,
  [3555] = 2571,
  [3556] = 2559,
  [3557] = 3457,
  [3558] = 2262,
  [3559] = 2379,
  [3560] = 3440,
  [3561] = 2324,
  [3562] = 2811,
  [3563] = 2338,
  [3564] = 2284,
  [3565] = 2349,
  [3566] = 2552,
  [3567] = 2411,
  [3568] = 2268,
  [3569] = 2122,
  [3570] = 2121,
  [3571] = 1112,
  [3572] = 2511,
  [3573] = 1969,
  [3574] = 3440,
  [3575] = 2305,
  [3576] = 2346,
  [3577] = 2277,
  [3578] = 2672,
  [3579] = 2291,
  [3580] = 2796,
  [3581] = 2050,
  [3582] = 2957,
  [3583] = 2467,
  [3584] = 2874,
  [3585] = 2833,
  [3586] = 2909,
  [3587] = 2574,
  [3588] = 2935,
  [3589] = 2540,
  [3590] = 2466,
  [3591] = 3180,
  [3592] = 3592,
  [3593] = 2840,
  [3594] = 2792,
  [3595] = 3134,
  [3596] = 2451,
  [3597] = 2039,
  [3598] = 2405,
  [3599] = 1975,
  [3600] = 3140,
  [3601] = 2051,
  [3602] = 2511,
  [3603] = 3132,
  [3604] = 2847,
  [3605] = 2489,
  [3606] = 2041,
  [3607] = 2878,
  [3608] = 3421,
  [3609] = 3195,
  [3610] = 2825,
  [3611] = 2976,
  [3612] = 2804,
  [3613] = 2049,
  [3614] = 2859,
  [3615] = 2875,
  [3616] = 2873,
  [3617] = 3377,
  [3618] = 2422,
  [3619] = 2945,
  [3620] = 2872,
  [3621] = 2928,
  [3622] = 2821,
  [3623] = 2767,
  [3624] = 2893,
  [3625] = 3142,
  [3626] = 2913,
  [3627] = 2301,
  [3628] = 3628,
  [3629] = 2915,
  [3630] = 2948,
  [3631] = 2292,
  [3632] = 2885,
  [3633] = 2519,
  [3634] = 2929,
  [3635] = 2348,
  [3636] = 2343,
  [3637] = 2806,
  [3638] = 2347,
  [3639] = 3134,
  [3640] = 3148,
  [3641] = 2793,
  [3642] = 2876,
  [3643] = 2344,
  [3644] = 3195,
  [3645] = 2035,
  [3646] = 3144,
  [3647] = 2346,
  [3648] = 2951,
  [3649] = 2881,
  [3650] = 2349,
  [3651] = 2428,
  [3652] = 3151,
  [3653] = 3140,
  [3654] = 2042,
  [3655] = 2969,
  [3656] = 3163,
  [3657] = 2932,
  [3658] = 2038,
  [3659] = 2898,
  [3660] = 3169,
  [3661] = 2052,
  [3662] = 2053,
  [3663] = 2040,
  [3664] = 3201,
  [3665] = 3161,
  [3666] = 2899,
  [3667] = 2398,
  [3668] = 3158,
  [3669] = 3166,
  [3670] = 2446,
  [3671] = 2902,
  [3672] = 3201,
  [3673] = 2265,
  [3674] = 2880,
  [3675] = 2453,
  [3676] = 2274,
  [3677] = 1967,
  [3678] = 2277,
  [3679] = 3166,
  [3680] = 2345,
  [3681] = 2281,
  [3682] = 2283,
  [3683] = 2967,
  [3684] = 3154,
  [3685] = 3158,
  [3686] = 2964,
  [3687] = 2295,
  [3688] = 2417,
  [3689] = 3151,
  [3690] = 3144,
  [3691] = 2794,
  [3692] = 3161,
  [3693] = 2308,
  [3694] = 2309,
  [3695] = 2886,
  [3696] = 2828,
  [3697] = 3154,
  [3698] = 2884,
  [3699] = 2122,
  [3700] = 3142,
  [3701] = 2801,
  [3702] = 2121,
  [3703] = 3163,
  [3704] = 3704,
  [3705] = 2439,
  [3706] = 2792,
  [3707] = 2440,
  [3708] = 2961,
  [3709] = 3188,
  [3710] = 3377,
  [3711] = 2975,
  [3712] = 2966,
  [3713] = 2580,
  [3714] = 2436,
  [3715] = 2936,
  [3716] = 2044,
  [3717] = 154,
  [3718] = 2509,
  [3719] = 2268,
  [3720] = 2896,
  [3721] = 2324,
  [3722] = 152,
  [3723] = 2282,
  [3724] = 2299,
  [3725] = 2437,
  [3726] = 2816,
  [3727] = 3132,
  [3728] = 2036,
  [3729] = 2963,
  [3730] = 2325,
  [3731] = 3431,
  [3732] = 2847,
  [3733] = 2266,
  [3734] = 2269,
  [3735] = 3169,
  [3736] = 2279,
  [3737] = 2946,
  [3738] = 2037,
  [3739] = 3421,
  [3740] = 2950,
  [3741] = 2960,
  [3742] = 2953,
  [3743] = 2954,
  [3744] = 2284,
  [3745] = 2286,
  [3746] = 2422,
  [3747] = 2847,
  [3748] = 2847,
  [3749] = 2937,
  [3750] = 2043,
  [3751] = 2971,
  [3752] = 2333,
  [3753] = 2877,
  [3754] = 2306,
  [3755] = 2956,
  [3756] = 3180,
  [3757] = 2865,
  [3758] = 3148,
  [3759] = 2927,
  [3760] = 2926,
  [3761] = 2829,
  [3762] = 2339,
  [3763] = 2867,
  [3764] = 2338,
  [3765] = 2920,
  [3766] = 2817,
  [3767] = 2818,
  [3768] = 2883,
  [3769] = 2034,
  [3770] = 2334,
  [3771] = 3188,
  [3772] = 2917,
  [3773] = 2918,
  [3774] = 2866,
  [3775] = 2046,
  [3776] = 2790,
  [3777] = 2930,
  [3778] = 2882,
  [3779] = 2048,
  [3780] = 2262,
  [3781] = 3161,
  [3782] = 1112,
  [3783] = 3163,
  [3784] = 2847,
  [3785] = 3140,
  [3786] = 2037,
  [3787] = 3134,
  [3788] = 3333,
  [3789] = 3789,
  [3790] = 2672,
  [3791] = 3421,
  [3792] = 3789,
  [3793] = 2831,
  [3794] = 2811,
  [3795] = 2830,
  [3796] = 2896,
  [3797] = 3789,
  [3798] = 2154,
  [3799] = 2573,
  [3800] = 2821,
  [3801] = 3151,
  [3802] = 3377,
  [3803] = 2867,
  [3804] = 3789,
  [3805] = 2446,
  [3806] = 3201,
  [3807] = 3333,
  [3808] = 1975,
  [3809] = 3180,
  [3810] = 2818,
  [3811] = 3811,
  [3812] = 3158,
  [3813] = 3166,
  [3814] = 2847,
  [3815] = 2453,
  [3816] = 3789,
  [3817] = 3148,
  [3818] = 3154,
  [3819] = 2866,
  [3820] = 2553,
  [3821] = 2817,
  [3822] = 2818,
  [3823] = 2806,
  [3824] = 2792,
  [3825] = 3789,
  [3826] = 2846,
  [3827] = 3169,
  [3828] = 2877,
  [3829] = 2398,
  [3830] = 3148,
  [3831] = 3188,
  [3832] = 2466,
  [3833] = 2829,
  [3834] = 3188,
  [3835] = 3835,
  [3836] = 3789,
  [3837] = 2467,
  [3838] = 3142,
  [3839] = 2121,
  [3840] = 2417,
  [3841] = 2790,
  [3842] = 2552,
  [3843] = 1111,
  [3844] = 2559,
  [3845] = 3144,
  [3846] = 2571,
  [3847] = 2280,
  [3848] = 2828,
  [3849] = 2847,
  [3850] = 2264,
  [3851] = 2804,
  [3852] = 3431,
  [3853] = 2122,
  [3854] = 2313,
  [3855] = 3789,
  [3856] = 1975,
  [3857] = 2310,
  [3858] = 2293,
  [3859] = 2806,
  [3860] = 2829,
  [3861] = 2439,
  [3862] = 2440,
  [3863] = 2051,
  [3864] = 3132,
  [3865] = 2436,
  [3866] = 2566,
  [3867] = 2437,
  [3868] = 2564,
  [3869] = 2865,
  [3870] = 3870,
  [3871] = 2125,
  [3872] = 3195,
  [3873] = 2817,
  [3874] = 3789,
  [3875] = 3789,
  [3876] = 2541,
  [3877] = 2536,
  [3878] = 3870,
  [3879] = 3195,
  [3880] = 3296,
  [3881] = 2580,
  [3882] = 3296,
  [3883] = 2865,
  [3884] = 2249,
  [3885] = 2119,
  [3886] = 3169,
  [3887] = 3180,
  [3888] = 3289,
  [3889] = 2847,
  [3890] = 2090,
  [3891] = 3789,
  [3892] = 2326,
  [3893] = 2542,
  [3894] = 3201,
  [3895] = 2821,
  [3896] = 2930,
  [3897] = 2166,
  [3898] = 3289,
  [3899] = 2451,
  [3900] = 2767,
  [3901] = 3901,
  [3902] = 2048,
  [3903] = 2877,
  [3904] = 2405,
  [3905] = 2306,
  [3906] = 2804,
  [3907] = 3132,
  [3908] = 3142,
  [3909] = 2828,
  [3910] = 2285,
  [3911] = 3144,
  [3912] = 2896,
  [3913] = 3151,
  [3914] = 3154,
  [3915] = 2918,
  [3916] = 3166,
  [3917] = 3158,
  [3918] = 3901,
  [3919] = 3161,
  [3920] = 3870,
  [3921] = 2917,
  [3922] = 3163,
  [3923] = 3140,
  [3924] = 2570,
  [3925] = 3134,
  [3926] = 2975,
  [3927] = 2920,
  [3928] = 2302,
  [3929] = 3929,
  [3930] = 3930,
  [3931] = 2638,
  [3932] = 2927,
  [3933] = 2552,
  [3934] = 3930,
  [3935] = 2043,
  [3936] = 3936,
  [3937] = 2877,
  [3938] = 2428,
  [3939] = 2326,
  [3940] = 154,
  [3941] = 3941,
  [3942] = 2348,
  [3943] = 2343,
  [3944] = 2428,
  [3945] = 2902,
  [3946] = 2936,
  [3947] = 2347,
  [3948] = 2937,
  [3949] = 3949,
  [3950] = 2847,
  [3951] = 3930,
  [3952] = 2953,
  [3953] = 2044,
  [3954] = 2963,
  [3955] = 2966,
  [3956] = 2344,
  [3957] = 2346,
  [3958] = 2847,
  [3959] = 2349,
  [3960] = 2068,
  [3961] = 2489,
  [3962] = 152,
  [3963] = 2050,
  [3964] = 2049,
  [3965] = 3965,
  [3966] = 3965,
  [3967] = 3936,
  [3968] = 2042,
  [3969] = 2926,
  [3970] = 3941,
  [3971] = 2039,
  [3972] = 2811,
  [3973] = 2635,
  [3974] = 2071,
  [3975] = 2313,
  [3976] = 3941,
  [3977] = 2036,
  [3978] = 3965,
  [3979] = 2559,
  [3980] = 2846,
  [3981] = 2042,
  [3982] = 3929,
  [3983] = 2571,
  [3984] = 2859,
  [3985] = 2039,
  [3986] = 3949,
  [3987] = 2044,
  [3988] = 2960,
  [3989] = 2275,
  [3990] = 3930,
  [3991] = 2950,
  [3992] = 2881,
  [3993] = 2036,
  [3994] = 2876,
  [3995] = 3930,
  [3996] = 2796,
  [3997] = 3930,
  [3998] = 3929,
  [3999] = 2794,
  [4000] = 2801,
  [4001] = 2793,
  [4002] = 2961,
  [4003] = 2046,
  [4004] = 2816,
  [4005] = 2875,
  [4006] = 2041,
  [4007] = 2034,
  [4008] = 3431,
  [4009] = 3949,
  [4010] = 3936,
  [4011] = 2874,
  [4012] = 2932,
  [4013] = 2929,
  [4014] = 2873,
  [4015] = 2050,
  [4016] = 2064,
  [4017] = 2840,
  [4018] = 2511,
  [4019] = 3930,
  [4020] = 4020,
  [4021] = 2049,
  [4022] = 2883,
  [4023] = 2882,
  [4024] = 2885,
  [4025] = 2872,
  [4026] = 2913,
  [4027] = 2265,
  [4028] = 2831,
  [4029] = 3965,
  [4030] = 2037,
  [4031] = 2896,
  [4032] = 2969,
  [4033] = 3941,
  [4034] = 2975,
  [4035] = 3628,
  [4036] = 2564,
  [4037] = 3930,
  [4038] = 2880,
  [4039] = 2566,
  [4040] = 2573,
  [4041] = 2928,
  [4042] = 2274,
  [4043] = 2553,
  [4044] = 2277,
  [4045] = 2542,
  [4046] = 2281,
  [4047] = 3123,
  [4048] = 2536,
  [4049] = 2541,
  [4050] = 2283,
  [4051] = 2570,
  [4052] = 2038,
  [4053] = 2957,
  [4054] = 2428,
  [4055] = 2292,
  [4056] = 3949,
  [4057] = 2967,
  [4058] = 2884,
  [4059] = 2291,
  [4060] = 2324,
  [4061] = 2672,
  [4062] = 2040,
  [4063] = 2053,
  [4064] = 4064,
  [4065] = 2325,
  [4066] = 3936,
  [4067] = 2070,
  [4068] = 3431,
  [4069] = 2301,
  [4070] = 2295,
  [4071] = 2052,
  [4072] = 2833,
  [4073] = 2898,
  [4074] = 2043,
  [4075] = 2306,
  [4076] = 2035,
  [4077] = 2308,
  [4078] = 2422,
  [4079] = 2309,
  [4080] = 2792,
  [4081] = 154,
  [4082] = 2899,
  [4083] = 2574,
  [4084] = 2038,
  [4085] = 2333,
  [4086] = 2334,
  [4087] = 2338,
  [4088] = 1112,
  [4089] = 2339,
  [4090] = 3333,
  [4091] = 2847,
  [4092] = 2422,
  [4093] = 2878,
  [4094] = 2976,
  [4095] = 4095,
  [4096] = 2956,
  [4097] = 3941,
  [4098] = 3296,
  [4099] = 1111,
  [4100] = 3965,
  [4101] = 2886,
  [4102] = 3941,
  [4103] = 2945,
  [4104] = 2048,
  [4105] = 3289,
  [4106] = 2946,
  [4107] = 2540,
  [4108] = 3929,
  [4109] = 3949,
  [4110] = 3965,
  [4111] = 2034,
  [4112] = 4112,
  [4113] = 2051,
  [4114] = 2041,
  [4115] = 2825,
  [4116] = 2046,
  [4117] = 2268,
  [4118] = 4064,
  [4119] = 2935,
  [4120] = 2964,
  [4121] = 2345,
  [4122] = 2930,
  [4123] = 2909,
  [4124] = 3949,
  [4125] = 3930,
  [4126] = 2866,
  [4127] = 2279,
  [4128] = 2918,
  [4129] = 2282,
  [4130] = 2299,
  [4131] = 3929,
  [4132] = 2266,
  [4133] = 2269,
  [4134] = 2284,
  [4135] = 2971,
  [4136] = 2917,
  [4137] = 2920,
  [4138] = 2830,
  [4139] = 2951,
  [4140] = 2893,
  [4141] = 2867,
  [4142] = 2915,
  [4143] = 2286,
  [4144] = 2035,
  [4145] = 2052,
  [4146] = 2865,
  [4147] = 2053,
  [4148] = 2040,
  [4149] = 2948,
  [4150] = 3936,
  [4151] = 2954,
  [4152] = 3929,
  [4153] = 152,
  [4154] = 3431,
  [4155] = 3195,
  [4156] = 2875,
  [4157] = 2872,
  [4158] = 4020,
  [4159] = 2948,
  [4160] = 2961,
  [4161] = 2122,
  [4162] = 2071,
  [4163] = 2121,
  [4164] = 2064,
  [4165] = 2951,
  [4166] = 2090,
  [4167] = 2964,
  [4168] = 2043,
  [4169] = 2549,
  [4170] = 2041,
  [4171] = 4064,
  [4172] = 2884,
  [4173] = 2935,
  [4174] = 3132,
  [4175] = 4175,
  [4176] = 2829,
  [4177] = 2840,
  [4178] = 2909,
  [4179] = 2119,
  [4180] = 2499,
  [4181] = 2816,
  [4182] = 3148,
  [4183] = 2035,
  [4184] = 2928,
  [4185] = 2039,
  [4186] = 2038,
  [4187] = 2950,
  [4188] = 2818,
  [4189] = 2930,
  [4190] = 3142,
  [4191] = 2828,
  [4192] = 2866,
  [4193] = 3144,
  [4194] = 3151,
  [4195] = 2913,
  [4196] = 3154,
  [4197] = 3166,
  [4198] = 3158,
  [4199] = 3161,
  [4200] = 3163,
  [4201] = 3140,
  [4202] = 3134,
  [4203] = 3025,
  [4204] = 2918,
  [4205] = 2917,
  [4206] = 3426,
  [4207] = 3431,
  [4208] = 2817,
  [4209] = 2920,
  [4210] = 2867,
  [4211] = 2976,
  [4212] = 2052,
  [4213] = 2804,
  [4214] = 2053,
  [4215] = 2040,
  [4216] = 2877,
  [4217] = 2801,
  [4218] = 2068,
  [4219] = 2794,
  [4220] = 2821,
  [4221] = 2070,
  [4222] = 2796,
  [4223] = 2885,
  [4224] = 1975,
  [4225] = 2859,
  [4226] = 2498,
  [4227] = 2497,
  [4228] = 2825,
  [4229] = 2493,
  [4230] = 2833,
  [4231] = 2865,
  [4232] = 2880,
  [4233] = 2902,
  [4234] = 2882,
  [4235] = 2883,
  [4236] = 154,
  [4237] = 2049,
  [4238] = 2050,
  [4239] = 1112,
  [4240] = 2491,
  [4241] = 2125,
  [4242] = 3201,
  [4243] = 2893,
  [4244] = 3431,
  [4245] = 2493,
  [4246] = 3188,
  [4247] = 2494,
  [4248] = 2042,
  [4249] = 2926,
  [4250] = 2876,
  [4251] = 2874,
  [4252] = 2790,
  [4253] = 2927,
  [4254] = 2873,
  [4255] = 152,
  [4256] = 2898,
  [4257] = 2899,
  [4258] = 2119,
  [4259] = 2937,
  [4260] = 2945,
  [4261] = 2946,
  [4262] = 2063,
  [4263] = 2971,
  [4264] = 2954,
  [4265] = 2793,
  [4266] = 2953,
  [4267] = 2497,
  [4268] = 2498,
  [4269] = 2967,
  [4270] = 2957,
  [4271] = 2963,
  [4272] = 2499,
  [4273] = 2494,
  [4274] = 3180,
  [4275] = 2306,
  [4276] = 2966,
  [4277] = 2881,
  [4278] = 3169,
  [4279] = 2969,
  [4280] = 4280,
  [4281] = 2975,
  [4282] = 2044,
  [4283] = 2956,
  [4284] = 2036,
  [4285] = 2491,
  [4286] = 2046,
  [4287] = 2492,
  [4288] = 2960,
  [4289] = 2034,
  [4290] = 2936,
  [4291] = 2932,
  [4292] = 3418,
  [4293] = 3592,
  [4294] = 4064,
  [4295] = 1111,
  [4296] = 2886,
  [4297] = 2125,
  [4298] = 2878,
  [4299] = 2929,
  [4300] = 2549,
  [4301] = 2090,
  [4302] = 2896,
  [4303] = 4303,
  [4304] = 2915,
  [4305] = 2638,
  [4306] = 2313,
  [4307] = 4064,
  [4308] = 1972,
  [4309] = 2830,
  [4310] = 4064,
  [4311] = 1969,
  [4312] = 1971,
  [4313] = 2122,
  [4314] = 2121,
  [4315] = 1973,
  [4316] = 3296,
  [4317] = 4064,
  [4318] = 1975,
  [4319] = 1968,
  [4320] = 1970,
  [4321] = 1974,
  [4322] = 2071,
  [4323] = 4064,
  [4324] = 2064,
  [4325] = 4064,
  [4326] = 3333,
  [4327] = 2790,
  [4328] = 2182,
  [4329] = 2178,
  [4330] = 2125,
  [4331] = 4064,
  [4332] = 2638,
  [4333] = 4064,
  [4334] = 2635,
  [4335] = 2070,
  [4336] = 2068,
  [4337] = 2063,
  [4338] = 3289,
  [4339] = 2158,
  [4340] = 2635,
  [4341] = 2492,
  [4342] = 2179,
  [4343] = 4064,
  [4344] = 2326,
  [4345] = 2119,
  [4346] = 2428,
  [4347] = 4347,
  [4348] = 2927,
  [4349] = 2119,
  [4350] = 2873,
  [4351] = 2953,
  [4352] = 2125,
  [4353] = 2945,
  [4354] = 2928,
  [4355] = 2946,
  [4356] = 2963,
  [4357] = 2948,
  [4358] = 2064,
  [4359] = 2070,
  [4360] = 2976,
  [4361] = 2898,
  [4362] = 2068,
  [4363] = 154,
  [4364] = 2549,
  [4365] = 2125,
  [4366] = 2885,
  [4367] = 2039,
  [4368] = 2859,
  [4369] = 2872,
  [4370] = 2828,
  [4371] = 2951,
  [4372] = 2960,
  [4373] = 2126,
  [4374] = 2899,
  [4375] = 2964,
  [4376] = 2038,
  [4377] = 4064,
  [4378] = 2071,
  [4379] = 2880,
  [4380] = 2041,
  [4381] = 2971,
  [4382] = 2882,
  [4383] = 2883,
  [4384] = 2875,
  [4385] = 2499,
  [4386] = 1967,
  [4387] = 2825,
  [4388] = 2498,
  [4389] = 2966,
  [4390] = 2935,
  [4391] = 2497,
  [4392] = 2909,
  [4393] = 2035,
  [4394] = 4064,
  [4395] = 2902,
  [4396] = 2119,
  [4397] = 2049,
  [4398] = 2050,
  [4399] = 2064,
  [4400] = 2052,
  [4401] = 2053,
  [4402] = 2040,
  [4403] = 152,
  [4404] = 2893,
  [4405] = 4064,
  [4406] = 2885,
  [4407] = 2874,
  [4408] = 2821,
  [4409] = 2830,
  [4410] = 2876,
  [4411] = 2044,
  [4412] = 2264,
  [4413] = 2953,
  [4414] = 2951,
  [4415] = 2829,
  [4416] = 2036,
  [4417] = 2116,
  [4418] = 2936,
  [4419] = 2913,
  [4420] = 2818,
  [4421] = 2068,
  [4422] = 2113,
  [4423] = 2428,
  [4424] = 2070,
  [4425] = 2491,
  [4426] = 2068,
  [4427] = 2804,
  [4428] = 2937,
  [4429] = 2880,
  [4430] = 2493,
  [4431] = 2494,
  [4432] = 4064,
  [4433] = 2046,
  [4434] = 2950,
  [4435] = 2043,
  [4436] = 2957,
  [4437] = 2967,
  [4438] = 2926,
  [4439] = 2070,
  [4440] = 2817,
  [4441] = 2929,
  [4442] = 2063,
  [4443] = 2884,
  [4444] = 2042,
  [4445] = 2932,
  [4446] = 2034,
  [4447] = 2112,
  [4448] = 2071,
  [4449] = 2071,
  [4450] = 2026,
  [4451] = 2946,
  [4452] = 2872,
  [4453] = 2638,
  [4454] = 2945,
  [4455] = 2064,
  [4456] = 2967,
  [4457] = 2935,
  [4458] = 3592,
  [4459] = 1972,
  [4460] = 2913,
  [4461] = 2976,
  [4462] = 1971,
  [4463] = 1973,
  [4464] = 2876,
  [4465] = 2966,
  [4466] = 2898,
  [4467] = 1968,
  [4468] = 1970,
  [4469] = 2305,
  [4470] = 2179,
  [4471] = 2635,
  [4472] = 2305,
  [4473] = 1969,
  [4474] = 2329,
  [4475] = 2635,
  [4476] = 2926,
  [4477] = 4064,
  [4478] = 1974,
  [4479] = 2932,
  [4480] = 2927,
  [4481] = 2963,
  [4482] = 2884,
  [4483] = 2950,
  [4484] = 2178,
  [4485] = 4485,
  [4486] = 2068,
  [4487] = 2875,
  [4488] = 2182,
  [4489] = 4064,
  [4490] = 2638,
  [4491] = 2929,
  [4492] = 2937,
  [4493] = 2070,
  [4494] = 2936,
  [4495] = 2928,
  [4496] = 2492,
  [4497] = 2899,
  [4498] = 2158,
  [4499] = 2874,
  [4500] = 2873,
  [4501] = 2957,
  [4502] = 2306,
  [4503] = 2964,
  [4504] = 2882,
  [4505] = 2948,
  [4506] = 2329,
  [4507] = 2909,
  [4508] = 2883,
  [4509] = 2540,
  [4510] = 2574,
  [4511] = 1975,
  [4512] = 2446,
  [4513] = 2453,
  [4514] = 2451,
  [4515] = 2405,
  [4516] = 2440,
  [4517] = 2439,
  [4518] = 2446,
  [4519] = 2453,
  [4520] = 2116,
  [4521] = 2264,
  [4522] = 2112,
  [4523] = 4523,
  [4524] = 4523,
  [4525] = 4525,
  [4526] = 2417,
  [4527] = 2428,
  [4528] = 2116,
  [4529] = 2405,
  [4530] = 2451,
  [4531] = 4525,
  [4532] = 2466,
  [4533] = 2398,
  [4534] = 2466,
  [4535] = 2437,
  [4536] = 2467,
  [4537] = 2417,
  [4538] = 4095,
  [4539] = 2126,
  [4540] = 2511,
  [4541] = 2467,
  [4542] = 2439,
  [4543] = 2440,
  [4544] = 2398,
  [4545] = 2436,
  [4546] = 2112,
  [4547] = 4525,
  [4548] = 4548,
  [4549] = 2126,
  [4550] = 2489,
  [4551] = 2437,
  [4552] = 2113,
  [4553] = 4523,
  [4554] = 4112,
  [4555] = 2436,
  [4556] = 2113,
  [4557] = 4557,
  [4558] = 4558,
  [4559] = 4559,
  [4560] = 4560,
  [4561] = 4561,
  [4562] = 4562,
  [4563] = 2305,
  [4564] = 4561,
  [4565] = 4560,
  [4566] = 4566,
  [4567] = 4560,
  [4568] = 4568,
  [4569] = 4558,
  [4570] = 4570,
  [4571] = 4558,
  [4572] = 2119,
  [4573] = 4557,
  [4574] = 2249,
  [4575] = 4568,
  [4576] = 4559,
  [4577] = 4566,
  [4578] = 4566,
  [4579] = 4558,
  [4580] = 4560,
  [4581] = 4568,
  [4582] = 2329,
  [4583] = 4064,
  [4584] = 2262,
  [4585] = 4562,
  [4586] = 4562,
  [4587] = 4561,
  [4588] = 4557,
  [4589] = 4566,
  [4590] = 4561,
  [4591] = 4562,
  [4592] = 4561,
  [4593] = 4560,
  [4594] = 4557,
  [4595] = 4568,
  [4596] = 4568,
  [4597] = 4566,
  [4598] = 4568,
  [4599] = 2310,
  [4600] = 4560,
  [4601] = 4560,
  [4602] = 2280,
  [4603] = 4568,
  [4604] = 4064,
  [4605] = 4558,
  [4606] = 2302,
  [4607] = 4559,
  [4608] = 4608,
  [4609] = 4523,
  [4610] = 4559,
  [4611] = 1967,
  [4612] = 2285,
  [4613] = 4560,
  [4614] = 2293,
  [4615] = 4558,
  [4616] = 2166,
  [4617] = 4561,
  [4618] = 4562,
  [4619] = 4568,
  [4620] = 4557,
  [4621] = 4560,
  [4622] = 4558,
  [4623] = 4064,
  [4624] = 4558,
  [4625] = 4557,
  [4626] = 4566,
  [4627] = 4559,
  [4628] = 4566,
  [4629] = 4568,
  [4630] = 4562,
  [4631] = 4559,
  [4632] = 4559,
  [4633] = 4562,
  [4634] = 4559,
  [4635] = 4559,
  [4636] = 4568,
  [4637] = 4559,
  [4638] = 4558,
  [4639] = 2154,
  [4640] = 4562,
  [4641] = 4561,
  [4642] = 4560,
  [4643] = 4566,
  [4644] = 4559,
  [4645] = 4560,
  [4646] = 4559,
  [4647] = 2125,
  [4648] = 4557,
  [4649] = 4561,
  [4650] = 4557,
  [4651] = 4568,
  [4652] = 4558,
  [4653] = 4557,
  [4654] = 4525,
  [4655] = 3592,
  [4656] = 4064,
  [4657] = 4557,
  [4658] = 4557,
  [4659] = 4558,
  [4660] = 2277,
  [4661] = 2440,
  [4662] = 4523,
  [4663] = 2635,
  [4664] = 4664,
  [4665] = 2345,
  [4666] = 2638,
  [4667] = 2116,
  [4668] = 4664,
  [4669] = 4525,
  [4670] = 2453,
  [4671] = 2349,
  [4672] = 2346,
  [4673] = 2344,
  [4674] = 2446,
  [4675] = 2347,
  [4676] = 2343,
  [4677] = 2348,
  [4678] = 4664,
  [4679] = 4679,
  [4680] = 2286,
  [4681] = 2284,
  [4682] = 2279,
  [4683] = 2269,
  [4684] = 4684,
  [4685] = 2266,
  [4686] = 4664,
  [4687] = 2299,
  [4688] = 2282,
  [4689] = 4689,
  [4690] = 4664,
  [4691] = 4664,
  [4692] = 4664,
  [4693] = 2324,
  [4694] = 2405,
  [4695] = 4664,
  [4696] = 2325,
  [4697] = 2451,
  [4698] = 4664,
  [4699] = 2466,
  [4700] = 2467,
  [4701] = 1975,
  [4702] = 2638,
  [4703] = 2112,
  [4704] = 2292,
  [4705] = 4664,
  [4706] = 2301,
  [4707] = 2439,
  [4708] = 2126,
  [4709] = 2417,
  [4710] = 2398,
  [4711] = 4664,
  [4712] = 2090,
  [4713] = 2339,
  [4714] = 2338,
  [4715] = 4525,
  [4716] = 2635,
  [4717] = 2334,
  [4718] = 2333,
  [4719] = 2309,
  [4720] = 2308,
  [4721] = 4664,
  [4722] = 4664,
  [4723] = 2295,
  [4724] = 2265,
  [4725] = 2291,
  [4726] = 2436,
  [4727] = 2437,
  [4728] = 4664,
  [4729] = 4523,
  [4730] = 2283,
  [4731] = 2113,
  [4732] = 4732,
  [4733] = 2281,
  [4734] = 2274,
  [4735] = 4735,
  [4736] = 2285,
  [4737] = 2916,
  [4738] = 4735,
  [4739] = 2113,
  [4740] = 3134,
  [4741] = 4741,
  [4742] = 4735,
  [4743] = 4743,
  [4744] = 3144,
  [4745] = 2126,
  [4746] = 3151,
  [4747] = 4747,
  [4748] = 3154,
  [4749] = 2893,
  [4750] = 3166,
  [4751] = 2971,
  [4752] = 2960,
  [4753] = 4523,
  [4754] = 2166,
  [4755] = 2902,
  [4756] = 3169,
  [4757] = 3158,
  [4758] = 2302,
  [4759] = 3161,
  [4760] = 2941,
  [4761] = 4741,
  [4762] = 4747,
  [4763] = 4763,
  [4764] = 4741,
  [4765] = 4747,
  [4766] = 3132,
  [4767] = 2249,
  [4768] = 3148,
  [4769] = 3163,
  [4770] = 4741,
  [4771] = 4747,
  [4772] = 3188,
  [4773] = 4747,
  [4774] = 4774,
  [4775] = 3201,
  [4776] = 3195,
  [4777] = 4525,
  [4778] = 2112,
  [4779] = 4735,
  [4780] = 4485,
  [4781] = 4735,
  [4782] = 2154,
  [4783] = 2262,
  [4784] = 4741,
  [4785] = 4743,
  [4786] = 2116,
  [4787] = 2293,
  [4788] = 4747,
  [4789] = 2310,
  [4790] = 3140,
  [4791] = 3142,
  [4792] = 4741,
  [4793] = 2280,
  [4794] = 4735,
  [4795] = 3180,
  [4796] = 2540,
  [4797] = 2266,
  [4798] = 4525,
  [4799] = 2279,
  [4800] = 2299,
  [4801] = 2282,
  [4802] = 2269,
  [4803] = 2301,
  [4804] = 2284,
  [4805] = 2286,
  [4806] = 2511,
  [4807] = 2265,
  [4808] = 2574,
  [4809] = 4523,
  [4810] = 2511,
  [4811] = 2349,
  [4812] = 2274,
  [4813] = 2346,
  [4814] = 2277,
  [4815] = 2344,
  [4816] = 2281,
  [4817] = 2283,
  [4818] = 2347,
  [4819] = 3289,
  [4820] = 2343,
  [4821] = 2348,
  [4822] = 2291,
  [4823] = 3930,
  [4824] = 2489,
  [4825] = 2295,
  [4826] = 3296,
  [4827] = 2345,
  [4828] = 2489,
  [4829] = 1967,
  [4830] = 3930,
  [4831] = 2324,
  [4832] = 2308,
  [4833] = 2422,
  [4834] = 2309,
  [4835] = 2339,
  [4836] = 2338,
  [4837] = 2334,
  [4838] = 2333,
  [4839] = 2540,
  [4840] = 3333,
  [4841] = 2574,
  [4842] = 2268,
  [4843] = 2292,
  [4844] = 2325,
  [4845] = 4845,
  [4846] = 3180,
  [4847] = 2825,
  [4848] = 3154,
  [4849] = 3142,
  [4850] = 3166,
  [4851] = 3201,
  [4852] = 2825,
  [4853] = 3151,
  [4854] = 3132,
  [4855] = 3144,
  [4856] = 4856,
  [4857] = 4774,
  [4858] = 1983,
  [4859] = 433,
  [4860] = 4523,
  [4861] = 4856,
  [4862] = 335,
  [4863] = 337,
  [4864] = 2804,
  [4865] = 4865,
  [4866] = 3188,
  [4867] = 3140,
  [4868] = 307,
  [4869] = 275,
  [4870] = 4865,
  [4871] = 3333,
  [4872] = 3134,
  [4873] = 3296,
  [4874] = 3289,
  [4875] = 4865,
  [4876] = 4845,
  [4877] = 421,
  [4878] = 2859,
  [4879] = 2859,
  [4880] = 2638,
  [4881] = 3158,
  [4882] = 4865,
  [4883] = 2635,
  [4884] = 2821,
  [4885] = 4525,
  [4886] = 3161,
  [4887] = 3163,
  [4888] = 3148,
  [4889] = 2829,
  [4890] = 2790,
  [4891] = 4891,
  [4892] = 1975,
  [4893] = 2828,
  [4894] = 3169,
  [4895] = 4856,
  [4896] = 2817,
  [4897] = 3195,
  [4898] = 2818,
  [4899] = 4845,
  [4900] = 3050,
  [4901] = 4523,
  [4902] = 2830,
  [4903] = 3025,
  [4904] = 3047,
  [4905] = 3333,
  [4906] = 3134,
  [4907] = 2428,
  [4908] = 3142,
  [4909] = 3180,
  [4910] = 4856,
  [4911] = 4679,
  [4912] = 3132,
  [4913] = 3144,
  [4914] = 2119,
  [4915] = 1967,
  [4916] = 3140,
  [4917] = 2428,
  [4918] = 3151,
  [4919] = 3154,
  [4920] = 4845,
  [4921] = 3166,
  [4922] = 4922,
  [4923] = 3201,
  [4924] = 3158,
  [4925] = 3169,
  [4926] = 2125,
  [4927] = 3148,
  [4928] = 4525,
  [4929] = 3188,
  [4930] = 3195,
  [4931] = 3161,
  [4932] = 4932,
  [4933] = 3289,
  [4934] = 3163,
  [4935] = 3296,
  [4936] = 4689,
  [4937] = 2306,
  [4938] = 4845,
  [4939] = 2902,
  [4940] = 2053,
  [4941] = 2040,
  [4942] = 2041,
  [4943] = 2043,
  [4944] = 2971,
  [4945] = 4945,
  [4946] = 4946,
  [4947] = 4891,
  [4948] = 4948,
  [4949] = 4949,
  [4950] = 2035,
  [4951] = 4891,
  [4952] = 4952,
  [4953] = 4945,
  [4954] = 4954,
  [4955] = 2052,
  [4956] = 4956,
  [4957] = 4957,
  [4958] = 4856,
  [4959] = 4959,
  [4960] = 4949,
  [4961] = 2960,
  [4962] = 4949,
  [4963] = 4949,
  [4964] = 152,
  [4965] = 4949,
  [4966] = 154,
  [4967] = 4967,
  [4968] = 4968,
  [4969] = 4949,
  [4970] = 4949,
  [4971] = 4949,
  [4972] = 4949,
  [4973] = 4973,
  [4974] = 4949,
  [4975] = 4948,
  [4976] = 4954,
  [4977] = 4946,
  [4978] = 2893,
  [4979] = 4945,
  [4980] = 2313,
  [4981] = 4949,
  [4982] = 4949,
  [4983] = 2326,
  [4984] = 2913,
  [4985] = 2041,
  [4986] = 2825,
  [4987] = 2876,
  [4988] = 2874,
  [4989] = 2873,
  [4990] = 2035,
  [4991] = 2898,
  [4992] = 2899,
  [4993] = 2945,
  [4994] = 2946,
  [4995] = 4954,
  [4996] = 2928,
  [4997] = 4967,
  [4998] = 4956,
  [4999] = 3148,
  [5000] = 2052,
  [5001] = 2053,
  [5002] = 2040,
  [5003] = 4948,
  [5004] = 4957,
  [5005] = 2967,
  [5006] = 2957,
  [5007] = 5007,
  [5008] = 4952,
  [5009] = 2976,
  [5010] = 4967,
  [5011] = 4948,
  [5012] = 4956,
  [5013] = 2039,
  [5014] = 4948,
  [5015] = 4954,
  [5016] = 4949,
  [5017] = 4954,
  [5018] = 2936,
  [5019] = 4949,
  [5020] = 5020,
  [5021] = 4967,
  [5022] = 2489,
  [5023] = 2872,
  [5024] = 2540,
  [5025] = 2935,
  [5026] = 2859,
  [5027] = 2909,
  [5028] = 4523,
  [5029] = 2034,
  [5030] = 2034,
  [5031] = 2046,
  [5032] = 4945,
  [5033] = 2046,
  [5034] = 2063,
  [5035] = 4523,
  [5036] = 4949,
  [5037] = 4525,
  [5038] = 5038,
  [5039] = 4954,
  [5040] = 4967,
  [5041] = 4948,
  [5042] = 4967,
  [5043] = 3195,
  [5044] = 4956,
  [5045] = 5045,
  [5046] = 4954,
  [5047] = 2036,
  [5048] = 2044,
  [5049] = 2885,
  [5050] = 4949,
  [5051] = 5051,
  [5052] = 2875,
  [5053] = 5053,
  [5054] = 152,
  [5055] = 2049,
  [5056] = 2050,
  [5057] = 3132,
  [5058] = 2929,
  [5059] = 2948,
  [5060] = 2951,
  [5061] = 4949,
  [5062] = 2964,
  [5063] = 4949,
  [5064] = 4956,
  [5065] = 3188,
  [5066] = 4954,
  [5067] = 2884,
  [5068] = 4967,
  [5069] = 2036,
  [5070] = 2042,
  [5071] = 2038,
  [5072] = 2511,
  [5073] = 5073,
  [5074] = 2044,
  [5075] = 2932,
  [5076] = 4948,
  [5077] = 4856,
  [5078] = 5078,
  [5079] = 2950,
  [5080] = 4956,
  [5081] = 4967,
  [5082] = 2038,
  [5083] = 2042,
  [5084] = 2039,
  [5085] = 4956,
  [5086] = 5086,
  [5087] = 2880,
  [5088] = 2882,
  [5089] = 2050,
  [5090] = 2049,
  [5091] = 2883,
  [5092] = 3169,
  [5093] = 5093,
  [5094] = 3180,
  [5095] = 4845,
  [5096] = 5096,
  [5097] = 4967,
  [5098] = 4956,
  [5099] = 4949,
  [5100] = 4954,
  [5101] = 5007,
  [5102] = 2926,
  [5103] = 2927,
  [5104] = 2043,
  [5105] = 3201,
  [5106] = 3144,
  [5107] = 5107,
  [5108] = 3151,
  [5109] = 3154,
  [5110] = 2574,
  [5111] = 3166,
  [5112] = 4525,
  [5113] = 3158,
  [5114] = 2937,
  [5115] = 3161,
  [5116] = 3163,
  [5117] = 154,
  [5118] = 3140,
  [5119] = 4948,
  [5120] = 3134,
  [5121] = 2953,
  [5122] = 3142,
  [5123] = 2963,
  [5124] = 2966,
  [5125] = 5125,
  [5126] = 5126,
  [5127] = 5127,
  [5128] = 5128,
  [5129] = 3296,
  [5130] = 5130,
  [5131] = 1975,
  [5132] = 3289,
  [5133] = 5133,
  [5134] = 4856,
  [5135] = 3188,
  [5136] = 5136,
  [5137] = 5136,
  [5138] = 4523,
  [5139] = 5130,
  [5140] = 5133,
  [5141] = 5133,
  [5142] = 3169,
  [5143] = 5133,
  [5144] = 2804,
  [5145] = 5125,
  [5146] = 5146,
  [5147] = 5147,
  [5148] = 2804,
  [5149] = 5128,
  [5150] = 3180,
  [5151] = 3201,
  [5152] = 5152,
  [5153] = 5133,
  [5154] = 3201,
  [5155] = 5146,
  [5156] = 5156,
  [5157] = 5133,
  [5158] = 5158,
  [5159] = 5159,
  [5160] = 5146,
  [5161] = 5146,
  [5162] = 5152,
  [5163] = 5152,
  [5164] = 5156,
  [5165] = 5165,
  [5166] = 3134,
  [5167] = 3140,
  [5168] = 3163,
  [5169] = 3161,
  [5170] = 3158,
  [5171] = 3166,
  [5172] = 5165,
  [5173] = 3154,
  [5174] = 3180,
  [5175] = 5175,
  [5176] = 3151,
  [5177] = 3144,
  [5178] = 5152,
  [5179] = 2828,
  [5180] = 3142,
  [5181] = 5147,
  [5182] = 5182,
  [5183] = 5146,
  [5184] = 5073,
  [5185] = 5133,
  [5186] = 3169,
  [5187] = 5156,
  [5188] = 5156,
  [5189] = 5156,
  [5190] = 5152,
  [5191] = 4525,
  [5192] = 5165,
  [5193] = 5193,
  [5194] = 2829,
  [5195] = 5158,
  [5196] = 2818,
  [5197] = 5197,
  [5198] = 5133,
  [5199] = 2817,
  [5200] = 3132,
  [5201] = 5152,
  [5202] = 5202,
  [5203] = 2821,
  [5204] = 2828,
  [5205] = 5156,
  [5206] = 5206,
  [5207] = 5158,
  [5208] = 5165,
  [5209] = 4845,
  [5210] = 5133,
  [5211] = 5211,
  [5212] = 5182,
  [5213] = 5146,
  [5214] = 3148,
  [5215] = 3134,
  [5216] = 4523,
  [5217] = 5146,
  [5218] = 4525,
  [5219] = 3195,
  [5220] = 3132,
  [5221] = 5136,
  [5222] = 5146,
  [5223] = 5152,
  [5224] = 5182,
  [5225] = 2790,
  [5226] = 5226,
  [5227] = 5133,
  [5228] = 3195,
  [5229] = 3188,
  [5230] = 5230,
  [5231] = 5202,
  [5232] = 5232,
  [5233] = 5182,
  [5234] = 3142,
  [5235] = 5130,
  [5236] = 4891,
  [5237] = 3140,
  [5238] = 5238,
  [5239] = 3144,
  [5240] = 5165,
  [5241] = 5241,
  [5242] = 5133,
  [5243] = 5128,
  [5244] = 3151,
  [5245] = 5147,
  [5246] = 5246,
  [5247] = 5247,
  [5248] = 5158,
  [5249] = 5165,
  [5250] = 5125,
  [5251] = 5152,
  [5252] = 3154,
  [5253] = 2306,
  [5254] = 5230,
  [5255] = 3166,
  [5256] = 3158,
  [5257] = 3161,
  [5258] = 3163,
  [5259] = 3140,
  [5260] = 3134,
  [5261] = 3195,
  [5262] = 3132,
  [5263] = 5263,
  [5264] = 5156,
  [5265] = 3201,
  [5266] = 3180,
  [5267] = 3169,
  [5268] = 3188,
  [5269] = 5269,
  [5270] = 5133,
  [5271] = 5156,
  [5272] = 5272,
  [5273] = 5273,
  [5274] = 3148,
  [5275] = 3901,
  [5276] = 5125,
  [5277] = 5125,
  [5278] = 5278,
  [5279] = 5133,
  [5280] = 5182,
  [5281] = 2829,
  [5282] = 5282,
  [5283] = 5158,
  [5284] = 2821,
  [5285] = 5182,
  [5286] = 3148,
  [5287] = 5182,
  [5288] = 5126,
  [5289] = 5133,
  [5290] = 5165,
  [5291] = 5165,
  [5292] = 5292,
  [5293] = 5293,
  [5294] = 3142,
  [5295] = 5158,
  [5296] = 3144,
  [5297] = 5125,
  [5298] = 3163,
  [5299] = 5182,
  [5300] = 3161,
  [5301] = 3333,
  [5302] = 5125,
  [5303] = 3158,
  [5304] = 3151,
  [5305] = 3154,
  [5306] = 1975,
  [5307] = 5182,
  [5308] = 5133,
  [5309] = 3166,
  [5310] = 4932,
  [5311] = 2817,
  [5312] = 4774,
  [5313] = 2818,
  [5314] = 5314,
  [5315] = 3296,
  [5316] = 2498,
  [5317] = 2148,
  [5318] = 5318,
  [5319] = 2499,
  [5320] = 2549,
  [5321] = 5321,
  [5322] = 5322,
  [5323] = 2492,
  [5324] = 5324,
  [5325] = 5325,
  [5326] = 5326,
  [5327] = 5324,
  [5328] = 5328,
  [5329] = 5321,
  [5330] = 5330,
  [5331] = 5328,
  [5332] = 5332,
  [5333] = 5333,
  [5334] = 5326,
  [5335] = 5335,
  [5336] = 5332,
  [5337] = 5314,
  [5338] = 4856,
  [5339] = 5330,
  [5340] = 2494,
  [5341] = 5341,
  [5342] = 2493,
  [5343] = 5343,
  [5344] = 5322,
  [5345] = 5330,
  [5346] = 5346,
  [5347] = 5341,
  [5348] = 5314,
  [5349] = 5326,
  [5350] = 5332,
  [5351] = 3333,
  [5352] = 5322,
  [5353] = 5353,
  [5354] = 5354,
  [5355] = 5343,
  [5356] = 5356,
  [5357] = 5335,
  [5358] = 5343,
  [5359] = 5356,
  [5360] = 5324,
  [5361] = 2491,
  [5362] = 5362,
  [5363] = 5321,
  [5364] = 5364,
  [5365] = 5147,
  [5366] = 5335,
  [5367] = 5367,
  [5368] = 5322,
  [5369] = 5356,
  [5370] = 5343,
  [5371] = 5326,
  [5372] = 5372,
  [5373] = 5330,
  [5374] = 2635,
  [5375] = 5353,
  [5376] = 4845,
  [5377] = 5335,
  [5378] = 5378,
  [5379] = 3289,
  [5380] = 2638,
  [5381] = 5335,
  [5382] = 2125,
  [5383] = 5326,
  [5384] = 5326,
  [5385] = 2063,
  [5386] = 5356,
  [5387] = 5343,
  [5388] = 5321,
  [5389] = 2497,
  [5390] = 2119,
  [5391] = 5321,
  [5392] = 5392,
  [5393] = 5393,
  [5394] = 5341,
  [5395] = 5346,
  [5396] = 2428,
  [5397] = 5341,
  [5398] = 5330,
  [5399] = 5330,
  [5400] = 5314,
  [5401] = 5322,
  [5402] = 5343,
  [5403] = 5128,
  [5404] = 5324,
  [5405] = 5130,
  [5406] = 5324,
  [5407] = 5353,
  [5408] = 5332,
  [5409] = 5322,
  [5410] = 2313,
  [5411] = 5314,
  [5412] = 5356,
  [5413] = 5354,
  [5414] = 5341,
  [5415] = 5330,
  [5416] = 2830,
  [5417] = 5328,
  [5418] = 5418,
  [5419] = 5335,
  [5420] = 5420,
  [5421] = 5353,
  [5422] = 5422,
  [5423] = 5330,
  [5424] = 5326,
  [5425] = 5425,
  [5426] = 5330,
  [5427] = 5427,
  [5428] = 5428,
  [5429] = 5322,
  [5430] = 5430,
  [5431] = 5326,
  [5432] = 5330,
  [5433] = 5322,
  [5434] = 5328,
  [5435] = 5343,
  [5436] = 5343,
  [5437] = 5356,
  [5438] = 5335,
  [5439] = 5324,
  [5440] = 5356,
  [5441] = 5441,
  [5442] = 5136,
  [5443] = 5330,
  [5444] = 5372,
  [5445] = 5322,
  [5446] = 5418,
  [5447] = 5343,
  [5448] = 5356,
  [5449] = 5335,
  [5450] = 5324,
  [5451] = 5451,
  [5452] = 5353,
  [5453] = 5321,
  [5454] = 5454,
  [5455] = 5427,
  [5456] = 5324,
  [5457] = 5457,
  [5458] = 5341,
  [5459] = 5314,
  [5460] = 5332,
  [5461] = 5332,
  [5462] = 5335,
  [5463] = 5328,
  [5464] = 5324,
  [5465] = 2326,
  [5466] = 5466,
  [5467] = 5466,
  [5468] = 2902,
  [5469] = 2885,
  [5470] = 2950,
  [5471] = 5130,
  [5472] = 2948,
  [5473] = 5147,
  [5474] = 2880,
  [5475] = 5130,
  [5476] = 5147,
  [5477] = 5477,
  [5478] = 5478,
  [5479] = 2882,
  [5480] = 2090,
  [5481] = 2960,
  [5482] = 2951,
  [5483] = 5128,
  [5484] = 2932,
  [5485] = 2883,
  [5486] = 2884,
  [5487] = 2964,
  [5488] = 2967,
  [5489] = 5466,
  [5490] = 5490,
  [5491] = 2957,
  [5492] = 5492,
  [5493] = 5493,
  [5494] = 2971,
  [5495] = 5466,
  [5496] = 2859,
  [5497] = 5490,
  [5498] = 4523,
  [5499] = 2926,
  [5500] = 2929,
  [5501] = 5466,
  [5502] = 5466,
  [5503] = 2927,
  [5504] = 5136,
  [5505] = 2946,
  [5506] = 2945,
  [5507] = 2966,
  [5508] = 2899,
  [5509] = 2898,
  [5510] = 5128,
  [5511] = 2913,
  [5512] = 2873,
  [5513] = 2874,
  [5514] = 4845,
  [5515] = 2893,
  [5516] = 2875,
  [5517] = 2928,
  [5518] = 4525,
  [5519] = 2909,
  [5520] = 2876,
  [5521] = 2935,
  [5522] = 2953,
  [5523] = 5523,
  [5524] = 5466,
  [5525] = 2825,
  [5526] = 5466,
  [5527] = 2937,
  [5528] = 5136,
  [5529] = 2306,
  [5530] = 2976,
  [5531] = 2936,
  [5532] = 4856,
  [5533] = 5466,
  [5534] = 2872,
  [5535] = 2963,
  [5536] = 2635,
  [5537] = 2498,
  [5538] = 1974,
  [5539] = 4856,
  [5540] = 5136,
  [5541] = 4845,
  [5542] = 5490,
  [5543] = 2148,
  [5544] = 2090,
  [5545] = 2494,
  [5546] = 5128,
  [5547] = 5130,
  [5548] = 2493,
  [5549] = 2491,
  [5550] = 2026,
  [5551] = 2846,
  [5552] = 2268,
  [5553] = 2428,
  [5554] = 2306,
  [5555] = 2638,
  [5556] = 2811,
  [5557] = 1971,
  [5558] = 1973,
  [5559] = 1968,
  [5560] = 2158,
  [5561] = 1970,
  [5562] = 1969,
  [5563] = 2275,
  [5564] = 2831,
  [5565] = 2499,
  [5566] = 5147,
  [5567] = 2549,
  [5568] = 2179,
  [5569] = 2178,
  [5570] = 1972,
  [5571] = 5571,
  [5572] = 5490,
  [5573] = 2497,
  [5574] = 2182,
  [5575] = 2492,
  [5576] = 5130,
  [5577] = 2125,
  [5578] = 4856,
  [5579] = 5490,
  [5580] = 5580,
  [5581] = 2635,
  [5582] = 5490,
  [5583] = 5490,
  [5584] = 2305,
  [5585] = 2119,
  [5586] = 5490,
  [5587] = 5490,
  [5588] = 2119,
  [5589] = 5136,
  [5590] = 5490,
  [5591] = 2329,
  [5592] = 5490,
  [5593] = 2125,
  [5594] = 2264,
  [5595] = 5147,
  [5596] = 5478,
  [5597] = 2638,
  [5598] = 5490,
  [5599] = 5128,
  [5600] = 5493,
  [5601] = 4845,
  [5602] = 5492,
  [5603] = 4845,
  [5604] = 2467,
  [5605] = 2453,
  [5606] = 5606,
  [5607] = 4856,
  [5608] = 2446,
  [5609] = 4856,
  [5610] = 2437,
  [5611] = 5136,
  [5612] = 2436,
  [5613] = 5490,
  [5614] = 2417,
  [5615] = 2398,
  [5616] = 5606,
  [5617] = 5617,
  [5618] = 2428,
  [5619] = 5490,
  [5620] = 5128,
  [5621] = 2466,
  [5622] = 5622,
  [5623] = 5130,
  [5624] = 2451,
  [5625] = 2439,
  [5626] = 5147,
  [5627] = 2440,
  [5628] = 5490,
  [5629] = 5490,
  [5630] = 4845,
  [5631] = 2166,
  [5632] = 2275,
  [5633] = 2405,
  [5634] = 5622,
  [5635] = 2346,
  [5636] = 2280,
  [5637] = 2339,
  [5638] = 2338,
  [5639] = 5639,
  [5640] = 5640,
  [5641] = 2274,
  [5642] = 5639,
  [5643] = 2277,
  [5644] = 2284,
  [5645] = 2265,
  [5646] = 2282,
  [5647] = 2299,
  [5648] = 5640,
  [5649] = 5640,
  [5650] = 2334,
  [5651] = 2281,
  [5652] = 5639,
  [5653] = 2305,
  [5654] = 2283,
  [5655] = 2285,
  [5656] = 5640,
  [5657] = 5657,
  [5658] = 2266,
  [5659] = 2291,
  [5660] = 2295,
  [5661] = 2302,
  [5662] = 2269,
  [5663] = 2333,
  [5664] = 5606,
  [5665] = 5639,
  [5666] = 2308,
  [5667] = 5639,
  [5668] = 2309,
  [5669] = 5639,
  [5670] = 2310,
  [5671] = 2279,
  [5672] = 5640,
  [5673] = 2329,
  [5674] = 5639,
  [5675] = 5622,
  [5676] = 2262,
  [5677] = 5640,
  [5678] = 2349,
  [5679] = 5640,
  [5680] = 2344,
  [5681] = 5640,
  [5682] = 2347,
  [5683] = 2343,
  [5684] = 2348,
  [5685] = 2286,
  [5686] = 2428,
  [5687] = 5606,
  [5688] = 5640,
  [5689] = 2293,
  [5690] = 5128,
  [5691] = 5639,
  [5692] = 2148,
  [5693] = 5640,
  [5694] = 5640,
  [5695] = 2324,
  [5696] = 2345,
  [5697] = 5490,
  [5698] = 2292,
  [5699] = 2301,
  [5700] = 5622,
  [5701] = 5639,
  [5702] = 5490,
  [5703] = 2090,
  [5704] = 5639,
  [5705] = 5130,
  [5706] = 5639,
  [5707] = 2325,
  [5708] = 5136,
  [5709] = 5147,
  [5710] = 5147,
  [5711] = 5606,
  [5712] = 5606,
  [5713] = 2125,
  [5714] = 5622,
  [5715] = 5136,
  [5716] = 5130,
  [5717] = 5128,
  [5718] = 2453,
  [5719] = 2446,
  [5720] = 5606,
  [5721] = 2405,
  [5722] = 2451,
  [5723] = 2466,
  [5724] = 5724,
  [5725] = 2467,
  [5726] = 5606,
  [5727] = 5622,
  [5728] = 4856,
  [5729] = 2440,
  [5730] = 2439,
  [5731] = 5731,
  [5732] = 2417,
  [5733] = 2398,
  [5734] = 5734,
  [5735] = 2436,
  [5736] = 2437,
  [5737] = 5147,
  [5738] = 4845,
  [5739] = 2638,
  [5740] = 2638,
  [5741] = 2635,
  [5742] = 5622,
  [5743] = 5622,
  [5744] = 5734,
  [5745] = 2635,
  [5746] = 5606,
  [5747] = 5606,
  [5748] = 5622,
  [5749] = 5130,
  [5750] = 5731,
  [5751] = 5606,
  [5752] = 5606,
  [5753] = 5622,
  [5754] = 2119,
  [5755] = 5622,
  [5756] = 5724,
  [5757] = 5622,
  [5758] = 5758,
  [5759] = 5759,
  [5760] = 5136,
  [5761] = 5490,
  [5762] = 2148,
  [5763] = 5763,
  [5764] = 5764,
  [5765] = 5764,
  [5766] = 5622,
  [5767] = 2310,
  [5768] = 5764,
  [5769] = 2262,
  [5770] = 5490,
  [5771] = 5759,
  [5772] = 5490,
  [5773] = 5764,
  [5774] = 5774,
  [5775] = 5775,
  [5776] = 5764,
  [5777] = 2285,
  [5778] = 5764,
  [5779] = 2302,
  [5780] = 5128,
  [5781] = 5764,
  [5782] = 5759,
  [5783] = 5763,
  [5784] = 5784,
  [5785] = 5759,
  [5786] = 5136,
  [5787] = 5774,
  [5788] = 5784,
  [5789] = 5763,
  [5790] = 5606,
  [5791] = 5606,
  [5792] = 3123,
  [5793] = 5764,
  [5794] = 5763,
  [5795] = 5775,
  [5796] = 5784,
  [5797] = 5774,
  [5798] = 5798,
  [5799] = 5763,
  [5800] = 5784,
  [5801] = 5759,
  [5802] = 2280,
  [5803] = 5775,
  [5804] = 2293,
  [5805] = 2166,
  [5806] = 5763,
  [5807] = 5764,
  [5808] = 5764,
  [5809] = 2249,
  [5810] = 5775,
  [5811] = 5784,
  [5812] = 2154,
  [5813] = 5490,
  [5814] = 5147,
  [5815] = 5763,
  [5816] = 5764,
  [5817] = 5622,
  [5818] = 5759,
  [5819] = 5764,
  [5820] = 5798,
  [5821] = 5130,
  [5822] = 5147,
  [5823] = 5764,
  [5824] = 5606,
  [5825] = 5784,
  [5826] = 5622,
  [5827] = 5774,
  [5828] = 5759,
  [5829] = 5774,
  [5830] = 5775,
  [5831] = 5774,
  [5832] = 5763,
  [5833] = 5759,
  [5834] = 2148,
  [5835] = 5763,
  [5836] = 5130,
  [5837] = 5837,
  [5838] = 5798,
  [5839] = 5774,
  [5840] = 5606,
  [5841] = 5764,
  [5842] = 5764,
  [5843] = 5798,
  [5844] = 5844,
  [5845] = 5775,
  [5846] = 5622,
  [5847] = 5764,
  [5848] = 5759,
  [5849] = 5764,
  [5850] = 5784,
  [5851] = 5774,
  [5852] = 5775,
  [5853] = 5764,
  [5854] = 5798,
  [5855] = 5855,
  [5856] = 5759,
  [5857] = 5764,
  [5858] = 5763,
  [5859] = 5775,
  [5860] = 5763,
  [5861] = 5128,
  [5862] = 5798,
  [5863] = 5759,
  [5864] = 5764,
  [5865] = 5764,
  [5866] = 5784,
  [5867] = 5867,
  [5868] = 5868,
  [5869] = 2324,
  [5870] = 2301,
  [5871] = 5871,
  [5872] = 5872,
  [5873] = 5873,
  [5874] = 5874,
  [5875] = 5875,
  [5876] = 5875,
  [5877] = 5868,
  [5878] = 5878,
  [5879] = 5879,
  [5880] = 5878,
  [5881] = 5881,
  [5882] = 5882,
  [5883] = 5871,
  [5884] = 5872,
  [5885] = 5873,
  [5886] = 5874,
  [5887] = 2306,
  [5888] = 5879,
  [5889] = 5868,
  [5890] = 5882,
  [5891] = 5875,
  [5892] = 5868,
  [5893] = 5882,
  [5894] = 5882,
  [5895] = 5881,
  [5896] = 5878,
  [5897] = 5882,
  [5898] = 5879,
  [5899] = 5868,
  [5900] = 5871,
  [5901] = 5871,
  [5902] = 5872,
  [5903] = 5873,
  [5904] = 5904,
  [5905] = 5874,
  [5906] = 5878,
  [5907] = 5879,
  [5908] = 5874,
  [5909] = 5882,
  [5910] = 2344,
  [5911] = 5875,
  [5912] = 5868,
  [5913] = 5878,
  [5914] = 2635,
  [5915] = 5873,
  [5916] = 5871,
  [5917] = 5872,
  [5918] = 2292,
  [5919] = 5873,
  [5920] = 5874,
  [5921] = 5875,
  [5922] = 5882,
  [5923] = 5872,
  [5924] = 5871,
  [5925] = 5872,
  [5926] = 5873,
  [5927] = 5874,
  [5928] = 5868,
  [5929] = 5882,
  [5930] = 5871,
  [5931] = 5871,
  [5932] = 5872,
  [5933] = 5873,
  [5934] = 5874,
  [5935] = 5878,
  [5936] = 5875,
  [5937] = 5875,
  [5938] = 5878,
  [5939] = 2348,
  [5940] = 5882,
  [5941] = 5881,
  [5942] = 5879,
  [5943] = 5868,
  [5944] = 5881,
  [5945] = 5879,
  [5946] = 2343,
  [5947] = 5878,
  [5948] = 5878,
  [5949] = 5875,
  [5950] = 5868,
  [5951] = 5951,
  [5952] = 5881,
  [5953] = 5875,
  [5954] = 5875,
  [5955] = 2347,
  [5956] = 5868,
  [5957] = 5878,
  [5958] = 5606,
  [5959] = 5622,
  [5960] = 5874,
  [5961] = 5871,
  [5962] = 2422,
  [5963] = 2346,
  [5964] = 2349,
  [5965] = 2638,
  [5966] = 5875,
  [5967] = 5868,
  [5968] = 5878,
  [5969] = 5873,
  [5970] = 2265,
  [5971] = 5872,
  [5972] = 2638,
  [5973] = 5878,
  [5974] = 5868,
  [5975] = 2325,
  [5976] = 2635,
  [5977] = 5875,
  [5978] = 5878,
  [5979] = 5979,
  [5980] = 5868,
  [5981] = 5875,
  [5982] = 2333,
  [5983] = 2334,
  [5984] = 2338,
  [5985] = 2339,
  [5986] = 5872,
  [5987] = 2345,
  [5988] = 2274,
  [5989] = 5878,
  [5990] = 5875,
  [5991] = 2277,
  [5992] = 2286,
  [5993] = 2284,
  [5994] = 5868,
  [5995] = 5878,
  [5996] = 4485,
  [5997] = 5868,
  [5998] = 5875,
  [5999] = 2281,
  [6000] = 5606,
  [6001] = 5622,
  [6002] = 2279,
  [6003] = 5875,
  [6004] = 5868,
  [6005] = 2283,
  [6006] = 2269,
  [6007] = 2266,
  [6008] = 5878,
  [6009] = 5868,
  [6010] = 5878,
  [6011] = 5875,
  [6012] = 5878,
  [6013] = 2299,
  [6014] = 2282,
  [6015] = 5868,
  [6016] = 5868,
  [6017] = 5875,
  [6018] = 5875,
  [6019] = 2268,
  [6020] = 5878,
  [6021] = 2309,
  [6022] = 5873,
  [6023] = 5878,
  [6024] = 2308,
  [6025] = 5868,
  [6026] = 2291,
  [6027] = 5875,
  [6028] = 5874,
  [6029] = 2295,
  [6030] = 6030,
  [6031] = 6031,
  [6032] = 6030,
  [6033] = 6030,
  [6034] = 6030,
  [6035] = 6035,
  [6036] = 5130,
  [6037] = 5136,
  [6038] = 6030,
  [6039] = 6039,
  [6040] = 6030,
  [6041] = 6030,
  [6042] = 6030,
  [6043] = 6030,
  [6044] = 6030,
  [6045] = 6039,
  [6046] = 6031,
  [6047] = 3123,
  [6048] = 6030,
  [6049] = 6035,
  [6050] = 6030,
  [6051] = 6030,
  [6052] = 5147,
  [6053] = 6030,
  [6054] = 6030,
  [6055] = 6030,
  [6056] = 5128,
  [6057] = 6030,
  [6058] = 2509,
  [6059] = 6030,
  [6060] = 6030,
  [6061] = 6030,
  [6062] = 2329,
  [6063] = 2305,
  [6064] = 6031,
  [6065] = 2428,
  [6066] = 6035,
  [6067] = 6039,
  [6068] = 6039,
  [6069] = 6035,
  [6070] = 6031,
  [6071] = 5622,
  [6072] = 5606,
  [6073] = 5622,
  [6074] = 5606,
  [6075] = 5622,
  [6076] = 5622,
  [6077] = 5606,
  [6078] = 5606,
  [6079] = 6079,
  [6080] = 4689,
  [6081] = 2491,
  [6082] = 2497,
  [6083] = 6083,
  [6084] = 6039,
  [6085] = 2493,
  [6086] = 2498,
  [6087] = 6039,
  [6088] = 6031,
  [6089] = 6031,
  [6090] = 6035,
  [6091] = 6031,
  [6092] = 6035,
  [6093] = 6031,
  [6094] = 6039,
  [6095] = 6035,
  [6096] = 6039,
  [6097] = 2499,
  [6098] = 6031,
  [6099] = 6039,
  [6100] = 6035,
  [6101] = 6031,
  [6102] = 2549,
  [6103] = 6039,
  [6104] = 6035,
  [6105] = 2494,
  [6106] = 6035,
  [6107] = 6035,
  [6108] = 6039,
  [6109] = 6039,
  [6110] = 6031,
  [6111] = 2313,
  [6112] = 6031,
  [6113] = 6035,
  [6114] = 2326,
  [6115] = 4679,
  [6116] = 2405,
  [6117] = 6035,
  [6118] = 4095,
  [6119] = 6119,
  [6120] = 6119,
  [6121] = 6039,
  [6122] = 6119,
  [6123] = 6035,
  [6124] = 6031,
  [6125] = 6119,
  [6126] = 6031,
  [6127] = 2417,
  [6128] = 6035,
  [6129] = 6031,
  [6130] = 6119,
  [6131] = 6119,
  [6132] = 6119,
  [6133] = 6119,
  [6134] = 6039,
  [6135] = 2437,
  [6136] = 2436,
  [6137] = 6031,
  [6138] = 6119,
  [6139] = 6035,
  [6140] = 2453,
  [6141] = 2446,
  [6142] = 6039,
  [6143] = 2451,
  [6144] = 2466,
  [6145] = 2440,
  [6146] = 2467,
  [6147] = 2439,
  [6148] = 2398,
  [6149] = 6039,
  [6150] = 2492,
  [6151] = 6039,
  [6152] = 6152,
  [6153] = 6031,
  [6154] = 6039,
  [6155] = 6035,
  [6156] = 6152,
  [6157] = 4112,
  [6158] = 6031,
  [6159] = 6159,
  [6160] = 6152,
  [6161] = 6035,
  [6162] = 6152,
  [6163] = 6163,
  [6164] = 6163,
  [6165] = 6163,
  [6166] = 2148,
  [6167] = 6167,
  [6168] = 6163,
  [6169] = 6169,
  [6170] = 6163,
  [6171] = 6171,
  [6172] = 6171,
  [6173] = 6173,
  [6174] = 6031,
  [6175] = 6175,
  [6176] = 6176,
  [6177] = 6039,
  [6178] = 6173,
  [6179] = 6176,
  [6180] = 6180,
  [6181] = 6035,
  [6182] = 6031,
  [6183] = 6152,
  [6184] = 6039,
  [6185] = 6171,
  [6186] = 6171,
  [6187] = 6039,
  [6188] = 6176,
  [6189] = 6180,
  [6190] = 6180,
  [6191] = 6171,
  [6192] = 6180,
  [6193] = 6152,
  [6194] = 6180,
  [6195] = 6180,
  [6196] = 6171,
  [6197] = 6180,
  [6198] = 6171,
  [6199] = 6031,
  [6200] = 6171,
  [6201] = 6180,
  [6202] = 6171,
  [6203] = 6180,
  [6204] = 6171,
  [6205] = 6205,
  [6206] = 6176,
  [6207] = 6176,
  [6208] = 6035,
  [6209] = 6205,
  [6210] = 6031,
  [6211] = 6039,
  [6212] = 6180,
  [6213] = 6180,
  [6214] = 6173,
  [6215] = 6176,
  [6216] = 6171,
  [6217] = 6171,
  [6218] = 6180,
  [6219] = 6176,
  [6220] = 6220,
  [6221] = 6180,
  [6222] = 6180,
  [6223] = 6171,
  [6224] = 6173,
  [6225] = 6176,
  [6226] = 6180,
  [6227] = 6180,
  [6228] = 6180,
  [6229] = 6171,
  [6230] = 6176,
  [6231] = 6205,
  [6232] = 6171,
  [6233] = 6171,
  [6234] = 6234,
  [6235] = 6171,
  [6236] = 6180,
  [6237] = 6171,
  [6238] = 6035,
  [6239] = 6035,
  [6240] = 6240,
  [6241] = 6241,
  [6242] = 6241,
  [6243] = 6243,
  [6244] = 6244,
  [6245] = 6241,
  [6246] = 6243,
  [6247] = 6244,
  [6248] = 6243,
  [6249] = 6152,
  [6250] = 6243,
  [6251] = 6241,
  [6252] = 6244,
  [6253] = 6243,
  [6254] = 6254,
  [6255] = 6243,
  [6256] = 6241,
  [6257] = 6243,
  [6258] = 6244,
  [6259] = 6240,
  [6260] = 6254,
  [6261] = 6241,
  [6262] = 6241,
  [6263] = 6240,
  [6264] = 6254,
  [6265] = 6244,
  [6266] = 6240,
  [6267] = 6254,
  [6268] = 6244,
  [6269] = 6244,
  [6270] = 6254,
  [6271] = 6244,
  [6272] = 6241,
  [6273] = 6244,
  [6274] = 6241,
  [6275] = 6254,
  [6276] = 6240,
  [6277] = 6240,
  [6278] = 6244,
  [6279] = 6243,
  [6280] = 2275,
  [6281] = 6240,
  [6282] = 6254,
  [6283] = 6254,
  [6284] = 6241,
  [6285] = 6240,
  [6286] = 6244,
  [6287] = 6287,
  [6288] = 6288,
  [6289] = 6243,
  [6290] = 6244,
  [6291] = 6254,
  [6292] = 6243,
  [6293] = 6241,
  [6294] = 6244,
  [6295] = 6175,
  [6296] = 6240,
  [6297] = 6254,
  [6298] = 6254,
  [6299] = 6243,
  [6300] = 6240,
  [6301] = 6240,
  [6302] = 6244,
  [6303] = 6241,
  [6304] = 6254,
  [6305] = 6254,
  [6306] = 6287,
  [6307] = 6240,
  [6308] = 6243,
  [6309] = 6240,
  [6310] = 6240,
  [6311] = 6240,
  [6312] = 6254,
  [6313] = 6254,
  [6314] = 6241,
  [6315] = 6240,
  [6316] = 6288,
  [6317] = 6244,
  [6318] = 6241,
  [6319] = 6244,
  [6320] = 6243,
  [6321] = 6244,
  [6322] = 6322,
  [6323] = 6241,
  [6324] = 6243,
  [6325] = 6240,
  [6326] = 6241,
  [6327] = 6243,
  [6328] = 6241,
  [6329] = 6244,
  [6330] = 6243,
  [6331] = 6243,
  [6332] = 6243,
  [6333] = 6254,
  [6334] = 6241,
  [6335] = 6240,
  [6336] = 6254,
  [6337] = 6241,
  [6338] = 6244,
  [6339] = 6243,
  [6340] = 6254,
  [6341] = 6288,
  [6342] = 6287,
  [6343] = 6244,
  [6344] = 6254,
  [6345] = 6254,
  [6346] = 6240,
  [6347] = 6241,
  [6348] = 6348,
  [6349] = 6240,
  [6350] = 6243,
  [6351] = 6351,
  [6352] = 6352,
  [6353] = 6353,
  [6354] = 6354,
  [6355] = 6355,
  [6356] = 6356,
  [6357] = 6357,
  [6358] = 6358,
  [6359] = 6359,
  [6360] = 6352,
  [6361] = 6352,
  [6362] = 6352,
  [6363] = 6363,
  [6364] = 6364,
  [6365] = 6353,
  [6366] = 6366,
  [6367] = 6367,
  [6368] = 6368,
  [6369] = 6369,
  [6370] = 6357,
  [6371] = 6352,
  [6372] = 6372,
  [6373] = 6353,
  [6374] = 6359,
  [6375] = 6353,
  [6376] = 6234,
  [6377] = 6377,
  [6378] = 6378,
  [6379] = 6352,
  [6380] = 6380,
  [6381] = 6352,
  [6382] = 6382,
  [6383] = 6383,
  [6384] = 6220,
  [6385] = 6352,
  [6386] = 6152,
  [6387] = 6387,
  [6388] = 6356,
  [6389] = 6389,
  [6390] = 6358,
  [6391] = 6358,
  [6392] = 6352,
  [6393] = 6393,
  [6394] = 6394,
  [6395] = 6358,
  [6396] = 6396,
  [6397] = 6357,
  [6398] = 6353,
  [6399] = 6364,
  [6400] = 6355,
  [6401] = 6401,
  [6402] = 6402,
  [6403] = 6403,
  [6404] = 6354,
  [6405] = 6405,
  [6406] = 6353,
  [6407] = 6407,
  [6408] = 6408,
  [6409] = 6353,
  [6410] = 6410,
  [6411] = 6357,
  [6412] = 6353,
  [6413] = 6413,
  [6414] = 6414,
  [6415] = 6359,
  [6416] = 6359,
  [6417] = 6353,
  [6418] = 6418,
  [6419] = 6419,
  [6420] = 6420,
  [6421] = 6357,
  [6422] = 6352,
  [6423] = 6352,
  [6424] = 6352,
  [6425] = 6352,
  [6426] = 6426,
  [6427] = 6377,
  [6428] = 6352,
  [6429] = 6426,
  [6430] = 6430,
  [6431] = 6431,
  [6432] = 6405,
  [6433] = 6433,
  [6434] = 6378,
  [6435] = 6382,
  [6436] = 3333,
  [6437] = 6437,
  [6438] = 6383,
  [6439] = 6351,
  [6440] = 6440,
  [6441] = 6413,
  [6442] = 6403,
  [6443] = 2036,
  [6444] = 6444,
  [6445] = 6414,
  [6446] = 6446,
  [6447] = 6447,
  [6448] = 6448,
  [6449] = 6449,
  [6450] = 2039,
  [6451] = 2050,
  [6452] = 6452,
  [6453] = 6453,
  [6454] = 6454,
  [6455] = 6440,
  [6456] = 6456,
  [6457] = 152,
  [6458] = 6458,
  [6459] = 2825,
  [6460] = 2049,
  [6461] = 154,
  [6462] = 6462,
  [6463] = 6446,
  [6464] = 6464,
  [6465] = 6464,
  [6466] = 6466,
  [6467] = 6467,
  [6468] = 6468,
  [6469] = 6369,
  [6470] = 6449,
  [6471] = 6447,
  [6472] = 6430,
  [6473] = 6473,
  [6474] = 6474,
  [6475] = 6468,
  [6476] = 6476,
  [6477] = 6454,
  [6478] = 6462,
  [6479] = 2859,
  [6480] = 2042,
  [6481] = 6420,
  [6482] = 6453,
  [6483] = 2038,
  [6484] = 6484,
  [6485] = 6389,
  [6486] = 6486,
  [6487] = 6473,
  [6488] = 6446,
  [6489] = 6449,
  [6490] = 6456,
  [6491] = 6446,
  [6492] = 6473,
  [6493] = 6493,
  [6494] = 6453,
  [6495] = 6433,
  [6496] = 6410,
  [6497] = 6454,
  [6498] = 6152,
  [6499] = 6474,
  [6500] = 6458,
  [6501] = 6464,
  [6502] = 6466,
  [6503] = 6454,
  [6504] = 2825,
  [6505] = 6468,
  [6506] = 6368,
  [6507] = 6453,
  [6508] = 6508,
  [6509] = 2044,
  [6510] = 6446,
  [6511] = 6511,
  [6512] = 6408,
  [6513] = 6456,
  [6514] = 6446,
  [6515] = 6449,
  [6516] = 6453,
  [6517] = 6454,
  [6518] = 6518,
  [6519] = 2043,
  [6520] = 6520,
  [6521] = 6418,
  [6522] = 6449,
  [6523] = 6466,
  [6524] = 6453,
  [6525] = 6473,
  [6526] = 6396,
  [6527] = 6462,
  [6528] = 6454,
  [6529] = 6474,
  [6530] = 6530,
  [6531] = 6531,
  [6532] = 6532,
  [6533] = 6468,
  [6534] = 6464,
  [6535] = 6431,
  [6536] = 6536,
  [6537] = 6402,
  [6538] = 6538,
  [6539] = 6449,
  [6540] = 6464,
  [6541] = 2041,
  [6542] = 6473,
  [6543] = 6543,
  [6544] = 6474,
  [6545] = 6464,
  [6546] = 6393,
  [6547] = 2046,
  [6548] = 6548,
  [6549] = 3333,
  [6550] = 6447,
  [6551] = 2035,
  [6552] = 6552,
  [6553] = 2052,
  [6554] = 2053,
  [6555] = 2040,
  [6556] = 6401,
  [6557] = 6456,
  [6558] = 6558,
  [6559] = 6407,
  [6560] = 6462,
  [6561] = 6466,
  [6562] = 2034,
  [6563] = 6563,
  [6564] = 6447,
  [6565] = 2859,
  [6566] = 6446,
  [6567] = 6532,
  [6568] = 2509,
  [6569] = 6446,
  [6570] = 6454,
  [6571] = 6453,
  [6572] = 6453,
  [6573] = 6449,
  [6574] = 6538,
  [6575] = 6520,
  [6576] = 6454,
  [6577] = 6152,
  [6578] = 6578,
  [6579] = 6449,
  [6580] = 6454,
  [6581] = 6446,
  [6582] = 2037,
  [6583] = 2048,
  [6584] = 6584,
  [6585] = 2125,
  [6586] = 6586,
  [6587] = 6453,
  [6588] = 6586,
  [6589] = 6586,
  [6590] = 6449,
  [6591] = 2119,
  [6592] = 6592,
  [6593] = 6593,
  [6594] = 6594,
  [6595] = 6595,
  [6596] = 6596,
  [6597] = 6586,
  [6598] = 6586,
  [6599] = 6595,
  [6600] = 6595,
  [6601] = 6601,
  [6602] = 6584,
  [6603] = 6603,
  [6604] = 6601,
  [6605] = 6605,
  [6606] = 6606,
  [6607] = 6592,
  [6608] = 6595,
  [6609] = 6592,
  [6610] = 6584,
  [6611] = 6601,
  [6612] = 6612,
  [6613] = 6601,
  [6614] = 2051,
  [6615] = 6595,
  [6616] = 6586,
  [6617] = 6617,
  [6618] = 6595,
  [6619] = 6584,
  [6620] = 6601,
  [6621] = 6621,
  [6622] = 6622,
  [6623] = 6623,
  [6624] = 6586,
  [6625] = 6595,
  [6626] = 6626,
  [6627] = 6586,
  [6628] = 6628,
  [6629] = 6629,
  [6630] = 6584,
  [6631] = 6584,
  [6632] = 6632,
  [6633] = 6601,
  [6634] = 6601,
  [6635] = 6635,
  [6636] = 6636,
  [6637] = 6453,
  [6638] = 6584,
  [6639] = 6586,
  [6640] = 6584,
  [6641] = 6641,
  [6642] = 6642,
  [6643] = 6592,
  [6644] = 6449,
  [6645] = 6586,
  [6646] = 6646,
  [6647] = 6601,
  [6648] = 6584,
  [6649] = 6586,
  [6650] = 6595,
  [6651] = 6601,
  [6652] = 6584,
  [6653] = 6601,
  [6654] = 6446,
  [6655] = 6655,
  [6656] = 6152,
  [6657] = 6657,
  [6658] = 6454,
  [6659] = 6659,
  [6660] = 6595,
  [6661] = 6453,
  [6662] = 6595,
  [6663] = 6584,
  [6664] = 6595,
  [6665] = 6152,
  [6666] = 6454,
  [6667] = 6449,
  [6668] = 6603,
  [6669] = 6446,
  [6670] = 6670,
  [6671] = 6601,
  [6672] = 6672,
  [6673] = 6595,
  [6674] = 6592,
  [6675] = 6586,
  [6676] = 6676,
  [6677] = 6453,
  [6678] = 6592,
  [6679] = 6449,
  [6680] = 6446,
  [6681] = 6454,
  [6682] = 6446,
  [6683] = 2052,
  [6684] = 2044,
  [6685] = 6685,
  [6686] = 2036,
  [6687] = 6687,
  [6688] = 6687,
  [6689] = 6687,
  [6690] = 2038,
  [6691] = 152,
  [6692] = 6692,
  [6693] = 6687,
  [6694] = 6687,
  [6695] = 2039,
  [6696] = 6454,
  [6697] = 6687,
  [6698] = 6698,
  [6699] = 6446,
  [6700] = 6456,
  [6701] = 2041,
  [6702] = 6453,
  [6703] = 6474,
  [6704] = 2825,
  [6705] = 2859,
  [6706] = 6447,
  [6707] = 6687,
  [6708] = 2046,
  [6709] = 6474,
  [6710] = 6710,
  [6711] = 6711,
  [6712] = 6687,
  [6713] = 6152,
  [6714] = 6687,
  [6715] = 6687,
  [6716] = 6687,
  [6717] = 6687,
  [6718] = 2042,
  [6719] = 6687,
  [6720] = 154,
  [6721] = 6466,
  [6722] = 6687,
  [6723] = 6687,
  [6724] = 6468,
  [6725] = 6452,
  [6726] = 6687,
  [6727] = 1111,
  [6728] = 6728,
  [6729] = 6449,
  [6730] = 6558,
  [6731] = 6687,
  [6732] = 2053,
  [6733] = 2040,
  [6734] = 1112,
  [6735] = 6728,
  [6736] = 6453,
  [6737] = 6466,
  [6738] = 2049,
  [6739] = 2050,
  [6740] = 6468,
  [6741] = 6687,
  [6742] = 6687,
  [6743] = 6728,
  [6744] = 2034,
  [6745] = 6447,
  [6746] = 2043,
  [6747] = 2035,
  [6748] = 6456,
  [6749] = 2792,
  [6750] = 6449,
  [6751] = 6152,
  [6752] = 6687,
  [6753] = 6454,
  [6754] = 6728,
  [6755] = 6728,
  [6756] = 6756,
  [6757] = 6757,
  [6758] = 6758,
  [6759] = 6759,
  [6760] = 6758,
  [6761] = 2379,
  [6762] = 6758,
  [6763] = 6446,
  [6764] = 6764,
  [6765] = 6756,
  [6766] = 6766,
  [6767] = 6766,
  [6768] = 6758,
  [6769] = 2385,
  [6770] = 6453,
  [6771] = 6766,
  [6772] = 2896,
  [6773] = 6773,
  [6774] = 6756,
  [6775] = 6775,
  [6776] = 6776,
  [6777] = 6777,
  [6778] = 6759,
  [6779] = 6454,
  [6780] = 6780,
  [6781] = 2423,
  [6782] = 6758,
  [6783] = 2509,
  [6784] = 6784,
  [6785] = 6785,
  [6786] = 6766,
  [6787] = 6773,
  [6788] = 6756,
  [6789] = 6789,
  [6790] = 6775,
  [6791] = 6758,
  [6792] = 6756,
  [6793] = 6757,
  [6794] = 6776,
  [6795] = 6758,
  [6796] = 6780,
  [6797] = 6766,
  [6798] = 6784,
  [6799] = 6785,
  [6800] = 6766,
  [6801] = 6756,
  [6802] = 6777,
  [6803] = 6766,
  [6804] = 2847,
  [6805] = 6758,
  [6806] = 6785,
  [6807] = 6784,
  [6808] = 6780,
  [6809] = 6449,
  [6810] = 6777,
  [6811] = 6776,
  [6812] = 6757,
  [6813] = 6775,
  [6814] = 6758,
  [6815] = 2411,
  [6816] = 6773,
  [6817] = 6446,
  [6818] = 6454,
  [6819] = 6756,
  [6820] = 6449,
  [6821] = 6758,
  [6822] = 6759,
  [6823] = 2877,
  [6824] = 6766,
  [6825] = 6766,
  [6826] = 6756,
  [6827] = 6827,
  [6828] = 6828,
  [6829] = 6759,
  [6830] = 6830,
  [6831] = 6759,
  [6832] = 6758,
  [6833] = 6453,
  [6834] = 6758,
  [6835] = 6756,
  [6836] = 6468,
  [6837] = 6837,
  [6838] = 6468,
  [6839] = 6594,
  [6840] = 6840,
  [6841] = 6776,
  [6842] = 6840,
  [6843] = 6612,
  [6844] = 6446,
  [6845] = 6449,
  [6846] = 6840,
  [6847] = 6840,
  [6848] = 6848,
  [6849] = 6621,
  [6850] = 6850,
  [6851] = 6777,
  [6852] = 6852,
  [6853] = 2859,
  [6854] = 6468,
  [6855] = 6655,
  [6856] = 6453,
  [6857] = 6474,
  [6858] = 6773,
  [6859] = 6840,
  [6860] = 6466,
  [6861] = 6632,
  [6862] = 6454,
  [6863] = 6848,
  [6864] = 6657,
  [6865] = 6474,
  [6866] = 6866,
  [6867] = 6152,
  [6868] = 6672,
  [6869] = 6606,
  [6870] = 6840,
  [6871] = 6780,
  [6872] = 6837,
  [6873] = 6840,
  [6874] = 6784,
  [6875] = 6456,
  [6876] = 6876,
  [6877] = 6447,
  [6878] = 6840,
  [6879] = 6785,
  [6880] = 6837,
  [6881] = 2519,
  [6882] = 6447,
  [6883] = 6659,
  [6884] = 2859,
  [6885] = 2068,
  [6886] = 6670,
  [6887] = 6605,
  [6888] = 6474,
  [6889] = 6456,
  [6890] = 1975,
  [6891] = 6641,
  [6892] = 2064,
  [6893] = 2825,
  [6894] = 6474,
  [6895] = 6629,
  [6896] = 6837,
  [6897] = 6840,
  [6898] = 6840,
  [6899] = 6593,
  [6900] = 6837,
  [6901] = 6456,
  [6902] = 6775,
  [6903] = 6837,
  [6904] = 6454,
  [6905] = 2071,
  [6906] = 6840,
  [6907] = 6840,
  [6908] = 6622,
  [6909] = 2070,
  [6910] = 6910,
  [6911] = 6837,
  [6912] = 6912,
  [6913] = 6840,
  [6914] = 6453,
  [6915] = 6466,
  [6916] = 6840,
  [6917] = 6449,
  [6918] = 6447,
  [6919] = 6919,
  [6920] = 6866,
  [6921] = 6921,
  [6922] = 6840,
  [6923] = 6646,
  [6924] = 6447,
  [6925] = 6837,
  [6926] = 6628,
  [6927] = 6840,
  [6928] = 6623,
  [6929] = 6837,
  [6930] = 6446,
  [6931] = 6840,
  [6932] = 6466,
  [6933] = 6921,
  [6934] = 6456,
  [6935] = 6840,
  [6936] = 6466,
  [6937] = 6840,
  [6938] = 6840,
  [6939] = 6939,
  [6940] = 2825,
  [6941] = 6642,
  [6942] = 6840,
  [6943] = 6943,
  [6944] = 6943,
  [6945] = 6617,
  [6946] = 6635,
  [6947] = 6468,
  [6948] = 6850,
  [6949] = 6757,
  [6950] = 6950,
  [6951] = 2571,
  [6952] = 2975,
  [6953] = 6454,
  [6954] = 6785,
  [6955] = 6950,
  [6956] = 6453,
  [6957] = 6957,
  [6958] = 6449,
  [6959] = 6950,
  [6960] = 6446,
  [6961] = 6961,
  [6962] = 6785,
  [6963] = 6963,
  [6964] = 6449,
  [6965] = 6453,
  [6966] = 6454,
  [6967] = 6967,
  [6968] = 6968,
  [6969] = 6957,
  [6970] = 6970,
  [6971] = 6971,
  [6972] = 6972,
  [6973] = 6970,
  [6974] = 6974,
  [6975] = 6950,
  [6976] = 6950,
  [6977] = 6977,
  [6978] = 6950,
  [6979] = 6979,
  [6980] = 6972,
  [6981] = 6981,
  [6982] = 6957,
  [6983] = 2570,
  [6984] = 6970,
  [6985] = 6957,
  [6986] = 6950,
  [6987] = 6977,
  [6988] = 6988,
  [6989] = 6989,
  [6990] = 6990,
  [6991] = 6981,
  [6992] = 6775,
  [6993] = 6446,
  [6994] = 6757,
  [6995] = 6977,
  [6996] = 6996,
  [6997] = 6970,
  [6998] = 6972,
  [6999] = 2385,
  [7000] = 6981,
  [7001] = 2423,
  [7002] = 2559,
  [7003] = 6773,
  [7004] = 7004,
  [7005] = 7005,
  [7006] = 2379,
  [7007] = 6972,
  [7008] = 6957,
  [7009] = 2553,
  [7010] = 6957,
  [7011] = 6777,
  [7012] = 6970,
  [7013] = 2920,
  [7014] = 6981,
  [7015] = 6981,
  [7016] = 6957,
  [7017] = 2573,
  [7018] = 6780,
  [7019] = 6970,
  [7020] = 6957,
  [7021] = 6970,
  [7022] = 2542,
  [7023] = 6977,
  [7024] = 2536,
  [7025] = 2564,
  [7026] = 6970,
  [7027] = 6773,
  [7028] = 2411,
  [7029] = 2552,
  [7030] = 6776,
  [7031] = 2930,
  [7032] = 6775,
  [7033] = 6757,
  [7034] = 6970,
  [7035] = 6950,
  [7036] = 6950,
  [7037] = 6981,
  [7038] = 6972,
  [7039] = 6981,
  [7040] = 6972,
  [7041] = 6981,
  [7042] = 6776,
  [7043] = 6777,
  [7044] = 2866,
  [7045] = 6996,
  [7046] = 6977,
  [7047] = 6981,
  [7048] = 6780,
  [7049] = 6970,
  [7050] = 6784,
  [7051] = 6981,
  [7052] = 2865,
  [7053] = 6972,
  [7054] = 6977,
  [7055] = 6784,
  [7056] = 7056,
  [7057] = 6970,
  [7058] = 2867,
  [7059] = 6981,
  [7060] = 6972,
  [7061] = 2918,
  [7062] = 6981,
  [7063] = 6970,
  [7064] = 6972,
  [7065] = 2917,
  [7066] = 2566,
  [7067] = 2541,
  [7068] = 6957,
  [7069] = 7069,
  [7070] = 7070,
  [7071] = 7070,
  [7072] = 6757,
  [7073] = 7070,
  [7074] = 7074,
  [7075] = 2379,
  [7076] = 6776,
  [7077] = 7077,
  [7078] = 7077,
  [7079] = 7079,
  [7080] = 7070,
  [7081] = 2385,
  [7082] = 7070,
  [7083] = 7070,
  [7084] = 7079,
  [7085] = 7079,
  [7086] = 6850,
  [7087] = 6468,
  [7088] = 6454,
  [7089] = 7070,
  [7090] = 6474,
  [7091] = 6468,
  [7092] = 2423,
  [7093] = 6474,
  [7094] = 6848,
  [7095] = 7070,
  [7096] = 6456,
  [7097] = 7097,
  [7098] = 4732,
  [7099] = 7099,
  [7100] = 7079,
  [7101] = 6456,
  [7102] = 6777,
  [7103] = 6466,
  [7104] = 7104,
  [7105] = 7070,
  [7106] = 6780,
  [7107] = 6453,
  [7108] = 6466,
  [7109] = 6784,
  [7110] = 6785,
  [7111] = 6447,
  [7112] = 7070,
  [7113] = 6449,
  [7114] = 6447,
  [7115] = 7070,
  [7116] = 2519,
  [7117] = 7070,
  [7118] = 6454,
  [7119] = 7077,
  [7120] = 6453,
  [7121] = 7070,
  [7122] = 7070,
  [7123] = 2411,
  [7124] = 7124,
  [7125] = 6919,
  [7126] = 2825,
  [7127] = 7070,
  [7128] = 7070,
  [7129] = 6446,
  [7130] = 6449,
  [7131] = 6446,
  [7132] = 7070,
  [7133] = 7070,
  [7134] = 7079,
  [7135] = 6921,
  [7136] = 6773,
  [7137] = 7137,
  [7138] = 7077,
  [7139] = 2859,
  [7140] = 6775,
  [7141] = 6866,
  [7142] = 7070,
  [7143] = 7070,
  [7144] = 7077,
  [7145] = 7070,
  [7146] = 7146,
  [7147] = 6943,
  [7148] = 7148,
  [7149] = 7149,
  [7150] = 6468,
  [7151] = 2859,
  [7152] = 6468,
  [7153] = 7148,
  [7154] = 6785,
  [7155] = 7148,
  [7156] = 6474,
  [7157] = 6777,
  [7158] = 7158,
  [7159] = 6456,
  [7160] = 7160,
  [7161] = 7161,
  [7162] = 7149,
  [7163] = 6474,
  [7164] = 7164,
  [7165] = 7148,
  [7166] = 7166,
  [7167] = 7167,
  [7168] = 6757,
  [7169] = 7148,
  [7170] = 7170,
  [7171] = 7166,
  [7172] = 7166,
  [7173] = 2519,
  [7174] = 7166,
  [7175] = 6775,
  [7176] = 7164,
  [7177] = 7149,
  [7178] = 6466,
  [7179] = 7179,
  [7180] = 7164,
  [7181] = 7148,
  [7182] = 7182,
  [7183] = 2793,
  [7184] = 6943,
  [7185] = 7185,
  [7186] = 7186,
  [7187] = 7149,
  [7188] = 7188,
  [7189] = 6456,
  [7190] = 7166,
  [7191] = 6866,
  [7192] = 7148,
  [7193] = 6785,
  [7194] = 7149,
  [7195] = 7166,
  [7196] = 7149,
  [7197] = 7164,
  [7198] = 6850,
  [7199] = 7166,
  [7200] = 6848,
  [7201] = 6921,
  [7202] = 6780,
  [7203] = 6780,
  [7204] = 7204,
  [7205] = 7164,
  [7206] = 6773,
  [7207] = 6784,
  [7208] = 7208,
  [7209] = 7209,
  [7210] = 7164,
  [7211] = 6447,
  [7212] = 6776,
  [7213] = 7164,
  [7214] = 7214,
  [7215] = 7166,
  [7216] = 7216,
  [7217] = 6466,
  [7218] = 7148,
  [7219] = 7149,
  [7220] = 7164,
  [7221] = 7164,
  [7222] = 6775,
  [7223] = 6447,
  [7224] = 7148,
  [7225] = 2825,
  [7226] = 7226,
  [7227] = 7149,
  [7228] = 6757,
  [7229] = 7149,
  [7230] = 7166,
  [7231] = 6785,
  [7232] = 1968,
  [7233] = 7233,
  [7234] = 7234,
  [7235] = 7235,
  [7236] = 6784,
  [7237] = 7235,
  [7238] = 7238,
  [7239] = 1972,
  [7240] = 7240,
  [7241] = 7235,
  [7242] = 7242,
  [7243] = 7238,
  [7244] = 7235,
  [7245] = 7235,
  [7246] = 7246,
  [7247] = 6780,
  [7248] = 7235,
  [7249] = 7235,
  [7250] = 7235,
  [7251] = 7235,
  [7252] = 7235,
  [7253] = 7253,
  [7254] = 6777,
  [7255] = 7255,
  [7256] = 1970,
  [7257] = 7257,
  [7258] = 6776,
  [7259] = 6757,
  [7260] = 6775,
  [7261] = 6773,
  [7262] = 7235,
  [7263] = 7263,
  [7264] = 7235,
  [7265] = 7235,
  [7266] = 1969,
  [7267] = 1971,
  [7268] = 1974,
  [7269] = 7235,
  [7270] = 1973,
  [7271] = 7235,
  [7272] = 7272,
  [7273] = 7272,
  [7274] = 7274,
  [7275] = 6775,
  [7276] = 7272,
  [7277] = 7277,
  [7278] = 7274,
  [7279] = 7272,
  [7280] = 2859,
  [7281] = 7272,
  [7282] = 7282,
  [7283] = 7272,
  [7284] = 7274,
  [7285] = 7272,
  [7286] = 7286,
  [7287] = 7286,
  [7288] = 7272,
  [7289] = 7272,
  [7290] = 6757,
  [7291] = 7272,
  [7292] = 7272,
  [7293] = 7272,
  [7294] = 7286,
  [7295] = 7286,
  [7296] = 6776,
  [7297] = 6698,
  [7298] = 7286,
  [7299] = 6777,
  [7300] = 7272,
  [7301] = 2825,
  [7302] = 7272,
  [7303] = 6773,
  [7304] = 7272,
  [7305] = 7286,
  [7306] = 7272,
  [7307] = 7272,
  [7308] = 7272,
  [7309] = 7274,
  [7310] = 7286,
  [7311] = 7274,
  [7312] = 6785,
  [7313] = 7286,
  [7314] = 7272,
  [7315] = 6710,
  [7316] = 7272,
  [7317] = 7286,
  [7318] = 7272,
  [7319] = 7272,
  [7320] = 7272,
  [7321] = 6784,
  [7322] = 6780,
  [7323] = 6848,
  [7324] = 6939,
  [7325] = 7325,
  [7326] = 7326,
  [7327] = 7327,
  [7328] = 6866,
  [7329] = 7329,
  [7330] = 7330,
  [7331] = 7331,
  [7332] = 6910,
  [7333] = 6710,
  [7334] = 6773,
  [7335] = 7335,
  [7336] = 6850,
  [7337] = 6943,
  [7338] = 6921,
  [7339] = 7339,
  [7340] = 7340,
  [7341] = 7331,
  [7342] = 7342,
  [7343] = 6698,
  [7344] = 7330,
  [7345] = 2847,
  [7346] = 6775,
  [7347] = 6757,
  [7348] = 7348,
  [7349] = 7349,
  [7350] = 6776,
  [7351] = 6777,
  [7352] = 7331,
  [7353] = 7330,
  [7354] = 7354,
  [7355] = 7355,
  [7356] = 7356,
  [7357] = 7331,
  [7358] = 7348,
  [7359] = 6912,
  [7360] = 7330,
  [7361] = 7361,
  [7362] = 7362,
  [7363] = 6876,
  [7364] = 7331,
  [7365] = 7365,
  [7366] = 7366,
  [7367] = 7367,
  [7368] = 7368,
  [7369] = 7369,
  [7370] = 7370,
  [7371] = 7348,
  [7372] = 7372,
  [7373] = 7373,
  [7374] = 7331,
  [7375] = 7331,
  [7376] = 6780,
  [7377] = 7331,
  [7378] = 7330,
  [7379] = 6784,
  [7380] = 7348,
  [7381] = 7331,
  [7382] = 7382,
  [7383] = 7348,
  [7384] = 6852,
  [7385] = 7385,
  [7386] = 6785,
  [7387] = 7387,
  [7388] = 6757,
  [7389] = 7389,
  [7390] = 7389,
  [7391] = 7391,
  [7392] = 6775,
  [7393] = 7391,
  [7394] = 6776,
  [7395] = 6777,
  [7396] = 7389,
  [7397] = 2998,
  [7398] = 7398,
  [7399] = 7399,
  [7400] = 2847,
  [7401] = 7401,
  [7402] = 7391,
  [7403] = 7389,
  [7404] = 7404,
  [7405] = 7405,
  [7406] = 2983,
  [7407] = 7398,
  [7408] = 2423,
  [7409] = 7391,
  [7410] = 6780,
  [7411] = 7399,
  [7412] = 6784,
  [7413] = 2411,
  [7414] = 7399,
  [7415] = 7399,
  [7416] = 7398,
  [7417] = 6776,
  [7418] = 7418,
  [7419] = 7419,
  [7420] = 6784,
  [7421] = 6773,
  [7422] = 7422,
  [7423] = 7391,
  [7424] = 7424,
  [7425] = 6775,
  [7426] = 7399,
  [7427] = 6757,
  [7428] = 7389,
  [7429] = 6777,
  [7430] = 6785,
  [7431] = 6785,
  [7432] = 7398,
  [7433] = 3002,
  [7434] = 2379,
  [7435] = 6780,
  [7436] = 7436,
  [7437] = 2385,
  [7438] = 7438,
  [7439] = 6773,
  [7440] = 7398,
  [7441] = 7441,
  [7442] = 7442,
  [7443] = 7441,
  [7444] = 7444,
  [7445] = 7445,
  [7446] = 7442,
  [7447] = 7447,
  [7448] = 7448,
  [7449] = 7442,
  [7450] = 7450,
  [7451] = 7441,
  [7452] = 7452,
  [7453] = 2847,
  [7454] = 7442,
  [7455] = 7445,
  [7456] = 7444,
  [7457] = 7445,
  [7458] = 7458,
  [7459] = 7444,
  [7460] = 7445,
  [7461] = 7444,
  [7462] = 7442,
  [7463] = 7366,
  [7464] = 7354,
  [7465] = 7465,
  [7466] = 7441,
  [7467] = 7467,
  [7468] = 7468,
  [7469] = 7469,
  [7470] = 7470,
  [7471] = 7441,
  [7472] = 7097,
  [7473] = 2847,
  [7474] = 7442,
  [7475] = 7475,
  [7476] = 7441,
  [7477] = 7477,
  [7478] = 7069,
  [7479] = 7444,
  [7480] = 7444,
  [7481] = 7445,
  [7482] = 7445,
  [7483] = 7483,
  [7484] = 2519,
  [7485] = 7445,
  [7486] = 7486,
  [7487] = 7444,
  [7488] = 7385,
  [7489] = 7442,
  [7490] = 7490,
  [7491] = 7099,
  [7492] = 7492,
  [7493] = 7444,
  [7494] = 7441,
  [7495] = 7445,
  [7496] = 7496,
  [7497] = 7442,
  [7498] = 7442,
  [7499] = 7445,
  [7500] = 7492,
  [7501] = 7444,
  [7502] = 7467,
  [7503] = 7441,
  [7504] = 7441,
  [7505] = 6777,
  [7506] = 7506,
  [7507] = 7507,
  [7508] = 7508,
  [7509] = 7509,
  [7510] = 2847,
  [7511] = 2580,
  [7512] = 7512,
  [7513] = 7513,
  [7514] = 7514,
  [7515] = 7515,
  [7516] = 7516,
  [7517] = 7517,
  [7518] = 7507,
  [7519] = 7418,
  [7520] = 7509,
  [7521] = 7521,
  [7522] = 7506,
  [7523] = 7506,
  [7524] = 7521,
  [7525] = 7525,
  [7526] = 7515,
  [7527] = 7527,
  [7528] = 7528,
  [7529] = 7529,
  [7530] = 7517,
  [7531] = 7515,
  [7532] = 7532,
  [7533] = 7508,
  [7534] = 7521,
  [7535] = 7508,
  [7536] = 7536,
  [7537] = 6775,
  [7538] = 6757,
  [7539] = 7527,
  [7540] = 7506,
  [7541] = 7541,
  [7542] = 7512,
  [7543] = 6776,
  [7544] = 7516,
  [7545] = 7521,
  [7546] = 7546,
  [7547] = 2847,
  [7548] = 7525,
  [7549] = 7549,
  [7550] = 7521,
  [7551] = 7516,
  [7552] = 7525,
  [7553] = 7516,
  [7554] = 7541,
  [7555] = 7525,
  [7556] = 7514,
  [7557] = 7527,
  [7558] = 7527,
  [7559] = 7549,
  [7560] = 7560,
  [7561] = 7506,
  [7562] = 6785,
  [7563] = 7512,
  [7564] = 7564,
  [7565] = 7515,
  [7566] = 6780,
  [7567] = 7567,
  [7568] = 7512,
  [7569] = 6773,
  [7570] = 7508,
  [7571] = 7521,
  [7572] = 6784,
  [7573] = 7549,
  [7574] = 7514,
  [7575] = 7549,
  [7576] = 7514,
  [7577] = 7577,
  [7578] = 7578,
  [7579] = 7579,
  [7580] = 7580,
  [7581] = 7581,
  [7582] = 7582,
  [7583] = 7583,
  [7584] = 7584,
  [7585] = 7585,
  [7586] = 7586,
  [7587] = 7578,
  [7588] = 7585,
  [7589] = 7578,
  [7590] = 7590,
  [7591] = 7591,
  [7592] = 7584,
  [7593] = 7585,
  [7594] = 7594,
  [7595] = 7595,
  [7596] = 7595,
  [7597] = 7578,
  [7598] = 7598,
  [7599] = 7599,
  [7600] = 7600,
  [7601] = 7601,
  [7602] = 7584,
  [7603] = 7600,
  [7604] = 7591,
  [7605] = 7585,
  [7606] = 7606,
  [7607] = 7598,
  [7608] = 7608,
  [7609] = 7578,
  [7610] = 7601,
  [7611] = 7611,
  [7612] = 7584,
  [7613] = 7458,
  [7614] = 7585,
  [7615] = 7615,
  [7616] = 7585,
  [7617] = 7617,
  [7618] = 7618,
  [7619] = 7584,
  [7620] = 7578,
  [7621] = 7606,
  [7622] = 7600,
  [7623] = 7584,
  [7624] = 7578,
  [7625] = 7625,
  [7626] = 7585,
  [7627] = 7627,
  [7628] = 7608,
  [7629] = 7606,
  [7630] = 7625,
  [7631] = 7631,
  [7632] = 7595,
  [7633] = 7586,
  [7634] = 7634,
  [7635] = 7578,
  [7636] = 7634,
  [7637] = 7637,
  [7638] = 7615,
  [7639] = 7627,
  [7640] = 7584,
  [7641] = 7583,
  [7642] = 7642,
  [7643] = 7585,
  [7644] = 7578,
  [7645] = 7608,
  [7646] = 7584,
  [7647] = 7586,
  [7648] = 7585,
  [7649] = 7649,
  [7650] = 7650,
  [7651] = 7634,
  [7652] = 7652,
  [7653] = 7617,
  [7654] = 7585,
  [7655] = 7585,
  [7656] = 7617,
  [7657] = 7577,
  [7658] = 7578,
  [7659] = 7584,
  [7660] = 7591,
  [7661] = 7661,
  [7662] = 7578,
  [7663] = 7601,
  [7664] = 7591,
  [7665] = 7577,
  [7666] = 7579,
  [7667] = 7580,
  [7668] = 7584,
  [7669] = 7591,
  [7670] = 7583,
  [7671] = 7580,
  [7672] = 7579,
  [7673] = 7582,
  [7674] = 7674,
  [7675] = 7675,
  [7676] = 7625,
  [7677] = 7677,
  [7678] = 7615,
  [7679] = 7617,
  [7680] = 7585,
  [7681] = 7617,
  [7682] = 7580,
  [7683] = 7578,
  [7684] = 7631,
  [7685] = 7627,
  [7686] = 7577,
  [7687] = 7687,
  [7688] = 7582,
  [7689] = 7582,
  [7690] = 7578,
  [7691] = 7595,
  [7692] = 7627,
  [7693] = 7582,
  [7694] = 7625,
  [7695] = 7578,
  [7696] = 7580,
  [7697] = 7601,
  [7698] = 7584,
  [7699] = 7585,
  [7700] = 7584,
  [7701] = 7601,
  [7702] = 7582,
  [7703] = 7703,
  [7704] = 7704,
  [7705] = 7586,
  [7706] = 7591,
  [7707] = 7591,
  [7708] = 7584,
  [7709] = 7585,
  [7710] = 7617,
  [7711] = 7634,
  [7712] = 7580,
  [7713] = 7615,
  [7714] = 7601,
  [7715] = 7580,
  [7716] = 7634,
  [7717] = 7615,
  [7718] = 7577,
  [7719] = 7608,
  [7720] = 7720,
  [7721] = 7595,
  [7722] = 7586,
  [7723] = 7578,
  [7724] = 7582,
  [7725] = 7606,
  [7726] = 7608,
  [7727] = 7585,
  [7728] = 7598,
  [7729] = 7583,
  [7730] = 7585,
  [7731] = 7617,
  [7732] = 7617,
  [7733] = 7606,
  [7734] = 7627,
  [7735] = 7631,
  [7736] = 7736,
  [7737] = 7595,
  [7738] = 7675,
  [7739] = 7579,
  [7740] = 7577,
  [7741] = 7600,
  [7742] = 7742,
  [7743] = 7608,
  [7744] = 7606,
  [7745] = 7634,
  [7746] = 7627,
  [7747] = 7747,
  [7748] = 7634,
  [7749] = 7595,
  [7750] = 7578,
  [7751] = 7577,
  [7752] = 7752,
  [7753] = 7579,
  [7754] = 7583,
  [7755] = 7617,
  [7756] = 7631,
  [7757] = 7580,
  [7758] = 7631,
  [7759] = 7584,
  [7760] = 7631,
  [7761] = 7617,
  [7762] = 7585,
  [7763] = 7582,
  [7764] = 7627,
  [7765] = 7582,
  [7766] = 7583,
  [7767] = 7577,
  [7768] = 7598,
  [7769] = 7578,
  [7770] = 7615,
  [7771] = 7625,
  [7772] = 7600,
  [7773] = 7600,
  [7774] = 7675,
  [7775] = 7615,
  [7776] = 7591,
  [7777] = 7600,
  [7778] = 7631,
  [7779] = 7583,
  [7780] = 7601,
  [7781] = 7634,
  [7782] = 7578,
  [7783] = 7579,
  [7784] = 7784,
  [7785] = 7586,
  [7786] = 7627,
  [7787] = 7787,
  [7788] = 7606,
  [7789] = 7601,
  [7790] = 7585,
  [7791] = 7608,
  [7792] = 7617,
  [7793] = 7793,
  [7794] = 7634,
  [7795] = 7591,
  [7796] = 7580,
  [7797] = 7797,
  [7798] = 7578,
  [7799] = 7799,
  [7800] = 7800,
  [7801] = 7582,
  [7802] = 7634,
  [7803] = 7598,
  [7804] = 7631,
  [7805] = 7634,
  [7806] = 7578,
  [7807] = 7600,
  [7808] = 7625,
  [7809] = 7617,
  [7810] = 7615,
  [7811] = 7585,
  [7812] = 7675,
  [7813] = 7583,
  [7814] = 7584,
  [7815] = 7815,
  [7816] = 7579,
  [7817] = 7675,
  [7818] = 7627,
  [7819] = 7584,
  [7820] = 7608,
  [7821] = 7634,
  [7822] = 7606,
  [7823] = 7617,
  [7824] = 7585,
  [7825] = 7625,
  [7826] = 7595,
  [7827] = 7827,
  [7828] = 7580,
  [7829] = 7601,
  [7830] = 7615,
  [7831] = 7586,
  [7832] = 7579,
  [7833] = 7601,
  [7834] = 7577,
  [7835] = 7615,
  [7836] = 7584,
  [7837] = 7582,
  [7838] = 7634,
  [7839] = 7591,
  [7840] = 7591,
  [7841] = 7625,
  [7842] = 7842,
  [7843] = 7579,
  [7844] = 7591,
  [7845] = 7601,
  [7846] = 7625,
  [7847] = 7625,
  [7848] = 7585,
  [7849] = 7577,
  [7850] = 7617,
  [7851] = 7851,
  [7852] = 7634,
  [7853] = 7675,
  [7854] = 7595,
  [7855] = 7855,
  [7856] = 7631,
  [7857] = 7582,
  [7858] = 7595,
  [7859] = 7606,
  [7860] = 7582,
  [7861] = 7625,
  [7862] = 7580,
  [7863] = 7606,
  [7864] = 7608,
  [7865] = 7675,
  [7866] = 7584,
  [7867] = 7608,
  [7868] = 7615,
  [7869] = 7869,
  [7870] = 7870,
  [7871] = 7586,
  [7872] = 7606,
  [7873] = 7584,
  [7874] = 7577,
  [7875] = 7595,
  [7876] = 7579,
  [7877] = 6710,
  [7878] = 7578,
  [7879] = 7577,
  [7880] = 7608,
  [7881] = 7586,
  [7882] = 7582,
  [7883] = 7595,
  [7884] = 7600,
  [7885] = 7579,
  [7886] = 7886,
  [7887] = 7887,
  [7888] = 7888,
  [7889] = 7889,
  [7890] = 7890,
  [7891] = 7891,
  [7892] = 7892,
  [7893] = 7893,
  [7894] = 7894,
  [7895] = 7895,
  [7896] = 7896,
  [7897] = 7897,
  [7898] = 7898,
  [7899] = 7899,
  [7900] = 7900,
  [7901] = 7901,
  [7902] = 7902,
  [7903] = 7903,
  [7904] = 7904,
  [7905] = 7905,
  [7906] = 7906,
  [7907] = 7907,
  [7908] = 7908,
  [7909] = 7888,
  [7910] = 7910,
  [7911] = 7910,
  [7912] = 7889,
  [7913] = 7890,
  [7914] = 7891,
  [7915] = 7891,
  [7916] = 7890,
  [7917] = 7889,
  [7918] = 7888,
  [7919] = 7908,
  [7920] = 7920,
  [7921] = 7921,
  [7922] = 7905,
  [7923] = 7894,
  [7924] = 7924,
  [7925] = 7895,
  [7926] = 7920,
  [7927] = 7927,
  [7928] = 7928,
  [7929] = 7929,
  [7930] = 7902,
  [7931] = 7931,
  [7932] = 7932,
  [7933] = 7901,
  [7934] = 7900,
  [7935] = 7935,
  [7936] = 7886,
  [7937] = 7937,
  [7938] = 7938,
  [7939] = 7939,
  [7940] = 7907,
  [7941] = 7892,
  [7942] = 7910,
  [7943] = 7892,
  [7944] = 7944,
  [7945] = 7945,
  [7946] = 7928,
  [7947] = 7947,
  [7948] = 7948,
  [7949] = 7929,
  [7950] = 7950,
  [7951] = 7908,
  [7952] = 7889,
  [7953] = 7895,
  [7954] = 7954,
  [7955] = 7898,
  [7956] = 7890,
  [7957] = 7957,
  [7958] = 7904,
  [7959] = 7927,
  [7960] = 7960,
  [7961] = 7904,
  [7962] = 7962,
  [7963] = 7927,
  [7964] = 7964,
  [7965] = 7965,
  [7966] = 7966,
  [7967] = 7931,
  [7968] = 7968,
  [7969] = 7969,
  [7970] = 7970,
  [7971] = 7950,
  [7972] = 7905,
  [7973] = 7888,
  [7974] = 7905,
  [7975] = 7968,
  [7976] = 7894,
  [7977] = 7908,
  [7978] = 7965,
  [7979] = 7932,
  [7980] = 7968,
  [7981] = 7964,
  [7982] = 7982,
  [7983] = 7894,
  [7984] = 7928,
  [7985] = 7902,
  [7986] = 7986,
  [7987] = 7901,
  [7988] = 7900,
  [7989] = 7950,
  [7990] = 7929,
  [7991] = 7920,
  [7992] = 7893,
  [7993] = 7970,
  [7994] = 7994,
  [7995] = 7895,
  [7996] = 7920,
  [7997] = 7900,
  [7998] = 7901,
  [7999] = 7902,
  [8000] = 8000,
  [8001] = 7908,
  [8002] = 8002,
  [8003] = 7965,
  [8004] = 7893,
  [8005] = 7893,
  [8006] = 7928,
  [8007] = 7929,
  [8008] = 7889,
  [8009] = 7892,
  [8010] = 7889,
  [8011] = 7888,
  [8012] = 7908,
  [8013] = 7944,
  [8014] = 8014,
  [8015] = 7945,
  [8016] = 7894,
  [8017] = 7928,
  [8018] = 7929,
  [8019] = 8019,
  [8020] = 7931,
  [8021] = 7965,
  [8022] = 7928,
  [8023] = 7954,
  [8024] = 8024,
  [8025] = 7957,
  [8026] = 7932,
  [8027] = 7902,
  [8028] = 7920,
  [8029] = 7901,
  [8030] = 7904,
  [8031] = 7927,
  [8032] = 7890,
  [8033] = 7893,
  [8034] = 7886,
  [8035] = 7891,
  [8036] = 7886,
  [8037] = 7899,
  [8038] = 7899,
  [8039] = 8039,
  [8040] = 7891,
  [8041] = 7945,
  [8042] = 8042,
  [8043] = 7905,
  [8044] = 7900,
  [8045] = 7970,
  [8046] = 8046,
  [8047] = 266,
  [8048] = 7968,
  [8049] = 8049,
  [8050] = 8050,
  [8051] = 7907,
  [8052] = 7910,
  [8053] = 8053,
  [8054] = 7931,
  [8055] = 7950,
  [8056] = 8056,
  [8057] = 7932,
  [8058] = 8058,
  [8059] = 8024,
  [8060] = 8053,
  [8061] = 7927,
  [8062] = 7904,
  [8063] = 7968,
  [8064] = 8064,
  [8065] = 7888,
  [8066] = 7920,
  [8067] = 7931,
  [8068] = 8068,
  [8069] = 7905,
  [8070] = 7932,
  [8071] = 7899,
  [8072] = 7965,
  [8073] = 8024,
  [8074] = 8039,
  [8075] = 7964,
  [8076] = 7932,
  [8077] = 7931,
  [8078] = 7950,
  [8079] = 7893,
  [8080] = 7891,
  [8081] = 7929,
  [8082] = 7928,
  [8083] = 7886,
  [8084] = 7899,
  [8085] = 7944,
  [8086] = 7920,
  [8087] = 7895,
  [8088] = 7902,
  [8089] = 7894,
  [8090] = 7895,
  [8091] = 7969,
  [8092] = 7945,
  [8093] = 8024,
  [8094] = 7889,
  [8095] = 7888,
  [8096] = 7908,
  [8097] = 8024,
  [8098] = 8098,
  [8099] = 7908,
  [8100] = 7888,
  [8101] = 7945,
  [8102] = 7889,
  [8103] = 8103,
  [8104] = 7890,
  [8105] = 7891,
  [8106] = 8106,
  [8107] = 8024,
  [8108] = 7901,
  [8109] = 7900,
  [8110] = 7907,
  [8111] = 7960,
  [8112] = 7898,
  [8113] = 7964,
  [8114] = 7907,
  [8115] = 7965,
  [8116] = 8116,
  [8117] = 8117,
  [8118] = 7910,
  [8119] = 7965,
  [8120] = 8120,
  [8121] = 8121,
  [8122] = 8039,
  [8123] = 2847,
  [8124] = 8124,
  [8125] = 7905,
  [8126] = 8103,
  [8127] = 8127,
  [8128] = 7893,
  [8129] = 7902,
  [8130] = 7968,
  [8131] = 7901,
  [8132] = 7900,
  [8133] = 7886,
  [8134] = 8134,
  [8135] = 8135,
  [8136] = 7944,
  [8137] = 8137,
  [8138] = 7968,
  [8139] = 7910,
  [8140] = 8039,
  [8141] = 7902,
  [8142] = 7968,
  [8143] = 7944,
  [8144] = 7899,
  [8145] = 7886,
  [8146] = 8146,
  [8147] = 8147,
  [8148] = 7954,
  [8149] = 7901,
  [8150] = 8150,
  [8151] = 7945,
  [8152] = 7893,
  [8153] = 7893,
  [8154] = 7892,
  [8155] = 7950,
  [8156] = 7899,
  [8157] = 7970,
  [8158] = 7957,
  [8159] = 7932,
  [8160] = 7945,
  [8161] = 7927,
  [8162] = 7931,
  [8163] = 7889,
  [8164] = 7888,
  [8165] = 7908,
  [8166] = 7944,
  [8167] = 7904,
  [8168] = 7950,
  [8169] = 7929,
  [8170] = 7928,
  [8171] = 7954,
  [8172] = 7900,
  [8173] = 8173,
  [8174] = 8039,
  [8175] = 7920,
  [8176] = 8176,
  [8177] = 8177,
  [8178] = 7954,
  [8179] = 7929,
  [8180] = 7904,
  [8181] = 7954,
  [8182] = 8182,
  [8183] = 7968,
  [8184] = 7927,
  [8185] = 7945,
  [8186] = 7957,
  [8187] = 7968,
  [8188] = 7893,
  [8189] = 7889,
  [8190] = 7888,
  [8191] = 7908,
  [8192] = 8192,
  [8193] = 7892,
  [8194] = 7950,
  [8195] = 8195,
  [8196] = 7968,
  [8197] = 270,
  [8198] = 8198,
  [8199] = 7945,
  [8200] = 7907,
  [8201] = 7954,
  [8202] = 7968,
  [8203] = 7895,
  [8204] = 7965,
  [8205] = 7893,
  [8206] = 7960,
  [8207] = 7968,
  [8208] = 7957,
  [8209] = 7920,
  [8210] = 7898,
  [8211] = 8024,
  [8212] = 7893,
  [8213] = 7889,
  [8214] = 7888,
  [8215] = 7908,
  [8216] = 8216,
  [8217] = 7894,
  [8218] = 8218,
  [8219] = 8219,
  [8220] = 7960,
  [8221] = 7910,
  [8222] = 7890,
  [8223] = 7385,
  [8224] = 7908,
  [8225] = 8225,
  [8226] = 7888,
  [8227] = 8024,
  [8228] = 8228,
  [8229] = 7968,
  [8230] = 7889,
  [8231] = 8231,
  [8232] = 7900,
  [8233] = 7893,
  [8234] = 7889,
  [8235] = 7888,
  [8236] = 7908,
  [8237] = 7901,
  [8238] = 7902,
  [8239] = 7904,
  [8240] = 8240,
  [8241] = 7889,
  [8242] = 7890,
  [8243] = 7891,
  [8244] = 7905,
  [8245] = 7927,
  [8246] = 8246,
  [8247] = 7895,
  [8248] = 8248,
  [8249] = 7910,
  [8250] = 7968,
  [8251] = 8251,
  [8252] = 8252,
  [8253] = 7907,
  [8254] = 7893,
  [8255] = 7889,
  [8256] = 7888,
  [8257] = 7908,
  [8258] = 7891,
  [8259] = 7890,
  [8260] = 7968,
  [8261] = 8261,
  [8262] = 7894,
  [8263] = 7950,
  [8264] = 7927,
  [8265] = 7892,
  [8266] = 7907,
  [8267] = 8024,
  [8268] = 7904,
  [8269] = 7889,
  [8270] = 7888,
  [8271] = 7968,
  [8272] = 8272,
  [8273] = 7908,
  [8274] = 7893,
  [8275] = 7889,
  [8276] = 7888,
  [8277] = 7908,
  [8278] = 7932,
  [8279] = 7931,
  [8280] = 8280,
  [8281] = 7910,
  [8282] = 7945,
  [8283] = 7886,
  [8284] = 7888,
  [8285] = 7894,
  [8286] = 8286,
  [8287] = 7965,
  [8288] = 7969,
  [8289] = 7945,
  [8290] = 7893,
  [8291] = 7968,
  [8292] = 7894,
  [8293] = 7960,
  [8294] = 7893,
  [8295] = 7889,
  [8296] = 7888,
  [8297] = 7908,
  [8298] = 7908,
  [8299] = 7895,
  [8300] = 8300,
  [8301] = 8301,
  [8302] = 8302,
  [8303] = 8303,
  [8304] = 7950,
  [8305] = 7945,
  [8306] = 7945,
  [8307] = 8307,
  [8308] = 7905,
  [8309] = 7899,
  [8310] = 7964,
  [8311] = 7968,
  [8312] = 7886,
  [8313] = 7893,
  [8314] = 7889,
  [8315] = 7888,
  [8316] = 7908,
  [8317] = 7892,
  [8318] = 7902,
  [8319] = 7901,
  [8320] = 8320,
  [8321] = 7968,
  [8322] = 7932,
  [8323] = 7900,
  [8324] = 7931,
  [8325] = 7968,
  [8326] = 8326,
  [8327] = 7893,
  [8328] = 7929,
  [8329] = 7892,
  [8330] = 7965,
  [8331] = 7945,
  [8332] = 7928,
  [8333] = 8333,
  [8334] = 7954,
  [8335] = 8335,
  [8336] = 7944,
  [8337] = 8337,
  [8338] = 8338,
  [8339] = 8339,
  [8340] = 8340,
  [8341] = 8341,
  [8342] = 8338,
  [8343] = 8343,
  [8344] = 8344,
  [8345] = 8345,
  [8346] = 8346,
  [8347] = 8347,
  [8348] = 8348,
  [8349] = 8349,
  [8350] = 8349,
  [8351] = 8349,
  [8352] = 8349,
  [8353] = 8349,
  [8354] = 8354,
  [8355] = 8349,
  [8356] = 8349,
  [8357] = 8349,
  [8358] = 8349,
  [8359] = 8349,
  [8360] = 8349,
  [8361] = 8344,
  [8362] = 8362,
  [8363] = 8349,
  [8364] = 8364,
  [8365] = 8365,
  [8366] = 8349,
  [8367] = 8367,
  [8368] = 8368,
  [8369] = 8347,
  [8370] = 8370,
  [8371] = 8371,
  [8372] = 8349,
  [8373] = 8349,
  [8374] = 8337,
  [8375] = 8375,
  [8376] = 8376,
  [8377] = 8349,
  [8378] = 8347,
  [8379] = 8362,
  [8380] = 8380,
  [8381] = 8367,
  [8382] = 8382,
  [8383] = 8383,
  [8384] = 8347,
  [8385] = 8339,
  [8386] = 8349,
  [8387] = 8387,
  [8388] = 8388,
  [8389] = 8347,
  [8390] = 8346,
  [8391] = 8364,
  [8392] = 8348,
  [8393] = 8393,
  [8394] = 8368,
  [8395] = 8354,
  [8396] = 8383,
  [8397] = 8397,
  [8398] = 8364,
  [8399] = 8349,
  [8400] = 2957,
  [8401] = 8401,
  [8402] = 8397,
  [8403] = 8338,
  [8404] = 2967,
  [8405] = 8405,
  [8406] = 8380,
  [8407] = 8368,
  [8408] = 8368,
  [8409] = 8376,
  [8410] = 8380,
  [8411] = 8362,
  [8412] = 8412,
  [8413] = 8347,
  [8414] = 8414,
  [8415] = 8370,
  [8416] = 2936,
  [8417] = 8370,
  [8418] = 8418,
  [8419] = 8419,
  [8420] = 8364,
  [8421] = 8349,
  [8422] = 8414,
  [8423] = 8345,
  [8424] = 8424,
  [8425] = 8425,
  [8426] = 8348,
  [8427] = 8412,
  [8428] = 8419,
  [8429] = 8341,
  [8430] = 8368,
  [8431] = 8397,
  [8432] = 8432,
  [8433] = 8433,
  [8434] = 8434,
  [8435] = 8435,
  [8436] = 8397,
  [8437] = 8401,
  [8438] = 8438,
  [8439] = 8439,
  [8440] = 8341,
  [8441] = 8441,
  [8442] = 8348,
  [8443] = 8340,
  [8444] = 8419,
  [8445] = 8364,
  [8446] = 8370,
  [8447] = 8367,
  [8448] = 8365,
  [8449] = 8340,
  [8450] = 8380,
  [8451] = 8362,
  [8452] = 8338,
  [8453] = 8453,
  [8454] = 8344,
  [8455] = 8376,
  [8456] = 8368,
  [8457] = 8345,
  [8458] = 8380,
  [8459] = 8347,
  [8460] = 8338,
  [8461] = 8370,
  [8462] = 8362,
  [8463] = 8370,
  [8464] = 8347,
  [8465] = 8337,
  [8466] = 8364,
  [8467] = 8405,
  [8468] = 8376,
  [8469] = 8362,
  [8470] = 8380,
  [8471] = 8397,
  [8472] = 8388,
  [8473] = 8439,
  [8474] = 8393,
  [8475] = 8412,
  [8476] = 8368,
  [8477] = 8401,
  [8478] = 8397,
  [8479] = 8397,
  [8480] = 8368,
  [8481] = 8412,
  [8482] = 8414,
  [8483] = 8418,
  [8484] = 8424,
  [8485] = 2946,
  [8486] = 2945,
  [8487] = 8418,
  [8488] = 8341,
  [8489] = 8380,
  [8490] = 8362,
  [8491] = 8347,
  [8492] = 8419,
  [8493] = 8376,
  [8494] = 8364,
  [8495] = 8495,
  [8496] = 8370,
  [8497] = 8347,
  [8498] = 8375,
  [8499] = 8338,
  [8500] = 8365,
  [8501] = 2899,
  [8502] = 8370,
  [8503] = 8393,
  [8504] = 2898,
  [8505] = 8364,
  [8506] = 8340,
  [8507] = 8338,
  [8508] = 8508,
  [8509] = 8509,
  [8510] = 8344,
  [8511] = 8364,
  [8512] = 2873,
  [8513] = 2874,
  [8514] = 8371,
  [8515] = 8345,
  [8516] = 8347,
  [8517] = 8371,
  [8518] = 8376,
  [8519] = 8438,
  [8520] = 8362,
  [8521] = 8371,
  [8522] = 8380,
  [8523] = 8354,
  [8524] = 8412,
  [8525] = 8368,
  [8526] = 8526,
  [8527] = 8388,
  [8528] = 8453,
  [8529] = 8529,
  [8530] = 8393,
  [8531] = 8393,
  [8532] = 8438,
  [8533] = 8424,
  [8534] = 8401,
  [8535] = 8383,
  [8536] = 8397,
  [8537] = 8371,
  [8538] = 8368,
  [8539] = 8354,
  [8540] = 8412,
  [8541] = 8339,
  [8542] = 8380,
  [8543] = 8543,
  [8544] = 8362,
  [8545] = 8453,
  [8546] = 8376,
  [8547] = 8418,
  [8548] = 8548,
  [8549] = 8347,
  [8550] = 8345,
  [8551] = 8551,
  [8552] = 8344,
  [8553] = 8338,
  [8554] = 8438,
  [8555] = 8370,
  [8556] = 8424,
  [8557] = 8383,
  [8558] = 8414,
  [8559] = 8371,
  [8560] = 8560,
  [8561] = 8354,
  [8562] = 8339,
  [8563] = 8364,
  [8564] = 8439,
  [8565] = 8453,
  [8566] = 2876,
  [8567] = 8341,
  [8568] = 8453,
  [8569] = 8569,
  [8570] = 8570,
  [8571] = 8388,
  [8572] = 8341,
  [8573] = 8438,
  [8574] = 8371,
  [8575] = 8419,
  [8576] = 8383,
  [8577] = 8364,
  [8578] = 8371,
  [8579] = 8354,
  [8580] = 8339,
  [8581] = 8370,
  [8582] = 8412,
  [8583] = 8365,
  [8584] = 8368,
  [8585] = 8439,
  [8586] = 8453,
  [8587] = 8397,
  [8588] = 8375,
  [8589] = 8393,
  [8590] = 8438,
  [8591] = 8340,
  [8592] = 8432,
  [8593] = 8338,
  [8594] = 8594,
  [8595] = 8344,
  [8596] = 8383,
  [8597] = 8345,
  [8598] = 8347,
  [8599] = 8380,
  [8600] = 8362,
  [8601] = 8337,
  [8602] = 8337,
  [8603] = 8375,
  [8604] = 8371,
  [8605] = 8376,
  [8606] = 8376,
  [8607] = 8380,
  [8608] = 8354,
  [8609] = 8609,
  [8610] = 8347,
  [8611] = 8345,
  [8612] = 8346,
  [8613] = 8339,
  [8614] = 8344,
  [8615] = 8338,
  [8616] = 8364,
  [8617] = 8388,
  [8618] = 8370,
  [8619] = 8439,
  [8620] = 8393,
  [8621] = 8347,
  [8622] = 8453,
  [8623] = 8388,
  [8624] = 8401,
  [8625] = 8376,
  [8626] = 8397,
  [8627] = 8438,
  [8628] = 8432,
  [8629] = 8368,
  [8630] = 8630,
  [8631] = 8364,
  [8632] = 8362,
  [8633] = 8419,
  [8634] = 8634,
  [8635] = 8383,
  [8636] = 8636,
  [8637] = 8341,
  [8638] = 8412,
  [8639] = 8414,
  [8640] = 8418,
  [8641] = 8367,
  [8642] = 8375,
  [8643] = 8371,
  [8644] = 8424,
  [8645] = 8354,
  [8646] = 8348,
  [8647] = 8424,
  [8648] = 8346,
  [8649] = 8649,
  [8650] = 8650,
  [8651] = 8651,
  [8652] = 8438,
  [8653] = 8653,
  [8654] = 8339,
  [8655] = 8341,
  [8656] = 8412,
  [8657] = 8419,
  [8658] = 8368,
  [8659] = 8364,
  [8660] = 8439,
  [8661] = 8397,
  [8662] = 8401,
  [8663] = 8663,
  [8664] = 8453,
  [8665] = 8393,
  [8666] = 8370,
  [8667] = 8667,
  [8668] = 8365,
  [8669] = 8438,
  [8670] = 8432,
  [8671] = 8671,
  [8672] = 8672,
  [8673] = 8370,
  [8674] = 8339,
  [8675] = 8675,
  [8676] = 8383,
  [8677] = 8346,
  [8678] = 8678,
  [8679] = 8348,
  [8680] = 8344,
  [8681] = 8681,
  [8682] = 8682,
  [8683] = 8367,
  [8684] = 8354,
  [8685] = 8345,
  [8686] = 8380,
  [8687] = 8362,
  [8688] = 8367,
  [8689] = 8375,
  [8690] = 8376,
  [8691] = 8364,
  [8692] = 8371,
  [8693] = 8347,
  [8694] = 8364,
  [8695] = 8376,
  [8696] = 8365,
  [8697] = 8371,
  [8698] = 8375,
  [8699] = 8367,
  [8700] = 8347,
  [8701] = 8345,
  [8702] = 8362,
  [8703] = 8344,
  [8704] = 8380,
  [8705] = 8338,
  [8706] = 8354,
  [8707] = 8348,
  [8708] = 8362,
  [8709] = 8346,
  [8710] = 8383,
  [8711] = 8370,
  [8712] = 8339,
  [8713] = 8380,
  [8714] = 8714,
  [8715] = 8347,
  [8716] = 8364,
  [8717] = 8393,
  [8718] = 8401,
  [8719] = 8397,
  [8720] = 8368,
  [8721] = 8721,
  [8722] = 8432,
  [8723] = 8412,
  [8724] = 8364,
  [8725] = 8438,
  [8726] = 8419,
  [8727] = 8727,
  [8728] = 8728,
  [8729] = 8341,
  [8730] = 8453,
  [8731] = 8432,
  [8732] = 8439,
  [8733] = 8733,
  [8734] = 8734,
  [8735] = 8424,
  [8736] = 8736,
  [8737] = 8737,
  [8738] = 8738,
  [8739] = 8739,
  [8740] = 8740,
  [8741] = 8741,
  [8742] = 8742,
  [8743] = 8743,
  [8744] = 8744,
  [8745] = 8736,
  [8746] = 8746,
  [8747] = 8747,
  [8748] = 8748,
  [8749] = 8749,
  [8750] = 8750,
  [8751] = 8751,
  [8752] = 8752,
  [8753] = 8753,
  [8754] = 8754,
  [8755] = 8755,
  [8756] = 8756,
  [8757] = 8757,
  [8758] = 8758,
  [8759] = 8759,
  [8760] = 8760,
  [8761] = 8759,
  [8762] = 8762,
  [8763] = 8763,
  [8764] = 8742,
  [8765] = 8765,
  [8766] = 8766,
  [8767] = 8767,
  [8768] = 8768,
  [8769] = 8740,
  [8770] = 8770,
  [8771] = 8771,
  [8772] = 8772,
  [8773] = 8773,
  [8774] = 8774,
  [8775] = 8757,
  [8776] = 8776,
  [8777] = 8777,
  [8778] = 8753,
  [8779] = 8779,
  [8780] = 8780,
  [8781] = 8781,
  [8782] = 8782,
  [8783] = 8783,
  [8784] = 8784,
  [8785] = 8785,
  [8786] = 8786,
  [8787] = 8787,
  [8788] = 8788,
  [8789] = 8789,
  [8790] = 8790,
  [8791] = 8791,
  [8792] = 8792,
  [8793] = 8793,
  [8794] = 8794,
  [8795] = 8795,
  [8796] = 8766,
  [8797] = 8758,
  [8798] = 8743,
  [8799] = 8799,
  [8800] = 8800,
  [8801] = 8801,
  [8802] = 8802,
  [8803] = 8803,
  [8804] = 8804,
  [8805] = 8805,
  [8806] = 8806,
  [8807] = 8807,
  [8808] = 8808,
  [8809] = 8806,
  [8810] = 8810,
  [8811] = 8811,
  [8812] = 8812,
  [8813] = 8803,
  [8814] = 8736,
  [8815] = 8804,
  [8816] = 8743,
  [8817] = 8805,
  [8818] = 8758,
  [8819] = 8739,
  [8820] = 8792,
  [8821] = 8821,
  [8822] = 8822,
  [8823] = 8791,
  [8824] = 8793,
  [8825] = 8825,
  [8826] = 8826,
  [8827] = 8801,
  [8828] = 8828,
  [8829] = 8774,
  [8830] = 8800,
  [8831] = 8784,
  [8832] = 8788,
  [8833] = 8740,
  [8834] = 8742,
  [8835] = 8739,
  [8836] = 8794,
  [8837] = 8787,
  [8838] = 8786,
  [8839] = 8839,
  [8840] = 8785,
  [8841] = 8841,
  [8842] = 8744,
  [8843] = 8780,
  [8844] = 8844,
  [8845] = 8845,
  [8846] = 8792,
  [8847] = 8779,
  [8848] = 8790,
  [8849] = 8849,
  [8850] = 8776,
  [8851] = 8851,
  [8852] = 8852,
  [8853] = 8789,
  [8854] = 8754,
  [8855] = 8749,
  [8856] = 8782,
  [8857] = 8857,
  [8858] = 8781,
  [8859] = 8859,
  [8860] = 8757,
  [8861] = 8777,
  [8862] = 8759,
  [8863] = 8772,
  [8864] = 8771,
  [8865] = 8756,
  [8866] = 8770,
  [8867] = 8867,
  [8868] = 8868,
  [8869] = 8869,
  [8870] = 8870,
  [8871] = 8786,
  [8872] = 8787,
  [8873] = 8873,
  [8874] = 8767,
  [8875] = 8765,
  [8876] = 8807,
  [8877] = 8762,
  [8878] = 8746,
  [8879] = 8736,
  [8880] = 8880,
  [8881] = 8766,
  [8882] = 8746,
  [8883] = 8748,
  [8884] = 8754,
  [8885] = 8752,
  [8886] = 8886,
  [8887] = 8887,
  [8888] = 8804,
  [8889] = 8753,
  [8890] = 8754,
  [8891] = 8791,
  [8892] = 8753,
  [8893] = 8893,
  [8894] = 8752,
  [8895] = 8748,
  [8896] = 8746,
  [8897] = 8736,
  [8898] = 8762,
  [8899] = 8807,
  [8900] = 8765,
  [8901] = 8901,
  [8902] = 7528,
  [8903] = 8774,
  [8904] = 6418,
  [8905] = 8767,
  [8906] = 8793,
  [8907] = 8907,
  [8908] = 8803,
  [8909] = 8768,
  [8910] = 8756,
  [8911] = 8744,
  [8912] = 8772,
  [8913] = 8808,
  [8914] = 8740,
  [8915] = 8742,
  [8916] = 8739,
  [8917] = 8770,
  [8918] = 8781,
  [8919] = 8771,
  [8920] = 8782,
  [8921] = 8921,
  [8922] = 8922,
  [8923] = 8744,
  [8924] = 8924,
  [8925] = 8776,
  [8926] = 8926,
  [8927] = 8927,
  [8928] = 8779,
  [8929] = 8929,
  [8930] = 8780,
  [8931] = 8931,
  [8932] = 8785,
  [8933] = 8749,
  [8934] = 8788,
  [8935] = 8935,
  [8936] = 8757,
  [8937] = 8791,
  [8938] = 8759,
  [8939] = 8792,
  [8940] = 8786,
  [8941] = 8758,
  [8942] = 8801,
  [8943] = 8943,
  [8944] = 8805,
  [8945] = 8766,
  [8946] = 8743,
  [8947] = 8806,
  [8948] = 8808,
  [8949] = 8800,
  [8950] = 8803,
  [8951] = 8804,
  [8952] = 8792,
  [8953] = 8953,
  [8954] = 8808,
  [8955] = 8808,
  [8956] = 8803,
  [8957] = 8957,
  [8958] = 8806,
  [8959] = 8959,
  [8960] = 8960,
  [8961] = 8743,
  [8962] = 8805,
  [8963] = 8758,
  [8964] = 8880,
  [8965] = 8793,
  [8966] = 8966,
  [8967] = 8791,
  [8968] = 8790,
  [8969] = 8788,
  [8970] = 8801,
  [8971] = 8785,
  [8972] = 8739,
  [8973] = 8780,
  [8974] = 8974,
  [8975] = 8975,
  [8976] = 8784,
  [8977] = 8849,
  [8978] = 8744,
  [8979] = 8779,
  [8980] = 8794,
  [8981] = 8776,
  [8982] = 8982,
  [8983] = 8771,
  [8984] = 8984,
  [8985] = 8985,
  [8986] = 8770,
  [8987] = 8749,
  [8988] = 8988,
  [8989] = 8767,
  [8990] = 8757,
  [8991] = 8991,
  [8992] = 8759,
  [8993] = 8790,
  [8994] = 8786,
  [8995] = 8765,
  [8996] = 8849,
  [8997] = 8807,
  [8998] = 8998,
  [8999] = 8999,
  [9000] = 8789,
  [9001] = 8762,
  [9002] = 8782,
  [9003] = 8781,
  [9004] = 8777,
  [9005] = 8772,
  [9006] = 8754,
  [9007] = 8756,
  [9008] = 8753,
  [9009] = 9009,
  [9010] = 8793,
  [9011] = 8777,
  [9012] = 8868,
  [9013] = 8748,
  [9014] = 8869,
  [9015] = 8788,
  [9016] = 8739,
  [9017] = 8873,
  [9018] = 8746,
  [9019] = 2068,
  [9020] = 8785,
  [9021] = 8736,
  [9022] = 8744,
  [9023] = 9023,
  [9024] = 9024,
  [9025] = 9025,
  [9026] = 8780,
  [9027] = 8752,
  [9028] = 9028,
  [9029] = 9029,
  [9030] = 9030,
  [9031] = 8749,
  [9032] = 8751,
  [9033] = 8750,
  [9034] = 8757,
  [9035] = 8746,
  [9036] = 8759,
  [9037] = 8966,
  [9038] = 8786,
  [9039] = 8756,
  [9040] = 9040,
  [9041] = 8772,
  [9042] = 9042,
  [9043] = 9043,
  [9044] = 9044,
  [9045] = 8777,
  [9046] = 8748,
  [9047] = 8752,
  [9048] = 9048,
  [9049] = 8781,
  [9050] = 9050,
  [9051] = 9051,
  [9052] = 8782,
  [9053] = 9053,
  [9054] = 8793,
  [9055] = 9055,
  [9056] = 8753,
  [9057] = 8754,
  [9058] = 8953,
  [9059] = 8984,
  [9060] = 8739,
  [9061] = 9061,
  [9062] = 9062,
  [9063] = 8801,
  [9064] = 8893,
  [9065] = 8805,
  [9066] = 8744,
  [9067] = 9067,
  [9068] = 8806,
  [9069] = 9069,
  [9070] = 8803,
  [9071] = 8762,
  [9072] = 8807,
  [9073] = 8765,
  [9074] = 8749,
  [9075] = 8789,
  [9076] = 8901,
  [9077] = 8757,
  [9078] = 8792,
  [9079] = 8759,
  [9080] = 8781,
  [9081] = 8786,
  [9082] = 9044,
  [9083] = 8743,
  [9084] = 9084,
  [9085] = 8767,
  [9086] = 8768,
  [9087] = 8792,
  [9088] = 8791,
  [9089] = 9089,
  [9090] = 8770,
  [9091] = 8779,
  [9092] = 8771,
  [9093] = 9093,
  [9094] = 9094,
  [9095] = 8788,
  [9096] = 8793,
  [9097] = 8785,
  [9098] = 8922,
  [9099] = 8924,
  [9100] = 8776,
  [9101] = 8780,
  [9102] = 8779,
  [9103] = 8779,
  [9104] = 8776,
  [9105] = 8744,
  [9106] = 8780,
  [9107] = 8806,
  [9108] = 9042,
  [9109] = 8785,
  [9110] = 8788,
  [9111] = 8771,
  [9112] = 8791,
  [9113] = 8781,
  [9114] = 8757,
  [9115] = 8758,
  [9116] = 8759,
  [9117] = 8743,
  [9118] = 8770,
  [9119] = 8765,
  [9120] = 8807,
  [9121] = 9043,
  [9122] = 8793,
  [9123] = 8826,
  [9124] = 9055,
  [9125] = 8803,
  [9126] = 8744,
  [9127] = 8762,
  [9128] = 8808,
  [9129] = 8759,
  [9130] = 8806,
  [9131] = 9131,
  [9132] = 8753,
  [9133] = 9133,
  [9134] = 8793,
  [9135] = 8752,
  [9136] = 8960,
  [9137] = 8744,
  [9138] = 8893,
  [9139] = 8759,
  [9140] = 8748,
  [9141] = 8746,
  [9142] = 8805,
  [9143] = 8793,
  [9144] = 8744,
  [9145] = 8759,
  [9146] = 8880,
  [9147] = 8744,
  [9148] = 8759,
  [9149] = 8736,
  [9150] = 8744,
  [9151] = 8759,
  [9152] = 8744,
  [9153] = 8759,
  [9154] = 8744,
  [9155] = 8759,
  [9156] = 8744,
  [9157] = 8759,
  [9158] = 8744,
  [9159] = 8759,
  [9160] = 8744,
  [9161] = 8759,
  [9162] = 8772,
  [9163] = 8777,
  [9164] = 8781,
  [9165] = 9165,
  [9166] = 8801,
  [9167] = 9167,
  [9168] = 9168,
  [9169] = 9169,
  [9170] = 8782,
  [9171] = 9171,
  [9172] = 8800,
  [9173] = 9173,
  [9174] = 9174,
  [9175] = 8782,
  [9176] = 8800,
  [9177] = 8777,
  [9178] = 6396,
  [9179] = 8772,
  [9180] = 8772,
  [9181] = 9181,
  [9182] = 8784,
  [9183] = 8794,
  [9184] = 9184,
  [9185] = 9185,
  [9186] = 8759,
  [9187] = 8757,
  [9188] = 9188,
  [9189] = 8790,
  [9190] = 8799,
  [9191] = 8849,
  [9192] = 8763,
  [9193] = 8776,
  [9194] = 8789,
  [9195] = 9195,
  [9196] = 8924,
  [9197] = 9197,
  [9198] = 9198,
  [9199] = 2070,
  [9200] = 9169,
  [9201] = 8782,
  [9202] = 8880,
  [9203] = 8772,
  [9204] = 8777,
  [9205] = 8753,
  [9206] = 9181,
  [9207] = 9207,
  [9208] = 8756,
  [9209] = 9009,
  [9210] = 8806,
  [9211] = 8868,
  [9212] = 8755,
  [9213] = 8743,
  [9214] = 8773,
  [9215] = 8869,
  [9216] = 8873,
  [9217] = 8803,
  [9218] = 8743,
  [9219] = 8779,
  [9220] = 8922,
  [9221] = 9221,
  [9222] = 6433,
  [9223] = 8736,
  [9224] = 8751,
  [9225] = 8750,
  [9226] = 8746,
  [9227] = 8966,
  [9228] = 9040,
  [9229] = 9042,
  [9230] = 9043,
  [9231] = 9231,
  [9232] = 9044,
  [9233] = 8748,
  [9234] = 8752,
  [9235] = 9048,
  [9236] = 8852,
  [9237] = 8975,
  [9238] = 9050,
  [9239] = 9239,
  [9240] = 9051,
  [9241] = 9241,
  [9242] = 9055,
  [9243] = 9243,
  [9244] = 8792,
  [9245] = 8754,
  [9246] = 8953,
  [9247] = 9247,
  [9248] = 8984,
  [9249] = 9249,
  [9250] = 9250,
  [9251] = 8792,
  [9252] = 9252,
  [9253] = 9253,
  [9254] = 8893,
  [9255] = 8749,
  [9256] = 8762,
  [9257] = 8807,
  [9258] = 8765,
  [9259] = 8901,
  [9260] = 8960,
  [9261] = 8780,
  [9262] = 8767,
  [9263] = 9263,
  [9264] = 9264,
  [9265] = 8768,
  [9266] = 9266,
  [9267] = 9051,
  [9268] = 9089,
  [9269] = 8770,
  [9270] = 9270,
  [9271] = 8771,
  [9272] = 9272,
  [9273] = 9273,
  [9274] = 8779,
  [9275] = 9275,
  [9276] = 8922,
  [9277] = 9277,
  [9278] = 8924,
  [9279] = 8776,
  [9280] = 8771,
  [9281] = 8779,
  [9282] = 8780,
  [9283] = 8765,
  [9284] = 8785,
  [9285] = 8788,
  [9286] = 9286,
  [9287] = 8791,
  [9288] = 9288,
  [9289] = 9289,
  [9290] = 9290,
  [9291] = 8758,
  [9292] = 8743,
  [9293] = 8742,
  [9294] = 8740,
  [9295] = 9295,
  [9296] = 8762,
  [9297] = 8748,
  [9298] = 9298,
  [9299] = 8826,
  [9300] = 9300,
  [9301] = 8803,
  [9302] = 9302,
  [9303] = 8808,
  [9304] = 8743,
  [9305] = 9305,
  [9306] = 9306,
  [9307] = 9307,
  [9308] = 8806,
  [9309] = 8772,
  [9310] = 9310,
  [9311] = 8960,
  [9312] = 8777,
  [9313] = 9313,
  [9314] = 8781,
  [9315] = 8782,
  [9316] = 8806,
  [9317] = 9317,
  [9318] = 8805,
  [9319] = 8756,
  [9320] = 9320,
  [9321] = 8743,
  [9322] = 8880,
  [9323] = 9323,
  [9324] = 9324,
  [9325] = 9325,
  [9326] = 9326,
  [9327] = 9327,
  [9328] = 9328,
  [9329] = 9329,
  [9330] = 8801,
  [9331] = 8803,
  [9332] = 9332,
  [9333] = 8789,
  [9334] = 8800,
  [9335] = 9335,
  [9336] = 9336,
  [9337] = 9337,
  [9338] = 9338,
  [9339] = 8784,
  [9340] = 8794,
  [9341] = 9341,
  [9342] = 8762,
  [9343] = 9165,
  [9344] = 9168,
  [9345] = 9171,
  [9346] = 8792,
  [9347] = 9173,
  [9348] = 9348,
  [9349] = 8772,
  [9350] = 8790,
  [9351] = 8849,
  [9352] = 8799,
  [9353] = 9353,
  [9354] = 8763,
  [9355] = 9169,
  [9356] = 8782,
  [9357] = 9009,
  [9358] = 9197,
  [9359] = 9198,
  [9360] = 8880,
  [9361] = 8781,
  [9362] = 8743,
  [9363] = 8773,
  [9364] = 8777,
  [9365] = 8772,
  [9366] = 9181,
  [9367] = 8737,
  [9368] = 8852,
  [9369] = 9369,
  [9370] = 8756,
  [9371] = 9165,
  [9372] = 9171,
  [9373] = 9009,
  [9374] = 9173,
  [9375] = 9375,
  [9376] = 9376,
  [9377] = 8799,
  [9378] = 8868,
  [9379] = 8763,
  [9380] = 8869,
  [9381] = 8744,
  [9382] = 9197,
  [9383] = 9198,
  [9384] = 8873,
  [9385] = 8773,
  [9386] = 9040,
  [9387] = 8780,
  [9388] = 9050,
  [9389] = 8737,
  [9390] = 8852,
  [9391] = 8753,
  [9392] = 9392,
  [9393] = 9165,
  [9394] = 9171,
  [9395] = 9395,
  [9396] = 9173,
  [9397] = 8739,
  [9398] = 8742,
  [9399] = 8799,
  [9400] = 9400,
  [9401] = 8763,
  [9402] = 8748,
  [9403] = 8901,
  [9404] = 9197,
  [9405] = 9198,
  [9406] = 8773,
  [9407] = 9407,
  [9408] = 9408,
  [9409] = 9409,
  [9410] = 8737,
  [9411] = 8852,
  [9412] = 9069,
  [9413] = 9165,
  [9414] = 9171,
  [9415] = 9415,
  [9416] = 9173,
  [9417] = 9417,
  [9418] = 9418,
  [9419] = 8799,
  [9420] = 8763,
  [9421] = 9421,
  [9422] = 8740,
  [9423] = 9197,
  [9424] = 9198,
  [9425] = 8773,
  [9426] = 8771,
  [9427] = 9427,
  [9428] = 9428,
  [9429] = 8737,
  [9430] = 8852,
  [9431] = 9431,
  [9432] = 9165,
  [9433] = 9171,
  [9434] = 8771,
  [9435] = 9173,
  [9436] = 8762,
  [9437] = 8737,
  [9438] = 8763,
  [9439] = 8736,
  [9440] = 8751,
  [9441] = 9197,
  [9442] = 9198,
  [9443] = 8773,
  [9444] = 8750,
  [9445] = 8746,
  [9446] = 8807,
  [9447] = 8737,
  [9448] = 8852,
  [9449] = 8966,
  [9450] = 9165,
  [9451] = 9171,
  [9452] = 9040,
  [9453] = 9173,
  [9454] = 8765,
  [9455] = 9042,
  [9456] = 8763,
  [9457] = 9043,
  [9458] = 9044,
  [9459] = 9197,
  [9460] = 9198,
  [9461] = 8773,
  [9462] = 8762,
  [9463] = 8752,
  [9464] = 9048,
  [9465] = 8737,
  [9466] = 8852,
  [9467] = 8975,
  [9468] = 9165,
  [9469] = 9050,
  [9470] = 9173,
  [9471] = 9051,
  [9472] = 9055,
  [9473] = 9473,
  [9474] = 8873,
  [9475] = 9197,
  [9476] = 9198,
  [9477] = 8753,
  [9478] = 8753,
  [9479] = 8869,
  [9480] = 8737,
  [9481] = 8868,
  [9482] = 9165,
  [9483] = 9173,
  [9484] = 8754,
  [9485] = 9198,
  [9486] = 8953,
  [9487] = 8765,
  [9488] = 8737,
  [9489] = 8774,
  [9490] = 9165,
  [9491] = 9173,
  [9492] = 8984,
  [9493] = 9198,
  [9494] = 8748,
  [9495] = 8737,
  [9496] = 9165,
  [9497] = 9173,
  [9498] = 9198,
  [9499] = 8737,
  [9500] = 9198,
  [9501] = 8737,
  [9502] = 9198,
  [9503] = 8737,
  [9504] = 9198,
  [9505] = 8737,
  [9506] = 9198,
  [9507] = 8737,
  [9508] = 9198,
  [9509] = 8737,
  [9510] = 9198,
  [9511] = 8737,
  [9512] = 9198,
  [9513] = 8737,
  [9514] = 8788,
  [9515] = 8801,
  [9516] = 9168,
  [9517] = 9517,
  [9518] = 9518,
  [9519] = 9197,
  [9520] = 8893,
  [9521] = 8805,
  [9522] = 8772,
  [9523] = 8749,
  [9524] = 6431,
  [9525] = 8762,
  [9526] = 8807,
  [9527] = 8765,
  [9528] = 8901,
  [9529] = 9369,
  [9530] = 9530,
  [9531] = 8806,
  [9532] = 9532,
  [9533] = 8755,
  [9534] = 8841,
  [9535] = 9198,
  [9536] = 8770,
  [9537] = 9009,
  [9538] = 8767,
  [9539] = 8768,
  [9540] = 8803,
  [9541] = 9089,
  [9542] = 8770,
  [9543] = 8804,
  [9544] = 8779,
  [9545] = 8771,
  [9546] = 9546,
  [9547] = 8743,
  [9548] = 8792,
  [9549] = 8780,
  [9550] = 9518,
  [9551] = 9517,
  [9552] = 8756,
  [9553] = 8779,
  [9554] = 8793,
  [9555] = 9089,
  [9556] = 9272,
  [9557] = 8772,
  [9558] = 8922,
  [9559] = 9174,
  [9560] = 9181,
  [9561] = 9173,
  [9562] = 8924,
  [9563] = 9195,
  [9564] = 8779,
  [9565] = 8776,
  [9566] = 8771,
  [9567] = 8772,
  [9568] = 8777,
  [9569] = 8782,
  [9570] = 9570,
  [9571] = 9571,
  [9572] = 9171,
  [9573] = 8766,
  [9574] = 8868,
  [9575] = 8869,
  [9576] = 9168,
  [9577] = 8762,
  [9578] = 8873,
  [9579] = 8748,
  [9580] = 8779,
  [9581] = 8781,
  [9582] = 8780,
  [9583] = 9583,
  [9584] = 8785,
  [9585] = 8758,
  [9586] = 8789,
  [9587] = 8791,
  [9588] = 8792,
  [9589] = 8800,
  [9590] = 8743,
  [9591] = 9591,
  [9592] = 8742,
  [9593] = 8779,
  [9594] = 8740,
  [9595] = 9167,
  [9596] = 9168,
  [9597] = 9517,
  [9598] = 9518,
  [9599] = 8748,
  [9600] = 8975,
  [9601] = 9048,
  [9602] = 8755,
  [9603] = 8841,
  [9604] = 8762,
  [9605] = 8826,
  [9606] = 8803,
  [9607] = 9168,
  [9608] = 9517,
  [9609] = 9518,
  [9610] = 8748,
  [9611] = 9611,
  [9612] = 8755,
  [9613] = 8841,
  [9614] = 8808,
  [9615] = 9615,
  [9616] = 9165,
  [9617] = 9168,
  [9618] = 9517,
  [9619] = 9518,
  [9620] = 8988,
  [9621] = 8849,
  [9622] = 8755,
  [9623] = 8841,
  [9624] = 9024,
  [9625] = 8790,
  [9626] = 8806,
  [9627] = 9517,
  [9628] = 9518,
  [9629] = 8762,
  [9630] = 8748,
  [9631] = 8755,
  [9632] = 8841,
  [9633] = 8880,
  [9634] = 8748,
  [9635] = 9517,
  [9636] = 9518,
  [9637] = 8752,
  [9638] = 9638,
  [9639] = 8755,
  [9640] = 8841,
  [9641] = 8768,
  [9642] = 8762,
  [9643] = 9517,
  [9644] = 9518,
  [9645] = 8748,
  [9646] = 9646,
  [9647] = 8755,
  [9648] = 8841,
  [9649] = 8794,
  [9650] = 9650,
  [9651] = 9517,
  [9652] = 9518,
  [9653] = 9653,
  [9654] = 8755,
  [9655] = 8841,
  [9656] = 8767,
  [9657] = 8748,
  [9658] = 8755,
  [9659] = 8841,
  [9660] = 8784,
  [9661] = 8804,
  [9662] = 8841,
  [9663] = 9663,
  [9664] = 8841,
  [9665] = 9665,
  [9666] = 8841,
  [9667] = 8793,
  [9668] = 8841,
  [9669] = 8762,
  [9670] = 8841,
  [9671] = 9671,
  [9672] = 8841,
  [9673] = 8748,
  [9674] = 8841,
  [9675] = 8762,
  [9676] = 8841,
  [9677] = 9677,
  [9678] = 8841,
  [9679] = 9571,
  [9680] = 9532,
  [9681] = 8766,
  [9682] = 9571,
  [9683] = 9532,
  [9684] = 8960,
  [9685] = 9571,
  [9686] = 9532,
  [9687] = 9169,
  [9688] = 9571,
  [9689] = 9532,
  [9690] = 9690,
  [9691] = 9571,
  [9692] = 9532,
  [9693] = 8805,
  [9694] = 9571,
  [9695] = 9532,
  [9696] = 8880,
  [9697] = 9571,
  [9698] = 9532,
  [9699] = 9699,
  [9700] = 9532,
  [9701] = 9532,
  [9702] = 9532,
  [9703] = 9532,
  [9704] = 9532,
  [9705] = 9532,
  [9706] = 9532,
  [9707] = 9532,
  [9708] = 9532,
  [9709] = 9532,
  [9710] = 9532,
  [9711] = 8787,
  [9712] = 8786,
  [9713] = 8801,
  [9714] = 8748,
  [9715] = 8787,
  [9716] = 8762,
  [9717] = 8786,
  [9718] = 9570,
  [9719] = 9570,
  [9720] = 9570,
  [9721] = 9570,
  [9722] = 9570,
  [9723] = 9570,
  [9724] = 9570,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 43312
    ? (c < 3804
      ? (c < 2579
        ? (c < 1646
          ? (c < 710
            ? (c < 'j'
              ? (c < 'V'
                ? (c < 'G'
                  ? (c < 'A'
                    ? c == '$'
                    : c <= 'E')
                  : (c <= 'K' || (c < 'S'
                    ? (c >= 'M' && c <= 'Q')
                    : c <= 'S')))
                : (c <= 'Z' || (c < 'e'
                  ? (c < 'a'
                    ? c == '_'
                    : c <= 'a')
                  : (c <= 'e' || (c >= 'g' && c <= 'h')))))
              : (c <= 'l' || (c < 181
                ? (c < 'w'
                  ? (c < 'q'
                    ? c == 'o'
                    : c <= 'r')
                  : (c <= 'z' || c == 170))
                : (c <= 181 || (c < 216
                  ? (c < 192
                    ? c == 186
                    : c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))))))
            : (c <= 721 || (c < 910
              ? (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 880 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || c == 908))))
              : (c <= 929 || (c < 1369
                ? (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c >= 1329 && c <= 1366)))
                : (c <= 1369 || (c < 1519
                  ? (c < 1488
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))))))))
          : (c <= 1647 || (c < 2185
            ? (c < 1994
              ? (c < 1791
                ? (c < 1765
                  ? (c < 1749
                    ? (c >= 1649 && c <= 1747)
                    : c <= 1749)
                  : (c <= 1766 || (c < 1786
                    ? (c >= 1774 && c <= 1775)
                    : c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))
              : (c <= 2026 || (c < 2084
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || c == 2074))
                : (c <= 2084 || (c < 2144
                  ? (c < 2112
                    ? c == 2088
                    : c <= 2136)
                  : (c <= 2154 || (c >= 2160 && c <= 2183)))))))
            : (c <= 2190 || (c < 2482
              ? (c < 2417
                ? (c < 2365
                  ? (c < 2308
                    ? (c >= 2208 && c <= 2249)
                    : c <= 2361)
                  : (c <= 2365 || (c < 2392
                    ? c == 2384
                    : c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))
              : (c <= 2482 || (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))))))))
        : (c <= 2600 || (c < 3114
          ? (c < 2858
            ? (c < 2730
              ? (c < 2654
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c < 2649
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2652)))
                : (c <= 2654 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2674 && c <= 2676)
                    : c <= 2701)
                  : (c <= 2705 || (c >= 2707 && c <= 2728)))))
              : (c <= 2736 || (c < 2784
                ? (c < 2749
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2749 || c == 2768))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))))
            : (c <= 2864 || (c < 2969
              ? (c < 2929
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2913)))
                : (c <= 2929 || (c < 2958
                  ? (c < 2949
                    ? c == 2947
                    : c <= 2954)
                  : (c <= 2960 || (c >= 2962 && c <= 2965)))))
              : (c <= 2970 || (c < 2990
                ? (c < 2979
                  ? (c < 2974
                    ? c == 2972
                    : c <= 2975)
                  : (c <= 2980 || (c >= 2984 && c <= 2986)))
                : (c <= 3001 || (c < 3086
                  ? (c < 3077
                    ? c == 3024
                    : c <= 3084)
                  : (c <= 3088 || (c >= 3090 && c <= 3112)))))))))
          : (c <= 3129 || (c < 3423
            ? (c < 3261
              ? (c < 3205
                ? (c < 3165
                  ? (c < 3160
                    ? c == 3133
                    : c <= 3162)
                  : (c <= 3165 || (c < 3200
                    ? (c >= 3168 && c <= 3169)
                    : c <= 3200)))
                : (c <= 3212 || (c < 3242
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))))
              : (c <= 3261 || (c < 3342
                ? (c < 3313
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3297)
                  : (c <= 3314 || (c >= 3332 && c <= 3340)))
                : (c <= 3344 || (c < 3406
                  ? (c < 3389
                    ? (c >= 3346 && c <= 3386)
                    : c <= 3389)
                  : (c <= 3406 || (c >= 3412 && c <= 3414)))))))
            : (c <= 3425 || (c < 3713
              ? (c < 3517
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3478)
                  : (c <= 3505 || (c >= 3507 && c <= 3515)))
                : (c <= 3517 || (c < 3634
                  ? (c < 3585
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3632)
                  : (c <= 3634 || (c >= 3648 && c <= 3654)))))
              : (c <= 3714 || (c < 3751
                ? (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || c == 3749))
                : (c <= 3760 || (c < 3776
                  ? (c < 3773
                    ? c == 3762
                    : c <= 3773)
                  : (c <= 3780 || c == 3782))))))))))))
      : (c <= 3807 || (c < 8027
        ? (c < 5888
          ? (c < 4696
            ? (c < 4206
              ? (c < 4159
                ? (c < 3913
                  ? (c < 3904
                    ? c == 3840
                    : c <= 3911)
                  : (c <= 3948 || (c < 4096
                    ? (c >= 3976 && c <= 3980)
                    : c <= 4138)))
                : (c <= 4159 || (c < 4193
                  ? (c < 4186
                    ? (c >= 4176 && c <= 4181)
                    : c <= 4189)
                  : (c <= 4193 || (c >= 4197 && c <= 4198)))))
              : (c <= 4208 || (c < 4301
                ? (c < 4256
                  ? (c < 4238
                    ? (c >= 4213 && c <= 4225)
                    : c <= 4238)
                  : (c <= 4293 || c == 4295))
                : (c <= 4301 || (c < 4682
                  ? (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)
                  : (c <= 4685 || (c >= 4688 && c <= 4694)))))))
            : (c <= 4696 || (c < 4882
              ? (c < 4792
                ? (c < 4746
                  ? (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)
                  : (c <= 4749 || (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)))
                : (c <= 4798 || (c < 4808
                  ? (c < 4802
                    ? c == 4800
                    : c <= 4805)
                  : (c <= 4822 || (c >= 4824 && c <= 4880)))))
              : (c <= 4885 || (c < 5121
                ? (c < 5024
                  ? (c < 4992
                    ? (c >= 4888 && c <= 4954)
                    : c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5792
                  ? (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)
                  : (c <= 5866 || (c >= 5870 && c <= 5880)))))))))
          : (c <= 5905 || (c < 6981
            ? (c < 6320
              ? (c < 6103
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5937)
                    : c <= 5969)
                  : (c <= 5996 || (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)))
                : (c <= 6103 || (c < 6272
                  ? (c < 6176
                    ? c == 6108
                    : c <= 6264)
                  : (c <= 6312 || c == 6314))))
              : (c <= 6389 || (c < 6576
                ? (c < 6512
                  ? (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)
                  : (c <= 6516 || (c >= 6528 && c <= 6571)))
                : (c <= 6601 || (c < 6823
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6678)
                    : c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))))))
            : (c <= 6988 || (c < 7406
              ? (c < 7258
                ? (c < 7098
                  ? (c < 7086
                    ? (c >= 7043 && c <= 7072)
                    : c <= 7087)
                  : (c <= 7141 || (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)))
                : (c <= 7293 || (c < 7357
                  ? (c < 7312
                    ? (c >= 7296 && c <= 7304)
                    : c <= 7354)
                  : (c <= 7359 || (c >= 7401 && c <= 7404)))))
              : (c <= 7411 || (c < 7960
                ? (c < 7424
                  ? (c < 7418
                    ? (c >= 7413 && c <= 7414)
                    : c <= 7418)
                  : (c <= 7615 || (c >= 7680 && c <= 7957)))
                : (c <= 7965 || (c < 8016
                  ? (c < 8008
                    ? (c >= 7968 && c <= 8005)
                    : c <= 8013)
                  : (c <= 8023 || c == 8025))))))))))
        : (c <= 8027 || (c < 11712
          ? (c < 8484
            ? (c < 8178
              ? (c < 8130
                ? (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)))
                : (c <= 8132 || (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c >= 8160 && c <= 8172)))))
              : (c <= 8180 || (c < 8450
                ? (c < 8319
                  ? (c < 8305
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8305)
                  : (c <= 8319 || (c >= 8336 && c <= 8348)))
                : (c <= 8450 || (c < 8469
                  ? (c < 8458
                    ? c == 8455
                    : c <= 8467)
                  : (c <= 8469 || (c >= 8472 && c <= 8477)))))))
            : (c <= 8484 || (c < 11520
              ? (c < 8526
                ? (c < 8490
                  ? (c < 8488
                    ? c == 8486
                    : c <= 8488)
                  : (c <= 8505 || (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)))
                : (c <= 8526 || (c < 11499
                  ? (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))))
              : (c <= 11557 || (c < 11648
                ? (c < 11568
                  ? (c < 11565
                    ? c == 11559
                    : c <= 11565)
                  : (c <= 11623 || c == 11631))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c >= 11704 && c <= 11710)))))))))
          : (c <= 11718 || (c < 42538
            ? (c < 12540
              ? (c < 12337
                ? (c < 11736
                  ? (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)
                  : (c <= 11742 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12329)))
                : (c <= 12341 || (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c >= 12449 && c <= 12538)))))
              : (c <= 12543 || (c < 13312
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c >= 12784 && c <= 12799)))
                : (c <= 19903 || (c < 42240
                  ? (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)
                  : (c <= 42508 || (c >= 42512 && c <= 42527)))))))
            : (c <= 42539 || (c < 42994
              ? (c < 42786
                ? (c < 42656
                  ? (c < 42623
                    ? (c >= 42560 && c <= 42606)
                    : c <= 42653)
                  : (c <= 42735 || (c >= 42775 && c <= 42783)))
                : (c <= 42888 || (c < 42963
                  ? (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)
                  : (c <= 42963 || (c >= 42965 && c <= 42969)))))
              : (c <= 43009 || (c < 43138
                ? (c < 43020
                  ? (c < 43015
                    ? (c >= 43011 && c <= 43013)
                    : c <= 43018)
                  : (c <= 43042 || (c >= 43072 && c <= 43123)))
                : (c <= 43187 || (c < 43261
                  ? (c < 43259
                    ? (c >= 43250 && c <= 43255)
                    : c <= 43259)
                  : (c <= 43262 || (c >= 43274 && c <= 43301)))))))))))))))
    : (c <= 43334 || (c < 70480
      ? (c < 66816
        ? (c < 64323
          ? (c < 43777
            ? (c < 43642
              ? (c < 43514
                ? (c < 43471
                  ? (c < 43396
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43442)
                  : (c <= 43471 || (c < 43494
                    ? (c >= 43488 && c <= 43492)
                    : c <= 43503)))
                : (c <= 43518 || (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c >= 43616 && c <= 43638)))))
              : (c <= 43642 || (c < 43712
                ? (c < 43701
                  ? (c < 43697
                    ? (c >= 43646 && c <= 43695)
                    : c <= 43697)
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))
                : (c <= 43712 || (c < 43744
                  ? (c < 43739
                    ? c == 43714
                    : c <= 43741)
                  : (c <= 43754 || (c >= 43762 && c <= 43764)))))))
            : (c <= 43782 || (c < 63744
              ? (c < 43868
                ? (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)))
                : (c <= 43881 || (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))))
              : (c <= 64109 || (c < 64287
                ? (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))
                : (c <= 64296 || (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))))))))
          : (c <= 64324 || (c < 65498
            ? (c < 65147
              ? (c < 65008
                ? (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)))
                : (c <= 65017 || (c < 65143
                  ? (c < 65139
                    ? c == 65137
                    : c <= 65139)
                  : (c <= 65143 || c == 65145))))
              : (c <= 65147 || (c < 65382
                ? (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))
                : (c <= 65437 || (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))))))
            : (c <= 65500 || (c < 66304
              ? (c < 65616
                ? (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)))
                : (c <= 65629 || (c < 66176
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66204 || (c >= 66208 && c <= 66256)))))
              : (c <= 66335 || (c < 66504
                ? (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66421)
                  : (c <= 66461 || (c >= 66464 && c <= 66499)))
                : (c <= 66511 || (c < 66736
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66771 || (c >= 66776 && c <= 66811)))))))))))
        : (c <= 66855 || (c < 68608
          ? (c < 67647
            ? (c < 67392
              ? (c < 66967
                ? (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)))
                : (c <= 66977 || (c < 67003
                  ? (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)
                  : (c <= 67004 || (c >= 67072 && c <= 67382)))))
              : (c <= 67413 || (c < 67584
                ? (c < 67463
                  ? (c < 67456
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67461)
                  : (c <= 67504 || (c >= 67506 && c <= 67514)))
                : (c <= 67589 || (c < 67639
                  ? (c < 67594
                    ? c == 67592
                    : c <= 67637)
                  : (c <= 67640 || c == 67644))))))
            : (c <= 67669 || (c < 68117
              ? (c < 67872
                ? (c < 67808
                  ? (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)
                  : (c <= 67826 || (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)))
                : (c <= 67897 || (c < 68096
                  ? (c < 68030
                    ? (c >= 67968 && c <= 68023)
                    : c <= 68031)
                  : (c <= 68096 || (c >= 68112 && c <= 68115)))))
              : (c <= 68119 || (c < 68297
                ? (c < 68224
                  ? (c < 68192
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68220)
                  : (c <= 68252 || (c >= 68288 && c <= 68295)))
                : (c <= 68324 || (c < 68448
                  ? (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)
                  : (c <= 68466 || (c >= 68480 && c <= 68497)))))))))
          : (c <= 68680 || (c < 70006
            ? (c < 69600
              ? (c < 69376
                ? (c < 68864
                  ? (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)
                  : (c <= 68899 || (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)))
                : (c <= 69404 || (c < 69488
                  ? (c < 69424
                    ? c == 69415
                    : c <= 69445)
                  : (c <= 69505 || (c >= 69552 && c <= 69572)))))
              : (c <= 69622 || (c < 69840
                ? (c < 69749
                  ? (c < 69745
                    ? (c >= 69635 && c <= 69687)
                    : c <= 69746)
                  : (c <= 69749 || (c >= 69763 && c <= 69807)))
                : (c <= 69864 || (c < 69959
                  ? (c < 69956
                    ? (c >= 69891 && c <= 69926)
                    : c <= 69956)
                  : (c <= 69959 || (c >= 69968 && c <= 70002)))))))
            : (c <= 70006 || (c < 70287
              ? (c < 70144
                ? (c < 70106
                  ? (c < 70081
                    ? (c >= 70019 && c <= 70066)
                    : c <= 70084)
                  : (c <= 70106 || c == 70108))
                : (c <= 70161 || (c < 70280
                  ? (c < 70272
                    ? (c >= 70163 && c <= 70187)
                    : c <= 70278)
                  : (c <= 70280 || (c >= 70282 && c <= 70285)))))
              : (c <= 70301 || (c < 70419
                ? (c < 70405
                  ? (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70366)
                  : (c <= 70412 || (c >= 70415 && c <= 70416)))
                : (c <= 70440 || (c < 70453
                  ? (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : c <= 70451)
                  : (c <= 70457 || c == 70461))))))))))))
      : (c <= 70480 || (c < 119808
        ? (c < 72971
          ? (c < 71957
            ? (c < 71236
              ? (c < 70852
                ? (c < 70727
                  ? (c < 70656
                    ? (c >= 70493 && c <= 70497)
                    : c <= 70708)
                  : (c <= 70730 || (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)))
                : (c <= 70853 || (c < 71128
                  ? (c < 71040
                    ? c == 70855
                    : c <= 71086)
                  : (c <= 71131 || (c >= 71168 && c <= 71215)))))
              : (c <= 71236 || (c < 71680
                ? (c < 71424
                  ? (c < 71352
                    ? (c >= 71296 && c <= 71338)
                    : c <= 71352)
                  : (c <= 71450 || (c >= 71488 && c <= 71494)))
                : (c <= 71723 || (c < 71945
                  ? (c < 71935
                    ? (c >= 71840 && c <= 71903)
                    : c <= 71942)
                  : (c <= 71945 || (c >= 71948 && c <= 71955)))))))
            : (c <= 71958 || (c < 72272
              ? (c < 72161
                ? (c < 72001
                  ? (c < 71999
                    ? (c >= 71960 && c <= 71983)
                    : c <= 71999)
                  : (c <= 72001 || (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)))
                : (c <= 72161 || (c < 72203
                  ? (c < 72192
                    ? c == 72163
                    : c <= 72192)
                  : (c <= 72242 || c == 72250))))
              : (c <= 72272 || (c < 72714
                ? (c < 72368
                  ? (c < 72349
                    ? (c >= 72284 && c <= 72329)
                    : c <= 72349)
                  : (c <= 72440 || (c >= 72704 && c <= 72712)))
                : (c <= 72750 || (c < 72960
                  ? (c < 72818
                    ? c == 72768
                    : c <= 72847)
                  : (c <= 72966 || (c >= 72968 && c <= 72969)))))))))
          : (c <= 73008 || (c < 93053
            ? (c < 77712
              ? (c < 73440
                ? (c < 73063
                  ? (c < 73056
                    ? c == 73030
                    : c <= 73061)
                  : (c <= 73064 || (c < 73112
                    ? (c >= 73066 && c <= 73097)
                    : c <= 73112)))
                : (c <= 73458 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c >= 74880 && c <= 75075)))))
              : (c <= 77808 || (c < 92784
                ? (c < 92160
                  ? (c < 82944
                    ? (c >= 77824 && c <= 78894)
                    : c <= 83526)
                  : (c <= 92728 || (c >= 92736 && c <= 92766)))
                : (c <= 92862 || (c < 92992
                  ? (c < 92928
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92975)
                  : (c <= 92995 || (c >= 93027 && c <= 93047)))))))
            : (c <= 93071 || (c < 110581
              ? (c < 94179
                ? (c < 94032
                  ? (c < 93952
                    ? (c >= 93760 && c <= 93823)
                    : c <= 94026)
                  : (c <= 94032 || (c < 94176
                    ? (c >= 94099 && c <= 94111)
                    : c <= 94177)))
                : (c <= 94179 || (c < 101632
                  ? (c < 100352
                    ? (c >= 94208 && c <= 100343)
                    : c <= 101589)
                  : (c <= 101640 || (c >= 110576 && c <= 110579)))))
              : (c <= 110587 || (c < 110960
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c >= 110948 && c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c >= 113808 && c <= 113817)))))))))))
        : (c <= 119892 || (c < 125259
          ? (c < 120540
            ? (c < 120077
              ? (c < 119982
                ? (c < 119970
                  ? (c < 119966
                    ? (c >= 119894 && c <= 119964)
                    : c <= 119967)
                  : (c <= 119970 || (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)))
                : (c <= 119993 || (c < 120005
                  ? (c < 119997
                    ? c == 119995
                    : c <= 120003)
                  : (c <= 120069 || (c >= 120071 && c <= 120074)))))
              : (c <= 120084 || (c < 120134
                ? (c < 120123
                  ? (c < 120094
                    ? (c >= 120086 && c <= 120092)
                    : c <= 120121)
                  : (c <= 120126 || (c >= 120128 && c <= 120132)))
                : (c <= 120134 || (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c >= 120514 && c <= 120538)))))))
            : (c <= 120570 || (c < 123191
              ? (c < 120714
                ? (c < 120630
                  ? (c < 120598
                    ? (c >= 120572 && c <= 120596)
                    : c <= 120628)
                  : (c <= 120654 || (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 43396
    ? (c < 3913
      ? (c < 2613
        ? (c < 1765
          ? (c < 750
            ? (c < 'w'
              ? (c < 'g'
                ? (c < '_'
                  ? (c < 'A'
                    ? c == '$'
                    : c <= 'Z')
                  : (c <= '_' || (c < 'e'
                    ? c == 'a'
                    : c <= 'e')))
                : (c <= 'h' || (c < 'q'
                  ? (c < 'o'
                    ? (c >= 'j' && c <= 'l')
                    : c <= 'o')
                  : (c <= 'r' || c == 't'))))
              : (c <= 'z' || (c < 216
                ? (c < 186
                  ? (c < 181
                    ? c == 170
                    : c <= 181)
                  : (c <= 186 || (c >= 192 && c <= 214)))
                : (c <= 246 || (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || c == 748))))))
            : (c <= 750 || (c < 1162
              ? (c < 904
                ? (c < 891
                  ? (c < 886
                    ? (c >= 880 && c <= 884)
                    : c <= 887)
                  : (c <= 893 || (c < 902
                    ? c == 895
                    : c <= 902)))
                : (c <= 906 || (c < 931
                  ? (c < 910
                    ? c == 908
                    : c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))))
              : (c <= 1327 || (c < 1519
                ? (c < 1376
                  ? (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)
                  : (c <= 1416 || (c >= 1488 && c <= 1514)))
                : (c <= 1522 || (c < 1649
                  ? (c < 1646
                    ? (c >= 1568 && c <= 1610)
                    : c <= 1647)
                  : (c <= 1747 || c == 1749))))))))
          : (c <= 1766 || (c < 2365
            ? (c < 2048
              ? (c < 1869
                ? (c < 1791
                  ? (c < 1786
                    ? (c >= 1774 && c <= 1775)
                    : c <= 1788)
                  : (c <= 1791 || (c < 1810
                    ? c == 1808
                    : c <= 1839)))
                : (c <= 1957 || (c < 2036
                  ? (c < 1994
                    ? c == 1969
                    : c <= 2026)
                  : (c <= 2037 || c == 2042))))
              : (c <= 2069 || (c < 2144
                ? (c < 2088
                  ? (c < 2084
                    ? c == 2074
                    : c <= 2084)
                  : (c <= 2088 || (c >= 2112 && c <= 2136)))
                : (c <= 2154 || (c < 2208
                  ? (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)
                  : (c <= 2249 || (c >= 2308 && c <= 2361)))))))
            : (c <= 2365 || (c < 2510
              ? (c < 2451
                ? (c < 2417
                  ? (c < 2392
                    ? c == 2384
                    : c <= 2401)
                  : (c <= 2432 || (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)))
                : (c <= 2472 || (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || c == 2493))))
              : (c <= 2510 || (c < 2565
                ? (c < 2544
                  ? (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2529)
                  : (c <= 2545 || c == 2556))
                : (c <= 2570 || (c < 2602
                  ? (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)
                  : (c <= 2608 || (c >= 2610 && c <= 2611)))))))))))
        : (c <= 2614 || (c < 3165
          ? (c < 2877
            ? (c < 2749
              ? (c < 2703
                ? (c < 2654
                  ? (c < 2649
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2652)
                  : (c <= 2654 || (c < 2693
                    ? (c >= 2674 && c <= 2676)
                    : c <= 2701)))
                : (c <= 2705 || (c < 2738
                  ? (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)
                  : (c <= 2739 || (c >= 2741 && c <= 2745)))))
              : (c <= 2749 || (c < 2831
                ? (c < 2809
                  ? (c < 2784
                    ? c == 2768
                    : c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2866
                  ? (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)
                  : (c <= 2867 || (c >= 2869 && c <= 2873)))))))
            : (c <= 2877 || (c < 2979
              ? (c < 2958
                ? (c < 2929
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2913)
                  : (c <= 2929 || (c < 2949
                    ? c == 2947
                    : c <= 2954)))
                : (c <= 2960 || (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c >= 2974 && c <= 2975)))))
              : (c <= 2980 || (c < 3086
                ? (c < 3024
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))
                : (c <= 3088 || (c < 3133
                  ? (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)
                  : (c <= 3133 || (c >= 3160 && c <= 3162)))))))))
          : (c <= 3165 || (c < 3482
            ? (c < 3313
              ? (c < 3242
                ? (c < 3205
                  ? (c < 3200
                    ? (c >= 3168 && c <= 3169)
                    : c <= 3200)
                  : (c <= 3212 || (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)))
                : (c <= 3251 || (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c >= 3296 && c <= 3297)))))
              : (c <= 3314 || (c < 3406
                ? (c < 3346
                  ? (c < 3342
                    ? (c >= 3332 && c <= 3340)
                    : c <= 3344)
                  : (c <= 3386 || c == 3389))
                : (c <= 3406 || (c < 3450
                  ? (c < 3423
                    ? (c >= 3412 && c <= 3414)
                    : c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))))))
            : (c <= 3505 || (c < 3724
              ? (c < 3634
                ? (c < 3520
                  ? (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)
                  : (c <= 3526 || (c >= 3585 && c <= 3632)))
                : (c <= 3634 || (c < 3716
                  ? (c < 3713
                    ? (c >= 3648 && c <= 3654)
                    : c <= 3714)
                  : (c <= 3716 || (c >= 3718 && c <= 3722)))))
              : (c <= 3747 || (c < 3776
                ? (c < 3762
                  ? (c < 3751
                    ? c == 3749
                    : c <= 3760)
                  : (c <= 3762 || c == 3773))
                : (c <= 3780 || (c < 3840
                  ? (c < 3804
                    ? c == 3782
                    : c <= 3807)
                  : (c <= 3840 || (c >= 3904 && c <= 3911)))))))))))))
      : (c <= 3948 || (c < 8031
        ? (c < 5984
          ? (c < 4746
            ? (c < 4256
              ? (c < 4193
                ? (c < 4159
                  ? (c < 4096
                    ? (c >= 3976 && c <= 3980)
                    : c <= 4138)
                  : (c <= 4159 || (c < 4186
                    ? (c >= 4176 && c <= 4181)
                    : c <= 4189)))
                : (c <= 4193 || (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || c == 4238))))
              : (c <= 4293 || (c < 4682
                ? (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c >= 4348 && c <= 4680)))
                : (c <= 4685 || (c < 4698
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : c <= 4696)
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))))))
            : (c <= 4749 || (c < 5024
              ? (c < 4808
                ? (c < 4792
                  ? (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)
                  : (c <= 4798 || (c < 4802
                    ? c == 4800
                    : c <= 4805)))
                : (c <= 4822 || (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))))
              : (c <= 5109 || (c < 5792
                ? (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))
                : (c <= 5866 || (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))))))))
          : (c <= 5996 || (c < 7098
            ? (c < 6512
              ? (c < 6272
                ? (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || (c < 6176
                    ? c == 6108
                    : c <= 6264)))
                : (c <= 6312 || (c < 6400
                  ? (c < 6320
                    ? c == 6314
                    : c <= 6389)
                  : (c <= 6430 || (c >= 6480 && c <= 6509)))))
              : (c <= 6516 || (c < 6823
                ? (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))
                : (c <= 6823 || (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))))))
            : (c <= 7141 || (c < 7418
              ? (c < 7312
                ? (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))
                : (c <= 7354 || (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))))
              : (c <= 7418 || (c < 8008
                ? (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))
                : (c <= 8013 || (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))))))))))
        : (c <= 8061 || (c < 11728
          ? (c < 8488
            ? (c < 8305
              ? (c < 8144
                ? (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)))
                : (c <= 8147 || (c < 8178
                  ? (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))))
              : (c <= 8305 || (c < 8458
                ? (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))
                : (c <= 8467 || (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))))))
            : (c <= 8488 || (c < 11565
              ? (c < 11264
                ? (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || (c < 8544
                    ? c == 8526
                    : c <= 8584)))
                : (c <= 11492 || (c < 11520
                  ? (c < 11506
                    ? (c >= 11499 && c <= 11502)
                    : c <= 11507)
                  : (c <= 11557 || c == 11559))))
              : (c <= 11565 || (c < 11688
                ? (c < 11648
                  ? (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11712
                  ? (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)
                  : (c <= 11718 || (c >= 11720 && c <= 11726)))))))))
          : (c <= 11734 || (c < 42623
            ? (c < 12593
              ? (c < 12353
                ? (c < 12321
                  ? (c < 12293
                    ? (c >= 11736 && c <= 11742)
                    : c <= 12295)
                  : (c <= 12329 || (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)))
                : (c <= 12438 || (c < 12540
                  ? (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)
                  : (c <= 12543 || (c >= 12549 && c <= 12591)))))
              : (c <= 12686 || (c < 42192
                ? (c < 13312
                  ? (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)
                  : (c <= 19903 || (c >= 19968 && c <= 42124)))
                : (c <= 42237 || (c < 42538
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))))))
            : (c <= 42653 || (c < 43015
              ? (c < 42960
                ? (c < 42786
                  ? (c < 42775
                    ? (c >= 42656 && c <= 42735)
                    : c <= 42783)
                  : (c <= 42888 || (c >= 42891 && c <= 42954)))
                : (c <= 42961 || (c < 42994
                  ? (c < 42965
                    ? c == 42963
                    : c <= 42969)
                  : (c <= 43009 || (c >= 43011 && c <= 43013)))))
              : (c <= 43018 || (c < 43259
                ? (c < 43138
                  ? (c < 43072
                    ? (c >= 43020 && c <= 43042)
                    : c <= 43123)
                  : (c <= 43187 || (c >= 43250 && c <= 43255)))
                : (c <= 43259 || (c < 43312
                  ? (c < 43274
                    ? (c >= 43261 && c <= 43262)
                    : c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))))))))))))))
    : (c <= 43442 || (c < 70493
      ? (c < 66864
        ? (c < 64467
          ? (c < 43793
            ? (c < 43697
              ? (c < 43584
                ? (c < 43494
                  ? (c < 43488
                    ? c == 43471
                    : c <= 43492)
                  : (c <= 43503 || (c < 43520
                    ? (c >= 43514 && c <= 43518)
                    : c <= 43560)))
                : (c <= 43586 || (c < 43642
                  ? (c < 43616
                    ? (c >= 43588 && c <= 43595)
                    : c <= 43638)
                  : (c <= 43642 || (c >= 43646 && c <= 43695)))))
              : (c <= 43697 || (c < 43739
                ? (c < 43712
                  ? (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)
                  : (c <= 43712 || c == 43714))
                : (c <= 43741 || (c < 43777
                  ? (c < 43762
                    ? (c >= 43744 && c <= 43754)
                    : c <= 43764)
                  : (c <= 43782 || (c >= 43785 && c <= 43790)))))))
            : (c <= 43798 || (c < 64256
              ? (c < 44032
                ? (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44002)))
                : (c <= 55203 || (c < 63744
                  ? (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))))
              : (c <= 64262 || (c < 64312
                ? (c < 64287
                  ? (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64285)
                  : (c <= 64296 || (c >= 64298 && c <= 64310)))
                : (c <= 64316 || (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c >= 64326 && c <= 64433)))))))))
          : (c <= 64605 || (c < 65549
            ? (c < 65151
              ? (c < 65139
                ? (c < 64914
                  ? (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)
                  : (c <= 64967 || (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)))
                : (c <= 65139 || (c < 65147
                  ? (c < 65145
                    ? c == 65143
                    : c <= 65145)
                  : (c <= 65147 || c == 65149))))
              : (c <= 65276 || (c < 65474
                ? (c < 65382
                  ? (c < 65345
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65370)
                  : (c <= 65437 || (c >= 65440 && c <= 65470)))
                : (c <= 65479 || (c < 65498
                  ? (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)
                  : (c <= 65500 || (c >= 65536 && c <= 65547)))))))
            : (c <= 65574 || (c < 66349
              ? (c < 65664
                ? (c < 65599
                  ? (c < 65596
                    ? (c >= 65576 && c <= 65594)
                    : c <= 65597)
                  : (c <= 65613 || (c >= 65616 && c <= 65629)))
                : (c <= 65786 || (c < 66208
                  ? (c < 66176
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66204)
                  : (c <= 66256 || (c >= 66304 && c <= 66335)))))
              : (c <= 66378 || (c < 66513
                ? (c < 66464
                  ? (c < 66432
                    ? (c >= 66384 && c <= 66421)
                    : c <= 66461)
                  : (c <= 66499 || (c >= 66504 && c <= 66511)))
                : (c <= 66517 || (c < 66776
                  ? (c < 66736
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66771)
                  : (c <= 66811 || (c >= 66816 && c <= 66855)))))))))))
        : (c <= 66915 || (c < 68736
          ? (c < 67680
            ? (c < 67424
              ? (c < 66979
                ? (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))
                : (c <= 66993 || (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))))
              : (c <= 67431 || (c < 67592
                ? (c < 67506
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : c <= 67504)
                  : (c <= 67514 || (c >= 67584 && c <= 67589)))
                : (c <= 67592 || (c < 67644
                  ? (c < 67639
                    ? (c >= 67594 && c <= 67637)
                    : c <= 67640)
                  : (c <= 67644 || (c >= 67647 && c <= 67669)))))))
            : (c <= 67702 || (c < 68121
              ? (c < 67968
                ? (c < 67828
                  ? (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)
                  : (c <= 67829 || (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)))
                : (c <= 68023 || (c < 68112
                  ? (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68096)
                  : (c <= 68115 || (c >= 68117 && c <= 68119)))))
              : (c <= 68149 || (c < 68352
                ? (c < 68288
                  ? (c < 68224
                    ? (c >= 68192 && c <= 68220)
                    : c <= 68252)
                  : (c <= 68295 || (c >= 68297 && c <= 68324)))
                : (c <= 68405 || (c < 68480
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : c <= 68466)
                  : (c <= 68497 || (c >= 68608 && c <= 68680)))))))))
          : (c <= 68786 || (c < 70019
            ? (c < 69635
              ? (c < 69415
                ? (c < 69248
                  ? (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68899)
                  : (c <= 69289 || (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)))
                : (c <= 69415 || (c < 69552
                  ? (c < 69488
                    ? (c >= 69424 && c <= 69445)
                    : c <= 69505)
                  : (c <= 69572 || (c >= 69600 && c <= 69622)))))
              : (c <= 69687 || (c < 69891
                ? (c < 69763
                  ? (c < 69749
                    ? (c >= 69745 && c <= 69746)
                    : c <= 69749)
                  : (c <= 69807 || (c >= 69840 && c <= 69864)))
                : (c <= 69926 || (c < 69968
                  ? (c < 69959
                    ? c == 69956
                    : c <= 69959)
                  : (c <= 70002 || c == 70006))))))
            : (c <= 70066 || (c < 70303
              ? (c < 70163
                ? (c < 70108
                  ? (c < 70106
                    ? (c >= 70081 && c <= 70084)
                    : c <= 70106)
                  : (c <= 70108 || (c >= 70144 && c <= 70161)))
                : (c <= 70187 || (c < 70282
                  ? (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)
                  : (c <= 70285 || (c >= 70287 && c <= 70301)))))
              : (c <= 70312 || (c < 70442
                ? (c < 70415
                  ? (c < 70405
                    ? (c >= 70320 && c <= 70366)
                    : c <= 70412)
                  : (c <= 70416 || (c >= 70419 && c <= 70440)))
                : (c <= 70448 || (c < 70461
                  ? (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)
                  : (c <= 70461 || c == 70480))))))))))))
      : (c <= 70497 || (c < 119808
        ? (c < 73030
          ? (c < 71960
            ? (c < 71296
              ? (c < 70855
                ? (c < 70751
                  ? (c < 70727
                    ? (c >= 70656 && c <= 70708)
                    : c <= 70730)
                  : (c <= 70753 || (c < 70852
                    ? (c >= 70784 && c <= 70831)
                    : c <= 70853)))
                : (c <= 70855 || (c < 71168
                  ? (c < 71128
                    ? (c >= 71040 && c <= 71086)
                    : c <= 71131)
                  : (c <= 71215 || c == 71236))))
              : (c <= 71338 || (c < 71840
                ? (c < 71488
                  ? (c < 71424
                    ? c == 71352
                    : c <= 71450)
                  : (c <= 71494 || (c >= 71680 && c <= 71723)))
                : (c <= 71903 || (c < 71948
                  ? (c < 71945
                    ? (c >= 71935 && c <= 71942)
                    : c <= 71945)
                  : (c <= 71955 || (c >= 71957 && c <= 71958)))))))
            : (c <= 71983 || (c < 72284
              ? (c < 72163
                ? (c < 72096
                  ? (c < 72001
                    ? c == 71999
                    : c <= 72001)
                  : (c <= 72103 || (c < 72161
                    ? (c >= 72106 && c <= 72144)
                    : c <= 72161)))
                : (c <= 72163 || (c < 72250
                  ? (c < 72203
                    ? c == 72192
                    : c <= 72242)
                  : (c <= 72250 || c == 72272))))
              : (c <= 72329 || (c < 72768
                ? (c < 72704
                  ? (c < 72368
                    ? c == 72349
                    : c <= 72440)
                  : (c <= 72712 || (c >= 72714 && c <= 72750)))
                : (c <= 72768 || (c < 72968
                  ? (c < 72960
                    ? (c >= 72818 && c <= 72847)
                    : c <= 72966)
                  : (c <= 72969 || (c >= 72971 && c <= 73008)))))))))
          : (c <= 73030 || (c < 93760
            ? (c < 77824
              ? (c < 73648
                ? (c < 73066
                  ? (c < 73063
                    ? (c >= 73056 && c <= 73061)
                    : c <= 73064)
                  : (c <= 73097 || (c < 73440
                    ? c == 73112
                    : c <= 73458)))
                : (c <= 73648 || (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c >= 77712 && c <= 77808)))))
              : (c <= 78894 || (c < 92880
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c >= 92784 && c <= 92862)))
                : (c <= 92909 || (c < 93027
                  ? (c < 92992
                    ? (c >= 92928 && c <= 92975)
                    : c <= 92995)
                  : (c <= 93047 || (c >= 93053 && c <= 93071)))))))
            : (c <= 93823 || (c < 110581
              ? (c < 94179
                ? (c < 94099
                  ? (c < 94032
                    ? (c >= 93952 && c <= 94026)
                    : c <= 94032)
                  : (c <= 94111 || (c >= 94176 && c <= 94177)))
                : (c <= 94179 || (c < 101632
                  ? (c < 100352
                    ? (c >= 94208 && c <= 100343)
                    : c <= 101589)
                  : (c <= 101640 || (c >= 110576 && c <= 110579)))))
              : (c <= 110587 || (c < 110960
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c >= 110948 && c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c >= 113808 && c <= 113817)))))))))))
        : (c <= 119892 || (c < 125259
          ? (c < 120540
            ? (c < 120077
              ? (c < 119982
                ? (c < 119970
                  ? (c < 119966
                    ? (c >= 119894 && c <= 119964)
                    : c <= 119967)
                  : (c <= 119970 || (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)))
                : (c <= 119993 || (c < 120005
                  ? (c < 119997
                    ? c == 119995
                    : c <= 120003)
                  : (c <= 120069 || (c >= 120071 && c <= 120074)))))
              : (c <= 120084 || (c < 120134
                ? (c < 120123
                  ? (c < 120094
                    ? (c >= 120086 && c <= 120092)
                    : c <= 120121)
                  : (c <= 120126 || (c >= 120128 && c <= 120132)))
                : (c <= 120134 || (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c >= 120514 && c <= 120538)))))))
            : (c <= 120570 || (c < 123191
              ? (c < 120714
                ? (c < 120630
                  ? (c < 120598
                    ? (c >= 120572 && c <= 120596)
                    : c <= 120628)
                  : (c <= 120654 || (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 43494
    ? (c < 4186
      ? (c < 2703
        ? (c < 1969
          ? (c < 908
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? c == '$'
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 216
                  ? (c < 192
                    ? c == 186
                    : c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))))
              : (c <= 721 || (c < 886
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c >= 880 && c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 902 || (c >= 904 && c <= 906)))))))
            : (c <= 908 || (c < 1646
              ? (c < 1369
                ? (c < 1015
                  ? (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)
                  : (c <= 1153 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))
                : (c <= 1369 || (c < 1519
                  ? (c < 1488
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))))
              : (c <= 1647 || (c < 1786
                ? (c < 1765
                  ? (c < 1749
                    ? (c >= 1649 && c <= 1747)
                    : c <= 1749)
                  : (c <= 1766 || (c >= 1774 && c <= 1775)))
                : (c <= 1788 || (c < 1810
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1808)
                  : (c <= 1839 || (c >= 1869 && c <= 1957)))))))))
          : (c <= 1969 || (c < 2474
            ? (c < 2185
              ? (c < 2084
                ? (c < 2042
                  ? (c < 2036
                    ? (c >= 1994 && c <= 2026)
                    : c <= 2037)
                  : (c <= 2042 || (c < 2074
                    ? (c >= 2048 && c <= 2069)
                    : c <= 2074)))
                : (c <= 2084 || (c < 2144
                  ? (c < 2112
                    ? c == 2088
                    : c <= 2136)
                  : (c <= 2154 || (c >= 2160 && c <= 2183)))))
              : (c <= 2190 || (c < 2392
                ? (c < 2365
                  ? (c < 2308
                    ? (c >= 2208 && c <= 2249)
                    : c <= 2361)
                  : (c <= 2365 || c == 2384))
                : (c <= 2401 || (c < 2447
                  ? (c < 2437
                    ? (c >= 2417 && c <= 2432)
                    : c <= 2444)
                  : (c <= 2448 || (c >= 2451 && c <= 2472)))))))
            : (c <= 2480 || (c < 2575
              ? (c < 2524
                ? (c < 2493
                  ? (c < 2486
                    ? c == 2482
                    : c <= 2489)
                  : (c <= 2493 || c == 2510))
                : (c <= 2525 || (c < 2556
                  ? (c < 2544
                    ? (c >= 2527 && c <= 2529)
                    : c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))))
              : (c <= 2576 || (c < 2616
                ? (c < 2610
                  ? (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)
                  : (c <= 2611 || (c >= 2613 && c <= 2614)))
                : (c <= 2617 || (c < 2674
                  ? (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)
                  : (c <= 2676 || (c >= 2693 && c <= 2701)))))))))))
        : (c <= 2705 || (c < 3218
          ? (c < 2958
            ? (c < 2835
              ? (c < 2768
                ? (c < 2738
                  ? (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)
                  : (c <= 2739 || (c < 2749
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2749)))
                : (c <= 2768 || (c < 2821
                  ? (c < 2809
                    ? (c >= 2784 && c <= 2785)
                    : c <= 2809)
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))))
              : (c <= 2856 || (c < 2908
                ? (c < 2869
                  ? (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)
                  : (c <= 2873 || c == 2877))
                : (c <= 2909 || (c < 2947
                  ? (c < 2929
                    ? (c >= 2911 && c <= 2913)
                    : c <= 2929)
                  : (c <= 2947 || (c >= 2949 && c <= 2954)))))))
            : (c <= 2960 || (c < 3086
              ? (c < 2979
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c >= 2974 && c <= 2975)))
                : (c <= 2980 || (c < 3024
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))))
              : (c <= 3088 || (c < 3165
                ? (c < 3133
                  ? (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)
                  : (c <= 3133 || (c >= 3160 && c <= 3162)))
                : (c <= 3165 || (c < 3205
                  ? (c < 3200
                    ? (c >= 3168 && c <= 3169)
                    : c <= 3200)
                  : (c <= 3212 || (c >= 3214 && c <= 3216)))))))))
          : (c <= 3240 || (c < 3634
            ? (c < 3406
              ? (c < 3313
                ? (c < 3261
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3261 || (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3297)))
                : (c <= 3314 || (c < 3346
                  ? (c < 3342
                    ? (c >= 3332 && c <= 3340)
                    : c <= 3344)
                  : (c <= 3386 || c == 3389))))
              : (c <= 3406 || (c < 3482
                ? (c < 3450
                  ? (c < 3423
                    ? (c >= 3412 && c <= 3414)
                    : c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3520
                  ? (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)
                  : (c <= 3526 || (c >= 3585 && c <= 3632)))))))
            : (c <= 3634 || (c < 3776
              ? (c < 3724
                ? (c < 3716
                  ? (c < 3713
                    ? (c >= 3648 && c <= 3654)
                    : c <= 3714)
                  : (c <= 3716 || (c >= 3718 && c <= 3722)))
                : (c <= 3747 || (c < 3762
                  ? (c < 3751
                    ? c == 3749
                    : c <= 3760)
                  : (c <= 3762 || c == 3773))))
              : (c <= 3780 || (c < 3913
                ? (c < 3840
                  ? (c < 3804
                    ? c == 3782
                    : c <= 3807)
                  : (c <= 3840 || (c >= 3904 && c <= 3911)))
                : (c <= 3948 || (c < 4159
                  ? (c < 4096
                    ? (c >= 3976 && c <= 3980)
                    : c <= 4138)
                  : (c <= 4159 || (c >= 4176 && c <= 4181)))))))))))))
      : (c <= 4189 || (c < 8130
        ? (c < 6108
          ? (c < 4802
            ? (c < 4682
              ? (c < 4256
                ? (c < 4206
                  ? (c < 4197
                    ? c == 4193
                    : c <= 4198)
                  : (c <= 4208 || (c < 4238
                    ? (c >= 4213 && c <= 4225)
                    : c <= 4238)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c >= 4348 && c <= 4680)))))
              : (c <= 4685 || (c < 4746
                ? (c < 4698
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : c <= 4696)
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4792
                  ? (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)
                  : (c <= 4798 || c == 4800))))))
            : (c <= 4805 || (c < 5761
              ? (c < 4992
                ? (c < 4882
                  ? (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)
                  : (c <= 4885 || (c >= 4888 && c <= 4954)))
                : (c <= 5007 || (c < 5121
                  ? (c < 5112
                    ? (c >= 5024 && c <= 5109)
                    : c <= 5117)
                  : (c <= 5740 || (c >= 5743 && c <= 5759)))))
              : (c <= 5786 || (c < 5952
                ? (c < 5888
                  ? (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 6016
                  ? (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)
                  : (c <= 6067 || c == 6103))))))))
          : (c <= 6108 || (c < 7296
            ? (c < 6688
              ? (c < 6480
                ? (c < 6314
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6312)
                  : (c <= 6314 || (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c >= 6656 && c <= 6678)))))
              : (c <= 6740 || (c < 7086
                ? (c < 6981
                  ? (c < 6917
                    ? c == 6823
                    : c <= 6963)
                  : (c <= 6988 || (c >= 7043 && c <= 7072)))
                : (c <= 7087 || (c < 7245
                  ? (c < 7168
                    ? (c >= 7098 && c <= 7141)
                    : c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))))))
            : (c <= 7304 || (c < 7968
              ? (c < 7413
                ? (c < 7401
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)
                  : (c <= 7404 || (c >= 7406 && c <= 7411)))
                : (c <= 7414 || (c < 7680
                  ? (c < 7424
                    ? c == 7418
                    : c <= 7615)
                  : (c <= 7957 || (c >= 7960 && c <= 7965)))))
              : (c <= 8005 || (c < 8029
                ? (c < 8025
                  ? (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)
                  : (c <= 8025 || c == 8027))
                : (c <= 8029 || (c < 8118
                  ? (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)
                  : (c <= 8124 || c == 8126))))))))))
        : (c <= 8132 || (c < 12321
          ? (c < 8526
            ? (c < 8455
              ? (c < 8182
                ? (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)))
                : (c <= 8188 || (c < 8336
                  ? (c < 8319
                    ? c == 8305
                    : c <= 8319)
                  : (c <= 8348 || c == 8450))))
              : (c <= 8455 || (c < 8486
                ? (c < 8472
                  ? (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)
                  : (c <= 8477 || c == 8484))
                : (c <= 8486 || (c < 8508
                  ? (c < 8490
                    ? c == 8488
                    : c <= 8505)
                  : (c <= 8511 || (c >= 8517 && c <= 8521)))))))
            : (c <= 8526 || (c < 11648
              ? (c < 11520
                ? (c < 11499
                  ? (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11568
                  ? (c < 11565
                    ? c == 11559
                    : c <= 11565)
                  : (c <= 11623 || c == 11631))))
              : (c <= 11670 || (c < 11712
                ? (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c >= 11704 && c <= 11710)))
                : (c <= 11718 || (c < 11736
                  ? (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)
                  : (c <= 11742 || (c >= 12293 && c <= 12295)))))))))
          : (c <= 12329 || (c < 42786
            ? (c < 13312
              ? (c < 12540
                ? (c < 12353
                  ? (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)
                  : (c <= 12438 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))
                : (c <= 12543 || (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c >= 12784 && c <= 12799)))))
              : (c <= 19903 || (c < 42538
                ? (c < 42240
                  ? (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)
                  : (c <= 42508 || (c >= 42512 && c <= 42527)))
                : (c <= 42539 || (c < 42656
                  ? (c < 42623
                    ? (c >= 42560 && c <= 42606)
                    : c <= 42653)
                  : (c <= 42735 || (c >= 42775 && c <= 42783)))))))
            : (c <= 42888 || (c < 43138
              ? (c < 42994
                ? (c < 42963
                  ? (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)
                  : (c <= 42963 || (c >= 42965 && c <= 42969)))
                : (c <= 43009 || (c < 43020
                  ? (c < 43015
                    ? (c >= 43011 && c <= 43013)
                    : c <= 43018)
                  : (c <= 43042 || (c >= 43072 && c <= 43123)))))
              : (c <= 43187 || (c < 43312
                ? (c < 43261
                  ? (c < 43259
                    ? (c >= 43250 && c <= 43255)
                    : c <= 43259)
                  : (c <= 43262 || (c >= 43274 && c <= 43301)))
                : (c <= 43334 || (c < 43471
                  ? (c < 43396
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43442)
                  : (c <= 43471 || (c >= 43488 && c <= 43492)))))))))))))))
    : (c <= 43503 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43824
            ? (c < 43712
              ? (c < 43642
                ? (c < 43584
                  ? (c < 43520
                    ? (c >= 43514 && c <= 43518)
                    : c <= 43560)
                  : (c <= 43586 || (c < 43616
                    ? (c >= 43588 && c <= 43595)
                    : c <= 43638)))
                : (c <= 43642 || (c < 43701
                  ? (c < 43697
                    ? (c >= 43646 && c <= 43695)
                    : c <= 43697)
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))))
              : (c <= 43712 || (c < 43777
                ? (c < 43744
                  ? (c < 43739
                    ? c == 43714
                    : c <= 43741)
                  : (c <= 43754 || (c >= 43762 && c <= 43764)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c >= 43816 && c <= 43822)))))))
            : (c <= 43866 || (c < 64287
              ? (c < 63744
                ? (c < 44032
                  ? (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44002)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_4(int32_t c) {
  return (c < 43488
    ? (c < 4159
      ? (c < 2654
        ? (c < 1808
          ? (c < 895
            ? (c < 192
              ? (c < 'a'
                ? (c < 'M'
                  ? (c < 'A'
                    ? c == '$'
                    : c <= 'K')
                  : (c <= 'T' || (c < '_'
                    ? (c >= 'V' && c <= 'Z')
                    : c <= '_')))
                : (c <= 't' || (c < 181
                  ? (c < 170
                    ? (c >= 'v' && c <= 'z')
                    : c <= 170)
                  : (c <= 181 || c == 186))))
              : (c <= 214 || (c < 748
                ? (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))
                : (c <= 748 || (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))))))
            : (c <= 895 || (c < 1488
              ? (c < 1015
                ? (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))
                : (c <= 1153 || (c < 1369
                  ? (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)
                  : (c <= 1369 || (c >= 1376 && c <= 1416)))))
              : (c <= 1514 || (c < 1749
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1610)
                  : (c <= 1647 || (c >= 1649 && c <= 1747)))
                : (c <= 1749 || (c < 1786
                  ? (c < 1774
                    ? (c >= 1765 && c <= 1766)
                    : c <= 1775)
                  : (c <= 1788 || c == 1791))))))))
          : (c <= 1808 || (c < 2437
            ? (c < 2112
              ? (c < 2042
                ? (c < 1969
                  ? (c < 1869
                    ? (c >= 1810 && c <= 1839)
                    : c <= 1957)
                  : (c <= 1969 || (c < 2036
                    ? (c >= 1994 && c <= 2026)
                    : c <= 2037)))
                : (c <= 2042 || (c < 2084
                  ? (c < 2074
                    ? (c >= 2048 && c <= 2069)
                    : c <= 2074)
                  : (c <= 2084 || c == 2088))))
              : (c <= 2136 || (c < 2308
                ? (c < 2185
                  ? (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)
                  : (c <= 2190 || (c >= 2208 && c <= 2249)))
                : (c <= 2361 || (c < 2392
                  ? (c < 2384
                    ? c == 2365
                    : c <= 2384)
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))))))
            : (c <= 2444 || (c < 2544
              ? (c < 2486
                ? (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || c == 2482))
                : (c <= 2489 || (c < 2524
                  ? (c < 2510
                    ? c == 2493
                    : c <= 2510)
                  : (c <= 2525 || (c >= 2527 && c <= 2529)))))
              : (c <= 2545 || (c < 2602
                ? (c < 2575
                  ? (c < 2565
                    ? c == 2556
                    : c <= 2570)
                  : (c <= 2576 || (c >= 2579 && c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c >= 2649 && c <= 2652)))))))))))
        : (c <= 2654 || (c < 3205
          ? (c < 2929
            ? (c < 2809
              ? (c < 2738
                ? (c < 2703
                  ? (c < 2693
                    ? (c >= 2674 && c <= 2676)
                    : c <= 2701)
                  : (c <= 2705 || (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)))
                : (c <= 2739 || (c < 2768
                  ? (c < 2749
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2749)
                  : (c <= 2768 || (c >= 2784 && c <= 2785)))))
              : (c <= 2809 || (c < 2866
                ? (c < 2835
                  ? (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)
                  : (c <= 2856 || (c >= 2858 && c <= 2864)))
                : (c <= 2867 || (c < 2908
                  ? (c < 2877
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2877)
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))))))
            : (c <= 2929 || (c < 3024
              ? (c < 2972
                ? (c < 2958
                  ? (c < 2949
                    ? c == 2947
                    : c <= 2954)
                  : (c <= 2960 || (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)))
                : (c <= 2972 || (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c >= 2990 && c <= 3001)))))
              : (c <= 3024 || (c < 3133
                ? (c < 3090
                  ? (c < 3086
                    ? (c >= 3077 && c <= 3084)
                    : c <= 3088)
                  : (c <= 3112 || (c >= 3114 && c <= 3129)))
                : (c <= 3133 || (c < 3168
                  ? (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)
                  : (c <= 3169 || c == 3200))))))))
          : (c <= 3212 || (c < 3520
            ? (c < 3346
              ? (c < 3293
                ? (c < 3242
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)
                  : (c <= 3251 || (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)))
                : (c <= 3294 || (c < 3332
                  ? (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)
                  : (c <= 3340 || (c >= 3342 && c <= 3344)))))
              : (c <= 3386 || (c < 3450
                ? (c < 3412
                  ? (c < 3406
                    ? c == 3389
                    : c <= 3406)
                  : (c <= 3414 || (c >= 3423 && c <= 3425)))
                : (c <= 3455 || (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || c == 3517))))))
            : (c <= 3526 || (c < 3762
              ? (c < 3716
                ? (c < 3648
                  ? (c < 3634
                    ? (c >= 3585 && c <= 3632)
                    : c <= 3634)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c >= 3751 && c <= 3760)))))
              : (c <= 3762 || (c < 3840
                ? (c < 3782
                  ? (c < 3776
                    ? c == 3773
                    : c <= 3780)
                  : (c <= 3782 || (c >= 3804 && c <= 3807)))
                : (c <= 3840 || (c < 3976
                  ? (c < 3913
                    ? (c >= 3904 && c <= 3911)
                    : c <= 3948)
                  : (c <= 3980 || (c >= 4096 && c <= 4138)))))))))))))
      : (c <= 4159 || (c < 8126
        ? (c < 6103
          ? (c < 4792
            ? (c < 4304
              ? (c < 4213
                ? (c < 4193
                  ? (c < 4186
                    ? (c >= 4176 && c <= 4181)
                    : c <= 4189)
                  : (c <= 4193 || (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)))
                : (c <= 4225 || (c < 4295
                  ? (c < 4256
                    ? c == 4238
                    : c <= 4293)
                  : (c <= 4295 || c == 4301))))
              : (c <= 4346 || (c < 4698
                ? (c < 4688
                  ? (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)
                  : (c <= 4694 || c == 4696))
                : (c <= 4701 || (c < 4752
                  ? (c < 4746
                    ? (c >= 4704 && c <= 4744)
                    : c <= 4749)
                  : (c <= 4784 || (c >= 4786 && c <= 4789)))))))
            : (c <= 4798 || (c < 5743
              ? (c < 4888
                ? (c < 4808
                  ? (c < 4802
                    ? c == 4800
                    : c <= 4805)
                  : (c <= 4822 || (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)))
                : (c <= 4954 || (c < 5112
                  ? (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)
                  : (c <= 5117 || (c >= 5121 && c <= 5740)))))
              : (c <= 5759 || (c < 5919
                ? (c < 5870
                  ? (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)
                  : (c <= 5880 || (c >= 5888 && c <= 5905)))
                : (c <= 5937 || (c < 5998
                  ? (c < 5984
                    ? (c >= 5952 && c <= 5969)
                    : c <= 5996)
                  : (c <= 6000 || (c >= 6016 && c <= 6067)))))))))
          : (c <= 6103 || (c < 7258
            ? (c < 6656
              ? (c < 6400
                ? (c < 6272
                  ? (c < 6176
                    ? c == 6108
                    : c <= 6264)
                  : (c <= 6312 || (c < 6320
                    ? c == 6314
                    : c <= 6389)))
                : (c <= 6430 || (c < 6528
                  ? (c < 6512
                    ? (c >= 6480 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c >= 6576 && c <= 6601)))))
              : (c <= 6678 || (c < 7043
                ? (c < 6917
                  ? (c < 6823
                    ? (c >= 6688 && c <= 6740)
                    : c <= 6823)
                  : (c <= 6963 || (c >= 6981 && c <= 6988)))
                : (c <= 7072 || (c < 7168
                  ? (c < 7098
                    ? (c >= 7086 && c <= 7087)
                    : c <= 7141)
                  : (c <= 7203 || (c >= 7245 && c <= 7247)))))))
            : (c <= 7293 || (c < 7960
              ? (c < 7406
                ? (c < 7357
                  ? (c < 7312
                    ? (c >= 7296 && c <= 7304)
                    : c <= 7354)
                  : (c <= 7359 || (c >= 7401 && c <= 7404)))
                : (c <= 7411 || (c < 7424
                  ? (c < 7418
                    ? (c >= 7413 && c <= 7414)
                    : c <= 7418)
                  : (c <= 7615 || (c >= 7680 && c <= 7957)))))
              : (c <= 7965 || (c < 8027
                ? (c < 8016
                  ? (c < 8008
                    ? (c >= 7968 && c <= 8005)
                    : c <= 8013)
                  : (c <= 8023 || c == 8025))
                : (c <= 8027 || (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c >= 8118 && c <= 8124)))))))))))
        : (c <= 8126 || (c < 12293
          ? (c < 8517
            ? (c < 8450
              ? (c < 8178
                ? (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))
                : (c <= 8180 || (c < 8319
                  ? (c < 8305
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8305)
                  : (c <= 8319 || (c >= 8336 && c <= 8348)))))
              : (c <= 8450 || (c < 8484
                ? (c < 8469
                  ? (c < 8458
                    ? c == 8455
                    : c <= 8467)
                  : (c <= 8469 || (c >= 8472 && c <= 8477)))
                : (c <= 8484 || (c < 8490
                  ? (c < 8488
                    ? c == 8486
                    : c <= 8488)
                  : (c <= 8505 || (c >= 8508 && c <= 8511)))))))
            : (c <= 8521 || (c < 11631
              ? (c < 11506
                ? (c < 11264
                  ? (c < 8544
                    ? c == 8526
                    : c <= 8584)
                  : (c <= 11492 || (c >= 11499 && c <= 11502)))
                : (c <= 11507 || (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c >= 11568 && c <= 11623)))))
              : (c <= 11631 || (c < 11704
                ? (c < 11688
                  ? (c < 11680
                    ? (c >= 11648 && c <= 11670)
                    : c <= 11686)
                  : (c <= 11694 || (c >= 11696 && c <= 11702)))
                : (c <= 11710 || (c < 11728
                  ? (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))))))))
          : (c <= 12295 || (c < 42775
            ? (c < 12784
              ? (c < 12449
                ? (c < 12344
                  ? (c < 12337
                    ? (c >= 12321 && c <= 12329)
                    : c <= 12341)
                  : (c <= 12348 || (c < 12445
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12447)))
                : (c <= 12538 || (c < 12593
                  ? (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)
                  : (c <= 12686 || (c >= 12704 && c <= 12735)))))
              : (c <= 12799 || (c < 42512
                ? (c < 42192
                  ? (c < 19968
                    ? (c >= 13312 && c <= 19903)
                    : c <= 42124)
                  : (c <= 42237 || (c >= 42240 && c <= 42508)))
                : (c <= 42527 || (c < 42623
                  ? (c < 42560
                    ? (c >= 42538 && c <= 42539)
                    : c <= 42606)
                  : (c <= 42653 || (c >= 42656 && c <= 42735)))))))
            : (c <= 42783 || (c < 43072
              ? (c < 42965
                ? (c < 42960
                  ? (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42954)
                  : (c <= 42961 || c == 42963))
                : (c <= 42969 || (c < 43015
                  ? (c < 43011
                    ? (c >= 42994 && c <= 43009)
                    : c <= 43013)
                  : (c <= 43018 || (c >= 43020 && c <= 43042)))))
              : (c <= 43123 || (c < 43274
                ? (c < 43259
                  ? (c < 43250
                    ? (c >= 43138 && c <= 43187)
                    : c <= 43255)
                  : (c <= 43259 || (c >= 43261 && c <= 43262)))
                : (c <= 43301 || (c < 43396
                  ? (c < 43360
                    ? (c >= 43312 && c <= 43334)
                    : c <= 43388)
                  : (c <= 43442 || c == 43471))))))))))))))
    : (c <= 43492 || (c < 70656
      ? (c < 66940
        ? (c < 64848
          ? (c < 43816
            ? (c < 43705
              ? (c < 43616
                ? (c < 43520
                  ? (c < 43514
                    ? (c >= 43494 && c <= 43503)
                    : c <= 43518)
                  : (c <= 43560 || (c < 43588
                    ? (c >= 43584 && c <= 43586)
                    : c <= 43595)))
                : (c <= 43638 || (c < 43697
                  ? (c < 43646
                    ? c == 43642
                    : c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))))
              : (c <= 43709 || (c < 43762
                ? (c < 43739
                  ? (c < 43714
                    ? c == 43712
                    : c <= 43714)
                  : (c <= 43741 || (c >= 43744 && c <= 43754)))
                : (c <= 43764 || (c < 43793
                  ? (c < 43785
                    ? (c >= 43777 && c <= 43782)
                    : c <= 43790)
                  : (c <= 43798 || (c >= 43808 && c <= 43814)))))))
            : (c <= 43822 || (c < 64285
              ? (c < 55243
                ? (c < 43888
                  ? (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)
                  : (c <= 44002 || (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)))
                : (c <= 55291 || (c < 64256
                  ? (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)
                  : (c <= 64262 || (c >= 64275 && c <= 64279)))))
              : (c <= 64285 || (c < 64320
                ? (c < 64312
                  ? (c < 64298
                    ? (c >= 64287 && c <= 64296)
                    : c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64467
                  ? (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)
                  : (c <= 64605 || (c >= 64612 && c <= 64829)))))))))
          : (c <= 64911 || (c < 65596
            ? (c < 65345
              ? (c < 65145
                ? (c < 65137
                  ? (c < 65008
                    ? (c >= 64914 && c <= 64967)
                    : c <= 65017)
                  : (c <= 65137 || (c < 65143
                    ? c == 65139
                    : c <= 65143)))
                : (c <= 65145 || (c < 65151
                  ? (c < 65149
                    ? c == 65147
                    : c <= 65149)
                  : (c <= 65276 || (c >= 65313 && c <= 65338)))))
              : (c <= 65370 || (c < 65490
                ? (c < 65474
                  ? (c < 65440
                    ? (c >= 65382 && c <= 65437)
                    : c <= 65470)
                  : (c <= 65479 || (c >= 65482 && c <= 65487)))
                : (c <= 65495 || (c < 65549
                  ? (c < 65536
                    ? (c >= 65498 && c <= 65500)
                    : c <= 65547)
                  : (c <= 65574 || (c >= 65576 && c <= 65594)))))))
            : (c <= 65597 || (c < 66432
              ? (c < 66176
                ? (c < 65664
                  ? (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)
                  : (c <= 65786 || (c >= 65856 && c <= 65908)))
                : (c <= 66204 || (c < 66349
                  ? (c < 66304
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66335)
                  : (c <= 66378 || (c >= 66384 && c <= 66421)))))
              : (c <= 66461 || (c < 66736
                ? (c < 66513
                  ? (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)
                  : (c <= 66517 || (c >= 66560 && c <= 66717)))
                : (c <= 66771 || (c < 66864
                  ? (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)
                  : (c <= 66915 || (c >= 66928 && c <= 66938)))))))))))
        : (c <= 66954 || (c < 68800
          ? (c < 67808
            ? (c < 67463
              ? (c < 67003
                ? (c < 66967
                  ? (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)
                  : (c <= 66977 || (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)))
                : (c <= 67004 || (c < 67424
                  ? (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)
                  : (c <= 67431 || (c >= 67456 && c <= 67461)))))
              : (c <= 67504 || (c < 67639
                ? (c < 67592
                  ? (c < 67584
                    ? (c >= 67506 && c <= 67514)
                    : c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c >= 67712 && c <= 67742)))))))
            : (c <= 67826 || (c < 68192
              ? (c < 68030
                ? (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c >= 67968 && c <= 68023)))
                : (c <= 68031 || (c < 68117
                  ? (c < 68112
                    ? c == 68096
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))))
              : (c <= 68220 || (c < 68416
                ? (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68324 || (c >= 68352 && c <= 68405)))
                : (c <= 68437 || (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c >= 68736 && c <= 68786)))))))))
          : (c <= 68850 || (c < 70081
            ? (c < 69745
              ? (c < 69424
                ? (c < 69296
                  ? (c < 69248
                    ? (c >= 68864 && c <= 68899)
                    : c <= 69289)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))
                : (c <= 69445 || (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69505)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69635 && c <= 69687)))))
              : (c <= 69746 || (c < 69956
                ? (c < 69840
                  ? (c < 69763
                    ? c == 69749
                    : c <= 69807)
                  : (c <= 69864 || (c >= 69891 && c <= 69926)))
                : (c <= 69956 || (c < 70006
                  ? (c < 69968
                    ? c == 69959
                    : c <= 70002)
                  : (c <= 70006 || (c >= 70019 && c <= 70066)))))))
            : (c <= 70084 || (c < 70320
              ? (c < 70272
                ? (c < 70144
                  ? (c < 70108
                    ? c == 70106
                    : c <= 70108)
                  : (c <= 70161 || (c >= 70163 && c <= 70187)))
                : (c <= 70278 || (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c >= 70303 && c <= 70312)))))
              : (c <= 70366 || (c < 70450
                ? (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c >= 70442 && c <= 70448)))
                : (c <= 70451 || (c < 70480
                  ? (c < 70461
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70461)
                  : (c <= 70480 || (c >= 70493 && c <= 70497)))))))))))))
      : (c <= 70708 || (c < 119894
        ? (c < 73056
          ? (c < 71999
            ? (c < 71352
              ? (c < 71040
                ? (c < 70784
                  ? (c < 70751
                    ? (c >= 70727 && c <= 70730)
                    : c <= 70753)
                  : (c <= 70831 || (c < 70855
                    ? (c >= 70852 && c <= 70853)
                    : c <= 70855)))
                : (c <= 71086 || (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71131)
                    : c <= 71215)
                  : (c <= 71236 || (c >= 71296 && c <= 71338)))))
              : (c <= 71352 || (c < 71935
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71494)
                  : (c <= 71723 || (c >= 71840 && c <= 71903)))
                : (c <= 71942 || (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c >= 71960 && c <= 71983)))))))
            : (c <= 71999 || (c < 72349
              ? (c < 72192
                ? (c < 72106
                  ? (c < 72096
                    ? c == 72001
                    : c <= 72103)
                  : (c <= 72144 || (c < 72163
                    ? c == 72161
                    : c <= 72163)))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_5(int32_t c) {
  return (c < 43520
    ? (c < 4197
      ? (c < 2730
        ? (c < 2036
          ? (c < 1015
            ? (c < 750
              ? (c < 216
                ? (c < 181
                  ? (c < 170
                    ? c == '$'
                    : c <= 170)
                  : (c <= 181 || (c < 192
                    ? c == 186
                    : c <= 214)))
                : (c <= 246 || (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || c == 748))))
              : (c <= 750 || (c < 902
                ? (c < 891
                  ? (c < 886
                    ? (c >= 880 && c <= 884)
                    : c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 910
                  ? (c < 908
                    ? (c >= 904 && c <= 906)
                    : c <= 908)
                  : (c <= 929 || (c >= 931 && c <= 1013)))))))
            : (c <= 1153 || (c < 1749
              ? (c < 1488
                ? (c < 1369
                  ? (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)
                  : (c <= 1369 || (c >= 1376 && c <= 1416)))
                : (c <= 1514 || (c < 1646
                  ? (c < 1568
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1610)
                  : (c <= 1647 || (c >= 1649 && c <= 1747)))))
              : (c <= 1749 || (c < 1808
                ? (c < 1786
                  ? (c < 1774
                    ? (c >= 1765 && c <= 1766)
                    : c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1969
                  ? (c < 1869
                    ? (c >= 1810 && c <= 1839)
                    : c <= 1957)
                  : (c <= 1969 || (c >= 1994 && c <= 2026)))))))))
          : (c <= 2037 || (c < 2486
            ? (c < 2308
              ? (c < 2112
                ? (c < 2074
                  ? (c < 2048
                    ? c == 2042
                    : c <= 2069)
                  : (c <= 2074 || (c < 2088
                    ? c == 2084
                    : c <= 2088)))
                : (c <= 2136 || (c < 2185
                  ? (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)
                  : (c <= 2190 || (c >= 2208 && c <= 2249)))))
              : (c <= 2361 || (c < 2437
                ? (c < 2392
                  ? (c < 2384
                    ? c == 2365
                    : c <= 2384)
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || c == 2482))))))
            : (c <= 2489 || (c < 2602
              ? (c < 2544
                ? (c < 2524
                  ? (c < 2510
                    ? c == 2493
                    : c <= 2510)
                  : (c <= 2525 || (c >= 2527 && c <= 2529)))
                : (c <= 2545 || (c < 2575
                  ? (c < 2565
                    ? c == 2556
                    : c <= 2570)
                  : (c <= 2576 || (c >= 2579 && c <= 2600)))))
              : (c <= 2608 || (c < 2654
                ? (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c >= 2649 && c <= 2652)))
                : (c <= 2654 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2674 && c <= 2676)
                    : c <= 2701)
                  : (c <= 2705 || (c >= 2707 && c <= 2728)))))))))))
        : (c <= 2736 || (c < 3253
          ? (c < 2969
            ? (c < 2866
              ? (c < 2809
                ? (c < 2749
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2749 || (c < 2784
                    ? c == 2768
                    : c <= 2785)))
                : (c <= 2809 || (c < 2835
                  ? (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)
                  : (c <= 2856 || (c >= 2858 && c <= 2864)))))
              : (c <= 2867 || (c < 2929
                ? (c < 2908
                  ? (c < 2877
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2877)
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))
                : (c <= 2929 || (c < 2958
                  ? (c < 2949
                    ? c == 2947
                    : c <= 2954)
                  : (c <= 2960 || (c >= 2962 && c <= 2965)))))))
            : (c <= 2970 || (c < 3114
              ? (c < 2990
                ? (c < 2979
                  ? (c < 2974
                    ? c == 2972
                    : c <= 2975)
                  : (c <= 2980 || (c >= 2984 && c <= 2986)))
                : (c <= 3001 || (c < 3086
                  ? (c < 3077
                    ? c == 3024
                    : c <= 3084)
                  : (c <= 3088 || (c >= 3090 && c <= 3112)))))
              : (c <= 3129 || (c < 3200
                ? (c < 3165
                  ? (c < 3160
                    ? c == 3133
                    : c <= 3162)
                  : (c <= 3165 || (c >= 3168 && c <= 3169)))
                : (c <= 3200 || (c < 3218
                  ? (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)
                  : (c <= 3240 || (c >= 3242 && c <= 3251)))))))))
          : (c <= 3257 || (c < 3713
            ? (c < 3423
              ? (c < 3342
                ? (c < 3296
                  ? (c < 3293
                    ? c == 3261
                    : c <= 3294)
                  : (c <= 3297 || (c < 3332
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3406
                  ? (c < 3389
                    ? (c >= 3346 && c <= 3386)
                    : c <= 3389)
                  : (c <= 3406 || (c >= 3412 && c <= 3414)))))
              : (c <= 3425 || (c < 3517
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3478)
                  : (c <= 3505 || (c >= 3507 && c <= 3515)))
                : (c <= 3517 || (c < 3634
                  ? (c < 3585
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3632)
                  : (c <= 3634 || (c >= 3648 && c <= 3654)))))))
            : (c <= 3714 || (c < 3804
              ? (c < 3751
                ? (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || c == 3749))
                : (c <= 3760 || (c < 3776
                  ? (c < 3773
                    ? c == 3762
                    : c <= 3773)
                  : (c <= 3780 || c == 3782))))
              : (c <= 3807 || (c < 4096
                ? (c < 3913
                  ? (c < 3904
                    ? c == 3840
                    : c <= 3911)
                  : (c <= 3948 || (c >= 3976 && c <= 3980)))
                : (c <= 4138 || (c < 4186
                  ? (c < 4176
                    ? c == 4159
                    : c <= 4181)
                  : (c <= 4189 || c == 4193))))))))))))
      : (c <= 4198 || (c < 8144
        ? (c < 6272
          ? (c < 4824
            ? (c < 4696
              ? (c < 4301
                ? (c < 4238
                  ? (c < 4213
                    ? (c >= 4206 && c <= 4208)
                    : c <= 4225)
                  : (c <= 4238 || (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)))
                : (c <= 4301 || (c < 4682
                  ? (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)
                  : (c <= 4685 || (c >= 4688 && c <= 4694)))))
              : (c <= 4696 || (c < 4786
                ? (c < 4746
                  ? (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)
                  : (c <= 4749 || (c >= 4752 && c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c >= 4808 && c <= 4822)))))))
            : (c <= 4880 || (c < 5870
              ? (c < 5112
                ? (c < 4992
                  ? (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)
                  : (c <= 5007 || (c >= 5024 && c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c >= 5792 && c <= 5866)))))
              : (c <= 5880 || (c < 5998
                ? (c < 5952
                  ? (c < 5919
                    ? (c >= 5888 && c <= 5905)
                    : c <= 5937)
                  : (c <= 5969 || (c >= 5984 && c <= 5996)))
                : (c <= 6000 || (c < 6108
                  ? (c < 6103
                    ? (c >= 6016 && c <= 6067)
                    : c <= 6103)
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))))))))
          : (c <= 6312 || (c < 7357
            ? (c < 6917
              ? (c < 6528
                ? (c < 6400
                  ? (c < 6320
                    ? c == 6314
                    : c <= 6389)
                  : (c <= 6430 || (c < 6512
                    ? (c >= 6480 && c <= 6509)
                    : c <= 6516)))
                : (c <= 6571 || (c < 6688
                  ? (c < 6656
                    ? (c >= 6576 && c <= 6601)
                    : c <= 6678)
                  : (c <= 6740 || c == 6823))))
              : (c <= 6963 || (c < 7168
                ? (c < 7086
                  ? (c < 7043
                    ? (c >= 6981 && c <= 6988)
                    : c <= 7072)
                  : (c <= 7087 || (c >= 7098 && c <= 7141)))
                : (c <= 7203 || (c < 7296
                  ? (c < 7258
                    ? (c >= 7245 && c <= 7247)
                    : c <= 7293)
                  : (c <= 7304 || (c >= 7312 && c <= 7354)))))))
            : (c <= 7359 || (c < 8016
              ? (c < 7424
                ? (c < 7413
                  ? (c < 7406
                    ? (c >= 7401 && c <= 7404)
                    : c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7680 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c >= 8008 && c <= 8013)))))
              : (c <= 8023 || (c < 8064
                ? (c < 8029
                  ? (c < 8027
                    ? c == 8025
                    : c <= 8027)
                  : (c <= 8029 || (c >= 8031 && c <= 8061)))
                : (c <= 8116 || (c < 8130
                  ? (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)
                  : (c <= 8132 || (c >= 8134 && c <= 8140)))))))))))
        : (c <= 8147 || (c < 12344
          ? (c < 11264
            ? (c < 8469
              ? (c < 8319
                ? (c < 8178
                  ? (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)
                  : (c <= 8180 || (c < 8305
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8305)))
                : (c <= 8319 || (c < 8455
                  ? (c < 8450
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8450)
                  : (c <= 8455 || (c >= 8458 && c <= 8467)))))
              : (c <= 8469 || (c < 8490
                ? (c < 8486
                  ? (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)
                  : (c <= 8486 || c == 8488))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c >= 8544 && c <= 8584)))))))
            : (c <= 11492 || (c < 11688
              ? (c < 11565
                ? (c < 11520
                  ? (c < 11506
                    ? (c >= 11499 && c <= 11502)
                    : c <= 11507)
                  : (c <= 11557 || c == 11559))
                : (c <= 11565 || (c < 11648
                  ? (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))))
              : (c <= 11694 || (c < 11728
                ? (c < 11712
                  ? (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)
                  : (c <= 11718 || (c >= 11720 && c <= 11726)))
                : (c <= 11734 || (c < 12321
                  ? (c < 12293
                    ? (c >= 11736 && c <= 11742)
                    : c <= 12295)
                  : (c <= 12329 || (c >= 12337 && c <= 12341)))))))))
          : (c <= 12348 || (c < 42960
            ? (c < 42192
              ? (c < 12593
                ? (c < 12449
                  ? (c < 12445
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12447)
                  : (c <= 12538 || (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)))
                : (c <= 12686 || (c < 13312
                  ? (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)
                  : (c <= 19903 || (c >= 19968 && c <= 42124)))))
              : (c <= 42237 || (c < 42623
                ? (c < 42538
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))
                : (c <= 42653 || (c < 42786
                  ? (c < 42775
                    ? (c >= 42656 && c <= 42735)
                    : c <= 42783)
                  : (c <= 42888 || (c >= 42891 && c <= 42954)))))))
            : (c <= 42961 || (c < 43259
              ? (c < 43015
                ? (c < 42994
                  ? (c < 42965
                    ? c == 42963
                    : c <= 42969)
                  : (c <= 43009 || (c >= 43011 && c <= 43013)))
                : (c <= 43018 || (c < 43138
                  ? (c < 43072
                    ? (c >= 43020 && c <= 43042)
                    : c <= 43123)
                  : (c <= 43187 || (c >= 43250 && c <= 43255)))))
              : (c <= 43259 || (c < 43396
                ? (c < 43312
                  ? (c < 43274
                    ? (c >= 43261 && c <= 43262)
                    : c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))
                : (c <= 43442 || (c < 43494
                  ? (c < 43488
                    ? c == 43471
                    : c <= 43492)
                  : (c <= 43503 || (c >= 43514 && c <= 43518)))))))))))))))
    : (c <= 43560 || (c < 70751
      ? (c < 66964
        ? (c < 65008
          ? (c < 43888
            ? (c < 43739
              ? (c < 43697
                ? (c < 43616
                  ? (c < 43588
                    ? (c >= 43584 && c <= 43586)
                    : c <= 43595)
                  : (c <= 43638 || (c < 43646
                    ? c == 43642
                    : c <= 43695)))
                : (c <= 43697 || (c < 43712
                  ? (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)
                  : (c <= 43712 || c == 43714))))
              : (c <= 43741 || (c < 43793
                ? (c < 43777
                  ? (c < 43762
                    ? (c >= 43744 && c <= 43754)
                    : c <= 43764)
                  : (c <= 43782 || (c >= 43785 && c <= 43790)))
                : (c <= 43798 || (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))))))
            : (c <= 44002 || (c < 64298
              ? (c < 64112
                ? (c < 55243
                  ? (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))
                : (c <= 64217 || (c < 64285
                  ? (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)
                  : (c <= 64285 || (c >= 64287 && c <= 64296)))))
              : (c <= 64310 || (c < 64326
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c >= 64323 && c <= 64324)))
                : (c <= 64433 || (c < 64848
                  ? (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)
                  : (c <= 64911 || (c >= 64914 && c <= 64967)))))))))
          : (c <= 65017 || (c < 65616
            ? (c < 65440
              ? (c < 65149
                ? (c < 65143
                  ? (c < 65139
                    ? c == 65137
                    : c <= 65139)
                  : (c <= 65143 || (c < 65147
                    ? c == 65145
                    : c <= 65147)))
                : (c <= 65149 || (c < 65345
                  ? (c < 65313
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65338)
                  : (c <= 65370 || (c >= 65382 && c <= 65437)))))
              : (c <= 65470 || (c < 65536
                ? (c < 65490
                  ? (c < 65482
                    ? (c >= 65474 && c <= 65479)
                    : c <= 65487)
                  : (c <= 65495 || (c >= 65498 && c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))))))
            : (c <= 65629 || (c < 66504
              ? (c < 66304
                ? (c < 66176
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66204 || (c >= 66208 && c <= 66256)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66421)
                  : (c <= 66461 || (c >= 66464 && c <= 66499)))))
              : (c <= 66511 || (c < 66816
                ? (c < 66736
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66771 || (c >= 66776 && c <= 66811)))
                : (c <= 66855 || (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))))))))))
        : (c <= 66965 || (c < 69248
          ? (c < 67840
            ? (c < 67584
              ? (c < 67392
                ? (c < 66995
                  ? (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)
                  : (c <= 67001 || (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)))
                : (c <= 67413 || (c < 67463
                  ? (c < 67456
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67461)
                  : (c <= 67504 || (c >= 67506 && c <= 67514)))))
              : (c <= 67589 || (c < 67647
                ? (c < 67639
                  ? (c < 67594
                    ? c == 67592
                    : c <= 67637)
                  : (c <= 67640 || c == 67644))
                : (c <= 67669 || (c < 67808
                  ? (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)
                  : (c <= 67826 || (c >= 67828 && c <= 67829)))))))
            : (c <= 67861 || (c < 68288
              ? (c < 68112
                ? (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || c == 68096))
                : (c <= 68115 || (c < 68192
                  ? (c < 68121
                    ? (c >= 68117 && c <= 68119)
                    : c <= 68149)
                  : (c <= 68220 || (c >= 68224 && c <= 68252)))))
              : (c <= 68295 || (c < 68480
                ? (c < 68416
                  ? (c < 68352
                    ? (c >= 68297 && c <= 68324)
                    : c <= 68405)
                  : (c <= 68437 || (c >= 68448 && c <= 68466)))
                : (c <= 68497 || (c < 68800
                  ? (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)
                  : (c <= 68850 || (c >= 68864 && c <= 68899)))))))))
          : (c <= 69289 || (c < 70108
            ? (c < 69763
              ? (c < 69552
                ? (c < 69415
                  ? (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)
                  : (c <= 69415 || (c < 69488
                    ? (c >= 69424 && c <= 69445)
                    : c <= 69505)))
                : (c <= 69572 || (c < 69745
                  ? (c < 69635
                    ? (c >= 69600 && c <= 69622)
                    : c <= 69687)
                  : (c <= 69746 || c == 69749))))
              : (c <= 69807 || (c < 69968
                ? (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || c == 69959))
                : (c <= 70002 || (c < 70081
                  ? (c < 70019
                    ? c == 70006
                    : c <= 70066)
                  : (c <= 70084 || c == 70106))))))
            : (c <= 70108 || (c < 70415
              ? (c < 70282
                ? (c < 70272
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)
                  : (c <= 70278 || c == 70280))
                : (c <= 70285 || (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70366 || (c >= 70405 && c <= 70412)))))
              : (c <= 70416 || (c < 70461
                ? (c < 70450
                  ? (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)
                  : (c <= 70451 || (c >= 70453 && c <= 70457)))
                : (c <= 70461 || (c < 70656
                  ? (c < 70493
                    ? c == 70480
                    : c <= 70497)
                  : (c <= 70708 || (c >= 70727 && c <= 70730)))))))))))))
      : (c <= 70753 || (c < 119966
        ? (c < 73063
          ? (c < 72096
            ? (c < 71488
              ? (c < 71168
                ? (c < 70855
                  ? (c < 70852
                    ? (c >= 70784 && c <= 70831)
                    : c <= 70853)
                  : (c <= 70855 || (c < 71128
                    ? (c >= 71040 && c <= 71086)
                    : c <= 71131)))
                : (c <= 71215 || (c < 71352
                  ? (c < 71296
                    ? c == 71236
                    : c <= 71338)
                  : (c <= 71352 || (c >= 71424 && c <= 71450)))))
              : (c <= 71494 || (c < 71948
                ? (c < 71935
                  ? (c < 71840
                    ? (c >= 71680 && c <= 71723)
                    : c <= 71903)
                  : (c <= 71942 || c == 71945))
                : (c <= 71955 || (c < 71999
                  ? (c < 71960
                    ? (c >= 71957 && c <= 71958)
                    : c <= 71983)
                  : (c <= 71999 || c == 72001))))))
            : (c <= 72103 || (c < 72368
              ? (c < 72203
                ? (c < 72163
                  ? (c < 72161
                    ? (c >= 72106 && c <= 72144)
                    : c <= 72161)
                  : (c <= 72163 || c == 72192))
                : (c <= 72242 || (c < 72284
                  ? (c < 72272
                    ? c == 72250
                    : c <= 72272)
                  : (c <= 72329 || c == 72349))))
              : (c <= 72440 || (c < 72960
                ? (c < 72768
                  ? (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72750)
                  : (c <= 72768 || (c >= 72818 && c <= 72847)))
                : (c <= 72966 || (c < 73030
                  ? (c < 72971
                    ? (c >= 72968 && c <= 72969)
                    : c <= 73008)
                  : (c <= 73030 || (c >= 73056 && c <= 73061)))))))))
          : (c <= 73064 || (c < 94032
            ? (c < 92160
              ? (c < 74752
                ? (c < 73440
                  ? (c < 73112
                    ? (c >= 73066 && c <= 73097)
                    : c <= 73112)
                  : (c <= 73458 || (c < 73728
                    ? c == 73648
                    : c <= 74649)))
                : (c <= 74862 || (c < 77824
                  ? (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)
                  : (c <= 78894 || (c >= 82944 && c <= 83526)))))
              : (c <= 92728 || (c < 92992
                ? (c < 92880
                  ? (c < 92784
                    ? (c >= 92736 && c <= 92766)
                    : c <= 92862)
                  : (c <= 92909 || (c >= 92928 && c <= 92975)))
                : (c <= 92995 || (c < 93760
                  ? (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)
                  : (c <= 93823 || (c >= 93952 && c <= 94026)))))))
            : (c <= 94032 || (c < 110592
              ? (c < 100352
                ? (c < 94179
                  ? (c < 94176
                    ? (c >= 94099 && c <= 94111)
                    : c <= 94177)
                  : (c <= 94179 || (c >= 94208 && c <= 100343)))
                : (c <= 101589 || (c < 110581
                  ? (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)
                  : (c <= 110587 || (c >= 110589 && c <= 110590)))))
              : (c <= 110882 || (c < 113776
                ? (c < 110960
                  ? (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)
                  : (c <= 111355 || (c >= 113664 && c <= 113770)))
                : (c <= 113788 || (c < 119808
                  ? (c < 113808
                    ? (c >= 113792 && c <= 113800)
                    : c <= 113817)
                  : (c <= 119892 || (c >= 119894 && c <= 119964)))))))))))
        : (c <= 119967 || (c < 126464
          ? (c < 120598
            ? (c < 120094
              ? (c < 119997
                ? (c < 119977
                  ? (c < 119973
                    ? c == 119970
                    : c <= 119974)
                  : (c <= 119980 || (c < 119995
                    ? (c >= 119982 && c <= 119993)
                    : c <= 119995)))
                : (c <= 120003 || (c < 120077
                  ? (c < 120071
                    ? (c >= 120005 && c <= 120069)
                    : c <= 120074)
                  : (c <= 120084 || (c >= 120086 && c <= 120092)))))
              : (c <= 120121 || (c < 120146
                ? (c < 120134
                  ? (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)
                  : (c <= 120134 || (c >= 120138 && c <= 120144)))
                : (c <= 120485 || (c < 120540
                  ? (c < 120514
                    ? (c >= 120488 && c <= 120512)
                    : c <= 120538)
                  : (c <= 120570 || (c >= 120572 && c <= 120596)))))))
            : (c <= 120628 || (c < 123214
              ? (c < 120746
                ? (c < 120688
                  ? (c < 120656
                    ? (c >= 120630 && c <= 120654)
                    : c <= 120686)
                  : (c <= 120712 || (c >= 120714 && c <= 120744)))
                : (c <= 120770 || (c < 123136
                  ? (c < 122624
                    ? (c >= 120772 && c <= 120779)
                    : c <= 122654)
                  : (c <= 123180 || (c >= 123191 && c <= 123197)))))
              : (c <= 123214 || (c < 124909
                ? (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123565)
                    : c <= 123627)
                  : (c <= 124902 || (c >= 124904 && c <= 124907)))
                : (c <= 124910 || (c < 125184
                  ? (c < 124928
                    ? (c >= 124912 && c <= 124926)
                    : c <= 125124)
                  : (c <= 125251 || c == 125259))))))))
          : (c <= 126467 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126500
                  ? (c < 126497
                    ? (c >= 126469 && c <= 126495)
                    : c <= 126498)
                  : (c <= 126500 || c == 126503))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_6(int32_t c) {
  return (c < 43471
    ? (c < 4096
      ? (c < 2649
        ? (c < 1791
          ? (c < 891
            ? (c < 186
              ? (c < '_'
                ? (c < 'M'
                  ? (c < 'A'
                    ? c == '$'
                    : c <= 'K')
                  : (c <= 'Q' || (c < 'V'
                    ? (c >= 'S' && c <= 'T')
                    : c <= 'Z')))
                : (c <= '_' || (c < 170
                  ? (c < 'v'
                    ? (c >= 'a' && c <= 't')
                    : c <= 'z')
                  : (c <= 170 || c == 181))))
              : (c <= 186 || (c < 736
                ? (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))))))
            : (c <= 893 || (c < 1376
              ? (c < 931
                ? (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))
                : (c <= 1013 || (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))))
              : (c <= 1416 || (c < 1649
                ? (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))
                : (c <= 1747 || (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))))))))
          : (c <= 1791 || (c < 2417
            ? (c < 2088
              ? (c < 2036
                ? (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || (c < 1994
                    ? c == 1969
                    : c <= 2026)))
                : (c <= 2037 || (c < 2074
                  ? (c < 2048
                    ? c == 2042
                    : c <= 2069)
                  : (c <= 2074 || c == 2084))))
              : (c <= 2088 || (c < 2208
                ? (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))
                : (c <= 2249 || (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))))))
            : (c <= 2432 || (c < 2527
              ? (c < 2482
                ? (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))
                : (c <= 2482 || (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))))
              : (c <= 2529 || (c < 2579
                ? (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))))))))))
        : (c <= 2652 || (c < 3200
          ? (c < 2911
            ? (c < 2784
              ? (c < 2730
                ? (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)))
                : (c <= 2736 || (c < 2749
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2749 || c == 2768))))
              : (c <= 2785 || (c < 2858
                ? (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))
                : (c <= 2864 || (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))))))
            : (c <= 2913 || (c < 2990
              ? (c < 2969
                ? (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)))
                : (c <= 2970 || (c < 2979
                  ? (c < 2974
                    ? c == 2972
                    : c <= 2975)
                  : (c <= 2980 || (c >= 2984 && c <= 2986)))))
              : (c <= 3001 || (c < 3114
                ? (c < 3086
                  ? (c < 3077
                    ? c == 3024
                    : c <= 3084)
                  : (c <= 3088 || (c >= 3090 && c <= 3112)))
                : (c <= 3129 || (c < 3165
                  ? (c < 3160
                    ? c == 3133
                    : c <= 3162)
                  : (c <= 3165 || (c >= 3168 && c <= 3169)))))))))
          : (c <= 3200 || (c < 3517
            ? (c < 3342
              ? (c < 3261
                ? (c < 3218
                  ? (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)
                  : (c <= 3240 || (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)))
                : (c <= 3261 || (c < 3313
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3297)
                  : (c <= 3314 || (c >= 3332 && c <= 3340)))))
              : (c <= 3344 || (c < 3423
                ? (c < 3406
                  ? (c < 3389
                    ? (c >= 3346 && c <= 3386)
                    : c <= 3389)
                  : (c <= 3406 || (c >= 3412 && c <= 3414)))
                : (c <= 3425 || (c < 3482
                  ? (c < 3461
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3478)
                  : (c <= 3505 || (c >= 3507 && c <= 3515)))))))
            : (c <= 3517 || (c < 3751
              ? (c < 3713
                ? (c < 3634
                  ? (c < 3585
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3632)
                  : (c <= 3634 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || c == 3749))))
              : (c <= 3760 || (c < 3804
                ? (c < 3776
                  ? (c < 3773
                    ? c == 3762
                    : c <= 3773)
                  : (c <= 3780 || c == 3782))
                : (c <= 3807 || (c < 3913
                  ? (c < 3904
                    ? c == 3840
                    : c <= 3911)
                  : (c <= 3948 || (c >= 3976 && c <= 3980)))))))))))))
      : (c <= 4138 || (c < 8118
        ? (c < 6016
          ? (c < 4786
            ? (c < 4301
              ? (c < 4206
                ? (c < 4186
                  ? (c < 4176
                    ? c == 4159
                    : c <= 4181)
                  : (c <= 4189 || (c < 4197
                    ? c == 4193
                    : c <= 4198)))
                : (c <= 4208 || (c < 4256
                  ? (c < 4238
                    ? (c >= 4213 && c <= 4225)
                    : c <= 4238)
                  : (c <= 4293 || c == 4295))))
              : (c <= 4301 || (c < 4696
                ? (c < 4682
                  ? (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)
                  : (c <= 4685 || (c >= 4688 && c <= 4694)))
                : (c <= 4696 || (c < 4746
                  ? (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)
                  : (c <= 4749 || (c >= 4752 && c <= 4784)))))))
            : (c <= 4789 || (c < 5121
              ? (c < 4882
                ? (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))
                : (c <= 4885 || (c < 5024
                  ? (c < 4992
                    ? (c >= 4888 && c <= 4954)
                    : c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))))
              : (c <= 5740 || (c < 5888
                ? (c < 5792
                  ? (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)
                  : (c <= 5866 || (c >= 5870 && c <= 5880)))
                : (c <= 5905 || (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5937)
                    : c <= 5969)
                  : (c <= 5996 || (c >= 5998 && c <= 6000)))))))))
          : (c <= 6067 || (c < 7245
            ? (c < 6576
              ? (c < 6320
                ? (c < 6176
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6108)
                  : (c <= 6264 || (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)))
                : (c <= 6389 || (c < 6512
                  ? (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)
                  : (c <= 6516 || (c >= 6528 && c <= 6571)))))
              : (c <= 6601 || (c < 6981
                ? (c < 6823
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6678)
                    : c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7098
                  ? (c < 7086
                    ? (c >= 7043 && c <= 7072)
                    : c <= 7087)
                  : (c <= 7141 || (c >= 7168 && c <= 7203)))))))
            : (c <= 7247 || (c < 7680
              ? (c < 7401
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7258 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c >= 7357 && c <= 7359)))
                : (c <= 7404 || (c < 7418
                  ? (c < 7413
                    ? (c >= 7406 && c <= 7411)
                    : c <= 7414)
                  : (c <= 7418 || (c >= 7424 && c <= 7615)))))
              : (c <= 7957 || (c < 8025
                ? (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c >= 8016 && c <= 8023)))
                : (c <= 8025 || (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c >= 8064 && c <= 8116)))))))))))
        : (c <= 8124 || (c < 11736
          ? (c < 8508
            ? (c < 8336
              ? (c < 8160
                ? (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)))
                : (c <= 8172 || (c < 8305
                  ? (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)
                  : (c <= 8305 || c == 8319))))
              : (c <= 8348 || (c < 8472
                ? (c < 8458
                  ? (c < 8455
                    ? c == 8450
                    : c <= 8455)
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8488
                  ? (c < 8486
                    ? c == 8484
                    : c <= 8486)
                  : (c <= 8488 || (c >= 8490 && c <= 8505)))))))
            : (c <= 8511 || (c < 11568
              ? (c < 11499
                ? (c < 8544
                  ? (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)
                  : (c <= 8584 || (c >= 11264 && c <= 11492)))
                : (c <= 11502 || (c < 11559
                  ? (c < 11520
                    ? (c >= 11506 && c <= 11507)
                    : c <= 11557)
                  : (c <= 11559 || c == 11565))))
              : (c <= 11623 || (c < 11696
                ? (c < 11680
                  ? (c < 11648
                    ? c == 11631
                    : c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))
                : (c <= 11702 || (c < 11720
                  ? (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)
                  : (c <= 11726 || (c >= 11728 && c <= 11734)))))))))
          : (c <= 11742 || (c < 42656
            ? (c < 12704
              ? (c < 12445
                ? (c < 12337
                  ? (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12329)
                  : (c <= 12341 || (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)))
                : (c <= 12447 || (c < 12549
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)
                  : (c <= 12591 || (c >= 12593 && c <= 12686)))))
              : (c <= 12735 || (c < 42240
                ? (c < 19968
                  ? (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)
                  : (c <= 42124 || (c >= 42192 && c <= 42237)))
                : (c <= 42508 || (c < 42560
                  ? (c < 42538
                    ? (c >= 42512 && c <= 42527)
                    : c <= 42539)
                  : (c <= 42606 || (c >= 42623 && c <= 42653)))))))
            : (c <= 42735 || (c < 43020
              ? (c < 42963
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 43011
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43009)
                  : (c <= 43013 || (c >= 43015 && c <= 43018)))))
              : (c <= 43042 || (c < 43261
                ? (c < 43250
                  ? (c < 43138
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43187)
                  : (c <= 43255 || c == 43259))
                : (c <= 43262 || (c < 43360
                  ? (c < 43312
                    ? (c >= 43274 && c <= 43301)
                    : c <= 43334)
                  : (c <= 43388 || (c >= 43396 && c <= 43442)))))))))))))))
    : (c <= 43471 || (c < 70656
      ? (c < 66928
        ? (c < 64612
          ? (c < 43808
            ? (c < 43701
              ? (c < 43588
                ? (c < 43514
                  ? (c < 43494
                    ? (c >= 43488 && c <= 43492)
                    : c <= 43503)
                  : (c <= 43518 || (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)))
                : (c <= 43595 || (c < 43646
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)
                  : (c <= 43695 || c == 43697))))
              : (c <= 43702 || (c < 43744
                ? (c < 43714
                  ? (c < 43712
                    ? (c >= 43705 && c <= 43709)
                    : c <= 43712)
                  : (c <= 43714 || (c >= 43739 && c <= 43741)))
                : (c <= 43754 || (c < 43785
                  ? (c < 43777
                    ? (c >= 43762 && c <= 43764)
                    : c <= 43782)
                  : (c <= 43790 || (c >= 43793 && c <= 43798)))))))
            : (c <= 43814 || (c < 64275
              ? (c < 55216
                ? (c < 43868
                  ? (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)
                  : (c <= 43881 || (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)))
                : (c <= 55238 || (c < 64112
                  ? (c < 63744
                    ? (c >= 55243 && c <= 55291)
                    : c <= 64109)
                  : (c <= 64217 || (c >= 64256 && c <= 64262)))))
              : (c <= 64279 || (c < 64318
                ? (c < 64298
                  ? (c < 64287
                    ? c == 64285
                    : c <= 64296)
                  : (c <= 64310 || (c >= 64312 && c <= 64316)))
                : (c <= 64318 || (c < 64326
                  ? (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : c <= 64324)
                  : (c <= 64433 || (c >= 64467 && c <= 64605)))))))))
          : (c <= 64829 || (c < 65576
            ? (c < 65313
              ? (c < 65143
                ? (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65139
                    ? c == 65137
                    : c <= 65139)))
                : (c <= 65143 || (c < 65149
                  ? (c < 65147
                    ? c == 65145
                    : c <= 65147)
                  : (c <= 65149 || (c >= 65151 && c <= 65276)))))
              : (c <= 65338 || (c < 65482
                ? (c < 65440
                  ? (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65437)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65536
                  ? (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)
                  : (c <= 65547 || (c >= 65549 && c <= 65574)))))))
            : (c <= 65594 || (c < 66384
              ? (c < 65856
                ? (c < 65616
                  ? (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)
                  : (c <= 65629 || (c >= 65664 && c <= 65786)))
                : (c <= 65908 || (c < 66304
                  ? (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66378)))))
              : (c <= 66421 || (c < 66560
                ? (c < 66504
                  ? (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)
                  : (c <= 66511 || (c >= 66513 && c <= 66517)))
                : (c <= 66717 || (c < 66816
                  ? (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)
                  : (c <= 66855 || (c >= 66864 && c <= 66915)))))))))))
        : (c <= 66938 || (c < 68800
          ? (c < 67712
            ? (c < 67456
              ? (c < 66995
                ? (c < 66964
                  ? (c < 66956
                    ? (c >= 66940 && c <= 66954)
                    : c <= 66962)
                  : (c <= 66965 || (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)))
                : (c <= 67001 || (c < 67392
                  ? (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)
                  : (c <= 67413 || (c >= 67424 && c <= 67431)))))
              : (c <= 67461 || (c < 67594
                ? (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || c == 67592))
                : (c <= 67637 || (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c >= 67680 && c <= 67702)))))))
            : (c <= 67742 || (c < 68192
              ? (c < 68030
                ? (c < 67840
                  ? (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)
                  : (c <= 67861 || (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)))
                : (c <= 68031 || (c < 68117
                  ? (c < 68112
                    ? c == 68096
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))))
              : (c <= 68220 || (c < 68416
                ? (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68324 || (c >= 68352 && c <= 68405)))
                : (c <= 68437 || (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c >= 68736 && c <= 68786)))))))))
          : (c <= 68850 || (c < 70081
            ? (c < 69745
              ? (c < 69424
                ? (c < 69296
                  ? (c < 69248
                    ? (c >= 68864 && c <= 68899)
                    : c <= 69289)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))
                : (c <= 69445 || (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69505)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69635 && c <= 69687)))))
              : (c <= 69746 || (c < 69956
                ? (c < 69840
                  ? (c < 69763
                    ? c == 69749
                    : c <= 69807)
                  : (c <= 69864 || (c >= 69891 && c <= 69926)))
                : (c <= 69956 || (c < 70006
                  ? (c < 69968
                    ? c == 69959
                    : c <= 70002)
                  : (c <= 70006 || (c >= 70019 && c <= 70066)))))))
            : (c <= 70084 || (c < 70320
              ? (c < 70272
                ? (c < 70144
                  ? (c < 70108
                    ? c == 70106
                    : c <= 70108)
                  : (c <= 70161 || (c >= 70163 && c <= 70187)))
                : (c <= 70278 || (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c >= 70303 && c <= 70312)))))
              : (c <= 70366 || (c < 70450
                ? (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c >= 70442 && c <= 70448)))
                : (c <= 70451 || (c < 70480
                  ? (c < 70461
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70461)
                  : (c <= 70480 || (c >= 70493 && c <= 70497)))))))))))))
      : (c <= 70708 || (c < 119894
        ? (c < 73056
          ? (c < 71999
            ? (c < 71352
              ? (c < 71040
                ? (c < 70784
                  ? (c < 70751
                    ? (c >= 70727 && c <= 70730)
                    : c <= 70753)
                  : (c <= 70831 || (c < 70855
                    ? (c >= 70852 && c <= 70853)
                    : c <= 70855)))
                : (c <= 71086 || (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71131)
                    : c <= 71215)
                  : (c <= 71236 || (c >= 71296 && c <= 71338)))))
              : (c <= 71352 || (c < 71935
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71494)
                  : (c <= 71723 || (c >= 71840 && c <= 71903)))
                : (c <= 71942 || (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c >= 71960 && c <= 71983)))))))
            : (c <= 71999 || (c < 72349
              ? (c < 72192
                ? (c < 72106
                  ? (c < 72096
                    ? c == 72001
                    : c <= 72103)
                  : (c <= 72144 || (c < 72163
                    ? c == 72161
                    : c <= 72163)))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_7(int32_t c) {
  return (c < 43360
    ? (c < 3840
      ? (c < 2602
        ? (c < 1649
          ? (c < 736
            ? (c < 'q'
              ? (c < 'a'
                ? (c < 'M'
                  ? (c < 'A'
                    ? c == '$'
                    : c <= 'K')
                  : (c <= 'T' || (c < '_'
                    ? (c >= 'V' && c <= 'Z')
                    : c <= '_')))
                : (c <= 'a' || (c < 'j'
                  ? (c < 'g'
                    ? c == 'e'
                    : c <= 'h')
                  : (c <= 'l' || c == 'o'))))
              : (c <= 'r' || (c < 186
                ? (c < 170
                  ? (c < 'w'
                    ? c == 't'
                    : c <= 'z')
                  : (c <= 170 || c == 181))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))))))
            : (c <= 740 || (c < 931
              ? (c < 895
                ? (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))
              : (c <= 1013 || (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))))))
          : (c <= 1747 || (c < 2208
            ? (c < 2036
              ? (c < 1808
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c < 1791
                    ? (c >= 1786 && c <= 1788)
                    : c <= 1791)))
                : (c <= 1808 || (c < 1969
                  ? (c < 1869
                    ? (c >= 1810 && c <= 1839)
                    : c <= 1957)
                  : (c <= 1969 || (c >= 1994 && c <= 2026)))))
              : (c <= 2037 || (c < 2088
                ? (c < 2074
                  ? (c < 2048
                    ? c == 2042
                    : c <= 2069)
                  : (c <= 2074 || c == 2084))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))))
            : (c <= 2249 || (c < 2486
              ? (c < 2437
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c < 2417
                    ? (c >= 2392 && c <= 2401)
                    : c <= 2432)))
                : (c <= 2444 || (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || c == 2482))))
              : (c <= 2489 || (c < 2544
                ? (c < 2524
                  ? (c < 2510
                    ? c == 2493
                    : c <= 2510)
                  : (c <= 2525 || (c >= 2527 && c <= 2529)))
                : (c <= 2545 || (c < 2575
                  ? (c < 2565
                    ? c == 2556
                    : c <= 2570)
                  : (c <= 2576 || (c >= 2579 && c <= 2600)))))))))))
        : (c <= 2608 || (c < 3133
          ? (c < 2866
            ? (c < 2738
              ? (c < 2674
                ? (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)))
                : (c <= 2676 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))))
              : (c <= 2739 || (c < 2809
                ? (c < 2768
                  ? (c < 2749
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2749)
                  : (c <= 2768 || (c >= 2784 && c <= 2785)))
                : (c <= 2809 || (c < 2835
                  ? (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)
                  : (c <= 2856 || (c >= 2858 && c <= 2864)))))))
            : (c <= 2867 || (c < 2972
              ? (c < 2947
                ? (c < 2908
                  ? (c < 2877
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2877)
                  : (c <= 2909 || (c < 2929
                    ? (c >= 2911 && c <= 2913)
                    : c <= 2929)))
                : (c <= 2947 || (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c >= 2969 && c <= 2970)))))
              : (c <= 2972 || (c < 3024
                ? (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c >= 2990 && c <= 3001)))
                : (c <= 3024 || (c < 3090
                  ? (c < 3086
                    ? (c >= 3077 && c <= 3084)
                    : c <= 3088)
                  : (c <= 3112 || (c >= 3114 && c <= 3129)))))))))
          : (c <= 3133 || (c < 3450
            ? (c < 3293
              ? (c < 3214
                ? (c < 3168
                  ? (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)
                  : (c <= 3169 || (c < 3205
                    ? c == 3200
                    : c <= 3212)))
                : (c <= 3216 || (c < 3253
                  ? (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)
                  : (c <= 3257 || c == 3261))))
              : (c <= 3294 || (c < 3346
                ? (c < 3332
                  ? (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)
                  : (c <= 3340 || (c >= 3342 && c <= 3344)))
                : (c <= 3386 || (c < 3412
                  ? (c < 3406
                    ? c == 3389
                    : c <= 3406)
                  : (c <= 3414 || (c >= 3423 && c <= 3425)))))))
            : (c <= 3455 || (c < 3716
              ? (c < 3520
                ? (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || c == 3517))
                : (c <= 3526 || (c < 3648
                  ? (c < 3634
                    ? (c >= 3585 && c <= 3632)
                    : c <= 3634)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))))
              : (c <= 3716 || (c < 3762
                ? (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c >= 3751 && c <= 3760)))
                : (c <= 3762 || (c < 3782
                  ? (c < 3776
                    ? c == 3773
                    : c <= 3780)
                  : (c <= 3782 || (c >= 3804 && c <= 3807)))))))))))))
      : (c <= 3840 || (c < 8029
        ? (c < 5919
          ? (c < 4698
            ? (c < 4213
              ? (c < 4176
                ? (c < 3976
                  ? (c < 3913
                    ? (c >= 3904 && c <= 3911)
                    : c <= 3948)
                  : (c <= 3980 || (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)))
                : (c <= 4181 || (c < 4197
                  ? (c < 4193
                    ? (c >= 4186 && c <= 4189)
                    : c <= 4193)
                  : (c <= 4198 || (c >= 4206 && c <= 4208)))))
              : (c <= 4225 || (c < 4304
                ? (c < 4295
                  ? (c < 4256
                    ? c == 4238
                    : c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4688
                  ? (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)
                  : (c <= 4694 || c == 4696))))))
            : (c <= 4701 || (c < 4888
              ? (c < 4800
                ? (c < 4752
                  ? (c < 4746
                    ? (c >= 4704 && c <= 4744)
                    : c <= 4749)
                  : (c <= 4784 || (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)))
                : (c <= 4800 || (c < 4824
                  ? (c < 4808
                    ? (c >= 4802 && c <= 4805)
                    : c <= 4822)
                  : (c <= 4880 || (c >= 4882 && c <= 4885)))))
              : (c <= 4954 || (c < 5743
                ? (c < 5112
                  ? (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)
                  : (c <= 5117 || (c >= 5121 && c <= 5740)))
                : (c <= 5759 || (c < 5870
                  ? (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)
                  : (c <= 5880 || (c >= 5888 && c <= 5905)))))))))
          : (c <= 5937 || (c < 7043
            ? (c < 6400
              ? (c < 6108
                ? (c < 5998
                  ? (c < 5984
                    ? (c >= 5952 && c <= 5969)
                    : c <= 5996)
                  : (c <= 6000 || (c < 6103
                    ? (c >= 6016 && c <= 6067)
                    : c <= 6103)))
                : (c <= 6108 || (c < 6314
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6312)
                  : (c <= 6314 || (c >= 6320 && c <= 6389)))))
              : (c <= 6430 || (c < 6656
                ? (c < 6528
                  ? (c < 6512
                    ? (c >= 6480 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c >= 6576 && c <= 6601)))
                : (c <= 6678 || (c < 6917
                  ? (c < 6823
                    ? (c >= 6688 && c <= 6740)
                    : c <= 6823)
                  : (c <= 6963 || (c >= 6981 && c <= 6988)))))))
            : (c <= 7072 || (c < 7413
              ? (c < 7296
                ? (c < 7168
                  ? (c < 7098
                    ? (c >= 7086 && c <= 7087)
                    : c <= 7141)
                  : (c <= 7203 || (c < 7258
                    ? (c >= 7245 && c <= 7247)
                    : c <= 7293)))
                : (c <= 7304 || (c < 7401
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)
                  : (c <= 7404 || (c >= 7406 && c <= 7411)))))
              : (c <= 7414 || (c < 7968
                ? (c < 7680
                  ? (c < 7424
                    ? c == 7418
                    : c <= 7615)
                  : (c <= 7957 || (c >= 7960 && c <= 7965)))
                : (c <= 8005 || (c < 8025
                  ? (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)
                  : (c <= 8025 || c == 8027))))))))))
        : (c <= 8029 || (c < 11720
          ? (c < 8486
            ? (c < 8182
              ? (c < 8134
                ? (c < 8118
                  ? (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)
                  : (c <= 8124 || (c < 8130
                    ? c == 8126
                    : c <= 8132)))
                : (c <= 8140 || (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c >= 8178 && c <= 8180)))))
              : (c <= 8188 || (c < 8455
                ? (c < 8336
                  ? (c < 8319
                    ? c == 8305
                    : c <= 8319)
                  : (c <= 8348 || c == 8450))
                : (c <= 8455 || (c < 8472
                  ? (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)
                  : (c <= 8477 || c == 8484))))))
            : (c <= 8486 || (c < 11559
              ? (c < 8544
                ? (c < 8508
                  ? (c < 8490
                    ? c == 8488
                    : c <= 8505)
                  : (c <= 8511 || (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)))
                : (c <= 8584 || (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))))
              : (c <= 11559 || (c < 11680
                ? (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))
                : (c <= 11686 || (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))))))))
          : (c <= 11726 || (c < 42560
            ? (c < 12549
              ? (c < 12344
                ? (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c < 12337
                    ? (c >= 12321 && c <= 12329)
                    : c <= 12341)))
                : (c <= 12348 || (c < 12449
                  ? (c < 12445
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12447)
                  : (c <= 12538 || (c >= 12540 && c <= 12543)))))
              : (c <= 12591 || (c < 19968
                ? (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))))))
            : (c <= 42606 || (c < 43011
              ? (c < 42891
                ? (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))
                : (c <= 42954 || (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))))
              : (c <= 43013 || (c < 43250
                ? (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))
                : (c <= 43255 || (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))))))))))))))
    : (c <= 43388 || (c < 70493
      ? (c < 66864
        ? (c < 64326
          ? (c < 43785
            ? (c < 43646
              ? (c < 43520
                ? (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c < 43514
                    ? (c >= 43494 && c <= 43503)
                    : c <= 43518)))
                : (c <= 43560 || (c < 43616
                  ? (c < 43588
                    ? (c >= 43584 && c <= 43586)
                    : c <= 43595)
                  : (c <= 43638 || c == 43642))))
              : (c <= 43695 || (c < 43714
                ? (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))
                : (c <= 43714 || (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))))))
            : (c <= 43790 || (c < 64112
              ? (c < 43888
                ? (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))
                : (c <= 44002 || (c < 55243
                  ? (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))))
              : (c <= 64217 || (c < 64298
                ? (c < 64285
                  ? (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)
                  : (c <= 64285 || (c >= 64287 && c <= 64296)))
                : (c <= 64310 || (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c >= 64323 && c <= 64324)))))))))
          : (c <= 64433 || (c < 65536
            ? (c < 65149
              ? (c < 65137
                ? (c < 64848
                  ? (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)
                  : (c <= 64911 || (c < 65008
                    ? (c >= 64914 && c <= 64967)
                    : c <= 65017)))
                : (c <= 65137 || (c < 65145
                  ? (c < 65143
                    ? c == 65139
                    : c <= 65143)
                  : (c <= 65145 || c == 65147))))
              : (c <= 65149 || (c < 65440
                ? (c < 65345
                  ? (c < 65313
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65338)
                  : (c <= 65370 || (c >= 65382 && c <= 65437)))
                : (c <= 65470 || (c < 65490
                  ? (c < 65482
                    ? (c >= 65474 && c <= 65479)
                    : c <= 65487)
                  : (c <= 65495 || (c >= 65498 && c <= 65500)))))))
            : (c <= 65547 || (c < 66349
              ? (c < 65664
                ? (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))
                : (c <= 65786 || (c < 66208
                  ? (c < 66176
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66204)
                  : (c <= 66256 || (c >= 66304 && c <= 66335)))))
              : (c <= 66378 || (c < 66513
                ? (c < 66464
                  ? (c < 66432
                    ? (c >= 66384 && c <= 66421)
                    : c <= 66461)
                  : (c <= 66499 || (c >= 66504 && c <= 66511)))
                : (c <= 66517 || (c < 66776
                  ? (c < 66736
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66771)
                  : (c <= 66811 || (c >= 66816 && c <= 66855)))))))))))
        : (c <= 66915 || (c < 68736
          ? (c < 67680
            ? (c < 67424
              ? (c < 66979
                ? (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))
                : (c <= 66993 || (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))))
              : (c <= 67431 || (c < 67592
                ? (c < 67506
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : c <= 67504)
                  : (c <= 67514 || (c >= 67584 && c <= 67589)))
                : (c <= 67592 || (c < 67644
                  ? (c < 67639
                    ? (c >= 67594 && c <= 67637)
                    : c <= 67640)
                  : (c <= 67644 || (c >= 67647 && c <= 67669)))))))
            : (c <= 67702 || (c < 68121
              ? (c < 67968
                ? (c < 67828
                  ? (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)
                  : (c <= 67829 || (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)))
                : (c <= 68023 || (c < 68112
                  ? (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68096)
                  : (c <= 68115 || (c >= 68117 && c <= 68119)))))
              : (c <= 68149 || (c < 68352
                ? (c < 68288
                  ? (c < 68224
                    ? (c >= 68192 && c <= 68220)
                    : c <= 68252)
                  : (c <= 68295 || (c >= 68297 && c <= 68324)))
                : (c <= 68405 || (c < 68480
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : c <= 68466)
                  : (c <= 68497 || (c >= 68608 && c <= 68680)))))))))
          : (c <= 68786 || (c < 70019
            ? (c < 69635
              ? (c < 69415
                ? (c < 69248
                  ? (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68899)
                  : (c <= 69289 || (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)))
                : (c <= 69415 || (c < 69552
                  ? (c < 69488
                    ? (c >= 69424 && c <= 69445)
                    : c <= 69505)
                  : (c <= 69572 || (c >= 69600 && c <= 69622)))))
              : (c <= 69687 || (c < 69891
                ? (c < 69763
                  ? (c < 69749
                    ? (c >= 69745 && c <= 69746)
                    : c <= 69749)
                  : (c <= 69807 || (c >= 69840 && c <= 69864)))
                : (c <= 69926 || (c < 69968
                  ? (c < 69959
                    ? c == 69956
                    : c <= 69959)
                  : (c <= 70002 || c == 70006))))))
            : (c <= 70066 || (c < 70303
              ? (c < 70163
                ? (c < 70108
                  ? (c < 70106
                    ? (c >= 70081 && c <= 70084)
                    : c <= 70106)
                  : (c <= 70108 || (c >= 70144 && c <= 70161)))
                : (c <= 70187 || (c < 70282
                  ? (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)
                  : (c <= 70285 || (c >= 70287 && c <= 70301)))))
              : (c <= 70312 || (c < 70442
                ? (c < 70415
                  ? (c < 70405
                    ? (c >= 70320 && c <= 70366)
                    : c <= 70412)
                  : (c <= 70416 || (c >= 70419 && c <= 70440)))
                : (c <= 70448 || (c < 70461
                  ? (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)
                  : (c <= 70461 || c == 70480))))))))))))
      : (c <= 70497 || (c < 119808
        ? (c < 73030
          ? (c < 71960
            ? (c < 71296
              ? (c < 70855
                ? (c < 70751
                  ? (c < 70727
                    ? (c >= 70656 && c <= 70708)
                    : c <= 70730)
                  : (c <= 70753 || (c < 70852
                    ? (c >= 70784 && c <= 70831)
                    : c <= 70853)))
                : (c <= 70855 || (c < 71168
                  ? (c < 71128
                    ? (c >= 71040 && c <= 71086)
                    : c <= 71131)
                  : (c <= 71215 || c == 71236))))
              : (c <= 71338 || (c < 71840
                ? (c < 71488
                  ? (c < 71424
                    ? c == 71352
                    : c <= 71450)
                  : (c <= 71494 || (c >= 71680 && c <= 71723)))
                : (c <= 71903 || (c < 71948
                  ? (c < 71945
                    ? (c >= 71935 && c <= 71942)
                    : c <= 71945)
                  : (c <= 71955 || (c >= 71957 && c <= 71958)))))))
            : (c <= 71983 || (c < 72284
              ? (c < 72163
                ? (c < 72096
                  ? (c < 72001
                    ? c == 71999
                    : c <= 72001)
                  : (c <= 72103 || (c < 72161
                    ? (c >= 72106 && c <= 72144)
                    : c <= 72161)))
                : (c <= 72163 || (c < 72250
                  ? (c < 72203
                    ? c == 72192
                    : c <= 72242)
                  : (c <= 72250 || c == 72272))))
              : (c <= 72329 || (c < 72768
                ? (c < 72704
                  ? (c < 72368
                    ? c == 72349
                    : c <= 72440)
                  : (c <= 72712 || (c >= 72714 && c <= 72750)))
                : (c <= 72768 || (c < 72968
                  ? (c < 72960
                    ? (c >= 72818 && c <= 72847)
                    : c <= 72966)
                  : (c <= 72969 || (c >= 72971 && c <= 73008)))))))))
          : (c <= 73030 || (c < 93760
            ? (c < 77824
              ? (c < 73648
                ? (c < 73066
                  ? (c < 73063
                    ? (c >= 73056 && c <= 73061)
                    : c <= 73064)
                  : (c <= 73097 || (c < 73440
                    ? c == 73112
                    : c <= 73458)))
                : (c <= 73648 || (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c >= 77712 && c <= 77808)))))
              : (c <= 78894 || (c < 92880
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c >= 92784 && c <= 92862)))
                : (c <= 92909 || (c < 93027
                  ? (c < 92992
                    ? (c >= 92928 && c <= 92975)
                    : c <= 92995)
                  : (c <= 93047 || (c >= 93053 && c <= 93071)))))))
            : (c <= 93823 || (c < 110581
              ? (c < 94179
                ? (c < 94099
                  ? (c < 94032
                    ? (c >= 93952 && c <= 94026)
                    : c <= 94032)
                  : (c <= 94111 || (c >= 94176 && c <= 94177)))
                : (c <= 94179 || (c < 101632
                  ? (c < 100352
                    ? (c >= 94208 && c <= 100343)
                    : c <= 101589)
                  : (c <= 101640 || (c >= 110576 && c <= 110579)))))
              : (c <= 110587 || (c < 110960
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c >= 110948 && c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c >= 113808 && c <= 113817)))))))))))
        : (c <= 119892 || (c < 125259
          ? (c < 120540
            ? (c < 120077
              ? (c < 119982
                ? (c < 119970
                  ? (c < 119966
                    ? (c >= 119894 && c <= 119964)
                    : c <= 119967)
                  : (c <= 119970 || (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)))
                : (c <= 119993 || (c < 120005
                  ? (c < 119997
                    ? c == 119995
                    : c <= 120003)
                  : (c <= 120069 || (c >= 120071 && c <= 120074)))))
              : (c <= 120084 || (c < 120134
                ? (c < 120123
                  ? (c < 120094
                    ? (c >= 120086 && c <= 120092)
                    : c <= 120121)
                  : (c <= 120126 || (c >= 120128 && c <= 120132)))
                : (c <= 120134 || (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c >= 120514 && c <= 120538)))))))
            : (c <= 120570 || (c < 123191
              ? (c < 120714
                ? (c < 120630
                  ? (c < 120598
                    ? (c >= 120572 && c <= 120596)
                    : c <= 120628)
                  : (c <= 120654 || (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_8(int32_t c) {
  return (c < 43471
    ? (c < 4096
      ? (c < 2649
        ? (c < 1791
          ? (c < 891
            ? (c < 186
              ? (c < 'a'
                ? (c < 'G'
                  ? (c < 'A'
                    ? c == '$'
                    : c <= 'E')
                  : (c <= 'S' || (c < '_'
                    ? (c >= 'U' && c <= 'Z')
                    : c <= '_')))
                : (c <= 'e' || (c < 170
                  ? (c < 'u'
                    ? (c >= 'g' && c <= 's')
                    : c <= 'z')
                  : (c <= 170 || c == 181))))
              : (c <= 186 || (c < 736
                ? (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))))))
            : (c <= 893 || (c < 1376
              ? (c < 931
                ? (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))
                : (c <= 1013 || (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))))
              : (c <= 1416 || (c < 1649
                ? (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))
                : (c <= 1747 || (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))))))))
          : (c <= 1791 || (c < 2417
            ? (c < 2088
              ? (c < 2036
                ? (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || (c < 1994
                    ? c == 1969
                    : c <= 2026)))
                : (c <= 2037 || (c < 2074
                  ? (c < 2048
                    ? c == 2042
                    : c <= 2069)
                  : (c <= 2074 || c == 2084))))
              : (c <= 2088 || (c < 2208
                ? (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))
                : (c <= 2249 || (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))))))
            : (c <= 2432 || (c < 2527
              ? (c < 2482
                ? (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))
                : (c <= 2482 || (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))))
              : (c <= 2529 || (c < 2579
                ? (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))))))))))
        : (c <= 2652 || (c < 3200
          ? (c < 2911
            ? (c < 2784
              ? (c < 2730
                ? (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)))
                : (c <= 2736 || (c < 2749
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2749 || c == 2768))))
              : (c <= 2785 || (c < 2858
                ? (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))
                : (c <= 2864 || (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))))))
            : (c <= 2913 || (c < 2990
              ? (c < 2969
                ? (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)))
                : (c <= 2970 || (c < 2979
                  ? (c < 2974
                    ? c == 2972
                    : c <= 2975)
                  : (c <= 2980 || (c >= 2984 && c <= 2986)))))
              : (c <= 3001 || (c < 3114
                ? (c < 3086
                  ? (c < 3077
                    ? c == 3024
                    : c <= 3084)
                  : (c <= 3088 || (c >= 3090 && c <= 3112)))
                : (c <= 3129 || (c < 3165
                  ? (c < 3160
                    ? c == 3133
                    : c <= 3162)
                  : (c <= 3165 || (c >= 3168 && c <= 3169)))))))))
          : (c <= 3200 || (c < 3517
            ? (c < 3342
              ? (c < 3261
                ? (c < 3218
                  ? (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)
                  : (c <= 3240 || (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)))
                : (c <= 3261 || (c < 3313
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3297)
                  : (c <= 3314 || (c >= 3332 && c <= 3340)))))
              : (c <= 3344 || (c < 3423
                ? (c < 3406
                  ? (c < 3389
                    ? (c >= 3346 && c <= 3386)
                    : c <= 3389)
                  : (c <= 3406 || (c >= 3412 && c <= 3414)))
                : (c <= 3425 || (c < 3482
                  ? (c < 3461
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3478)
                  : (c <= 3505 || (c >= 3507 && c <= 3515)))))))
            : (c <= 3517 || (c < 3751
              ? (c < 3713
                ? (c < 3634
                  ? (c < 3585
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3632)
                  : (c <= 3634 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || c == 3749))))
              : (c <= 3760 || (c < 3804
                ? (c < 3776
                  ? (c < 3773
                    ? c == 3762
                    : c <= 3773)
                  : (c <= 3780 || c == 3782))
                : (c <= 3807 || (c < 3913
                  ? (c < 3904
                    ? c == 3840
                    : c <= 3911)
                  : (c <= 3948 || (c >= 3976 && c <= 3980)))))))))))))
      : (c <= 4138 || (c < 8118
        ? (c < 6016
          ? (c < 4786
            ? (c < 4301
              ? (c < 4206
                ? (c < 4186
                  ? (c < 4176
                    ? c == 4159
                    : c <= 4181)
                  : (c <= 4189 || (c < 4197
                    ? c == 4193
                    : c <= 4198)))
                : (c <= 4208 || (c < 4256
                  ? (c < 4238
                    ? (c >= 4213 && c <= 4225)
                    : c <= 4238)
                  : (c <= 4293 || c == 4295))))
              : (c <= 4301 || (c < 4696
                ? (c < 4682
                  ? (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)
                  : (c <= 4685 || (c >= 4688 && c <= 4694)))
                : (c <= 4696 || (c < 4746
                  ? (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)
                  : (c <= 4749 || (c >= 4752 && c <= 4784)))))))
            : (c <= 4789 || (c < 5121
              ? (c < 4882
                ? (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))
                : (c <= 4885 || (c < 5024
                  ? (c < 4992
                    ? (c >= 4888 && c <= 4954)
                    : c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))))
              : (c <= 5740 || (c < 5888
                ? (c < 5792
                  ? (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)
                  : (c <= 5866 || (c >= 5870 && c <= 5880)))
                : (c <= 5905 || (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5937)
                    : c <= 5969)
                  : (c <= 5996 || (c >= 5998 && c <= 6000)))))))))
          : (c <= 6067 || (c < 7245
            ? (c < 6576
              ? (c < 6320
                ? (c < 6176
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6108)
                  : (c <= 6264 || (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)))
                : (c <= 6389 || (c < 6512
                  ? (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)
                  : (c <= 6516 || (c >= 6528 && c <= 6571)))))
              : (c <= 6601 || (c < 6981
                ? (c < 6823
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6678)
                    : c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7098
                  ? (c < 7086
                    ? (c >= 7043 && c <= 7072)
                    : c <= 7087)
                  : (c <= 7141 || (c >= 7168 && c <= 7203)))))))
            : (c <= 7247 || (c < 7680
              ? (c < 7401
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7258 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c >= 7357 && c <= 7359)))
                : (c <= 7404 || (c < 7418
                  ? (c < 7413
                    ? (c >= 7406 && c <= 7411)
                    : c <= 7414)
                  : (c <= 7418 || (c >= 7424 && c <= 7615)))))
              : (c <= 7957 || (c < 8025
                ? (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c >= 8016 && c <= 8023)))
                : (c <= 8025 || (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c >= 8064 && c <= 8116)))))))))))
        : (c <= 8124 || (c < 11736
          ? (c < 8508
            ? (c < 8336
              ? (c < 8160
                ? (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)))
                : (c <= 8172 || (c < 8305
                  ? (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)
                  : (c <= 8305 || c == 8319))))
              : (c <= 8348 || (c < 8472
                ? (c < 8458
                  ? (c < 8455
                    ? c == 8450
                    : c <= 8455)
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8488
                  ? (c < 8486
                    ? c == 8484
                    : c <= 8486)
                  : (c <= 8488 || (c >= 8490 && c <= 8505)))))))
            : (c <= 8511 || (c < 11568
              ? (c < 11499
                ? (c < 8544
                  ? (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)
                  : (c <= 8584 || (c >= 11264 && c <= 11492)))
                : (c <= 11502 || (c < 11559
                  ? (c < 11520
                    ? (c >= 11506 && c <= 11507)
                    : c <= 11557)
                  : (c <= 11559 || c == 11565))))
              : (c <= 11623 || (c < 11696
                ? (c < 11680
                  ? (c < 11648
                    ? c == 11631
                    : c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))
                : (c <= 11702 || (c < 11720
                  ? (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)
                  : (c <= 11726 || (c >= 11728 && c <= 11734)))))))))
          : (c <= 11742 || (c < 42656
            ? (c < 12704
              ? (c < 12445
                ? (c < 12337
                  ? (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12329)
                  : (c <= 12341 || (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)))
                : (c <= 12447 || (c < 12549
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)
                  : (c <= 12591 || (c >= 12593 && c <= 12686)))))
              : (c <= 12735 || (c < 42240
                ? (c < 19968
                  ? (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)
                  : (c <= 42124 || (c >= 42192 && c <= 42237)))
                : (c <= 42508 || (c < 42560
                  ? (c < 42538
                    ? (c >= 42512 && c <= 42527)
                    : c <= 42539)
                  : (c <= 42606 || (c >= 42623 && c <= 42653)))))))
            : (c <= 42735 || (c < 43020
              ? (c < 42963
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 43011
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43009)
                  : (c <= 43013 || (c >= 43015 && c <= 43018)))))
              : (c <= 43042 || (c < 43261
                ? (c < 43250
                  ? (c < 43138
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43187)
                  : (c <= 43255 || c == 43259))
                : (c <= 43262 || (c < 43360
                  ? (c < 43312
                    ? (c >= 43274 && c <= 43301)
                    : c <= 43334)
                  : (c <= 43388 || (c >= 43396 && c <= 43442)))))))))))))))
    : (c <= 43471 || (c < 70656
      ? (c < 66928
        ? (c < 64612
          ? (c < 43808
            ? (c < 43701
              ? (c < 43588
                ? (c < 43514
                  ? (c < 43494
                    ? (c >= 43488 && c <= 43492)
                    : c <= 43503)
                  : (c <= 43518 || (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)))
                : (c <= 43595 || (c < 43646
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)
                  : (c <= 43695 || c == 43697))))
              : (c <= 43702 || (c < 43744
                ? (c < 43714
                  ? (c < 43712
                    ? (c >= 43705 && c <= 43709)
                    : c <= 43712)
                  : (c <= 43714 || (c >= 43739 && c <= 43741)))
                : (c <= 43754 || (c < 43785
                  ? (c < 43777
                    ? (c >= 43762 && c <= 43764)
                    : c <= 43782)
                  : (c <= 43790 || (c >= 43793 && c <= 43798)))))))
            : (c <= 43814 || (c < 64275
              ? (c < 55216
                ? (c < 43868
                  ? (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)
                  : (c <= 43881 || (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)))
                : (c <= 55238 || (c < 64112
                  ? (c < 63744
                    ? (c >= 55243 && c <= 55291)
                    : c <= 64109)
                  : (c <= 64217 || (c >= 64256 && c <= 64262)))))
              : (c <= 64279 || (c < 64318
                ? (c < 64298
                  ? (c < 64287
                    ? c == 64285
                    : c <= 64296)
                  : (c <= 64310 || (c >= 64312 && c <= 64316)))
                : (c <= 64318 || (c < 64326
                  ? (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : c <= 64324)
                  : (c <= 64433 || (c >= 64467 && c <= 64605)))))))))
          : (c <= 64829 || (c < 65576
            ? (c < 65313
              ? (c < 65143
                ? (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65139
                    ? c == 65137
                    : c <= 65139)))
                : (c <= 65143 || (c < 65149
                  ? (c < 65147
                    ? c == 65145
                    : c <= 65147)
                  : (c <= 65149 || (c >= 65151 && c <= 65276)))))
              : (c <= 65338 || (c < 65482
                ? (c < 65440
                  ? (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65437)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65536
                  ? (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)
                  : (c <= 65547 || (c >= 65549 && c <= 65574)))))))
            : (c <= 65594 || (c < 66384
              ? (c < 65856
                ? (c < 65616
                  ? (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)
                  : (c <= 65629 || (c >= 65664 && c <= 65786)))
                : (c <= 65908 || (c < 66304
                  ? (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66378)))))
              : (c <= 66421 || (c < 66560
                ? (c < 66504
                  ? (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)
                  : (c <= 66511 || (c >= 66513 && c <= 66517)))
                : (c <= 66717 || (c < 66816
                  ? (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)
                  : (c <= 66855 || (c >= 66864 && c <= 66915)))))))))))
        : (c <= 66938 || (c < 68800
          ? (c < 67712
            ? (c < 67456
              ? (c < 66995
                ? (c < 66964
                  ? (c < 66956
                    ? (c >= 66940 && c <= 66954)
                    : c <= 66962)
                  : (c <= 66965 || (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)))
                : (c <= 67001 || (c < 67392
                  ? (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)
                  : (c <= 67413 || (c >= 67424 && c <= 67431)))))
              : (c <= 67461 || (c < 67594
                ? (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || c == 67592))
                : (c <= 67637 || (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c >= 67680 && c <= 67702)))))))
            : (c <= 67742 || (c < 68192
              ? (c < 68030
                ? (c < 67840
                  ? (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)
                  : (c <= 67861 || (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)))
                : (c <= 68031 || (c < 68117
                  ? (c < 68112
                    ? c == 68096
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))))
              : (c <= 68220 || (c < 68416
                ? (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68324 || (c >= 68352 && c <= 68405)))
                : (c <= 68437 || (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c >= 68736 && c <= 68786)))))))))
          : (c <= 68850 || (c < 70081
            ? (c < 69745
              ? (c < 69424
                ? (c < 69296
                  ? (c < 69248
                    ? (c >= 68864 && c <= 68899)
                    : c <= 69289)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))
                : (c <= 69445 || (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69505)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69635 && c <= 69687)))))
              : (c <= 69746 || (c < 69956
                ? (c < 69840
                  ? (c < 69763
                    ? c == 69749
                    : c <= 69807)
                  : (c <= 69864 || (c >= 69891 && c <= 69926)))
                : (c <= 69956 || (c < 70006
                  ? (c < 69968
                    ? c == 69959
                    : c <= 70002)
                  : (c <= 70006 || (c >= 70019 && c <= 70066)))))))
            : (c <= 70084 || (c < 70320
              ? (c < 70272
                ? (c < 70144
                  ? (c < 70108
                    ? c == 70106
                    : c <= 70108)
                  : (c <= 70161 || (c >= 70163 && c <= 70187)))
                : (c <= 70278 || (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c >= 70303 && c <= 70312)))))
              : (c <= 70366 || (c < 70450
                ? (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c >= 70442 && c <= 70448)))
                : (c <= 70451 || (c < 70480
                  ? (c < 70461
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70461)
                  : (c <= 70480 || (c >= 70493 && c <= 70497)))))))))))))
      : (c <= 70708 || (c < 119894
        ? (c < 73056
          ? (c < 71999
            ? (c < 71352
              ? (c < 71040
                ? (c < 70784
                  ? (c < 70751
                    ? (c >= 70727 && c <= 70730)
                    : c <= 70753)
                  : (c <= 70831 || (c < 70855
                    ? (c >= 70852 && c <= 70853)
                    : c <= 70855)))
                : (c <= 71086 || (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71131)
                    : c <= 71215)
                  : (c <= 71236 || (c >= 71296 && c <= 71338)))))
              : (c <= 71352 || (c < 71935
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71494)
                  : (c <= 71723 || (c >= 71840 && c <= 71903)))
                : (c <= 71942 || (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c >= 71960 && c <= 71983)))))))
            : (c <= 71999 || (c < 72349
              ? (c < 72192
                ? (c < 72106
                  ? (c < 72096
                    ? c == 72001
                    : c <= 72103)
                  : (c <= 72144 || (c < 72163
                    ? c == 72161
                    : c <= 72163)))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_9(int32_t c) {
  return (c < 43520
    ? (c < 3724
      ? (c < 2703
        ? (c < 1791
          ? (c < 895
            ? (c < 183
              ? (c < 'A'
                ? (c < '4'
                  ? (c < '0'
                    ? c == '$'
                    : (c <= '0' || c == '2'))
                  : (c <= '5' || (c < '9'
                    ? c == '7'
                    : c <= '9')))
                : (c <= 'Z' || (c < 'q'
                  ? (c < 'a'
                    ? c == '_'
                    : c <= 'o')
                  : (c <= 'z' || (c < 181
                    ? c == 170
                    : c <= 181)))))
              : (c <= 183 || (c < 736
                ? (c < 216
                  ? (c < 192
                    ? c == 186
                    : c <= 214)
                  : (c <= 246 || (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)))
                : (c <= 740 || (c < 768
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)))))))
            : (c <= 895 || (c < 1471
              ? (c < 1155
                ? (c < 910
                  ? (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)
                  : (c <= 929 || (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)))
                : (c <= 1159 || (c < 1369
                  ? (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)
                  : (c <= 1369 || (c < 1425
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1469)))))
              : (c <= 1471 || (c < 1552
                ? (c < 1479
                  ? (c < 1476
                    ? (c >= 1473 && c <= 1474)
                    : c <= 1477)
                  : (c <= 1479 || (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)))
                : (c <= 1562 || (c < 1749
                  ? (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)
                  : (c <= 1756 || (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : c <= 1788)))))))))
          : (c <= 1791 || (c < 2519
            ? (c < 2275
              ? (c < 2048
                ? (c < 1984
                  ? (c < 1869
                    ? (c >= 1808 && c <= 1866)
                    : c <= 1969)
                  : (c <= 2037 || (c < 2045
                    ? c == 2042
                    : c <= 2045)))
                : (c <= 2093 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2139)
                    : c <= 2154)
                  : (c <= 2183 || (c < 2200
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2273)))))
              : (c <= 2403 || (c < 2474
                ? (c < 2437
                  ? (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)
                  : (c <= 2444 || (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)))
                : (c <= 2480 || (c < 2492
                  ? (c < 2486
                    ? c == 2482
                    : c <= 2489)
                  : (c <= 2500 || (c < 2507
                    ? (c >= 2503 && c <= 2504)
                    : c <= 2510)))))))
            : (c <= 2519 || (c < 2613
              ? (c < 2561
                ? (c < 2534
                  ? (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2531)
                  : (c <= 2545 || (c < 2558
                    ? c == 2556
                    : c <= 2558)))
                : (c <= 2563 || (c < 2579
                  ? (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)
                  : (c <= 2600 || (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)))))
              : (c <= 2614 || (c < 2641
                ? (c < 2622
                  ? (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)
                  : (c <= 2626 || (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)))
                : (c <= 2641 || (c < 2662
                  ? (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)
                  : (c <= 2677 || (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)))))))))))
        : (c <= 2705 || (c < 3142
          ? (c < 2911
            ? (c < 2817
              ? (c < 2759
                ? (c < 2738
                  ? (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)
                  : (c <= 2739 || (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)))
                : (c <= 2761 || (c < 2784
                  ? (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : c <= 2768)
                  : (c <= 2787 || (c < 2809
                    ? (c >= 2790 && c <= 2799)
                    : c <= 2815)))))
              : (c <= 2819 || (c < 2869
                ? (c < 2835
                  ? (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)
                  : (c <= 2856 || (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)))
                : (c <= 2873 || (c < 2891
                  ? (c < 2887
                    ? (c >= 2876 && c <= 2884)
                    : c <= 2888)
                  : (c <= 2893 || (c < 2908
                    ? (c >= 2901 && c <= 2903)
                    : c <= 2909)))))))
            : (c <= 2915 || (c < 2990
              ? (c < 2962
                ? (c < 2946
                  ? (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : c <= 2929)
                  : (c <= 2947 || (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)))
                : (c <= 2965 || (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)))))
              : (c <= 3001 || (c < 3046
                ? (c < 3018
                  ? (c < 3014
                    ? (c >= 3006 && c <= 3010)
                    : c <= 3016)
                  : (c <= 3021 || (c < 3031
                    ? c == 3024
                    : c <= 3031)))
                : (c <= 3055 || (c < 3090
                  ? (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : c <= 3088)
                  : (c <= 3112 || (c < 3132
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3140)))))))))
          : (c <= 3144 || (c < 3398
            ? (c < 3253
              ? (c < 3174
                ? (c < 3160
                  ? (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)
                  : (c <= 3162 || (c < 3168
                    ? c == 3165
                    : c <= 3171)))
                : (c <= 3183 || (c < 3214
                  ? (c < 3205
                    ? (c >= 3200 && c <= 3203)
                    : c <= 3212)
                  : (c <= 3216 || (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)))))
              : (c <= 3257 || (c < 3296
                ? (c < 3274
                  ? (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)
                  : (c <= 3277 || (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : c <= 3294)))
                : (c <= 3299 || (c < 3328
                  ? (c < 3313
                    ? (c >= 3302 && c <= 3311)
                    : c <= 3314)
                  : (c <= 3340 || (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3396)))))))
            : (c <= 3400 || (c < 3530
              ? (c < 3457
                ? (c < 3423
                  ? (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)
                  : (c <= 3427 || (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)))
                : (c <= 3459 || (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || (c < 3520
                    ? c == 3517
                    : c <= 3526)))))
              : (c <= 3530 || (c < 3585
                ? (c < 3544
                  ? (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)
                  : (c <= 3551 || (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)))
                : (c <= 3642 || (c < 3713
                  ? (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)
                  : (c <= 3714 || (c < 3718
                    ? c == 3716
                    : c <= 3722)))))))))))))
      : (c <= 3747 || (c < 7960
        ? (c < 5743
          ? (c < 4301
            ? (c < 3895
              ? (c < 3792
                ? (c < 3776
                  ? (c < 3751
                    ? c == 3749
                    : c <= 3773)
                  : (c <= 3780 || (c < 3784
                    ? c == 3782
                    : c <= 3789)))
                : (c <= 3801 || (c < 3864
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3865 || (c < 3893
                    ? (c >= 3872 && c <= 3881)
                    : c <= 3893)))))
              : (c <= 3895 || (c < 3993
                ? (c < 3913
                  ? (c < 3902
                    ? c == 3897
                    : c <= 3911)
                  : (c <= 3948 || (c < 3974
                    ? (c >= 3953 && c <= 3972)
                    : c <= 3991)))
                : (c <= 4028 || (c < 4176
                  ? (c < 4096
                    ? c == 4038
                    : c <= 4169)
                  : (c <= 4253 || (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)))))))
            : (c <= 4301 || (c < 4800
              ? (c < 4698
                ? (c < 4682
                  ? (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)
                  : (c <= 4685 || (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : c <= 4696)))
                : (c <= 4701 || (c < 4752
                  ? (c < 4746
                    ? (c >= 4704 && c <= 4744)
                    : c <= 4749)
                  : (c <= 4784 || (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)))))
              : (c <= 4800 || (c < 4957
                ? (c < 4824
                  ? (c < 4808
                    ? (c >= 4802 && c <= 4805)
                    : c <= 4822)
                  : (c <= 4880 || (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)))
                : (c <= 4959 || (c < 5024
                  ? (c < 4992
                    ? (c >= 4969 && c <= 4977)
                    : c <= 5007)
                  : (c <= 5109 || (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)))))))))
          : (c <= 5759 || (c < 6528
            ? (c < 6108
              ? (c < 5952
                ? (c < 5870
                  ? (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)
                  : (c <= 5880 || (c < 5919
                    ? (c >= 5888 && c <= 5909)
                    : c <= 5940)))
                : (c <= 5971 || (c < 6002
                  ? (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)
                  : (c <= 6003 || (c < 6103
                    ? (c >= 6016 && c <= 6099)
                    : c <= 6103)))))
              : (c <= 6109 || (c < 6320
                ? (c < 6159
                  ? (c < 6155
                    ? (c >= 6112 && c <= 6121)
                    : c <= 6157)
                  : (c <= 6169 || (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6314)))
                : (c <= 6389 || (c < 6448
                  ? (c < 6432
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6443)
                  : (c <= 6459 || (c < 6512
                    ? (c >= 6470 && c <= 6509)
                    : c <= 6516)))))))
            : (c <= 6571 || (c < 6992
              ? (c < 6783
                ? (c < 6656
                  ? (c < 6608
                    ? (c >= 6576 && c <= 6601)
                    : c <= 6618)
                  : (c <= 6683 || (c < 6752
                    ? (c >= 6688 && c <= 6750)
                    : c <= 6780)))
                : (c <= 6793 || (c < 6832
                  ? (c < 6823
                    ? (c >= 6800 && c <= 6809)
                    : c <= 6823)
                  : (c <= 6845 || (c < 6912
                    ? (c >= 6847 && c <= 6862)
                    : c <= 6988)))))
              : (c <= 7001 || (c < 7296
                ? (c < 7168
                  ? (c < 7040
                    ? (c >= 7019 && c <= 7027)
                    : c <= 7155)
                  : (c <= 7223 || (c < 7245
                    ? (c >= 7232 && c <= 7241)
                    : c <= 7293)))
                : (c <= 7304 || (c < 7376
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)
                  : (c <= 7378 || (c < 7424
                    ? (c >= 7380 && c <= 7418)
                    : c <= 7957)))))))))))
        : (c <= 7965 || (c < 11688
          ? (c < 8417
            ? (c < 8134
              ? (c < 8029
                ? (c < 8016
                  ? (c < 8008
                    ? (c >= 7968 && c <= 8005)
                    : c <= 8013)
                  : (c <= 8023 || (c < 8027
                    ? c == 8025
                    : c <= 8027)))
                : (c <= 8029 || (c < 8118
                  ? (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)
                  : (c <= 8124 || (c < 8130
                    ? c == 8126
                    : c <= 8132)))))
              : (c <= 8140 || (c < 8255
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8256 || (c < 8319
                  ? (c < 8305
                    ? c == 8276
                    : c <= 8305)
                  : (c <= 8319 || (c < 8400
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8412)))))))
            : (c <= 8417 || (c < 8517
              ? (c < 8472
                ? (c < 8455
                  ? (c < 8450
                    ? (c >= 8421 && c <= 8432)
                    : c <= 8450)
                  : (c <= 8455 || (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)))
                : (c <= 8477 || (c < 8488
                  ? (c < 8486
                    ? c == 8484
                    : c <= 8486)
                  : (c <= 8488 || (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)))))
              : (c <= 8521 || (c < 11559
                ? (c < 11264
                  ? (c < 8544
                    ? c == 8526
                    : c <= 8584)
                  : (c <= 11492 || (c < 11520
                    ? (c >= 11499 && c <= 11507)
                    : c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c < 11680
                    ? (c >= 11647 && c <= 11670)
                    : c <= 11686)))))))))
          : (c <= 11694 || (c < 42240
            ? (c < 12353
              ? (c < 11736
                ? (c < 11712
                  ? (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)
                  : (c <= 11718 || (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)))
                : (c <= 11742 || (c < 12321
                  ? (c < 12293
                    ? (c >= 11744 && c <= 11775)
                    : c <= 12295)
                  : (c <= 12335 || (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)))))
              : (c <= 12438 || (c < 12593
                ? (c < 12449
                  ? (c < 12445
                    ? (c >= 12441 && c <= 12442)
                    : c <= 12447)
                  : (c <= 12538 || (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)))
                : (c <= 12686 || (c < 13312
                  ? (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)
                  : (c <= 19903 || (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)))))))
            : (c <= 42508 || (c < 43052
              ? (c < 42786
                ? (c < 42612
                  ? (c < 42560
                    ? (c >= 42512 && c <= 42539)
                    : c <= 42607)
                  : (c <= 42621 || (c < 42775
                    ? (c >= 42623 && c <= 42737)
                    : c <= 42783)))
                : (c <= 42888 || (c < 42963
                  ? (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)
                  : (c <= 42963 || (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43047)))))
              : (c <= 43052 || (c < 43261
                ? (c < 43216
                  ? (c < 43136
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43205)
                  : (c <= 43225 || (c < 43259
                    ? (c >= 43232 && c <= 43255)
                    : c <= 43259)))
                : (c <= 43309 || (c < 43392
                  ? (c < 43360
                    ? (c >= 43312 && c <= 43347)
                    : c <= 43388)
                  : (c <= 43456 || (c < 43488
                    ? (c >= 43471 && c <= 43481)
                    : c <= 43518)))))))))))))))
    : (c <= 43574 || (c < 71424
      ? (c < 67592
        ? (c < 65313
          ? (c < 64285
            ? (c < 43824
              ? (c < 43762
                ? (c < 43642
                  ? (c < 43600
                    ? (c >= 43584 && c <= 43597)
                    : (c <= 43609 || (c >= 43616 && c <= 43638)))
                  : (c <= 43714 || (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43759)))
                : (c <= 43766 || (c < 43793
                  ? (c < 43785
                    ? (c >= 43777 && c <= 43782)
                    : c <= 43790)
                  : (c <= 43798 || (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)))))
              : (c <= 43866 || (c < 55216
                ? (c < 44012
                  ? (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44010)
                  : (c <= 44013 || (c < 44032
                    ? (c >= 44016 && c <= 44025)
                    : c <= 55203)))
                : (c <= 55238 || (c < 64112
                  ? (c < 63744
                    ? (c >= 55243 && c <= 55291)
                    : c <= 64109)
                  : (c <= 64217 || (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)))))))
            : (c <= 64296 || (c < 65024
              ? (c < 64326
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : c <= 64324)))
                : (c <= 64433 || (c < 64848
                  ? (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)
                  : (c <= 64911 || (c < 65008
                    ? (c >= 64914 && c <= 64967)
                    : c <= 65017)))))
              : (c <= 65039 || (c < 65143
                ? (c < 65101
                  ? (c < 65075
                    ? (c >= 65056 && c <= 65071)
                    : c <= 65076)
                  : (c <= 65103 || (c < 65139
                    ? c == 65137
                    : c <= 65139)))
                : (c <= 65143 || (c < 65149
                  ? (c < 65147
                    ? c == 65145
                    : c <= 65147)
                  : (c <= 65149 || (c < 65296
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65305)))))))))
          : (c <= 65338 || (c < 66464
            ? (c < 65599
              ? (c < 65490
                ? (c < 65382
                  ? (c < 65345
                    ? c == 65343
                    : c <= 65370)
                  : (c <= 65470 || (c < 65482
                    ? (c >= 65474 && c <= 65479)
                    : c <= 65487)))
                : (c <= 65495 || (c < 65549
                  ? (c < 65536
                    ? (c >= 65498 && c <= 65500)
                    : c <= 65547)
                  : (c <= 65574 || (c < 65596
                    ? (c >= 65576 && c <= 65594)
                    : c <= 65597)))))
              : (c <= 65613 || (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c < 66176
                    ? c == 66045
                    : c <= 66204)))
                : (c <= 66256 || (c < 66349
                  ? (c < 66304
                    ? c == 66272
                    : c <= 66335)
                  : (c <= 66378 || (c < 66432
                    ? (c >= 66384 && c <= 66426)
                    : c <= 66461)))))))
            : (c <= 66499 || (c < 66964
              ? (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c < 66736
                    ? (c >= 66720 && c <= 66729)
                    : c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c < 66956
                    ? (c >= 66940 && c <= 66954)
                    : c <= 66962)))))
              : (c <= 66965 || (c < 67392
                ? (c < 66995
                  ? (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)
                  : (c <= 67001 || (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)))
                : (c <= 67413 || (c < 67463
                  ? (c < 67456
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67461)
                  : (c <= 67504 || (c < 67584
                    ? (c >= 67506 && c <= 67514)
                    : c <= 67589)))))))))))
        : (c <= 67592 || (c < 69888
          ? (c < 68352
            ? (c < 68030
              ? (c < 67712
                ? (c < 67644
                  ? (c < 67639
                    ? (c >= 67594 && c <= 67637)
                    : c <= 67640)
                  : (c <= 67644 || (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)))
                : (c <= 67742 || (c < 67840
                  ? (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)
                  : (c <= 67861 || (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)))))
              : (c <= 68031 || (c < 68152
                ? (c < 68108
                  ? (c < 68101
                    ? (c >= 68096 && c <= 68099)
                    : c <= 68102)
                  : (c <= 68115 || (c < 68121
                    ? (c >= 68117 && c <= 68119)
                    : c <= 68149)))
                : (c <= 68154 || (c < 68224
                  ? (c < 68192
                    ? c == 68159
                    : c <= 68220)
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)))))))
            : (c <= 68405 || (c < 69376
              ? (c < 68800
                ? (c < 68480
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : c <= 68466)
                  : (c <= 68497 || (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)))
                : (c <= 68850 || (c < 69248
                  ? (c < 68912
                    ? (c >= 68864 && c <= 68903)
                    : c <= 68921)
                  : (c <= 69289 || (c < 69296
                    ? (c >= 69291 && c <= 69292)
                    : c <= 69297)))))
              : (c <= 69404 || (c < 69632
                ? (c < 69488
                  ? (c < 69424
                    ? c == 69415
                    : c <= 69456)
                  : (c <= 69509 || (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)))
                : (c <= 69702 || (c < 69826
                  ? (c < 69759
                    ? (c >= 69734 && c <= 69749)
                    : c <= 69818)
                  : (c <= 69826 || (c < 69872
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69881)))))))))
          : (c <= 69940 || (c < 70450
            ? (c < 70272
              ? (c < 70089
                ? (c < 69968
                  ? (c < 69956
                    ? (c >= 69942 && c <= 69951)
                    : c <= 69959)
                  : (c <= 70003 || (c < 70016
                    ? c == 70006
                    : c <= 70084)))
                : (c <= 70092 || (c < 70144
                  ? (c < 70108
                    ? (c >= 70094 && c <= 70106)
                    : c <= 70108)
                  : (c <= 70161 || (c < 70206
                    ? (c >= 70163 && c <= 70199)
                    : c <= 70206)))))
              : (c <= 70278 || (c < 70384
                ? (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70378)))
                : (c <= 70393 || (c < 70415
                  ? (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : c <= 70412)
                  : (c <= 70416 || (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)))))))
            : (c <= 70451 || (c < 70750
              ? (c < 70487
                ? (c < 70471
                  ? (c < 70459
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70468)
                  : (c <= 70472 || (c < 70480
                    ? (c >= 70475 && c <= 70477)
                    : c <= 70480)))
                : (c <= 70487 || (c < 70512
                  ? (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)
                  : (c <= 70516 || (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : c <= 70745)))))
              : (c <= 70753 || (c < 71128
                ? (c < 70864
                  ? (c < 70855
                    ? (c >= 70784 && c <= 70853)
                    : c <= 70855)
                  : (c <= 70873 || (c < 71096
                    ? (c >= 71040 && c <= 71093)
                    : c <= 71104)))
                : (c <= 71133 || (c < 71248
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71232)
                    : c <= 71236)
                  : (c <= 71257 || (c < 71360
                    ? (c >= 71296 && c <= 71352)
                    : c <= 71369)))))))))))))
      : (c <= 71450 || (c < 119970
        ? (c < 77712
          ? (c < 72714
            ? (c < 71995
              ? (c < 71935
                ? (c < 71488
                  ? (c < 71472
                    ? (c >= 71453 && c <= 71467)
                    : c <= 71481)
                  : (c <= 71494 || (c < 71840
                    ? (c >= 71680 && c <= 71738)
                    : c <= 71913)))
                : (c <= 71942 || (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c < 71991
                    ? (c >= 71960 && c <= 71989)
                    : c <= 71992)))))
              : (c <= 72003 || (c < 72192
                ? (c < 72106
                  ? (c < 72096
                    ? (c >= 72016 && c <= 72025)
                    : c <= 72103)
                  : (c <= 72151 || (c < 72163
                    ? (c >= 72154 && c <= 72161)
                    : c <= 72164)))
                : (c <= 72254 || (c < 72349
                  ? (c < 72272
                    ? c == 72263
                    : c <= 72345)
                  : (c <= 72349 || (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)))))))
            : (c <= 72758 || (c < 73040
              ? (c < 72960
                ? (c < 72818
                  ? (c < 72784
                    ? (c >= 72760 && c <= 72768)
                    : c <= 72793)
                  : (c <= 72847 || (c < 72873
                    ? (c >= 72850 && c <= 72871)
                    : c <= 72886)))
                : (c <= 72966 || (c < 73018
                  ? (c < 72971
                    ? (c >= 72968 && c <= 72969)
                    : c <= 73014)
                  : (c <= 73018 || (c < 73023
                    ? (c >= 73020 && c <= 73021)
                    : c <= 73031)))))
              : (c <= 73049 || (c < 73120
                ? (c < 73066
                  ? (c < 73063
                    ? (c >= 73056 && c <= 73061)
                    : c <= 73064)
                  : (c <= 73102 || (c < 73107
                    ? (c >= 73104 && c <= 73105)
                    : c <= 73112)))
                : (c <= 73129 || (c < 73728
                  ? (c < 73648
                    ? (c >= 73440 && c <= 73462)
                    : c <= 73648)
                  : (c <= 74649 || (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)))))))))
          : (c <= 77808 || (c < 101632
            ? (c < 93008
              ? (c < 92784
                ? (c < 92160
                  ? (c < 82944
                    ? (c >= 77824 && c <= 78894)
                    : c <= 83526)
                  : (c <= 92728 || (c < 92768
                    ? (c >= 92736 && c <= 92766)
                    : c <= 92777)))
                : (c <= 92862 || (c < 92912
                  ? (c < 92880
                    ? (c >= 92864 && c <= 92873)
                    : c <= 92909)
                  : (c <= 92916 || (c < 92992
                    ? (c >= 92928 && c <= 92982)
                    : c <= 92995)))))
              : (c <= 93017 || (c < 94095
                ? (c < 93760
                  ? (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)
                  : (c <= 93823 || (c < 94031
                    ? (c >= 93952 && c <= 94026)
                    : c <= 94087)))
                : (c <= 94111 || (c < 94192
                  ? (c < 94179
                    ? (c >= 94176 && c <= 94177)
                    : c <= 94180)
                  : (c <= 94193 || (c < 100352
                    ? (c >= 94208 && c <= 100343)
                    : c <= 101589)))))))
            : (c <= 101640 || (c < 113821
              ? (c < 110948
                ? (c < 110589
                  ? (c < 110581
                    ? (c >= 110576 && c <= 110579)
                    : c <= 110587)
                  : (c <= 110590 || (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)))
                : (c <= 110951 || (c < 113776
                  ? (c < 113664
                    ? (c >= 110960 && c <= 111355)
                    : c <= 113770)
                  : (c <= 113788 || (c < 113808
                    ? (c >= 113792 && c <= 113800)
                    : c <= 113817)))))
              : (c <= 113822 || (c < 119173
                ? (c < 119141
                  ? (c < 118576
                    ? (c >= 118528 && c <= 118573)
                    : c <= 118598)
                  : (c <= 119145 || (c < 119163
                    ? (c >= 119149 && c <= 119154)
                    : c <= 119170)))
                : (c <= 119179 || (c < 119808
                  ? (c < 119362
                    ? (c >= 119210 && c <= 119213)
                    : c <= 119364)
                  : (c <= 119892 || (c < 119966
                    ? (c >= 119894 && c <= 119964)
                    : c <= 119967)))))))))))
        : (c <= 119970 || (c < 124909
          ? (c < 120714
            ? (c < 120128
              ? (c < 120005
                ? (c < 119982
                  ? (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)
                  : (c <= 119993 || (c < 119997
                    ? c == 119995
                    : c <= 120003)))
                : (c <= 120069 || (c < 120086
                  ? (c < 120077
                    ? (c >= 120071 && c <= 120074)
                    : c <= 120084)
                  : (c <= 120092 || (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)))))
              : (c <= 120132 || (c < 120540
                ? (c < 120146
                  ? (c < 120138
                    ? c == 120134
                    : c <= 120144)
                  : (c <= 120485 || (c < 120514
                    ? (c >= 120488 && c <= 120512)
                    : c <= 120538)))
                : (c <= 120570 || (c < 120630
                  ? (c < 120598
                    ? (c >= 120572 && c <= 120596)
                    : c <= 120628)
                  : (c <= 120654 || (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)))))))
            : (c <= 120744 || (c < 122888
              ? (c < 121461
                ? (c < 120782
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 120831 || (c < 121403
                    ? (c >= 121344 && c <= 121398)
                    : c <= 121452)))
                : (c <= 121461 || (c < 121505
                  ? (c < 121499
                    ? c == 121476
                    : c <= 121503)
                  : (c <= 121519 || (c < 122880
                    ? (c >= 122624 && c <= 122654)
                    : c <= 122886)))))
              : (c <= 122904 || (c < 123200
                ? (c < 122918
                  ? (c < 122915
                    ? (c >= 122907 && c <= 122913)
                    : c <= 122916)
                  : (c <= 122922 || (c < 123184
                    ? (c >= 123136 && c <= 123180)
                    : c <= 123197)))
                : (c <= 123209 || (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123566)
                  : (c <= 123641 || (c < 124904
                    ? (c >= 124896 && c <= 124902)
                    : c <= 124907)))))))))
          : (c <= 124910 || (c < 126555
            ? (c < 126516
              ? (c < 126464
                ? (c < 125136
                  ? (c < 124928
                    ? (c >= 124912 && c <= 124926)
                    : c <= 125124)
                  : (c <= 125142 || (c < 125264
                    ? (c >= 125184 && c <= 125259)
                    : c <= 125273)))
                : (c <= 126467 || (c < 126500
                  ? (c < 126497
                    ? (c >= 126469 && c <= 126495)
                    : c <= 126498)
                  : (c <= 126500 || (c < 126505
                    ? c == 126503
                    : c <= 126514)))))
              : (c <= 126519 || (c < 126539
                ? (c < 126530
                  ? (c < 126523
                    ? c == 126521
                    : c <= 126523)
                  : (c <= 126530 || (c < 126537
                    ? c == 126535
                    : c <= 126537)))
                : (c <= 126539 || (c < 126548
                  ? (c < 126545
                    ? (c >= 126541 && c <= 126543)
                    : c <= 126546)
                  : (c <= 126548 || (c < 126553
                    ? c == 126551
                    : c <= 126553)))))))
            : (c <= 126555 || (c < 126625
              ? (c < 126572
                ? (c < 126561
                  ? (c < 126559
                    ? c == 126557
                    : c <= 126559)
                  : (c <= 126562 || (c < 126567
                    ? c == 126564
                    : c <= 126570)))
                : (c <= 126578 || (c < 126590
                  ? (c < 126585
                    ? (c >= 126580 && c <= 126583)
                    : c <= 126588)
                  : (c <= 126590 || (c < 126603
                    ? (c >= 126592 && c <= 126601)
                    : c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 130032
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 130041 || (c < 173824
                    ? (c >= 131072 && c <= 173791)
                    : c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c < 917760
                    ? (c >= 196608 && c <= 201546)
                    : c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_10(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2741
        ? (c < 2042
          ? (c < 931
            ? (c < 248
              ? (c < 170
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '$'
                    : c <= '9')
                  : (c <= 'Z' || (c < 'a'
                    ? c == '_'
                    : c <= 'z')))
                : (c <= 170 || (c < 186
                  ? (c < 183
                    ? c == 181
                    : c <= 183)
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))))
              : (c <= 705 || (c < 886
                ? (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || (c < 768
                    ? c == 750
                    : c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))))))
            : (c <= 1013 || (c < 1488
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1473
                  ? (c < 1471
                    ? (c >= 1425 && c <= 1469)
                    : c <= 1471)
                  : (c <= 1474 || (c < 1479
                    ? (c >= 1476 && c <= 1477)
                    : c <= 1479)))))
              : (c <= 1514 || (c < 1759
                ? (c < 1568
                  ? (c < 1552
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1562)
                  : (c <= 1641 || (c < 1749
                    ? (c >= 1646 && c <= 1747)
                    : c <= 1756)))
                : (c <= 1768 || (c < 1808
                  ? (c < 1791
                    ? (c >= 1770 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))))))))
          : (c <= 2042 || (c < 2556
            ? (c < 2447
              ? (c < 2185
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)))
                : (c <= 2190 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2200 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c < 2534
                    ? (c >= 2527 && c <= 2531)
                    : c <= 2545)))))))
            : (c <= 2556 || (c < 2631
              ? (c < 2602
                ? (c < 2565
                  ? (c < 2561
                    ? c == 2558
                    : c <= 2563)
                  : (c <= 2570 || (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))
              : (c <= 2632 || (c < 2689
                ? (c < 2649
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : c <= 2641)
                  : (c <= 2652 || (c < 2662
                    ? c == 2654
                    : c <= 2677)))
                : (c <= 2691 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)))))))))))
        : (c <= 2745 || (c < 3165
          ? (c < 2949
            ? (c < 2858
              ? (c < 2790
                ? (c < 2763
                  ? (c < 2759
                    ? (c >= 2748 && c <= 2757)
                    : c <= 2761)
                  : (c <= 2765 || (c < 2784
                    ? c == 2768
                    : c <= 2787)))
                : (c <= 2799 || (c < 2821
                  ? (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)
                  : (c <= 2828 || (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)))))
              : (c <= 2864 || (c < 2901
                ? (c < 2876
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2884 || (c < 2891
                    ? (c >= 2887 && c <= 2888)
                    : c <= 2893)))
                : (c <= 2903 || (c < 2918
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2915)
                  : (c <= 2927 || (c < 2946
                    ? c == 2929
                    : c <= 2947)))))))
            : (c <= 2954 || (c < 3024
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3006
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3010 || (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)))))
              : (c <= 3024 || (c < 3114
                ? (c < 3072
                  ? (c < 3046
                    ? c == 3031
                    : c <= 3055)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))
                : (c <= 3129 || (c < 3146
                  ? (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)
                  : (c <= 3149 || (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : c <= 3162)))))))))
          : (c <= 3165 || (c < 3430
            ? (c < 3285
              ? (c < 3218
                ? (c < 3200
                  ? (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)
                  : (c <= 3203 || (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)))
                : (c <= 3240 || (c < 3260
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3268 || (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)))))
              : (c <= 3286 || (c < 3342
                ? (c < 3302
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3299)
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3402
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : c <= 3400)
                  : (c <= 3406 || (c < 3423
                    ? (c >= 3412 && c <= 3415)
                    : c <= 3427)))))))
            : (c <= 3439 || (c < 3558
              ? (c < 3517
                ? (c < 3461
                  ? (c < 3457
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3459)
                  : (c <= 3478 || (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)))
                : (c <= 3517 || (c < 3535
                  ? (c < 3530
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3530)
                  : (c <= 3540 || (c < 3544
                    ? c == 3542
                    : c <= 3551)))))
              : (c <= 3567 || (c < 3716
                ? (c < 3648
                  ? (c < 3585
                    ? (c >= 3570 && c <= 3571)
                    : c <= 3642)
                  : (c <= 3662 || (c < 3713
                    ? (c >= 3664 && c <= 3673)
                    : c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c < 3776
                    ? (c >= 3751 && c <= 3773)
                    : c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_11(int32_t c) {
  return (c < 43600
    ? (c < 3776
      ? (c < 2738
        ? (c < 1984
          ? (c < 910
            ? (c < 216
              ? (c < 'a'
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '$'
                    : c <= '9')
                  : (c <= 'Q' || (c < '_'
                    ? (c >= 'S' && c <= 'Z')
                    : c <= '_')))
                : (c <= 'z' || (c < 183
                  ? (c < 181
                    ? c == 170
                    : c <= 181)
                  : (c <= 183 || (c < 192
                    ? c == 186
                    : c <= 214)))))
              : (c <= 246 || (c < 768
                ? (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || (c < 750
                    ? c == 748
                    : c <= 750)))
                : (c <= 884 || (c < 895
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)))))))
            : (c <= 929 || (c < 1479
              ? (c < 1369
                ? (c < 1155
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1159 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))
                : (c <= 1369 || (c < 1471
                  ? (c < 1425
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1469)
                  : (c <= 1471 || (c < 1476
                    ? (c >= 1473 && c <= 1474)
                    : c <= 1477)))))
              : (c <= 1479 || (c < 1749
                ? (c < 1552
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1562 || (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)))
                : (c <= 1756 || (c < 1791
                  ? (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : c <= 1788)
                  : (c <= 1791 || (c < 1869
                    ? (c >= 1808 && c <= 1866)
                    : c <= 1969)))))))))
          : (c <= 2037 || (c < 2534
            ? (c < 2437
              ? (c < 2160
                ? (c < 2048
                  ? (c < 2045
                    ? c == 2042
                    : c <= 2045)
                  : (c <= 2093 || (c < 2144
                    ? (c >= 2112 && c <= 2139)
                    : c <= 2154)))
                : (c <= 2183 || (c < 2275
                  ? (c < 2200
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2273)
                  : (c <= 2403 || (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)))))
              : (c <= 2444 || (c < 2492
                ? (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || (c < 2486
                    ? c == 2482
                    : c <= 2489)))
                : (c <= 2500 || (c < 2519
                  ? (c < 2507
                    ? (c >= 2503 && c <= 2504)
                    : c <= 2510)
                  : (c <= 2519 || (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2531)))))))
            : (c <= 2545 || (c < 2622
              ? (c < 2579
                ? (c < 2561
                  ? (c < 2558
                    ? c == 2556
                    : c <= 2558)
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)))))
              : (c <= 2626 || (c < 2662
                ? (c < 2641
                  ? (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)
                  : (c <= 2641 || (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)))
                : (c <= 2677 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)
                  : (c <= 2705 || (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)))))))))))
        : (c <= 2739 || (c < 3160
          ? (c < 2946
            ? (c < 2835
              ? (c < 2784
                ? (c < 2759
                  ? (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)
                  : (c <= 2761 || (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : c <= 2768)))
                : (c <= 2787 || (c < 2817
                  ? (c < 2809
                    ? (c >= 2790 && c <= 2799)
                    : c <= 2815)
                  : (c <= 2819 || (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)))))
              : (c <= 2856 || (c < 2891
                ? (c < 2869
                  ? (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)
                  : (c <= 2873 || (c < 2887
                    ? (c >= 2876 && c <= 2884)
                    : c <= 2888)))
                : (c <= 2893 || (c < 2911
                  ? (c < 2908
                    ? (c >= 2901 && c <= 2903)
                    : c <= 2909)
                  : (c <= 2915 || (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : c <= 2929)))))))
            : (c <= 2947 || (c < 3018
              ? (c < 2974
                ? (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)))
                : (c <= 2975 || (c < 2990
                  ? (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)
                  : (c <= 3001 || (c < 3014
                    ? (c >= 3006 && c <= 3010)
                    : c <= 3016)))))
              : (c <= 3021 || (c < 3090
                ? (c < 3046
                  ? (c < 3031
                    ? c == 3024
                    : c <= 3031)
                  : (c <= 3055 || (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : c <= 3088)))
                : (c <= 3112 || (c < 3142
                  ? (c < 3132
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3140)
                  : (c <= 3144 || (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)))))))))
          : (c <= 3162 || (c < 3423
            ? (c < 3274
              ? (c < 3214
                ? (c < 3174
                  ? (c < 3168
                    ? c == 3165
                    : c <= 3171)
                  : (c <= 3183 || (c < 3205
                    ? (c >= 3200 && c <= 3203)
                    : c <= 3212)))
                : (c <= 3216 || (c < 3253
                  ? (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)
                  : (c <= 3257 || (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)))))
              : (c <= 3277 || (c < 3328
                ? (c < 3296
                  ? (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : c <= 3294)
                  : (c <= 3299 || (c < 3313
                    ? (c >= 3302 && c <= 3311)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3398
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3396)
                  : (c <= 3400 || (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)))))))
            : (c <= 3427 || (c < 3544
              ? (c < 3507
                ? (c < 3457
                  ? (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)
                  : (c <= 3459 || (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)))
                : (c <= 3515 || (c < 3530
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3530 || (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)))))
              : (c <= 3551 || (c < 3713
                ? (c < 3585
                  ? (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)
                  : (c <= 3642 || (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)))
                : (c <= 3714 || (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || (c < 3751
                    ? c == 3749
                    : c <= 3773)))))))))))))
      : (c <= 3780 || (c < 8016
        ? (c < 5870
          ? (c < 4682
            ? (c < 3913
              ? (c < 3864
                ? (c < 3792
                  ? (c < 3784
                    ? c == 3782
                    : c <= 3789)
                  : (c <= 3801 || (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)))
                : (c <= 3865 || (c < 3895
                  ? (c < 3893
                    ? (c >= 3872 && c <= 3881)
                    : c <= 3893)
                  : (c <= 3895 || (c < 3902
                    ? c == 3897
                    : c <= 3911)))))
              : (c <= 3948 || (c < 4176
                ? (c < 3993
                  ? (c < 3974
                    ? (c >= 3953 && c <= 3972)
                    : c <= 3991)
                  : (c <= 4028 || (c < 4096
                    ? c == 4038
                    : c <= 4169)))
                : (c <= 4253 || (c < 4301
                  ? (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)
                  : (c <= 4301 || (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)))))))
            : (c <= 4685 || (c < 4824
              ? (c < 4752
                ? (c < 4698
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : c <= 4696)
                  : (c <= 4701 || (c < 4746
                    ? (c >= 4704 && c <= 4744)
                    : c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c < 4808
                    ? (c >= 4802 && c <= 4805)
                    : c <= 4822)))))
              : (c <= 4880 || (c < 5024
                ? (c < 4957
                  ? (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)
                  : (c <= 4959 || (c < 4992
                    ? (c >= 4969 && c <= 4977)
                    : c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)))))))))
          : (c <= 5880 || (c < 6656
            ? (c < 6159
              ? (c < 6002
                ? (c < 5952
                  ? (c < 5919
                    ? (c >= 5888 && c <= 5909)
                    : c <= 5940)
                  : (c <= 5971 || (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)))
                : (c <= 6003 || (c < 6108
                  ? (c < 6103
                    ? (c >= 6016 && c <= 6099)
                    : c <= 6103)
                  : (c <= 6109 || (c < 6155
                    ? (c >= 6112 && c <= 6121)
                    : c <= 6157)))))
              : (c <= 6169 || (c < 6448
                ? (c < 6320
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6432
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6443)))
                : (c <= 6459 || (c < 6528
                  ? (c < 6512
                    ? (c >= 6470 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c < 6608
                    ? (c >= 6576 && c <= 6601)
                    : c <= 6618)))))))
            : (c <= 6683 || (c < 7168
              ? (c < 6832
                ? (c < 6783
                  ? (c < 6752
                    ? (c >= 6688 && c <= 6750)
                    : c <= 6780)
                  : (c <= 6793 || (c < 6823
                    ? (c >= 6800 && c <= 6809)
                    : c <= 6823)))
                : (c <= 6845 || (c < 6992
                  ? (c < 6912
                    ? (c >= 6847 && c <= 6862)
                    : c <= 6988)
                  : (c <= 7001 || (c < 7040
                    ? (c >= 7019 && c <= 7027)
                    : c <= 7155)))))
              : (c <= 7223 || (c < 7376
                ? (c < 7296
                  ? (c < 7245
                    ? (c >= 7232 && c <= 7241)
                    : c <= 7293)
                  : (c <= 7304 || (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)))
                : (c <= 7378 || (c < 7960
                  ? (c < 7424
                    ? (c >= 7380 && c <= 7418)
                    : c <= 7957)
                  : (c <= 7965 || (c < 8008
                    ? (c >= 7968 && c <= 8005)
                    : c <= 8013)))))))))))
        : (c <= 8023 || (c < 11712
          ? (c < 8455
            ? (c < 8160
              ? (c < 8118
                ? (c < 8029
                  ? (c < 8027
                    ? c == 8025
                    : c <= 8027)
                  : (c <= 8029 || (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)))
                : (c <= 8124 || (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)))))
              : (c <= 8172 || (c < 8319
                ? (c < 8255
                  ? (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)
                  : (c <= 8256 || (c < 8305
                    ? c == 8276
                    : c <= 8305)))
                : (c <= 8319 || (c < 8417
                  ? (c < 8400
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8412)
                  : (c <= 8417 || (c < 8450
                    ? (c >= 8421 && c <= 8432)
                    : c <= 8450)))))))
            : (c <= 8455 || (c < 11264
              ? (c < 8488
                ? (c < 8472
                  ? (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)
                  : (c <= 8477 || (c < 8486
                    ? c == 8484
                    : c <= 8486)))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || (c < 8544
                    ? c == 8526
                    : c <= 8584)))))
              : (c <= 11492 || (c < 11631
                ? (c < 11559
                  ? (c < 11520
                    ? (c >= 11499 && c <= 11507)
                    : c <= 11557)
                  : (c <= 11559 || (c < 11568
                    ? c == 11565
                    : c <= 11623)))
                : (c <= 11631 || (c < 11688
                  ? (c < 11680
                    ? (c >= 11647 && c <= 11670)
                    : c <= 11686)
                  : (c <= 11694 || (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)))))))))
          : (c <= 11718 || (c < 42612
            ? (c < 12449
              ? (c < 12321
                ? (c < 11736
                  ? (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)
                  : (c <= 11742 || (c < 12293
                    ? (c >= 11744 && c <= 11775)
                    : c <= 12295)))
                : (c <= 12335 || (c < 12353
                  ? (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)
                  : (c <= 12438 || (c < 12445
                    ? (c >= 12441 && c <= 12442)
                    : c <= 12447)))))
              : (c <= 12538 || (c < 13312
                ? (c < 12593
                  ? (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)
                  : (c <= 12686 || (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)))
                : (c <= 19903 || (c < 42240
                  ? (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)
                  : (c <= 42508 || (c < 42560
                    ? (c >= 42512 && c <= 42539)
                    : c <= 42607)))))))
            : (c <= 42621 || (c < 43216
              ? (c < 42963
                ? (c < 42786
                  ? (c < 42775
                    ? (c >= 42623 && c <= 42737)
                    : c <= 42783)
                  : (c <= 42888 || (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)))
                : (c <= 42963 || (c < 43052
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43047)
                  : (c <= 43052 || (c < 43136
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43205)))))
              : (c <= 43225 || (c < 43392
                ? (c < 43261
                  ? (c < 43259
                    ? (c >= 43232 && c <= 43255)
                    : c <= 43259)
                  : (c <= 43309 || (c < 43360
                    ? (c >= 43312 && c <= 43347)
                    : c <= 43388)))
                : (c <= 43456 || (c < 43520
                  ? (c < 43488
                    ? (c >= 43471 && c <= 43481)
                    : c <= 43518)
                  : (c <= 43574 || (c >= 43584 && c <= 43597)))))))))))))))
    : (c <= 43609 || (c < 71453
      ? (c < 67594
        ? (c < 65343
          ? (c < 64298
            ? (c < 43868
              ? (c < 43777
                ? (c < 43739
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43714)
                  : (c <= 43741 || (c < 43762
                    ? (c >= 43744 && c <= 43759)
                    : c <= 43766)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)))))
              : (c <= 43881 || (c < 55243
                ? (c < 44016
                  ? (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : c <= 44013)
                  : (c <= 44025 || (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)))
                : (c <= 55291 || (c < 64256
                  ? (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)
                  : (c <= 64262 || (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64296)))))))
            : (c <= 64310 || (c < 65056
              ? (c < 64467
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)))
                : (c <= 64605 || (c < 64914
                  ? (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)
                  : (c <= 64967 || (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)))))
              : (c <= 65071 || (c < 65145
                ? (c < 65137
                  ? (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)
                  : (c <= 65137 || (c < 65143
                    ? c == 65139
                    : c <= 65143)))
                : (c <= 65145 || (c < 65151
                  ? (c < 65149
                    ? c == 65147
                    : c <= 65149)
                  : (c <= 65276 || (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)))))))))
          : (c <= 65343 || (c < 66504
            ? (c < 65616
              ? (c < 65498
                ? (c < 65474
                  ? (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)
                  : (c <= 65479 || (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)))))
              : (c <= 65629 || (c < 66272
                ? (c < 66045
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66045 || (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)))
                : (c <= 66272 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66426 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))))))
            : (c <= 66511 || (c < 66967
              ? (c < 66816
                ? (c < 66720
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66729 || (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)))
                : (c <= 66855 || (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)))))
              : (c <= 66977 || (c < 67424
                ? (c < 67003
                  ? (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)
                  : (c <= 67004 || (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)))
                : (c <= 67431 || (c < 67506
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : c <= 67504)
                  : (c <= 67514 || (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)))))))))))
        : (c <= 67637 || (c < 69942
          ? (c < 68416
            ? (c < 68096
              ? (c < 67808
                ? (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)))
                : (c <= 67826 || (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c < 68030
                    ? (c >= 67968 && c <= 68023)
                    : c <= 68031)))))
              : (c <= 68099 || (c < 68159
                ? (c < 68117
                  ? (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : c <= 68115)
                  : (c <= 68119 || (c < 68152
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68154)))
                : (c <= 68159 || (c < 68288
                  ? (c < 68224
                    ? (c >= 68192 && c <= 68220)
                    : c <= 68252)
                  : (c <= 68295 || (c < 68352
                    ? (c >= 68297 && c <= 68326)
                    : c <= 68405)))))))
            : (c <= 68437 || (c < 69415
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68903 || (c < 69291
                  ? (c < 69248
                    ? (c >= 68912 && c <= 68921)
                    : c <= 69289)
                  : (c <= 69292 || (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)))))
              : (c <= 69415 || (c < 69734
                ? (c < 69552
                  ? (c < 69488
                    ? (c >= 69424 && c <= 69456)
                    : c <= 69509)
                  : (c <= 69572 || (c < 69632
                    ? (c >= 69600 && c <= 69622)
                    : c <= 69702)))
                : (c <= 69749 || (c < 69840
                  ? (c < 69826
                    ? (c >= 69759 && c <= 69818)
                    : c <= 69826)
                  : (c <= 69864 || (c < 69888
                    ? (c >= 69872 && c <= 69881)
                    : c <= 69940)))))))))
          : (c <= 69951 || (c < 70453
            ? (c < 70280
              ? (c < 70094
                ? (c < 70006
                  ? (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)
                  : (c <= 70006 || (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : c <= 70092)))
                : (c <= 70106 || (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70199 || (c < 70272
                    ? c == 70206
                    : c <= 70278)))))
              : (c <= 70280 || (c < 70400
                ? (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c < 70384
                    ? (c >= 70320 && c <= 70378)
                    : c <= 70393)))
                : (c <= 70403 || (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : c <= 70451)))))))
            : (c <= 70457 || (c < 70784
              ? (c < 70493
                ? (c < 70475
                  ? (c < 70471
                    ? (c >= 70459 && c <= 70468)
                    : c <= 70472)
                  : (c <= 70477 || (c < 70487
                    ? c == 70480
                    : c <= 70487)))
                : (c <= 70499 || (c < 70656
                  ? (c < 70512
                    ? (c >= 70502 && c <= 70508)
                    : c <= 70516)
                  : (c <= 70730 || (c < 70750
                    ? (c >= 70736 && c <= 70745)
                    : c <= 70753)))))
              : (c <= 70853 || (c < 71168
                ? (c < 71040
                  ? (c < 70864
                    ? c == 70855
                    : c <= 70873)
                  : (c <= 71093 || (c < 71128
                    ? (c >= 71096 && c <= 71104)
                    : c <= 71133)))
                : (c <= 71232 || (c < 71296
                  ? (c < 71248
                    ? c == 71236
                    : c <= 71257)
                  : (c <= 71352 || (c < 71424
                    ? (c >= 71360 && c <= 71369)
                    : c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_12(int32_t c) {
  return (c < 43584
    ? (c < 3749
      ? (c < 2707
        ? (c < 1808
          ? (c < 902
            ? (c < 186
              ? (c < '_'
                ? (c < '9'
                  ? (c < '0'
                    ? c == '$'
                    : c <= '7')
                  : (c <= '9' || (c < 'S'
                    ? (c >= 'A' && c <= 'Q')
                    : c <= 'Z')))
                : (c <= '_' || (c < 170
                  ? (c < 'j'
                    ? (c >= 'a' && c <= 'h')
                    : c <= 'z')
                  : (c <= 170 || (c < 183
                    ? c == 181
                    : c <= 183)))))
              : (c <= 186 || (c < 748
                ? (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)))
                : (c <= 748 || (c < 886
                  ? (c < 768
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)))))))
            : (c <= 906 || (c < 1473
              ? (c < 1162
                ? (c < 931
                  ? (c < 910
                    ? c == 908
                    : c <= 929)
                  : (c <= 1013 || (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)))
                : (c <= 1327 || (c < 1376
                  ? (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)
                  : (c <= 1416 || (c < 1471
                    ? (c >= 1425 && c <= 1469)
                    : c <= 1471)))))
              : (c <= 1474 || (c < 1568
                ? (c < 1488
                  ? (c < 1479
                    ? (c >= 1476 && c <= 1477)
                    : c <= 1479)
                  : (c <= 1514 || (c < 1552
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1562)))
                : (c <= 1641 || (c < 1759
                  ? (c < 1749
                    ? (c >= 1646 && c <= 1747)
                    : c <= 1756)
                  : (c <= 1768 || (c < 1791
                    ? (c >= 1770 && c <= 1788)
                    : c <= 1791)))))))))
          : (c <= 1866 || (c < 2524
            ? (c < 2406
              ? (c < 2112
                ? (c < 2042
                  ? (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)
                  : (c <= 2042 || (c < 2048
                    ? c == 2045
                    : c <= 2093)))
                : (c <= 2139 || (c < 2185
                  ? (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)
                  : (c <= 2190 || (c < 2275
                    ? (c >= 2200 && c <= 2273)
                    : c <= 2403)))))
              : (c <= 2415 || (c < 2482
                ? (c < 2447
                  ? (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)
                  : (c <= 2448 || (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)))
                : (c <= 2482 || (c < 2503
                  ? (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)
                  : (c <= 2504 || (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)))))))
            : (c <= 2525 || (c < 2616
              ? (c < 2565
                ? (c < 2556
                  ? (c < 2534
                    ? (c >= 2527 && c <= 2531)
                    : c <= 2545)
                  : (c <= 2556 || (c < 2561
                    ? c == 2558
                    : c <= 2563)))
                : (c <= 2570 || (c < 2602
                  ? (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)
                  : (c <= 2608 || (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)))))
              : (c <= 2617 || (c < 2649
                ? (c < 2631
                  ? (c < 2622
                    ? c == 2620
                    : c <= 2626)
                  : (c <= 2632 || (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : c <= 2641)))
                : (c <= 2652 || (c < 2689
                  ? (c < 2662
                    ? c == 2654
                    : c <= 2677)
                  : (c <= 2691 || (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)))))))))))
        : (c <= 2728 || (c < 3146
          ? (c < 2918
            ? (c < 2821
              ? (c < 2763
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2759
                    ? (c >= 2748 && c <= 2757)
                    : c <= 2761)))
                : (c <= 2765 || (c < 2790
                  ? (c < 2784
                    ? c == 2768
                    : c <= 2787)
                  : (c <= 2799 || (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)))))
              : (c <= 2828 || (c < 2876
                ? (c < 2858
                  ? (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)
                  : (c <= 2864 || (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)))
                : (c <= 2884 || (c < 2901
                  ? (c < 2891
                    ? (c >= 2887 && c <= 2888)
                    : c <= 2893)
                  : (c <= 2903 || (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2915)))))))
            : (c <= 2927 || (c < 3006
              ? (c < 2969
                ? (c < 2949
                  ? (c < 2946
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)))
                : (c <= 2970 || (c < 2979
                  ? (c < 2974
                    ? c == 2972
                    : c <= 2975)
                  : (c <= 2980 || (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)))))
              : (c <= 3010 || (c < 3072
                ? (c < 3024
                  ? (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)
                  : (c <= 3024 || (c < 3046
                    ? c == 3031
                    : c <= 3055)))
                : (c <= 3084 || (c < 3114
                  ? (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)
                  : (c <= 3129 || (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)))))))))
          : (c <= 3149 || (c < 3402
            ? (c < 3260
              ? (c < 3200
                ? (c < 3165
                  ? (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : c <= 3162)
                  : (c <= 3165 || (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)))
                : (c <= 3203 || (c < 3218
                  ? (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)
                  : (c <= 3240 || (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)))))
              : (c <= 3268 || (c < 3302
                ? (c < 3285
                  ? (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)
                  : (c <= 3286 || (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3299)))
                : (c <= 3311 || (c < 3342
                  ? (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)
                  : (c <= 3344 || (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : c <= 3400)))))))
            : (c <= 3406 || (c < 3535
              ? (c < 3461
                ? (c < 3430
                  ? (c < 3423
                    ? (c >= 3412 && c <= 3415)
                    : c <= 3427)
                  : (c <= 3439 || (c < 3457
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3459)))
                : (c <= 3478 || (c < 3517
                  ? (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)
                  : (c <= 3517 || (c < 3530
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3530)))))
              : (c <= 3540 || (c < 3648
                ? (c < 3558
                  ? (c < 3544
                    ? c == 3542
                    : c <= 3551)
                  : (c <= 3567 || (c < 3585
                    ? (c >= 3570 && c <= 3571)
                    : c <= 3642)))
                : (c <= 3662 || (c < 3716
                  ? (c < 3713
                    ? (c >= 3664 && c <= 3673)
                    : c <= 3714)
                  : (c <= 3716 || (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)))))))))))))
      : (c <= 3749 || (c < 7968
        ? (c < 5761
          ? (c < 4304
            ? (c < 3897
              ? (c < 3804
                ? (c < 3782
                  ? (c < 3776
                    ? (c >= 3751 && c <= 3773)
                    : c <= 3780)
                  : (c <= 3782 || (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)))
                : (c <= 3807 || (c < 3872
                  ? (c < 3864
                    ? c == 3840
                    : c <= 3865)
                  : (c <= 3881 || (c < 3895
                    ? c == 3893
                    : c <= 3895)))))
              : (c <= 3897 || (c < 4038
                ? (c < 3953
                  ? (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)
                  : (c <= 3972 || (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)))
                : (c <= 4038 || (c < 4256
                  ? (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)
                  : (c <= 4293 || (c < 4301
                    ? c == 4295
                    : c <= 4301)))))))
            : (c <= 4346 || (c < 4802
              ? (c < 4704
                ? (c < 4688
                  ? (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)
                  : (c <= 4694 || (c < 4698
                    ? c == 4696
                    : c <= 4701)))
                : (c <= 4744 || (c < 4786
                  ? (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)
                  : (c <= 4789 || (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)))))
              : (c <= 4805 || (c < 4969
                ? (c < 4882
                  ? (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)
                  : (c <= 4885 || (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)))
                : (c <= 4977 || (c < 5112
                  ? (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)
                  : (c <= 5117 || (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)))))))))
          : (c <= 5786 || (c < 6576
            ? (c < 6112
              ? (c < 5984
                ? (c < 5888
                  ? (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)
                  : (c <= 5909 || (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)))
                : (c <= 5996 || (c < 6016
                  ? (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)
                  : (c <= 6099 || (c < 6108
                    ? c == 6103
                    : c <= 6109)))))
              : (c <= 6121 || (c < 6400
                ? (c < 6176
                  ? (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)
                  : (c <= 6264 || (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)))
                : (c <= 6430 || (c < 6470
                  ? (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)
                  : (c <= 6509 || (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)))))))
            : (c <= 6601 || (c < 7019
              ? (c < 6800
                ? (c < 6688
                  ? (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)
                  : (c <= 6750 || (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)))
                : (c <= 6809 || (c < 6847
                  ? (c < 6832
                    ? c == 6823
                    : c <= 6845)
                  : (c <= 6862 || (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)))))
              : (c <= 7027 || (c < 7312
                ? (c < 7232
                  ? (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)
                  : (c <= 7241 || (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)))
                : (c <= 7354 || (c < 7380
                  ? (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)
                  : (c <= 7418 || (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)))))))))))
        : (c <= 8005 || (c < 11696
          ? (c < 8421
            ? (c < 8144
              ? (c < 8031
                ? (c < 8025
                  ? (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)
                  : (c <= 8025 || (c < 8029
                    ? c == 8027
                    : c <= 8029)))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)))))
              : (c <= 8147 || (c < 8276
                ? (c < 8178
                  ? (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)
                  : (c <= 8180 || (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)))
                : (c <= 8276 || (c < 8336
                  ? (c < 8319
                    ? c == 8305
                    : c <= 8319)
                  : (c <= 8348 || (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)))))))
            : (c <= 8432 || (c < 8526
              ? (c < 8484
                ? (c < 8458
                  ? (c < 8455
                    ? c == 8450
                    : c <= 8455)
                  : (c <= 8467 || (c < 8472
                    ? c == 8469
                    : c <= 8477)))
                : (c <= 8484 || (c < 8490
                  ? (c < 8488
                    ? c == 8486
                    : c <= 8488)
                  : (c <= 8505 || (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)))))
              : (c <= 8526 || (c < 11565
                ? (c < 11499
                  ? (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)
                  : (c <= 11507 || (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)))
                : (c <= 11565 || (c < 11647
                  ? (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)
                  : (c <= 11670 || (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)))))))))
          : (c <= 11702 || (c < 42512
            ? (c < 12441
              ? (c < 11744
                ? (c < 11720
                  ? (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)
                  : (c <= 11726 || (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)))
                : (c <= 11775 || (c < 12337
                  ? (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)
                  : (c <= 12341 || (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)))))
              : (c <= 12442 || (c < 12704
                ? (c < 12540
                  ? (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)
                  : (c <= 12543 || (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)))
                : (c <= 12735 || (c < 19968
                  ? (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)
                  : (c <= 42124 || (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)))))))
            : (c <= 42539 || (c < 43072
              ? (c < 42891
                ? (c < 42623
                  ? (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)
                  : (c <= 42737 || (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)))
                : (c <= 42954 || (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)))))
              : (c <= 43123 || (c < 43312
                ? (c < 43232
                  ? (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)
                  : (c <= 43255 || (c < 43261
                    ? c == 43259
                    : c <= 43309)))
                : (c <= 43347 || (c < 43471
                  ? (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)
                  : (c <= 43481 || (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)))))))))))))))
    : (c <= 43597 || (c < 71424
      ? (c < 67592
        ? (c < 65313
          ? (c < 64285
            ? (c < 43824
              ? (c < 43762
                ? (c < 43642
                  ? (c < 43616
                    ? (c >= 43600 && c <= 43609)
                    : c <= 43638)
                  : (c <= 43714 || (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43759)))
                : (c <= 43766 || (c < 43793
                  ? (c < 43785
                    ? (c >= 43777 && c <= 43782)
                    : c <= 43790)
                  : (c <= 43798 || (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)))))
              : (c <= 43866 || (c < 55216
                ? (c < 44012
                  ? (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44010)
                  : (c <= 44013 || (c < 44032
                    ? (c >= 44016 && c <= 44025)
                    : c <= 55203)))
                : (c <= 55238 || (c < 64112
                  ? (c < 63744
                    ? (c >= 55243 && c <= 55291)
                    : c <= 64109)
                  : (c <= 64217 || (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)))))))
            : (c <= 64296 || (c < 65024
              ? (c < 64326
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : c <= 64324)))
                : (c <= 64433 || (c < 64848
                  ? (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)
                  : (c <= 64911 || (c < 65008
                    ? (c >= 64914 && c <= 64967)
                    : c <= 65017)))))
              : (c <= 65039 || (c < 65143
                ? (c < 65101
                  ? (c < 65075
                    ? (c >= 65056 && c <= 65071)
                    : c <= 65076)
                  : (c <= 65103 || (c < 65139
                    ? c == 65137
                    : c <= 65139)))
                : (c <= 65143 || (c < 65149
                  ? (c < 65147
                    ? c == 65145
                    : c <= 65147)
                  : (c <= 65149 || (c < 65296
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65305)))))))))
          : (c <= 65338 || (c < 66464
            ? (c < 65599
              ? (c < 65490
                ? (c < 65382
                  ? (c < 65345
                    ? c == 65343
                    : c <= 65370)
                  : (c <= 65470 || (c < 65482
                    ? (c >= 65474 && c <= 65479)
                    : c <= 65487)))
                : (c <= 65495 || (c < 65549
                  ? (c < 65536
                    ? (c >= 65498 && c <= 65500)
                    : c <= 65547)
                  : (c <= 65574 || (c < 65596
                    ? (c >= 65576 && c <= 65594)
                    : c <= 65597)))))
              : (c <= 65613 || (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c < 66176
                    ? c == 66045
                    : c <= 66204)))
                : (c <= 66256 || (c < 66349
                  ? (c < 66304
                    ? c == 66272
                    : c <= 66335)
                  : (c <= 66378 || (c < 66432
                    ? (c >= 66384 && c <= 66426)
                    : c <= 66461)))))))
            : (c <= 66499 || (c < 66964
              ? (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c < 66736
                    ? (c >= 66720 && c <= 66729)
                    : c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c < 66956
                    ? (c >= 66940 && c <= 66954)
                    : c <= 66962)))))
              : (c <= 66965 || (c < 67392
                ? (c < 66995
                  ? (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)
                  : (c <= 67001 || (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)))
                : (c <= 67413 || (c < 67463
                  ? (c < 67456
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67461)
                  : (c <= 67504 || (c < 67584
                    ? (c >= 67506 && c <= 67514)
                    : c <= 67589)))))))))))
        : (c <= 67592 || (c < 69888
          ? (c < 68352
            ? (c < 68030
              ? (c < 67712
                ? (c < 67644
                  ? (c < 67639
                    ? (c >= 67594 && c <= 67637)
                    : c <= 67640)
                  : (c <= 67644 || (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)))
                : (c <= 67742 || (c < 67840
                  ? (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)
                  : (c <= 67861 || (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)))))
              : (c <= 68031 || (c < 68152
                ? (c < 68108
                  ? (c < 68101
                    ? (c >= 68096 && c <= 68099)
                    : c <= 68102)
                  : (c <= 68115 || (c < 68121
                    ? (c >= 68117 && c <= 68119)
                    : c <= 68149)))
                : (c <= 68154 || (c < 68224
                  ? (c < 68192
                    ? c == 68159
                    : c <= 68220)
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)))))))
            : (c <= 68405 || (c < 69376
              ? (c < 68800
                ? (c < 68480
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : c <= 68466)
                  : (c <= 68497 || (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)))
                : (c <= 68850 || (c < 69248
                  ? (c < 68912
                    ? (c >= 68864 && c <= 68903)
                    : c <= 68921)
                  : (c <= 69289 || (c < 69296
                    ? (c >= 69291 && c <= 69292)
                    : c <= 69297)))))
              : (c <= 69404 || (c < 69632
                ? (c < 69488
                  ? (c < 69424
                    ? c == 69415
                    : c <= 69456)
                  : (c <= 69509 || (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)))
                : (c <= 69702 || (c < 69826
                  ? (c < 69759
                    ? (c >= 69734 && c <= 69749)
                    : c <= 69818)
                  : (c <= 69826 || (c < 69872
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69881)))))))))
          : (c <= 69940 || (c < 70450
            ? (c < 70272
              ? (c < 70089
                ? (c < 69968
                  ? (c < 69956
                    ? (c >= 69942 && c <= 69951)
                    : c <= 69959)
                  : (c <= 70003 || (c < 70016
                    ? c == 70006
                    : c <= 70084)))
                : (c <= 70092 || (c < 70144
                  ? (c < 70108
                    ? (c >= 70094 && c <= 70106)
                    : c <= 70108)
                  : (c <= 70161 || (c < 70206
                    ? (c >= 70163 && c <= 70199)
                    : c <= 70206)))))
              : (c <= 70278 || (c < 70384
                ? (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70378)))
                : (c <= 70393 || (c < 70415
                  ? (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : c <= 70412)
                  : (c <= 70416 || (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)))))))
            : (c <= 70451 || (c < 70750
              ? (c < 70487
                ? (c < 70471
                  ? (c < 70459
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70468)
                  : (c <= 70472 || (c < 70480
                    ? (c >= 70475 && c <= 70477)
                    : c <= 70480)))
                : (c <= 70487 || (c < 70512
                  ? (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)
                  : (c <= 70516 || (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : c <= 70745)))))
              : (c <= 70753 || (c < 71128
                ? (c < 70864
                  ? (c < 70855
                    ? (c >= 70784 && c <= 70853)
                    : c <= 70855)
                  : (c <= 70873 || (c < 71096
                    ? (c >= 71040 && c <= 71093)
                    : c <= 71104)))
                : (c <= 71133 || (c < 71248
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71232)
                    : c <= 71236)
                  : (c <= 71257 || (c < 71360
                    ? (c >= 71296 && c <= 71352)
                    : c <= 71369)))))))))))))
      : (c <= 71450 || (c < 119970
        ? (c < 77712
          ? (c < 72714
            ? (c < 71995
              ? (c < 71935
                ? (c < 71488
                  ? (c < 71472
                    ? (c >= 71453 && c <= 71467)
                    : c <= 71481)
                  : (c <= 71494 || (c < 71840
                    ? (c >= 71680 && c <= 71738)
                    : c <= 71913)))
                : (c <= 71942 || (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c < 71991
                    ? (c >= 71960 && c <= 71989)
                    : c <= 71992)))))
              : (c <= 72003 || (c < 72192
                ? (c < 72106
                  ? (c < 72096
                    ? (c >= 72016 && c <= 72025)
                    : c <= 72103)
                  : (c <= 72151 || (c < 72163
                    ? (c >= 72154 && c <= 72161)
                    : c <= 72164)))
                : (c <= 72254 || (c < 72349
                  ? (c < 72272
                    ? c == 72263
                    : c <= 72345)
                  : (c <= 72349 || (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)))))))
            : (c <= 72758 || (c < 73040
              ? (c < 72960
                ? (c < 72818
                  ? (c < 72784
                    ? (c >= 72760 && c <= 72768)
                    : c <= 72793)
                  : (c <= 72847 || (c < 72873
                    ? (c >= 72850 && c <= 72871)
                    : c <= 72886)))
                : (c <= 72966 || (c < 73018
                  ? (c < 72971
                    ? (c >= 72968 && c <= 72969)
                    : c <= 73014)
                  : (c <= 73018 || (c < 73023
                    ? (c >= 73020 && c <= 73021)
                    : c <= 73031)))))
              : (c <= 73049 || (c < 73120
                ? (c < 73066
                  ? (c < 73063
                    ? (c >= 73056 && c <= 73061)
                    : c <= 73064)
                  : (c <= 73102 || (c < 73107
                    ? (c >= 73104 && c <= 73105)
                    : c <= 73112)))
                : (c <= 73129 || (c < 73728
                  ? (c < 73648
                    ? (c >= 73440 && c <= 73462)
                    : c <= 73648)
                  : (c <= 74649 || (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)))))))))
          : (c <= 77808 || (c < 101632
            ? (c < 93008
              ? (c < 92784
                ? (c < 92160
                  ? (c < 82944
                    ? (c >= 77824 && c <= 78894)
                    : c <= 83526)
                  : (c <= 92728 || (c < 92768
                    ? (c >= 92736 && c <= 92766)
                    : c <= 92777)))
                : (c <= 92862 || (c < 92912
                  ? (c < 92880
                    ? (c >= 92864 && c <= 92873)
                    : c <= 92909)
                  : (c <= 92916 || (c < 92992
                    ? (c >= 92928 && c <= 92982)
                    : c <= 92995)))))
              : (c <= 93017 || (c < 94095
                ? (c < 93760
                  ? (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)
                  : (c <= 93823 || (c < 94031
                    ? (c >= 93952 && c <= 94026)
                    : c <= 94087)))
                : (c <= 94111 || (c < 94192
                  ? (c < 94179
                    ? (c >= 94176 && c <= 94177)
                    : c <= 94180)
                  : (c <= 94193 || (c < 100352
                    ? (c >= 94208 && c <= 100343)
                    : c <= 101589)))))))
            : (c <= 101640 || (c < 113821
              ? (c < 110948
                ? (c < 110589
                  ? (c < 110581
                    ? (c >= 110576 && c <= 110579)
                    : c <= 110587)
                  : (c <= 110590 || (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)))
                : (c <= 110951 || (c < 113776
                  ? (c < 113664
                    ? (c >= 110960 && c <= 111355)
                    : c <= 113770)
                  : (c <= 113788 || (c < 113808
                    ? (c >= 113792 && c <= 113800)
                    : c <= 113817)))))
              : (c <= 113822 || (c < 119173
                ? (c < 119141
                  ? (c < 118576
                    ? (c >= 118528 && c <= 118573)
                    : c <= 118598)
                  : (c <= 119145 || (c < 119163
                    ? (c >= 119149 && c <= 119154)
                    : c <= 119170)))
                : (c <= 119179 || (c < 119808
                  ? (c < 119362
                    ? (c >= 119210 && c <= 119213)
                    : c <= 119364)
                  : (c <= 119892 || (c < 119966
                    ? (c >= 119894 && c <= 119964)
                    : c <= 119967)))))))))))
        : (c <= 119970 || (c < 124909
          ? (c < 120714
            ? (c < 120128
              ? (c < 120005
                ? (c < 119982
                  ? (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)
                  : (c <= 119993 || (c < 119997
                    ? c == 119995
                    : c <= 120003)))
                : (c <= 120069 || (c < 120086
                  ? (c < 120077
                    ? (c >= 120071 && c <= 120074)
                    : c <= 120084)
                  : (c <= 120092 || (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)))))
              : (c <= 120132 || (c < 120540
                ? (c < 120146
                  ? (c < 120138
                    ? c == 120134
                    : c <= 120144)
                  : (c <= 120485 || (c < 120514
                    ? (c >= 120488 && c <= 120512)
                    : c <= 120538)))
                : (c <= 120570 || (c < 120630
                  ? (c < 120598
                    ? (c >= 120572 && c <= 120596)
                    : c <= 120628)
                  : (c <= 120654 || (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)))))))
            : (c <= 120744 || (c < 122888
              ? (c < 121461
                ? (c < 120782
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 120831 || (c < 121403
                    ? (c >= 121344 && c <= 121398)
                    : c <= 121452)))
                : (c <= 121461 || (c < 121505
                  ? (c < 121499
                    ? c == 121476
                    : c <= 121503)
                  : (c <= 121519 || (c < 122880
                    ? (c >= 122624 && c <= 122654)
                    : c <= 122886)))))
              : (c <= 122904 || (c < 123200
                ? (c < 122918
                  ? (c < 122915
                    ? (c >= 122907 && c <= 122913)
                    : c <= 122916)
                  : (c <= 122922 || (c < 123184
                    ? (c >= 123136 && c <= 123180)
                    : c <= 123197)))
                : (c <= 123209 || (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123566)
                  : (c <= 123641 || (c < 124904
                    ? (c >= 124896 && c <= 124902)
                    : c <= 124907)))))))))
          : (c <= 124910 || (c < 126555
            ? (c < 126516
              ? (c < 126464
                ? (c < 125136
                  ? (c < 124928
                    ? (c >= 124912 && c <= 124926)
                    : c <= 125124)
                  : (c <= 125142 || (c < 125264
                    ? (c >= 125184 && c <= 125259)
                    : c <= 125273)))
                : (c <= 126467 || (c < 126500
                  ? (c < 126497
                    ? (c >= 126469 && c <= 126495)
                    : c <= 126498)
                  : (c <= 126500 || (c < 126505
                    ? c == 126503
                    : c <= 126514)))))
              : (c <= 126519 || (c < 126539
                ? (c < 126530
                  ? (c < 126523
                    ? c == 126521
                    : c <= 126523)
                  : (c <= 126530 || (c < 126537
                    ? c == 126535
                    : c <= 126537)))
                : (c <= 126539 || (c < 126548
                  ? (c < 126545
                    ? (c >= 126541 && c <= 126543)
                    : c <= 126546)
                  : (c <= 126548 || (c < 126553
                    ? c == 126551
                    : c <= 126553)))))))
            : (c <= 126555 || (c < 126625
              ? (c < 126572
                ? (c < 126561
                  ? (c < 126559
                    ? c == 126557
                    : c <= 126559)
                  : (c <= 126562 || (c < 126567
                    ? c == 126564
                    : c <= 126570)))
                : (c <= 126578 || (c < 126590
                  ? (c < 126585
                    ? (c >= 126580 && c <= 126583)
                    : c <= 126588)
                  : (c <= 126590 || (c < 126603
                    ? (c >= 126592 && c <= 126601)
                    : c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 130032
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 130041 || (c < 173824
                    ? (c >= 131072 && c <= 173791)
                    : c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c < 917760
                    ? (c >= 196608 && c <= 201546)
                    : c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_13(int32_t c) {
  return (c < 43600
    ? (c < 3751
      ? (c < 2730
        ? (c < 1869
          ? (c < 908
            ? (c < 192
              ? (c < '_'
                ? (c < '9'
                  ? (c < '0'
                    ? c == '$'
                    : c <= '7')
                  : (c <= '9' || (c < 'S'
                    ? (c >= 'A' && c <= 'Q')
                    : c <= 'Z')))
                : (c <= '_' || (c < 181
                  ? (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)
                  : (c <= 181 || (c < 186
                    ? c == 183
                    : c <= 186)))))
              : (c <= 214 || (c < 750
                ? (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)))
                : (c <= 750 || (c < 891
                  ? (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)
                  : (c <= 893 || (c < 902
                    ? c == 895
                    : c <= 906)))))))
            : (c <= 908 || (c < 1476
              ? (c < 1329
                ? (c < 1015
                  ? (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)
                  : (c <= 1153 || (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)))
                : (c <= 1366 || (c < 1425
                  ? (c < 1376
                    ? c == 1369
                    : c <= 1416)
                  : (c <= 1469 || (c < 1473
                    ? c == 1471
                    : c <= 1474)))))
              : (c <= 1477 || (c < 1646
                ? (c < 1519
                  ? (c < 1488
                    ? c == 1479
                    : c <= 1514)
                  : (c <= 1522 || (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)))
                : (c <= 1747 || (c < 1770
                  ? (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)
                  : (c <= 1788 || (c < 1808
                    ? c == 1791
                    : c <= 1866)))))))))
          : (c <= 1969 || (c < 2527
            ? (c < 2417
              ? (c < 2144
                ? (c < 2045
                  ? (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2045 || (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)))
                : (c <= 2154 || (c < 2200
                  ? (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)
                  : (c <= 2273 || (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)))))
              : (c <= 2435 || (c < 2486
                ? (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)))
                : (c <= 2489 || (c < 2507
                  ? (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)
                  : (c <= 2510 || (c < 2524
                    ? c == 2519
                    : c <= 2525)))))))
            : (c <= 2531 || (c < 2620
              ? (c < 2575
                ? (c < 2558
                  ? (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2558 || (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)))
                : (c <= 2576 || (c < 2610
                  ? (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)
                  : (c <= 2611 || (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)))))
              : (c <= 2620 || (c < 2654
                ? (c < 2635
                  ? (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)
                  : (c <= 2637 || (c < 2649
                    ? c == 2641
                    : c <= 2652)))
                : (c <= 2654 || (c < 2693
                  ? (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)
                  : (c <= 2701 || (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)))))))))))
        : (c <= 2736 || (c < 3157
          ? (c < 2929
            ? (c < 2831
              ? (c < 2768
                ? (c < 2748
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2757 || (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)))
                : (c <= 2768 || (c < 2809
                  ? (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)
                  : (c <= 2815 || (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)))))
              : (c <= 2832 || (c < 2887
                ? (c < 2866
                  ? (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)
                  : (c <= 2867 || (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)))
                : (c <= 2888 || (c < 2908
                  ? (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)
                  : (c <= 2909 || (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)))))))
            : (c <= 2929 || (c < 3014
              ? (c < 2972
                ? (c < 2958
                  ? (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)
                  : (c <= 2960 || (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)))
                : (c <= 2972 || (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)))))
              : (c <= 3016 || (c < 3086
                ? (c < 3031
                  ? (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)
                  : (c <= 3031 || (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)))
                : (c <= 3088 || (c < 3132
                  ? (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)
                  : (c <= 3140 || (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)))))))))
          : (c <= 3158 || (c < 3412
            ? (c < 3270
              ? (c < 3205
                ? (c < 3168
                  ? (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)
                  : (c <= 3171 || (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)))
                : (c <= 3212 || (c < 3242
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)
                  : (c <= 3251 || (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)))))
              : (c <= 3272 || (c < 3313
                ? (c < 3293
                  ? (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)
                  : (c <= 3294 || (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)))
                : (c <= 3314 || (c < 3346
                  ? (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)
                  : (c <= 3396 || (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)))))))
            : (c <= 3415 || (c < 3542
              ? (c < 3482
                ? (c < 3450
                  ? (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)
                  : (c <= 3455 || (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)))
                : (c <= 3505 || (c < 3520
                  ? (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)
                  : (c <= 3526 || (c < 3535
                    ? c == 3530
                    : c <= 3540)))))
              : (c <= 3542 || (c < 3664
                ? (c < 3570
                  ? (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)
                  : (c <= 3571 || (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)))
                : (c <= 3673 || (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)))))))))))))
      : (c <= 3773 || (c < 8008
        ? (c < 5792
          ? (c < 4348
            ? (c < 3902
              ? (c < 3840
                ? (c < 3784
                  ? (c < 3782
                    ? (c >= 3776 && c <= 3780)
                    : c <= 3782)
                  : (c <= 3789 || (c < 3804
                    ? (c >= 3792 && c <= 3801)
                    : c <= 3807)))
                : (c <= 3840 || (c < 3893
                  ? (c < 3872
                    ? (c >= 3864 && c <= 3865)
                    : c <= 3881)
                  : (c <= 3893 || (c < 3897
                    ? c == 3895
                    : c <= 3897)))))
              : (c <= 3911 || (c < 4096
                ? (c < 3974
                  ? (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)
                  : (c <= 3991 || (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : c <= 4038)))
                : (c <= 4169 || (c < 4295
                  ? (c < 4256
                    ? (c >= 4176 && c <= 4253)
                    : c <= 4293)
                  : (c <= 4295 || (c < 4304
                    ? c == 4301
                    : c <= 4346)))))))
            : (c <= 4680 || (c < 4808
              ? (c < 4746
                ? (c < 4696
                  ? (c < 4688
                    ? (c >= 4682 && c <= 4685)
                    : c <= 4694)
                  : (c <= 4696 || (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)))
                : (c <= 4749 || (c < 4792
                  ? (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)
                  : (c <= 4798 || (c < 4802
                    ? c == 4800
                    : c <= 4805)))))
              : (c <= 4822 || (c < 4992
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c < 4969
                    ? (c >= 4957 && c <= 4959)
                    : c <= 4977)))
                : (c <= 5007 || (c < 5121
                  ? (c < 5112
                    ? (c >= 5024 && c <= 5109)
                    : c <= 5117)
                  : (c <= 5740 || (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)))))))))
          : (c <= 5866 || (c < 6608
            ? (c < 6155
              ? (c < 5998
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5909)
                  : (c <= 5940 || (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : c <= 5996)))
                : (c <= 6000 || (c < 6103
                  ? (c < 6016
                    ? (c >= 6002 && c <= 6003)
                    : c <= 6099)
                  : (c <= 6103 || (c < 6112
                    ? (c >= 6108 && c <= 6109)
                    : c <= 6121)))))
              : (c <= 6157 || (c < 6432
                ? (c < 6272
                  ? (c < 6176
                    ? (c >= 6159 && c <= 6169)
                    : c <= 6264)
                  : (c <= 6314 || (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)))
                : (c <= 6443 || (c < 6512
                  ? (c < 6470
                    ? (c >= 6448 && c <= 6459)
                    : c <= 6509)
                  : (c <= 6516 || (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)))))))
            : (c <= 6618 || (c < 7040
              ? (c < 6823
                ? (c < 6752
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6683)
                    : c <= 6750)
                  : (c <= 6780 || (c < 6800
                    ? (c >= 6783 && c <= 6793)
                    : c <= 6809)))
                : (c <= 6823 || (c < 6912
                  ? (c < 6847
                    ? (c >= 6832 && c <= 6845)
                    : c <= 6862)
                  : (c <= 6988 || (c < 7019
                    ? (c >= 6992 && c <= 7001)
                    : c <= 7027)))))
              : (c <= 7155 || (c < 7357
                ? (c < 7245
                  ? (c < 7232
                    ? (c >= 7168 && c <= 7223)
                    : c <= 7241)
                  : (c <= 7293 || (c < 7312
                    ? (c >= 7296 && c <= 7304)
                    : c <= 7354)))
                : (c <= 7359 || (c < 7424
                  ? (c < 7380
                    ? (c >= 7376 && c <= 7378)
                    : c <= 7418)
                  : (c <= 7957 || (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)))))))))))
        : (c <= 8013 || (c < 11704
          ? (c < 8450
            ? (c < 8150
              ? (c < 8064
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || (c < 8031
                    ? c == 8029
                    : c <= 8061)))
                : (c <= 8116 || (c < 8130
                  ? (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)
                  : (c <= 8132 || (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)))))
              : (c <= 8155 || (c < 8305
                ? (c < 8182
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)
                  : (c <= 8188 || (c < 8276
                    ? (c >= 8255 && c <= 8256)
                    : c <= 8276)))
                : (c <= 8305 || (c < 8400
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8412 || (c < 8421
                    ? c == 8417
                    : c <= 8432)))))))
            : (c <= 8450 || (c < 8544
              ? (c < 8486
                ? (c < 8469
                  ? (c < 8458
                    ? c == 8455
                    : c <= 8467)
                  : (c <= 8469 || (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)))
                : (c <= 8486 || (c < 8508
                  ? (c < 8490
                    ? c == 8488
                    : c <= 8505)
                  : (c <= 8511 || (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)))))
              : (c <= 8584 || (c < 11568
                ? (c < 11520
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11507)
                  : (c <= 11557 || (c < 11565
                    ? c == 11559
                    : c <= 11565)))
                : (c <= 11623 || (c < 11680
                  ? (c < 11647
                    ? c == 11631
                    : c <= 11670)
                  : (c <= 11686 || (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)))))))))
          : (c <= 11710 || (c < 42560
            ? (c < 12445
              ? (c < 12293
                ? (c < 11728
                  ? (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)
                  : (c <= 11734 || (c < 11744
                    ? (c >= 11736 && c <= 11742)
                    : c <= 11775)))
                : (c <= 12295 || (c < 12344
                  ? (c < 12337
                    ? (c >= 12321 && c <= 12335)
                    : c <= 12341)
                  : (c <= 12348 || (c < 12441
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12442)))))
              : (c <= 12447 || (c < 12784
                ? (c < 12549
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)
                  : (c <= 12591 || (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)))
                : (c <= 12799 || (c < 42192
                  ? (c < 19968
                    ? (c >= 13312 && c <= 19903)
                    : c <= 42124)
                  : (c <= 42237 || (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42539)))))))
            : (c <= 42607 || (c < 43136
              ? (c < 42960
                ? (c < 42775
                  ? (c < 42623
                    ? (c >= 42612 && c <= 42621)
                    : c <= 42737)
                  : (c <= 42783 || (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42954)))
                : (c <= 42961 || (c < 42994
                  ? (c < 42965
                    ? c == 42963
                    : c <= 42969)
                  : (c <= 43047 || (c < 43072
                    ? c == 43052
                    : c <= 43123)))))
              : (c <= 43205 || (c < 43360
                ? (c < 43259
                  ? (c < 43232
                    ? (c >= 43216 && c <= 43225)
                    : c <= 43255)
                  : (c <= 43259 || (c < 43312
                    ? (c >= 43261 && c <= 43309)
                    : c <= 43347)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43392 && c <= 43456)
                    : c <= 43481)
                  : (c <= 43518 || (c < 43584
                    ? (c >= 43520 && c <= 43574)
                    : c <= 43597)))))))))))))))
    : (c <= 43609 || (c < 71453
      ? (c < 67594
        ? (c < 65343
          ? (c < 64298
            ? (c < 43868
              ? (c < 43777
                ? (c < 43739
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43714)
                  : (c <= 43741 || (c < 43762
                    ? (c >= 43744 && c <= 43759)
                    : c <= 43766)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)))))
              : (c <= 43881 || (c < 55243
                ? (c < 44016
                  ? (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : c <= 44013)
                  : (c <= 44025 || (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)))
                : (c <= 55291 || (c < 64256
                  ? (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)
                  : (c <= 64262 || (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64296)))))))
            : (c <= 64310 || (c < 65056
              ? (c < 64467
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)))
                : (c <= 64605 || (c < 64914
                  ? (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)
                  : (c <= 64967 || (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)))))
              : (c <= 65071 || (c < 65145
                ? (c < 65137
                  ? (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)
                  : (c <= 65137 || (c < 65143
                    ? c == 65139
                    : c <= 65143)))
                : (c <= 65145 || (c < 65151
                  ? (c < 65149
                    ? c == 65147
                    : c <= 65149)
                  : (c <= 65276 || (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)))))))))
          : (c <= 65343 || (c < 66504
            ? (c < 65616
              ? (c < 65498
                ? (c < 65474
                  ? (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)
                  : (c <= 65479 || (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)))))
              : (c <= 65629 || (c < 66272
                ? (c < 66045
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66045 || (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)))
                : (c <= 66272 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66426 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))))))
            : (c <= 66511 || (c < 66967
              ? (c < 66816
                ? (c < 66720
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66729 || (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)))
                : (c <= 66855 || (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)))))
              : (c <= 66977 || (c < 67424
                ? (c < 67003
                  ? (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)
                  : (c <= 67004 || (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)))
                : (c <= 67431 || (c < 67506
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : c <= 67504)
                  : (c <= 67514 || (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)))))))))))
        : (c <= 67637 || (c < 69942
          ? (c < 68416
            ? (c < 68096
              ? (c < 67808
                ? (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)))
                : (c <= 67826 || (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c < 68030
                    ? (c >= 67968 && c <= 68023)
                    : c <= 68031)))))
              : (c <= 68099 || (c < 68159
                ? (c < 68117
                  ? (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : c <= 68115)
                  : (c <= 68119 || (c < 68152
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68154)))
                : (c <= 68159 || (c < 68288
                  ? (c < 68224
                    ? (c >= 68192 && c <= 68220)
                    : c <= 68252)
                  : (c <= 68295 || (c < 68352
                    ? (c >= 68297 && c <= 68326)
                    : c <= 68405)))))))
            : (c <= 68437 || (c < 69415
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68903 || (c < 69291
                  ? (c < 69248
                    ? (c >= 68912 && c <= 68921)
                    : c <= 69289)
                  : (c <= 69292 || (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)))))
              : (c <= 69415 || (c < 69734
                ? (c < 69552
                  ? (c < 69488
                    ? (c >= 69424 && c <= 69456)
                    : c <= 69509)
                  : (c <= 69572 || (c < 69632
                    ? (c >= 69600 && c <= 69622)
                    : c <= 69702)))
                : (c <= 69749 || (c < 69840
                  ? (c < 69826
                    ? (c >= 69759 && c <= 69818)
                    : c <= 69826)
                  : (c <= 69864 || (c < 69888
                    ? (c >= 69872 && c <= 69881)
                    : c <= 69940)))))))))
          : (c <= 69951 || (c < 70453
            ? (c < 70280
              ? (c < 70094
                ? (c < 70006
                  ? (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)
                  : (c <= 70006 || (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : c <= 70092)))
                : (c <= 70106 || (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70199 || (c < 70272
                    ? c == 70206
                    : c <= 70278)))))
              : (c <= 70280 || (c < 70400
                ? (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c < 70384
                    ? (c >= 70320 && c <= 70378)
                    : c <= 70393)))
                : (c <= 70403 || (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : c <= 70451)))))))
            : (c <= 70457 || (c < 70784
              ? (c < 70493
                ? (c < 70475
                  ? (c < 70471
                    ? (c >= 70459 && c <= 70468)
                    : c <= 70472)
                  : (c <= 70477 || (c < 70487
                    ? c == 70480
                    : c <= 70487)))
                : (c <= 70499 || (c < 70656
                  ? (c < 70512
                    ? (c >= 70502 && c <= 70508)
                    : c <= 70516)
                  : (c <= 70730 || (c < 70750
                    ? (c >= 70736 && c <= 70745)
                    : c <= 70753)))))
              : (c <= 70853 || (c < 71168
                ? (c < 71040
                  ? (c < 70864
                    ? c == 70855
                    : c <= 70873)
                  : (c <= 71093 || (c < 71128
                    ? (c >= 71096 && c <= 71104)
                    : c <= 71133)))
                : (c <= 71232 || (c < 71296
                  ? (c < 71248
                    ? c == 71236
                    : c <= 71257)
                  : (c <= 71352 || (c < 71424
                    ? (c >= 71360 && c <= 71369)
                    : c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_14(int32_t c) {
  return (c < 43600
    ? (c < 3751
      ? (c < 2730
        ? (c < 1869
          ? (c < 908
            ? (c < 192
              ? (c < 'a'
                ? (c < '9'
                  ? (c < '0'
                    ? c == '$'
                    : c <= '7')
                  : (c <= '9' || (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')))
                : (c <= 'h' || (c < 181
                  ? (c < 170
                    ? (c >= 'j' && c <= 'z')
                    : c <= 170)
                  : (c <= 181 || (c < 186
                    ? c == 183
                    : c <= 186)))))
              : (c <= 214 || (c < 750
                ? (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)))
                : (c <= 750 || (c < 891
                  ? (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)
                  : (c <= 893 || (c < 902
                    ? c == 895
                    : c <= 906)))))))
            : (c <= 908 || (c < 1476
              ? (c < 1329
                ? (c < 1015
                  ? (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)
                  : (c <= 1153 || (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)))
                : (c <= 1366 || (c < 1425
                  ? (c < 1376
                    ? c == 1369
                    : c <= 1416)
                  : (c <= 1469 || (c < 1473
                    ? c == 1471
                    : c <= 1474)))))
              : (c <= 1477 || (c < 1646
                ? (c < 1519
                  ? (c < 1488
                    ? c == 1479
                    : c <= 1514)
                  : (c <= 1522 || (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)))
                : (c <= 1747 || (c < 1770
                  ? (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)
                  : (c <= 1788 || (c < 1808
                    ? c == 1791
                    : c <= 1866)))))))))
          : (c <= 1969 || (c < 2527
            ? (c < 2417
              ? (c < 2144
                ? (c < 2045
                  ? (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2045 || (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)))
                : (c <= 2154 || (c < 2200
                  ? (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)
                  : (c <= 2273 || (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)))))
              : (c <= 2435 || (c < 2486
                ? (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)))
                : (c <= 2489 || (c < 2507
                  ? (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)
                  : (c <= 2510 || (c < 2524
                    ? c == 2519
                    : c <= 2525)))))))
            : (c <= 2531 || (c < 2620
              ? (c < 2575
                ? (c < 2558
                  ? (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2558 || (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)))
                : (c <= 2576 || (c < 2610
                  ? (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)
                  : (c <= 2611 || (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)))))
              : (c <= 2620 || (c < 2654
                ? (c < 2635
                  ? (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)
                  : (c <= 2637 || (c < 2649
                    ? c == 2641
                    : c <= 2652)))
                : (c <= 2654 || (c < 2693
                  ? (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)
                  : (c <= 2701 || (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)))))))))))
        : (c <= 2736 || (c < 3157
          ? (c < 2929
            ? (c < 2831
              ? (c < 2768
                ? (c < 2748
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2757 || (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)))
                : (c <= 2768 || (c < 2809
                  ? (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)
                  : (c <= 2815 || (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)))))
              : (c <= 2832 || (c < 2887
                ? (c < 2866
                  ? (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)
                  : (c <= 2867 || (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)))
                : (c <= 2888 || (c < 2908
                  ? (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)
                  : (c <= 2909 || (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)))))))
            : (c <= 2929 || (c < 3014
              ? (c < 2972
                ? (c < 2958
                  ? (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)
                  : (c <= 2960 || (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)))
                : (c <= 2972 || (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)))))
              : (c <= 3016 || (c < 3086
                ? (c < 3031
                  ? (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)
                  : (c <= 3031 || (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)))
                : (c <= 3088 || (c < 3132
                  ? (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)
                  : (c <= 3140 || (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)))))))))
          : (c <= 3158 || (c < 3412
            ? (c < 3270
              ? (c < 3205
                ? (c < 3168
                  ? (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)
                  : (c <= 3171 || (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)))
                : (c <= 3212 || (c < 3242
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)
                  : (c <= 3251 || (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)))))
              : (c <= 3272 || (c < 3313
                ? (c < 3293
                  ? (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)
                  : (c <= 3294 || (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)))
                : (c <= 3314 || (c < 3346
                  ? (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)
                  : (c <= 3396 || (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)))))))
            : (c <= 3415 || (c < 3542
              ? (c < 3482
                ? (c < 3450
                  ? (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)
                  : (c <= 3455 || (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)))
                : (c <= 3505 || (c < 3520
                  ? (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)
                  : (c <= 3526 || (c < 3535
                    ? c == 3530
                    : c <= 3540)))))
              : (c <= 3542 || (c < 3664
                ? (c < 3570
                  ? (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)
                  : (c <= 3571 || (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)))
                : (c <= 3673 || (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)))))))))))))
      : (c <= 3773 || (c < 8008
        ? (c < 5792
          ? (c < 4348
            ? (c < 3902
              ? (c < 3840
                ? (c < 3784
                  ? (c < 3782
                    ? (c >= 3776 && c <= 3780)
                    : c <= 3782)
                  : (c <= 3789 || (c < 3804
                    ? (c >= 3792 && c <= 3801)
                    : c <= 3807)))
                : (c <= 3840 || (c < 3893
                  ? (c < 3872
                    ? (c >= 3864 && c <= 3865)
                    : c <= 3881)
                  : (c <= 3893 || (c < 3897
                    ? c == 3895
                    : c <= 3897)))))
              : (c <= 3911 || (c < 4096
                ? (c < 3974
                  ? (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)
                  : (c <= 3991 || (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : c <= 4038)))
                : (c <= 4169 || (c < 4295
                  ? (c < 4256
                    ? (c >= 4176 && c <= 4253)
                    : c <= 4293)
                  : (c <= 4295 || (c < 4304
                    ? c == 4301
                    : c <= 4346)))))))
            : (c <= 4680 || (c < 4808
              ? (c < 4746
                ? (c < 4696
                  ? (c < 4688
                    ? (c >= 4682 && c <= 4685)
                    : c <= 4694)
                  : (c <= 4696 || (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)))
                : (c <= 4749 || (c < 4792
                  ? (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)
                  : (c <= 4798 || (c < 4802
                    ? c == 4800
                    : c <= 4805)))))
              : (c <= 4822 || (c < 4992
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c < 4969
                    ? (c >= 4957 && c <= 4959)
                    : c <= 4977)))
                : (c <= 5007 || (c < 5121
                  ? (c < 5112
                    ? (c >= 5024 && c <= 5109)
                    : c <= 5117)
                  : (c <= 5740 || (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)))))))))
          : (c <= 5866 || (c < 6608
            ? (c < 6155
              ? (c < 5998
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5909)
                  : (c <= 5940 || (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : c <= 5996)))
                : (c <= 6000 || (c < 6103
                  ? (c < 6016
                    ? (c >= 6002 && c <= 6003)
                    : c <= 6099)
                  : (c <= 6103 || (c < 6112
                    ? (c >= 6108 && c <= 6109)
                    : c <= 6121)))))
              : (c <= 6157 || (c < 6432
                ? (c < 6272
                  ? (c < 6176
                    ? (c >= 6159 && c <= 6169)
                    : c <= 6264)
                  : (c <= 6314 || (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)))
                : (c <= 6443 || (c < 6512
                  ? (c < 6470
                    ? (c >= 6448 && c <= 6459)
                    : c <= 6509)
                  : (c <= 6516 || (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)))))))
            : (c <= 6618 || (c < 7040
              ? (c < 6823
                ? (c < 6752
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6683)
                    : c <= 6750)
                  : (c <= 6780 || (c < 6800
                    ? (c >= 6783 && c <= 6793)
                    : c <= 6809)))
                : (c <= 6823 || (c < 6912
                  ? (c < 6847
                    ? (c >= 6832 && c <= 6845)
                    : c <= 6862)
                  : (c <= 6988 || (c < 7019
                    ? (c >= 6992 && c <= 7001)
                    : c <= 7027)))))
              : (c <= 7155 || (c < 7357
                ? (c < 7245
                  ? (c < 7232
                    ? (c >= 7168 && c <= 7223)
                    : c <= 7241)
                  : (c <= 7293 || (c < 7312
                    ? (c >= 7296 && c <= 7304)
                    : c <= 7354)))
                : (c <= 7359 || (c < 7424
                  ? (c < 7380
                    ? (c >= 7376 && c <= 7378)
                    : c <= 7418)
                  : (c <= 7957 || (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)))))))))))
        : (c <= 8013 || (c < 11704
          ? (c < 8450
            ? (c < 8150
              ? (c < 8064
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || (c < 8031
                    ? c == 8029
                    : c <= 8061)))
                : (c <= 8116 || (c < 8130
                  ? (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)
                  : (c <= 8132 || (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)))))
              : (c <= 8155 || (c < 8305
                ? (c < 8182
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)
                  : (c <= 8188 || (c < 8276
                    ? (c >= 8255 && c <= 8256)
                    : c <= 8276)))
                : (c <= 8305 || (c < 8400
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8412 || (c < 8421
                    ? c == 8417
                    : c <= 8432)))))))
            : (c <= 8450 || (c < 8544
              ? (c < 8486
                ? (c < 8469
                  ? (c < 8458
                    ? c == 8455
                    : c <= 8467)
                  : (c <= 8469 || (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)))
                : (c <= 8486 || (c < 8508
                  ? (c < 8490
                    ? c == 8488
                    : c <= 8505)
                  : (c <= 8511 || (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)))))
              : (c <= 8584 || (c < 11568
                ? (c < 11520
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11507)
                  : (c <= 11557 || (c < 11565
                    ? c == 11559
                    : c <= 11565)))
                : (c <= 11623 || (c < 11680
                  ? (c < 11647
                    ? c == 11631
                    : c <= 11670)
                  : (c <= 11686 || (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)))))))))
          : (c <= 11710 || (c < 42560
            ? (c < 12445
              ? (c < 12293
                ? (c < 11728
                  ? (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)
                  : (c <= 11734 || (c < 11744
                    ? (c >= 11736 && c <= 11742)
                    : c <= 11775)))
                : (c <= 12295 || (c < 12344
                  ? (c < 12337
                    ? (c >= 12321 && c <= 12335)
                    : c <= 12341)
                  : (c <= 12348 || (c < 12441
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12442)))))
              : (c <= 12447 || (c < 12784
                ? (c < 12549
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)
                  : (c <= 12591 || (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)))
                : (c <= 12799 || (c < 42192
                  ? (c < 19968
                    ? (c >= 13312 && c <= 19903)
                    : c <= 42124)
                  : (c <= 42237 || (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42539)))))))
            : (c <= 42607 || (c < 43136
              ? (c < 42960
                ? (c < 42775
                  ? (c < 42623
                    ? (c >= 42612 && c <= 42621)
                    : c <= 42737)
                  : (c <= 42783 || (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42954)))
                : (c <= 42961 || (c < 42994
                  ? (c < 42965
                    ? c == 42963
                    : c <= 42969)
                  : (c <= 43047 || (c < 43072
                    ? c == 43052
                    : c <= 43123)))))
              : (c <= 43205 || (c < 43360
                ? (c < 43259
                  ? (c < 43232
                    ? (c >= 43216 && c <= 43225)
                    : c <= 43255)
                  : (c <= 43259 || (c < 43312
                    ? (c >= 43261 && c <= 43309)
                    : c <= 43347)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43392 && c <= 43456)
                    : c <= 43481)
                  : (c <= 43518 || (c < 43584
                    ? (c >= 43520 && c <= 43574)
                    : c <= 43597)))))))))))))))
    : (c <= 43609 || (c < 71453
      ? (c < 67594
        ? (c < 65343
          ? (c < 64298
            ? (c < 43868
              ? (c < 43777
                ? (c < 43739
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43714)
                  : (c <= 43741 || (c < 43762
                    ? (c >= 43744 && c <= 43759)
                    : c <= 43766)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)))))
              : (c <= 43881 || (c < 55243
                ? (c < 44016
                  ? (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : c <= 44013)
                  : (c <= 44025 || (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)))
                : (c <= 55291 || (c < 64256
                  ? (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)
                  : (c <= 64262 || (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64296)))))))
            : (c <= 64310 || (c < 65056
              ? (c < 64467
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)))
                : (c <= 64605 || (c < 64914
                  ? (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)
                  : (c <= 64967 || (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)))))
              : (c <= 65071 || (c < 65145
                ? (c < 65137
                  ? (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)
                  : (c <= 65137 || (c < 65143
                    ? c == 65139
                    : c <= 65143)))
                : (c <= 65145 || (c < 65151
                  ? (c < 65149
                    ? c == 65147
                    : c <= 65149)
                  : (c <= 65276 || (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)))))))))
          : (c <= 65343 || (c < 66504
            ? (c < 65616
              ? (c < 65498
                ? (c < 65474
                  ? (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)
                  : (c <= 65479 || (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)))))
              : (c <= 65629 || (c < 66272
                ? (c < 66045
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66045 || (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)))
                : (c <= 66272 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66426 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))))))
            : (c <= 66511 || (c < 66967
              ? (c < 66816
                ? (c < 66720
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66729 || (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)))
                : (c <= 66855 || (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)))))
              : (c <= 66977 || (c < 67424
                ? (c < 67003
                  ? (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)
                  : (c <= 67004 || (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)))
                : (c <= 67431 || (c < 67506
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : c <= 67504)
                  : (c <= 67514 || (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)))))))))))
        : (c <= 67637 || (c < 69942
          ? (c < 68416
            ? (c < 68096
              ? (c < 67808
                ? (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)))
                : (c <= 67826 || (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c < 68030
                    ? (c >= 67968 && c <= 68023)
                    : c <= 68031)))))
              : (c <= 68099 || (c < 68159
                ? (c < 68117
                  ? (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : c <= 68115)
                  : (c <= 68119 || (c < 68152
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68154)))
                : (c <= 68159 || (c < 68288
                  ? (c < 68224
                    ? (c >= 68192 && c <= 68220)
                    : c <= 68252)
                  : (c <= 68295 || (c < 68352
                    ? (c >= 68297 && c <= 68326)
                    : c <= 68405)))))))
            : (c <= 68437 || (c < 69415
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68903 || (c < 69291
                  ? (c < 69248
                    ? (c >= 68912 && c <= 68921)
                    : c <= 69289)
                  : (c <= 69292 || (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)))))
              : (c <= 69415 || (c < 69734
                ? (c < 69552
                  ? (c < 69488
                    ? (c >= 69424 && c <= 69456)
                    : c <= 69509)
                  : (c <= 69572 || (c < 69632
                    ? (c >= 69600 && c <= 69622)
                    : c <= 69702)))
                : (c <= 69749 || (c < 69840
                  ? (c < 69826
                    ? (c >= 69759 && c <= 69818)
                    : c <= 69826)
                  : (c <= 69864 || (c < 69888
                    ? (c >= 69872 && c <= 69881)
                    : c <= 69940)))))))))
          : (c <= 69951 || (c < 70453
            ? (c < 70280
              ? (c < 70094
                ? (c < 70006
                  ? (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)
                  : (c <= 70006 || (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : c <= 70092)))
                : (c <= 70106 || (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70199 || (c < 70272
                    ? c == 70206
                    : c <= 70278)))))
              : (c <= 70280 || (c < 70400
                ? (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c < 70384
                    ? (c >= 70320 && c <= 70378)
                    : c <= 70393)))
                : (c <= 70403 || (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : c <= 70451)))))))
            : (c <= 70457 || (c < 70784
              ? (c < 70493
                ? (c < 70475
                  ? (c < 70471
                    ? (c >= 70459 && c <= 70468)
                    : c <= 70472)
                  : (c <= 70477 || (c < 70487
                    ? c == 70480
                    : c <= 70487)))
                : (c <= 70499 || (c < 70656
                  ? (c < 70512
                    ? (c >= 70502 && c <= 70508)
                    : c <= 70516)
                  : (c <= 70730 || (c < 70750
                    ? (c >= 70736 && c <= 70745)
                    : c <= 70753)))))
              : (c <= 70853 || (c < 71168
                ? (c < 71040
                  ? (c < 70864
                    ? c == 70855
                    : c <= 70873)
                  : (c <= 71093 || (c < 71128
                    ? (c >= 71096 && c <= 71104)
                    : c <= 71133)))
                : (c <= 71232 || (c < 71296
                  ? (c < 71248
                    ? c == 71236
                    : c <= 71257)
                  : (c <= 71352 || (c < 71424
                    ? (c >= 71360 && c <= 71369)
                    : c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_15(int32_t c) {
  return (c < 43600
    ? (c < 3776
      ? (c < 2738
        ? (c < 1984
          ? (c < 910
            ? (c < 216
              ? (c < 'a'
                ? (c < '9'
                  ? (c < '0'
                    ? c == '$'
                    : c <= '7')
                  : (c <= '9' || (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')))
                : (c <= 'z' || (c < 183
                  ? (c < 181
                    ? c == 170
                    : c <= 181)
                  : (c <= 183 || (c < 192
                    ? c == 186
                    : c <= 214)))))
              : (c <= 246 || (c < 768
                ? (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || (c < 750
                    ? c == 748
                    : c <= 750)))
                : (c <= 884 || (c < 895
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)))))))
            : (c <= 929 || (c < 1479
              ? (c < 1369
                ? (c < 1155
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1159 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))
                : (c <= 1369 || (c < 1471
                  ? (c < 1425
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1469)
                  : (c <= 1471 || (c < 1476
                    ? (c >= 1473 && c <= 1474)
                    : c <= 1477)))))
              : (c <= 1479 || (c < 1749
                ? (c < 1552
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1562 || (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)))
                : (c <= 1756 || (c < 1791
                  ? (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : c <= 1788)
                  : (c <= 1791 || (c < 1869
                    ? (c >= 1808 && c <= 1866)
                    : c <= 1969)))))))))
          : (c <= 2037 || (c < 2534
            ? (c < 2437
              ? (c < 2160
                ? (c < 2048
                  ? (c < 2045
                    ? c == 2042
                    : c <= 2045)
                  : (c <= 2093 || (c < 2144
                    ? (c >= 2112 && c <= 2139)
                    : c <= 2154)))
                : (c <= 2183 || (c < 2275
                  ? (c < 2200
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2273)
                  : (c <= 2403 || (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)))))
              : (c <= 2444 || (c < 2492
                ? (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || (c < 2486
                    ? c == 2482
                    : c <= 2489)))
                : (c <= 2500 || (c < 2519
                  ? (c < 2507
                    ? (c >= 2503 && c <= 2504)
                    : c <= 2510)
                  : (c <= 2519 || (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2531)))))))
            : (c <= 2545 || (c < 2622
              ? (c < 2579
                ? (c < 2561
                  ? (c < 2558
                    ? c == 2556
                    : c <= 2558)
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)))))
              : (c <= 2626 || (c < 2662
                ? (c < 2641
                  ? (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)
                  : (c <= 2641 || (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)))
                : (c <= 2677 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)
                  : (c <= 2705 || (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)))))))))))
        : (c <= 2739 || (c < 3160
          ? (c < 2946
            ? (c < 2835
              ? (c < 2784
                ? (c < 2759
                  ? (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)
                  : (c <= 2761 || (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : c <= 2768)))
                : (c <= 2787 || (c < 2817
                  ? (c < 2809
                    ? (c >= 2790 && c <= 2799)
                    : c <= 2815)
                  : (c <= 2819 || (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)))))
              : (c <= 2856 || (c < 2891
                ? (c < 2869
                  ? (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)
                  : (c <= 2873 || (c < 2887
                    ? (c >= 2876 && c <= 2884)
                    : c <= 2888)))
                : (c <= 2893 || (c < 2911
                  ? (c < 2908
                    ? (c >= 2901 && c <= 2903)
                    : c <= 2909)
                  : (c <= 2915 || (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : c <= 2929)))))))
            : (c <= 2947 || (c < 3018
              ? (c < 2974
                ? (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)))
                : (c <= 2975 || (c < 2990
                  ? (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)
                  : (c <= 3001 || (c < 3014
                    ? (c >= 3006 && c <= 3010)
                    : c <= 3016)))))
              : (c <= 3021 || (c < 3090
                ? (c < 3046
                  ? (c < 3031
                    ? c == 3024
                    : c <= 3031)
                  : (c <= 3055 || (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : c <= 3088)))
                : (c <= 3112 || (c < 3142
                  ? (c < 3132
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3140)
                  : (c <= 3144 || (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)))))))))
          : (c <= 3162 || (c < 3423
            ? (c < 3274
              ? (c < 3214
                ? (c < 3174
                  ? (c < 3168
                    ? c == 3165
                    : c <= 3171)
                  : (c <= 3183 || (c < 3205
                    ? (c >= 3200 && c <= 3203)
                    : c <= 3212)))
                : (c <= 3216 || (c < 3253
                  ? (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)
                  : (c <= 3257 || (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)))))
              : (c <= 3277 || (c < 3328
                ? (c < 3296
                  ? (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : c <= 3294)
                  : (c <= 3299 || (c < 3313
                    ? (c >= 3302 && c <= 3311)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3398
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3396)
                  : (c <= 3400 || (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)))))))
            : (c <= 3427 || (c < 3544
              ? (c < 3507
                ? (c < 3457
                  ? (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)
                  : (c <= 3459 || (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)))
                : (c <= 3515 || (c < 3530
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3530 || (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)))))
              : (c <= 3551 || (c < 3713
                ? (c < 3585
                  ? (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)
                  : (c <= 3642 || (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)))
                : (c <= 3714 || (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || (c < 3751
                    ? c == 3749
                    : c <= 3773)))))))))))))
      : (c <= 3780 || (c < 8016
        ? (c < 5870
          ? (c < 4682
            ? (c < 3913
              ? (c < 3864
                ? (c < 3792
                  ? (c < 3784
                    ? c == 3782
                    : c <= 3789)
                  : (c <= 3801 || (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)))
                : (c <= 3865 || (c < 3895
                  ? (c < 3893
                    ? (c >= 3872 && c <= 3881)
                    : c <= 3893)
                  : (c <= 3895 || (c < 3902
                    ? c == 3897
                    : c <= 3911)))))
              : (c <= 3948 || (c < 4176
                ? (c < 3993
                  ? (c < 3974
                    ? (c >= 3953 && c <= 3972)
                    : c <= 3991)
                  : (c <= 4028 || (c < 4096
                    ? c == 4038
                    : c <= 4169)))
                : (c <= 4253 || (c < 4301
                  ? (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)
                  : (c <= 4301 || (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)))))))
            : (c <= 4685 || (c < 4824
              ? (c < 4752
                ? (c < 4698
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : c <= 4696)
                  : (c <= 4701 || (c < 4746
                    ? (c >= 4704 && c <= 4744)
                    : c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c < 4808
                    ? (c >= 4802 && c <= 4805)
                    : c <= 4822)))))
              : (c <= 4880 || (c < 5024
                ? (c < 4957
                  ? (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)
                  : (c <= 4959 || (c < 4992
                    ? (c >= 4969 && c <= 4977)
                    : c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)))))))))
          : (c <= 5880 || (c < 6656
            ? (c < 6159
              ? (c < 6002
                ? (c < 5952
                  ? (c < 5919
                    ? (c >= 5888 && c <= 5909)
                    : c <= 5940)
                  : (c <= 5971 || (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)))
                : (c <= 6003 || (c < 6108
                  ? (c < 6103
                    ? (c >= 6016 && c <= 6099)
                    : c <= 6103)
                  : (c <= 6109 || (c < 6155
                    ? (c >= 6112 && c <= 6121)
                    : c <= 6157)))))
              : (c <= 6169 || (c < 6448
                ? (c < 6320
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6432
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6443)))
                : (c <= 6459 || (c < 6528
                  ? (c < 6512
                    ? (c >= 6470 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c < 6608
                    ? (c >= 6576 && c <= 6601)
                    : c <= 6618)))))))
            : (c <= 6683 || (c < 7168
              ? (c < 6832
                ? (c < 6783
                  ? (c < 6752
                    ? (c >= 6688 && c <= 6750)
                    : c <= 6780)
                  : (c <= 6793 || (c < 6823
                    ? (c >= 6800 && c <= 6809)
                    : c <= 6823)))
                : (c <= 6845 || (c < 6992
                  ? (c < 6912
                    ? (c >= 6847 && c <= 6862)
                    : c <= 6988)
                  : (c <= 7001 || (c < 7040
                    ? (c >= 7019 && c <= 7027)
                    : c <= 7155)))))
              : (c <= 7223 || (c < 7376
                ? (c < 7296
                  ? (c < 7245
                    ? (c >= 7232 && c <= 7241)
                    : c <= 7293)
                  : (c <= 7304 || (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)))
                : (c <= 7378 || (c < 7960
                  ? (c < 7424
                    ? (c >= 7380 && c <= 7418)
                    : c <= 7957)
                  : (c <= 7965 || (c < 8008
                    ? (c >= 7968 && c <= 8005)
                    : c <= 8013)))))))))))
        : (c <= 8023 || (c < 11712
          ? (c < 8455
            ? (c < 8160
              ? (c < 8118
                ? (c < 8029
                  ? (c < 8027
                    ? c == 8025
                    : c <= 8027)
                  : (c <= 8029 || (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)))
                : (c <= 8124 || (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)))))
              : (c <= 8172 || (c < 8319
                ? (c < 8255
                  ? (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)
                  : (c <= 8256 || (c < 8305
                    ? c == 8276
                    : c <= 8305)))
                : (c <= 8319 || (c < 8417
                  ? (c < 8400
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8412)
                  : (c <= 8417 || (c < 8450
                    ? (c >= 8421 && c <= 8432)
                    : c <= 8450)))))))
            : (c <= 8455 || (c < 11264
              ? (c < 8488
                ? (c < 8472
                  ? (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)
                  : (c <= 8477 || (c < 8486
                    ? c == 8484
                    : c <= 8486)))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || (c < 8544
                    ? c == 8526
                    : c <= 8584)))))
              : (c <= 11492 || (c < 11631
                ? (c < 11559
                  ? (c < 11520
                    ? (c >= 11499 && c <= 11507)
                    : c <= 11557)
                  : (c <= 11559 || (c < 11568
                    ? c == 11565
                    : c <= 11623)))
                : (c <= 11631 || (c < 11688
                  ? (c < 11680
                    ? (c >= 11647 && c <= 11670)
                    : c <= 11686)
                  : (c <= 11694 || (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)))))))))
          : (c <= 11718 || (c < 42612
            ? (c < 12449
              ? (c < 12321
                ? (c < 11736
                  ? (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)
                  : (c <= 11742 || (c < 12293
                    ? (c >= 11744 && c <= 11775)
                    : c <= 12295)))
                : (c <= 12335 || (c < 12353
                  ? (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)
                  : (c <= 12438 || (c < 12445
                    ? (c >= 12441 && c <= 12442)
                    : c <= 12447)))))
              : (c <= 12538 || (c < 13312
                ? (c < 12593
                  ? (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)
                  : (c <= 12686 || (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)))
                : (c <= 19903 || (c < 42240
                  ? (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)
                  : (c <= 42508 || (c < 42560
                    ? (c >= 42512 && c <= 42539)
                    : c <= 42607)))))))
            : (c <= 42621 || (c < 43216
              ? (c < 42963
                ? (c < 42786
                  ? (c < 42775
                    ? (c >= 42623 && c <= 42737)
                    : c <= 42783)
                  : (c <= 42888 || (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)))
                : (c <= 42963 || (c < 43052
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43047)
                  : (c <= 43052 || (c < 43136
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43205)))))
              : (c <= 43225 || (c < 43392
                ? (c < 43261
                  ? (c < 43259
                    ? (c >= 43232 && c <= 43255)
                    : c <= 43259)
                  : (c <= 43309 || (c < 43360
                    ? (c >= 43312 && c <= 43347)
                    : c <= 43388)))
                : (c <= 43456 || (c < 43520
                  ? (c < 43488
                    ? (c >= 43471 && c <= 43481)
                    : c <= 43518)
                  : (c <= 43574 || (c >= 43584 && c <= 43597)))))))))))))))
    : (c <= 43609 || (c < 71453
      ? (c < 67594
        ? (c < 65343
          ? (c < 64298
            ? (c < 43868
              ? (c < 43777
                ? (c < 43739
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43714)
                  : (c <= 43741 || (c < 43762
                    ? (c >= 43744 && c <= 43759)
                    : c <= 43766)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)))))
              : (c <= 43881 || (c < 55243
                ? (c < 44016
                  ? (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : c <= 44013)
                  : (c <= 44025 || (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)))
                : (c <= 55291 || (c < 64256
                  ? (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)
                  : (c <= 64262 || (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64296)))))))
            : (c <= 64310 || (c < 65056
              ? (c < 64467
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)))
                : (c <= 64605 || (c < 64914
                  ? (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)
                  : (c <= 64967 || (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)))))
              : (c <= 65071 || (c < 65145
                ? (c < 65137
                  ? (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)
                  : (c <= 65137 || (c < 65143
                    ? c == 65139
                    : c <= 65143)))
                : (c <= 65145 || (c < 65151
                  ? (c < 65149
                    ? c == 65147
                    : c <= 65149)
                  : (c <= 65276 || (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)))))))))
          : (c <= 65343 || (c < 66504
            ? (c < 65616
              ? (c < 65498
                ? (c < 65474
                  ? (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)
                  : (c <= 65479 || (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)))))
              : (c <= 65629 || (c < 66272
                ? (c < 66045
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66045 || (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)))
                : (c <= 66272 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66426 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))))))
            : (c <= 66511 || (c < 66967
              ? (c < 66816
                ? (c < 66720
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66729 || (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)))
                : (c <= 66855 || (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)))))
              : (c <= 66977 || (c < 67424
                ? (c < 67003
                  ? (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)
                  : (c <= 67004 || (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)))
                : (c <= 67431 || (c < 67506
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : c <= 67504)
                  : (c <= 67514 || (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)))))))))))
        : (c <= 67637 || (c < 69942
          ? (c < 68416
            ? (c < 68096
              ? (c < 67808
                ? (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)))
                : (c <= 67826 || (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c < 68030
                    ? (c >= 67968 && c <= 68023)
                    : c <= 68031)))))
              : (c <= 68099 || (c < 68159
                ? (c < 68117
                  ? (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : c <= 68115)
                  : (c <= 68119 || (c < 68152
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68154)))
                : (c <= 68159 || (c < 68288
                  ? (c < 68224
                    ? (c >= 68192 && c <= 68220)
                    : c <= 68252)
                  : (c <= 68295 || (c < 68352
                    ? (c >= 68297 && c <= 68326)
                    : c <= 68405)))))))
            : (c <= 68437 || (c < 69415
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68903 || (c < 69291
                  ? (c < 69248
                    ? (c >= 68912 && c <= 68921)
                    : c <= 69289)
                  : (c <= 69292 || (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)))))
              : (c <= 69415 || (c < 69734
                ? (c < 69552
                  ? (c < 69488
                    ? (c >= 69424 && c <= 69456)
                    : c <= 69509)
                  : (c <= 69572 || (c < 69632
                    ? (c >= 69600 && c <= 69622)
                    : c <= 69702)))
                : (c <= 69749 || (c < 69840
                  ? (c < 69826
                    ? (c >= 69759 && c <= 69818)
                    : c <= 69826)
                  : (c <= 69864 || (c < 69888
                    ? (c >= 69872 && c <= 69881)
                    : c <= 69940)))))))))
          : (c <= 69951 || (c < 70453
            ? (c < 70280
              ? (c < 70094
                ? (c < 70006
                  ? (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)
                  : (c <= 70006 || (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : c <= 70092)))
                : (c <= 70106 || (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70199 || (c < 70272
                    ? c == 70206
                    : c <= 70278)))))
              : (c <= 70280 || (c < 70400
                ? (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c < 70384
                    ? (c >= 70320 && c <= 70378)
                    : c <= 70393)))
                : (c <= 70403 || (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : c <= 70451)))))))
            : (c <= 70457 || (c < 70784
              ? (c < 70493
                ? (c < 70475
                  ? (c < 70471
                    ? (c >= 70459 && c <= 70468)
                    : c <= 70472)
                  : (c <= 70477 || (c < 70487
                    ? c == 70480
                    : c <= 70487)))
                : (c <= 70499 || (c < 70656
                  ? (c < 70512
                    ? (c >= 70502 && c <= 70508)
                    : c <= 70516)
                  : (c <= 70730 || (c < 70750
                    ? (c >= 70736 && c <= 70745)
                    : c <= 70753)))))
              : (c <= 70853 || (c < 71168
                ? (c < 71040
                  ? (c < 70864
                    ? c == 70855
                    : c <= 70873)
                  : (c <= 71093 || (c < 71128
                    ? (c >= 71096 && c <= 71104)
                    : c <= 71133)))
                : (c <= 71232 || (c < 71296
                  ? (c < 71248
                    ? c == 71236
                    : c <= 71257)
                  : (c <= 71352 || (c < 71424
                    ? (c >= 71360 && c <= 71369)
                    : c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_16(int32_t c) {
  return (c < 43600
    ? (c < 3751
      ? (c < 2730
        ? (c < 1869
          ? (c < 908
            ? (c < 192
              ? (c < 'j'
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '$'
                    : c <= '9')
                  : (c <= 'Z' || (c < 'a'
                    ? c == '_'
                    : c <= 'h')))
                : (c <= 'r' || (c < 181
                  ? (c < 170
                    ? (c >= 't' && c <= 'z')
                    : c <= 170)
                  : (c <= 181 || (c < 186
                    ? c == 183
                    : c <= 186)))))
              : (c <= 214 || (c < 750
                ? (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)))
                : (c <= 750 || (c < 891
                  ? (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)
                  : (c <= 893 || (c < 902
                    ? c == 895
                    : c <= 906)))))))
            : (c <= 908 || (c < 1476
              ? (c < 1329
                ? (c < 1015
                  ? (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)
                  : (c <= 1153 || (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)))
                : (c <= 1366 || (c < 1425
                  ? (c < 1376
                    ? c == 1369
                    : c <= 1416)
                  : (c <= 1469 || (c < 1473
                    ? c == 1471
                    : c <= 1474)))))
              : (c <= 1477 || (c < 1646
                ? (c < 1519
                  ? (c < 1488
                    ? c == 1479
                    : c <= 1514)
                  : (c <= 1522 || (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)))
                : (c <= 1747 || (c < 1770
                  ? (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)
                  : (c <= 1788 || (c < 1808
                    ? c == 1791
                    : c <= 1866)))))))))
          : (c <= 1969 || (c < 2527
            ? (c < 2417
              ? (c < 2144
                ? (c < 2045
                  ? (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2045 || (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)))
                : (c <= 2154 || (c < 2200
                  ? (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)
                  : (c <= 2273 || (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)))))
              : (c <= 2435 || (c < 2486
                ? (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)))
                : (c <= 2489 || (c < 2507
                  ? (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)
                  : (c <= 2510 || (c < 2524
                    ? c == 2519
                    : c <= 2525)))))))
            : (c <= 2531 || (c < 2620
              ? (c < 2575
                ? (c < 2558
                  ? (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2558 || (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)))
                : (c <= 2576 || (c < 2610
                  ? (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)
                  : (c <= 2611 || (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)))))
              : (c <= 2620 || (c < 2654
                ? (c < 2635
                  ? (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)
                  : (c <= 2637 || (c < 2649
                    ? c == 2641
                    : c <= 2652)))
                : (c <= 2654 || (c < 2693
                  ? (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)
                  : (c <= 2701 || (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)))))))))))
        : (c <= 2736 || (c < 3157
          ? (c < 2929
            ? (c < 2831
              ? (c < 2768
                ? (c < 2748
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2757 || (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)))
                : (c <= 2768 || (c < 2809
                  ? (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)
                  : (c <= 2815 || (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)))))
              : (c <= 2832 || (c < 2887
                ? (c < 2866
                  ? (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)
                  : (c <= 2867 || (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)))
                : (c <= 2888 || (c < 2908
                  ? (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)
                  : (c <= 2909 || (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)))))))
            : (c <= 2929 || (c < 3014
              ? (c < 2972
                ? (c < 2958
                  ? (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)
                  : (c <= 2960 || (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)))
                : (c <= 2972 || (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)))))
              : (c <= 3016 || (c < 3086
                ? (c < 3031
                  ? (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)
                  : (c <= 3031 || (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)))
                : (c <= 3088 || (c < 3132
                  ? (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)
                  : (c <= 3140 || (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)))))))))
          : (c <= 3158 || (c < 3412
            ? (c < 3270
              ? (c < 3205
                ? (c < 3168
                  ? (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)
                  : (c <= 3171 || (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)))
                : (c <= 3212 || (c < 3242
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)
                  : (c <= 3251 || (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)))))
              : (c <= 3272 || (c < 3313
                ? (c < 3293
                  ? (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)
                  : (c <= 3294 || (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)))
                : (c <= 3314 || (c < 3346
                  ? (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)
                  : (c <= 3396 || (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)))))))
            : (c <= 3415 || (c < 3542
              ? (c < 3482
                ? (c < 3450
                  ? (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)
                  : (c <= 3455 || (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)))
                : (c <= 3505 || (c < 3520
                  ? (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)
                  : (c <= 3526 || (c < 3535
                    ? c == 3530
                    : c <= 3540)))))
              : (c <= 3542 || (c < 3664
                ? (c < 3570
                  ? (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)
                  : (c <= 3571 || (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)))
                : (c <= 3673 || (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)))))))))))))
      : (c <= 3773 || (c < 8008
        ? (c < 5792
          ? (c < 4348
            ? (c < 3902
              ? (c < 3840
                ? (c < 3784
                  ? (c < 3782
                    ? (c >= 3776 && c <= 3780)
                    : c <= 3782)
                  : (c <= 3789 || (c < 3804
                    ? (c >= 3792 && c <= 3801)
                    : c <= 3807)))
                : (c <= 3840 || (c < 3893
                  ? (c < 3872
                    ? (c >= 3864 && c <= 3865)
                    : c <= 3881)
                  : (c <= 3893 || (c < 3897
                    ? c == 3895
                    : c <= 3897)))))
              : (c <= 3911 || (c < 4096
                ? (c < 3974
                  ? (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)
                  : (c <= 3991 || (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : c <= 4038)))
                : (c <= 4169 || (c < 4295
                  ? (c < 4256
                    ? (c >= 4176 && c <= 4253)
                    : c <= 4293)
                  : (c <= 4295 || (c < 4304
                    ? c == 4301
                    : c <= 4346)))))))
            : (c <= 4680 || (c < 4808
              ? (c < 4746
                ? (c < 4696
                  ? (c < 4688
                    ? (c >= 4682 && c <= 4685)
                    : c <= 4694)
                  : (c <= 4696 || (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)))
                : (c <= 4749 || (c < 4792
                  ? (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)
                  : (c <= 4798 || (c < 4802
                    ? c == 4800
                    : c <= 4805)))))
              : (c <= 4822 || (c < 4992
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c < 4969
                    ? (c >= 4957 && c <= 4959)
                    : c <= 4977)))
                : (c <= 5007 || (c < 5121
                  ? (c < 5112
                    ? (c >= 5024 && c <= 5109)
                    : c <= 5117)
                  : (c <= 5740 || (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)))))))))
          : (c <= 5866 || (c < 6608
            ? (c < 6155
              ? (c < 5998
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5909)
                  : (c <= 5940 || (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : c <= 5996)))
                : (c <= 6000 || (c < 6103
                  ? (c < 6016
                    ? (c >= 6002 && c <= 6003)
                    : c <= 6099)
                  : (c <= 6103 || (c < 6112
                    ? (c >= 6108 && c <= 6109)
                    : c <= 6121)))))
              : (c <= 6157 || (c < 6432
                ? (c < 6272
                  ? (c < 6176
                    ? (c >= 6159 && c <= 6169)
                    : c <= 6264)
                  : (c <= 6314 || (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)))
                : (c <= 6443 || (c < 6512
                  ? (c < 6470
                    ? (c >= 6448 && c <= 6459)
                    : c <= 6509)
                  : (c <= 6516 || (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)))))))
            : (c <= 6618 || (c < 7040
              ? (c < 6823
                ? (c < 6752
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6683)
                    : c <= 6750)
                  : (c <= 6780 || (c < 6800
                    ? (c >= 6783 && c <= 6793)
                    : c <= 6809)))
                : (c <= 6823 || (c < 6912
                  ? (c < 6847
                    ? (c >= 6832 && c <= 6845)
                    : c <= 6862)
                  : (c <= 6988 || (c < 7019
                    ? (c >= 6992 && c <= 7001)
                    : c <= 7027)))))
              : (c <= 7155 || (c < 7357
                ? (c < 7245
                  ? (c < 7232
                    ? (c >= 7168 && c <= 7223)
                    : c <= 7241)
                  : (c <= 7293 || (c < 7312
                    ? (c >= 7296 && c <= 7304)
                    : c <= 7354)))
                : (c <= 7359 || (c < 7424
                  ? (c < 7380
                    ? (c >= 7376 && c <= 7378)
                    : c <= 7418)
                  : (c <= 7957 || (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)))))))))))
        : (c <= 8013 || (c < 11704
          ? (c < 8450
            ? (c < 8150
              ? (c < 8064
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || (c < 8031
                    ? c == 8029
                    : c <= 8061)))
                : (c <= 8116 || (c < 8130
                  ? (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)
                  : (c <= 8132 || (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)))))
              : (c <= 8155 || (c < 8305
                ? (c < 8182
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)
                  : (c <= 8188 || (c < 8276
                    ? (c >= 8255 && c <= 8256)
                    : c <= 8276)))
                : (c <= 8305 || (c < 8400
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8412 || (c < 8421
                    ? c == 8417
                    : c <= 8432)))))))
            : (c <= 8450 || (c < 8544
              ? (c < 8486
                ? (c < 8469
                  ? (c < 8458
                    ? c == 8455
                    : c <= 8467)
                  : (c <= 8469 || (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)))
                : (c <= 8486 || (c < 8508
                  ? (c < 8490
                    ? c == 8488
                    : c <= 8505)
                  : (c <= 8511 || (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)))))
              : (c <= 8584 || (c < 11568
                ? (c < 11520
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11507)
                  : (c <= 11557 || (c < 11565
                    ? c == 11559
                    : c <= 11565)))
                : (c <= 11623 || (c < 11680
                  ? (c < 11647
                    ? c == 11631
                    : c <= 11670)
                  : (c <= 11686 || (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)))))))))
          : (c <= 11710 || (c < 42560
            ? (c < 12445
              ? (c < 12293
                ? (c < 11728
                  ? (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)
                  : (c <= 11734 || (c < 11744
                    ? (c >= 11736 && c <= 11742)
                    : c <= 11775)))
                : (c <= 12295 || (c < 12344
                  ? (c < 12337
                    ? (c >= 12321 && c <= 12335)
                    : c <= 12341)
                  : (c <= 12348 || (c < 12441
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12442)))))
              : (c <= 12447 || (c < 12784
                ? (c < 12549
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)
                  : (c <= 12591 || (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)))
                : (c <= 12799 || (c < 42192
                  ? (c < 19968
                    ? (c >= 13312 && c <= 19903)
                    : c <= 42124)
                  : (c <= 42237 || (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42539)))))))
            : (c <= 42607 || (c < 43136
              ? (c < 42960
                ? (c < 42775
                  ? (c < 42623
                    ? (c >= 42612 && c <= 42621)
                    : c <= 42737)
                  : (c <= 42783 || (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42954)))
                : (c <= 42961 || (c < 42994
                  ? (c < 42965
                    ? c == 42963
                    : c <= 42969)
                  : (c <= 43047 || (c < 43072
                    ? c == 43052
                    : c <= 43123)))))
              : (c <= 43205 || (c < 43360
                ? (c < 43259
                  ? (c < 43232
                    ? (c >= 43216 && c <= 43225)
                    : c <= 43255)
                  : (c <= 43259 || (c < 43312
                    ? (c >= 43261 && c <= 43309)
                    : c <= 43347)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43392 && c <= 43456)
                    : c <= 43481)
                  : (c <= 43518 || (c < 43584
                    ? (c >= 43520 && c <= 43574)
                    : c <= 43597)))))))))))))))
    : (c <= 43609 || (c < 71453
      ? (c < 67594
        ? (c < 65343
          ? (c < 64298
            ? (c < 43868
              ? (c < 43777
                ? (c < 43739
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43714)
                  : (c <= 43741 || (c < 43762
                    ? (c >= 43744 && c <= 43759)
                    : c <= 43766)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)))))
              : (c <= 43881 || (c < 55243
                ? (c < 44016
                  ? (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : c <= 44013)
                  : (c <= 44025 || (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)))
                : (c <= 55291 || (c < 64256
                  ? (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)
                  : (c <= 64262 || (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64296)))))))
            : (c <= 64310 || (c < 65056
              ? (c < 64467
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)))
                : (c <= 64605 || (c < 64914
                  ? (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)
                  : (c <= 64967 || (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)))))
              : (c <= 65071 || (c < 65145
                ? (c < 65137
                  ? (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)
                  : (c <= 65137 || (c < 65143
                    ? c == 65139
                    : c <= 65143)))
                : (c <= 65145 || (c < 65151
                  ? (c < 65149
                    ? c == 65147
                    : c <= 65149)
                  : (c <= 65276 || (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)))))))))
          : (c <= 65343 || (c < 66504
            ? (c < 65616
              ? (c < 65498
                ? (c < 65474
                  ? (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)
                  : (c <= 65479 || (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)))))
              : (c <= 65629 || (c < 66272
                ? (c < 66045
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66045 || (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)))
                : (c <= 66272 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66426 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))))))
            : (c <= 66511 || (c < 66967
              ? (c < 66816
                ? (c < 66720
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66729 || (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)))
                : (c <= 66855 || (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)))))
              : (c <= 66977 || (c < 67424
                ? (c < 67003
                  ? (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)
                  : (c <= 67004 || (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)))
                : (c <= 67431 || (c < 67506
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : c <= 67504)
                  : (c <= 67514 || (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)))))))))))
        : (c <= 67637 || (c < 69942
          ? (c < 68416
            ? (c < 68096
              ? (c < 67808
                ? (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)))
                : (c <= 67826 || (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c < 68030
                    ? (c >= 67968 && c <= 68023)
                    : c <= 68031)))))
              : (c <= 68099 || (c < 68159
                ? (c < 68117
                  ? (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : c <= 68115)
                  : (c <= 68119 || (c < 68152
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68154)))
                : (c <= 68159 || (c < 68288
                  ? (c < 68224
                    ? (c >= 68192 && c <= 68220)
                    : c <= 68252)
                  : (c <= 68295 || (c < 68352
                    ? (c >= 68297 && c <= 68326)
                    : c <= 68405)))))))
            : (c <= 68437 || (c < 69415
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68903 || (c < 69291
                  ? (c < 69248
                    ? (c >= 68912 && c <= 68921)
                    : c <= 69289)
                  : (c <= 69292 || (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)))))
              : (c <= 69415 || (c < 69734
                ? (c < 69552
                  ? (c < 69488
                    ? (c >= 69424 && c <= 69456)
                    : c <= 69509)
                  : (c <= 69572 || (c < 69632
                    ? (c >= 69600 && c <= 69622)
                    : c <= 69702)))
                : (c <= 69749 || (c < 69840
                  ? (c < 69826
                    ? (c >= 69759 && c <= 69818)
                    : c <= 69826)
                  : (c <= 69864 || (c < 69888
                    ? (c >= 69872 && c <= 69881)
                    : c <= 69940)))))))))
          : (c <= 69951 || (c < 70453
            ? (c < 70280
              ? (c < 70094
                ? (c < 70006
                  ? (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)
                  : (c <= 70006 || (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : c <= 70092)))
                : (c <= 70106 || (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70199 || (c < 70272
                    ? c == 70206
                    : c <= 70278)))))
              : (c <= 70280 || (c < 70400
                ? (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c < 70384
                    ? (c >= 70320 && c <= 70378)
                    : c <= 70393)))
                : (c <= 70403 || (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : c <= 70451)))))))
            : (c <= 70457 || (c < 70784
              ? (c < 70493
                ? (c < 70475
                  ? (c < 70471
                    ? (c >= 70459 && c <= 70468)
                    : c <= 70472)
                  : (c <= 70477 || (c < 70487
                    ? c == 70480
                    : c <= 70487)))
                : (c <= 70499 || (c < 70656
                  ? (c < 70512
                    ? (c >= 70502 && c <= 70508)
                    : c <= 70516)
                  : (c <= 70730 || (c < 70750
                    ? (c >= 70736 && c <= 70745)
                    : c <= 70753)))))
              : (c <= 70853 || (c < 71168
                ? (c < 71040
                  ? (c < 70864
                    ? c == 70855
                    : c <= 70873)
                  : (c <= 71093 || (c < 71128
                    ? (c >= 71096 && c <= 71104)
                    : c <= 71133)))
                : (c <= 71232 || (c < 71296
                  ? (c < 71248
                    ? c == 71236
                    : c <= 71257)
                  : (c <= 71352 || (c < 71424
                    ? (c >= 71360 && c <= 71369)
                    : c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_17(int32_t c) {
  return (c < 43600
    ? (c < 3776
      ? (c < 2738
        ? (c < 1984
          ? (c < 910
            ? (c < 216
              ? (c < 'm'
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '$'
                    : c <= '9')
                  : (c <= 'Z' || (c < 'b'
                    ? c == '_'
                    : c <= 'k')))
                : (c <= 'z' || (c < 183
                  ? (c < 181
                    ? c == 170
                    : c <= 181)
                  : (c <= 183 || (c < 192
                    ? c == 186
                    : c <= 214)))))
              : (c <= 246 || (c < 768
                ? (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || (c < 750
                    ? c == 748
                    : c <= 750)))
                : (c <= 884 || (c < 895
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)))))))
            : (c <= 929 || (c < 1479
              ? (c < 1369
                ? (c < 1155
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1159 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))
                : (c <= 1369 || (c < 1471
                  ? (c < 1425
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1469)
                  : (c <= 1471 || (c < 1476
                    ? (c >= 1473 && c <= 1474)
                    : c <= 1477)))))
              : (c <= 1479 || (c < 1749
                ? (c < 1552
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1562 || (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)))
                : (c <= 1756 || (c < 1791
                  ? (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : c <= 1788)
                  : (c <= 1791 || (c < 1869
                    ? (c >= 1808 && c <= 1866)
                    : c <= 1969)))))))))
          : (c <= 2037 || (c < 2534
            ? (c < 2437
              ? (c < 2160
                ? (c < 2048
                  ? (c < 2045
                    ? c == 2042
                    : c <= 2045)
                  : (c <= 2093 || (c < 2144
                    ? (c >= 2112 && c <= 2139)
                    : c <= 2154)))
                : (c <= 2183 || (c < 2275
                  ? (c < 2200
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2273)
                  : (c <= 2403 || (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)))))
              : (c <= 2444 || (c < 2492
                ? (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || (c < 2486
                    ? c == 2482
                    : c <= 2489)))
                : (c <= 2500 || (c < 2519
                  ? (c < 2507
                    ? (c >= 2503 && c <= 2504)
                    : c <= 2510)
                  : (c <= 2519 || (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2531)))))))
            : (c <= 2545 || (c < 2622
              ? (c < 2579
                ? (c < 2561
                  ? (c < 2558
                    ? c == 2556
                    : c <= 2558)
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)))))
              : (c <= 2626 || (c < 2662
                ? (c < 2641
                  ? (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)
                  : (c <= 2641 || (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)))
                : (c <= 2677 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)
                  : (c <= 2705 || (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)))))))))))
        : (c <= 2739 || (c < 3160
          ? (c < 2946
            ? (c < 2835
              ? (c < 2784
                ? (c < 2759
                  ? (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)
                  : (c <= 2761 || (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : c <= 2768)))
                : (c <= 2787 || (c < 2817
                  ? (c < 2809
                    ? (c >= 2790 && c <= 2799)
                    : c <= 2815)
                  : (c <= 2819 || (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)))))
              : (c <= 2856 || (c < 2891
                ? (c < 2869
                  ? (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)
                  : (c <= 2873 || (c < 2887
                    ? (c >= 2876 && c <= 2884)
                    : c <= 2888)))
                : (c <= 2893 || (c < 2911
                  ? (c < 2908
                    ? (c >= 2901 && c <= 2903)
                    : c <= 2909)
                  : (c <= 2915 || (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : c <= 2929)))))))
            : (c <= 2947 || (c < 3018
              ? (c < 2974
                ? (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)))
                : (c <= 2975 || (c < 2990
                  ? (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)
                  : (c <= 3001 || (c < 3014
                    ? (c >= 3006 && c <= 3010)
                    : c <= 3016)))))
              : (c <= 3021 || (c < 3090
                ? (c < 3046
                  ? (c < 3031
                    ? c == 3024
                    : c <= 3031)
                  : (c <= 3055 || (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : c <= 3088)))
                : (c <= 3112 || (c < 3142
                  ? (c < 3132
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3140)
                  : (c <= 3144 || (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)))))))))
          : (c <= 3162 || (c < 3423
            ? (c < 3274
              ? (c < 3214
                ? (c < 3174
                  ? (c < 3168
                    ? c == 3165
                    : c <= 3171)
                  : (c <= 3183 || (c < 3205
                    ? (c >= 3200 && c <= 3203)
                    : c <= 3212)))
                : (c <= 3216 || (c < 3253
                  ? (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)
                  : (c <= 3257 || (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)))))
              : (c <= 3277 || (c < 3328
                ? (c < 3296
                  ? (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : c <= 3294)
                  : (c <= 3299 || (c < 3313
                    ? (c >= 3302 && c <= 3311)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3398
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3396)
                  : (c <= 3400 || (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)))))))
            : (c <= 3427 || (c < 3544
              ? (c < 3507
                ? (c < 3457
                  ? (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)
                  : (c <= 3459 || (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)))
                : (c <= 3515 || (c < 3530
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3530 || (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)))))
              : (c <= 3551 || (c < 3713
                ? (c < 3585
                  ? (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)
                  : (c <= 3642 || (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)))
                : (c <= 3714 || (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || (c < 3751
                    ? c == 3749
                    : c <= 3773)))))))))))))
      : (c <= 3780 || (c < 8016
        ? (c < 5870
          ? (c < 4682
            ? (c < 3913
              ? (c < 3864
                ? (c < 3792
                  ? (c < 3784
                    ? c == 3782
                    : c <= 3789)
                  : (c <= 3801 || (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)))
                : (c <= 3865 || (c < 3895
                  ? (c < 3893
                    ? (c >= 3872 && c <= 3881)
                    : c <= 3893)
                  : (c <= 3895 || (c < 3902
                    ? c == 3897
                    : c <= 3911)))))
              : (c <= 3948 || (c < 4176
                ? (c < 3993
                  ? (c < 3974
                    ? (c >= 3953 && c <= 3972)
                    : c <= 3991)
                  : (c <= 4028 || (c < 4096
                    ? c == 4038
                    : c <= 4169)))
                : (c <= 4253 || (c < 4301
                  ? (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)
                  : (c <= 4301 || (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)))))))
            : (c <= 4685 || (c < 4824
              ? (c < 4752
                ? (c < 4698
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : c <= 4696)
                  : (c <= 4701 || (c < 4746
                    ? (c >= 4704 && c <= 4744)
                    : c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c < 4808
                    ? (c >= 4802 && c <= 4805)
                    : c <= 4822)))))
              : (c <= 4880 || (c < 5024
                ? (c < 4957
                  ? (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)
                  : (c <= 4959 || (c < 4992
                    ? (c >= 4969 && c <= 4977)
                    : c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)))))))))
          : (c <= 5880 || (c < 6656
            ? (c < 6159
              ? (c < 6002
                ? (c < 5952
                  ? (c < 5919
                    ? (c >= 5888 && c <= 5909)
                    : c <= 5940)
                  : (c <= 5971 || (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)))
                : (c <= 6003 || (c < 6108
                  ? (c < 6103
                    ? (c >= 6016 && c <= 6099)
                    : c <= 6103)
                  : (c <= 6109 || (c < 6155
                    ? (c >= 6112 && c <= 6121)
                    : c <= 6157)))))
              : (c <= 6169 || (c < 6448
                ? (c < 6320
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6432
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6443)))
                : (c <= 6459 || (c < 6528
                  ? (c < 6512
                    ? (c >= 6470 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c < 6608
                    ? (c >= 6576 && c <= 6601)
                    : c <= 6618)))))))
            : (c <= 6683 || (c < 7168
              ? (c < 6832
                ? (c < 6783
                  ? (c < 6752
                    ? (c >= 6688 && c <= 6750)
                    : c <= 6780)
                  : (c <= 6793 || (c < 6823
                    ? (c >= 6800 && c <= 6809)
                    : c <= 6823)))
                : (c <= 6845 || (c < 6992
                  ? (c < 6912
                    ? (c >= 6847 && c <= 6862)
                    : c <= 6988)
                  : (c <= 7001 || (c < 7040
                    ? (c >= 7019 && c <= 7027)
                    : c <= 7155)))))
              : (c <= 7223 || (c < 7376
                ? (c < 7296
                  ? (c < 7245
                    ? (c >= 7232 && c <= 7241)
                    : c <= 7293)
                  : (c <= 7304 || (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)))
                : (c <= 7378 || (c < 7960
                  ? (c < 7424
                    ? (c >= 7380 && c <= 7418)
                    : c <= 7957)
                  : (c <= 7965 || (c < 8008
                    ? (c >= 7968 && c <= 8005)
                    : c <= 8013)))))))))))
        : (c <= 8023 || (c < 11712
          ? (c < 8455
            ? (c < 8160
              ? (c < 8118
                ? (c < 8029
                  ? (c < 8027
                    ? c == 8025
                    : c <= 8027)
                  : (c <= 8029 || (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)))
                : (c <= 8124 || (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)))))
              : (c <= 8172 || (c < 8319
                ? (c < 8255
                  ? (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)
                  : (c <= 8256 || (c < 8305
                    ? c == 8276
                    : c <= 8305)))
                : (c <= 8319 || (c < 8417
                  ? (c < 8400
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8412)
                  : (c <= 8417 || (c < 8450
                    ? (c >= 8421 && c <= 8432)
                    : c <= 8450)))))))
            : (c <= 8455 || (c < 11264
              ? (c < 8488
                ? (c < 8472
                  ? (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)
                  : (c <= 8477 || (c < 8486
                    ? c == 8484
                    : c <= 8486)))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || (c < 8544
                    ? c == 8526
                    : c <= 8584)))))
              : (c <= 11492 || (c < 11631
                ? (c < 11559
                  ? (c < 11520
                    ? (c >= 11499 && c <= 11507)
                    : c <= 11557)
                  : (c <= 11559 || (c < 11568
                    ? c == 11565
                    : c <= 11623)))
                : (c <= 11631 || (c < 11688
                  ? (c < 11680
                    ? (c >= 11647 && c <= 11670)
                    : c <= 11686)
                  : (c <= 11694 || (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)))))))))
          : (c <= 11718 || (c < 42612
            ? (c < 12449
              ? (c < 12321
                ? (c < 11736
                  ? (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)
                  : (c <= 11742 || (c < 12293
                    ? (c >= 11744 && c <= 11775)
                    : c <= 12295)))
                : (c <= 12335 || (c < 12353
                  ? (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)
                  : (c <= 12438 || (c < 12445
                    ? (c >= 12441 && c <= 12442)
                    : c <= 12447)))))
              : (c <= 12538 || (c < 13312
                ? (c < 12593
                  ? (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)
                  : (c <= 12686 || (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)))
                : (c <= 19903 || (c < 42240
                  ? (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)
                  : (c <= 42508 || (c < 42560
                    ? (c >= 42512 && c <= 42539)
                    : c <= 42607)))))))
            : (c <= 42621 || (c < 43216
              ? (c < 42963
                ? (c < 42786
                  ? (c < 42775
                    ? (c >= 42623 && c <= 42737)
                    : c <= 42783)
                  : (c <= 42888 || (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)))
                : (c <= 42963 || (c < 43052
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43047)
                  : (c <= 43052 || (c < 43136
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43205)))))
              : (c <= 43225 || (c < 43392
                ? (c < 43261
                  ? (c < 43259
                    ? (c >= 43232 && c <= 43255)
                    : c <= 43259)
                  : (c <= 43309 || (c < 43360
                    ? (c >= 43312 && c <= 43347)
                    : c <= 43388)))
                : (c <= 43456 || (c < 43520
                  ? (c < 43488
                    ? (c >= 43471 && c <= 43481)
                    : c <= 43518)
                  : (c <= 43574 || (c >= 43584 && c <= 43597)))))))))))))))
    : (c <= 43609 || (c < 71453
      ? (c < 67594
        ? (c < 65343
          ? (c < 64298
            ? (c < 43868
              ? (c < 43777
                ? (c < 43739
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43714)
                  : (c <= 43741 || (c < 43762
                    ? (c >= 43744 && c <= 43759)
                    : c <= 43766)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)))))
              : (c <= 43881 || (c < 55243
                ? (c < 44016
                  ? (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : c <= 44013)
                  : (c <= 44025 || (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)))
                : (c <= 55291 || (c < 64256
                  ? (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)
                  : (c <= 64262 || (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64296)))))))
            : (c <= 64310 || (c < 65056
              ? (c < 64467
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)))
                : (c <= 64605 || (c < 64914
                  ? (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)
                  : (c <= 64967 || (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)))))
              : (c <= 65071 || (c < 65145
                ? (c < 65137
                  ? (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)
                  : (c <= 65137 || (c < 65143
                    ? c == 65139
                    : c <= 65143)))
                : (c <= 65145 || (c < 65151
                  ? (c < 65149
                    ? c == 65147
                    : c <= 65149)
                  : (c <= 65276 || (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)))))))))
          : (c <= 65343 || (c < 66504
            ? (c < 65616
              ? (c < 65498
                ? (c < 65474
                  ? (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)
                  : (c <= 65479 || (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)))))
              : (c <= 65629 || (c < 66272
                ? (c < 66045
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66045 || (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)))
                : (c <= 66272 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66426 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))))))
            : (c <= 66511 || (c < 66967
              ? (c < 66816
                ? (c < 66720
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66729 || (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)))
                : (c <= 66855 || (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)))))
              : (c <= 66977 || (c < 67424
                ? (c < 67003
                  ? (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)
                  : (c <= 67004 || (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)))
                : (c <= 67431 || (c < 67506
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : c <= 67504)
                  : (c <= 67514 || (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)))))))))))
        : (c <= 67637 || (c < 69942
          ? (c < 68416
            ? (c < 68096
              ? (c < 67808
                ? (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)))
                : (c <= 67826 || (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c < 68030
                    ? (c >= 67968 && c <= 68023)
                    : c <= 68031)))))
              : (c <= 68099 || (c < 68159
                ? (c < 68117
                  ? (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : c <= 68115)
                  : (c <= 68119 || (c < 68152
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68154)))
                : (c <= 68159 || (c < 68288
                  ? (c < 68224
                    ? (c >= 68192 && c <= 68220)
                    : c <= 68252)
                  : (c <= 68295 || (c < 68352
                    ? (c >= 68297 && c <= 68326)
                    : c <= 68405)))))))
            : (c <= 68437 || (c < 69415
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68903 || (c < 69291
                  ? (c < 69248
                    ? (c >= 68912 && c <= 68921)
                    : c <= 69289)
                  : (c <= 69292 || (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)))))
              : (c <= 69415 || (c < 69734
                ? (c < 69552
                  ? (c < 69488
                    ? (c >= 69424 && c <= 69456)
                    : c <= 69509)
                  : (c <= 69572 || (c < 69632
                    ? (c >= 69600 && c <= 69622)
                    : c <= 69702)))
                : (c <= 69749 || (c < 69840
                  ? (c < 69826
                    ? (c >= 69759 && c <= 69818)
                    : c <= 69826)
                  : (c <= 69864 || (c < 69888
                    ? (c >= 69872 && c <= 69881)
                    : c <= 69940)))))))))
          : (c <= 69951 || (c < 70453
            ? (c < 70280
              ? (c < 70094
                ? (c < 70006
                  ? (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)
                  : (c <= 70006 || (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : c <= 70092)))
                : (c <= 70106 || (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70199 || (c < 70272
                    ? c == 70206
                    : c <= 70278)))))
              : (c <= 70280 || (c < 70400
                ? (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c < 70384
                    ? (c >= 70320 && c <= 70378)
                    : c <= 70393)))
                : (c <= 70403 || (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : c <= 70451)))))))
            : (c <= 70457 || (c < 70784
              ? (c < 70493
                ? (c < 70475
                  ? (c < 70471
                    ? (c >= 70459 && c <= 70468)
                    : c <= 70472)
                  : (c <= 70477 || (c < 70487
                    ? c == 70480
                    : c <= 70487)))
                : (c <= 70499 || (c < 70656
                  ? (c < 70512
                    ? (c >= 70502 && c <= 70508)
                    : c <= 70516)
                  : (c <= 70730 || (c < 70750
                    ? (c >= 70736 && c <= 70745)
                    : c <= 70753)))))
              : (c <= 70853 || (c < 71168
                ? (c < 71040
                  ? (c < 70864
                    ? c == 70855
                    : c <= 70873)
                  : (c <= 71093 || (c < 71128
                    ? (c >= 71096 && c <= 71104)
                    : c <= 71133)))
                : (c <= 71232 || (c < 71296
                  ? (c < 71248
                    ? c == 71236
                    : c <= 71257)
                  : (c <= 71352 || (c < 71424
                    ? (c >= 71360 && c <= 71369)
                    : c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_18(int32_t c) {
  return (c < 43600
    ? (c < 3776
      ? (c < 2738
        ? (c < 1984
          ? (c < 910
            ? (c < 216
              ? (c < 'a'
                ? (c < '3'
                  ? (c < '0'
                    ? c == '$'
                    : c <= '1')
                  : (c <= '9' || (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')))
                : (c <= 'z' || (c < 183
                  ? (c < 181
                    ? c == 170
                    : c <= 181)
                  : (c <= 183 || (c < 192
                    ? c == 186
                    : c <= 214)))))
              : (c <= 246 || (c < 768
                ? (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || (c < 750
                    ? c == 748
                    : c <= 750)))
                : (c <= 884 || (c < 895
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)))))))
            : (c <= 929 || (c < 1479
              ? (c < 1369
                ? (c < 1155
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1159 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))
                : (c <= 1369 || (c < 1471
                  ? (c < 1425
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1469)
                  : (c <= 1471 || (c < 1476
                    ? (c >= 1473 && c <= 1474)
                    : c <= 1477)))))
              : (c <= 1479 || (c < 1749
                ? (c < 1552
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1562 || (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)))
                : (c <= 1756 || (c < 1791
                  ? (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : c <= 1788)
                  : (c <= 1791 || (c < 1869
                    ? (c >= 1808 && c <= 1866)
                    : c <= 1969)))))))))
          : (c <= 2037 || (c < 2534
            ? (c < 2437
              ? (c < 2160
                ? (c < 2048
                  ? (c < 2045
                    ? c == 2042
                    : c <= 2045)
                  : (c <= 2093 || (c < 2144
                    ? (c >= 2112 && c <= 2139)
                    : c <= 2154)))
                : (c <= 2183 || (c < 2275
                  ? (c < 2200
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2273)
                  : (c <= 2403 || (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)))))
              : (c <= 2444 || (c < 2492
                ? (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || (c < 2486
                    ? c == 2482
                    : c <= 2489)))
                : (c <= 2500 || (c < 2519
                  ? (c < 2507
                    ? (c >= 2503 && c <= 2504)
                    : c <= 2510)
                  : (c <= 2519 || (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2531)))))))
            : (c <= 2545 || (c < 2622
              ? (c < 2579
                ? (c < 2561
                  ? (c < 2558
                    ? c == 2556
                    : c <= 2558)
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)))))
              : (c <= 2626 || (c < 2662
                ? (c < 2641
                  ? (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)
                  : (c <= 2641 || (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)))
                : (c <= 2677 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)
                  : (c <= 2705 || (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)))))))))))
        : (c <= 2739 || (c < 3160
          ? (c < 2946
            ? (c < 2835
              ? (c < 2784
                ? (c < 2759
                  ? (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)
                  : (c <= 2761 || (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : c <= 2768)))
                : (c <= 2787 || (c < 2817
                  ? (c < 2809
                    ? (c >= 2790 && c <= 2799)
                    : c <= 2815)
                  : (c <= 2819 || (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)))))
              : (c <= 2856 || (c < 2891
                ? (c < 2869
                  ? (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)
                  : (c <= 2873 || (c < 2887
                    ? (c >= 2876 && c <= 2884)
                    : c <= 2888)))
                : (c <= 2893 || (c < 2911
                  ? (c < 2908
                    ? (c >= 2901 && c <= 2903)
                    : c <= 2909)
                  : (c <= 2915 || (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : c <= 2929)))))))
            : (c <= 2947 || (c < 3018
              ? (c < 2974
                ? (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)))
                : (c <= 2975 || (c < 2990
                  ? (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)
                  : (c <= 3001 || (c < 3014
                    ? (c >= 3006 && c <= 3010)
                    : c <= 3016)))))
              : (c <= 3021 || (c < 3090
                ? (c < 3046
                  ? (c < 3031
                    ? c == 3024
                    : c <= 3031)
                  : (c <= 3055 || (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : c <= 3088)))
                : (c <= 3112 || (c < 3142
                  ? (c < 3132
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3140)
                  : (c <= 3144 || (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)))))))))
          : (c <= 3162 || (c < 3423
            ? (c < 3274
              ? (c < 3214
                ? (c < 3174
                  ? (c < 3168
                    ? c == 3165
                    : c <= 3171)
                  : (c <= 3183 || (c < 3205
                    ? (c >= 3200 && c <= 3203)
                    : c <= 3212)))
                : (c <= 3216 || (c < 3253
                  ? (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)
                  : (c <= 3257 || (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)))))
              : (c <= 3277 || (c < 3328
                ? (c < 3296
                  ? (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : c <= 3294)
                  : (c <= 3299 || (c < 3313
                    ? (c >= 3302 && c <= 3311)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3398
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3396)
                  : (c <= 3400 || (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)))))))
            : (c <= 3427 || (c < 3544
              ? (c < 3507
                ? (c < 3457
                  ? (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)
                  : (c <= 3459 || (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)))
                : (c <= 3515 || (c < 3530
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3530 || (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)))))
              : (c <= 3551 || (c < 3713
                ? (c < 3585
                  ? (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)
                  : (c <= 3642 || (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)))
                : (c <= 3714 || (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || (c < 3751
                    ? c == 3749
                    : c <= 3773)))))))))))))
      : (c <= 3780 || (c < 8016
        ? (c < 5870
          ? (c < 4682
            ? (c < 3913
              ? (c < 3864
                ? (c < 3792
                  ? (c < 3784
                    ? c == 3782
                    : c <= 3789)
                  : (c <= 3801 || (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)))
                : (c <= 3865 || (c < 3895
                  ? (c < 3893
                    ? (c >= 3872 && c <= 3881)
                    : c <= 3893)
                  : (c <= 3895 || (c < 3902
                    ? c == 3897
                    : c <= 3911)))))
              : (c <= 3948 || (c < 4176
                ? (c < 3993
                  ? (c < 3974
                    ? (c >= 3953 && c <= 3972)
                    : c <= 3991)
                  : (c <= 4028 || (c < 4096
                    ? c == 4038
                    : c <= 4169)))
                : (c <= 4253 || (c < 4301
                  ? (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)
                  : (c <= 4301 || (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)))))))
            : (c <= 4685 || (c < 4824
              ? (c < 4752
                ? (c < 4698
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : c <= 4696)
                  : (c <= 4701 || (c < 4746
                    ? (c >= 4704 && c <= 4744)
                    : c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c < 4808
                    ? (c >= 4802 && c <= 4805)
                    : c <= 4822)))))
              : (c <= 4880 || (c < 5024
                ? (c < 4957
                  ? (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)
                  : (c <= 4959 || (c < 4992
                    ? (c >= 4969 && c <= 4977)
                    : c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)))))))))
          : (c <= 5880 || (c < 6656
            ? (c < 6159
              ? (c < 6002
                ? (c < 5952
                  ? (c < 5919
                    ? (c >= 5888 && c <= 5909)
                    : c <= 5940)
                  : (c <= 5971 || (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)))
                : (c <= 6003 || (c < 6108
                  ? (c < 6103
                    ? (c >= 6016 && c <= 6099)
                    : c <= 6103)
                  : (c <= 6109 || (c < 6155
                    ? (c >= 6112 && c <= 6121)
                    : c <= 6157)))))
              : (c <= 6169 || (c < 6448
                ? (c < 6320
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6432
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6443)))
                : (c <= 6459 || (c < 6528
                  ? (c < 6512
                    ? (c >= 6470 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c < 6608
                    ? (c >= 6576 && c <= 6601)
                    : c <= 6618)))))))
            : (c <= 6683 || (c < 7168
              ? (c < 6832
                ? (c < 6783
                  ? (c < 6752
                    ? (c >= 6688 && c <= 6750)
                    : c <= 6780)
                  : (c <= 6793 || (c < 6823
                    ? (c >= 6800 && c <= 6809)
                    : c <= 6823)))
                : (c <= 6845 || (c < 6992
                  ? (c < 6912
                    ? (c >= 6847 && c <= 6862)
                    : c <= 6988)
                  : (c <= 7001 || (c < 7040
                    ? (c >= 7019 && c <= 7027)
                    : c <= 7155)))))
              : (c <= 7223 || (c < 7376
                ? (c < 7296
                  ? (c < 7245
                    ? (c >= 7232 && c <= 7241)
                    : c <= 7293)
                  : (c <= 7304 || (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)))
                : (c <= 7378 || (c < 7960
                  ? (c < 7424
                    ? (c >= 7380 && c <= 7418)
                    : c <= 7957)
                  : (c <= 7965 || (c < 8008
                    ? (c >= 7968 && c <= 8005)
                    : c <= 8013)))))))))))
        : (c <= 8023 || (c < 11712
          ? (c < 8455
            ? (c < 8160
              ? (c < 8118
                ? (c < 8029
                  ? (c < 8027
                    ? c == 8025
                    : c <= 8027)
                  : (c <= 8029 || (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)))
                : (c <= 8124 || (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)))))
              : (c <= 8172 || (c < 8319
                ? (c < 8255
                  ? (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)
                  : (c <= 8256 || (c < 8305
                    ? c == 8276
                    : c <= 8305)))
                : (c <= 8319 || (c < 8417
                  ? (c < 8400
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8412)
                  : (c <= 8417 || (c < 8450
                    ? (c >= 8421 && c <= 8432)
                    : c <= 8450)))))))
            : (c <= 8455 || (c < 11264
              ? (c < 8488
                ? (c < 8472
                  ? (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)
                  : (c <= 8477 || (c < 8486
                    ? c == 8484
                    : c <= 8486)))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || (c < 8544
                    ? c == 8526
                    : c <= 8584)))))
              : (c <= 11492 || (c < 11631
                ? (c < 11559
                  ? (c < 11520
                    ? (c >= 11499 && c <= 11507)
                    : c <= 11557)
                  : (c <= 11559 || (c < 11568
                    ? c == 11565
                    : c <= 11623)))
                : (c <= 11631 || (c < 11688
                  ? (c < 11680
                    ? (c >= 11647 && c <= 11670)
                    : c <= 11686)
                  : (c <= 11694 || (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)))))))))
          : (c <= 11718 || (c < 42612
            ? (c < 12449
              ? (c < 12321
                ? (c < 11736
                  ? (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)
                  : (c <= 11742 || (c < 12293
                    ? (c >= 11744 && c <= 11775)
                    : c <= 12295)))
                : (c <= 12335 || (c < 12353
                  ? (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)
                  : (c <= 12438 || (c < 12445
                    ? (c >= 12441 && c <= 12442)
                    : c <= 12447)))))
              : (c <= 12538 || (c < 13312
                ? (c < 12593
                  ? (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)
                  : (c <= 12686 || (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)))
                : (c <= 19903 || (c < 42240
                  ? (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)
                  : (c <= 42508 || (c < 42560
                    ? (c >= 42512 && c <= 42539)
                    : c <= 42607)))))))
            : (c <= 42621 || (c < 43216
              ? (c < 42963
                ? (c < 42786
                  ? (c < 42775
                    ? (c >= 42623 && c <= 42737)
                    : c <= 42783)
                  : (c <= 42888 || (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)))
                : (c <= 42963 || (c < 43052
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43047)
                  : (c <= 43052 || (c < 43136
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43205)))))
              : (c <= 43225 || (c < 43392
                ? (c < 43261
                  ? (c < 43259
                    ? (c >= 43232 && c <= 43255)
                    : c <= 43259)
                  : (c <= 43309 || (c < 43360
                    ? (c >= 43312 && c <= 43347)
                    : c <= 43388)))
                : (c <= 43456 || (c < 43520
                  ? (c < 43488
                    ? (c >= 43471 && c <= 43481)
                    : c <= 43518)
                  : (c <= 43574 || (c >= 43584 && c <= 43597)))))))))))))))
    : (c <= 43609 || (c < 71453
      ? (c < 67594
        ? (c < 65343
          ? (c < 64298
            ? (c < 43868
              ? (c < 43777
                ? (c < 43739
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43714)
                  : (c <= 43741 || (c < 43762
                    ? (c >= 43744 && c <= 43759)
                    : c <= 43766)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)))))
              : (c <= 43881 || (c < 55243
                ? (c < 44016
                  ? (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : c <= 44013)
                  : (c <= 44025 || (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)))
                : (c <= 55291 || (c < 64256
                  ? (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)
                  : (c <= 64262 || (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64296)))))))
            : (c <= 64310 || (c < 65056
              ? (c < 64467
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)))
                : (c <= 64605 || (c < 64914
                  ? (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)
                  : (c <= 64967 || (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)))))
              : (c <= 65071 || (c < 65145
                ? (c < 65137
                  ? (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)
                  : (c <= 65137 || (c < 65143
                    ? c == 65139
                    : c <= 65143)))
                : (c <= 65145 || (c < 65151
                  ? (c < 65149
                    ? c == 65147
                    : c <= 65149)
                  : (c <= 65276 || (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)))))))))
          : (c <= 65343 || (c < 66504
            ? (c < 65616
              ? (c < 65498
                ? (c < 65474
                  ? (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)
                  : (c <= 65479 || (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)))))
              : (c <= 65629 || (c < 66272
                ? (c < 66045
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66045 || (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)))
                : (c <= 66272 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66426 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))))))
            : (c <= 66511 || (c < 66967
              ? (c < 66816
                ? (c < 66720
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66729 || (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)))
                : (c <= 66855 || (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)))))
              : (c <= 66977 || (c < 67424
                ? (c < 67003
                  ? (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)
                  : (c <= 67004 || (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)))
                : (c <= 67431 || (c < 67506
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : c <= 67504)
                  : (c <= 67514 || (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)))))))))))
        : (c <= 67637 || (c < 69942
          ? (c < 68416
            ? (c < 68096
              ? (c < 67808
                ? (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)))
                : (c <= 67826 || (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c < 68030
                    ? (c >= 67968 && c <= 68023)
                    : c <= 68031)))))
              : (c <= 68099 || (c < 68159
                ? (c < 68117
                  ? (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : c <= 68115)
                  : (c <= 68119 || (c < 68152
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68154)))
                : (c <= 68159 || (c < 68288
                  ? (c < 68224
                    ? (c >= 68192 && c <= 68220)
                    : c <= 68252)
                  : (c <= 68295 || (c < 68352
                    ? (c >= 68297 && c <= 68326)
                    : c <= 68405)))))))
            : (c <= 68437 || (c < 69415
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68903 || (c < 69291
                  ? (c < 69248
                    ? (c >= 68912 && c <= 68921)
                    : c <= 69289)
                  : (c <= 69292 || (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)))))
              : (c <= 69415 || (c < 69734
                ? (c < 69552
                  ? (c < 69488
                    ? (c >= 69424 && c <= 69456)
                    : c <= 69509)
                  : (c <= 69572 || (c < 69632
                    ? (c >= 69600 && c <= 69622)
                    : c <= 69702)))
                : (c <= 69749 || (c < 69840
                  ? (c < 69826
                    ? (c >= 69759 && c <= 69818)
                    : c <= 69826)
                  : (c <= 69864 || (c < 69888
                    ? (c >= 69872 && c <= 69881)
                    : c <= 69940)))))))))
          : (c <= 69951 || (c < 70453
            ? (c < 70280
              ? (c < 70094
                ? (c < 70006
                  ? (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)
                  : (c <= 70006 || (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : c <= 70092)))
                : (c <= 70106 || (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70199 || (c < 70272
                    ? c == 70206
                    : c <= 70278)))))
              : (c <= 70280 || (c < 70400
                ? (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c < 70384
                    ? (c >= 70320 && c <= 70378)
                    : c <= 70393)))
                : (c <= 70403 || (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : c <= 70451)))))))
            : (c <= 70457 || (c < 70784
              ? (c < 70493
                ? (c < 70475
                  ? (c < 70471
                    ? (c >= 70459 && c <= 70468)
                    : c <= 70472)
                  : (c <= 70477 || (c < 70487
                    ? c == 70480
                    : c <= 70487)))
                : (c <= 70499 || (c < 70656
                  ? (c < 70512
                    ? (c >= 70502 && c <= 70508)
                    : c <= 70516)
                  : (c <= 70730 || (c < 70750
                    ? (c >= 70736 && c <= 70745)
                    : c <= 70753)))))
              : (c <= 70853 || (c < 71168
                ? (c < 71040
                  ? (c < 70864
                    ? c == 70855
                    : c <= 70873)
                  : (c <= 71093 || (c < 71128
                    ? (c >= 71096 && c <= 71104)
                    : c <= 71133)))
                : (c <= 71232 || (c < 71296
                  ? (c < 71248
                    ? c == 71236
                    : c <= 71257)
                  : (c <= 71352 || (c < 71424
                    ? (c >= 71360 && c <= 71369)
                    : c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_19(int32_t c) {
  return (c < 43600
    ? (c < 3776
      ? (c < 2738
        ? (c < 1984
          ? (c < 910
            ? (c < 216
              ? (c < 'a'
                ? (c < '5'
                  ? (c < '0'
                    ? c == '$'
                    : c <= '3')
                  : (c <= '9' || (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')))
                : (c <= 'z' || (c < 183
                  ? (c < 181
                    ? c == 170
                    : c <= 181)
                  : (c <= 183 || (c < 192
                    ? c == 186
                    : c <= 214)))))
              : (c <= 246 || (c < 768
                ? (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || (c < 750
                    ? c == 748
                    : c <= 750)))
                : (c <= 884 || (c < 895
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)))))))
            : (c <= 929 || (c < 1479
              ? (c < 1369
                ? (c < 1155
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1159 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))
                : (c <= 1369 || (c < 1471
                  ? (c < 1425
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1469)
                  : (c <= 1471 || (c < 1476
                    ? (c >= 1473 && c <= 1474)
                    : c <= 1477)))))
              : (c <= 1479 || (c < 1749
                ? (c < 1552
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1562 || (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)))
                : (c <= 1756 || (c < 1791
                  ? (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : c <= 1788)
                  : (c <= 1791 || (c < 1869
                    ? (c >= 1808 && c <= 1866)
                    : c <= 1969)))))))))
          : (c <= 2037 || (c < 2534
            ? (c < 2437
              ? (c < 2160
                ? (c < 2048
                  ? (c < 2045
                    ? c == 2042
                    : c <= 2045)
                  : (c <= 2093 || (c < 2144
                    ? (c >= 2112 && c <= 2139)
                    : c <= 2154)))
                : (c <= 2183 || (c < 2275
                  ? (c < 2200
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2273)
                  : (c <= 2403 || (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)))))
              : (c <= 2444 || (c < 2492
                ? (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || (c < 2486
                    ? c == 2482
                    : c <= 2489)))
                : (c <= 2500 || (c < 2519
                  ? (c < 2507
                    ? (c >= 2503 && c <= 2504)
                    : c <= 2510)
                  : (c <= 2519 || (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2531)))))))
            : (c <= 2545 || (c < 2622
              ? (c < 2579
                ? (c < 2561
                  ? (c < 2558
                    ? c == 2556
                    : c <= 2558)
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)))))
              : (c <= 2626 || (c < 2662
                ? (c < 2641
                  ? (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)
                  : (c <= 2641 || (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)))
                : (c <= 2677 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)
                  : (c <= 2705 || (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)))))))))))
        : (c <= 2739 || (c < 3160
          ? (c < 2946
            ? (c < 2835
              ? (c < 2784
                ? (c < 2759
                  ? (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)
                  : (c <= 2761 || (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : c <= 2768)))
                : (c <= 2787 || (c < 2817
                  ? (c < 2809
                    ? (c >= 2790 && c <= 2799)
                    : c <= 2815)
                  : (c <= 2819 || (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)))))
              : (c <= 2856 || (c < 2891
                ? (c < 2869
                  ? (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)
                  : (c <= 2873 || (c < 2887
                    ? (c >= 2876 && c <= 2884)
                    : c <= 2888)))
                : (c <= 2893 || (c < 2911
                  ? (c < 2908
                    ? (c >= 2901 && c <= 2903)
                    : c <= 2909)
                  : (c <= 2915 || (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : c <= 2929)))))))
            : (c <= 2947 || (c < 3018
              ? (c < 2974
                ? (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)))
                : (c <= 2975 || (c < 2990
                  ? (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)
                  : (c <= 3001 || (c < 3014
                    ? (c >= 3006 && c <= 3010)
                    : c <= 3016)))))
              : (c <= 3021 || (c < 3090
                ? (c < 3046
                  ? (c < 3031
                    ? c == 3024
                    : c <= 3031)
                  : (c <= 3055 || (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : c <= 3088)))
                : (c <= 3112 || (c < 3142
                  ? (c < 3132
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3140)
                  : (c <= 3144 || (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)))))))))
          : (c <= 3162 || (c < 3423
            ? (c < 3274
              ? (c < 3214
                ? (c < 3174
                  ? (c < 3168
                    ? c == 3165
                    : c <= 3171)
                  : (c <= 3183 || (c < 3205
                    ? (c >= 3200 && c <= 3203)
                    : c <= 3212)))
                : (c <= 3216 || (c < 3253
                  ? (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)
                  : (c <= 3257 || (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)))))
              : (c <= 3277 || (c < 3328
                ? (c < 3296
                  ? (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : c <= 3294)
                  : (c <= 3299 || (c < 3313
                    ? (c >= 3302 && c <= 3311)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3398
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3396)
                  : (c <= 3400 || (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)))))))
            : (c <= 3427 || (c < 3544
              ? (c < 3507
                ? (c < 3457
                  ? (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)
                  : (c <= 3459 || (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)))
                : (c <= 3515 || (c < 3530
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3530 || (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)))))
              : (c <= 3551 || (c < 3713
                ? (c < 3585
                  ? (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)
                  : (c <= 3642 || (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)))
                : (c <= 3714 || (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || (c < 3751
                    ? c == 3749
                    : c <= 3773)))))))))))))
      : (c <= 3780 || (c < 8016
        ? (c < 5870
          ? (c < 4682
            ? (c < 3913
              ? (c < 3864
                ? (c < 3792
                  ? (c < 3784
                    ? c == 3782
                    : c <= 3789)
                  : (c <= 3801 || (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)))
                : (c <= 3865 || (c < 3895
                  ? (c < 3893
                    ? (c >= 3872 && c <= 3881)
                    : c <= 3893)
                  : (c <= 3895 || (c < 3902
                    ? c == 3897
                    : c <= 3911)))))
              : (c <= 3948 || (c < 4176
                ? (c < 3993
                  ? (c < 3974
                    ? (c >= 3953 && c <= 3972)
                    : c <= 3991)
                  : (c <= 4028 || (c < 4096
                    ? c == 4038
                    : c <= 4169)))
                : (c <= 4253 || (c < 4301
                  ? (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)
                  : (c <= 4301 || (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)))))))
            : (c <= 4685 || (c < 4824
              ? (c < 4752
                ? (c < 4698
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : c <= 4696)
                  : (c <= 4701 || (c < 4746
                    ? (c >= 4704 && c <= 4744)
                    : c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c < 4808
                    ? (c >= 4802 && c <= 4805)
                    : c <= 4822)))))
              : (c <= 4880 || (c < 5024
                ? (c < 4957
                  ? (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)
                  : (c <= 4959 || (c < 4992
                    ? (c >= 4969 && c <= 4977)
                    : c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)))))))))
          : (c <= 5880 || (c < 6656
            ? (c < 6159
              ? (c < 6002
                ? (c < 5952
                  ? (c < 5919
                    ? (c >= 5888 && c <= 5909)
                    : c <= 5940)
                  : (c <= 5971 || (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)))
                : (c <= 6003 || (c < 6108
                  ? (c < 6103
                    ? (c >= 6016 && c <= 6099)
                    : c <= 6103)
                  : (c <= 6109 || (c < 6155
                    ? (c >= 6112 && c <= 6121)
                    : c <= 6157)))))
              : (c <= 6169 || (c < 6448
                ? (c < 6320
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6432
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6443)))
                : (c <= 6459 || (c < 6528
                  ? (c < 6512
                    ? (c >= 6470 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c < 6608
                    ? (c >= 6576 && c <= 6601)
                    : c <= 6618)))))))
            : (c <= 6683 || (c < 7168
              ? (c < 6832
                ? (c < 6783
                  ? (c < 6752
                    ? (c >= 6688 && c <= 6750)
                    : c <= 6780)
                  : (c <= 6793 || (c < 6823
                    ? (c >= 6800 && c <= 6809)
                    : c <= 6823)))
                : (c <= 6845 || (c < 6992
                  ? (c < 6912
                    ? (c >= 6847 && c <= 6862)
                    : c <= 6988)
                  : (c <= 7001 || (c < 7040
                    ? (c >= 7019 && c <= 7027)
                    : c <= 7155)))))
              : (c <= 7223 || (c < 7376
                ? (c < 7296
                  ? (c < 7245
                    ? (c >= 7232 && c <= 7241)
                    : c <= 7293)
                  : (c <= 7304 || (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)))
                : (c <= 7378 || (c < 7960
                  ? (c < 7424
                    ? (c >= 7380 && c <= 7418)
                    : c <= 7957)
                  : (c <= 7965 || (c < 8008
                    ? (c >= 7968 && c <= 8005)
                    : c <= 8013)))))))))))
        : (c <= 8023 || (c < 11712
          ? (c < 8455
            ? (c < 8160
              ? (c < 8118
                ? (c < 8029
                  ? (c < 8027
                    ? c == 8025
                    : c <= 8027)
                  : (c <= 8029 || (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)))
                : (c <= 8124 || (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)))))
              : (c <= 8172 || (c < 8319
                ? (c < 8255
                  ? (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)
                  : (c <= 8256 || (c < 8305
                    ? c == 8276
                    : c <= 8305)))
                : (c <= 8319 || (c < 8417
                  ? (c < 8400
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8412)
                  : (c <= 8417 || (c < 8450
                    ? (c >= 8421 && c <= 8432)
                    : c <= 8450)))))))
            : (c <= 8455 || (c < 11264
              ? (c < 8488
                ? (c < 8472
                  ? (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)
                  : (c <= 8477 || (c < 8486
                    ? c == 8484
                    : c <= 8486)))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || (c < 8544
                    ? c == 8526
                    : c <= 8584)))))
              : (c <= 11492 || (c < 11631
                ? (c < 11559
                  ? (c < 11520
                    ? (c >= 11499 && c <= 11507)
                    : c <= 11557)
                  : (c <= 11559 || (c < 11568
                    ? c == 11565
                    : c <= 11623)))
                : (c <= 11631 || (c < 11688
                  ? (c < 11680
                    ? (c >= 11647 && c <= 11670)
                    : c <= 11686)
                  : (c <= 11694 || (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)))))))))
          : (c <= 11718 || (c < 42612
            ? (c < 12449
              ? (c < 12321
                ? (c < 11736
                  ? (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)
                  : (c <= 11742 || (c < 12293
                    ? (c >= 11744 && c <= 11775)
                    : c <= 12295)))
                : (c <= 12335 || (c < 12353
                  ? (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)
                  : (c <= 12438 || (c < 12445
                    ? (c >= 12441 && c <= 12442)
                    : c <= 12447)))))
              : (c <= 12538 || (c < 13312
                ? (c < 12593
                  ? (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)
                  : (c <= 12686 || (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)))
                : (c <= 19903 || (c < 42240
                  ? (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)
                  : (c <= 42508 || (c < 42560
                    ? (c >= 42512 && c <= 42539)
                    : c <= 42607)))))))
            : (c <= 42621 || (c < 43216
              ? (c < 42963
                ? (c < 42786
                  ? (c < 42775
                    ? (c >= 42623 && c <= 42737)
                    : c <= 42783)
                  : (c <= 42888 || (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)))
                : (c <= 42963 || (c < 43052
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43047)
                  : (c <= 43052 || (c < 43136
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43205)))))
              : (c <= 43225 || (c < 43392
                ? (c < 43261
                  ? (c < 43259
                    ? (c >= 43232 && c <= 43255)
                    : c <= 43259)
                  : (c <= 43309 || (c < 43360
                    ? (c >= 43312 && c <= 43347)
                    : c <= 43388)))
                : (c <= 43456 || (c < 43520
                  ? (c < 43488
                    ? (c >= 43471 && c <= 43481)
                    : c <= 43518)
                  : (c <= 43574 || (c >= 43584 && c <= 43597)))))))))))))))
    : (c <= 43609 || (c < 71453
      ? (c < 67594
        ? (c < 65343
          ? (c < 64298
            ? (c < 43868
              ? (c < 43777
                ? (c < 43739
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43714)
                  : (c <= 43741 || (c < 43762
                    ? (c >= 43744 && c <= 43759)
                    : c <= 43766)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)))))
              : (c <= 43881 || (c < 55243
                ? (c < 44016
                  ? (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : c <= 44013)
                  : (c <= 44025 || (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)))
                : (c <= 55291 || (c < 64256
                  ? (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)
                  : (c <= 64262 || (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64296)))))))
            : (c <= 64310 || (c < 65056
              ? (c < 64467
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)))
                : (c <= 64605 || (c < 64914
                  ? (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)
                  : (c <= 64967 || (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)))))
              : (c <= 65071 || (c < 65145
                ? (c < 65137
                  ? (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)
                  : (c <= 65137 || (c < 65143
                    ? c == 65139
                    : c <= 65143)))
                : (c <= 65145 || (c < 65151
                  ? (c < 65149
                    ? c == 65147
                    : c <= 65149)
                  : (c <= 65276 || (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)))))))))
          : (c <= 65343 || (c < 66504
            ? (c < 65616
              ? (c < 65498
                ? (c < 65474
                  ? (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)
                  : (c <= 65479 || (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)))))
              : (c <= 65629 || (c < 66272
                ? (c < 66045
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66045 || (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)))
                : (c <= 66272 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66426 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))))))
            : (c <= 66511 || (c < 66967
              ? (c < 66816
                ? (c < 66720
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66729 || (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)))
                : (c <= 66855 || (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)))))
              : (c <= 66977 || (c < 67424
                ? (c < 67003
                  ? (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)
                  : (c <= 67004 || (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)))
                : (c <= 67431 || (c < 67506
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : c <= 67504)
                  : (c <= 67514 || (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)))))))))))
        : (c <= 67637 || (c < 69942
          ? (c < 68416
            ? (c < 68096
              ? (c < 67808
                ? (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)))
                : (c <= 67826 || (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c < 68030
                    ? (c >= 67968 && c <= 68023)
                    : c <= 68031)))))
              : (c <= 68099 || (c < 68159
                ? (c < 68117
                  ? (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : c <= 68115)
                  : (c <= 68119 || (c < 68152
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68154)))
                : (c <= 68159 || (c < 68288
                  ? (c < 68224
                    ? (c >= 68192 && c <= 68220)
                    : c <= 68252)
                  : (c <= 68295 || (c < 68352
                    ? (c >= 68297 && c <= 68326)
                    : c <= 68405)))))))
            : (c <= 68437 || (c < 69415
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68903 || (c < 69291
                  ? (c < 69248
                    ? (c >= 68912 && c <= 68921)
                    : c <= 69289)
                  : (c <= 69292 || (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)))))
              : (c <= 69415 || (c < 69734
                ? (c < 69552
                  ? (c < 69488
                    ? (c >= 69424 && c <= 69456)
                    : c <= 69509)
                  : (c <= 69572 || (c < 69632
                    ? (c >= 69600 && c <= 69622)
                    : c <= 69702)))
                : (c <= 69749 || (c < 69840
                  ? (c < 69826
                    ? (c >= 69759 && c <= 69818)
                    : c <= 69826)
                  : (c <= 69864 || (c < 69888
                    ? (c >= 69872 && c <= 69881)
                    : c <= 69940)))))))))
          : (c <= 69951 || (c < 70453
            ? (c < 70280
              ? (c < 70094
                ? (c < 70006
                  ? (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)
                  : (c <= 70006 || (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : c <= 70092)))
                : (c <= 70106 || (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70199 || (c < 70272
                    ? c == 70206
                    : c <= 70278)))))
              : (c <= 70280 || (c < 70400
                ? (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c < 70384
                    ? (c >= 70320 && c <= 70378)
                    : c <= 70393)))
                : (c <= 70403 || (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : c <= 70451)))))))
            : (c <= 70457 || (c < 70784
              ? (c < 70493
                ? (c < 70475
                  ? (c < 70471
                    ? (c >= 70459 && c <= 70468)
                    : c <= 70472)
                  : (c <= 70477 || (c < 70487
                    ? c == 70480
                    : c <= 70487)))
                : (c <= 70499 || (c < 70656
                  ? (c < 70512
                    ? (c >= 70502 && c <= 70508)
                    : c <= 70516)
                  : (c <= 70730 || (c < 70750
                    ? (c >= 70736 && c <= 70745)
                    : c <= 70753)))))
              : (c <= 70853 || (c < 71168
                ? (c < 71040
                  ? (c < 70864
                    ? c == 70855
                    : c <= 70873)
                  : (c <= 71093 || (c < 71128
                    ? (c >= 71096 && c <= 71104)
                    : c <= 71133)))
                : (c <= 71232 || (c < 71296
                  ? (c < 71248
                    ? c == 71236
                    : c <= 71257)
                  : (c <= 71352 || (c < 71424
                    ? (c >= 71360 && c <= 71369)
                    : c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_20(int32_t c) {
  return (c < 43600
    ? (c < 3776
      ? (c < 2738
        ? (c < 1984
          ? (c < 910
            ? (c < 216
              ? (c < 'a'
                ? (c < '7'
                  ? (c < '0'
                    ? c == '$'
                    : c <= '5')
                  : (c <= '9' || (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')))
                : (c <= 'z' || (c < 183
                  ? (c < 181
                    ? c == 170
                    : c <= 181)
                  : (c <= 183 || (c < 192
                    ? c == 186
                    : c <= 214)))))
              : (c <= 246 || (c < 768
                ? (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || (c < 750
                    ? c == 748
                    : c <= 750)))
                : (c <= 884 || (c < 895
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)))))))
            : (c <= 929 || (c < 1479
              ? (c < 1369
                ? (c < 1155
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1159 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))
                : (c <= 1369 || (c < 1471
                  ? (c < 1425
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1469)
                  : (c <= 1471 || (c < 1476
                    ? (c >= 1473 && c <= 1474)
                    : c <= 1477)))))
              : (c <= 1479 || (c < 1749
                ? (c < 1552
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1562 || (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)))
                : (c <= 1756 || (c < 1791
                  ? (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : c <= 1788)
                  : (c <= 1791 || (c < 1869
                    ? (c >= 1808 && c <= 1866)
                    : c <= 1969)))))))))
          : (c <= 2037 || (c < 2534
            ? (c < 2437
              ? (c < 2160
                ? (c < 2048
                  ? (c < 2045
                    ? c == 2042
                    : c <= 2045)
                  : (c <= 2093 || (c < 2144
                    ? (c >= 2112 && c <= 2139)
                    : c <= 2154)))
                : (c <= 2183 || (c < 2275
                  ? (c < 2200
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2273)
                  : (c <= 2403 || (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)))))
              : (c <= 2444 || (c < 2492
                ? (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || (c < 2486
                    ? c == 2482
                    : c <= 2489)))
                : (c <= 2500 || (c < 2519
                  ? (c < 2507
                    ? (c >= 2503 && c <= 2504)
                    : c <= 2510)
                  : (c <= 2519 || (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2531)))))))
            : (c <= 2545 || (c < 2622
              ? (c < 2579
                ? (c < 2561
                  ? (c < 2558
                    ? c == 2556
                    : c <= 2558)
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)))))
              : (c <= 2626 || (c < 2662
                ? (c < 2641
                  ? (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)
                  : (c <= 2641 || (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)))
                : (c <= 2677 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)
                  : (c <= 2705 || (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)))))))))))
        : (c <= 2739 || (c < 3160
          ? (c < 2946
            ? (c < 2835
              ? (c < 2784
                ? (c < 2759
                  ? (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)
                  : (c <= 2761 || (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : c <= 2768)))
                : (c <= 2787 || (c < 2817
                  ? (c < 2809
                    ? (c >= 2790 && c <= 2799)
                    : c <= 2815)
                  : (c <= 2819 || (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)))))
              : (c <= 2856 || (c < 2891
                ? (c < 2869
                  ? (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)
                  : (c <= 2873 || (c < 2887
                    ? (c >= 2876 && c <= 2884)
                    : c <= 2888)))
                : (c <= 2893 || (c < 2911
                  ? (c < 2908
                    ? (c >= 2901 && c <= 2903)
                    : c <= 2909)
                  : (c <= 2915 || (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : c <= 2929)))))))
            : (c <= 2947 || (c < 3018
              ? (c < 2974
                ? (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)))
                : (c <= 2975 || (c < 2990
                  ? (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)
                  : (c <= 3001 || (c < 3014
                    ? (c >= 3006 && c <= 3010)
                    : c <= 3016)))))
              : (c <= 3021 || (c < 3090
                ? (c < 3046
                  ? (c < 3031
                    ? c == 3024
                    : c <= 3031)
                  : (c <= 3055 || (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : c <= 3088)))
                : (c <= 3112 || (c < 3142
                  ? (c < 3132
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3140)
                  : (c <= 3144 || (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)))))))))
          : (c <= 3162 || (c < 3423
            ? (c < 3274
              ? (c < 3214
                ? (c < 3174
                  ? (c < 3168
                    ? c == 3165
                    : c <= 3171)
                  : (c <= 3183 || (c < 3205
                    ? (c >= 3200 && c <= 3203)
                    : c <= 3212)))
                : (c <= 3216 || (c < 3253
                  ? (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)
                  : (c <= 3257 || (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)))))
              : (c <= 3277 || (c < 3328
                ? (c < 3296
                  ? (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : c <= 3294)
                  : (c <= 3299 || (c < 3313
                    ? (c >= 3302 && c <= 3311)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3398
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3396)
                  : (c <= 3400 || (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)))))))
            : (c <= 3427 || (c < 3544
              ? (c < 3507
                ? (c < 3457
                  ? (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)
                  : (c <= 3459 || (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)))
                : (c <= 3515 || (c < 3530
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3530 || (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)))))
              : (c <= 3551 || (c < 3713
                ? (c < 3585
                  ? (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)
                  : (c <= 3642 || (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)))
                : (c <= 3714 || (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || (c < 3751
                    ? c == 3749
                    : c <= 3773)))))))))))))
      : (c <= 3780 || (c < 8016
        ? (c < 5870
          ?