---
title: "Traefik Migration Documentation"
description: "Learn the steps needed to migrate to new Traefik Proxy v2 versions, i.e. v2.0 to v2.1 or v2.1 to v2.2. Read the technical documentation."
---

# Migration: Steps needed between the versions

## v2.0 to v2.1

### Kubernetes CRD

In v2.1, a new Kubernetes CRD called `TraefikService` was added.
While updating an installation to v2.1,
one should apply that CRD, and update the existing `ClusterRole` definition to allow Traefik to use that CRD.

To add that CRD and enhance the permissions, the following definitions need to be applied to the cluster.

```yaml tab="TraefikService"
apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  name: traefikservices.traefik.containo.us

spec:
  group: traefik.containo.us
  version: v1alpha1
  names:
    kind: TraefikService
    plural: traefikservices
    singular: traefikservice
  scope: Namespaced
```

```yaml tab="ClusterRole"
kind: ClusterRole
apiVersion: rbac.authorization.k8s.io/v1beta1
metadata:
  name: traefik-ingress-controller

rules:
  - apiGroups:
      - ""
    resources:
      - services
      - endpoints
      - secrets
    verbs:
      - get
      - list
      - watch
  - apiGroups:
      - extensions
    resources:
      - ingresses
    verbs:
      - get
      - list
      - watch
  - apiGroups:
      - extensions
    resources:
      - ingresses/status
    verbs:
      - update
  - apiGroups:
      - traefik.containo.us
    resources:
      - middlewares
      - ingressroutes
      - traefikservices
      - ingressroutetcps
      - tlsoptions
    verbs:
      - get
      - list
      - watch
```

After having both resources applied, Traefik will work properly.

## v2.1 to v2.2

### Headers middleware: accessControlAllowOrigin

`accessControlAllowOrigin` is deprecated.
This field will be removed in future 2.x releases.
Please configure your allowed origins in `accessControlAllowOriginList` instead.

### Kubernetes CRD

In v2.2, new Kubernetes CRDs called `TLSStore` and `IngressRouteUDP` were added.
While updating an installation to v2.2,
one should apply that CRDs, and update the existing `ClusterRole` definition to allow Traefik to use that CRDs.

To add that CRDs and enhance the permissions, the following definitions need to be applied to the cluster.

```yaml tab="TLSStore"
apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  name: tlsstores.traefik.containo.us

spec:
  group: traefik.containo.us
  version: v1alpha1
  names:
    kind: TLSStore
    plural: tlsstores
    singular: tlsstore
  scope: Namespaced

```

```yaml tab="IngressRouteUDP"
apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  name: ingressrouteudps.traefik.containo.us

spec:
  group: traefik.containo.us
  version: v1alpha1
  names:
    kind: IngressRouteUDP
    plural: ingressrouteudps
    singular: ingressrouteudp
  scope: Namespaced

```

```yaml tab="ClusterRole"
kind: ClusterRole
apiVersion: rbac.authorization.k8s.io/v1beta1
metadata:
  name: traefik-ingress-controller

rules:
  - apiGroups:
      - ""
    resources:
      - services
      - endpoints
      - secrets
    verbs:
      - get
      - list
      - watch
  - apiGroups:
      - extensions
    resources:
      - ingresses
    verbs:
      - get
      - list
      - watch
  - apiGroups:
      - extensions
    resources:
      - ingresses/status
    verbs:
      - update
  - apiGroups:
      - traefik.containo.us
    resources:
      - middlewares
      - ingressroutes
      - traefikservices
      - ingressroutetcps
      - ingressrouteudps
      - tlsoptions
      - tlsstores
    verbs:
      - get
      - list
      - watch

```

After having both resources applied, Traefik will work properly.

### Kubernetes Ingress

To enable HTTPS, it is not sufficient anymore to only rely on a TLS section in the Ingress.

#### Expose an Ingress on 80 and 443

Define the default TLS configuration on the HTTPS entry point.

```yaml tab="Ingress"
kind: Ingress
apiVersion: networking.k8s.io/v1beta1
metadata:
  name: example

spec:
  tls:
  - secretName: my-tls-secret

  rules:
  - host: example.com
    http:
      paths:
      - path: "/foo"
        backend:
          serviceName: example-com
          servicePort: 80
```

Entry points definition and enable Ingress provider:

```yaml tab="File (YAML)"
# Static configuration

entryPoints:
  web:
    address: :80
  websecure:
    address: :443
    http:
      tls: {}

providers:
  kubernetesIngress: {}
```

```toml tab="File (TOML)"
# Static configuration

[entryPoints.web]
  address = ":80"

[entryPoints.websecure]
  address = ":443"
  [entryPoints.websecure.http]
    [entryPoints.websecure.http.tls]

[providers.kubernetesIngress]
```

```bash tab="CLI"
# Static configuration

--entryPoints.web.address=:80
--entryPoints.websecure.address=:443
--entryPoints.websecure.http.tls=true
--providers.kubernetesIngress=true
```

#### Use TLS only on one Ingress

Define the TLS restriction with annotations.

```yaml tab="Ingress"
kind: Ingress
apiVersion: networking.k8s.io/v1beta1
metadata:
  name: example-tls
  annotations:
    traefik.ingress.kubernetes.io/router.entrypoints: websecure
    traefik.ingress.kubernetes.io/router.tls: "true"

spec:
  tls:
  - secretName: my-tls-secret

  rules:
  - host: example.com
    http:
      paths:
      - path: ""
        backend:
          serviceName: example-com
          servicePort: 80
```

Entry points definition and enable Ingress provider:

```yaml tab="File (YAML)"
# Static configuration

entryPoints:
  web:
    address: :80
  websecure:
    address: :443

providers:
  kubernetesIngress: {}
```

```toml tab="File (TOML)"
# Static configuration

[entryPoints.web]
  address = ":80"

[entryPoints.websecure]
  address = ":443"

[providers.kubernetesIngress]
```

```bash tab="CLI"
# Static configuration

--entryPoints.web.address=:80
--entryPoints.websecure.address=:443
--providers.kubernetesIngress=true
```

## v2.2.2 to v2.2.5

### InsecureSNI removal

In `v2.2.2` we introduced a new flag (`insecureSNI`) which was available as a global option to disable domain fronting.
Since `v2.2.5` this global option has been removed, and you should not use it anymore.

### HostSNI rule matcher removal

In `v2.2.2` we introduced a new rule matcher (`HostSNI`) for HTTP routers which was allowing to match the Server Name Indication at the router level.
Since `v2.2.5` this rule has been removed for HTTP routers, and you should not use it anymore.

## v2.2 to v2.3

### X.509 CommonName Deprecation

The deprecated, legacy behavior of treating the CommonName field on X.509 certificates as a host name when no Subject Alternative Names are present, is now disabled by default.

It means that if one is using https with your backend servers, and a certificate with only a CommonName,
Traefik will not try to match the server name indication with the CommonName anymore.

It can be temporarily re-enabled by adding the value `x509ignoreCN=0` to the `GODEBUG` environment variable.

More information: https://golang.org/doc/go1.15#commonname

### File Provider

The file parser has been changed, since v2.3 the unknown options/fields in a dynamic configuration file are treated as errors.

### IngressClass

In `v2.3`, the support of `IngressClass`, which is available since Kubernetes version `1.18`, has been introduced.
In order to be able to use this new resource the [Kubernetes RBAC](../reference/dynamic-configuration/kubernetes-crd.md#rbac) must be updated.

## v2.3 to v2.4

### ServersTransport

In `v2.4.0`, the support of `ServersTransport` has been introduced.
It is therefore necessary to update [RBAC](../reference/dynamic-configuration/kubernetes-crd.md#rbac) and [CRD](../reference/dynamic-configuration/kubernetes-crd.md) definitions.

## v2.4.7 to v2.4.8

### Non-ASCII Domain Names

In `v2.4.8`, we introduced a new check on domain names used in HTTP router rule `Host` and `HostRegexp` expressions,
and in TCP router rule `HostSNI` expression.
This check ensures that provided domain names don't contain non-ASCII characters.
If not, an error is raised, and the associated router will be shown as invalid in the dashboard.

This new behavior is intended to show what was failing silently previously and to help troubleshooting configuration issues.
It doesn't change the support for non-ASCII domain names in routers rules, which is not part of the Traefik feature set so far.

In order to use non-ASCII domain names in a router's rule, one should use the Punycode form of the domain name.
For more information, please read the [HTTP routers rule](../routing/routers/index.md#rule) part or [TCP router rules](../routing/routers/index.md#rule_1) part of the documentation.

## v2.4.8 to v2.4.9

### Tracing Span

In `v2.4.9`, we changed span error to log only server errors (>= 500).

## v2.4.9 to v2.4.10

### K8S CrossNamespace

In `v2.4.10`, the default value for `allowCrossNamespace` has been changed to `false`.

### K8S ExternalName Service

In `v2.4.10`, by default, it is no longer authorized to reference Kubernetes ExternalName services.
To allow it, the `allowExternalNameServices` option should be set to `true`.

## v2.4 to v2.5

### Kubernetes CRD

In `v2.5`, the [Traefik CRDs](../reference/dynamic-configuration/kubernetes-crd.md#definitions) have been updated to support the new API version `apiextensions.k8s.io/v1`.
As required by `apiextensions.k8s.io/v1`, we have included the OpenAPI validation schema.

After deploying the new [Traefik CRDs](../reference/dynamic-configuration/kubernetes-crd.md#definitions), the resources will be validated only on creation or update.

Please note that the unknown fields will not be pruned when migrating from `apiextensions.k8s.io/v1beta1` to `apiextensions.k8s.io/v1` CRDs.
For more details check out the official [documentation](https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#specifying-a-structural-schema).

### Kubernetes Ingress

Traefik v2.5 moves forward for the Ingress provider to support Kubernetes v1.22.

Traefik now supports only v1.14+ Kubernetes clusters, which means the support of `extensions/v1beta1` API Version ingresses has been dropped.

The `extensions/v1beta1` API Version should now be replaced either by `networking.k8s.io/v1beta1` or by `networking.k8s.io/v1` (as of Kubernetes v1.19+).

The support of the `networking.k8s.io/v1beta1` API Version will stop in Kubernetes v1.22.

### Headers middleware: ssl redirect options

`sslRedirect`, `sslTemporaryRedirect`, `sslHost` and `sslForceHost` are deprecated in Traefik v2.5.

For simple HTTP to HTTPS redirection, you may use [EntryPoints redirections](../routing/entrypoints.md#redirection).

For more advanced use cases, you can use either the [RedirectScheme middleware](../middlewares/http/redirectscheme.md) or the [RedirectRegex middleware](../middlewares/http/redirectregex.md).

### Headers middleware: accessControlAllowOrigin

`accessControlAllowOrigin` is no longer supported in Traefik v2.5.

### X.509 CommonName Deprecation Bis

Following up on the deprecation started [previously](#x509-commonname-deprecation),
as the `x509ignoreCN=0` value for the `GODEBUG` is [deprecated in Go 1.17](https://tip.golang.org/doc/go1.17#crypto/x509),
the legacy behavior related to the CommonName field can not be enabled at all anymore.

## v2.5.3 to v2.5.4

### Errors middleware

In `v2.5.4`, when the errors service is configured with the [`PassHostHeader`](../routing/services/index.md#pass-host-header) option to `true` (default),
the forwarded Host header value is now set to the client request Host value and not `0.0.0.0`.
Check out the [Errors middleware](../middlewares/http/errorpages.md#service) documentation for more details.

## v2.5 to v2.6

### HTTP/3

Traefik v2.6 introduces the `AdvertisedPort` option,
which allows advertising, in the `Alt-Svc` header, a UDP port different from the one on which Traefik is actually listening (the EntryPoint's port).
By doing so, it introduces a new configuration structure `http3`, which replaces the `enableHTTP3` option (which therefore doesn't exist anymore).
To enable HTTP/3 on an EntryPoint, please check out the [HTTP/3 configuration](../routing/entrypoints.md#http3) documentation.

### Kubernetes Gateway API Provider

In `v2.6`, the [Kubernetes Gateway API provider](../providers/kubernetes-gateway.md) now only supports the version [v1alpha2](https://gateway-api.sigs.k8s.io/v1alpha2/guides/getting-started/) of the specification and 
[route namespaces](https://gateway-api.sigs.k8s.io/v1alpha2/references/spec/#gateway.networking.k8s.io/v1alpha2.RouteNamespaces) selectors, which requires Traefik to fetch and watch the cluster namespaces.
Therefore, the [RBAC](../reference/dynamic-configuration/kubernetes-gateway.md#rbac) and [CRD](../reference/dynamic-configuration/kubernetes-gateway.md#definitions) definitions must be updated.

## v2.6.0 to v2.6.1

### Metrics

In `v2.6.1`, the metrics system does not support any more custom HTTP method verbs to prevent potential metrics cardinality overhead.
In consequence, for metrics having the method label,
if the HTTP method verb of a request is not one defined in the set of common methods for [`HTTP/1.1`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods)
or the [`PRI`](https://datatracker.ietf.org/doc/html/rfc7540#section-11.6) verb (for `HTTP/2`),
the value for the method label becomes `EXTENSION_METHOD`, instead of the request's one.

### Tracing

In `v2.6.1`, the Datadog tags added to a span changed from `service.name` to `traefik.service.name` and from `router.name` to `traefik.router.name`.
