"""Test for compatibility with Mercurial API"""

import inspect

from tortoisehg.util import hglib, pipeui

def test_same_argspec(f, g):
    fa, ga = inspect.getfullargspec(f), inspect.getfullargspec(g)
    assert fa == ga, '%s != %s' % (inspect.formatargspec(*fa),
                                   inspect.formatargspec(*ga))

def overridden_methods(cls):
    basefunctions = inspect.getmembers(cls.__base__, inspect.isfunction)
    return [(basefn, getattr(cls, name)) for name, basefn in basefunctions
            if basefn is not getattr(cls, name)]

def pytest_generate_tests(metafunc):
    ui = hglib.loadui()
    pipeui.uisetup(ui)
    if metafunc.function == test_same_argspec:
        metafunc.parametrize('f, g', overridden_methods(ui.__class__))
