# The PEP 484 type hints stub file for the QtWidgets module.
#
# Generated by SIP 4.19.19
#
# Copyright (c) 2019 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt5.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import typing
import sip

from typing import overload

from PyQt5 import QtGui
from PyQt5 import QtCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[...], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], sip.Buffer, int, None]


class QWidget(QtCore.QObject, QtGui.QPaintDevice):

    customContextMenuRequested: PYQT_SIGNAL
    windowIconChanged: PYQT_SIGNAL
    windowIconTextChanged: PYQT_SIGNAL
    windowTitleChanged: PYQT_SIGNAL

    RenderFlag: typing.Type[int]
    #class RenderFlag(int): ...
    DrawWindowBackground = ... # type: int
    DrawChildren = ... # type: int
    IgnoreMask = ... # type: int

    RenderFlags: typing.Type[int]
    #class RenderFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QWidget.RenderFlags, QWidget.RenderFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QWidget.RenderFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QWidget.RenderFlags: ...
        #def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    def setWindowFlag(self, a0: int, on: bool = ...) -> None: ...
    def hasTabletTracking(self) -> bool: ...
    def setTabletTracking(self, enable: bool) -> None: ...
    #def windowIconTextChanged(self, iconText: str) -> None: ...
    #def windowIconChanged(self, icon: QtGui.QIcon) -> None: ...
    #def windowTitleChanged(self, title: str) -> None: ...
    def toolTipDuration(self) -> int: ...
    def setToolTipDuration(self, msec: int) -> None: ...
    def initPainter(self, painter: QtGui.QPainter) -> None: ...
    def sharedPainter(self) -> QtGui.QPainter: ...
    def nativeEvent(self, eventType: typing.Union[QtCore.QByteArray, bytes, bytearray], message: sip.voidptr) -> typing.Tuple[bool, int]: ...
    def windowHandle(self) -> QtGui.QWindow: ...
    @staticmethod
    def createWindowContainer(window: QtGui.QWindow, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ...) -> QWidget: ...
    def grab(self, rectangle: QtCore.QRect = ...) -> QtGui.QPixmap: ...
    def hasHeightForWidth(self) -> bool: ...
    def setInputMethodHints(self, hints: typing.Union[int, int]) -> None: ...
    def inputMethodHints(self) -> int: ...
    def previousInFocusChain(self) -> QWidget: ...
    def contentsMargins(self) -> QtCore.QMargins: ...
    def ungrabGesture(self, type: int) -> None: ...
    def grabGesture(self, type: int, flags: typing.Union[int, int] = ...) -> None: ...
    def setGraphicsEffect(self, effect: QGraphicsEffect) -> None: ...
    def graphicsEffect(self) -> QGraphicsEffect: ...
    def graphicsProxyWidget(self) -> QGraphicsProxyWidget: ...
    def windowFilePath(self) -> str: ...
    def setWindowFilePath(self, filePath: str) -> None: ...
    def nativeParentWidget(self) -> QWidget: ...
    def effectiveWinId(self) -> sip.voidptr: ...
    def unsetLocale(self) -> None: ...
    def locale(self) -> QtCore.QLocale: ...
    def setLocale(self, locale: QtCore.QLocale) -> None: ...
    @overload
    def render(self, target: QtGui.QPaintDevice, targetOffset: QtCore.QPoint = ..., sourceRegion: QtGui.QRegion = ..., flags: typing.Union[int, int] = ...) -> None: ...
    @overload
    def render(self, painter: QtGui.QPainter, targetOffset: QtCore.QPoint = ..., sourceRegion: QtGui.QRegion = ..., flags: typing.Union[int, int] = ...) -> None: ...
    def restoreGeometry(self, geometry: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def saveGeometry(self) -> QtCore.QByteArray: ...
    def setShortcutAutoRepeat(self, id: int, enabled: bool = ...) -> None: ...
    def styleSheet(self) -> str: ...
    def setStyleSheet(self, styleSheet: str) -> None: ...
    def setAutoFillBackground(self, enabled: bool) -> None: ...
    def autoFillBackground(self) -> bool: ...
    def setWindowModality(self, windowModality: int) -> None: ...
    def windowModality(self) -> int: ...
    def testAttribute(self, attribute: int) -> bool: ...
    def parentWidget(self) -> QWidget: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def size(self) -> QtCore.QSize: ...
    def geometry(self) -> QtCore.QRect: ...
    def rect(self) -> QtCore.QRect: ...
    def isHidden(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def updatesEnabled(self) -> bool: ...
    def underMouse(self) -> bool: ...
    def hasMouseTracking(self) -> bool: ...
    def setMouseTracking(self, enable: bool) -> None: ...
    def fontInfo(self) -> QtGui.QFontInfo: ...
    def fontMetrics(self) -> QtGui.QFontMetrics: ...
    def font(self) -> QtGui.QFont: ...
    def maximumHeight(self) -> int: ...
    def maximumWidth(self) -> int: ...
    def minimumHeight(self) -> int: ...
    def minimumWidth(self) -> int: ...
    def isModal(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isWindow(self) -> bool: ...
    def winId(self) -> sip.voidptr: ...
    def windowFlags(self) -> int: ...
    def windowType(self) -> int: ...
    def focusPreviousChild(self) -> bool: ...
    def focusNextChild(self) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def destroy(self, destroyWindow: bool = ..., destroySubWindows: bool = ...) -> None: ...
    def create(self, window: sip.voidptr = ..., initializeWindow: bool = ..., destroyOldWindow: bool = ...) -> None: ...
    def updateMicroFocus(self) -> None: ...
    def inputMethodQuery(self, a0: int) -> typing.Any: ...
    def inputMethodEvent(self, a0: QtGui.QInputMethodEvent) -> None: ...
    def metric(self, a0: int) -> int: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def hideEvent(self, a0: QtGui.QHideEvent) -> None: ...
    def showEvent(self, a0: QtGui.QShowEvent) -> None: ...
    def dropEvent(self, a0: QtGui.QDropEvent) -> None: ...
    def dragLeaveEvent(self, a0: QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, a0: QtGui.QDragMoveEvent) -> None: ...
    def dragEnterEvent(self, a0: QtGui.QDragEnterEvent) -> None: ...
    def actionEvent(self, a0: QtGui.QActionEvent) -> None: ...
    def tabletEvent(self, a0: QtGui.QTabletEvent) -> None: ...
    def contextMenuEvent(self, a0: QtGui.QContextMenuEvent) -> None: ...
    def closeEvent(self, a0: QtGui.QCloseEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def moveEvent(self, a0: QtGui.QMoveEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def leaveEvent(self, a0: QtCore.QEvent) -> None: ...
    def enterEvent(self, a0: QtCore.QEvent) -> None: ...
    def focusOutEvent(self, a0: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, a0: QtGui.QFocusEvent) -> None: ...
    def keyReleaseEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def wheelEvent(self, a0: QtGui.QWheelEvent) -> None: ...
    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseDoubleClickEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    #def customContextMenuRequested(self, pos: QtCore.QPoint) -> None: ...
    def isAncestorOf(self, child: QWidget) -> bool: ...
    def ensurePolished(self) -> None: ...
    def paintEngine(self) -> QtGui.QPaintEngine: ...
    def setAttribute(self, attribute: int, on: bool = ...) -> None: ...
    @overload
    def childAt(self, p: QtCore.QPoint) -> QWidget: ...
    @overload
    def childAt(self, ax: int, ay: int) -> QWidget: ...
    @staticmethod
    def find(a0: sip.voidptr) -> QWidget: ...
    def overrideWindowFlags(self, type: typing.Union[int, int]) -> None: ...
    def setWindowFlags(self, type: typing.Union[int, int]) -> None: ...
    def actions(self) -> typing.List[QAction]: ...
    def removeAction(self, action: QAction) -> None: ...
    def insertActions(self, before: QAction, actions: typing.Iterable[QAction]) -> None: ...
    def insertAction(self, before: QAction, action: QAction) -> None: ...
    def addActions(self, actions: typing.Iterable[QAction]) -> None: ...
    def addAction(self, action: QAction) -> None: ...
    def setAcceptDrops(self, on: bool) -> None: ...
    def acceptDrops(self) -> bool: ...
    def nextInFocusChain(self) -> QWidget: ...
    def focusWidget(self) -> QWidget: ...
    @overload
    def scroll(self, dx: int, dy: int) -> None: ...
    @overload
    def scroll(self, dx: int, dy: int, a2: QtCore.QRect) -> None: ...
    @overload
    def setParent(self, parent: typing.Optional[QWidget]) -> None: ...
    @overload
    def setParent(self, parent: typing.Optional[QWidget], f: typing.Union[int, int]) -> None: ...
    def updateGeometry(self) -> None: ...
    def setLayout(self, a0: QLayout) -> None: ...
    def layout(self) -> QLayout: ...
    def contentsRect(self) -> QtCore.QRect: ...
    def getContentsMargins(self) -> typing.Tuple[int, int, int, int]: ...
    @overload
    def setContentsMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @overload
    def setContentsMargins(self, margins: QtCore.QMargins) -> None: ...
    def visibleRegion(self) -> QtGui.QRegion: ...
    def heightForWidth(self, a0: int) -> int: ...
    @overload
    def setSizePolicy(self, a0: QSizePolicy) -> None: ...
    @overload
    def setSizePolicy(self, hor: int, ver: int) -> None: ...
    def sizePolicy(self) -> QSizePolicy: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def overrideWindowState(self, state: typing.Union[int, int]) -> None: ...
    def setWindowState(self, state: typing.Union[int, int]) -> None: ...
    def windowState(self) -> int: ...
    def isFullScreen(self) -> bool: ...
    def isMaximized(self) -> bool: ...
    def isMinimized(self) -> bool: ...
    def isVisibleTo(self, a0: QWidget) -> bool: ...
    def adjustSize(self) -> None: ...
    @overload
    def setGeometry(self, a0: QtCore.QRect) -> None: ...
    @overload
    def setGeometry(self, ax: int, ay: int, aw: int, ah: int) -> None: ...
    @overload
    def resize(self, a0: QtCore.QSize) -> None: ...
    @overload
    def resize(self, w: int, h: int) -> None: ...
    @overload
    def move(self, a0: QtCore.QPoint) -> None: ...
    @overload
    def move(self, ax: int, ay: int) -> None: ...
    def stackUnder(self, a0: QWidget) -> None: ...
    def lower(self) -> None: ...
    def raise_(self) -> None: ...
    def close(self) -> bool: ...
    def showNormal(self) -> None: ...
    def showFullScreen(self) -> None: ...
    def showMaximized(self) -> None: ...
    def showMinimized(self) -> None: ...
    def hide(self) -> None: ...
    def show(self) -> None: ...
    def setHidden(self, hidden: bool) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    @overload
    def repaint(self) -> None: ...
    @overload
    def repaint(self, x: int, y: int, w: int, h: int) -> None: ...
    @overload
    def repaint(self, a0: QtCore.QRect) -> None: ...
    @overload
    def repaint(self, a0: QtGui.QRegion) -> None: ...
    @overload
    def update(self) -> None: ...
    @overload
    def update(self, a0: QtCore.QRect) -> None: ...
    @overload
    def update(self, a0: QtGui.QRegion) -> None: ...
    @overload
    def update(self, ax: int, ay: int, aw: int, ah: int) -> None: ...
    def setUpdatesEnabled(self, enable: bool) -> None: ...
    @staticmethod
    def keyboardGrabber() -> QWidget: ...
    @staticmethod
    def mouseGrabber() -> QWidget: ...
    def setShortcutEnabled(self, id: int, enabled: bool = ...) -> None: ...
    def releaseShortcut(self, id: int) -> None: ...
    def grabShortcut(self, key: typing.Union[QtGui.QKeySequence, int, str, int], context: int = ...) -> int: ...
    def releaseKeyboard(self) -> None: ...
    def grabKeyboard(self) -> None: ...
    def releaseMouse(self) -> None: ...
    @overload
    def grabMouse(self) -> None: ...
    @overload
    def grabMouse(self, a0: typing.Union[QtGui.QCursor, int]) -> None: ...
    def setContextMenuPolicy(self, policy: int) -> None: ...
    def contextMenuPolicy(self) -> int: ...
    def focusProxy(self) -> QWidget: ...
    def setFocusProxy(self, a0: QWidget) -> None: ...
    @staticmethod
    def setTabOrder(a0: QWidget, a1: QWidget) -> None: ...
    def hasFocus(self) -> bool: ...
    def setFocusPolicy(self, policy: int) -> None: ...
    def focusPolicy(self) -> int: ...
    def clearFocus(self) -> None: ...
    def activateWindow(self) -> None: ...
    def isActiveWindow(self) -> bool: ...
    @overload
    def setFocus(self) -> None: ...
    @overload
    def setFocus(self, reason: int) -> None: ...
    def isLeftToRight(self) -> bool: ...
    def isRightToLeft(self) -> bool: ...
    def unsetLayoutDirection(self) -> None: ...
    def layoutDirection(self) -> int: ...
    def setLayoutDirection(self, direction: int) -> None: ...
    def setAccessibleDescription(self, description: str) -> None: ...
    def accessibleDescription(self) -> str: ...
    def setAccessibleName(self, name: str) -> None: ...
    def accessibleName(self) -> str: ...
    def whatsThis(self) -> str: ...
    def setWhatsThis(self, a0: str) -> None: ...
    def statusTip(self) -> str: ...
    def setStatusTip(self, a0: str) -> None: ...
    def toolTip(self) -> str: ...
    def setToolTip(self, a0: str) -> None: ...
    def isWindowModified(self) -> bool: ...
    def windowOpacity(self) -> float: ...
    def setWindowOpacity(self, level: float) -> None: ...
    def windowRole(self) -> str: ...
    def setWindowRole(self, a0: str) -> None: ...
    def windowIconText(self) -> str: ...
    def setWindowIconText(self, a0: str) -> None: ...
    def windowIcon(self) -> QtGui.QIcon: ...
    def setWindowIcon(self, icon: QtGui.QIcon) -> None: ...
    def windowTitle(self) -> str: ...
    def setWindowTitle(self, a0: str) -> None: ...
    def clearMask(self) -> None: ...
    def mask(self) -> QtGui.QRegion: ...
    @overload
    def setMask(self, a0: QtGui.QBitmap) -> None: ...
    @overload
    def setMask(self, a0: QtGui.QRegion) -> None: ...
    def unsetCursor(self) -> None: ...
    def setCursor(self, a0: typing.Union[QtGui.QCursor, int]) -> None: ...
    def cursor(self) -> QtGui.QCursor: ...
    def setFont(self, a0: QtGui.QFont) -> None: ...
    def foregroundRole(self) -> int: ...
    def setForegroundRole(self, a0: int) -> None: ...
    def backgroundRole(self) -> int: ...
    def setBackgroundRole(self, a0: int) -> None: ...
    def setPalette(self, a0: QtGui.QPalette) -> None: ...
    def palette(self) -> QtGui.QPalette: ...
    def window(self) -> QWidget: ...
    def mapFrom(self, a0: QWidget, a1: QtCore.QPoint) -> QtCore.QPoint: ...
    def mapTo(self, a0: QWidget, a1: QtCore.QPoint) -> QtCore.QPoint: ...
    def mapFromParent(self, a0: QtCore.QPoint) -> QtCore.QPoint: ...
    def mapToParent(self, a0: QtCore.QPoint) -> QtCore.QPoint: ...
    def mapFromGlobal(self, a0: QtCore.QPoint) -> QtCore.QPoint: ...
    def mapToGlobal(self, a0: QtCore.QPoint) -> QtCore.QPoint: ...
    def setFixedHeight(self, h: int) -> None: ...
    def setFixedWidth(self, w: int) -> None: ...
    @overload
    def setFixedSize(self, a0: QtCore.QSize) -> None: ...
    @overload
    def setFixedSize(self, w: int, h: int) -> None: ...
    @overload
    def setBaseSize(self, basew: int, baseh: int) -> None: ...
    @overload
    def setBaseSize(self, s: QtCore.QSize) -> None: ...
    def baseSize(self) -> QtCore.QSize: ...
    @overload
    def setSizeIncrement(self, w: int, h: int) -> None: ...
    @overload
    def setSizeIncrement(self, s: QtCore.QSize) -> None: ...
    def sizeIncrement(self) -> QtCore.QSize: ...
    def setMaximumHeight(self, maxh: int) -> None: ...
    def setMaximumWidth(self, maxw: int) -> None: ...
    def setMinimumHeight(self, minh: int) -> None: ...
    def setMinimumWidth(self, minw: int) -> None: ...
    @overload
    def setMaximumSize(self, maxw: int, maxh: int) -> None: ...
    @overload
    def setMaximumSize(self, s: QtCore.QSize) -> None: ...
    @overload
    def setMinimumSize(self, minw: int, minh: int) -> None: ...
    @overload
    def setMinimumSize(self, s: QtCore.QSize) -> None: ...
    def maximumSize(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def childrenRegion(self) -> QtGui.QRegion: ...
    def childrenRect(self) -> QtCore.QRect: ...
    def frameSize(self) -> QtCore.QSize: ...
    def pos(self) -> QtCore.QPoint: ...
    def y(self) -> int: ...
    def x(self) -> int: ...
    def normalGeometry(self) -> QtCore.QRect: ...
    def frameGeometry(self) -> QtCore.QRect: ...
    def setWindowModified(self, a0: bool) -> None: ...
    def setDisabled(self, a0: bool) -> None: ...
    def setEnabled(self, a0: bool) -> None: ...
    def isEnabledTo(self, a0: QWidget) -> bool: ...
    def setStyle(self, a0: QStyle) -> None: ...
    def style(self) -> QStyle: ...
    def devType(self) -> int: ...


class QAbstractButton(QWidget):

    clicked: PYQT_SIGNAL
    pressed: PYQT_SIGNAL
    released: PYQT_SIGNAL
    toggled: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def timerEvent(self, e: QtCore.QTimerEvent) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def focusOutEvent(self, e: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, e: QtGui.QFocusEvent) -> None: ...
    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def keyReleaseEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def nextCheckState(self) -> None: ...
    def checkStateSet(self) -> None: ...
    def hitButton(self, pos: QtCore.QPoint) -> bool: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    #def toggled(self, checked: bool) -> None: ...
    #def clicked(self, checked: bool = ...) -> None: ...
    #def released(self) -> None: ...
    #def pressed(self) -> None: ...
    def setChecked(self, a0: bool) -> None: ...
    def toggle(self) -> None: ...
    def click(self) -> None: ...
    def animateClick(self, msecs: int = ...) -> None: ...
    def setIconSize(self, size: QtCore.QSize) -> None: ...
    def group(self) -> QButtonGroup: ...
    def autoExclusive(self) -> bool: ...
    def setAutoExclusive(self, a0: bool) -> None: ...
    def autoRepeat(self) -> bool: ...
    def setAutoRepeat(self, a0: bool) -> None: ...
    def isDown(self) -> bool: ...
    def setDown(self, a0: bool) -> None: ...
    def isChecked(self) -> bool: ...
    def isCheckable(self) -> bool: ...
    def setCheckable(self, a0: bool) -> None: ...
    def shortcut(self) -> QtGui.QKeySequence: ...
    def setShortcut(self, key: typing.Union[QtGui.QKeySequence, int, str, int]) -> None: ...
    def iconSize(self) -> QtCore.QSize: ...
    def icon(self) -> QtGui.QIcon: ...
    def setIcon(self, icon: QtGui.QIcon) -> None: ...
    def text(self) -> str: ...
    def setText(self, text: str) -> None: ...
    def autoRepeatInterval(self) -> int: ...
    def setAutoRepeatInterval(self, a0: int) -> None: ...
    def autoRepeatDelay(self) -> int: ...
    def setAutoRepeatDelay(self, a0: int) -> None: ...


class QAbstractItemDelegate(QtCore.QObject):

    closeEditor: PYQT_SIGNAL
    commitData: PYQT_SIGNAL
    sizeHintChanged: PYQT_SIGNAL

    EndEditHint: typing.Type[int]
    #class EndEditHint(int): ...
    NoHint = ... # type: int
    EditNextItem = ... # type: int
    EditPreviousItem = ... # type: int
    SubmitModelCache = ... # type: int
    RevertModelCache = ... # type: int

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    #def sizeHintChanged(self, a0: QtCore.QModelIndex) -> None: ...
    #def closeEditor(self, editor: QWidget, hint: int = ...) -> None: ...
    #def commitData(self, editor: QWidget) -> None: ...
    def helpEvent(self, event: QtGui.QHelpEvent, view: QAbstractItemView, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> bool: ...
    def editorEvent(self, event: QtCore.QEvent, model: QtCore.QAbstractItemModel, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> bool: ...
    def destroyEditor(self, editor: QWidget, index: QtCore.QModelIndex) -> None: ...
    def updateEditorGeometry(self, editor: QWidget, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> None: ...
    def setModelData(self, editor: QWidget, model: QtCore.QAbstractItemModel, index: QtCore.QModelIndex) -> None: ...
    def setEditorData(self, editor: QWidget, index: QtCore.QModelIndex) -> None: ...
    def createEditor(self, parent: QWidget, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> QWidget: ...
    def sizeHint(self, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> QtCore.QSize: ...
    def paint(self, painter: QtGui.QPainter, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> None: ...


class QFrame(QWidget):

    class StyleMask(int):
        Shadow_Mask = ... # type: QFrame.StyleMask
        Shape_Mask = ... # type: QFrame.StyleMask

    class Shape(int):
        NoFrame = ... # type: QFrame.Shape
        Box = ... # type: QFrame.Shape
        Panel = ... # type: QFrame.Shape
        WinPanel = ... # type: QFrame.Shape
        HLine = ... # type: QFrame.Shape
        VLine = ... # type: QFrame.Shape
        StyledPanel = ... # type: QFrame.Shape

    class Shadow(int):
        Plain = ... # type: QFrame.Shadow
        Raised = ... # type: QFrame.Shadow
        Sunken = ... # type: QFrame.Shadow

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    def initStyleOption(self, option: QStyleOptionFrame) -> None: ...
    def drawFrame(self, a0: QtGui.QPainter) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def setFrameRect(self, a0: QtCore.QRect) -> None: ...
    def frameRect(self) -> QtCore.QRect: ...
    def setMidLineWidth(self, a0: int) -> None: ...
    def midLineWidth(self) -> int: ...
    def setLineWidth(self, a0: int) -> None: ...
    def lineWidth(self) -> int: ...
    def setFrameShadow(self, a0: int) -> None: ...
    def frameShadow(self) -> int: ...
    def setFrameShape(self, a0: int) -> None: ...
    def frameShape(self) -> int: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def frameWidth(self) -> int: ...
    def setFrameStyle(self, a0: int) -> None: ...
    def frameStyle(self) -> int: ...


class QAbstractScrollArea(QFrame):

    class SizeAdjustPolicy(int):
        AdjustIgnored = ... # type: QAbstractScrollArea.SizeAdjustPolicy
        AdjustToContentsOnFirstShow = ... # type: QAbstractScrollArea.SizeAdjustPolicy
        AdjustToContents = ... # type: QAbstractScrollArea.SizeAdjustPolicy

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def setSizeAdjustPolicy(self, policy: int) -> None: ...
    def sizeAdjustPolicy(self) -> int: ...
    def setupViewport(self, viewport: QWidget) -> None: ...
    def setViewport(self, widget: QWidget) -> None: ...
    def scrollBarWidgets(self, alignment: typing.Union[int, int]) -> typing.List[QWidget]: ...
    def addScrollBarWidget(self, widget: QWidget, alignment: typing.Union[int, int]) -> None: ...
    def setCornerWidget(self, widget: QWidget) -> None: ...
    def cornerWidget(self) -> QWidget: ...
    def setHorizontalScrollBar(self, scrollbar: QScrollBar) -> None: ...
    def setVerticalScrollBar(self, scrollbar: QScrollBar) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def dropEvent(self, a0: QtGui.QDropEvent) -> None: ...
    def dragLeaveEvent(self, a0: QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, a0: QtGui.QDragMoveEvent) -> None: ...
    def dragEnterEvent(self, a0: QtGui.QDragEnterEvent) -> None: ...
    def contextMenuEvent(self, a0: QtGui.QContextMenuEvent) -> None: ...
    def wheelEvent(self, a0: QtGui.QWheelEvent) -> None: ...
    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseDoubleClickEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def viewportEvent(self, a0: QtCore.QEvent) -> bool: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def viewportSizeHint(self) -> QtCore.QSize: ...
    def viewportMargins(self) -> QtCore.QMargins: ...
    @overload
    def setViewportMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @overload
    def setViewportMargins(self, margins: QtCore.QMargins) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def maximumViewportSize(self) -> QtCore.QSize: ...
    def viewport(self) -> QWidget: ...
    def horizontalScrollBar(self) -> QScrollBar: ...
    def setHorizontalScrollBarPolicy(self, a0: int) -> None: ...
    def horizontalScrollBarPolicy(self) -> int: ...
    def verticalScrollBar(self) -> QScrollBar: ...
    def setVerticalScrollBarPolicy(self, a0: int) -> None: ...
    def verticalScrollBarPolicy(self) -> int: ...


class QAbstractItemView(QAbstractScrollArea):

    activated: PYQT_SIGNAL
    clicked: PYQT_SIGNAL
    doubleClicked: PYQT_SIGNAL
    entered: PYQT_SIGNAL
    iconSizeChanged: PYQT_SIGNAL
    pressed: PYQT_SIGNAL
    viewportEntered: PYQT_SIGNAL

    DropIndicatorPosition: typing.Type[int]
    #class DropIndicatorPosition(int): ...
    OnItem = ... # type: int
    AboveItem = ... # type: int
    BelowItem = ... # type: int
    OnViewport = ... # type: int

    class State(int):
        NoState = ... # type: QAbstractItemView.State
        DraggingState = ... # type: QAbstractItemView.State
        DragSelectingState = ... # type: QAbstractItemView.State
        EditingState = ... # type: QAbstractItemView.State
        ExpandingState = ... # type: QAbstractItemView.State
        CollapsingState = ... # type: QAbstractItemView.State
        AnimatingState = ... # type: QAbstractItemView.State

    class CursorAction(int):
        MoveUp = ... # type: QAbstractItemView.CursorAction
        MoveDown = ... # type: QAbstractItemView.CursorAction
        MoveLeft = ... # type: QAbstractItemView.CursorAction
        MoveRight = ... # type: QAbstractItemView.CursorAction
        MoveHome = ... # type: QAbstractItemView.CursorAction
        MoveEnd = ... # type: QAbstractItemView.CursorAction
        MovePageUp = ... # type: QAbstractItemView.CursorAction
        MovePageDown = ... # type: QAbstractItemView.CursorAction
        MoveNext = ... # type: QAbstractItemView.CursorAction
        MovePrevious = ... # type: QAbstractItemView.CursorAction

    class SelectionMode(int):
        NoSelection = ... # type: QAbstractItemView.SelectionMode
        SingleSelection = ... # type: QAbstractItemView.SelectionMode
        MultiSelection = ... # type: QAbstractItemView.SelectionMode
        ExtendedSelection = ... # type: QAbstractItemView.SelectionMode
        ContiguousSelection = ... # type: QAbstractItemView.SelectionMode

    class SelectionBehavior(int):
        SelectItems = ... # type: QAbstractItemView.SelectionBehavior
        SelectRows = ... # type: QAbstractItemView.SelectionBehavior
        SelectColumns = ... # type: QAbstractItemView.SelectionBehavior

    class ScrollMode(int):
        ScrollPerItem = ... # type: QAbstractItemView.ScrollMode
        ScrollPerPixel = ... # type: QAbstractItemView.ScrollMode

    class ScrollHint(int):
        EnsureVisible = ... # type: QAbstractItemView.ScrollHint
        PositionAtTop = ... # type: QAbstractItemView.ScrollHint
        PositionAtBottom = ... # type: QAbstractItemView.ScrollHint
        PositionAtCenter = ... # type: QAbstractItemView.ScrollHint

    class EditTrigger(int):
        NoEditTriggers = ... # type: QAbstractItemView.EditTrigger
        CurrentChanged = ... # type: QAbstractItemView.EditTrigger
        DoubleClicked = ... # type: QAbstractItemView.EditTrigger
        SelectedClicked = ... # type: QAbstractItemView.EditTrigger
        EditKeyPressed = ... # type: QAbstractItemView.EditTrigger
        AnyKeyPressed = ... # type: QAbstractItemView.EditTrigger
        AllEditTriggers = ... # type: QAbstractItemView.EditTrigger

    class DragDropMode(int):
        NoDragDrop = ... # type: QAbstractItemView.DragDropMode
        DragOnly = ... # type: QAbstractItemView.DragDropMode
        DropOnly = ... # type: QAbstractItemView.DragDropMode
        DragDrop = ... # type: QAbstractItemView.DragDropMode
        InternalMove = ... # type: QAbstractItemView.DragDropMode

    EditTriggers: typing.Type[int]
    #class EditTriggers(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QAbstractItemView.EditTriggers, QAbstractItemView.EditTrigger]) -> None: ...
        #@overload
        #def __init__(self, a0: QAbstractItemView.EditTriggers) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QAbstractItemView.EditTriggers: ...
        #def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def isPersistentEditorOpen(self, index: QtCore.QModelIndex) -> bool: ...
    def resetHorizontalScrollMode(self) -> None: ...
    def resetVerticalScrollMode(self) -> None: ...
    def defaultDropAction(self) -> int: ...
    def setDefaultDropAction(self, dropAction: int) -> None: ...
    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def viewportSizeHint(self) -> QtCore.QSize: ...
    def inputMethodEvent(self, event: QtGui.QInputMethodEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def autoScrollMargin(self) -> int: ...
    def setAutoScrollMargin(self, margin: int) -> None: ...
    def inputMethodQuery(self, query: int) -> typing.Any: ...
    def itemDelegateForColumn(self, column: int) -> QAbstractItemDelegate: ...
    def setItemDelegateForColumn(self, column: int, delegate: QAbstractItemDelegate) -> None: ...
    def itemDelegateForRow(self, row: int) -> QAbstractItemDelegate: ...
    def setItemDelegateForRow(self, row: int, delegate: QAbstractItemDelegate) -> None: ...
    def dragDropMode(self) -> int: ...
    def setDragDropMode(self, behavior: int) -> None: ...
    def dragDropOverwriteMode(self) -> bool: ...
    def setDragDropOverwriteMode(self, overwrite: bool) -> None: ...
    def horizontalScrollMode(self) -> int: ...
    def setHorizontalScrollMode(self, mode: int) -> None: ...
    def verticalScrollMode(self) -> int: ...
    def setVerticalScrollMode(self, mode: int) -> None: ...
    def dropIndicatorPosition(self) -> int: ...
    def timerEvent(self, e: QtCore.QTimerEvent) -> None: ...
    def resizeEvent(self, e: QtGui.QResizeEvent) -> None: ...
    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def focusOutEvent(self, e: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, e: QtGui.QFocusEvent) -> None: ...
    def dropEvent(self, e: QtGui.QDropEvent) -> None: ...
    def dragLeaveEvent(self, e: QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: QtGui.QDragMoveEvent) -> None: ...
    def dragEnterEvent(self, e: QtGui.QDragEnterEvent) -> None: ...
    def mouseDoubleClickEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def viewportEvent(self, e: QtCore.QEvent) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def dirtyRegionOffset(self) -> QtCore.QPoint: ...
    def setDirtyRegion(self, region: QtGui.QRegion) -> None: ...
    def scrollDirtyRegion(self, dx: int, dy: int) -> None: ...
    def executeDelayedItemsLayout(self) -> None: ...
    def scheduleDelayedItemsLayout(self) -> None: ...
    def setState(self, state: int) -> None: ...
    def state(self) -> int: ...
    def viewOptions(self) -> QStyleOptionViewItem: ...
    def startDrag(self, supportedActions: typing.Union[int, int]) -> None: ...
    def selectionCommand(self, index: QtCore.QModelIndex, event: typing.Optional[QtCore.QEvent] = ...) -> int: ...
    def selectedIndexes(self) -> typing.List[QtCore.QModelIndex]: ...
    def visualRegionForSelection(self, selection: QtCore.QItemSelection) -> QtGui.QRegion: ...
    def setSelection(self, rect: QtCore.QRect, command: typing.Union[int, int]) -> None: ...
    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool: ...
    def verticalOffset(self) -> int: ...
    def horizontalOffset(self) -> int: ...
    def moveCursor(self, cursorAction: int, modifiers: typing.Union[int, int]) -> QtCore.QModelIndex: ...
    #def iconSizeChanged(self, size: QtCore.QSize) -> None: ...
    #def viewportEntered(self) -> None: ...
    #def entered(self, index: QtCore.QModelIndex) -> None: ...
    #def activated(self, index: QtCore.QModelIndex) -> None: ...
    #def doubleClicked(self, index: QtCore.QModelIndex) -> None: ...
    #def clicked(self, index: QtCore.QModelIndex) -> None: ...
    #def pressed(self, index: QtCore.QModelIndex) -> None: ...
    def editorDestroyed(self, editor: QtCore.QObject) -> None: ...
    def commitData(self, editor: QWidget) -> None: ...
    def closeEditor(self, editor: QWidget, hint: int) -> None: ...
    def horizontalScrollbarValueChanged(self, value: int) -> None: ...
    def verticalScrollbarValueChanged(self, value: int) -> None: ...
    def horizontalScrollbarAction(self, action: int) -> None: ...
    def verticalScrollbarAction(self, action: int) -> None: ...
    def updateGeometries(self) -> None: ...
    def updateEditorGeometries(self) -> None: ...
    def updateEditorData(self) -> None: ...
    def currentChanged(self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex) -> None: ...
    def selectionChanged(self, selected: QtCore.QItemSelection, deselected: QtCore.QItemSelection) -> None: ...
    def rowsAboutToBeRemoved(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def rowsInserted(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def dataChanged(self, topLeft: QtCore.QModelIndex, bottomRight: QtCore.QModelIndex, roles: typing.Iterable[int] = ...) -> None: ...
    @overload
    def update(self) -> None: ...
    @overload
    def update(self, index: QtCore.QModelIndex) -> None: ...
    def scrollToBottom(self) -> None: ...
    def scrollToTop(self) -> None: ...
    def setCurrentIndex(self, index: QtCore.QModelIndex) -> None: ...
    def clearSelection(self) -> None: ...
    @overload
    def edit(self, index: QtCore.QModelIndex) -> None: ...
    @overload
    def edit(self, index: QtCore.QModelIndex, trigger: int, event: QtCore.QEvent) -> bool: ...
    def selectAll(self) -> None: ...
    def setRootIndex(self, index: QtCore.QModelIndex) -> None: ...
    def reset(self) -> None: ...
    def indexWidget(self, index: QtCore.QModelIndex) -> QWidget: ...
    def setIndexWidget(self, index: QtCore.QModelIndex, widget: QWidget) -> None: ...
    def closePersistentEditor(self, index: QtCore.QModelIndex) -> None: ...
    def openPersistentEditor(self, index: QtCore.QModelIndex) -> None: ...
    def sizeHintForColumn(self, column: int) -> int: ...
    def sizeHintForRow(self, row: int) -> int: ...
    def sizeHintForIndex(self, index: QtCore.QModelIndex) -> QtCore.QSize: ...
    def indexAt(self, p: QtCore.QPoint) -> QtCore.QModelIndex: ...
    def scrollTo(self, index: QtCore.QModelIndex, hint: int = ...) -> None: ...
    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect: ...
    def keyboardSearch(self, search: str) -> None: ...
    def textElideMode(self) -> int: ...
    def setTextElideMode(self, mode: int) -> None: ...
    def iconSize(self) -> QtCore.QSize: ...
    def setIconSize(self, size: QtCore.QSize) -> None: ...
    def alternatingRowColors(self) -> bool: ...
    def setAlternatingRowColors(self, enable: bool) -> None: ...
    def dragEnabled(self) -> bool: ...
    def setDragEnabled(self, enable: bool) -> None: ...
    def showDropIndicator(self) -> bool: ...
    def setDropIndicatorShown(self, enable: bool) -> None: ...
    def tabKeyNavigation(self) -> bool: ...
    def setTabKeyNavigation(self, enable: bool) -> None: ...
    def hasAutoScroll(self) -> bool: ...
    def setAutoScroll(self, enable: bool) -> None: ...
    def editTriggers(self) -> int: ...
    def setEditTriggers(self, triggers: typing.Union[int, int]) -> None: ...
    def rootIndex(self) -> QtCore.QModelIndex: ...
    def currentIndex(self) -> QtCore.QModelIndex: ...
    def selectionBehavior(self) -> int: ...
    def setSelectionBehavior(self, behavior: int) -> None: ...
    def selectionMode(self) -> int: ...
    def setSelectionMode(self, mode: int) -> None: ...
    @overload
    def itemDelegate(self) -> QAbstractItemDelegate: ...
    @overload
    def itemDelegate(self, index: QtCore.QModelIndex) -> QAbstractItemDelegate: ...
    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None: ...
    def selectionModel(self) -> QtCore.QItemSelectionModel: ...
    def setSelectionModel(self, selectionModel: QtCore.QItemSelectionModel) -> None: ...
    def model(self) -> typing.Optional[QtCore.QAbstractItemModel]: ...
    def setModel(self, model: typing.Optional[QtCore.QAbstractItemModel]) -> None: ...


class QAbstractSlider(QWidget):

    actionTriggered: PYQT_SIGNAL
    rangeChanged: PYQT_SIGNAL
    sliderMoved: PYQT_SIGNAL
    sliderPressed: PYQT_SIGNAL
    sliderReleased: PYQT_SIGNAL
    valueChanged: PYQT_SIGNAL

    SliderChange: typing.Type[int]
    #class SliderChange(int): ...
    SliderRangeChange = ... # type: int
    SliderOrientationChange = ... # type: int
    SliderStepsChange = ... # type: int
    SliderValueChange = ... # type: int

    SliderAction: typing.Type[int]
    #class SliderAction(int): ...
    SliderNoAction = ... # type: int
    SliderSingleStepAdd = ... # type: int
    SliderSingleStepSub = ... # type: int
    SliderPageStepAdd = ... # type: int
    SliderPageStepSub = ... # type: int
    SliderToMinimum = ... # type: int
    SliderToMaximum = ... # type: int
    SliderMove = ... # type: int

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def wheelEvent(self, e: QtGui.QWheelEvent) -> None: ...
    def timerEvent(self, a0: QtCore.QTimerEvent) -> None: ...
    def keyPressEvent(self, ev: QtGui.QKeyEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def sliderChange(self, change: int) -> None: ...
    def repeatAction(self) -> int: ...
    def setRepeatAction(self, action: int, thresholdTime: int = ..., repeatTime: int = ...) -> None: ...
    #def actionTriggered(self, action: int) -> None: ...
    #def rangeChanged(self, min: int, max: int) -> None: ...
    #def sliderReleased(self) -> None: ...
    #def sliderMoved(self, position: int) -> None: ...
    #def sliderPressed(self) -> None: ...
    #def valueChanged(self, value: int) -> None: ...
    def setOrientation(self, a0: int) -> None: ...
    def setValue(self, a0: int) -> None: ...
    def triggerAction(self, action: int) -> None: ...
    def value(self) -> int: ...
    def invertedControls(self) -> bool: ...
    def setInvertedControls(self, a0: bool) -> None: ...
    def invertedAppearance(self) -> bool: ...
    def setInvertedAppearance(self, a0: bool) -> None: ...
    def sliderPosition(self) -> int: ...
    def setSliderPosition(self, a0: int) -> None: ...
    def isSliderDown(self) -> bool: ...
    def setSliderDown(self, a0: bool) -> None: ...
    def hasTracking(self) -> bool: ...
    def setTracking(self, enable: bool) -> None: ...
    def pageStep(self) -> int: ...
    def setPageStep(self, a0: int) -> None: ...
    def singleStep(self) -> int: ...
    def setSingleStep(self, a0: int) -> None: ...
    def setRange(self, min: int, max: int) -> None: ...
    def maximum(self) -> int: ...
    def setMaximum(self, a0: int) -> None: ...
    def minimum(self) -> int: ...
    def setMinimum(self, a0: int) -> None: ...
    def orientation(self) -> int: ...


class QAbstractSpinBox(QWidget):

    editingFinished: PYQT_SIGNAL

    StepType: typing.Type[int]
    #class StepType(int): ...
    DefaultStepType = ... # type: int
    AdaptiveDecimalStepType = ... # type: int

    CorrectionMode: typing.Type[int]
    #class CorrectionMode(int): ...
    CorrectToPreviousValue = ... # type: int
    CorrectToNearestValue = ... # type: int

    ButtonSymbols: typing.Type[int]
    #class ButtonSymbols(int): ...
    UpDownArrows = ... # type: int
    PlusMinus = ... # type: int
    NoButtons = ... # type: int

    StepEnabledFlag: typing.Type[int]
    #class StepEnabledFlag(int): ...
    StepNone = ... # type: int
    StepUpEnabled = ... # type: int
    StepDownEnabled = ... # type: int

    StepEnabled: typing.Type[int]
    #class StepEnabled(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QAbstractSpinBox.StepEnabled, QAbstractSpinBox.StepEnabledFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QAbstractSpinBox.StepEnabled) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QAbstractSpinBox.StepEnabled: ...
        #def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def isGroupSeparatorShown(self) -> bool: ...
    def setGroupSeparatorShown(self, shown: bool) -> None: ...
    def inputMethodQuery(self, a0: int) -> typing.Any: ...
    def keyboardTracking(self) -> bool: ...
    def setKeyboardTracking(self, kt: bool) -> None: ...
    def isAccelerated(self) -> bool: ...
    def setAccelerated(self, on: bool) -> None: ...
    def hasAcceptableInput(self) -> bool: ...
    def correctionMode(self) -> int: ...
    def setCorrectionMode(self, cm: int) -> None: ...
    def initStyleOption(self, option: QStyleOptionSpinBox) -> None: ...
    def stepEnabled(self) -> int: ...
    def setLineEdit(self, e: QLineEdit) -> None: ...
    def lineEdit(self) -> QLineEdit: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def timerEvent(self, e: QtCore.QTimerEvent) -> None: ...
    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def hideEvent(self, e: QtGui.QHideEvent) -> None: ...
    def closeEvent(self, e: QtGui.QCloseEvent) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def contextMenuEvent(self, e: QtGui.QContextMenuEvent) -> None: ...
    def focusOutEvent(self, e: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, e: QtGui.QFocusEvent) -> None: ...
    def wheelEvent(self, e: QtGui.QWheelEvent) -> None: ...
    def keyReleaseEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def resizeEvent(self, e: QtGui.QResizeEvent) -> None: ...
    #def editingFinished(self) -> None: ...
    def clear(self) -> None: ...
    def selectAll(self) -> None: ...
    def stepDown(self) -> None: ...
    def stepUp(self) -> None: ...
    def stepBy(self, steps: int) -> None: ...
    def fixup(self, input: str) -> str: ...
    def validate(self, input: str, pos: int) -> typing.Tuple[int, str, int]: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def interpretText(self) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def hasFrame(self) -> bool: ...
    def setFrame(self, a0: bool) -> None: ...
    def alignment(self) -> int: ...
    def setAlignment(self, flag: typing.Union[int, int]) -> None: ...
    def isReadOnly(self) -> bool: ...
    def setReadOnly(self, r: bool) -> None: ...
    def setWrapping(self, w: bool) -> None: ...
    def wrapping(self) -> bool: ...
    def setSpecialValueText(self, s: str) -> None: ...
    def specialValueText(self) -> str: ...
    def text(self) -> str: ...
    def setButtonSymbols(self, bs: int) -> None: ...
    def buttonSymbols(self) -> int: ...


class QAction(QtCore.QObject):

    changed: PYQT_SIGNAL
    hovered: PYQT_SIGNAL
    toggled: PYQT_SIGNAL
    triggered: PYQT_SIGNAL

    Priority: typing.Type[int]
    #class Priority(int): ...
    LowPriority = ... # type: int
    NormalPriority = ... # type: int
    HighPriority = ... # type: int

    MenuRole: typing.Type[int]
    #class MenuRole(int): ...
    NoRole = ... # type: int
    TextHeuristicRole = ... # type: int
    ApplicationSpecificRole = ... # type: int
    AboutQtRole = ... # type: int
    AboutRole = ... # type: int
    PreferencesRole = ... # type: int
    QuitRole = ... # type: int

    ActionEvent: typing.Type[int]
    #class ActionEvent(int): ...
    Trigger = ... # type: int
    Hover = ... # type: int

    @overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, icon: QtGui.QIcon, text: str, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def isShortcutVisibleInContextMenu(self) -> bool: ...
    def setShortcutVisibleInContextMenu(self, show: bool) -> None: ...
    def priority(self) -> int: ...
    def setPriority(self, priority: int) -> None: ...
    def isIconVisibleInMenu(self) -> bool: ...
    def setIconVisibleInMenu(self, visible: bool) -> None: ...
    def associatedGraphicsWidgets(self) -> typing.List[QGraphicsWidget]: ...
    def associatedWidgets(self) -> typing.List[QWidget]: ...
    def menuRole(self) -> int: ...
    def setMenuRole(self, menuRole: int) -> None: ...
    def autoRepeat(self) -> bool: ...
    def setAutoRepeat(self, a0: bool) -> None: ...
    def shortcuts(self) -> typing.List[QtGui.QKeySequence]: ...
    @overload
    def setShortcuts(self, shortcuts: typing.Iterable[typing.Union[QtGui.QKeySequence, int, str, int]]) -> None: ...
    @overload
    def setShortcuts(self, a0: int) -> None: ...
    #def toggled(self, a0: bool) -> None: ...
    #def hovered(self) -> None: ...
    #def triggered(self, checked: bool = ...) -> None: ...
    #def changed(self) -> None: ...
    def setVisible(self, a0: bool) -> None: ...
    def setDisabled(self, b: bool) -> None: ...
    def setEnabled(self, a0: bool) -> None: ...
    def toggle(self) -> None: ...
    def setChecked(self, a0: bool) -> None: ...
    def hover(self) -> None: ...
    def trigger(self) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def parentWidget(self) -> QWidget: ...
    def showStatusText(self, widget: typing.Optional[QWidget] = ...) -> bool: ...
    def activate(self, event: int) -> None: ...
    def isVisible(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def setData(self, var: typing.Any) -> None: ...
    def data(self) -> typing.Any: ...
    def isCheckable(self) -> bool: ...
    def setCheckable(self, a0: bool) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def shortcutContext(self) -> int: ...
    def setShortcutContext(self, context: int) -> None: ...
    def shortcut(self) -> QtGui.QKeySequence: ...
    def setShortcut(self, shortcut: typing.Union[QtGui.QKeySequence, int, str, int]) -> None: ...
    def isSeparator(self) -> bool: ...
    def setSeparator(self, b: bool) -> None: ...
    def setMenu(self, menu: QMenu) -> None: ...
    def menu(self) -> QMenu: ...
    def whatsThis(self) -> str: ...
    def setWhatsThis(self, what: str) -> None: ...
    def statusTip(self) -> str: ...
    def setStatusTip(self, statusTip: str) -> None: ...
    def toolTip(self) -> str: ...
    def setToolTip(self, tip: str) -> None: ...
    def iconText(self) -> str: ...
    def setIconText(self, text: str) -> None: ...
    def text(self) -> str: ...
    def setText(self, text: str) -> None: ...
    def icon(self) -> QtGui.QIcon: ...
    def setIcon(self, icon: QtGui.QIcon) -> None: ...
    def actionGroup(self) -> QActionGroup: ...
    def setActionGroup(self, group: QActionGroup) -> None: ...


class QActionGroup(QtCore.QObject):

    hovered: PYQT_SIGNAL
    triggered: PYQT_SIGNAL

    def __init__(self, parent: QtCore.QObject, **props) -> None: ...

    #def hovered(self, a0: QAction) -> None: ...
    #def triggered(self, a0: QAction) -> None: ...
    def setExclusive(self, a0: bool) -> None: ...
    def setVisible(self, a0: bool) -> None: ...
    def setDisabled(self, b: bool) -> None: ...
    def setEnabled(self, a0: bool) -> None: ...
    def isVisible(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isExclusive(self) -> bool: ...
    def checkedAction(self) -> QAction: ...
    def actions(self) -> typing.List[QAction]: ...
    def removeAction(self, a: QAction) -> None: ...
    @overload
    def addAction(self, a: QAction) -> QAction: ...
    @overload
    def addAction(self, text: str) -> QAction: ...
    @overload
    def addAction(self, icon: QtGui.QIcon, text: str) -> QAction: ...


class QApplication(QtGui.QGuiApplication):

    focusChanged: PYQT_SIGNAL

    ColorSpec: typing.Type[int]
    #class ColorSpec(int): ...
    NormalColor = ... # type: int
    CustomColor = ... # type: int
    ManyColor = ... # type: int

    def __init__(self, argv: typing.List[str], **props) -> None: ...

    def event(self, a0: QtCore.QEvent) -> bool: ...
    def setStyleSheet(self, sheet: str) -> None: ...
    def setAutoSipEnabled(self, enabled: bool) -> None: ...
    @staticmethod
    def closeAllWindows() -> None: ...
    @staticmethod
    def aboutQt() -> None: ...
    #def focusChanged(self, old: QWidget, now: QWidget) -> None: ...
    def styleSheet(self) -> str: ...
    def autoSipEnabled(self) -> bool: ...
    def notify(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    @staticmethod
    def exec() -> int: ...
    @staticmethod
    def exec_() -> int: ...
    @staticmethod
    def setEffectEnabled(a0: int, enabled: bool = ...) -> None: ...
    @staticmethod
    def isEffectEnabled(a0: int) -> bool: ...
    @staticmethod
    def startDragDistance() -> int: ...
    @staticmethod
    def setStartDragDistance(l: int) -> None: ...
    @staticmethod
    def startDragTime() -> int: ...
    @staticmethod
    def setStartDragTime(ms: int) -> None: ...
    @staticmethod
    def globalStrut() -> QtCore.QSize: ...
    @staticmethod
    def setGlobalStrut(a0: QtCore.QSize) -> None: ...
    @staticmethod
    def wheelScrollLines() -> int: ...
    @staticmethod
    def setWheelScrollLines(a0: int) -> None: ...
    @staticmethod
    def keyboardInputInterval() -> int: ...
    @staticmethod
    def setKeyboardInputInterval(a0: int) -> None: ...
    @staticmethod
    def doubleClickInterval() -> int: ...
    @staticmethod
    def setDoubleClickInterval(a0: int) -> None: ...
    @staticmethod
    def cursorFlashTime() -> int: ...
    @staticmethod
    def setCursorFlashTime(a0: int) -> None: ...
    @staticmethod
    def alert(widget: QWidget, msecs: int = ...) -> None: ...
    @staticmethod
    def beep() -> None: ...
    @overload
    @staticmethod
    def topLevelAt(p: QtCore.QPoint) -> QWidget: ...
    @overload
    @staticmethod
    def topLevelAt(x: int, y: int) -> QWidget: ...
    @overload
    @staticmethod
    def widgetAt(p: QtCore.QPoint) -> QWidget: ...
    @overload
    @staticmethod
    def widgetAt(x: int, y: int) -> QWidget: ...
    @staticmethod
    def setActiveWindow(act: QWidget) -> None: ...
    @staticmethod
    def activeWindow() -> QWidget: ...
    @staticmethod
    def focusWidget() -> QWidget: ...
    @staticmethod
    def activeModalWidget() -> QWidget: ...
    @staticmethod
    def activePopupWidget() -> QWidget: ...
    @staticmethod
    def desktop() -> QDesktopWidget: ...
    @staticmethod
    def topLevelWidgets() -> typing.List[QWidget]: ...
    @staticmethod
    def allWidgets() -> typing.List[QWidget]: ...
    @staticmethod
    def windowIcon() -> QtGui.QIcon: ...
    @staticmethod
    def setWindowIcon(icon: QtGui.QIcon) -> None: ...
    @staticmethod
    def fontMetrics() -> QtGui.QFontMetrics: ...
    @staticmethod
    def setFont(a0: QtGui.QFont, className: typing.Optional[str] = ...) -> None: ...
    @overload
    @staticmethod
    def font() -> QtGui.QFont: ...
    @overload
    @staticmethod
    def font(a0: QWidget) -> QtGui.QFont: ...
    @overload
    @staticmethod
    def font(className: str) -> QtGui.QFont: ...
    @staticmethod
    def setPalette(a0: QtGui.QPalette, className: typing.Optional[str] = ...) -> None: ...
    @overload
    @staticmethod
    def palette() -> QtGui.QPalette: ...
    @overload
    @staticmethod
    def palette(a0: QWidget) -> QtGui.QPalette: ...
    @overload
    @staticmethod
    def palette(className: str) -> QtGui.QPalette: ...
    @staticmethod
    def setColorSpec(a0: int) -> None: ...
    @staticmethod
    def colorSpec() -> int: ...
    @overload
    @staticmethod
    def setStyle(a0: QStyle) -> None: ...
    @overload
    @staticmethod
    def setStyle(a0: str) -> QStyle: ...
    @staticmethod
    def style() -> QStyle: ...


class QLayoutItem(sip.wrapper):

    @overload
    def __init__(self, alignment: typing.Union[int, int] = ...) -> None: ...
    @overload
    def __init__(self, a0: QLayoutItem) -> None: ...

    def controlTypes(self) -> int: ...
    def setAlignment(self, a: typing.Union[int, int]) -> None: ...
    def alignment(self) -> int: ...
    def spacerItem(self) -> QSpacerItem: ...
    def layout(self) -> QLayout: ...
    def widget(self) -> QWidget: ...
    def invalidate(self) -> None: ...
    def minimumHeightForWidth(self, a0: int) -> int: ...
    def heightForWidth(self, a0: int) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def geometry(self) -> QtCore.QRect: ...
    def setGeometry(self, a0: QtCore.QRect) -> None: ...
    def expandingDirections(self) -> int: ...
    def maximumSize(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QLayout(QtCore.QObject, QLayoutItem):

    class SizeConstraint(int):
        SetDefaultConstraint = ... # type: QLayout.SizeConstraint
        SetNoConstraint = ... # type: QLayout.SizeConstraint
        SetMinimumSize = ... # type: QLayout.SizeConstraint
        SetFixedSize = ... # type: QLayout.SizeConstraint
        SetMaximumSize = ... # type: QLayout.SizeConstraint
        SetMinAndMaxSize = ... # type: QLayout.SizeConstraint

    @overload
    def __init__(self, parent: QWidget, **props) -> None: ...
    @overload
    def __init__(self, **props) -> None: ...

    def replaceWidget(self, from_: QWidget, to: QWidget, options: typing.Union[int, int] = ...) -> QLayoutItem: ...
    def controlTypes(self) -> int: ...
    def contentsMargins(self) -> QtCore.QMargins: ...
    def contentsRect(self) -> QtCore.QRect: ...
    def getContentsMargins(self) -> typing.Tuple[int, int, int, int]: ...
    @overload
    def setContentsMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @overload
    def setContentsMargins(self, margins: QtCore.QMargins) -> None: ...
    def alignmentRect(self, a0: QtCore.QRect) -> QtCore.QRect: ...
    def addChildWidget(self, w: QWidget) -> None: ...
    def addChildLayout(self, l: QLayout) -> None: ...
    def childEvent(self, e: QtCore.QChildEvent) -> None: ...
    def widgetEvent(self, a0: QtCore.QEvent) -> None: ...
    @staticmethod
    def closestAcceptableSize(w: QWidget, s: QtCore.QSize) -> QtCore.QSize: ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, a0: bool) -> None: ...
    def layout(self) -> QLayout: ...
    def totalSizeHint(self) -> QtCore.QSize: ...
    def totalMaximumSize(self) -> QtCore.QSize: ...
    def totalMinimumSize(self) -> QtCore.QSize: ...
    def totalHeightForWidth(self, w: int) -> int: ...
    def isEmpty(self) -> bool: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    @overload
    def indexOf(self, a0: QWidget) -> int: ...
    @overload
    def indexOf(self, a0: QLayoutItem) -> int: ...
    def takeAt(self, index: int) -> QLayoutItem: ...
    def itemAt(self, index: int) -> QLayoutItem: ...
    def setGeometry(self, a0: QtCore.QRect) -> None: ...
    def maximumSize(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def expandingDirections(self) -> int: ...
    def removeItem(self, a0: QLayoutItem) -> None: ...
    def removeWidget(self, w: QWidget) -> None: ...
    def addItem(self, a0: QLayoutItem) -> None: ...
    def addWidget(self, w: QWidget) -> None: ...
    def update(self) -> None: ...
    def activate(self) -> bool: ...
    def geometry(self) -> QtCore.QRect: ...
    def invalidate(self) -> None: ...
    def parentWidget(self) -> QWidget: ...
    def menuBar(self) -> QWidget: ...
    def setMenuBar(self, w: QWidget) -> None: ...
    def sizeConstraint(self) -> int: ...
    def setSizeConstraint(self, a0: int) -> None: ...
    @overload
    def setAlignment(self, w: QWidget, alignment: typing.Union[int, int]) -> bool: ...
    @overload
    def setAlignment(self, l: QLayout, alignment: typing.Union[int, int]) -> bool: ...
    @overload
    def setAlignment(self, alignment: typing.Union[int, int]) -> None: ...
    def setSpacing(self, a0: int) -> None: ...
    def spacing(self) -> int: ...


class QBoxLayout(QLayout):

    Direction: typing.Type[int]
    #class Direction(int): ...
    LeftToRight = ... # type: int
    RightToLeft = ... # type: int
    TopToBottom = ... # type: int
    BottomToTop = ... # type: int
    Down = ... # type: int
    Up = ... # type: int

    def __init__(self, direction: int, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def insertItem(self, index: int, a1: QLayoutItem) -> None: ...
    def stretch(self, index: int) -> int: ...
    def setStretch(self, index: int, stretch: int) -> None: ...
    def insertSpacerItem(self, index: int, spacerItem: QSpacerItem) -> None: ...
    def addSpacerItem(self, spacerItem: QSpacerItem) -> None: ...
    def setSpacing(self, spacing: int) -> None: ...
    def spacing(self) -> int: ...
    def setGeometry(self, a0: QtCore.QRect) -> None: ...
    def count(self) -> int: ...
    def takeAt(self, a0: int) -> QLayoutItem: ...
    def itemAt(self, a0: int) -> QLayoutItem: ...
    def invalidate(self) -> None: ...
    def expandingDirections(self) -> int: ...
    def minimumHeightForWidth(self, a0: int) -> int: ...
    def heightForWidth(self, a0: int) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def maximumSize(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    @overload
    def setStretchFactor(self, w: QWidget, stretch: int) -> bool: ...
    @overload
    def setStretchFactor(self, l: QLayout, stretch: int) -> bool: ...
    def insertLayout(self, index: int, layout: QLayout, stretch: int = ...) -> None: ...
    def insertWidget(self, index: int, widget: QWidget, stretch: int = ..., alignment: typing.Union[int, int] = ...) -> None: ...
    def insertStretch(self, index: int, stretch: int = ...) -> None: ...
    def insertSpacing(self, index: int, size: int) -> None: ...
    def addItem(self, a0: QLayoutItem) -> None: ...
    def addStrut(self, a0: int) -> None: ...
    def addLayout(self, layout: QLayout, stretch: int = ...) -> None: ...
    def addWidget(self, a0: QWidget, stretch: int = ..., alignment: typing.Union[int, int] = ...) -> None: ...
    def addStretch(self, stretch: int = ...) -> None: ...
    def addSpacing(self, size: int) -> None: ...
    def setDirection(self, a0: int) -> None: ...
    def direction(self) -> int: ...


class QHBoxLayout(QBoxLayout):

    @overload
    def __init__(self, **props) -> None: ...
    @overload
    def __init__(self, parent: QWidget, **props) -> None: ...


class QVBoxLayout(QBoxLayout):

    @overload
    def __init__(self, **props) -> None: ...
    @overload
    def __init__(self, parent: QWidget, **props) -> None: ...


class QButtonGroup(QtCore.QObject):

    buttonClicked: PYQT_SIGNAL
    buttonPressed: PYQT_SIGNAL
    buttonReleased: PYQT_SIGNAL
    buttonToggled: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    #@overload
    #def buttonToggled(self, a0: QAbstractButton, a1: bool) -> None: ...
    #@overload
    #def buttonToggled(self, a0: int, a1: bool) -> None: ...
    #@overload
    #def buttonReleased(self, a0: QAbstractButton) -> None: ...
    #@overload
    #def buttonReleased(self, a0: int) -> None: ...
    #@overload
    #def buttonPressed(self, a0: QAbstractButton) -> None: ...
    #@overload
    #def buttonPressed(self, a0: int) -> None: ...
    #@overload
    #def buttonClicked(self, a0: QAbstractButton) -> None: ...
    #@overload
    #def buttonClicked(self, a0: int) -> None: ...
    def checkedId(self) -> int: ...
    def id(self, button: QAbstractButton) -> int: ...
    def setId(self, button: QAbstractButton, id: int) -> None: ...
    def checkedButton(self) -> QAbstractButton: ...
    def button(self, id: int) -> QAbstractButton: ...
    def buttons(self) -> typing.List[QAbstractButton]: ...
    def removeButton(self, a0: QAbstractButton) -> None: ...
    def addButton(self, a0: QAbstractButton, id: int = ...) -> None: ...
    def exclusive(self) -> bool: ...
    def setExclusive(self, a0: bool) -> None: ...


class QCalendarWidget(QWidget):

    activated: PYQT_SIGNAL
    clicked: PYQT_SIGNAL
    currentPageChanged: PYQT_SIGNAL
    selectionChanged: PYQT_SIGNAL

    SelectionMode: typing.Type[int]
    #class SelectionMode(int): ...
    NoSelection = ... # type: int
    SingleSelection = ... # type: int

    VerticalHeaderFormat: typing.Type[int]
    #class VerticalHeaderFormat(int): ...
    NoVerticalHeader = ... # type: int
    ISOWeekNumbers = ... # type: int

    HorizontalHeaderFormat: typing.Type[int]
    #class HorizontalHeaderFormat(int): ...
    NoHorizontalHeader = ... # type: int
    SingleLetterDayNames = ... # type: int
    ShortDayNames = ... # type: int
    LongDayNames = ... # type: int

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def setNavigationBarVisible(self, visible: bool) -> None: ...
    def setDateEditAcceptDelay(self, delay: int) -> None: ...
    def dateEditAcceptDelay(self) -> int: ...
    def setDateEditEnabled(self, enable: bool) -> None: ...
    def isDateEditEnabled(self) -> bool: ...
    def isNavigationBarVisible(self) -> bool: ...
    #def selectionChanged(self) -> None: ...
    #def currentPageChanged(self, year: int, month: int) -> None: ...
    #def clicked(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    #def activated(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def showToday(self) -> None: ...
    def showSelectedDate(self) -> None: ...
    def showPreviousYear(self) -> None: ...
    def showPreviousMonth(self) -> None: ...
    def showNextYear(self) -> None: ...
    def showNextMonth(self) -> None: ...
    def setSelectedDate(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def setDateRange(self, min: typing.Union[QtCore.QDate, datetime.date], max: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def setCurrentPage(self, year: int, month: int) -> None: ...
    def paintCell(self, painter: QtGui.QPainter, rect: QtCore.QRect, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def eventFilter(self, watched: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def updateCells(self) -> None: ...
    def updateCell(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def setDateTextFormat(self, date: typing.Union[QtCore.QDate, datetime.date], color: QtGui.QTextCharFormat) -> None: ...
    @overload
    def dateTextFormat(self) -> typing.Dict[QtCore.QDate, QtGui.QTextCharFormat]: ...
    @overload
    def dateTextFormat(self, date: typing.Union[QtCore.QDate, datetime.date]) -> QtGui.QTextCharFormat: ...
    def setWeekdayTextFormat(self, dayOfWeek: int, format: QtGui.QTextCharFormat) -> None: ...
    def weekdayTextFormat(self, dayOfWeek: int) -> QtGui.QTextCharFormat: ...
    def setHeaderTextFormat(self, format: QtGui.QTextCharFormat) -> None: ...
    def headerTextFormat(self) -> QtGui.QTextCharFormat: ...
    def setVerticalHeaderFormat(self, format: int) -> None: ...
    def verticalHeaderFormat(self) -> int: ...
    def setHorizontalHeaderFormat(self, format: int) -> None: ...
    def horizontalHeaderFormat(self) -> int: ...
    def setSelectionMode(self, mode: int) -> None: ...
    def selectionMode(self) -> int: ...
    def setGridVisible(self, show: bool) -> None: ...
    def isGridVisible(self) -> bool: ...
    def setFirstDayOfWeek(self, dayOfWeek: int) -> None: ...
    def firstDayOfWeek(self) -> int: ...
    def setMaximumDate(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def maximumDate(self) -> QtCore.QDate: ...
    def setMinimumDate(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def minimumDate(self) -> QtCore.QDate: ...
    def monthShown(self) -> int: ...
    def yearShown(self) -> int: ...
    def selectedDate(self) -> QtCore.QDate: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QCheckBox(QAbstractButton):

    stateChanged: PYQT_SIGNAL

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def initStyleOption(self, option: QStyleOptionButton) -> None: ...
    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def nextCheckState(self) -> None: ...
    def checkStateSet(self) -> None: ...
    def hitButton(self, pos: QtCore.QPoint) -> bool: ...
    #def stateChanged(self, a0: int) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def setCheckState(self, state: int) -> None: ...
    def checkState(self) -> int: ...
    def isTristate(self) -> bool: ...
    def setTristate(self, on: bool = ...) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QDialog(QWidget):

    accepted: PYQT_SIGNAL
    finished: PYQT_SIGNAL
    rejected: PYQT_SIGNAL

    class DialogCode(int):
        Rejected = ... # type: QDialog.DialogCode
        Accepted = ... # type: QDialog.DialogCode

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def contextMenuEvent(self, a0: QtGui.QContextMenuEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def showEvent(self, a0: QtGui.QShowEvent) -> None: ...
    def closeEvent(self, a0: QtGui.QCloseEvent) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    #def rejected(self) -> None: ...
    #def finished(self, result: int) -> None: ...
    #def accepted(self) -> None: ...
    def open(self) -> None: ...
    def reject(self) -> None: ...
    def accept(self) -> None: ...
    def done(self, a0: int) -> None: ...
    def exec(self) -> int: ...
    def exec_(self) -> int: ...
    def setResult(self, r: int) -> None: ...
    def setModal(self, modal: bool) -> None: ...
    def isSizeGripEnabled(self) -> bool: ...
    def setSizeGripEnabled(self, a0: bool) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setVisible(self, visible: bool) -> None: ...
    def result(self) -> int: ...


class QColorDialog(QDialog):

    colorSelected: PYQT_SIGNAL
    currentColorChanged: PYQT_SIGNAL

    ColorDialogOption: typing.Type[int]
    #class ColorDialogOption(int): ...
    ShowAlphaChannel = ... # type: int
    NoButtons = ... # type: int
    DontUseNativeDialog = ... # type: int

    ColorDialogOptions: typing.Type[int]
    #class ColorDialogOptions(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QColorDialog.ColorDialogOptions, QColorDialog.ColorDialogOption]) -> None: ...
        #@overload
        #def __init__(self, a0: QColorDialog.ColorDialogOptions) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QColorDialog.ColorDialogOptions: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, initial: typing.Union[QtGui.QColor, int, QtGui.QGradient], parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def setVisible(self, visible: bool) -> None: ...
    @overload
    def open(self) -> None: ...
    @overload
    def open(self, slot: PYQT_SLOT) -> None: ...
    def options(self) -> int: ...
    def setOptions(self, options: typing.Union[int, int]) -> None: ...
    def testOption(self, option: int) -> bool: ...
    def setOption(self, option: int, on: bool = ...) -> None: ...
    def selectedColor(self) -> QtGui.QColor: ...
    def currentColor(self) -> QtGui.QColor: ...
    def setCurrentColor(self, color: typing.Union[QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def done(self, result: int) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    #def currentColorChanged(self, color: typing.Union[QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    #def colorSelected(self, color: typing.Union[QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    @staticmethod
    def setStandardColor(index: int, color: typing.Union[QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    @staticmethod
    def standardColor(index: int) -> QtGui.QColor: ...
    @staticmethod
    def setCustomColor(index: int, color: typing.Union[QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    @staticmethod
    def customColor(index: int) -> QtGui.QColor: ...
    @staticmethod
    def customCount() -> int: ...
    @staticmethod
    def getColor(initial: typing.Union[QtGui.QColor, int, QtGui.QGradient] = ..., parent: typing.Optional[QWidget] = ..., title: str = ..., options: typing.Union[int, int] = ...) -> QtGui.QColor: ...


class QColumnView(QAbstractItemView):

    updatePreviewWidget: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def currentChanged(self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex) -> None: ...
    def rowsInserted(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def verticalOffset(self) -> int: ...
    def horizontalOffset(self) -> int: ...
    def visualRegionForSelection(self, selection: QtCore.QItemSelection) -> QtGui.QRegion: ...
    def setSelection(self, rect: QtCore.QRect, command: typing.Union[int, int]) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def moveCursor(self, cursorAction: int, modifiers: typing.Union[int, int]) -> QtCore.QModelIndex: ...
    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool: ...
    def initializeColumn(self, column: QAbstractItemView) -> None: ...
    def createColumn(self, rootIndex: QtCore.QModelIndex) -> QAbstractItemView: ...
    #def updatePreviewWidget(self, index: QtCore.QModelIndex) -> None: ...
    def selectAll(self) -> None: ...
    def setRootIndex(self, index: QtCore.QModelIndex) -> None: ...
    def setSelectionModel(self, selectionModel: QtCore.QItemSelectionModel) -> None: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...
    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def scrollTo(self, index: QtCore.QModelIndex, hint: int = ...) -> None: ...
    def indexAt(self, point: QtCore.QPoint) -> QtCore.QModelIndex: ...
    def setResizeGripsVisible(self, visible: bool) -> None: ...
    def setPreviewWidget(self, widget: QWidget) -> None: ...
    def setColumnWidths(self, list: typing.Iterable[int]) -> None: ...
    def resizeGripsVisible(self) -> bool: ...
    def previewWidget(self) -> QWidget: ...
    def columnWidths(self) -> typing.List[int]: ...


class QComboBox(QWidget):

    activated: PYQT_SIGNAL
    currentIndexChanged: PYQT_SIGNAL
    currentTextChanged: PYQT_SIGNAL
    editTextChanged: PYQT_SIGNAL
    highlighted: PYQT_SIGNAL

    class SizeAdjustPolicy(int):
        AdjustToContents = ... # type: QComboBox.SizeAdjustPolicy
        AdjustToContentsOnFirstShow = ... # type: QComboBox.SizeAdjustPolicy
        AdjustToMinimumContentsLength = ... # type: QComboBox.SizeAdjustPolicy
        AdjustToMinimumContentsLengthWithIcon = ... # type: QComboBox.SizeAdjustPolicy

    class InsertPolicy(int):
        NoInsert = ... # type: QComboBox.InsertPolicy
        InsertAtTop = ... # type: QComboBox.InsertPolicy
        InsertAtCurrent = ... # type: QComboBox.InsertPolicy
        InsertAtBottom = ... # type: QComboBox.InsertPolicy
        InsertAfterCurrent = ... # type: QComboBox.InsertPolicy
        InsertBeforeCurrent = ... # type: QComboBox.InsertPolicy
        InsertAlphabetically = ... # type: QComboBox.InsertPolicy

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def currentData(self, role: int = ...) -> typing.Any: ...
    @overload
    def inputMethodQuery(self, a0: int) -> typing.Any: ...
    @overload
    def inputMethodQuery(self, query: int, argument: typing.Any) -> typing.Any: ...
    def inputMethodEvent(self, a0: QtGui.QInputMethodEvent) -> None: ...
    def contextMenuEvent(self, e: QtGui.QContextMenuEvent) -> None: ...
    def wheelEvent(self, e: QtGui.QWheelEvent) -> None: ...
    def keyReleaseEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def hideEvent(self, e: QtGui.QHideEvent) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, e: QtGui.QResizeEvent) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def focusOutEvent(self, e: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, e: QtGui.QFocusEvent) -> None: ...
    def initStyleOption(self, option: QStyleOptionComboBox) -> None: ...
    #@overload
    #def highlighted(self, index: int) -> None: ...
    #@overload
    #def highlighted(self, a0: str) -> None: ...
    #def currentTextChanged(self, a0: str) -> None: ...
    #@overload
    #def currentIndexChanged(self, index: int) -> None: ...
    #@overload
    #def currentIndexChanged(self, a0: str) -> None: ...
    #@overload
    #def activated(self, index: int) -> None: ...
    #@overload
    #def activated(self, a0: str) -> None: ...
    #def editTextChanged(self, a0: str) -> None: ...
    def setCurrentText(self, text: str) -> None: ...
    def setEditText(self, text: str) -> None: ...
    def clearEditText(self) -> None: ...
    def clear(self) -> None: ...
    def insertSeparator(self, index: int) -> None: ...
    def completer(self) -> QCompleter: ...
    def setCompleter(self, c: QCompleter) -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def hidePopup(self) -> None: ...
    def showPopup(self) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setView(self, itemView: QAbstractItemView) -> None: ...
    def view(self) -> QAbstractItemView: ...
    def setItemData(self, index: int, value: typing.Any, role: int = ...) -> None: ...
    def setItemIcon(self, index: int, icon: QtGui.QIcon) -> None: ...
    def setItemText(self, index: int, text: str) -> None: ...
    def removeItem(self, index: int) -> None: ...
    def insertItems(self, index: int, texts: typing.Iterable[str]) -> None: ...
    @overload
    def insertItem(self, index: int, text: str, userData: typing.Any = ...) -> None: ...
    @overload
    def insertItem(self, index: int, icon: QtGui.QIcon, text: str, userData: typing.Any = ...) -> None: ...
    @overload
    def addItem(self, text: str, userData: typing.Any = ...) -> None: ...
    @overload
    def addItem(self, icon: QtGui.QIcon, text: str, userData: typing.Any = ...) -> None: ...
    def addItems(self, texts: typing.Iterable[str]) -> None: ...
    def itemData(self, index: int, role: int = ...) -> typing.Any: ...
    def itemIcon(self, index: int) -> QtGui.QIcon: ...
    def itemText(self, index: int) -> str: ...
    def currentText(self) -> str: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def currentIndex(self) -> int: ...
    def setModelColumn(self, visibleColumn: int) -> None: ...
    def modelColumn(self) -> int: ...
    def setRootModelIndex(self, index: QtCore.QModelIndex) -> None: ...
    def rootModelIndex(self) -> QtCore.QModelIndex: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel: ...
    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None: ...
    def itemDelegate(self) -> QAbstractItemDelegate: ...
    def validator(self) -> QtGui.QValidator: ...
    def setValidator(self, v: QtGui.QValidator) -> None: ...
    def lineEdit(self) -> QLineEdit: ...
    def setLineEdit(self, edit: QLineEdit) -> None: ...
    def setEditable(self, editable: bool) -> None: ...
    def isEditable(self) -> bool: ...
    def setIconSize(self, size: QtCore.QSize) -> None: ...
    def iconSize(self) -> QtCore.QSize: ...
    def setMinimumContentsLength(self, characters: int) -> None: ...
    def minimumContentsLength(self) -> int: ...
    def setSizeAdjustPolicy(self, policy: int) -> None: ...
    def sizeAdjustPolicy(self) -> int: ...
    def setInsertPolicy(self, policy: int) -> None: ...
    def insertPolicy(self) -> int: ...
    def findData(self, data: typing.Any, role: int = ..., flags: typing.Union[int, int] = ...) -> int: ...
    def findText(self, text: str, flags: typing.Union[int, int] = ...) -> int: ...
    def hasFrame(self) -> bool: ...
    def setFrame(self, a0: bool) -> None: ...
    def setDuplicatesEnabled(self, enable: bool) -> None: ...
    def duplicatesEnabled(self) -> bool: ...
    def maxCount(self) -> int: ...
    def setMaxCount(self, max: int) -> None: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def setMaxVisibleItems(self, maxItems: int) -> None: ...
    def maxVisibleItems(self) -> int: ...


class QPushButton(QAbstractButton):

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, icon: QtGui.QIcon, text: str, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def focusOutEvent(self, a0: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, a0: QtGui.QFocusEvent) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: QStyleOptionButton) -> None: ...
    def showMenu(self) -> None: ...
    def isFlat(self) -> bool: ...
    def setFlat(self, a0: bool) -> None: ...
    def menu(self) -> QMenu: ...
    def setMenu(self, menu: QMenu) -> None: ...
    def setDefault(self, a0: bool) -> None: ...
    def isDefault(self) -> bool: ...
    def setAutoDefault(self, a0: bool) -> None: ...
    def autoDefault(self) -> bool: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QCommandLinkButton(QPushButton):

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, text: str, description: str, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def heightForWidth(self, a0: int) -> int: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setDescription(self, description: str) -> None: ...
    def description(self) -> str: ...


class QStyle(QtCore.QObject):

    class RequestSoftwareInputPanel(int):
        RSIP_OnMouseClickAndAlreadyFocused = ... # type: QStyle.RequestSoftwareInputPanel
        RSIP_OnMouseClick = ... # type: QStyle.RequestSoftwareInputPanel

    class StandardPixmap(int):
        SP_TitleBarMenuButton = ... # type: QStyle.StandardPixmap
        SP_TitleBarMinButton = ... # type: QStyle.StandardPixmap
        SP_TitleBarMaxButton = ... # type: QStyle.StandardPixmap
        SP_TitleBarCloseButton = ... # type: QStyle.StandardPixmap
        SP_TitleBarNormalButton = ... # type: QStyle.StandardPixmap
        SP_TitleBarShadeButton = ... # type: QStyle.StandardPixmap
        SP_TitleBarUnshadeButton = ... # type: QStyle.StandardPixmap
        SP_TitleBarContextHelpButton = ... # type: QStyle.StandardPixmap
        SP_DockWidgetCloseButton = ... # type: QStyle.StandardPixmap
        SP_MessageBoxInformation = ... # type: QStyle.StandardPixmap
        SP_MessageBoxWarning = ... # type: QStyle.StandardPixmap
        SP_MessageBoxCritical = ... # type: QStyle.StandardPixmap
        SP_MessageBoxQuestion = ... # type: QStyle.StandardPixmap
        SP_DesktopIcon = ... # type: QStyle.StandardPixmap
        SP_TrashIcon = ... # type: QStyle.StandardPixmap
        SP_ComputerIcon = ... # type: QStyle.StandardPixmap
        SP_DriveFDIcon = ... # type: QStyle.StandardPixmap
        SP_DriveHDIcon = ... # type: QStyle.StandardPixmap
        SP_DriveCDIcon = ... # type: QStyle.StandardPixmap
        SP_DriveDVDIcon = ... # type: QStyle.StandardPixmap
        SP_DriveNetIcon = ... # type: QStyle.StandardPixmap
        SP_DirOpenIcon = ... # type: QStyle.StandardPixmap
        SP_DirClosedIcon = ... # type: QStyle.StandardPixmap
        SP_DirLinkIcon = ... # type: QStyle.StandardPixmap
        SP_FileIcon = ... # type: QStyle.StandardPixmap
        SP_FileLinkIcon = ... # type: QStyle.StandardPixmap
        SP_ToolBarHorizontalExtensionButton = ... # type: QStyle.StandardPixmap
        SP_ToolBarVerticalExtensionButton = ... # type: QStyle.StandardPixmap
        SP_FileDialogStart = ... # type: QStyle.StandardPixmap
        SP_FileDialogEnd = ... # type: QStyle.StandardPixmap
        SP_FileDialogToParent = ... # type: QStyle.StandardPixmap
        SP_FileDialogNewFolder = ... # type: QStyle.StandardPixmap
        SP_FileDialogDetailedView = ... # type: QStyle.StandardPixmap
        SP_FileDialogInfoView = ... # type: QStyle.StandardPixmap
        SP_FileDialogContentsView = ... # type: QStyle.StandardPixmap
        SP_FileDialogListView = ... # type: QStyle.StandardPixmap
        SP_FileDialogBack = ... # type: QStyle.StandardPixmap
        SP_DirIcon = ... # type: QStyle.StandardPixmap
        SP_DialogOkButton = ... # type: QStyle.StandardPixmap
        SP_DialogCancelButton = ... # type: QStyle.StandardPixmap
        SP_DialogHelpButton = ... # type: QStyle.StandardPixmap
        SP_DialogOpenButton = ... # type: QStyle.StandardPixmap
        SP_DialogSaveButton = ... # type: QStyle.StandardPixmap
        SP_DialogCloseButton = ... # type: QStyle.StandardPixmap
        SP_DialogApplyButton = ... # type: QStyle.StandardPixmap
        SP_DialogResetButton = ... # type: QStyle.StandardPixmap
        SP_DialogDiscardButton = ... # type: QStyle.StandardPixmap
        SP_DialogYesButton = ... # type: QStyle.StandardPixmap
        SP_DialogNoButton = ... # type: QStyle.StandardPixmap
        SP_ArrowUp = ... # type: QStyle.StandardPixmap
        SP_ArrowDown = ... # type: QStyle.StandardPixmap
        SP_ArrowLeft = ... # type: QStyle.StandardPixmap
        SP_ArrowRight = ... # type: QStyle.StandardPixmap
        SP_ArrowBack = ... # type: QStyle.StandardPixmap
        SP_ArrowForward = ... # type: QStyle.StandardPixmap
        SP_DirHomeIcon = ... # type: QStyle.StandardPixmap
        SP_CommandLink = ... # type: QStyle.StandardPixmap
        SP_VistaShield = ... # type: QStyle.StandardPixmap
        SP_BrowserReload = ... # type: QStyle.StandardPixmap
        SP_BrowserStop = ... # type: QStyle.StandardPixmap
        SP_MediaPlay = ... # type: QStyle.StandardPixmap
        SP_MediaStop = ... # type: QStyle.StandardPixmap
        SP_MediaPause = ... # type: QStyle.StandardPixmap
        SP_MediaSkipForward = ... # type: QStyle.StandardPixmap
        SP_MediaSkipBackward = ... # type: QStyle.StandardPixmap
        SP_MediaSeekForward = ... # type: QStyle.StandardPixmap
        SP_MediaSeekBackward = ... # type: QStyle.StandardPixmap
        SP_MediaVolume = ... # type: QStyle.StandardPixmap
        SP_MediaVolumeMuted = ... # type: QStyle.StandardPixmap
        SP_DirLinkOpenIcon = ... # type: QStyle.StandardPixmap
        SP_LineEditClearButton = ... # type: QStyle.StandardPixmap
        SP_DialogYesToAllButton = ... # type: QStyle.StandardPixmap
        SP_DialogNoToAllButton = ... # type: QStyle.StandardPixmap
        SP_DialogSaveAllButton = ... # type: QStyle.StandardPixmap
        SP_DialogAbortButton = ... # type: QStyle.StandardPixmap
        SP_DialogRetryButton = ... # type: QStyle.StandardPixmap
        SP_DialogIgnoreButton = ... # type: QStyle.StandardPixmap
        SP_RestoreDefaultsButton = ... # type: QStyle.StandardPixmap
        SP_CustomBase = ... # type: QStyle.StandardPixmap

    class StyleHint(int):
        SH_EtchDisabledText = ... # type: QStyle.StyleHint
        SH_DitherDisabledText = ... # type: QStyle.StyleHint
        SH_ScrollBar_MiddleClickAbsolutePosition = ... # type: QStyle.StyleHint
        SH_ScrollBar_ScrollWhenPointerLeavesControl = ... # type: QStyle.StyleHint
        SH_TabBar_SelectMouseType = ... # type: QStyle.StyleHint
        SH_TabBar_Alignment = ... # type: QStyle.StyleHint
        SH_Header_ArrowAlignment = ... # type: QStyle.StyleHint
        SH_Slider_SnapToValue = ... # type: QStyle.StyleHint
        SH_Slider_SloppyKeyEvents = ... # type: QStyle.StyleHint
        SH_ProgressDialog_CenterCancelButton = ... # type: QStyle.StyleHint
        SH_ProgressDialog_TextLabelAlignment = ... # type: QStyle.StyleHint
        SH_PrintDialog_RightAlignButtons = ... # type: QStyle.StyleHint
        SH_MainWindow_SpaceBelowMenuBar = ... # type: QStyle.StyleHint
        SH_FontDialog_SelectAssociatedText = ... # type: QStyle.StyleHint
        SH_Menu_AllowActiveAndDisabled = ... # type: QStyle.StyleHint
        SH_Menu_SpaceActivatesItem = ... # type: QStyle.StyleHint
        SH_Menu_SubMenuPopupDelay = ... # type: QStyle.StyleHint
        SH_ScrollView_FrameOnlyAroundContents = ... # type: QStyle.StyleHint
        SH_MenuBar_AltKeyNavigation = ... # type: QStyle.StyleHint
        SH_ComboBox_ListMouseTracking = ... # type: QStyle.StyleHint
        SH_Menu_MouseTracking = ... # type: QStyle.StyleHint
        SH_MenuBar_MouseTracking = ... # type: QStyle.StyleHint
        SH_ItemView_ChangeHighlightOnFocus = ... # type: QStyle.StyleHint
        SH_Widget_ShareActivation = ... # type: QStyle.StyleHint
        SH_Workspace_FillSpaceOnMaximize = ... # type: QStyle.StyleHint
        SH_ComboBox_Popup = ... # type: QStyle.StyleHint
        SH_TitleBar_NoBorder = ... # type: QStyle.StyleHint
        SH_ScrollBar_StopMouseOverSlider = ... # type: QStyle.StyleHint
        SH_BlinkCursorWhenTextSelected = ... # type: QStyle.StyleHint
        SH_RichText_FullWidthSelection = ... # type: QStyle.StyleHint
        SH_Menu_Scrollable = ... # type: QStyle.StyleHint
        SH_GroupBox_TextLabelVerticalAlignment = ... # type: QStyle.StyleHint
        SH_GroupBox_TextLabelColor = ... # type: QStyle.StyleHint
        SH_Menu_SloppySubMenus = ... # type: QStyle.StyleHint
        SH_Table_GridLineColor = ... # type: QStyle.StyleHint
        SH_LineEdit_PasswordCharacter = ... # type: QStyle.StyleHint
        SH_DialogButtons_DefaultButton = ... # type: QStyle.StyleHint
        SH_ToolBox_SelectedPageTitleBold = ... # type: QStyle.StyleHint
        SH_TabBar_PreferNoArrows = ... # type: QStyle.StyleHint
        SH_ScrollBar_LeftClickAbsolutePosition = ... # type: QStyle.StyleHint
        SH_UnderlineShortcut = ... # type: QStyle.StyleHint
        SH_SpinBox_AnimateButton = ... # type: QStyle.StyleHint
        SH_SpinBox_KeyPressAutoRepeatRate = ... # type: QStyle.StyleHint
        SH_SpinBox_ClickAutoRepeatRate = ... # type: QStyle.StyleHint
        SH_Menu_FillScreenWithScroll = ... # type: QStyle.StyleHint
        SH_ToolTipLabel_Opacity = ... # type: QStyle.StyleHint
        SH_DrawMenuBarSeparator = ... # type: QStyle.StyleHint
        SH_TitleBar_ModifyNotification = ... # type: QStyle.StyleHint
        SH_Button_FocusPolicy = ... # type: QStyle.StyleHint
        SH_MessageBox_UseBorderForButtonSpacing = ... # type: QStyle.StyleHint
        SH_TitleBar_AutoRaise = ... # type: QStyle.StyleHint
        SH_ToolButton_PopupDelay = ... # type: QStyle.StyleHint
        SH_FocusFrame_Mask = ... # type: QStyle.StyleHint
        SH_RubberBand_Mask = ... # type: QStyle.StyleHint
        SH_WindowFrame_Mask = ... # type: QStyle.StyleHint
        SH_SpinControls_DisableOnBounds = ... # type: QStyle.StyleHint
        SH_Dial_BackgroundRole = ... # type: QStyle.StyleHint
        SH_ComboBox_LayoutDirection = ... # type: QStyle.StyleHint
        SH_ItemView_EllipsisLocation = ... # type: QStyle.StyleHint
        SH_ItemView_ShowDecorationSelected = ... # type: QStyle.StyleHint
        SH_ItemView_ActivateItemOnSingleClick = ... # type: QStyle.StyleHint
        SH_ScrollBar_ContextMenu = ... # type: QStyle.StyleHint
        SH_ScrollBar_RollBetweenButtons = ... # type: QStyle.StyleHint
        SH_Slider_StopMouseOverSlider = ... # type: QStyle.StyleHint
        SH_Slider_AbsoluteSetButtons = ... # type: QStyle.StyleHint
        SH_Slider_PageSetButtons = ... # type: QStyle.StyleHint
        SH_Menu_KeyboardSearch = ... # type: QStyle.StyleHint
        SH_TabBar_ElideMode = ... # type: QStyle.StyleHint
        SH_DialogButtonLayout = ... # type: QStyle.StyleHint
        SH_ComboBox_PopupFrameStyle = ... # type: QStyle.StyleHint
        SH_MessageBox_TextInteractionFlags = ... # type: QStyle.StyleHint
        SH_DialogButtonBox_ButtonsHaveIcons = ... # type: QStyle.StyleHint
        SH_SpellCheckUnderlineStyle = ... # type: QStyle.StyleHint
        SH_MessageBox_CenterButtons = ... # type: QStyle.StyleHint
        SH_Menu_SelectionWrap = ... # type: QStyle.StyleHint
        SH_ItemView_MovementWithoutUpdatingSelection = ... # type: QStyle.StyleHint
        SH_ToolTip_Mask = ... # type: QStyle.StyleHint
        SH_FocusFrame_AboveWidget = ... # type: QStyle.StyleHint
        SH_TextControl_FocusIndicatorTextCharFormat = ... # type: QStyle.StyleHint
        SH_WizardStyle = ... # type: QStyle.StyleHint
        SH_ItemView_ArrowKeysNavigateIntoChildren = ... # type: QStyle.StyleHint
        SH_Menu_Mask = ... # type: QStyle.StyleHint
        SH_Menu_FlashTriggeredItem = ... # type: QStyle.StyleHint
        SH_Menu_FadeOutOnHide = ... # type: QStyle.StyleHint
        SH_SpinBox_ClickAutoRepeatThreshold = ... # type: QStyle.StyleHint
        SH_ItemView_PaintAlternatingRowColorsForEmptyArea = ... # type: QStyle.StyleHint
        SH_FormLayoutWrapPolicy = ... # type: QStyle.StyleHint
        SH_TabWidget_DefaultTabPosition = ... # type: QStyle.StyleHint
        SH_ToolBar_Movable = ... # type: QStyle.StyleHint
        SH_FormLayoutFieldGrowthPolicy = ... # type: QStyle.StyleHint
        SH_FormLayoutFormAlignment = ... # type: QStyle.StyleHint
        SH_FormLayoutLabelAlignment = ... # type: QStyle.StyleHint
        SH_ItemView_DrawDelegateFrame = ... # type: QStyle.StyleHint
        SH_TabBar_CloseButtonPosition = ... # type: QStyle.StyleHint
        SH_DockWidget_ButtonsHaveFrame = ... # type: QStyle.StyleHint
        SH_ToolButtonStyle = ... # type: QStyle.StyleHint
        SH_RequestSoftwareInputPanel = ... # type: QStyle.StyleHint
        SH_ListViewExpand_SelectMouseType = ... # type: QStyle.StyleHint
        SH_ScrollBar_Transient = ... # type: QStyle.StyleHint
        SH_Menu_SupportsSections = ... # type: QStyle.StyleHint
        SH_ToolTip_WakeUpDelay = ... # type: QStyle.StyleHint
        SH_ToolTip_FallAsleepDelay = ... # type: QStyle.StyleHint
        SH_Widget_Animate = ... # type: QStyle.StyleHint
        SH_Splitter_OpaqueResize = ... # type: QStyle.StyleHint
        SH_LineEdit_PasswordMaskDelay = ... # type: QStyle.StyleHint
        SH_TabBar_ChangeCurrentDelay = ... # type: QStyle.StyleHint
        SH_Menu_SubMenuUniDirection = ... # type: QStyle.StyleHint
        SH_Menu_SubMenuUniDirectionFailCount = ... # type: QStyle.StyleHint
        SH_Menu_SubMenuSloppySelectOtherActions = ... # type: QStyle.StyleHint
        SH_Menu_SubMenuSloppyCloseTimeout = ... # type: QStyle.StyleHint
        SH_Menu_SubMenuResetWhenReenteringParent = ... # type: QStyle.StyleHint
        SH_Menu_SubMenuDontStartSloppyOnLeave = ... # type: QStyle.StyleHint
        SH_ItemView_ScrollMode = ... # type: QStyle.StyleHint
        SH_TitleBar_ShowToolTipsOnButtons = ... # type: QStyle.StyleHint
        SH_Widget_Animation_Duration = ... # type: QStyle.StyleHint
        SH_ComboBox_AllowWheelScrolling = ... # type: QStyle.StyleHint
        SH_SpinBox_ButtonsInsideFrame = ... # type: QStyle.StyleHint
        SH_SpinBox_StepModifier = ... # type: QStyle.StyleHint
        SH_CustomBase = ... # type: QStyle.StyleHint

    class ContentsType(int):
        CT_PushButton = ... # type: QStyle.ContentsType
        CT_CheckBox = ... # type: QStyle.ContentsType
        CT_RadioButton = ... # type: QStyle.ContentsType
        CT_ToolButton = ... # type: QStyle.ContentsType
        CT_ComboBox = ... # type: QStyle.ContentsType
        CT_Splitter = ... # type: QStyle.ContentsType
        CT_ProgressBar = ... # type: QStyle.ContentsType
        CT_MenuItem = ... # type: QStyle.ContentsType
        CT_MenuBarItem = ... # type: QStyle.ContentsType
        CT_MenuBar = ... # type: QStyle.ContentsType
        CT_Menu = ... # type: QStyle.ContentsType
        CT_TabBarTab = ... # type: QStyle.ContentsType
        CT_Slider = ... # type: QStyle.ContentsType
        CT_ScrollBar = ... # type: QStyle.ContentsType
        CT_LineEdit = ... # type: QStyle.ContentsType
        CT_SpinBox = ... # type: QStyle.ContentsType
        CT_SizeGrip = ... # type: QStyle.ContentsType
        CT_TabWidget = ... # type: QStyle.ContentsType
        CT_DialogButtons = ... # type: QStyle.ContentsType
        CT_HeaderSection = ... # type: QStyle.ContentsType
        CT_GroupBox = ... # type: QStyle.ContentsType
        CT_MdiControls = ... # type: QStyle.ContentsType
        CT_ItemViewItem = ... # type: QStyle.ContentsType
        CT_CustomBase = ... # type: QStyle.ContentsType

    class PixelMetric(int):
        PM_ButtonMargin = ... # type: QStyle.PixelMetric
        PM_ButtonDefaultIndicator = ... # type: QStyle.PixelMetric
        PM_MenuButtonIndicator = ... # type: QStyle.PixelMetric
        PM_ButtonShiftHorizontal = ... # type: QStyle.PixelMetric
        PM_ButtonShiftVertical = ... # type: QStyle.PixelMetric
        PM_DefaultFrameWidth = ... # type: QStyle.PixelMetric
        PM_SpinBoxFrameWidth = ... # type: QStyle.PixelMetric
        PM_ComboBoxFrameWidth = ... # type: QStyle.PixelMetric
        PM_MaximumDragDistance = ... # type: QStyle.PixelMetric
        PM_ScrollBarExtent = ... # type: QStyle.PixelMetric
        PM_ScrollBarSliderMin = ... # type: QStyle.PixelMetric
        PM_SliderThickness = ... # type: QStyle.PixelMetric
        PM_SliderControlThickness = ... # type: QStyle.PixelMetric
        PM_SliderLength = ... # type: QStyle.PixelMetric
        PM_SliderTickmarkOffset = ... # type: QStyle.PixelMetric
        PM_SliderSpaceAvailable = ... # type: QStyle.PixelMetric
        PM_DockWidgetSeparatorExtent = ... # type: QStyle.PixelMetric
        PM_DockWidgetHandleExtent = ... # type: QStyle.PixelMetric
        PM_DockWidgetFrameWidth = ... # type: QStyle.PixelMetric
        PM_TabBarTabOverlap = ... # type: QStyle.PixelMetric
        PM_TabBarTabHSpace = ... # type: QStyle.PixelMetric
        PM_TabBarTabVSpace = ... # type: QStyle.PixelMetric
        PM_TabBarBaseHeight = ... # type: QStyle.PixelMetric
        PM_TabBarBaseOverlap = ... # type: QStyle.PixelMetric
        PM_ProgressBarChunkWidth = ... # type: QStyle.PixelMetric
        PM_SplitterWidth = ... # type: QStyle.PixelMetric
        PM_TitleBarHeight = ... # type: QStyle.PixelMetric
        PM_MenuScrollerHeight = ... # type: QStyle.PixelMetric
        PM_MenuHMargin = ... # type: QStyle.PixelMetric
        PM_MenuVMargin = ... # type: QStyle.PixelMetric
        PM_MenuPanelWidth = ... # type: QStyle.PixelMetric
        PM_MenuTearoffHeight = ... # type: QStyle.PixelMetric
        PM_MenuDesktopFrameWidth = ... # type: QStyle.PixelMetric
        PM_MenuBarPanelWidth = ... # type: QStyle.PixelMetric
        PM_MenuBarItemSpacing = ... # type: QStyle.PixelMetric
        PM_MenuBarVMargin = ... # type: QStyle.PixelMetric
        PM_MenuBarHMargin = ... # type: QStyle.PixelMetric
        PM_IndicatorWidth = ... # type: QStyle.PixelMetric
        PM_IndicatorHeight = ... # type: QStyle.PixelMetric
        PM_ExclusiveIndicatorWidth = ... # type: QStyle.PixelMetric
        PM_ExclusiveIndicatorHeight = ... # type: QStyle.PixelMetric
        PM_DialogButtonsSeparator = ... # type: QStyle.PixelMetric
        PM_DialogButtonsButtonWidth = ... # type: QStyle.PixelMetric
        PM_DialogButtonsButtonHeight = ... # type: QStyle.PixelMetric
        PM_MdiSubWindowFrameWidth = ... # type: QStyle.PixelMetric
        PM_MDIFrameWidth = ... # type: QStyle.PixelMetric
        PM_MdiSubWindowMinimizedWidth = ... # type: QStyle.PixelMetric
        PM_MDIMinimizedWidth = ... # type: QStyle.PixelMetric
        PM_HeaderMargin = ... # type: QStyle.PixelMetric
        PM_HeaderMarkSize = ... # type: QStyle.PixelMetric
        PM_HeaderGripMargin = ... # type: QStyle.PixelMetric
        PM_TabBarTabShiftHorizontal = ... # type: QStyle.PixelMetric
        PM_TabBarTabShiftVertical = ... # type: QStyle.PixelMetric
        PM_TabBarScrollButtonWidth = ... # type: QStyle.PixelMetric
        PM_ToolBarFrameWidth = ... # type: QStyle.PixelMetric
        PM_ToolBarHandleExtent = ... # type: QStyle.PixelMetric
        PM_ToolBarItemSpacing = ... # type: QStyle.PixelMetric
        PM_ToolBarItemMargin = ... # type: QStyle.PixelMetric
        PM_ToolBarSeparatorExtent = ... # type: QStyle.PixelMetric
        PM_ToolBarExtensionExtent = ... # type: QStyle.PixelMetric
        PM_SpinBoxSliderHeight = ... # type: QStyle.PixelMetric
        PM_DefaultTopLevelMargin = ... # type: QStyle.PixelMetric
        PM_DefaultChildMargin = ... # type: QStyle.PixelMetric
        PM_DefaultLayoutSpacing = ... # type: QStyle.PixelMetric
        PM_ToolBarIconSize = ... # type: QStyle.PixelMetric
        PM_ListViewIconSize = ... # type: QStyle.PixelMetric
        PM_IconViewIconSize = ... # type: QStyle.PixelMetric
        PM_SmallIconSize = ... # type: QStyle.PixelMetric
        PM_LargeIconSize = ... # type: QStyle.PixelMetric
        PM_FocusFrameVMargin = ... # type: QStyle.PixelMetric
        PM_FocusFrameHMargin = ... # type: QStyle.PixelMetric
        PM_ToolTipLabelFrameWidth = ... # type: QStyle.PixelMetric
        PM_CheckBoxLabelSpacing = ... # type: QStyle.PixelMetric
        PM_TabBarIconSize = ... # type: QStyle.PixelMetric
        PM_SizeGripSize = ... # type: QStyle.PixelMetric
        PM_DockWidgetTitleMargin = ... # type: QStyle.PixelMetric
        PM_MessageBoxIconSize = ... # type: QStyle.PixelMetric
        PM_ButtonIconSize = ... # type: QStyle.PixelMetric
        PM_DockWidgetTitleBarButtonMargin = ... # type: QStyle.PixelMetric
        PM_RadioButtonLabelSpacing = ... # type: QStyle.PixelMetric
        PM_LayoutLeftMargin = ... # type: QStyle.PixelMetric
        PM_LayoutTopMargin = ... # type: QStyle.PixelMetric
        PM_LayoutRightMargin = ... # type: QStyle.PixelMetric
        PM_LayoutBottomMargin = ... # type: QStyle.PixelMetric
        PM_LayoutHorizontalSpacing = ... # type: QStyle.PixelMetric
        PM_LayoutVerticalSpacing = ... # type: QStyle.PixelMetric
        PM_TabBar_ScrollButtonOverlap = ... # type: QStyle.PixelMetric
        PM_TextCursorWidth = ... # type: QStyle.PixelMetric
        PM_TabCloseIndicatorWidth = ... # type: QStyle.PixelMetric
        PM_TabCloseIndicatorHeight = ... # type: QStyle.PixelMetric
        PM_ScrollView_ScrollBarSpacing = ... # type: QStyle.PixelMetric
        PM_SubMenuOverlap = ... # type: QStyle.PixelMetric
        PM_ScrollView_ScrollBarOverlap = ... # type: QStyle.PixelMetric
        PM_TreeViewIndentation = ... # type: QStyle.PixelMetric
        PM_HeaderDefaultSectionSizeHorizontal = ... # type: QStyle.PixelMetric
        PM_HeaderDefaultSectionSizeVertical = ... # type: QStyle.PixelMetric
        PM_TitleBarButtonIconSize = ... # type: QStyle.PixelMetric
        PM_TitleBarButtonSize = ... # type: QStyle.PixelMetric
        PM_CustomBase = ... # type: QStyle.PixelMetric

    class SubControl(int):
        SC_None = ... # type: QStyle.SubControl
        SC_ScrollBarAddLine = ... # type: QStyle.SubControl
        SC_ScrollBarSubLine = ... # type: QStyle.SubControl
        SC_ScrollBarAddPage = ... # type: QStyle.SubControl
        SC_ScrollBarSubPage = ... # type: QStyle.SubControl
        SC_ScrollBarFirst = ... # type: QStyle.SubControl
        SC_ScrollBarLast = ... # type: QStyle.SubControl
        SC_ScrollBarSlider = ... # type: QStyle.SubControl
        SC_ScrollBarGroove = ... # type: QStyle.SubControl
        SC_SpinBoxUp = ... # type: QStyle.SubControl
        SC_SpinBoxDown = ... # type: QStyle.SubControl
        SC_SpinBoxFrame = ... # type: QStyle.SubControl
        SC_SpinBoxEditField = ... # type: QStyle.SubControl
        SC_ComboBoxFrame = ... # type: QStyle.SubControl
        SC_ComboBoxEditField = ... # type: QStyle.SubControl
        SC_ComboBoxArrow = ... # type: QStyle.SubControl
        SC_ComboBoxListBoxPopup = ... # type: QStyle.SubControl
        SC_SliderGroove = ... # type: QStyle.SubControl
        SC_SliderHandle = ... # type: QStyle.SubControl
        SC_SliderTickmarks = ... # type: QStyle.SubControl
        SC_ToolButton = ... # type: QStyle.SubControl
        SC_ToolButtonMenu = ... # type: QStyle.SubControl
        SC_TitleBarSysMenu = ... # type: QStyle.SubControl
        SC_TitleBarMinButton = ... # type: QStyle.SubControl
        SC_TitleBarMaxButton = ... # type: QStyle.SubControl
        SC_TitleBarCloseButton = ... # type: QStyle.SubControl
        SC_TitleBarNormalButton = ... # type: QStyle.SubControl
        SC_TitleBarShadeButton = ... # type: QStyle.SubControl
        SC_TitleBarUnshadeButton = ... # type: QStyle.SubControl
        SC_TitleBarContextHelpButton = ... # type: QStyle.SubControl
        SC_TitleBarLabel = ... # type: QStyle.SubControl
        SC_DialGroove = ... # type: QStyle.SubControl
        SC_DialHandle = ... # type: QStyle.SubControl
        SC_DialTickmarks = ... # type: QStyle.SubControl
        SC_GroupBoxCheckBox = ... # type: QStyle.SubControl
        SC_GroupBoxLabel = ... # type: QStyle.SubControl
        SC_GroupBoxContents = ... # type: QStyle.SubControl
        SC_GroupBoxFrame = ... # type: QStyle.SubControl
        SC_MdiMinButton = ... # type: QStyle.SubControl
        SC_MdiNormalButton = ... # type: QStyle.SubControl
        SC_MdiCloseButton = ... # type: QStyle.SubControl
        SC_CustomBase = ... # type: QStyle.SubControl
        SC_All = ... # type: QStyle.SubControl

    class ComplexControl(int):
        CC_SpinBox = ... # type: QStyle.ComplexControl
        CC_ComboBox = ... # type: QStyle.ComplexControl
        CC_ScrollBar = ... # type: QStyle.ComplexControl
        CC_Slider = ... # type: QStyle.ComplexControl
        CC_ToolButton = ... # type: QStyle.ComplexControl
        CC_TitleBar = ... # type: QStyle.ComplexControl
        CC_Dial = ... # type: QStyle.ComplexControl
        CC_GroupBox = ... # type: QStyle.ComplexControl
        CC_MdiControls = ... # type: QStyle.ComplexControl
        CC_CustomBase = ... # type: QStyle.ComplexControl

    class SubElement(int):
        SE_PushButtonContents = ... # type: QStyle.SubElement
        SE_PushButtonFocusRect = ... # type: QStyle.SubElement
        SE_CheckBoxIndicator = ... # type: QStyle.SubElement
        SE_CheckBoxContents = ... # type: QStyle.SubElement
        SE_CheckBoxFocusRect = ... # type: QStyle.SubElement
        SE_CheckBoxClickRect = ... # type: QStyle.SubElement
        SE_RadioButtonIndicator = ... # type: QStyle.SubElement
        SE_RadioButtonContents = ... # type: QStyle.SubElement
        SE_RadioButtonFocusRect = ... # type: QStyle.SubElement
        SE_RadioButtonClickRect = ... # type: QStyle.SubElement
        SE_ComboBoxFocusRect = ... # type: QStyle.SubElement
        SE_SliderFocusRect = ... # type: QStyle.SubElement
        SE_ProgressBarGroove = ... # type: QStyle.SubElement
        SE_ProgressBarContents = ... # type: QStyle.SubElement
        SE_ProgressBarLabel = ... # type: QStyle.SubElement
        SE_ToolBoxTabContents = ... # type: QStyle.SubElement
        SE_HeaderLabel = ... # type: QStyle.SubElement
        SE_HeaderArrow = ... # type: QStyle.SubElement
        SE_TabWidgetTabBar = ... # type: QStyle.SubElement
        SE_TabWidgetTabPane = ... # type: QStyle.SubElement
        SE_TabWidgetTabContents = ... # type: QStyle.SubElement
        SE_TabWidgetLeftCorner = ... # type: QStyle.SubElement
        SE_TabWidgetRightCorner = ... # type: QStyle.SubElement
        SE_ViewItemCheckIndicator = ... # type: QStyle.SubElement
        SE_TabBarTearIndicator = ... # type: QStyle.SubElement
        SE_TreeViewDisclosureItem = ... # type: QStyle.SubElement
        SE_LineEditContents = ... # type: QStyle.SubElement
        SE_FrameContents = ... # type: QStyle.SubElement
        SE_DockWidgetCloseButton = ... # type: QStyle.SubElement
        SE_DockWidgetFloatButton = ... # type: QStyle.SubElement
        SE_DockWidgetTitleBarText = ... # type: QStyle.SubElement
        SE_DockWidgetIcon = ... # type: QStyle.SubElement
        SE_CheckBoxLayoutItem = ... # type: QStyle.SubElement
        SE_ComboBoxLayoutItem = ... # type: QStyle.SubElement
        SE_DateTimeEditLayoutItem = ... # type: QStyle.SubElement
        SE_DialogButtonBoxLayoutItem = ... # type: QStyle.SubElement
        SE_LabelLayoutItem = ... # type: QStyle.SubElement
        SE_ProgressBarLayoutItem = ... # type: QStyle.SubElement
        SE_PushButtonLayoutItem = ... # type: QStyle.SubElement
        SE_RadioButtonLayoutItem = ... # type: QStyle.SubElement
        SE_SliderLayoutItem = ... # type: QStyle.SubElement
        SE_SpinBoxLayoutItem = ... # type: QStyle.SubElement
        SE_ToolButtonLayoutItem = ... # type: QStyle.SubElement
        SE_FrameLayoutItem = ... # type: QStyle.SubElement
        SE_GroupBoxLayoutItem = ... # type: QStyle.SubElement
        SE_TabWidgetLayoutItem = ... # type: QStyle.SubElement
        SE_ItemViewItemCheckIndicator = ... # type: QStyle.SubElement
        SE_ItemViewItemDecoration = ... # type: QStyle.SubElement
        SE_ItemViewItemText = ... # type: QStyle.SubElement
        SE_ItemViewItemFocusRect = ... # type: QStyle.SubElement
        SE_TabBarTabLeftButton = ... # type: QStyle.SubElement
        SE_TabBarTabRightButton = ... # type: QStyle.SubElement
        SE_TabBarTabText = ... # type: QStyle.SubElement
        SE_ShapedFrameContents = ... # type: QStyle.SubElement
        SE_ToolBarHandle = ... # type: QStyle.SubElement
        SE_TabBarTearIndicatorLeft = ... # type: QStyle.SubElement
        SE_TabBarScrollLeftButton = ... # type: QStyle.SubElement
        SE_TabBarScrollRightButton = ... # type: QStyle.SubElement
        SE_TabBarTearIndicatorRight = ... # type: QStyle.SubElement
        SE_PushButtonBevel = ... # type: QStyle.SubElement
        SE_CustomBase = ... # type: QStyle.SubElement

    class ControlElement(int):
        CE_PushButton = ... # type: QStyle.ControlElement
        CE_PushButtonBevel = ... # type: QStyle.ControlElement
        CE_PushButtonLabel = ... # type: QStyle.ControlElement
        CE_CheckBox = ... # type: QStyle.ControlElement
        CE_CheckBoxLabel = ... # type: QStyle.ControlElement
        CE_RadioButton = ... # type: QStyle.ControlElement
        CE_RadioButtonLabel = ... # type: QStyle.ControlElement
        CE_TabBarTab = ... # type: QStyle.ControlElement
        CE_TabBarTabShape = ... # type: QStyle.ControlElement
        CE_TabBarTabLabel = ... # type: QStyle.ControlElement
        CE_ProgressBar = ... # type: QStyle.ControlElement
        CE_ProgressBarGroove = ... # type: QStyle.ControlElement
        CE_ProgressBarContents = ... # type: QStyle.ControlElement
        CE_ProgressBarLabel = ... # type: QStyle.ControlElement
        CE_MenuItem = ... # type: QStyle.ControlElement
        CE_MenuScroller = ... # type: QStyle.ControlElement
        CE_MenuVMargin = ... # type: QStyle.ControlElement
        CE_MenuHMargin = ... # type: QStyle.ControlElement
        CE_MenuTearoff = ... # type: QStyle.ControlElement
        CE_MenuEmptyArea = ... # type: QStyle.ControlElement
        CE_MenuBarItem = ... # type: QStyle.ControlElement
        CE_MenuBarEmptyArea = ... # type: QStyle.ControlElement
        CE_ToolButtonLabel = ... # type: QStyle.ControlElement
        CE_Header = ... # type: QStyle.ControlElement
        CE_HeaderSection = ... # type: QStyle.ControlElement
        CE_HeaderLabel = ... # type: QStyle.ControlElement
        CE_ToolBoxTab = ... # type: QStyle.ControlElement
        CE_SizeGrip = ... # type: QStyle.ControlElement
        CE_Splitter = ... # type: QStyle.ControlElement
        CE_RubberBand = ... # type: QStyle.ControlElement
        CE_DockWidgetTitle = ... # type: QStyle.ControlElement
        CE_ScrollBarAddLine = ... # type: QStyle.ControlElement
        CE_ScrollBarSubLine = ... # type: QStyle.ControlElement
        CE_ScrollBarAddPage = ... # type: QStyle.ControlElement
        CE_ScrollBarSubPage = ... # type: QStyle.ControlElement
        CE_ScrollBarSlider = ... # type: QStyle.ControlElement
        CE_ScrollBarFirst = ... # type: QStyle.ControlElement
        CE_ScrollBarLast = ... # type: QStyle.ControlElement
        CE_FocusFrame = ... # type: QStyle.ControlElement
        CE_ComboBoxLabel = ... # type: QStyle.ControlElement
        CE_ToolBar = ... # type: QStyle.ControlElement
        CE_ToolBoxTabShape = ... # type: QStyle.ControlElement
        CE_ToolBoxTabLabel = ... # type: QStyle.ControlElement
        CE_HeaderEmptyArea = ... # type: QStyle.ControlElement
        CE_ColumnViewGrip = ... # type: QStyle.ControlElement
        CE_ItemViewItem = ... # type: QStyle.ControlElement
        CE_ShapedFrame = ... # type: QStyle.ControlElement
        CE_CustomBase = ... # type: QStyle.ControlElement

    class PrimitiveElement(int):
        PE_Frame = ... # type: QStyle.PrimitiveElement
        PE_FrameDefaultButton = ... # type: QStyle.PrimitiveElement
        PE_FrameDockWidget = ... # type: QStyle.PrimitiveElement
        PE_FrameFocusRect = ... # type: QStyle.PrimitiveElement
        PE_FrameGroupBox = ... # type: QStyle.PrimitiveElement
        PE_FrameLineEdit = ... # type: QStyle.PrimitiveElement
        PE_FrameMenu = ... # type: QStyle.PrimitiveElement
        PE_FrameStatusBar = ... # type: QStyle.PrimitiveElement
        PE_FrameTabWidget = ... # type: QStyle.PrimitiveElement
        PE_FrameWindow = ... # type: QStyle.PrimitiveElement
        PE_FrameButtonBevel = ... # type: QStyle.PrimitiveElement
        PE_FrameButtonTool = ... # type: QStyle.PrimitiveElement
        PE_FrameTabBarBase = ... # type: QStyle.PrimitiveElement
        PE_PanelButtonCommand = ... # type: QStyle.PrimitiveElement
        PE_PanelButtonBevel = ... # type: QStyle.PrimitiveElement
        PE_PanelButtonTool = ... # type: QStyle.PrimitiveElement
        PE_PanelMenuBar = ... # type: QStyle.PrimitiveElement
        PE_PanelToolBar = ... # type: QStyle.PrimitiveElement
        PE_PanelLineEdit = ... # type: QStyle.PrimitiveElement
        PE_IndicatorArrowDown = ... # type: QStyle.PrimitiveElement
        PE_IndicatorArrowLeft = ... # type: QStyle.PrimitiveElement
        PE_IndicatorArrowRight = ... # type: QStyle.PrimitiveElement
        PE_IndicatorArrowUp = ... # type: QStyle.PrimitiveElement
        PE_IndicatorBranch = ... # type: QStyle.PrimitiveElement
        PE_IndicatorButtonDropDown = ... # type: QStyle.PrimitiveElement
        PE_IndicatorViewItemCheck = ... # type: QStyle.PrimitiveElement
        PE_IndicatorCheckBox = ... # type: QStyle.PrimitiveElement
        PE_IndicatorDockWidgetResizeHandle = ... # type: QStyle.PrimitiveElement
        PE_IndicatorHeaderArrow = ... # type: QStyle.PrimitiveElement
        PE_IndicatorMenuCheckMark = ... # type: QStyle.PrimitiveElement
        PE_IndicatorProgressChunk = ... # type: QStyle.PrimitiveElement
        PE_IndicatorRadioButton = ... # type: QStyle.PrimitiveElement
        PE_IndicatorSpinDown = ... # type: QStyle.PrimitiveElement
        PE_IndicatorSpinMinus = ... # type: QStyle.PrimitiveElement
        PE_IndicatorSpinPlus = ... # type: QStyle.PrimitiveElement
        PE_IndicatorSpinUp = ... # type: QStyle.PrimitiveElement
        PE_IndicatorToolBarHandle = ... # type: QStyle.PrimitiveElement
        PE_IndicatorToolBarSeparator = ... # type: QStyle.PrimitiveElement
        PE_PanelTipLabel = ... # type: QStyle.PrimitiveElement
        PE_IndicatorTabTear = ... # type: QStyle.PrimitiveElement
        PE_PanelScrollAreaCorner = ... # type: QStyle.PrimitiveElement
        PE_Widget = ... # type: QStyle.PrimitiveElement
        PE_IndicatorColumnViewArrow = ... # type: QStyle.PrimitiveElement
        PE_FrameStatusBarItem = ... # type: QStyle.PrimitiveElement
        PE_IndicatorItemViewItemCheck = ... # type: QStyle.PrimitiveElement
        PE_IndicatorItemViewItemDrop = ... # type: QStyle.PrimitiveElement
        PE_PanelItemViewItem = ... # type: QStyle.PrimitiveElement
        PE_PanelItemViewRow = ... # type: QStyle.PrimitiveElement
        PE_PanelStatusBar = ... # type: QStyle.PrimitiveElement
        PE_IndicatorTabClose = ... # type: QStyle.PrimitiveElement
        PE_PanelMenu = ... # type: QStyle.PrimitiveElement
        PE_IndicatorTabTearLeft = ... # type: QStyle.PrimitiveElement
        PE_IndicatorTabTearRight = ... # type: QStyle.PrimitiveElement
        PE_CustomBase = ... # type: QStyle.PrimitiveElement

    class StateFlag(int):
        State_None = ... # type: QStyle.StateFlag
        State_Enabled = ... # type: QStyle.StateFlag
        State_Raised = ... # type: QStyle.StateFlag
        State_Sunken = ... # type: QStyle.StateFlag
        State_Off = ... # type: QStyle.StateFlag
        State_NoChange = ... # type: QStyle.StateFlag
        State_On = ... # type: QStyle.StateFlag
        State_DownArrow = ... # type: QStyle.StateFlag
        State_Horizontal = ... # type: QStyle.StateFlag
        State_HasFocus = ... # type: QStyle.StateFlag
        State_Top = ... # type: QStyle.StateFlag
        State_Bottom = ... # type: QStyle.StateFlag
        State_FocusAtBorder = ... # type: QStyle.StateFlag
        State_AutoRaise = ... # type: QStyle.StateFlag
        State_MouseOver = ... # type: QStyle.StateFlag
        State_UpArrow = ... # type: QStyle.StateFlag
        State_Selected = ... # type: QStyle.StateFlag
        State_Active = ... # type: QStyle.StateFlag
        State_Open = ... # type: QStyle.StateFlag
        State_Children = ... # type: QStyle.StateFlag
        State_Item = ... # type: QStyle.StateFlag
        State_Sibling = ... # type: QStyle.StateFlag
        State_Editing = ... # type: QStyle.StateFlag
        State_KeyboardFocusChange = ... # type: QStyle.StateFlag
        State_ReadOnly = ... # type: QStyle.StateFlag
        State_Window = ... # type: QStyle.StateFlag
        State_Small = ... # type: QStyle.StateFlag
        State_Mini = ... # type: QStyle.StateFlag

    State: typing.Type[int]
    #class State(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QStyle.State, int]) -> None: ...
        #@overload
        #def __init__(self, a0: QStyle.State) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QStyle.State: ...
        #def __int__(self) -> int: ...

    SubControls: typing.Type[int]
    #class SubControls(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QStyle.SubControls, QStyle.SubControl]) -> None: ...
        #@overload
        #def __init__(self, a0: QStyle.SubControls) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QStyle.SubControls: ...
        #def __int__(self) -> int: ...

    def __init__(self, **props) -> None: ...

    def proxy(self) -> QStyle: ...
    def combinedLayoutSpacing(self, controls1: typing.Union[int, int], controls2: typing.Union[int, int], orientation: int, option: typing.Optional[QStyleOption] = ..., widget: typing.Optional[QWidget] = ...) -> int: ...
    def layoutSpacing(self, control1: int, control2: int, orientation: int, option: typing.Optional[QStyleOption] = ..., widget: typing.Optional[QWidget] = ...) -> int: ...
    @staticmethod
    def alignedRect(direction: int, alignment: typing.Union[int, int], size: QtCore.QSize, rectangle: QtCore.QRect) -> QtCore.QRect: ...
    @staticmethod
    def visualAlignment(direction: int, alignment: typing.Union[int, int]) -> int: ...
    @staticmethod
    def sliderValueFromPosition(min: int, max: int, position: int, span: int, upsideDown: bool = ...) -> int: ...
    @staticmethod
    def sliderPositionFromValue(min: int, max: int, logicalValue: int, span: int, upsideDown: bool = ...) -> int: ...
    @staticmethod
    def visualPos(direction: int, boundingRect: QtCore.QRect, logicalPos: QtCore.QPoint) -> QtCore.QPoint: ...
    @staticmethod
    def visualRect(direction: int, boundingRect: QtCore.QRect, logicalRect: QtCore.QRect) -> QtCore.QRect: ...
    def generatedIconPixmap(self, iconMode: int, pixmap: QtGui.QPixmap, opt: QStyleOption) -> QtGui.QPixmap: ...
    def standardIcon(self, standardIcon: int, option: typing.Optional[QStyleOption] = ..., widget: typing.Optional[QWidget] = ...) -> QtGui.QIcon: ...
    def standardPixmap(self, standardPixmap: int, option: typing.Optional[QStyleOption] = ..., widget: typing.Optional[QWidget] = ...) -> QtGui.QPixmap: ...
    def styleHint(self, stylehint: int, option: typing.Optional[QStyleOption] = ..., widget: typing.Optional[QWidget] = ..., returnData: typing.Optional[QStyleHintReturn] = ...) -> int: ...
    def sizeFromContents(self, ct: int, opt: QStyleOption, contentsSize: QtCore.QSize, widget: typing.Optional[QWidget] = ...) -> QtCore.QSize: ...
    def pixelMetric(self, metric: int, option: typing.Optional[QStyleOption] = ..., widget: typing.Optional[QWidget] = ...) -> int: ...
    def subControlRect(self, cc: int, opt: QStyleOptionComplex, sc: int, widget: typing.Optional[QWidget] = ...) -> QtCore.QRect: ...
    def hitTestComplexControl(self, cc: int, opt: QStyleOptionComplex, pt: QtCore.QPoint, widget: typing.Optional[QWidget] = ...) -> int: ...
    def drawComplexControl(self, cc: int, opt: QStyleOptionComplex, p: QtGui.QPainter, widget: typing.Optional[QWidget] = ...) -> None: ...
    def subElementRect(self, subElement: int, option: QStyleOption, widget: typing.Optional[QWidget] = ...) -> QtCore.QRect: ...
    def drawControl(self, element: int, opt: QStyleOption, p: QtGui.QPainter, widget: typing.Optional[QWidget] = ...) -> None: ...
    def drawPrimitive(self, pe: int, opt: QStyleOption, p: QtGui.QPainter, widget: typing.Optional[QWidget] = ...) -> None: ...
    def standardPalette(self) -> QtGui.QPalette: ...
    def drawItemPixmap(self, painter: QtGui.QPainter, rect: QtCore.QRect, alignment: int, pixmap: QtGui.QPixmap) -> None: ...
    def drawItemText(self, painter: QtGui.QPainter, rectangle: QtCore.QRect, alignment: int, palette: QtGui.QPalette, enabled: bool, text: str, textRole: int = ...) -> None: ...
    def itemPixmapRect(self, r: QtCore.QRect, flags: int, pixmap: QtGui.QPixmap) -> QtCore.QRect: ...
    def itemTextRect(self, fm: QtGui.QFontMetrics, r: QtCore.QRect, flags: int, enabled: bool, text: str) -> QtCore.QRect: ...
    @overload
    def unpolish(self, a0: QWidget) -> None: ...
    @overload
    def unpolish(self, a0: QApplication) -> None: ...
    @overload
    def polish(self, a0: QWidget) -> None: ...
    @overload
    def polish(self, a0: QApplication) -> None: ...
    @overload
    def polish(self, a0: QtGui.QPalette) -> QtGui.QPalette: ...


class QCommonStyle(QStyle):

    def __init__(self, **props) -> None: ...

    def layoutSpacing(self, control1: int, control2: int, orientation: int, option: typing.Optional[QStyleOption] = ..., widget: typing.Optional[QWidget] = ...) -> int: ...
    def standardIcon(self, standardIcon: int, option: typing.Optional[QStyleOption] = ..., widget: typing.Optional[QWidget] = ...) -> QtGui.QIcon: ...
    def generatedIconPixmap(self, iconMode: int, pixmap: QtGui.QPixmap, opt: QStyleOption) -> QtGui.QPixmap: ...
    def standardPixmap(self, sp: int, option: typing.Optional[QStyleOption] = ..., widget: typing.Optional[QWidget] = ...) -> QtGui.QPixmap: ...
    def styleHint(self, sh: int, option: typing.Optional[QStyleOption] = ..., widget: typing.Optional[QWidget] = ..., returnData: typing.Optional[QStyleHintReturn] = ...) -> int: ...
    def pixelMetric(self, m: int, option: typing.Optional[QStyleOption] = ..., widget: typing.Optional[QWidget] = ...) -> int: ...
    def sizeFromContents(self, ct: int, opt: QStyleOption, contentsSize: QtCore.QSize, widget: typing.Optional[QWidget] = ...) -> QtCore.QSize: ...
    def subControlRect(self, cc: int, opt: QStyleOptionComplex, sc: int, widget: typing.Optional[QWidget] = ...) -> QtCore.QRect: ...
    def hitTestComplexControl(self, cc: int, opt: QStyleOptionComplex, pt: QtCore.QPoint, widget: typing.Optional[QWidget] = ...) -> int: ...
    def drawComplexControl(self, cc: int, opt: QStyleOptionComplex, p: QtGui.QPainter, widget: typing.Optional[QWidget] = ...) -> None: ...
    def subElementRect(self, r: int, opt: QStyleOption, widget: typing.Optional[QWidget] = ...) -> QtCore.QRect: ...
    def drawControl(self, element: int, opt: QStyleOption, p: QtGui.QPainter, widget: typing.Optional[QWidget] = ...) -> None: ...
    def drawPrimitive(self, pe: int, opt: QStyleOption, p: QtGui.QPainter, widget: typing.Optional[QWidget] = ...) -> None: ...
    @overload
    def unpolish(self, widget: QWidget) -> None: ...
    @overload
    def unpolish(self, application: QApplication) -> None: ...
    @overload
    def polish(self, widget: QWidget) -> None: ...
    @overload
    def polish(self, app: QApplication) -> None: ...
    @overload
    def polish(self, a0: QtGui.QPalette) -> QtGui.QPalette: ...


class QCompleter(QtCore.QObject):

    activated: PYQT_SIGNAL
    highlighted: PYQT_SIGNAL

    ModelSorting: typing.Type[int]
    #class ModelSorting(int): ...
    UnsortedModel = ... # type: int
    CaseSensitivelySortedModel = ... # type: int
    CaseInsensitivelySortedModel = ... # type: int

    CompletionMode: typing.Type[int]
    #class CompletionMode(int): ...
    PopupCompletion = ... # type: int
    UnfilteredPopupCompletion = ... # type: int
    InlineCompletion = ... # type: int

    @overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, model: typing.Optional[QtCore.QAbstractItemModel], parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, list: typing.Iterable[str], parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def filterMode(self) -> int: ...
    def setFilterMode(self, filterMode: typing.Union[int, int]) -> None: ...
    def setMaxVisibleItems(self, maxItems: int) -> None: ...
    def maxVisibleItems(self) -> int: ...
    #@overload
    #def highlighted(self, text: str) -> None: ...
    #@overload
    #def highlighted(self, index: QtCore.QModelIndex) -> None: ...
    #@overload
    #def activated(self, text: str) -> None: ...
    #@overload
    #def activated(self, index: QtCore.QModelIndex) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def eventFilter(self, o: QtCore.QObject, e: QtCore.QEvent) -> bool: ...
    def setWrapAround(self, wrap: bool) -> None: ...
    def setCompletionPrefix(self, prefix: str) -> None: ...
    def complete(self, rect: QtCore.QRect = ...) -> None: ...
    def wrapAround(self) -> bool: ...
    def splitPath(self, path: str) -> typing.List[str]: ...
    def pathFromIndex(self, index: QtCore.QModelIndex) -> str: ...
    def completionPrefix(self) -> str: ...
    def completionModel(self) -> QtCore.QAbstractItemModel: ...
    def currentCompletion(self) -> str: ...
    def currentIndex(self) -> QtCore.QModelIndex: ...
    def currentRow(self) -> int: ...
    def setCurrentRow(self, row: int) -> bool: ...
    def completionCount(self) -> int: ...
    def completionRole(self) -> int: ...
    def setCompletionRole(self, role: int) -> None: ...
    def completionColumn(self) -> int: ...
    def setCompletionColumn(self, column: int) -> None: ...
    def modelSorting(self) -> int: ...
    def setModelSorting(self, sorting: int) -> None: ...
    def caseSensitivity(self) -> int: ...
    def setCaseSensitivity(self, caseSensitivity: int) -> None: ...
    def setPopup(self, popup: QAbstractItemView) -> None: ...
    def popup(self) -> QAbstractItemView: ...
    def completionMode(self) -> int: ...
    def setCompletionMode(self, mode: int) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel: ...
    def setModel(self, c: QtCore.QAbstractItemModel) -> None: ...
    def widget(self) -> QWidget: ...
    def setWidget(self, widget: QWidget) -> None: ...


class QDataWidgetMapper(QtCore.QObject):

    currentIndexChanged: PYQT_SIGNAL

    SubmitPolicy: typing.Type[int]
    #class SubmitPolicy(int): ...
    AutoSubmit = ... # type: int
    ManualSubmit = ... # type: int

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    #def currentIndexChanged(self, index: int) -> None: ...
    def toPrevious(self) -> None: ...
    def toNext(self) -> None: ...
    def toLast(self) -> None: ...
    def toFirst(self) -> None: ...
    def submit(self) -> bool: ...
    def setCurrentModelIndex(self, index: QtCore.QModelIndex) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def revert(self) -> None: ...
    def currentIndex(self) -> int: ...
    def clearMapping(self) -> None: ...
    def mappedWidgetAt(self, section: int) -> QWidget: ...
    def mappedSection(self, widget: QWidget) -> int: ...
    def mappedPropertyName(self, widget: QWidget) -> QtCore.QByteArray: ...
    def removeMapping(self, widget: QWidget) -> None: ...
    @overload
    def addMapping(self, widget: QWidget, section: int) -> None: ...
    @overload
    def addMapping(self, widget: QWidget, section: int, propertyName: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def submitPolicy(self) -> int: ...
    def setSubmitPolicy(self, policy: int) -> None: ...
    def orientation(self) -> int: ...
    def setOrientation(self, aOrientation: int) -> None: ...
    def rootIndex(self) -> QtCore.QModelIndex: ...
    def setRootIndex(self, index: QtCore.QModelIndex) -> None: ...
    def itemDelegate(self) -> QAbstractItemDelegate: ...
    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...


class QDateTimeEdit(QAbstractSpinBox):

    dateChanged: PYQT_SIGNAL
    dateTimeChanged: PYQT_SIGNAL
    timeChanged: PYQT_SIGNAL

    Section: typing.Type[int]
    #class Section(int): ...
    NoSection = ... # type: int
    AmPmSection = ... # type: int
    MSecSection = ... # type: int
    SecondSection = ... # type: int
    MinuteSection = ... # type: int
    HourSection = ... # type: int
    DaySection = ... # type: int
    MonthSection = ... # type: int
    YearSection = ... # type: int
    TimeSections_Mask = ... # type: int
    DateSections_Mask = ... # type: int

    Sections: typing.Type[int]
    #class Sections(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QDateTimeEdit.Sections, QDateTimeEdit.Section]) -> None: ...
        #@overload
        #def __init__(self, a0: QDateTimeEdit.Sections) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QDateTimeEdit.Sections: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, datetime: typing.Union[QtCore.QDateTime, datetime.datetime], parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, date: typing.Union[QtCore.QDate, datetime.date], parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, time: typing.Union[QtCore.QTime, datetime.time], parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def setTimeSpec(self, spec: int) -> None: ...
    def timeSpec(self) -> int: ...
    def setCalendarWidget(self, calendarWidget: QCalendarWidget) -> None: ...
    def calendarWidget(self) -> QCalendarWidget: ...
    def setDateTimeRange(self, min: typing.Union[QtCore.QDateTime, datetime.datetime], max: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def setMaximumDateTime(self, dt: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def clearMaximumDateTime(self) -> None: ...
    def maximumDateTime(self) -> QtCore.QDateTime: ...
    def setMinimumDateTime(self, dt: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def clearMinimumDateTime(self) -> None: ...
    def minimumDateTime(self) -> QtCore.QDateTime: ...
    def stepEnabled(self) -> int: ...
    def textFromDateTime(self, dt: typing.Union[QtCore.QDateTime, datetime.datetime]) -> str: ...
    def dateTimeFromText(self, text: str) -> QtCore.QDateTime: ...
    def fixup(self, input: str) -> str: ...
    def validate(self, input: str, pos: int) -> typing.Tuple[int, str, int]: ...
    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusInEvent(self, e: QtGui.QFocusEvent) -> None: ...
    def wheelEvent(self, e: QtGui.QWheelEvent) -> None: ...
    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def initStyleOption(self, option: QStyleOptionSpinBox) -> None: ...
    def setTime(self, time: typing.Union[QtCore.QTime, datetime.time]) -> None: ...
    def setDate(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def setDateTime(self, dateTime: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    #def dateChanged(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    #def timeChanged(self, date: typing.Union[QtCore.QTime, datetime.time]) -> None: ...
    #def dateTimeChanged(self, date: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def sectionCount(self) -> int: ...
    def setCurrentSectionIndex(self, index: int) -> None: ...
    def currentSectionIndex(self) -> int: ...
    def sectionAt(self, index: int) -> int: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def stepBy(self, steps: int) -> None: ...
    def clear(self) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setSelectedSection(self, section: int) -> None: ...
    def setCalendarPopup(self, enable: bool) -> None: ...
    def calendarPopup(self) -> bool: ...
    def setDisplayFormat(self, format: str) -> None: ...
    def displayFormat(self) -> str: ...
    def sectionText(self, s: int) -> str: ...
    def setCurrentSection(self, section: int) -> None: ...
    def currentSection(self) -> int: ...
    def displayedSections(self) -> int: ...
    def setTimeRange(self, min: typing.Union[QtCore.QTime, datetime.time], max: typing.Union[QtCore.QTime, datetime.time]) -> None: ...
    def clearMaximumTime(self) -> None: ...
    def setMaximumTime(self, max: typing.Union[QtCore.QTime, datetime.time]) -> None: ...
    def maximumTime(self) -> QtCore.QTime: ...
    def clearMinimumTime(self) -> None: ...
    def setMinimumTime(self, min: typing.Union[QtCore.QTime, datetime.time]) -> None: ...
    def minimumTime(self) -> QtCore.QTime: ...
    def setDateRange(self, min: typing.Union[QtCore.QDate, datetime.date], max: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def clearMaximumDate(self) -> None: ...
    def setMaximumDate(self, max: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def maximumDate(self) -> QtCore.QDate: ...
    def clearMinimumDate(self) -> None: ...
    def setMinimumDate(self, min: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def minimumDate(self) -> QtCore.QDate: ...
    def time(self) -> QtCore.QTime: ...
    def date(self) -> QtCore.QDate: ...
    def dateTime(self) -> QtCore.QDateTime: ...


class QTimeEdit(QDateTimeEdit):

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, time: typing.Union[QtCore.QTime, datetime.time], parent: typing.Optional[QWidget] = ..., **props) -> None: ...


class QDateEdit(QDateTimeEdit):

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, date: typing.Union[QtCore.QDate, datetime.date], parent: typing.Optional[QWidget] = ..., **props) -> None: ...


class QDesktopWidget(QWidget):

    primaryScreenChanged: PYQT_SIGNAL
    resized: PYQT_SIGNAL
    screenCountChanged: PYQT_SIGNAL
    workAreaResized: PYQT_SIGNAL

    def __init__(self, **props) -> None: ...

    def resizeEvent(self, e: QtGui.QResizeEvent) -> None: ...
    #def primaryScreenChanged(self) -> None: ...
    #def screenCountChanged(self, a0: int) -> None: ...
    #def workAreaResized(self, a0: int) -> None: ...
    #def resized(self, a0: int) -> None: ...
    @overload
    def availableGeometry(self, screen: int = ...) -> QtCore.QRect: ...
    @overload
    def availableGeometry(self, widget: QWidget) -> QtCore.QRect: ...
    @overload
    def availableGeometry(self, point: QtCore.QPoint) -> QtCore.QRect: ...
    @overload
    def screenGeometry(self, screen: int = ...) -> QtCore.QRect: ...
    @overload
    def screenGeometry(self, widget: QWidget) -> QtCore.QRect: ...
    @overload
    def screenGeometry(self, point: QtCore.QPoint) -> QtCore.QRect: ...
    def screenCount(self) -> int: ...
    def screen(self, screen: int = ...) -> QWidget: ...
    @overload
    def screenNumber(self, widget: typing.Optional[QWidget] = ...) -> int: ...
    @overload
    def screenNumber(self, a0: QtCore.QPoint) -> int: ...
    def primaryScreen(self) -> int: ...
    def isVirtualDesktop(self) -> bool: ...


class QDial(QAbstractSlider):

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def sliderChange(self, change: int) -> None: ...
    def mouseMoveEvent(self, me: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, me: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, me: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, pe: QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, re: QtGui.QResizeEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: QStyleOptionSlider) -> None: ...
    def setWrapping(self, on: bool) -> None: ...
    def setNotchesVisible(self, visible: bool) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def notchesVisible(self) -> bool: ...
    def notchTarget(self) -> float: ...
    def setNotchTarget(self, target: float) -> None: ...
    def notchSize(self) -> int: ...
    def wrapping(self) -> bool: ...


class QDialogButtonBox(QWidget):

    accepted: PYQT_SIGNAL
    clicked: PYQT_SIGNAL
    helpRequested: PYQT_SIGNAL
    rejected: PYQT_SIGNAL

    class StandardButton(int):
        NoButton = ... # type: QDialogButtonBox.StandardButton
        Ok = ... # type: QDialogButtonBox.StandardButton
        Save = ... # type: QDialogButtonBox.StandardButton
        SaveAll = ... # type: QDialogButtonBox.StandardButton
        Open = ... # type: QDialogButtonBox.StandardButton
        Yes = ... # type: QDialogButtonBox.StandardButton
        YesToAll = ... # type: QDialogButtonBox.StandardButton
        No = ... # type: QDialogButtonBox.StandardButton
        NoToAll = ... # type: QDialogButtonBox.StandardButton
        Abort = ... # type: QDialogButtonBox.StandardButton
        Retry = ... # type: QDialogButtonBox.StandardButton
        Ignore = ... # type: QDialogButtonBox.StandardButton
        Close = ... # type: QDialogButtonBox.StandardButton
        Cancel = ... # type: QDialogButtonBox.StandardButton
        Discard = ... # type: QDialogButtonBox.StandardButton
        Help = ... # type: QDialogButtonBox.StandardButton
        Apply = ... # type: QDialogButtonBox.StandardButton
        Reset = ... # type: QDialogButtonBox.StandardButton
        RestoreDefaults = ... # type: QDialogButtonBox.StandardButton

    class ButtonRole(int):
        InvalidRole = ... # type: QDialogButtonBox.ButtonRole
        AcceptRole = ... # type: QDialogButtonBox.ButtonRole
        RejectRole = ... # type: QDialogButtonBox.ButtonRole
        DestructiveRole = ... # type: QDialogButtonBox.ButtonRole
        ActionRole = ... # type: QDialogButtonBox.ButtonRole
        HelpRole = ... # type: QDialogButtonBox.ButtonRole
        YesRole = ... # type: QDialogButtonBox.ButtonRole
        NoRole = ... # type: QDialogButtonBox.ButtonRole
        ResetRole = ... # type: QDialogButtonBox.ButtonRole
        ApplyRole = ... # type: QDialogButtonBox.ButtonRole

    ButtonLayout: typing.Type[int]
    #class ButtonLayout(int): ...
    WinLayout = ... # type: int
    MacLayout = ... # type: int
    KdeLayout = ... # type: int
    GnomeLayout = ... # type: int
    AndroidLayout = ... # type: int

    StandardButtons: typing.Type[int]
    #class StandardButtons(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QDialogButtonBox.StandardButtons, QDialogButtonBox.StandardButton]) -> None: ...
        #@overload
        #def __init__(self, a0: QDialogButtonBox.StandardButtons) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QDialogButtonBox.StandardButtons: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, orientation: int, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, buttons: typing.Union[int, int], parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, buttons: typing.Union[int, int], orientation: int, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def event(self, event: QtCore.QEvent) -> bool: ...
    def changeEvent(self, event: QtCore.QEvent) -> None: ...
    #def rejected(self) -> None: ...
    #def helpRequested(self) -> None: ...
    #def clicked(self, button: QAbstractButton) -> None: ...
    #def accepted(self) -> None: ...
    def centerButtons(self) -> bool: ...
    def setCenterButtons(self, center: bool) -> None: ...
    def button(self, which: int) -> QPushButton: ...
    def standardButton(self, button: QAbstractButton) -> int: ...
    def standardButtons(self) -> int: ...
    def setStandardButtons(self, buttons: typing.Union[int, int]) -> None: ...
    def buttonRole(self, button: QAbstractButton) -> int: ...
    def buttons(self) -> typing.List[QAbstractButton]: ...
    def clear(self) -> None: ...
    def removeButton(self, button: QAbstractButton) -> None: ...
    @overload
    def addButton(self, button: QAbstractButton, role: int) -> None: ...
    @overload
    def addButton(self, text: str, role: int) -> QPushButton: ...
    @overload
    def addButton(self, button: int) -> QPushButton: ...
    def orientation(self) -> int: ...
    def setOrientation(self, orientation: int) -> None: ...


class QDirModel(QtCore.QAbstractItemModel):

    Roles: typing.Type[int]
    #class Roles(int): ...
    FileIconRole = ... # type: int
    FilePathRole = ... # type: int
    FileNameRole = ... # type: int

    @overload
    def __init__(self, nameFilters: typing.Iterable[str], filters: typing.Union[int, int], sort: typing.Union[int, int], parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def fileInfo(self, index: QtCore.QModelIndex) -> QtCore.QFileInfo: ...
    def fileIcon(self, index: QtCore.QModelIndex) -> QtGui.QIcon: ...
    def fileName(self, index: QtCore.QModelIndex) -> str: ...
    def filePath(self, index: QtCore.QModelIndex) -> str: ...
    def remove(self, index: QtCore.QModelIndex) -> bool: ...
    def rmdir(self, index: QtCore.QModelIndex) -> bool: ...
    def mkdir(self, parent: QtCore.QModelIndex, name: str) -> QtCore.QModelIndex: ...
    def isDir(self, index: QtCore.QModelIndex) -> bool: ...
    def refresh(self, parent: QtCore.QModelIndex = ...) -> None: ...
    def lazyChildCount(self) -> bool: ...
    def setLazyChildCount(self, enable: bool) -> None: ...
    def isReadOnly(self) -> bool: ...
    def setReadOnly(self, enable: bool) -> None: ...
    def resolveSymlinks(self) -> bool: ...
    def setResolveSymlinks(self, enable: bool) -> None: ...
    def sorting(self) -> int: ...
    def setSorting(self, sort: typing.Union[int, int]) -> None: ...
    def filter(self) -> int: ...
    def setFilter(self, filters: typing.Union[int, int]) -> None: ...
    def nameFilters(self) -> typing.List[str]: ...
    def setNameFilters(self, filters: typing.Iterable[str]) -> None: ...
    def iconProvider(self) -> QFileIconProvider: ...
    def setIconProvider(self, provider: QFileIconProvider) -> None: ...
    def supportedDropActions(self) -> int: ...
    def dropMimeData(self, data: QtCore.QMimeData, action: int, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: typing.Iterable[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def sort(self, column: int, order: int = ...) -> None: ...
    def flags(self, index: QtCore.QModelIndex) -> int: ...
    def hasChildren(self, parent: QtCore.QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: int, role: int = ...) -> typing.Any: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    @overload
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    @overload
    def parent(self) -> QtCore.QObject: ...
    @overload
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    @overload
    def index(self, path: str, column: int = ...) -> QtCore.QModelIndex: ...


class QDockWidget(QWidget):

    allowedAreasChanged: PYQT_SIGNAL
    dockLocationChanged: PYQT_SIGNAL
    featuresChanged: PYQT_SIGNAL
    topLevelChanged: PYQT_SIGNAL
    visibilityChanged: PYQT_SIGNAL

    class DockWidgetFeature(int):
        DockWidgetClosable = ... # type: QDockWidget.DockWidgetFeature
        DockWidgetMovable = ... # type: QDockWidget.DockWidgetFeature
        DockWidgetFloatable = ... # type: QDockWidget.DockWidgetFeature
        DockWidgetVerticalTitleBar = ... # type: QDockWidget.DockWidgetFeature
        AllDockWidgetFeatures = ... # type: QDockWidget.DockWidgetFeature
        NoDockWidgetFeatures = ... # type: QDockWidget.DockWidgetFeature

    DockWidgetFeatures: typing.Type[int]
    #class DockWidgetFeatures(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QDockWidget.DockWidgetFeatures, QDockWidget.DockWidgetFeature]) -> None: ...
        #@overload
        #def __init__(self, a0: QDockWidget.DockWidgetFeatures) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QDockWidget.DockWidgetFeatures: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self, title: str, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...
    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    def event(self, event: QtCore.QEvent) -> bool: ...
    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def closeEvent(self, event: QtGui.QCloseEvent) -> None: ...
    def changeEvent(self, event: QtCore.QEvent) -> None: ...
    def initStyleOption(self, option: QStyleOptionDockWidget) -> None: ...
    #def visibilityChanged(self, visible: bool) -> None: ...
    #def dockLocationChanged(self, area: int) -> None: ...
    #def allowedAreasChanged(self, allowedAreas: typing.Union[int, int]) -> None: ...
    #def topLevelChanged(self, topLevel: bool) -> None: ...
    #def featuresChanged(self, features: typing.Union[int, int]) -> None: ...
    def titleBarWidget(self) -> QWidget: ...
    def setTitleBarWidget(self, widget: QWidget) -> None: ...
    def toggleViewAction(self) -> QAction: ...
    def isAreaAllowed(self, area: int) -> bool: ...
    def allowedAreas(self) -> int: ...
    def setAllowedAreas(self, areas: typing.Union[int, int]) -> None: ...
    def isFloating(self) -> bool: ...
    def setFloating(self, floating: bool) -> None: ...
    def features(self) -> int: ...
    def setFeatures(self, features: typing.Union[int, int]) -> None: ...
    def setWidget(self, widget: QWidget) -> None: ...
    def widget(self) -> QWidget: ...


class QErrorMessage(QDialog):

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def done(self, a0: int) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    @overload
    def showMessage(self, message: str) -> None: ...
    @overload
    def showMessage(self, message: str, type: str) -> None: ...
    @staticmethod
    def qtHandler() -> QErrorMessage: ...


class QFileDialog(QDialog):

    currentChanged: PYQT_SIGNAL
    currentUrlChanged: PYQT_SIGNAL
    directoryEntered: PYQT_SIGNAL
    directoryUrlEntered: PYQT_SIGNAL
    fileSelected: PYQT_SIGNAL
    filesSelected: PYQT_SIGNAL
    filterSelected: PYQT_SIGNAL
    urlSelected: PYQT_SIGNAL
    urlsSelected: PYQT_SIGNAL

    class Option(int):
        ShowDirsOnly = ... # type: QFileDialog.Option
        DontResolveSymlinks = ... # type: QFileDialog.Option
        DontConfirmOverwrite = ... # type: QFileDialog.Option
        DontUseSheet = ... # type: QFileDialog.Option
        DontUseNativeDialog = ... # type: QFileDialog.Option
        ReadOnly = ... # type: QFileDialog.Option
        HideNameFilterDetails = ... # type: QFileDialog.Option
        DontUseCustomDirectoryIcons = ... # type: QFileDialog.Option

    class DialogLabel(int):
        LookIn = ... # type: QFileDialog.DialogLabel
        FileName = ... # type: QFileDialog.DialogLabel
        FileType = ... # type: QFileDialog.DialogLabel
        Accept = ... # type: QFileDialog.DialogLabel
        Reject = ... # type: QFileDialog.DialogLabel

    class AcceptMode(int):
        AcceptOpen = ... # type: QFileDialog.AcceptMode
        AcceptSave = ... # type: QFileDialog.AcceptMode

    class FileMode(int):
        AnyFile = ... # type: QFileDialog.FileMode
        ExistingFile = ... # type: QFileDialog.FileMode
        Directory = ... # type: QFileDialog.FileMode
        ExistingFiles = ... # type: QFileDialog.FileMode
        DirectoryOnly = ... # type: QFileDialog.FileMode

    class ViewMode(int):
        Detail = ... # type: QFileDialog.ViewMode
        List = ... # type: QFileDialog.ViewMode

    Options: typing.Type[int]
    #class Options(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QFileDialog.Options, QFileDialog.Option]) -> None: ...
        #@overload
        #def __init__(self, a0: QFileDialog.Options) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QFileDialog.Options: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self, parent: QWidget, f: typing.Union[int, int], **props) -> None: ...
    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ..., **props) -> None: ...

    def selectedMimeTypeFilter(self) -> str: ...
    def supportedSchemes(self) -> typing.List[str]: ...
    def setSupportedSchemes(self, schemes: typing.Iterable[str]) -> None: ...
    @staticmethod
    def getSaveFileUrl(parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ..., initialFilter: str = ..., options: typing.Union[int, int] = ..., supportedSchemes: typing.Iterable[str] = ...) -> typing.Tuple[QtCore.QUrl, str]: ...
    @staticmethod
    def getOpenFileUrls(parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ..., initialFilter: str = ..., options: typing.Union[int, int] = ..., supportedSchemes: typing.Iterable[str] = ...) -> typing.Tuple[typing.List[QtCore.QUrl], str]: ...
    @staticmethod
    def getOpenFileUrl(parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ..., initialFilter: str = ..., options: typing.Union[int, int] = ..., supportedSchemes: typing.Iterable[str] = ...) -> typing.Tuple[QtCore.QUrl, str]: ...
    #def directoryUrlEntered(self, directory: QtCore.QUrl) -> None: ...
    #def currentUrlChanged(self, url: QtCore.QUrl) -> None: ...
    #def urlsSelected(self, urls: typing.Iterable[QtCore.QUrl]) -> None: ...
    #def urlSelected(self, url: QtCore.QUrl) -> None: ...
    def selectMimeTypeFilter(self, filter: str) -> None: ...
    def mimeTypeFilters(self) -> typing.List[str]: ...
    def setMimeTypeFilters(self, filters: typing.Iterable[str]) -> None: ...
    def selectedUrls(self) -> typing.List[QtCore.QUrl]: ...
    def selectUrl(self, url: QtCore.QUrl) -> None: ...
    def directoryUrl(self) -> QtCore.QUrl: ...
    def setDirectoryUrl(self, directory: QtCore.QUrl) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    @overload
    def open(self) -> None: ...
    @overload
    def open(self, slot: PYQT_SLOT) -> None: ...
    def options(self) -> int: ...
    def setOptions(self, options: typing.Union[int, int]) -> None: ...
    def testOption(self, option: int) -> bool: ...
    def setOption(self, option: int, on: bool = ...) -> None: ...
    def setFilter(self, filters: typing.Union[int, int]) -> None: ...
    def filter(self) -> int: ...
    def selectedNameFilter(self) -> str: ...
    def selectNameFilter(self, filter: str) -> None: ...
    def nameFilters(self) -> typing.List[str]: ...
    def setNameFilters(self, filters: typing.Iterable[str]) -> None: ...
    def setNameFilter(self, filter: str) -> None: ...
    def proxyModel(self) -> QtCore.QAbstractProxyModel: ...
    def setProxyModel(self, model: QtCore.QAbstractProxyModel) -> None: ...
    def restoreState(self, state: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def saveState(self) -> QtCore.QByteArray: ...
    def sidebarUrls(self) -> typing.List[QtCore.QUrl]: ...
    def setSidebarUrls(self, urls: typing.Iterable[QtCore.QUrl]) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def accept(self) -> None: ...
    def done(self, result: int) -> None: ...
    @staticmethod
    def getSaveFileName(parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ..., initialFilter: str = ..., options: typing.Union[int, int] = ...) -> typing.Tuple[str, str]: ...
    @staticmethod
    def getOpenFileNames(parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ..., initialFilter: str = ..., options: typing.Union[int, int] = ...) -> typing.Tuple[typing.List[str], str]: ...
    @staticmethod
    def getOpenFileName(parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ..., initialFilter: str = ..., options: typing.Union[int, int] = ...) -> typing.Tuple[str, str]: ...
    @staticmethod
    def getExistingDirectoryUrl(parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: QtCore.QUrl = ..., options: typing.Union[int, int] = ..., supportedSchemes: typing.Iterable[str] = ...) -> QtCore.QUrl: ...
    @staticmethod
    def getExistingDirectory(parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., options: typing.Union[int, int] = ...) -> str: ...
    #def fileSelected(self, file: str) -> None: ...
    #def filterSelected(self, filter: str) -> None: ...
    #def filesSelected(self, files: typing.Iterable[str]) -> None: ...
    #def directoryEntered(self, directory: str) -> None: ...
    #def currentChanged(self, path: str) -> None: ...
    def labelText(self, label: int) -> str: ...
    def setLabelText(self, label: int, text: str) -> None: ...
    def iconProvider(self) -> QFileIconProvider: ...
    def setIconProvider(self, provider: QFileIconProvider) -> None: ...
    def itemDelegate(self) -> QAbstractItemDelegate: ...
    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None: ...
    def history(self) -> typing.List[str]: ...
    def setHistory(self, paths: typing.Iterable[str]) -> None: ...
    def defaultSuffix(self) -> str: ...
    def setDefaultSuffix(self, suffix: str) -> None: ...
    def acceptMode(self) -> int: ...
    def setAcceptMode(self, mode: int) -> None: ...
    def fileMode(self) -> int: ...
    def setFileMode(self, mode: int) -> None: ...
    def viewMode(self) -> int: ...
    def setViewMode(self, mode: int) -> None: ...
    def selectedFiles(self) -> typing.List[str]: ...
    def selectFile(self, filename: str) -> None: ...
    def directory(self) -> QtCore.QDir: ...
    @overload
    def setDirectory(self, directory: str) -> None: ...
    @overload
    def setDirectory(self, adirectory: QtCore.QDir) -> None: ...


class QFileIconProvider(sip.simplewrapper):

    class Option(int):
        DontUseCustomDirectoryIcons = ... # type: QFileIconProvider.Option

    class IconType(int):
        Computer = ... # type: QFileIconProvider.IconType
        Desktop = ... # type: QFileIconProvider.IconType
        Trashcan = ... # type: QFileIconProvider.IconType
        Network = ... # type: QFileIconProvider.IconType
        Drive = ... # type: QFileIconProvider.IconType
        Folder = ... # type: QFileIconProvider.IconType
        File = ... # type: QFileIconProvider.IconType

    Options: typing.Type[int]
    #class Options(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QFileIconProvider.Options, QFileIconProvider.Option]) -> None: ...
        #@overload
        #def __init__(self, a0: QFileIconProvider.Options) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QFileIconProvider.Options: ...
        #def __int__(self) -> int: ...

    def __init__(self) -> None: ...

    def options(self) -> int: ...
    def setOptions(self, options: typing.Union[int, int]) -> None: ...
    def type(self, info: QtCore.QFileInfo) -> str: ...
    @overload
    def icon(self, type: int) -> QtGui.QIcon: ...
    @overload
    def icon(self, info: QtCore.QFileInfo) -> QtGui.QIcon: ...


class QFileSystemModel(QtCore.QAbstractItemModel):

    directoryLoaded: PYQT_SIGNAL
    fileRenamed: PYQT_SIGNAL
    rootPathChanged: PYQT_SIGNAL

    Roles: typing.Type[int]
    #class Roles(int): ...
    FileIconRole = ... # type: int
    FilePathRole = ... # type: int
    FileNameRole = ... # type: int
    FilePermissions = ... # type: int

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def sibling(self, row: int, column: int, idx: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def timerEvent(self, event: QtCore.QTimerEvent) -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    #def directoryLoaded(self, path: str) -> None: ...
    #def rootPathChanged(self, newPath: str) -> None: ...
    #def fileRenamed(self, path: str, oldName: str, newName: str) -> None: ...
    def remove(self, index: QtCore.QModelIndex) -> bool: ...
    def fileInfo(self, aindex: QtCore.QModelIndex) -> QtCore.QFileInfo: ...
    def fileIcon(self, aindex: QtCore.QModelIndex) -> QtGui.QIcon: ...
    def fileName(self, aindex: QtCore.QModelIndex) -> str: ...
    def rmdir(self, index: QtCore.QModelIndex) -> bool: ...
    def permissions(self, index: QtCore.QModelIndex) -> int: ...
    def mkdir(self, parent: QtCore.QModelIndex, name: str) -> QtCore.QModelIndex: ...
    def lastModified(self, index: QtCore.QModelIndex) -> QtCore.QDateTime: ...
    def type(self, index: QtCore.QModelIndex) -> str: ...
    def size(self, index: QtCore.QModelIndex) -> int: ...
    def isDir(self, index: QtCore.QModelIndex) -> bool: ...
    def filePath(self, index: QtCore.QModelIndex) -> str: ...
    def nameFilters(self) -> typing.List[str]: ...
    def setNameFilters(self, filters: typing.Iterable[str]) -> None: ...
    def nameFilterDisables(self) -> bool: ...
    def setNameFilterDisables(self, enable: bool) -> None: ...
    def isReadOnly(self) -> bool: ...
    def setReadOnly(self, enable: bool) -> None: ...
    def resolveSymlinks(self) -> bool: ...
    def setResolveSymlinks(self, enable: bool) -> None: ...
    def filter(self) -> int: ...
    def setFilter(self, filters: typing.Union[int, int]) -> None: ...
    def iconProvider(self) -> QFileIconProvider: ...
    def setIconProvider(self, provider: QFileIconProvider) -> None: ...
    def rootDirectory(self) -> QtCore.QDir: ...
    def rootPath(self) -> str: ...
    def setRootPath(self, path: str) -> QtCore.QModelIndex: ...
    def supportedDropActions(self) -> int: ...
    def dropMimeData(self, data: QtCore.QMimeData, action: int, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: typing.Iterable[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def sort(self, column: int, order: int = ...) -> None: ...
    def flags(self, index: QtCore.QModelIndex) -> int: ...
    def headerData(self, section: int, orientation: int, role: int = ...) -> typing.Any: ...
    def setData(self, idx: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def myComputer(self, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def fetchMore(self, parent: QtCore.QModelIndex) -> None: ...
    def canFetchMore(self, parent: QtCore.QModelIndex) -> bool: ...
    def hasChildren(self, parent: QtCore.QModelIndex = ...) -> bool: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    @overload
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    @overload
    def index(self, path: str, column: int = ...) -> QtCore.QModelIndex: ...


class QFocusFrame(QWidget):

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: QStyleOption) -> None: ...
    def widget(self) -> QWidget: ...
    def setWidget(self, widget: QWidget) -> None: ...


class QFontComboBox(QComboBox):

    currentFontChanged: PYQT_SIGNAL

    FontFilter: typing.Type[int]
    #class FontFilter(int): ...
    AllFonts = ... # type: int
    ScalableFonts = ... # type: int
    NonScalableFonts = ... # type: int
    MonospacedFonts = ... # type: int
    ProportionalFonts = ... # type: int

    FontFilters: typing.Type[int]
    #class FontFilters(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QFontComboBox.FontFilters, QFontComboBox.FontFilter]) -> None: ...
        #@overload
        #def __init__(self, a0: QFontComboBox.FontFilters) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QFontComboBox.FontFilters: ...
        #def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def event(self, e: QtCore.QEvent) -> bool: ...
    #def currentFontChanged(self, f: QtGui.QFont) -> None: ...
    def setCurrentFont(self, f: QtGui.QFont) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def currentFont(self) -> QtGui.QFont: ...
    def setFontFilters(self, filters: typing.Union[int, int]) -> None: ...
    def writingSystem(self) -> int: ...
    def setWritingSystem(self, a0: int) -> None: ...
    def fontFilters(self) -> int: ...


class QFontDialog(QDialog):

    currentFontChanged: PYQT_SIGNAL
    fontSelected: PYQT_SIGNAL

    FontDialogOption: typing.Type[int]
    #class FontDialogOption(int): ...
    NoButtons = ... # type: int
    DontUseNativeDialog = ... # type: int
    ScalableFonts = ... # type: int
    NonScalableFonts = ... # type: int
    MonospacedFonts = ... # type: int
    ProportionalFonts = ... # type: int

    FontDialogOptions: typing.Type[int]
    #class FontDialogOptions(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QFontDialog.FontDialogOptions, QFontDialog.FontDialogOption]) -> None: ...
        #@overload
        #def __init__(self, a0: QFontDialog.FontDialogOptions) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QFontDialog.FontDialogOptions: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, initial: QtGui.QFont, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    #def fontSelected(self, font: QtGui.QFont) -> None: ...
    #def currentFontChanged(self, font: QtGui.QFont) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    @overload
    def open(self) -> None: ...
    @overload
    def open(self, slot: PYQT_SLOT) -> None: ...
    def options(self) -> int: ...
    def setOptions(self, options: typing.Union[int, int]) -> None: ...
    def testOption(self, option: int) -> bool: ...
    def setOption(self, option: int, on: bool = ...) -> None: ...
    def selectedFont(self) -> QtGui.QFont: ...
    def currentFont(self) -> QtGui.QFont: ...
    def setCurrentFont(self, font: QtGui.QFont) -> None: ...
    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def done(self, result: int) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    @overload
    @staticmethod
    def getFont(initial: QtGui.QFont, parent: typing.Optional[QWidget] = ..., caption: str = ..., options: typing.Union[int, int] = ...) -> typing.Tuple[QtGui.QFont, bool]: ...
    @overload
    @staticmethod
    def getFont(parent: typing.Optional[QWidget] = ...) -> typing.Tuple[QtGui.QFont, bool]: ...


class QFormLayout(QLayout):

    class ItemRole(int):
        LabelRole = ... # type: QFormLayout.ItemRole
        FieldRole = ... # type: QFormLayout.ItemRole
        SpanningRole = ... # type: QFormLayout.ItemRole

    class RowWrapPolicy(int):
        DontWrapRows = ... # type: QFormLayout.RowWrapPolicy
        WrapLongRows = ... # type: QFormLayout.RowWrapPolicy
        WrapAllRows = ... # type: QFormLayout.RowWrapPolicy

    class FieldGrowthPolicy(int):
        FieldsStayAtSizeHint = ... # type: QFormLayout.FieldGrowthPolicy
        ExpandingFieldsGrow = ... # type: QFormLayout.FieldGrowthPolicy
        AllNonFixedFieldsGrow = ... # type: QFormLayout.FieldGrowthPolicy

    class TakeRowResult:

        fieldItem = ... # type: QLayoutItem
        labelItem = ... # type: QLayoutItem

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QFormLayout.TakeRowResult) -> None: ...

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    @overload
    def takeRow(self, row: int) -> QFormLayout.TakeRowResult: ...
    @overload
    def takeRow(self, widget: QWidget) -> QFormLayout.TakeRowResult: ...
    @overload
    def takeRow(self, layout: QLayout) -> QFormLayout.TakeRowResult: ...
    @overload
    def removeRow(self, row: int) -> None: ...
    @overload
    def removeRow(self, widget: QWidget) -> None: ...
    @overload
    def removeRow(self, layout: QLayout) -> None: ...
    def rowCount(self) -> int: ...
    def count(self) -> int: ...
    def expandingDirections(self) -> int: ...
    def heightForWidth(self, width: int) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def invalidate(self) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def setGeometry(self, rect: QtCore.QRect) -> None: ...
    def takeAt(self, index: int) -> QLayoutItem: ...
    def addItem(self, item: QLayoutItem) -> None: ...
    @overload
    def labelForField(self, field: QWidget) -> QWidget: ...
    @overload
    def labelForField(self, field: QLayout) -> QWidget: ...
    def getLayoutPosition(self, layout: QLayout) -> typing.Tuple[int, int]: ...
    def getWidgetPosition(self, widget: QWidget) -> typing.Tuple[int, int]: ...
    def getItemPosition(self, index: int) -> typing.Tuple[int, int]: ...
    @overload
    def itemAt(self, row: int, role: int) -> QLayoutItem: ...
    @overload
    def itemAt(self, index: int) -> QLayoutItem: ...
    def setLayout(self, row: int, role: int, layout: QLayout) -> None: ...
    def setWidget(self, row: int, role: int, widget: QWidget) -> None: ...
    def setItem(self, row: int, role: int, item: QLayoutItem) -> None: ...
    @overload
    def insertRow(self, row: int, label: QWidget, field: QWidget) -> None: ...
    @overload
    def insertRow(self, row: int, label: QWidget, field: QLayout) -> None: ...
    @overload
    def insertRow(self, row: int, labelText: str, field: QWidget) -> None: ...
    @overload
    def insertRow(self, row: int, labelText: str, field: QLayout) -> None: ...
    @overload
    def insertRow(self, row: int, widget: QWidget) -> None: ...
    @overload
    def insertRow(self, row: int, layout: QLayout) -> None: ...
    @overload
    def addRow(self, label: QWidget, field: QWidget) -> None: ...
    @overload
    def addRow(self, label: QWidget, field: QLayout) -> None: ...
    @overload
    def addRow(self, labelText: str, field: QWidget) -> None: ...
    @overload
    def addRow(self, labelText: str, field: QLayout) -> None: ...
    @overload
    def addRow(self, widget: QWidget) -> None: ...
    @overload
    def addRow(self, layout: QLayout) -> None: ...
    def setSpacing(self, a0: int) -> None: ...
    def spacing(self) -> int: ...
    def verticalSpacing(self) -> int: ...
    def setVerticalSpacing(self, spacing: int) -> None: ...
    def horizontalSpacing(self) -> int: ...
    def setHorizontalSpacing(self, spacing: int) -> None: ...
    def formAlignment(self) -> int: ...
    def setFormAlignment(self, alignment: typing.Union[int, int]) -> None: ...
    def labelAlignment(self) -> int: ...
    def setLabelAlignment(self, alignment: typing.Union[int, int]) -> None: ...
    def rowWrapPolicy(self) -> int: ...
    def setRowWrapPolicy(self, policy: int) -> None: ...
    def fieldGrowthPolicy(self) -> int: ...
    def setFieldGrowthPolicy(self, policy: int) -> None: ...


class QGesture(QtCore.QObject):

    GestureCancelPolicy: typing.Type[int]
    #class GestureCancelPolicy(int): ...
    CancelNone = ... # type: int
    CancelAllInContext = ... # type: int

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def gestureCancelPolicy(self) -> int: ...
    def setGestureCancelPolicy(self, policy: int) -> None: ...
    def unsetHotSpot(self) -> None: ...
    def hasHotSpot(self) -> bool: ...
    def setHotSpot(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def hotSpot(self) -> QtCore.QPointF: ...
    def state(self) -> int: ...
    def gestureType(self) -> int: ...


class QPanGesture(QGesture):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def setAcceleration(self, value: float) -> None: ...
    def setOffset(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setLastOffset(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def acceleration(self) -> float: ...
    def delta(self) -> QtCore.QPointF: ...
    def offset(self) -> QtCore.QPointF: ...
    def lastOffset(self) -> QtCore.QPointF: ...


class QPinchGesture(QGesture):

    ChangeFlag: typing.Type[int]
    #class ChangeFlag(int): ...
    ScaleFactorChanged = ... # type: int
    RotationAngleChanged = ... # type: int
    CenterPointChanged = ... # type: int

    ChangeFlags: typing.Type[int]
    #class ChangeFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QPinchGesture.ChangeFlags, QPinchGesture.ChangeFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QPinchGesture.ChangeFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QPinchGesture.ChangeFlags: ...
        #def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def setRotationAngle(self, value: float) -> None: ...
    def setLastRotationAngle(self, value: float) -> None: ...
    def setTotalRotationAngle(self, value: float) -> None: ...
    def rotationAngle(self) -> float: ...
    def lastRotationAngle(self) -> float: ...
    def totalRotationAngle(self) -> float: ...
    def setScaleFactor(self, value: float) -> None: ...
    def setLastScaleFactor(self, value: float) -> None: ...
    def setTotalScaleFactor(self, value: float) -> None: ...
    def scaleFactor(self) -> float: ...
    def lastScaleFactor(self) -> float: ...
    def totalScaleFactor(self) -> float: ...
    def setCenterPoint(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setLastCenterPoint(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setStartCenterPoint(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def centerPoint(self) -> QtCore.QPointF: ...
    def lastCenterPoint(self) -> QtCore.QPointF: ...
    def startCenterPoint(self) -> QtCore.QPointF: ...
    def setChangeFlags(self, value: typing.Union[int, int]) -> None: ...
    def changeFlags(self) -> int: ...
    def setTotalChangeFlags(self, value: typing.Union[int, int]) -> None: ...
    def totalChangeFlags(self) -> int: ...


class QSwipeGesture(QGesture):

    SwipeDirection: typing.Type[int]
    #class SwipeDirection(int): ...
    NoDirection = ... # type: int
    Left = ... # type: int
    Right = ... # type: int
    Up = ... # type: int
    Down = ... # type: int

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def setSwipeAngle(self, value: float) -> None: ...
    def swipeAngle(self) -> float: ...
    def verticalDirection(self) -> int: ...
    def horizontalDirection(self) -> int: ...


class QTapGesture(QGesture):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def setPosition(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def position(self) -> QtCore.QPointF: ...


class QTapAndHoldGesture(QGesture):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    @staticmethod
    def timeout() -> int: ...
    @staticmethod
    def setTimeout(msecs: int) -> None: ...
    def setPosition(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def position(self) -> QtCore.QPointF: ...


class QGestureEvent(QtCore.QEvent):

    @overload
    def __init__(self, gestures: typing.Iterable[QGesture]) -> None: ...
    @overload
    def __init__(self, a0: QGestureEvent) -> None: ...

    def mapToGraphicsScene(self, gesturePoint: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    def widget(self) -> QWidget: ...
    @overload
    def ignore(self) -> None: ...
    @overload
    def ignore(self, a0: QGesture) -> None: ...
    @overload
    def ignore(self, a0: int) -> None: ...
    @overload
    def accept(self) -> None: ...
    @overload
    def accept(self, a0: QGesture) -> None: ...
    @overload
    def accept(self, a0: int) -> None: ...
    @overload
    def isAccepted(self) -> bool: ...
    @overload
    def isAccepted(self, a0: QGesture) -> bool: ...
    @overload
    def isAccepted(self, a0: int) -> bool: ...
    @overload
    def setAccepted(self, accepted: bool) -> None: ...
    @overload
    def setAccepted(self, a0: QGesture, a1: bool) -> None: ...
    @overload
    def setAccepted(self, a0: int, a1: bool) -> None: ...
    def canceledGestures(self) -> typing.List[QGesture]: ...
    def activeGestures(self) -> typing.List[QGesture]: ...
    def gesture(self, type: int) -> QGesture: ...
    def gestures(self) -> typing.List[QGesture]: ...


class QGestureRecognizer(sip.wrapper):

    ResultFlag: typing.Type[int]
    #class ResultFlag(int): ...
    Ignore = ... # type: int
    MayBeGesture = ... # type: int
    TriggerGesture = ... # type: int
    FinishGesture = ... # type: int
    CancelGesture = ... # type: int
    ConsumeEventHint = ... # type: int

    Result: typing.Type[int]
    #class Result(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QGestureRecognizer.Result, QGestureRecognizer.ResultFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QGestureRecognizer.Result) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QGestureRecognizer.Result: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QGestureRecognizer) -> None: ...

    @staticmethod
    def unregisterRecognizer(type: int) -> None: ...
    @staticmethod
    def registerRecognizer(recognizer: QGestureRecognizer) -> int: ...
    def reset(self, state: QGesture) -> None: ...
    def recognize(self, state: QGesture, watched: QtCore.QObject, event: QtCore.QEvent) -> int: ...
    def create(self, target: QtCore.QObject) -> QGesture: ...


class QGraphicsAnchor(QtCore.QObject):

    def sizePolicy(self) -> int: ...
    def setSizePolicy(self, policy: int) -> None: ...
    def spacing(self) -> float: ...
    def unsetSpacing(self) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...


class QGraphicsLayoutItem(sip.wrapper):

    def __init__(self, parent: typing.Optional[QGraphicsLayoutItem] = ..., isLayout: bool = ...) -> None: ...

    def setOwnedByLayout(self, ownedByLayout: bool) -> None: ...
    def setGraphicsItem(self, item: QGraphicsItem) -> None: ...
    def sizeHint(self, which: int, constraint: QtCore.QSizeF = ...) -> QtCore.QSizeF: ...
    def ownedByLayout(self) -> bool: ...
    def graphicsItem(self) -> QGraphicsItem: ...
    def maximumHeight(self) -> float: ...
    def maximumWidth(self) -> float: ...
    def preferredHeight(self) -> float: ...
    def preferredWidth(self) -> float: ...
    def minimumHeight(self) -> float: ...
    def minimumWidth(self) -> float: ...
    def isLayout(self) -> bool: ...
    def setParentLayoutItem(self, parent: QGraphicsLayoutItem) -> None: ...
    def parentLayoutItem(self) -> QGraphicsLayoutItem: ...
    def updateGeometry(self) -> None: ...
    def effectiveSizeHint(self, which: int, constraint: QtCore.QSizeF = ...) -> QtCore.QSizeF: ...
    def contentsRect(self) -> QtCore.QRectF: ...
    def getContentsMargins(self) -> typing.Tuple[float, float, float, float]: ...
    def geometry(self) -> QtCore.QRectF: ...
    def setGeometry(self, rect: QtCore.QRectF) -> None: ...
    def setMaximumHeight(self, height: float) -> None: ...
    def setMaximumWidth(self, width: float) -> None: ...
    def maximumSize(self) -> QtCore.QSizeF: ...
    @overload
    def setMaximumSize(self, size: QtCore.QSizeF) -> None: ...
    @overload
    def setMaximumSize(self, aw: float, ah: float) -> None: ...
    def setPreferredHeight(self, height: float) -> None: ...
    def setPreferredWidth(self, width: float) -> None: ...
    def preferredSize(self) -> QtCore.QSizeF: ...
    @overload
    def setPreferredSize(self, size: QtCore.QSizeF) -> None: ...
    @overload
    def setPreferredSize(self, aw: float, ah: float) -> None: ...
    def setMinimumHeight(self, height: float) -> None: ...
    def setMinimumWidth(self, width: float) -> None: ...
    def minimumSize(self) -> QtCore.QSizeF: ...
    @overload
    def setMinimumSize(self, size: QtCore.QSizeF) -> None: ...
    @overload
    def setMinimumSize(self, aw: float, ah: float) -> None: ...
    def sizePolicy(self) -> QSizePolicy: ...
    @overload
    def setSizePolicy(self, policy: QSizePolicy) -> None: ...
    @overload
    def setSizePolicy(self, hPolicy: int, vPolicy: int, controlType: int = ...) -> None: ...


class QGraphicsLayout(QGraphicsLayoutItem):

    def __init__(self, parent: typing.Optional[QGraphicsLayoutItem] = ...) -> None: ...

    def addChildLayoutItem(self, layoutItem: QGraphicsLayoutItem) -> None: ...
    def updateGeometry(self) -> None: ...
    def removeAt(self, index: int) -> None: ...
    def itemAt(self, i: int) -> QGraphicsLayoutItem: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def widgetEvent(self, e: QtCore.QEvent) -> None: ...
    def invalidate(self) -> None: ...
    def isActivated(self) -> bool: ...
    def activate(self) -> None: ...
    def getContentsMargins(self) -> typing.Tuple[float, float, float, float]: ...
    def setContentsMargins(self, left: float, top: float, right: float, bottom: float) -> None: ...


class QGraphicsAnchorLayout(QGraphicsLayout):

    def __init__(self, parent: typing.Optional[QGraphicsLayoutItem] = ...) -> None: ...

    def sizeHint(self, which: int, constraint: QtCore.QSizeF = ...) -> QtCore.QSizeF: ...
    def invalidate(self) -> None: ...
    def itemAt(self, index: int) -> QGraphicsLayoutItem: ...
    def count(self) -> int: ...
    def setGeometry(self, rect: QtCore.QRectF) -> None: ...
    def removeAt(self, index: int) -> None: ...
    def verticalSpacing(self) -> float: ...
    def horizontalSpacing(self) -> float: ...
    def setSpacing(self, spacing: float) -> None: ...
    def setVerticalSpacing(self, spacing: float) -> None: ...
    def setHorizontalSpacing(self, spacing: float) -> None: ...
    def addAnchors(self, firstItem: QGraphicsLayoutItem, secondItem: QGraphicsLayoutItem, orientations: typing.Union[int, int] = ...) -> None: ...
    def addCornerAnchors(self, firstItem: QGraphicsLayoutItem, firstCorner: int, secondItem: QGraphicsLayoutItem, secondCorner: int) -> None: ...
    def anchor(self, firstItem: QGraphicsLayoutItem, firstEdge: int, secondItem: QGraphicsLayoutItem, secondEdge: int) -> QGraphicsAnchor: ...
    def addAnchor(self, firstItem: QGraphicsLayoutItem, firstEdge: int, secondItem: QGraphicsLayoutItem, secondEdge: int) -> QGraphicsAnchor: ...


class QGraphicsEffect(QtCore.QObject):

    enabledChanged: PYQT_SIGNAL

    PixmapPadMode: typing.Type[int]
    #class PixmapPadMode(int): ...
    NoPad = ... # type: int
    PadToTransparentBorder = ... # type: int
    PadToEffectiveBoundingRect = ... # type: int

    ChangeFlag: typing.Type[int]
    #class ChangeFlag(int): ...
    SourceAttached = ... # type: int
    SourceDetached = ... # type: int
    SourceBoundingRectChanged = ... # type: int
    SourceInvalidated = ... # type: int

    ChangeFlags: typing.Type[int]
    #class ChangeFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QGraphicsEffect.ChangeFlags, QGraphicsEffect.ChangeFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QGraphicsEffect.ChangeFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QGraphicsEffect.ChangeFlags: ...
        #def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def sourcePixmap(self, system: int = ..., mode: int = ...) -> typing.Tuple[QtGui.QPixmap, QtCore.QPoint]: ...
    def drawSource(self, painter: QtGui.QPainter) -> None: ...
    def sourceBoundingRect(self, system: int = ...) -> QtCore.QRectF: ...
    def sourceIsPixmap(self) -> bool: ...
    def updateBoundingRect(self) -> None: ...
    def sourceChanged(self, flags: typing.Union[int, int]) -> None: ...
    def draw(self, painter: QtGui.QPainter) -> None: ...
    #def enabledChanged(self, enabled: bool) -> None: ...
    def update(self) -> None: ...
    def setEnabled(self, enable: bool) -> None: ...
    def isEnabled(self) -> bool: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def boundingRectFor(self, sourceRect: QtCore.QRectF) -> QtCore.QRectF: ...


class QGraphicsColorizeEffect(QGraphicsEffect):

    colorChanged: PYQT_SIGNAL
    strengthChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def draw(self, painter: QtGui.QPainter) -> None: ...
    #def strengthChanged(self, strength: float) -> None: ...
    #def colorChanged(self, color: typing.Union[QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def setStrength(self, strength: float) -> None: ...
    def setColor(self, c: typing.Union[QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def strength(self) -> float: ...
    def color(self) -> QtGui.QColor: ...


class QGraphicsBlurEffect(QGraphicsEffect):

    blurHintsChanged: PYQT_SIGNAL
    blurRadiusChanged: PYQT_SIGNAL

    BlurHint: typing.Type[int]
    #class BlurHint(int): ...
    PerformanceHint = ... # type: int
    QualityHint = ... # type: int
    AnimationHint = ... # type: int

    BlurHints: typing.Type[int]
    #class BlurHints(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QGraphicsBlurEffect.BlurHints, QGraphicsBlurEffect.BlurHint]) -> None: ...
        #@overload
        #def __init__(self, a0: QGraphicsBlurEffect.BlurHints) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QGraphicsBlurEffect.BlurHints: ...
        #def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def draw(self, painter: QtGui.QPainter) -> None: ...
    #def blurHintsChanged(self, hints: typing.Union[int, int]) -> None: ...
    #def blurRadiusChanged(self, blurRadius: float) -> None: ...
    def setBlurHints(self, hints: typing.Union[int, int]) -> None: ...
    def setBlurRadius(self, blurRadius: float) -> None: ...
    def blurHints(self) -> int: ...
    def blurRadius(self) -> float: ...
    def boundingRectFor(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...


class QGraphicsDropShadowEffect(QGraphicsEffect):

    blurRadiusChanged: PYQT_SIGNAL
    colorChanged: PYQT_SIGNAL
    offsetChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def draw(self, painter: QtGui.QPainter) -> None: ...
    #def colorChanged(self, color: typing.Union[QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    #def blurRadiusChanged(self, blurRadius: float) -> None: ...
    #def offsetChanged(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setColor(self, color: typing.Union[QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def setBlurRadius(self, blurRadius: float) -> None: ...
    def setYOffset(self, dy: float) -> None: ...
    def setXOffset(self, dx: float) -> None: ...
    @overload
    def setOffset(self, ofs: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def setOffset(self, dx: float, dy: float) -> None: ...
    @overload
    def setOffset(self, d: float) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def blurRadius(self) -> float: ...
    def yOffset(self) -> float: ...
    def xOffset(self) -> float: ...
    def offset(self) -> QtCore.QPointF: ...
    def boundingRectFor(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...


class QGraphicsOpacityEffect(QGraphicsEffect):

    opacityChanged: PYQT_SIGNAL
    opacityMaskChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def draw(self, painter: QtGui.QPainter) -> None: ...
    #def opacityMaskChanged(self, mask: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    #def opacityChanged(self, opacity: float) -> None: ...
    def setOpacityMask(self, mask: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...
    def opacityMask(self) -> QtGui.QBrush: ...
    def opacity(self) -> float: ...


class QGraphicsGridLayout(QGraphicsLayout):

    def __init__(self, parent: typing.Optional[QGraphicsLayoutItem] = ...) -> None: ...

    def removeItem(self, item: QGraphicsLayoutItem) -> None: ...
    def sizeHint(self, which: int, constraint: QtCore.QSizeF = ...) -> QtCore.QSizeF: ...
    def setGeometry(self, rect: QtCore.QRectF) -> None: ...
    def invalidate(self) -> None: ...
    def removeAt(self, index: int) -> None: ...
    def count(self) -> int: ...
    @overload
    def itemAt(self, row: int, column: int) -> QGraphicsLayoutItem: ...
    @overload
    def itemAt(self, index: int) -> QGraphicsLayoutItem: ...
    def columnCount(self) -> int: ...
    def rowCount(self) -> int: ...
    def alignment(self, item: QGraphicsLayoutItem) -> int: ...
    def setAlignment(self, item: QGraphicsLayoutItem, alignment: typing.Union[int, int]) -> None: ...
    def columnAlignment(self, column: int) -> int: ...
    def setColumnAlignment(self, column: int, alignment: typing.Union[int, int]) -> None: ...
    def rowAlignment(self, row: int) -> int: ...
    def setRowAlignment(self, row: int, alignment: typing.Union[int, int]) -> None: ...
    def setColumnFixedWidth(self, column: int, width: float) -> None: ...
    def columnMaximumWidth(self, column: int) -> float: ...
    def setColumnMaximumWidth(self, column: int, width: float) -> None: ...
    def columnPreferredWidth(self, column: int) -> float: ...
    def setColumnPreferredWidth(self, column: int, width: float) -> None: ...
    def columnMinimumWidth(self, column: int) -> float: ...
    def setColumnMinimumWidth(self, column: int, width: float) -> None: ...
    def setRowFixedHeight(self, row: int, height: float) -> None: ...
    def rowMaximumHeight(self, row: int) -> float: ...
    def setRowMaximumHeight(self, row: int, height: float) -> None: ...
    def rowPreferredHeight(self, row: int) -> float: ...
    def setRowPreferredHeight(self, row: int, height: float) -> None: ...
    def rowMinimumHeight(self, row: int) -> float: ...
    def setRowMinimumHeight(self, row: int, height: float) -> None: ...
    def columnStretchFactor(self, column: int) -> int: ...
    def setColumnStretchFactor(self, column: int, stretch: int) -> None: ...
    def rowStretchFactor(self, row: int) -> int: ...
    def setRowStretchFactor(self, row: int, stretch: int) -> None: ...
    def columnSpacing(self, column: int) -> float: ...
    def setColumnSpacing(self, column: int, spacing: float) -> None: ...
    def rowSpacing(self, row: int) -> float: ...
    def setRowSpacing(self, row: int, spacing: float) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def verticalSpacing(self) -> float: ...
    def setVerticalSpacing(self, spacing: float) -> None: ...
    def horizontalSpacing(self) -> float: ...
    def setHorizontalSpacing(self, spacing: float) -> None: ...
    @overload
    def addItem(self, item: QGraphicsLayoutItem, row: int, column: int, rowSpan: int, columnSpan: int, alignment: typing.Union[int, int] = ...) -> None: ...
    @overload
    def addItem(self, item: QGraphicsLayoutItem, row: int, column: int, alignment: typing.Union[int, int] = ...) -> None: ...


class QGraphicsItem(sip.wrapper):

    PanelModality: typing.Type[int]
    #class PanelModality(int): ...
    NonModal = ... # type: int
    PanelModal = ... # type: int
    SceneModal = ... # type: int

    GraphicsItemFlag: typing.Type[int]
    #class GraphicsItemFlag(int): ...
    ItemIsMovable = ... # type: int
    ItemIsSelectable = ... # type: int
    ItemIsFocusable = ... # type: int
    ItemClipsToShape = ... # type: int
    ItemClipsChildrenToShape = ... # type: int
    ItemIgnoresTransformations = ... # type: int
    ItemIgnoresParentOpacity = ... # type: int
    ItemDoesntPropagateOpacityToChildren = ... # type: int
    ItemStacksBehindParent = ... # type: int
    ItemUsesExtendedStyleOption = ... # type: int
    ItemHasNoContents = ... # type: int
    ItemSendsGeometryChanges = ... # type: int
    ItemAcceptsInputMethod = ... # type: int
    ItemNegativeZStacksBehindParent = ... # type: int
    ItemIsPanel = ... # type: int
    ItemSendsScenePositionChanges = ... # type: int
    ItemContainsChildrenInShape = ... # type: int

    GraphicsItemChange: typing.Type[int]
    #class GraphicsItemChange(int): ...
    ItemPositionChange = ... # type: int
    ItemMatrixChange = ... # type: int
    ItemVisibleChange = ... # type: int
    ItemEnabledChange = ... # type: int
    ItemSelectedChange = ... # type: int
    ItemParentChange = ... # type: int
    ItemChildAddedChange = ... # type: int
    ItemChildRemovedChange = ... # type: int
    ItemTransformChange = ... # type: int
    ItemPositionHasChanged = ... # type: int
    ItemTransformHasChanged = ... # type: int
    ItemSceneChange = ... # type: int
    ItemVisibleHasChanged = ... # type: int
    ItemEnabledHasChanged = ... # type: int
    ItemSelectedHasChanged = ... # type: int
    ItemParentHasChanged = ... # type: int
    ItemSceneHasChanged = ... # type: int
    ItemCursorChange = ... # type: int
    ItemCursorHasChanged = ... # type: int
    ItemToolTipChange = ... # type: int
    ItemToolTipHasChanged = ... # type: int
    ItemFlagsChange = ... # type: int
    ItemFlagsHaveChanged = ... # type: int
    ItemZValueChange = ... # type: int
    ItemZValueHasChanged = ... # type: int
    ItemOpacityChange = ... # type: int
    ItemOpacityHasChanged = ... # type: int
    ItemScenePositionHasChanged = ... # type: int
    ItemRotationChange = ... # type: int
    ItemRotationHasChanged = ... # type: int
    ItemScaleChange = ... # type: int
    ItemScaleHasChanged = ... # type: int
    ItemTransformOriginPointChange = ... # type: int
    ItemTransformOriginPointHasChanged = ... # type: int

    CacheMode: typing.Type[int]
    #class CacheMode(int): ...
    NoCache = ... # type: int
    ItemCoordinateCache = ... # type: int
    DeviceCoordinateCache = ... # type: int

    GraphicsItemFlags: typing.Type[int]
    #class GraphicsItemFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QGraphicsItem.GraphicsItemFlags, QGraphicsItem.GraphicsItemFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QGraphicsItem.GraphicsItemFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QGraphicsItem.GraphicsItemFlags: ...
        #def __int__(self) -> int: ...

    Type = ... # type: int
    UserType = ... # type: int

    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...

    def updateMicroFocus(self) -> None: ...
    def setInputMethodHints(self, hints: typing.Union[int, int]) -> None: ...
    def inputMethodHints(self) -> int: ...
    def stackBefore(self, sibling: QGraphicsItem) -> None: ...
    @overload
    def setTransformOriginPoint(self, origin: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def setTransformOriginPoint(self, ax: float, ay: float) -> None: ...
    def transformOriginPoint(self) -> QtCore.QPointF: ...
    def setTransformations(self, transformations: typing.Iterable[QGraphicsTransform]) -> None: ...
    def transformations(self) -> typing.List[QGraphicsTransform]: ...
    def scale(self) -> float: ...
    def setScale(self, scale: float) -> None: ...
    def rotation(self) -> float: ...
    def setRotation(self, angle: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setX(self, x: float) -> None: ...
    def focusItem(self) -> QGraphicsItem: ...
    def setFocusProxy(self, item: QGraphicsItem) -> None: ...
    def focusProxy(self) -> QGraphicsItem: ...
    def setActive(self, active: bool) -> None: ...
    def isActive(self) -> bool: ...
    def setFiltersChildEvents(self, enabled: bool) -> None: ...
    def filtersChildEvents(self) -> bool: ...
    def setAcceptTouchEvents(self, enabled: bool) -> None: ...
    def acceptTouchEvents(self) -> bool: ...
    def setGraphicsEffect(self, effect: QGraphicsEffect) -> None: ...
    def graphicsEffect(self) -> QGraphicsEffect: ...
    def isBlockedByModalPanel(self) -> typing.Tuple[bool, QGraphicsItem]: ...
    def setPanelModality(self, panelModality: int) -> None: ...
    def panelModality(self) -> int: ...
    def toGraphicsObject(self) -> QGraphicsObject: ...
    def isPanel(self) -> bool: ...
    def panel(self) -> QGraphicsItem: ...
    def parentObject(self) -> QGraphicsObject: ...
    @overload
    def mapRectFromScene(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @overload
    def mapRectFromScene(self, ax: float, ay: float, w: float, h: float) -> QtCore.QRectF: ...
    @overload
    def mapRectFromParent(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @overload
    def mapRectFromParent(self, ax: float, ay: float, w: float, h: float) -> QtCore.QRectF: ...
    @overload
    def mapRectFromItem(self, item: QGraphicsItem, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @overload
    def mapRectFromItem(self, item: QGraphicsItem, ax: float, ay: float, w: float, h: float) -> QtCore.QRectF: ...
    @overload
    def mapRectToScene(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @overload
    def mapRectToScene(self, ax: float, ay: float, w: float, h: float) -> QtCore.QRectF: ...
    @overload
    def mapRectToParent(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @overload
    def mapRectToParent(self, ax: float, ay: float, w: float, h: float) -> QtCore.QRectF: ...
    @overload
    def mapRectToItem(self, item: QGraphicsItem, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @overload
    def mapRectToItem(self, item: QGraphicsItem, ax: float, ay: float, w: float, h: float) -> QtCore.QRectF: ...
    def clipPath(self) -> QtGui.QPainterPath: ...
    def isClipped(self) -> bool: ...
    def itemTransform(self, other: QGraphicsItem) -> typing.Tuple[QtGui.QTransform, bool]: ...
    def setOpacity(self, opacity: float) -> None: ...
    def effectiveOpacity(self) -> float: ...
    def opacity(self) -> float: ...
    def isUnderMouse(self) -> bool: ...
    def commonAncestorItem(self, other: QGraphicsItem) -> QGraphicsItem: ...
    def scroll(self, dx: float, dy: float, rect: QtCore.QRectF = ...) -> None: ...
    def setBoundingRegionGranularity(self, granularity: float) -> None: ...
    def boundingRegionGranularity(self) -> float: ...
    def boundingRegion(self, itemToDeviceTransform: QtGui.QTransform) -> QtGui.QRegion: ...
    def ungrabKeyboard(self) -> None: ...
    def grabKeyboard(self) -> None: ...
    def ungrabMouse(self) -> None: ...
    def grabMouse(self) -> None: ...
    def setAcceptHoverEvents(self, enabled: bool) -> None: ...
    def acceptHoverEvents(self) -> bool: ...
    def isVisibleTo(self, parent: QGraphicsItem) -> bool: ...
    def setCacheMode(self, mode: int, logicalCacheSize: QtCore.QSize = ...) -> None: ...
    def cacheMode(self) -> int: ...
    def isWindow(self) -> bool: ...
    def isWidget(self) -> bool: ...
    def childItems(self) -> typing.List[QGraphicsItem]: ...
    def window(self) -> QGraphicsWidget: ...
    def topLevelWidget(self) -> QGraphicsWidget: ...
    def parentWidget(self) -> QGraphicsWidget: ...
    @overload
    def isObscured(self, rect: QtCore.QRectF = ...) -> bool: ...
    @overload
    def isObscured(self, ax: float, ay: float, w: float, h: float) -> bool: ...
    def resetTransform(self) -> None: ...
    def setTransform(self, matrix: QtGui.QTransform, combine: bool = ...) -> None: ...
    def deviceTransform(self, viewportTransform: QtGui.QTransform) -> QtGui.QTransform: ...
    def sceneTransform(self) -> QtGui.QTransform: ...
    def transform(self) -> QtGui.QTransform: ...
    def wheelEvent(self, event: QGraphicsSceneWheelEvent) -> None: ...
    def sceneEventFilter(self, watched: QGraphicsItem, event: QtCore.QEvent) -> bool: ...
    def sceneEvent(self, event: QtCore.QEvent) -> bool: ...
    def prepareGeometryChange(self) -> None: ...
    def mouseReleaseEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def keyReleaseEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def itemChange(self, change: int, value: typing.Any) -> typing.Any: ...
    def inputMethodQuery(self, query: int) -> typing.Any: ...
    def inputMethodEvent(self, event: QtGui.QInputMethodEvent) -> None: ...
    def hoverMoveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def hoverLeaveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def hoverEnterEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def focusOutEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def dropEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragEnterEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def contextMenuEvent(self, event: QGraphicsSceneContextMenuEvent) -> None: ...
    def removeSceneEventFilter(self, filterItem: QGraphicsItem) -> None: ...
    def installSceneEventFilter(self, filterItem: QGraphicsItem) -> None: ...
    def type(self) -> int: ...
    def setData(self, key: int, value: typing.Any) -> None: ...
    def data(self, key: int) -> typing.Any: ...
    def isAncestorOf(self, child: QGraphicsItem) -> bool: ...
    @overload
    def mapFromScene(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @overload
    def mapFromScene(self, rect: QtCore.QRectF) -> QtGui.QPolygonF: ...
    @overload
    def mapFromScene(self, polygon: QtGui.QPolygonF) -> QtGui.QPolygonF: ...
    @overload
    def mapFromScene(self, path: QtGui.QPainterPath) -> QtGui.QPainterPath: ...
    @overload
    def mapFromScene(self, ax: float, ay: float) -> QtCore.QPointF: ...
    @overload
    def mapFromScene(self, ax: float, ay: float, w: float, h: float) -> QtGui.QPolygonF: ...
    @overload
    def mapFromParent(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @overload
    def mapFromParent(self, rect: QtCore.QRectF) -> QtGui.QPolygonF: ...
    @overload
    def mapFromParent(self, polygon: QtGui.QPolygonF) -> QtGui.QPolygonF: ...
    @overload
    def mapFromParent(self, path: QtGui.QPainterPath) -> QtGui.QPainterPath: ...
    @overload
    def mapFromParent(self, ax: float, ay: float) -> QtCore.QPointF: ...
    @overload
    def mapFromParent(self, ax: float, ay: float, w: float, h: float) -> QtGui.QPolygonF: ...
    @overload
    def mapFromItem(self, item: QGraphicsItem, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @overload
    def mapFromItem(self, item: QGraphicsItem, rect: QtCore.QRectF) -> QtGui.QPolygonF: ...
    @overload
    def mapFromItem(self, item: QGraphicsItem, polygon: QtGui.QPolygonF) -> QtGui.QPolygonF: ...
    @overload
    def mapFromItem(self, item: QGraphicsItem, path: QtGui.QPainterPath) -> QtGui.QPainterPath: ...
    @overload
    def mapFromItem(self, item: QGraphicsItem, ax: float, ay: float) -> QtCore.QPointF: ...
    @overload
    def mapFromItem(self, item: QGraphicsItem, ax: float, ay: float, w: float, h: float) -> QtGui.QPolygonF: ...
    @overload
    def mapToScene(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @overload
    def mapToScene(self, rect: QtCore.QRectF) -> QtGui.QPolygonF: ...
    @overload
    def mapToScene(self, polygon: QtGui.QPolygonF) -> QtGui.QPolygonF: ...
    @overload
    def mapToScene(self, path: QtGui.QPainterPath) -> QtGui.QPainterPath: ...
    @overload
    def mapToScene(self, ax: float, ay: float) -> QtCore.QPointF: ...
    @overload
    def mapToScene(self, ax: float, ay: float, w: float, h: float) -> QtGui.QPolygonF: ...
    @overload
    def mapToParent(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @overload
    def mapToParent(self, rect: QtCore.QRectF) -> QtGui.QPolygonF: ...
    @overload
    def mapToParent(self, polygon: QtGui.QPolygonF) -> QtGui.QPolygonF: ...
    @overload
    def mapToParent(self, path: QtGui.QPainterPath) -> QtGui.QPainterPath: ...
    @overload
    def mapToParent(self, ax: float, ay: float) -> QtCore.QPointF: ...
    @overload
    def mapToParent(self, ax: float, ay: float, w: float, h: float) -> QtGui.QPolygonF: ...
    @overload
    def mapToItem(self, item: QGraphicsItem, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @overload
    def mapToItem(self, item: QGraphicsItem, rect: QtCore.QRectF) -> QtGui.QPolygonF: ...
    @overload
    def mapToItem(self, item: QGraphicsItem, polygon: QtGui.QPolygonF) -> QtGui.QPolygonF: ...
    @overload
    def mapToItem(self, item: QGraphicsItem, path: QtGui.QPainterPath) -> QtGui.QPainterPath: ...
    @overload
    def mapToItem(self, item: QGraphicsItem, ax: float, ay: float) -> QtCore.QPointF: ...
    @overload
    def mapToItem(self, item: QGraphicsItem, ax: float, ay: float, w: float, h: float) -> QtGui.QPolygonF: ...
    @overload
    def update(self, rect: QtCore.QRectF = ...) -> None: ...
    @overload
    def update(self, ax: float, ay: float, width: float, height: float) -> None: ...
    def paint(self, painter: QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Optional[QWidget] = ...) -> None: ...
    def opaqueArea(self) -> QtGui.QPainterPath: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def collidingItems(self, mode: int = ...) -> typing.List[QGraphicsItem]: ...
    def collidesWithPath(self, path: QtGui.QPainterPath, mode: int = ...) -> bool: ...
    def collidesWithItem(self, other: QGraphicsItem, mode: int = ...) -> bool: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> QtGui.QPainterPath: ...
    def sceneBoundingRect(self) -> QtCore.QRectF: ...
    def childrenBoundingRect(self) -> QtCore.QRectF: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def setZValue(self, z: float) -> None: ...
    def zValue(self) -> float: ...
    def advance(self, phase: int) -> None: ...
    @overload
    def ensureVisible(self, rect: QtCore.QRectF = ..., xMargin: int = ..., yMargin: int = ...) -> None: ...
    @overload
    def ensureVisible(self, x: float, y: float, w: float, h: float, xMargin: int = ..., yMargin: int = ...) -> None: ...
    def moveBy(self, dx: float, dy: float) -> None: ...
    @overload
    def setPos(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def setPos(self, ax: float, ay: float) -> None: ...
    def scenePos(self) -> QtCore.QPointF: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def pos(self) -> QtCore.QPointF: ...
    def clearFocus(self) -> None: ...
    def setFocus(self, focusReason: int = ...) -> None: ...
    def hasFocus(self) -> bool: ...
    def setAcceptedMouseButtons(self, buttons: typing.Union[int, int]) -> None: ...
    def acceptedMouseButtons(self) -> int: ...
    def setAcceptDrops(self, on: bool) -> None: ...
    def acceptDrops(self) -> bool: ...
    def setSelected(self, selected: bool) -> None: ...
    def isSelected(self) -> bool: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def isEnabled(self) -> bool: ...
    def show(self) -> None: ...
    def hide(self) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def isVisible(self) -> bool: ...
    def unsetCursor(self) -> None: ...
    def hasCursor(self) -> bool: ...
    def setCursor(self, cursor: typing.Union[QtGui.QCursor, int]) -> None: ...
    def cursor(self) -> QtGui.QCursor: ...
    def setToolTip(self, toolTip: str) -> None: ...
    def toolTip(self) -> str: ...
    def setFlags(self, flags: typing.Union[int, int]) -> None: ...
    def setFlag(self, flag: int, enabled: bool = ...) -> None: ...
    def flags(self) -> int: ...
    def setGroup(self, group: QGraphicsItemGroup) -> None: ...
    def group(self) -> QGraphicsItemGroup: ...
    def setParentItem(self, parent: QGraphicsItem) -> None: ...
    def topLevelItem(self) -> QGraphicsItem: ...
    def parentItem(self) -> QGraphicsItem: ...
    def scene(self) -> QGraphicsScene: ...


class QAbstractGraphicsShapeItem(QGraphicsItem):

    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...

    def opaqueArea(self) -> QtGui.QPainterPath: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def setBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def brush(self) -> QtGui.QBrush: ...
    def setPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def pen(self) -> QtGui.QPen: ...


class QGraphicsPathItem(QAbstractGraphicsShapeItem):

    @overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, path: QtGui.QPainterPath, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...

    def type(self) -> int: ...
    def opaqueArea(self) -> QtGui.QPainterPath: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Optional[QWidget] = ...) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> QtGui.QPainterPath: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def setPath(self, path: QtGui.QPainterPath) -> None: ...
    def path(self) -> QtGui.QPainterPath: ...


class QGraphicsRectItem(QAbstractGraphicsShapeItem):

    @overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, rect: QtCore.QRectF, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, x: float, y: float, w: float, h: float, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...

    def type(self) -> int: ...
    def opaqueArea(self) -> QtGui.QPainterPath: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Optional[QWidget] = ...) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> QtGui.QPainterPath: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    @overload
    def setRect(self, rect: QtCore.QRectF) -> None: ...
    @overload
    def setRect(self, ax: float, ay: float, w: float, h: float) -> None: ...
    def rect(self) -> QtCore.QRectF: ...


class QGraphicsEllipseItem(QAbstractGraphicsShapeItem):

    @overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, rect: QtCore.QRectF, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, x: float, y: float, w: float, h: float, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...

    def type(self) -> int: ...
    def opaqueArea(self) -> QtGui.QPainterPath: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Optional[QWidget] = ...) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> QtGui.QPainterPath: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def setSpanAngle(self, angle: int) -> None: ...
    def spanAngle(self) -> int: ...
    def setStartAngle(self, angle: int) -> None: ...
    def startAngle(self) -> int: ...
    @overload
    def setRect(self, rect: QtCore.QRectF) -> None: ...
    @overload
    def setRect(self, ax: float, ay: float, w: float, h: float) -> None: ...
    def rect(self) -> QtCore.QRectF: ...


class QGraphicsPolygonItem(QAbstractGraphicsShapeItem):

    @overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, polygon: QtGui.QPolygonF, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...

    def type(self) -> int: ...
    def opaqueArea(self) -> QtGui.QPainterPath: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Optional[QWidget] = ...) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> QtGui.QPainterPath: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def setFillRule(self, rule: int) -> None: ...
    def fillRule(self) -> int: ...
    def setPolygon(self, polygon: QtGui.QPolygonF) -> None: ...
    def polygon(self) -> QtGui.QPolygonF: ...


class QGraphicsLineItem(QGraphicsItem):

    @overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, line: QtCore.QLineF, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, x1: float, y1: float, x2: float, y2: float, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...

    def type(self) -> int: ...
    def opaqueArea(self) -> QtGui.QPainterPath: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Optional[QWidget] = ...) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> QtGui.QPainterPath: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    @overload
    def setLine(self, line: QtCore.QLineF) -> None: ...
    @overload
    def setLine(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def line(self) -> QtCore.QLineF: ...
    def setPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def pen(self) -> QtGui.QPen: ...


class QGraphicsPixmapItem(QGraphicsItem):

    ShapeMode: typing.Type[int]
    #class ShapeMode(int): ...
    MaskShape = ... # type: int
    BoundingRectShape = ... # type: int
    HeuristicMaskShape = ... # type: int

    @overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, pixmap: QtGui.QPixmap, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...

    def setShapeMode(self, mode: int) -> None: ...
    def shapeMode(self) -> int: ...
    def type(self) -> int: ...
    def opaqueArea(self) -> QtGui.QPainterPath: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: QWidget) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> QtGui.QPainterPath: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    @overload
    def setOffset(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def setOffset(self, ax: float, ay: float) -> None: ...
    def offset(self) -> QtCore.QPointF: ...
    def setTransformationMode(self, mode: int) -> None: ...
    def transformationMode(self) -> int: ...
    def setPixmap(self, pixmap: QtGui.QPixmap) -> None: ...
    def pixmap(self) -> QtGui.QPixmap: ...


class QGraphicsSimpleTextItem(QAbstractGraphicsShapeItem):

    @overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...

    def type(self) -> int: ...
    def opaqueArea(self) -> QtGui.QPainterPath: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: QWidget) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> QtGui.QPainterPath: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def font(self) -> QtGui.QFont: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def text(self) -> str: ...
    def setText(self, text: str) -> None: ...


class QGraphicsItemGroup(QGraphicsItem):

    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...

    def type(self) -> int: ...
    def opaqueArea(self) -> QtGui.QPainterPath: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Optional[QWidget] = ...) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def removeFromGroup(self, item: QGraphicsItem) -> None: ...
    def addToGroup(self, item: QGraphicsItem) -> None: ...


class QGraphicsObject(QtCore.QObject, QGraphicsItem):

    enabledChanged: PYQT_SIGNAL
    opacityChanged: PYQT_SIGNAL
    parentChanged: PYQT_SIGNAL
    rotationChanged: PYQT_SIGNAL
    scaleChanged: PYQT_SIGNAL
    visibleChanged: PYQT_SIGNAL
    xChanged: PYQT_SIGNAL
    yChanged: PYQT_SIGNAL
    zChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., **props) -> None: ...

    def event(self, ev: QtCore.QEvent) -> bool: ...
    def updateMicroFocus(self) -> None: ...
    #def scaleChanged(self) -> None: ...
    #def rotationChanged(self) -> None: ...
    #def zChanged(self) -> None: ...
    #def yChanged(self) -> None: ...
    #def xChanged(self) -> None: ...
    #def enabledChanged(self) -> None: ...
    #def visibleChanged(self) -> None: ...
    #def opacityChanged(self) -> None: ...
    #def parentChanged(self) -> None: ...
    def ungrabGesture(self, type: int) -> None: ...
    def grabGesture(self, type: int, flags: typing.Union[int, int] = ...) -> None: ...


class QGraphicsTextItem(QGraphicsObject):

    linkActivated: PYQT_SIGNAL
    linkHovered: PYQT_SIGNAL

    @overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., **props) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Optional[QGraphicsItem] = ..., **props) -> None: ...

    def inputMethodQuery(self, query: int) -> typing.Any: ...
    def hoverLeaveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def hoverEnterEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def inputMethodEvent(self, event: QtGui.QInputMethodEvent) -> None: ...
    def dropEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragEnterEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def focusOutEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def keyReleaseEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def contextMenuEvent(self, event: QGraphicsSceneContextMenuEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def sceneEvent(self, event: QtCore.QEvent) -> bool: ...
    #def linkHovered(self, a0: str) -> None: ...
    #def linkActivated(self, a0: str) -> None: ...
    def textCursor(self) -> QtGui.QTextCursor: ...
    def setTextCursor(self, cursor: QtGui.QTextCursor) -> None: ...
    def openExternalLinks(self) -> bool: ...
    def setOpenExternalLinks(self, open: bool) -> None: ...
    def tabChangesFocus(self) -> bool: ...
    def setTabChangesFocus(self, b: bool) -> None: ...
    def textInteractionFlags(self) -> int: ...
    def setTextInteractionFlags(self, flags: typing.Union[int, int]) -> None: ...
    def document(self) -> QtGui.QTextDocument: ...
    def setDocument(self, document: QtGui.QTextDocument) -> None: ...
    def adjustSize(self) -> None: ...
    def textWidth(self) -> float: ...
    def setTextWidth(self, width: float) -> None: ...
    def type(self) -> int: ...
    def opaqueArea(self) -> QtGui.QPainterPath: ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: QWidget) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> QtGui.QPainterPath: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def defaultTextColor(self) -> QtGui.QColor: ...
    def setDefaultTextColor(self, c: typing.Union[QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def setPlainText(self, text: str) -> None: ...
    def toPlainText(self) -> str: ...
    def setHtml(self, html: str) -> None: ...
    def toHtml(self) -> str: ...


class QGraphicsLinearLayout(QGraphicsLayout):

    @overload
    def __init__(self, parent: typing.Optional[QGraphicsLayoutItem] = ...) -> None: ...
    @overload
    def __init__(self, orientation: int, parent: typing.Optional[QGraphicsLayoutItem] = ...) -> None: ...

    def sizeHint(self, which: int, constraint: QtCore.QSizeF = ...) -> QtCore.QSizeF: ...
    def invalidate(self) -> None: ...
    def itemAt(self, index: int) -> QGraphicsLayoutItem: ...
    def count(self) -> int: ...
    def setGeometry(self, rect: QtCore.QRectF) -> None: ...
    def alignment(self, item: QGraphicsLayoutItem) -> int: ...
    def setAlignment(self, item: QGraphicsLayoutItem, alignment: typing.Union[int, int]) -> None: ...
    def stretchFactor(self, item: QGraphicsLayoutItem) -> int: ...
    def setStretchFactor(self, item: QGraphicsLayoutItem, stretch: int) -> None: ...
    def itemSpacing(self, index: int) -> float: ...
    def setItemSpacing(self, index: int, spacing: float) -> None: ...
    def spacing(self) -> float: ...
    def setSpacing(self, spacing: float) -> None: ...
    def removeAt(self, index: int) -> None: ...
    def removeItem(self, item: QGraphicsLayoutItem) -> None: ...
    def insertStretch(self, index: int, stretch: int = ...) -> None: ...
    def insertItem(self, index: int, item: QGraphicsLayoutItem) -> None: ...
    def addStretch(self, stretch: int = ...) -> None: ...
    def addItem(self, item: QGraphicsLayoutItem) -> None: ...
    def orientation(self) -> int: ...
    def setOrientation(self, orientation: int) -> None: ...


class QGraphicsWidget(QGraphicsObject, QGraphicsLayoutItem):

    geometryChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    #def geometryChanged(self) -> None: ...
    def setAutoFillBackground(self, enabled: bool) -> None: ...
    def autoFillBackground(self) -> bool: ...
    def ungrabKeyboardEvent(self, event: QtCore.QEvent) -> None: ...
    def grabKeyboardEvent(self, event: QtCore.QEvent) -> None: ...
    def ungrabMouseEvent(self, event: QtCore.QEvent) -> None: ...
    def grabMouseEvent(self, event: QtCore.QEvent) -> None: ...
    def hoverLeaveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def showEvent(self, event: QtGui.QShowEvent) -> None: ...
    def resizeEvent(self, event: QGraphicsSceneResizeEvent) -> None: ...
    def polishEvent(self) -> None: ...
    def moveEvent(self, event: QGraphicsSceneMoveEvent) -> None: ...
    def hideEvent(self, event: QtGui.QHideEvent) -> None: ...
    def focusOutEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusInEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def closeEvent(self, event: QtGui.QCloseEvent) -> None: ...
    def changeEvent(self, event: QtCore.QEvent) -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def windowFrameSectionAt(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> int: ...
    def windowFrameEvent(self, e: QtCore.QEvent) -> bool: ...
    def sceneEvent(self, event: QtCore.QEvent) -> bool: ...
    def itemChange(self, change: int, value: typing.Any) -> typing.Any: ...
    def updateGeometry(self) -> None: ...
    def sizeHint(self, which: int, constraint: QtCore.QSizeF = ...) -> QtCore.QSizeF: ...
    def initStyleOption(self, option: QStyleOption) -> None: ...
    def close(self) -> bool: ...
    def shape(self) -> QtGui.QPainterPath: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def paintWindowFrame(self, painter: QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Optional[QWidget] = ...) -> None: ...
    def paint(self, painter: QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: typing.Optional[QWidget] = ...) -> None: ...
    def type(self) -> int: ...
    def testAttribute(self, attribute: int) -> bool: ...
    def setAttribute(self, attribute: int, on: bool = ...) -> None: ...
    def actions(self) -> typing.List[QAction]: ...
    def removeAction(self, action: QAction) -> None: ...
    def insertActions(self, before: QAction, actions: typing.Iterable[QAction]) -> None: ...
    def insertAction(self, before: QAction, action: QAction) -> None: ...
    def addActions(self, actions: typing.Iterable[QAction]) -> None: ...
    def addAction(self, action: QAction) -> None: ...
    def setShortcutAutoRepeat(self, id: int, enabled: bool = ...) -> None: ...
    def setShortcutEnabled(self, id: int, enabled: bool = ...) -> None: ...
    def releaseShortcut(self, id: int) -> None: ...
    def grabShortcut(self, sequence: typing.Union[QtGui.QKeySequence, int, str, int], context: int = ...) -> int: ...
    def focusWidget(self) -> QGraphicsWidget: ...
    @staticmethod
    def setTabOrder(first: QGraphicsWidget, second: QGraphicsWidget) -> None: ...
    def setFocusPolicy(self, policy: int) -> None: ...
    def focusPolicy(self) -> int: ...
    def windowTitle(self) -> str: ...
    def setWindowTitle(self, title: str) -> None: ...
    def isActiveWindow(self) -> bool: ...
    def setWindowFlags(self, wFlags: typing.Union[int, int]) -> None: ...
    def windowType(self) -> int: ...
    def windowFlags(self) -> int: ...
    def windowFrameRect(self) -> QtCore.QRectF: ...
    def windowFrameGeometry(self) -> QtCore.QRectF: ...
    def unsetWindowFrameMargins(self) -> None: ...
    def getWindowFrameMargins(self) -> typing.Tuple[float, float, float, float]: ...
    def setWindowFrameMargins(self, left: float, top: float, right: float, bottom: float) -> None: ...
    def getContentsMargins(self) -> typing.Tuple[float, float, float, float]: ...
    def setContentsMargins(self, left: float, top: float, right: float, bottom: float) -> None: ...
    def rect(self) -> QtCore.QRectF: ...
    @overload
    def setGeometry(self, rect: QtCore.QRectF) -> None: ...
    @overload
    def setGeometry(self, ax: float, ay: float, aw: float, ah: float) -> None: ...
    def size(self) -> QtCore.QSizeF: ...
    @overload
    def resize(self, size: QtCore.QSizeF) -> None: ...
    @overload
    def resize(self, w: float, h: float) -> None: ...
    def setPalette(self, palette: QtGui.QPalette) -> None: ...
    def palette(self) -> QtGui.QPalette: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def setStyle(self, style: QStyle) -> None: ...
    def style(self) -> QStyle: ...
    def unsetLayoutDirection(self) -> None: ...
    def setLayoutDirection(self, direction: int) -> None: ...
    def layoutDirection(self) -> int: ...
    def adjustSize(self) -> None: ...
    def setLayout(self, layout: QGraphicsLayout) -> None: ...
    def layout(self) -> QGraphicsLayout: ...


class QGraphicsProxyWidget(QGraphicsWidget):

    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    def inputMethodEvent(self, event: QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: int) -> typing.Any: ...
    def newProxyWidget(self, a0: QWidget) -> QGraphicsProxyWidget: ...
    def dropEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragEnterEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def resizeEvent(self, event: QGraphicsSceneResizeEvent) -> None: ...
    def sizeHint(self, which: int, constraint: QtCore.QSizeF = ...) -> QtCore.QSizeF: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def keyReleaseEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def wheelEvent(self, event: QGraphicsSceneWheelEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def ungrabMouseEvent(self, event: QtCore.QEvent) -> None: ...
    def grabMouseEvent(self, event: QtCore.QEvent) -> None: ...
    def hoverMoveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def hoverLeaveEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def hoverEnterEvent(self, event: QGraphicsSceneHoverEvent) -> None: ...
    def contextMenuEvent(self, event: QGraphicsSceneContextMenuEvent) -> None: ...
    def hideEvent(self, event: QtGui.QHideEvent) -> None: ...
    def showEvent(self, event: QtGui.QShowEvent) -> None: ...
    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def itemChange(self, change: int, value: typing.Any) -> typing.Any: ...
    def createProxyForChildWidget(self, child: QWidget) -> QGraphicsProxyWidget: ...
    def type(self) -> int: ...
    def paint(self, painter: QtGui.QPainter, option: QStyleOptionGraphicsItem, widget: QWidget) -> None: ...
    def setGeometry(self, rect: QtCore.QRectF) -> None: ...
    def subWidgetRect(self, widget: QWidget) -> QtCore.QRectF: ...
    def widget(self) -> QWidget: ...
    def setWidget(self, widget: QWidget) -> None: ...


class QGraphicsScene(QtCore.QObject):

    changed: PYQT_SIGNAL
    focusItemChanged: PYQT_SIGNAL
    sceneRectChanged: PYQT_SIGNAL
    selectionChanged: PYQT_SIGNAL

    SceneLayer: typing.Type[int]
    #class SceneLayer(int): ...
    ItemLayer = ... # type: int
    BackgroundLayer = ... # type: int
    ForegroundLayer = ... # type: int
    AllLayers = ... # type: int

    ItemIndexMethod: typing.Type[int]
    #class ItemIndexMethod(int): ...
    BspTreeIndex = ... # type: int
    NoIndex = ... # type: int

    SceneLayers: typing.Type[int]
    #class SceneLayers(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QGraphicsScene.SceneLayers, QGraphicsScene.SceneLayer]) -> None: ...
        #@overload
        #def __init__(self, a0: QGraphicsScene.SceneLayers) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QGraphicsScene.SceneLayers: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, sceneRect: QtCore.QRectF, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, x: float, y: float, width: float, height: float, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def setFocusOnTouch(self, enabled: bool) -> None: ...
    def focusOnTouch(self) -> bool: ...
    #def focusItemChanged(self, newFocus: QGraphicsItem, oldFocus: QGraphicsItem, reason: int) -> None: ...
    def setMinimumRenderSize(self, minSize: float) -> None: ...
    def minimumRenderSize(self) -> float: ...
    def sendEvent(self, item: QGraphicsItem, event: QtCore.QEvent) -> bool: ...
    def setActivePanel(self, item: QGraphicsItem) -> None: ...
    def activePanel(self) -> QGraphicsItem: ...
    def isActive(self) -> bool: ...
    @overload
    def itemAt(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], deviceTransform: QtGui.QTransform) -> QGraphicsItem: ...
    @overload
    def itemAt(self, x: float, y: float, deviceTransform: QtGui.QTransform) -> QGraphicsItem: ...
    def stickyFocus(self) -> bool: ...
    def setStickyFocus(self, enabled: bool) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def eventFilter(self, watched: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def setActiveWindow(self, widget: QGraphicsWidget) -> None: ...
    def activeWindow(self) -> QGraphicsWidget: ...
    def setPalette(self, palette: QtGui.QPalette) -> None: ...
    def palette(self) -> QtGui.QPalette: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def setStyle(self, style: QStyle) -> None: ...
    def style(self) -> QStyle: ...
    def addWidget(self, widget: QWidget, flags: typing.Union[int, int] = ...) -> QGraphicsProxyWidget: ...
    def selectionArea(self) -> QtGui.QPainterPath: ...
    def setBspTreeDepth(self, depth: int) -> None: ...
    def bspTreeDepth(self) -> int: ...
    def drawForeground(self, painter: QtGui.QPainter, rect: QtCore.QRectF) -> None: ...
    def drawBackground(self, painter: QtGui.QPainter, rect: QtCore.QRectF) -> None: ...
    def inputMethodEvent(self, event: QtGui.QInputMethodEvent) -> None: ...
    def wheelEvent(self, event: QGraphicsSceneWheelEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: QGraphicsSceneMouseEvent) -> None: ...
    def keyReleaseEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def helpEvent(self, event: QGraphicsSceneHelpEvent) -> None: ...
    def focusOutEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def dropEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def dragEnterEvent(self, event: QGraphicsSceneDragDropEvent) -> None: ...
    def contextMenuEvent(self, event: QGraphicsSceneContextMenuEvent) -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    #def selectionChanged(self) -> None: ...
    #def sceneRectChanged(self, rect: QtCore.QRectF) -> None: ...
    #def changed(self, region: typing.Iterable[QtCore.QRectF]) -> None: ...
    def clear(self) -> None: ...
    @overload
    def invalidate(self, rect: QtCore.QRectF = ..., layers: typing.Union[int, int] = ...) -> None: ...
    @overload
    def invalidate(self, x: float, y: float, w: float, h: float, layers: typing.Union[int, int] = ...) -> None: ...
    @overload
    def update(self, rect: QtCore.QRectF = ...) -> None: ...
    @overload
    def update(self, x: float, y: float, w: float, h: float) -> None: ...
    def advance(self) -> None: ...
    def views(self) -> typing.List[QGraphicsView]: ...
    def inputMethodQuery(self, query: int) -> typing.Any: ...
    def setForegroundBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def foregroundBrush(self) -> QtGui.QBrush: ...
    def setBackgroundBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def backgroundBrush(self) -> QtGui.QBrush: ...
    def mouseGrabberItem(self) -> QGraphicsItem: ...
    def clearFocus(self) -> None: ...
    def setFocus(self, focusReason: int = ...) -> None: ...
    def hasFocus(self) -> bool: ...
    def setFocusItem(self, item: QGraphicsItem, focusReason: int = ...) -> None: ...
    def focusItem(self) -> QGraphicsItem: ...
    def removeItem(self, item: QGraphicsItem) -> None: ...
    def addText(self, text: str, font: QtGui.QFont = ...) -> QGraphicsTextItem: ...
    def addSimpleText(self, text: str, font: QtGui.QFont = ...) -> QGraphicsSimpleTextItem: ...
    @overload
    def addRect(self, rect: QtCore.QRectF, pen: typing.Union[QtGui.QPen, QtGui.QColor, int, QtGui.QGradient] = ..., brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient] = ...) -> QGraphicsRectItem: ...
    @overload
    def addRect(self, x: float, y: float, w: float, h: float, pen: typing.Union[QtGui.QPen, QtGui.QColor, int, QtGui.QGradient] = ..., brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient] = ...) -> QGraphicsRectItem: ...
    def addPolygon(self, polygon: QtGui.QPolygonF, pen: typing.Union[QtGui.QPen, QtGui.QColor, int, QtGui.QGradient] = ..., brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient] = ...) -> QGraphicsPolygonItem: ...
    def addPixmap(self, pixmap: QtGui.QPixmap) -> QGraphicsPixmapItem: ...
    def addPath(self, path: QtGui.QPainterPath, pen: typing.Union[QtGui.QPen, QtGui.QColor, int, QtGui.QGradient] = ..., brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient] = ...) -> QGraphicsPathItem: ...
    @overload
    def addLine(self, line: QtCore.QLineF, pen: typing.Union[QtGui.QPen, QtGui.QColor, int, QtGui.QGradient] = ...) -> QGraphicsLineItem: ...
    @overload
    def addLine(self, x1: float, y1: float, x2: float, y2: float, pen: typing.Union[QtGui.QPen, QtGui.QColor, int, QtGui.QGradient] = ...) -> QGraphicsLineItem: ...
    @overload
    def addEllipse(self, rect: QtCore.QRectF, pen: typing.Union[QtGui.QPen, QtGui.QColor, int, QtGui.QGradient] = ..., brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient] = ...) -> QGraphicsEllipseItem: ...
    @overload
    def addEllipse(self, x: float, y: float, w: float, h: float, pen: typing.Union[QtGui.QPen, QtGui.QColor, int, QtGui.QGradient] = ..., brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient] = ...) -> QGraphicsEllipseItem: ...
    def addItem(self, item: QGraphicsItem) -> None: ...
    def destroyItemGroup(self, group: QGraphicsItemGroup) -> None: ...
    def createItemGroup(self, items: typing.Iterable[QGraphicsItem]) -> QGraphicsItemGroup: ...
    def clearSelection(self) -> None: ...
    @overload
    def setSelectionArea(self, path: QtGui.QPainterPath, deviceTransform: QtGui.QTransform) -> None: ...
    @overload
    def setSelectionArea(self, path: QtGui.QPainterPath, mode: int = ..., deviceTransform: QtGui.QTransform = ...) -> None: ...
    @overload
    def setSelectionArea(self, path: QtGui.QPainterPath, selectionOperation: int, mode: int = ..., deviceTransform: QtGui.QTransform = ...) -> None: ...
    def selectedItems(self) -> typing.List[QGraphicsItem]: ...
    def collidingItems(self, item: QGraphicsItem, mode: int = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, order: int = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], mode: int = ..., order: int = ..., deviceTransform: QtGui.QTransform = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, rect: QtCore.QRectF, mode: int = ..., order: int = ..., deviceTransform: QtGui.QTransform = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, polygon: QtGui.QPolygonF, mode: int = ..., order: int = ..., deviceTransform: QtGui.QTransform = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, path: QtGui.QPainterPath, mode: int = ..., order: int = ..., deviceTransform: QtGui.QTransform = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, x: float, y: float, w: float, h: float, mode: int, order: int, deviceTransform: QtGui.QTransform = ...) -> typing.List[QGraphicsItem]: ...
    def itemsBoundingRect(self) -> QtCore.QRectF: ...
    def setItemIndexMethod(self, method: int) -> None: ...
    def itemIndexMethod(self) -> int: ...
    def render(self, painter: QtGui.QPainter, target: QtCore.QRectF = ..., source: QtCore.QRectF = ..., mode: int = ...) -> None: ...
    @overload
    def setSceneRect(self, rect: QtCore.QRectF) -> None: ...
    @overload
    def setSceneRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def height(self) -> float: ...
    def width(self) -> float: ...
    def sceneRect(self) -> QtCore.QRectF: ...


class QGraphicsSceneEvent(QtCore.QEvent):

    def widget(self) -> QWidget: ...


class QGraphicsSceneMouseEvent(QGraphicsSceneEvent):

    def flags(self) -> int: ...
    def source(self) -> int: ...
    def modifiers(self) -> int: ...
    def button(self) -> int: ...
    def buttons(self) -> int: ...
    def lastScreenPos(self) -> QtCore.QPoint: ...
    def lastScenePos(self) -> QtCore.QPointF: ...
    def lastPos(self) -> QtCore.QPointF: ...
    def buttonDownScreenPos(self, button: int) -> QtCore.QPoint: ...
    def buttonDownScenePos(self, button: int) -> QtCore.QPointF: ...
    def buttonDownPos(self, button: int) -> QtCore.QPointF: ...
    def screenPos(self) -> QtCore.QPoint: ...
    def scenePos(self) -> QtCore.QPointF: ...
    def pos(self) -> QtCore.QPointF: ...


class QGraphicsSceneWheelEvent(QGraphicsSceneEvent):

    def orientation(self) -> int: ...
    def delta(self) -> int: ...
    def modifiers(self) -> int: ...
    def buttons(self) -> int: ...
    def screenPos(self) -> QtCore.QPoint: ...
    def scenePos(self) -> QtCore.QPointF: ...
    def pos(self) -> QtCore.QPointF: ...


class QGraphicsSceneContextMenuEvent(QGraphicsSceneEvent):

    Reason: typing.Type[int]
    #class Reason(int): ...
    Mouse = ... # type: int
    Keyboard = ... # type: int
    Other = ... # type: int

    def reason(self) -> int: ...
    def modifiers(self) -> int: ...
    def screenPos(self) -> QtCore.QPoint: ...
    def scenePos(self) -> QtCore.QPointF: ...
    def pos(self) -> QtCore.QPointF: ...


class QGraphicsSceneHoverEvent(QGraphicsSceneEvent):

    def modifiers(self) -> int: ...
    def lastScreenPos(self) -> QtCore.QPoint: ...
    def lastScenePos(self) -> QtCore.QPointF: ...
    def lastPos(self) -> QtCore.QPointF: ...
    def screenPos(self) -> QtCore.QPoint: ...
    def scenePos(self) -> QtCore.QPointF: ...
    def pos(self) -> QtCore.QPointF: ...


class QGraphicsSceneHelpEvent(QGraphicsSceneEvent):

    def screenPos(self) -> QtCore.QPoint: ...
    def scenePos(self) -> QtCore.QPointF: ...


class QGraphicsSceneDragDropEvent(QGraphicsSceneEvent):

    def mimeData(self) -> QtCore.QMimeData: ...
    def source(self) -> QWidget: ...
    def setDropAction(self, action: int) -> None: ...
    def dropAction(self) -> int: ...
    def acceptProposedAction(self) -> None: ...
    def proposedAction(self) -> int: ...
    def possibleActions(self) -> int: ...
    def modifiers(self) -> int: ...
    def buttons(self) -> int: ...
    def screenPos(self) -> QtCore.QPoint: ...
    def scenePos(self) -> QtCore.QPointF: ...
    def pos(self) -> QtCore.QPointF: ...


class QGraphicsSceneResizeEvent(QGraphicsSceneEvent):

    def __init__(self) -> None: ...

    def newSize(self) -> QtCore.QSizeF: ...
    def oldSize(self) -> QtCore.QSizeF: ...


class QGraphicsSceneMoveEvent(QGraphicsSceneEvent):

    def __init__(self) -> None: ...

    def newPos(self) -> QtCore.QPointF: ...
    def oldPos(self) -> QtCore.QPointF: ...


class QGraphicsTransform(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def update(self) -> None: ...
    def applyTo(self, matrix: QtGui.QMatrix4x4) -> None: ...


class QGraphicsScale(QGraphicsTransform):

    originChanged: PYQT_SIGNAL
    scaleChanged: PYQT_SIGNAL
    xScaleChanged: PYQT_SIGNAL
    yScaleChanged: PYQT_SIGNAL
    zScaleChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    #def zScaleChanged(self) -> None: ...
    #def yScaleChanged(self) -> None: ...
    #def xScaleChanged(self) -> None: ...
    #def scaleChanged(self) -> None: ...
    #def originChanged(self) -> None: ...
    def applyTo(self, matrix: QtGui.QMatrix4x4) -> None: ...
    def setZScale(self, a0: float) -> None: ...
    def zScale(self) -> float: ...
    def setYScale(self, a0: float) -> None: ...
    def yScale(self) -> float: ...
    def setXScale(self, a0: float) -> None: ...
    def xScale(self) -> float: ...
    def setOrigin(self, point: QtGui.QVector3D) -> None: ...
    def origin(self) -> QtGui.QVector3D: ...


class QGraphicsRotation(QGraphicsTransform):

    angleChanged: PYQT_SIGNAL
    axisChanged: PYQT_SIGNAL
    originChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    #def axisChanged(self) -> None: ...
    #def angleChanged(self) -> None: ...
    #def originChanged(self) -> None: ...
    def applyTo(self, matrix: QtGui.QMatrix4x4) -> None: ...
    @overload
    def setAxis(self, axis: QtGui.QVector3D) -> None: ...
    @overload
    def setAxis(self, axis: int) -> None: ...
    def axis(self) -> QtGui.QVector3D: ...
    def setAngle(self, a0: float) -> None: ...
    def angle(self) -> float: ...
    def setOrigin(self, point: QtGui.QVector3D) -> None: ...
    def origin(self) -> QtGui.QVector3D: ...


class QGraphicsView(QAbstractScrollArea):

    rubberBandChanged: PYQT_SIGNAL

    OptimizationFlag: typing.Type[int]
    #class OptimizationFlag(int): ...
    DontClipPainter = ... # type: int
    DontSavePainterState = ... # type: int
    DontAdjustForAntialiasing = ... # type: int

    ViewportUpdateMode: typing.Type[int]
    #class ViewportUpdateMode(int): ...
    FullViewportUpdate = ... # type: int
    MinimalViewportUpdate = ... # type: int
    SmartViewportUpdate = ... # type: int
    BoundingRectViewportUpdate = ... # type: int
    NoViewportUpdate = ... # type: int

    ViewportAnchor: typing.Type[int]
    #class ViewportAnchor(int): ...
    NoAnchor = ... # type: int
    AnchorViewCenter = ... # type: int
    AnchorUnderMouse = ... # type: int

    DragMode: typing.Type[int]
    #class DragMode(int): ...
    NoDrag = ... # type: int
    ScrollHandDrag = ... # type: int
    RubberBandDrag = ... # type: int

    CacheModeFlag: typing.Type[int]
    #class CacheModeFlag(int): ...
    CacheNone = ... # type: int
    CacheBackground = ... # type: int

    CacheMode: typing.Type[int]
    #class CacheMode(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QGraphicsView.CacheMode, QGraphicsView.CacheModeFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QGraphicsView.CacheMode) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QGraphicsView.CacheMode: ...
        #def __int__(self) -> int: ...

    OptimizationFlags: typing.Type[int]
    #class OptimizationFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QGraphicsView.OptimizationFlags, QGraphicsView.OptimizationFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QGraphicsView.OptimizationFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QGraphicsView.OptimizationFlags: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, scene: QGraphicsScene, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    #def rubberBandChanged(self, viewportRect: QtCore.QRect, fromScenePoint: typing.Union[QtCore.QPointF, QtCore.QPoint], toScenePoint: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def rubberBandRect(self) -> QtCore.QRect: ...
    def isTransformed(self) -> bool: ...
    def resetTransform(self) -> None: ...
    def setTransform(self, matrix: QtGui.QTransform, combine: bool = ...) -> None: ...
    def viewportTransform(self) -> QtGui.QTransform: ...
    def transform(self) -> QtGui.QTransform: ...
    def setRubberBandSelectionMode(self, mode: int) -> None: ...
    def rubberBandSelectionMode(self) -> int: ...
    def setOptimizationFlags(self, flags: typing.Union[int, int]) -> None: ...
    def setOptimizationFlag(self, flag: int, enabled: bool = ...) -> None: ...
    def optimizationFlags(self) -> int: ...
    def setViewportUpdateMode(self, mode: int) -> None: ...
    def viewportUpdateMode(self) -> int: ...
    def drawForeground(self, painter: QtGui.QPainter, rect: QtCore.QRectF) -> None: ...
    def drawBackground(self, painter: QtGui.QPainter, rect: QtCore.QRectF) -> None: ...
    def inputMethodEvent(self, event: QtGui.QInputMethodEvent) -> None: ...
    def showEvent(self, event: QtGui.QShowEvent) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def keyReleaseEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def dropEvent(self, event: QtGui.QDropEvent) -> None: ...
    def dragMoveEvent(self, event: QtGui.QDragMoveEvent) -> None: ...
    def dragLeaveEvent(self, event: QtGui.QDragLeaveEvent) -> None: ...
    def dragEnterEvent(self, event: QtGui.QDragEnterEvent) -> None: ...
    def contextMenuEvent(self, event: QtGui.QContextMenuEvent) -> None: ...
    def viewportEvent(self, event: QtCore.QEvent) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def setupViewport(self, widget: QWidget) -> None: ...
    def updateSceneRect(self, rect: QtCore.QRectF) -> None: ...
    def updateScene(self, rects: typing.Iterable[QtCore.QRectF]) -> None: ...
    def invalidateScene(self, rect: QtCore.QRectF = ..., layers: typing.Union[int, int] = ...) -> None: ...
    def setForegroundBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def foregroundBrush(self) -> QtGui.QBrush: ...
    def setBackgroundBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def backgroundBrush(self) -> QtGui.QBrush: ...
    def inputMethodQuery(self, query: int) -> typing.Any: ...
    @overload
    def mapFromScene(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPoint: ...
    @overload
    def mapFromScene(self, rect: QtCore.QRectF) -> QtGui.QPolygon: ...
    @overload
    def mapFromScene(self, polygon: QtGui.QPolygonF) -> QtGui.QPolygon: ...
    @overload
    def mapFromScene(self, path: QtGui.QPainterPath) -> QtGui.QPainterPath: ...
    @overload
    def mapFromScene(self, ax: float, ay: float) -> QtCore.QPoint: ...
    @overload
    def mapFromScene(self, ax: float, ay: float, w: float, h: float) -> QtGui.QPolygon: ...
    @overload
    def mapToScene(self, point: QtCore.QPoint) -> QtCore.QPointF: ...
    @overload
    def mapToScene(self, rect: QtCore.QRect) -> QtGui.QPolygonF: ...
    @overload
    def mapToScene(self, polygon: QtGui.QPolygon) -> QtGui.QPolygonF: ...
    @overload
    def mapToScene(self, path: QtGui.QPainterPath) -> QtGui.QPainterPath: ...
    @overload
    def mapToScene(self, ax: int, ay: int) -> QtCore.QPointF: ...
    @overload
    def mapToScene(self, ax: int, ay: int, w: int, h: int) -> QtGui.QPolygonF: ...
    @overload
    def itemAt(self, pos: QtCore.QPoint) -> QGraphicsItem: ...
    @overload
    def itemAt(self, ax: int, ay: int) -> QGraphicsItem: ...
    @overload
    def items(self) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, pos: QtCore.QPoint) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, x: int, y: int) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, x: int, y: int, w: int, h: int, mode: int = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, rect: QtCore.QRect, mode: int = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, polygon: QtGui.QPolygon, mode: int = ...) -> typing.List[QGraphicsItem]: ...
    @overload
    def items(self, path: QtGui.QPainterPath, mode: int = ...) -> typing.List[QGraphicsItem]: ...
    def render(self, painter: QtGui.QPainter, target: QtCore.QRectF = ..., source: QtCore.QRect = ..., mode: int = ...) -> None: ...
    @overload
    def fitInView(self, rect: QtCore.QRectF, mode: int = ...) -> None: ...
    @overload
    def fitInView(self, item: QGraphicsItem, mode: int = ...) -> None: ...
    @overload
    def fitInView(self, x: float, y: float, w: float, h: float, mode: int = ...) -> None: ...
    @overload
    def ensureVisible(self, rect: QtCore.QRectF, xMargin: int = ..., yMargin: int = ...) -> None: ...
    @overload
    def ensureVisible(self, item: QGraphicsItem, xMargin: int = ..., yMargin: int = ...) -> None: ...
    @overload
    def ensureVisible(self, x: float, y: float, w: float, h: float, xMargin: int = ..., yMargin: int = ...) -> None: ...
    @overload
    def centerOn(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def centerOn(self, item: QGraphicsItem) -> None: ...
    @overload
    def centerOn(self, ax: float, ay: float) -> None: ...
    def translate(self, dx: float, dy: float) -> None: ...
    def shear(self, sh: float, sv: float) -> None: ...
    def scale(self, sx: float, sy: float) -> None: ...
    def rotate(self, angle: float) -> None: ...
    @overload
    def setSceneRect(self, rect: QtCore.QRectF) -> None: ...
    @overload
    def setSceneRect(self, ax: float, ay: float, aw: float, ah: float) -> None: ...
    def sceneRect(self) -> QtCore.QRectF: ...
    def setScene(self, scene: QGraphicsScene) -> None: ...
    def scene(self) -> QGraphicsScene: ...
    def setInteractive(self, allowed: bool) -> None: ...
    def isInteractive(self) -> bool: ...
    def resetCachedContent(self) -> None: ...
    def setCacheMode(self, mode: typing.Union[int, int]) -> None: ...
    def cacheMode(self) -> int: ...
    def setDragMode(self, mode: int) -> None: ...
    def dragMode(self) -> int: ...
    def setResizeAnchor(self, anchor: int) -> None: ...
    def resizeAnchor(self) -> int: ...
    def setTransformationAnchor(self, anchor: int) -> None: ...
    def transformationAnchor(self) -> int: ...
    def setAlignment(self, alignment: typing.Union[int, int]) -> None: ...
    def alignment(self) -> int: ...
    def setRenderHints(self, hints: typing.Union[int, int]) -> None: ...
    def setRenderHint(self, hint: int, on: bool = ...) -> None: ...
    def renderHints(self) -> int: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QGridLayout(QLayout):

    @overload
    def __init__(self, parent: QWidget, **props) -> None: ...
    @overload
    def __init__(self, **props) -> None: ...

    def itemAtPosition(self, row: int, column: int) -> QLayoutItem: ...
    def spacing(self) -> int: ...
    def setSpacing(self, spacing: int) -> None: ...
    def verticalSpacing(self) -> int: ...
    def setVerticalSpacing(self, spacing: int) -> None: ...
    def horizontalSpacing(self) -> int: ...
    def setHorizontalSpacing(self, spacing: int) -> None: ...
    def getItemPosition(self, idx: int) -> typing.Tuple[int, int, int, int]: ...
    def setDefaultPositioning(self, n: int, orient: int) -> None: ...
    @overload
    def addItem(self, item: QLayoutItem, row: int, column: int, rowSpan: int = ..., columnSpan: int = ..., alignment: typing.Union[int, int] = ...) -> None: ...
    @overload
    def addItem(self, a0: QLayoutItem) -> None: ...
    def setGeometry(self, a0: QtCore.QRect) -> None: ...
    def count(self) -> int: ...
    def takeAt(self, a0: int) -> QLayoutItem: ...
    def itemAt(self, a0: int) -> QLayoutItem: ...
    def originCorner(self) -> int: ...
    def setOriginCorner(self, a0: int) -> None: ...
    @overload
    def addLayout(self, a0: QLayout, row: int, column: int, alignment: typing.Union[int, int] = ...) -> None: ...
    @overload
    def addLayout(self, a0: QLayout, row: int, column: int, rowSpan: int, columnSpan: int, alignment: typing.Union[int, int] = ...) -> None: ...
    @overload
    def addWidget(self, w: QWidget) -> None: ...
    @overload
    def addWidget(self, a0: QWidget, row: int, column: int, alignment: typing.Union[int, int] = ...) -> None: ...
    @overload
    def addWidget(self, a0: QWidget, row: int, column: int, rowSpan: int, columnSpan: int, alignment: typing.Union[int, int] = ...) -> None: ...
    def invalidate(self) -> None: ...
    def expandingDirections(self) -> int: ...
    def minimumHeightForWidth(self, a0: int) -> int: ...
    def heightForWidth(self, a0: int) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def cellRect(self, row: int, column: int) -> QtCore.QRect: ...
    def rowCount(self) -> int: ...
    def columnCount(self) -> int: ...
    def columnMinimumWidth(self, column: int) -> int: ...
    def rowMinimumHeight(self, row: int) -> int: ...
    def setColumnMinimumWidth(self, column: int, minSize: int) -> None: ...
    def setRowMinimumHeight(self, row: int, minSize: int) -> None: ...
    def columnStretch(self, column: int) -> int: ...
    def rowStretch(self, row: int) -> int: ...
    def setColumnStretch(self, column: int, stretch: int) -> None: ...
    def setRowStretch(self, row: int, stretch: int) -> None: ...
    def maximumSize(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QGroupBox(QWidget):

    clicked: PYQT_SIGNAL
    toggled: PYQT_SIGNAL

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, title: str, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def focusInEvent(self, a0: QtGui.QFocusEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def childEvent(self, a0: QtCore.QChildEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: QStyleOptionGroupBox) -> None: ...
    #def toggled(self, a0: bool) -> None: ...
    #def clicked(self, checked: bool = ...) -> None: ...
    def setChecked(self, b: bool) -> None: ...
    def isChecked(self) -> bool: ...
    def setCheckable(self, b: bool) -> None: ...
    def isCheckable(self) -> bool: ...
    def setFlat(self, b: bool) -> None: ...
    def isFlat(self) -> bool: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def setAlignment(self, a0: int) -> None: ...
    def alignment(self) -> int: ...
    def setTitle(self, a0: str) -> None: ...
    def title(self) -> str: ...


class QHeaderView(QAbstractItemView):

    geometriesChanged: PYQT_SIGNAL
    sectionClicked: PYQT_SIGNAL
    sectionCountChanged: PYQT_SIGNAL
    sectionDoubleClicked: PYQT_SIGNAL
    sectionEntered: PYQT_SIGNAL
    sectionHandleDoubleClicked: PYQT_SIGNAL
    sectionMoved: PYQT_SIGNAL
    sectionPressed: PYQT_SIGNAL
    sectionResized: PYQT_SIGNAL
    sortIndicatorChanged: PYQT_SIGNAL

    class ResizeMode(int):
        Interactive = ... # type: QHeaderView.ResizeMode
        Fixed = ... # type: QHeaderView.ResizeMode
        Stretch = ... # type: QHeaderView.ResizeMode
        ResizeToContents = ... # type: QHeaderView.ResizeMode
        Custom = ... # type: QHeaderView.ResizeMode

    def __init__(self, orientation: int, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def isFirstSectionMovable(self) -> bool: ...
    def setFirstSectionMovable(self, movable: bool) -> None: ...
    def resetDefaultSectionSize(self) -> None: ...
    def setMaximumSectionSize(self, size: int) -> None: ...
    def maximumSectionSize(self) -> int: ...
    def resizeContentsPrecision(self) -> int: ...
    def setResizeContentsPrecision(self, precision: int) -> None: ...
    def setVisible(self, v: bool) -> None: ...
    @overload
    def setSectionResizeMode(self, logicalIndex: int, mode: int) -> None: ...
    @overload
    def setSectionResizeMode(self, mode: int) -> None: ...
    def sectionResizeMode(self, logicalIndex: int) -> int: ...
    def sectionsClickable(self) -> bool: ...
    def setSectionsClickable(self, clickable: bool) -> None: ...
    def sectionsMovable(self) -> bool: ...
    def setSectionsMovable(self, movable: bool) -> None: ...
    def initStyleOption(self, option: QStyleOptionHeader) -> None: ...
    #def sortIndicatorChanged(self, logicalIndex: int, order: int) -> None: ...
    #def sectionEntered(self, logicalIndex: int) -> None: ...
    def setOffsetToLastSection(self) -> None: ...
    def reset(self) -> None: ...
    def restoreState(self, state: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def saveState(self) -> QtCore.QByteArray: ...
    def setMinimumSectionSize(self, size: int) -> None: ...
    def minimumSectionSize(self) -> int: ...
    def setCascadingSectionResizes(self, enable: bool) -> None: ...
    def cascadingSectionResizes(self) -> bool: ...
    def swapSections(self, first: int, second: int) -> None: ...
    def sectionsHidden(self) -> bool: ...
    def setDefaultAlignment(self, alignment: typing.Union[int, int]) -> None: ...
    def defaultAlignment(self) -> int: ...
    def setDefaultSectionSize(self, size: int) -> None: ...
    def defaultSectionSize(self) -> int: ...
    def hiddenSectionCount(self) -> int: ...
    def showSection(self, alogicalIndex: int) -> None: ...
    def hideSection(self, alogicalIndex: int) -> None: ...
    def visualRegionForSelection(self, selection: QtCore.QItemSelection) -> QtGui.QRegion: ...
    def setSelection(self, rect: QtCore.QRect, flags: typing.Union[int, int]) -> None: ...
    def moveCursor(self, a0: int, a1: typing.Union[int, int]) -> QtCore.QModelIndex: ...
    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool: ...
    def indexAt(self, p: QtCore.QPoint) -> QtCore.QModelIndex: ...
    def scrollTo(self, index: QtCore.QModelIndex, hint: int) -> None: ...
    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect: ...
    def rowsInserted(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def dataChanged(self, topLeft: QtCore.QModelIndex, bottomRight: QtCore.QModelIndex, roles: typing.Iterable[int] = ...) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def updateGeometries(self) -> None: ...
    def verticalOffset(self) -> int: ...
    def horizontalOffset(self) -> int: ...
    def sectionSizeFromContents(self, logicalIndex: int) -> QtCore.QSize: ...
    def paintSection(self, painter: QtGui.QPainter, rect: QtCore.QRect, logicalIndex: int) -> None: ...
    def mouseDoubleClickEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def viewportEvent(self, e: QtCore.QEvent) -> bool: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def currentChanged(self, current: QtCore.QModelIndex, old: QtCore.QModelIndex) -> None: ...
    @overload
    def initializeSections(self) -> None: ...
    @overload
    def initializeSections(self, start: int, end: int) -> None: ...
    def initialize(self) -> None: ...
    def sectionsAboutToBeRemoved(self, parent: QtCore.QModelIndex, logicalFirst: int, logicalLast: int) -> None: ...
    def sectionsInserted(self, parent: QtCore.QModelIndex, logicalFirst: int, logicalLast: int) -> None: ...
    @overload
    def resizeSections(self) -> None: ...
    @overload
    def resizeSections(self, mode: int) -> None: ...
    def updateSection(self, logicalIndex: int) -> None: ...
    #def sectionHandleDoubleClicked(self, logicalIndex: int) -> None: ...
    #def sectionCountChanged(self, oldCount: int, newCount: int) -> None: ...
    #def sectionDoubleClicked(self, logicalIndex: int) -> None: ...
    #def sectionClicked(self, logicalIndex: int) -> None: ...
    #def sectionPressed(self, logicalIndex: int) -> None: ...
    #def sectionResized(self, logicalIndex: int, oldSize: int, newSize: int) -> None: ...
    #def sectionMoved(self, logicalIndex: int, oldVisualIndex: int, newVisualIndex: int) -> None: ...
    #def geometriesChanged(self) -> None: ...
    def setOffsetToSectionPosition(self, visualIndex: int) -> None: ...
    def headerDataChanged(self, orientation: int, logicalFirst: int, logicalLast: int) -> None: ...
    def setOffset(self, offset: int) -> None: ...
    def sectionsMoved(self) -> bool: ...
    def setStretchLastSection(self, stretch: bool) -> None: ...
    def stretchLastSection(self) -> bool: ...
    def sortIndicatorOrder(self) -> int: ...
    def sortIndicatorSection(self) -> int: ...
    def setSortIndicator(self, logicalIndex: int, order: int) -> None: ...
    def isSortIndicatorShown(self) -> bool: ...
    def setSortIndicatorShown(self, show: bool) -> None: ...
    def stretchSectionCount(self) -> int: ...
    def highlightSections(self) -> bool: ...
    def setHighlightSections(self, highlight: bool) -> None: ...
    def logicalIndex(self, visualIndex: int) -> int: ...
    def visualIndex(self, logicalIndex: int) -> int: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def setSectionHidden(self, logicalIndex: int, hide: bool) -> None: ...
    def isSectionHidden(self, logicalIndex: int) -> bool: ...
    def resizeSection(self, logicalIndex: int, size: int) -> None: ...
    def moveSection(self, from_: int, to: int) -> None: ...
    def sectionViewportPosition(self, logicalIndex: int) -> int: ...
    def sectionPosition(self, logicalIndex: int) -> int: ...
    def sectionSize(self, logicalIndex: int) -> int: ...
    @overload
    def logicalIndexAt(self, position: int) -> int: ...
    @overload
    def logicalIndexAt(self, ax: int, ay: int) -> int: ...
    @overload
    def logicalIndexAt(self, apos: QtCore.QPoint) -> int: ...
    def visualIndexAt(self, position: int) -> int: ...
    def sectionSizeHint(self, logicalIndex: int) -> int: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def length(self) -> int: ...
    def offset(self) -> int: ...
    def orientation(self) -> int: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...


class QInputDialog(QDialog):

    doubleValueChanged: PYQT_SIGNAL
    doubleValueSelected: PYQT_SIGNAL
    intValueChanged: PYQT_SIGNAL
    intValueSelected: PYQT_SIGNAL
    textValueChanged: PYQT_SIGNAL
    textValueSelected: PYQT_SIGNAL

    InputMode: typing.Type[int]
    #class InputMode(int): ...
    TextInput = ... # type: int
    IntInput = ... # type: int
    DoubleInput = ... # type: int

    InputDialogOption: typing.Type[int]
    #class InputDialogOption(int): ...
    NoButtons = ... # type: int
    UseListViewForComboBoxItems = ... # type: int
    UsePlainTextEditForTextInput = ... # type: int

    InputDialogOptions: typing.Type[int]
    #class InputDialogOptions(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QInputDialog.InputDialogOptions, QInputDialog.InputDialogOption]) -> None: ...
        #@overload
        #def __init__(self, a0: QInputDialog.InputDialogOptions) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QInputDialog.InputDialogOptions: ...
        #def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    def doubleStep(self) -> float: ...
    def setDoubleStep(self, step: float) -> None: ...
    #def doubleValueSelected(self, value: float) -> None: ...
    #def doubleValueChanged(self, value: float) -> None: ...
    #def intValueSelected(self, value: int) -> None: ...
    #def intValueChanged(self, value: int) -> None: ...
    #def textValueSelected(self, text: str) -> None: ...
    #def textValueChanged(self, text: str) -> None: ...
    def done(self, result: int) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    @overload
    def open(self) -> None: ...
    @overload
    def open(self, slot: PYQT_SLOT) -> None: ...
    def cancelButtonText(self) -> str: ...
    def setCancelButtonText(self, text: str) -> None: ...
    def okButtonText(self) -> str: ...
    def setOkButtonText(self, text: str) -> None: ...
    def doubleDecimals(self) -> int: ...
    def setDoubleDecimals(self, decimals: int) -> None: ...
    def setDoubleRange(self, min: float, max: float) -> None: ...
    def doubleMaximum(self) -> float: ...
    def setDoubleMaximum(self, max: float) -> None: ...
    def doubleMinimum(self) -> float: ...
    def setDoubleMinimum(self, min: float) -> None: ...
    def doubleValue(self) -> float: ...
    def setDoubleValue(self, value: float) -> None: ...
    def intStep(self) -> int: ...
    def setIntStep(self, step: int) -> None: ...
    def setIntRange(self, min: int, max: int) -> None: ...
    def intMaximum(self) -> int: ...
    def setIntMaximum(self, max: int) -> None: ...
    def intMinimum(self) -> int: ...
    def setIntMinimum(self, min: int) -> None: ...
    def intValue(self) -> int: ...
    def setIntValue(self, value: int) -> None: ...
    def comboBoxItems(self) -> typing.List[str]: ...
    def setComboBoxItems(self, items: typing.Iterable[str]) -> None: ...
    def isComboBoxEditable(self) -> bool: ...
    def setComboBoxEditable(self, editable: bool) -> None: ...
    def textEchoMode(self) -> int: ...
    def setTextEchoMode(self, mode: int) -> None: ...
    def textValue(self) -> str: ...
    def setTextValue(self, text: str) -> None: ...
    def options(self) -> int: ...
    def setOptions(self, options: typing.Union[int, int]) -> None: ...
    def testOption(self, option: int) -> bool: ...
    def setOption(self, option: int, on: bool = ...) -> None: ...
    def labelText(self) -> str: ...
    def setLabelText(self, text: str) -> None: ...
    def inputMode(self) -> int: ...
    def setInputMode(self, mode: int) -> None: ...
    @staticmethod
    def getMultiLineText(parent: QWidget, title: str, label: str, text: str = ..., flags: typing.Union[int, int] = ..., inputMethodHints: typing.Union[int, int] = ...) -> typing.Tuple[str, bool]: ...
    @staticmethod
    def getItem(parent: QWidget, title: str, label: str, items: typing.Iterable[str], current: int = ..., editable: bool = ..., flags: typing.Union[int, int] = ..., inputMethodHints: typing.Union[int, int] = ...) -> typing.Tuple[str, bool]: ...
    @overload
    @staticmethod
    def getDouble(parent: QWidget, title: str, label: str, value: float = ..., min: float = ..., max: float = ..., decimals: int = ..., flags: typing.Union[int, int] = ...) -> typing.Tuple[float, bool]: ...
    @overload
    @staticmethod
    def getDouble(parent: QWidget, title: str, label: str, value: float, minValue: float, maxValue: float, decimals: int, flags: typing.Union[int, int], step: float) -> typing.Tuple[float, bool]: ...
    @staticmethod
    def getInt(parent: QWidget, title: str, label: str, value: int = ..., min: int = ..., max: int = ..., step: int = ..., flags: typing.Union[int, int] = ...) -> typing.Tuple[int, bool]: ...
    @staticmethod
    def getText(parent: QWidget, title: str, label: str, echo: int = ..., text: str = ..., flags: typing.Union[int, int] = ..., inputMethodHints: typing.Union[int, int] = ...) -> typing.Tuple[str, bool]: ...


class QItemDelegate(QAbstractItemDelegate):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def editorEvent(self, event: QtCore.QEvent, model: QtCore.QAbstractItemModel, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> bool: ...
    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def drawFocus(self, painter: QtGui.QPainter, option: QStyleOptionViewItem, rect: QtCore.QRect) -> None: ...
    def drawDisplay(self, painter: QtGui.QPainter, option: QStyleOptionViewItem, rect: QtCore.QRect, text: str) -> None: ...
    def drawDecoration(self, painter: QtGui.QPainter, option: QStyleOptionViewItem, rect: QtCore.QRect, pixmap: QtGui.QPixmap) -> None: ...
    def drawCheck(self, painter: QtGui.QPainter, option: QStyleOptionViewItem, rect: QtCore.QRect, state: int) -> None: ...
    def drawBackground(self, painter: QtGui.QPainter, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> None: ...
    def setClipping(self, clip: bool) -> None: ...
    def hasClipping(self) -> bool: ...
    def setItemEditorFactory(self, factory: QItemEditorFactory) -> None: ...
    def itemEditorFactory(self) -> QItemEditorFactory: ...
    def updateEditorGeometry(self, editor: QWidget, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> None: ...
    def setModelData(self, editor: QWidget, model: QtCore.QAbstractItemModel, index: QtCore.QModelIndex) -> None: ...
    def setEditorData(self, editor: QWidget, index: QtCore.QModelIndex) -> None: ...
    def createEditor(self, parent: QWidget, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> QWidget: ...
    def sizeHint(self, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> QtCore.QSize: ...
    def paint(self, painter: QtGui.QPainter, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> None: ...


class QItemEditorCreatorBase(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QItemEditorCreatorBase) -> None: ...

    def valuePropertyName(self) -> QtCore.QByteArray: ...
    def createWidget(self, parent: QWidget) -> QWidget: ...


class QItemEditorFactory(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QItemEditorFactory) -> None: ...

    @staticmethod
    def setDefaultFactory(factory: QItemEditorFactory) -> None: ...
    @staticmethod
    def defaultFactory() -> QItemEditorFactory: ...
    def registerEditor(self, userType: int, creator: QItemEditorCreatorBase) -> None: ...
    def valuePropertyName(self, userType: int) -> QtCore.QByteArray: ...
    def createEditor(self, userType: int, parent: QWidget) -> QWidget: ...


class QKeyEventTransition(QtCore.QEventTransition):

    @overload
    def __init__(self, sourceState: typing.Optional[QtCore.QState] = ..., **props) -> None: ...
    @overload
    def __init__(self, object: QtCore.QObject, type: int, key: int, sourceState: typing.Optional[QtCore.QState] = ..., **props) -> None: ...

    def eventTest(self, event: QtCore.QEvent) -> bool: ...
    def onTransition(self, event: QtCore.QEvent) -> None: ...
    def setModifierMask(self, modifiers: typing.Union[int, int]) -> None: ...
    def modifierMask(self) -> int: ...
    def setKey(self, key: int) -> None: ...
    def key(self) -> int: ...


class QKeySequenceEdit(QWidget):

    editingFinished: PYQT_SIGNAL
    keySequenceChanged: PYQT_SIGNAL

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, keySequence: typing.Union[QtGui.QKeySequence, int, str, int], parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def timerEvent(self, a0: QtCore.QTimerEvent) -> None: ...
    def keyReleaseEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    #def keySequenceChanged(self, keySequence: typing.Union[QtGui.QKeySequence, int, str, int]) -> None: ...
    #def editingFinished(self) -> None: ...
    def clear(self) -> None: ...
    def setKeySequence(self, keySequence: typing.Union[QtGui.QKeySequence, int, str, int]) -> None: ...
    def keySequence(self) -> QtGui.QKeySequence: ...


class QLabel(QFrame):

    linkActivated: PYQT_SIGNAL
    linkHovered: PYQT_SIGNAL

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    def selectionStart(self) -> int: ...
    def selectedText(self) -> str: ...
    def hasSelectedText(self) -> bool: ...
    def setSelection(self, a0: int, a1: int) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, ev: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, ev: QtGui.QFocusEvent) -> None: ...
    def contextMenuEvent(self, ev: QtGui.QContextMenuEvent) -> None: ...
    def mouseReleaseEvent(self, ev: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, ev: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, ev: QtGui.QMouseEvent) -> None: ...
    def keyPressEvent(self, ev: QtGui.QKeyEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    #def linkHovered(self, link: str) -> None: ...
    #def linkActivated(self, link: str) -> None: ...
    def setText(self, a0: str) -> None: ...
    def setPixmap(self, a0: QtGui.QPixmap) -> None: ...
    def setPicture(self, a0: QtGui.QPicture) -> None: ...
    @overload
    def setNum(self, a0: float) -> None: ...
    @overload
    def setNum(self, a0: int) -> None: ...
    def setMovie(self, movie: QtGui.QMovie) -> None: ...
    def clear(self) -> None: ...
    def setOpenExternalLinks(self, open: bool) -> None: ...
    def textInteractionFlags(self) -> int: ...
    def setTextInteractionFlags(self, flags: typing.Union[int, int]) -> None: ...
    def openExternalLinks(self) -> bool: ...
    def heightForWidth(self, a0: int) -> int: ...
    def buddy(self) -> QWidget: ...
    def setBuddy(self, a0: QWidget) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setScaledContents(self, a0: bool) -> None: ...
    def hasScaledContents(self) -> bool: ...
    def setMargin(self, a0: int) -> None: ...
    def margin(self) -> int: ...
    def setIndent(self, a0: int) -> None: ...
    def indent(self) -> int: ...
    def wordWrap(self) -> bool: ...
    def setWordWrap(self, on: bool) -> None: ...
    def setAlignment(self, a0: typing.Union[int, int]) -> None: ...
    def alignment(self) -> int: ...
    def setTextFormat(self, a0: int) -> None: ...
    def textFormat(self) -> int: ...
    def movie(self) -> QtGui.QMovie: ...
    def picture(self) -> QtGui.QPicture: ...
    def pixmap(self) -> QtGui.QPixmap: ...
    def text(self) -> str: ...


class QSpacerItem(QLayoutItem):

    @overload
    def __init__(self, w: int, h: int, hPolicy: int = ..., vPolicy: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QSpacerItem) -> None: ...

    def sizePolicy(self) -> QSizePolicy: ...
    def spacerItem(self) -> QSpacerItem: ...
    def geometry(self) -> QtCore.QRect: ...
    def setGeometry(self, a0: QtCore.QRect) -> None: ...
    def isEmpty(self) -> bool: ...
    def expandingDirections(self) -> int: ...
    def maximumSize(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def changeSize(self, w: int, h: int, hPolicy: int = ..., vPolicy: int = ...) -> None: ...


class QWidgetItem(QLayoutItem):

    def __init__(self, w: QWidget) -> None: ...

    def controlTypes(self) -> int: ...
    def heightForWidth(self, a0: int) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def widget(self) -> QWidget: ...
    def geometry(self) -> QtCore.QRect: ...
    def setGeometry(self, a0: QtCore.QRect) -> None: ...
    def isEmpty(self) -> bool: ...
    def expandingDirections(self) -> int: ...
    def maximumSize(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QLCDNumber(QFrame):

    overflow: PYQT_SIGNAL

    SegmentStyle: typing.Type[int]
    #class SegmentStyle(int): ...
    Outline = ... # type: int
    Filled = ... # type: int
    Flat = ... # type: int

    Mode: typing.Type[int]
    #class Mode(int): ...
    Hex = ... # type: int
    Dec = ... # type: int
    Oct = ... # type: int
    Bin = ... # type: int

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, numDigits: int, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    #def overflow(self) -> None: ...
    def setSmallDecimalPoint(self, a0: bool) -> None: ...
    def setBinMode(self) -> None: ...
    def setOctMode(self) -> None: ...
    def setDecMode(self) -> None: ...
    def setHexMode(self) -> None: ...
    @overload
    def display(self, str: str) -> None: ...
    @overload
    def display(self, num: float) -> None: ...
    @overload
    def display(self, num: int) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def intValue(self) -> int: ...
    def value(self) -> float: ...
    def setSegmentStyle(self, a0: int) -> None: ...
    def segmentStyle(self) -> int: ...
    def setMode(self, a0: int) -> None: ...
    def mode(self) -> int: ...
    @overload
    def checkOverflow(self, num: float) -> bool: ...
    @overload
    def checkOverflow(self, num: int) -> bool: ...
    def setNumDigits(self, nDigits: int) -> None: ...
    def setDigitCount(self, nDigits: int) -> None: ...
    def digitCount(self) -> int: ...
    def smallDecimalPoint(self) -> bool: ...


class QLineEdit(QWidget):

    cursorPositionChanged: PYQT_SIGNAL
    editingFinished: PYQT_SIGNAL
    inputRejected: PYQT_SIGNAL
    returnPressed: PYQT_SIGNAL
    selectionChanged: PYQT_SIGNAL
    textChanged: PYQT_SIGNAL
    textEdited: PYQT_SIGNAL

    ActionPosition: typing.Type[int]
    #class ActionPosition(int): ...
    LeadingPosition = ... # type: int
    TrailingPosition = ... # type: int

    class EchoMode(int):
        Normal = ... # type: QLineEdit.EchoMode
        NoEcho = ... # type: QLineEdit.EchoMode
        Password = ... # type: QLineEdit.EchoMode
        PasswordEchoOnEdit = ... # type: QLineEdit.EchoMode

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, contents: str, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    #def inputRejected(self) -> None: ...
    def selectionLength(self) -> int: ...
    def selectionEnd(self) -> int: ...
    @overload
    def addAction(self, action: QAction) -> None: ...
    @overload
    def addAction(self, action: QAction, position: int) -> None: ...
    @overload
    def addAction(self, icon: QtGui.QIcon, position: int) -> QAction: ...
    def isClearButtonEnabled(self) -> bool: ...
    def setClearButtonEnabled(self, enable: bool) -> None: ...
    def cursorMoveStyle(self) -> int: ...
    def setCursorMoveStyle(self, style: int) -> None: ...
    def setPlaceholderText(self, a0: str) -> None: ...
    def placeholderText(self) -> str: ...
    def textMargins(self) -> QtCore.QMargins: ...
    def getTextMargins(self) -> typing.Tuple[int, int, int, int]: ...
    @overload
    def setTextMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @overload
    def setTextMargins(self, margins: QtCore.QMargins) -> None: ...
    def completer(self) -> QCompleter: ...
    def setCompleter(self, completer: QCompleter) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    @overload
    def inputMethodQuery(self, a0: int) -> typing.Any: ...
    @overload
    def inputMethodQuery(self, property: int, argument: typing.Any) -> typing.Any: ...
    def cursorRect(self) -> QtCore.QRect: ...
    def inputMethodEvent(self, a0: QtGui.QInputMethodEvent) -> None: ...
    def contextMenuEvent(self, a0: QtGui.QContextMenuEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def dropEvent(self, a0: QtGui.QDropEvent) -> None: ...
    def dragLeaveEvent(self, e: QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: QtGui.QDragMoveEvent) -> None: ...
    def dragEnterEvent(self, a0: QtGui.QDragEnterEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def focusOutEvent(self, a0: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, a0: QtGui.QFocusEvent) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def initStyleOption(self, option: QStyleOptionFrame) -> None: ...
    #def selectionChanged(self) -> None: ...
    #def editingFinished(self) -> None: ...
    #def returnPressed(self) -> None: ...
    #def cursorPositionChanged(self, a0: int, a1: int) -> None: ...
    #def textEdited(self, a0: str) -> None: ...
    #def textChanged(self, a0: str) -> None: ...
    def createStandardContextMenu(self) -> QMenu: ...
    def insert(self, a0: str) -> None: ...
    def deselect(self) -> None: ...
    def paste(self) -> None: ...
    def copy(self) -> None: ...
    def cut(self) -> None: ...
    def redo(self) -> None: ...
    def undo(self) -> None: ...
    def selectAll(self) -> None: ...
    def clear(self) -> None: ...
    def setText(self, a0: str) -> None: ...
    def hasAcceptableInput(self) -> bool: ...
    def setInputMask(self, inputMask: str) -> None: ...
    def inputMask(self) -> str: ...
    def dragEnabled(self) -> bool: ...
    def setDragEnabled(self, b: bool) -> None: ...
    def isRedoAvailable(self) -> bool: ...
    def isUndoAvailable(self) -> bool: ...
    def selectionStart(self) -> int: ...
    def selectedText(self) -> str: ...
    def hasSelectedText(self) -> bool: ...
    def setSelection(self, a0: int, a1: int) -> None: ...
    def setModified(self, a0: bool) -> None: ...
    def isModified(self) -> bool: ...
    def end(self, mark: bool) -> None: ...
    def home(self, mark: bool) -> None: ...
    def del_(self) -> None: ...
    def backspace(self) -> None: ...
    def cursorWordBackward(self, mark: bool) -> None: ...
    def cursorWordForward(self, mark: bool) -> None: ...
    def cursorBackward(self, mark: bool, steps: int = ...) -> None: ...
    def cursorForward(self, mark: bool, steps: int = ...) -> None: ...
    def alignment(self) -> int: ...
    def setAlignment(self, flag: typing.Union[int, int]) -> None: ...
    def cursorPositionAt(self, pos: QtCore.QPoint) -> int: ...
    def setCursorPosition(self, a0: int) -> None: ...
    def cursorPosition(self) -> int: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def validator(self) -> QtGui.QValidator: ...
    def setValidator(self, a0: QtGui.QValidator) -> None: ...
    def setReadOnly(self, a0: bool) -> None: ...
    def isReadOnly(self) -> bool: ...
    def setEchoMode(self, a0: int) -> None: ...
    def echoMode(self) -> int: ...
    def hasFrame(self) -> bool: ...
    def setFrame(self, a0: bool) -> None: ...
    def setMaxLength(self, a0: int) -> None: ...
    def maxLength(self) -> int: ...
    def displayText(self) -> str: ...
    def text(self) -> str: ...


class QListView(QAbstractItemView):

    indexesMoved: PYQT_SIGNAL

    class ViewMode(int):
        ListMode = ... # type: QListView.ViewMode
        IconMode = ... # type: QListView.ViewMode

    class LayoutMode(int):
        SinglePass = ... # type: QListView.LayoutMode
        Batched = ... # type: QListView.LayoutMode

    class ResizeMode(int):
        Fixed = ... # type: QListView.ResizeMode
        Adjust = ... # type: QListView.ResizeMode

    class Flow(int):
        LeftToRight = ... # type: QListView.Flow
        TopToBottom = ... # type: QListView.Flow

    class Movement(int):
        Static = ... # type: QListView.Movement
        Free = ... # type: QListView.Movement
        Snap = ... # type: QListView.Movement

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def itemAlignment(self) -> int: ...
    def setItemAlignment(self, alignment: typing.Union[int, int]) -> None: ...
    def currentChanged(self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex) -> None: ...
    def selectionChanged(self, selected: QtCore.QItemSelection, deselected: QtCore.QItemSelection) -> None: ...
    def isSelectionRectVisible(self) -> bool: ...
    def setSelectionRectVisible(self, show: bool) -> None: ...
    def wordWrap(self) -> bool: ...
    def setWordWrap(self, on: bool) -> None: ...
    def batchSize(self) -> int: ...
    def setBatchSize(self, batchSize: int) -> None: ...
    def viewportSizeHint(self) -> QtCore.QSize: ...
    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool: ...
    def updateGeometries(self) -> None: ...
    def selectedIndexes(self) -> typing.List[QtCore.QModelIndex]: ...
    def visualRegionForSelection(self, selection: QtCore.QItemSelection) -> QtGui.QRegion: ...
    def setSelection(self, rect: QtCore.QRect, command: typing.Union[int, int]) -> None: ...
    def setPositionForIndex(self, position: QtCore.QPoint, index: QtCore.QModelIndex) -> None: ...
    def rectForIndex(self, index: QtCore.QModelIndex) -> QtCore.QRect: ...
    def moveCursor(self, cursorAction: int, modifiers: typing.Union[int, int]) -> QtCore.QModelIndex: ...
    def verticalOffset(self) -> int: ...
    def horizontalOffset(self) -> int: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def viewOptions(self) -> QStyleOptionViewItem: ...
    def startDrag(self, supportedActions: typing.Union[int, int]) -> None: ...
    def wheelEvent(self, e: QtGui.QWheelEvent) -> None: ...
    def dropEvent(self, e: QtGui.QDropEvent) -> None: ...
    def dragLeaveEvent(self, e: QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: QtGui.QDragMoveEvent) -> None: ...
    def resizeEvent(self, e: QtGui.QResizeEvent) -> None: ...
    def timerEvent(self, e: QtCore.QTimerEvent) -> None: ...
    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def rowsAboutToBeRemoved(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def rowsInserted(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def dataChanged(self, topLeft: QtCore.QModelIndex, bottomRight: QtCore.QModelIndex, roles: typing.Iterable[int] = ...) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    #def indexesMoved(self, indexes: typing.Iterable[QtCore.QModelIndex]) -> None: ...
    def setRootIndex(self, index: QtCore.QModelIndex) -> None: ...
    def reset(self) -> None: ...
    def indexAt(self, p: QtCore.QPoint) -> QtCore.QModelIndex: ...
    def scrollTo(self, index: QtCore.QModelIndex, hint: int = ...) -> None: ...
    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect: ...
    def uniformItemSizes(self) -> bool: ...
    def setUniformItemSizes(self, enable: bool) -> None: ...
    def modelColumn(self) -> int: ...
    def setModelColumn(self, column: int) -> None: ...
    def setRowHidden(self, row: int, hide: bool) -> None: ...
    def isRowHidden(self, row: int) -> bool: ...
    def clearPropertyFlags(self) -> None: ...
    def viewMode(self) -> int: ...
    def setViewMode(self, mode: int) -> None: ...
    def gridSize(self) -> QtCore.QSize: ...
    def setGridSize(self, size: QtCore.QSize) -> None: ...
    def spacing(self) -> int: ...
    def setSpacing(self, space: int) -> None: ...
    def layoutMode(self) -> int: ...
    def setLayoutMode(self, mode: int) -> None: ...
    def resizeMode(self) -> int: ...
    def setResizeMode(self, mode: int) -> None: ...
    def isWrapping(self) -> bool: ...
    def setWrapping(self, enable: bool) -> None: ...
    def flow(self) -> int: ...
    def setFlow(self, flow: int) -> None: ...
    def movement(self) -> int: ...
    def setMovement(self, movement: int) -> None: ...


class QListWidgetItem(sip.wrapper):

    ItemType: typing.Type[int]
    #class ItemType(int): ...
    Type = ... # type: int
    UserType = ... # type: int

    @overload
    def __init__(self, parent: typing.Optional[QListWidget] = ..., type: int = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Optional[QListWidget] = ..., type: int = ...) -> None: ...
    @overload
    def __init__(self, icon: QtGui.QIcon, text: str, parent: typing.Optional[QListWidget] = ..., type: int = ...) -> None: ...
    @overload
    def __init__(self, other: QListWidgetItem) -> None: ...

    def isHidden(self) -> bool: ...
    def setHidden(self, ahide: bool) -> None: ...
    def isSelected(self) -> bool: ...
    def setSelected(self, aselect: bool) -> None: ...
    def setForeground(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def foreground(self) -> QtGui.QBrush: ...
    def setBackground(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def background(self) -> QtGui.QBrush: ...
    def setFont(self, afont: QtGui.QFont) -> None: ...
    def setWhatsThis(self, awhatsThis: str) -> None: ...
    def setToolTip(self, atoolTip: str) -> None: ...
    def setStatusTip(self, astatusTip: str) -> None: ...
    def setIcon(self, aicon: QtGui.QIcon) -> None: ...
    def setText(self, atext: str) -> None: ...
    def setFlags(self, aflags: typing.Union[int, int]) -> None: ...
    def type(self) -> int: ...
    def write(self, out: QtCore.QDataStream) -> None: ...
    def read(self, in_: QtCore.QDataStream) -> None: ...
    def setData(self, role: int, value: typing.Any) -> None: ...
    def data(self, role: int) -> typing.Any: ...
    def setSizeHint(self, size: QtCore.QSize) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setCheckState(self, state: int) -> None: ...
    def checkState(self) -> int: ...
    def setTextAlignment(self, alignment: int) -> None: ...
    def textAlignment(self) -> int: ...
    def font(self) -> QtGui.QFont: ...
    def whatsThis(self) -> str: ...
    def toolTip(self) -> str: ...
    def statusTip(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def text(self) -> str: ...
    def flags(self) -> int: ...
    def listWidget(self) -> QListWidget: ...
    def clone(self) -> QListWidgetItem: ...


class QListWidget(QListView):

    currentItemChanged: PYQT_SIGNAL
    currentRowChanged: PYQT_SIGNAL
    currentTextChanged: PYQT_SIGNAL
    itemActivated: PYQT_SIGNAL
    itemChanged: PYQT_SIGNAL
    itemClicked: PYQT_SIGNAL
    itemDoubleClicked: PYQT_SIGNAL
    itemEntered: PYQT_SIGNAL
    itemPressed: PYQT_SIGNAL
    itemSelectionChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def isPersistentEditorOpen(self, item: QListWidgetItem) -> bool: ...
    def setSelectionModel(self, selectionModel: QtCore.QItemSelectionModel) -> None: ...
    def removeItemWidget(self, aItem: QListWidgetItem) -> None: ...
    def dropEvent(self, event: QtGui.QDropEvent) -> None: ...
    def isSortingEnabled(self) -> bool: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def itemFromIndex(self, index: QtCore.QModelIndex) -> QListWidgetItem: ...
    def indexFromItem(self, item: QListWidgetItem) -> QtCore.QModelIndex: ...
    def items(self, data: QtCore.QMimeData) -> typing.List[QListWidgetItem]: ...
    def supportedDropActions(self) -> int: ...
    def dropMimeData(self, index: int, data: QtCore.QMimeData, action: int) -> bool: ...
    def mimeData(self, items: typing.Iterable[QListWidgetItem]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    #def itemSelectionChanged(self) -> None: ...
    #def currentRowChanged(self, currentRow: int) -> None: ...
    #def currentTextChanged(self, currentText: str) -> None: ...
    #def currentItemChanged(self, current: QListWidgetItem, previous: QListWidgetItem) -> None: ...
    #def itemChanged(self, item: QListWidgetItem) -> None: ...
    #def itemEntered(self, item: QListWidgetItem) -> None: ...
    #def itemActivated(self, item: QListWidgetItem) -> None: ...
    #def itemDoubleClicked(self, item: QListWidgetItem) -> None: ...
    #def itemClicked(self, item: QListWidgetItem) -> None: ...
    #def itemPressed(self, item: QListWidgetItem) -> None: ...
    def scrollToItem(self, item: QListWidgetItem, hint: int = ...) -> None: ...
    def clear(self) -> None: ...
    def findItems(self, text: str, flags: typing.Union[int, int]) -> typing.List[QListWidgetItem]: ...
    def selectedItems(self) -> typing.List[QListWidgetItem]: ...
    def closePersistentEditor(self, item: QListWidgetItem) -> None: ...
    def openPersistentEditor(self, item: QListWidgetItem) -> None: ...
    def editItem(self, item: QListWidgetItem) -> None: ...
    def sortItems(self, order: int = ...) -> None: ...
    def visualItemRect(self, item: QListWidgetItem) -> QtCore.QRect: ...
    def setItemWidget(self, item: QListWidgetItem, widget: QWidget) -> None: ...
    def itemWidget(self, item: QListWidgetItem) -> QWidget: ...
    @overload
    def itemAt(self, p: QtCore.QPoint) -> QListWidgetItem: ...
    @overload
    def itemAt(self, ax: int, ay: int) -> QListWidgetItem: ...
    @overload
    def setCurrentRow(self, row: int) -> None: ...
    @overload
    def setCurrentRow(self, row: int, command: typing.Union[int, int]) -> None: ...
    def currentRow(self) -> int: ...
    @overload
    def setCurrentItem(self, item: QListWidgetItem) -> None: ...
    @overload
    def setCurrentItem(self, item: QListWidgetItem, command: typing.Union[int, int]) -> None: ...
    def currentItem(self) -> QListWidgetItem: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def takeItem(self, row: int) -> QListWidgetItem: ...
    def addItems(self, labels: typing.Iterable[str]) -> None: ...
    @overload
    def addItem(self, aitem: QListWidgetItem) -> None: ...
    @overload
    def addItem(self, label: str) -> None: ...
    def insertItems(self, row: int, labels: typing.Iterable[str]) -> None: ...
    @overload
    def insertItem(self, row: int, item: QListWidgetItem) -> None: ...
    @overload
    def insertItem(self, row: int, label: str) -> None: ...
    def row(self, item: QListWidgetItem) -> int: ...
    def item(self, row: int) -> QListWidgetItem: ...


class QMainWindow(QWidget):

    iconSizeChanged: PYQT_SIGNAL
    tabifiedDockWidgetActivated: PYQT_SIGNAL
    toolButtonStyleChanged: PYQT_SIGNAL

    DockOption: typing.Type[int]
    #class DockOption(int): ...
    AnimatedDocks = ... # type: int
    AllowNestedDocks = ... # type: int
    AllowTabbedDocks = ... # type: int
    ForceTabbedDocks = ... # type: int
    VerticalTabs = ... # type: int
    GroupedDragging = ... # type: int

    DockOptions: typing.Type[int]
    #class DockOptions(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QMainWindow.DockOptions, QMainWindow.DockOption]) -> None: ...
        #@overload
        #def __init__(self, a0: QMainWindow.DockOptions) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QMainWindow.DockOptions: ...
        #def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    def resizeDocks(self, docks: typing.Iterable[QDockWidget], sizes: typing.Iterable[int], orientation: int) -> None: ...
    def takeCentralWidget(self) -> QWidget: ...
    def tabifiedDockWidgets(self, dockwidget: QDockWidget) -> typing.List[QDockWidget]: ...
    def setTabPosition(self, areas: typing.Union[int, int], tabPosition: int) -> None: ...
    def tabPosition(self, area: int) -> int: ...
    def setTabShape(self, tabShape: int) -> None: ...
    def tabShape(self) -> int: ...
    def setDocumentMode(self, enabled: bool) -> None: ...
    def documentMode(self) -> bool: ...
    def restoreDockWidget(self, dockwidget: QDockWidget) -> bool: ...
    def unifiedTitleAndToolBarOnMac(self) -> bool: ...
    def setUnifiedTitleAndToolBarOnMac(self, set: bool) -> None: ...
    def toolBarBreak(self, toolbar: QToolBar) -> bool: ...
    def removeToolBarBreak(self, before: QToolBar) -> None: ...
    def dockOptions(self) -> int: ...
    def setDockOptions(self, options: typing.Union[int, int]) -> None: ...
    def tabifyDockWidget(self, first: QDockWidget, second: QDockWidget) -> None: ...
    def setMenuWidget(self, menubar: QWidget) -> None: ...
    def menuWidget(self) -> QWidget: ...
    def isSeparator(self, pos: QtCore.QPoint) -> bool: ...
    def isDockNestingEnabled(self) -> bool: ...
    def isAnimated(self) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def contextMenuEvent(self, event: QtGui.QContextMenuEvent) -> None: ...
    #def tabifiedDockWidgetActivated(self, dockWidget: QDockWidget) -> None: ...
    #def toolButtonStyleChanged(self, toolButtonStyle: int) -> None: ...
    #def iconSizeChanged(self, iconSize: QtCore.QSize) -> None: ...
    def setDockNestingEnabled(self, enabled: bool) -> None: ...
    def setAnimated(self, enabled: bool) -> None: ...
    def createPopupMenu(self) -> QMenu: ...
    def restoreState(self, state: typing.Union[QtCore.QByteArray, bytes, bytearray], version: int = ...) -> bool: ...
    def saveState(self, version: int = ...) -> QtCore.QByteArray: ...
    def dockWidgetArea(self, dockwidget: QDockWidget) -> int: ...
    def removeDockWidget(self, dockwidget: QDockWidget) -> None: ...
    def splitDockWidget(self, after: QDockWidget, dockwidget: QDockWidget, orientation: int) -> None: ...
    @overload
    def addDockWidget(self, area: int, dockwidget: QDockWidget) -> None: ...
    @overload
    def addDockWidget(self, area: int, dockwidget: QDockWidget, orientation: int) -> None: ...
    def toolBarArea(self, toolbar: QToolBar) -> int: ...
    def removeToolBar(self, toolbar: QToolBar) -> None: ...
    def insertToolBar(self, before: QToolBar, toolbar: QToolBar) -> None: ...
    @overload
    def addToolBar(self, area: int, toolbar: QToolBar) -> None: ...
    @overload
    def addToolBar(self, toolbar: QToolBar) -> None: ...
    @overload
    def addToolBar(self, title: str) -> QToolBar: ...
    def insertToolBarBreak(self, before: QToolBar) -> None: ...
    def addToolBarBreak(self, area: int = ...) -> None: ...
    def corner(self, corner: int) -> int: ...
    def setCorner(self, corner: int, area: int) -> None: ...
    def setCentralWidget(self, widget: QWidget) -> None: ...
    def centralWidget(self) -> QWidget: ...
    def setStatusBar(self, statusbar: QStatusBar) -> None: ...
    def statusBar(self) -> QStatusBar: ...
    def setMenuBar(self, menubar: QMenuBar) -> None: ...
    def menuBar(self) -> QMenuBar: ...
    def setToolButtonStyle(self, toolButtonStyle: int) -> None: ...
    def toolButtonStyle(self) -> int: ...
    def setIconSize(self, iconSize: QtCore.QSize) -> None: ...
    def iconSize(self) -> QtCore.QSize: ...


class QMdiArea(QAbstractScrollArea):

    subWindowActivated: PYQT_SIGNAL

    WindowOrder: typing.Type[int]
    #class WindowOrder(int): ...
    CreationOrder = ... # type: int
    StackingOrder = ... # type: int
    ActivationHistoryOrder = ... # type: int

    ViewMode: typing.Type[int]
    #class ViewMode(int): ...
    SubWindowView = ... # type: int
    TabbedView = ... # type: int

    AreaOption: typing.Type[int]
    #class AreaOption(int): ...
    DontMaximizeSubWindowOnActivation = ... # type: int

    AreaOptions: typing.Type[int]
    #class AreaOptions(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QMdiArea.AreaOptions, QMdiArea.AreaOption]) -> None: ...
        #@overload
        #def __init__(self, a0: QMdiArea.AreaOptions) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QMdiArea.AreaOptions: ...
        #def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def tabsMovable(self) -> bool: ...
    def setTabsMovable(self, movable: bool) -> None: ...
    def tabsClosable(self) -> bool: ...
    def setTabsClosable(self, closable: bool) -> None: ...
    def setDocumentMode(self, enabled: bool) -> None: ...
    def documentMode(self) -> bool: ...
    def tabPosition(self) -> int: ...
    def setTabPosition(self, position: int) -> None: ...
    def tabShape(self) -> int: ...
    def setTabShape(self, shape: int) -> None: ...
    def viewMode(self) -> int: ...
    def setViewMode(self, mode: int) -> None: ...
    def setActivationOrder(self, order: int) -> None: ...
    def activationOrder(self) -> int: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def viewportEvent(self, event: QtCore.QEvent) -> bool: ...
    def showEvent(self, showEvent: QtGui.QShowEvent) -> None: ...
    def timerEvent(self, timerEvent: QtCore.QTimerEvent) -> None: ...
    def resizeEvent(self, resizeEvent: QtGui.QResizeEvent) -> None: ...
    def childEvent(self, childEvent: QtCore.QChildEvent) -> None: ...
    def paintEvent(self, paintEvent: QtGui.QPaintEvent) -> None: ...
    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def setupViewport(self, viewport: QWidget) -> None: ...
    def activatePreviousSubWindow(self) -> None: ...
    def activateNextSubWindow(self) -> None: ...
    def closeAllSubWindows(self) -> None: ...
    def closeActiveSubWindow(self) -> None: ...
    def cascadeSubWindows(self) -> None: ...
    def tileSubWindows(self) -> None: ...
    def setActiveSubWindow(self, window: QMdiSubWindow) -> None: ...
    #def subWindowActivated(self, a0: QMdiSubWindow) -> None: ...
    def testOption(self, opton: int) -> bool: ...
    def setOption(self, option: int, on: bool = ...) -> None: ...
    def setBackground(self, background: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def background(self) -> QtGui.QBrush: ...
    def removeSubWindow(self, widget: QWidget) -> None: ...
    def currentSubWindow(self) -> QMdiSubWindow: ...
    def subWindowList(self, order: int = ...) -> typing.List[QMdiSubWindow]: ...
    def addSubWindow(self, widget: QWidget, flags: typing.Union[int, int] = ...) -> QMdiSubWindow: ...
    def activeSubWindow(self) -> QMdiSubWindow: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QMdiSubWindow(QWidget):

    aboutToActivate: PYQT_SIGNAL
    windowStateChanged: PYQT_SIGNAL

    SubWindowOption: typing.Type[int]
    #class SubWindowOption(int): ...
    RubberBandResize = ... # type: int
    RubberBandMove = ... # type: int

    SubWindowOptions: typing.Type[int]
    #class SubWindowOptions(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QMdiSubWindow.SubWindowOptions, QMdiSubWindow.SubWindowOption]) -> None: ...
        #@overload
        #def __init__(self, a0: QMdiSubWindow.SubWindowOptions) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QMdiSubWindow.SubWindowOptions: ...
        #def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    def childEvent(self, childEvent: QtCore.QChildEvent) -> None: ...
    def focusOutEvent(self, focusOutEvent: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, focusInEvent: QtGui.QFocusEvent) -> None: ...
    def contextMenuEvent(self, contextMenuEvent: QtGui.QContextMenuEvent) -> None: ...
    def keyPressEvent(self, keyEvent: QtGui.QKeyEvent) -> None: ...
    def mouseMoveEvent(self, mouseEvent: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, mouseEvent: QtGui.QMouseEvent) -> None: ...
    def mouseDoubleClickEvent(self, mouseEvent: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, mouseEvent: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, paintEvent: QtGui.QPaintEvent) -> None: ...
    def moveEvent(self, moveEvent: QtGui.QMoveEvent) -> None: ...
    def timerEvent(self, timerEvent: QtCore.QTimerEvent) -> None: ...
    def resizeEvent(self, resizeEvent: QtGui.QResizeEvent) -> None: ...
    def leaveEvent(self, leaveEvent: QtCore.QEvent) -> None: ...
    def closeEvent(self, closeEvent: QtGui.QCloseEvent) -> None: ...
    def changeEvent(self, changeEvent: QtCore.QEvent) -> None: ...
    def hideEvent(self, hideEvent: QtGui.QHideEvent) -> None: ...
    def showEvent(self, showEvent: QtGui.QShowEvent) -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def showShaded(self) -> None: ...
    def showSystemMenu(self) -> None: ...
    #def aboutToActivate(self) -> None: ...
    #def windowStateChanged(self, oldState: typing.Union[int, int], newState: typing.Union[int, int]) -> None: ...
    def mdiArea(self) -> QMdiArea: ...
    def systemMenu(self) -> QMenu: ...
    def setSystemMenu(self, systemMenu: QMenu) -> None: ...
    def keyboardPageStep(self) -> int: ...
    def setKeyboardPageStep(self, step: int) -> None: ...
    def keyboardSingleStep(self) -> int: ...
    def setKeyboardSingleStep(self, step: int) -> None: ...
    def testOption(self, a0: int) -> bool: ...
    def setOption(self, option: int, on: bool = ...) -> None: ...
    def isShaded(self) -> bool: ...
    def widget(self) -> QWidget: ...
    def setWidget(self, widget: QWidget) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QMenu(QWidget):

    aboutToHide: PYQT_SIGNAL
    aboutToShow: PYQT_SIGNAL
    hovered: PYQT_SIGNAL
    triggered: PYQT_SIGNAL

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, title: str, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    @overload
    def showTearOffMenu(self) -> None: ...
    @overload
    def showTearOffMenu(self, pos: QtCore.QPoint) -> None: ...
    def setToolTipsVisible(self, visible: bool) -> None: ...
    def toolTipsVisible(self) -> bool: ...
    @overload
    def insertSection(self, before: QAction, text: str) -> QAction: ...
    @overload
    def insertSection(self, before: QAction, icon: QtGui.QIcon, text: str) -> QAction: ...
    @overload
    def addSection(self, text: str) -> QAction: ...
    @overload
    def addSection(self, icon: QtGui.QIcon, text: str) -> QAction: ...
    def setSeparatorsCollapsible(self, collapse: bool) -> None: ...
    def separatorsCollapsible(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def timerEvent(self, a0: QtCore.QTimerEvent) -> None: ...
    def actionEvent(self, a0: QtGui.QActionEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def hideEvent(self, a0: QtGui.QHideEvent) -> None: ...
    def leaveEvent(self, a0: QtCore.QEvent) -> None: ...
    def enterEvent(self, a0: QtCore.QEvent) -> None: ...
    def wheelEvent(self, a0: QtGui.QWheelEvent) -> None: ...
    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def initStyleOption(self, option: QStyleOptionMenuItem, action: QAction) -> None: ...
    def columnCount(self) -> int: ...
    #def triggered(self, action: QAction) -> None: ...
    #def hovered(self, action: QAction) -> None: ...
    #def aboutToShow(self) -> None: ...
    #def aboutToHide(self) -> None: ...
    def setNoReplayFor(self, widget: QWidget) -> None: ...
    def setIcon(self, icon: QtGui.QIcon) -> None: ...
    def icon(self) -> QtGui.QIcon: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...
    def menuAction(self) -> QAction: ...
    def actionAt(self, a0: QtCore.QPoint) -> QAction: ...
    def actionGeometry(self, a0: QAction) -> QtCore.QRect: ...
    def sizeHint(self) -> QtCore.QSize: ...
    @overload
    def exec(self) -> QAction: ...
    @overload
    def exec(self, pos: QtCore.QPoint, action: typing.Optional[QAction] = ...) -> QAction: ...
    #@overload
    #@staticmethod
    #def exec(actions: typing.Iterable[QAction], pos: QtCore.QPoint, at: typing.Optional[QAction] = ..., parent: typing.Optional[QWidget] = ...) -> QAction: ...
    @overload
    def exec_(self) -> QAction: ...
    @overload
    def exec_(self, p: QtCore.QPoint, action: typing.Optional[QAction] = ...) -> QAction: ...
    #@overload
    #@staticmethod
    #def exec_(actions: typing.Iterable[QAction], pos: QtCore.QPoint, at: typing.Optional[QAction] = ..., parent: typing.Optional[QWidget] = ...) -> QAction: ...
    def popup(self, p: QtCore.QPoint, action: typing.Optional[QAction] = ...) -> None: ...
    def activeAction(self) -> QAction: ...
    def setActiveAction(self, act: QAction) -> None: ...
    def defaultAction(self) -> QAction: ...
    def setDefaultAction(self, a0: QAction) -> None: ...
    def hideTearOffMenu(self) -> None: ...
    def isTearOffMenuVisible(self) -> bool: ...
    def isTearOffEnabled(self) -> bool: ...
    def setTearOffEnabled(self, a0: bool) -> None: ...
    def clear(self) -> None: ...
    def insertSeparator(self, before: QAction) -> QAction: ...
    def insertMenu(self, before: QAction, menu: QMenu) -> QAction: ...
    def addSeparator(self) -> QAction: ...
    @overload
    def addMenu(self, menu: QMenu) -> QAction: ...
    @overload
    def addMenu(self, title: str) -> QMenu: ...
    @overload
    def addMenu(self, icon: QtGui.QIcon, title: str) -> QMenu: ...
    @overload
    def addAction(self, action: QAction) -> None: ...
    @overload
    def addAction(self, text: str) -> QAction: ...
    @overload
    def addAction(self, icon: QtGui.QIcon, text: str) -> QAction: ...
    @overload
    def addAction(self, text: str, slot: PYQT_SLOT, shortcut: typing.Union[QtGui.QKeySequence, int, str, int] = ...) -> QAction: ...
    @overload
    def addAction(self, icon: QtGui.QIcon, text: str, slot: PYQT_SLOT, shortcut: typing.Union[QtGui.QKeySequence, int, str, int] = ...) -> QAction: ...


class QMenuBar(QWidget):

    hovered: PYQT_SIGNAL
    triggered: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def setNativeMenuBar(self, nativeMenuBar: bool) -> None: ...
    def isNativeMenuBar(self) -> bool: ...
    def timerEvent(self, a0: QtCore.QTimerEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def focusInEvent(self, a0: QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, a0: QtGui.QFocusEvent) -> None: ...
    def actionEvent(self, a0: QtGui.QActionEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def leaveEvent(self, a0: QtCore.QEvent) -> None: ...
    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def initStyleOption(self, option: QStyleOptionMenuItem, action: QAction) -> None: ...
    #def hovered(self, action: QAction) -> None: ...
    #def triggered(self, action: QAction) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def cornerWidget(self, corner: int = ...) -> QWidget: ...
    def setCornerWidget(self, widget: QWidget, corner: int = ...) -> None: ...
    def actionAt(self, a0: QtCore.QPoint) -> QAction: ...
    def actionGeometry(self, a0: QAction) -> QtCore.QRect: ...
    def heightForWidth(self, a0: int) -> int: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def isDefaultUp(self) -> bool: ...
    def setDefaultUp(self, a0: bool) -> None: ...
    def setActiveAction(self, action: QAction) -> None: ...
    def activeAction(self) -> QAction: ...
    def clear(self) -> None: ...
    def insertSeparator(self, before: QAction) -> QAction: ...
    def insertMenu(self, before: QAction, menu: QMenu) -> QAction: ...
    def addSeparator(self) -> QAction: ...
    @overload
    def addMenu(self, menu: QMenu) -> QAction: ...
    @overload
    def addMenu(self, title: str) -> QMenu: ...
    @overload
    def addMenu(self, icon: QtGui.QIcon, title: str) -> QMenu: ...
    @overload
    def addAction(self, action: QAction) -> None: ...
    @overload
    def addAction(self, text: str) -> QAction: ...
    @overload
    def addAction(self, text: str, slot: PYQT_SLOT) -> QAction: ...


class QMessageBox(QDialog):

    buttonClicked: PYQT_SIGNAL

    class StandardButton(int):
        NoButton = ... # type: QMessageBox.StandardButton
        Ok = ... # type: QMessageBox.StandardButton
        Save = ... # type: QMessageBox.StandardButton
        SaveAll = ... # type: QMessageBox.StandardButton
        Open = ... # type: QMessageBox.StandardButton
        Yes = ... # type: QMessageBox.StandardButton
        YesToAll = ... # type: QMessageBox.StandardButton
        No = ... # type: QMessageBox.StandardButton
        NoToAll = ... # type: QMessageBox.StandardButton
        Abort = ... # type: QMessageBox.StandardButton
        Retry = ... # type: QMessageBox.StandardButton
        Ignore = ... # type: QMessageBox.StandardButton
        Close = ... # type: QMessageBox.StandardButton
        Cancel = ... # type: QMessageBox.StandardButton
        Discard = ... # type: QMessageBox.StandardButton
        Help = ... # type: QMessageBox.StandardButton
        Apply = ... # type: QMessageBox.StandardButton
        Reset = ... # type: QMessageBox.StandardButton
        RestoreDefaults = ... # type: QMessageBox.StandardButton
        FirstButton = ... # type: QMessageBox.StandardButton
        LastButton = ... # type: QMessageBox.StandardButton
        YesAll = ... # type: QMessageBox.StandardButton
        NoAll = ... # type: QMessageBox.StandardButton
        Default = ... # type: QMessageBox.StandardButton
        Escape = ... # type: QMessageBox.StandardButton
        FlagMask = ... # type: QMessageBox.StandardButton
        ButtonMask = ... # type: QMessageBox.StandardButton

    class Icon(int):
        NoIcon = ... # type: QMessageBox.Icon
        Information = ... # type: QMessageBox.Icon
        Warning = ... # type: QMessageBox.Icon
        Critical = ... # type: QMessageBox.Icon
        Question = ... # type: QMessageBox.Icon

    class ButtonRole(int):
        InvalidRole = ... # type: QMessageBox.ButtonRole
        AcceptRole = ... # type: QMessageBox.ButtonRole
        RejectRole = ... # type: QMessageBox.ButtonRole
        DestructiveRole = ... # type: QMessageBox.ButtonRole
        ActionRole = ... # type: QMessageBox.ButtonRole
        HelpRole = ... # type: QMessageBox.ButtonRole
        YesRole = ... # type: QMessageBox.ButtonRole
        NoRole = ... # type: QMessageBox.ButtonRole
        ResetRole = ... # type: QMessageBox.ButtonRole
        ApplyRole = ... # type: QMessageBox.ButtonRole

    StandardButtons: typing.Type[int]
    #class StandardButtons(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QMessageBox.StandardButtons, QMessageBox.StandardButton]) -> None: ...
        #@overload
        #def __init__(self, a0: QMessageBox.StandardButtons) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QMessageBox.StandardButtons: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, icon: int, title: str, text: str, buttons: typing.Union[int, int] = ..., parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    def checkBox(self) -> QCheckBox: ...
    def setCheckBox(self, cb: QCheckBox) -> None: ...
    def textInteractionFlags(self) -> int: ...
    def setTextInteractionFlags(self, flags: typing.Union[int, int]) -> None: ...
    #def buttonClicked(self, button: QAbstractButton) -> None: ...
    def buttonRole(self, button: QAbstractButton) -> int: ...
    def buttons(self) -> typing.List[QAbstractButton]: ...
    @overload
    def open(self) -> None: ...
    @overload
    def open(self, slot: PYQT_SLOT) -> None: ...
    def setWindowModality(self, windowModality: int) -> None: ...
    def setWindowTitle(self, title: str) -> None: ...
    def setDetailedText(self, text: str) -> None: ...
    def detailedText(self) -> str: ...
    def setInformativeText(self, text: str) -> None: ...
    def informativeText(self) -> str: ...
    def clickedButton(self) -> QAbstractButton: ...
    @overload
    def setEscapeButton(self, button: QAbstractButton) -> None: ...
    @overload
    def setEscapeButton(self, button: int) -> None: ...
    def escapeButton(self) -> QAbstractButton: ...
    @overload
    def setDefaultButton(self, button: QPushButton) -> None: ...
    @overload
    def setDefaultButton(self, button: int) -> None: ...
    def defaultButton(self) -> QPushButton: ...
    def button(self, which: int) -> QAbstractButton: ...
    def standardButton(self, button: QAbstractButton) -> int: ...
    def standardButtons(self) -> int: ...
    def setStandardButtons(self, buttons: typing.Union[int, int]) -> None: ...
    def removeButton(self, button: QAbstractButton) -> None: ...
    @overload
    def addButton(self, button: QAbstractButton, role: int) -> None: ...
    @overload
    def addButton(self, text: str, role: int) -> QPushButton: ...
    @overload
    def addButton(self, button: int) -> QPushButton: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def closeEvent(self, a0: QtGui.QCloseEvent) -> None: ...
    def showEvent(self, a0: QtGui.QShowEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    @staticmethod
    def standardIcon(icon: int) -> QtGui.QPixmap: ...
    @staticmethod
    def aboutQt(parent: typing.Optional[QWidget], title: str = ...) -> None: ...
    @staticmethod
    def about(parent: typing.Optional[QWidget], caption: str, text: str) -> None: ...
    @staticmethod
    def critical(parent: typing.Optional[QWidget], title: str, text: str, buttons: typing.Union[int, int] = ..., defaultButton: int = ...) -> int: ...
    @staticmethod
    def warning(parent: typing.Optional[QWidget], title: str, text: str, buttons: typing.Union[int, int] = ..., defaultButton: int = ...) -> int: ...
    @staticmethod
    def question(parent: typing.Optional[QWidget], title: str, text: str, buttons: typing.Union[int, int] = ..., defaultButton: int = ...) -> int: ...
    @staticmethod
    def information(parent: typing.Optional[QWidget], title: str, text: str, buttons: typing.Union[int, int] = ..., defaultButton: int = ...) -> int: ...
    def setTextFormat(self, a0: int) -> None: ...
    def textFormat(self) -> int: ...
    def setIconPixmap(self, a0: QtGui.QPixmap) -> None: ...
    def iconPixmap(self) -> QtGui.QPixmap: ...
    def setIcon(self, a0: int) -> None: ...
    def icon(self) -> int: ...
    def setText(self, a0: str) -> None: ...
    def text(self) -> str: ...


class QMouseEventTransition(QtCore.QEventTransition):

    @overload
    def __init__(self, sourceState: typing.Optional[QtCore.QState] = ..., **props) -> None: ...
    @overload
    def __init__(self, object: QtCore.QObject, type: int, button: int, sourceState: typing.Optional[QtCore.QState] = ..., **props) -> None: ...

    def eventTest(self, event: QtCore.QEvent) -> bool: ...
    def onTransition(self, event: QtCore.QEvent) -> None: ...
    def setHitTestPath(self, path: QtGui.QPainterPath) -> None: ...
    def hitTestPath(self) -> QtGui.QPainterPath: ...
    def setModifierMask(self, modifiers: typing.Union[int, int]) -> None: ...
    def modifierMask(self) -> int: ...
    def setButton(self, button: int) -> None: ...
    def button(self) -> int: ...


class QOpenGLWidget(QWidget):

    aboutToCompose: PYQT_SIGNAL
    aboutToResize: PYQT_SIGNAL
    frameSwapped: PYQT_SIGNAL
    resized: PYQT_SIGNAL

    UpdateBehavior: typing.Type[int]
    #class UpdateBehavior(int): ...
    NoPartialUpdate = ... # type: int
    PartialUpdate = ... # type: int

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    def setTextureFormat(self, texFormat: int) -> None: ...
    def textureFormat(self) -> int: ...
    def updateBehavior(self) -> int: ...
    def setUpdateBehavior(self, updateBehavior: int) -> None: ...
    def paintEngine(self) -> QtGui.QPaintEngine: ...
    def metric(self, metric: int) -> int: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def resizeEvent(self, e: QtGui.QResizeEvent) -> None: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def paintGL(self) -> None: ...
    def resizeGL(self, w: int, h: int) -> None: ...
    def initializeGL(self) -> None: ...
    #def resized(self) -> None: ...
    #def aboutToResize(self) -> None: ...
    #def frameSwapped(self) -> None: ...
    #def aboutToCompose(self) -> None: ...
    def grabFramebuffer(self) -> QtGui.QImage: ...
    def defaultFramebufferObject(self) -> int: ...
    def context(self) -> QtGui.QOpenGLContext: ...
    def doneCurrent(self) -> None: ...
    def makeCurrent(self) -> None: ...
    def isValid(self) -> bool: ...
    def format(self) -> QtGui.QSurfaceFormat: ...
    def setFormat(self, format: QtGui.QSurfaceFormat) -> None: ...


class QPlainTextEdit(QAbstractScrollArea):

    blockCountChanged: PYQT_SIGNAL
    copyAvailable: PYQT_SIGNAL
    cursorPositionChanged: PYQT_SIGNAL
    modificationChanged: PYQT_SIGNAL
    redoAvailable: PYQT_SIGNAL
    selectionChanged: PYQT_SIGNAL
    textChanged: PYQT_SIGNAL
    undoAvailable: PYQT_SIGNAL
    updateRequest: PYQT_SIGNAL

    class LineWrapMode(int):
        NoWrap = ... # type: QPlainTextEdit.LineWrapMode
        WidgetWidth = ... # type: QPlainTextEdit.LineWrapMode

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def setTabStopDistance(self, distance: float) -> None: ...
    def tabStopDistance(self) -> float: ...
    def placeholderText(self) -> str: ...
    def setPlaceholderText(self, placeholderText: str) -> None: ...
    def zoomOut(self, range: int = ...) -> None: ...
    def zoomIn(self, range: int = ...) -> None: ...
    def anchorAt(self, pos: QtCore.QPoint) -> str: ...
    def getPaintContext(self) -> QtGui.QAbstractTextDocumentLayout.PaintContext: ...
    def blockBoundingGeometry(self, block: QtGui.QTextBlock) -> QtCore.QRectF: ...
    def blockBoundingRect(self, block: QtGui.QTextBlock) -> QtCore.QRectF: ...
    def contentOffset(self) -> QtCore.QPointF: ...
    def firstVisibleBlock(self) -> QtGui.QTextBlock: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def insertFromMimeData(self, source: QtCore.QMimeData) -> None: ...
    def canInsertFromMimeData(self, source: QtCore.QMimeData) -> bool: ...
    def createMimeDataFromSelection(self) -> QtCore.QMimeData: ...
    @overload
    def inputMethodQuery(self, property: int) -> typing.Any: ...
    @overload
    def inputMethodQuery(self, query: int, argument: typing.Any) -> typing.Any: ...
    def inputMethodEvent(self, a0: QtGui.QInputMethodEvent) -> None: ...
    def wheelEvent(self, e: QtGui.QWheelEvent) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def showEvent(self, a0: QtGui.QShowEvent) -> None: ...
    def focusOutEvent(self, e: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, e: QtGui.QFocusEvent) -> None: ...
    def dropEvent(self, e: QtGui.QDropEvent) -> None: ...
    def dragMoveEvent(self, e: QtGui.QDragMoveEvent) -> None: ...
    def dragLeaveEvent(self, e: QtGui.QDragLeaveEvent) -> None: ...
    def dragEnterEvent(self, e: QtGui.QDragEnterEvent) -> None: ...
    def contextMenuEvent(self, e: QtGui.QContextMenuEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def mouseDoubleClickEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, e: QtGui.QResizeEvent) -> None: ...
    def keyReleaseEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def timerEvent(self, e: QtCore.QTimerEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    #def modificationChanged(self, a0: bool) -> None: ...
    #def blockCountChanged(self, newBlockCount: int) -> None: ...
    #def updateRequest(self, rect: QtCore.QRect, dy: int) -> None: ...
    #def cursorPositionChanged(self) -> None: ...
    #def selectionChanged(self) -> None: ...
    #def copyAvailable(self, b: bool) -> None: ...
    #def redoAvailable(self, b: bool) -> None: ...
    #def undoAvailable(self, b: bool) -> None: ...
    #def textChanged(self) -> None: ...
    def centerCursor(self) -> None: ...
    def appendHtml(self, html: str) -> None: ...
    def appendPlainText(self, text: str) -> None: ...
    def insertPlainText(self, text: str) -> None: ...
    def selectAll(self) -> None: ...
    def clear(self) -> None: ...
    def redo(self) -> None: ...
    def undo(self) -> None: ...
    def paste(self) -> None: ...
    def copy(self) -> None: ...
    def cut(self) -> None: ...
    def setPlainText(self, text: str) -> None: ...
    def blockCount(self) -> int: ...
    def print(self, printer: QtGui.QPagedPaintDevice) -> None: ...
    def print_(self, printer: QtGui.QPagedPaintDevice) -> None: ...
    def canPaste(self) -> bool: ...
    def moveCursor(self, operation: int, mode: int = ...) -> None: ...
    def extraSelections(self) -> typing.List[QTextEdit.ExtraSelection]: ...
    def setExtraSelections(self, selections: typing.Iterable[QTextEdit.ExtraSelection]) -> None: ...
    def setCursorWidth(self, width: int) -> None: ...
    def cursorWidth(self) -> int: ...
    def setTabStopWidth(self, width: int) -> None: ...
    def tabStopWidth(self) -> int: ...
    def setOverwriteMode(self, overwrite: bool) -> None: ...
    def overwriteMode(self) -> bool: ...
    @overload
    def cursorRect(self, cursor: QtGui.QTextCursor) -> QtCore.QRect: ...
    @overload
    def cursorRect(self) -> QtCore.QRect: ...
    def cursorForPosition(self, pos: QtCore.QPoint) -> QtGui.QTextCursor: ...
    @overload
    def createStandardContextMenu(self) -> QMenu: ...
    @overload
    def createStandardContextMenu(self, position: QtCore.QPoint) -> QMenu: ...
    def loadResource(self, type: int, name: QtCore.QUrl) -> typing.Any: ...
    def ensureCursorVisible(self) -> None: ...
    def toPlainText(self) -> str: ...
    @overload
    def find(self, exp: str, options: typing.Union[int, int] = ...) -> bool: ...
    @overload
    def find(self, exp: QtCore.QRegExp, options: typing.Union[int, int] = ...) -> bool: ...
    def centerOnScroll(self) -> bool: ...
    def setCenterOnScroll(self, enabled: bool) -> None: ...
    def backgroundVisible(self) -> bool: ...
    def setBackgroundVisible(self, visible: bool) -> None: ...
    def setWordWrapMode(self, policy: int) -> None: ...
    def wordWrapMode(self) -> int: ...
    def setLineWrapMode(self, mode: int) -> None: ...
    def lineWrapMode(self) -> int: ...
    def maximumBlockCount(self) -> int: ...
    def setMaximumBlockCount(self, maximum: int) -> None: ...
    def setUndoRedoEnabled(self, enable: bool) -> None: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def documentTitle(self) -> str: ...
    def setDocumentTitle(self, title: str) -> None: ...
    def setTabChangesFocus(self, b: bool) -> None: ...
    def tabChangesFocus(self) -> bool: ...
    def currentCharFormat(self) -> QtGui.QTextCharFormat: ...
    def setCurrentCharFormat(self, format: QtGui.QTextCharFormat) -> None: ...
    def mergeCurrentCharFormat(self, modifier: QtGui.QTextCharFormat) -> None: ...
    def textInteractionFlags(self) -> int: ...
    def setTextInteractionFlags(self, flags: typing.Union[int, int]) -> None: ...
    def setReadOnly(self, ro: bool) -> None: ...
    def isReadOnly(self) -> bool: ...
    def textCursor(self) -> QtGui.QTextCursor: ...
    def setTextCursor(self, cursor: QtGui.QTextCursor) -> None: ...
    def document(self) -> QtGui.QTextDocument: ...
    def setDocument(self, document: QtGui.QTextDocument) -> None: ...


class QPlainTextDocumentLayout(QtGui.QAbstractTextDocumentLayout):

    def __init__(self, document: QtGui.QTextDocument, **props) -> None: ...

    def documentChanged(self, from_: int, a1: int, charsAdded: int) -> None: ...
    def requestUpdate(self) -> None: ...
    def cursorWidth(self) -> int: ...
    def setCursorWidth(self, width: int) -> None: ...
    def ensureBlockLayout(self, block: QtGui.QTextBlock) -> None: ...
    def blockBoundingRect(self, block: QtGui.QTextBlock) -> QtCore.QRectF: ...
    def frameBoundingRect(self, a0: QtGui.QTextFrame) -> QtCore.QRectF: ...
    def documentSize(self) -> QtCore.QSizeF: ...
    def pageCount(self) -> int: ...
    def hitTest(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint], a1: int) -> int: ...
    def draw(self, a0: QtGui.QPainter, a1: QtGui.QAbstractTextDocumentLayout.PaintContext) -> None: ...


class QProgressBar(QWidget):

    valueChanged: PYQT_SIGNAL

    Direction: typing.Type[int]
    #class Direction(int): ...
    TopToBottom = ... # type: int
    BottomToTop = ... # type: int

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: QStyleOptionProgressBar) -> None: ...
    #def valueChanged(self, value: int) -> None: ...
    def setOrientation(self, a0: int) -> None: ...
    def setValue(self, value: int) -> None: ...
    def setMaximum(self, maximum: int) -> None: ...
    def setMinimum(self, minimum: int) -> None: ...
    def reset(self) -> None: ...
    def resetFormat(self) -> None: ...
    def format(self) -> str: ...
    def setFormat(self, format: str) -> None: ...
    def setTextDirection(self, textDirection: int) -> None: ...
    def setInvertedAppearance(self, invert: bool) -> None: ...
    def orientation(self) -> int: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setAlignment(self, alignment: typing.Union[int, int]) -> None: ...
    def alignment(self) -> int: ...
    def isTextVisible(self) -> bool: ...
    def setTextVisible(self, visible: bool) -> None: ...
    def text(self) -> str: ...
    def value(self) -> int: ...
    def setRange(self, minimum: int, maximum: int) -> None: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...


class QProgressDialog(QDialog):

    canceled: PYQT_SIGNAL

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...
    @overload
    def __init__(self, labelText: str, cancelButtonText: str, minimum: int, maximum: int, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    @overload
    def open(self) -> None: ...
    @overload
    def open(self, slot: PYQT_SLOT) -> None: ...
    def forceShow(self) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def closeEvent(self, a0: QtGui.QCloseEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    #def canceled(self) -> None: ...
    def setMinimumDuration(self, ms: int) -> None: ...
    def setCancelButtonText(self, a0: str) -> None: ...
    def setLabelText(self, a0: str) -> None: ...
    def setValue(self, progress: int) -> None: ...
    def setMinimum(self, minimum: int) -> None: ...
    def setMaximum(self, maximum: int) -> None: ...
    def reset(self) -> None: ...
    def cancel(self) -> None: ...
    def autoClose(self) -> bool: ...
    def setAutoClose(self, b: bool) -> None: ...
    def autoReset(self) -> bool: ...
    def setAutoReset(self, b: bool) -> None: ...
    def minimumDuration(self) -> int: ...
    def labelText(self) -> str: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def value(self) -> int: ...
    def setRange(self, minimum: int, maximum: int) -> None: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def wasCanceled(self) -> bool: ...
    def setBar(self, bar: QProgressBar) -> None: ...
    def setCancelButton(self, button: QPushButton) -> None: ...
    def setLabel(self, label: QLabel) -> None: ...


class QProxyStyle(QCommonStyle):

    @overload
    def __init__(self, style: typing.Optional[QStyle] = ..., **props) -> None: ...
    @overload
    def __init__(self, key: str, **props) -> None: ...

    def event(self, e: QtCore.QEvent) -> bool: ...
    @overload
    def unpolish(self, widget: QWidget) -> None: ...
    @overload
    def unpolish(self, app: QApplication) -> None: ...
    @overload
    def polish(self, widget: QWidget) -> None: ...
    @overload
    def polish(self, pal: QtGui.QPalette) -> QtGui.QPalette: ...
    @overload
    def polish(self, app: QApplication) -> None: ...
    def standardPalette(self) -> QtGui.QPalette: ...
    def generatedIconPixmap(self, iconMode: int, pixmap: QtGui.QPixmap, opt: QStyleOption) -> QtGui.QPixmap: ...
    def standardPixmap(self, standardPixmap: int, opt: QStyleOption, widget: typing.Optional[QWidget] = ...) -> QtGui.QPixmap: ...
    def standardIcon(self, standardIcon: int, option: typing.Optional[QStyleOption] = ..., widget: typing.Optional[QWidget] = ...) -> QtGui.QIcon: ...
    def layoutSpacing(self, control1: int, control2: int, orientation: int, option: typing.Optional[QStyleOption] = ..., widget: typing.Optional[QWidget] = ...) -> int: ...
    def pixelMetric(self, metric: int, option: typing.Optional[QStyleOption] = ..., widget: typing.Optional[QWidget] = ...) -> int: ...
    def styleHint(self, hint: int, option: typing.Optional[QStyleOption] = ..., widget: typing.Optional[QWidget] = ..., returnData: typing.Optional[QStyleHintReturn] = ...) -> int: ...
    def hitTestComplexControl(self, control: int, option: QStyleOptionComplex, pos: QtCore.QPoint, widget: typing.Optional[QWidget] = ...) -> int: ...
    def itemPixmapRect(self, r: QtCore.QRect, flags: int, pixmap: QtGui.QPixmap) -> QtCore.QRect: ...
    def itemTextRect(self, fm: QtGui.QFontMetrics, r: QtCore.QRect, flags: int, enabled: bool, text: str) -> QtCore.QRect: ...
    def subControlRect(self, cc: int, opt: QStyleOptionComplex, sc: int, widget: QWidget) -> QtCore.QRect: ...
    def subElementRect(self, element: int, option: QStyleOption, widget: QWidget) -> QtCore.QRect: ...
    def sizeFromContents(self, type: int, option: QStyleOption, size: QtCore.QSize, widget: QWidget) -> QtCore.QSize: ...
    def drawItemPixmap(self, painter: QtGui.QPainter, rect: QtCore.QRect, alignment: int, pixmap: QtGui.QPixmap) -> None: ...
    def drawItemText(self, painter: QtGui.QPainter, rect: QtCore.QRect, flags: int, pal: QtGui.QPalette, enabled: bool, text: str, textRole: int = ...) -> None: ...
    def drawComplexControl(self, control: int, option: QStyleOptionComplex, painter: QtGui.QPainter, widget: typing.Optional[QWidget] = ...) -> None: ...
    def drawControl(self, element: int, option: QStyleOption, painter: QtGui.QPainter, widget: typing.Optional[QWidget] = ...) -> None: ...
    def drawPrimitive(self, element: int, option: QStyleOption, painter: QtGui.QPainter, widget: typing.Optional[QWidget] = ...) -> None: ...
    def setBaseStyle(self, style: QStyle) -> None: ...
    def baseStyle(self) -> QStyle: ...


class QRadioButton(QAbstractButton):

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def hitButton(self, a0: QtCore.QPoint) -> bool: ...
    def initStyleOption(self, button: QStyleOptionButton) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QRubberBand(QWidget):

    Shape: typing.Type[int]
    #class Shape(int): ...
    Line = ... # type: int
    Rectangle = ... # type: int

    def __init__(self, a0: int, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def moveEvent(self, a0: QtGui.QMoveEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def showEvent(self, a0: QtGui.QShowEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: QStyleOptionRubberBand) -> None: ...
    @overload
    def resize(self, w: int, h: int) -> None: ...
    @overload
    def resize(self, s: QtCore.QSize) -> None: ...
    @overload
    def move(self, p: QtCore.QPoint) -> None: ...
    @overload
    def move(self, ax: int, ay: int) -> None: ...
    @overload
    def setGeometry(self, r: QtCore.QRect) -> None: ...
    @overload
    def setGeometry(self, ax: int, ay: int, aw: int, ah: int) -> None: ...
    def shape(self) -> int: ...


class QScrollArea(QAbstractScrollArea):

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def viewportSizeHint(self) -> QtCore.QSize: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def ensureWidgetVisible(self, childWidget: QWidget, xMargin: int = ..., yMargin: int = ...) -> None: ...
    def ensureVisible(self, x: int, y: int, xMargin: int = ..., yMargin: int = ...) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setAlignment(self, a0: typing.Union[int, int]) -> None: ...
    def alignment(self) -> int: ...
    def setWidgetResizable(self, resizable: bool) -> None: ...
    def widgetResizable(self) -> bool: ...
    def takeWidget(self) -> QWidget: ...
    def setWidget(self, w: QWidget) -> None: ...
    def widget(self) -> QWidget: ...


class QScrollBar(QAbstractSlider):

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, orientation: int, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def sliderChange(self, change: int) -> None: ...
    def wheelEvent(self, a0: QtGui.QWheelEvent) -> None: ...
    def contextMenuEvent(self, a0: QtGui.QContextMenuEvent) -> None: ...
    def hideEvent(self, a0: QtGui.QHideEvent) -> None: ...
    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def initStyleOption(self, option: QStyleOptionSlider) -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QScroller(QtCore.QObject):

    scrollerPropertiesChanged: PYQT_SIGNAL
    stateChanged: PYQT_SIGNAL

    Input: typing.Type[int]
    #class Input(int): ...
    InputPress = ... # type: int
    InputMove = ... # type: int
    InputRelease = ... # type: int

    ScrollerGestureType: typing.Type[int]
    #class ScrollerGestureType(int): ...
    TouchGesture = ... # type: int
    LeftMouseButtonGesture = ... # type: int
    RightMouseButtonGesture = ... # type: int
    MiddleMouseButtonGesture = ... # type: int

    State: typing.Type[int]
    #class State(int): ...
    Inactive = ... # type: int
    Pressed = ... # type: int
    Dragging = ... # type: int
    Scrolling = ... # type: int

    #def scrollerPropertiesChanged(self, a0: QScrollerProperties) -> None: ...
    #def stateChanged(self, newstate: int) -> None: ...
    def resendPrepareEvent(self) -> None: ...
    @overload
    def ensureVisible(self, rect: QtCore.QRectF, xmargin: float, ymargin: float) -> None: ...
    @overload
    def ensureVisible(self, rect: QtCore.QRectF, xmargin: float, ymargin: float, scrollTime: int) -> None: ...
    @overload
    def scrollTo(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def scrollTo(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], scrollTime: int) -> None: ...
    def setScrollerProperties(self, prop: QScrollerProperties) -> None: ...
    @overload
    def setSnapPositionsY(self, positions: typing.Iterable[float]) -> None: ...
    @overload
    def setSnapPositionsY(self, first: float, interval: float) -> None: ...
    @overload
    def setSnapPositionsX(self, positions: typing.Iterable[float]) -> None: ...
    @overload
    def setSnapPositionsX(self, first: float, interval: float) -> None: ...
    def scrollerProperties(self) -> QScrollerProperties: ...
    def pixelPerMeter(self) -> QtCore.QPointF: ...
    def finalPosition(self) -> QtCore.QPointF: ...
    def velocity(self) -> QtCore.QPointF: ...
    def stop(self) -> None: ...
    def handleInput(self, input: int, position: typing.Union[QtCore.QPointF, QtCore.QPoint], timestamp: int = ...) -> bool: ...
    def state(self) -> int: ...
    def target(self) -> QtCore.QObject: ...
    @staticmethod
    def activeScrollers() -> typing.List[QScroller]: ...
    @staticmethod
    def ungrabGesture(target: QtCore.QObject) -> None: ...
    @staticmethod
    def grabbedGesture(target: QtCore.QObject) -> int: ...
    @staticmethod
    def grabGesture(target: QtCore.QObject, scrollGestureType: int = ...) -> int: ...
    @staticmethod
    def scroller(target: QtCore.QObject) -> QScroller: ...
    @staticmethod
    def hasScroller(target: QtCore.QObject) -> bool: ...


class QScrollerProperties(sip.simplewrapper):

    ScrollMetric: typing.Type[int]
    #class ScrollMetric(int): ...
    MousePressEventDelay = ... # type: int
    DragStartDistance = ... # type: int
    DragVelocitySmoothingFactor = ... # type: int
    AxisLockThreshold = ... # type: int
    ScrollingCurve = ... # type: int
    DecelerationFactor = ... # type: int
    MinimumVelocity = ... # type: int
    MaximumVelocity = ... # type: int
    MaximumClickThroughVelocity = ... # type: int
    AcceleratingFlickMaximumTime = ... # type: int
    AcceleratingFlickSpeedupFactor = ... # type: int
    SnapPositionRatio = ... # type: int
    SnapTime = ... # type: int
    OvershootDragResistanceFactor = ... # type: int
    OvershootDragDistanceFactor = ... # type: int
    OvershootScrollDistanceFactor = ... # type: int
    OvershootScrollTime = ... # type: int
    HorizontalOvershootPolicy = ... # type: int
    VerticalOvershootPolicy = ... # type: int
    FrameRate = ... # type: int
    ScrollMetricCount = ... # type: int

    FrameRates: typing.Type[int]
    #class FrameRates(int): ...
    Standard = ... # type: int
    Fps60 = ... # type: int
    Fps30 = ... # type: int
    Fps20 = ... # type: int

    OvershootPolicy: typing.Type[int]
    #class OvershootPolicy(int): ...
    OvershootWhenScrollable = ... # type: int
    OvershootAlwaysOff = ... # type: int
    OvershootAlwaysOn = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, sp: QScrollerProperties) -> None: ...

    def setScrollMetric(self, metric: int, value: typing.Any) -> None: ...
    def scrollMetric(self, metric: int) -> typing.Any: ...
    @staticmethod
    def unsetDefaultScrollerProperties() -> None: ...
    @staticmethod
    def setDefaultScrollerProperties(sp: QScrollerProperties) -> None: ...


class QShortcut(QtCore.QObject):

    activated: PYQT_SIGNAL
    activatedAmbiguously: PYQT_SIGNAL

    @overload
    def __init__(self, parent: QWidget, **props) -> None: ...
    @overload
    def __init__(self, key: typing.Union[QtGui.QKeySequence, int, str, int], parent: QWidget, member: PYQT_SLOT = ..., ambiguousMember: PYQT_SLOT = ..., context: int = ..., **props) -> None: ...

    def event(self, e: QtCore.QEvent) -> bool: ...
    #def activatedAmbiguously(self) -> None: ...
    #def activated(self) -> None: ...
    def autoRepeat(self) -> bool: ...
    def setAutoRepeat(self, on: bool) -> None: ...
    def parentWidget(self) -> QWidget: ...
    def id(self) -> int: ...
    def whatsThis(self) -> str: ...
    def setWhatsThis(self, text: str) -> None: ...
    def context(self) -> int: ...
    def setContext(self, context: int) -> None: ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, enable: bool) -> None: ...
    def key(self) -> QtGui.QKeySequence: ...
    def setKey(self, key: typing.Union[QtGui.QKeySequence, int, str, int]) -> None: ...


class QSizeGrip(QWidget):

    def __init__(self, parent: QWidget, **props) -> None: ...

    def hideEvent(self, hideEvent: QtGui.QHideEvent) -> None: ...
    def showEvent(self, showEvent: QtGui.QShowEvent) -> None: ...
    def moveEvent(self, moveEvent: QtGui.QMoveEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, mouseEvent: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def setVisible(self, a0: bool) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QSizePolicy(sip.simplewrapper):

    class ControlType(int):
        DefaultType = ... # type: QSizePolicy.ControlType
        ButtonBox = ... # type: QSizePolicy.ControlType
        CheckBox = ... # type: QSizePolicy.ControlType
        ComboBox = ... # type: QSizePolicy.ControlType
        Frame = ... # type: QSizePolicy.ControlType
        GroupBox = ... # type: QSizePolicy.ControlType
        Label = ... # type: QSizePolicy.ControlType
        Line = ... # type: QSizePolicy.ControlType
        LineEdit = ... # type: QSizePolicy.ControlType
        PushButton = ... # type: QSizePolicy.ControlType
        RadioButton = ... # type: QSizePolicy.ControlType
        Slider = ... # type: QSizePolicy.ControlType
        SpinBox = ... # type: QSizePolicy.ControlType
        TabWidget = ... # type: QSizePolicy.ControlType
        ToolButton = ... # type: QSizePolicy.ControlType

    class Policy(int):
        Fixed = ... # type: QSizePolicy.Policy
        Minimum = ... # type: QSizePolicy.Policy
        Maximum = ... # type: QSizePolicy.Policy
        Preferred = ... # type: QSizePolicy.Policy
        MinimumExpanding = ... # type: QSizePolicy.Policy
        Expanding = ... # type: QSizePolicy.Policy
        Ignored = ... # type: QSizePolicy.Policy

    class PolicyFlag(int):
        GrowFlag = ... # type: QSizePolicy.PolicyFlag
        ExpandFlag = ... # type: QSizePolicy.PolicyFlag
        ShrinkFlag = ... # type: QSizePolicy.PolicyFlag
        IgnoreFlag = ... # type: QSizePolicy.PolicyFlag

    ControlTypes: typing.Type[int]
    #class ControlTypes(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QSizePolicy.ControlTypes, QSizePolicy.ControlType]) -> None: ...
        #@overload
        #def __init__(self, a0: QSizePolicy.ControlTypes) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QSizePolicy.ControlTypes: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, horizontal: int, vertical: int, type: int = ...) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...
    @overload
    def __init__(self, a0: QSizePolicy) -> None: ...

    def __hash__(self) -> int: ...
    def setRetainSizeWhenHidden(self, retainSize: bool) -> None: ...
    def retainSizeWhenHidden(self) -> bool: ...
    def hasWidthForHeight(self) -> bool: ...
    def setWidthForHeight(self, b: bool) -> None: ...
    def setControlType(self, type: int) -> None: ...
    def controlType(self) -> int: ...
    def transposed(self) -> QSizePolicy: ...
    def transpose(self) -> None: ...
    def setVerticalStretch(self, stretchFactor: int) -> None: ...
    def setHorizontalStretch(self, stretchFactor: int) -> None: ...
    def verticalStretch(self) -> int: ...
    def horizontalStretch(self) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def setHeightForWidth(self, b: bool) -> None: ...
    def expandingDirections(self) -> int: ...
    def setVerticalPolicy(self, d: int) -> None: ...
    def setHorizontalPolicy(self, d: int) -> None: ...
    def verticalPolicy(self) -> int: ...
    def horizontalPolicy(self) -> int: ...


class QSlider(QAbstractSlider):

    class TickPosition(int):
        NoTicks = ... # type: QSlider.TickPosition
        TicksAbove = ... # type: QSlider.TickPosition
        TicksLeft = ... # type: QSlider.TickPosition
        TicksBelow = ... # type: QSlider.TickPosition
        TicksRight = ... # type: QSlider.TickPosition
        TicksBothSides = ... # type: QSlider.TickPosition

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, orientation: int, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def mouseMoveEvent(self, ev: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, ev: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, ev: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, ev: QtGui.QPaintEvent) -> None: ...
    def initStyleOption(self, option: QStyleOptionSlider) -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def tickInterval(self) -> int: ...
    def setTickInterval(self, ti: int) -> None: ...
    def tickPosition(self) -> int: ...
    def setTickPosition(self, position: int) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QSpinBox(QAbstractSpinBox):

    valueChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def setStepType(self, stepType: int) -> None: ...
    def stepType(self) -> int: ...
    def setDisplayIntegerBase(self, base: int) -> None: ...
    def displayIntegerBase(self) -> int: ...
    #@overload
    #def valueChanged(self, a0: int) -> None: ...
    #@overload
    #def valueChanged(self, a0: str) -> None: ...
    def setValue(self, val: int) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def fixup(self, str: str) -> str: ...
    def textFromValue(self, v: int) -> str: ...
    def valueFromText(self, text: str) -> int: ...
    def validate(self, input: str, pos: int) -> typing.Tuple[int, str, int]: ...
    def setRange(self, min: int, max: int) -> None: ...
    def setMaximum(self, max: int) -> None: ...
    def maximum(self) -> int: ...
    def setMinimum(self, min: int) -> None: ...
    def minimum(self) -> int: ...
    def setSingleStep(self, val: int) -> None: ...
    def singleStep(self) -> int: ...
    def cleanText(self) -> str: ...
    def setSuffix(self, s: str) -> None: ...
    def suffix(self) -> str: ...
    def setPrefix(self, p: str) -> None: ...
    def prefix(self) -> str: ...
    def value(self) -> int: ...


class QDoubleSpinBox(QAbstractSpinBox):

    valueChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def setStepType(self, stepType: int) -> None: ...
    def stepType(self) -> int: ...
    #@overload
    #def valueChanged(self, a0: float) -> None: ...
    #@overload
    #def valueChanged(self, a0: str) -> None: ...
    def setValue(self, val: float) -> None: ...
    def fixup(self, str: str) -> str: ...
    def textFromValue(self, v: float) -> str: ...
    def valueFromText(self, text: str) -> float: ...
    def validate(self, input: str, pos: int) -> typing.Tuple[int, str, int]: ...
    def setDecimals(self, prec: int) -> None: ...
    def decimals(self) -> int: ...
    def setRange(self, min: float, max: float) -> None: ...
    def setMaximum(self, max: float) -> None: ...
    def maximum(self) -> float: ...
    def setMinimum(self, min: float) -> None: ...
    def minimum(self) -> float: ...
    def setSingleStep(self, val: float) -> None: ...
    def singleStep(self) -> float: ...
    def cleanText(self) -> str: ...
    def setSuffix(self, s: str) -> None: ...
    def suffix(self) -> str: ...
    def setPrefix(self, p: str) -> None: ...
    def prefix(self) -> str: ...
    def value(self) -> float: ...


class QSplashScreen(QWidget):

    messageChanged: PYQT_SIGNAL

    @overload
    def __init__(self, pixmap: QtGui.QPixmap = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...
    @overload
    def __init__(self, parent: QWidget, pixmap: QtGui.QPixmap = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def drawContents(self, painter: QtGui.QPainter) -> None: ...
    #def messageChanged(self, message: str) -> None: ...
    def clearMessage(self) -> None: ...
    def showMessage(self, message: str, alignment: int = ..., color: typing.Union[QtGui.QColor, int, QtGui.QGradient] = ...) -> None: ...
    def message(self) -> str: ...
    def repaint(self) -> None: ...
    def finish(self, w: QWidget) -> None: ...
    def pixmap(self) -> QtGui.QPixmap: ...
    def setPixmap(self, pixmap: QtGui.QPixmap) -> None: ...


class QSplitter(QFrame):

    splitterMoved: PYQT_SIGNAL

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, orientation: int, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def closestLegalPosition(self, a0: int, a1: int) -> int: ...
    def setRubberBand(self, position: int) -> None: ...
    def moveSplitter(self, pos: int, index: int) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def childEvent(self, a0: QtCore.QChildEvent) -> None: ...
    def createHandle(self) -> QSplitterHandle: ...
    #def splitterMoved(self, pos: int, index: int) -> None: ...
    def replaceWidget(self, index: int, widget: QWidget) -> QWidget: ...
    def setStretchFactor(self, index: int, stretch: int) -> None: ...
    def handle(self, index: int) -> QSplitterHandle: ...
    def getRange(self, index: int) -> typing.Tuple[int, int]: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def widget(self, index: int) -> QWidget: ...
    def indexOf(self, w: QWidget) -> int: ...
    def setHandleWidth(self, a0: int) -> None: ...
    def handleWidth(self) -> int: ...
    def restoreState(self, state: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def saveState(self) -> QtCore.QByteArray: ...
    def setSizes(self, list: typing.Iterable[int]) -> None: ...
    def sizes(self) -> typing.List[int]: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def refresh(self) -> None: ...
    def opaqueResize(self) -> bool: ...
    def setOpaqueResize(self, opaque: bool = ...) -> None: ...
    def isCollapsible(self, index: int) -> bool: ...
    def setCollapsible(self, index: int, a1: bool) -> None: ...
    def childrenCollapsible(self) -> bool: ...
    def setChildrenCollapsible(self, a0: bool) -> None: ...
    def orientation(self) -> int: ...
    def setOrientation(self, a0: int) -> None: ...
    def insertWidget(self, index: int, widget: QWidget) -> None: ...
    def addWidget(self, widget: QWidget) -> None: ...


class QSplitterHandle(QWidget):

    def __init__(self, o: int, parent: QSplitter, **props) -> None: ...

    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def closestLegalPosition(self, p: int) -> int: ...
    def moveSplitter(self, p: int) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def splitter(self) -> QSplitter: ...
    def opaqueResize(self) -> bool: ...
    def orientation(self) -> int: ...
    def setOrientation(self, o: int) -> None: ...


class QStackedLayout(QLayout):

    currentChanged: PYQT_SIGNAL
    widgetRemoved: PYQT_SIGNAL

    StackingMode: typing.Type[int]
    #class StackingMode(int): ...
    StackOne = ... # type: int
    StackAll = ... # type: int

    @overload
    def __init__(self, **props) -> None: ...
    @overload
    def __init__(self, parent: QWidget, **props) -> None: ...
    @overload
    def __init__(self, parentLayout: QLayout, **props) -> None: ...

    def heightForWidth(self, width: int) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def setStackingMode(self, stackingMode: int) -> None: ...
    def stackingMode(self) -> int: ...
    def setCurrentWidget(self, w: QWidget) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    #def currentChanged(self, index: int) -> None: ...
    #def widgetRemoved(self, index: int) -> None: ...
    def setGeometry(self, rect: QtCore.QRect) -> None: ...
    def takeAt(self, a0: int) -> QLayoutItem: ...
    def itemAt(self, a0: int) -> QLayoutItem: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def addItem(self, item: QLayoutItem) -> None: ...
    def count(self) -> int: ...
    @overload
    def widget(self, a0: int) -> QWidget: ...
    @overload
    def widget(self) -> QWidget: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> QWidget: ...
    def insertWidget(self, index: int, w: QWidget) -> int: ...
    def addWidget(self, w: QWidget) -> int: ...


class QStackedWidget(QFrame):

    currentChanged: PYQT_SIGNAL
    widgetRemoved: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def event(self, e: QtCore.QEvent) -> bool: ...
    #def widgetRemoved(self, index: int) -> None: ...
    #def currentChanged(self, a0: int) -> None: ...
    def setCurrentWidget(self, w: QWidget) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def widget(self, a0: int) -> QWidget: ...
    def indexOf(self, a0: QWidget) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> QWidget: ...
    def removeWidget(self, w: QWidget) -> None: ...
    def insertWidget(self, index: int, w: QWidget) -> int: ...
    def addWidget(self, w: QWidget) -> int: ...


class QStatusBar(QWidget):

    messageChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def showEvent(self, a0: QtGui.QShowEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def hideOrShow(self) -> None: ...
    def reformat(self) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    #def messageChanged(self, text: str) -> None: ...
    def clearMessage(self) -> None: ...
    def showMessage(self, message: str, msecs: int = ...) -> None: ...
    def insertPermanentWidget(self, index: int, widget: QWidget, stretch: int = ...) -> int: ...
    def insertWidget(self, index: int, widget: QWidget, stretch: int = ...) -> int: ...
    def currentMessage(self) -> str: ...
    def isSizeGripEnabled(self) -> bool: ...
    def setSizeGripEnabled(self, a0: bool) -> None: ...
    def removeWidget(self, widget: QWidget) -> None: ...
    def addPermanentWidget(self, widget: QWidget, stretch: int = ...) -> None: ...
    def addWidget(self, widget: QWidget, stretch: int = ...) -> None: ...


class QStyledItemDelegate(QAbstractItemDelegate):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def editorEvent(self, event: QtCore.QEvent, model: QtCore.QAbstractItemModel, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> bool: ...
    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> None: ...
    def displayText(self, value: typing.Any, locale: QtCore.QLocale) -> str: ...
    def setItemEditorFactory(self, factory: QItemEditorFactory) -> None: ...
    def itemEditorFactory(self) -> QItemEditorFactory: ...
    def updateEditorGeometry(self, editor: QWidget, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> None: ...
    def setModelData(self, editor: QWidget, model: QtCore.QAbstractItemModel, index: QtCore.QModelIndex) -> None: ...
    def setEditorData(self, editor: QWidget, index: QtCore.QModelIndex) -> None: ...
    def createEditor(self, parent: QWidget, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> QWidget: ...
    def sizeHint(self, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> QtCore.QSize: ...
    def paint(self, painter: QtGui.QPainter, option: QStyleOptionViewItem, index: QtCore.QModelIndex) -> None: ...


class QStyleFactory(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QStyleFactory) -> None: ...

    @staticmethod
    def create(a0: str) -> QStyle: ...
    @staticmethod
    def keys() -> typing.List[str]: ...


class QStyleOption(sip.simplewrapper):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    OptionType: typing.Type[int]
    #class OptionType(int): ...
    SO_Default = ... # type: int
    SO_FocusRect = ... # type: int
    SO_Button = ... # type: int
    SO_Tab = ... # type: int
    SO_MenuItem = ... # type: int
    SO_Frame = ... # type: int
    SO_ProgressBar = ... # type: int
    SO_ToolBox = ... # type: int
    SO_Header = ... # type: int
    SO_DockWidget = ... # type: int
    SO_ViewItem = ... # type: int
    SO_TabWidgetFrame = ... # type: int
    SO_TabBarBase = ... # type: int
    SO_RubberBand = ... # type: int
    SO_ToolBar = ... # type: int
    SO_Complex = ... # type: int
    SO_Slider = ... # type: int
    SO_SpinBox = ... # type: int
    SO_ToolButton = ... # type: int
    SO_ComboBox = ... # type: int
    SO_TitleBar = ... # type: int
    SO_GroupBox = ... # type: int
    SO_ComplexCustomBase = ... # type: int
    SO_GraphicsItem = ... # type: int
    SO_SizeGrip = ... # type: int
    SO_CustomBase = ... # type: int

    direction = ... # type: int
    fontMetrics = ... # type: QtGui.QFontMetrics
    palette = ... # type: QtGui.QPalette
    rect = ... # type: QtCore.QRect
    state = ... # type: typing.Union[int, int]
    styleObject = ... # type: QtCore.QObject
    type = ... # type: int
    version = ... # type: int

    @overload
    def __init__(self, version: int = ..., type: int = ...) -> None: ...
    @overload
    def __init__(self, other: QStyleOption) -> None: ...

    def initFrom(self, w: QWidget) -> None: ...


class QStyleOptionFocusRect(QStyleOption):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    backgroundColor = ... # type: typing.Union[QtGui.QColor, int, QtGui.QGradient]

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionFocusRect) -> None: ...


class QStyleOptionFrame(QStyleOption):

    FrameFeature: typing.Type[int]
    #class FrameFeature(int): ...
    None_ = ... # type: int
    Flat = ... # type: int
    Rounded = ... # type: int

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    FrameFeatures: typing.Type[int]
    #class FrameFeatures(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QStyleOptionFrame.FrameFeatures, QStyleOptionFrame.FrameFeature]) -> None: ...
        #@overload
        #def __init__(self, a0: QStyleOptionFrame.FrameFeatures) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QStyleOptionFrame.FrameFeatures: ...
        #def __int__(self) -> int: ...

    features = ... # type: typing.Union[int, int]
    frameShape = ... # type: int
    lineWidth = ... # type: int
    midLineWidth = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionFrame) -> None: ...


class QStyleOptionTabWidgetFrame(QStyleOption):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    leftCornerWidgetSize = ... # type: QtCore.QSize
    lineWidth = ... # type: int
    midLineWidth = ... # type: int
    rightCornerWidgetSize = ... # type: QtCore.QSize
    selectedTabRect = ... # type: QtCore.QRect
    shape = ... # type: int
    tabBarRect = ... # type: QtCore.QRect
    tabBarSize = ... # type: QtCore.QSize

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionTabWidgetFrame) -> None: ...


class QStyleOptionTabBarBase(QStyleOption):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    documentMode = ... # type: bool
    selectedTabRect = ... # type: QtCore.QRect
    shape = ... # type: int
    tabBarRect = ... # type: QtCore.QRect

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionTabBarBase) -> None: ...


class QStyleOptionHeader(QStyleOption):

    SortIndicator: typing.Type[int]
    #class SortIndicator(int): ...
    None_ = ... # type: int
    SortUp = ... # type: int
    SortDown = ... # type: int

    SelectedPosition: typing.Type[int]
    #class SelectedPosition(int): ...
    NotAdjacent = ... # type: int
    NextIsSelected = ... # type: int
    PreviousIsSelected = ... # type: int
    NextAndPreviousAreSelected = ... # type: int

    SectionPosition: typing.Type[int]
    #class SectionPosition(int): ...
    Beginning = ... # type: int
    Middle = ... # type: int
    End = ... # type: int
    OnlyOneSection = ... # type: int

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    icon = ... # type: QtGui.QIcon
    iconAlignment = ... # type: typing.Union[int, int]
    orientation = ... # type: int
    position = ... # type: int
    section = ... # type: int
    selectedPosition = ... # type: int
    sortIndicator = ... # type: int
    text = ... # type: str
    textAlignment = ... # type: typing.Union[int, int]

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionHeader) -> None: ...


class QStyleOptionButton(QStyleOption):

    ButtonFeature: typing.Type[int]
    #class ButtonFeature(int): ...
    None_ = ... # type: int
    Flat = ... # type: int
    HasMenu = ... # type: int
    DefaultButton = ... # type: int
    AutoDefaultButton = ... # type: int
    CommandLinkButton = ... # type: int

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    ButtonFeatures: typing.Type[int]
    #class ButtonFeatures(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QStyleOptionButton.ButtonFeatures, QStyleOptionButton.ButtonFeature]) -> None: ...
        #@overload
        #def __init__(self, a0: QStyleOptionButton.ButtonFeatures) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QStyleOptionButton.ButtonFeatures: ...
        #def __int__(self) -> int: ...

    features = ... # type: typing.Union[int, int]
    icon = ... # type: QtGui.QIcon
    iconSize = ... # type: QtCore.QSize
    text = ... # type: str

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionButton) -> None: ...


class QStyleOptionTab(QStyleOption):

    TabFeature: typing.Type[int]
    #class TabFeature(int): ...
    None_ = ... # type: int
    HasFrame = ... # type: int

    CornerWidget: typing.Type[int]
    #class CornerWidget(int): ...
    NoCornerWidgets = ... # type: int
    LeftCornerWidget = ... # type: int
    RightCornerWidget = ... # type: int

    SelectedPosition: typing.Type[int]
    #class SelectedPosition(int): ...
    NotAdjacent = ... # type: int
    NextIsSelected = ... # type: int
    PreviousIsSelected = ... # type: int

    TabPosition: typing.Type[int]
    #class TabPosition(int): ...
    Beginning = ... # type: int
    Middle = ... # type: int
    End = ... # type: int
    OnlyOneTab = ... # type: int

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    CornerWidgets: typing.Type[int]
    #class CornerWidgets(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QStyleOptionTab.CornerWidgets, QStyleOptionTab.CornerWidget]) -> None: ...
        #@overload
        #def __init__(self, a0: QStyleOptionTab.CornerWidgets) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QStyleOptionTab.CornerWidgets: ...
        #def __int__(self) -> int: ...

    TabFeatures: typing.Type[int]
    #class TabFeatures(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QStyleOptionTab.TabFeatures, QStyleOptionTab.TabFeature]) -> None: ...
        #@overload
        #def __init__(self, a0: QStyleOptionTab.TabFeatures) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QStyleOptionTab.TabFeatures: ...
        #def __int__(self) -> int: ...

    cornerWidgets = ... # type: typing.Union[int, int]
    documentMode = ... # type: bool
    features = ... # type: typing.Union[int, int]
    icon = ... # type: QtGui.QIcon
    iconSize = ... # type: QtCore.QSize
    leftButtonSize = ... # type: QtCore.QSize
    position = ... # type: int
    rightButtonSize = ... # type: QtCore.QSize
    row = ... # type: int
    selectedPosition = ... # type: int
    shape = ... # type: int
    text = ... # type: str

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionTab) -> None: ...


class QStyleOptionProgressBar(QStyleOption):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    bottomToTop = ... # type: bool
    invertedAppearance = ... # type: bool
    maximum = ... # type: int
    minimum = ... # type: int
    orientation = ... # type: int
    progress = ... # type: int
    text = ... # type: str
    textAlignment = ... # type: typing.Union[int, int]
    textVisible = ... # type: bool

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionProgressBar) -> None: ...


class QStyleOptionMenuItem(QStyleOption):

    CheckType: typing.Type[int]
    #class CheckType(int): ...
    NotCheckable = ... # type: int
    Exclusive = ... # type: int
    NonExclusive = ... # type: int

    MenuItemType: typing.Type[int]
    #class MenuItemType(int): ...
    Normal = ... # type: int
    DefaultItem = ... # type: int
    Separator = ... # type: int
    SubMenu = ... # type: int
    Scroller = ... # type: int
    TearOff = ... # type: int
    Margin = ... # type: int
    EmptyArea = ... # type: int

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    checkType = ... # type: int
    checked = ... # type: bool
    font = ... # type: QtGui.QFont
    icon = ... # type: QtGui.QIcon
    maxIconWidth = ... # type: int
    menuHasCheckableItems = ... # type: bool
    menuItemType = ... # type: int
    menuRect = ... # type: QtCore.QRect
    tabWidth = ... # type: int
    text = ... # type: str

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionMenuItem) -> None: ...


class QStyleOptionDockWidget(QStyleOption):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    closable = ... # type: bool
    floatable = ... # type: bool
    movable = ... # type: bool
    title = ... # type: str
    verticalTitleBar = ... # type: bool

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionDockWidget) -> None: ...


class QStyleOptionViewItem(QStyleOption):

    class ViewItemPosition(int):
        Invalid = ... # type: QStyleOptionViewItem.ViewItemPosition
        Beginning = ... # type: QStyleOptionViewItem.ViewItemPosition
        Middle = ... # type: QStyleOptionViewItem.ViewItemPosition
        End = ... # type: QStyleOptionViewItem.ViewItemPosition
        OnlyOne = ... # type: QStyleOptionViewItem.ViewItemPosition

    class ViewItemFeature(int):
        None_ = ... # type: QStyleOptionViewItem.ViewItemFeature
        WrapText = ... # type: QStyleOptionViewItem.ViewItemFeature
        Alternate = ... # type: QStyleOptionViewItem.ViewItemFeature
        HasCheckIndicator = ... # type: QStyleOptionViewItem.ViewItemFeature
        HasDisplay = ... # type: QStyleOptionViewItem.ViewItemFeature
        HasDecoration = ... # type: QStyleOptionViewItem.ViewItemFeature

    class Position(int):
        Left = ... # type: QStyleOptionViewItem.Position
        Right = ... # type: QStyleOptionViewItem.Position
        Top = ... # type: QStyleOptionViewItem.Position
        Bottom = ... # type: QStyleOptionViewItem.Position

    class StyleOptionVersion(int):
        Version = ... # type: QStyleOptionViewItem.StyleOptionVersion

    class StyleOptionType(int):
        Type = ... # type: QStyleOptionViewItem.StyleOptionType

    ViewItemFeatures: typing.Type[int]
    #class ViewItemFeatures(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QStyleOptionViewItem.ViewItemFeatures, QStyleOptionViewItem.ViewItemFeature]) -> None: ...
        #@overload
        #def __init__(self, a0: QStyleOptionViewItem.ViewItemFeatures) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QStyleOptionViewItem.ViewItemFeatures: ...
        #def __int__(self) -> int: ...

    backgroundBrush = ... # type: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]
    checkState = ... # type: int
    decorationAlignment = ... # type: typing.Union[int, int]
    decorationPosition = ... # type: int
    decorationSize = ... # type: QtCore.QSize
    displayAlignment = ... # type: typing.Union[int, int]
    features = ... # type: typing.Union[int, int]
    font = ... # type: QtGui.QFont
    icon = ... # type: QtGui.QIcon
    index = ... # type: QtCore.QModelIndex
    locale = ... # type: QtCore.QLocale
    showDecorationSelected = ... # type: bool
    text = ... # type: str
    textElideMode = ... # type: int
    viewItemPosition = ... # type: int
    widget = ... # type: QWidget

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionViewItem) -> None: ...


class QStyleOptionToolBox(QStyleOption):

    SelectedPosition: typing.Type[int]
    #class SelectedPosition(int): ...
    NotAdjacent = ... # type: int
    NextIsSelected = ... # type: int
    PreviousIsSelected = ... # type: int

    TabPosition: typing.Type[int]
    #class TabPosition(int): ...
    Beginning = ... # type: int
    Middle = ... # type: int
    End = ... # type: int
    OnlyOneTab = ... # type: int

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    icon = ... # type: QtGui.QIcon
    position = ... # type: int
    selectedPosition = ... # type: int
    text = ... # type: str

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionToolBox) -> None: ...


class QStyleOptionRubberBand(QStyleOption):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    opaque = ... # type: bool
    shape = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionRubberBand) -> None: ...


class QStyleOptionComplex(QStyleOption):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    activeSubControls = ... # type: typing.Union[int, int]
    subControls = ... # type: typing.Union[int, int]

    @overload
    def __init__(self, version: int = ..., type: int = ...) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionComplex) -> None: ...


class QStyleOptionSlider(QStyleOptionComplex):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    dialWrapping = ... # type: bool
    maximum = ... # type: int
    minimum = ... # type: int
    notchTarget = ... # type: float
    orientation = ... # type: int
    pageStep = ... # type: int
    singleStep = ... # type: int
    sliderPosition = ... # type: int
    sliderValue = ... # type: int
    tickInterval = ... # type: int
    tickPosition = ... # type: int
    upsideDown = ... # type: bool

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionSlider) -> None: ...


class QStyleOptionSpinBox(QStyleOptionComplex):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    buttonSymbols = ... # type: int
    frame = ... # type: bool
    stepEnabled = ... # type: typing.Union[int, int]

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionSpinBox) -> None: ...


class QStyleOptionToolButton(QStyleOptionComplex):

    class ToolButtonFeature(int):
        None_ = ... # type: QStyleOptionToolButton.ToolButtonFeature
        Arrow = ... # type: QStyleOptionToolButton.ToolButtonFeature
        Menu = ... # type: QStyleOptionToolButton.ToolButtonFeature
        PopupDelay = ... # type: QStyleOptionToolButton.ToolButtonFeature
        MenuButtonPopup = ... # type: QStyleOptionToolButton.ToolButtonFeature
        HasMenu = ... # type: QStyleOptionToolButton.ToolButtonFeature

    class StyleOptionVersion(int):
        Version = ... # type: QStyleOptionToolButton.StyleOptionVersion

    class StyleOptionType(int):
        Type = ... # type: QStyleOptionToolButton.StyleOptionType

    ToolButtonFeatures: typing.Type[int]
    #class ToolButtonFeatures(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QStyleOptionToolButton.ToolButtonFeatures, QStyleOptionToolButton.ToolButtonFeature]) -> None: ...
        #@overload
        #def __init__(self, a0: QStyleOptionToolButton.ToolButtonFeatures) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QStyleOptionToolButton.ToolButtonFeatures: ...
        #def __int__(self) -> int: ...

    arrowType = ... # type: int
    features = ... # type: typing.Union[int, int]
    font = ... # type: QtGui.QFont
    icon = ... # type: QtGui.QIcon
    iconSize = ... # type: QtCore.QSize
    pos = ... # type: QtCore.QPoint
    text = ... # type: str
    toolButtonStyle = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionToolButton) -> None: ...


class QStyleOptionComboBox(QStyleOptionComplex):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    currentIcon = ... # type: QtGui.QIcon
    currentText = ... # type: str
    editable = ... # type: bool
    frame = ... # type: bool
    iconSize = ... # type: QtCore.QSize
    popupRect = ... # type: QtCore.QRect

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionComboBox) -> None: ...


class QStyleOptionTitleBar(QStyleOptionComplex):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    icon = ... # type: QtGui.QIcon
    text = ... # type: str
    titleBarFlags = ... # type: typing.Union[int, int]
    titleBarState = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionTitleBar) -> None: ...


class QStyleHintReturn(sip.simplewrapper):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    HintReturnType: typing.Type[int]
    #class HintReturnType(int): ...
    SH_Default = ... # type: int
    SH_Mask = ... # type: int
    SH_Variant = ... # type: int

    type = ... # type: int
    version = ... # type: int

    @overload
    def __init__(self, version: int = ..., type: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QStyleHintReturn) -> None: ...


class QStyleHintReturnMask(QStyleHintReturn):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    region = ... # type: QtGui.QRegion

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QStyleHintReturnMask) -> None: ...


class QStyleOptionToolBar(QStyleOption):

    ToolBarFeature: typing.Type[int]
    #class ToolBarFeature(int): ...
    None_ = ... # type: int
    Movable = ... # type: int

    ToolBarPosition: typing.Type[int]
    #class ToolBarPosition(int): ...
    Beginning = ... # type: int
    Middle = ... # type: int
    End = ... # type: int
    OnlyOne = ... # type: int

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    ToolBarFeatures: typing.Type[int]
    #class ToolBarFeatures(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QStyleOptionToolBar.ToolBarFeatures, QStyleOptionToolBar.ToolBarFeature]) -> None: ...
        #@overload
        #def __init__(self, a0: QStyleOptionToolBar.ToolBarFeatures) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QStyleOptionToolBar.ToolBarFeatures: ...
        #def __int__(self) -> int: ...

    features = ... # type: typing.Union[int, int]
    lineWidth = ... # type: int
    midLineWidth = ... # type: int
    positionOfLine = ... # type: int
    positionWithinLine = ... # type: int
    toolBarArea = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionToolBar) -> None: ...


class QStyleOptionGroupBox(QStyleOptionComplex):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    features = ... # type: typing.Union[int, int]
    lineWidth = ... # type: int
    midLineWidth = ... # type: int
    text = ... # type: str
    textAlignment = ... # type: typing.Union[int, int]
    textColor = ... # type: typing.Union[QtGui.QColor, int, QtGui.QGradient]

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionGroupBox) -> None: ...


class QStyleOptionSizeGrip(QStyleOptionComplex):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    corner = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionSizeGrip) -> None: ...


class QStyleOptionGraphicsItem(QStyleOption):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    exposedRect = ... # type: QtCore.QRectF

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QStyleOptionGraphicsItem) -> None: ...

    @staticmethod
    def levelOfDetailFromTransform(worldTransform: QtGui.QTransform) -> float: ...


class QStyleHintReturnVariant(QStyleHintReturn):

    StyleOptionVersion: typing.Type[int]
    #class StyleOptionVersion(int): ...
    Version = ... # type: int

    StyleOptionType: typing.Type[int]
    #class StyleOptionType(int): ...
    Type = ... # type: int

    variant = ... # type: typing.Any

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QStyleHintReturnVariant) -> None: ...


class QStylePainter(QtGui.QPainter):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, w: QWidget) -> None: ...
    @overload
    def __init__(self, pd: QtGui.QPaintDevice, w: QWidget) -> None: ...

    def drawItemPixmap(self, r: QtCore.QRect, flags: int, pixmap: QtGui.QPixmap) -> None: ...
    def drawItemText(self, rect: QtCore.QRect, flags: int, pal: QtGui.QPalette, enabled: bool, text: str, textRole: int = ...) -> None: ...
    def drawComplexControl(self, cc: int, opt: QStyleOptionComplex) -> None: ...
    def drawControl(self, ce: int, opt: QStyleOption) -> None: ...
    def drawPrimitive(self, pe: int, opt: QStyleOption) -> None: ...
    def style(self) -> QStyle: ...
    @overload
    def begin(self, w: QWidget) -> bool: ...
    @overload
    def begin(self, pd: QtGui.QPaintDevice, w: QWidget) -> bool: ...


class QSystemTrayIcon(QtCore.QObject):

    activated: PYQT_SIGNAL
    messageClicked: PYQT_SIGNAL

    MessageIcon: typing.Type[int]
    #class MessageIcon(int): ...
    NoIcon = ... # type: int
    Information = ... # type: int
    Warning = ... # type: int
    Critical = ... # type: int

    ActivationReason: typing.Type[int]
    #class ActivationReason(int): ...
    Unknown = ... # type: int
    Context = ... # type: int
    DoubleClick = ... # type: int
    Trigger = ... # type: int
    MiddleClick = ... # type: int

    @overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, icon: QtGui.QIcon, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def event(self, event: QtCore.QEvent) -> bool: ...
    #def messageClicked(self) -> None: ...
    #def activated(self, reason: int) -> None: ...
    def show(self) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def hide(self) -> None: ...
    def isVisible(self) -> bool: ...
    @overload
    def showMessage(self, title: str, msg: str, icon: int = ..., msecs: int = ...) -> None: ...
    @overload
    def showMessage(self, title: str, msg: str, icon: QtGui.QIcon, msecs: int = ...) -> None: ...
    @staticmethod
    def supportsMessages() -> bool: ...
    @staticmethod
    def isSystemTrayAvailable() -> bool: ...
    def setToolTip(self, tip: str) -> None: ...
    def toolTip(self) -> str: ...
    def setIcon(self, icon: QtGui.QIcon) -> None: ...
    def icon(self) -> QtGui.QIcon: ...
    def geometry(self) -> QtCore.QRect: ...
    def contextMenu(self) -> QMenu: ...
    def setContextMenu(self, menu: QMenu) -> None: ...


class QTabBar(QWidget):

    currentChanged: PYQT_SIGNAL
    tabBarClicked: PYQT_SIGNAL
    tabBarDoubleClicked: PYQT_SIGNAL
    tabCloseRequested: PYQT_SIGNAL
    tabMoved: PYQT_SIGNAL

    SelectionBehavior: typing.Type[int]
    #class SelectionBehavior(int): ...
    SelectLeftTab = ... # type: int
    SelectRightTab = ... # type: int
    SelectPreviousTab = ... # type: int

    ButtonPosition: typing.Type[int]
    #class ButtonPosition(int): ...
    LeftSide = ... # type: int
    RightSide = ... # type: int

    Shape: typing.Type[int]
    #class Shape(int): ...
    RoundedNorth = ... # type: int
    RoundedSouth = ... # type: int
    RoundedWest = ... # type: int
    RoundedEast = ... # type: int
    TriangularNorth = ... # type: int
    TriangularSouth = ... # type: int
    TriangularWest = ... # type: int
    TriangularEast = ... # type: int

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def setAccessibleTabName(self, index: int, name: str) -> None: ...
    def accessibleTabName(self, index: int) -> str: ...
    def timerEvent(self, event: QtCore.QTimerEvent) -> None: ...
    def setChangeCurrentOnDrag(self, change: bool) -> None: ...
    def changeCurrentOnDrag(self) -> bool: ...
    def setAutoHide(self, hide: bool) -> None: ...
    def autoHide(self) -> bool: ...
    #def tabBarDoubleClicked(self, index: int) -> None: ...
    #def tabBarClicked(self, index: int) -> None: ...
    def minimumTabSizeHint(self, index: int) -> QtCore.QSize: ...
    def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
    def hideEvent(self, a0: QtGui.QHideEvent) -> None: ...
    #def tabMoved(self, from_: int, to: int) -> None: ...
    #def tabCloseRequested(self, index: int) -> None: ...
    def setDocumentMode(self, set: bool) -> None: ...
    def documentMode(self) -> bool: ...
    def setMovable(self, movable: bool) -> None: ...
    def isMovable(self) -> bool: ...
    def setExpanding(self, enabled: bool) -> None: ...
    def expanding(self) -> bool: ...
    def setSelectionBehaviorOnRemove(self, behavior: int) -> None: ...
    def selectionBehaviorOnRemove(self) -> int: ...
    def tabButton(self, index: int, position: int) -> QWidget: ...
    def setTabButton(self, index: int, position: int, widget: QWidget) -> None: ...
    def setTabsClosable(self, closable: bool) -> None: ...
    def tabsClosable(self) -> bool: ...
    def moveTab(self, from_: int, to: int) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def showEvent(self, a0: QtGui.QShowEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def tabLayoutChange(self) -> None: ...
    def tabRemoved(self, index: int) -> None: ...
    def tabInserted(self, index: int) -> None: ...
    def tabSizeHint(self, index: int) -> QtCore.QSize: ...
    def initStyleOption(self, option: QStyleOptionTab, tabIndex: int) -> None: ...
    #def currentChanged(self, index: int) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def usesScrollButtons(self) -> bool: ...
    def setUsesScrollButtons(self, useButtons: bool) -> None: ...
    def setElideMode(self, a0: int) -> None: ...
    def elideMode(self) -> int: ...
    def setIconSize(self, size: QtCore.QSize) -> None: ...
    def iconSize(self) -> QtCore.QSize: ...
    def drawBase(self) -> bool: ...
    def setDrawBase(self, drawTheBase: bool) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def tabRect(self, index: int) -> QtCore.QRect: ...
    def tabAt(self, pos: QtCore.QPoint) -> int: ...
    def tabData(self, index: int) -> typing.Any: ...
    def setTabData(self, index: int, data: typing.Any) -> None: ...
    def tabWhatsThis(self, index: int) -> str: ...
    def setTabWhatsThis(self, index: int, text: str) -> None: ...
    def tabToolTip(self, index: int) -> str: ...
    def setTabToolTip(self, index: int, tip: str) -> None: ...
    def setTabIcon(self, index: int, icon: QtGui.QIcon) -> None: ...
    def tabIcon(self, index: int) -> QtGui.QIcon: ...
    def setTabTextColor(self, index: int, color: typing.Union[QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def tabTextColor(self, index: int) -> QtGui.QColor: ...
    def setTabText(self, index: int, text: str) -> None: ...
    def tabText(self, index: int) -> str: ...
    def setTabEnabled(self, index: int, a1: bool) -> None: ...
    def isTabEnabled(self, index: int) -> bool: ...
    def removeTab(self, index: int) -> None: ...
    @overload
    def insertTab(self, index: int, text: str) -> int: ...
    @overload
    def insertTab(self, index: int, icon: QtGui.QIcon, text: str) -> int: ...
    @overload
    def addTab(self, text: str) -> int: ...
    @overload
    def addTab(self, icon: QtGui.QIcon, text: str) -> int: ...
    def setShape(self, shape: int) -> None: ...
    def shape(self) -> int: ...


class QTableView(QAbstractItemView):

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def currentChanged(self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex) -> None: ...
    def selectionChanged(self, selected: QtCore.QItemSelection, deselected: QtCore.QItemSelection) -> None: ...
    def clearSpans(self) -> None: ...
    def isCornerButtonEnabled(self) -> bool: ...
    def setCornerButtonEnabled(self, enable: bool) -> None: ...
    def wordWrap(self) -> bool: ...
    def setWordWrap(self, on: bool) -> None: ...
    def sortByColumn(self, column: int, order: int) -> None: ...
    def columnSpan(self, row: int, column: int) -> int: ...
    def rowSpan(self, row: int, column: int) -> int: ...
    def setSpan(self, row: int, column: int, rowSpan: int, columnSpan: int) -> None: ...
    def isSortingEnabled(self) -> bool: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def viewportSizeHint(self) -> QtCore.QSize: ...
    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool: ...
    def horizontalScrollbarAction(self, action: int) -> None: ...
    def verticalScrollbarAction(self, action: int) -> None: ...
    def sizeHintForColumn(self, column: int) -> int: ...
    def sizeHintForRow(self, row: int) -> int: ...
    def updateGeometries(self) -> None: ...
    def selectedIndexes(self) -> typing.List[QtCore.QModelIndex]: ...
    def visualRegionForSelection(self, selection: QtCore.QItemSelection) -> QtGui.QRegion: ...
    def setSelection(self, rect: QtCore.QRect, command: typing.Union[int, int]) -> None: ...
    def moveCursor(self, cursorAction: int, modifiers: typing.Union[int, int]) -> QtCore.QModelIndex: ...
    def verticalOffset(self) -> int: ...
    def horizontalOffset(self) -> int: ...
    def timerEvent(self, event: QtCore.QTimerEvent) -> None: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def viewOptions(self) -> QStyleOptionViewItem: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def columnCountChanged(self, oldCount: int, newCount: int) -> None: ...
    def rowCountChanged(self, oldCount: int, newCount: int) -> None: ...
    def columnResized(self, column: int, oldWidth: int, newWidth: int) -> None: ...
    def rowResized(self, row: int, oldHeight: int, newHeight: int) -> None: ...
    def columnMoved(self, column: int, oldIndex: int, newIndex: int) -> None: ...
    def rowMoved(self, row: int, oldIndex: int, newIndex: int) -> None: ...
    def resizeColumnsToContents(self) -> None: ...
    def resizeColumnToContents(self, column: int) -> None: ...
    def resizeRowsToContents(self) -> None: ...
    def resizeRowToContents(self, row: int) -> None: ...
    def showColumn(self, column: int) -> None: ...
    def showRow(self, row: int) -> None: ...
    def hideColumn(self, column: int) -> None: ...
    def hideRow(self, row: int) -> None: ...
    def selectColumn(self, column: int) -> None: ...
    def selectRow(self, row: int) -> None: ...
    def indexAt(self, p: QtCore.QPoint) -> QtCore.QModelIndex: ...
    def scrollTo(self, index: QtCore.QModelIndex, hint: int = ...) -> None: ...
    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect: ...
    def setGridStyle(self, style: int) -> None: ...
    def gridStyle(self) -> int: ...
    def setShowGrid(self, show: bool) -> None: ...
    def showGrid(self) -> bool: ...
    def setColumnHidden(self, column: int, hide: bool) -> None: ...
    def isColumnHidden(self, column: int) -> bool: ...
    def setRowHidden(self, row: int, hide: bool) -> None: ...
    def isRowHidden(self, row: int) -> bool: ...
    def columnAt(self, x: int) -> int: ...
    def columnWidth(self, column: int) -> int: ...
    def setColumnWidth(self, column: int, width: int) -> None: ...
    def columnViewportPosition(self, column: int) -> int: ...
    def rowAt(self, y: int) -> int: ...
    def rowHeight(self, row: int) -> int: ...
    def setRowHeight(self, row: int, height: int) -> None: ...
    def rowViewportPosition(self, row: int) -> int: ...
    def setVerticalHeader(self, header: QHeaderView) -> None: ...
    def setHorizontalHeader(self, header: QHeaderView) -> None: ...
    def verticalHeader(self) -> QHeaderView: ...
    def horizontalHeader(self) -> QHeaderView: ...
    def setSelectionModel(self, selectionModel: QtCore.QItemSelectionModel) -> None: ...
    def setRootIndex(self, index: QtCore.QModelIndex) -> None: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...


class QTableWidgetSelectionRange(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, top: int, left: int, bottom: int, right: int) -> None: ...
    @overload
    def __init__(self, other: QTableWidgetSelectionRange) -> None: ...

    def columnCount(self) -> int: ...
    def rowCount(self) -> int: ...
    def rightColumn(self) -> int: ...
    def leftColumn(self) -> int: ...
    def bottomRow(self) -> int: ...
    def topRow(self) -> int: ...


class QTableWidgetItem(sip.wrapper):

    ItemType: typing.Type[int]
    #class ItemType(int): ...
    Type = ... # type: int
    UserType = ... # type: int

    @overload
    def __init__(self, type: int = ...) -> None: ...
    @overload
    def __init__(self, text: str, type: int = ...) -> None: ...
    @overload
    def __init__(self, icon: QtGui.QIcon, text: str, type: int = ...) -> None: ...
    @overload
    def __init__(self, other: QTableWidgetItem) -> None: ...

    def isSelected(self) -> bool: ...
    def setSelected(self, aselect: bool) -> None: ...
    def column(self) -> int: ...
    def row(self) -> int: ...
    def setForeground(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def foreground(self) -> QtGui.QBrush: ...
    def setBackground(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def background(self) -> QtGui.QBrush: ...
    def setSizeHint(self, size: QtCore.QSize) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setFont(self, afont: QtGui.QFont) -> None: ...
    def setWhatsThis(self, awhatsThis: str) -> None: ...
    def setToolTip(self, atoolTip: str) -> None: ...
    def setStatusTip(self, astatusTip: str) -> None: ...
    def setIcon(self, aicon: QtGui.QIcon) -> None: ...
    def setText(self, atext: str) -> None: ...
    def setFlags(self, aflags: typing.Union[int, int]) -> None: ...
    def type(self) -> int: ...
    def write(self, out: QtCore.QDataStream) -> None: ...
    def read(self, in_: QtCore.QDataStream) -> None: ...
    def setData(self, role: int, value: typing.Any) -> None: ...
    def data(self, role: int) -> typing.Any: ...
    def setCheckState(self, state: int) -> None: ...
    def checkState(self) -> int: ...
    def setTextAlignment(self, alignment: int) -> None: ...
    def textAlignment(self) -> int: ...
    def font(self) -> QtGui.QFont: ...
    def whatsThis(self) -> str: ...
    def toolTip(self) -> str: ...
    def statusTip(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def text(self) -> str: ...
    def flags(self) -> int: ...
    def tableWidget(self) -> QTableWidget: ...
    def clone(self) -> QTableWidgetItem: ...


class QTableWidget(QTableView):

    cellActivated: PYQT_SIGNAL
    cellChanged: PYQT_SIGNAL
    cellClicked: PYQT_SIGNAL
    cellDoubleClicked: PYQT_SIGNAL
    cellEntered: PYQT_SIGNAL
    cellPressed: PYQT_SIGNAL
    currentCellChanged: PYQT_SIGNAL
    currentItemChanged: PYQT_SIGNAL
    itemActivated: PYQT_SIGNAL
    itemChanged: PYQT_SIGNAL
    itemClicked: PYQT_SIGNAL
    itemDoubleClicked: PYQT_SIGNAL
    itemEntered: PYQT_SIGNAL
    itemPressed: PYQT_SIGNAL
    itemSelectionChanged: PYQT_SIGNAL

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, rows: int, columns: int, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def isPersistentEditorOpen(self, item: QTableWidgetItem) -> bool: ...
    def dropEvent(self, event: QtGui.QDropEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def itemFromIndex(self, index: QtCore.QModelIndex) -> QTableWidgetItem: ...
    def indexFromItem(self, item: QTableWidgetItem) -> QtCore.QModelIndex: ...
    def items(self, data: QtCore.QMimeData) -> typing.List[QTableWidgetItem]: ...
    def supportedDropActions(self) -> int: ...
    def dropMimeData(self, row: int, column: int, data: QtCore.QMimeData, action: int) -> bool: ...
    def mimeData(self, items: typing.Iterable[QTableWidgetItem]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    #def currentCellChanged(self, currentRow: int, currentColumn: int, previousRow: int, previousColumn: int) -> None: ...
    #def cellChanged(self, row: int, column: int) -> None: ...
    #def cellEntered(self, row: int, column: int) -> None: ...
    #def cellActivated(self, row: int, column: int) -> None: ...
    #def cellDoubleClicked(self, row: int, column: int) -> None: ...
    #def cellClicked(self, row: int, column: int) -> None: ...
    #def cellPressed(self, row: int, column: int) -> None: ...
    #def itemSelectionChanged(self) -> None: ...
    #def currentItemChanged(self, current: QTableWidgetItem, previous: QTableWidgetItem) -> None: ...
    #def itemChanged(self, item: QTableWidgetItem) -> None: ...
    #def itemEntered(self, item: QTableWidgetItem) -> None: ...
    #def itemActivated(self, item: QTableWidgetItem) -> None: ...
    #def itemDoubleClicked(self, item: QTableWidgetItem) -> None: ...
    #def itemClicked(self, item: QTableWidgetItem) -> None: ...
    #def itemPressed(self, item: QTableWidgetItem) -> None: ...
    def clearContents(self) -> None: ...
    def clear(self) -> None: ...
    def removeColumn(self, column: int) -> None: ...
    def removeRow(self, row: int) -> None: ...
    def insertColumn(self, column: int) -> None: ...
    def insertRow(self, row: int) -> None: ...
    def scrollToItem(self, item: QTableWidgetItem, hint: int = ...) -> None: ...
    def setItemPrototype(self, item: QTableWidgetItem) -> None: ...
    def itemPrototype(self) -> QTableWidgetItem: ...
    def visualItemRect(self, item: QTableWidgetItem) -> QtCore.QRect: ...
    @overload
    def itemAt(self, p: QtCore.QPoint) -> QTableWidgetItem: ...
    @overload
    def itemAt(self, ax: int, ay: int) -> QTableWidgetItem: ...
    def visualColumn(self, logicalColumn: int) -> int: ...
    def visualRow(self, logicalRow: int) -> int: ...
    def findItems(self, text: str, flags: typing.Union[int, int]) -> typing.List[QTableWidgetItem]: ...
    def selectedItems(self) -> typing.List[QTableWidgetItem]: ...
    def selectedRanges(self) -> typing.List[QTableWidgetSelectionRange]: ...
    def setRangeSelected(self, range: QTableWidgetSelectionRange, select: bool) -> None: ...
    def removeCellWidget(self, arow: int, acolumn: int) -> None: ...
    def setCellWidget(self, row: int, column: int, widget: QWidget) -> None: ...
    def cellWidget(self, row: int, column: int) -> QWidget: ...
    def closePersistentEditor(self, item: QTableWidgetItem) -> None: ...
    def openPersistentEditor(self, item: QTableWidgetItem) -> None: ...
    def editItem(self, item: QTableWidgetItem) -> None: ...
    def isSortingEnabled(self) -> bool: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def sortItems(self, column: int, order: int = ...) -> None: ...
    @overload
    def setCurrentCell(self, row: int, column: int) -> None: ...
    @overload
    def setCurrentCell(self, row: int, column: int, command: typing.Union[int, int]) -> None: ...
    @overload
    def setCurrentItem(self, item: QTableWidgetItem) -> None: ...
    @overload
    def setCurrentItem(self, item: QTableWidgetItem, command: typing.Union[int, int]) -> None: ...
    def currentItem(self) -> QTableWidgetItem: ...
    def currentColumn(self) -> int: ...
    def currentRow(self) -> int: ...
    def setHorizontalHeaderLabels(self, labels: typing.Iterable[str]) -> None: ...
    def setVerticalHeaderLabels(self, labels: typing.Iterable[str]) -> None: ...
    def takeHorizontalHeaderItem(self, column: int) -> QTableWidgetItem: ...
    def setHorizontalHeaderItem(self, column: int, item: QTableWidgetItem) -> None: ...
    def horizontalHeaderItem(self, column: int) -> QTableWidgetItem: ...
    def takeVerticalHeaderItem(self, row: int) -> QTableWidgetItem: ...
    def setVerticalHeaderItem(self, row: int, item: QTableWidgetItem) -> None: ...
    def verticalHeaderItem(self, row: int) -> QTableWidgetItem: ...
    def takeItem(self, row: int, column: int) -> QTableWidgetItem: ...
    def setItem(self, row: int, column: int, item: QTableWidgetItem) -> None: ...
    def item(self, row: int, column: int) -> QTableWidgetItem: ...
    def column(self, item: QTableWidgetItem) -> int: ...
    def row(self, item: QTableWidgetItem) -> int: ...
    def columnCount(self) -> int: ...
    def setColumnCount(self, columns: int) -> None: ...
    def rowCount(self) -> int: ...
    def setRowCount(self, rows: int) -> None: ...


class QTabWidget(QWidget):

    currentChanged: PYQT_SIGNAL
    tabBarClicked: PYQT_SIGNAL
    tabBarDoubleClicked: PYQT_SIGNAL
    tabCloseRequested: PYQT_SIGNAL

    class TabShape(int):
        Rounded = ... # type: QTabWidget.TabShape
        Triangular = ... # type: QTabWidget.TabShape

    class TabPosition(int):
        North = ... # type: QTabWidget.TabPosition
        South = ... # type: QTabWidget.TabPosition
        West = ... # type: QTabWidget.TabPosition
        East = ... # type: QTabWidget.TabPosition

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def setTabBarAutoHide(self, enabled: bool) -> None: ...
    def tabBarAutoHide(self) -> bool: ...
    #def tabBarDoubleClicked(self, index: int) -> None: ...
    #def tabBarClicked(self, index: int) -> None: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, width: int) -> int: ...
    #def tabCloseRequested(self, index: int) -> None: ...
    def setDocumentMode(self, set: bool) -> None: ...
    def documentMode(self) -> bool: ...
    def setMovable(self, movable: bool) -> None: ...
    def isMovable(self) -> bool: ...
    def setTabsClosable(self, closeable: bool) -> None: ...
    def tabsClosable(self) -> bool: ...
    def setUsesScrollButtons(self, useButtons: bool) -> None: ...
    def usesScrollButtons(self) -> bool: ...
    def setIconSize(self, size: QtCore.QSize) -> None: ...
    def iconSize(self) -> QtCore.QSize: ...
    def setElideMode(self, a0: int) -> None: ...
    def elideMode(self) -> int: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def tabBar(self) -> QTabBar: ...
    def setTabBar(self, a0: QTabBar) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def showEvent(self, a0: QtGui.QShowEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def tabRemoved(self, index: int) -> None: ...
    def tabInserted(self, index: int) -> None: ...
    def initStyleOption(self, option: QStyleOptionTabWidgetFrame) -> None: ...
    #def currentChanged(self, index: int) -> None: ...
    def setCurrentWidget(self, widget: QWidget) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def cornerWidget(self, corner: int = ...) -> QWidget: ...
    def setCornerWidget(self, widget: QWidget, corner: int = ...) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setTabShape(self, s: int) -> None: ...
    def tabShape(self) -> int: ...
    def setTabPosition(self, a0: int) -> None: ...
    def tabPosition(self) -> int: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def indexOf(self, widget: QWidget) -> int: ...
    def widget(self, index: int) -> QWidget: ...
    def currentWidget(self) -> QWidget: ...
    def currentIndex(self) -> int: ...
    def tabWhatsThis(self, index: int) -> str: ...
    def setTabWhatsThis(self, index: int, text: str) -> None: ...
    def tabToolTip(self, index: int) -> str: ...
    def setTabToolTip(self, index: int, tip: str) -> None: ...
    def setTabIcon(self, index: int, icon: QtGui.QIcon) -> None: ...
    def tabIcon(self, index: int) -> QtGui.QIcon: ...
    def setTabText(self, index: int, a1: str) -> None: ...
    def tabText(self, index: int) -> str: ...
    def setTabEnabled(self, index: int, a1: bool) -> None: ...
    def isTabEnabled(self, index: int) -> bool: ...
    def removeTab(self, index: int) -> None: ...
    @overload
    def insertTab(self, index: int, widget: QWidget, a2: str) -> int: ...
    @overload
    def insertTab(self, index: int, widget: QWidget, icon: QtGui.QIcon, label: str) -> int: ...
    @overload
    def addTab(self, widget: QWidget, a1: str) -> int: ...
    @overload
    def addTab(self, widget: QWidget, icon: QtGui.QIcon, label: str) -> int: ...
    def clear(self) -> None: ...


class QTextEdit(QAbstractScrollArea):

    copyAvailable: PYQT_SIGNAL
    currentCharFormatChanged: PYQT_SIGNAL
    cursorPositionChanged: PYQT_SIGNAL
    redoAvailable: PYQT_SIGNAL
    selectionChanged: PYQT_SIGNAL
    textChanged: PYQT_SIGNAL
    undoAvailable: PYQT_SIGNAL

    class AutoFormattingFlag(int):
        AutoNone = ... # type: QTextEdit.AutoFormattingFlag
        AutoBulletList = ... # type: QTextEdit.AutoFormattingFlag
        AutoAll = ... # type: QTextEdit.AutoFormattingFlag

    class LineWrapMode(int):
        NoWrap = ... # type: QTextEdit.LineWrapMode
        WidgetWidth = ... # type: QTextEdit.LineWrapMode
        FixedPixelWidth = ... # type: QTextEdit.LineWrapMode
        FixedColumnWidth = ... # type: QTextEdit.LineWrapMode

    class ExtraSelection:

        cursor = ... # type: QtGui.QTextCursor
        format = ... # type: QtGui.QTextCharFormat

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QTextEdit.ExtraSelection) -> None: ...

    AutoFormatting: typing.Type[int]
    #class AutoFormatting(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QTextEdit.AutoFormatting, QTextEdit.AutoFormattingFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QTextEdit.AutoFormatting) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QTextEdit.AutoFormatting: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def setTabStopDistance(self, distance: float) -> None: ...
    def tabStopDistance(self) -> float: ...
    def placeholderText(self) -> str: ...
    def setPlaceholderText(self, placeholderText: str) -> None: ...
    def setTextBackgroundColor(self, c: typing.Union[QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def textBackgroundColor(self) -> QtGui.QColor: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    @overload
    def inputMethodQuery(self, property: int) -> typing.Any: ...
    @overload
    def inputMethodQuery(self, query: int, argument: typing.Any) -> typing.Any: ...
    def inputMethodEvent(self, a0: QtGui.QInputMethodEvent) -> None: ...
    def insertFromMimeData(self, source: QtCore.QMimeData) -> None: ...
    def canInsertFromMimeData(self, source: QtCore.QMimeData) -> bool: ...
    def createMimeDataFromSelection(self) -> QtCore.QMimeData: ...
    def wheelEvent(self, e: QtGui.QWheelEvent) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def showEvent(self, a0: QtGui.QShowEvent) -> None: ...
    def focusOutEvent(self, e: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, e: QtGui.QFocusEvent) -> None: ...
    def dropEvent(self, e: QtGui.QDropEvent) -> None: ...
    def dragMoveEvent(self, e: QtGui.QDragMoveEvent) -> None: ...
    def dragLeaveEvent(self, e: QtGui.QDragLeaveEvent) -> None: ...
    def dragEnterEvent(self, e: QtGui.QDragEnterEvent) -> None: ...
    def contextMenuEvent(self, e: QtGui.QContextMenuEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def mouseDoubleClickEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def keyReleaseEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def timerEvent(self, e: QtCore.QTimerEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    #def cursorPositionChanged(self) -> None: ...
    #def selectionChanged(self) -> None: ...
    #def copyAvailable(self, b: bool) -> None: ...
    #def currentCharFormatChanged(self, format: QtGui.QTextCharFormat) -> None: ...
    #def redoAvailable(self, b: bool) -> None: ...
    #def undoAvailable(self, b: bool) -> None: ...
    #def textChanged(self) -> None: ...
    def zoomOut(self, range: int = ...) -> None: ...
    def zoomIn(self, range: int = ...) -> None: ...
    def undo(self) -> None: ...
    def redo(self) -> None: ...
    def scrollToAnchor(self, name: str) -> None: ...
    def insertHtml(self, text: str) -> None: ...
    def insertPlainText(self, text: str) -> None: ...
    def selectAll(self) -> None: ...
    def clear(self) -> None: ...
    def paste(self) -> None: ...
    def copy(self) -> None: ...
    def cut(self) -> None: ...
    def setHtml(self, text: str) -> None: ...
    def setPlainText(self, text: str) -> None: ...
    def setAlignment(self, a: typing.Union[int, int]) -> None: ...
    def setCurrentFont(self, f: QtGui.QFont) -> None: ...
    def setTextColor(self, c: typing.Union[QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def setText(self, text: str) -> None: ...
    def setFontItalic(self, b: bool) -> None: ...
    def setFontUnderline(self, b: bool) -> None: ...
    def setFontWeight(self, w: int) -> None: ...
    def setFontFamily(self, fontFamily: str) -> None: ...
    def setFontPointSize(self, s: float) -> None: ...
    def print(self, printer: QtGui.QPagedPaintDevice) -> None: ...
    def print_(self, printer: QtGui.QPagedPaintDevice) -> None: ...
    def moveCursor(self, operation: int, mode: int = ...) -> None: ...
    def canPaste(self) -> bool: ...
    def extraSelections(self) -> typing.List[QTextEdit.ExtraSelection]: ...
    def setExtraSelections(self, selections: typing.Iterable[QTextEdit.ExtraSelection]) -> None: ...
    def cursorWidth(self) -> int: ...
    def setCursorWidth(self, width: int) -> None: ...
    def textInteractionFlags(self) -> int: ...
    def setTextInteractionFlags(self, flags: typing.Union[int, int]) -> None: ...
    def setAcceptRichText(self, accept: bool) -> None: ...
    def acceptRichText(self) -> bool: ...
    def setTabStopWidth(self, width: int) -> None: ...
    def tabStopWidth(self) -> int: ...
    def setOverwriteMode(self, overwrite: bool) -> None: ...
    def overwriteMode(self) -> bool: ...
    def anchorAt(self, pos: QtCore.QPoint) -> str: ...
    @overload
    def cursorRect(self, cursor: QtGui.QTextCursor) -> QtCore.QRect: ...
    @overload
    def cursorRect(self) -> QtCore.QRect: ...
    def cursorForPosition(self, pos: QtCore.QPoint) -> QtGui.QTextCursor: ...
    @overload
    def createStandardContextMenu(self) -> QMenu: ...
    @overload
    def createStandardContextMenu(self, position: QtCore.QPoint) -> QMenu: ...
    def loadResource(self, type: int, name: QtCore.QUrl) -> typing.Any: ...
    def ensureCursorVisible(self) -> None: ...
    def append(self, text: str) -> None: ...
    def toHtml(self) -> str: ...
    def toPlainText(self) -> str: ...
    @overload
    def find(self, exp: str, options: typing.Union[int, int] = ...) -> bool: ...
    @overload
    def find(self, exp: QtCore.QRegExp, options: typing.Union[int, int] = ...) -> bool: ...
    def setWordWrapMode(self, policy: int) -> None: ...
    def wordWrapMode(self) -> int: ...
    def setLineWrapColumnOrWidth(self, w: int) -> None: ...
    def lineWrapColumnOrWidth(self) -> int: ...
    def setLineWrapMode(self, mode: int) -> None: ...
    def lineWrapMode(self) -> int: ...
    def setUndoRedoEnabled(self, enable: bool) -> None: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def documentTitle(self) -> str: ...
    def setDocumentTitle(self, title: str) -> None: ...
    def setTabChangesFocus(self, b: bool) -> None: ...
    def tabChangesFocus(self) -> bool: ...
    def setAutoFormatting(self, features: typing.Union[int, int]) -> None: ...
    def autoFormatting(self) -> int: ...
    def currentCharFormat(self) -> QtGui.QTextCharFormat: ...
    def setCurrentCharFormat(self, format: QtGui.QTextCharFormat) -> None: ...
    def mergeCurrentCharFormat(self, modifier: QtGui.QTextCharFormat) -> None: ...
    def alignment(self) -> int: ...
    def currentFont(self) -> QtGui.QFont: ...
    def textColor(self) -> QtGui.QColor: ...
    def fontItalic(self) -> bool: ...
    def fontUnderline(self) -> bool: ...
    def fontWeight(self) -> int: ...
    def fontFamily(self) -> str: ...
    def fontPointSize(self) -> float: ...
    def setReadOnly(self, ro: bool) -> None: ...
    def isReadOnly(self) -> bool: ...
    def textCursor(self) -> QtGui.QTextCursor: ...
    def setTextCursor(self, cursor: QtGui.QTextCursor) -> None: ...
    def document(self) -> QtGui.QTextDocument: ...
    def setDocument(self, document: QtGui.QTextDocument) -> None: ...


class QTextBrowser(QTextEdit):

    anchorClicked: PYQT_SIGNAL
    backwardAvailable: PYQT_SIGNAL
    forwardAvailable: PYQT_SIGNAL
    highlighted: PYQT_SIGNAL
    historyChanged: PYQT_SIGNAL
    sourceChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    #def historyChanged(self) -> None: ...
    def forwardHistoryCount(self) -> int: ...
    def backwardHistoryCount(self) -> int: ...
    def historyUrl(self, a0: int) -> QtCore.QUrl: ...
    def historyTitle(self, a0: int) -> str: ...
    def setOpenLinks(self, open: bool) -> None: ...
    def openLinks(self) -> bool: ...
    def setOpenExternalLinks(self, open: bool) -> None: ...
    def openExternalLinks(self) -> bool: ...
    def clearHistory(self) -> None: ...
    def isForwardAvailable(self) -> bool: ...
    def isBackwardAvailable(self) -> bool: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, ev: QtGui.QFocusEvent) -> None: ...
    def mouseReleaseEvent(self, ev: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, ev: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, ev: QtGui.QMouseEvent) -> None: ...
    def keyPressEvent(self, ev: QtGui.QKeyEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    #def anchorClicked(self, a0: QtCore.QUrl) -> None: ...
    #@overload
    #def highlighted(self, a0: QtCore.QUrl) -> None: ...
    #@overload
    #def highlighted(self, a0: str) -> None: ...
    #def sourceChanged(self, a0: QtCore.QUrl) -> None: ...
    #def forwardAvailable(self, a0: bool) -> None: ...
    #def backwardAvailable(self, a0: bool) -> None: ...
    def reload(self) -> None: ...
    def home(self) -> None: ...
    def forward(self) -> None: ...
    def backward(self) -> None: ...
    def setSource(self, name: QtCore.QUrl) -> None: ...
    def loadResource(self, type: int, name: QtCore.QUrl) -> typing.Any: ...
    def setSearchPaths(self, paths: typing.Iterable[str]) -> None: ...
    def searchPaths(self) -> typing.List[str]: ...
    def source(self) -> QtCore.QUrl: ...


class QToolBar(QWidget):

    actionTriggered: PYQT_SIGNAL
    allowedAreasChanged: PYQT_SIGNAL
    iconSizeChanged: PYQT_SIGNAL
    movableChanged: PYQT_SIGNAL
    orientationChanged: PYQT_SIGNAL
    toolButtonStyleChanged: PYQT_SIGNAL
    topLevelChanged: PYQT_SIGNAL
    visibilityChanged: PYQT_SIGNAL

    @overload
    def __init__(self, title: str, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def isFloating(self) -> bool: ...
    def setFloatable(self, floatable: bool) -> None: ...
    def isFloatable(self) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def changeEvent(self, event: QtCore.QEvent) -> None: ...
    def actionEvent(self, event: QtGui.QActionEvent) -> None: ...
    def initStyleOption(self, option: QStyleOptionToolBar) -> None: ...
    #def visibilityChanged(self, visible: bool) -> None: ...
    #def topLevelChanged(self, topLevel: bool) -> None: ...
    #def toolButtonStyleChanged(self, toolButtonStyle: int) -> None: ...
    #def iconSizeChanged(self, iconSize: QtCore.QSize) -> None: ...
    #def orientationChanged(self, orientation: int) -> None: ...
    #def allowedAreasChanged(self, allowedAreas: typing.Union[int, int]) -> None: ...
    #def movableChanged(self, movable: bool) -> None: ...
    #def actionTriggered(self, action: QAction) -> None: ...
    def setToolButtonStyle(self, toolButtonStyle: int) -> None: ...
    def setIconSize(self, iconSize: QtCore.QSize) -> None: ...
    def widgetForAction(self, action: QAction) -> QWidget: ...
    def toolButtonStyle(self) -> int: ...
    def iconSize(self) -> QtCore.QSize: ...
    def toggleViewAction(self) -> QAction: ...
    @overload
    def actionAt(self, p: QtCore.QPoint) -> QAction: ...
    @overload
    def actionAt(self, ax: int, ay: int) -> QAction: ...
    def actionGeometry(self, action: QAction) -> QtCore.QRect: ...
    def insertWidget(self, before: QAction, widget: QWidget) -> QAction: ...
    def addWidget(self, widget: QWidget) -> QAction: ...
    def insertSeparator(self, before: QAction) -> QAction: ...
    def addSeparator(self) -> QAction: ...
    @overload
    def addAction(self, action: QAction) -> None: ...
    @overload
    def addAction(self, text: str) -> QAction: ...
    @overload
    def addAction(self, icon: QtGui.QIcon, text: str) -> QAction: ...
    @overload
    def addAction(self, text: str, slot: PYQT_SLOT) -> QAction: ...
    @overload
    def addAction(self, icon: QtGui.QIcon, text: str, slot: PYQT_SLOT) -> QAction: ...
    def clear(self) -> None: ...
    def orientation(self) -> int: ...
    def setOrientation(self, orientation: int) -> None: ...
    def isAreaAllowed(self, area: int) -> bool: ...
    def allowedAreas(self) -> int: ...
    def setAllowedAreas(self, areas: typing.Union[int, int]) -> None: ...
    def isMovable(self) -> bool: ...
    def setMovable(self, movable: bool) -> None: ...


class QToolBox(QFrame):

    currentChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def itemRemoved(self, index: int) -> None: ...
    def itemInserted(self, index: int) -> None: ...
    #def currentChanged(self, index: int) -> None: ...
    def setCurrentWidget(self, widget: QWidget) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def indexOf(self, widget: QWidget) -> int: ...
    def widget(self, index: int) -> QWidget: ...
    def currentWidget(self) -> QWidget: ...
    def currentIndex(self) -> int: ...
    def itemToolTip(self, index: int) -> str: ...
    def setItemToolTip(self, index: int, toolTip: str) -> None: ...
    def itemIcon(self, index: int) -> QtGui.QIcon: ...
    def setItemIcon(self, index: int, icon: QtGui.QIcon) -> None: ...
    def itemText(self, index: int) -> str: ...
    def setItemText(self, index: int, text: str) -> None: ...
    def isItemEnabled(self, index: int) -> bool: ...
    def setItemEnabled(self, index: int, enabled: bool) -> None: ...
    def removeItem(self, index: int) -> None: ...
    @overload
    def insertItem(self, index: int, item: QWidget, text: str) -> int: ...
    @overload
    def insertItem(self, index: int, widget: QWidget, icon: QtGui.QIcon, text: str) -> int: ...
    @overload
    def addItem(self, item: QWidget, text: str) -> int: ...
    @overload
    def addItem(self, item: QWidget, iconSet: QtGui.QIcon, text: str) -> int: ...


class QToolButton(QAbstractButton):

    triggered: PYQT_SIGNAL

    class ToolButtonPopupMode(int):
        DelayedPopup = ... # type: QToolButton.ToolButtonPopupMode
        MenuButtonPopup = ... # type: QToolButton.ToolButtonPopupMode
        InstantPopup = ... # type: QToolButton.ToolButtonPopupMode

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def hitButton(self, pos: QtCore.QPoint) -> bool: ...
    def nextCheckState(self) -> None: ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def timerEvent(self, a0: QtCore.QTimerEvent) -> None: ...
    def leaveEvent(self, a0: QtCore.QEvent) -> None: ...
    def enterEvent(self, a0: QtCore.QEvent) -> None: ...
    def actionEvent(self, a0: QtGui.QActionEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: QStyleOptionToolButton) -> None: ...
    #def triggered(self, a0: QAction) -> None: ...
    def setDefaultAction(self, a0: QAction) -> None: ...
    def setToolButtonStyle(self, style: int) -> None: ...
    def showMenu(self) -> None: ...
    def autoRaise(self) -> bool: ...
    def setAutoRaise(self, enable: bool) -> None: ...
    def defaultAction(self) -> QAction: ...
    def popupMode(self) -> int: ...
    def setPopupMode(self, mode: int) -> None: ...
    def menu(self) -> QMenu: ...
    def setMenu(self, menu: QMenu) -> None: ...
    def setArrowType(self, type: int) -> None: ...
    def arrowType(self) -> int: ...
    def toolButtonStyle(self) -> int: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QToolTip(sip.simplewrapper):

    def __init__(self, a0: QToolTip) -> None: ...

    @staticmethod
    def text() -> str: ...
    @staticmethod
    def isVisible() -> bool: ...
    @staticmethod
    def setFont(a0: QtGui.QFont) -> None: ...
    @staticmethod
    def font() -> QtGui.QFont: ...
    @staticmethod
    def setPalette(a0: QtGui.QPalette) -> None: ...
    @staticmethod
    def hideText() -> None: ...
    @staticmethod
    def palette() -> QtGui.QPalette: ...
    @overload
    @staticmethod
    def showText(pos: QtCore.QPoint, text: str, widget: typing.Optional[QWidget] = ...) -> None: ...
    @overload
    @staticmethod
    def showText(pos: QtCore.QPoint, text: str, w: QWidget, rect: QtCore.QRect) -> None: ...
    @overload
    @staticmethod
    def showText(pos: QtCore.QPoint, text: str, w: QWidget, rect: QtCore.QRect, msecShowTime: int) -> None: ...


class QTreeView(QAbstractItemView):

    collapsed: PYQT_SIGNAL
    expanded: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def resetIndentation(self) -> None: ...
    def viewportSizeHint(self) -> QtCore.QSize: ...
    def treePosition(self) -> int: ...
    def setTreePosition(self, logicalIndex: int) -> None: ...
    def setHeaderHidden(self, hide: bool) -> None: ...
    def isHeaderHidden(self) -> bool: ...
    def setExpandsOnDoubleClick(self, enable: bool) -> None: ...
    def expandsOnDoubleClick(self) -> bool: ...
    def currentChanged(self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex) -> None: ...
    def selectionChanged(self, selected: QtCore.QItemSelection, deselected: QtCore.QItemSelection) -> None: ...
    def rowHeight(self, index: QtCore.QModelIndex) -> int: ...
    def viewportEvent(self, event: QtCore.QEvent) -> bool: ...
    def dragMoveEvent(self, event: QtGui.QDragMoveEvent) -> None: ...
    def expandToDepth(self, depth: int) -> None: ...
    def wordWrap(self) -> bool: ...
    def setWordWrap(self, on: bool) -> None: ...
    def setFirstColumnSpanned(self, row: int, parent: QtCore.QModelIndex, span: bool) -> None: ...
    def isFirstColumnSpanned(self, row: int, parent: QtCore.QModelIndex) -> bool: ...
    def setAutoExpandDelay(self, delay: int) -> None: ...
    def autoExpandDelay(self) -> int: ...
    def sortByColumn(self, column: int, order: int) -> None: ...
    def allColumnsShowFocus(self) -> bool: ...
    def setAllColumnsShowFocus(self, enable: bool) -> None: ...
    def isAnimated(self) -> bool: ...
    def setAnimated(self, enable: bool) -> None: ...
    def isSortingEnabled(self) -> bool: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def setColumnWidth(self, column: int, width: int) -> None: ...
    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool: ...
    def horizontalScrollbarAction(self, action: int) -> None: ...
    def indexRowSizeHint(self, index: QtCore.QModelIndex) -> int: ...
    def sizeHintForColumn(self, column: int) -> int: ...
    def updateGeometries(self) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def drawTree(self, painter: QtGui.QPainter, region: QtGui.QRegion) -> None: ...
    def drawBranches(self, painter: QtGui.QPainter, rect: QtCore.QRect, index: QtCore.QModelIndex) -> None: ...
    def drawRow(self, painter: QtGui.QPainter, options: QStyleOptionViewItem, index: QtCore.QModelIndex) -> None: ...
    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def timerEvent(self, event: QtCore.QTimerEvent) -> None: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def selectedIndexes(self) -> typing.List[QtCore.QModelIndex]: ...
    def visualRegionForSelection(self, selection: QtCore.QItemSelection) -> QtGui.QRegion: ...
    def setSelection(self, rect: QtCore.QRect, command: typing.Union[int, int]) -> None: ...
    def verticalOffset(self) -> int: ...
    def horizontalOffset(self) -> int: ...
    def moveCursor(self, cursorAction: int, modifiers: typing.Union[int, int]) -> QtCore.QModelIndex: ...
    def rowsAboutToBeRemoved(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def rowsInserted(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def rowsRemoved(self, parent: QtCore.QModelIndex, first: int, last: int) -> None: ...
    def reexpand(self) -> None: ...
    def columnMoved(self) -> None: ...
    def columnCountChanged(self, oldCount: int, newCount: int) -> None: ...
    def columnResized(self, column: int, oldSize: int, newSize: int) -> None: ...
    def selectAll(self) -> None: ...
    def resizeColumnToContents(self, column: int) -> None: ...
    def collapseAll(self) -> None: ...
    def collapse(self, index: QtCore.QModelIndex) -> None: ...
    def expandAll(self) -> None: ...
    def expand(self, index: QtCore.QModelIndex) -> None: ...
    def showColumn(self, column: int) -> None: ...
    def hideColumn(self, column: int) -> None: ...
    def dataChanged(self, topLeft: QtCore.QModelIndex, bottomRight: QtCore.QModelIndex, roles: typing.Iterable[int] = ...) -> None: ...
    #def collapsed(self, index: QtCore.QModelIndex) -> None: ...
    #def expanded(self, index: QtCore.QModelIndex) -> None: ...
    def reset(self) -> None: ...
    def indexBelow(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def indexAbove(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def indexAt(self, p: QtCore.QPoint) -> QtCore.QModelIndex: ...
    def scrollTo(self, index: QtCore.QModelIndex, hint: int = ...) -> None: ...
    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect: ...
    def keyboardSearch(self, search: str) -> None: ...
    def setExpanded(self, index: QtCore.QModelIndex, expand: bool) -> None: ...
    def isExpanded(self, index: QtCore.QModelIndex) -> bool: ...
    def setRowHidden(self, row: int, parent: QtCore.QModelIndex, hide: bool) -> None: ...
    def isRowHidden(self, row: int, parent: QtCore.QModelIndex) -> bool: ...
    def setColumnHidden(self, column: int, hide: bool) -> None: ...
    def isColumnHidden(self, column: int) -> bool: ...
    def columnAt(self, x: int) -> int: ...
    def columnWidth(self, column: int) -> int: ...
    def columnViewportPosition(self, column: int) -> int: ...
    def setItemsExpandable(self, enable: bool) -> None: ...
    def itemsExpandable(self) -> bool: ...
    def setUniformRowHeights(self, uniform: bool) -> None: ...
    def uniformRowHeights(self) -> bool: ...
    def setRootIsDecorated(self, show: bool) -> None: ...
    def rootIsDecorated(self) -> bool: ...
    def setIndentation(self, i: int) -> None: ...
    def indentation(self) -> int: ...
    def setHeader(self, header: QHeaderView) -> None: ...
    def header(self) -> QHeaderView: ...
    def setSelectionModel(self, selectionModel: QtCore.QItemSelectionModel) -> None: ...
    def setRootIndex(self, index: QtCore.QModelIndex) -> None: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...


class QTreeWidgetItem(sip.wrapper):

    ChildIndicatorPolicy: typing.Type[int]
    #class ChildIndicatorPolicy(int): ...
    ShowIndicator = ... # type: int
    DontShowIndicator = ... # type: int
    DontShowIndicatorWhenChildless = ... # type: int

    ItemType: typing.Type[int]
    #class ItemType(int): ...
    Type = ... # type: int
    UserType = ... # type: int

    @overload
    def __init__(self, type: int = ...) -> None: ...
    @overload
    def __init__(self, strings: typing.Iterable[str], type: int = ...) -> None: ...
    @overload
    def __init__(self, parent: QTreeWidget, type: int = ...) -> None: ...
    @overload
    def __init__(self, parent: QTreeWidget, strings: typing.Iterable[str], type: int = ...) -> None: ...
    @overload
    def __init__(self, parent: QTreeWidget, preceding: QTreeWidgetItem, type: int = ...) -> None: ...
    @overload
    def __init__(self, parent: QTreeWidgetItem, type: int = ...) -> None: ...
    @overload
    def __init__(self, parent: QTreeWidgetItem, strings: typing.Iterable[str], type: int = ...) -> None: ...
    @overload
    def __init__(self, parent: QTreeWidgetItem, preceding: QTreeWidgetItem, type: int = ...) -> None: ...
    @overload
    def __init__(self, other: QTreeWidgetItem) -> None: ...

    def emitDataChanged(self) -> None: ...
    def isDisabled(self) -> bool: ...
    def setDisabled(self, disabled: bool) -> None: ...
    def isFirstColumnSpanned(self) -> bool: ...
    def setFirstColumnSpanned(self, aspan: bool) -> None: ...
    def removeChild(self, child: QTreeWidgetItem) -> None: ...
    def childIndicatorPolicy(self) -> int: ...
    def setChildIndicatorPolicy(self, policy: int) -> None: ...
    def isExpanded(self) -> bool: ...
    def setExpanded(self, aexpand: bool) -> None: ...
    def isHidden(self) -> bool: ...
    def setHidden(self, ahide: bool) -> None: ...
    def isSelected(self) -> bool: ...
    def setSelected(self, aselect: bool) -> None: ...
    def sortChildren(self, column: int, order: int) -> None: ...
    def setForeground(self, column: int, brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def foreground(self, column: int) -> QtGui.QBrush: ...
    def setBackground(self, column: int, brush: typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]) -> None: ...
    def background(self, column: int) -> QtGui.QBrush: ...
    def takeChildren(self) -> typing.List[QTreeWidgetItem]: ...
    def insertChildren(self, index: int, children: typing.Iterable[QTreeWidgetItem]) -> None: ...
    def addChildren(self, children: typing.Iterable[QTreeWidgetItem]) -> None: ...
    def setSizeHint(self, column: int, size: QtCore.QSize) -> None: ...
    def sizeHint(self, column: int) -> QtCore.QSize: ...
    def indexOfChild(self, achild: QTreeWidgetItem) -> int: ...
    def setFont(self, column: int, afont: QtGui.QFont) -> None: ...
    def setWhatsThis(self, column: int, awhatsThis: str) -> None: ...
    def setToolTip(self, column: int, atoolTip: str) -> None: ...
    def setStatusTip(self, column: int, astatusTip: str) -> None: ...
    def setIcon(self, column: int, aicon: QtGui.QIcon) -> None: ...
    def setText(self, column: int, atext: str) -> None: ...
    def setFlags(self, aflags: typing.Union[int, int]) -> None: ...
    def type(self) -> int: ...
    def takeChild(self, index: int) -> QTreeWidgetItem: ...
    def insertChild(self, index: int, child: QTreeWidgetItem) -> None: ...
    def addChild(self, child: QTreeWidgetItem) -> None: ...
    def columnCount(self) -> int: ...
    def childCount(self) -> int: ...
    def child(self, index: int) -> QTreeWidgetItem: ...
    def parent(self) -> QTreeWidgetItem: ...
    def write(self, out: QtCore.QDataStream) -> None: ...
    def read(self, in_: QtCore.QDataStream) -> None: ...
    def setData(self, column: int, role: int, value: typing.Any) -> None: ...
    def data(self, column: int, role: int) -> typing.Any: ...
    def setCheckState(self, column: int, state: int) -> None: ...
    def checkState(self, column: int) -> int: ...
    def setTextAlignment(self, column: int, alignment: int) -> None: ...
    def textAlignment(self, column: int) -> int: ...
    def font(self, column: int) -> QtGui.QFont: ...
    def whatsThis(self, column: int) -> str: ...
    def toolTip(self, column: int) -> str: ...
    def statusTip(self, column: int) -> str: ...
    def icon(self, column: int) -> QtGui.QIcon: ...
    def text(self, column: int) -> str: ...
    def flags(self) -> int: ...
    def treeWidget(self) -> QTreeWidget: ...
    def clone(self) -> QTreeWidgetItem: ...


class QTreeWidget(QTreeView):

    currentItemChanged: PYQT_SIGNAL
    itemActivated: PYQT_SIGNAL
    itemChanged: PYQT_SIGNAL
    itemClicked: PYQT_SIGNAL
    itemCollapsed: PYQT_SIGNAL
    itemDoubleClicked: PYQT_SIGNAL
    itemEntered: PYQT_SIGNAL
    itemExpanded: PYQT_SIGNAL
    itemPressed: PYQT_SIGNAL
    itemSelectionChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def isPersistentEditorOpen(self, item: QTreeWidgetItem, column: int = ...) -> bool: ...
    def setSelectionModel(self, selectionModel: QtCore.QItemSelectionModel) -> None: ...
    def removeItemWidget(self, item: QTreeWidgetItem, column: int) -> None: ...
    def itemBelow(self, item: QTreeWidgetItem) -> QTreeWidgetItem: ...
    def itemAbove(self, item: QTreeWidgetItem) -> QTreeWidgetItem: ...
    def setFirstItemColumnSpanned(self, item: QTreeWidgetItem, span: bool) -> None: ...
    def isFirstItemColumnSpanned(self, item: QTreeWidgetItem) -> bool: ...
    def setHeaderLabel(self, alabel: str) -> None: ...
    def invisibleRootItem(self) -> QTreeWidgetItem: ...
    def dropEvent(self, event: QtGui.QDropEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def itemFromIndex(self, index: QtCore.QModelIndex) -> QTreeWidgetItem: ...
    def indexFromItem(self, item: QTreeWidgetItem, column: int = ...) -> QtCore.QModelIndex: ...
    def supportedDropActions(self) -> int: ...
    def dropMimeData(self, parent: QTreeWidgetItem, index: int, data: QtCore.QMimeData, action: int) -> bool: ...
    def mimeData(self, items: typing.Iterable[QTreeWidgetItem]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    #def itemSelectionChanged(self) -> None: ...
    #def currentItemChanged(self, current: QTreeWidgetItem, previous: QTreeWidgetItem) -> None: ...
    #def itemCollapsed(self, item: QTreeWidgetItem) -> None: ...
    #def itemExpanded(self, item: QTreeWidgetItem) -> None: ...
    #def itemChanged(self, item: QTreeWidgetItem, column: int) -> None: ...
    #def itemEntered(self, item: QTreeWidgetItem, column: int) -> None: ...
    #def itemActivated(self, item: QTreeWidgetItem, column: int) -> None: ...
    #def itemDoubleClicked(self, item: QTreeWidgetItem, column: int) -> None: ...
    #def itemClicked(self, item: QTreeWidgetItem, column: int) -> None: ...
    #def itemPressed(self, item: QTreeWidgetItem, column: int) -> None: ...
    def clear(self) -> None: ...
    def collapseItem(self, item: QTreeWidgetItem) -> None: ...
    def expandItem(self, item: QTreeWidgetItem) -> None: ...
    def scrollToItem(self, item: QTreeWidgetItem, hint: int = ...) -> None: ...
    def findItems(self, text: str, flags: typing.Union[int, int], column: int = ...) -> typing.List[QTreeWidgetItem]: ...
    def selectedItems(self) -> typing.List[QTreeWidgetItem]: ...
    def setItemWidget(self, item: QTreeWidgetItem, column: int, widget: QWidget) -> None: ...
    def itemWidget(self, item: QTreeWidgetItem, column: int) -> QWidget: ...
    def closePersistentEditor(self, item: QTreeWidgetItem, column: int = ...) -> None: ...
    def openPersistentEditor(self, item: QTreeWidgetItem, column: int = ...) -> None: ...
    def editItem(self, item: QTreeWidgetItem, column: int = ...) -> None: ...
    def sortItems(self, column: int, order: int) -> None: ...
    def sortColumn(self) -> int: ...
    def visualItemRect(self, item: QTreeWidgetItem) -> QtCore.QRect: ...
    @overload
    def itemAt(self, p: QtCore.QPoint) -> QTreeWidgetItem: ...
    @overload
    def itemAt(self, ax: int, ay: int) -> QTreeWidgetItem: ...
    @overload
    def setCurrentItem(self, item: QTreeWidgetItem) -> None: ...
    @overload
    def setCurrentItem(self, item: QTreeWidgetItem, column: int) -> None: ...
    @overload
    def setCurrentItem(self, item: QTreeWidgetItem, column: int, command: typing.Union[int, int]) -> None: ...
    def currentColumn(self) -> int: ...
    def currentItem(self) -> QTreeWidgetItem: ...
    def setHeaderLabels(self, labels: typing.Iterable[str]) -> None: ...
    def setHeaderItem(self, item: QTreeWidgetItem) -> None: ...
    def headerItem(self) -> QTreeWidgetItem: ...
    def addTopLevelItems(self, items: typing.Iterable[QTreeWidgetItem]) -> None: ...
    def insertTopLevelItems(self, index: int, items: typing.Iterable[QTreeWidgetItem]) -> None: ...
    def indexOfTopLevelItem(self, item: QTreeWidgetItem) -> int: ...
    def takeTopLevelItem(self, index: int) -> QTreeWidgetItem: ...
    def addTopLevelItem(self, item: QTreeWidgetItem) -> None: ...
    def insertTopLevelItem(self, index: int, item: QTreeWidgetItem) -> None: ...
    def topLevelItemCount(self) -> int: ...
    def topLevelItem(self, index: int) -> QTreeWidgetItem: ...
    def setColumnCount(self, columns: int) -> None: ...
    def columnCount(self) -> int: ...


class QTreeWidgetItemIterator(sip.simplewrapper):

    IteratorFlag: typing.Type[int]
    #class IteratorFlag(int): ...
    All = ... # type: int
    Hidden = ... # type: int
    NotHidden = ... # type: int
    Selected = ... # type: int
    Unselected = ... # type: int
    Selectable = ... # type: int
    NotSelectable = ... # type: int
    DragEnabled = ... # type: int
    DragDisabled = ... # type: int
    DropEnabled = ... # type: int
    DropDisabled = ... # type: int
    HasChildren = ... # type: int
    NoChildren = ... # type: int
    Checked = ... # type: int
    NotChecked = ... # type: int
    Enabled = ... # type: int
    Disabled = ... # type: int
    Editable = ... # type: int
    NotEditable = ... # type: int
    UserFlag = ... # type: int

    IteratorFlags: typing.Type[int]
    #class IteratorFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QTreeWidgetItemIterator.IteratorFlags, QTreeWidgetItemIterator.IteratorFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QTreeWidgetItemIterator.IteratorFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QTreeWidgetItemIterator.IteratorFlags: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self, it: QTreeWidgetItemIterator) -> None: ...
    @overload
    def __init__(self, widget: QTreeWidget, flags: int = ...) -> None: ...
    @overload
    def __init__(self, item: QTreeWidgetItem, flags: int = ...) -> None: ...

    def value(self) -> QTreeWidgetItem: ...


class QUndoGroup(QtCore.QObject):

    activeStackChanged: PYQT_SIGNAL
    canRedoChanged: PYQT_SIGNAL
    canUndoChanged: PYQT_SIGNAL
    cleanChanged: PYQT_SIGNAL
    indexChanged: PYQT_SIGNAL
    redoTextChanged: PYQT_SIGNAL
    undoTextChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    #def undoTextChanged(self, undoText: str) -> None: ...
    #def redoTextChanged(self, redoText: str) -> None: ...
    #def indexChanged(self, idx: int) -> None: ...
    #def cleanChanged(self, clean: bool) -> None: ...
    #def canUndoChanged(self, canUndo: bool) -> None: ...
    #def canRedoChanged(self, canRedo: bool) -> None: ...
    #def activeStackChanged(self, stack: QUndoStack) -> None: ...
    def undo(self) -> None: ...
    def setActiveStack(self, stack: QUndoStack) -> None: ...
    def redo(self) -> None: ...
    def isClean(self) -> bool: ...
    def redoText(self) -> str: ...
    def undoText(self) -> str: ...
    def canRedo(self) -> bool: ...
    def canUndo(self) -> bool: ...
    def createUndoAction(self, parent: QtCore.QObject, prefix: str = ...) -> QAction: ...
    def createRedoAction(self, parent: QtCore.QObject, prefix: str = ...) -> QAction: ...
    def activeStack(self) -> QUndoStack: ...
    def stacks(self) -> typing.List[QUndoStack]: ...
    def removeStack(self, stack: QUndoStack) -> None: ...
    def addStack(self, stack: QUndoStack) -> None: ...


class QUndoCommand(sip.wrapper):

    @overload
    def __init__(self, parent: typing.Optional[QUndoCommand] = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Optional[QUndoCommand] = ...) -> None: ...

    def setObsolete(self, obsolete: bool) -> None: ...
    def isObsolete(self) -> bool: ...
    def actionText(self) -> str: ...
    def child(self, index: int) -> QUndoCommand: ...
    def childCount(self) -> int: ...
    def undo(self) -> None: ...
    def text(self) -> str: ...
    def setText(self, text: str) -> None: ...
    def redo(self) -> None: ...
    def mergeWith(self, other: QUndoCommand) -> bool: ...
    def id(self) -> int: ...


class QUndoStack(QtCore.QObject):

    canRedoChanged: PYQT_SIGNAL
    canUndoChanged: PYQT_SIGNAL
    cleanChanged: PYQT_SIGNAL
    indexChanged: PYQT_SIGNAL
    redoTextChanged: PYQT_SIGNAL
    undoTextChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def command(self, index: int) -> QUndoCommand: ...
    def undoLimit(self) -> int: ...
    def setUndoLimit(self, limit: int) -> None: ...
    #def undoTextChanged(self, undoText: str) -> None: ...
    #def redoTextChanged(self, redoText: str) -> None: ...
    #def indexChanged(self, idx: int) -> None: ...
    #def cleanChanged(self, clean: bool) -> None: ...
    #def canUndoChanged(self, canUndo: bool) -> None: ...
    #def canRedoChanged(self, canRedo: bool) -> None: ...
    def resetClean(self) -> None: ...
    def undo(self) -> None: ...
    def setIndex(self, idx: int) -> None: ...
    def setClean(self) -> None: ...
    def setActive(self, active: bool = ...) -> None: ...
    def redo(self) -> None: ...
    def endMacro(self) -> None: ...
    def beginMacro(self, text: str) -> None: ...
    def cleanIndex(self) -> int: ...
    def isClean(self) -> bool: ...
    def isActive(self) -> bool: ...
    def createRedoAction(self, parent: QtCore.QObject, prefix: str = ...) -> QAction: ...
    def createUndoAction(self, parent: QtCore.QObject, prefix: str = ...) -> QAction: ...
    def text(self, idx: int) -> str: ...
    def index(self) -> int: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def redoText(self) -> str: ...
    def undoText(self) -> str: ...
    def canRedo(self) -> bool: ...
    def canUndo(self) -> bool: ...
    def push(self, cmd: QUndoCommand) -> None: ...
    def clear(self) -> None: ...


class QUndoView(QListView):

    @overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, stack: QUndoStack, parent: typing.Optional[QWidget] = ..., **props) -> None: ...
    @overload
    def __init__(self, group: QUndoGroup, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def setGroup(self, group: QUndoGroup) -> None: ...
    def setStack(self, stack: QUndoStack) -> None: ...
    def cleanIcon(self) -> QtGui.QIcon: ...
    def setCleanIcon(self, icon: QtGui.QIcon) -> None: ...
    def emptyLabel(self) -> str: ...
    def setEmptyLabel(self, label: str) -> None: ...
    def group(self) -> QUndoGroup: ...
    def stack(self) -> QUndoStack: ...


class QWhatsThis(sip.simplewrapper):

    def __init__(self, a0: QWhatsThis) -> None: ...

    @staticmethod
    def createAction(parent: typing.Optional[QtCore.QObject] = ...) -> QAction: ...
    @staticmethod
    def hideText() -> None: ...
    @staticmethod
    def showText(pos: QtCore.QPoint, text: str, widget: typing.Optional[QWidget] = ...) -> None: ...
    @staticmethod
    def leaveWhatsThisMode() -> None: ...
    @staticmethod
    def inWhatsThisMode() -> bool: ...
    @staticmethod
    def enterWhatsThisMode() -> None: ...


class QWidgetAction(QAction):

    def __init__(self, parent: QtCore.QObject, **props) -> None: ...

    def createdWidgets(self) -> typing.List[QWidget]: ...
    def deleteWidget(self, widget: QWidget) -> None: ...
    def createWidget(self, parent: QWidget) -> QWidget: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def releaseWidget(self, widget: QWidget) -> None: ...
    def requestWidget(self, parent: QWidget) -> QWidget: ...
    def defaultWidget(self) -> QWidget: ...
    def setDefaultWidget(self, w: QWidget) -> None: ...


class QWizard(QDialog):

    currentIdChanged: PYQT_SIGNAL
    customButtonClicked: PYQT_SIGNAL
    helpRequested: PYQT_SIGNAL
    pageAdded: PYQT_SIGNAL
    pageRemoved: PYQT_SIGNAL

    class WizardOption(int):
        IndependentPages = ... # type: QWizard.WizardOption
        IgnoreSubTitles = ... # type: QWizard.WizardOption
        ExtendedWatermarkPixmap = ... # type: QWizard.WizardOption
        NoDefaultButton = ... # type: QWizard.WizardOption
        NoBackButtonOnStartPage = ... # type: QWizard.WizardOption
        NoBackButtonOnLastPage = ... # type: QWizard.WizardOption
        DisabledBackButtonOnLastPage = ... # type: QWizard.WizardOption
        HaveNextButtonOnLastPage = ... # type: QWizard.WizardOption
        HaveFinishButtonOnEarlyPages = ... # type: QWizard.WizardOption
        NoCancelButton = ... # type: QWizard.WizardOption
        CancelButtonOnLeft = ... # type: QWizard.WizardOption
        HaveHelpButton = ... # type: QWizard.WizardOption
        HelpButtonOnRight = ... # type: QWizard.WizardOption
        HaveCustomButton1 = ... # type: QWizard.WizardOption
        HaveCustomButton2 = ... # type: QWizard.WizardOption
        HaveCustomButton3 = ... # type: QWizard.WizardOption
        NoCancelButtonOnLastPage = ... # type: QWizard.WizardOption

    class WizardStyle(int):
        ClassicStyle = ... # type: QWizard.WizardStyle
        ModernStyle = ... # type: QWizard.WizardStyle
        MacStyle = ... # type: QWizard.WizardStyle
        AeroStyle = ... # type: QWizard.WizardStyle

    class WizardPixmap(int):
        WatermarkPixmap = ... # type: QWizard.WizardPixmap
        LogoPixmap = ... # type: QWizard.WizardPixmap
        BannerPixmap = ... # type: QWizard.WizardPixmap
        BackgroundPixmap = ... # type: QWizard.WizardPixmap

    class WizardButton(int):
        BackButton = ... # type: QWizard.WizardButton
        NextButton = ... # type: QWizard.WizardButton
        CommitButton = ... # type: QWizard.WizardButton
        FinishButton = ... # type: QWizard.WizardButton
        CancelButton = ... # type: QWizard.WizardButton
        HelpButton = ... # type: QWizard.WizardButton
        CustomButton1 = ... # type: QWizard.WizardButton
        CustomButton2 = ... # type: QWizard.WizardButton
        CustomButton3 = ... # type: QWizard.WizardButton
        Stretch = ... # type: QWizard.WizardButton

    WizardOptions: typing.Type[int]
    #class WizardOptions(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QWizard.WizardOptions, QWizard.WizardOption]) -> None: ...
        #@overload
        #def __init__(self, a0: QWizard.WizardOptions) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QWizard.WizardOptions: ...
        #def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[int, int] = ..., **props) -> None: ...

    #def pageRemoved(self, id: int) -> None: ...
    #def pageAdded(self, id: int) -> None: ...
    def sideWidget(self) -> QWidget: ...
    def setSideWidget(self, widget: QWidget) -> None: ...
    def pageIds(self) -> typing.List[int]: ...
    def removePage(self, id: int) -> None: ...
    def cleanupPage(self, id: int) -> None: ...
    def initializePage(self, id: int) -> None: ...
    def done(self, result: int) -> None: ...
    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def restart(self) -> None: ...
    def next(self) -> None: ...
    def back(self) -> None: ...
    #def customButtonClicked(self, which: int) -> None: ...
    #def helpRequested(self) -> None: ...
    #def currentIdChanged(self, id: int) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setVisible(self, visible: bool) -> None: ...
    def setDefaultProperty(self, className: str, property: str, changedSignal: PYQT_SIGNAL) -> None: ...
    def pixmap(self, which: int) -> QtGui.QPixmap: ...
    def setPixmap(self, which: int, pixmap: QtGui.QPixmap) -> None: ...
    def subTitleFormat(self) -> int: ...
    def setSubTitleFormat(self, format: int) -> None: ...
    def titleFormat(self) -> int: ...
    def setTitleFormat(self, format: int) -> None: ...
    def button(self, which: int) -> QAbstractButton: ...
    def setButton(self, which: int, button: QAbstractButton) -> None: ...
    def setButtonLayout(self, layout: typing.Iterable[int]) -> None: ...
    def buttonText(self, which: int) -> str: ...
    def setButtonText(self, which: int, text: str) -> None: ...
    def options(self) -> int: ...
    def setOptions(self, options: typing.Union[int, int]) -> None: ...
    def testOption(self, option: int) -> bool: ...
    def setOption(self, option: int, on: bool = ...) -> None: ...
    def wizardStyle(self) -> int: ...
    def setWizardStyle(self, style: int) -> None: ...
    def field(self, name: str) -> typing.Any: ...
    def setField(self, name: str, value: typing.Any) -> None: ...
    def nextId(self) -> int: ...
    def validateCurrentPage(self) -> bool: ...
    def currentId(self) -> int: ...
    def currentPage(self) -> QWizardPage: ...
    def startId(self) -> int: ...
    def setStartId(self, id: int) -> None: ...
    def visitedPages(self) -> typing.List[int]: ...
    def hasVisitedPage(self, id: int) -> bool: ...
    def page(self, id: int) -> QWizardPage: ...
    def setPage(self, id: int, page: QWizardPage) -> None: ...
    def addPage(self, page: QWizardPage) -> int: ...


class QWizardPage(QWidget):

    completeChanged: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QWidget] = ..., **props) -> None: ...

    def wizard(self) -> QWizard: ...
    def registerField(self, name: str, widget: QWidget, property: typing.Optional[str] = ..., changedSignal: PYQT_SIGNAL = ...) -> None: ...
    def field(self, name: str) -> typing.Any: ...
    def setField(self, name: str, value: typing.Any) -> None: ...
    #def completeChanged(self) -> None: ...
    def nextId(self) -> int: ...
    def isComplete(self) -> bool: ...
    def validatePage(self) -> bool: ...
    def cleanupPage(self) -> None: ...
    def initializePage(self) -> None: ...
    def buttonText(self, which: int) -> str: ...
    def setButtonText(self, which: int, text: str) -> None: ...
    def isCommitPage(self) -> bool: ...
    def setCommitPage(self, commitPage: bool) -> None: ...
    def isFinalPage(self) -> bool: ...
    def setFinalPage(self, finalPage: bool) -> None: ...
    def pixmap(self, which: int) -> QtGui.QPixmap: ...
    def setPixmap(self, which: int, pixmap: QtGui.QPixmap) -> None: ...
    def subTitle(self) -> str: ...
    def setSubTitle(self, subTitle: str) -> None: ...
    def title(self) -> str: ...
    def setTitle(self, title: str) -> None: ...


QWIDGETSIZE_MAX = ... # type: int
qApp = ... # type: QApplication


def qDrawBorderPixmap(painter: QtGui.QPainter, target: QtCore.QRect, margins: QtCore.QMargins, pixmap: QtGui.QPixmap) -> None: ...
@overload
def qDrawPlainRect(p: QtGui.QPainter, x: int, y: int, w: int, h: int, a5: typing.Union[QtGui.QColor, int, QtGui.QGradient], lineWidth: int = ..., fill: typing.Optional[typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]] = ...) -> None: ...
@overload
def qDrawPlainRect(p: QtGui.QPainter, r: QtCore.QRect, a2: typing.Union[QtGui.QColor, int, QtGui.QGradient], lineWidth: int = ..., fill: typing.Optional[typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]] = ...) -> None: ...
@overload
def qDrawWinPanel(p: QtGui.QPainter, x: int, y: int, w: int, h: int, pal: QtGui.QPalette, sunken: bool = ..., fill: typing.Optional[typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]] = ...) -> None: ...
@overload
def qDrawWinPanel(p: QtGui.QPainter, r: QtCore.QRect, pal: QtGui.QPalette, sunken: bool = ..., fill: typing.Optional[typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]] = ...) -> None: ...
@overload
def qDrawWinButton(p: QtGui.QPainter, x: int, y: int, w: int, h: int, pal: QtGui.QPalette, sunken: bool = ..., fill: typing.Optional[typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]] = ...) -> None: ...
@overload
def qDrawWinButton(p: QtGui.QPainter, r: QtCore.QRect, pal: QtGui.QPalette, sunken: bool = ..., fill: typing.Optional[typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]] = ...) -> None: ...
@overload
def qDrawShadePanel(p: QtGui.QPainter, x: int, y: int, w: int, h: int, pal: QtGui.QPalette, sunken: bool = ..., lineWidth: int = ..., fill: typing.Optional[typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]] = ...) -> None: ...
@overload
def qDrawShadePanel(p: QtGui.QPainter, r: QtCore.QRect, pal: QtGui.QPalette, sunken: bool = ..., lineWidth: int = ..., fill: typing.Optional[typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]] = ...) -> None: ...
@overload
def qDrawShadeRect(p: QtGui.QPainter, x: int, y: int, w: int, h: int, pal: QtGui.QPalette, sunken: bool = ..., lineWidth: int = ..., midLineWidth: int = ..., fill: typing.Optional[typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]] = ...) -> None: ...
@overload
def qDrawShadeRect(p: QtGui.QPainter, r: QtCore.QRect, pal: QtGui.QPalette, sunken: bool = ..., lineWidth: int = ..., midLineWidth: int = ..., fill: typing.Optional[typing.Union[QtGui.QBrush, QtGui.QColor, int, QtGui.QGradient]] = ...) -> None: ...
@overload
def qDrawShadeLine(p: QtGui.QPainter, x1: int, y1: int, x2: int, y2: int, pal: QtGui.QPalette, sunken: bool = ..., lineWidth: int = ..., midLineWidth: int = ...) -> None: ...
@overload
def qDrawShadeLine(p: QtGui.QPainter, p1: QtCore.QPoint, p2: QtCore.QPoint, pal: QtGui.QPalette, sunken: bool = ..., lineWidth: int = ..., midLineWidth: int = ...) -> None: ...
