 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_MODIFIER_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_MODIFIER_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// FunctorComplement

template <typename TValue> struct FunctorComplement;       	// "projects/library/seqan/modifier/modifier_functors.h"(110)

//____________________________________________________________________________
// FunctorConvert

template <typename InType, typename OutType> struct FunctorConvert;       	// "projects/library/seqan/modifier/modifier_functors.h"(88)

//____________________________________________________________________________
// FunctorLowcase

template <typename InType, typename Result > struct FunctorLowcase;       	// "projects/library/seqan/modifier/modifier_functors.h"(64)

//____________________________________________________________________________
// FunctorUpcase

template <typename InType, typename Result > struct FunctorUpcase;       	// "projects/library/seqan/modifier/modifier_functors.h"(46)

//____________________________________________________________________________
// ModReverse

struct ModReverse;       	// "projects/library/seqan/modifier/modifier_reverse.h"(42)

//____________________________________________________________________________
// ModView

template <typename TFunctor> struct ModView;       	// "projects/library/seqan/modifier/modifier_view.h"(46)

//____________________________________________________________________________
// ModViewCargo

template <typename TFunctor> struct ModViewCargo;       	// "projects/library/seqan/modifier/modifier_view.h"(49)

//____________________________________________________________________________
// ModifiedIterator

template <typename THost, typename TSpec > class ModifiedIterator;       	// "projects/library/seqan/modifier/modifier_iterator.h"(44)

//____________________________________________________________________________
// ModifiedString

template <typename THost, typename TSpec > class ModifiedString;       	// "projects/library/seqan/modifier/modifier_string.h"(44)

//____________________________________________________________________________
// _Translate_Table_Dna5_2_Dna5Complement

template <typename T > struct _Translate_Table_Dna5_2_Dna5Complement;       	// "projects/library/seqan/modifier/modifier_functors.h"(116)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Dna5StringComplement

typedef ModifiedString<Dna5String, ModView< FunctorComplement<Dna5> > > Dna5StringComplement;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(35)

//____________________________________________________________________________
// Dna5StringReverse

typedef ModifiedString<Dna5String, ModReverse> Dna5StringReverse;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(40)

//____________________________________________________________________________
// Dna5StringReverseComplement

typedef ModifiedString< ModifiedString< Dna5String, ModView< FunctorComplement<Dna5> > >, ModReverse > Dna5StringReverseComplement;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(56)

//____________________________________________________________________________
// DnaStringComplement

typedef ModifiedString<DnaString, ModView< FunctorComplement<Dna> > > DnaStringComplement;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(34)

//____________________________________________________________________________
// DnaStringReverse

typedef ModifiedString<DnaString, ModReverse> DnaStringReverse;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(39)

//____________________________________________________________________________
// DnaStringReverseComplement

typedef ModifiedString< ModifiedString<DnaString, ModView< FunctorComplement<Dna> > >, ModReverse > DnaStringReverseComplement;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(51)

//____________________________________________________________________________
// ModComplementDna

typedef ModView< FunctorComplement<Dna> > ModComplementDna;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(29)

//____________________________________________________________________________
// ModComplementDna5

typedef ModView< FunctorComplement<Dna5> > ModComplementDna5;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(30)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _copyCargo

template <typename TDest, typename TSource> inline void _copyCargo(TDest & me, TSource & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(231)

//____________________________________________________________________________
// _copyCargoImpl

template <typename TDest, typename TSource> inline void _copyCargoImpl(TDest &, TSource &, False const);       	// "projects/library/seqan/modifier/modifier_string.h"(223)
template <typename TDest, typename TSource> inline void _copyCargoImpl(TDest & me, TSource & _origin, True const);       	// "projects/library/seqan/modifier/modifier_string.h"(226)

//____________________________________________________________________________
// _dataHost

template <typename THost, typename TSpec> inline Holder<THost> & _dataHost(ModifiedString<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_string.h"(189)
template <typename THost, typename TSpec> inline Holder<THost> const & _dataHost(ModifiedString<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_string.h"(197)
template <typename THost, typename TSpec> inline Holder<THost, Simple> & _dataHost(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(168)
template <typename THost, typename TSpec> inline Holder<THost, Simple> const & _dataHost(ModifiedIterator<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(176)

//____________________________________________________________________________
// assign

template <typename THost, typename TSpec, typename THost2> inline ModifiedString<THost, TSpec> const & assign(ModifiedString<THost, TSpec> & me, ModifiedString<THost2, TSpec> & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(240)
template <typename THost, typename TSpec, typename THost2> inline ModifiedString<THost, TSpec> const & assign(ModifiedString<THost, TSpec> & me, ModifiedString<THost2, TSpec> const & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(248)
template <typename THost, typename TSpec, typename T> inline ModifiedString<THost, TSpec> const & assign(ModifiedString<THost, TSpec> & me, T & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(256)
template <typename THost, typename TSpec, typename T> inline ModifiedString<THost, TSpec> const & assign(ModifiedString<THost, TSpec> & me, T const & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(263)
template <typename THost, typename TSpec, typename THost2> inline ModifiedIterator<THost, TSpec> const & assign(ModifiedIterator<THost, TSpec> & me, ModifiedIterator<THost2, TSpec> & _origin);       	// "projects/library/seqan/modifier/modifier_iterator.h"(203)
template <typename THost, typename TSpec, typename THost2> inline ModifiedIterator<THost, TSpec> const & assign(ModifiedIterator<THost, TSpec> & me, ModifiedIterator<THost2, TSpec> const & _origin);       	// "projects/library/seqan/modifier/modifier_iterator.h"(211)
template <typename THost, typename TSpec, typename T> inline ModifiedIterator<THost, TSpec> const & assign(ModifiedIterator<THost, TSpec> & me, T & _origin);       	// "projects/library/seqan/modifier/modifier_iterator.h"(219)
template <typename THost, typename TSpec, typename T> inline ModifiedIterator<THost, TSpec> const & assign(ModifiedIterator<THost, TSpec> & me, T const & _origin);       	// "projects/library/seqan/modifier/modifier_iterator.h"(226)

//____________________________________________________________________________
// assignModViewFunctor

template <typename THost, typename TFunctor> inline void assignModViewFunctor(ModifiedIterator<THost, ModView<TFunctor> > & me, TFunctor const & _func);       	// "projects/library/seqan/modifier/modifier_view.h"(163)
template <typename THost, typename TFunctor> inline void assignModViewFunctor(ModifiedString<THost, ModView<TFunctor> > & me, TFunctor const & _func);       	// "projects/library/seqan/modifier/modifier_view.h"(282)

//____________________________________________________________________________
// atBegin

template <typename THost, typename TContainer> inline bool atBegin(ModifiedIterator<THost, ModReverse> const & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_reverse.h"(252)
template <typename THost> inline bool atBegin(ModifiedIterator<THost, ModReverse> const & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(260)
template <typename THost, typename TSpec, typename TContainer> inline bool atBegin(ModifiedIterator<THost, TSpec> & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_iterator.h"(487)
template <typename THost, typename TSpec, typename TContainer> inline bool atBegin(ModifiedIterator<THost, TSpec> const & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_iterator.h"(497)
template <typename THost, typename TSpec> inline bool atBegin(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(505)
template <typename THost, typename TSpec> inline bool atBegin(ModifiedIterator<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(514)

//____________________________________________________________________________
// atEnd

template <typename THost, typename TContainer> inline bool atEnd(ModifiedIterator<THost, ModReverse> const & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_reverse.h"(273)
template <typename THost> inline bool atEnd(ModifiedIterator<THost, ModReverse> const & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(281)
template <typename THost, typename TSpec, typename TContainer> inline bool atEnd(ModifiedIterator<THost, TSpec> & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_iterator.h"(527)
template <typename THost, typename TSpec, typename TContainer> inline bool atEnd(ModifiedIterator<THost, TSpec> const & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_iterator.h"(537)
template <typename THost, typename TSpec> inline bool atEnd(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(545)
template <typename THost, typename TSpec> inline bool atEnd(ModifiedIterator<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(554)

//____________________________________________________________________________
// begin

template <typename THost, typename TTag > inline typename Iterator< ModifiedString<THost, ModReverse> const >::Type begin(ModifiedString<THost, ModReverse> const & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(399)
template <typename THost > inline typename Iterator< ModifiedString<THost, ModReverse> >::Type begin(ModifiedString<THost, ModReverse> & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(408)
template <typename THost, typename TTagSpec > inline typename Iterator< ModifiedString<THost, ModReverse> const, Tag<TTagSpec> const >::Type begin(ModifiedString<THost, ModReverse> const & me, Tag<TTagSpec> const);       	// "projects/library/seqan/modifier/modifier_reverse.h"(417)
template <typename THost, typename TTagSpec > inline typename Iterator< ModifiedString<THost, ModReverse>, Tag<TTagSpec> const >::Type begin(ModifiedString<THost, ModReverse> & me, Tag<TTagSpec> const);       	// "projects/library/seqan/modifier/modifier_reverse.h"(426)
template <typename THost, typename TSpec > inline typename Iterator< ModifiedString<THost, TSpec> const >::Type begin(ModifiedString<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_string.h"(374)
template <typename THost, typename TSpec > inline typename Iterator< ModifiedString<THost, TSpec> >::Type begin(ModifiedString<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_string.h"(382)
template <typename THost, typename TSpec, typename TTagSpec > inline typename Iterator< ModifiedString<THost, TSpec> const, Tag<TTagSpec> const >::Type begin(ModifiedString<THost, TSpec> const & me, Tag<TTagSpec> const tag_);       	// "projects/library/seqan/modifier/modifier_string.h"(390)
template <typename THost, typename TSpec, typename TTagSpec > inline typename Iterator< ModifiedString<THost, TSpec>, Tag<TTagSpec> const >::Type begin(ModifiedString<THost, TSpec> & me, Tag<TTagSpec> const tag_);       	// "projects/library/seqan/modifier/modifier_string.h"(401)

//____________________________________________________________________________
// cargo

template <typename THost, typename TSpec> inline typename Reference< typename Cargo<ModifiedString<THost, TSpec> >::Type >::Type cargo(ModifiedString<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_string.h"(205)
template <typename THost, typename TSpec> inline typename Reference< typename Cargo<ModifiedString<THost, TSpec> const>::Type >::Type cargo(ModifiedString<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_string.h"(213)
template <typename THost, typename TSpec> inline typename Reference< typename Cargo<ModifiedIterator<THost, TSpec> >::Type >::Type cargo(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(184)
template <typename THost, typename TSpec> inline typename Reference< typename Cargo<ModifiedIterator<THost, TSpec> const>::Type >::Type cargo(ModifiedIterator<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(192)

//____________________________________________________________________________
// complementInPlace

template <typename TSequence > inline void complementInPlace(TSequence & sequence);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(63)
template <typename TSequence, typename TSpec > inline void complementInPlace(StringSet<TSequence, TSpec> & stringSet);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(69)

//____________________________________________________________________________
// convertInPlace

template <typename TSequence, typename TFunctor > inline void convertInPlace(TSequence & sequence, TFunctor const &F);       	// "projects/library/seqan/modifier/modifier_view.h"(298)

//____________________________________________________________________________
// end

template <typename THost > inline typename Iterator< ModifiedString<THost, ModReverse> const >::Type end(ModifiedString<THost, ModReverse> const & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(439)
template <typename THost > inline typename Iterator< ModifiedString<THost, ModReverse> >::Type end(ModifiedString<THost, ModReverse> & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(448)
template <typename THost, typename TTagSpec > inline typename Iterator< ModifiedString<THost, ModReverse> const, Tag<TTagSpec> const >::Type end(ModifiedString<THost, ModReverse> const & me, Tag<TTagSpec> const);       	// "projects/library/seqan/modifier/modifier_reverse.h"(457)
template <typename THost, typename TTagSpec > inline typename Iterator< ModifiedString<THost, ModReverse>, Tag<TTagSpec> const >::Type end(ModifiedString<THost, ModReverse> & me, Tag<TTagSpec> const);       	// "projects/library/seqan/modifier/modifier_reverse.h"(466)
template <typename THost, typename TSpec > inline typename Iterator< ModifiedString<THost, TSpec> const >::Type end(ModifiedString<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_string.h"(416)
template <typename THost, typename TSpec > inline typename Iterator< ModifiedString<THost, TSpec> >::Type end(ModifiedString<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_string.h"(424)
template <typename THost, typename TSpec, typename TTagSpec > inline typename Iterator< ModifiedString<THost, TSpec> const, Tag<TTagSpec> const >::Type end(ModifiedString<THost, TSpec> const & me, Tag<TTagSpec> const tag_);       	// "projects/library/seqan/modifier/modifier_string.h"(432)
template <typename THost, typename TSpec, typename TTagSpec > inline typename Iterator< ModifiedString<THost, TSpec>, Tag<TTagSpec> const >::Type end(ModifiedString<THost, TSpec> & me, Tag<TTagSpec> const tag_);       	// "projects/library/seqan/modifier/modifier_string.h"(440)

//____________________________________________________________________________
// goBegin

template <typename THost, typename TSpec, typename TContainer> inline void goBegin(ModifiedIterator<THost, TSpec> & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_iterator.h"(389)
template <typename THost, typename TSpec> inline void goBegin(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(397)

//____________________________________________________________________________
// goEnd

template <typename THost, typename TSpec, typename TContainer> inline void goEnd(ModifiedIterator<THost, TSpec> & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_iterator.h"(410)
template <typename THost, typename TSpec> inline void goEnd(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(418)

//____________________________________________________________________________
// goNext

template <typename THost> inline void goNext(ModifiedIterator<THost, ModReverse> & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(106)
template <typename THost, typename TSpec> inline void goNext(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(278)

//____________________________________________________________________________
// goPrevious

template <typename THost> inline void goPrevious(ModifiedIterator<THost, ModReverse> & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(121)
template <typename THost, typename TSpec> inline void goPrevious(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(310)

//____________________________________________________________________________
// id

template <typename THost, typename TSpec> inline void const * id(ModifiedString<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_string.h"(475)
template <typename THost, typename TSpec> inline void const * id(ModifiedString<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_string.h"(482)

//____________________________________________________________________________
// length

template <typename THost, typename TSpec > inline typename Size< ModifiedString<THost, TSpec> >::Type length(ModifiedString<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_string.h"(364)

//____________________________________________________________________________
// operator!=

template <typename THost, typename TSpec> inline bool operator!= (ModifiedIterator<THost, TSpec> const & a, ModifiedIterator<THost, TSpec> const & b);       	// "projects/library/seqan/modifier/modifier_iterator.h"(458)

//____________________________________________________________________________
// operator*

template <typename THost, typename TSpec> inline typename Reference<ModifiedIterator<THost, TSpec> >::Type operator* (ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(256)
template <typename THost, typename TSpec> inline typename Reference<ModifiedIterator<THost, TSpec> const>::Type operator* (ModifiedIterator<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(264)

//____________________________________________________________________________
// operator+

template <typename THost, typename TSpec, typename TDelta> inline ModifiedIterator<THost, TSpec> operator+ (ModifiedIterator<THost, TSpec> const & me, TDelta delta);       	// "projects/library/seqan/modifier/modifier_iterator.h"(348)

//____________________________________________________________________________
// operator++

template <typename THost, typename TSpec> inline ModifiedIterator<THost, TSpec> const & operator++ (ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(286)
template <typename THost, typename TSpec> inline ModifiedIterator<THost, TSpec> const & operator++ (ModifiedIterator<THost, TSpec> & me, int);       	// "projects/library/seqan/modifier/modifier_iterator.h"(295)

//____________________________________________________________________________
// operator+=

template <typename THost, typename TDelta> inline ModifiedIterator<THost, ModReverse> & operator+= (ModifiedIterator<THost, ModReverse> & me, TDelta delta_);       	// "projects/library/seqan/modifier/modifier_reverse.h"(136)
template <typename THost, typename TSpec, typename TDelta> inline ModifiedIterator<THost, TSpec> & operator+= (ModifiedIterator<THost, TSpec> & me, TDelta delta);       	// "projects/library/seqan/modifier/modifier_iterator.h"(341)

//____________________________________________________________________________
// operator-

template <typename THost> inline typename Difference< ModifiedIterator<THost, ModReverse> >::Type operator- (ModifiedIterator<THost, ModReverse> const & a, ModifiedIterator<THost, ModReverse> const & b);       	// "projects/library/seqan/modifier/modifier_reverse.h"(189)
template <typename THost, typename TSpec, typename TDelta> inline ModifiedIterator<THost, TSpec> operator- (ModifiedIterator<THost, TSpec> const & me, TDelta delta);       	// "projects/library/seqan/modifier/modifier_iterator.h"(368)
template <typename THost, typename TSpec> inline typename Difference< ModifiedIterator<THost, TSpec> >::Type operator- (ModifiedIterator<THost, TSpec> const & a, ModifiedIterator<THost, TSpec> const & b);       	// "projects/library/seqan/modifier/modifier_iterator.h"(377)

//____________________________________________________________________________
// operator--

template <typename THost, typename TSpec> inline ModifiedIterator<THost, TSpec> const & operator-- (ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(318)
template <typename THost, typename TSpec> inline ModifiedIterator<THost, TSpec> const & operator-- (ModifiedIterator<THost, TSpec> & me, int);       	// "projects/library/seqan/modifier/modifier_iterator.h"(327)

//____________________________________________________________________________
// operator-=

template <typename THost, typename TDelta> inline ModifiedIterator<THost, ModReverse> & operator-= (ModifiedIterator<THost, ModReverse> & me, TDelta delta);       	// "projects/library/seqan/modifier/modifier_reverse.h"(170)
template <typename THost, typename TSpec, typename TDelta> inline ModifiedIterator<THost, TSpec> & operator-= (ModifiedIterator<THost, TSpec> & me, TDelta delta);       	// "projects/library/seqan/modifier/modifier_iterator.h"(361)

//____________________________________________________________________________
// operator<

template <typename THost> inline bool operator< (ModifiedIterator<THost, ModReverse> const & a, ModifiedIterator<THost, ModReverse> const & b);       	// "projects/library/seqan/modifier/modifier_reverse.h"(239)
template <typename THost, typename TSpec> inline bool operator< (ModifiedIterator<THost, TSpec> const & a, ModifiedIterator<THost, TSpec> const & b);       	// "projects/library/seqan/modifier/modifier_iterator.h"(469)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename THost, typename TSpec > inline TStream & operator<< (TStream & target, ModifiedString<THost, TSpec> const & source);       	// "projects/library/seqan/modifier/modifier_string.h"(453)

//____________________________________________________________________________
// operator==

template <typename THost> inline bool operator== (ModifiedIterator<THost, ModReverse> const & a, ModifiedIterator<THost, ModReverse> const & b);       	// "projects/library/seqan/modifier/modifier_reverse.h"(228)
template <typename THost, typename TSpec> inline bool operator== (ModifiedIterator<THost, TSpec> const & a, ModifiedIterator<THost, TSpec> const & b);       	// "projects/library/seqan/modifier/modifier_iterator.h"(452)

//____________________________________________________________________________
// operator>

template <typename THost, typename TSpec> inline bool operator> (ModifiedIterator<THost, TSpec> const & a, ModifiedIterator<THost, TSpec> const & b);       	// "projects/library/seqan/modifier/modifier_iterator.h"(475)

//____________________________________________________________________________
// operator>>

template <typename TStream, typename THost, typename TSpec > inline TStream & operator>> (TStream & source, ModifiedString<THost, TSpec> & target);       	// "projects/library/seqan/modifier/modifier_string.h"(464)

//____________________________________________________________________________
// position

template <typename THost> inline typename Position<ModifiedIterator<THost, ModReverse> const>::Type position(ModifiedIterator<THost, ModReverse> const & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(203)
template <typename THost, typename TContainer> inline typename Position<ModifiedIterator<THost, ModReverse> const>::Type position(ModifiedIterator<THost, ModReverse> const & me, TContainer const &cont);       	// "projects/library/seqan/modifier/modifier_reverse.h"(214)
template <typename THost, typename TSpec> inline typename Position<ModifiedIterator<THost, TSpec> const>::Type position(ModifiedIterator<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(431)
template <typename THost, typename TSpec, typename TContainer> inline typename Position<ModifiedIterator<THost, TSpec> const>::Type position(ModifiedIterator<THost, TSpec> const & me, TContainer const &cont);       	// "projects/library/seqan/modifier/modifier_iterator.h"(440)

//____________________________________________________________________________
// reverseComplementInPlace

template <typename TSequence > inline void reverseComplementInPlace(TSequence & sequence);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(77)
template <typename TSequence, typename TSpec > inline void reverseComplementInPlace(StringSet<TSequence, TSpec> & stringSet);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(84)

//____________________________________________________________________________
// reverseInPlace

template <typename TSequence > inline void reverseInPlace(TSequence & sequence);       	// "projects/library/seqan/modifier/modifier_reverse.h"(484)
template <typename TSequence, typename TSpec > inline void reverseInPlace(StringSet<TSequence, TSpec> & stringSet);       	// "projects/library/seqan/modifier/modifier_reverse.h"(502)

//____________________________________________________________________________
// setValue

template <typename THost, typename TSpec> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, ModifiedString<THost, TSpec> const & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(293)
template <typename THost, typename TSpec> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, ModifiedString<THost, TSpec> & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(301)
template <typename THost, typename THostSpec, typename TSpec, typename THost2> inline ModifiedString< ModifiedString<THost, THostSpec>, TSpec> const & setValue( ModifiedString< ModifiedString<THost, THostSpec>, TSpec> & me, THost2 const & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(313)
template <typename THost, typename THostSpec, typename TSpec, typename THost2> inline ModifiedString< ModifiedString<THost, THostSpec>, TSpec> const & setValue( ModifiedString< ModifiedString<THost, THostSpec>, TSpec> & me, THost2 & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(323)
template <typename THost, typename TSpec> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, THost const & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(331)
template <typename THost, typename TSpec> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, THost & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(338)
template <typename THost, typename TSpec, typename THost2> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, THost2 & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(346)
template <typename THost, typename TSpec, typename THost2> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, THost2 const & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(353)

//____________________________________________________________________________
// value

template <typename THost, typename TPos> inline typename Reference<ModifiedString<THost, ModReverse> >::Type value(ModifiedString<THost, ModReverse> & me, TPos pos);       	// "projects/library/seqan/modifier/modifier_reverse.h"(380)
template <typename THost, typename TPos> inline typename Reference<ModifiedString<THost, ModReverse> const>::Type value(ModifiedString<THost, ModReverse> const & me, TPos pos);       	// "projects/library/seqan/modifier/modifier_reverse.h"(388)
template <typename THost, typename TSpec, typename TPos> inline typename Reference<ModifiedString<THost, TSpec> >::Type value(ModifiedString<THost, TSpec> & me, TPos pos);       	// "projects/library/seqan/modifier/modifier_string.h"(275)
template <typename THost, typename TSpec, typename TPos> inline typename Reference<ModifiedString<THost, TSpec> const >::Type value(ModifiedString<THost, TSpec> const & me, TPos pos);       	// "projects/library/seqan/modifier/modifier_string.h"(282)
template <typename THost, typename TSpec> inline typename Reference<ModifiedIterator<THost, TSpec> >::Type value(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(239)
template <typename THost, typename TSpec> inline typename Reference<ModifiedIterator<THost, TSpec> const>::Type value(ModifiedIterator<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(248)
template <typename THost, typename TFunctor> inline typename Reference<ModifiedIterator<THost, ModView<TFunctor> > >::Type value(ModifiedIterator<THost, ModView<TFunctor> > & me);       	// "projects/library/seqan/modifier/modifier_view.h"(141)
template <typename THost, typename TFunctor> inline typename Reference<ModifiedIterator<THost, ModView<TFunctor> > const>::Type value(ModifiedIterator<THost, ModView<TFunctor> > const & me);       	// "projects/library/seqan/modifier/modifier_view.h"(150)
template <typename THost, typename TFunctor, typename TPos> inline typename Reference<ModifiedString<THost, ModView<TFunctor> > >::Type value(ModifiedString<THost, ModView<TFunctor> > & me, TPos pos);       	// "projects/library/seqan/modifier/modifier_view.h"(260)
template <typename THost, typename TFunctor, typename TPos> inline typename Reference<ModifiedString<THost, ModView<TFunctor> > const>::Type value(ModifiedString<THost, ModView<TFunctor> > const & me, TPos pos);       	// "projects/library/seqan/modifier/modifier_view.h"(269)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

