/*
 * Decompiled with CFR 0.152.
 */
package tom.gom.adt.objects.types;

import aterm.ATerm;
import java.io.IOException;
import java.io.InputStream;
import tom.gom.adt.code.types.Code;
import tom.gom.adt.objects.ObjectsAbstractType;
import tom.gom.adt.objects.ObjectsVisitor;
import tom.gom.adt.objects.types.SlotFieldList;
import tom.gom.adt.objects.types.hook.BlockHook;
import tom.gom.adt.objects.types.hook.ImportHook;
import tom.gom.adt.objects.types.hook.InterfaceHook;
import tom.gom.adt.objects.types.hook.MakeBeforeHook;
import tom.gom.adt.objects.types.hook.MakeHook;
import tom.gom.adt.objects.types.hook.MappingHook;
import tom.library.sl.VisitFailure;

public abstract class Hook
extends ObjectsAbstractType {
    public ObjectsAbstractType accept(ObjectsVisitor v) throws VisitFailure {
        return v.visit_Hook(this);
    }

    public boolean isMakeHook() {
        return false;
    }

    public boolean isMakeBeforeHook() {
        return false;
    }

    public boolean isBlockHook() {
        return false;
    }

    public boolean isInterfaceHook() {
        return false;
    }

    public boolean isImportHook() {
        return false;
    }

    public boolean isMappingHook() {
        return false;
    }

    public Code getCode() {
        throw new UnsupportedOperationException("This Hook has no Code");
    }

    public Hook setCode(Code _arg) {
        throw new UnsupportedOperationException("This Hook has no Code");
    }

    public SlotFieldList getHookArguments() {
        throw new UnsupportedOperationException("This Hook has no HookArguments");
    }

    public Hook setHookArguments(SlotFieldList _arg) {
        throw new UnsupportedOperationException("This Hook has no HookArguments");
    }

    public static Hook fromTerm(ATerm trm) {
        Hook tmp = MakeHook.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = MakeBeforeHook.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = BlockHook.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = InterfaceHook.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = ImportHook.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = MappingHook.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        throw new IllegalArgumentException("This is not a Hook " + trm);
    }

    public static Hook fromString(String s) {
        return Hook.fromTerm(atermFactory.parse(s));
    }

    public static Hook fromStream(InputStream stream) throws IOException {
        return Hook.fromTerm(atermFactory.readFromFile(stream));
    }

    public int length() {
        throw new IllegalArgumentException("This " + this.getClass().getName() + " is not a list");
    }

    public Hook reverse() {
        throw new IllegalArgumentException("This " + this.getClass().getName() + " is not a list");
    }
}

