/*
 * Decompiled with CFR 0.152.
 */
package tom.gom.adt.code.types.code;

import aterm.ATerm;
import aterm.ATermAppl;
import tom.gom.adt.code.types.Code;
import tom.gom.adt.code.types.code.ConsCodeList;
import tom.gom.adt.code.types.code.EmptyCodeList;

public abstract class CodeList
extends Code {
    public int length() {
        if (this instanceof ConsCodeList) {
            Code tl = ((ConsCodeList)this).getTailCodeList();
            if (tl instanceof CodeList) {
                return 1 + ((CodeList)tl).length();
            }
            return 2;
        }
        return 0;
    }

    public Code[] toArray() {
        Code[] array;
        if (this instanceof ConsCodeList) {
            Code h = ((ConsCodeList)this).getHeadCodeList();
            Code tl = ((ConsCodeList)this).getTailCodeList();
            if (tl instanceof CodeList) {
                Code[] tailArray = ((CodeList)tl).toArray();
                array = new Code[1 + tailArray.length];
                array[0] = h;
                for (int i = 0; i < tailArray.length; ++i) {
                    array[i + 1] = tailArray[i];
                }
            } else {
                array = new Code[]{h};
            }
        } else {
            array = new Code[]{};
        }
        return array;
    }

    public static Code fromArray(Code[] array) {
        Code res = EmptyCodeList.make();
        int i = array.length;
        while (i > 0) {
            res = ConsCodeList.make(array[--i], res);
        }
        return res;
    }

    public Code reverse() {
        if (this instanceof ConsCodeList) {
            Code cur = this;
            Code rev = EmptyCodeList.make();
            while (cur instanceof ConsCodeList) {
                rev = ConsCodeList.make(((ConsCodeList)cur).getHeadCodeList(), rev);
                cur = ((ConsCodeList)cur).getTailCodeList();
            }
            return rev;
        }
        return this;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("CodeList(");
        if (this instanceof ConsCodeList) {
            Code cur = this;
            while (cur instanceof ConsCodeList) {
                Code elem = ((ConsCodeList)cur).getHeadCodeList();
                cur = ((ConsCodeList)cur).getTailCodeList();
                elem.toStringBuffer(buffer);
                if (!(cur instanceof ConsCodeList)) continue;
                buffer.append(",");
            }
            if (!(cur instanceof EmptyCodeList)) {
                buffer.append(",");
                cur.toStringBuffer(buffer);
            }
        }
        buffer.append(")");
    }

    public static Code fromTerm(ATerm trm) {
        ATermAppl appl;
        if (trm instanceof ATermAppl && "CodeList".equals((appl = (ATermAppl)trm).getName())) {
            Code res = EmptyCodeList.make();
            ATerm[] array = appl.getArgumentArray();
            for (int i = array.length - 1; i >= 0; --i) {
                Code elem = Code.fromTerm(array[i]);
                res = ConsCodeList.make(elem, res);
            }
            return res;
        }
        return null;
    }
}

