/*
 * Decompiled with CFR 0.152.
 */
package tom.engine.adt.tominstruction.types.instruction;

import aterm.ATerm;
import aterm.ATermAppl;
import shared.HashFunctions;
import shared.SharedObject;
import tom.engine.adt.tominstruction.TomInstructionAbstractType;
import tom.engine.adt.tominstruction.types.Instruction;
import tom.engine.adt.tominstruction.types.InstructionList;
import tom.library.sl.Visitable;

public final class NamedBlock
extends Instruction
implements Visitable {
    private int hashCode;
    private static NamedBlock proto = new NamedBlock();
    private String _BlockName;
    private InstructionList _InstList;

    private NamedBlock() {
    }

    public static NamedBlock make(String _BlockName, InstructionList _InstList) {
        proto.initHashCode(_BlockName, _InstList);
        return (NamedBlock)factory.build((SharedObject)proto);
    }

    private void init(String _BlockName, InstructionList _InstList, int hashCode) {
        this._BlockName = _BlockName.intern();
        this._InstList = _InstList;
        this.hashCode = hashCode;
    }

    private void initHashCode(String _BlockName, InstructionList _InstList) {
        this._BlockName = _BlockName.intern();
        this._InstList = _InstList;
        this.hashCode = this.hashFunction();
    }

    public String symbolName() {
        return "NamedBlock";
    }

    private int getArity() {
        return 2;
    }

    public SharedObject duplicate() {
        NamedBlock clone = new NamedBlock();
        clone.init(this._BlockName, this._InstList, this.hashCode);
        return clone;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("NamedBlock(");
        buffer.append('\"');
        block11: for (int i = 0; i < this._BlockName.length(); ++i) {
            char c = this._BlockName.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block11;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block11;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block11;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block11;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block11;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block11;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block11;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block11;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block11;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block11;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        this._InstList.toStringBuffer(buffer);
        buffer.append(")");
    }

    public int compareToLPO(Object o) {
        TomInstructionAbstractType ao = (TomInstructionAbstractType)o;
        if (ao == this) {
            return 0;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        NamedBlock tco = (NamedBlock)ao;
        int _BlockNameCmp = this._BlockName.compareTo(tco._BlockName);
        if (_BlockNameCmp != 0) {
            return _BlockNameCmp;
        }
        int _InstListCmp = this._InstList.compareToLPO(tco._InstList);
        if (_InstListCmp != 0) {
            return _InstListCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public int compareTo(Object o) {
        TomInstructionAbstractType ao = (TomInstructionAbstractType)o;
        if (ao == this) {
            return 0;
        }
        if (this.hashCode != ao.hashCode()) {
            return this.hashCode < ao.hashCode() ? -1 : 1;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        NamedBlock tco = (NamedBlock)ao;
        int _BlockNameCmp = this._BlockName.compareTo(tco._BlockName);
        if (_BlockNameCmp != 0) {
            return _BlockNameCmp;
        }
        int _InstListCmp = this._InstList.compareTo(tco._InstList);
        if (_InstListCmp != 0) {
            return _InstListCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equivalent(SharedObject obj) {
        if (obj instanceof NamedBlock) {
            NamedBlock peer = (NamedBlock)obj;
            return this._BlockName == peer._BlockName && this._InstList == peer._InstList;
        }
        return false;
    }

    public boolean isNamedBlock() {
        return true;
    }

    public String getBlockName() {
        return this._BlockName;
    }

    public Instruction setBlockName(String set_arg) {
        return NamedBlock.make(set_arg, this._InstList);
    }

    public InstructionList getInstList() {
        return this._InstList;
    }

    public Instruction setInstList(InstructionList set_arg) {
        return NamedBlock.make(this._BlockName, set_arg);
    }

    public ATerm toATerm() {
        return atermFactory.makeAppl(atermFactory.makeAFun(this.symbolName(), this.getArity(), false), new ATerm[]{atermFactory.makeAppl(atermFactory.makeAFun(this.getBlockName(), 0, true)), this.getInstList().toATerm()});
    }

    public static Instruction fromTerm(ATerm trm) {
        if (trm instanceof ATermAppl) {
            ATermAppl appl = (ATermAppl)trm;
            if (proto.symbolName().equals(appl.getName())) {
                return NamedBlock.make(((ATermAppl)appl.getArgument(0)).getAFun().getName(), InstructionList.fromTerm(appl.getArgument(1)));
            }
        }
        return null;
    }

    public int getChildCount() {
        return 1;
    }

    public Visitable getChildAt(int index) {
        switch (index) {
            case 0: {
                return this._InstList;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildAt(int index, Visitable v) {
        switch (index) {
            case 0: {
                return NamedBlock.make(this.getBlockName(), (InstructionList)v);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildren(Visitable[] childs) {
        if (childs.length == 1) {
            return NamedBlock.make(this.getBlockName(), (InstructionList)childs[0]);
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable[] getChildren() {
        return new Visitable[]{this._InstList};
    }

    protected int hashFunction() {
        int a = -1640531527;
        int b = 1140728832;
        int c = this.getArity();
        a += HashFunctions.stringHashFunction((String)this._BlockName, (int)1) << 8;
        a += this._InstList.hashCode();
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

