/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.BooleanAttribute;
import com.sun.xacml.attr.IntegerAttribute;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class NOfFunction
extends FunctionBase {
    public static final String NAME_N_OF = "urn:oasis:names:tc:xacml:1.0:function:n-of";

    public NOfFunction(String string) {
        super(NAME_N_OF, 0, "http://www.w3.org/2001/XMLSchema#boolean", false);
        if (!string.equals(NAME_N_OF)) {
            throw new IllegalArgumentException("unknown nOf function: " + string);
        }
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(NAME_N_OF);
        return hashSet;
    }

    public EvaluationResult evaluate(List list, EvaluationCtx evaluationCtx) {
        Iterator iterator = list.iterator();
        Evaluatable evaluatable = (Evaluatable)iterator.next();
        EvaluationResult evaluationResult = evaluatable.evaluate(evaluationCtx);
        if (evaluationResult.indeterminate()) {
            return evaluationResult;
        }
        long l = ((IntegerAttribute)evaluationResult.getAttributeValue()).getValue();
        if (l < 0L) {
            return NOfFunction.makeProcessingError("First argument to " + this.getFunctionName() + " cannot be negative.");
        }
        if (l == 0L) {
            return EvaluationResult.getTrueInstance();
        }
        long l2 = list.size() - 1;
        if (l > l2) {
            return NOfFunction.makeProcessingError("not enough arguments to n-of to find " + l + " true values");
        }
        while (l2 >= l) {
            evaluatable = (Evaluatable)iterator.next();
            evaluationResult = evaluatable.evaluate(evaluationCtx);
            if (evaluationResult.indeterminate()) {
                return evaluationResult;
            }
            if (((BooleanAttribute)evaluationResult.getAttributeValue()).getValue() && --l == 0L) {
                return EvaluationResult.getTrueInstance();
            }
            --l2;
        }
        return EvaluationResult.getFalseInstance();
    }

    public void checkInputs(List list) throws IllegalArgumentException {
        Object[] objectArray = list.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!((Evaluatable)objectArray[i]).evaluatesToBag()) continue;
            throw new IllegalArgumentException("n-of can't use bags");
        }
        this.checkInputsNoBag(list);
    }

    public void checkInputsNoBag(List list) throws IllegalArgumentException {
        Object[] objectArray = list.toArray();
        if (objectArray.length == 0) {
            throw new IllegalArgumentException("n-of requires an argument");
        }
        Evaluatable evaluatable = (Evaluatable)objectArray[0];
        if (!evaluatable.getType().toString().equals("http://www.w3.org/2001/XMLSchema#integer")) {
            throw new IllegalArgumentException("first argument to n-of must be an integer");
        }
        for (int i = 1; i < objectArray.length; ++i) {
            if (((Evaluatable)objectArray[i]).getType().toString().equals("http://www.w3.org/2001/XMLSchema#boolean")) continue;
            throw new IllegalArgumentException("invalid parameter in n-of: expected boolean");
        }
    }
}

